# Demoscene

Demoscene is a [hacker](hacking.md) [art](art.md) subculture revolving around making so called [demos](demo.md), programs that produce rich and highly [curious](interesting.md) and intriguing audiovisual effects which are sometimes limited by strict size constraints (so called [intros](intro.md)). The scene originated in northern [Europe](europe.md) sometime in 1980s (although things like screen hacks existed long before) among groups of [crackers](cracker.md) who were adding small signature effect screens into their cracked software (popularly likened to "digital graffiti"); [programming](programming.md) of these cool effects later became an art of its own and started to have their own competitions (sometimes with high financial prizes), so called *[compos](compo.md)*, at dedicated real life events called *[demoparties](demoparty.md)* (which themselves evolved from *[copyparties](copyparty.md)*, real life events focused on [piracy](piracy.md)). The community is still centered mostly in the [Europe](europe.md) (primarily Finland, in some countries demoscene was even officially added to the cultural heritage), it is underground, out of the mainstream; [Wikipedia](wikipedia.md) says that by 2010 its size was estimated to 10000 people (such people are called *demosceners*).

Demoscene is a bit of a bittersweet topic: on one side it's awesome, full of beautiful hacking, great ideas and minimalism, on the other side there are secretive people who don't share their source code (most demos are [proprietary](proprietary.md)) and ugly unportable programs that exploit quirks of specific platforms. Common platforms are [DOS](dos.md), [Commodore 64](c64.md), [Amiga](amiga.md) or [Windows](windows.md). These guys simply try to make the coolest visuals and smallest programs, with all good and bad that comes with it. Please strive to take only the good of it.

Besides "digital graffiti" the scene is also perhaps a bit remotely similar to the culture of street rap in its underground and competitive nature, but of course it differs by lack of improvisation and in centering on groups rather than individuals. Nevertheless the focus is on competition, originality, style etc. But demos should show off technological skills as the highest priority -- trying to "win by content" rather than programming skills is sometimes frowned upon. Individuals within a demogroup have roles such as a [programmer](programmer.md), visual artist, music artist, director, even [PR](pr.md) etc. The whole mindset and relationship to technology within demoscene is much different from the mainstream; for example it's been stated that while mainstream sees computers just as a tool that should just make happen what we imagine, a demoscener puts technology first, he doesn't see computing platforms in terms of better or worse e.g. for its raw computational power, he rather sees a rich world of unique computing platforms, each one with specific personality and feel, kind of like a visual artist sees different painting styles.

A demo isn't a [video](video.md), it is a non-[interactive](interactive.md) [real time](real_time.md) executable that produces the same output on every run (even though categories outside of this may also appear). [Viznut](viznut.md) has noted that this "static nature" of demos may be due to the established culture in which demos are made for a single show to the audience. Demos themselves aren't really limited by resource constraints (well, sometimes a limit such as 4 MB is imposed), it's where the programmers can show off all they have. However compos are often organized for **intros**, demos whose executable size is limited (i.e. NOT the size of the source code, like in [code golfing](golf.md), but the size of the compiled binary). The main categories are 4 KB intros and 64 KB intros, rarely also 256 KB intros. Apparently even such categories as 256 [byte](byte.md) intro appear. Sometimes also platform may be specified (e.g. [Commodore 64](c64.md), [PC](pc.md) etc.). The winner of a compo is decided by voting.

Some of the biggest demoparties are or were Assembly (Finland), The Party (Denmark), The Gathering (Norway), Kindergarden (Norway) and Revision (Germany). A guy on https://mlab.taik.fi/~eye/demos/ says that he has never seen a demo [female](female.md) programmer and that females often have free entry to demoparties while men have to pay because there are almost no women anyway xD Some famous demogroups include Farbrausch (Germany, also created a tiny 3D shooter game [.kkrieger](kkrieger.md)), Future Crew (Finland), Pulse (international), Haujobb (international), Conspiracy (Hungary) and [Razor 1911](razor_1911.md) (Norway). { Personally I liked best the name of a group that called themselves *Byterapers*. ~drummyfish } There is an online community of demosceners at at https://www.pouet.net.

**On technological side of demos**: great amount of [hacking](hacking.md), exploitation of bugs and errors and usage of techniques going against "good programming practices" are made use of in making of demos. Demosceners make use and invent many kinds of effects, such as the *plasma* (cycling color palette on a 2D noise pattern), *copper bars*, *[moire](moire.md)* patterns, waving, lens distortion etc. Demos are usually written in [C](c.md), [C++](cpp.md) or [assembly](assembly.md) (though some retards even make demos in [Java](java.md) [lmao](lmao.md)). In intros it is extremely important to save space wherever possible, so things such as [procedural generation](procgen.md) and [compression](compression.md) are heavily used. Manual [assembly](assembly.md) optimization for size can take place. [Tracker music](tracker_music.md), [chiptune](chiptune.md), [fractals](fractal.md) and [ASCII art](ascii_art.md) are very popular. New techniques are still being discovered, e.g. [bytebeat](bytebeat.md). [GLSL](glsl.md) shader source code that's to be embedded in the executable has to be minified or compressed. Compiler flags are chosen so as to minimize size, e.g. small size optimization (`-Os`), turning off buffer security checks or turning on fast [float](float.md) operations. The final executable is also additionally compressed with [specialized executable compression](executable_compression.md).

## See Also

- [hacker culture](hacking.md)
- [code golf](golf.md)
- [databending](databending.md)
- [kkrieger](kkrieger.md)
- [procedural generation](procgen.md)
- [bytebeat](bytebeat.md)
- [LAN party](lan_party.md)
- [MUD](mud.md)