# Comment

Comment is a part of computer code that doesn't affect how the code is interpreted by the [computer](computer.md) and is intended to hold information for humans that read the code (even though comments can sometimes contain additional information for computers such as metadata and autodocumentation information). There are comments in basically all [programming languages](programming_language.md), they usually start with `//`, `#`, `/*` and similar symbols, sometimes parts of code that don't fit the language syntax are ignored and as such can be used for comments (e.g. in [Brainfuck](brainfuck.md) anything that's not a command character is ignored).

While yes, you should write nice, [self documenting](self_documentation.md) code, **you should comment you source code** as well. General tips on commenting:

- ALWAYS put a **global file comment** at the top of a file to make it [self-contained](self_contained.md). It should include:
  - **Description of what the file actually does.** This is extremely important for [readability](readability.md), documentation and quick orientation. If a new programmer comes looking for a specific part of the code, he may waste hours on searching the wrong files just because the idiotic author couldn't be bothered to include fucking three sentences at the start of the file. [Modern](modern.md) program just don't fucking do this anymore, this is just [shit](shit.md).
  - [License](license.md)/[waiver](waiver.md), either full text or link. Even if your repo contains a global license (which it should), it's good for the file to carry the license because the file may just be copy pasted on its own into some other project and then it will appear as having no license.
  - **Name/nick of the author(s)** and roughly the date of creation (year is enough). This firstly helps legally assess [copyright](copyright.md) (who and for how long holds the copyright) and secondly helps others contact the author in case of encountering something weird in the code.
- Comment specific blocks of code with **keywords** -- this will help searching the code with tools like [grep](grep.md). E.g. in game's code add comment `// player: shoot, fire` to the part of code that handles player's shooting so that someone searching for any one of these two words will be directed here.
- Be brief, don't write poetry, too much text and pompous style will make it less readable.
- Functions (maybe with some exceptions like trivial one-liners) should come with a comment documenting:
  - **Behavior** of the function, what it does and also how it does that (Is the function slow? Is it safe? Does it perform checks of arguments? Does it have [side effects](side_effect.md)? How are errors handled? ...).
  - **Meaning of all arguments** and if needed their possible values.
  - **Return value meaning**.
- You may decide to use comment format of some [autodoc](autodoc.md) system such as [doxygen](doxygen.md) -- it costs nothing and helps firstly unify the style of your comments and secondly, obviously, generate automatic documentation of your code, as well as possibly automatically process it in other ways.
- TODO: moar

Way too many comments are sometimes considered bad, there shouldn't be more comments than code, unless maybe in some super complex [assembly](assembly.md) program :) There also seem to be controversial opinions around about comments being essentially [harmful](harmful.md) at least to a degree, for example [Jonathan Blow](jonathan_blow.md) said that "comments are code that never runs and code that never runs has bugs" { I think that's a bit misleading -- comments are never run by a computer but they are run by the brain, a kind of neural network that is tolerant to many bugs, so a comment that's been read by a few people who didn't find anything wrong about it is kind of tested. Besides that by definition the purpose of a comment is not to define algorithms, comments aren't code or at least shouldn't take such role, they're there for other purposes, e.g. declaring intent, putting a reference to something and so on. ~drummyfish }.