# Brain Software

Brain [software](software.md), also brainware, is kind of a [fun](fun.md) idea of software that runs on the human brain as opposed to a typical electronic [computer](computer.md). This removes the [dependency](dependency.md) on computers and highly increases freedom. Of course, this also comes with a huge drop of computational power :) However, aside from being an entertaining idea to explore, this kind of software and "architectures" may become interesting from the perspective of [freedom](free_software.md) and [primitivism](primitivism.md) (especially when the technological [collapse](collapse.md) seems like a real danger).

Primitive tools helping the brain compute, such as pen and paper  or printed out mathematical [tables](lut.md), may be allowed.

**Brain game** is brain software which is a [game](game.md), i.e. servers to entertain the user. This kind of brain software may be also very important, for example it can make being in prison more bearable and therefore makes an individual less afraid of prison.

Example of brain software (and brain game) can be the [game](game.html) of [chess](chess.md). A chess master can easily play the game without a physical chess board, only in his head, and he can play games with someone else just by saying the moves out loud. He may even just play games with himself, which makes chess a deep, entertaining game that can be 100% contained in one's brain. Such game can never be taken away from the man, it can't be altered by [corporations](corporation.md), it can't become unplayable on new [hardware](hardware.md) etc., making it free to the greatest extent. Many other board games and pen and pencil games, such as [racetrack](racetrack.md) (pen and pencil racing game suitable for one or many players).

[Math](math.md) is a kind of universal brain game -- when bored, one can simply think about some mathematical problem and try solving it as a challenge, potentially discovering new problems and making new discoveries along the way. It's like an infinite open world exploration game just in your head. Trying to make brain games may itself be an entertaining game.

One may think of a [pen and paper](pen_and_paper.md) computer with its own simple instruction set that allows general purpose programming. This instruction set may be designed to be well interpretable by human and it may be accompanied by tables printed out on paper for quick lookup of operation results -- e.g. a 4 bit computer might provide a 16x16 table with precomputed multiplication results which would help the individual execute the multiplication instruction within mere seconds.

Yet another idea is to make a computer with architecture similar to the typical electronic computers but powered by human brains -- let's call this a [human computer](human_computer.md) (not to be confused with people whose job was to perform computations!). Imagine that after a societal collapse we lose our computer technology (i.e. the ability to manufacture transistors and similar key components), but we retain our knowledge of computer architecture, algorithms and the usefulness of computers. As a temporary solution for performing computations we may create a "computer made of humans", a room with several men, each one performing a role of some computer component, for example an [ALU](alu.md), [cache](cache.md) and memory controller. Again, a special instruction set and a set of tools (such as physical lookup tables for results of instructions) could be made to make such a human computer relatively fast. It might not run [Doom](doom.md), but it could possibly e.g. compute some mathematical constants to a high precision or perhaps help find optimal structure of cities, compute stresses in big building etc. In such conditions even a slow calculator could be immensely useful.