# Approximation

Approximating means calculating or representing something with lesser than best possible precision -- estimating -- purposefully allowing some margin of error in results and using simpler mathematical models than the most accurate ones: this is typically done in order to save resources (CPU cycles, memory etc.) and reduce [complexity](complexity.md) so that our projects and analysis stay manageable. Simulating real world on a computer is always an approximation as we cannot capture the infinitely complex and fine nature of the real world with a machine of limited resources, but even within this we need to consider how much, in what ways and where to simplify.

Using approximations however doesn't have to imply decrease in precision of the final result -- approximations very well serve [optimization](optimization.md). E.g. approximate metrics help in [heuristic](heuristic.md) algorithms such as [A*](a_star.md). Another use of approximations in optimization is as a quick preliminary check for the expensive precise algorithms: e.g. using bounding spheres helps speed up collision detection (if bounding spheres of two objects don't collide, we know they can't possibly collide and don't have to expensively check this).

Examples of approximations:

- **[Distances](distance.md)**: instead of expensive **Euclidean** distance (`sqrt(dx^2 + dy^2)`) we may use **Chebyshev** distance (`dx + dy`) or **Taxicab** distance (`max(dx,dy)`).
- **Engineering approximations** ("guesstimations"): e.g. **sin(x) = x** for "small" values of *x* or **[pi](pi.md) = 3** (integer instead of float).
- **[Physics engines](physics_engine.md)**: complex triangle meshes are approximated with simple analytical shapes such as **spheres**, **cuboids** and **capsules** or at least **convex hulls** which are much easier and faster to deal with. They also approximate **relativistic** physics with **Newtonian**.
- **Addition/subtraction** (of integers) can sometimes be approximated with logical [OR](or.md)/[AND](and.md) operations, as they behave a bit similarly. This can be used e.g. for brightening/darkening of pixel colors in [332](rgb332.md) or [565](rgb565.md) format -- without the approximation addition of colors in these formats is very expensive (basically requires conversion to RGB, addition, clamping and a conversion back).
- **[Square root](sqrt.md)/square** (integer) can be roughly approximated too. E.g. to get a quick "almost square" of a number you can try something like doubling each binary digit and shifting everything right, e.g. `101` -> `11001` -- it's not very accurate but may be [good enough](good_enough.md) e.g. for some graphics effects and may be especially effective as hardware implementation as it works instantly and uses literally no [logic gates](logic_gate.md) (you just reorder bits)! A bit improved version may construct a pair of digits from each digit as logical AND (upper bit) and logical OR (lower bit) of the bit with its lower neighbor (lowest bit may still just be doubled), e.g. `1101` -> `11010111`. Square root can similarly be roughly estimated by reducing each pair of bits with logical OR sown to a single bit (e.g. `101100` -> `110`). { Dunno if this is actually used anywhere, I came up with this once before I fell asleep. ~drummyfish } A famous hack in Quake, called *fast inverse square root*, uses a similar approximation in [floating point](float.md). 
- **[3D graphics](3d_rendering.md)** is almost completely about approximations, e.g. basically all shapes are approximated with triangle meshes, [screen space](screen_space.md) effects (like [SSAO](ssao.md)) are used to approximate global illumination, reflections etc. Similarly [ray tracing](ray_tracing.md) neglects indirect lighting etcetc.
- **[Real numbers](real_number.md)** are practically always approximated with [floating point](floating_point.md) or [fixed point](fixed_point.md) (rational numbers).
- **[Numerical methods](numerical.md)** offer generality and typically yield approximate solutions while their precision vs speed can be adjusted via parameters such as number of iterations.
- **[Taylor series](taylor_series.md)** approximates given mathematical function and can be used to e.g. estimate solutions of [differential equations](differential_equation.md).
- Primitive [music](music.md) synthesis often uses simple functions like triangle/saw/square wave to approximate [sin](sin.md) waves (though many times it's done for the actual sound of these waves, sometimes it may be simply to save on resources).
- ...