(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    210299,       3713]
NotebookOptionsPosition[    209379,       3688]
NotebookOutlinePosition[    210209,       3712]
CellTagsIndexPosition[    210166,       3709]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"\:1513\:1515", "=", 
   RowBox[{"{", " ", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"WorkingPrecision", "\[Rule]", " ", "16"}], ","}], "*)"}], " ", 
    RowBox[{
     RowBox[{"MaxRecursion", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"2", "^", "4"}], "-", "1"}]}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", " ", 
      RowBox[{"1", "+", 
       RowBox[{"2", "^", "8"}]}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", " ", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{"PlotRangePadding", "\[Rule]", " ", 
      RowBox[{"1", "/", "256"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4", ",", ".5"}], "]"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4", ",", ".5"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", " ", "256"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", " ", "Thin"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:1d25", "=", 
   RowBox[{"{", 
    RowBox[{"X", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\:a5f3", "[", "X_", "]"}], ":=", "                ", 
    RowBox[{"(", 
     RowBox[{"(", 
      RowBox[{"(", 
       RowBox[{"(", "                ", 
        RowBox[{"X", "^", "3.35"}], "                ", ")"}], ")"}], ")"}], 
     ")"}]}], "                ", ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"\:a5f3", "[", "X_", "]"}], ":=", "                ", 
     RowBox[{"(", 
      RowBox[{"(", 
       RowBox[{"(", 
        RowBox[{"(", "                ", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"E", "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1", "/", "X"}], "+", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"X", "-", "1"}], ")"}]}]}], ")"}]}], "+", "1"}], 
           ")"}]}], "                ", ")"}], ")"}], ")"}], ")"}]}], 
    "                ", ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"\:a5f3", "[", "X_", "]"}], ":=", "                ", 
     RowBox[{"(", 
      RowBox[{"(", 
       RowBox[{"(", 
        RowBox[{"(", "                ", 
         RowBox[{".5", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"Tanh", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{".5", "-", "X"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "X"}], ")"}], "*", "X"}], ")"}]}], 
             "]"}]}], ")"}]}], "                ", ")"}], ")"}], ")"}], 
      ")"}]}], "                ", ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"\:a5f3", "[", "X_", "]"}], ":=", "                ", 
     RowBox[{"(", 
      RowBox[{"(", 
       RowBox[{"(", 
        RowBox[{"(", "                ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "32"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "15"}], "/", "16"}], "+", "X"}]}], "]"}], 
                "^", "3"}], "-", 
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "13"}], "/", "16"}], "+", "X"}]}], "]"}], 
                "^", "3"}], "-", 
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "11"}], "/", "16"}], "+", "X"}]}], "]"}], 
                "^", "3"}], "+", 
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "9"}], "/", "16"}], "+", "X"}]}], "]"}], "^",
                 "3"}], "-", 
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "7"}], "/", "16"}], "+", "X"}]}], "]"}], "^",
                 "3"}], "+", 
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "5"}], "/", "16"}], "+", "X"}]}], "]"}], "^",
                 "3"}], "+", 
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "3"}], "/", "16"}], "+", "X"}]}], "]"}], "^",
                 "3"}], "-", 
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"0", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "/", "16"}], "+", "X"}]}], "]"}], "^",
                 "3"}]}], ")"}]}], ")"}], "/", "3"}], ")"}], 
         "                ", ")"}], ")"}], ")"}], ")"}]}], "                ",
     ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:1450\:1455\:15ef\:a5f3\:15ef\:1450\:1455", "[", "X_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"Floor", "[", "X", "]"}]}], " ", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\:a5f3", "[", 
        RowBox[{"Mod", "[", 
         RowBox[{"X", ",", "1"}], "]"}], "]"}], "-", "0.5"}], ")"}]}], "+", 
    "0.5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:1450\:1455\:c637\:a5f3\:c637\:1450\:1455", "[", "X_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"\:a5f3", "[", 
      RowBox[{"Mod", "[", 
       RowBox[{"X", ",", "1"}], "]"}], "]"}], " ", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"Floor", "[", 
        RowBox[{"X", "+", "1"}], "]"}], ",", "2"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"\:a5f3", "[", 
      RowBox[{"1", "-", 
       RowBox[{"Mod", "[", 
        RowBox[{"X", ",", "1"}], "]"}]}], "]"}], " ", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"Floor", "[", 
        RowBox[{
         RowBox[{"-", "X"}], "+", "1"}], "]"}], ",", "2"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Column", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Column", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"\:a5f3", "[", "X", "]"}], ",", 
           RowBox[{"Evaluate", "[", "\:1d25", "]"}], ",", 
           RowBox[{"Evaluate", "[", "\:1513\:1515", "]"}]}], "]"}], ",", 
         RowBox[{"ToLowerCase", "[", 
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"\:a5f3", "[", "X", "]"}], ",", "InputForm"}], "]"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<)\>\""}], ",", 
              RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<(\>\""}]}], "}"}]}], "]"}],
           "]"}], ",", 
         RowBox[{"ToLowerCase", "[", 
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Simplify", "[", 
               RowBox[{"ExpandAll", "[", 
                RowBox[{"\:a5f3", "[", "X", "]"}], "]"}], "]"}], ",", 
              "InputForm"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<)\>\""}], ",", 
              RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<(\>\""}]}], "}"}]}], "]"}],
           "]"}]}], "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Column", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
           "\:1450\:1455\:15ef\:a5f3\:15ef\:1450\:1455", "[", "X", "]"}], ",", 
           RowBox[{"Evaluate", "[", "\:1d25", "]"}], ",", 
           RowBox[{"Evaluate", "[", "\:1513\:1515", "]"}]}], "]"}], ",", 
         RowBox[{"ToLowerCase", "[", 
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{
              "\:1450\:1455\:15ef\:a5f3\:15ef\:1450\:1455", "[", "X", "]"}], 
              ",", "InputForm"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<)\>\""}], ",", 
              RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<(\>\""}]}], "}"}]}], "]"}],
           "]"}], ",", 
         RowBox[{"ToLowerCase", "[", 
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Simplify", "[", 
               RowBox[{"ExpandAll", "[", 
                RowBox[{
                "\:1450\:1455\:15ef\:a5f3\:15ef\:1450\:1455", "[", "X", "]"}],
                 "]"}], "]"}], ",", "InputForm"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<)\>\""}], ",", 
              RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<(\>\""}]}], "}"}]}], "]"}],
           "]"}]}], "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Column", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
           "\:1450\:1455\:c637\:a5f3\:c637\:1450\:1455", "[", "X", "]"}], ",", 
           RowBox[{"Evaluate", "[", "\:1d25", "]"}], ",", 
           RowBox[{"Evaluate", "[", "\:1513\:1515", "]"}]}], "]"}], ",", 
         RowBox[{"ToLowerCase", "[", 
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{
              "\:1450\:1455\:c637\:a5f3\:c637\:1450\:1455", "[", "X", "]"}], 
              ",", "InputForm"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<)\>\""}], ",", 
              RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<(\>\""}]}], "}"}]}], "]"}],
           "]"}], ",", 
         RowBox[{"ToLowerCase", "[", 
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Simplify", "[", 
               RowBox[{"ExpandAll", "[", 
                RowBox[{
                "\:1450\:1455\:c637\:a5f3\:c637\:1450\:1455", "[", "X", "]"}],
                 "]"}], "]"}], ",", "InputForm"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<)\>\""}], ",", 
              RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<(\>\""}]}], "}"}]}], "]"}],
           "]"}]}], "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ","}], 
    "\[IndentingNewLine]", "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}]}], "Input",
 FontFamily->"Go Noto Africa Middle East",
 FontSize->10,
 FontWeight->"Normal",
 CellLabel->
  "9/3/24 13:16:01 \
In[1]:=",ExpressionUUID->"32fbf20e-ca9a-443c-b482-3ff5cfb2baf3"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         GraphicsBox[{{{}, {}, 
            TagBox[
             {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Tiny], 
              Opacity[1.], LineBox[CompressedData["
1:eJwU1nc0V/8fwHHJV2QLocgmVHalz32/7J2dJCs7MyMhZEfJzsoqm2SE7JU9
KrJJIRKFkJn63d9f9zzOPff1ft9z7j3vJ6eFi641MREREZAQEf3/ikm+WhQs
1Uc3mjx3inJipTUn0z/ryYSjp10v6XrOwBUKc8+MwYhc9JM3v8bmMOuKH0vv
3VxUh9455ZbPHn69IrXtfosmpR+RhOwfOzPKSfjv24o/UdYicj8n1frJxYeQ
NqKvmpb0DXUlNU402PsTJNobT1yKXkJcN0Su6NkEEiyeRxe4+C+jLja/y3rO
YYSWm+JDM8araNrIwKa9MpaA7BrjZig3kaw2pUbI+gvCo8+/7r0M30TzFBdl
1FJyCKMGfCY+JFvolkWzWdDNPIKTYjQ/058tlHJfIanqQhEhjetWw9WVbcRd
sNXVllROWEp5+vyU7Q6iZqdIYJqpIEjQ9YZ9n9tBS7bBGvkSlYS+f2I6oZO7
aEld5pMOwxvC/jTJYkPPPqrxc6qvLWokCNSN+mzV/EHPLNos/RraCNeTCmiE
C/6i8IpPZ35qdhHkpbGhcnUiyFe53uSY1k+YFMhLuyp/BK6MDz18bDRIcDtJ
Y/tdmhjGG6xaXw0PE8hJvURDxY7C4l06H+KOcULW1pcDDkESGEU3LOgkPhEu
zat2NnD+B9PWfx8rMc4SPgxWxBiykIK43SnPvPF5gm3LqZtbtMcgiWjTPG9p
kfD3VQhvDBkZBOU4Eo2qLhMS03+uCRGRQ1TY2tVRolXCHAPXyN59cpBOpMg6
OFwjnI80qOvaIYcbz75GCJP/InT4NIdYrh0Hyd7jMjGym4St67Esz2YooaG5
t29ZbZcg877jr50RFURy9fgNv9ojRCrtz0uNUsHAP3+KPo4DArek5auhAWq4
Te/NyiHyl+D8Mik+S5UGmus+OXO8+0eo4+73cu6ggQlj++c1jUTY2YhUzlBT
WnBoYLufF0SMvWuXYHBMo4Ui4dcpyPUo5kH0nlRvkhZqSt/o89iRYC33jv7g
MKCDG93vDQNcSDFDG8fqhqv0oFaTceP09+PY3+ekhdmP6WHrX/yzVnZKLOdT
1rNHPfTQs/9WndyUClvXHwkwVDwBT+0mJc/v02AP5ZH6FoEBJMTrb78bpceE
H4xjUz4McOXpSYvY1BPYUJ2bSFsNA+QqUOuNWjJg7GL5jDESjMC2Sa8uc4wJ
q+ag/SIkzASjyhtLtAksmLFx0RC9PROw3aXQNwtjxYiTFTr28pmAd4HRcdH/
FKZJ413UxX0StCKnSg6C2LCFw1kPy1PM4PWf8tXvPziwR5d9bdVuMAMz0fCu
dAAnJnKXyUg0iRkelG9zHTvJhfn+UIN/9CxAdqH/I9LixhimXpM/O84KKLGZ
2W+FF6tj0vwTqMIKz45f/Lz5jA8z111atQtjhfv1OVuK2vxYcc/pYSniU2Bx
T+RiSbsAJlcTmjG0dwpUP9B7zn0SwlyfXhc//p0N8rDJO07OohjT4C/eX3zs
4Ho7n8hlSRRroIxkHrdih0TVx+1tVmIYWUjLYe4XdvB7O1LuYyWOZbmd7ZYd
PwNNWubZswGSGPfYLRMGCg4gvFKTEKSWwra3Xo0eE+SAX8UUxHvpUliaiGrP
qi0HPP5ZWSLfcRH7lu/3qmGeA1RNdUqVxKWxuo5e/jJiTiiUtnH1GZHGIudP
Ps/m5ITgNuWnt32uYGJnKuIfmXFCvtDmYkI/AfNPXPQynOIE5aCsmek4wJhC
teS3hrjgFm/ns4RROYyIYfuf0xwXHAyVpBYcl8e+v0hr+PaLC07s7SpwgjzW
0PJdcoqWGywkn96QK5THLP4EC7RpcsPM46k6rSAF7JV7DVVMLzec0Dkauqes
hClacI4LtfGArZvzRBaPGnb+V1dC7iAPdLUqR/LYqGHMAc46Z2Z5YOzJd4ZT
BWrYcnp9Lz0RL1xjGPawOKeOxUxca9zDeCFlYIXeFtPAprUfveiq5YVirFep
xF0T84BNR8tyPsit6nl7IUMHM32XcvZTCx+4JGj1RHfqYMomMosGH/jAOWz1
kciaDsZ6/4mZ2hoflAZZikjK6mIt1fy6ouf44VtSRbjOki5Ged744r8CfvBU
vtB6XF4fyz7dceRZlgB0kiY08AhfxyKLHZoYygSgJe3PI1qT65inNP39qGYB
mA+6lqkQdR1TMTTbCpwRgAtXcqPCfl3HVuP3Fu1OnwVBDQWCV70hJk1xvl8q
+Sy8nXbIVjExwob2EhOHogUhkL1xWHPSBGsIx/Q0MgWhYzF7tY7BFMs9+ZWm
85UgqJiRUt/TMsW8JEUjagcEYYL2qeGXDlOM3bXvfhaFEFzLPfLPr9oMs1/6
Z+78UAiOft+zjvpojh0ZsxM6/kAYklOd7YbmLbBla5ql4ChhuH1Bh1uJ1BIb
3qrKOUwXBqKfypMLApZYHv1R9l8NwnDL/0pjobMlpqGZTju+LwwuLCdmlP5Y
Yskdg79zPc/B7/f8oxtnrDGRSukWWefzwCMYIfI7whZjlZ/1rfc7D0FpT2X5
K2yxo0MPL0s+OQ8qDN7mEZO22OjacIXAy/PAlvhIfUbIDvMVcsmlWT4PZ3lC
3d59sMO6X2Q/+mR9AR5t6m595bbHylTCihrOi8DBw37vj2uOmPLFNQ9DPlG4
/PS2+bF4V6zBX06P8bwojIjM5OWWuGIinU9FhyRF4ctgnoB5tyvGeo2wqq4o
Crski1yCf12xH24RtmAlCoPBMR9POLhhca+4jfhe4PfPUkpfVXPHZngNYYtN
DAauRqsPst/F9JyK2cp5xeBHsNZdZuwu1l3598DpnBhYvDv+n//Nu1i5fG7N
N4IYDLt4peUk38VCbm2ITt0UgzHf5ae3GDwxwfRInrYUMXDqCKYroruHeTK0
kscwikMhY2/uOrc3tnKTYUmDTRwcrLOK+JS8MfNs205yXnFgCH+s5mfnjamK
UQcHS4jDKffVF5El3thp7Zt/PPXE4a1YUqHkZR+s7fHvVZNY/HlbicoWg/sY
9VHBYSEqCaCveeFyqdgPy/0Vl9FFIgm8f8hohkwDMdbLi74hlJJQFJvnqOwR
iEUFXL4pyyAJQVcWb76PCMS8aL6crOeWBJFGIYaTVYGY2rlzsa/kJEH0muhq
GGUQtm7XFfw0QBL2FhjM1puCMMKXAzvLP5LwXVnprJBYCDb8zkr836YULNaf
GlXXf4ipMtXQNRxIAVnsyvor54dYkwnFutfRi3BJ1XWLL+Ihlv+j/OUG/UWw
IM2dutb0EPM5/o93UfQiOHSxSpadDcc4lFKYB1wuwoSPtoMZSQTm0DhwmLpy
EbZn8saWex5hxC+luqXmL8HQk1NfPiRFYfc2I/I2ly+B3c/jb2rfRGE/pD+F
lG1cAra08s+1Y1HYSE+wrCDxZbB8JHeViDkaK/j2oY6N8zJwPPYrzkuJxjS5
HUpIzC5D5L8TJOXaMVhqambc0ORlSA+moHS8FYuJRpCZOA9Jg1qc3ejv/HjM
3GbyV24rAThWL2aeGkrGRkrOfbDoIcB5BzHroKVkTO13wKszgwSgouUz2Pmb
jImH8DukfCHA9vCjAQrhFIz0hcfXyH8EEHazfPE5LAV7+Yl6zB3DQPh4qc1F
SMV29eUbZGsxuNU7FNpX9wyLln8Z9qkMAZMKgaZwJgMjefzPKrUGgUfurNnb
3QzMa0hX/noLgme1NwR+0mdiFrf2/n14j4BXdEDSRTkTk3ig5N2+ioDn3tnR
c+WZ2GTdF4diYQC5C01f++WzMD4xRh3vAgBlRpcGAY7nmBlt85Pj2jKgOGpX
LfHrBcZaufRnSU8GcmGrUpEoGxu+Tu/YdV0GWF8/ZjGjycZUMq3VQsxkQMk9
40zxuWxM7Dzlsb/OMvB6Jd2+wD4bI9G4EfDriQxQLJ24Lr2YjRU93HQb75MB
26RNp3fzOdj2X37DPGVZ0OPpdNTay8OifsZwyYEc6N/QHfOPK8ZUYutiOeTl
IGo+Qoslrxg7KvmV6J+SHGT+yY5srC3GvHwvfq7XlAMdvxJz7tli7BbFzDNJ
UzmIbDJvshJ5iUmcFWI86ycHw7+vvm358BKbtOo4RlsvB6kqMom/mF9hfNN7
Pz5JyUMeIyf9smUZ1thr8cb7vAIcO7DtV9N9jXk5R/IZiikA/s681aavMTH6
6qdSUgpQSJPMxO/wGsu7Qe6xiSnASHF0N0vIayxmqVTE6aoCnGgRipOrfo1Z
kB4WmjsqAMnvHqLsU5UYmVxSmnKRAgwoKHgWLldi+rV9gYx8ijBHu27LnlqN
/ciX0ChnU4Ij9ipR0rJ1WJ66aX00pxJsKBSkZGnXYbfWHgo68yrBhXv9e5Tm
ddio1BSZ0DkleCNs3LTrX4c1dwR25BCUgJ7MM+h0Yx0WN/8OJd9UAnn/HsVE
6Xrs0pnbog9SlKBqzvqiiXQDFpKYznSVURnSqPhJn1xtwk6Fks4uUapAgMP5
wCcWrdiogIh2F60KPJGiKvnp0IrF9N9ozmVQAcZTplY6d1sxEoaSdIvTKnCV
xd6LO7wVW32hZzQtpAJSr2vUN0pasZaWrI/v1VQAfrSpX9lvxWz+SHdWh6vA
Dqklc8DTNqzC3aU4hEQVSidiEdHYW0zNYvwuxx9VyAu9/P7iw06MhJR44e8/
VQjufm/kGdeJNRcK6X86qgYdlSUjNemdmMQvf7FUCjVAlPZpqpWdGFsA79qJ
U2qQkkwekjrbia2nu9kdk1YDsepzTvuELixxgvLm6j01uGjtJ16z3YXNasvK
NGyqwQfNU0yGnj2YFxQdN1xRBw6y6sDo/H5MbP6jt9SaOrBURhB9ruzHfoYd
LjFsqgOjNduIWFs/ZvFOu2twXx0af7YFfZvux9RNdoLVj2vAC7d60lD6AYz9
vsIhOqsBXsSCtrH+A1h79cwar60GvF5Wkf594x1Ge/7EyOacBoRe0LOhoPmA
5Z/2zYyevAp0qr/Mk1cHMYuWXGrnmatQ6foo3GJ7EDtt9d5PY+4qhPYG0lz4
O4jFFHMZky9fhcNVcew91RDmI93DHLx3FaJkFLmFzw1hGoZMcZ7MmrBVxXvP
0HEI24gvCzEx0MT/Z35+/x9DGKJYuC00pAlCr3mIGbc+YqN7VyW6erRA0Czd
UZhzFAtaibZ6MK0N42/68td2JzGzRp405xltmEuhn9I8OoURoms/mnzRhtEA
hckyqilsR2xejvBVGySaeZAf1xTm6CPFubeiDZ4vdvIvakxh18g/fXI70IaE
hn0r8awpTIBf8LoNqw6sv//zRFVtGntn0a561VAHfA6zt8nyP2Gsk7vnTw3r
wAGtxFqf7Bdsp/iJzfFRHfjhXOJcpfwFG/bjytgb0wHrryfvZF39gkVzalCN
T+nAW54Xez43vmAktzNXEuZ1YHWy7pyc6xfs545iAfWmDsxz3Vdnef4Fa2GM
5ySm1wWm+KTvK0dmMRudcwzftXThRq4s64XuWay8+9ZedZ8uLE09ooy1ncei
UrdF8gZ0QZhhKVbOeR5zdHxs9/S9LmSq1Vf99pjH+Girxtw/6gLLbuGEedA8
lnqdrFpkSheWX28lq6XPYyGLr9yKlnUh2amQ3/HjPGZA8mclnVwPTG+qsXyX
+Yr9gcSZEGU9GDhCtDHKsYCpvOl9q/tWD6gbTMmXthaxL7niUat1+qCj8W+D
/tcy1nivu+NTgz6UM1KtP9hbxlJVTQ77m/Sh0J2nc/XICnbtZ5hjcZs+KEqb
/h2kX8F6JSbV7Hr1gcc7KPeVxAr2+m3AsbkJfSi+VkPc6rWChc0OBIzs6gP7
mYRUdeIfmDCbnXuD1DVg57us/9+pn5hXQprho4pr0K3/9Le75RpGE/wfN1+R
AcRMnBfpPLuB/dBPNWJ8aQCtJWWiu+c3sF6+C3Ekrwxg4vI+JiSxgYX0Gh6Z
LzeAQxuzewloA9ule/k5s9YAajre3XHX28DmsnTTWHoMAJ0STLH028AqmzIZ
qZYM4LGtchLV0AZmtH+ZbIv3OpjeaTwW7b+J5bk6/2x9fh0u7KrP+H3dwpD5
2BuTFEM43xvk07ywg50Sc1zTeGYI9z1P1lD82MF2jx7hJ6QbwvfJ52dubOxg
r/MFE1mfG8IpDSannb87mMCan8dYgSFwB2ySyDHvYnT+PKI6NYYQ+fiCAo36
Lvb1mWuRwpghlBeazjwq38UejVGkCzHeADaZLVeqoD1sVFMmaC/mBjxaZui8
J3qAOWGFGk/DjcBXacbled9fLI31/mz/PWOYFXJIrvc7irx/0LA0eBuDU8Fy
v1DQUWTQlKNdfN8Yfm5MVaeFHUV0Fu+aIx4YQ0GQQXFA9FEUVsiZofTQGGRT
/Jh1nh9FLpe6jVoSjYFVh5eeoeMokjNgHH5dZQwSJ/12uKhI0FJsaWfqpjH0
GRaJ2GWSIAnyr8V2LiZAzOiVU9L/H+rb0fAksTUF/ifpDLTqZKigZ7Zk084U
ytYEGJE2GQp75rkwZ28KLDsHU47XyJAMZOm3OpvCNF1jQ78ZGaoM2xTz9zSF
iRvh/U89yFAGY+raTqgpED0UkriaQYbuiH+zW8kxBdp3+6k6G2SIySXw5tCc
KQxTvAqqTCNHFotVMlmmZrDb86qE6OA48rOP/o9dyBy0vo8pZs9QIcePN54z
CptDtcY2c9ZXKmRE4MGozpnDimz82/RlKnSJutbjz3lzyLwflflsmwptlM/N
T4qZQ6KHq8dzampksyfZliRtDumbPM9HEDXSDp/2p1MzB9kNkYAvmdSIK+/s
Lsltc8gQCOENsaJB3bNvl1fyzMFKMm+I1pcWMdzYfV/LdQtKvspWjvDQo5fK
t1KvsVrA311Lkpl3jCi1TEjq6ikLUFMcCOsYYkQRLNuDCqctwHqzOqxklBHZ
rDwil2C3AO7CC//8ZxgRZ3SlFz2XBTz49foj/yojShw9dv39WQugu7xFH0vF
hB5YvzqhetkCMtObzrZpMCHd4INIgqEFaEqbV2b1M6HdpqcPuBMt4ON/o7xm
QyeRglSv1S86Swg3HlC8tc2CpnjELzwht4LMOv/gwBx21PvksDfkuBVcpz2h
7VnIjvAzz8aXwgqC9BJfOrxiR4ndxhkOVFbwjDea0bCGHWk7hlGp0VlBYbJ2
wcV+dtT+emKFlMUKskBlgm6LHb2SCygIELCCCbLmIjGFMyjAfIDTQ9kKKjc3
WAQWzyC+NFuGm6FWcHfHT8c7mQO5nUjbEzhiDfPZedcVf3Gi48T/tbfvWsMS
yUHe7jQP2rV/b9awZw1krm/dKL/woG8fUw5e71tDaQdFDMc8D2rPPS+e/cca
njy80Kz6nQc9UDV8EUhkA2PH1dczf/OgrZjiAERmAw6XaF7cpOZFn87oYjUn
bSDUrNaaVoYXlWGZ1cVSNsA5TfC7k8OLDLwvF8Z52EBzNa/zCVc+9GLdKcp8
3QaYw3MyBFgF0OXPo4Z/vtkCX/RLleoSISSg8nxrc8kW7mZMj3mWCyGmcoeY
le+2cM77VtvFKiG0FUTUPbliC5EhfoV1DULoFZ/gxdo1W6DNetTS3ieEuJz9
GD13bMEg2oBp+bsQojzkHlojtQNGobxgbz5hNMPqqj7Pawf21ou+L7OEUYgB
Beq1tAO7xuJih5Rz6MMAcCd/tgM2awr5p2kXkF1DwU/xsdvQptOdtfBbFBnw
ukcIjd+GzjeW8ny7okgxCuPlnrgNt7lqmG33RRGX+ZAx/dRtGFJMvPn9ryj6
dPRP3/rMbeCIcJFbPyaGdNW1ikoWb8MZbDjxGKsYujL524Z/+zbc2bvhaIzE
EPWu3BdWRnvQmaIxynwohirFPw0d0bOHK8ylzVGnxdG/Irqa9+/s4TH5ft9F
bQmUmOIT5NDpAOcoM61HPkuhDk+Nk9lVTrA32FzpVEhAlZ+ZXqdWO0HtFBNt
1EsCeqEyqxn3xgn6mwsLXpUSUACrZ1hgrRNETz6JXa8iIOmmzN9mjU6gVJUq
d6+NgF79t/nxdIcT/Fzj5ImZIqDkhJSYxGEn+J3cvLNGhSH7ikXyR5tOsGrJ
6mXnjiHa1YA/d0SdQTLh8KmsLELG1lWzqMQZ8qeCeeuWAG3psb+czHEBruCi
mP3XsmiuYUl5KNcFJC1nX/VWyaJB3tfzPXku0DPgvJr6Rha92lE+VVvgAttt
cYNX6mXR7Weuj5JeusCJCl6BB22yaGau3U6/0gXqhotPUg7Koi5XB953b12g
xXeKHFZlUWp0TUbrnAs0Sn57SH5WDmVZF6ro096BeoKjvniWHFJ6Ln/liuYd
kEfaET8T5FEssxcHee8dGOC03k5KVkRkV01WQ3DT6IWFlqQqooBAuQaivjvg
1NRx6W2aInJepjTcxR0ym0OxlqWINBqeR38bwOe/pLBUKVREpOZ9fzsG70D7
36qJI3WKyCef/VPQxB0wjdRbj55SRFZSHSl/lu5AEokzHcsZJSSlT39i/Zgr
+L2pT5nNV0LT0S//G1N0BSEpy2CzFmUkcGx2OafVFUaJm+6XUKmhlt+qVTK1
btBqeSopnl0LXRS8ENyA++uC4V8FTi30ypRB51KdG1AcOkdvc2uh9K6ZHxfq
3cCjRfCC0Vkt5JPiznOm0Q0iPcmtuSW0kCSWHn/Y4ga/goqKG1W1UFHIumtd
txtcW6h4RXdXC8WfSDovMe4GV/jzPl3s10I2ol/z+XfcgIaY/A0gbUTp5J9K
LekO6rSrPx9uaCPDrxUPpsvcQUMwxtDJQRetDZ1S8yrwAOce1Uye59eQzbEj
zFu4ic5oLI++uIZmriwuuBR6wP3fYlcjcq6h/pyyQNsiD1AQLDdazb+GijwV
aw1eekDfWEhC7atryIrVRUCyzAOmHMRC9BuuofFbbaQbbzygiXHdMG3sGmpb
t3vr0OUB60+UiT2oDVACdTXBbNEDfL+o5Sv4GSBpNe0LSjx3YYj+x+hds+so
rDWEgSHrLoRYUR9xkrqB2Mt+zpQmecIVIcdLJqIm6OnXoZdCyZ5gVjxx/q64
CaJkqfHJxy2CMJknkiboIDCIKTPFE3Jqv79uvGyCxvVOakY98wTX8Z8zZ+RM
UPyOTKNjpifoy+gofNc1QWSQ8OxsvieYGO/pxHiYoF8D0obZ1Z5Q0+6Vc6HG
BLWvPBxMHPGEsMdDwZUypsien6vd78Q9EN15yzZnYIaqMwwK1aPvwVVV66v0
/ebo6pNm929hXoBdeiceeskStbfmyFo+9IL6xj/Qe9kSEbYjaD7j1qO4cpPm
iiUSNNMvHg33AtWUpaYUzBKRiX6f63jkBefr6K+UylmitmF63ZwoL7D68of0
k4YlkjptI3Ir0Qu67HbW5G9ZIo5iyp+TuV7AT3V4Gh5Zoo3uGzbv2r2AdUI4
aWXaEiWTbBlWEXvDP/aAEq5QK/T1vgAK9vcG+c6PsVKz1sjXPpbsjKcP3Kh8
8s+8xw5tZniOpuL2rX8YttBrh+w/3sxhuucDY5mi7Pb9dugGgU+G2ssH2nMT
H7i/t0NS1PX3Dr19IOlc+fGHI3boV/nXxSk/H4ixC5Ern7XDe+RiR3KoD5x7
FHqFft8OaYXPBNI/9QGRXBJ7UqHbeI8IHfxX6QP2Q0WuNU9u4z3S8fPHL3w/
91w2VQzs8R7ZH6pzug+KmqVcalsOqFjZMt3A2hdmNt7by1m7IC5fFYch3AWX
compbF3wPjl3WdPGFy5dGXk5ZueCwll2hxVtfeE1n/IlJ0cXvE8iKSVv+wK3
nb9QirsL4oiuvn/CyRcusKcEbwW6oIRRcqMPHr7A0O5+WJPhgvyty5jUQnwh
5L7lBe9xF6QdfBiNZfvC2JXGHAe+O2i7KSmIZ9YXJJnDOcPT7iA5qX7bDWM/
iF0YsRuKdkWTPJJiUfr+EMUZoOUQ7450brASHb/mD3vD20fvJbij7if/BkJx
t/vdbQt66o7ebPfc9jPwh5jIxyapSe4oodv0uaOhPzQUcVD2PnNHWo7htOrG
/qCrckZdKMcd75Wp1WNW/kBJ+0vnd6U7KpELKg509wdzOqLo/FF3vFfe89yN
8wdJ4jz+UFYPvFdunzT+4A8Zc18n+XM8kOuJjD9nNR7A2dCJJO7mu4gkMHh+
jjMACFuHn98weKE0lx8l/iyBoOPg+tdfwQ+Nk39OaMCdpiW9Navoh07kDN7f
x/1j691vBWU/9Gi8WtWTNRAUbxufplDzQ96ygQtOpwLhtxL1TpKWHzI4wcRm
whYIMipE86+N/BDdG4i8whkI5sTliVt3/FDY3zj7XYFAWJad905J90MuTy7z
u10KhEb1iATXHT8kVxyWZX09ECQUGuVNS/zR0iJHvMbTQPD6M+7CSReAJEyv
ebHSBYE47Vv9oORAdGdX2cwQN+XH/7Q0UgJRcZy0UiJu+dkXWkypgYir6wwD
PX0QmF/7YVn0LBDRiSyXkp8IAqqPzeNDGYFo9ciDb7sMQVA5GbTJkxuICnML
DMaYg2B+VGl1oDwQsf88kEjgCALhjxL/xPoC0THfF7+oRIJg6ClXm+rfQDSZ
smZ/RCsIZrTD7Iqtg1DASITJUmQQ7EbkcGhcDkZ9Gk1y1WTB0PT4yL79Vggi
/VZ2dgs3t0q9qtbvECQXmE0rRh4ML1cVs8S3Q1BdVfhMCe5h13e3/uyEoAJ2
PZ/c48FgklgqFXUQgsLWv5UnUAbDpfB+/tfEoUgmgY7TnTYY/sbLCRDThaLK
Kat/F5iDYX2+uKDyXCjKsKdoKOQPBsUzn6ccbEPRnXBDyXSlYDgm/bSUZzoU
MbVv8IeEBMN8dKroQG8YsrjCT6VLFAIXBi5ftmwMR/tnY8Z+7oTAvXd669v7
kUiqPahJaBc3e3Y0459I5Gp6N/c2brKlaimJw0i0FGfkvoC73VI4zfVfJBo7
4KH5tBcCRua67T+OPkGVA7VK/QchkBCSG/GV8glycZ2vKvoXAoqSst8n2J+g
rzVSCbbHQuH5A4aj03JP0IDyJ+1ZplA4G2Y5hj1+gveFYO+wZChccR6q9GaL
wvuivaHePRQi2n9NflaORnHMe88j1kLhtPum3+3JGHT2mIUj77cwmDDoOWXh
HY+snuvrWeIWTHzuSu8Tj7KuKEs/xy0zOdHXhpv5jjAZ21IYxJTZP+H2jUek
E9vZDN/D4LU+jeKCfzz6WvR46uhKGJxzdwu7HRKPMjSr1OZWw8Cln0b3bnQ8
ok8kO5u5HQaGiJc2NTce/eEpXWAmfQgeBWXyzEPx6J3cH1NK3ofwUZHfbkko
AXn4J+psWjwEs6anBTNzCXhv9Eq1zjyEuMNolZumifj5Ln7EZDQcZqV5mYye
pKAEf76lVNyYT7HLhagU9J6Z5f047utXT7wjiU5BSlf/pumPhUPo+sOU0pgU
JFndfUljPBzit0kd/ktIQfThJneuTIbDbXP73fLUFDQg9PAzy0w4VOdebqQu
SEFy7pONowvhoH8QuzHaloKEiAN9tH+Hg9TiD4EXuyno75l3m/IMETAhHV/E
Y52Kcm7aLQrqRoCWeq/UrOwzvD/S+nYHIuAcqlBzO56On/f/JSZ0PIIjxrpE
845ZqCpjTLC/MhIaTnlvbTfnILnHKkBTFQmn+SWtU1py0Id7tXq6uNOlnSau
tOagZe1nvuO4f+Tq9Ae05SD2o2bvvlZHQmbrj6njHTko3HbR9bAGn1d898WZ
3hxkLPK75nxjJLTCmQH14RxE0kavHNsRCW7Cl5+9WspB+gtXLQ1GIyHqVPe5
DLpctCHU/uzLTiT8G3Pp5LXKRSK1ZZS/pZ8A33BB8hRFHir6GLHK1voEClgp
Pchs8lEGGaHCZSAKxhk87mQoFSGh3y87K3APtexymyoXoZpZtqnfuAsf6E6x
qRShj3X/jvq+i4J/FqHX0lWLEJnT22vh76Og8eD7vTSNIuQ2qLaXNRgFtjo1
Hs90i5BS6g2ZoZEouORco5lmWoR+Ct17JzETBfwxjWGFnkWIoFWxvLcaBY/U
Elk38orQ1FMB7hDaaOC75eFCICtGzNyMCcl60bCESTfXDRSjeGz1butENARe
TkwPtSpBCpc/pJG7x0B0B3226q0y9KiUjF8I98mEN2G1uAd5Zcs1cBuEeDie
tShDpvQVHdG4/36RQuSWZch7JX6V0SMG7IRn9rutytCr9OsyXHdjYJOpYVzF
rgwxE3+el74XA3GJn/jUXMrQj96fgo73Y+C+4D6Vnl8ZijemqH0XHAP/DZbT
+aeUobkHSiPxCTFw+Os7XB4qQ4GdDVTs1TFw1K6vSUmxHDXpFfqL7cWAoitf
1JBoBbrkHGR+80EsEJ90CtPmrUTnsiV4Sh7HwXo0IZLifg3yYHF69Q43u739
TCbuuujcS+u4lV5Qi0v41iAVX6ar4pFxkK1QN2/sV4Msru3ercXdupdh8epB
DUo81tDV8SQOjO2yR3VCahCRo7zDTHQcBDq1JaU+qUHDEroVNAlxQDdW+EA8
qwb5drrIuKXFAeFHznpQRw3q/15kfLEkDkQao4qTaWuRvQjn09Z3caDwl1Lg
RUEtKmikIh2li4dV4n1TuS91iGt88dvfpHh4Q/c2+5ZzI7LTPOPGkRwPmUz2
9sddGlFp+/U/sri7yGvEX+MmlHfThuJW+6jyjsS1EV1/VHSZIiUe+jMQd4F7
I4okOD8+mRoPDzwCNNa8GtF21u/zImnxYEEcnvYguBH13ibxvJUVD7K/DsUL
khuR6wEnSXtBPCjyyqizvG1ELewmHBG18TBLIHa9z9yEzKw/Gp6Yiof3+2aq
ch1NKG2juYefPQFeLilP3zvRgpioUoq1cxLA4GqlXn1oKzIOHpR0w53yy6SK
NawVZe+Rt8Tjzup1Z/bBLbLoMzyK24X/69ylh61Ivdn40Dg3AXzmx8Krw1tR
gCuH1u28BFDloGapeNyKlkfyNwILEqAitE+tKLYVNWVUX379MgEc+y9tZaS3
ImuR4S7GqgQIodS3SqlqRZV6NF8nOxKgD1QXhhZakV5q6Gnrbwmgl2jffUO5
DcXwuz3xFnwKmvbiFG3UbxGFnLrLi7KnMMEomqZf2o6I7h2KbTUkgpPKbSsV
6W6k9FOykbExEYx+mLK14H5i6ax8EXdk7ObYxSvdiFX7800f3Ck/9nT4Cd1I
8mxrCFFTIvTD/RukqBvZT4WMUjYnQtE5vep22W40DJQ+vK24W5zz5VS7UQHZ
qVaDjkQ4l0BuJ2/YjbRSL2nVDiTCVp+HnaFnN8podHfwn0kE+16T+A8V3Qgj
Wc4mI0qCs5mvD/aFe5BP7CgDm3wSlJoXO8nz9aLfxaXbij1JkJh14duhcD9a
/nKrLmkkGULCqMMOlD4gkeupCrW4r/VpCSkqf0D3BobeTeIO6vcZjMJNUic/
zzaaDLHHozi4VD6gM/G8lDm4BXMKe1RUPyB9xe8mZWPJcKatWjlR/QNqKrxz
pGciGe5pS2yKan9AcW4PVPY/JQP1FguZ440P6DJJ+qjxYjJ8vu0tvOLwAYXz
j29w7iSDBGHakzH2A+J31hR6yZwCbTRb/azTH5DVgXRay80UmHtMf33VYxDN
MDL4f59NASvJ04PfyofQR7VO2SurqfDDC+lnGI0g1ta/fca4h3OMHXdwm1+8
aOCP2yTuQaj2zRG0yl1g34r7Yu3HOmLjEUR2GBGvvJYKC9ZVorYmI4hQenVB
bz0VvtSZaYuYj6C8EyPhjhupcFfbWOet9QjymZ5/n76dCkGM1yx+3BlBXM5H
TIn+pQLvI4W3ag9HkFsswaeD5hms57OkXKocQbTjFRVaos8gkqNGf4J6FGla
Z3JbeTwDu5t0NJJdo6j7gdd/T/afweY1s8FQhXHUUCnYM0OaDisNg39o3adQ
Hnu0dtCZTNh4KZxEYTCL5h7poWzcN3sCyFVxs++cFG7HPfnSyTcMd9L7rGOk
HJkQ3k9ndeT6LAoPqGiKwO0WFiy9g9t+bkQ4ljMT/LOpSOZvzKJzeafJs7gz
8a+wjbzeZBZVnitqbeTPhJ8GM58drWdRG6FDbO9CJsS8N64Z85hFn4wOGO7I
ZELsW2u+3vhZxJBkO2FyKxNYfGQMuIZmUTCNjMXl7EyoVPlGnK09h0QCdi97
nciCvCNTUYf684jStVD9QlIWKAWIO43fX0CC+Y/bALdz5NzEGd8FpPLJ6bI2
7hXBS8q2uENUxfhdcRtzjXFv4z7krCd+jfvJia9fT/gvoNWh/lqp5Cy43iYd
phWwgD5IrPOjlCwYcZhV7ApZQPG7UiRXn2WBTKtCbc2TBcQa0N5gn5kF66eW
XbMzF5BA9OdzeflZcKl5QSr57QKSL2GkZavJAh0aC9d/FIvI53vg8PGJLFBr
9HzTlbGIlm4ZmSyyPoccF0Zaw/5vqF2XwiU94zmc0397DlNZRnPhPxdKcN/y
+OUejZuo+b1xE+5SGK6bxU0QSlD7jFto6o1amOoyqjrKxseZ+Rzi0Y7be7Vl
lFd5/lMO7rv+1xduXV1G4Uy66i+znsMJ9hydh7rLSH0ymb/+BT6/NlNl2HgZ
Dd3i+zKeh69/rbTc03UZfbkjq8NQ+hzuNRT4fkpdRgdR98QfNz+HacvxG+Kr
y0isb37H68tzWE9o1j6atIKy5BsC9LlegKCkP+Hqrx/IV8IpjiLvBdjFat3U
7VlDkkzvq7xLsiFsuieskXQT6WuUCz/CXaEaMLWB2y0oPjsVd1F8pojAsU30
avV6bD3upWbm6TjcfF1fHA9xPw77fdGObBMxeW1wB77KBgqJG0dPHN9EuxOM
ceGl2SB+tX/JjmoTNaQbOyeVZ8P0rfurjAybSI53ma+qKhvu2PcveHBuIm2J
/5LXG7OhnaXqkRJhEznqXvGxfZcNv+kDZy+5baKcqHx0bS0bFNbvWtz8vIno
jwV0iYjmgHeoV2VO0xZa3RGZ+FaZA/tBFuzlsdsobyLuz7WGXJAWfsHzJ3If
tdPcdbfBve+ZHwJP9tGc4vVlT9xlZTwLQbjZK06NJ+Fe2gjLJ4/aR0mPcl5P
4N5tXhY9Gb2Pwq9U25s05sLQtwsmYrH7yD59YtyqKReoel5T3X66j87d4qhy
b8kFy7yG0bH0fVS5VOIU254LL7wLyetf7aO2ne6Z/v5cmNHP3Uv6sI8+Mf5r
kf+UC3OsUxdfMhwgBl2HUNG/uSBxVm8KMg5QUK88NZVMHtiY1EhyvvmDTOu3
zrS/zQOVN59vXiL6h06mG8iL9eXD4J1O0pi9I2B1RCxTFvfSX+uFatxl1lQH
2rj1gmXaP+FWOd9e4YJ71yUvSGj/CHg1i3KV4GafkSTuwj0+S3lEoD8fPkpb
Uv49OAKpfG+b2AbyIdZkT8Px7xFgL7sgTf4+H2ZD2R+oHiUGnrdkol+G8mFH
Oy+flIoYxL7XsUdN5oPrnfuUkRzEoCF5Zv/793ygEam/8laZGIIGvpU9JysA
98jyr/OJxLB66MVOp1QAHYszR7cuHoVO02d7ay0FIFfAWuMbSgKeHF9KS6oL
gbLZST9N6xi0hdRTNOLOZo3c68VN/T3Rth93zNpKxh7uvPKrZ1ZwA+mdZQPt
YzAmVx8l8KYQGn9EhNDpHINL1olO2bgN+0k6wnSPwX6hhlBKTSEUKzPfc712
DPzEa/NC6gohqr41U/nmMQhRiku/2VQIR4/cP7pjcwxiHRUek3cWwh8H+5MW
/sfgZU2BjfVIIVzVNgq/XXIM5rRd2di2CgF9jVJGlGSgGUj8OFK0CAzDaEn/
GyAD3jkeG4eXRcAnF3goefM4DGffPn32RTFYkKh/flZMBRxkil6XcGtG0rJ/
xO3oyDGsjLuewG5y/CUVkEiOPbbBvXmSftoLt2SnwkE27r7Gm5+ulVBB4tKZ
SfbsYrDc9vxJU0oFhudGkxhyikE18Z18SAUVTFXLnSDKKwa+29Q9TrVUMNdz
6vhYYTFcP3NBSqGLCtbWBnZCyothnXYl/e8cFRwniH380lIMqxpH6gtZqUFm
eD8i+XMxjLY5fJ94RA0vSSJ3jrG9BDLykGMFzjQQYv1qaDHpJbivlnoyvqAF
cf7N8JwnJbCrdEqXN4Ee4op8f5/xLgXyOubcsHUmcMt+kyaCu8ioULMUt17a
hrwsbsrHjrtjuBmi7OIscD999kjj7C8mSHTVv5CLu/4B704f7tRLwrcFfUrh
t/voNbpNJnjROTUtcb8UNsj4Lqf9ZoKKOel2Vb9SaO8LTqrYZ4Ih1r0498BS
6F/xej1LchJOPL4r0hVRCjaW8vaqLCchwcHZwTm1FDT/CcwjuZOQKGw+21Bf
Cm6KfQFtCSch5ZX8wI2/pSCb4nhLhMAM2jdCh3pky6Bkf9mvM4EFDEw0io52
lUGo+uPiKafT0Dnx/ZACt7Ti5Npx59MgZfBQhwF3spm5hDTuk1ptuzy417bp
mpJxj8tcUlbCvfr6+PA1l9NgxMPzNRx3+kPd4x/unAbTlQM26u4yUE8mZLW7
nwYb7+JY5p4y8HQPcn3lfRo8nx73PtdXBtXVjEUhoachcaBb+fr7MjB7bXb3
SvppGMMUF4rG8PnfX4YM9Z8GQ3bEobtUBhLuacfyhdngxucLiVnk5XD5TVbx
z1U2ML51IgjTKAequvxvdP5nwMJ68sa9wXJgIhgUf7LkhKHZeyUPcHPfrfu6
i1vOlPFIOO6P8QR2BitO4L6uXZCM2zooNVYN91eVzu1a3CZ8jd5vcNsIV8T/
wc2Rmq4Va80J9psRA4FD5UBS1UenaMsJboGXZSM/lkPI+Je1l/acEJSeLPB8
pByMJ2hO+LtywosRg53eiXL4PR++zfuAE+YVPyawz5XDpT4B6chUTrDi63/f
sVEOsS4XtysGOcH6W6MiA0MFqEz81HWQ5QK7289Fyw0qQOJbrXgyHze4ONmR
r0xVwMAj+UlbMl7wvbtdY7r4Gsi6x/rpz5+FoxG0D2xwQ+vLFnHcj9IEFZ1x
N+9nVurjTnlrOuiHe+L8bFoi7mq6ru9puLnT3zmzXjgL6yVJrFO4mbOuMXOJ
nAWrxUu+17+9hvOlDEGiYmdB4/p90F56DYEuRmXaUmfh9GWiTtnl1zBoxeEV
g85Cwx/yjzyrr6E/4m4Vo9ZZ+BPM9nP592ugdpJZlbpzFnzjFDjv/VcJVzEs
ZrjiLPiVxkVE81RCnJ79Nf/LguD//bxRi0UlMC/eXkrREIIAE9sDzs+VYHnk
U8utR+cgRHEcWxirAjO6zKnP4qJAcWPj6E/cY+Isplu44xwpe7dwB/nlfCGT
EIXn8TIGJONVkBy2uiCKu2m2wJkbd/wd7V/BuHf9vDNv4aYuVqcQkBQFx2rW
IzO4ezbPaNyREgV9fpP20YkqGH0ue+TIZVHgIZ9T656qgs7pe5e5kSi0969c
L/5cBWKS3HP2KqJAov/P1fVbFXh9pmU+ZiIKIRZ8eYfbVUD7i0/cPUwUQh94
UDMxVcN8gD3VqUlRCKul/aykXw12iZTRZSFiEH5ONaDgQzVcE9+cFf4mDo8Z
69ocet7A4bPoFTQvBTF8b2654+4GY9/ruBMuVhLdxx1ocYXqDu6MG6/QI9yr
PKIXnuMuS39RV4DbJWPf/ehXKRjlfVyxgFvC4b8j3bg5pIxfmPW+gfzsfQGd
RSmoNPgbqNf3BtS1rcssv0vBTJKc7JWBN/AjWTU9Yk0KxFj7mo8PvoFfPxrX
xg+kYJx9uqFw/A1cPhjxCWW4CDwCf6u/fXsDn316FJmULkKDtFyxJWkNIJ1T
0SeLLsKqWW/8TXncnnK/M+9eAt2iSSv1xhrQNCFyIjolDaxwQCpUXgs0oVTj
HVkYsGvv5orhdnYWVp3HzX3rt4I07g+fzOqInmMgHLwWpIq7UJMk/Qpu6Jr/
a4u70lveshy3lVb/dg5uuT+pm2kvMCg1S19kr6iF6R+vuD1yMFAIgE7617Vw
RcWxlasAA6fW4ND9ylr4paq+GVCKQYs8JUlvTS2oRFGJyjZhYKPCduR2Sy1Q
r11hHpzC4LUOHOS9r4XkAPKK8ycRaFgFr3Gt1kIB3Ze92SgE/hEU46xCdTDd
8R+dSBDA3MdThcdz6+DphW123QYZKLQjqC8n18PMynshs49ysCv/PXoD96cv
S7RuuJXOJA7v4w7gptkOwf11ZM2EIqUexmKDW4pwc8hn3xHGrXCC0mAbdyLb
8URn3MMlz4KfDMtByNDYlw3cD22rlupH5MCc4O55kFoPgazDk8zjcsBEW/Sc
Mr0eQr93mX6cloOgNyd3zz+vh3/Bwwtqi3JgTLqZ415YD1YR0xvye3JAnVP4
909tPcjlBJwyPSMPbp+ZKmim6kHk1CEm7igPBINfzJJsDcD1vinAmkwB3snn
LT543gBfD+7P0agrwgY7bRBjUSNgIoO0JfvKILvf0MmGW4CmyeMt7piR2xR8
uCOSa8cncJ+PfJsghbutaDqL9EAZbu955l/HXTQwJGqO+8vHT/0puC/SPzA4
8UcZBsKLT7IXN8Jow1iR96EyFGwolfC9xNcbePRAiUgFTDv9xi++agTB4CMT
X/5TgT6nlfNGFY0gHOGvwUynAjkNnVMZdY3gqcx5KY5fBQyM/CQF+hrhaYaJ
ZIW+CtQ/XV6S/tEIxXedLbJLVSCEskPL/HwTpO8nm2rZqcLJfW+24oomSCi/
XrP1VQ0II/M1MvXNsLjM51VCqQkvlKnuqOCWE4WNDtxkdVL82rjpPKwdZ3AP
Z0Q8NcPNvjZlTkOlCQ52F9z8cdvX31FzxZ164CPUgHu27DKHJLUm7HDSZ1xs
aAaLC6qjDTSaUOEsE3y+sRnG75s59tNrggBZ+tXTzc3getNV5gezJjBeMZjb
aWuGaT/78PO8mrCa1U1R2tsMPAWVKY2YJmQ5lpiyTTbD9cyGwf9cNOEoyT2S
/d1maNjRYoYhTbBm+a/gxqkWSCO4kd54pgXCKsmb9Dda4NjkxRu8adpQl9v0
KHS4BdqveNxl0NKFn6Z6NhG4KcojQ7hwczAvyT7BTVT7Ml4Ed9gjur0E3IcB
Rys0cOu6WNnm4A79RbEWgvv7peMKb3F/NAi3/42buf/aIdFIC8zLXbAd1daF
uxs/XHxxH3BL3UvW1QUROHXNfbQFSHmEN04b6ELe+L0zt8ZbwHxlQo/fRBfi
KUQrCdMtIMYh3yXroAuOrtmfNudbAMgCPZ881AV2LFzEYrMFjKZvXgpo0YXA
YZ1RRN8KQrKvr4+I64HK0QXOXa1WuEQ+/0CTQx9GzClq7ftagfJO53ciOgM4
/+/eN2fcgl+iVehxh6V/ZXTH3f3NIp8bt9Rko9t93KmNvNZKuBP17ghH4v4Z
zD77GLeB0khmCe7fftOTTPQGMCqUGbaOe47waET4BO5tMX3P/laIiin5Zsho
AOORRmuBA61wb475QTmLAUzWFPKmvG+FM30vfay4DOALrUpc18dWoItnzxsU
N4AfLSEOPNOtwLU0ON5tYAAknH/ZZn60wk3WdmKhdAOQmF0P0qFuA4YCCoZW
oesQd2tU45JOG9hoTMapahuCpsXzL/+NtYHSkASp1xsjyCOipjmO2ybMfP4x
7r8ZPhg17ubExJZM3K+m9FKZcAv1c97vwk19jVSfHzf2qHKdqcYI3ik7dKng
JjLo+1SFW+uc5KvHuLtlm5o3a41Ae7f7Pt14G5xirnvh0mAEOlHrTGwTbZB8
nmbBttUI9OvgqsRUGwx4G9006jMCI/qZWovPbVCrPkij/NkIbNpY45u/tYFn
I3s2HLsJflwJit67bWDvQ+gtuX4TXs6FFf1geQs8svYfA/ZvwnFLR4+Pxm9h
Nsww96SKCXRZXiR7PvcWnuZ1j04dMYeZAEbuXNxUd/KXFnFvpW9ihbjlkh/v
/8LNNV7qXo57n8SKnYzYHHw1BD634i7TumYjgVtMkqV6Dvez4ss7kbgzSA8s
eebfwuBDcjZ01Bw8C5ua83HH8HZ6ZZGYA8+a4r1XX9/CcELVHetj5hDgo79Y
v4jvTyrIYp3SHC7FuraPLr+FN6I+mseZzaGoqTiAcvMt0L3guqp53hyiWDj2
7h1tB1YmFZqTN83B4D3ZsiZPO7SxjGy/rDKHRenJvj/W7bA7xzK+5XwLSOj9
og2/t0PqBUob1Q0LkGlpY6Jd7wDrei3NUmQDcwKfl0/gjq4v0GrAHRJ70HQS
91m6Yzo9uHssJGzP4C5v+Kg3j1v3v7w353ELMJbcOAk2YKUWYXgV92S/mc0D
3A+HtVIf4WY07wjWkrGBd0vTbP/96oDrxrHv1mRtwJhuh2cf95+Z8zkiijbg
bSEk/nWzA6hzY7Veq9tABUmCVs1OB2jtB+U3GNoAt6p1uPm/DiCVvm/+2c0G
SIeO7ZdRd8K91D0W63wbGJjX+KRzrhNSIgU73OhswejYWHa8fSdIpSt8yPxu
Cx6aKyInFzqBZ/5m8sOi25A/fUKdfbILXmj2TXTfcQJnQTI3LtysaqT/TeKW
8vqTzIf7ubqKyAru9hMLi+dx95nPhlG5OsGcWnUQ4P720VZCF/fpWsM6c9yP
ZjpipnDHPU0/m41bJLZTc9XNCXw1+ckEprpAqXvy84m7TqDdIt0hOt0FhFs6
BmbeTrCffQsUZ7qgwSgqYSfQCTQcSsUd57pAV5/o+rl4J1jfUztdt9wFc3uP
90qqnED6ZNDPawddMHAiZP7ogRP066xHPzndDeQrNxuPPnSG9c7+4T+m3TBY
TsVpluMCl8pDTafmu+GTZvznO/t3oCd0xzX5Zw843sJOEXu5w+kzgrppuBdy
qKYocDvXGItl4T55bTaVETfDSutGPu43B3GsZ3Gba0e6v8E9f+sMqzbubVbO
u6O4/eOmWTJw85SpeTGs9kBVxNIpaW938J9M94/B3bqtJOjm4w5iFxQeh6/1
ANGRM3fmfN0hbTwmx+tXDxgGK2a9DcTXFxIcM/zdA8+LauPCH7sD/aAxgeWw
B8L/FLadznQHo9NtpKmUvUBrRGbh3OkOKxWRz54J9cL5l12X3zB6ANUXzo6M
273gMhPL/7XaA3SkNZhzF3rBUuruj8GjnjCxmtVU/qkPRo499pbq8YLsr9OH
UjsD4Gi74h6a/gD2WQj+Pkc/QDSL9RhHazCkPnekLdz7AA+GIwOkScIhyWXx
2ROSIVg0Lws5ovcEHrPJ17UeDkGn2N13ZH6xIO+ldYl+4yN4SxpyENISwJAl
t5T5YBgavLbbVuyTwSr1U63zxgjMGby44WuVBgO3zBp9/o7C4a3sjOvJWbA/
EsOR/d84bDDYni2VygZ2wVymUwfjEEW0Gv7uWy5kthOTqv43CfcIU8Nlpwvh
JMiHdx5OwnOWpLufLV+Cno24vfmvKTB15Px1Y64Ufnx0VCzbm4ZjwcTSOUQV
4MsZ8Vpr/RN4R5mQaTFVgn3VKmvuwQzwFBtYioVXA/XBEVeKI1/Apn3P6h1H
LVhQ/GVzvP8F+Jofm1jV18NCU0YXP9EsFLSp8CS/bQLLuTJpCt9ZMOJy3ju2
2AK0hbZFqsRzcJBgrype0AZnlLZVmcLmQMs0TfF8YPv/AsEBPv4/KVP2sgoB
4z/1pD6yLVfGP2IDmxhahuM/qyrmGUl1yD+WI7FH0QLkP1qkf2gNj8o/LBqf
ptZ85D/wW+lT7LzMP/GzMQI3AeU/7IJ2SZ89zz+xvTUnv3zlP4UZrif02tA/
oGreSKIC5j/KW67/9UTSP/HtXpoThuY/QWpg2ZO80z894VC1rADnP5oulI6J
LdU/uHfnzKCF5z9BEGqnltLWPy5+7628Aeg/+irqAtpv2D8GW8++ZnvoP7Cn
ol13GNo/DdtTzGv/6D9ObsrSqPvbPw/LSaOYeuk/RTCuqxzU3T9AXuR2IADq
P7LI0eaE7N8/bWHwE9B86j81SHRWYfzgP/s61OAN9+o/FCpqv5gI4j+4t1yq
pnvrPySVJe5tOOM/caRWPWf36z+GqYDAZmDkP1g09cyCfew/+tlOeQCv5T+h
mmuMLAHtP7zhe83fBec/5nBTFf577T9V3Nzh21LoP1nq35oqAe4/9FDCW5jK
6T/I093pfn3uP3Ytzgd5N+s/mZOzaGH37j8G59PnrqrsP5j2LeSee+8/lPYD
deNM7j+TyRkpBPfvP9ht63Xx4e8/FxoKQ9f/7z8AAAAAAADwPxWr+Yc=
               "]]},
             Annotation[#, "Charting`Private`Tag$4110#1"]& ]}, {}},
          AspectRatio->NCache[
            Rational[1, 2], 0.5],
          Axes->{True, True},
          AxesLabel->{None, None},
          AxesOrigin->{0, 0},
          DisplayFunction->Identity,
          Frame->{{False, False}, {False, False}},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImagePadding->All,
          ImageSize->256,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, 
            "DefaultGraphicsInteraction" -> {
             "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
              "Effects" -> {
               "Highlight" -> {"ratio" -> 2}, 
                "HighlightPoint" -> {"ratio" -> 2}, 
                "Droplines" -> {
                 "freeformCursorMode" -> True, 
                  "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
            "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
            None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}},
          PlotRange->{{-2, 2}, {-1, 1}},
          PlotRangeClipping->True,
          PlotRangePadding->NCache[{{
              Rational[1, 256], 
              Rational[1, 256]}, {
              Rational[1, 256], 
              Rational[1, 256]}}, {{0.00390625, 0.00390625}, {0.00390625, 
            0.00390625}}],
          Ticks->{{{-4., 
              FormBox[
               RowBox[{"-", "4.`"}], TraditionalForm]}, {-3.5, 
              FormBox[
               RowBox[{"-", "3.5`"}], TraditionalForm]}, {-3., 
              FormBox[
               RowBox[{"-", "3.`"}], TraditionalForm]}, {-2.5, 
              FormBox[
               RowBox[{"-", "2.5`"}], TraditionalForm]}, {-2., 
              FormBox[
               RowBox[{"-", "2.`"}], TraditionalForm]}, {-1.5, 
              FormBox[
               RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1., 
              FormBox[
               RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
              FormBox[
               RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
              FormBox["0.`", TraditionalForm]}, {0.5, 
              FormBox["0.5`", TraditionalForm]}, {1., 
              FormBox["1.`", TraditionalForm]}, {1.5, 
              FormBox["1.5`", TraditionalForm]}, {2., 
              FormBox["2.`", TraditionalForm]}, {2.5, 
              FormBox["2.5`", TraditionalForm]}, {3., 
              FormBox["3.`", TraditionalForm]}, {3.5, 
              FormBox["3.5`", TraditionalForm]}, {4., 
              FormBox["4.`", TraditionalForm]}}, {{-4., 
              FormBox[
               RowBox[{"-", "4.`"}], TraditionalForm]}, {-3.5, 
              FormBox[
               RowBox[{"-", "3.5`"}], TraditionalForm]}, {-3., 
              FormBox[
               RowBox[{"-", "3.`"}], TraditionalForm]}, {-2.5, 
              FormBox[
               RowBox[{"-", "2.5`"}], TraditionalForm]}, {-2., 
              FormBox[
               RowBox[{"-", "2.`"}], TraditionalForm]}, {-1.5, 
              FormBox[
               RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1., 
              FormBox[
               RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
              FormBox[
               RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
              FormBox["0.`", TraditionalForm]}, {0.5, 
              FormBox["0.5`", TraditionalForm]}, {1., 
              FormBox["1.`", TraditionalForm]}, {1.5, 
              FormBox["1.5`", TraditionalForm]}, {2., 
              FormBox["2.`", TraditionalForm]}, {2.5, 
              FormBox["2.5`", TraditionalForm]}, {3., 
              FormBox["3.`", TraditionalForm]}, {3.5, 
              FormBox["3.5`", TraditionalForm]}, {4., 
              FormBox["4.`", TraditionalForm]}}}]},
        {"\<\"x^3.35\"\>"},
        {"\<\"x^3.35\"\>"}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Center}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"]},
    {
     TagBox[GridBox[{
        {
         GraphicsBox[{{{}, {}, 
            TagBox[
             {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Tiny], 
              Opacity[1.], LineBox[CompressedData["
1:eJxM13k8VU8bAHBJthaUSpYsKWsou5w5QqiUpUJUZAslQqIFoUiUpJIkhISK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               "]]},
             Annotation[#, "Charting`Private`Tag$4236#1"]& ]}, {}},
          AspectRatio->NCache[
            Rational[1, 2], 0.5],
          Axes->{True, True},
          AxesLabel->{None, None},
          AxesOrigin->{0, 0},
          DisplayFunction->Identity,
          Frame->{{False, False}, {False, False}},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImagePadding->All,
          ImageSize->256,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, 
            "DefaultGraphicsInteraction" -> {
             "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
              "Effects" -> {
               "Highlight" -> {"ratio" -> 2}, 
                "HighlightPoint" -> {"ratio" -> 2}, 
                "Droplines" -> {
                 "freeformCursorMode" -> True, 
                  "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
            "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
            None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}},
          PlotRange->{{-2, 2}, {-1, 1}},
          PlotRangeClipping->True,
          PlotRangePadding->NCache[{{
              Rational[1, 256], 
              Rational[1, 256]}, {
              Rational[1, 256], 
              Rational[1, 256]}}, {{0.00390625, 0.00390625}, {0.00390625, 
            0.00390625}}],
          Ticks->{{{-4., 
              FormBox[
               RowBox[{"-", "4.`"}], TraditionalForm]}, {-3.5, 
              FormBox[
               RowBox[{"-", "3.5`"}], TraditionalForm]}, {-3., 
              FormBox[
               RowBox[{"-", "3.`"}], TraditionalForm]}, {-2.5, 
              FormBox[
               RowBox[{"-", "2.5`"}], TraditionalForm]}, {-2., 
              FormBox[
               RowBox[{"-", "2.`"}], TraditionalForm]}, {-1.5, 
              FormBox[
               RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1., 
              FormBox[
               RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
              FormBox[
               RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
              FormBox["0.`", TraditionalForm]}, {0.5, 
              FormBox["0.5`", TraditionalForm]}, {1., 
              FormBox["1.`", TraditionalForm]}, {1.5, 
              FormBox["1.5`", TraditionalForm]}, {2., 
              FormBox["2.`", TraditionalForm]}, {2.5, 
              FormBox["2.5`", TraditionalForm]}, {3., 
              FormBox["3.`", TraditionalForm]}, {3.5, 
              FormBox["3.5`", TraditionalForm]}, {4., 
              FormBox["4.`", TraditionalForm]}}, {{-4., 
              FormBox[
               RowBox[{"-", "4.`"}], TraditionalForm]}, {-3.5, 
              FormBox[
               RowBox[{"-", "3.5`"}], TraditionalForm]}, {-3., 
              FormBox[
               RowBox[{"-", "3.`"}], TraditionalForm]}, {-2.5, 
              FormBox[
               RowBox[{"-", "2.5`"}], TraditionalForm]}, {-2., 
              FormBox[
               RowBox[{"-", "2.`"}], TraditionalForm]}, {-1.5, 
              FormBox[
               RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1., 
              FormBox[
               RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
              FormBox[
               RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
              FormBox["0.`", TraditionalForm]}, {0.5, 
              FormBox["0.5`", TraditionalForm]}, {1., 
              FormBox["1.`", TraditionalForm]}, {1.5, 
              FormBox["1.5`", TraditionalForm]}, {2., 
              FormBox["2.`", TraditionalForm]}, {2.5, 
              FormBox["2.5`", TraditionalForm]}, {3., 
              FormBox["3.`", TraditionalForm]}, {3.5, 
              FormBox["3.5`", TraditionalForm]}, {4., 
              FormBox["4.`", TraditionalForm]}}}]},
        {"\<\"0.5 + (-1)^floor(x)*(-0.5 + mod(x, 1)^3.35)\"\>"},
        {"\<\"0.5 - 0.5*(-1)^floor(x) + (-1)^floor(x)*mod(x, 1)^3.35\"\>"}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Center}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"]},
    {
     TagBox[GridBox[{
        {
         GraphicsBox[{{{}, {}, 
            TagBox[
             {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Tiny], 
              Opacity[1.], LineBox[CompressedData["
1:eJwc13c8l98XAHDJLhmpr4zszFD2eO4jhEqJrFD2iIysUCElshKiYZfsQvZ6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               "]], LineBox[CompressedData["
1:eJwU13c4UN8fB3AhWQkpmUlIRhmRdc+1d0Zmkr2VnVlCRla2UDYlZK+ED0Ly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               "]], LineBox[CompressedData["
1:eJwU1nc0V/8fwHHJt8gWQpFNSHalz32/7J0dkpWdmZEQsqNkJ2SVTbJlr+xR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               "]], LineBox[CompressedData["
1:eJwU2nc4V18YAHCkQspItggJGREluecI+SHZo4FUsirJJkIKmUWRsjIiEUok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               "]]},
             Annotation[#, "Charting`Private`Tag$4307#1"]& ], {}}, {}},
          AspectRatio->NCache[
            Rational[1, 2], 0.5],
          Axes->{True, True},
          AxesLabel->{None, None},
          AxesOrigin->{0, 0},
          DisplayFunction->Identity,
          Frame->{{False, False}, {False, False}},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImagePadding->All,
          ImageSize->256,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, 
            "DefaultGraphicsInteraction" -> {
             "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
              "Effects" -> {
               "Highlight" -> {"ratio" -> 2}, 
                "HighlightPoint" -> {"ratio" -> 2}, 
                "Droplines" -> {
                 "freeformCursorMode" -> True, 
                  "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
            "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
            None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}},
          PlotRange->{{-2, 2}, {-1, 1}},
          PlotRangeClipping->True,
          PlotRangePadding->NCache[{{
              Rational[1, 256], 
              Rational[1, 256]}, {
              Rational[1, 256], 
              Rational[1, 256]}}, {{0.00390625, 0.00390625}, {0.00390625, 
            0.00390625}}],
          Ticks->{{{-4., 
              FormBox[
               RowBox[{"-", "4.`"}], TraditionalForm]}, {-3.5, 
              FormBox[
               RowBox[{"-", "3.5`"}], TraditionalForm]}, {-3., 
              FormBox[
               RowBox[{"-", "3.`"}], TraditionalForm]}, {-2.5, 
              FormBox[
               RowBox[{"-", "2.5`"}], TraditionalForm]}, {-2., 
              FormBox[
               RowBox[{"-", "2.`"}], TraditionalForm]}, {-1.5, 
              FormBox[
               RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1., 
              FormBox[
               RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
              FormBox[
               RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
              FormBox["0.`", TraditionalForm]}, {0.5, 
              FormBox["0.5`", TraditionalForm]}, {1., 
              FormBox["1.`", TraditionalForm]}, {1.5, 
              FormBox["1.5`", TraditionalForm]}, {2., 
              FormBox["2.`", TraditionalForm]}, {2.5, 
              FormBox["2.5`", TraditionalForm]}, {3., 
              FormBox["3.`", TraditionalForm]}, {3.5, 
              FormBox["3.5`", TraditionalForm]}, {4., 
              FormBox["4.`", TraditionalForm]}}, {{-4., 
              FormBox[
               RowBox[{"-", "4.`"}], TraditionalForm]}, {-3.5, 
              FormBox[
               RowBox[{"-", "3.5`"}], TraditionalForm]}, {-3., 
              FormBox[
               RowBox[{"-", "3.`"}], TraditionalForm]}, {-2.5, 
              FormBox[
               RowBox[{"-", "2.5`"}], TraditionalForm]}, {-2., 
              FormBox[
               RowBox[{"-", "2.`"}], TraditionalForm]}, {-1.5, 
              FormBox[
               RowBox[{"-", "1.5`"}], TraditionalForm]}, {-1., 
              FormBox[
               RowBox[{"-", "1.`"}], TraditionalForm]}, {-0.5, 
              FormBox[
               RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
              FormBox["0.`", TraditionalForm]}, {0.5, 
              FormBox["0.5`", TraditionalForm]}, {1., 
              FormBox["1.`", TraditionalForm]}, {1.5, 
              FormBox["1.5`", TraditionalForm]}, {2., 
              FormBox["2.`", TraditionalForm]}, {2.5, 
              FormBox["2.5`", TraditionalForm]}, {3., 
              FormBox["3.`", TraditionalForm]}, {3.5, 
              FormBox["3.5`", TraditionalForm]}, {4., 
              FormBox["4.`", TraditionalForm]}}}]},
        {"\<\"(1 - mod(x, 1))^3.35*mod(1 + floor(-x), 2) + mod(x, \
1)^3.35*mod(1 + floor(x), 2)\"\>"},
        {"\<\"(1 - mod(x, 1))^3.35*mod(1 - ceiling(x), 2) + mod(x, \
1)^3.35*mod(1 + floor(x), 2)\"\>"}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Center}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"]},
    {""}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Center}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellLabel->
  "9/3/24 13:16:03 \
Out[6]=",ExpressionUUID->"aeeafc34-4d04-438f-b482-074faa48214d"]
}, Open  ]]
},
WindowSize->{1680, 984},
WindowMargins->{{-4, Automatic}, {Automatic, -4}},
FrontEndVersion->"12.2 for Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[All], TextAlignment -> Center, FontFamily -> 
    "Go Noto Africa Middle East", FontSize -> 10, FontWeight -> "Normal", 
    FontSlant -> "Plain", FontTracking -> "Plain", 
    FontVariations -> {"StrikeThrough" -> False, "Underline" -> False}]}, 
  Visible -> False, FrontEndVersion -> 
  "12.2 for Microsoft Windows (64-bit) (December 12, 2020)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"a85bbfc4-b31d-41b8-b2bc-7072c2a1a886"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 12210, 334, 290, "Input",ExpressionUUID->"32fbf20e-ca9a-443c-b482-3ff5cfb2baf3"],
Cell[12793, 358, 196570, 3327, 557, "Output",ExpressionUUID->"aeeafc34-4d04-438f-b482-074faa48214d"]
}, Open  ]]
}
]
*)

