precision mediump float;

uniform sampler2D textureSampler;

uniform float shaderVariable1; //X
uniform float shaderVariable2; //Y
uniform float shaderVariable3; //W
uniform float shaderVariable4; //X

varying vec2 textCord;
varying vec2 glPosition;

void main(){
	
	vec2 newTextCord = textCord;
	
	newTextCord.x *= shaderVariable3;
	newTextCord.y *= shaderVariable4;
	newTextCord.x += shaderVariable1;
	newTextCord.y += shaderVariable2;
	
	newTextCord.x = mod(newTextCord.x,1.0);
	newTextCord.y = mod(newTextCord.y,1.0);
	
	gl_FragColor = texture2D(textureSampler,newTextCord);
	
	//gl_FragColor = vec4(glPosition.x*0.5+0.5,glPosition.y*0.5+0.5,1.0,1.0);
	
}