precision mediump float;

uniform sampler2D textureSampler;	//original image

uniform float shaderVariable1;
uniform float shaderVariable2;
uniform float shaderVariable3;
uniform float shaderVariable4;

varying vec2 textCord;
varying vec2 visPosition;

const float GAMMA = 2.2;

vec4 vecpow(vec4 x, float y){
	
	return(vec4(pow(x.r,y),pow(x.g,y),pow(x.b,y),pow(x.a,y)));
	
}

float bloomImportance(vec4 color){
	
	const float THRESHOLD = 0.6;
	const vec3 colorWeights = vec3(0.299,0.587,0.114);
	//const vec3 colorWeights = vec3(1.0,0.5,1.0);
	
	float importance = length(color.rgb*colorWeights)/length(colorWeights);
	importance = max(importance-THRESHOLD,0.0);
	importance *= 1.0/(1.0-THRESHOLD);
	
	return(importance);
	
}

void main(){
	
	const float NORMAL_IMPORTANCE_MAX = 0.4;
	const float EXTREME_IMPORTANCE = 1.0;
	
	vec4 originalColor = vecpow(texture2D(textureSampler,textCord),GAMMA);
	
	float importance = bloomImportance(originalColor);
	
	importance *= NORMAL_IMPORTANCE_MAX;
	
	if(max(originalColor.r,max(originalColor.g,originalColor.b)) == EXTREME_IMPORTANCE){
		
		importance = EXTREME_IMPORTANCE;
		
	}
	
	vec4 outputColor = originalColor * importance;
	
	outputColor = vecpow(outputColor,1.0/GAMMA);
	outputColor.a = 1.0;
	
	gl_FragColor = outputColor;
	
}
