attribute vec4 vPosition;

uniform vec3 modelView[2];
uniform vec3 projection[2];

varying vec2 textCord;
varying vec2 glPosition;

const float playfieldW = 960.0;
const float playfieldH = 540.0;

void main(){
	
	textCord.x = vPosition.x;
	textCord.y = vPosition.y;
	textCord *= 1.0;
	
	vec2 modelViewApplied;
	modelViewApplied.x = dot(vec3(vPosition.x,vPosition.y,1.0),modelView[0]);
	modelViewApplied.y = dot(vec3(vPosition.x,vPosition.y,1.0),modelView[1]);
	
	
	vec2 projectionAplied;
	
	modelViewApplied.x = dot(vec3(modelViewApplied.x,modelViewApplied.y,1.0),projection[0]);
	modelViewApplied.y = dot(vec3(modelViewApplied.x,modelViewApplied.y,1.0),projection[1]);
	
	gl_Position.x = modelViewApplied.x;
	gl_Position.y = modelViewApplied.y;
	gl_Position.z = 0.0;
	gl_Position.w = 1.0;
	
	glPosition.x = modelViewApplied.x;
	glPosition.y = modelViewApplied.y;
	
}