precision mediump float;

uniform sampler2D textureSampler;

uniform float shaderVariable1; //Transition Time
uniform float shaderVariable2; //ScaleX
uniform float shaderVariable3; //ScaleY

varying vec2 textCord;
varying vec2 glPosition;

void main(){
	
	const float VALUE_SCALE = 0.25;
	
	//const float INV_NOISE_SIZE = 1.0/64.0;
	//float SCALE = 1.0/shaderVariable5;
	
	float correctedAlpha = sqrt(shaderVariable1);
	
	vec2 samplePosition = textCord;//textCord*(INV_NOISE_SIZE*SCALE);
	samplePosition.x *= shaderVariable2;
	samplePosition.y *= shaderVariable3;
	
	vec4 noise = texture2D(textureSampler,samplePosition);
	
	if(noise.r > correctedAlpha) discard;
	\
	vec4 outColor = vec4(24.0/255.0,230.0/255.0,89.0/255.0,correctedAlpha);
	outColor.rgb *= VALUE_SCALE*noise.g + (1.0-VALUE_SCALE);
	
	gl_FragColor = outColor;
	
}