precision mediump float;

uniform sampler2D textureSampler;

uniform float shaderVariable1;//Red
uniform float shaderVariable2;//Green
uniform float shaderVariable3;//Blue
uniform float shaderVariable4;//Tolerance

varying vec2 textCord;
varying vec2 visPosition;

void main(){
	
	float value = texture2D(textureSampler,textCord).r - 0.5;
	value *= shaderVariable4;
	value = clamp(value,0.0,1.0);
	
	gl_FragColor = vec4(shaderVariable1,shaderVariable2,shaderVariable3,value*texture2D(textureSampler,textCord).a);
	
}