precision mediump float;

uniform sampler2D textureSampler;

uniform float shaderVariable1;//Blur X
uniform float shaderVariable2;//Blur Y
uniform float shaderVariable3;//Alpha

varying vec2 textCord;
varying vec2 visPosition;

float invGaussianCDF(float cdfValue){
	
	//approximate the inverse CDF of a gaussian.
	
	//we use a function to approximate the inverse CDF for values 0.5-1.0 (1.0 is actually the inverse CDF value corresponding to ~2.0 standard deviations from the mean.)
	
	//first, map cdfValue to an x-cordinate of a point on the polynomial.
	//0.0-0.5 get mapped to 1.0-0.5 by reflection, then 0.5 is subtracted, then it's finally scaled so the max value is 0.882
	
	float polyX = abs(cdfValue-0.5)*(2.0*0.882);
	
	float polyResult;
	
	//the main polynomial only concerns itself with values greater than 0.5. we use a separate, simpler polynoimial for values between 0.0 and 0.5
	
	if(polyX > 0.5){
		
		//polynoimial constants, starting with a*x, then b*x^2, etc.
		const float polyConstant0 = 0.55376707791;
		const float polyConstant1 = 1.21383824396;
		const float polyConstant2 = -3.35581625993;
		const float polyConstant3 = 100.15521335;
		const float polyConstant4 = -536.892502393;
		const float polyConstant5 = 889.776842371;
		
		polyX -= 0.5;
		
		float powX = 1.0;
		
		polyResult = polyConstant0;
		powX *= polyX;
		polyResult += powX * polyConstant1;
		powX *= polyX;
		polyResult += powX * polyConstant2;
		powX *= polyX;
		polyResult += powX * polyConstant3;
		powX *= polyX;
		polyResult += powX * polyConstant4;
		powX *= polyX;
		polyResult += powX * polyConstant5;
		
		/*float powX = 1.0;
		
		float polyResult = -0.838813;
		powX *= polyX;
		polyResult += powX*2.71418;*/
		
	}else{
		
		//fit to a quadratic between (0.0,0.0) and (0.5,0.5538)
		
		polyResult = polyX;
		polyX *= polyX;
		polyResult += polyX*(1.0/(0.5*0.5))*(0.5538-0.5);
		
	}
	
	//flip the output depending on what side of the deviation we're sampling, then we're done!
	
	if(cdfValue > 0.5){
		
		return(polyResult);
		
	}else{
		
		return(-polyResult);
		
	}
	
	return(polyResult);
	
}

vec3 vecpow(vec3 x, float y){
	
	return(vec3(pow(x.r,y),pow(x.g,y),pow(x.b,y)));
	
}

vec4 vecpow(vec4 x, float y){
	
	return(vec4(pow(x.r,y),pow(x.g,y),pow(x.b,y),pow(x.a,y)));
	
}

const float GAMMA = 2.2;

vec3 sample(float gaussianSample){
	
	vec2 off = vec2(shaderVariable1,shaderVariable2);
	
	off *= gaussianSample;
	
	vec3 bloomSample = vecpow(texture2D(textureSampler,textCord+off).rgb,GAMMA);
	
	return(bloomSample);
	
}

void main(){
	
	vec3 bloomAvg = vec3(0.0);
	
	const int NUM_SAMPLES = 9;
	
	/*for(int i = 0; i < NUM_SAMPLES; i++){
		
		vec2 off = vec2(shaderVariable1,shaderVariable2);
		
		//off *= invGaussianCDF(float(i)/float(NUM_SAMPLES));
		off *= invGaussianCDF(float(i+1)/float(NUM_SAMPLES+2));
		
		vec4 bloomSample = vecpow(texture2D(textureSampler,textCord+off),GAMMA);
		
		bloomAvg += bloomSample;
		
	}*/
	
	/*bloomAvg += sample(-1.07);
	bloomAvg += sample(-0.57);
	bloomAvg += sample(-0.18);
	bloomAvg += sample(0.18);
	bloomAvg += sample(0.57);
	bloomAvg += sample(1.07);*/
	
	bloomAvg += sample(-1.5932188180230502);
	bloomAvg += sample(-0.9674215661017014);
	bloomAvg += sample(-0.5894557978497785);
	bloomAvg += sample(-0.2822161470625081);
	bloomAvg += sample(0.0);
	bloomAvg += sample(0.2822161470625081);
	bloomAvg += sample(0.5894557978497785);
	bloomAvg += sample(0.9674215661017014);
	bloomAvg += sample(1.5932188180230502);
	
	
	bloomAvg *= (1.0/float(NUM_SAMPLES));
	bloomAvg = vecpow(bloomAvg,1.0/GAMMA);
	
	gl_FragColor = vec4(bloomAvg.r,bloomAvg.g,bloomAvg.b,shaderVariable3);
	
}