precision mediump float;

uniform sampler2D textureSampler;	//original image
uniform sampler2D textureSampler2;	//blurred image

uniform float shaderVariable1;//Bloom ammount
uniform float shaderVariable2;//Color ramp slope
uniform float shaderVariable3;//Color ramp offset
uniform float shaderVariable4;

varying vec2 textCord;
varying vec2 visPosition;

vec3 vecpow(vec3 x, float y){
	
	return(vec3(pow(x.r,y),pow(x.g,y),pow(x.b,y)));
	
}

vec4 vecpow(vec4 x, float y){
	
	return(vec4(pow(x.r,y),pow(x.g,y),pow(x.b,y),pow(x.a,y)));
	
}

const float GAMMA = 2.2;

float sum(vec3 x){
	
	return(x.r+x.g+x.b);
	
}

vec3 clampToWhite(vec3 color){
	
	const float MIN_VALUE = 0.1;
	
	if(length(color) < MIN_VALUE){
		
		return(color);
		
	}
	
	vec3 clamped = clamp(color,0.0,1.0);
	
	clamped *= max(MIN_VALUE,length(color))/length(clamped);
	
	clamped = clamp(color,clamped,vec3(1.0));
	
	return(clamped);
	
}

vec3 oldColorCurve(vec3 inputColor, float slope, float offset){
	
	//apply color curve 
	//note that we take special care to preserve dark values
	
	vec3 curvedColor = inputColor;
	curvedColor.rgb *= slope;
	curvedColor.rgb += offset;
	return(mix(inputColor,curvedColor,min(10.0*(inputColor.r,inputColor.g,inputColor.b),1.0)));
	
}

vec3 colorCurve(vec3 inputColor, float slope, float offset){
	
	//apply color curve
	
	const float EPSILON = 1e-3;
	
	const float THRESHOLD = 0.6;
	const vec3 colorWeights = vec3(0.299,0.587,0.114);
	
	float lum = sum(inputColor.rgb*colorWeights)/sum(colorWeights);
	
	vec3 belowValue = inputColor.rgb*(THRESHOLD/max(THRESHOLD,lum));
	vec3 aboveValue = inputColor.rgb-belowValue;
	
	vec3 outputColor = belowValue+aboveValue*slope;
	
	outputColor *= max(length(outputColor)+offset,EPSILON)/max(length(outputColor),EPSILON);
	outputColor = mix(inputColor.rgb,outputColor,min(lum*(0.5/(abs(offset)+EPSILON)),1.0));
	
	return(outputColor);
	
}

vec3 blendBlurred(vec3 original, vec3 blur, float strength){
	
	const float BLUR_BLEND_MUL = 3.0;
	const float BLUR_TARGET_MUL = 0.3;
	
	const float EPSILON = 0.001;
	
	const vec3 colorWeights = vec3(0.299,0.587,0.114);
	
	vec3 blendedColor = original + (blur * (strength*BLUR_BLEND_MUL));
	
	float ogLum = sum(original*colorWeights);
	float blurLum = sum(blur*colorWeights);
	float blendedLum = sum(blendedColor*colorWeights);
	
	float targetLum = ogLum + BLUR_TARGET_MUL*blurLum;
	//float targetLum = ogLum;
	
	blendedColor *= (targetLum+EPSILON)/(blendedLum+EPSILON);
	
	return(blendedColor);
	
}

void main(){
	
	vec4 originalColor = vecpow(texture2D(textureSampler,textCord),GAMMA);
	
	vec4 blurColor = vecpow(texture2D(textureSampler2,textCord),GAMMA);
	
	//vec3 outputColor = originalColor + (blurColor * shaderVariable1);
	vec3 outputColor = blendBlurred(originalColor.rgb,blurColor.rgb,shaderVariable1);
	outputColor = clampToWhite(colorCurve(outputColor,shaderVariable2,shaderVariable3));
	
	outputColor = vecpow(outputColor,1.0/GAMMA);
	
	gl_FragColor = vec4(outputColor.r,outputColor.g,outputColor.b,1.0);
	
}