precision mediump float;

uniform sampler2D textureSampler;
uniform sampler2D textureSampler2;

uniform float shaderVariable1; //Lightness Scale
uniform float shaderVariable2; //ScaleX
uniform float shaderVariable3; //ScaleY
uniform float shaderVariable4;

varying vec2 textCord;
varying vec2 visPosition;

float invGaussianCDF(float cdfValue){
	
	//approximate the inverse CDF of a gaussian.
	
	//we use a function to approximate the inverse CDF for values 0.5-1.0 (1.0 is actually the inverse CDF value corresponding to ~2.0 standard deviations from the mean.)
	
	//first, map cdfValue to an x-cordinate of a point on the polynomial.
	//0.0-0.5 get mapped to 1.0-0.5 by reflection, then 0.5 is subtracted, then it's finally scaled so the max value is 0.882
	
	float polyX = abs(cdfValue-0.5)*(2.0*0.882);
	
	float polyResult;
	
	//the main polynomial only concerns itself with values greater than 0.5. we use a separate, simpler polynoimial for values between 0.0 and 0.5
	
	if(polyX > 0.5){
		
		//polynoimial constants, starting with a*x, then b*x^2, etc.
		const float polyConstant0 = 0.55376707791;
		const float polyConstant1 = 1.21383824396;
		const float polyConstant2 = -3.35581625993;
		const float polyConstant3 = 100.15521335;
		const float polyConstant4 = -536.892502393;
		const float polyConstant5 = 889.776842371;
		
		polyX -= 0.5;
		
		float powX = 1.0;
		
		polyResult = polyConstant0;
		powX *= polyX;
		polyResult += powX * polyConstant1;
		powX *= polyX;
		polyResult += powX * polyConstant2;
		powX *= polyX;
		polyResult += powX * polyConstant3;
		powX *= polyX;
		polyResult += powX * polyConstant4;
		powX *= polyX;
		polyResult += powX * polyConstant5;
		
		/*float powX = 1.0;
		
		float polyResult = -0.838813;
		powX *= polyX;
		polyResult += powX*2.71418;*/
		
	}else{
		
		//fit to a quadratic between (0.0,0.0) and (0.5,0.5538)
		
		polyResult = polyX;
		polyX *= polyX;
		polyResult += polyX*(1.0/(0.5*0.5))*(0.5538-0.5);
		
	}
	
	//flip the output depending on what side of the deviation we're sampling, then we're done!
	//NOTE: we actually don't do that here, since we use the value we return to scale an arbitrary direction.
	//always returning a positive result is better.
	
	/*if(cdfValue > 0.5){
		
		return(polyResult);
		
	}else{
		
		return(-polyResult);
		
	}*/
	
	return(polyResult);
	
}

vec2 warpCord(vec2 inCord, float scale){
	
	const float EPSILON = 1e-7;
	
	vec2 warped = inCord;
	
	//const float scale = 0.01;
	//const float scale = 0.04;
	const float INV_NOISE_SIZE = 1.0/64.0;
	
	vec2 sampleCord = gl_FragCoord.xy;
	
	if(shaderVariable2 != 1.0 || shaderVariable3 != 1.0){
		
		sampleCord.x *= shaderVariable2;
		sampleCord.y *= shaderVariable3;
		sampleCord = floor(sampleCord);
		
		vec2 adjustedCord = sampleCord;
		adjustedCord.x /= shaderVariable2;
		adjustedCord.y /= shaderVariable3;
		warped *= ((adjustedCord)/(gl_FragCoord.xy));
		
	}
	
	sampleCord *= INV_NOISE_SIZE;
	
	vec3 noiseSample = texture2D(textureSampler2,sampleCord).rgb;
	noiseSample.rg -= 0.5;
	
	//treat rg of noise sample as direction, b as input into inv gaussian to get magnitude.
	
	//warped += scale*2.0*noiseSample.rg;
	warped += scale*normalize(noiseSample.rg)*invGaussianCDF(noiseSample.b);
	
	return(warped);
	
}

vec4 vecpow(vec4 x, float y){
	
	return(vec4(pow(x.r,y),pow(x.g,y),pow(x.b,y),pow(x.a,y)));
	
}

const float GAMMA = 2.2;

void main(){
	
	/*float PI = 3.14159;
	
	float RADIUS = 0.02;
	
	vec4 colAvg = vecpow(texture2D(textureSampler,textCord),GAMMA);
	
	for(int i = 0; i < 6; i++){
		
		float rad = (PI*2.0)*float(i);
		rad *= (1.0/6.0);
		
		vec2 off = vec2(sin(rad),cos(rad));
		
		off *= RADIUS;
		
		colAvg += vecpow(texture2D(textureSampler,textCord+off),GAMMA);
		
	}
	
	colAvg *= (1.0/7.0);
	
	//fade out edges
	
	vec2 centeredCord = textCord - 0.5;
	float edgeFactor = clamp(1.5-length(centeredCord)*3.0,0.0,1.0);
	
	colAvg.rgb *= edgeFactor;
	colAvg.rgb += 1.0-edgeFactor;
	
	gl_FragColor = vecpow(colAvg,1.0/GAMMA);*/
	
	//const float SCALE_FACTOR = 0.08;
	
	const float SCALE_FACTOR = 0.08;
	
	vec4 sampledColor = texture2D(textureSampler,warpCord(textCord,max(0.5,length(textCord-0.5))*SCALE_FACTOR));
	sampledColor.rgb *= shaderVariable1;
	gl_FragColor = sampledColor;
	
}