/*
 * $Id: StringBuffer.h,v 1.4 2007/08/18 08:52:18 maya Exp $
 */

#ifndef _YCL_STRINGBUFFER_H_
#define _YCL_STRINGBUFFER_H_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <YCL/common.h>

#include <YCL/String.h>

#include <malloc.h>

namespace yebisuya {

// ϒ̕߂̃NXB
class StringBuffer {
private:
	// i[obt@B
	char* buffer;
	// ݗLȕ̒B
	size_t validLength;
	// obt@̑傫B
	size_t bufferSize;
	enum {
		// obt@LۂɎgpTCYB
		INIT_CAPACITY = 16,
	};
	// obt@B
	// :
	//	source	B
	//	length	̒B
	//	capacity	obt@̏TCYB
	void init(const char* source, size_t length, size_t capacity) {
		if ((capacity != 0 || length != 0) && capacity < length + INIT_CAPACITY)
			capacity = length + INIT_CAPACITY;
		validLength = length;
		bufferSize = capacity;
		if (bufferSize == 0) {
			buffer = NULL;
		}else{
			buffer = new char[bufferSize];
		}
		memcpy(buffer, source, validLength);
		memset(buffer + validLength, '\0', bufferSize - validLength);
	}
public:
	// ftHgRXgN^B
	StringBuffer() {
		init(NULL, 0, 0);
	}
	// obt@̏TCYw肷RXgN^B
	// :
	//	capacity obt@̏TCYB
	StringBuffer(size_t capacity) {
		init(NULL, 0, capacity);
	}
	// obt@̏w肷RXgN^B
	// :
	//	source	B
	StringBuffer(const char* source) {
		init(source, strlen(source), 0);
	}
	// Rs[RXgN^B
	// :
	//	source	B
	StringBuffer(const StringBuffer& source) {
		init(source.buffer, source.validLength, source.bufferSize);
	}
	// fXgN^B
	~StringBuffer() {
		delete[] buffer;
	}

	// ݗLȕ̒擾B
	// Ԓl:
	//	Lȕ̒B
	size_t length()const {
		return validLength;
	}
	// obt@̃TCY擾B
	// Ԓl:
	//	obt@̃TCYB
	size_t capacity()const {
		return bufferSize;
	}
	// obt@̃TCYw̒܂悤ɒ߂B
	// :
	//	newLength	߂钷B
	void ensureCapacity(size_t newLength) {
		if (bufferSize < newLength) {
			char* oldBuffer = buffer;
			init(oldBuffer, validLength, newLength + INIT_CAPACITY);
			delete[] oldBuffer;
		}
	}
	// Lȕ񒷂ύXB
	// :
	//	newLength	V񒷁B
	void setLength(size_t newLength) {
		if (validLength < newLength)
			ensureCapacity(newLength);
		validLength = newLength;
	}
	// ẅʒu̕擾B
	// :
	//	index	̈ʒuB
	// Ԓl:
	//	ẅʒu̕B
	char charAt(size_t index)const {
		return index >= 0 && index < validLength ? buffer[index] : '\0';
	}
	// ẅʒu̕擾B
	// :
	//	index	̈ʒuB
	// Ԓl:
	//	ẅʒu̎̕QƁB
	char& charAt(size_t index) {
		if (index < 0) {
			index = 0;
		}else if (index >= validLength) {
			ensureCapacity(validLength + 1);
			index = validLength++;
		}
		return buffer[index];
	}
	// ẅʒu̕ύXB
	// :
	//	index	ύX镶̈ʒuB
	//	chr	ύX镶B
	void setCharAt(int index, char chr) {
		charAt(index) = chr;
	}
	// ǉB
	// :
	//	chr	ǉ镶B
	// Ԓl:
	//	ǉʁB
	StringBuffer& append(char chr) {
		charAt(validLength) = chr;
		return *this;
	}
	// ǉB
	// :
	//	source	ǉ镶B
	// Ԓl:
	//	ǉʁB
	StringBuffer& append(const char* source) {
		return append(source, strlen(source));
	}
	// ǉB
	// :
	//	source	ǉ镶B
	//	length	ǉ镶̒B
	// Ԓl:
	//	ǉʁB
	StringBuffer& append(const char* source, size_t length) {
		size_t oldLength = validLength;
		ensureCapacity(validLength + length);
		memcpy(buffer + oldLength, source, length);
		validLength += length;
		return *this;
	}
	// ẅʒu̕폜B
	// :
	//	start	폜ʒuB
	// Ԓl:
	//	폜ʁB
	StringBuffer& remove(size_t index) {
		return remove(index, index + 1);
	}
	// ẅʒu̕폜B
	// :
	//	start	폜擪ʒuB
	//	end	폜ÏʒuB
	// Ԓl:
	//	폜ʁB
	StringBuffer& remove(size_t start, size_t end) {
		if (start <= 0)
			start = 0;
		if (start < end) {
			if (end < validLength){
				memcpy(buffer + start, buffer + end, validLength - end);
				validLength -= end - start;
			}else{
				validLength = start;
			}
		}
		return *this;
	}
	// ẅʒu̕uB
	// :
	//	start	u擪ʒuB
	//	end	uÏʒuB
	//	source	u镶B
	// Ԓl:
	//	uʁB
	StringBuffer& replace(size_t start, size_t end, const char* source) {
		if (start < 0)
			start = 0;
		if (end > validLength)
			end = validLength;
		if (start < end) {
			size_t length = strlen(source);
			size_t oldLength = validLength;
			ensureCapacity(validLength += length - (end - start));
			memcpy(buffer + start + length, buffer + end, oldLength - end);
			memcpy(buffer + start, source, length);
		}
		return *this;
	}
	// ẅʒu̕擾B
	// :
	//	start	擾镶̐擪ʒuB
	// Ԓl:
	//	ẅʒu̕B
	String substring(size_t index)const {
		if (index < 0)
			index = 0;
		return String(buffer + index, validLength - index);
	}
	// ẅʒu̕擾B
	// :
	//	start	擾镶̐擪ʒuB
	//	end	擾镶̏ÏʒuB
	// Ԓl:
	//	ẅʒu̕B
	String substring(size_t start, size_t end)const {
		if (start < 0)
			start = 0;
		if (end > validLength)
			end = validLength;
		return String(buffer + start, end - start);
	}
	// ẅʒuɕ}B
	// :
	//	index	}ʒuB
	//	source	}镶B
	// Ԓl:
	//	}ʁB
	StringBuffer& insert(size_t index, char chr) {
		return insert(index, &chr, 1);
	}
	// ẅʒuɕ}B
	// :
	//	index	}ʒuB
	//	source	}镶B
	// Ԓl:
	//	}ʁB
	StringBuffer& insert(size_t index, const char* source) {
		return insert(index, source, strlen(source));
	}
	// ẅʒuɕ}B
	// :
	//	index	}ʒuB
	//	source	}镶B
	//	length	̒B
	// Ԓl:
	//	}ʁB
	StringBuffer& insert(size_t index, const char* source, size_t length) {
		if (index < 0)
			index = 0;
		else if (index >= validLength)
			index = validLength;
		size_t oldLength = validLength;
		ensureCapacity(validLength + length);
		char* temp = (char*) alloca(oldLength - index);
		memcpy(temp, buffer + index, oldLength - index);
		memcpy(buffer + index, source, length);
		memcpy(buffer + index + length, temp, oldLength - index);
		validLength += length;
		return *this;
	}
	// 𔽓]B
	// Ԓl:
	//	]ʁB
	StringBuffer& reverse() {
		char* temporary = (char*) alloca(sizeof (char) * validLength);
		char* dst = temporary + validLength;
		char* src = buffer;
		while (temporary < dst) {
			if (String::isLeadByte(*src)) {
				char pre = *src++;
				*--dst = *src++;
				*--dst = pre;
			}else{
				*--dst = *src++;
			}
		}
		memcpy(buffer, temporary, validLength);
		return *this;
	}
	// 擾B
	// Ԓl:
	//	ݐݒ肳Ă镶B
	String toString()const {
		return String(buffer, validLength);
	}

	// ꕶ̕ɕύXB
	// :
	//	ύXꕶB
	// Ԓl:
	//	ύXʁB
	StringBuffer& set(char chr) {
		ensureCapacity(1);
		buffer[0] = chr;
		validLength = 1;
		return *this;
	}
	// w̕ɕύXB
	// :
	//	source	ύX镶B
	// Ԓl:
	//	ύXʁB
	StringBuffer& set(const char* source) {
		size_t length = strlen(source);
		ensureCapacity(validLength = length);
		memcpy(buffer, source, length);
		return *this;
	}

	// char*ɕϊLXgZqB
	// obt@̃AhX擾B
	// Ԓl:
	//	obt@̃AhXB
	operator char*() {
		return buffer;
	}
	// StringɕϊLXgZqB
	// 擾B
	// Ԓl:
	//	ݐݒ肳Ă镶B
	operator String()const {
		return toString();
	}
	// ZqB
	// ꕶ̕ɕύXB
	// :
	//	ch	ύXꕶB
	// Ԓl:
	//	ʁB
	StringBuffer& operator=(char ch) {
		return set(ch);
	}
	// ZqB
	// w̕ɕύXB
	// :
	//	source	ύX镶B
	// Ԓl:
	//	ʁB
	StringBuffer& operator=(const char* source) {
		return set(source);
	}
	// AZqB
	// ǉB
	// :
	//	ch	ǉ镶B
	// Ԓl:
	//	ʁB
	StringBuffer& operator+=(char ch) {
		return append(ch);
	}
	// AZqB
	// ǉB
	// :
	//	source	ǉ镶B
	// Ԓl:
	//	ʁB
	StringBuffer& operator+=(const char* source) {
		return append(source);
	}
};

}

#endif//_YCL_STRINGBUFFER_H_
