/*
 * $Id: String.h,v 1.4 2007/08/18 08:52:18 maya Exp $
 */

#ifndef _YCL_STRING_H_
#define _YCL_STRING_H_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <YCL/common.h>

#include <string.h>

namespace yebisuya {

// ̊ǗEsNXB
class String {
private:
	// i[obt@B
	// ̑Oɂ͎QƃJE^A
	// j̍ۂɂ͂ύXB
	const char* string;

	// utilities
	// i[obt@쐬B
	// ƎQƃJE^̗̈̕mۂB
	// QƃJE^0ɂȂĂB
	// :
	//	length ̒B
	// Ԓl:
	//	쐬obt@̕񕔂̃AhXB
	static char* createBuffer(size_t length) {
		size_t* count = (size_t*) new unsigned char[sizeof (size_t) + sizeof (char) * (length + 1)];
		*count = 0;
		return (char*) (count + 1);
	}
	// i[obt@쐬B
	// :
	//	source i[镶B
	// Ԓl:
	//	쐬obt@̕񕔂̃AhXB
	static const char* create(const char* source) {
		return source != NULL ? create(source, strlen(source)) : NULL;
	}
	// i[obt@쐬B
	// :
	//	source i[镶B
	//	length ̒B
	// Ԓl:
	//	쐬obt@̕񕔂̃AhXB
	static const char* create(const char* source, size_t length) {
		if (source != NULL) {
			char* buffer = createBuffer(length);
			memcpy(buffer, source, length);
			buffer[length] = '\0';
			return buffer;
		}
		return NULL;
	}
	// ̕Ai[obt@쐬B
	// :
	//	str1 A镶(O)B
	//	str2 A镶()B
	// Ԓl:
	//	쐬obt@̕񕔂̃AhXB
	static const char* concat(const char* str1, const char* str2) {
		size_t len1 = strlen(str1);
		size_t len2 = strlen(str2);
		char* buffer = createBuffer(len1 + len2);
		memcpy(buffer, str1, len1);
		memcpy(buffer + len1, str2, len2);
		buffer[len1 + len2] = '\0';
		return buffer;
	}
	// private methods
	// QƃJE^炵A0ɂȂobt@jB
	void release() {
		if (string != NULL) {
			size_t* count = (size_t*) string - 1;
			if (--*count == 0)
				delete[] (unsigned char*) count;
		}
	}
	// QƃJE^𑝂₷B
	void add() {
		if (string != NULL) {
			size_t* count = (size_t*) string - 1;
			++*count;
		}
	}
	// ʂ̃obt@ƒuB
	// ̃obt@̎QƃJE^炵A
	// Vobt@̎QƃJE^𑝂₷B
	// :
	//	source uVobt@B
	void set(const char* source) {
		if (string != source) {
			release();
			string = source;
			add();
		}
	}
public:
	// constructor
	// ftHgRXgN^B
	// NULLĂ̂ŁÂ܂܂ŕ񑀍삷ƃANZXᔽɂȂ̂ŒӁB
	String():string(NULL) {
	}
	// ̕w肷RXgN^B
	// :
	//	source ̕B
	String(const char* source):string(NULL) {
		set(create(source));
	}
	// ̕𒷂tŎw肷RXgN^B
	// :
	//	source ̕B
	//	length ̒B
	String(const char* source, size_t length):string(NULL) {
		set(create(source, length));
	}
	// Rs[RXgN^B
	// :
	//	source ̕B
	String(const String& source):string(NULL) {
		set(source.string);
	}
	// ̕ARXgN^B
	// :
	//	str1 OɂȂ镶B
	//	str2 ɂȂ镶B
	String(const char* str1, const char* str2):string(NULL) {
		set(concat(str1, str2));
	}
	// ̕ARXgN^B
	// :
	//	str1 OɂȂ镶B
	//	str2 ɂȂ镶B
	String(const String& str1, const char* str2):string(NULL) {
		set(*str2 != '\0' ? concat(str1.string, str2) : str1.string);
	}
	// destructor
	// fXgN^B
	// h邱Ƃ͍lĂȂ̂ŉz֐ɂ͂ȂB
	~String() {
		release();
	}
	// public methods
	// ̌̕Ɏw̕AB
	// :
	//	source A镶B
	// Ԓl:
	//	AꂽB
	String concat(const char* source)const {
		return String(*this, source);
	}
	// Ƃ̔rsB
	// NULLƂrłB
	// :
	//	str r镶B
	// Ԓl:
	//	0Astr̕傫ΕAΐB
	int compareTo(const char* str)const {
		if (str == NULL)
			return string == NULL ? 0 : 1;
		else if (string == NULL)
			return -1;
		return strcmp(string, str);
	}
	// Ƃ̔r啶̋ʂȂōsB
	// NULLƂrłB
	// :
	//	str r镶B
	// Ԓl:
	//	0Astr̕傫ΕAΐB
	int compareToIgnoreCase(const char* str)const {
		if (str == NULL)
			return string == NULL ? 0 : 1;
		else if (string == NULL)
			return -1;
		return _stricmp(string, str);
	}
	// Ƃ̔rsB
	// NULLƂrłB
	// :
	//	str r镶B
	// Ԓl:
	//	ΐ^B
	bool equals(const char* str)const {
		return compareTo(str) == 0;
	}
	// Ƃ̔r啶̋ʂȂōsB
	// NULLƂrłB
	// :
	//	str r镶B
	// Ԓl:
	//	ΐ^B
	bool equalsIgnoreCase(const char* str)const {
		return compareToIgnoreCase(str) == 0;
	}
	// w肳ꂽŎn܂Ă邩ǂ𔻒肷B
	// :
	//	str r镶B
	// Ԓl:
	//	w肳ꂽŎn܂Ăΐ^B
	bool startsWith(const char* str)const {
		return startsWith(str, 0);
	}
	// ẅʒuw肳ꂽŎn܂Ă邩ǂ𔻒肷B
	// :
	//	str r镶B
	// Ԓl:
	//	w肳ꂽŎn܂Ăΐ^B
	bool startsWith(const char* str, int offset)const {
		return strncmp(string, str, strlen(str)) == 0;
	}
	// w肳ꂽŏIĂ邩ǂ𔻒肷B
	// :
	//	str r镶B
	// Ԓl:
	//	w肳ꂽŏIĂΐ^B
	// 
	bool endsWith(const char* str)const {
		size_t str_length = strlen(str);
		size_t string_length = length();
		if (string_length < str_length)
			return false;
		return strcmp(string + string_length - str_length, str) == 0;
	}
	// w̕ǂ̈ʒuɂ邩TB
	// :
	//	chr TB
	// Ԓl:
	//	̌CfbNXBȂ-1B
	int indexOf(char chr)const {
		return indexOf(chr, 0);
	}
	// w̕ǂ̈ʒuɂ邩ẅʒuTB
	// :
	//	chr TB
	//	from Tn߂ʒuB
	// Ԓl:
	//	̌CfbNXBȂ-1B
	int indexOf(char chr, size_t from)const {
		if (from < 0)
			from = 0;
		else if (from >= length())
			return -1;
		const char* found = strchr(string + from, chr);
		if (found == NULL)
			return -1;
		return found - string;
	}
	// w̕񂪂ǂ̈ʒuɂ邩TB
	// :
	//	str TB
	// Ԓl:
	//	̌CfbNXBȂ-1B
	int indexOf(const char* str)const {
		return indexOf(str, 0);
	}
	// w̕񂪂ǂ̈ʒuɂ邩ẅʒuTB
	// :
	//	str TB
	//	from Tn߂ʒuB
	// Ԓl:
	//	̌CfbNXBȂ-1B
	// 
	int indexOf(const char* str, size_t from)const {
		if (from < 0)
			from = 0;
		else if (from >= length())
			return -1;
		const char* found = strstr(string + from, str);
		if (found == NULL)
			return -1;
		return found - string;
	}
	// ̒ԂB
	size_t length()const {
		return strlen(string);
	}
	// w̕ŌɌʒu擾B
	// :
	//	chr TB
	// Ԓl:
	//	̌CfbNXBȂ-1B
	int lastIndexOf(char chr)const {
		return lastIndexOf(chr, (size_t) -1);
	}
	// w̕ẅʒuOōŌɌʒu擾B
	// :
	//	chr TB
	//	from Tn߂ʒuB
	// Ԓl:
	//	̌CfbNXBȂ-1B
	int lastIndexOf(char chr, size_t from)const {
		size_t len = length();
		if (from > len - 1)
			from = len - 1;
		const char* s = string;
		const char* end = string + from;
		const char* found = NULL;
		while (*s != '0' && s <= end) {
			if (*s == chr)
				found = s;
			if (isLeadByte(*s))
				s++;
			s++;
		}
		return found != NULL ? found - string : -1;
	}
	// w̕񂪍ŌɌʒu擾B
	// :
	//	str TB
	// Ԓl:
	//	̌CfbNXBȂ-1B
	int lastIndexOf(const char* str)const {
		return lastIndexOf(str, (size_t) -1);
	}
	// w̕񂪎ẅʒuOōŌɌʒu擾B
	// :
	//	str TB
	//	from Tn߂ʒuB
	// Ԓl:
	//	̌CfbNXBȂ-1B
	int lastIndexOf(const char* str, size_t from)const {
		size_t len = length();
		size_t str_len = strlen(str);
		if (from > len - str_len)
			from = len - str_len;
		const char* s = string + from;
		while (s >= string) {
			if (strncmp(s, str, str_len) == 0)
				return s - string;
			s--;
		}
		return -1;
	}
	// ̈ꕔoB
	// :
	//	start o̐擪̈ʒuB
	// Ԓl:
	//	̈ꕔB
	String substring(int start)const {
		return String(string + start);
	}
	// ̈ꕔoB
	// :
	//	start o̐擪̈ʒuB
	//	end ǒ̈ʒuB
	// Ԓl:
	//	̈ꕔB
	String substring(int start, int end)const {
		return String(string + start, end - start);
	}
	// ẅʒuɂ镶oB
	// :
	//	index öʒuB
	// Ԓl:
	//	ẅʒuɂ镶B
	char charAt(size_t index)const {
		return index >= 0 && index < length() ? string[index] : '\0';
	}
	// w̕w̕ɒu܂B
	// :
	//	oldChr ̕B
	//	newChr u镶B
	// Ԓl:
	//	u̕B
	String replace(char oldChr, char newChr)const {
		String result(string);
		char* s = (char*) result.string;
		while (*s != '\0'){
			if (String::isLeadByte(*s))
				s++;
			else if (*s == oldChr)
				*s = newChr;
			s++;
		}
		return result;
	}
	// 񒆂̑啶ɕϊB
	// Ԓl:
	//	ϊ̕B
	String toLowerCase()const {
		String result(string);
		char* s = (char*) result.string;
		while (*s != '\0'){
			if (String::isLeadByte(*s))
				s++;
			else if ('A' <= *s && *s <= 'Z')
				*s += 'a' - 'A';
			s++;
		}
		return result;
	}
	// 񒆂̏啶ɕϊB
	// Ԓl:
	//	ϊ̕B
	String toUpperCase()const {
		String result(string);
		char* s = (char*) result.string;
		while (*s != '\0'){
			if (String::isLeadByte(*s))
				s++;
			else if ('a' <= *s && *s <= 'z')
				*s += 'A' - 'a';
			s++;
		}
		return result;
	}
	// ̑Ő󔒕폜B
	// Ԓl:
	//	폜̕B
	String trim()const {
		const char* s = string;
		while (*s != '\0' && (unsigned char) *s <= ' ')
			s++;
		const char* start = s;
		s = string + length();
		while (s > start && (*s != '\0' && (unsigned char) *s <= ' '))
			s--;
		return String(start, s - start);
	}

	// operators

	// const char*ւ̃LXgZq
	// Ԓl:
	//	ւ̃AhXB
	operator const char*()const {
		return string;
	}
	// charẑ悤Ɉ߂[]ZqB
	// :
	//	index 擾镶̃CfbNXB
	// Ԓl:
	//	w̃CfbNXɂ镶B
	char operator[](size_t index)const {
		return charAt(index);
	}
	// A邽߂+ZqB
	// :
	//	source A镶B
	// Ԓl:
	//	AB
	String operator+(const char* source)const {
		return String(string, source);
	}
	// A邽߂+ZqB
	// :
	//	source A镶B
	// Ԓl:
	//	AB
	String operator+(const String& source)const {
		return *string != '\0' ? String(string, source.string) : source;
	}
	// A邽߂+ZqB
	// :
	//	str1 A镶(O)B
	//	str2 A镶()B
	// Ԓl:
	//	AB
	friend String operator+(const char* str1, const String& str2) {
		return *str1 != '\0' ? String(str1, str2.string) : str2;
	}
	// ZqB
	// :
	//	source 镶B
	// Ԓl:
	//	ʁB
	String& operator=(const char* source) {
		set(create(source));
		return *this;
	}
	// ZqB
	// :
	//	source 镶B
	// Ԓl:
	//	ʁB
	String& operator=(const String& source) {
		set(source.string);
		return *this;
	}
	// Aʂ鉉ZqB
	// :
	//	source A镶B
	// Ԓl:
	//	AʁB
	String& operator+=(const char* source) {
		if (*source != '\0')
			set(concat(string, source));
		return *this;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕ΐ^B
	bool operator==(const String& str)const {
		return compareTo(str.string) == 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕ΐ^B
	bool operator==(const char* str)const {
		return compareTo(str) == 0;
	}
	// rZqB
	// :
	//	str1 r镶B
	//	str2 r镶B
	// Ԓl:
	//	str1str2̕ΐ^B
	friend bool operator==(const char* str1, const String& str2) {
		return str2.compareTo(str1) == 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕Ȃΐ^B
	bool operator!=(const String& str)const {
		return compareTo(str) != 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕Ȃΐ^B
	bool operator!=(const char* str)const {
		return compareTo(str) != 0;
	}
	// rZqB
	// :
	//	str1 r镶B
	//	str2 r镶B
	// Ԓl:
	//	str1str2̕Ȃΐ^B
	friend bool operator!=(const char* str1, const String& str2) {
		return str2.compareTo(str1) != 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕傫ΐ^B
	bool operator<(const String& str)const {
		return compareTo(str) < 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕傫ΐ^B
	bool operator<(const char* str)const {
		return compareTo(str) < 0;
	}
	// rZqB
	// :
	//	str1 r镶B
	//	str2 r镶B
	// Ԓl:
	//	str1str2̕傫ΐ^B
	friend bool operator<(const char* str1, const String& str2) {
		return str2.compareTo(str1) > 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕傫ΐ^B
	bool operator<=(const String& str)const {
		return compareTo(str) <= 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕傫ΐ^B
	bool operator<=(const char* str)const {
		return compareTo(str) <= 0;
	}
	// rZqB
	// :
	//	str1 r镶B
	//	str2 r镶B
	// Ԓl:
	//	str1str2̕傫ΐ^B
	friend bool operator<=(const char* str1, const String& str2) {
		return str2.compareTo(str1) >= 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕ΐ^B
	bool operator>(const String& str)const {
		return compareTo(str) > 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕ΐ^B
	bool operator>(const char* str)const {
		return compareTo(str) > 0;
	}
	// rZqB
	// :
	//	str1 r镶B
	//	str2 r镶B
	// Ԓl:
	//	str1str2̕ΐ^B
	friend bool operator>(const char* str1, const String& str2) {
		return str2.compareTo(str1) < 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕ΐ^B
	bool operator>=(const String& str)const {
		return compareTo(str) >= 0;
	}
	// rZqB
	// :
	//	str rΏۂ̕B
	// Ԓl:
	//	str̕ΐ^B
	bool operator>=(const char* str)const {
		return compareTo(str) >= 0;
	}
	// rZqB
	// :
	//	str1 r镶B
	//	str2 r镶B
	// Ԓl:
	//	str1str2̕ΐ^B
	friend bool operator>=(const char* str1, const String& str2) {
		return str2.compareTo(str1) <= 0;
	}

	// public utilities

	// 2oCg̍ŏ1oCgǂ𔻒肷B
	// :
	//	肷oCgB
	// Ԓl:
	//	2oCg̍ŏ1oCgłΐ^B
	static bool isLeadByte(char ch) {
	#ifdef _INC_WINDOWS
		return ::IsDBCSLeadByte(ch) != 0;
	#else
		return (ch & 0x80) != 0;
	#endif
	}
};

}

#endif//_YCL_STRING_H_
