/* Tera Term
 Copyright(C) 1994-1998 T. Teranishi
 All rights reserved. */

// TTCMN.DLL character code conversion

#include "teraterm.h"
#include "tttypes.h"
#include <mbstring.h>
#include <locale.h>

#include "sjis2uni.map"

unsigned short ConvertUnicode(unsigned short code, codemap_t *table, int tmax)
{
	int low, mid, high;
	unsigned short result;

	low = 0;
	high = tmax - 1;
	result = 0; // convert error

	// binary search
	while (low < high) {
		mid = (low + high) / 2;
		if (table[mid].from_code < code) {
			low = mid + 1;
		} else {
			high = mid;
		}
	}

	if (table[low].from_code == code) {
		result = table[low].to_code;
	}

	return (result);
}

unsigned int FAR PASCAL SJIS2UTF8(WORD KCode, int *byte, char *locale)
{
	wchar_t wchar;
	int ret;
	unsigned int code = KCode;
	unsigned int c, c1, c2, c3;
	unsigned char *ptr, buf[3];
	unsigned short cset;

	*byte = 2;

	// CP932UTF-16LE֕ϊ
	setlocale(LC_ALL, locale);

	buf[0] = KCode >> 8;
	buf[1] = KCode & 0xff;
	buf[2] = '\0';
	ret = mbtowc(&wchar, buf, 2);
	if (ret <= 0) { // ϊs
		cset = 0;
		if (_stricmp(locale, DEFAULT_LOCALE) == 0) {
			cset = ConvertUnicode(KCode, mapSJISToUnicode, sizeof(mapSJISToUnicode)/sizeof(mapSJISToUnicode[0]));
		}
		if (cset == 0) {
			goto error;
		} else {
			c = cset;
		}
	} else {
		ptr = (unsigned char *)&wchar;
		if (ret >= 2) {
			c = ((ptr[1] << 8) | ptr[0]);
		} else {
			c = '?';
		}
	}

	// UTF-16LEUTF-8֕ϊ
	if (0x00000000 <= c && c <= 0x0000007f) {
		code = (c & 0xff);
		*byte = 1;

	} else if (0x00000080 <= c && c <= 0x000007ff) {
		c1 = ((c >> 6) & 0x1f) | 0xc0;
		c2 = (c & 0x3f) | 0x80;
		code = (c1 << 8) | c2;
		*byte = 2;

	} else if (0x00000800 <= c && c <= 0x0000ffff) {
		c1 = ((c >> 12) & 0xf) | 0xe0;
		c2 = ((c >> 6) & 0x3f) | 0x80;
		c3 = ((c) & 0x3f) | 0x80;
		code = (c1 << 16) | (c2 << 8) | c3;
		*byte = 3;
	}

error:

	return (code);
}


// Japanese SJIS -> JIS
WORD FAR PASCAL SJIS2JIS(WORD KCode)
{
	WORD x0,x1,x2,y0;
	BYTE b = LOBYTE(KCode);

	if ((b>=0x40) && (b<=0x7f)) {
		x0 = 0x8140;
		y0 = 0x2121;
	}
	else if ((b>=0x80) && (b<=0x9e)) {
		x0 = 0x8180;
		y0 = 0x2160;
	}
	else {
		x0 = 0x819f;
		y0 = 0x2221;
	}
	if (HIBYTE(KCode) >= 0xe0) {
		x0 = x0 + 0x5f00;
		y0 = y0 + 0x3e00;
	}
	x1 = (KCode-x0) / 0x100;
	x2 = (KCode-x0) % 0x100;
	return (y0 + x1*0x200 + x2);
}

// Japanese SJIS -> EUC
WORD FAR PASCAL SJIS2EUC(WORD KCode)
{
	return (SJIS2JIS(KCode) | 0x8080);
}

// Japanese JIS -> SJIS
WORD FAR PASCAL JIS2SJIS(WORD KCode)
{
	WORD n1, n2, SJIS;

	n1 = (KCode-0x2121) / 0x200;
	n2 = (KCode-0x2121) % 0x200;

	if (n1<=0x1e)
		SJIS = 0x8100 + n1*256;
	else
		SJIS = 0xC100 + n1*256;

	if (n2<=0x3e)
		return (SJIS + n2 + 0x40);
	else if ((n2>=0x3f) && (n2<=0x5d))
		return (SJIS + n2 + 0x41);
	else
		return (SJIS + n2 - 0x61);
}

/* Russian charset conversion table by Andrey Nikiforov 19971114 */
static BYTE cpconv[4][4][128] =
{
// 1251 -> 1251 = dummy
/*128-143*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*144-159*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*160-175*/  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
/*176-191*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*192-207*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*208-223*/  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/*224-239*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/*240-255*/  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
// 1251 -> KOI8-R
/*128-143*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*144-159*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*160-175*/  160,161,162,164,165,166,167,168,179,169,170,171,172,173,174,175,
/*176-191*/  176,177,178,180,181,182,183,184,163,185,186,187,188,189,190,191,
/*192-207*/  225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
/*208-223*/  242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
/*224-239*/  193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
/*240-255*/  210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209, 
// 1251 -> 866                              ,                       ,
/*128-143*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*144-159*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*160-175*/  208,246,247,209,253,210,211,212,240,213,242,214,215,216,217,244,
/*176-191*/  248,218,219,220,221,222,223,249,241,252,243,250,251,254,255,245,
/*192-207*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*208-223*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*224-239*/  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
/*240-255*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
// 1251 -> ISO                          ,                   ,
/*128-143*/  162,163,128,243,129,130,131,132,133,134,169,135,170,172,171,175,
/*144-159*/  242,136,137,138,139,140,141,142,143,144,249,145,250,252,251,255,
/*160-175*/  146,174,254,168,147,148,149,150,161,151,164,152,153,154,155,167,
/*176-191*/  156,157,166,246,158,159,160,173,241,240,244,253,248,165,245,247,
/*192-207*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*208-223*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*224-239*/  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/*240-255*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
// koi8-r -> 1251                       ,                   ,
/*128-143*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*144-159*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*160-175*/  160,161,162,184,163,164,165,166,167,169,170,171,172,173,174,175,
/*176-191*/  176,177,178,168,179,180,181,182,183,185,186,187,188,189,190,191,
/*192-207*/  254,224,225,246,228,229,244,227,245,232,233,234,235,236,237,238,
/*208-223*/  239,255,240,241,242,243,230,226,252,251,231,248,253,249,247,250,
/*224-239*/  222,192,193,214,196,197,212,195,213,200,201,202,203,204,205,206,
/*240-255*/  207,223,208,209,210,211,198,194,220,219,199,216,221,217,215,218,
// koi8-r -> koi8-r = dummy  
/*128-143*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*144-159*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*160-175*/  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
/*176-191*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*192-207*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*208-223*/  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/*224-239*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/*240-255*/  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
// koi8-r -> 866
/*128-143*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*144-159*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*160-175*/  208,209,210,241,211,212,213,214,215,216,217,218,219,220,221,222,
/*176-191*/  223,242,243,240,244,245,246,247,248,249,250,251,252,253,254,255,
/*192-207*/  238,160,161,230,164,165,228,163,229,168,169,170,171,172,173,174,
/*208-223*/  175,239,224,225,226,227,166,162,236,235,167,232,237,233,231,234,
/*224-239*/  158,128,129,150,132,133,148,131,149,136,137,138,139,140,141,142,
/*240-255*/  143,159,144,145,146,147,134,130,156,155,135,152,157,153,151,154,
// koi8-r -> ISO                        ,       ,   ,   ,   ,   ,   ,   ,
/*128-143*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*144-159*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*160-175*/  160,162,163,241,164,165,166,167,168,169,170,171,172,173,174,175,
/*176-191*/  240,242,243,161,244,245,246,247,248,249,250,251,252,253,254,255,
/*192-207*/  238,208,209,230,212,213,228,211,229,216,217,218,219,220,221,222,
/*208-223*/  223,239,224,225,226,227,214,210,236,235,215,232,237,233,231,234,
/*224-239*/  206,176,177,198,180,181,196,179,197,184,185,186,187,188,189,190,
/*240-255*/  191,207,192,193,194,195,182,178,204,203,183,200,205,201,199,202,
// 866 -> 1251                                              ,       ,
/*128-143*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*144-159*/  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/*160-175*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/*176-191*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*192-207*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*208-223*/  160,163,165,166,167,169,171,172,173,174,177,178,179,180,181,182,
/*224-239*/  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
/*240-255*/  168,184,170,186,175,191,161,162,176,183,187,188,185,164,189,190,
// 866 -> koi8-r                        ,   ,                       ,
/*128-143*/  225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
/*144-159*/  242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
/*160-175*/  193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
/*176-191*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*192-207*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*208-223*/  160,161,162,164,165,166,167,168,169,170,171,172,173,174,175,176,
/*224-239*/  210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209,
/*240-255*/  179,163,177,178,180,181,182,183,184,185,186,187,188,189,190,191,
// 866 -> 866 = dummy                   ,                           ,        
/*128-143*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*144-159*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*160-175*/  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
/*176-191*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*192-207*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*208-223*/  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/*224-239*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/*240-255*/  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
// 866 -> ISO
/*128-143*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*144-159*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*160-175*/  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/*176-191*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*192-207*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*208-223*/  160,162,163,165,166,168,169,170,171,172,173,175,240,242,243,245,
/*224-239*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/*240-255*/  161,241,164,244,167,247,174,254,246,248,249,250,251,252,253,255,
// ISO -> 1251                                                           ,  ,
/*128-143*/  130,132,133,134,135,136,137,139,145,146,147,148,149,150,151,152,
/*144-159*/  153,155,160,164,165,166,167,169,171,172,173,174,176,177,180,181,
/*160-175*/  182,168,128,129,170,189,178,175,163,138,140,142,141,183,161,143,
/*176-191*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*192-207*/  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/*208-223*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/*224-239*/  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
/*240-255*/  185,184,144,131,186,190,179,191,188,154,156,158,157,187,162,159,
// ISO -> koi8-r                        ,           ,                   ,   ,
/*128-143*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*144-159*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*160-175*/  160,179,161,162,164,165,166,167,168,169,170,171,172,173,174,175,
/*176-191*/  225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
/*192-207*/  242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
/*208-223*/  193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
/*224-239*/  210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209,
/*240-255*/  176,163,177,178,180,181,182,183,184,185,186,187,188,189,190,191,
// ISO -> 866                           ,           ,   ,                    ,
/*128-143*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*144-159*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*160-175*/  208,240,209,210,242,211,212,244,213,214,215,216,217,218,246,219,
/*176-191*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*192-207*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*208-223*/  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
/*224-239*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/*240-255*/  220,241,221,222,243,223,248,245,249,250,251,252,253,254,247,255,
// iso -> iso = dummy                                   ,    ,              ,
/*128-143*/  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
/*144-159*/  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
/*160-175*/  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
/*176-191*/  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/*192-207*/  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/*208-223*/  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/*224-239*/  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/*240-255*/  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 
};

// Russian character set conversion
BYTE FAR PASCAL RussConv(int cin, int cout, BYTE b)
// cin: input character set (IdWindows/IdKOI8/Id866/IdISO)
// cin: output character set (IdWindows/IdKOI8/Id866/IdISO)
{
	if (b<128)
		return b;
	return cpconv[cin-1][cout-1][b-128];
}

// Russian character set conversion for a character string
void FAR PASCAL RussConvStr(int cin, int cout, PCHAR Str, int count)
// cin: input character set (IdWindows/IdKOI8/Id866/IdISO)
// cin: output character set (IdWindows/IdKOI8/Id866/IdISO)
{
	int i;

	if (count<=0)
		return;

	for (i=0; i<=count-1; i++)
		if ((BYTE)Str[i]>=128)
			Str[i] = (char)cpconv[cin-1][cout-1][(BYTE)Str[i]-128];
}
