/* terms.c -- (C) 2016 Mark Rodenkirch

   Build and manage list of remaining terms
*/

#include <assert.h>
#include <inttypes.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "cksieve.h"
#include "bitmap.h"

uint32_t n_min;
uint32_t n_max;
uint32_t bm_max;

uint_fast32_t *N_PLUS;
uint_fast32_t *N_MINUS;
uint32_t n_count;        /* number of remaining n */
char bnc_buf[70];

void add_nc(uint32_t n, int32_t c);
const char *abc_str();

void build_terms()
{
   uint32_t n;

   bm_max = n_max + 1;
   N_PLUS = make_bitmap(bm_max, "out of memory");
   N_MINUS = make_bitmap(bm_max, "out of memory");
      
   for (n=n_min; n<=n_max; n++)
   {
      add_nc(n, +1);
      add_nc(n, -1);
   }
   
   report(1,"Started with %"PRIu32" term%s for %s from command line.", n_count, plural(n_count), abc_str());
}
  
const char *bnc_str(uint32_t n, int32_t c)
{
   sprintf(bnc_buf,"(%"PRIu32"^%"PRIu32"%+"PRId32")^2-2", b_term,n,c);
          
   return bnc_buf;
}

void add_nc(uint32_t n, int32_t c)
{
   if (n_min == 0)
   {
      n_min = n_max = n;
      bm_max = 1000000;
      N_PLUS = make_bitmap(bm_max, "out of memory");
      N_MINUS = make_bitmap(bm_max, "out of memory");
   } else if (n > bm_max)
   {
      N_PLUS = resize_bitmap(N_PLUS, bm_max, n + 100000);
      N_MINUS = resize_bitmap(N_MINUS, bm_max, n + 100000);
      bm_max = n + 100000;
   }

   if (n < n_min)
      n_min = n;
   if (n > n_max)
      n_max = n;

   if (c == 1)
      set_bit(N_PLUS, n);
   else
      set_bit(N_MINUS, n);

   n_count++;
}

uint32_t for_each_term(void (*fun)(uint32_t, int32_t, void *), void *arg)
{
   uint32_t n;
   uint32_t count = 0;
   
   for (n=n_min; n<=n_max; n++)
   {
      if (test_bit(N_PLUS, n))
      {
         fun(n, +1, arg);
         count++;
      }
         
      if (test_bit(N_MINUS, n))
      {
         fun(n, -1, arg);
         count++;
      }
   }

  return count;
}


void eliminate_term(uint32_t n, int32_t c, uint64_t p)
{
   if (n > n_max)
      return;
      
   if (c == 1 && !test_bit(N_PLUS, n))
   	return;
   	
   if (c == -1 && !test_bit(N_MINUS, n))
   	return;

   if (!is_factor(n, c, p))
      error("%"PRIu64" DOES NOT DIVIDE %s.",p , bnc_str(n, c));

   notify_factor();
   save_factor(n, c, p);

   if (c == -1)
      clear_bit(N_MINUS, n);
   else
      clear_bit(N_PLUS, n);
   
}