/* memset_fast32.h -- (C) 2016 Mark Rodenkirch, Geoffrey Reynolds

   memset_fast32() function.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
*/

#ifndef _MEMSET_FAST32_H
#define _MEMSET_FAST32_H

/* Store count copies of x starting at dst. In critical cases dst will be
   64-aligned and count will be a power of 2, usually greater than 16, but
   other cases must be handled as well.
 */
static inline
void memset_fast32(uint_fast32_t *dst, uint_fast32_t x, uint_fast32_t count)
{
  uint_fast32_t i;
  for (i = 0; i+8 <= count; i += 8)
  {
    dst[i+0] = x;
    dst[i+1] = x;
    dst[i+2] = x;
    dst[i+3] = x;
    dst[i+4] = x;
    dst[i+5] = x;
    dst[i+6] = x;
    dst[i+7] = x;
  }
  for ( ; i < count; i++)
    dst[i] = x;
}

#endif /* _MEMSET_FAST32_H */
