/* factors.c -- (C) 2016 Mark Rodenkirch

   Factors file routines and misc factoring related functions.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
*/

#include <assert.h>
#include <inttypes.h>
#include <stdio.h>
#include "cksieve.h"
#if CHECK_FACTORS
#include "arithmetic.h"
#endif

uint32_t  factor_count = 0;
const char *bnc_str(uint32_t n, int32_t c);
extern double one_over_p;

void check_prime(int32_t n, int32_t c, uint64_t p);

void save_factor(uint32_t n, int32_t c, uint64_t p)
{
  FILE *factors_file;

  if (factors_file_name != NULL)
  {
    factors_file = xfopen(factors_file_name,"a",error);

    if (fprintf(factors_file,"%"PRIu64" | %s\n",p,bnc_str(n, c)) < 0)
      error("Could not write to factors file `%s'.",factors_file_name);

    xfclose(factors_file,factors_file_name);
  }

  factor_count++;
}

int is_factor(uint32_t n, int32_t c, uint64_t p)
{
   uint64_t res;

   assert(p > 0);

   check_prime(n, c, p);

   mod64_init(p);

   res = powmod64(b_term, n, p) + c;

   res = sqrmod64(res, p);

   mod64_fini();

   return (res == 2);
}

void check_prime(int32_t n, int32_t c, uint64_t p)
{
   if (b_term ==  2 && n > 63) return;
   if (b_term >=  4 && n > 31) return;
   if (b_term >=  8 && n > 20) return;
   if (b_term >= 16 && n > 15) return;
   if (b_term >= 32 && n > 12) return;
   if (b_term >= 64 && n > 10) return;

   int32_t N = n;
   uint64_t value = b_term;

   while (N > 1)
   {
      value *= b_term;

      if (value > p) return;

      N--;
   }

   value += c;
   value *= value;

   if (value == p + 2)
      warning("%s appears to be prime (%"PRIu64")", bnc_str(n, c), p);
}
