#!/usr/bin/perl -w
#
# you can use this script on pl_remain.txt
#
use Math::BigInt;

line: while(<>) {
  next unless /^(\d+)\*(\d+)\^n([+-])1/ && $1 && $2;
  $k = Math::BigInt->new($1);
  $a = Math::BigInt->new($2);
  my @powers = ($3 eq '+') ? qw(3 5 7 11) : qw(2 3 5 7 11);
  
  foreach $m (@powers) {
    $b = $k->copy()->broot($m);
    if ($b->copy()->bpow($m) == $k) {
      if ($a->copy()->broot($m)->bpow($m) == $a) {
	print "*  x^$m\t$_";
	next line;
      }
      print "0|$m $b^$m\t$_";
    }
  }
  for ($n=1; $n<$powers[$#powers]; $n++) {
    $a->bmul($k);
    foreach $m (@powers) {
      next if $n>=$m;
      $b = $a->copy()->broot($m);
      print "$n|$m $b^$m\t$_" if ($b->copy()->bpow($m) == $a);
    }
  }
}
