/*
 * Based on arch/arm/include/asm/arch-armada100/mfp.h
 * (C) Copyright 2011
 * Marvell Semiconductor <www.marvell.com>
 * Written-by: Lei Wen <leiwen@marvell.com>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __PXA1928_MFP_H
#define __PXA1928_MFP_H

/*
 * Frequently used MFP Configuration macros for all PANTHEON family of SoCs
 *
 * offset, pull,pF, drv,dF, edge,eF ,afn,aF
 *
 * Naming: Board usage name + ball/pad name + mfp offset
 * If board usage name is same as ball/pad name, no need to repeat.
 */
/* UART3 */
#define UART3_RXD_MMC2_DAT7_MFP33		(MFP_REG(0x40) | MFP_AF7 | MFP_DRIVE_MEDIUM)
#define UART3_TXD_MMC2_DAT6_MFP34		(MFP_REG(0x44) | MFP_AF7 | MFP_DRIVE_MEDIUM)

/* PWR_TWSI */
#define PWR_SCL_MFP67		(MFP_REG(0x140) | MFP_AF0 | MFP_DRIVE_SLOW)
#define PWR_SDA_MFP68		(MFP_REG(0x144) | MFP_AF0 | MFP_DRIVE_SLOW)

/* TWSI2 */
#define TWSI2_SCL_MFP43		(MFP_REG(0x19C) | MFP_AF6 | MFP_DRIVE_SLOW)
#define TWSI2_SDA_MFP44		(MFP_REG(0x1A0) | MFP_AF6 | MFP_DRIVE_SLOW)

/* TWSI3 */
#define TWSI3_SCL_MFP31		(MFP_REG(0x194) | MFP_AF7 | MFP_DRIVE_SLOW)
#define TWSI3_SDA_MFP32		(MFP_REG(0x198) | MFP_AF7 | MFP_DRIVE_SLOW)
#define TWSI3_SCL_MFP18		(MFP_REG(0x160) | MFP_AF4 | MFP_DRIVE_SLOW)
#define TWSI3_SDA_MFP19		(MFP_REG(0x164) | MFP_AF4 | MFP_DRIVE_SLOW)

/* TWSI4 */
#define TWSI4_SCL_MFP46		(MFP_REG(0x1A8) | MFP_AF6 | MFP_DRIVE_SLOW)
#define TWSI4_SDA_MFP45		(MFP_REG(0x1A4) | MFP_AF6 | MFP_DRIVE_SLOW)

/* TWSI5 */
#define TWSI5_SCL_MFP29		(MFP_REG(0x18C) | MFP_AF7 | MFP_DRIVE_SLOW)
#define TWSI5_SDA_MFP30		(MFP_REG(0x190) | MFP_AF7 | MFP_DRIVE_SLOW)

/* TWSI6 */
#define TWSI6_SCL_MMC2_DAT5_MFP35	(MFP_REG(0x48) | MFP_AF5 | MFP_DRIVE_SLOW)
#define TWSI6_SDA_MMC2_DAT4_MFP36	(MFP_REG(0x4C) | MFP_AF5 | MFP_DRIVE_SLOW)

/* MMC3(eMMC) */
#define MMC3_DAT0_ND_IO8_MFP87		(MFP_REG(0x88) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_DAT1_ND_IO9_MFP86		(MFP_REG(0x8C) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_DAT2_ND_IO10_MFP85		(MFP_REG(0x90) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_DAT3_ND_IO11_MFP84		(MFP_REG(0x94) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_DAT4_ND_IO12_MFP83		(MFP_REG(0x98) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_DAT5_ND_IO13_MFP82		(MFP_REG(0x9C) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_DAT6_ND_IO14_MFP81		(MFP_REG(0xA0) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_DAT7_ND_IO15_MFP80		(MFP_REG(0xA4) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_CLK_SM_ADVMUX_MFP88	(MFP_REG(0xDC) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_LOW)
#define MMC3_CMD_SM_RDY_MFP89		(MFP_REG(0xE0) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC3_RST_ND_CLE_MFP90		(MFP_REG(0xC0) | MFP_AF1 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)

/* MMC1(SD) */
#define MMC1_DAT0_MFP62		(MFP_REG(0x2C) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_DAT1_MFP61		(MFP_REG(0x28) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_DAT2_MFP60		(MFP_REG(0x24) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_DAT3_MFP59		(MFP_REG(0x20) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_DAT4_MFP58		(MFP_REG(0x1C) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_DAT5_MFP57		(MFP_REG(0x18) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_DAT6_MFP56		(MFP_REG(0x14) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_DAT7_MFP55		(MFP_REG(0x10) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_CLK_MFP64		(MFP_REG(0x34) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_LOW)
#define MMC1_CMD_MFP63		(MFP_REG(0x30) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_CD_N_MFP65		(MFP_REG(0x38) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)
#define MMC1_WP_MFP66		(MFP_REG(0x3C) | MFP_AF0 | MFP_DRIVE_MEDIUM | MFP_PULL_HIGH)

/* LCD and backlight */
#define BACKLIGHT_PWM2_MFP51	(MFP_REG(0x1BC) | MFP_AF2 | MFP_DRIVE_MEDIUM) /* FIXME */
#define LCD_RESET_MFP121	(MFP_REG(0x1F4) | MFP_AF0 | MFP_DRIVE_MEDIUM)
#define LCD_BACKLIGHT_EN_MFP6	(MFP_REG(0x128) | MFP_AF0 | MFP_DRIVE_MEDIUM)
#define BOOST_5V_EN_MFP125	(MFP_REG(0x238) | MFP_AF1 | MFP_DRIVE_MEDIUM)
#define BOOST_5V_EN_MFP10	(MFP_REG(0x138) | MFP_AF0 | MFP_DRIVE_MEDIUM)

/* Volume Down Key for fastboot */
#define GPIO17_MFP17	(MFP_REG(0x15C) | MFP_AF0 | MFP_PULL_HIGH)
/* Volume Up Key for recovery on concord rev1 */
#define GPIO16_MFP16	(MFP_REG(0x158) | MFP_AF0 | MFP_PULL_HIGH)
/* Volume Up Key for recovery on concord rev2 */
#define GPIO15_MFP15	(MFP_REG(0x154) | MFP_AF0 | MFP_PULL_HIGH)

/* DVC pin */
#define DVC_PIN0_MFP107		(MFP_REG(0xC8) | MFP_AF7 | MFP_DRIVE_MEDIUM)
#define DVC_PIN1_MFP108		(MFP_REG(0xD0) | MFP_AF7 | MFP_DRIVE_MEDIUM)
#define DVC_PIN2_MFP99		(MFP_REG(0xAC) | MFP_AF7 | MFP_DRIVE_MEDIUM)
#define DVC_PIN3_MFP103		(MFP_REG(0xB0) | MFP_AF7 | MFP_DRIVE_MEDIUM)
/* More macros can be defined here... */

/* for discrete */
/* TWSI2 */
#define TWSI2_SCL_MFP178	(MFP_REG(0x2D0) | MFP_AF6 | MFP_DRIVE_SLOW)
#define TWSI2_SDA_MFP179	(MFP_REG(0x2CC) | MFP_AF6 | MFP_DRIVE_SLOW)

/* TWSI3 */
#define TWSI3_SCL_MFP176	(MFP_REG(0x2D8) | MFP_AF7 | MFP_DRIVE_SLOW)
#define TWSI3_SDA_MFP177	(MFP_REG(0x2D4) | MFP_AF7 | MFP_DRIVE_SLOW)

/* TWSI4 */
#define TWSI4_SCL_MFP181	(MFP_REG(0x2C4) | MFP_AF6 | MFP_DRIVE_SLOW)
#define TWSI4_SDA_MFP180	(MFP_REG(0x2C8) | MFP_AF6 | MFP_DRIVE_SLOW)

/* TWSI5 */
#define TWSI5_SCL_MFP174	(MFP_REG(0x2E0) | MFP_AF7 | MFP_DRIVE_SLOW)
#define TWSI5_SDA_MFP175	(MFP_REG(0x2DC) | MFP_AF7 | MFP_DRIVE_SLOW)

/* LCD and backlight */
#define BACKLIGHT_PWM2_MFP186	(MFP_REG(0x2B0) | MFP_AF2 | MFP_DRIVE_MEDIUM)
#define LCD_BACKLIGHT_EN_MFP151	(MFP_REG(0x260) | MFP_AF0 | MFP_DRIVE_MEDIUM)
#define BOOST_5V_EN_MFP155	(MFP_REG(0x270) | MFP_AF0 | MFP_DRIVE_MEDIUM)

/* Volume Down Key for fastboot */
#define GPIO162_MFP162		(MFP_REG(0x28C) | MFP_AF0 | MFP_PULL_HIGH)
/* Volume Up Key for recovery on concord discrete */
#define GPIO160_MFP160		(MFP_REG(0x284) | MFP_AF0 | MFP_PULL_HIGH)

/* Main Camera */
#define GPIO12_MFP12		(MFP_REG(0x148) | MFP_AF0 | MFP_DRIVE_SLOW | \
				 MFP_LPM_EDGE_NONE | MFP_SLEEP_DATA)
#define GPIO113_MFP113		(MFP_REG(0x1D4) | MFP_AF0 | MFP_DRIVE_SLOW | \
				 MFP_LPM_EDGE_NONE)

/* Secondary Camera */
#define GPIO13_MFP13		(MFP_REG(0x14C) | MFP_AF0 | MFP_DRIVE_SLOW | \
				 MFP_LPM_EDGE_NONE)
#define GPIO111_MFP111		(MFP_REG(0x1CC) | MFP_AF0 | MFP_DRIVE_SLOW | \
				 MFP_LPM_EDGE_NONE | MFP_SLEEP_DATA)

/* GPS */
#define GPIO53_MFP53		(MFP_REG(0x1C4) | MFP_AF0 | MFP_DRIVE_MEDIUM | \
				MFP_LPM_EDGE_NONE)

/*GPIO 00::54 */
#define GPIO0_MFP0		(MFP_REG(0x110) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO1_MFP1		(MFP_REG(0x114) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO2_MFP2		(MFP_REG(0x118) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO3_MFP3		(MFP_REG(0x11C) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO4_MFP4		(MFP_REG(0x120) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO5_MFP5		(MFP_REG(0x124) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO6_MFP6		(MFP_REG(0x128) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO7_MFP7		(MFP_REG(0x12C) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO8_MFP8		(MFP_REG(0x130) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO9_MFP9		(MFP_REG(0x134) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO10_MFP10		(MFP_REG(0x138) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO11_MFP11		(MFP_REG(0x13C) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO14_MFP14		(MFP_REG(0x150) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO18_MFP18		(MFP_REG(0x160) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO19_MFP19		(MFP_REG(0x164) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO20_MFP20		(MFP_REG(0x168) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO21_MFP21		(MFP_REG(0x16C) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO22_MFP22		(MFP_REG(0x170) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO23_MFP23		(MFP_REG(0x174) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO24_MFP24		(MFP_REG(0x178) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO25_MFP25		(MFP_REG(0x17C) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO26_MFP26		(MFP_REG(0x180) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO27_MFP27		(MFP_REG(0x184) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO28_MFP28		(MFP_REG(0x188) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO29_MFP29		(MFP_REG(0x18C) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO30_MFP30		(MFP_REG(0x190) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO31_MFP31		(MFP_REG(0x194) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO32_MFP32		(MFP_REG(0x198) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO43_MFP43		(MFP_REG(0x19C) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO44_MFP44		(MFP_REG(0x1A0) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO45_MFP45		(MFP_REG(0x1A4) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO46_MFP46		(MFP_REG(0x1A8) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO47_MFP47		(MFP_REG(0x1AC) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO48_MFP48		(MFP_REG(0x1B0) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO49_MFP49		(MFP_REG(0x1B4) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO50_MFP50		(MFP_REG(0x1B8) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO51_MFP51		(MFP_REG(0x1BC) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO52_MFP52		(MFP_REG(0x1C0) | MFP_AF0 | MFP_DRIVE_SLOW)
#define GPIO54_MFP54		(MFP_REG(0x1C8) | MFP_AF0 | MFP_DRIVE_SLOW)

/* GPIO 136::138 */
#define GPIO136_MFP136		(MFP_REG(0x4) | MFP_AF1 | MFP_DRIVE_SLOW)
#define GPIO137_MFP137		(MFP_REG(0x8) | MFP_AF1 | MFP_DRIVE_SLOW)
#define GPIO138_MFP138		(MFP_REG(0xC) | MFP_AF1 | MFP_DRIVE_SLOW)

/* GPIO 140::144 */
#define GPIO140_MFP140		(MFP_REG(0x224) | MFP_AF1 | MFP_DRIVE_SLOW)
#define GPIO141_MFP141		(MFP_REG(0x21C) | MFP_AF1 | MFP_DRIVE_SLOW)
#define GPIO142_MFP142		(MFP_REG(0x220) | MFP_AF1 | MFP_DRIVE_SLOW)
#define GPIO143_MFP143		(MFP_REG(0x240) | MFP_AF1 | MFP_DRIVE_SLOW)
#define GPIO144_MFP144		(MFP_REG(0x244) | MFP_AF1 | MFP_DRIVE_SLOW)

/* USIM */
#define IC_USB_P_DIS_MFP193		(MFP_REG(0x308) | MFP_AF1 | MFP_DRIVE_SLOW)
#define IC_USB_N_DIS_MFP194		(MFP_REG(0x30C) | MFP_AF1 | MFP_DRIVE_SLOW)
#define USIM1_UCLK_DIS_MFP190		(MFP_REG(0x304) | MFP_AF1 | MFP_DRIVE_SLOW)
#define USIM1_UIO_DIS_MFP191		(MFP_REG(0x2FC) | MFP_AF1 | MFP_DRIVE_SLOW)
#define USIM1_NURST_DIS_MFP192		(MFP_REG(0x300) | MFP_AF1 | MFP_DRIVE_SLOW)
#define USIM2_UCLK_DIS_MFP195		(MFP_REG(0x318) | MFP_AF1 | MFP_DRIVE_SLOW)
#define USIM2_UIO_DIS_MFP196		(MFP_REG(0x310) | MFP_AF1 | MFP_DRIVE_SLOW)
#define USIM2_NURST_DIS_MFP197		(MFP_REG(0x314) | MFP_AF1 | MFP_DRIVE_SLOW)

/* MMC1_CD */
#define MMC1_CD_ND_NCS1_MFP100		(MFP_REG(0xB8) | MFP_AF7 | MFP_DRIVE_SLOW)
#define ND_NCS1_MFP100			(MFP_REG(0xB8) | MFP_AF0 | MFP_DRIVE_SLOW)
/* GPIO */
#define GPIO65_MFP65			(MFP_REG(0x38) | MFP_AF1 | MFP_DRIVE_SLOW)
#endif /* __PXA1928_MFP_H */
