from __future__ import (unicode_literals, division, absolute_import, print_function)

from calibre.customize import FileTypePlugin

__license__ = "GPL v3"
__copyright__ = "2021, John Howell <jhowell@acm.org>"


class PackageKFXFileTypePlugin(FileTypePlugin):
    name = "Package KFX (from KFX Input)"
    description = "Import Amazon KFX format Pt 2 - package a KFX-ZIP book into monolithic KFX"
    supported_platforms = ["windows", "osx", "linux"]
    author = "jhowell"
    file_types = {"azw", "azw8", "kfx", "kfx-zip", "zip"}     # original type - any type that could turn into kfx-zip
    on_import = True
    priority = 200
    minimum_calibre_version = (2, 0, 0)

    def run(self, path_to_ebook):
        if path_to_ebook.endswith(".kfx-zip"):
            return self.run_kfx(path_to_ebook)

        return path_to_ebook

    def run_kfx(self, path_to_ebook):
        from calibre.utils.logging import Log
        from calibre_plugins.kfx_input.kfxlib import (file_write_binary, set_logger, YJ_Book)

        log = set_logger(Log())
        log.info("%s %s: Packaging %s" % (self.name, ".".join([str(i) for i in self.version]), path_to_ebook))

        kfx_data = YJ_Book(path_to_ebook).convert_to_single_kfx()
        set_logger()

        outfile = self.temporary_file(".kfx").name
        file_write_binary(outfile, kfx_data)

        log.info("%s: Imported as %s" % (self.name, outfile))
        return outfile
