import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:hive/hive.dart';
import 'package:hive_flutter/hive_flutter.dart';
import 'package:ichan/blocs/thread/data.dart';
import 'package:ichan/models/post.dart';
import 'package:ichan/models/thread.dart';
import 'package:ichan/pages/settings/general_links_page.dart';
import 'package:ichan/pages/thread/post_item.dart';
import 'package:ichan/services/consts.dart';
import 'package:ichan/services/exports.dart';
import 'package:ichan/widgets/menu/menu.dart';
import 'package:ichan/services/my.dart' as my;

class FontSettingsPage extends StatelessWidget {
  static const header = 'Font';

  @override
  Widget build(BuildContext context) {
    return HeaderNavbar(
      backgroundColor: my.theme.secondaryBackgroundColor,
      middle: Text(header, style: TextStyle(color: my.theme.navbarFontColor)),
      previousPageTitle: GeneralSettingsPage.header,
      child: const FontSettingsPageWidget(),
    );
  }
}

class FontSettingsPageWidget extends StatefulWidget {
  const FontSettingsPageWidget({Key key}) : super(key: key);

  @override
  _FontSettingsPageState createState() => _FontSettingsPageState();
}

class _FontSettingsPageState extends State<FontSettingsPageWidget> {
  static const defaultFontSize = 15.0;
  final fontController = TextEditingController();
  double fontSize;
  String exampleText;

  @override
  void initState() {
    super.initState();
    fontController.text = my.prefs.get("font_size", defaultValue: defaultFontSize).toString();
    print("fontController.text = ${fontController.text}");

    if (fontController.text.isNotEmpty) {
      fontSize = double.parse(fontController.text);
    } else {
      my.prefs.put("font_size", defaultFontSize);
      fontSize = defaultFontSize;
    }

    exampleText = my.prefs.platforms[0] == Platform.dvach ? getRuBody() : getEnBody();
  }

  @override
  void dispose() {
    fontController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    final currentSize = my.prefs.get('font_size', defaultValue: defaultFontSize);

    return ListView(
      padding: const EdgeInsets.only(top: Consts.topPadding * 3),
      children: [
        MenuSwitch(
          label: "Light font",
          field: "light_font",
          defaultValue: false,
          onChanged: (val) {
            setState(() {
              my.prefs.put('light_font', val);
            });
          },
        ),
        MenuTextField(
          label: 'Post font size',
          boxField: 'font_size',
          onSubmitted: (val) {
            my.prefs.put("font_size", fontSize);
          },
          onChanged: (val) {
            double parsedVal;
            try {
              final _val = val.replaceAll(',', '.');
              parsedVal = double.parse(_val as String);
              if (parsedVal <= 6) {
                parsedVal = 6;
              } else if (parsedVal >= 60) {
                parsedVal = 60;
              }
            } catch (e) {
              parsedVal = currentSize;
            }

            fontSize = parsedVal;
          },
        ),
        ValueListenableBuilder<Box>(
          valueListenable: my.prefs.box.listenable(keys: ['font_size', 'light_font']),
          builder: (context, box, child) {
            final post = Post(
              body: exampleText,
              outerId: "12345678",
              timestamp: 1594567811,
              boardName: "test",
              platform: Platform.dvach,
              threadId: "12345678",
              counter: 1,
            );

            return GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {
                setState(() {
                  exampleText = my.prefs.platforms[0] == Platform.dvach ? getRuBody() : getEnBody();
                });
              },
              child: Container(
                margin: const EdgeInsets.only(
                    top: 20.0, left: Consts.sidePadding, right: Consts.sidePadding, bottom: 50.0),
                alignment: Alignment.bottomLeft,
                child: PostItem(
                  post: post,
                  threadData: ThreadData(thread: Thread.empty()),
                  origin: Origin.example,
                ),
              ),
            );
          },
        )
      ],
    );
  }

  String getEnBody() {
    return "When I was 15 I used to take a shit and my dad had been ocasionally hanging out around the toilet asking me why I was so silent. First time I didn\'t respond so he tried to force open the door shouting: \"Why are you keeping silence, what's going on there?\" He started swearing and tellong me he's gonna knock down the door, also he used to swear when I forgot to flush the toilet, not only after I took a shit, but even right after the shit left my asshole saying that it stank. He used to tell me: \"When I just took a shit I always flush it down and you have to do the same!\" One day I was sitting on the toilet and heard that my dad stood right next to the door, so I wipe my ass and got on my knees - there's a chink under the door - so I watch through the chink and see my dad on his knees looking at me through the chink saying: \"What's wrong with you? What the hell are you doing there?\" By the way dad always drinks some decoction which makes him take a dump often, like 5 times a day, then he complains his ass is sore and farts. That's fucked up! That's a real story I'm not a troll.";
  }

  String getRuBody() {
    final pasta = [
      'Когда мне было 46 лет, и мой сын ходил срать я всё время как-бы невзначай крутился возле толчка, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз он не ответил, так я начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель сниму. ещё я ругался, если сына срёт и не смывает, причём не просто вконце срания, а непосредственно после вылезания какашки, мотивировал я это тем, что воняет, и сам потом ему говорил: вот я какну и смываю, и ты так делай! однажды он срать сел, ну а я у двери встал в отдалении, слышу он жопу вытер, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там он тоже на карачиках сидит и в щель смотрит, ну я ему и говорю: ты чё? ебанутый? чё ты там делаешь? я кстати специальные таёжные травы пью, чтобы срать часто, сру по 5 раз в день, правда потом жопу жжот, и ещё газы испускаю иногда. реальная история. я не отчим',
      'Когда приходил день выдачи зарплаты, и я сидел у себя в кабинете, готовясь выдать деньги, мой подчиненный уже заранее как-бы невзначай крутился возле двери, и всё спрашивал: "Что вы там затихли, почему вас не слышно?" Первый раз я не ответил, так он начал дергать за ручку двери и орать "что вы там молчите, что с вами?". Начал материться, и говорить, что вообще заяву на увольнение напишет. Также подчиненный возмущался, если я выдаю з/п не в один и тот же день месяца, а каждый раз с опозданием, причём не просто в конце рабочего дня, а непосредственно с самого утра, мотивировав это тем, что деньги срочно нужны, и сам потом мне говорил: "Вот я прийду на работу в день з/п, и вы сразу мне выдавайте!" Однажды я в день выдачи зарплаты отчет писать сел, уронил на пол ручку, а она, сука, к дверной щели подкотилась. Слышу, подчиненный возле двери стал с другой стороны. Ну я на пол на карачики присел, а там щель очень широкая между дверьми и полом, ну я в щель и смотрю, а там подчиненный на карачиках сидит и в щель смотрит, и мне говорит: "Вы чё? Забыли про мою зарплату? Чё Вы там делаете? Подчиненный, кстати, всё время сидит до поздна на работе, чтобы типа сверхурочные были, перерабатывает по 5 часов в день, а потом говорит, что надбавку хочет, и ещё пердит он. Пиздец, короче! Реальная история. Я не директор банкротеющего филиала.',
      'Когда мне было 15 лет, и я ходил в качалку бятя всё время как-бы невзначай крутился возле штанги, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал бегать по всему залу, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще абонемент отберет, алсо, батя ругался, если я жму и не ем метан, причём не просто в конце тренировки, а непосредственно после каждого подхода, мотивировал это тем, что "катаболизм начнется, сука, и масса слетит", и сам потом мне говорил: вот я сделаю подход и закину в себя горсть метана, и ты так делай! однажды я жать сел, и слышу, батя где-то у двери встал в отдалении, ну я на пол накарачики присел, а там щель очень широкая между лавкой и полом, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? натурал? чё ты там делаешь? батя кстати всё время какие-то гейнеры пьёт, чтобы массу набрать, пьёт по 5 раз в день, а потом говорит, что срать хочется, и ещё пердит он. пиздец короче! реальная история. я не химик',
      'Когда мне было 9 и я ходил шатать девятач, анон все время как-бы невзначай крутился возле борды, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ддосить сервер, и спамить, что ты там молчишь, что с тобой? начал вайпать, и говорить, что вообще сервер положит, алсо, анон ругался, если я шатаю, и бекапы не делаю, причём не просто после шатания, а непосредственно после каждой правки, мотивировал это тем, что лагает, и сам потом мне говорил: вот я делаю фикс и бекаплю, и ты так делай! однажды я шатал девятач, и слышу, анон где-то у треда встал в отдалении, ну я бекап сделал, и в тред зашел, а там форма ответа очень широкая снизу у треда, ну я и смотрю, а там анон на карачиках сидит и в тред смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? анон кстати всё время каких-то петухов постит, чтобы сагать часто, срёт по 5 раз в день, а потом говорит, что девятач говно, и ещё вайпает он. пиздец короче! реальная история. я не девяталя.',
      'Когда мне было 15 лет и я ходил в автошколу, автоинструктор всё время как бы невзначай крутился возле моего автомобиля и всё спрашивал, что ты там не трогаешься, что с тобой? первый раз я не ответил так он начал ломиться в дверь и орать что ты там заглох, что с тобой? начал материться и говорил что вобще мне часы практики не засчитает, алсо, автоинструктор ругался если я поворачивал и не включал поворотник, причём не просто в конце поворота, а непосредственно перед началом манёвра, мотивировал это тем, что нарушаю, и сам потом мне говорил: вот я манёвр начну и включаю поворотник, и ты так делай! однажды я за руль сел и слышу, автоинструктор где то у автомобиля встал в отдалении, ну я практику откатал, автомобиль заглушил, и на пол на карачики присел, а там посадка очень высокая снизу у автомобиля, ну я под машину смотрю, а там автоинструктор на карачиках сидит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? автоинструктор кстати всё время какие-то ПДД читает, чтобы практики проводить часто, проводит по 5 практик в день, а потом говорит, что у автомобиля двигатель жжёт, и ещё глохнет он. пиздец короче! реальная история. я не ГАИшник',
      'Когда мне было 18 лет, и я ходил в университет, аспирант всё время как-бы невзначай крутился возле моей парты, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ходить по аудитории, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще меня с семинара выгонит, алсо, аспирант ругался, что я отвечаю и не ссылаюсь на источник, причём не просто в конце семинара, а непосредственно после ответа на данный вопрос, мотивировал это тем, что так не приобрести необходимый опыт, и сам потом мне говорил: вот я отвечу и сошлюсь на источники, и ты так делай! однажды я пришел на семинар, и слышу, аспирант где-то у кафедры встал в отдалении, ну я конспект проверил, и на пол накарачики присел, а там щель очень широкая снизу у кафедры, ну я в щель и смотрю, а там аспирант на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? аспирант кстати всё время какие-то научные работы пишет, чтобы наукой заниматься часто, проверяет источники по 5 раз в день, а потом говорит, что голова болит, и ещё мигрень у него. пиздец короче! реальная история. я не ПТУшник',
      'Когда я сидел вконтаче и ходил покурить, одна тян всё время как-бы невзначай крутилась вокруг да около, и всё спрашивала: "Что ты там затих, почему тебя не слышно?". Первый раз я не ответил, так она начала спамить стенку, и орать: "Что ты там молчишь, что с тобой?". Начала причитать, и говорить, что вообще удалит меня, алсо, эта тян ругалась, если я курю и не пишу, причём не просто в конце курения, а непосредственно после каждой затяжки, мотивировала это тем, что слоу, и сама потом мне говорила: "Вот я покурю и пишу, и ты так делай!" Однажды я сел покурить, и вижу, тян где-то там, в онлайне. Ну я покурил, и на монитор посматриваю, а там вебка включена, ну я в монитор и смотрю, а там тянка сидит и в моник смотрит, и мне говорит: "Ты чё? Ебанутый? Чё ты там делаешь?". Тян, кстати, всё время какие-то тпэшные паблики читает, чтобы репостить часто, репостит по 5 раз в день, а потом говорит, что глаза устают, и ещё спамит она! Пиздец короче! Реальная история. Я не тролль.',
      'Когда мне было 15 лет, и я варил мет мистер Уайт всё время как-бы невзначай крутился возле лабы, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, мистер Уайт ругался, если я варю и не надеваю противогаз, причём не просто во время щелочения, а на продолжении всей варки, мотивировал это тем, что токсично, и сам потом мне говорил: вот я противогаз надену, вытяжку включу, и ты так делай! однажды я стал варить, и слышу, мистер Уайт где-то у двери встал в отдалении, ну я алюминий засыпал, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там мистер Уайт на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? мистер уайт кстати всё время какие-то травы пьёт, чтобы варить часто, варит по 5 раз в день, а потом говорит, что рак у него, и ещё свояк у него агент обн. пиздец короче! реальная история. Я не сука',
      'Когда мне было 19 лет, и мы путешествовали во времени, Доктор всё время как бы невзначай крутился возле ТАРДИС, и всё спрашивал, что ты там затихла, почему тебя не слышно? первый раз я не ответила, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще активирует аварийный протокол, алсо, Доктор ругался, если я перехожу между измерениями, причём не просто во времени и пространстве, а непосредственно между двумя вселенными, мотивировал это тем, что рушатся стены мироздания, и сам потом мне говорил: вот я закрываю брешь, и ты так делай! однажды я перенеслась в свой мир, и слышу, Доктор где-то у стены встал в отдалении, ну я бластер положила, и на пол накарачики присела, а там щель очень широкая снизу у стены, ну я в щель и смотрю, а там Доктор на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутая? чё ты тут делаешь? Доктор кстати всё время какие-то травы пьёт, чтобы путешествовать во времени, спасает мир по 5 раз в день, а потом регенерирует, и ещё оружие не носит. пиздец короче! реальная история. я Роуз Тайлер.',
      'Когда мне было 15 лет, и я изучал квантовую механику, бятя всё время как-бы невзначай крутился возле комнаты, и всё спрашивал, что ты там затих, жив ты или мертв? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, батя ругался, если я провожу двухщелевой опыт, причём не просто после интерферирования фотона, а непосредственно после вылетания из щели, мотивировал это тем, что квант исчезает в другое измерение, и сам потом мне говорил: вот я ставлю детекторы около щелей и ты так делай! однажды я сел проводить опыт, и слышу, батя где-то у двери встал в отдалении, ну я поставил детекторы, и на пол накарачики присел к аппарату, а там две щели снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то опыты проводит, чтобы перемещаться по измерениям, путешествует по 5 раз в день, а потом говорит, что жопу жжёт, и ещё пердит он. пиздец короче! реальная история. я Томас Юнг',
      'Когда мне было 44 года, и я работал над Android Project Butter, Romain Guy всё время как-бы невзначай крутился возле моего офиса и всё спрашивал: "Что ты там затих, почему от тебя коммитов на гитхаб не идет?" Первый раз я не ответил, так он начал ломиться в дверь и орать: "Что ты там молчишь, что с тобой?", начал материться по-французски и говорить, что вообще дверь с петель снимет, алсо, он ругался, если я не работаю над классом Choreographer, причём не просто допиливаю его, а непосредственно использую для синхронизации анимаций, мотивировал это тем, что происходит VSync, и сам потом мне говорил: вот я синхронизирую рендеринг с частотой обновления дисплея, поэтому плавные анимации получаются, и ты так делай! однажды я код писать сел и слышу, Romain где-то у двери встал в отдалении, ну я запустил проект на сборку и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Romain на карачиках сидит и в щель смотрит и мне говорит: ты чё? ебанутый? чё ты там кодишь? Он кстати всё время какие-то книжки читает по Java, чтобы коммитить часто, коммитит по 5 раз в день, а потом говорит, что у ведроблядей от списочков жжёт, и ещё фотакет он все подряд на зеркалку. пиздец короче! реальная история. я Chet Haase',
      'Когда мне было 15 лет, и я ходил на рок-фестиваль батя всё время как-бы невзначай крутился возле сцены, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться через толпу, и орать, что ты там не кидаешь козу, что с тобой? начал материться, и говорить, что вообще больше в клуб не возьмет, алсо, батя ругался, если я козу кидаю и ХОЙ не кричу, причём не просто в конце песни, а непосредственно после каждого припева, мотивировал это тем, что как позер, и сам потом мне говорил: вот я козу кину и ХОЙ кричу, и ты так делай! однажды я на концерт пошел, и слышу, батя где-то у сцены встал в отдалении, ну я в толпу подошел, и на пол на карачики присел, а там щель очень широкая снизу у толпы, ну я в ноги и смотрю, а там батя на карачиках сидит и через ноги смотрит, и мне говорит: Ты чё? Гопник? Чё ты там делаешь? батя кстати всё время какие-то портвейны пьёт, чтобы козу кидать часто, ХОЙ по 5 раз за песню орет, а потом говорит, что глодку жжёт, и ещё слемится он. панк короче! реальная история. я не репер',
      'Однажды в далекой стране тысячи лет назад гуляла принцесса в чудесном саду. Светило солнце, пели птицы и всюду веяло весной и радостью. Вдруг налетели черные тучи, засверкали молнии, подул промозглый северный ветер и перед принцессой с небес спустился чудовищный дракон. Казалось, конец уже близок и пала принцесса на колени и взмолила: - Не ешь меня! - Хорошо, но за это ты окажешь мне одну любую услугу, когда и где захочу. Согласилась принцесса, хотя и не знала, что вовсе не дракон это, а старый злой колдун ей явился. Прошло много лет, принцесса вышла замуж за принца, родила ему сына, они жили и радовались, горя не знали. И вот на семилетие маленького принца прямо посреди празднества разверзнулся пол замка и оттуда выползла гигантская змея. Проползла вокруг трона, подползла к королевской чете и превратилась в злого колдуна. - Настало время вернуть долг, принцесса,- сказал колдун,- я забираю к себе на воспитание маленького принца. Королевская охрана попыталась напасть на колдуна, на он одним словом превратил их в статуи. Делать было нечего, и пришлось подчиниться. Плачущая принцесса на прощание дала маленькому принцу свой амулет со словами: - В трудную минуту он тебе пригодится. Забрал к себе колдун маленького принца в черный замок на вершине черной горы. Посадил в подвал, закрыл на семь засовов, повесил семь замков и сказал что придет через семь дней. Принц сидел и ждал несколько дней, затем достал амулет и стал его рассматривать. Вдруг в голове услышал голос матери: - Что ты себе представишь, во то он и превратится. Представил принц лопату, и стал копать землю под ногами. Копал несколько дней пока не наткнулся на пласт твердой породы. Представил тогда принц себе кирку и стал долбить дальше. Очень долго он долбил, очень сильно устал. И вот из-под кончика кирки показался лучик света. - Я пробился наружу!-обрадовался принц. Он стал ковырять отверстие, но оно все равно было лишь несколько миллиметров. Тогда принц встал на колени, поднес голову к отверстию и посмотрел в него, а там с другой стороны на него колдун смотрит и говорит: -Ты чё? Ебанутый? Чё ты там делаешь? Колдун кстати всё время какие-то зелья пьёт, чтобы срать часто, срёт по 5 раз в день, а потом говорит, что жопу жжёт, и ещё пердит он. Пиздец короче! Реальная история. Я летописец.',
      'Когда было 7 ноября 41 года, и я учавствовал в параде на Красной площади Сталин всё время как-бы невзначай крутился возле трибуны, и всё спрашивал, что вы там затихли, почему вас не слышно? первый раз солдаты в строю не ответили, так он начал ломиться вниз, и орать, что вы там молчите, что с вами? немцев испугались? начал материться, и говорить, что весь Московский гарнизон в штрафбаты сошлет, алсо, Сталин ругался, если мы не кричим "здравия желаем, товарищ верховный главнокомандующий!", причём не просто вконце парада, а непосредственно после каждой произнесенной им с трибуны фразы, мотивировал это тем, что мы воинскую дисциплину подрываем, и сам потом нам говорил: вот я солдат в строю увижу и кричу "здравствуйте, товарищи красноармейцы!", и вы так делайте! однажды я в кабину своего КВ сел и по брусчатке поехал, и слышу, Сталин где-то на трибуне встал в отдалении, ну я пот со лба вытер, и на пол накарачики присел, а там щель очень широкая снизу у пушки, ну я в щель и смотрю, а там Сталин на карачиках сидит и в ствол смотрит, и мне говорит: ти чё? ебанутий? чё ти там дэлаишь? Сталин кстати всё время какие-то приказы издает, чтобы наступать часто, наступает на немцев по 5 раз в день, а потом говорит, что надо больше заградительных отрядов, и ещё он трубку курит. пиздец немецко-фашистским захватчикам короче! реальная история. я механик-водитель',
      'Когда мне было 15 лет, и я ходил в сенат, Цезарь всё время как-бы невзначай крутился возле Капитолия, и всё спрашивал: "Что ты там затих, почему тебя не слышно?". Первый раз я не ответил, так он начал ломиться в дверь, и орать: "Что ты там молчишь, что с тобой?", - начал материться, и говорить, что вообще дверь с петель снимет, алсо, Цезарь ругался, если я хожу в сенат и не выступаю, причём не просто в конце заседания, а непосредственно после каждого пункта, мотивировал это тем, что тихо, и сам потом мне говорил: вот я пункт объявлю и выступаю, и ты так делай!',
      'Однажды я выступать встал, и слышу, Цезарь где-то у двери встал в отдалении, ну я свиток свернул, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там цезарь на карачиках сидит и в щель смотрит, и мне говорит: "Ты чё? ебанутый? чё ты там делаешь?". Цезарь кстати всё время какие-то травы пьёт, чтобы в сенат ходить часто, выступает по 5 раз в день, а потом говорит, что в горле першит, и ещё жестикулирует он. пиздец короче! Реальная история. Я не Брут.',
      'Когда я был президентом Украины, я ездил в Брюссель обсуждать вступление в Евросоюз. А Путин всё время как-бы невзначай приезжал в Крым, и всё спрашивал, что ты там затих, почему тебя не слышно? Первый раз я не ответил, так он начал повышать цены на газ, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще перекроет газ и сделает газопровод в обход Украины, алсо, Путин ругался, если я хотел вступить в Евросоюз, причём не просто в ВТО, а непосредственно в Евросоюз и НАТО, мотивировал это тем, что вот он не вступает и ты так не делай! И сам потом мне говорит: вот я создал таможенный союз "Россия, Беларусь, Казахстан", все вступили и вы вступайте! Однажды я поехал на саммит думал Евроинтеграцию подписать, и слышу, Путин за ходом саммита наблюдает в отдалении, ну я в кулуары зашел и жду Ангелу Меркель, и тут у меня Договор на кредиты МФВ случайно на пол упал, я нагнулся его поднять, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Путин на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Путин кстати всё время какие-то майские указы принимает, чтобы быть президентом часто, президентом становится каждые 5 лет, а потом говорит, что Навальный и вообще народ бунтует, и ещё за интернет плотно взялся он. пиздец короче! реальная история. я не президент',
      'Когда мне было 15 лет, и я служила в храме, Мима всё как-бы невзначай крутилась возле храма, и всё спрашивала: "Что ты там затихла, почему тебя не слышно?" Первый раз я не ответила, там она начала ломиться в храм, и орать: "Что ты там молчишь,что с тобой, - начала материться, и говорить, что вообще весь храм разрушит, алсо, Мима ругалась, если я не выхожу драться, причём не просто в конце службы, а непосредтвенно когда ей хочется, мотивировала это тем, что это для тренировки, и сама мне потом говорила: "Вот я кого встречу и дерусь с ним, и ты так делай!" Однажды я сидела в храме, и слышу, Мима где-то у барьера встала в отдалении, ну я подошла к стене, и на пол накарачики присела, а там щель широкая снизу в стене, ну я в щель и смотрю, а там Мима на карачиках сидит и в щель смотрит, и мне говорит: "Ты чё? Ебанутая? Чё ты там делаешь?" Мима кстати всё время какие-то спеллкарты применяет, чтобы в битвах побеждать всегда, применяет по 5 раз за битву, а потом говорит, что её все побеждают всегда, и ещё Марису так учит. Пиздец короче! Реальная история, я не ёкай.',
      'Когда я играл в тохо и проходил первые уровни сырна всё время как-бы невзначай крутилась по карте, и всё спрашивала, что ты там затих, почему не атакуешь? первый раз я не ответил, так она начала пускать сосульки, и орать, что ты там молчишь, что с тобой? начала стрелять, и говорить, что вообще сейчас ледяное кольцо скастует, алсо, сырна ругалась, если я уклоняюсь и не стреляю, причём не просто после её комбы-вомбы, а непосредственно после запуска сосулек, мотивировала это тем, что так быстрее проходится, и сама потом мне говорила: вот я выстрелю и уклоняюсь, и ты так делай! однажды я уровень запустил, и слышу, сырно где-то наверху встала в отдалении, ну я волшебную палочку приготовил, и начал от её кольца уклоняться, а там щель очень широкая снизу между льдинками, ну я в щель и смотрю, а там сырнолетает и в щель смотрит, и мне говорит: ты чё? бака? чё ты там делаешь? сырно кстати всё время какой-то эликсир пьёт, чтобы энергии набраться, орёт 129 по 5 раз в день, а потом говорит, что голова кружится, и ещё говорит что не бака. пиздец короче! реальная история. я не Рейму.',
      'Когда мне было 495 лет, и я ходила читать, Ремилия всё время как-бы невзначай крутилась возле библиотеки, и всё спрашивала, что ты там затихла, почему тебя не слышно? первый раз я не ответила, так она начала звать Сакую, и орать, что ты там молчишь, что с тобой? начала материться, и говорить, что вообще дверь с петель снимет, алсо, Ремилия ругалась, если я читаю и не убираю книгу на место, причём не просто вконце чтения, а непосредственно после закладывания страницы, мотивировала это тем, что беспорядок, и сама потом мне говорила: вот я почитаю и уберу книгу, и ты так делай! однажды я читать села, и слышу, Пачули где-то у двери встала в отдалении, ну я закладку заложила, и на пол накарачики присела, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Пачули на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутая? чё ты там делаешь? Ремилия кстати всё время какие-то травы пьёт, чтобы читать часто, читает по 5 раз в день, а потом говорит, что чай плохой, и ещё в подвале меня держит он. пиздец короче! реальная история. я не Фландре',
      'Когда мне было 17 лет и я ходила в Генсокё, Ренко как бы невзначай крутилась возле разлома и всё спрашивала: «Что ты там затихла? Почему тебя не слышно?» Первый раз я не ответила, так она начала ломиться в разлом и орать: «Что ты там молчишь, что с тобой?» — начала материться и говорить, что вообще в разлом за мной войдёт. Алсо, Ренко ругалась, если я хожу по Генсокё и не ищу север, причём не только под конец, возвращаясь домой, а непосредственно каждые пару минут. Мотивировала это тем, что я потеряюсь и навсегда останусь в Генсокё. И сама мне потом говорила: «Вот я хожу в Генсокё - и прям сразу ищу, где север! И ты так делай!» Однажды я пошла в Генсокё и слышу, как Ренко где-то у разлома встала в отдалении. Ну я к разлому подошла и на землю на карачки присела. А разлом там был широкий, ну я в него и смотрю. А там Ренко на карачках сидит, в разлом смотрит и мне говорит: «Ты чё, ебанутая? Чё ты там делаешь?» Ренко всё время какие-то карты рисует, чтобы точно не потеряться, правит их по пять раз в день, а потом говорит, что всё равно неправильно, и опять север ищет. Пиздец короче! Реальная история, я не Юкари.',
      'Когда мне было 15 лет и я читал реп, Эминем всё время как бы невзначай крутился возле студийки и всё спрашивал: что ты там затих, почему тебя не слышно? Один раз я не ответил, так он начал ломиться в дверь и орать: что ты там молчишь, что с тобой? Начал материться, и говорил, что вообще звукоизоляцию со стен снимет. Алсо, Эминем ругался, если я не делаю глубокий вдох перед читкой, при чём не просто перед припевом, а непосредственно перед каждым куплетом, мотивируя это тем, что в бит не попадаю, и сам потом мне говорил: вот я о иллюминатах читаю, и ты так делай! Однажды я трек записывать сел и слышу, как Эминем где-то у двери встал в отдалении, ну я минус врубил и на пол на карачках присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Эминем на карачках сидит и в щель смотрит, и мне говорит: ты че? Ебанутый? Че ты там делаешь? Эминем, кстати все время какие-то вещества пьет, чтобы выступать часто, выступает по 5 раз в день, а потом говорит, что рифмы плохо получаются, и еще «Aftermath Drugs» раздает он. Пиздец короче! Реальная история. Я не тролль.',
      'Когда мне было 15 лет, и я хотел спать, призрак всё время как-бы невзначай крутился возле комнаты, и всё спрашивал: что ты там затих, почему тебя не слышно? Первый раз я не ответил, так он начал ломиться в дверь, скрипеть половицами, и орать: что ты там молчишь, что с тобой? Начал материться, и говорить, что вообще ночью задушит, алсо, призрак ругался, если я вешаю иконы и читаю псалмы, причём не просто в конце молитвы, а непосредственно после махания кадилом, мотивировал это тем, что эктоплазму жжёт, и сам потом мне говорил: вот я гремлю цепями, и ты так делай! Однажды я спать лег, и слышу, призрак где-то у двери встал в отдалении, ну я встал с кровати, и на пол на карачки присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там призрак на карачках сидит и в щель смотрит, и мне говорит: ты чё? Ебанутый? Чё ты там делаешь? Призрак кстати всё время каких-то духов вызывает, чтобы пугать меня часто, пугает по 5 раз в день, а потом говорит, что кот боится, и ещё материализуется в сортире он. Пиздец короче! Реальная история. Я не тролль.',
      'Когда мне было 15 лет, и я ездил на трамвае, кондуктор всё время как-бы невзначай крутился возле меня, и всё спрашивал, что ты там затих, почему ты не оплачиваешь проезд? Первый раз я не ответил, так он начал ломиться ко мне, и орать, чего не оплачиваешь, что с тобой? Начал материться, и говорить, что вообще ментов вызовет, алсо, кондуктор ругался, если я захожу и не оплачиваю, причём не просто в конце поездки, а непосредственно после входа в трамвай, мотивировал это тем, что заяц, и сам потом мне говорил: вот все заходят и оплачивают, и ты так делай! Однажды я в трамвай сел, и слышу, кондуктор где-то в толпы встал в отдалении, ну я мелочь достал, и на пол на карачики присел, а там щель очень широкая снизу в толпе, ну я в щель и смотрю, а там кондуктор на карачках сидит и в щель смотрит, и мне говорит: ты чё? Ебанутый? Чё ты там делаешь? Кондуктор кстати всё время какие-то проездные продает, чтобы ездить часто, продает по 5 раз в день, а потом говорит, что мелочи тысячу разменять нет, и ещё пердит он. Пиздец короче! Реальная история. Я не заяц.',
      'Когда мне было 17 лет, и я ходил в город, Юля, всё время как-бы невзначай крутилась возле меня, и всё спрашивала, куда ты идёшь, чего ты хочешь? первый раз я не ответил, так она вышла из кустов и начала шипеть, что ты там решил, что с тобой? начала ругаться, и говорить, что вообще не нужно ничего менять, алсо, Юля ругалась, если я шел в город, причём не просто шел, а непосредственно после разговора по рации, мотивировала это тем, что так заведено, так лучше и спокойней, и сама потом мне говорит: вот я просто знаю, и ты так делай! однажды я принял решение, и слышу, Юля где-то в кустах стоит в отдалении, ну я остановился, и на землю накарачики присел, а там щель очень широкая снизу в листьях, ну я в щель и смотрю, а там Юля на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там выбрал? Юля кстати всё время какие-то грибы сахаром посыпает, чтобы запасы на зиму делать, посыпает по 5 раз в день, а потом говорит, что так растут лучше, и ещё мешки заставляет носить. пиздец короче! реальная история. я не harem master',
      'Когда мне было 17 лет, и я отдыхал в шезлонге Ольга Дмитриевна всё время как-бы невзначай крутилась возле меня, и всё спрашивала, ты почему лежишь, почему ничем не занимаешься? первый раз я не ответил, так она подошла ближе и начала кричать, что ты уснул, что с тобой? начала ругаться, и говорить, что вообще настоящие пионеры так не делают, алсо, Ольга Дмитриевна ругалась, если я не шел за мешком с сахаром, причём не просто шел, а непосредственно после разговора про торт, мотивировала это тем, что надо отпраздновать возвращение Шурика, сюрприз сделать, и сама потом мне говорит: вот я мешок сахара притащу, и ты так делай! однажды я со Славей в медпункте лежу, и слышу, Ольга Дмитриевна где-то за дверью стоит в отдалении, ну я Славю в свитер одел, и на пол накарачики присел, а там щель очень широкая снизу под дверью, ну я в щель и смотрю, а там Ольга Дмитриевна на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Ольга Дмитриевна кстати всё время задания дает, чтобы я не прохлаждался, дает по 5 раз в день, а потом говорит, чтобы я галстук научился завязывать, и ещё столовую заставляет с Ульянкой убирать. пиздец короче! реальная история. я не пионер',
      'Когда я был на 4-м курсе Хогвартса и я ходил варить зелья, Снейп всё время крутился возле котла и всё спрашивал, что я там затих, почему тебя не слышно? Первый раз я не ответил, так он начал снимать баллы с моего факультета и говорить, что оставит меня отрабатывать после занятий, алсо, Снейп ругался, что я варю зелье и не смываю, причём не просто в конце занятий, а непосредственно после готовности костероста, мотивировал это тем, что воняет, а сам потом мне говорил: вот я сварю и сразу смываю, и ты так делай! Однажды пришёл я на зальеварение, слышу, Снейп где-то у камина встал в отдалении, ну я глаза ящерицы 4 раза кинул в зелье, к камину наклонился, а там дымоход в камине не очень широкий, ну я в камин и смотрю, а там Снейп на карачиках сидит и в щель смотрит, и мне говорит: ты чё? сквибанутый? чё ты там сварил? 10 баллов с рейвенкло! Снейп кстати всё время на травологию ходит и травы собирает, чтобы зелья варить часто, варит по 5 раз в день,а потом говорит, что котёл прожжёг, и ещё баллы снимает он. Мерлинова борода! Реальная история, я не маггл.',
      'Когда мне было 5 лет и наступала новогодняя ночь, батя каждый раз как бы невзначай пропадал из квартиры, а в скором времени появлялся Дедушка Мороз. Он все время крутился возле ёлки и спрашивал: "Хорошо ли ты себя вел в этом году? Кто расскажет дедушке стишок?" Первый раз я запнулся, так он начал подсказывать и подбадривать. Стал говорить, что вообще мешок с плеч снимет и вручит подарок без стишка. К тому же, Дед Мороз хмурил брови, если я плохо себя веду и не извиняюсь. Причем не просто в конце года, а непосредственно после проступка. Мотивировал это тем, что подарки дарят только хорошим детям. И сам мне потом говорил: "Вот сосед твой Ваня вазу разбил и сразу извинился. И ты так делай!" Однажды я залез под ёлку искать подарки, и слышу, Дед где-то у ёлки встал с другой стороны. Ну я обертку самого большого подарка развернул и голову поднимаю. А напротив Дед Мороз на карачках сидит и на меня смотрит, и мне говорит: "Ты что там делаешь? Ты невоспитанный? Подарки только после курантов!" Дед Мороз, кстати, все время дешевые конфеты раздает, чтобы стихи рассказывали чаще. Дети рассказывают по 5 раз за вечер, а потом говорят, что от конфет зубы болят. И еще у него на ногах батины ботинки. С новым годом, короче! Реальная история. Я до сих пор верю в Деда Мороза.',
      'Когда мне было 15 лет и я играл в Дарк Солс, батя все время как бы невзначай крутился возле меня и спрашивал ,что ты там затих, почему тебя не слышно? Первый раз я не ответил, так батя начал ломиться ко мне в комнуту и орать, что вообще дверь с петель снимет. Алсо, батя ругался, если я не приветствую поклоном призванных на помощь фантомов, причем не после призыва, а непосредственно после каждого убитого моба. Мотивировал это тем, что некультурно, и сам потом говорил: вот я нежить убью и поклоняюсь, и ты так делай! Однажды я играть сел и слышу батя вторгся где-то в отдалении. Ну я людоедку Милдред убил и к боссу пошел, а там у входа во владения Квилаг, щель очень широкая, ну я на карачки присел, в щель смотрю, а там батя на карачках сидит и в щель смотрит, и мне говорит : Ты что? Ебанутый? Ты что там делаешь? Батя кстати все время какой-то бесконечный итем использует, чтобы вторгаться часто, вторгается по пять раз в день, а потом говорит, что жопу жжет. А еще темный дух он. Пиздец короче. Реальная история, я не полый.',
      'Когда мне было 15 лет, и я был падаваном, Оби-ван всё время как-бы невзначай крутился возле Храма Джедаев, и всё спрашивал, что ты там затих, почему возмущений в Силе не слышно? первый раз я не ответил, так он начал размахивать световым мечем, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще в лаву сбросит, алсо, Оби-ван ругался, если я чувствую гнев, мотивировал это тем, что на Темную сторону ведет, и сам потом мне говорил: гнев рождает ненависть, ненависть — залог страданий! однажды я полетел на Мустафар наместника убить, и слышу, батя где-то в отдалении с Падме на звездолете сел, ну я на площадку вышел и Падме душить начал, а там в корабле каюта небольшая, а из нее Оби-Ван вышел, ну я на него и смотрю, а он и мне говорит: ты чё? ситх? только ситхи все возводят в абсолют! Оби-ван кстати всё время дроидов возит, чтобы говорить что мы не тех ищем, кидаеться на меня с мечем, а потом говорит, что если я убью его и еще могущественней станет, и ещё исчез он. пиздец короче! реальная история. я не Вейдер',
      'Когда я был магом огня 15 уровня, и я сидел в своей келье в монастыре Парлан всё время как-бы невзначай крутился возле кельи, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, он ругался, если я изготавливаю руны и не ложу щипцы на место, причём не просто вконце создания заклинания, а непосредственно после смешивания компонентов, мотивировал это тем, что от рунного камня едкий дым идёт, и сам потом мне говорил: вот я соединю кварц с аквамарином и убираю щипцы, и ты так делай! однажды я читал "Божественную силу звёзд", и слышу, Парлан где-то у двери встал в отдалении, ну я книгу отложил, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Парлан на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Парлан кстати всё время какие-то травы пьёт, чтобы ману пополнять, кастует по 5 раз в день, а потом говорит, что жопу жжёт, и ещё Инносу молится он. пиздец короче! реальная история. я не слуга Белиара',
      'Когда я приплыл в Морровинд меня выпустили, и я ходил по Сейда Нину Фаргот всё время как-бы невзначай крутился возле таверны Аррилла, и всё спрашивал, где его кольцо, не находил ли я его? первый раз я сказал что у меня нет кольца, так он начал угрожать, и орать, что я выбрал неправильного босмера! начал материться, и говорить, что вообще стражу позовет, алсо, Фаргот ругался, если я хожу возле болота около таверны, причём не просто в любое время, а непосредственно после заката, мотивировал это тем, что нечего там ходить, и сам потом мне говорил: вот никто там не ходит, и ты не ходи! однажды я договорился с одним нордом обокрасть тайник Фаргота, увидел что он после заката шастает возле того болота и решил его осмотреть, и слышу, Фаргот где-то у дерева встал в отдалении, ну я к пустотелому пню подошел, и в режим подкрадывания присел, а там щель очень широкая в пне, ну я в щель и смотрю, а там Фаргот сидит и из щели смотрит, и мне говорит: что? в чем дело? ты преследуешь меня? оставь меня в покое! Фаргот кстати всё время какие-то зелья пьёт, чтобы бегать быстро, бегает в 5 раз быстрее, а потом говорит, что спасается от еженедельного ритуала "давайте потрясем Фаргота", и ещё сопит он. пиздец короче! реальная история. я не н\'вах',
      'Когда я был Чемпионом Сиродила, и я ходил воровать стражник всё время как-бы невзначай крутился возле меня, и всё спрашивал, что ты там делаешь, почему я тебя здесь вижу? первый раз я не ответил, так он начал гоняться за мной, и орать, что ты там делаешь, что с тобой? начал материться и говорить, что вообще в тюрьму отведёт, алсо, стражник ругался, если я одену маску Серого Лиса и убегаю, причём не просто при краже предмета, а непосредственно после надевания маски, мотивировал это тем, что я из гильдии воров, и сам потом мне говорил: жаль! а я надеялся, что ты будешь сопротивляться! однажды я дверь взламывать сел, и слышу стражник где-то у двери встал в отдалении, ну я замок вскрыл, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там стражник на карачиках сидит и в щель смотрит, и мне говорит: STOP RIGHT THERE, CRIMINAL SCUM! стражник кстати всё время какие-то сладкие рулеты жрёт, чтобы дежурить часто, дежурит по 5 раз в день, а потом говорит, что доспехи жмут, и ещё все видит он. пиздец короче! реальная история. я не рисованный тролль',
      'Когда я был Слышащим в Темном Братстве Скайрима, я ходил убивать по повелениям Матери Ночи. Стражник все время крутился возле очередной моей жертвы, и все спрашивал, постой-ка, дай угадаю, кто-то украл твой сладкий рулет? Слушай, это ведь не правда, что говорят про тебя и… и Тёмное Братство? Или правда? Первый раз я не ответил, так он выхватил меч и стал орать, что-ты там молчишь? неуважение к закону - неуважение ко мне, начал материться, и говорить, что вообще Император. Мёртв. Темные времена настали. Воистину, тёмные времена, алсо стражник ругался, если я сражаюсь и не убираю клинок, причем не в конце боя, а после каждого удара, мотивировал это тем, что стальными мечами удобно рубить с размаха, и колоть исподтишка, и сам потом мне говорил: вот я махну и прячу клинок, и ты так делай! Однажды я к жертве подошел, и слышу, стражник где-то у двери лавки Беллетора встал в отдалении, ну я клинок вытер, и на карачики в режим скрытности присел, а там щель очень широкая снизу у двери, ну я в щель смотрю, а там стражник на карачиках сидит, и мне говорит: Тссс… я знаю кто ты. Слава Ситису! Стражник кстати всё время какие-то зелья пьёт, чтобы его дорога приключений вела часто, ходит по 5 раз в день, а потом говорит, что ему колено простреливает, и ещё пердит он. пиздец короче! реальная история. я не тролль Удурфрукт.',
      'Когда я был 15 лвл, и я ходил саппортом, керри всё время как-бы невзначай крутился возле крипов, и всё спрашивал, что ты там затих, почему ты не инициируешь? первый раз я не ответил, так он начал ломиться один в два, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще в афк встанет, алсо, керри ругался, если я врываюсь и не вешаю экзост, причём не просто когда враги уже ушли, а непосредственно после удачного енгейджа, мотивировал это тем, что килл уходит, и сам потом мне говорил: вот я поукаю и влетаю, и ты так делай! однажды я в кусты пришёл, и слышу, керри где-то у башни встал в отдалении, ну я вард поставил, и реколлиться начал, а там щель очень широкая снизу у сайдбуша, ну я в щель и смотрю, а там керри на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? керри кстати всё время какие-то поты пьёт, чтобы бекаться редко, бекается 2 раза за игру, а потом говорит, что тима пидоры, и ещё флеймит он. пиздец короче! реальная история. я не тролль',
      'Когда мне было 18 лет, и я служил во внутренних воийсках охраняя Верховную Раду ультрас всё время как-бы невзначай крутился возле барикад, и всё спрашивал, зачем ты защищаешь преступную власть, почему ты стреляешь по журналистам? первый раз я не ответил, так он начал ломиться сквозь заслон силовиков, и орать, банду гэть, Слава Украине! начал кидать коктейль молотова, и говорить, что вообще возьмутся за оружие, алсо, ультрас ругался, если я кидаю светошумовую гранату и привязываю скотчем к гранате болты и гайки, причём не просто чтоб отпугнуть людей, а непосредственно в толпу протестующих, мотивировал это тем, что людей убивает, и сам потом мне говорил: вот мы воюем за народ, и ты так делай! однажды я стоял со щитом, и слышу, ультрас где-то у барикад встал в отдалении, ну я огонь от молотова потушил, и внутри черепахи накарачики присел, а там щель очень широкая снизу у щитов, ну я в щель и смотрю, а там ультрас на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? ультрас кстати всё время какие-то лозунги кричит, чтобы чтоб нападать часто, нападает по 5 раз в день, а потом говорит, что по ним стреляют, и ещё покрышки жжет он. пиздец короче! реальная история. я не титушка',
      'Когда мне было 15 лет и я ходил на митинги, беркут все время как-бы невзначай крутился возле меня, и всё спрашивал, что ты там затих, почему не жжешь. первый раз я не ответил, так он начал орать, что ты там молчишь, что с тобой? начал бить дубиной о щит, и говорить, что вообще майдан разгонит. Алсо, беркут ругался, если я бросаю в него камень и не ору "Слава Украине!", причем не когда все камни выброшу, а непосредственно после каждого камня, мотивировал это тем, что он орет "слава диктатору" после каждой гранаты и ты так делай. однажды я закинул коктейль молотова и смотрю беркут отошел назад немного. там еще температура от горения смеси большая. я сел на карачики посмотреть под автобус, как там горит. смотрю, беркут на карачиках за щитом сидит и кричит мне: ты чё? ебанутый? чё ты там делаешь? беркут, кстати, все время видео снимает о том, как издевается над гражданами. снимает по 5 видео на день. а потом говорит еще, что действует в рамках закона. Реальная история, я не провокатор.',
      'Когда я участвовал в очередной экспедиции на МКС и выходил в открытый космос, командир экспедиции всё время как-бы невзначай крутился возле шлюза, и всё спрашивал по рации, что ты там затих, почему тебя не слышно? Первый раз я не вышел на связь, так он начал ломиться в шлюз, и орать: «что ты там молчишь, что с тобой?». Начал материться, и говорить, что вообще шлюз вручную откроет. Ещё, командир ругался, если я не отчитываюсь о выполненных задачах, причём не просто в конце выхода в открытый космос, а непосредственно после выполнения задачи, мотивировал это тем, что там полно неожиданностей, и сам потом мне говорил: «Вот я сделаю что-то и сразу сообщаю об этом, и ты так делай!»',
      'Когда мне было 15 лет, и я ходил слушать сабатон бятя всё время как-бы невзначай крутился возле толчка, и всё спрашивал, что ты там затих, почему сабатон не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, батя ругался, если я слушаю сабатон и не сру кругами, причём не просто вконце срания, а непосредственно после конца каждой песни, мотивировал это тем, что надо быть генералом, и сам потом мне говорил: вот я генерал и смываю, и ты так делай! однажды я слушать сабатон сел, и слышу, батя где-то у двери встал в отдалении, ну я жопу вытер, и на пол на карачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя круги на карачиках нарезает и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время сабатон слушает, чтобы срать кругами, срёт по 5 раз в день, а потом говорит, что жопу жжёт, и ещё пердит минусовкой Primo Victoria он. пиздец короче! реальная история. я не тролль.',
      'Когда мне было 15 лет, и я был на концерте сабатона, броден всё время как-бы невзначай крутился на сцене, и всё спрашивал, что ты там затих, почему криков не слышно? первый раз я не ответил, так он начал топать на сцене, и орать "что ты там молчишь, не нравится штоль?" начал орать ещё громче, и говорить, что вообще на клавишных играть начнёт, алсо, бродену не нравилось, если я на его концерте не включаю сабатон в наушниках, причём не просто в начале концерта, а синхронно с каждой песней, мотивировал это тем, что впечатление не полное, и сам потом мне говорил: We are a panzer elite! однажды я пришел на концерт сабатона, и слышу, броден где-то у синтезатора встал в отдалении, ну я подпевал, и перед сценой накарачики присел, а там щель очень широкая снизу у синтезатора, ну я в щель и смотрю, а там броден на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там слушаешь, почему не сабатон? броден кстати всё время какие-то таблетки пьет, чтобы концерты устраивать часто, поёт и играет по 5 раз в день, а потом говорит, что пальцы болят и горло, и ещё очки носит он. пиздец короче! реальная история. я не тролль',
      'Когда мне было 20 лет я часто ходил в поход с ребятами, ставили палатки, и каждый раз Дятлов как бы невзначай крутился возле палатки и все спрашивал "что вы там затихли? почему вас не слышно?" как то раз мы не ответили так он начал ломится в палатку и орать "что вы там замолкли? что с вами?" начал матерится и говорить что вообще палатку порвет. Еще Дятлов ругался если мы палатку не на склоне ставили, причем не просто на склоне, а непосредственно на горе. Говорил вот я палатку за 300 метров от вершины поставил - и вы так делайте! Однажды спать легли и среди ночи слышим как Дятлов вылез и встал где то в отдалении, ну я палатку разрезал, на карачки стал, там щель такая широкая, ну я в щель и смотрю а там Дятлов на карачках сидит и в щель смотрит и мне говорит "Ты чё ебанутый? чё ты там делаешь?" Дятлов кстати все время какие то травы пьет, что бы в поход ходить часто, ходит по пять раз в месяц, пиздец короче, реальная история, я не Тибо-Бриньоль',
      'Когда мне было 25 лет, и я выступал на соревнованиях по биатлону в сочи, бьерндален всё время как-бы невзначай бежал рядом со мной, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он ломился со мной до самого стрельбища, и орал, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще винтовку отнимет, алсо, бьерндален ругался, если я промахиваюсь на стрельбище и не бегу штрафной круг, причём не просто в конце забега, а непосредственно после каждого огневого рубежа, мотивировал это тем, что не по правилам, и сам потом мне говорил: вот я промахнусь и пробегу штрафной круг, и ты так делай! однажды я бежал спринт, и слышу, бьерндален где-то в 10-ти метрах бежит в отдалении, ну я трассу пробежал, лыжи сложил, и на снег накарачики присел, а там щель очень широкая между лыжами когда их сложишь, ну я в щель и смотрю, а там бьерндален на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? бьерндален кстати всё время какие-то тиры посещает, чтобы стрелять метко, стреляет по 5 раз в день, а потом говорит, что винтовку жжёт, и ещё золото взял он. пиздец короче! реальная история. я не шипулин',
      'Когда мне было 15 лет, и я катался на всевозможной технике, батя всё время как-бы невзначай крутился рядом со мной, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал высовывать голову через зефир, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще в ЛОВД сдаст, алсо, батя ругался, если я в салоне сижу подолгу, причём не просто сразу после отправления, а непосредственно всю поездку, мотивировал это тем, что контры туда-сюда ходят, гоняют зайцев, и сам потом мне говорил: вот я отъеду, прозефирюсь, и на руф вылезу и ты так делай! однажды я в межке зефириться готовился, и слышу, шаги на руфе, батя где-то у встал в отдалении, ну я зефир раздвинул, и начал пролезать, а там щель очень широкая, ну я в щель лезу, а там батя на песочнице сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какую-то яжку пьёт, чтобы цеплять часто, катается по 5 раз в день, а потом говорит, что сознание какое-то слишком широкое, и ещё яркий и свободный он. пиздец короче! реальная история. я не Швец.',
      'Когда мне было 15 лет, и я играл в контру на одном сервере, админ всё время как-бы невзначай крутился рядом, и всё спрашивал, что ты там затих, почему не двигаешься? первый раз я не ответил, так он начал орать в микрофон, что ты там стоишь, ты афк чтоли? начал материться, и говорить, что вообще с сервера кикнет, алсо, админ ругался, если я стреляю и не перезаряжаюсь, причём не просто когда патронов мало остается, а непосредственно после каждого убийства, мотивировал это тем, что на зажим может не хватить, и сам потом мне говорил: вот я кого-нибудь убью и перезаряжаюсь, и ты так делай! однажды на дасте2 я сел с авп смотреть мид, и слышу, админ где-то у двери встал в отдалении, ну я двойной зум сделал и присел, а там щель между дверей очень широкая, ну я в щель и смотрю, а там админ тоже с авп на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? админ кстати всё время какие-то права раздает, чтобы народу больше на сервере играло, раздает по 5 раз в день, а потом говорит, что читеров много, и ещё банит он. пиздец короче! реальная история. я не аимщик.',
      'Когда я был молодой и жил в Афинах, Сократ всё время как бы невзначай крутился возле моих работ, и всё спрашивал, что ты там написал, почему тебя не слышно? первый раз я не ответил, так он начал ломиться через толпу учеников и орать, что ты там молчишь, что с тобой? начал полемизировать и говорить, что вообще мои утопические очерки о государстве выбросит, алсо, Сократ ругался, если я богов помяну и только традиционных называю, причём не просто ради словца, а непосредственно с глубоким почтением, мотивировал это тем, что воняет, и сам потом мне говорил: вот я старых богов отрину и новыми мораль молодёжи подрываю, и ты так делай! однажды я за Парфеноном поразмыслить сел и слышу, Сократ где-то у храма встал в отдалении, ну я диалектический разбор закончил, и на ступени накарачики присел, а там проходы очень широкие между колонами, ну я в проход и смотрю, а там Сократ на карачиках сидит и в проход смотрит, и мне говорит: ты чё? софист? чё ты там делаешь? Сократ кстати всё время вино пьёт, чтобы дискутировать часто, дискутирует по 5 раз на день, а потом говорит, что скоро его жопу отожгут, и ещё многим ненавистен он. гелиайнэ короче! реальная история. я Платон.',
      'Когда мне было 25 лет, и я работал сетевым инженером, начальник всегда как-бы невзначай крутился возле серверной, и все спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться и говорить, что сейчас вообще дверь с петель снимет, алсо, начальник ругался, если я меняю конфиги и не перезагружусь, причем не просто вконце настройки, а непосредственно после каждого сохранения, мотивировал это тем, что надежно, и сам потом мне говорил: вот я сохраню и перезагружаюсь, и ты так делай! однажды я бриджи настраивал, и слышу, начальник где-то у двери встал в отдалении, ну я веб-интерфейс закрыл, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там начальник на карачиках сидит и в щель смотрит, и мне говорит: ты че? ебанутый? че ты там делаешь? начальник кстати все время какие-то мануалы читает, чтобы настраивать лучше, настраивает по 5 шлюзов в день, а потом говорит, что голова болит, и еще глаза красные у него. пиздец короче! реальная история. я не нуб',
      'Когда я был молодым протоном, электрон все время как-бы невзначай крутился возле моей орбиты, и все спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться к ядру, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще поле нейтрализует. алсо, электрон ругался, если я излучаю и не поглощаю, при чем не просто в конце квантового перехода, а сразу после испускания, мотивировал тем, что стабильней, и сам потом мне говорил: вот я испущу и поглощаю, и ты так делай! однажды я переход начал, и слышу, электрон где-то у орбиты притих в отдалении, ну я стабилизировался, вошел во взаимодействие, а там переносчики силы быстро ходят, посылаю фотон, а там электрон такой же фотон шлет, и мне говорит: ты че? ебанутный? че ты там делаешь? электрон кстати все время какое-то ускорение принимает, чтоб орбираль менять часто, меняет по 5 раз в день, а потом говорит, что энергии нет, и еще коллапсирует он. пиздец короче! реальная история. я не кварк',
      'Когда мне было 15 лет, и я участвовала в олимпиаде Плющенко всё время как-бы невзначай крутился на льду, и всё спрашивал, что ты там катаешь, почему не короткую программу? первый раз я не ответила, так он вышел на лёд, и катался, ещё говорил моя очередь, почему со льда не уходишь? начал материться, и говорить, что вообще болт из позвоночника вытащит, алсо, Плющенко ругался, если я мало катаюсь назад, причём не просто так, а под музыку и после каждого тулупа, мотивировал это тем, что зрители не оценят, и сам потом мне говорил: вот я прокручусь и назад еду, и ты так делай! однажды я каталась, и слышу, Плющенко где-то у льда встал в отдалении, ну я откатала разминку, и на пол накарачики присела, а там щель очень широкая снизу у стенок льда, ну я в щель и смотрю, а там Плющенко на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутая? чё ты там упала? Плющенко кстати всё время спиной хрустит, чтобы кататься часто, катается по 5 раз в день, а потом говорит, что спина болит, и ещё дисквалифицировали его. пиздец короче! реальная история. я Липницкая.',
      'Когда мне было 20 лет, и я ходил за артефактами Лесник всё время как-бы невзначай крутился возле аномалии, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал кидаться болтами, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще больше меня на архианомалии не поведет, алсо, Лесник ругался, если я иду и болты не кидаю, причём не просто рядом с аномалиями, а непосредственно во время ходьбы в зоне, мотивировал это тем, что после выброса аномалии меняют расположение, и сам потом мне говорил: вот я кину болт и и иду, и ты так делай! однажды я за артефактом сел, и слышу, Лесник где-то у «Загребущих рук» встал в отдалении, ну я артефакт подобрал, и на землю накарачики присел, а там щель очень широкая между деревьями, ну я в щель и смотрю, а там Лесник на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Лесник кстати всё время какие-то антирадиационные таблетки жрет, чтобы собирать артефакты часто, собирает артефакты по 5 раз в день, а потом говорит, что руки жжет, и ещё фонит он. пиздец короче! реальная история. я не новичок',
      'Когда я досмотрел РМ, я был просто вне себя от печали. Шёл 3-й час ночи, а я всё бродил по дому и ронял скупые слёзы: «Нууу зачееем???!!! Зачем они убили её??!!! Её – самую няшную из всех кукол». Мне было больно, сердце разрывалось на части. Я подошёл к большому зеркалу в коридоре, и, прислонившись к нему щекой зарыдал. Внезапно мои глаза озарил яркий свет. Это был свет лился из зеркала. Он был сине-бирюзовым, и всё это было похоже на какой то портал. «Портал в Н-поле» - подумал я. После чего в зеркале начал появляться лёгкий силуэт: «Хина, ты ли это?» Я ещё сильнее вгляделся в портал, а там батя на карачиках сидит и в портал смотрит, и мне говорит: ты чё? ебанутый? Че ты там делаешь? Батя, кстати, всё время каких-то кукол мастерил. Сделал 7 штук и драться их заставил. А ещё пердел он. Трустори, я не Джун',
      'Когда у меня появился новый медиум Джун, и я жила в его доме Суигинто всё время как-бы невзначай крутилась возле моей комнаты, и всё спрашивала, что ты там затихла, почему не участвуешь в Игре Алисы? первый раз я не ответила, так она начала ломиться в дверь, и орать, что ты там молчишь, что с тобой? начала материться, и говорить, что вообще дверь с петель снимет, алсо, Суигинто ругалась, если я куклу Розена побеждаю и Мистическую Розу не забираю, причём не просто вконце Игры Алисы, а непосредственно после битвы, мотивировала это тем, что так угодно Отцу, и сама потом мне говорила: вот я противника побеждаю и сразу Мистическую Розу забираю, и ты так делай! однажды я шоу детектива Кун-Куна смотреть села, и слышу, Суигинто где-то у двери встала в отдалении, ну я с дивана слезла, и на пол накарачики присела, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Суигинто на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутая? чё ты там делаешь? Суигинто кстати всё время с моими сёстрами сражается, чтобы Мистические Розы собирать часто, собирает по 5 Роз в день, а потом говорит, что скоро она станет Алисой, и ещё Отца хочет увидеть она. пиздец короче! реальная история. я не кукла',
      'Когда мне был 61 год, и я возвращал территории, дух Сталина всё время как-бы невзначай крутился возле кремля, и всё спрашивал, ну что, СССР уже восстановил? первый раз я не ответил, так он начал снится мне по ночам, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще третью мировую устроит, алсо, Сталин ругался, если я захватываю территории по частям, мотивировал это тем, что запад не будет боятся, сам потом мне говорил: вот я беру страну и принимаю в состав СССР, и ты так делай! однажды я пошёл возвращать Крым, и слышу, Сталин где-то встал в отдалении, ну я на юго-восток наметился, а там русских много, решил провести там референдум, а там Сталин на карачках наблюдает за референдумом, и мне говорит: ты чё? ебанутый? чё ты делаешь? Сталин кстати всё время какие-то законы принимает, чтобы территории захватывать часто, по несколько республик в год присоединяет, а потом говорит, что Рузвельту жопу жжёт, и ещё репрессирует он. пиздец короче! реальная история. я не тролль',
      'Когда мне было 27 лет, и я перешел в Московский Спартак возле команды как-бы невзначай все время крутился какой то эстонский физрук в пуховике по имени Валера. Я все спрашивал у парней –где наш тренер, когда мы начнем работать с тренером? Я спросил у одного бразильского паренька-Where is our coach?, но он лишь сделал кислую мину, покачал головой со словами – A bola,bola и пошел в сторону столовой. После отбоя Валера все ходил по базе, стучал в комнаты и всё спрашивал, что ты там затих, почему тебя не слышно, я не понимаю тебя как игрока. Первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, Валера ругался, если вратарь не играет ногами и говорил, что тогда это не вратарь, и сам потом мне говорил: вот когда я выигрывал кубок Интертото в 2000 у нас вратарь охеренно играл ногами, и ты так делай! Однажды, когда мы отрабатывали штрафные я выбил мяч за площадку и решил его разыскать. Я прошел вдоль забора Тарасовки, ну я накарачики присел, а там щель очень широкая снизу у забора ну я в щель и смотрю, а Валера на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Фалькао к нам не поедет Ёпт. Валера кстати всё время в какие то квадраты в играет, говорит чтобы вторую звезду выиграть , играет часто по 5 раз в день, а потом говорит, что у Веллитона пятка болит, и ещё пердит он. пиздец короче! реальная история. Я не Инсаурральде.',
      'Когда мне было 15 лет и я ходил петь, Бока всё время как-бы невзначай крутился возле микрофона и всё спрашивал, что ты там затих, почему ты все еще не популярный? первый раз я не ответил, так он начал неистово потреблять чачу, и орать что-то про воровскую долю и Лос-Анджелес. начал материться, и говорить, что в Краснодар без меня поедет, алсо, Бока ругался, если я пою и не становлюсь легендарным, причём не просто после мирового турне и платинового альбома, а еще на этапе выступлений в пивнушках Баку и на детских утренниках, мотивировал это тем, что на одной сцене будет затмевать меня своей легендарностью, и сам потом мне говорил: вот я спою и сразу легендарным становлюсь, и ты так делай! однажды я в душе пел, и слышу, Бока где-то у двери встал в отдалении, ну я про вай-фай песню исполнил, и на пол на карачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Бока на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Бока кстати всё время какие-то травы за губу закидывает, чтобы петь часто, выступает по 5 раз в день, а потом говорит, что душу жжёт, что в голове ГОРЫ,в крови КОЧАРИ, в душе ДУДУК, в сердце АСТВАЦ. пиздец короче! реальная история. я не хач.',
      'Когда мне было 13 лет, меня первый раз опустили на сходочке, поэтому я всё время как-бы невзначай крутился возле БСМ, и всё спрашивал, что же они там затихли, почему их не слышно? первый раз я писал, что слежу за ними издалека, но им было все равно, так потом я начал каждый день писать в тред, и орать, что там собирается полнейшее дно - нарки, алкота, маргиналы и просто поехавшие. Сами мнят себя на борде няшами, а как что и туза могут твоего оприходовать. я вообще люблю материться в интернете и говорить всем, что они пидарасы, алсо, я ругался, если они не отвечают сразу, причём не просто сразу, а непосредственно после вылезания моего месседжа, мотивирую это тем, что я Дартаньян, а они пидоры! однажды я пошел на сходку, и слышу, стоят эти социобляди где-то у библиотеки, встал в отдалении, достал пиструн, и на пол накарачики присел, а у меня там щель очень широкая снизу, ну и дрочу, а там эти стоят в кольце да как заорут: хикканы? хиканчики? вы где? пидоры эти кстати всё время какие-то вина пьют, чтобы собираться часто, собираются по 3 раза в неделю, а потом пишут приходите все в 16:00 каждую СБ на БСМ,мне аж жопу жжёт, не вздумайте ходить,эти пидоры вас за жопу лапать будут и пытаться влезть в вашу мохнатую пещеру. пиздец короче! реальная история. я настоящий ананим',
      'Когда мне было 15 лет, и я начал гонять в Формуле-Форд батя всё время как-бы невзначай крутился в боксах, и всё спрашивал по радио, что ты там затих, почему не обгоняешь? первый раз я не ответил, так он начал орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще вместе меня в кокпит сядет, алсо, батя ругался, если я не хочу гонять за Макларен , причём не просто выступать за Маков, а непосредственно побеждать, мотивировал это тем, что гонки ради победы, и сам потом мне говорил: вот я выступал за Макларен, и ты так делай! однажды я в кокпит сел, и слышу, батя где-то у командного мостика встал в отдалении, ну я из болида вылез, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? ты почему не в кокпите? батя кстати всё время какие-то травы пьёт, чтобы гоняться часто, на трассу выезжает по 5 раз в неделю, а потом говорит, что жопу жжёт, и ещё постоянно с Роном Деннисом общается. пиздец короче! реальная история. я Кевин Магнуссен.',
      'Когда мне было позабытое за чередой личностей число лет и я покрывал их образами стены офиса Серебрянного Дождя, маэстро все время как бы невзначай крутился возле моего бастиона безумия и все спрашивал что ты там балаболишь почему кроме тебя никого не слышно? первый раз я не ответил а продолжил восхищать вас, дорогие мои, своими АБСОЛЮТНО НЕНОРМАЛЬНЫМИ персоналиями, так он начал атаковать мой слух звуком бьющихся в дверь ударов, и орать что ты там постоянно говоришь, что с тобой? начал материться и говорить что вообще вещание от эфира отключит, алсо, маэстро ругался, если я вношу сумбур в ваши головы и не прерываюсь на прослушивание нашего автоответчика, на который вы должны оставить свое имя, имя роли в которой как вам кажется я проснулся сегодня и свой контактный телефон, причем не после конца вещания а непосредственно во время раскрытия поразительных особенностей биографии меня сегодняшнего, мотивировал это тем что неугадывают, и сам потом мне говорил: вот я одну подробность расскажу и автоответчик слушаю, и ты так делай! однажды я сел окунаться в череду эпизодов по силе яркости сравнимых с неудержимым сиянием столь изощренного разума как мой сегодняшний и слышу маэстро где то встал в отдалении, ну я сиять образом закончил, диск с моими лучшими ролями двум победителям отправил и на пол накарачики присел а там щель очень широкая снизу у офиса, ну я в щель смотрю а там маэстро накарачиках сидит и в щель смотрит и мне говорит : ты че? ебанутый? ты че там облекаешь в пурпурные сцены давно минувших воспоминаний? маэстро кстати все время какие-то звуки дождливого вечера создает, что бы восхищать мой слух чаще а потом восхищает по 5 раз в день, а еще вещание ИЗ СУМАШЕДШЕГО ДОМА организовывает он, ШОУ-ТАЙМ короче. реальная история, я не демчог.',
      'Когда у меня было 15 лям сп, и я летал карибасить, цео всё время как-бы невзначай крутился возле аномальки, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в конво , и орать в локал, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще насканит сейчас , алсо, цео ругался, если я карибашу и не собираю лут, причём не просто вконце аномальки, а непосредственно после вырезания неписи, мотивировал это тем, что вреков много, и сам потом мне говорил: вот я убью крестик и сразу лучу, и ты так делай! Однажды я в санктум прилетел , и вижу, цео где-то на ближнем подскане завис , ну я непись убил, и на МВД потопил на него, а там грид не очень большой, ну я грид протопил и смотрю, а там цео на коверте сидит и разгон в мою сторону, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Цео кстати всё время какие-то бустеры пьет, чтобы ДПС выше был, крабит по 5 аномалек в день, а потом говорит, что скрабился, и ещё жабы толкает. пиздец короче! реальная история. я не Лиза',
      'Когда мне было 18 лет, и меня похитили культисты, Леон всё время как-бы невзначай крутился рядом, и всё спрашивал, что ты орешь, почему не отбиваешься? Первый раз я не ответила, так он начал палить по монахам, и орать, что ты там орешь, что с тобой? Начал материться, и говорить, что вообще Саддлера убьет наxyй, алсо, Леон ругался, если я попадаюсь и не сбегаю, причём не просто из заключения, а непосредственно после поимки, мотивировал это тем, что бесит, и сам потом мне говорил: вот на меня нападут - я отбиваюсь, и ты так делай! Однажды меня поймали, и слышу, Леон где-то у мониторов встал в отдалении, ну я поднялась, и в камеру посмотрела, а там объектив очень широкий у камеры, ну я в объектив и смотрю, а там Леон на карачиках сидит и в монитор смотрит, и мне говорит: ты чё? eбaнyтaя? чё ты там делаешь? Леон кстати всё время какие-то травы пьёт, чтобы здоровье восполнять, восполняет по 5 раз в день, а потом говорит, что жрать охота, и ещё мне под юбку смотрит. пи#дeц короче! реальная история. Я дочь президента',
      'Когда мне было 15 лет, и я отвечал на спрашивай.ру аноним всё время как-бы невзначай крутился возле моей странички, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал засыпать вопросами, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще перестанет задавать вопросы, алсо, аноним ругался, если я не отвечаю на вопросы правдиво, причём не только на серьезные вопросы, а непосредственно на все, мотивировал это тем, что ему интересно, и сам потом мне говорил: вот мне задают вопрос и я правдиво отвечаю, и ты так делай! однажды я на спрашивай зашел, и слышу, аноним где-то у новых вопросов встал в отдалении, ну я на вопрос дня ответил, и на ленту накарачики присел, а там щель очень широкая снизу у мобильного браузера, ну я в щель и смотрю, а там аноним на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Аноним кстати всё время какие-то травы пьёт, чтобы вопросы,задавать часто, спрашивает по 5 раз в день, а потом говорит, что редко отвечают, и ещё комментит он. пиздец короче! реальная история. я не подписчик',
      'когда у меня была 1000 кредитов, и я возил легальные грузы, агент Федерации всё время как-бы невзначай крутился возле Eravate, и всё спрашивал, что ты там в тихом режиме, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в крыло, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще суперкруиз перехватит, алсо, агент ругался, если я включаю тихий и не сбрасываю хит синк, причём не просто во время приземления, а непосредственно после запроса на док, мотивировал это тем, что обшивка греется, и сам потом мне говорил: вот я докну и сбрасываю, и ты так делай! однажды я на станцию сел, и слышу, агент где-то у корабля встал в отдалении, ну я нагрев сбросил, и на пол накарачики присел, а там щель очень широкая снизу у шлюза, ну я в щель и смотрю, а там агент на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутыйй? чё ты там делаешь? агент кстати всё время какие-то сканы груза делает, чтобы захватывать ковшом часто, по 5 раз в день, а потом говорит, что задницу греет, и ещё на вультуре таранит он. пиздец короче! реальная история. я не пират',
      'Когда мне исполнялось 33 года и я ходил на день рождения своего дядьки (мы в один день родились), ему тогда стукнуло 111, мы с Туком буханули и пошли взрывать петарды, а Гендальф всё время как-бы невзначай крутился возле повозки с феерверками, и всё спрашивал, что вы там затихли, может спиздить хотите чего? Первый раз мы не ответили, так он начал ломиться в повозку, и орать, что вы там молчите, что с вами? Но он старый был, и не спалил нас короче. А когда мы дракона запустили, так он начал материться, и говорить, что вообще повозку эту всю взорвет и колёса у ней с осей снимет, алсо, он ругался, если мы что-то спиздили, причем не в конце кражи, а непосредственно перед попыткой, мотивировал это тем, что только в Пустоши Смауга, и сам потом нам говорил: вот я спизжу что-нибудь, и никто даже и не знает, и ты так делай! Однажды я забухал в таверне "Горцующий пони", и слышу, Странник где-то у двери встал в отдалении, ну я пинту поставил, и на пол накарачики присел, а там щель очень широкая снизу под стойкой, ну я в щель и смотрю, а там Странник на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? где Гендальф? чё ты там делаешь? Гендальф кстати всё время какие-то травы воскуривает, чтобы жить вечно, живет по 5 эпох, а потом говорит, что Кольцо ему не нужно вовсе, и ещё бородат он. пиздец короче! реальная история. я не оркс',
      'Когда мне было тысяча лет, и я отправлял орков воевать хоббиты всё время как-бы невзначай крутились возле Мордора, и всё спрашивали, что ты там затих, почему тебя не слышно? первый раз я не ответил, так они начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начали материться, и говорить, что вообще на орлах прилетят, алсо, хоббиты ругались, если я орков отправляю и не предупреждаю, причём не просто орков, а непосредственно хачей на слонах, мотивировали это тем, что воняет, и сами потом мне говорили: вот мы на орлах летаем а не катапультой, и ты так делай! однажды я думать сел, и слышу, хоббиты где-то у черных врат встали в отдалении, ну я с отрханка слез, и на землю накарачики присел, а там щель очень широкая снизу у ворот, ну я в щель и смотрю, а там Арагорн на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Хоббиты кстати всё время какие-то лембасы едят, чтобы на орлах летать часто, летают по 5 раз в день, а потом говорят, что можно катапультой, и ещё шелоб убили они. пиздец короче! реальная история. я не Саруман',
      'Когда мне было тридцать лет и я ходил по гоблинским пещерам Голлум всё время как-бы невзначай крутился возле воды, и всё спрашивал, кто там во тьме, почему тебя не слышно-с? первый раз я не ответил, так он начал плыть, и орать, что ты там молчишь, что с тобой, моя прелесть? начал материться, и говорить, что вообще съест меня, алсо, Голлум ругался, если он загадывает загадку, а я не отвечаю, причём не просто вконце размышления, а непосредственно после произнесения загадки, мотивировал это тем, что я вкусный и сочный, и сам потом мне говорил: вот ты загадаешь и я отвечаю, и ты так делай-с! однажды я разгадывать пошел, и слышу, Голлум где-то между скал встал в отдалении, ну я загадку разгадал, и на пол накарачики присел, а там щель широкая между скал, ну я в щель и смотрю, а там Голлум на карачиках сидит и в щель двумя светящимися глазами смотрит, и мне говорит: ты чё? моя прелесть, ебанутый? чё ты там делаешь-ссс? Голлум кстати всё время какое-то кольцо носит, чтобы жить дольше, живёт уже 600 лет, а потом говорит, что солнце жжёт, и ещё шипит он. пиздец короче! реальная история. я не тролль',
      'Когда мне было 30 лет, и я сидел в темнице бятя всё время как-бы невзначай крутился возле двери, и всё спрашивал, я ли убил Джоффри, хочешь, чтоб тебя казнили? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, я сейчас стражников позову? начал материться, и говорить, что я вообще не его сын, алсо, батя ругался, если я убиваю племянника и не сознаюсь в этом, причём не просто сразу после убийства, а непосредственно перед казнью, мотивировал это тем, что Ланистеры всегда платят свои долги, и сам потом мне говорил: вот я убью и сразу признаю это, и ты так делай! однажды я шёл по застенкам, и слышу, батя где-то сел срать в отдалении, ну я вскинул арбалет, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и засунул арбалет, а там батя с голой жопой стоит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то травы пьёт, чтобы золотом срать, срёт по 5 раз в день, а потом говорит, что жопу жжёт, и ещё долги вечно платит он. пиздец короче! реальная история. я не убивал Джоффри.',
      'Когда мне было 80 лет и я восходил на гору Хорив, чтобы говорить со Всевышним, народ Израиля всё время как-бы невзначай крутился возле горы, и всё вопрошал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так они начали мастерить Золотого Тельца, и вопиять, что ты там молчишь, что с тобой? начали роптать, и говорить, что вообще обратно в Египет уйдут, алсо, народ Израиля роптал, что у Всевышнего нету никакого подобия, мотивировал это тем, что наглядности нет, и сами потом мне говорили: вот у других народов идолы есть, и ты нам их сделай! однажды я вошел в Святая Святых, и слышу, Иегошуа где-то у занавеси встал в отдалении, ну я со Всевышним поговорил, и на пол накарачики присел, а там щель очень широкая снизу у завеси, ну я в щель и смотрю, а там Иегошуа на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Народ Израиля кстати всё время какую-то хуйню творит, чтобы Б-га гневить, гневит по 5 раз в день, а потом говорит, что Б-г небесным огнем их жжет, и ещё пердят они. пиздец короче! реальная история. я Моше.',
      'Когда мне было 26 лет и работал следаком в ментовке, начальник следствия всё время как-бы невзначай крутился возле моего кабинета и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще нахер меня подставит и уволит, алсо, начальник ругался, если я бандита отмазываю а ему бабло не заношу, причём не просто вконце производства, а непосредственно после сразу после отмаза, мотивировал это тем, что бабла на "BMW" ему не хватает, и сам потом мне говорил: вот я отмажу - и начальнику РО заношу, и ты так делай! однажды я закрывать дело сел, и слышу, начальник где-то у двери встал в отдалении, ну я дело и баблосы в сейф спрятал, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там начальник на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? начальник кстати всё время какие-то хитровыебанные схемы придумывает, чтобы бабло с бандосов брать, берёт по 5 раз в день, а потом говорит, что кошелёк распирает, и ещё западлит он. пиздец короче! реальная история. я не прокурор',
      'Когда мне было 15 лет и я ходил в магазин 24/7, батя всё время как-бы невзначай крутился возле магазина, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, батя ругался, если я оплачиваю и не считаю сдачу, причём не просто отойдя от кассы, а непосредственно после получения сдачи, мотивировал это тем, что обсчитывают, и сам потом мне говорил: вот я получу и считаю, и ты так делай! однажды я зашёл в магазин, и слышу, батя где-то у двери встал в отдалении, ну я монетку уронил, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то вина пьёт, чтобы считать часто, считает по 5 раз в день, а потом говорит, что маца не прожарилась, и ещё учит теологию он. пиздец короче! реальная история. я не гой',
      'Когда мне было 14 лет, и я ходил в NERV Гендо всё время как-бы невзначай крутился возле Евы-01, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в капсулу, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще Рей Аянами вместо меня посадит, алсо, Гендо ругался, если я с Ангелами сражаюсь и хитрый план не применяю, причём не просто вконце битвы, а непосредственно перед тем как Евангелион в хлам раздолбят, мотивировал это тем, что ремонт крайне дорогой, и сам потом мне говорил: вот я хитрые планы составляю, и ты так делай! однажды я в капсулу сел, и слышу, Гендо где-то у Евы встал в отдалении, ну я из кресла вылез, и на пол накарачики присел, а там щель очень широкая снизу у двери капсулы, ну я в щель и смотрю, а там Гендо на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Гендо кстати всё время с какими-то старцами из SEELE совещания проводит, чтобы хитрые планы разрабатывать часто, совещается по 5 раз в день в позе Злой Посол, а потом говорит, что жопу жжёт, и ещё комплементацию готовит он. пиздец короче! реальная история. я не ОЯШ',
      'Когда мне было 4 года и я ходил играть в футбол, мой батя всё время как бы невзначай крутился возле поля, и всё спрашивал, что ты там затих, почему тебя не слышно? Первый раз я не ответил, так он начал ломиться в дверь коробки, и орать, что ты там молчишь, что с тобой? Начал материться и говорить, что вообще дверь с петель снимет, алсо, батя ругался, если я играю и не забиваю, причём не просто со штрафных, а непосредственно после каждой атаки, мотивировал это тем, что он легенда, и я таким же должен быть. И сам потом мне говорил: вот я забью и воздушные сиськи мну, и ты так делай! Однажды я играть пошел и слышу, батя где-то у двери коробки встал в отдалении, ну я забил гол и на газон на карачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Батя кстати всё время какие-то травы пьёт, чтобы забивать часто, забивает голы по 5 раз в день, а потом говорит, что ноги жжёт, и ещё сиськи воздушные мнет он. Пиздец короче! Реальная история, я не тролль.',
      'Когда мне было 47 лет, и я ходил в Газпром Украина всё время как-бы невзначай крутилась возле газовой трубы, и всё спрашивала, что ты там затих, почему тебя не слышно? первый раз я не ответил, так она начала ломиться в Международный арбитражный суд, и орать, что ты там молчишь, что с тобой? начала материться, и говорить, что вообще теперь за газ платить не будет, алсо, Украина ругалась, если я контракт предлагаю и скидку не предоставляю, причём не просто вконце полной оплаты, а непосредственно после подписания контракта, мотивировала это тем, что цена нерыночная, и сама потом мне говорила: вот я контракт подпишу и сразу скидку прошу, и ты так делай! однажды я решил газ за неуплату отключить, и слышу, Украина где-то у газовой трубы встала в отдалении, ну я вентиль закрутил, и на пол накарачики присел, а там щель очень широкая снизу у трубы, ну я в щель и смотрю, а там Украина на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Украина кстати всё время какие-то переговоры с Евросоюзом ведёт, чтобы реверсные поставки газа организовать, переговаривается по 5 раз в год, а потом говорит, что МВФ кредит не даёт, и ещё в НАТО хочет она. пиздец короче! реальная история. я не Миллер',
      'Когда мне было 50 лет, и я ходил в Верховную Раду сепаратисты Юго-Востока всё время как-бы невзначай крутились возле административных зданий, и всё спрашивали, что ты там затих, почему тебя не слышно? первый раз я не ответил, так они начали ломиться в ОГА, и орать, что ты там молчишь, что с тобой? начали материться, и говорить, что вообще отделяться будут, алсо, сепаратисты ругались, если я для подавления протестов армию использую и оружие применять разрешаю, причём не просто вконце митингов, а непосредственно после захвата зданий ОГА, мотивировали это тем, что негуманно, и сами потом мне говорили: вот мы протестуем и оружие не применяем, и ты так делай! однажды я антитеррористическую операцию на Юго-Востоке объявил, и слышу, сепаратисты где-то у Донецка и Луганска встали в отдалении, ну я отдал приказ штурмовать Славянск и Мариуполь, и перед телевизором на пол накарачики присел, а там камера очень широкая передает репортаж с места событий, ну я в телевизор и смотрю, а там сепаратисты на карачиках сидят и в камеру смотрят, и мне говорят: ты чё? ебанутый? чё ты там делаешь? сепаратисты кстати всё время какие-то референдумы проводят, чтобы мирных жителей не убивали часто, проводят по 5 референдумов в день, а потом говорят, что теперь Донецк и Луганск независимыми республиками будут, и ещё власть в Киеве не признают они. пиздец короче! реальная история. я не и.о. президента Украины',
      'Когда мне было 23 года, и я играл в ТФ бятя всё время как-бы невзначай крутился возле спауна, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, батя ругался, если я убиваю и не таунтю, причём не просто вконце раунда, а непосредственно после килла, мотивировал это тем, что как ф2п, и сам потом мне говорил: вот я убиваю и таунтю, и ты так делай! однажды я играть сел, и слышу, батя где-то у спауна встал в отдалении, ну я перезарядился, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то киллстрики крафтит, чтобы убивать часто, убивает по 5 раз за жизнь, а потом говорит, что глаза горят, и ещё трейдится он. пиздец короче! реальная история. я не мепт',
      'Когда мне было 20 лет, и я ходил ботать матан и урматы в бомбарь под ГЗ МГУ, мой препод по матану всё время как-бы невзначай крутился возле гермы, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще герму с петель снимет, алсо, мой матанист ругался, если я интегрирую и не оставляю константу, причём не просто вконце интегрирования, а непосредственно после каждого вспомогательного интеграла, и мотивировал это тем, что это формально правильно, и сам потом мне говорил: вот я возьму интеграл по частям и ставлю константу, и ты так делай! однажды я уравнение теплопроводности решать сел, и слышу, матанист где-то у гермы встал в отдалении, ну я функцию Грина досчитал, и на пол накарачики присел, а там щель очень широкая снизу у гермы, ну я в щель и смотрю, а там препод на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? матанист кстати всё время какие-то травы курит, чтобы размерность своего воображения повышать часто, расширяет сознание по 5 раз в день, а потом говорит, что реальный мир скучен, и ещё он пытается сделать тессеракт в трехмерном мире. пиздец короче! реальная история. я не гуманитарий',
      'Когда мне было 15 лет, и я ходил в пустоши батя всё время как-бы невзначай крутился в радиорубке, и всё спрашивал по рации, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал стучать рацией, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще с тобой ходить будет, алсо, батя ругался, если я не пишу отчеты, причём не просто вконце вылазки, а непосредственно после вылезания за гермодверь, мотивировал это тем, что точнее, и сам потом мне говорил: вот я выйду и начинаю составлять отчет, и ты так делай! однажды я вышел в пустоши, и слышу, батя где-то в рацию дышит в отдалении, ну я рацию достал, и к уху поднес, а там динамик такой громкий, ну я подношу к уху, а там батя дышит и попердывает, и как заорет: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то карты рисует, чтобы округу лучше знать, ходит в пустоши по 5 раз в день, а потом говорит, что жопу жжёт, и ещё по рации переговаривается он. пиздец короче! реальная история. я не мутант',
      'Когда мне было 33 года, и меня вели на голгофу, Понтий Пилат всё время как-бы невзначай крутился возле меня, и всё спрашивал, много ли истязаний выдержишь, может тебя распять? первый раз я не ответил, так он приказал меня пытать, и орал, что ты не молчишь, почему себя сыном божьим называешь? начал материться, и говорить, что вообще распянет меня, алсо, Понтий ругался, если я чудеса свершаю, причём не просто по итогу мирского пути, а непосредственно после совершения каждого чуда, мотивировал это тем, что такое разум смущает, и сам потом мне говорил: вот я свершу что-нибудь и всем говорю, что это по воле императора римского, и ты так делай! однажды я себя царем иудейским объявлял, и слышу, Понтий где-то у двери синагоги встал в отдалении, ну я речь прервал, и на пол на карачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Понтий на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Иуда кстати всё время какие-то серебрянники в карманы прячет, чтобы предавать легче было, к первосвященникам бегает по 5 раз в день, а потом говорит, что душу жжёт, и ещё апостол он. пиздец короче! реальная история. я не бог',
      'Когда мне было 24 года, и я ходил модерировать вк дуров всё время как-бы невзначай крутился онлайн, и всё спрашивал, что ты там читаешь, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в лс, и орать, что ты там смотришь, что с тобой? начал материться, и говорить, что вообще уволит за такую хуйню, алсо, дуров ругался, если я модерирую и не удаляю нарушителей, причём не просто вконце проверки, а непосредственно после вылезания жалобы, мотивировал это тем, что вконтакте всегда заботится о вашей безопасности, и сам потом мне говорил: вот я удаляю и ментов сбиваю, и ты так делай! однажды я чужие месаги читать сел, и слышу, дуров где-то у двери встал в отдалении, ну я пару ботов удалил, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там дуров на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? дуров кстати всё время какие-то провокационные посты пишет, чтобы срачи были часто, учавствует в срачах по 5 раз в день, а потом говорит, что всем жопу жжёт, и ещё шутит он. пиздец короче! реальная история. я не спамер',
      'Когда у меня была бета 1.5, и я ходил добывать алмазы херобрин всё время как-бы невзначай крутился возле шахты, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в шахту, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще телепортируется, алсо, херобрин ругался, если я добываю алмазы и не складываю в сундук, причём не просто вконце добычи, а непосредственно после выхода наружу, мотивировал это тем, что теряю, и сам потом мне говорил: вот я добуду и складываю, и ты так делай! однажды я добывать алмазы пошёл, и слышу, херобрин где-то в пещере встал в отдалении, ну я криперов отогнал, и на камень накарачики присел, а там проход очень широкий снизу под шахтой, ну я в проход и смотрю, а там херыч на карачиках сидит и в проход смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? херобрин кстати всё время какие-то x-ray устанавливает, чтобы алмазы добывать часто, добывает по 5 раз в день, а потом говорит, что сундуки переполняются, и ещё роняет алмазы в лаву он. пиздец короче! реальная история. я не нотч',
      'Когда мне было 10 лет, и я ходил гриферить в майнкрафт, админ всё время как-бы невзначай крутился возле моего дома, и всё спрашивал по скайпу, что ты там затих, почему тебя не слышно? первый раз я его нахуй послал, так он начал сундуки ломать, и орать, что ты там молчишь, что с тобой? начал сетать мой дом, и говорить, что вообще по айпи забанит, алсо, админ ругался, если я гриферю и не отдаю вещи, причём не просто после того, как админ придёт, а непосредственно после гриферства, мотивировал это тем, что выложет мой скайп и его переписку с моим батей, и сам потом мне говорил: вот я вещи гриферов простым игрокам раздаю, и ты так делай! однажды я одного чувака загриферил, и слышу, админ где-то у двери встал в отдалении, ну вещи в сундуки положил, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там админ в креативе на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? у админа кстати есть канал на ютубе, чтобы выкладывать анти-грифер шоу, снимает по 5 раз в день, а потом говорит, что у него миллион подписчиков и ещё с гриферами в реальной жизни встречается. пиздец короче! реальная история. я ДК_Дравен.',
      'Когда у меня был 15 уровень, и я нанимал войска некромант всё время как-бы невзначай крутился возле замка, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в ворота, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще замок штурмом возьмёт, алсо, некромант ругался, если я нанимаю армию и не улучшаю, причём не просто вконце найма, а непосредственно после приезда корованов с крестьянами, мотивировал это тем, что абилок нет, и сам потом мне говорил: вот я найму и улучшаюаю, и ты так делай! однажды я нанимать стал, и слышу, некромант где-то у замка встал в отдалении, ну я артефакты надел, и на обзорную башню накарачики присел, а там видимость очень хорошая над воротами, ну я туда и смотрю, а там некромант на обзорной башне на карачиках сидит и за ворота смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? некромант кстати всё время какие-то деньги читерит, чтобы нанимать армию часто, нанимает по 5 раз в месяц, а потом говорит, что у противников жопу жжёт, и ещё артефакты лишние скидывает он. пиздец короче! реальная история. я не энротец',
      'Когда мне было 15 лет, и я был юнгой, Джереми всё время как-бы невзначай крутился возле кормы, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, Джереми ругался, если я заряжаю пушку и не стреляю, причём не просто в конце раунда, а непосредственно после подачи ядра, мотивировал это тем, что эрафийские корабли иначе не берутся, и сам потом мне говорил: вот я заряжаю и стреляю, и ты так делай! однажды я начал заряжать пушку, сел, и слышу, Джереми где-то у полубака встал в отдалении, ну я порох всыпал, и на палубу накарачики присел, а там щель очень широкая снизу у пушки, ну я в щель и смотрю, а там Джереми на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Джереми кстати всё время какие-то заклинания использует, чтобы стрелять часто, стреляет из пушки по 5 раз за раунд, а потом говорит, что таталийские порты сожжет, и ещё с вейта ходит он. пиздец короче! реальная история. я не никс',
      'Когда мне было 30 лет, и я фьюдил с Шеймусом Винс всё время как-бы невзначай крутился возле ринга, и всё спрашивал, что ты там затих, почему гарпун не проводишь? первый раз я не ответил, так он начал лезть на ринг, и орать, почему ты ботчишь приемы, что с тобой? начал материться, и говорить, что вообще на Роял Рамбл меня не пустит, алсо, Винс ругался, если я провожу гарпун и не удерживаю, причём не просто вконце матча, а непосредственно после проведения гарпуна, мотивировал это тем, что меня букают, и сам потом мне говорил: вот Эдж проводил гарпун и удерживал, и ты так делай! однажды я супермен панч Эмброузу провел, и слышу, Винс где-то у ринга встал в отдалении, ну я Эмброуза через канат выкинул, и на канвас накарачики присел, а там щель очень широкая снизу у первого каната, ну я в щель и смотрю, а там Винс на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Винс кстати всё время какие-то промо дает, чтобы шоу выходили часто, шоу выходят по 5 раз в неделю, а потом говорит, что Дикси Картеру жопу жжёт, и ещё пушит он. пиздец короче! реальная история. я не Батиста',
      'Когда мне было 23 года, и я ходил монтировать ролики сарик андреасян всё время как-бы невзначай крутился возле моего канала на ютубе, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в личку, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще страйк навесит, алсо, сарик ругался, если я снимаю обзор на его говно и выкладываю, причём не просто вконце монтажа, а непосредственно после выкладывания на ютуб, мотивировал это тем, что баттхёртит, и сам потом мне говорил: вот я сниму говно и зарабатываю на нём бабки, и ты так делай! однажды я монтировать сел, и слышу, сарик где-то у канала встал в отдалении, ну я нарезку сделал, и в интернете накарачики присел, а там страница сарика очень тупая снизу у днища, ну я на страницу и смотрю, а там сарик на карачиках сидит и на карамбу смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? сарик кстати всё время какие-то травы курит, чтобы говно снимать часто, снимает по 5 раз в два-три года, а потом говорит, что адекватные люди фейспалмят, и ещё баттхёртит он. пиздец короче! реальная история. я не ностальгиякритик',
      'Когда мне было 20 лет, и мы воевали на Армагедоне Комиссар всё время как-бы невзначай крутился возле моей химеры, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще нахуй расстреляет из лаз-пистолета, алсо, Комиссар ругался, если мы идем в бой и дохнем, причём не просто вконце атаки, а непосредственно после союзного артобстрела, мотивировал это тем, что расстреливать некого, и сам потом мне говорил: вот я крикну "За Императора!" и стреляю вам в спину, и ты пиздуй в бой! однажды я в химеру сел, и слышу, комиссар где-то у стаб-болтера встал в отдалении, ну я двигатель завел, и к курсовому болтеру накарачики присел, а там щель очень широкая справа от болтера, ну я в щель и смотрю, а там комиссар на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? комиссар кстати всё время какие-то молитвы читает, чтобы от хаоса уберечься, срёт по 5 раз в день, а потом говорит, что это варп-сущности вылазят, и ещё пердит он. пиздец короче! реальная история. я не шторм-труппер',
      'Когда мне было 34 года, и я попал в плен к дарк элдарам, Гомункул всё время как-бы невзначай крутился возле моей клетки, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал расчленять и сшивать меня, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще хуй на лоб пришьет, алсо, Гомункул ругался, если я не ору от боли, причём не просто вконце пытки, а непосредственно после каждого надреза, мотивировал это тем, что мало удовольствия, и сам потом мне говорил: вот я пытаю раба и он вопит, и ты так делай! однажды я кое как сел, и слышу, Гомункул где-то у клетки встал в отдалении, ну я кишки подобрал, и на пол накарачики присел, а там щель очень широкая между прутьев клетки, ну я в щель и смотрю, а там Гомункул на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Гомункул кстати всё время какие-то души пьёт, чтобы жить вечно, пьет по 5 раз в день, а потом говорит, что пьян от душ, и ещё слаанешист он. пиздец короче! реальная история. я не с крафтворлда',
      'Когда человечеству было 200 тысяч лет, и мы жили на своей планете, инопланетяне всё время как бы невзначай крутились возле орбиты Земли и всё спрашивали, что мы там затихли, почему нас не слышно? Первый раз мы не ответили, так они начали летать в атмосфере, и орать на своем, что мы там молчим, что с нами? Начали телепатировать, что вообще Землю с орбиты снимут, алсо, ругались, что мы засираем Землю мусором и не утилизируем его, причём не просто вконце года, а непосредственно после производства отходов, мотивировали это тем, что воняет, и сами потом нам говорили: вот мы намусорим и утилизируем, и вы так делайте! Однажды запустили спутник, и слышат, инопланетяне где-то у него зависли в отдалении, ну мы мусор выбросили в космос, и на прямую орбиту спутник сел, а там щель света образуется снизу у атмосферы, ну и в телескоп смотрят, а там инопланетянин в иллюминатор смотрит и говорит: вы чё? ебанутые? Чё вы там делаете? Они кстати всё время какие-то генетические программы выполняют, чтобы мусор не производить, утилизируют его по 5 раз в день, а потом говорят, что им атмосферу это только жжёт, и ещё двуполы они. пиздец короче! реальная история. я землянин.',
      'Когда мне было 12 лет я играл в доту и все время как-бы невзначай крутился около фонтана, меня все спрашивали, что ты там стоишь, почему не качаешься? первый раз я не ответил, все начали орать в микрофон и писать, что не качаешься, ты АФК? начали материться, и говорить, что вообще репорт кинут и мамку выебут, алсо, меня часто ругали, если я не добиваю крипов, причем не только своих, но и чужих, мотивируя это тем, что фармить надо, и сами мне потом говорили: вот мы добиваем и ты так делай! однажды я прибежал в потайную и слышу пудж где то в лесу встал в отдалении, ну я закуп сделал и в лес смотрю, а там пудж стоит и хук делает и мне пишет: ты че? ебанутый? что ты там делаешь? пудж кстати все время какие то закупы делает, чтобы вонять часто, воняет по 5 раз за игру, а потом говорит, что все фидят. пиздец короче, реальная история. я не школьник.',
      'Когда мне было 15 лет, и я играл в магию, батя всё время как-бы невзначай крутился возле стола, и всё спрашивал, что ты там затих, почему ты не кастуешь ничего? Первый раз я не ответил, так он начал ломиться ко мне в руку, и орать, хуле болты не кидаешь, что с тобой? Начал материться, и говорить, что вообще свой картон из деки заберет, алсо, батя ругался, если я передаю хотд ничего не разыграв, причём не просто в конце хода, а непосредственно после антапа, мотивировал это тем, что моноред, и сам потом мне говорил: вот я болт кинул в лицо, и ты так делай! Однажды я играть сел, и слышу, батя где-то в толпе встал в отдалении, ну я ход передал, и на пол на карачики присел, а там щель очень широкая снизу под столом, ну я в щель и смотрю, а там батя на карачках сидит и в щель смотрит, и мне говорит: ты чё? Ебанутый? Чё ты там делаешь? Батя кстати всё время как-то деку раскладывает чтобы карты шли, раскладывает по 5 раз в день, а потом говорит, что топдеки от бога, и ещё пердит он. Пиздец короче! Реальная история. Я не контроль.',
      'Когда я хожу в бой, серб всё время как-бы невзначай крутится возле компа, и всё спрашивает, что ты там стоишь в кустах, почему не нагибаешь? первый раз я не ответил, так он начал ломиться в ангар, и орать, что ты там покупаешь, что с тобой? начал материться, и говорить, что вообще танк понерфит, алсо, серб ругался, если я не пробиваю и не заряжаю голду, причём не просто после выстрела, а непосредственно перед ним, мотивировал это тем, что я все равно рак, и сам потом мне говорил: вот я голдой в топе ебашу, и ты так делай! однажды я играть сел, и слышу, серб где-то у ангара встал в отдалении, ну я расходники поставил, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там серб на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Серб кстати всё время какие-то акции делает, чтобы донатить часто, донатит по 5 раз в день, а потом говорит, что жопу жжёт, и ещё сливается он. пиздец короче! реальная история. я не тролль',
      'Когда я только начинал играть, и я ходил в рандом, муразор всё время как-бы невзначай крутился на ютубе, и всё ныл, когда там немцам апнут броню, почему их все пробивают? первый раз я не оценил, так он начал ныть ещё больше, и орать, что все голду заряжают, что арта так сильно дамажит? начал материться, и говорить, что вообще играть перестанет, алсо, муразор ругался, если я играю и не ною, причём не просто после очередного апа чего-то кроме тт, а непосредственно перед патчем, мотивировал это тем, что вг постоянно всё нерфит: вот я услышал про новый патч и сразу ною, и ты так делай! однажды я на ютуб зашёл, и слышу, муразор где-то новое нытьё выпустил, ну я видео включил, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там муразор на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? муразор кстати всё время на каком-то тапке играет, чтобы ныть часто, ноет по 5 раз в день, а потом говорит, что голду надо нерфить, и ещё бородатый он. пиздец короче! реальная история. я не артовод',
      'Когда мне было 20 лет, и я ходил снимать свадьбу жених всё время как-бы невзначай крутился возле меня, и всё спрашивал, что ты там наснимал, почему ничего не видно? первый раз я не ответил, так он начал смотреть в экран, и орать, что ты там не снимаешь, что с камерой? начал материться, и говорить, что вообще не заплатит и камеру со стедикама снимет, алсо, жених ругался, если я хожу есть и не снимаю, причём не просто вконце застолья, а непосредственно после окончания дискотеки, мотивировал это тем, что я бездельник, и сам потом мне говорил: вот мой свидетель выпьет и на мыльницу снимает, и ты так делай! однажды я снимать встал, и слышу, жених где-то у двери встал в отдалении, ну я видеосвет выключил, и на пол накарачики присел, а там щель очень широкая между входных дверей, ну я в щель и смотрю, а там жених стоит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? жених кстати всё время что-то пьёт, чтобы танцевать часто, танцевал уже 5 раз, а потом говорит, что трубы жжёт, и ещё орет он. пиздец короче! реальная история. я не фотограф',
      'Когда у меня был iPhone, и я заходил в Appstore iOS всё время как-бы невзначай слал push-уведомления, и всё спрашивал, что ты там не жмёшь, почему не обновляешь? первый раз я не обновил, так он начал ломиться на заблокированный экран, и орать, что ты там не жмёшь, что с тобой? начал «ругаться» и сообщать, что вообще код блокировки снимет, алсо iOS оповещал, если я смотрю на новые обновления и не устанавливаю, причём не просто вконце работы телефона, а непосредственно после вылезания уведомления, мотивировал это тем, что всё это улучшает, и сам потом мне пишет: вот мою выпустят новую версию и устанавливают, и ты так делай! однажды я играть сел, и слышу, iOS где-то у окна уведомлений завис в отдалении, ну я босса вынес, и в меню зашёл, а там щель у уведомлений очень широкая сверху у экрана, ну я в щель смотрю, а там уведомление iOS\'а выскакивает и будто на меня смотрит, и мне говорит: ты чё? лаганутый? чё ты меня не обновляешь? iOS кстати всё время какие-то приложения загружает, чтобы обновлять часто, обновляет по 5 раз в день, а потом говорит, что батарею тратит, и ещё звенит он. пиздец короче! реальная история. у меня не Андроид',
      'Во время службы попал я в ракетные войска и для облегчения жизни своей писал себе разные прожки старые бабки всё время как-бы невзначай крутились возле кабинета, и всё спрашивали, что ты там затих, почему тебя не слышно? первый раз я не ответил, так они начали ломиться в дверь, и орать, что ты там молчишь, что с тобой? начали материться, и говорить, что вообще дверь с петель снимут, алсо, они ругаются, если я компилю в дебаг режиме и отдаю заму, причём не просто вконце тестов, а непосредственно после дебага, мотивировал это тем, что лишний мусор, и сами потом мне говорили: вот мы скомпилим в релиз, и ты так делай! однажды я прожить сел, и слышу, бабки где-то у двери встали в отдалении, ну я в дебаге цикл прогнал, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там бабки на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? бабки кстати всё время какие-то мануалы читают, чтобы писать сразу в машинном коде, пишут в интел прям через хекс редактор, а потом говорят, что ассемблер надоел, и ещё не толкают в esi ссылки на функции. пиздец короче! реальная история. я не тролль',
      'Во дни моего чуднаго отрочества случалось, что когда я посѣщалъ closet, mon papа всякiй разъ какъ будто ненароком охаживался подлѣ него и приговаривалъ: "Чего же вы тамъ притихли, васъ совершенно не слыхать!". Случилось мне как-то разъ оставить его вопросъ безъ ответа и papa громко постучалъ в дверь, вопрошая повелитѣльнымъ тономъ: "Сударь, отчего же вы молчите? Что с вами такое происходитъ, извольте немедля объясниться!", бранился и угрожалъ позвать плотника, дабы онъ снялъ с петель двѣрь в closet. Так же papa бранил меня за то, что я не спускаю воду, сразу же едва опростравшись, сѣтуя на то, что смрадъ идет ужасный и поучалъ меня следовать своѣму примеру. Одинъ разъ, зайдя в closet, я услыхал, что papa стоит в некоторомъ отдалѣнии от двери. Я оправился и приселъ на полъ, дабы заглянуть в широкiй просвѣтъ между дверью и поломъ. Заглянувши в просвѣтъ я неимоверно изумился, увидевъ papa, точно такъ же сидѣвшего и смотрѣвшего в просвѣтъ на меня, который тотчасъ же воскликнулъ: "VOUS ÊTES COMPLÈTEMENT FOU? QU\'EST-CE QUE TU FAIS LÀ?!". Рapa, между прочимъ, постоянно употрѣбляетъ некие травяные снадобья, дабы исправно посѣщать closet по пяти раз на дню, а после жалуется, молъ афѣдронъ испускаетъ газы и нестерпимо жжетъ. Такой вот анекдотъ, господа! Правдивая история, ни капли смутьянства, уверяю васъ!',
      'Когда мне было 16 лет, и я садился писать треки, батя всё время как-бы невзначай крутился возле компа, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал звук мне выключать, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще ФЛ удалит, алсо, батя ругался, если пишу треки и не рендерю, причём не просто вконце работы в ФЛ, а непосредственно после сохранения, мотивировал это тем, что винда полетит, и сам потом мне говорил: вот я сохранюсь и отрендерю, и ты так делай! однажды я трек писать сел, и слышу, батя где-то у двери встал в отдалении, ну я наушники снял, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то глитчи слушает, чтобы писать часто, пишет по 5 треков в день, а потом говорит, что EDM-революцию сделал, и еще амен брейки сэмплирует он. пиздец короче! реальная история. я не мартин гэррикс.',
      'Когда меня поместили в камеру содержания, сотрудник фонда всё время, как бы невзначай, крутился возле стекла и все записывал, как я там стою, почему не двигаюсь. Первый раз он моргнул, и я к нему успел повернулся, так он начал бегать по всей комнате и орать, что объект изменил положение, начал материться и говорить, что вообще из фонда уволится. Алсо, сотрудник пугался, что я двигаюсь, когда он моргает, при чем не просто в рандомном направлении, а непосредственно в его сторону. Мотивировал это тем, что я за ним наблюдаю, потом записывал в отчет: вот я моргну, а он на меня двигается. А однажды ко мне в камеру сотрудников класса "D" запустили, чтобы они за мной убрались. Ну я дождался, пока они уйдут, а они дверь закрыть забыли, а там щель очень широкая осталась. Ну в щель вышел и смотрю, а там сотрудник фонда стоит и на меня смотрит, и мне говорит: "Ты чё? Евклид? Чё ты там делаешь?" Сотрудник этот, кстати, всё время какие-то капли в глаза капает, чтобы моргать реже. Моргает всего пять раз в день. А потом говорит, что глаза жжет. А еще не спит он. Пиздец короче! Реальная отчетность, я — SCP-173.',
      'Когда я работал в Daycare, и я ухаживал за покемонами, тренер всё время как-бы невзначай крутился возле Daycare, и всё спрашивал, что ты там затих, почему яиц нет? Первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? Начал материться, и говорить, что вообще дверь с петель снимет, алсо, тренер ругался, если я яйцо вылупляю и не проверяю статы, причём не просто в конце вылупления всех яиц, а непосредственно после одного, мотивировал это тем, что релизить надо, и сам потом мне говорил: вот я вылуплю одно и статы проверяю, и ты так делай! Однажды я за покемонами ухаживал и слышу, тренер где-то у двери встал в отдалении, ну я ходы переучил, и на пол на карачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там тренер на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Тренер кстати всё время какие-то хартскейлы ищет, чтобы мувки учить часто, учит по 5 раз в день, а потом говорит, что мувсет не подходит, и ещё гриндит он. Пиздец короче! Реальная история. я не Генгар.',
      'Когда мне было 20 лет, и я ходил играть на гитаре дядя всё время как-бы невзначай крутился возле репточки, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, дядя ругался, если я играю и не делаю соло, причём не просто вконце песни, а непосредственно после каждого припева, мотивировал это тем, что "одни нули", и сам потом мне говорил: вот я нули поиграю и соло запиливаю, и ты так делай! однажды мы с Мишей играть концерт пошли, и слышу, дядя где-то у стеков встал за кулисами, ну я дилэй покрутил, и на пол накарачики присел, а там щель очень широкая снизу между кабами, ну я в щель и смотрю, а там дядя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? дядя кстати всё время какие-то травы пьёт, чтобы играть быстро, гоняет свипы по 5 раз в день, а потом говорит, что руки жжёт, и ещё флойдом балуется он. пиздец короче! реальная история. я Джейк Боуэн',
      'Когда мне было 15 лет, и я ходил испорожняться в уборную, нависающую над рвом, отец всё время как-бы невзначай крутился возле городских стен, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал таранить ворота, и орать, что ты там молчишь, что с тобой? начал богохульствовать, и говорить, что вообще начнёт осаду замка, алсо, отец бранился, если я испорожняюсь и не приказываю закрыть откидной мост, причём не просто вконце испорожнения, а непосредственно после вылезания дерьма, мотивировал это тем, что дерьмо попадает в замок и разносит чуму, и сам потом мне говорил: вот я облегчусь и приказываю закрыть, и ты так делай! однажды я испорожняться сел, и слышу, отец где-то на осадной лестнице встал в отдалении, ну я доспехи надел, и на пол накарачики присел, а там щель очень широкая снизу для лучников, ну я в щель и смотрю, а там отец на лестнице стоит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? отец кстати всё время какие-то травы пьёт, чтобы в крестовые походы ходить часто, ходит по 5 раз в день, а потом говорит, что с нами бог, и ещё молится он. пиздец короче! реальная история. я не шут',
      'Когда я только прибыл на станцию, и я ходил запускать сингулярность, СЕ всё время как-бы невзначай крутился возле окна, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в аирлок, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще болты с аирлока снимет, алсо, СЕ ругался, если я эмиттеры врубаю, и не блокирую, причём не просто в конце запуска щилдов, а непосредственно после включения, мотивировал это тем, что триторы, и сам потом мне говорил: вот я врубаю, и блочу, и ты так делай! однажды я ускоритель запустил, и слышу, СЕ где-то у аирлока встал в отдалении, ну я ускоритель завинтил, и на пол на карачики присел, а там щель очень широкая снизу у аирлока, ну я в щель и смотрю, а там СЕ на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? СЕ кстати всё время какой-то риг носит, чтобы в космос выходить спокойно, выходит по 5 раз в день, а потом говорит, что лёгкие жжёт, и ещё кашляет он. пиздец короче! реальная история. я не тритор.',
      'Когда мне было 30 лет, и я воевал с колумбийцами за влияние, Ричард всё время как-бы невзначай крутился возле меня, и всё спрашивал, зачем ты это делаешь, с какой целью? первый раз я не ответил, так он начал галлюцинации устраивать, и орать, что ты там стараешься, ради чего? начал мне мертвых людей показывать, и говорить, что вообще ядерную войну устроит, алсо, Ричард ругался, если я убиваю людей и не объясняю зачем, причём не просто после убивания, а непосредственно после конца света, мотивировал это тем, что бессмысленно, и сам потом мне говорил: вот я ничего не объясняю, и ты так делай! однажды я банк грабил, и вижу, в хранилище деньги колумбийцев лежат, ну я охранников убил, и хранилище открыл, а там темнота такая, ну я в темноту и смотрю, а там мой батя мертвый сидит и на меня смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? я кстати всё время какие-то таблетки жру, чтобы убивать часто, жру по 5 штук в день, а потом психика по пизде идет, и ещё лебедей-мутантов вижу. пиздец короче! реальная история. я не Пардо',
      'Когда я был вторым пилотом, и заходил на посадку, КВС как-бы невзначай держал руку на РУДах , всё спрашивал, как там работает КГС на 10 ВПП, почему не включаю фары, и не слышно сигнала прохода ближнего привода? Первый раз я не ответил, так он начал на меня орать, что с тобой? Начал материться, и говорить, что вообще самолёт сейчас в пике скинет, алсо, он ругался, если я на в полете в болтанку АБСУ отключал, причём не просто в конце полёта, а непосредственно на эшелоне, мотивировал это тем, что РЛЭ не предусмотренно, и сам потом мне говорил: я ТКС С КУРС-ПНП синхронизирую и за штурвал весь полет не держусь, только тримерами нагрузку снимаю и ты так делай. Однажды я в пошел загрузку проверять в багажное отделение, и слышу, КВС где-то за дверью встал в отдалении, ну я беспалевно за баулами сныкался, и на пол на карачки присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там КВС на карачках сидит и в щель смотрит, и мне говорит: Андрюха ты чё ебанутый? Чё ты там делаешь? А еще он по приводам заходит постоянно и касалетки жрет, и пиздец кароче. Реальная история я не симмер.',
      'Когда мне было 15 лет, и я ходил в рейд рл всё время как-бы невзначай крутился рядом, и всё спрашивал, знаю ли я тактику? первый раз я не ответил, так он начал материться в тимспик, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дкп снимет, алсо, рл ругался, если я дамажу и не выхожу из луж, причём не просто в конце фазы, а непосредственно в момент появления лужи, мотивировал это тем, что хилы просаживаются по мане, и сам потом мне говорил: вот я в лужах не стою, и ты так делай! однажды я в текстуры провалился, и слышу, рл где-то встал в отдалении, а там щель очень широкая в текстурах, ну я в щель смотрю, а там рл стоит и в щель смотрит, и мне говорит: ты че? ебанутый? чё ты там делаешь? рл кстати всё время какие-то зелья пьёт, чтобы рейдить часто, рейдит по 5 раз в день, а потом говорит, что жопу жжёт, и ещё донатит он. пиздец короче! реальная история. я не краб',
      'Когда мне было 37 лет, и я подключался к Матрице, чтобы спасать остатки человечества, Морфеус всё время как бы невзначай крутился возле пульта оператора, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал орать мне в ухо, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще запретит мне выходить в Матрицу, алсо, Морфеус всегда ругался, если я не пристегивался, когда выпрыгивал из летящего вертолета, причем не просто в конце прыжка, а непосредственно после выпрыгивания из вертолета, мотивировал это тем, что я могу убиться, и сам потом мне говорил: вот я пристегнусь и прыгаю, и ты так делай! Однажды я собрался прыгать, и чувствую будто за мной кто-то наблюдает в отдалении, ну я рукой за шасси схватился, присел накарачики в воздухе и смотрю в щель между шасси и фюзеляжем, а там щель очень широкая снизу у фюзеляжа, ну я в щель и смотрю, а там Морфеус на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Морфеус кстати все время какие-то пилюли глотает разноцветные, чтобы быть в форме, пробивает головой кирпичные стены по 5 раз в день, а потом говорит, что голова болит, и еще стальные рельсы узлом завязывает и мне постоянно дает свои пилюли, и говорит что я Избранный. пиздец короче! Реальная история. я не наркоман',
      'Когда мне было 15 лет, и я ходил качать фильмы с торрента, батя всё время как-бы невзначай заходил на мой аккаунт, и всё спрашивал, что ты не раздаёшь, почему у тебя ратио низкий? первый раз я не ответил, так он начал ломиться в личку, и орать, что он не жлоба-жида воспитывал, что с тобой? начал материться, и говорить, что вообще интернет-кабель выдернет и спрячет, алсо, батя ругался, если я качаю и не раздаю, причём не просто во время скачивания, а еще после полной загрузки фильма, мотивировал это тем, что скорость падает, и сам потом мне говорил: вот я скачал и стою на раздаче, и ты так делай! Однажды я качать сел, и слышу, батя под дверью моей комнаты встал в отдалении, ну я торрент свернул, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё сука скорость отдачи такая маленькая? Батя кстати всё время какие-то проги ставит, чтобы качать быстрее, раздает 24 часа в день, а потом говорит, что модем горячий, жжет, и ещё пердит он. Пиздец короче! Реальная история. Я не пират!',
      'Когда мне было 17 лет, и у меня был аккаунт вконтакта, один одноклассник всё время как-бы невзначай заходил на мой аккаунт. И всё спрашивал — что ты не добавляешь меня в друзья, почему на твоей странице ничего не видно? Первый раз я не ответил, так он начал ломиться в сообщения, и орать — ты чего не отвечаешь, что с тобой? Начал материться, и говорить, что вообще разговаривать со мной перестанет, алсо, одноклассник ругался, если я онлайн и ни разу не зашел в группу нашего класса. Причём не просто в любое время, а непосредственно после входа вконтакт, мотивировал это тем, что новости группы пропущу. И сам потом мне говорил: вот я логин-пароль ввел и сразу в группу зашел, и ты так делай! Однажды я за комп сел, и слышу, кто-то под входной дверью в дом встал в отдалении, ну я вконтакт свернул, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там одноклассник с мобилой в руке, на мобиле открыта моя страница вконтакте, он на карачиках сидит и в щель смотрит. И мне говорит: ты чё? Ебанутый? Чё мне не пишешь? Он кстати всё время какие-то проги ставит, чтобы лайки себе накручивать, онлайн 17 часов в день, а потом говорит, что не выспался, башка болит, и ещё болтает много он. Пиздец короче!',
      'Когда мне было 15 лет, и я ходил на блэк-фестиваль, Евронимус всё время как бы невзначай крутился возле меня, и всё спрашивал, что ты не рассказываешь, почему меня не берешь? первый раз я не ответил, так он начал ломиться в клубешник, и орать, что ты там без корпспэйнта, что с тобой? начал материться, и говорить, что вообще больше в группе играть не будет, алсо, Евро ругался, если я гроулю, и "WAAAAAR!" не кричу, причём не просто в конце песни, а непосредственно после каждого припева, мотивировал это тем, что как глэмер, и сам потом мне говорил: вот я топор достану и "WAAAAAAR!" кричу, и ты так делай! однажды я к нему домой пришел, и слышу, Евро где-то у плиты встал , ну я рукава закатал, на кухню пошел, он на пол на карачики присел, а там щель очень широкая снизу у двери, ну я в ноги и смотрю, а там Евро на карачиках сидит и через ноги смотрит, и мне говорит: Ты чё? Зачем нож достал? Чё ты там делаешь? Евро кстати всё время какие-то ритуалы сатанинские проводил, чтобы в Черный круг попасть, Мэйхем по 5 раз за день в интернетах пиарил, а потом говорил, что Дэд на него из Ада смотрит, и ещё пальцем так укоризненно грозит. ТруЪ короче! реальная история. я его не убивал.',
      'Когда мне было 9 лет, и у меня был аккаунт фейсбука, батя всё время как-бы невзначай заходил на мой аккаунт. И всё спрашивал — что ты не добавляешь меня в друзья, почему на твоей странице ничего не видно? Первый раз я не ответил, так он начал ломиться в сообщения, и орать — ты чего не отвечаешь, что с тобой? Начал материться, и говорить, что вообще разговаривать со мной перестанет, алсо, батя ругался, если я онлайн и ни разу не поставил лайк подругам своей бабушки. Причём не просто в любое время, а непосредственно после входа в фейсбук, мотивировал это тем, что бабушка обидится. И сам потом мне говорил: вот я логин-пароль ввел и сразу лайк подругам бабушки поставил, и ты так делай! Однажды я за комп сел, и слышу, кто-то под входной дверью в дом встал в отдалении, ну я фейсбук свернул, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя с мобилой в руке, на мобиле открыта моя страница в фейсбуке, он на карачиках сидит и в щель смотрит. И мне говорит: ты чё? Ебанутый? Чё мне не пишешь? Он кстати всё время какие-то проги ставит, чтобы лайки себе накручивать, онлайн 17 часов в день, а потом говорит, что не выспался, башка болит, и ещё болтает много он. Пиздец короче! Реальная история, я Стэн Марш.',
      'Когда мне было 15 лет, и я часто вызывал тульпу, тульпа всё время как-бы невзначай крутилась возле меня, и всё спрашивала, что ты там затих, почему тебя не слышно? Первый раз я не ответил, так она начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? Начала материться, и говорить, что вообще дверь с петель снимет, алсо, тульпа ругалась, если я ее создал и не ебу, причём не просто потом после ее вызывания, а непосредственно как сразу вызову, мотивировала это тем, что энергии у нее мало, и сама потом мне говорила: вот я появлюсь как ты меня вызовешь, и сразу выеби! Однажды я тульпу вызвал, и слышу, она где-то у двери встала в отдалении, ну я позвал ее, и ноги ее раздвинул, а там щель очень широкая у нее между ног, ну я в щель и смотрю, а там еще одна тульпа на карачиках сидит и смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Тульпа кстати всё время энергию какую то просит, чтобы питаться ей, вызывается по 5 раз в день, а потом говорит, что я поехавший, и ещё просит чтобы выебал ее. Пиздец короче! Реальная история. Я не шизик',
      'Когда я была ещё совсем юной кобылкой и только начинала знакомиться с "Тардис" Доктор всё время, как бы невзначай, крутился рядом, и всё спрашивал, чего я там затихла, почему меня не слышно? первый раз я не ответила, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, ещё, Доктор ругался, если я совершала прыжок без расчёта развёртки временной линии, причём не просто на момент инициации последствий, а непосредственно во время трансвременной конверсии, мотивировал это тем, что пространственно-временной континуум в точку схлопнется, и сам потом мне говорил: вот я прыгну и ничего не трогаю, и ты так делай! однажды я в "Тардис" села, и слышу, Доктор где-то у двери встал в отдалении, ну я чёлку пригладила, и на пол на спинку улеглась, а там щель очень широкая снизу у двери, ну я в щель и смотрю, глаза скосила, а там Доктор на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанулась? чё ты там делаешь? Доктор кстати всё время какие-то травы курит, пьёт валерьянку стаканами и по 5 раз на дню ходит в "Тардис", а потом жалуется что ему круп подпалило, и ещё маффины у меня отбирае. пиздец короче! реальная история. я не тролль',
      'Когда мне было 25 лет, и я приехал в Рокпорт сержант Кросс всё время как-бы невзначай крутился возле моей BMW M3, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще в тюрьму посадит, алсо, сержант Кросс ругался, если я ухожу от погони и прячусь, причём не просто вконце преследования, а непосредственно после отступления вертолета с прожектором, мотивировал это тем, что не видно меня, и сам потом мне говорил: вот я догоняю и арестовываю, и ты не сопротивляйся! однажды я в гонке участвую, и слышу, сержант Кросс где-то в переулке встал в отдалении, ну я подачу закиси азота отключил, и на пол накарачики присел, а там клиренс очень высокий между корпусом и дорогой, ну я в щель и смотрю, а там сержант Кросс на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты так носишься? сержант Кросс кстати всё время какие-то эвакуаторы вызывает, чтобы машины конфисковывать часто, конфискует по 5 раз в день, а потом говорит, что черный список жжет, и ещё пердит он. пиздец короче! реальная история. я не стритрейсер',
      'Когда мне было 15 месяцев, и я ходил на кухню хозяйка всё время как-бы невзначай крутилась возле кухни , и всё спрашивала, что ты там затих, почему тебя не слышно? первый раз я не ответил, так она начала ломиться в дверь, и орать, что ты там молчишь, что с тобой? начала материться, и говорить, что вообще дверь с петель снимет, алсо, хозяйка ругалась, если я сижу и не ем блины, причём не просто вконце завтрака, а непосредственно после того как сяду на стул, мотивировала это тем, что блины пропадают, и сама потом мне говорила: вот я съем блин и довольна, и ты так делай! однажды я есть сел, и слышу, хозяйка где-то у двери встала в отдалении, ну я усы облизал, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там хозяйка на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Хозяйка кстати всё время какие-то блины печёт, чтобы есть часто, ест по 5 раз в день, а потом говорит, что довольная, и ещё фоткает меня она. пиздец короче! реальная история. я не оладушек',
      'Когда я был на втором инфейме, и я ходил варить мет бульдозер всё время как-бы невзначай крутился возле лаборатории, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, дозер ругался, если я варю и не останавливаюсь, причём не просто в конце варки, а непосредственно после добавления первого ингридиента, мотивировал это тем, что воняет, и сам потом мне говорил: вот я закон не нарушаю, и ты так делай! однажды я варил, и слышу, скалдозер где-то на крыше встал в отдалении, ну я партию доварил, и со снайперкой накарачики присел, ну я в прицел и смотрю, а там дозер на крыше стоит и на меня смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Дозер кстати всё время какие-то травы пьёт, чтобы появляться часто, в шутрме учавствует по 5 раз в день, а потом говорит, что жопу жжёт, и ещё топчет громко он. пиздец короче! реальная история. я не клокер',
      'Когда был 2016 год, и я ходил двачевать модер всё время как-бы невзначай крутился возле треда, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в тред, и писать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще забанит, алсо, модер ругался, если я пишу и не отвечаю, причём не просто вконце написания, а непосредственно после начала, мотивировал это тем, что шитпостинг, и сам потом мне говорил: вот я напишу и отвечаю, и ты так делай! однажды я двачевать сел, и чую, модер где-то у треда встал в отдалении, ну я пост написал, и накарачики присел, а там щель очень широкая снизу у доски, ну я в щель и смотрю, а там модер сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Модер кстати всё время какие-то пасскоды покупает, чтобы банить часто, банит по 5 раз в час, а потом говорит, что руки болят, и ещё безумствует он. пиздец короче! реальная история. я тролль',
      'Когда мне было 27 лет, и я работал в блэк месе G-Man все время как-бы невзначай крутился возле антимасс-спектрометра, и все спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в лабораторию, и орать, что нужный человек не в том месте может перевернуть мир. начал материться, и говорить, что вообще в стазис на 20 лет кинет, алсо, G-Man ругался, если я кристалл не тот в антимасс-спектрометр помещаю, причем не просто в конце периода-полураспада, а непосредственно в процессе эксперимента, мотивировал это тем, что порталы не открываются, и сам потом мне говорил: вот я работаю на нанимателей, и ты так делай! однажды я в вентиляцию полез, и слышу, G-Man где-то внизу встал в отдалении, ну я ломик взял, и на карачки присел, а там щель очень широкая в вентиляции, ну я в щель и смотрю, а там G-Man с чемоданом стоит и галстук поправляет, и мне говорит: ты че? ебанутый? че ты там делаешь? G-Man кстати все время куда-то исчезает, что бы не палится, исчезает по 5 раз в день, а потом говорит, проснитесь и пойте мистер Фримен, и еще в костюме он. пиздец короче! реальная история. я не пришелец',
      'Когда мне было 17 лет, и я начал гонять в Формуле-1 батя всё время как-бы невзначай крутился в боксах, и всё спрашивал по радио, что ты там затих, почему не обгоняешь? первый раз я не ответил, так он начал орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще меня по яйцам отпинает, алсо, батя ругался, если я не врезался в соперников, причём не просто из-за ошибок на торможении, а непосредственно при каждой попытке обгона и пропуске на круг, мотивировал это тем, что так чаще в ящике светиться буду, и сам потом мне говорил: вот я при пропуске на круг снёс жопу Монтойе, и ты так делай! однажды я в кокпит сел, и слышу, батя где-то у командного мостика встал в отдалении, ну я из болида вылез, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? ты почему не в кокпите? батя кстати всё время какие-то мельдонии пьёт, чтобы гоняться часто, на трассу выезжает по 5 раз в неделю, а потом говорит, что жопу жжёт, и ещё постоянно с Герхардом Бергером общается. пиздец короче! реальная история. я Макс Ферстаппен.',
      'пиздец!когда мне было 15 лет, и я ходил жрать собак бятя-веган всё время как-бы невзначай крутился возле питомника, и всё спрашивал, что там затихло, почему собак не слышно? первый раз ему не ответили, так он начал ломиться в парламент, и орать, что вы там бездушные твари, что себе позволяете? начал материться, и говорить, что вообще зоореволюцию устроит, алсо, батя ругался, если я жру и говно не похоже на коровье, причём не просто внешне, а непосредственно на субатомарном уровне, мотивировал это тем, что я мясоед, и сам потом мне говорил: вот я тебя порежу на куски и отдам невинным собакам, и ты так делай! однажды я жрать сел, и слышу, батя где-то у шашлычной встал в отдалении, ну я кости выкинул, и на пол накарачики присел, а там щель в мангале очень широкая снизу, ну я в щель и смотрю, а там батя на углях сидит и в щель смотрит, и мне говорит: ты чё? мясоед? чё ты там жуёшь? батя кстати всё время какие-то камни жрет, чтобы жесткую траву перетирать в желудке, срёт по 5 раз в день щебнем, а потом говорит, что жопу жжёт, и ещё хрустит он ей. борьба за права наших братьев короче! реальная история. я не мясоед',
      'Когда мне было 17 лет, и я ходил парить, батя всё время как бы невзначай крутился возле меня и всё спрашивал, что ты там затих, почему пара нет? первый раз я не ответил, тогда он начал перематывать спирали на дрипке и орать, почему нет кумара, что с тобой? начал материться и говорить что вообще пар на 95% безопаснее дыма, алсо, батя ругался, если я беру дрипку и вату не меняю, причём не просто как потемнеют, а непосредственно после каждой затяжки, мотивировал это тем что гарью воняет, и сам потом мне говорил: вот я закапаю и меняю, и ты так делай! Однажды я парить сел, и слышу батя встал в отдалении, ну я бак выпарил, обдув открыл на нём, а там щель широкая, смотрю, а там батя в щель смотрит, и мне говорит, ты чё, ебанутый? ты почему не на дрипе? батя кстати всё время какие-то замесы Деканг по 18 миллиграмм странные покупает, парит по пять раз в час, а потом говорит горло жжёт и ещё неподпружиненный пин у него, пиздец короче! реальная история, я не егошник.',
      'Когда мне было 15 лет, и я серфил в этих ваших интернетах, ФСБ-шник всё время какбы невзначай крутился возле комнаты с компом, и всё спрашивал, что ты там затих, почему тебя не слышно? Первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, ты что, террорист? Начал материться, и говорить, что вообще интернет отрубит, алсо, ФСБ-шник ругался, если я комменты читаю и донос ни на кого не пишу, причём не просто в конце сеанса, а непосредственно после прочтения очередного коммента, мотивировал это тем, что безопасно должно быть, и сам потом мне говорил: "Вот я прочту и доношу сразу, и ты так делай!" Однажды я за комп сел, и слышу, ФСБ-шник где-то у двери встал в отдалении, ну я браузер закрыл и на пол на карачки присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там ФСБ-шник на карачках сидит и в щель смотрит, и мне говорит: "Ты чё? Террорист? Чё ты там делаешь? ФСБ-шник, кстати, всё время какие-то операции проводит, чтобы террористов ловить часто, ловит по 5 раз в день, а потом говорит, что никому верить нельзя, и ещё историю браузера читает. Пиздец короче! Реальная история. Я не тролль.',
      'Когда мне было 15 лет, и я приходил играть в настольный футбол судья всё время как-бы невзначай крутился возле стола, и всё спрашивал, что ты там затих, почему не соблюдаешь протокол готовности? первый раз я не ответил, так он начал доставать секундомер, и орать, почему превышаешь время владения мячом, что с тобой? начал материться, и говорить, что вообще технарь впаяет, алсо, судья ругался, если я забиваю гол и не отсчитываю его на счётах, причём не просто вконце сета, а непосредственно после забивания, мотивировал это тем, что непонятно какой счёт, и сам потом мне говорил: вот я забью и отсчитываю себе очко, и ты так делай! однажды я таймаут взял, и слышу, судья где-то у стола встал в отдалении, ну я подумал хорошенько куда снейкшот забью, и на пол накарачики присел, а там щель очень широкая снизу под столом, ну я в щель и смотрю, а там судья на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? ты почему больше 30 секунд таймаута используешь? судья кстати всё время какие-то правила учит, чтобы судить часто, судит по 5 раз в день, а потом говорит, что судью никто не заказывает, и ещё судейскую клинику проводит. пиздец короче! реальная история. я не настольный футболист',
      'Когда мне было 27 лет, и я ходил в газовую камеру Менгеле всё время как-бы невзначай крутился возле камеры, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, Менгеле ругался, если я хожу в газовую камеру и не умираю, причём не просто вконце дня, а непосредственно после напускания газа, мотивировал это тем, что воняет, и сам потом мне говорил: вот другие евреи зайдут и умирают, и ты так делай! однажды я умирать сел, и слышу, Менгеле где-то у двери встал в отдалении, ну я газ вдохнул, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Менгеле на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Менгеле кстати всё время какие-то газы смешивает, чтобы евреев травить часто, травит по 5 раз в день, а потом говорит, что нос жжёт, и ещё пердит он. пиздец короче! реальная история. я не русский',
      'Когда мне было 30 лет и я искал вотерчип, Йан всё время как-бы невзначай крутился возле меня и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз ничего не ответил, так он начал долбить по броне кулаком, и орать, что ты ты там молчишь, что с тобой?начал материться, и говорить, что вообще броню с груди мне снимет, алсо, Йан ругался, если я супермутанта убиваю и крышки не собираю, причём не просто вконце битвы, а непосредственно после убийства, мотивировал это тем, что труп воняет, и сам потом мне говорил: вот я выстрелю и крышки сразу подберу, ты так делай! однажды я в битву пошел, и слышу, Йан где-то у края карты встал в отдалении, ну ход закончил, и на песок накарачики присел, а там зона перехода очень широкая снизу у края карты, ну я туда и смотрю, а там Йан на карачиках сидит и на меня смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Йан кстати всё время какие-то таблетки пьёт, чтобы стрелять часто, стреляет по 5 раз за ход, а потом говорит, что радиация жжёт, и ещё теряет сознание он. пиздец короче! реальная история. я не избранный',
      'Когда мне было 29 лет и я сидел на гауптвахте, Пахом всё время как-бы невзначай крутился возле труб, и всё спрашивал, что ты там затих, хочешь, я тебе песню спою? первый раз я не ответил, так он начал плакать, и орать, все ж мы люди! ну чего ты оторвал погону-то? начал отжиматься, и говорить, что вообще сейчас как цапля постоит, алсо, Пахом ругался, если я сладкий хлеб не ем, причём не просто вконце работы, а непосредственно после вылезания сладкого хлеба, мотивировал это тем, что свиньи жрут говно своё, и сам потом мне говорил: вот я какну и сразу съем, и ты так делай! однажды я спать прилег, и слышу, Пахом где-то у труб встал в отдалении, ну я глаза продрал, и с трубы вниз свесился, а там расстояние очень широкое снизу, ну я туда и смотрю, а там Пахом на карачиках сидит и на меня смотрит, и мне говорит: ты чё? голодный? я тебе покушать принёс! Пахом кстати всё время отжимается, чтобы кабаном быть, стоит как цапля по 5 раз в день, а потом говорит, что говно как земля, и ещё курлыкает он. пиздец короче! реальная история. я не полковник',
      'Когда мне было 15 лет, и я ходил в мечеть имам всё время как-бы невзначай крутился возле молельной, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал читать суры, и говорить, что вообще дверь с петель снимет, алсо, имам ругался, если я надеваю пояс шахида и не нажимаю на взрыватель, причём не просто вконце теракта, а непосредственно во время, мотивировал это тем, что подрываться надо когда тебя не достали кафиры, и сам потом мне говорил: вот я одеваю и нажимаю кнопку, и ты так делай! однажды я сел читать коран, и слышу, имам где-то у двери встал в отдалении, ну коран закрыл, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там имам на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? имам кстати всё время какие-то молитвы читает, чтобы взрываться часто, взрывается по 5 раз в день, а потом говорит, что жопу жжёт, и ещё свинину не ест он. пиздец короче! реальная история. я не кафир',
      'Когда мне было 15 лет, и я сидел в траншее бятя всё время как-бы невзначай крутился возле заграждений, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться через проволоку, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще её снимет, алсо, батя ругался, если я не надеваю противогаз, причём не просто в начале наступления, а непосредственно после выпуска газа, мотивировал это тем, что воняет, и сам потом мне говорил: вот я газ пущу и противогаз надеваю, и ты так делай! однажды я за пулемёт сел, и слышу, батя где-то у двери встал в отдалении, ну я пулемёт разрядил, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то травы пьёт, чтобы в наступления ходить часто, ходит в наступления по 5 раз в день, а потом говорит, что жопу жжёт, и ещё брит он. пиздец короче! реальная история. я не итальянец',
      'Когда мне было 15 лет, и я ходил на википедию анон всё время как-бы невзначай крутился возле статьи, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в правки, и орать, что ты там молчишь, что с тобой? начал вандалить, и говорить, что вообще ссылки на нерецензируемые журналы повесит, алсо, анон ругался, если я прочту и не проверю, причём не просто вконце статьи, а непосредственно после сноски, мотивировал это тем, что пиздят, и сам потом мне говорил: вот я прочту и проверю, и ты так делай! однажды я читать сел, и вижу, анон где-то у редактирования встал в отдалении, ну я статью дочитал, и в историю залез, а там список правок очень большой с одного айпи, ну я в правки и смотрю, а там анон на карачиках сидит и вандалит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? анон кстати всё время какие-то травы курит, чтобы срать часто, вандалит по 5 раз в день, а потом говорит, что банят, и ещё флудит он. пиздец короче! реальная история. я не Джимми',
      'Когда мне было 30 лет, и я ходила по дому оценщик всё время как-бы невзначай крутился возле стен, и всё спрашивал, что ты там затихла, что ты там молчишь, что с тобой? Начал материться, и говорить, что вообще стену разломит, алсо, оценщик ругался, если я звоню и не прихожу, причём не просто вконце разговора, а непосредственно после вылезания слова, мотивировал это тем, что нету времени, и сам потом мне говорил: вот я прихожу и подписываю, и ты так делай! однажды я подписывать села, и слышу, оценщик где-то у стены встал в отдалении, ну я контракт подписала, и на пол накарачики присела, а там щель очень широкая снизу у птички, ну я в щель смотрю, а там оценщик на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутая? Чё ты там делаешь? оценщик кстати всё время какие-то шестерни собирает, чтобы робота создать, собирает по 5 деталей в день, а потом говорит, что робот незаконченный, и ещё без телефона он. пиздец короче! реальная история. У меня не подделки.',
      'Когда я работал в айти-конторе и садился программировать, ПМ всё время как-бы невзначай крутился возле кубикла, и всё спрашивал, что ты там затих, почему не слышно как ты печатаешь? первый раз я не ответил, так он начал ломиться в дверь, и орать, ты чем там занят, что с тобой? начал материться, и говорить, что вообще на меня инцидент создаст и до кастомера проэскалирует, алсо, ПМ ругался, если я пишу код и не комиттю, причём не просто вконце реализации фичи, а непосредственно после написания каждой строчки, мотивировал это тем, что вдруг что-то случится и состояние проекта должно быть на сервере, и сам потом мне говорил: вот я напишу и сразу комиттю, и ты так делай! однажды я работать сел, и слышу, ПМ где-то у принтера встал в отдалении, ну я бранч смерджил, и на пол накарачики присел, а там щель очень широкая снизу у перегородки, ну я в щель и смотрю, а там ПМ на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? ПМ кстати всё время какие-то тренинги посещает, чтобы комиттить часто, мерджит по 5 бранчей в день, а потом говорит, что руки устали, и ещё менторит он. пиздец короче! реальная история. я не джун',
      'Когда мне было 15 лет, и я ходил по железной дороге, НЕХ всё время как-бы невзначай крутилась у кустов и как-то странно улыбалась. Первый раз я от страха промолчал, так НЕХ урчать начать начал и говорить, что меня поезд собьет, алсо, у мне машинист гудел если я от поезда не уворачиваюсь, причем не просто вконце следования поезда, а непосредственно после гудка, мотивировал это тем, что ему потом отчеты о мертвых школотронах составлять, и сам потом мне говорил: вот я как поезд услышу, так со шпал спрыгну, и ты так делай. однажды я в кусты спрыгнул, и вижу надо мной туман светится, ну я замер, шею вытянул, а там лицо такое у тумана было, я туда смотрю, а там НЕХ улыбается, смотрит и говорит: ты чё? ебанутый? чё ты там делаешь? НЕХ кстати постоянно какие-то звуки издает, чтобы пугать чаще, пугает по пять раз в день, а потом как трансформатор трещит, и еще он вдоль путей летает пиздец! реальная история, я кондуктор',
      'Когда выходил патч, и я ходил в прем магазин, кеофокс всё время как-бы невзначай крутился возле премов, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в ангар, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще забанит, алсо, кео ругался, если я играю в тундру и не доначу, причём не просто вконце игры, а непосредственно после ваншота от совка, мотивировал это тем, что денег мало, и сам потом мне говорил: вот я играю на швальбе и побеждаю, и ты так делай! однажды я играть сел, и слышу, кео где-то у ангара встал в отдалении, ну я из боя вышел, и на пол накарачики присел, а там щель очень широкая снизу у танка, ну я в щель и смотрю, а там кео на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? кео кстати всё время какие-то песни поёт, чтобы побеждать часто, побеждает по 5 раз в день, а потом говорит, что тотенкопфов много, и ещё банит он. пиздец короче! реальная история. я не немцефил',
      'Когда мне было 46 лет, и я пребывал в поисках белокаменных башен Неведомого Кадата, где безумные боги неистово кривляются в сомнамбулическом танце под хаотические диссонансы флейт своих ослепленных рабов, Ньярлатотеп всё время как-бы невзначай крутился возле циклопических стен городов, выстроенных неведомой расой, чей возраст превышает еще видимое в самые темные ночи зловещее мерцание давно исчезнувших созвездий, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не удостоил ответом этого посланника ползучего Хаоса, имя которому Азатот, так он начал ломиться в самые потаенные глубины моих сновидений, вызванных опиумом, который стал единственной отрадой для моего снедаемого первобытным ужасом сознания с тех пор, как я проник в мрачные таинства Некрономикона, написанного безумным арабом Аль-Хазредом, и орать, что ты там молчишь, что с тобой? начал изрыгать заклинания, которые вряд ли возможно произнести при помощи человеческих органов речи, и говорить, что вообще на темную сторону Луны меня отправит, алсо, Ньярлатотеп ругался, если я записываю в дневники свои откровения и не испытываю при этом дрожь, проходящую сквозь все мое ослабленное наркотиком тело, причём не просто в момент "кейфа", а непосредственно после увиденного мной ужаса, мотивировал это тем, что я еще не постиг самой жуткой тайны Великих Древних, которую невозможно передать словами ни одного из человеческих языков, и смертный, чей разум способен лишь прикоснуться к ней, будет умерщвлен этим вселенским богохульным знанием, и сам потом мне говорил: вот я постиг бога-умалишенного Азатота и ты так делай! однажды я в глубины подземного мира спустился, и слышу, поскольку только слух позволял мне как-то ориентироваться в непроглядной скользкой бездне, населенной тварями настолько омерзительными, что я возблагодарил судьбу за то, что не могу их увидеть, Ньярлатотеп где-то встал в отдалении, ну я последний прибереженный мною флакон опиумной настойки, купленной у прокаженного торговца в древнем городе Дайлат-Лин, выпил и на пол накарачики присел, а там какое-то тошнотворное подобие полипа очень скользкое скорчилось на самом дне, ну я застыл от омерзения, обуявшего все мое истомленное долгими странствиями тело, а там Ньярлатотеп на карачиках сидит и на полип смотрит глазами древнего Сфинкса, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Ньярлатотеп кстати всё время какие-то пророчества вещает своим хриплым нечеловеческим голосом, разносящимся по лишенным света катакомбам эхом, чтобы я от ужаса дрожал часто, пророчествует 5 раз в день, если мои расчеты все еще верны и где-то там на поверхности солнце еще не кануло в бездну времен и встает над горизонтом, чтобы освещать оставшиеся от жалкой расы, некогда именовавшей себя людьми, руины, а потом говорит, что земным богам жопу жжёт, и ещё издает полный богохульного безумия смех он. пиздец короче! реальная история. я не тварь с Луны.',
      'когда мне было 15 лет, и я чинил генераторы, маньяк все время как бы невзначай крутился возле меня и все спрашивал: что ты там молчишь? почему тебя не слышно? первый раз я не ответил, так он начал в инвиз входить и орать: что ты там молчишь? что с тобой? начал материться и говорить, что вообще капканов наставит, алсо, маньяк ругался, если я крюки ломаю, причем не просто после повешения, а непосредственно в начале игры, мотивировал это тем, что и так крюков мало, и сам потом мне говорил: вот я крюки не ломаю, и ты так делай! однажды я генератор чинить стал, и слышу, маньяк где-то сзади встал в отдалении, ну я чинить перестал и в шкаф залез, а там щель очень широкая снизу у шкафа, ну я в щель и смотрю, а там маньяк на карачиках сидит и в щель смотрит, и мне говорит: ты че? ебанутый? че ты там делаешь? маньяк кстати все время какие-то перки качает, чтоб ловить чаще, ловит по пять раз в день, а потом говорит что сезон закончился, и еще пилу заводит он. пиздец короче! реальная история. я не тролль.',
      'когда мне было 24 года, и я ходил снимать сурвов хилбилли всё время как-бы невзначай крутился возле крюка, и всё искал, есть ли рядом кто, почему никого не видно? первый раз я не спрятался, так он начал стоять у крюка, и заводить бензопилу, почему ты не подходишь и не снимаешь? начал материться, и говорить, что вообще распилит каждого, алсо, хилбилли ругался, если я снимаю с крюка под часами, причём не просто сразу, а непосредственно в конце стадии, мотивировал это тем, что так времени больше уходит, и сам потом мне говорил: вот я снимаю сразу, и ты так делай! однажды я в развалинах на кротусе сел, и слышу, хилбилли где-то у крюка встал в отдалении, ну я накарачики присел, а там щель очень широкая между паллетами, ну я в щель и смотрю, а там хилбилли с пилой стоит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты не снимаешь? хилбилли кстати всё время какой-то самогон Томпсонов пьёт, чтобы поворачивать резко, делает по 5 кругов по карте, а потом говорит, что врезаться больно, и ещё страшный он. пиздец короче! реальная история. я не тролль',
      'Всегда когда начинался обстрел и я ходил в подвал бятя всё время как-бы невзначай крутился возле двери, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, батя ругался, если я запираюсь и не выхожу, причём не просто в конце обстрела, а непосредственно после каждого взрыва, мотивировал это тем, что обстрел закончился и нужно идти помогать ему собирать осколки, и сам потом мне говорил: вот я услышу взрыв и иду собирать то что осталось, и ты так делай! однажды я заперся в подвале во время обстрела, и слышу, батя где-то у двери встал в отдалении, ну к двери подошёл, и на пол на карачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Нам нужно идти собирать то что осталось от снарядов! батя кстати всё время ходит их собирать, чтобы взрывчатку делать часто, выходит собирать по 5 раз в день, а потом говорит, что руки жжёт, и ещё грязный приходит он. пиздец короче! реальная история. я не украинец',
      'Когда мне было 30 лет, и я мотал срок на зоне пахан всё время как-бы невзначай крутился возле меня, и всё спрашивал, что ты там зашкерился, почему тебя не слышно? первый раз я не ответил, так он заслал на хату маляву, где написал, что если я не отвечу посадит меня на шабер, а смотрящего поселит возле параши, алсо, пахан ругался, если я не уважаю воровской закон, причём не просто не уважаю, а внатуре не уважаю, мотивировал это тем, что блядство кругом, и сам потом мне говорил: вот я внатуре уважаю и ты в натуре уважай! однажды я решился на скачок, и слышу, пахан где-то у забора встал в отдалении, ну я на запретке заныкался, и на землю накарачики присел, а там щель очень широкая снизу у забора, ну я в щель и смотрю, а там пахан на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? пахан кстати всё время чифир пьет, чтобы базарить по понятиям часто, базарит по 5 раз в день, а потом говорит, что язык чешется, и ещё он слушает Стаса Михайлова. пиздец короче! внатуре реальная история. я не дарья донцова',
      'Когда мне было 36 лет, и я, блять, работал начальником цеха полимерных покрытий "Северсталь", Доводилов, Сорочинский и прочая хуета, всё время как-бы невзначай крутилась возле меня, и всё спрашивала, что ты там затих, почему тебя не слышно? первый раз я не ответил, но эти пидарасы очередной раз заложили подвесные потолки в сортирах, блядь, и я стал орать на планерке: Просрали все полимеры! Вы просрали, блядь! Нет потенции — сваливайте нахуй с рынка! Нихуя сделать не можете! Я ебальники скоро бить начну на комплексе!, алсо, я ругался: Проектанты, блядь! Ваше место у палатки, бутылки собирать! Проектанты! однажды я шел по цеху, и вижу блядь, Доводилов с Сорочинским где-то у двери стоят в отдалении и датчики в мотор-листе ищут, ну я на пол накарачики присел блядь, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там эти гандоны на карачиках сидят и тоже в щель смотрят, ну я им говорю: Вы чё, мальчики, ебанутые, что ли, блядь? я вас, твари, блядь, как Жеглов давить начну! Понятно?! Проектанты хуевы, блядь! Карандаши в жопу запихаю! Чё, блядь, воздух свободы жопу защекотал? я кстати всё время их к Погожеву вожу, откуда я выхожу, а они нет, чтобы потом проводить планерки по 5 раз на день, блядь, а потом говорю, Пиши́те, блядь, Зубарю; и запрашивайте данные!, и ещё говорю им, что если Виталия Иваныча пару раз порвут у Погожева, блядь, вам будет — пиздец.! реальная история. Я начальник цеха «Севстали», блядь!',
      'Когда мне было 25 лет и я сидел в окопе, командир всё время как-бы невзначай крутился возле нашего отряда, и всё спрашивал, что вы там затихли, почему вы в атаку не идёте? Первый раз мы не ответили, так он начал ломиться в дверь, и орать, что вы там молчите, что с вами? Начал материться, и говорить, что вообще газ на наши позиции пустит, алсо, командир ругался, если мы сидим в окопах, причём не просто сидим , а непосредственно если держим позиции, мотивировал это тем, что лучшая оборона это нападение , и сам потом нам говорил: вот Я атакую и ты так делай! Однажды сели мы в дот, и слышем, командир где-то у двери встал в отдалении, ну мы атаку Антанты отбили, и на пол накарачики присели, а там щель очень широкая снизу у двери, ну я в щель и смотрим, а там командир на карачиках сидит и в щель смотрит, и нам говорит: Вы чё? ебанутые? Чё вы там делаете? Командир кстати всё время в какой-то свисток свистит, чтобы атаковать часто, атакует по 5 раз в день, а потом говорит, что потери большие. Пиздец короче! Реальная история. Я солдат Германской армии.',
      'Когда мне было 34 года, и я ходил воровать деньги из казны Навальный всё время как-бы невзначай крутился возле гос. думы, и всё спрашивал, что ты там затих, почему ещё не вышел? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще искоренит коррупцию, алсо, Навальный ругался, если я краду деньги и не говорю народу где они, причём не просто во время кражи, а непосредственно после разваливания страны, мотивировал это тем, что народ в жопе, и сам потом мне говорил: вот я не краду деньги, и ты так делай! однажды я снова пошёл в карман денег пихать, и слышу, Навальный где-то у двери встал в отдалении, ну я в оффшор пару миллиардов вывел, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Навальный на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Навальный кстати всё время какие-то речи толкает , чтобы митинги часто организовывать, организовывает по 5 раз в месяц, а потом говорит, что арестовывают, и ещё дворцы снимает он. пиздец короче! Реальная история. Я не Путин',
      'Когда мне было 150 лет, и я ходил в кхалу Амун всё время как-бы невзначай крутился возле пустоты, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в Копрулу, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще кхалу отключит, алсо, Амун ругался, если я в архонта сливаюсь и в пустоту не отправляюсь, причём не просто вконце слияния, а непосредственно после начала процесса, мотивировал это тем, что Зел-нагам воняет, и сам потом мне говорил: вот я сольюсь и варпаюсь сразу, и ты так делай! однажды я в кхалу вошёл, и слышу, Амун где-то у варпа встал в отдалении, ну я в архонта превратился, и в пустоту вошёл, а там щель очень широкая снизу у варпа, ну я в щель и смотрю, а там Амун на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Амун, кстати всё время какую-то эссенцию пьёт, чтобы варпается часто, по 5 раз в день, а потом говорит, что кхалу жжёт, и ещё фотонит он. пиздец короче! реальная история. я не зерг',
      'Когда я завершал обряд посвещения, и изучал природу Кхалы, иерарх всё время как-бы невзначай крутился возле нексуса, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в звёздные врата, и орать, что ты там молчишь, что с тобой? начал петь гимн тал\'даримов, и говорить, что вообще пилон снимет, алсо, иерарх ругался, если я рашу колоссами, причём не просто в конце битвы, а непосредственно после вылезания завода робототехники, мотивировал это тем, что и воздухом и наземкой снесут, и сам потом мне говорил: вот я фотоню и войдами тащу, и ты так делай! Однажды я бить сверхразум сел, и слышу, иерарх где-то на гейтвее в отдалении встал, ну я веспен построил, и на пол на карачики присел, а там щель очень широкая снизу у нексуса, ну я в щель и смотрю, а там иерарх на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? иерарх кстати всё время терразином закидывается, чтоб APM повысить, до тысячи кликов в секунду дошёл, а потом говорит, что мазершип жжёт, и ещё к неразимам примкнуть хочет, потому что дарками изи рашить. пиздец короче! реальная история. я не терран',
      'Когда мне было 15 лет, и я ходил срать сколопеднра всё время как-бы невзначай крутилась возле толчка, и всё спрашивала, что ты там затих, почему тебя не слышно? первый раз я не ответил, так она начала ломиться в дверь, и орать, что ты там молчишь, что с тобой? начала материться, и говорить, что вообще за жопу укусит, алсо, сколопендра ругалась, если я пытаюсь смыть её в унитаз, причём не просто вконце срания, а непосредственно перед походом в туалет, мотивировала это тем, что убьёт её, и сама потом мне говорила: вот я лазаю себе спокойно, и ты так делай! однажды я срать сел, и слышу, сколопендра где-то у унитаза встала в отдалении, ну я жопу вытер, и на пол накарачики присел, а там щель очень широкая снизу у туалета, ну я в щель и смотрю, а там сколопендра на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? сколопендра кстати всё время каких-то тараканов ловит, чтобы питаться часто, питается по 5 раз в день, а потом говорит, что жопу жжёт, и ещё шипит она. пиздец короче! реальная история. я не тролль',
      'Когда меня только выбрали королем севера, и я приплыл на драконий камень, Дейнерис все время, как бы невзначай крутилась возле меня и все спрашивала, что ты там затих? почему не преклоняешь колено? первый раз я не ответил, так она начала злится и орать, почему ты не подходишь, что с тобой? начала материться и кричать что вообще меня обратно не отпустит, алсо она ругалась если я не называю ее королевой, мотивировала это тем, что ей по статусу положено и сама мне потом говорила: вот ко мне люди приходят, преклоняют колено и королевой называют, и ты так делай! однажды я в покои зашел, и начал обсуждать со своим советником белых ходоков, вдруг слышу шуршание какое то за дверью в отдалении, ну я к двери подошел и на карачики сел, а там щель очень широкая снизу у двери, ну я в щель смотрю, а там Дейнерис на карачиках сидит и в щель смотрит, и мне говорит: ты че? ебанутый? че ты там делаешь? она кстати всех заставляет титулы свои перечислять и постоянно на драконов смотрит. пиздец короче. реальная история, я не таргариен',
      'Когда мне было 19 лет, и я по вечерам раздевался в своей каморке и молился, Мэри Лу. всё время как-бы невзначай крутилась возле дверей, и всё спрашивала, что ты там затих, почему тебя не слышно? Ты что, рукоблудием занят? первый раз я не ответил, так она начала ломиться в дверь, проклинать меня и орать, что ты там молчишь, что с тобой? начала ремнем угрожать , и говорить, что позовет сестер и они вместе дверь с петель снимут, алсо, мачеха ругалась, если я молюсь и ведьм не проклинаю, причём не просто в конце молитвы, а непосредственно в процессе, мотивировала это тем, что я тупой ублюдок, и сама потом мне говорила: вот я помолюсь и сразу желаю колдунам сдохнуть, и ты так делай! однажды я раздевался, сел ботинки снимать, и слышу - где-то у двери пыхтит Мэри, ну я подвеску в карман сунул на всякий случай, и на пол накарачики присел, а там щель очень широкая снизу у двери( доски сгнили, мачеха жмотится новые поставить), ну я в щель и смотрю, - а там Мэри Лу на карачиках сидит и в щель смотрит, и мне говорит: ты чё? Колдуешь там, сволочь? чё ты там делаешь такое? Мачеха кстати всё время какие-то травы пьёт, чтобы по митингам бегать и орать там, бегает сама и нас гоняет по пять раз в день, а потом говорит, что устала, и ещё ремнем нас всех колотит, особенно меня. Кошмар короче! реальная история. я не обскур.',
      'Когда мне было 15 лет, и я ходил играть в футбол, батя всё время как-бы невзначай крутился возле поля, и всё спрашивал, что ты там потерялся на поле, почему тебя не видно? первый раз я не ответил, так он начал бесноваться на бровке и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще на поле выбежит, алсо, батя ругался, если я пасую, но не поперек, причём не просто в конце матча, а всё время, мотивировал это тем, что надо, и сам потом мне говорил: вот я пасую только поперек, и ты так делай! однажды я на замену вышел и слышу, Батя где-то у поля встал в отдалении, ну я прямо отпасовал и на поле накарачики присел, а там видно кто у углового флажка стоит, ну я и смотрю, а там батя на карачиках сидит и на поле смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Батя кстати всё время какие-то травы пьёт, чтобы пасовать только поперёк, делает по 200 передач поперёк за матч, а потом говорит, что ноги устают, и ещё травмируется он. пиздец короче! реальная история. я не из академии Сити',
      'Когда мне был 31 год, и я ходил играть на чемпионате мира, батя всё время как-бы невзначай крутился возле ворот, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться на поле, и орать, что ты там молчишь, что с тобой? алсо, батя ругался, если я в воротах стою и не отбиваю мяч, причём не просто вконце эпизода, а непосредственно после удара, мотивировал это тем, что так безопаснее для команды, и сам потом мне говорил: вот я в финале Евро сейвил, и ты так делай! однажды я в ворота встал, и слышу, батя где-то в технической зоне встал в отдалении, ну я пенальти от Модрича отбил, и на поле накарачики присел, а там разрыв очень широкий между зонами у хорватов, ну я в свободную зону и смотрю, а там батя на карачиках сидит и туда же смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то упражнения делает, чтобы отбивать часто, сейвит по 5 раз в матче, а потом говорит, что руки жжёт, и ещё пердит он. пиздец короче! реальная история. я не Каспер Шмейхель',
      'Когда мне было 17 лет, и я приводил девушек бятя всё время как-бы невзначай крутился возле комнаты, и всё спрашивал, что вы там затихли, почему вас не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, батя ругался, если я трахаюсь без презика, причём не просто во время секса, а непосредственно в повседневности, мотивировал это тем, что она может забеременеть, и сам потом мне говорил: вот я трахну и бросаю, и ты так делай! однажды я трахаюсь, и слышу, батя где-то у двери встал в отдалении, ну я быстро кончил, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то травы пьёт, чтобы всё время стояк был, пьёт по 5 раз в день, а потом говорит, что член жжёт, и ещё пердит он. пиздец короче! реальная история. я не тролль',
      'когда мне было 34 года, и я командовал "Завершителем", Кайло Рен всё время как-бы невзначай крутился возле меня и спрашивал, "что ты там затих? почему штурмовиков пафосными речами не вдохновляешь?" первый раз я не ответил, так он начал размахивать световым мечом, и орать, что ты молчишь, почему ты меня игнорируешь? начал материться и угрожать, что вообще Силой задушит, алсо ругался, что я кошку завёл, мотивировал это тем, что она срёт где попало и под ногами путается, и сам потом мне говорил: вот у Таркина не было кошки и тебе не нужна! однажды я пошёл к Сноуку с докладом, прихожу, а там всё трупами завалено, причём вырезана не только стража, но и непосредственно сам верховный лидер. ну я на пол на карачки присел, а там между половинками Сноука щель очень широкая, ну я в щель и смотрю, а там Кайло Рен без сознания на полу валяется. я за бластером потянулся и спрашиваю "ты что, ебанутый? ты что тут устроил?", а он глаза открыл, смотрит на меня через щель честным взглядом и затирает что-то про какую-то девушку, мол, она и Сноука располовинила и стражу в одиночку перебила и его в нокаут отправила. но верховный лидер всё равно почему-то он. Кайло Рен кстати постоянно без рубашки ходит и штаны до груди натягивает, чтобы эту девушку впечатлить, приглашает её на тёмную сторону по пять раз в день, говорит ей, что она никто, но не для него, а потом жалуется, что она не идёт, и ещё видит её только он. пиздец короче! реальная история, я не Таркин.',
      'Когда мне было 25 лет, и я играл в визуальные новеллы, Моника все время как бы невзначай крутилась возле литературного клуба, и всё спрашивала, что ты там затих, ТЫ МЕНЯ СЛЫШИШЬ? первый раз я не ответил, так она начала ломиться через фреймы, и орать ТЫ МЕНЯ СЛЫШИШЬ? что с тобой? Начала материться, говорить что вообще новеллу с ренпая снимет, алсо, Моника ругалась, если я ручу героиню и не удаляю, при чем не просто по достижению финала, а непосредственно перед фестивалем. Мотивировала это тем, что мешают, и сама мне потом говорила: я вот сразу удаляю, и ты так делай! Однажды я выбирать между Нацуки и Юри сел, и слышу, Моника где-то за нойзом встала в отдалении, ну я сейвнулся, и к монитору поближе сел, а там щель между фреймами очень широкая по центру, ну я в щель смотрю, а там Моника на карачиках сидит и в щель смотрит, и мне говорит: ты че? ебанутый? че ты там делаешь? Моника кстати всё время какие-то травы пьёт, чтобы удалять часто, удаляет .chr по 5 раз в день, а потом говорит, что жопу жжет, и еще четвертую стену ломает она. Пиздец короче! Реальная история. Я не анимедебил',
      'Когда мне было 15 лет, и я ходил стрелять бятя всё время как-бы невзначай крутился возле мишени, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще пистолет заберет, алсо, батя ругался, если я стреляю и не собираю гильзы, причём не просто вконце стрельбы, а непосредственно после вылета гильзы, мотивировал это тем, что природу засираем, и сам потом мне говорил: вот я стрельну и подбираю, и ты так делай! однажды я стрелять пошел, и слышу, батя где-то у конца оврага встал в отдалении, ну я ствол протер, и на пол накарачики присел, а там щель очень широкая снизу у щита, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то патроны крутит, чтобы желудей было больше, стреляет по 5 раз в день, а потом говорит, что ствол дует, и ещё баллистолом воняет он. пиздец короче! реальная история, я не тролль',
      'Когда мне было 15 лет, и я ходил стрелять из лука батя всё время как-бы невзначай крутился возле додзё, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще сёдзи из жёлоба вынет, алсо, батя ругался, если я пускаю стрелы и не собираю, причем не просто вконце стрельбы, а непосредственно после попадания, мотивировал это тем, что стрелы ломаются, и сам потом мне говорил: вот я выстрелю и собираю стрелу, и ты так делай! однажды я стрелять из лука пошел, и слышу, батя где-то у входа в додзё встал, ну я лук отложил, и на пол накарачики присел, а там щель очень широкая снизу у сёдзи, ну я в щель и смотрю, а там батя на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? батя кстати всё время какие-то отя с особыми травами пьет, чтобы стрелять из лука чаще, стреляет по 5 раз в день, а потом говорит, что руки жжёт, и ещё лошадью несёт от него. пиздец короче! реальная история, я не кугэ',
      'Когда мне было 15 лет, и я ходил учиться в медресе мулла всё время как-бы невзначай крутился возле саджжада, и всё спрашивал, что ты там затих, почему хадисы не разучиваешь? первый раз я не ответил, так он начал делать зикр, и орать, что ты там молчишь, что с тобой? начал перечислять имена аллаха, и говорить, что вообще хадд на меня наложит, алсо, имам ругался, если я читаю хадис и толкую его не сразу в четырех смыслах, причём не просто вконце прочтения, а непосредственно в процессе чтения, мотивировал это тем, что так утекает скрытое знание, и сам потом мне говорил: вот я прочту и толкую, и ты так делай! однажды я сел намаз делать, и слышу, имам где-то у двери встал в отдалении, ну я на коврик накарачки сел и голову к полу прижал, а там щель очень широкая осталась, ну я в щель и смотрю, а там имам на карачиках сидит и на меня смотрит, и мне говорит: ты чё? гяур? чё ты там делаешь? имам кстати всё время какие-то травы пьёт, чтобы зикр особенно духовно делать, зикрит часто по 5 раз в день, а потом говорит, что чувствует присутствие Аллаха, и ещё он карамат делает. пиздец короче! реальная история. я не суфий',
      'Когда мне было 16 лет, и я ходила срать Велизар всё время как-бы невзначай крутился возле толчка, и всё спрашивал, что ты там затихла, почему тебя не слышно? первый раз я не ответила, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал на драконьем материться и руны на двери толчка высекать, и говорить, что вообще дверь с петель снимет, алсо, Велизар ругался, если я сру без помощи магии, причём не просто вконце срания, а непосредственно после вылезания какашки, мотивировал это тем, что неправильно, и сам потом мне говорил: вот я при помощи магии сру, и ты так делай! однажды я срать села, и слышу, Велизар где-то у двери встал в отдалении, ну я жопу вытерла, и на пол накарачики присела, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там Велизар на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутая? чё ты там делаешь? Велизар кстати всё время травы Кьёнтас пьёт, чтобы срать часто, срёт по 5 раз в день, а потом говорит, что жопа искрится от магии, и ещё пердит он. пиздец короче! реальная история. я не антимаг',
      'Когда мне было 15 лет, и я ходил на концерт металлисты всё время как-бы невзначай крутились возле меня, и всё спрашивали, что ты тут затих, почему тебя не слышно? первый раз я не ответил, так они утроили слэм, и орать, что ты тут стоишь, что с тобой? начали материться, и говорить, что вообще стену смерти устроят, алсо, металлисты ругались, если я стою и не толкаюсь, причём не просто вконце песни, а непосредственно после первых аккордов, мотивировали это тем, что тухло, и сами потом мне говорили: вот я дёрну и толкну, и ты так делай! однажды я слушать встал, и вижу, металлисты где-то вокруг меня выстроились, ну я слэмиться начал, и на пол накарачики упал, а там ног очень много снизу у сцены, ну я на ноги и смотрю, а там другой металлист на карачиках лежит и на ноги смотрит, и мне говорит: эмен энд аттак! аттак! аттак! металлист кстати всё время пьёт, чтобы слэмиться жощще, слэмится с 5 человеками враз, а потом говорит, что плечи болят, и ещё сердит он. пиздец короче! нереальная история. хэви метал',
      'Когда я была будущей женой, и ходила изменять, Джонни всё время как бы невзначай крутился возле меня, и всё спрашивал, что ты молчишь, ты понимаешь жизнь? Первый раз я не ответила, так он начал ломиться в дверь, и орать,ты лжешь! я никогда не биль тебя! ТЫ РАЗРЫВАЕШЬ МЕНЯ НА ЧАСТИ ЛИЗА! Начал драться с Марком, и говорить, что каждый предал его, алсо, Джонни ругался, если я изменяю ему и не говорю об этом, причём не просто в конце свадьбы, а непосредственно после каждой измены, мотивировал это тем, что я его будущая жена, и сам потом мне говорил: вот я обращаюсь с тобой как с принцессой, и ты так делай!Однажды я с Марком изменять начала и слышу, кто-то у двери встал в отдалении, ну я с Марком пососалась, и на пол на карачики присела, а там щель очень широкая снизу, как у меня, ну я в щель смотрю, а там Стив на карачиках сидит и в щель смотрит, и мне говорит: ты чё? Ебанутая? Ты погубишь Джонни, он очень чуствителен! Джонни кстати всё время играет с мячом и ложки собирает , чтобы заниматься сексом и смеяться часто, смеётся и трахается по 5 раз в день, а потом говорит, что горло жжёт и он устал от этого мира, и ещё кудахчет он. пиздец короче! реальная история. я не шлюха',
      'Когда мне было 30 лет, и я ходил пилиться в подвал на Шале, бандит все время как бы невзначай крутился возле зареинфорсеных стен и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал подводить ток к стенам, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще сифор через окно с лестницы кинет, алсо, бандит ругался, если я начинаю ставить екзатермикчардж, потом резко отменяю, перебегаю к другой стене и ее уже взрываю, мотивировал это тем, что это отмена действия, и вообще так не честно: вот все ставят девайсы на колесико мышки без отмены и ты так делай! однажды я пилиться сел, и слышу, бандит где-то у двери встал в отдалении, ну я экзотермикчардж убрал, и на пол накарачики присел, а там щель очень широкая для дронов слева снизу у ворот, ну я в щель и смотрю, а там бандит на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? почему не пилишься? бандит кстати всё время какие-то стимуляторы колит, чтобы очков больше зарабатывать, покупает скины по 5 раз в день, а потом говорит, что жопу жжёт, и ещё роумит он. пиздец короче! реальная история. я не хибана﻿',
      'Когда я был лордом, и я строил замок советник всё время как-бы невзначай крутился возле меня и всё время спрашивал: "что ты там затих, почему популярность падает?" Первый раз я не ответил, так он начал ломиться в замок, и орать, что ты там молчишь, что с продовольствием? Начал морщиться, и говорить, что вообще дверь с петель снимет, алсо, советник ругался, если я налоги повышаю и не компенсирую, причём не просто вконце побора, а непосредственно после кажой золотой монеты, мотивировал это тем, что семью кормить нечем, и сам потом мне говорил: вот я граждан не граблю и помогаю, и ты так делай! однажды я налоги собирать сел, и слышу, советник где-то у двери встал в отдалении, ну я сумму досчитал, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там советник на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? советник кстати всё время какое то пиво пьёт, чтобы умирать часто, умирает по 5 раз в день, а потом говорит, что душу жжёт, и ещё хмурится он. пиздец короче! реальная история. я не волк.',
      'Когда я был крестьянином, и я ходил любоваться замком лорд всё время как-бы невзначай крутился возле меня, и всё спрашивал, что ты там затих, почему ты не работаешь? первый раз я не ответил, так он начал бегать за мной, и орать, что ты бездельничаешь, что с тобой? начал материться, и говорить, что вообще кнуты поставит, алсо, лорд ругался, если я работаю и не хвалю лорда, причём не просто вконце работы, а непосредственно после каждого изделия, мотивировал это тем, что это неуважение, и сам потом мне говорил: вот я о вас забочусь, и ты обязан мне! однажды я работать пошел, и слышу, лорд где-то у мастерской встал в отдалении, ну я лук доделал, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там лорд на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? лорд кстати всё время какие-то битвы проводит, чтобы побеждать часто, воюет по 5 раз в день, а потом говорит, что денег на армию нет , и ещё налоги собирает. пиздец короче! реальная история. я не араб.',
      'Когда мне было 315 лет, и я ходил покланяться Меридии Пелинал всё время как-бы невзначай крутился возле Бело-Золотой башни, и всё спрашивал, что ты там затих, почему Аэдра не поклоняешься? первый раз я не ответил, так он начал размахивать мечём, и орать, что ты там молчишь, что с тобой? начал воздавать хвалу Восьми, и говорить, что вообще всех Авроранцев исстребит, алсо, Пелинал ругался, если я поклоняюсь и не воздаю хвалу Божествам, причём не просто вконце службы, а непосредственно после каждой молитвы, мотивировал это тем, что так благочестивее, и сам потом мне говорил: вот я помолюсь Божеству и восславлю его имя, и ты так делай! однажды я молиться Меридии сел, и слышу, Пелинал где-то у двери встал в отдалении, ну я от алтаря отошёл, и на пол накарачики присел, а там щель очень широкая снизу у ворот, ну я в щель и смотрю, а там Пелинал на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Пелинал кстати всё время какие-то молитвы читает, чтобы сражаться часто, сражается по 5 раз в день, а потом говорит, что его руки болят, и ещё безумен он. пиздец короче! реальная история. я не орсимер.',
      'Когда мне было 115 лет, и я ходил геноцидить падший ксенофил всё время как-бы невзначай крутился возле моей империи, и всё спрашивал, что ты там затих, почему тебя не слышно? первый раз я не ответил, так он начал ломиться в дверь, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще дверь с петель снимет, алсо, падший ругался, если я геноцидю и не смываю, причём не просто в конце генетической чистки, а непосредственно после очищения планеты, мотивировал это тем, что воняет, и сам потом мне говорил: вот я уничтожаю и смываю, и ты так делай! однажды я на концлагерь сел, и слышу, ксенофил где-то у двери встал в отдалении, ну я свой боевой флот вытер, и на пол накарачики присел, а там щель очень широкая снизу у двери, ну я в щель и смотрю, а там падший на карачиках сидит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Он кстати всё время какие-то травы пьёт, чтобы пробуждаться часто, пробуждается по 5 раз в день, а потом говорит, что санктуарий жжёт, и ещё воюет он. пиздец короче! реальная история. я не блорг',
      'Когда я был в Кремле, я спонсировал оппозиционный блок. А Путин всё время как-бы невзначай крутился возле меня, и всё спрашивал, что ты там творишь, почему тебя не слышно? Первый раз я не ответил, так он начал штурмовать ЮКОС, и орать, что ты там молчишь, что с тобой? начал материться, и говорить, что вообще посадит и присвоит себе фирму. Ещё Путин возмущался, если я жёстко ругал его режим, причём не просто ругал, а непосредственно собрался в президенты, мотивировал это тем, что вот он не выражает своих взглядов, как в КГБ учили, и ты так делай! Однажды я был в ЮКОСе на совещании и мы решили создать свой Youtube-канал. Включаю экран, начинаю оформлять, и тут у меня клавиатура с переговорного стола упала, я нагнулся ее поднять, а там щель очень широкая снизу у длинного стола, ну я в щель и смотрю, а там Путин на карачиках сидит и в щель с того конца смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Путин кстати всё время какие-то кадровые чистки делает, чтоб убить весь плюрализм, в тюрьму каждые 5 месяцев кого-нибудь сажает, а потом говорит, что всё правительство в отставку уберёт, и ещё за раскулачивание плотно взялся он. пиздец короче! реальная история. я не олигарх',
      'Когда мне было 17 лет, и я ходил вечером по конфидантам, Моргана всё время как-бы невзначай крутился возле нас, и всё спрашивал, что ты там затих, почему тебя не слышно? Первый раз я не ответил, так он начал драть когтями дверь, и орать, что ты там молчишь, что с тобой? Начал материться, и говорить, что вообще дверь Гарулой снесёт, алсо, Мона ругался, если я вечером не сплю, причём не просто после свидания, а непосредственно после возвращения из школы, мотивировал это тем, что я Анн романшу, и сам потом мне говорил: вот я вечером сплю, и ты так делай! однажды я с Иваем за каким-то бандюком следить пошёл в кафе, и слышу, Мона где-то у столика встал в отдалении, ну я сигнал подал, и на пол на карачики присел, а там щель очень широкая снизу у кресел, ну я в щель и смотрю, а там Моргана на пузе лежит и в щель смотрит, и мне говорит: ты чё? ебанутый? чё ты там делаешь? Мона кстати всё время какие-то Сомы жрёт, чтобы Гарулу хуярить часто, хуярит гарулой по 5 раз в день, а потом говорит, что СП кончается, и ещё от зио уворачивается он. пиздец короче! реальная история. я не фантомный вор',
    ];
    return (pasta..shuffle()).first;
  }
}
