#pragma once

#define WEBSERVER_CALLBACK \
server.on("/credits.html", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "text/html", credits_html, sizeof(credits_html));\
});\
server.on("/error404.html", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 404, "text/html", error404_html, sizeof(error404_html));\
});\
server.on("/index.html", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "text/html", index_html, sizeof(index_html));\
});\
server.on("/index.js", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "application/javascript", index_js, sizeof(index_js));\
});\
server.on("/script.js", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "application/javascript", script_js, sizeof(script_js));\
});\
server.on("/settings.html", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "text/html", settings_html, sizeof(settings_html));\
});\
server.on("/settings.js", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "application/javascript", settings_js, sizeof(settings_js));\
});\
server.on("/style.css", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "text/css", style_css, sizeof(style_css));\
});\
server.on("/terminal.html", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "text/html", terminal_html, sizeof(terminal_html));\
});\
server.on("/terminal.js", HTTP_GET, [](AsyncWebServerRequest* request) {\
	reply(request, 200, "application/javascript", terminal_js, sizeof(terminal_js));\
});

const uint8_t credits_html[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0xa5,0x57,0x6d,0x6f,0xdb,0x38,0x12,0xfe,0x9e,0x5f,0x31,0xf5,0x1,0x77,0xbb,0x80,0x6d,0x6d,0xb7,0x40,0xd1,0x2d,0x94,0x0,0xaa,0xad,0x34,0xc2,0x3a,0x96,0x21,0xc9,0xcd,0xe6,0xd3,0x82,0x96,0xe8,0x88,0x17,0x89,0x34,0x48,0x2a,0xae,0x81,0xfb,0xf1,0x37,0x43,0xc9,0xb2,0x5d,0x27,0xe9,0x6e,0x17,0x8,0x62,0x91,0xc3,0x79,0x7b,0x38,0x6f,0xf4,0xdf,0x8c,0x46,0x17,0x0,0x30,0x51,0x9b,0x9d,0x16,0xf,0xa5,0x85,0x9f,0xf2,0x9f,0xe1,0xd7,0x5f,0xde,0xfe,0x6,0xa9,0xe5,0x6b,0x26,0xe1,0x77,0xcd,0x6b,0xc3,0x35,0x1d,0xca,0x4a,0x61,0xc0,0xa8,0xb5,0xdd,0x32,0xcd,0x1,0xbf,0x2b,0x91,0x73,0x69,0x78,0x1,0x8d,0x2c,0xb8,0x6,0x5b,0x72,0xb8,0x8d,0x32,0x98,0xb5,0xdb,0x63,0x48,0x39,0x77,0x9b,0xdd,0x39,0x58,0x8b,0xa,0xff,0x29,0xd,0x5,0xb7,0x4c,0x54,0x66,0x4c,0x52,0x53,0xd5,0xe8,0x9c,0x7f,0x84,0x7,0x61,0xcb,0x66,0x35,0xce,0x55,0xed,0x99,0xd,0xcb,0x79,0xd9,0x94,0xd2,0xbb,0x13,0xd7,0x62,0xda,0xe4,0x8f,0x17,0xa3,0xd1,0xd5,0x85,0xff,0x66,0x1a,0x4f,0xb2,0xfb,0x45,0x8,0xa5,0xad,0x2b,0x5c,0xb7,0x3f,0xf8,0xcb,0x59,0x71,0x85,0xb2,0xfc,0x1a,0xe5,0x42,0x5e,0x32,0x6d,0xb8,0xbd,0x1c,0x2c,0xb3,0xeb,0xd1,0x87,0x1,0x78,0x7,0x92,0x64,0x35,0xbf,0x1c,0x3c,0x9,0xbe,0xdd,0x28,0x6d,0x7,0x90,0x2b,0x69,0xb9,0xc4,0xa3,0x5b,0x51,0xd8,0xf2,0xb2,0xe0,0x4f,0x68,0xe9,0xc8,0x2d,0x86,0x20,0xa4,0xb0,0x82,0x55,0x23,0x93,0xb3,0x8a,0x5f,0xfe,0x32,0xfe,0x30,0x84,0x1a,0xf7,0x6a,0xdc,0x6a,0xc4,0x33,0x62,0xd1,0xd3,0x9a,0x8f,0x72,0x55,0x29,0x7d,0x24,0xf9,0x5f,0xef,0xde,0xbf,0xfb,0xed,0x5d,0xf8,0xcc,0xf9,0x82,0x9b,0x5c,0x8b,0x8d,0x15,0x4a,0x1e,0x9d,0x27,0x8f,0x81,0x5c,0x7e,0x86,0x83,0x35,0xb6,0x3c,0x11,0x9e,0xee,0x81,0x82,0xd1,0x37,0xf7,0xb5,0xe7,0xae,0x84,0x7c,0x4,0xcd,0xab,0xcb,0x81,0xb1,0xbb,0x8a,0x9b,0x92,0x73,0xf4,0xdb,0xee,0x36,0x64,0x30,0xff,0x6a,0xbd,0xdc,0x98,0x1,0x94,0x9a,0xaf,0xbb,0x13,0x63,0xda,0x70,0xac,0x56,0xd8,0x8a,0x5f,0xf5,0xf6,0xc0,0xff,0x20,0x58,0xa9,0xc6,0xfa,0x5e,0x4b,0xb8,0xf0,0xbd,0x16,0xf7,0xb,0x7f,0xa5,0x8a,0x9d,0x63,0x91,0xec,0x89,0x7e,0xf1,0xab,0xa9,0x20,0xaf,0x98,0x31,0x97,0x83,0x9a,0xcb,0x66,0xd0,0xee,0x3a,0x7b,0xae,0x7c,0xd6,0xe9,0x13,0x18,0x35,0x5f,0xc7,0x74,0x89,0x83,0x83,0x1a,0xdf,0x63,0x57,0xbe,0x87,0xc7,0x9e,0xe3,0xc0,0x6b,0xb5,0x42,0x3e,0x98,0x8e,0x29,0xed,0x96,0xaf,0xf2,0x58,0xae,0xf1,0xda,0x58,0xd5,0xf1,0x64,0xdd,0xf2,0x55,0x9e,0x5c,0xf3,0x42,0xd8,0xbd,0x9a,0xce,0xed,0xe3,0xf3,0xbe,0xd7,0x54,0xce,0x63,0xaf,0x73,0xd9,0x2f,0xc4,0x13,0x88,0x82,0x40,0x64,0xb6,0x41,0x4,0x7d,0xf,0x77,0xda,0xb,0x64,0x42,0x76,0x5c,0x86,0xe7,0x74,0xdd,0xbd,0xce,0xf2,0xed,0xd5,0x54,0x18,0x4,0x4a,0xd4,0x5c,0x23,0x9e,0x6f,0x7b,0xca,0x66,0xff,0xd5,0xa5,0x1d,0xfe,0x31,0xb0,0x4a,0x55,0x63,0x7f,0xa5,0xf,0xb4,0xc8,0xfe,0xc7,0x80,0xe4,0x98,0x3a,0x98,0x7f,0xf,0x4a,0x15,0x20,0x31,0xbd,0x56,0xac,0x38,0x3d,0xb6,0xc4,0xe4,0x13,0x16,0xf9,0xa1,0x50,0xee,0xd8,0x90,0xbe,0x8d,0x6d,0x8a,0x1d,0x30,0x59,0xd0,0xc2,0x72,0x63,0x4f,0x99,0xe6,0xfc,0x9,0x85,0x36,0xc7,0xac,0x98,0x59,0x35,0xa0,0x2,0xc4,0x87,0x59,0xe,0x5,0xab,0xd9,0x3,0x7f,0x73,0xc2,0x75,0xb2,0xc8,0x30,0xf9,0x29,0x58,0x85,0x6c,0x18,0x39,0xe,0x6a,0x8d,0x5,0x1,0x7d,0xd9,0x68,0xf5,0x5f,0xc4,0x2,0x89,0x8d,0xb4,0x6,0x90,0xb2,0x53,0xcd,0x9b,0xbd,0xf3,0xde,0x66,0x8f,0xf2,0x9,0x60,0xcf,0xc1,0xd7,0xd5,0x9a,0x97,0xb0,0x3b,0x2a,0x47,0x27,0x86,0x7d,0xb7,0xde,0xbd,0xec,0xd3,0x82,0x2,0xc8,0x18,0xf2,0x6,0x1d,0x41,0xdc,0xf9,0x6a,0x7,0xf,0x9a,0x61,0x4a,0x22,0xac,0x6b,0x8d,0x35,0xf,0xbd,0xa4,0x22,0xf4,0xc0,0x1d,0xcc,0x4c,0xee,0x60,0xc3,0xb5,0x21,0xf7,0x57,0x58,0xf7,0x24,0x86,0x2c,0x5e,0x66,0x8e,0x26,0xf4,0x42,0xf7,0xb8,0xf4,0xd5,0x95,0x6e,0x5,0xd3,0x47,0xe5,0x2,0x81,0x2e,0x10,0xfb,0xbc,0xc1,0x44,0xb2,0x2d,0x8a,0x54,0x47,0xd,0xfc,0x44,0xa5,0x75,0x90,0x76,0x1c,0x83,0x9f,0x9d,0xb2,0x82,0xb3,0xaa,0x97,0x2a,0xa4,0x2b,0xbf,0xfb,0x23,0xb0,0xc5,0x38,0xc1,0x50,0xc6,0x7a,0x60,0xac,0x16,0xe,0x4b,0x2a,0x73,0x79,0xd5,0x14,0x64,0xd3,0x9e,0x5c,0x89,0x5a,0x74,0x9a,0x88,0xdd,0xe1,0x64,0x7a,0xa1,0xa8,0x4,0x63,0x62,0xe8,0xec,0xc7,0x8a,0xa8,0xa,0xb1,0xa6,0x5f,0xee,0xdc,0xdd,0x34,0xab,0x4a,0x18,0x2c,0x9e,0x85,0x20,0x15,0xab,0xc6,0xe2,0xa6,0xa1,0x4d,0x77,0x7,0x43,0xf2,0xcb,0xc3,0x0,0x32,0xbc,0x3a,0x98,0x89,0x92,0x4,0xfa,0xe3,0x30,0x38,0x58,0x3b,0xdc,0x47,0xe6,0x86,0x0,0xb7,0x1d,0x84,0x86,0x76,0xb6,0xa5,0xaa,0x4f,0x3d,0x13,0x7,0xfb,0xd6,0x8d,0x96,0x68,0x2,0x2f,0xba,0x98,0x35,0xca,0x59,0xe0,0xc2,0x8d,0xe2,0xbc,0xa4,0x16,0x54,0x55,0x6a,0x4b,0x2e,0x63,0x70,0x62,0xa2,0xa3,0xa7,0xe6,0xe3,0xeb,0x51,0xcc,0x56,0xea,0x89,0x3b,0x9f,0xdb,0xb0,0x91,0xca,0xa2,0x4b,0xad,0x89,0x2e,0xa0,0xf,0x51,0xd1,0x91,0x4c,0xc9,0xaa,0xa,0x56,0xbc,0x3,0x18,0xed,0xc1,0xeb,0x60,0xcf,0xb8,0xad,0xc9,0x3c,0x2c,0x1b,0x92,0xba,0xd,0x50,0x63,0x22,0x7b,0xbe,0x85,0x63,0xfc,0x8a,0x7d,0x37,0x21,0xa4,0xf1,0x75,0x76,0x17,0x24,0x21,0x44,0x29,0x2c,0x92,0xf8,0x4b,0x34,0xd,0xa7,0x30,0x8,0x52,0x5c,0xf,0x86,0x70,0x17,0x65,0x37,0xf1,0x32,0x3,0x3c,0x91,0x4,0xf3,0xec,0x1e,0xe2,0x6b,0x8,0xe6,0xf7,0xf0,0x7b,0x34,0x9f,0xe,0x21,0xfc,0x63,0x91,0x84,0x69,0xa,0x71,0x72,0xa8,0x2b,0xb7,0x8b,0x59,0x14,0x22,0x2d,0x9a,0x4f,0x66,0xcb,0x69,0x34,0xff,0xc,0x9f,0x90,0x7f,0x1e,0x63,0x3a,0x45,0x98,0x54,0x28,0x3c,0x8b,0x9d,0xe2,0x4e,0x64,0x14,0xa6,0x24,0xf4,0x36,0x4c,0x26,0x37,0xb8,0xc,0x3e,0x45,0xb3,0x28,0xbb,0x1f,0xf6,0x2,0xaf,0xa3,0x6c,0x4e,0x3a,0xae,0xe3,0x4,0x2,0x58,0x4,0x49,0x16,0x4d,0x96,0xb3,0x20,0x81,0xc5,0x32,0x59,0xc4,0x69,0x88,0xe6,0x4c,0x51,0xfc,0x3c,0x9a,0x5f,0x27,0xa8,0x2d,0xbc,0xd,0xe7,0xd9,0x18,0xb5,0xe3,0x1e,0x84,0x5f,0x70,0x1,0xe9,0x4d,0x30,0x9b,0x91,0xca,0x5e,0x66,0xb0,0x44,0xaf,0x12,0xb2,0x1b,0x26,0xf1,0xe2,0x3e,0x89,0x3e,0xdf,0x64,0x70,0x13,0xcf,0xa6,0x21,0x6e,0x7e,0xa,0xd1,0xd2,0xe0,0xd3,0x2c,0x6c,0x55,0xa2,0xb3,0x93,0x59,0x10,0xdd,0xe,0x61,0x1a,0xdc,0x6,0x9f,0x43,0xc7,0x15,0xa3,0xb4,0x83,0xcf,0x74,0xbc,0xb5,0x1a,0xee,0x6e,0x42,0x22,0x91,0xfe,0x0,0xff,0x26,0x59,0x14,0xcf,0xc9,0xbd,0x49,0x3c,0xcf,0x12,0x5c,0xe,0xd1,0xfb,0x24,0xeb,0x45,0xdc,0x45,0x69,0x38,0x84,0x20,0x89,0x52,0x2,0xea,0x3a,0x89,0x6f,0xf,0x8e,0x13,0xec,0xc8,0x19,0x3b,0x61,0xc8,0x3f,0xf,0x5b,0x69,0x74,0x25,0xa7,0x37,0x87,0x47,0x68,0xbd,0x4c,0xc3,0x5e,0x30,0x4c,0xc3,0x60,0x86,0x32,0x53,0x62,0x3e,0x76,0x7d,0xcf,0x34,0xfe,0x81,0x92,0x39,0x69,0x9b,0xdb,0x4b,0x25,0x33,0x76,0xbd,0xa4,0x2f,0x44,0xd,0xcd,0x77,0x34,0xb3,0x1d,0xd7,0xed,0xd3,0x64,0x19,0x41,0xdf,0x38,0x4b,0x6b,0x37,0xe6,0xa3,0xe7,0x6d,0xb7,0xdb,0x31,0xd3,0x45,0x23,0xa4,0x1a,0xe7,0x39,0xe,0x1c,0x54,0xd,0x71,0x60,0xf9,0x73,0x55,0x31,0xf9,0x88,0x2d,0xb5,0xa5,0xb9,0xa6,0xfa,0x1d,0x51,0x47,0x73,0x21,0x2b,0xd8,0x5a,0x37,0xc2,0x7a,0x41,0xf7,0xf1,0xe7,0x9c,0xab,0x85,0xf8,0xca,0xab,0x73,0xd,0x48,0xd9,0x10,0x5,0xcb,0xff,0x4a,0x33,0xbd,0xfb,0xc7,0xaa,0xa6,0xca,0xa6,0xa8,0xe4,0x5c,0x13,0x12,0x30,0x7b,0xf5,0xf,0x2a,0x3a,0xcc,0xba,0xd8,0x31,0xa,0x82,0xdc,0xb3,0xd8,0x43,0xbc,0x9a,0x19,0x9c,0x5c,0xbc,0xad,0x58,0x8b,0xc2,0x4d,0x83,0x67,0x10,0x7e,0x49,0x30,0x75,0xd3,0xc5,0x87,0x5f,0xdf,0xbf,0x87,0x7f,0x43,0x1a,0xdc,0x4e,0xa1,0x83,0x15,0xdb,0x9b,0xe6,0x7f,0xd3,0xe,0x1c,0x5d,0xa5,0x1a,0xe1,0x4,0xec,0xa1,0xcc,0xc0,0xec,0x64,0x9e,0x4d,0x16,0xe7,0x5a,0x8f,0x88,0xff,0x58,0xc1,0x1d,0x5f,0xa5,0x5c,0x3f,0x71,0xfd,0xb2,0x9a,0xfe,0xc8,0xf,0xa3,0x9a,0x8a,0x7a,0x53,0xf1,0xc9,0x2c,0x3a,0x57,0xd2,0x93,0x48,0xf8,0xf,0x24,0x52,0x56,0xa2,0x18,0xf3,0xf2,0xd8,0x46,0x54,0x6a,0x39,0x34,0x47,0xed,0x94,0xa4,0xb7,0x10,0xb3,0x38,0x31,0x54,0x1b,0x4c,0xa9,0x9a,0x3d,0x52,0x3,0x3a,0x99,0x86,0x70,0xaa,0xaa,0x84,0xc5,0x6e,0xca,0xcd,0x86,0x63,0xe7,0xaf,0xaa,0xdd,0x77,0x33,0xd,0x1b,0xbe,0xb4,0x4a,0xa,0xd5,0x98,0x31,0x37,0xe7,0x4e,0x1e,0xd1,0xc9,0x4d,0x97,0xca,0x64,0x82,0x53,0x4e,0xf3,0x82,0x11,0xf,0xd2,0xf5,0x31,0x44,0x43,0x53,0x93,0xa3,0xae,0x83,0x59,0xaf,0x81,0x7f,0xc5,0xae,0x26,0xb8,0xcc,0xf9,0x4b,0x46,0xe0,0xd0,0x66,0x9b,0x15,0x6f,0x21,0xe7,0x3b,0xd2,0xf3,0x4c,0xb2,0xa7,0x1d,0xa5,0xd7,0xcf,0x31,0xa2,0x19,0x4d,0xee,0xd8,0x36,0x15,0x5e,0x1,0x75,0x57,0x9c,0x3b,0x48,0xb1,0xc5,0xac,0xcd,0xbf,0xeb,0xb3,0xb1,0xe2,0xb1,0xd5,0x7a,0xae,0x2d,0xd3,0xec,0x9,0x31,0x9d,0x9,0xd9,0xeb,0x73,0xe3,0x2a,0xaa,0x1b,0xba,0xb9,0xc3,0x8d,0x5f,0xe8,0xef,0x1a,0x9f,0x1,0xb2,0x45,0x19,0x3b,0xf0,0xc6,0x35,0x5e,0x24,0x35,0xc6,0xd,0x42,0x90,0x37,0xc6,0xe2,0x98,0x51,0xb3,0x82,0xc3,0x3e,0x35,0xbf,0x31,0x8c,0xa4,0xdc,0xc7,0x4b,0xa7,0xa3,0x31,0xc4,0x2c,0xec,0xeb,0x43,0xac,0xef,0xed,0x5f,0x3,0xfe,0x5a,0x29,0x4c,0xf0,0xee,0xcc,0x5f,0xa,0xe5,0xfd,0x63,0xf8,0x19,0x84,0xdd,0x1b,0xba,0xf,0x63,0x32,0xb3,0x37,0xd5,0x47,0x1,0xd2,0x3d,0x4d,0x30,0xc,0x69,0x40,0xa1,0xb7,0x9,0xed,0x1d,0x8e,0xfc,0xf5,0x69,0xf8,0xcc,0xd0,0xde,0xba,0xb1,0x50,0xe7,0x76,0x1d,0x53,0x3b,0xeb,0x7c,0x6f,0xef,0xb8,0xef,0xb5,0xef,0x46,0x7a,0x48,0xd2,0x43,0xfe,0xff,0xe2,0xf8,0xd8,0xb,0x8c,0x10,0x0,0x0 };

const uint8_t error404_html[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0x8d,0x54,0x5b,0x6b,0xdb,0x30,0x14,0x7e,0x5e,0x7e,0xc5,0xa9,0xf7,0xd2,0x41,0x6d,0xb5,0x6b,0x19,0x6d,0x71,0xc,0xa3,0x17,0x18,0xdb,0x58,0x21,0x19,0x63,0x4f,0x43,0x91,0x4f,0x22,0xad,0xb2,0x64,0x24,0x39,0x6d,0x60,0x3f,0x7e,0x47,0xb6,0xd3,0xda,0xe9,0xda,0xd5,0x60,0x5b,0xe7,0xf2,0x1d,0x9d,0x7b,0xbe,0x97,0xa6,0x13,0x0,0xb8,0xb0,0xf5,0xc6,0xa9,0x95,0xc,0xb0,0x2f,0xde,0xc1,0xfb,0xc3,0xa3,0x33,0x98,0x5,0x5c,0x72,0x3,0x9f,0x1d,0x56,0x1e,0x5d,0x54,0x9a,0x4b,0xe5,0xc1,0xdb,0x65,0xb8,0xe3,0xe,0x81,0xce,0x5a,0x9,0x34,0x1e,0x4b,0x68,0x4c,0x89,0xe,0x82,0x44,0xf8,0xfa,0x69,0xe,0x5f,0x3a,0x76,0x6,0x33,0xc4,0x96,0xd9,0xeb,0xc1,0x52,0x69,0xfa,0x58,0x7,0x25,0x6,0xae,0xb4,0xcf,0xa2,0xd5,0x99,0x6d,0x9c,0xc0,0x73,0x58,0xa9,0x20,0x9b,0x45,0x26,0x6c,0xc5,0x7c,0xcd,0x5,0xca,0x46,0x1a,0xf6,0x43,0x5d,0xab,0xcb,0x46,0xdc,0x4e,0xd2,0xb4,0x98,0xe4,0x7b,0x97,0xdf,0x2e,0xe6,0x3f,0x6f,0xae,0x40,0x86,0x4a,0x13,0xdd,0xfd,0xc8,0x6,0xe4,0x12,0x79,0xd9,0x1d,0x5b,0xb2,0xa2,0xb,0x40,0x48,0xee,0x3c,0x86,0x69,0xf2,0x7d,0x7e,0x9d,0x9e,0x26,0xc0,0x76,0x15,0xc,0xaf,0x70,0x9a,0xac,0x15,0xde,0xd5,0xd6,0x85,0x4,0x84,0x35,0x1,0xd,0x1,0xee,0x54,0x19,0xe4,0xb4,0xc4,0x35,0x39,0x9e,0xb6,0xc4,0x1,0x28,0xa3,0x82,0xe2,0x3a,0xf5,0x82,0x6b,0x9c,0x1e,0x66,0xa7,0x7,0x50,0x11,0xaf,0x22,0x56,0xa3,0x9e,0x35,0x4e,0xe1,0x57,0x98,0xa,0xab,0xad,0x1b,0xd8,0x7f,0x7b,0xfc,0xe1,0xf8,0xec,0xf8,0xea,0x59,0x54,0x89,0x5e,0x38,0x55,0x7,0x65,0xcd,0x0,0x15,0x93,0x1,0x31,0x1b,0xcf,0xe2,0x78,0x13,0xe4,0xe8,0xa2,0xd9,0x36,0x93,0x90,0xee,0x14,0x34,0x19,0x9a,0xd0,0xca,0xdc,0x82,0x43,0x3d,0x4d,0x7c,0xd8,0x68,0xf4,0x12,0x91,0xd2,0x11,0x36,0x75,0x8c,0x0,0xef,0x3,0x13,0xde,0x27,0x20,0x1d,0x2e,0x7b,0x8d,0x2c,0x32,0x6,0x6,0x3a,0x77,0xc1,0x3b,0x41,0xa,0xed,0x39,0xfb,0x4d,0xa,0x39,0xeb,0x88,0x81,0x66,0x50,0x41,0x63,0xf1,0x10,0xa,0xfc,0x81,0x2b,0xe7,0xac,0xcb,0x59,0x27,0xe8,0xaa,0xc9,0x1e,0xcb,0x99,0x2f,0x6c,0xb9,0x19,0xe0,0xd,0x5f,0x3f,0x52,0x2d,0xa7,0xd1,0x20,0x34,0xf7,0x7e,0x9a,0x54,0x68,0x9a,0x64,0x2c,0xed,0xc3,0x2b,0x72,0xde,0xbb,0xaf,0xa8,0x55,0xef,0xb3,0xd8,0x39,0xc9,0xa3,0x17,0x39,0xe3,0xe4,0x2b,0xa9,0xbd,0x8c,0xa5,0x66,0xa,0xca,0xac,0x7c,0xf,0x9f,0xf5,0xe4,0x2b,0xd1,0x1,0x1d,0x35,0xc,0xd7,0x3d,0x7a,0xde,0x93,0xaf,0x44,0xb,0x87,0xa5,0xa,0xdb,0xab,0x3f,0x2e,0x6c,0x13,0xfe,0x8d,0xcc,0x59,0xa3,0x7,0xf9,0x62,0xa3,0x84,0xe5,0xa5,0x5a,0x83,0x2a,0x63,0x15,0x79,0x68,0xda,0xa,0x11,0x67,0xd8,0x4c,0x5c,0x99,0x1d,0x7b,0x1e,0x45,0x6c,0xc4,0x62,0x32,0x79,0x43,0x4f,0x2e,0x8f,0x8a,0x93,0xc3,0x13,0x2a,0xd1,0x51,0xd1,0x31,0xea,0xee,0x7f,0xc3,0x57,0x8,0xc6,0x6,0x1a,0x70,0x5a,0x7,0x70,0xbe,0xdf,0x49,0x59,0x27,0xa6,0x4e,0xd8,0x9a,0x89,0xc4,0xf8,0x9a,0x7c,0x69,0x2d,0x65,0x67,0xe7,0xde,0x6d,0xe4,0x32,0x84,0xda,0x9f,0x33,0xf6,0xe2,0x82,0xa0,0x6e,0xe5,0x6e,0x15,0x87,0xfd,0xd7,0x42,0x73,0x73,0x4b,0xd5,0x69,0xf7,0x4a,0xcc,0xd1,0xd8,0xec,0xc2,0x15,0xf1,0xdd,0x89,0xb1,0xa6,0xc9,0x88,0x79,0x59,0xa3,0xf3,0x71,0xea,0x62,0xeb,0x12,0xaf,0x55,0x85,0x91,0xee,0x7f,0x57,0xe5,0x53,0xeb,0xbb,0x91,0x3c,0xb8,0x9f,0x29,0xfb,0xd4,0xf1,0xa1,0x74,0xe4,0x7e,0xce,0x86,0x79,0xca,0x59,0x37,0x19,0x54,0x89,0xb8,0x6,0xff,0x2,0xfe,0x91,0x6a,0x3e,0xca,0x5,0x0,0x0 };

const uint8_t index_html[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0xed,0x1a,0x6b,0x6f,0xe2,0xb8,0xf6,0x7b,0x7f,0x85,0x27,0x2b,0xad,0x5a,0xa9,0x3c,0xda,0xee,0xae,0x76,0x66,0xd3,0x48,0x14,0x42,0xa7,0x2a,0x5,0x44,0x82,0xaa,0xd9,0xd5,0x6a,0x64,0x12,0xd3,0x64,0x9b,0xc4,0x91,0xed,0x94,0x72,0x7f,0xfd,0x3d,0xb6,0x3,0x4d,0x81,0x30,0xc0,0x4c,0xd3,0xfd,0xb0,0x95,0xa,0xf1,0xb1,0xcf,0xfb,0xe1,0xe3,0x60,0xf3,0x43,0xad,0x76,0x84,0xe0,0xaf,0x4d,0xd3,0x39,0xb,0x1f,0x2,0x81,0x8e,0xbd,0x13,0x74,0xde,0x3c,0xfb,0x88,0x1c,0x41,0xa6,0x38,0x41,0xb7,0x8c,0xc4,0x9c,0x30,0xb5,0xca,0xd,0x42,0x8e,0x38,0x9d,0x8a,0x19,0x66,0x4,0xc1,0x73,0x14,0x7a,0x24,0xe1,0xc4,0x47,0x59,0xe2,0x13,0x86,0x44,0x40,0xd0,0xdd,0x8d,0x8b,0x7a,0x1a,0x5c,0x47,0xe,0x21,0xa,0x98,0xaf,0x43,0xd3,0x30,0x82,0xf,0xca,0x90,0x4f,0x4,0xe,0x23,0x5e,0x57,0x64,0x1d,0x9a,0x31,0x8f,0x7c,0x42,0xf,0xa1,0x8,0xb2,0x49,0xdd,0xa3,0x71,0x83,0xa7,0xd8,0x23,0x41,0x16,0x24,0x8d,0xfb,0xb0,0x1b,0x76,0x32,0xef,0xf1,0xa8,0x56,0xb3,0x8e,0xcc,0xf,0x9d,0x41,0xdb,0xfd,0x32,0xb4,0x51,0x20,0xe2,0x8,0xc6,0xfa,0x4b,0x12,0x31,0x3,0x82,0x7d,0xfd,0xa8,0x86,0x31,0x70,0x40,0x5e,0x80,0x19,0x27,0xe2,0xd2,0x18,0xbb,0xdd,0xda,0xef,0x6,0x6a,0xac,0x2e,0x48,0x70,0x4c,0x2e,0x8d,0xa7,0x90,0xcc,0x52,0xca,0x84,0x81,0x3c,0x9a,0x8,0x92,0x0,0xc2,0x2c,0xf4,0x45,0x70,0xe9,0x93,0x27,0x90,0xbc,0xa6,0x6,0xa7,0x28,0x4c,0x42,0x11,0xe2,0xa8,0xc6,0x3d,0x1c,0x91,0xcb,0x66,0xfd,0xf7,0x53,0x14,0x3,0x2c,0x6,0x50,0x16,0x96,0x12,0x7,0xfd,0x63,0x52,0xf3,0x68,0x44,0x59,0x81,0xfe,0x4f,0x17,0xbf,0x5d,0x7c,0xbc,0xb0,0x4b,0xb1,0x7c,0xc2,0x3d,0x16,0xa6,0x22,0xa4,0x49,0x1,0x4b,0x1a,0x3,0x49,0x6b,0x94,0xe2,0xe1,0x4c,0x4,0xaf,0x18,0x39,0xb,0x4b,0xa2,0xda,0x8a,0x4b,0x8d,0x22,0x89,0x28,0x4c,0x1e,0x11,0x23,0xd1,0xa5,0xc1,0xc5,0x3c,0x22,0x3c,0x20,0x4,0xcc,0x21,0xe6,0xa9,0xd4,0x80,0x3c,0x8b,0x86,0xc7,0xb9,0x81,0x2,0x46,0xa6,0xf9,0x8a,0xba,0x4,0x14,0x8,0x68,0x71,0x11,0x67,0x1e,0x2c,0x50,0xcf,0xf5,0x7f,0x60,0x81,0xd9,0xd0,0x83,0x92,0x95,0x21,0xc4,0xcd,0x73,0xd9,0x42,0x11,0x8a,0x88,0x58,0x4b,0x9d,0xcd,0x86,0x6,0x68,0x77,0x37,0x5e,0xfc,0x6d,0x4e,0xa8,0x3f,0x2f,0xe0,0x25,0xf8,0xe9,0x65,0xa4,0x20,0x59,0x84,0xbc,0x8,0x73,0x7e,0x69,0xc4,0x24,0xc9,0x8c,0xd7,0xb3,0xb9,0xfe,0x96,0x89,0x73,0xfd,0xb4,0x50,0x32,0xb4,0x8c,0x22,0x77,0xc,0x32,0xc2,0xb2,0xed,0xb8,0x10,0x6d,0x22,0x4c,0x1e,0x78,0x8e,0xee,0xe4,0xc3,0x1d,0xb1,0x5,0x61,0x10,0x51,0x38,0xca,0xb1,0xdd,0x7c,0xb8,0x23,0xb6,0xc7,0x88,0x1f,0x8a,0x5,0xeb,0xd6,0x84,0x66,0x62,0x33,0xa6,0xd9,0xc8,0xa2,0x82,0xbd,0x1a,0xaf,0xc,0x66,0xfa,0xe1,0x13,0xa,0x7d,0xe9,0x66,0x2c,0x32,0xe5,0x19,0x80,0x14,0xa3,0xd,0x87,0xc9,0xa,0x3d,0x4e,0x3c,0x19,0xa9,0x1b,0xe4,0xb,0xce,0x2c,0x47,0xd1,0x1,0x87,0x9d,0x6d,0x98,0x97,0xcc,0x72,0xd7,0x30,0x3a,0xdb,0xe0,0x19,0xb5,0x2a,0xb5,0xcc,0x89,0xe5,0xc,0x6f,0xba,0x5d,0xe7,0x13,0xc8,0x3b,0xb1,0x4c,0x28,0x10,0x89,0x92,0x72,0xca,0x8,0xb9,0x23,0x31,0x65,0x73,0xc3,0xaa,0x99,0xb2,0x70,0x24,0x20,0x71,0x5a,0x42,0x68,0x92,0x9,0x41,0x93,0x5,0x47,0x1f,0x27,0xf,0x90,0x7,0x9a,0xe,0x65,0x31,0x16,0x86,0xa5,0xbf,0x81,0x87,0x5a,0xb9,0x13,0x19,0xa8,0x86,0x89,0x91,0x9b,0x8c,0xa6,0x86,0x25,0x3f,0xf7,0x23,0x10,0x84,0x82,0x68,0xa,0x8c,0x40,0xe6,0x26,0x60,0x4e,0xc3,0x5a,0x3e,0x96,0xd3,0x5a,0x71,0x8d,0x6,0x6d,0x74,0xc6,0x37,0x5c,0xa4,0x52,0x8f,0x23,0x8,0xa5,0x85,0x33,0x48,0x44,0xb1,0x9f,0x6b,0xa5,0x67,0x47,0x1a,0x64,0xfd,0xfc,0xd3,0xf3,0xf9,0xd9,0x64,0xf2,0x87,0x8e,0xad,0x8d,0x5e,0x15,0x78,0x2,0x85,0x3e,0x27,0xa5,0x6,0x45,0x4a,0xae,0x2,0x0,0xae,0x9a,0x39,0x38,0x28,0xc2,0x24,0xcd,0x4,0x4a,0x23,0x59,0xdf,0x68,0x4,0xfb,0xcf,0xa5,0xd1,0x85,0xfd,0x45,0xd6,0x41,0xd4,0x30,0xe5,0x97,0x55,0xac,0x60,0xc6,0x82,0x24,0x8f,0x29,0x15,0x81,0x81,0x9e,0x70,0x94,0xc1,0x5c,0x43,0x8b,0x96,0x90,0x99,0xc4,0x2e,0x16,0xc5,0x2d,0x1e,0xe3,0x99,0xe7,0x11,0x59,0x11,0x69,0xe2,0xc1,0xe6,0xf6,0xa8,0x92,0xf,0xb,0x72,0xfc,0x40,0xc4,0x57,0x20,0xf5,0x75,0x9a,0x4b,0x72,0x7c,0x72,0x62,0x58,0x7a,0xee,0xed,0xdd,0x68,0x43,0xfa,0xc3,0xe6,0xba,0xd9,0x8b,0x44,0x4d,0xee,0xe1,0xc4,0xf7,0xf0,0x82,0x16,0x52,0x39,0x62,0xef,0xc,0xd6,0xb8,0x1d,0x12,0x11,0x48,0x26,0xcb,0x57,0xdf,0x7b,0xa5,0x61,0xca,0x60,0x2f,0x87,0x3a,0x52,0xa4,0x46,0x67,0x89,0x36,0x98,0x9f,0x3f,0x7d,0x2f,0xc5,0x56,0x6,0x1f,0x59,0x62,0x58,0x76,0xa2,0x92,0x4,0xeb,0xf1,0x5e,0xc1,0xb1,0x87,0x7b,0xa4,0xcd,0xa1,0x59,0xc3,0xab,0x66,0x7f,0x11,0x48,0x25,0x62,0xbe,0xea,0x47,0x73,0x2f,0xac,0xf2,0xc9,0x24,0x7b,0x90,0xbe,0xda,0xbc,0x54,0xfe,0xd,0x32,0x1,0xb1,0x4,0x5,0x7e,0x59,0xdc,0xb5,0x84,0x61,0x32,0xa5,0x50,0x55,0xf1,0x13,0xf1,0xf3,0x2,0xbf,0x99,0x5b,0x89,0xa8,0xdf,0xad,0xc1,0x8b,0x24,0xb5,0xdc,0xa1,0x35,0xed,0x2c,0xbe,0x45,0x99,0xb2,0x82,0xf1,0x42,0xcc,0x1,0x85,0xb4,0x5a,0xdb,0x63,0x6a,0xeb,0x8e,0x93,0x67,0xb5,0xc,0xa8,0xad,0x51,0xb4,0x73,0xfe,0x38,0xbb,0x6e,0x61,0x3b,0x5b,0xfb,0xa0,0x52,0xd6,0xa1,0x5e,0x6,0xbd,0x1a,0xb4,0xe,0xb0,0xa4,0xa4,0x40,0x5,0xe7,0x96,0xec,0xcc,0xe6,0x48,0x6f,0x5f,0xb0,0xea,0x7c,0xd3,0xaa,0xb,0xeb,0xa,0xf3,0xd0,0x93,0x1d,0xc8,0xc5,0x86,0xf9,0x92,0x56,0xe1,0x96,0xcc,0x39,0x92,0xc7,0x1c,0x4e,0x52,0xcc,0xa0,0x7c,0xfb,0x68,0x32,0x47,0x18,0x71,0x68,0xe7,0x20,0x6d,0xd5,0x1,0xa5,0x5e,0x52,0x3,0x98,0x85,0xec,0x27,0xc2,0xe6,0x22,0x80,0xc5,0x68,0xc6,0x42,0x1,0xbd,0x38,0x1c,0x1f,0x5e,0xd0,0xa1,0xdd,0x26,0x8,0xf6,0xa,0x8e,0x52,0x6,0x61,0x1,0xc4,0x71,0xe2,0xcb,0xfe,0x9b,0x60,0x35,0x10,0xea,0xd8,0xc4,0x65,0x11,0x15,0x61,0xbc,0x8d,0x91,0x4b,0x15,0x3,0x58,0x7,0x39,0x7c,0x8a,0x32,0xae,0x4f,0x5c,0x8e,0x3b,0xba,0xe9,0x5f,0xa3,0x69,0x96,0x28,0x23,0xd7,0x37,0x38,0x2a,0x2d,0xdb,0xb8,0xcb,0x4a,0xc9,0xeb,0x13,0xd6,0xfa,0x3c,0x2b,0x9f,0xcc,0x9,0x58,0xf6,0x33,0x8e,0xd3,0x8,0x2,0x1e,0x9e,0x77,0x58,0xc,0xdb,0x4a,0x92,0x47,0xc0,0x36,0x4,0x98,0x65,0x65,0x51,0xba,0x45,0x6a,0x53,0xbc,0x3e,0x38,0x1c,0xa0,0x91,0x6f,0xdd,0xdf,0xf4,0x3b,0x83,0x7b,0x67,0xeb,0xba,0xa5,0xb3,0xd8,0x76,0x72,0xd,0xe1,0x7f,0x9b,0xa1,0xb,0x7b,0xa9,0x72,0xf1,0x3d,0x9c,0x53,0xe8,0x8c,0xa3,0x47,0x32,0x57,0xd1,0x3,0xb0,0x44,0x4d,0x30,0x9,0xda,0x4e,0xac,0xdc,0x62,0xfb,0x2a,0x8e,0xd8,0x6e,0x62,0xf,0x65,0x9c,0x97,0xc9,0xad,0x45,0x86,0xe4,0x88,0xb3,0x48,0xe0,0x84,0xd0,0x8c,0x47,0x6f,0xaf,0x41,0x9e,0x23,0x7b,0x2a,0x72,0xaf,0xb2,0x6d,0x47,0xa4,0xad,0x91,0xb9,0x39,0xfa,0xca,0xdb,0x62,0x28,0x5f,0xdd,0x3c,0x9f,0xcb,0x8a,0x99,0x6e,0xbc,0x65,0x35,0xf7,0x65,0x65,0xac,0x2d,0xf2,0x9f,0xd7,0x74,0x17,0xfe,0x86,0xa9,0xdd,0xa6,0x71,0xc,0xee,0xdc,0x35,0xb5,0xf7,0xa8,0x3,0x9d,0x97,0x77,0x21,0xff,0xde,0x3a,0x60,0x7a,0xd4,0x27,0xd6,0xc8,0xbe,0x33,0x1b,0xea,0x69,0xb7,0x60,0x5a,0x62,0xa1,0xcf,0x24,0x8a,0x28,0xba,0xa7,0x2c,0xf2,0x3f,0xec,0x45,0x42,0xda,0x1d,0x36,0xca,0x37,0xcf,0x16,0x2d,0x6a,0xc7,0xee,0xb6,0xc6,0x3d,0xb7,0x63,0xf7,0x5a,0x5f,0x72,0x31,0x91,0x3c,0x72,0x14,0x27,0xbf,0x16,0x67,0xf7,0xb1,0x43,0x91,0x38,0x3a,0x6f,0x36,0xf7,0x22,0xe1,0xc2,0x3e,0x29,0xf7,0xd8,0x98,0xa3,0x9,0x11,0x33,0x2,0xc5,0x90,0xc8,0x4d,0x18,0x79,0xcb,0xc0,0xac,0xc6,0x40,0x87,0xea,0x2e,0x95,0x3e,0x6b,0xee,0xa9,0x35,0x1c,0x77,0xf0,0x5c,0xab,0x5d,0x91,0x82,0xba,0x6a,0x1e,0xa0,0x61,0x5e,0x6e,0xf,0xe,0x74,0xb9,0xf1,0xe9,0x1d,0x64,0x4a,0x81,0xc4,0x4c,0xf6,0x56,0x5c,0xc0,0xe9,0xe0,0xa1,0x22,0xcd,0x47,0xf6,0xd0,0x6e,0xb9,0x6b,0x51,0xf,0xe0,0xc3,0x5c,0xae,0xe9,0xa1,0x8b,0xbd,0x50,0x47,0x24,0x25,0x58,0x68,0x3b,0x40,0xf,0x2f,0x16,0xe1,0x8d,0x12,0xd5,0x29,0x56,0x15,0x5,0xbd,0x41,0xbb,0xd5,0xb3,0xf,0x50,0x5a,0x23,0xa2,0xce,0x7e,0xb8,0xe,0xc9,0x55,0x86,0x36,0x61,0x42,0x31,0xf3,0x41,0xf7,0x39,0xcd,0x44,0x1d,0xb5,0x33,0xc6,0xa0,0xfc,0x45,0xd0,0x3d,0x64,0xa9,0x7c,0x89,0x4f,0xfc,0x4f,0xcb,0x72,0x94,0xf3,0x38,0xcd,0x1,0xd7,0x57,0x2b,0x80,0xb1,0xb3,0x2,0xb0,0x57,0x1,0xdd,0x51,0xe,0xf8,0x8e,0xce,0xed,0x87,0x19,0xfd,0xd6,0xfe,0xd2,0x1e,0x74,0xe,0xb1,0x7a,0x8e,0x89,0x9a,0xcf,0xcd,0x73,0xf9,0xf1,0xcb,0x1,0x99,0x7,0x87,0x97,0x94,0x78,0xe1,0x34,0xf4,0x54,0xb3,0x26,0xf1,0xd1,0x71,0x4c,0x7d,0x80,0x10,0x76,0x2a,0x61,0x67,0x7f,0x9d,0xa2,0x7a,0xbd,0xae,0x9e,0x7f,0xfb,0xfb,0x44,0x96,0x25,0x1f,0x30,0x62,0x1c,0xc9,0x6c,0x9,0xc8,0x33,0xce,0x87,0x55,0x5,0xa9,0xdd,0x39,0x24,0x42,0xed,0xe,0xfa,0xa5,0x9,0xfb,0xf,0x54,0xe3,0xfd,0x76,0xe2,0x40,0x9e,0xa6,0x75,0x9c,0xaa,0xdf,0x7b,0x10,0x9d,0xaa,0x81,0xa4,0x58,0xb0,0xc5,0xe8,0xfa,0x4a,0xbf,0xf6,0xe2,0xe8,0xb8,0x59,0x3b,0xff,0xf5,0xd7,0x93,0x6a,0x9b,0x48,0x7,0x5a,0x6c,0x5f,0xe6,0x90,0x3c,0xe3,0x6e,0x6b,0x24,0xdf,0xb0,0x5b,0xbc,0x55,0x27,0x94,0x7f,0x75,0x2f,0x87,0x17,0x95,0xbe,0x96,0xd7,0x82,0xff,0xed,0x14,0xd,0x3f,0x2c,0x7a,0x5b,0xab,0xfc,0xff,0xac,0x96,0x7f,0x73,0x95,0xff,0xc7,0x6a,0xf9,0x77,0xcf,0x56,0x5,0xe8,0x9e,0x9d,0x7f,0xa7,0x8,0x87,0x25,0xcc,0x5d,0x5e,0xe4,0xfe,0x4b,0x98,0xad,0xe,0x6b,0xbb,0xa3,0xde,0x5a,0x77,0xd4,0x1e,0xf4,0xdd,0xd1,0xa0,0x57,0x6d,0xe8,0x38,0x9f,0x6f,0xba,0x6e,0xc5,0xd9,0xda,0xab,0x98,0x61,0xfe,0x6,0x62,0xcd,0xe0,0xd7,0xe3,0x9b,0x77,0x49,0x92,0x1,0x4,0xd9,0x7f,0x19,0xb2,0xdd,0x67,0x76,0xdf,0xb5,0x47,0xd5,0x86,0xc9,0x9d,0xdd,0x1f,0xaf,0xc5,0x48,0x6b,0x38,0xac,0x56,0xa,0x38,0xdd,0xda,0xae,0x5d,0x2d,0xcf,0xcf,0x83,0xbb,0x8a,0x39,0xde,0xf4,0x1d,0x7b,0x54,0x71,0x19,0x18,0xb6,0xae,0xed,0xf1,0xb0,0x7a,0x9e,0x50,0x7b,0xfa,0xd5,0x72,0x5d,0x6a,0xf9,0x12,0xc7,0xe3,0x61,0x6b,0x34,0x1a,0xdc,0x57,0x1c,0xcb,0x2f,0x9a,0x17,0x5e,0x7d,0x1,0xf0,0x1d,0x64,0xe9,0xd9,0xdd,0xf5,0x17,0x12,0x12,0xf8,0xe,0xb2,0x8c,0x6e,0xae,0x3f,0x6f,0x78,0x3b,0x22,0xa1,0xef,0x20,0x8d,0xdb,0xba,0xaa,0x96,0xa1,0xdd,0xef,0x54,0xcc,0xd0,0x69,0xaf,0x59,0x1b,0x60,0xad,0x61,0xc5,0x55,0xcf,0x19,0xb6,0xda,0x76,0xd5,0x5,0x68,0xec,0xd8,0x52,0xeb,0xab,0x91,0xdd,0xba,0xad,0x96,0x37,0x18,0xd8,0xe9,0xd,0xda,0x15,0x73,0xed,0x8f,0xef,0xaa,0x67,0x3a,0x1c,0xdd,0xf4,0x5d,0xa7,0x3d,0xb2,0xed,0x8a,0x4b,0x3d,0xf0,0x1c,0xf4,0x7a,0x3f,0x40,0xe1,0xfd,0x5a,0xd9,0xd,0x37,0x15,0xcc,0xc6,0xeb,0xeb,0x8e,0xe6,0x94,0x52,0x41,0x56,0xb8,0x2d,0x6f,0x60,0x6,0x42,0xa4,0xfc,0x53,0xa3,0xb1,0xf5,0x26,0xb3,0x81,0x4,0x66,0xf,0xf2,0x56,0xf2,0xd7,0x49,0x84,0x93,0x47,0xc3,0xd2,0x17,0xa0,0xe5,0x55,0xac,0xa3,0xd5,0x9f,0x8c,0xe5,0xff,0xca,0xb5,0x89,0xc5,0xe5,0x98,0x27,0xc2,0xb8,0xbc,0x1e,0x6c,0x2d,0x6e,0x3d,0xca,0x5f,0x98,0x5f,0xad,0xfd,0xe6,0xad,0xee,0x75,0xea,0xab,0x9a,0x2c,0xc5,0xaf,0x87,0x74,0x5d,0xf0,0xe2,0xec,0x2b,0xf1,0xcd,0x46,0xd1,0x4e,0x66,0x43,0x3b,0x1,0xe,0x6,0xea,0xbe,0xf6,0xd1,0xff,0x1,0xea,0x8b,0x66,0x70,0x78,0x2e,0x0,0x0 };

const uint8_t index_js[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0xad,0x59,0x5b,0x73,0x1b,0xb7,0x15,0x7e,0xe7,0xaf,0x38,0xda,0x99,0xc6,0xa4,0xa5,0xe1,0x4a,0x9e,0xf6,0xa1,0xd5,0xc5,0xe3,0xc6,0x56,0xea,0x69,0x94,0x74,0x2c,0x37,0x9e,0x4e,0x95,0xe1,0x40,0xbb,0x20,0x89,0xd1,0x12,0xcb,0x2,0x58,0x31,0x6c,0xa3,0xff,0xde,0x73,0x70,0xdb,0xbb,0x68,0xb5,0xf1,0x43,0x42,0x1,0x7,0xe7,0xf2,0x9d,0x2b,0xb0,0xe9,0xeb,0x9,0x0,0x7c,0x5b,0x6e,0xf7,0x4a,0xac,0xd6,0x6,0xa6,0xd9,0xc,0xde,0x9c,0x9e,0xfd,0x11,0x6e,0xd,0x5f,0x32,0x9,0x7f,0x55,0x7c,0xa3,0xb9,0x22,0xa2,0xcf,0x6b,0xa1,0x41,0x97,0x4b,0xb3,0x63,0x8a,0x3,0xfe,0x2e,0x44,0xc6,0xa5,0xe6,0x39,0x54,0x32,0xe7,0xa,0xcc,0x9a,0xc3,0xcd,0xc7,0xcf,0xf0,0xbd,0x5b,0x9e,0xc3,0x2d,0xe7,0x76,0xd1,0xd3,0xc1,0x52,0x14,0xf8,0x9f,0x52,0x41,0xce,0xd,0x13,0x85,0x9e,0x13,0xd7,0xdb,0xb2,0x52,0x19,0xff,0x13,0xac,0x84,0x59,0x57,0xf7,0xf3,0xac,0xdc,0xa4,0x7a,0xcb,0x32,0xbe,0xae,0xd6,0x32,0xfd,0x22,0xae,0xc5,0xfb,0x2a,0x7b,0x98,0xc0,0xeb,0x74,0x32,0x99,0xa4,0x29,0x5c,0xc6,0x7f,0xf0,0x5d,0x51,0xde,0xb3,0x2,0x7e,0x62,0x4a,0xb0,0xfb,0x82,0xeb,0xe6,0x5e,0x9a,0x5a,0xea,0x23,0x54,0x46,0x1b,0x28,0x97,0x56,0xb6,0x6,0xc5,0x4d,0xa5,0x24,0x6a,0x7c,0xbf,0x87,0xa4,0xd0,0x9,0xa0,0xb8,0xd,0x93,0xf9,0xe4,0x91,0x29,0x4b,0xb2,0x28,0x88,0xfe,0x12,0x92,0xe4,0xdc,0x33,0x8,0xec,0xc1,0x94,0xa0,0xd9,0x23,0x1a,0x2e,0xd,0x57,0x8f,0x28,0x98,0x2c,0xa9,0xb6,0x39,0x33,0x42,0xae,0x40,0x1b,0x66,0x2a,0x8d,0xfc,0x24,0xfe,0x59,0x56,0xba,0xd8,0x5b,0x9e,0x6e,0x79,0x11,0xcf,0x5c,0x5a,0xac,0x96,0x2,0x75,0x8,0x2,0xfe,0x2e,0x89,0x6d,0x6e,0x8f,0x72,0x69,0x90,0xbf,0x5,0x8d,0xe7,0xc2,0x94,0xca,0x32,0xa9,0x1c,0xc5,0x22,0x5b,0x33,0xb9,0x42,0xca,0x4b,0x58,0xb2,0x42,0xf3,0xc0,0xe0,0xba,0x60,0x2b,0x10,0x4b,0x7f,0x2,0xd6,0xc,0x3d,0x53,0xb2,0x1c,0x9,0x99,0x83,0x7c,0xcf,0x4d,0x6d,0x60,0xb9,0xe5,0xb2,0xcb,0xa3,0xf,0xea,0x75,0x25,0x33,0x23,0x4a,0x39,0x4,0xaa,0xfb,0xe3,0x27,0x56,0x54,0x1c,0xbe,0xe3,0x6,0x2d,0xf3,0x54,0x44,0xb0,0xf4,0x7,0x61,0xc5,0xcd,0x42,0xf2,0xdd,0x82,0x84,0x4a,0xb6,0xe1,0xd3,0x19,0xfc,0x7,0xfd,0xed,0x3c,0x0,0x1f,0xa6,0x9,0x6e,0x5e,0xe3,0x5e,0x32,0x9b,0x3f,0x12,0xab,0xf3,0xc9,0xd3,0xa4,0x7d,0xda,0xd9,0x33,0xce,0xc0,0xed,0x8f,0xf3,0xd0,0x3,0x3c,0xc2,0x8f,0xc3,0xbc,0x8,0x21,0x4f,0x3c,0xaa,0x9a,0x77,0x99,0xd7,0x8c,0x20,0xe,0x4e,0xbc,0xac,0x99,0xd6,0xca,0x21,0xd,0xba,0x69,0x7a,0xe4,0x89,0xe6,0x5c,0xe6,0xfa,0xb,0x86,0xfd,0x34,0xb9,0x93,0xc9,0x6c,0x46,0xd9,0xd0,0x60,0x10,0x7e,0x1d,0x3,0x6d,0xdb,0xd3,0x5e,0x5f,0xbf,0x63,0xd5,0x72,0x21,0x44,0x51,0xc8,0x43,0xc,0x56,0x18,0x82,0x5,0x8,0xf3,0x4a,0x83,0x2c,0x31,0x14,0x30,0x66,0x14,0x24,0xaa,0x92,0x12,0x3,0x35,0xa9,0xd,0xc9,0xd6,0x3c,0x7b,0x58,0xb8,0x43,0xde,0x4,0x52,0x2f,0xab,0x94,0x42,0xee,0x7e,0x63,0x2e,0x64,0x56,0x54,0x39,0xd7,0xd3,0xc8,0x61,0x6,0xbf,0xfe,0xa,0xa3,0x54,0x18,0xaa,0x96,0xc8,0x99,0xb3,0xd3,0xb,0x9b,0x22,0x3c,0xca,0x39,0xc7,0x75,0x8e,0x91,0x67,0xb7,0xb5,0x29,0xb7,0x8b,0x4e,0x8e,0x10,0x49,0x30,0xec,0xd6,0x30,0x65,0xea,0x8c,0x33,0x6b,0x66,0x9c,0xda,0x1a,0x30,0x6b,0x5d,0xf6,0x61,0x5a,0x53,0xbe,0xc,0x24,0x60,0x1d,0x9,0xc4,0xa6,0x2f,0x27,0x9a,0xdc,0xd9,0x99,0x79,0xa0,0xcf,0x81,0x94,0xb8,0x80,0x1f,0x65,0xb1,0xf7,0x8c,0x31,0x2e,0xf0,0x40,0x37,0xab,0x65,0x69,0x28,0xda,0xc8,0x45,0x3,0x6,0x7b,0x2e,0x98,0x2a,0x1,0x35,0xcf,0x60,0x2,0x3,0xf5,0x1,0xf9,0x7c,0xc,0x1a,0x36,0x3d,0x74,0x2,0x7f,0x38,0x3d,0x8d,0xcc,0xda,0xc0,0x34,0xf0,0x2a,0xb7,0xbf,0x5,0x5c,0x43,0x5e,0x89,0x68,0x1d,0xfd,0xbf,0x70,0xed,0xb0,0x42,0x79,0xb8,0x6,0xb4,0xb6,0x9a,0x62,0xbb,0x30,0x94,0x50,0xb6,0xf4,0x22,0x5d,0x56,0x70,0xa6,0x22,0x2e,0x5d,0x5,0xce,0x7,0x91,0x6c,0x54,0xda,0x80,0xcf,0xbb,0x2d,0x56,0xbf,0x1c,0x69,0x15,0xd5,0x6c,0xaa,0xe8,0x99,0x12,0x5b,0x13,0x32,0xaa,0x86,0x80,0x59,0x42,0x14,0xa4,0x9c,0xdd,0xbd,0x6c,0x86,0xe3,0x4b,0x62,0xd3,0xcd,0x41,0xed,0x2a,0xae,0xed,0x22,0x64,0xc8,0x86,0x6f,0x4a,0xb5,0x87,0x4a,0xb3,0x15,0xaf,0xb9,0xfb,0x8,0x89,0xd,0xc7,0x83,0x8b,0xb1,0xa3,0x49,0x6a,0x82,0xa7,0x92,0x13,0x8,0xe4,0xd3,0x8d,0x5e,0x39,0x2,0x57,0x63,0xa,0xb4,0x9,0x2b,0x2e,0xe0,0xf2,0x5c,0x6f,0xb,0x61,0xa6,0xe9,0x9d,0x4c,0x2d,0x8,0x8e,0xe0,0x7e,0x6f,0xa8,0x7c,0x59,0xba,0x7f,0x9e,0xfe,0xec,0x89,0x12,0x48,0x66,0xf8,0x57,0x4d,0x56,0x69,0xdb,0x7,0x1c,0xd9,0xd9,0x28,0xd9,0x52,0xf1,0x9a,0xdb,0x9b,0x1e,0x59,0xa4,0xdb,0x72,0xec,0xe3,0xb6,0x72,0xdd,0x30,0xb3,0x9e,0x2f,0x8b,0xb2,0x54,0x53,0xab,0x4a,0xa,0x67,0x14,0xba,0x2d,0x8e,0x83,0xd4,0x56,0x54,0x1a,0x38,0xcd,0x3c,0x73,0xc4,0x9e,0x36,0x6e,0x2c,0x94,0x88,0xbf,0x90,0x92,0xab,0xbf,0x7c,0xbe,0xf9,0x9e,0x7c,0x4c,0x36,0x60,0x85,0x74,0x36,0xdb,0xbf,0x50,0xb5,0xe3,0x96,0x8,0xdc,0xfe,0x9d,0x5d,0x98,0x25,0x9e,0x63,0xaf,0xd3,0xfb,0x52,0xe5,0xd0,0xc7,0xb9,0xa0,0x1,0x7e,0xa6,0x1f,0x3,0xf8,0xcd,0x83,0xe8,0x7e,0xdc,0xf1,0x47,0xdb,0x7e,0x89,0x44,0x7d,0xef,0x38,0x42,0x43,0x41,0xed,0xd,0x48,0x2e,0x30,0x1b,0x59,0x7e,0x15,0x4a,0x3c,0xfd,0xab,0xf7,0x8f,0x2d,0x81,0x72,0xbb,0xc3,0x9b,0xeb,0x2b,0xea,0x5a,0x17,0x29,0xfe,0x78,0x96,0xea,0xcf,0x8,0xd0,0x61,0xaa,0x77,0xae,0xeb,0x1f,0x20,0x4c,0x9f,0x55,0x29,0x6d,0x58,0x34,0x2c,0xe7,0xbe,0xcc,0xf7,0x2d,0x8b,0x69,0x94,0x9a,0x12,0x34,0x2,0x21,0x39,0x3d,0xc7,0xff,0x5d,0x38,0x38,0xe7,0xd8,0x81,0x57,0x66,0x8d,0x2b,0xc7,0xc7,0xb5,0x1b,0x1c,0x8c,0x98,0x43,0x2c,0x6,0xa6,0x68,0x6,0xe6,0x79,0x8b,0x8e,0xfc,0xf1,0x3,0xb6,0x71,0xa4,0xa5,0x23,0x31,0xb8,0x9b,0xfb,0xb7,0xe2,0xdf,0x71,0xff,0xec,0xe7,0xa8,0x97,0x2b,0x78,0x81,0x81,0x57,0x6,0xae,0xe0,0xb4,0xa9,0x8b,0x23,0x42,0xcd,0x51,0x75,0xf8,0xe6,0x1b,0x38,0x6a,0xcc,0x59,0x6d,0x3a,0xea,0xe0,0x2c,0x8f,0xfc,0x1a,0x7a,0x2,0x3c,0x35,0x7e,0x3f,0x1b,0x0,0x43,0x4,0xf9,0x95,0xd,0xfa,0x60,0xe8,0xb1,0xf5,0x42,0xfe,0xf5,0xa7,0xac,0xf9,0x5f,0x7d,0xea,0x79,0x82,0xfb,0xca,0x18,0x9a,0x2e,0xa,0xa6,0xf5,0xe5,0x5d,0xb2,0x55,0x62,0xc3,0xd4,0xfe,0x2e,0x81,0x12,0x67,0x4,0x91,0x3d,0xe0,0x9a,0x45,0xe1,0x55,0x57,0xe5,0x57,0xb3,0xbb,0xe4,0x8a,0xaa,0xec,0x45,0xea,0x78,0xbc,0x4c,0x10,0xde,0x4a,0x64,0x5b,0x4a,0x25,0x47,0x84,0xe0,0xce,0x57,0xca,0x48,0xbb,0xd8,0x7,0x37,0x3d,0x8d,0xc5,0x7e,0x2f,0xb6,0xb1,0x7c,0xb9,0x2e,0xf3,0x99,0x48,0x3b,0xf5,0x2b,0x1e,0x77,0x12,0x9e,0x6c,0x48,0x3c,0x35,0x26,0xa0,0xeb,0x52,0x6d,0xb0,0x8b,0xdf,0xfe,0xed,0xe3,0xf5,0xf5,0x6d,0xdd,0x41,0x96,0x76,0xb9,0x39,0xb5,0x95,0x72,0x29,0xd4,0x66,0x9a,0xb4,0xe,0xbc,0x75,0x97,0xb6,0x9d,0x28,0xa,0xbc,0x74,0x15,0x1c,0x6b,0x24,0xc3,0x9f,0x4e,0x1f,0x7d,0x84,0x53,0x9a,0x8f,0xcf,0x58,0xfc,0x1c,0x63,0x2c,0x80,0x45,0xb9,0x5a,0xec,0xb4,0xf,0x51,0x56,0x70,0x65,0x2,0x6f,0x7b,0xdf,0xb1,0x2c,0xd,0x7b,0x40,0x86,0xb0,0xc1,0x46,0x6f,0xf8,0xfc,0x4e,0xfe,0xa3,0xac,0xf0,0xfa,0xf1,0x68,0xef,0x4a,0x8a,0xa3,0x4a,0x92,0x67,0xd8,0x7,0x97,0xd8,0x92,0xd1,0x3b,0xb9,0x9e,0xbb,0xd4,0x7c,0x8a,0xd6,0x7d,0xaa,0xa4,0x57,0xa6,0x36,0x8d,0xdc,0x16,0x33,0xa4,0xdd,0x17,0x71,0xb,0xee,0x12,0xe7,0xd2,0x5f,0xae,0x3d,0x4d,0x83,0x98,0x46,0xe5,0xa4,0xad,0xfb,0xc8,0xe8,0x77,0xde,0x1e,0x99,0xfc,0x68,0xb,0x7a,0xcb,0x33,0xb1,0x14,0x59,0x4f,0x29,0x1a,0x89,0xc6,0xb4,0xa2,0xbd,0x17,0xa8,0x75,0x2,0x46,0x55,0x7c,0x4c,0x83,0x86,0x7b,0xda,0xd2,0xdf,0x15,0xc5,0x74,0x40,0xf0,0x38,0xdb,0x4f,0x1c,0xa7,0x4d,0x2d,0xd0,0x1b,0x94,0x6e,0xd8,0x0,0xcb,0xd,0x4d,0x2c,0x9c,0x6d,0x1a,0x58,0xe3,0xce,0xc2,0x2d,0x76,0x99,0xd3,0x56,0xab,0xf,0xba,0x11,0x29,0x4,0x8c,0x8f,0x39,0x7b,0x43,0x39,0xc2,0xc8,0xbf,0x82,0xf,0x3f,0xbc,0x4f,0xea,0x72,0x37,0x38,0x30,0xc5,0x8b,0x4b,0x5d,0xc,0xa3,0xf4,0xb0,0xe8,0xc7,0x66,0x2b,0x1f,0x1,0x99,0xcf,0xe7,0xa1,0x9e,0x3f,0xd9,0x7b,0x43,0x94,0x10,0x35,0xcd,0x8a,0x52,0xf3,0x6e,0xc4,0x8e,0x5d,0x3d,0x5c,0xe6,0x36,0x33,0xec,0x47,0x2c,0xd4,0x1e,0x18,0x8a,0x5b,0x77,0x67,0x6e,0x43,0xd4,0xf1,0x7c,0x3b,0x18,0x6c,0xa2,0x37,0x7a,0xcc,0x60,0xc,0x58,0xa2,0xb1,0xb,0x69,0xec,0x5,0x7d,0xd0,0xe2,0x7c,0xd2,0x70,0xba,0xd5,0x34,0xc4,0x5b,0x5d,0xd9,0xda,0x91,0x3f,0xe9,0xc2,0xeb,0x87,0xf3,0x4f,0x36,0x16,0x68,0x46,0xf5,0xce,0xd0,0x30,0x55,0x21,0x52,0x8a,0xfd,0x2c,0x18,0x53,0xbf,0x13,0x50,0x58,0xd5,0x68,0x7d,0x8b,0xec,0xa8,0x8a,0x0,0x5e,0xdf,0x3b,0x48,0x65,0x76,0xeb,0x37,0xc2,0x2a,0xf4,0x5d,0x37,0x48,0xc5,0xeb,0x65,0xd3,0x60,0xa8,0xcb,0x57,0xbf,0xad,0xb6,0x82,0xe5,0x20,0xf0,0xcf,0x42,0xdf,0xc,0x35,0x67,0xfd,0x21,0xf0,0xe9,0x4c,0x7f,0xc6,0x6f,0x97,0xbe,0xf7,0xbe,0x1c,0xf7,0xc2,0x6d,0x53,0x3e,0x1e,0x2,0xb1,0x95,0xa6,0x44,0xff,0xd2,0xaa,0x38,0xac,0x5c,0xff,0x9d,0x29,0xfa,0xbe,0xbe,0x18,0x55,0x88,0xd1,0x78,0x85,0xa6,0x6b,0x9b,0x27,0x79,0x99,0x4e,0x1,0x96,0x2f,0x4a,0x98,0x18,0x9b,0x94,0x8f,0x6d,0x78,0x76,0xb4,0x1d,0xf9,0x9c,0x40,0xab,0x2a,0xfd,0xaf,0xb1,0xd6,0x7,0x33,0x35,0x7c,0xb3,0x2d,0x15,0xce,0x2d,0xb,0x57,0x8c,0xbb,0x0,0xf6,0x23,0xe2,0xc0,0x91,0xc1,0x14,0x3e,0x7c,0x86,0xe6,0x53,0x7f,0x6e,0x81,0xeb,0x64,0xc6,0xc0,0xad,0x30,0xd4,0x4c,0xf7,0xf6,0xd2,0x28,0x99,0x8e,0x95,0x25,0xb5,0xd1,0x17,0x79,0x6e,0x1f,0x8c,0x76,0x23,0xef,0xd9,0xe9,0x9b,0xdf,0x3b,0xa8,0x6,0x66,0x70,0x7b,0x37,0xcb,0xb8,0x28,0x42,0xad,0xf,0x23,0x70,0x1a,0x38,0xcc,0x5a,0xa3,0xb9,0xbd,0x7d,0xf2,0x95,0x90,0xc8,0x42,0xc0,0xeb,0x40,0x54,0x5f,0xfd,0xe8,0xf6,0x7d,0xe9,0x49,0x8e,0xdb,0xdb,0x94,0xf1,0xb4,0x7d,0x5,0x6d,0x59,0x33,0x7f,0xa8,0xbd,0xda,0xce,0xcc,0x85,0x62,0xbb,0xa8,0xa2,0xae,0xee,0xdd,0x5,0x7f,0x6a,0xe5,0x9c,0xd0,0xf9,0xd9,0x49,0x13,0x46,0x9f,0x8a,0x93,0xe7,0x9a,0xc8,0x33,0x49,0x36,0x9e,0xf6,0x8d,0x13,0x54,0x64,0x86,0x5d,0xfc,0x35,0xb5,0x7b,0xa8,0x79,0xc5,0x79,0x81,0x26,0x2c,0x5b,0xc2,0xed,0x3,0xf,0xce,0x77,0xfe,0x59,0xa9,0xd8,0x3,0x55,0xed,0xce,0xb,0x72,0x3d,0x45,0xe0,0xb9,0xd0,0xe5,0x6d,0x1a,0xd,0x3e,0xb2,0x9e,0xc,0x3e,0x70,0x8e,0xd4,0x7,0xff,0x86,0xdc,0x28,0x9f,0x42,0x2e,0xcb,0xce,0x8c,0x9b,0xd8,0x53,0xc9,0x58,0xdd,0x89,0x93,0x6e,0xd0,0x33,0x5a,0x85,0xb3,0x10,0x4a,0xc1,0x81,0xde,0x7d,0x46,0xd8,0xf1,0x7b,0x5d,0x66,0xf,0xdc,0x3e,0xd7,0xd0,0x64,0x69,0xb,0x2,0xd3,0xc0,0x35,0x8d,0xd1,0x42,0xaf,0x79,0xde,0xa8,0x14,0x7a,0xe1,0xc9,0x78,0xee,0xad,0x1e,0x97,0xde,0x78,0xe4,0xb6,0x2f,0x6b,0xd5,0xb6,0xf3,0xee,0xbd,0x13,0x32,0x2f,0x77,0x73,0x96,0xe7,0x1f,0x1e,0x11,0x10,0xfa,0xaa,0x80,0xed,0x51,0x4d,0x13,0x7a,0x69,0x6f,0x8e,0x49,0xf1,0xb9,0x28,0xce,0xbf,0x88,0x86,0xbf,0x93,0x20,0x16,0x3b,0x1a,0x42,0x85,0xf1,0x90,0xf9,0x41,0xef,0x13,0xb7,0x5c,0x9a,0x74,0x5d,0x55,0xfd,0x1,0x3f,0x9d,0x37,0x29,0xdd,0x52,0x60,0x48,0x13,0x61,0x73,0xd7,0x4f,0x8e,0x36,0xa6,0xa2,0x8f,0x6,0xe4,0x75,0xf4,0xf7,0x1d,0x75,0x30,0x40,0x1a,0x95,0x24,0x72,0xa4,0x90,0x6c,0xcb,0xc5,0x85,0x36,0x89,0xeb,0x77,0xcf,0xb,0x6d,0x5d,0x64,0x7c,0x83,0xa4,0x54,0x19,0xfe,0x1a,0x80,0x79,0xf3,0xb6,0x1e,0x1,0x20,0xb4,0xce,0x71,0xa5,0xfd,0xec,0xd7,0xd1,0xab,0xdc,0xc9,0xc3,0x70,0xe4,0x9e,0x6a,0x61,0x7e,0x31,0x2f,0xce,0x9b,0x2e,0x58,0x5d,0x27,0xf5,0xa4,0xd9,0x46,0xf6,0xc,0xf8,0x6d,0x6f,0x56,0xf2,0x30,0xaa,0x9d,0xd4,0xad,0x41,0x73,0x45,0x21,0xa0,0xe3,0x5c,0x8f,0xed,0xfd,0xab,0x3d,0x6f,0x45,0x3f,0xf0,0x3d,0x65,0x4c,0x5f,0xf4,0xd8,0x44,0xd1,0x9a,0xb8,0x86,0x4a,0x46,0x15,0x3e,0x8a,0xd9,0x83,0x3a,0xe9,0x9b,0xfd,0xce,0x4d,0x19,0x2f,0x8,0x28,0xba,0x6c,0x1a,0xfb,0xd,0xd3,0x3d,0xfa,0xd2,0x9c,0x82,0xa9,0x23,0xa8,0xce,0x60,0xe5,0xf4,0x9f,0x9,0xaa,0xed,0x5b,0x77,0x91,0xcd,0x98,0x84,0x5c,0x68,0xfb,0xed,0x4f,0xc4,0xcf,0x72,0x38,0xe0,0xd0,0xfd,0x97,0xae,0xb2,0x33,0xf,0x61,0x18,0x89,0xe,0x38,0xcc,0x16,0xb9,0x1b,0x7b,0x63,0xc6,0x3b,0xde,0x45,0x56,0xe6,0xfc,0x4a,0xfb,0x87,0x66,0x1a,0x74,0xea,0x92,0xd,0xbb,0x35,0xa7,0x77,0xd,0x34,0xa,0x2b,0x5a,0xf8,0xb0,0x94,0xdb,0xc7,0xc5,0xbc,0xcc,0xaa,0xd,0x75,0xb9,0x7f,0x55,0x5c,0xed,0x6f,0x31,0x47,0x32,0x2,0x3,0x2f,0x87,0x9,0x91,0xb8,0xc6,0x3f,0xd4,0xca,0x2d,0x83,0xa1,0xe7,0x34,0xbb,0x41,0xef,0x67,0xfd,0xe2,0x66,0x55,0xe8,0x57,0x37,0x6b,0xb4,0x7b,0x20,0x27,0x3c,0x1b,0x9e,0xa3,0xa9,0x9c,0xbe,0x65,0xb5,0x5e,0x33,0x7c,0x3f,0xa3,0xba,0x67,0x2b,0xee,0x89,0x6b,0x1b,0xb3,0xf3,0xff,0x2,0x9e,0xfa,0xf5,0xfd,0x7c,0x1e,0x0,0x0 };

const uint8_t script_js[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0x9d,0x56,0x5b,0x6f,0xdb,0x36,0x14,0x7e,0xf7,0xaf,0x60,0x55,0xa0,0x96,0x53,0x57,0x8a,0x9b,0x5d,0xda,0x18,0x19,0xb0,0xa5,0x9,0x1a,0xac,0xd9,0x80,0x25,0x43,0x1e,0xd2,0xc0,0xa0,0xa9,0x23,0x99,0x8b,0x4c,0xba,0x24,0x65,0x27,0x58,0xf3,0xdf,0x77,0x78,0x91,0x2c,0xc9,0x5e,0xbb,0xce,0xf,0x86,0x74,0xf8,0x9d,0xef,0xdc,0xf,0x95,0x1e,0xc,0x8,0x21,0xa7,0x72,0xf5,0xa8,0x78,0xb1,0x30,0x24,0x66,0x23,0xf2,0xfa,0x70,0xf2,0x96,0x5c,0x19,0xc8,0xa9,0x20,0xbf,0x2a,0x58,0x6a,0x50,0x16,0x74,0xbd,0xe0,0x9a,0x68,0x99,0x9b,0xd,0x55,0x40,0xf0,0xb9,0xe4,0xc,0x84,0x86,0x8c,0x54,0x22,0x3,0x45,0xcc,0x2,0xc8,0xe5,0xc5,0x35,0xf9,0xe0,0xc5,0x9,0xb9,0x2,0x70,0xc2,0x80,0x23,0x39,0x2f,0xf1,0x4f,0x2a,0x92,0x81,0xa1,0xbc,0xd4,0x89,0x65,0xbd,0x92,0x95,0x62,0x70,0x4c,0xa,0x6e,0x16,0xd5,0x3c,0x61,0x72,0x99,0xea,0x15,0x65,0xb0,0xa8,0x16,0x22,0xbd,0xe1,0xe7,0xfc,0x5d,0xc5,0xee,0x7,0xe4,0x20,0x1d,0xc,0xd2,0x94,0x9c,0xd8,0x1f,0x79,0xf,0xe5,0xa,0xd,0x9e,0x57,0x82,0x19,0x2e,0x85,0xe,0xe2,0x34,0x1d,0xe4,0x41,0x44,0x4a,0x59,0xc4,0x4b,0x5d,0x8c,0xc8,0xdf,0x68,0x84,0x21,0x46,0x96,0x90,0xd4,0xc2,0xe9,0xe0,0x69,0xb0,0x85,0x9e,0xc5,0x3c,0xf3,0x38,0x5,0xa6,0x52,0x82,0x64,0x92,0x55,0x4b,0x10,0x26,0x29,0xc0,0x9c,0x95,0x60,0x1f,0x7f,0x79,0xbc,0xc8,0x2c,0xac,0xab,0x99,0xc9,0x8d,0x28,0x25,0xcd,0x66,0xe6,0xc1,0xc4,0x36,0xba,0xdf,0xe8,0x12,0xc6,0x2e,0xce,0x53,0x29,0xc,0xea,0x79,0xde,0x35,0x55,0x4,0x3c,0x11,0x39,0xd9,0xd2,0x33,0x5,0xd4,0x40,0xb0,0x10,0xf,0xe9,0x10,0xe9,0x49,0xd,0x4c,0x34,0x98,0x9f,0x8d,0x51,0x7c,0x5e,0x19,0x88,0x87,0xb,0x5,0xf9,0x70,0x4c,0x86,0x19,0x35,0xf4,0xd8,0xc0,0x83,0x49,0x57,0x25,0xe5,0x62,0xca,0x16,0x54,0x21,0xf2,0xa4,0x32,0xf9,0xab,0x37,0xe3,0x21,0x79,0x49,0x40,0x30,0x99,0xc1,0x9f,0x7f,0x5c,0x9c,0xca,0xe5,0x4a,0xa,0x4b,0xdd,0x76,0xe8,0xb,0x36,0xea,0x70,0x86,0x3e,0x4,0x1b,0xc,0xa2,0xdb,0x70,0xf3,0x88,0x59,0xcc,0xb8,0x46,0xdb,0x8f,0x18,0xc9,0x50,0x20,0xff,0xd0,0x12,0x36,0x31,0xcd,0x65,0xf6,0x98,0xd0,0xd5,0xa,0x44,0x76,0xba,0xe0,0x65,0x16,0x7,0xdd,0x2e,0x11,0xc3,0x96,0xb8,0x8f,0xbd,0xac,0xab,0x8a,0xed,0x26,0xd7,0xd0,0x57,0x6d,0x27,0x3d,0xe7,0xf,0xe7,0xc1,0xbb,0x26,0xe7,0x3e,0xcd,0x3c,0x27,0x8d,0x24,0x29,0x41,0x14,0x66,0x41,0x7e,0x22,0x87,0xfe,0xb0,0x7b,0x7c,0x7b,0x78,0x47,0x9e,0x61,0x0,0xe9,0xb0,0x3e,0x25,0x4d,0xcc,0xc4,0xc9,0x31,0x93,0xb5,0x60,0xea,0x0,0x4f,0x83,0x41,0xf,0xd5,0xd8,0x52,0x80,0x9,0x61,0x10,0xa7,0x24,0x2d,0xb0,0x46,0x1f,0x5f,0xf9,0x4a,0x3e,0x6d,0x5b,0x6a,0x4b,0xf5,0xd4,0xea,0xe3,0x77,0xbf,0x5f,0x92,0x4b,0x2a,0xf8,0xaa,0x2a,0xa9,0x8b,0x6d,0xb7,0x8f,0xb5,0xa1,0xa6,0xd2,0xf1,0x12,0x4b,0x1a,0x7a,0xb9,0x52,0xa,0x93,0x32,0xf3,0x7,0xe8,0x85,0x3d,0x72,0x89,0xb4,0xf1,0xd9,0x17,0x64,0x21,0x11,0xb6,0xbc,0x0,0x66,0x20,0x8b,0xea,0x0,0xcf,0xe2,0xc8,0xeb,0x44,0xa3,0x50,0xc8,0x39,0x65,0xf7,0x85,0x92,0x38,0xbd,0xa7,0xb2,0xc4,0xb1,0x44,0xb5,0xe7,0x47,0xec,0xfb,0xc8,0xf9,0x8e,0xb5,0xc2,0x91,0xed,0x70,0x62,0xe1,0xff,0x2f,0x6d,0x76,0x74,0xb4,0x8f,0x36,0xe1,0x82,0x95,0x55,0x6,0x3a,0x8e,0x56,0x4a,0xce,0xb1,0xde,0xc8,0xfb,0xf9,0x33,0xe9,0x9d,0x81,0x52,0x52,0x45,0xa3,0x6f,0x33,0x99,0xe7,0x6c,0x72,0xf8,0x63,0xdb,0x6a,0x7a,0xb0,0x2f,0x45,0x5c,0x14,0x49,0x92,0x44,0xa3,0x83,0xf4,0x9b,0xe8,0xf,0x29,0x78,0x6e,0x9b,0xfa,0xb6,0xa,0x47,0x56,0xf5,0xfe,0xfa,0xf2,0x43,0x53,0x9b,0x76,0xc9,0x6f,0x60,0x8e,0x2b,0x8f,0xdd,0x83,0xd9,0xbf,0xb4,0x66,0x1b,0xbd,0xdd,0x5b,0x76,0x5f,0x45,0xb7,0x37,0x57,0x77,0x24,0xc2,0x76,0xdc,0xdd,0x5c,0x38,0xbe,0xb3,0x35,0x28,0x8d,0xcf,0xb1,0x36,0xca,0x2b,0xa1,0x2f,0x41,0xd6,0x73,0x6,0x11,0x4e,0xdd,0x6e,0xa3,0x8d,0xed,0x1c,0x51,0x95,0xe5,0x14,0x1d,0x20,0x1b,0x74,0x4a,0x7b,0xa7,0xb8,0xc0,0x40,0x4,0x83,0x80,0x9a,0x31,0x5a,0x96,0x36,0x7c,0x84,0x7b,0xef,0x9c,0xc2,0x12,0xb4,0xa6,0x5,0x60,0x77,0x33,0xe0,0x6b,0x20,0x35,0xaa,0xd6,0x42,0x57,0x67,0x9f,0x2a,0xa8,0xec,0x94,0xdc,0xde,0x39,0x15,0xff,0x6a,0xb7,0xbf,0xac,0x4c,0x21,0x31,0xeb,0x35,0x8b,0x76,0x5a,0xcc,0x58,0x97,0x72,0x8a,0x85,0x72,0x78,0x56,0x2,0x4a,0x8d,0xc4,0x20,0x45,0x46,0xf2,0x92,0x16,0x4e,0xb9,0xb6,0xec,0xe8,0x7c,0x2c,0x3b,0x13,0x11,0x61,0x61,0x6a,0x4f,0x1c,0x6e,0xc6,0x71,0xf7,0xa9,0x35,0x2d,0xeb,0xa0,0xbb,0x5,0x9,0xf5,0xf8,0xd2,0x75,0xd2,0x8e,0x69,0x56,0xad,0x70,0xb,0x43,0xbc,0x5d,0x3a,0xd6,0xf7,0x17,0x2f,0x3a,0xa0,0xde,0xfe,0x71,0x8d,0x65,0x5d,0xe2,0x6,0x96,0xe8,0x45,0x7,0xaa,0x17,0x3c,0x37,0x61,0x1b,0x7a,0x54,0x1d,0xe5,0x89,0xc3,0x27,0xe1,0x75,0xda,0x9c,0xb7,0xaa,0xe2,0x0,0xf5,0x7b,0xa0,0xd8,0xe8,0xc4,0x66,0x2d,0xe,0x7a,0xa3,0x69,0x90,0xb6,0xab,0xd9,0x53,0xa9,0xaf,0xc8,0xc,0xe6,0x15,0x36,0xdd,0x73,0xdf,0x71,0x1d,0xfd,0x76,0x85,0x5c,0xe3,0xb7,0x5b,0x11,0xc9,0xdb,0x26,0xc7,0xd,0xff,0xd8,0x96,0x8d,0x41,0xad,0xb9,0x4d,0xda,0xb3,0x0,0x4d,0x50,0x4d,0xdf,0xe0,0xed,0x1f,0xf,0x3f,0x8a,0x21,0xe,0x79,0x1d,0xfc,0x4b,0xdc,0xc3,0x28,0x71,0xe,0x6,0xfa,0x99,0xa2,0x9b,0x7f,0x35,0xd1,0x1b,0x8e,0xff,0xa2,0xd2,0xf5,0xca,0x66,0x56,0xce,0xff,0x42,0xa1,0x5f,0x4,0x51,0x50,0x8b,0x8e,0x6b,0x9f,0xc6,0x5e,0x5e,0xb3,0xe0,0x41,0xd3,0xf9,0x98,0x90,0x66,0xb,0x7b,0x77,0x2,0x4b,0xa7,0xd4,0x95,0xf0,0xc5,0x46,0x33,0xa3,0xd6,0x66,0xda,0x83,0x5c,0x55,0x7a,0xb1,0x85,0xf5,0x23,0xf3,0x2d,0x18,0x5a,0x3e,0x74,0x62,0x5d,0x82,0x7a,0x15,0x8d,0xc3,0xe5,0xb1,0x9b,0x17,0x2e,0xb8,0x9,0x4a,0x81,0xa1,0xbf,0xc,0x43,0xd2,0xed,0xbc,0xc0,0x66,0x3b,0x23,0x71,0xb4,0xd1,0xc7,0x69,0x3a,0x79,0xfb,0x3a,0x99,0xfc,0xf0,0x26,0xf9,0x2e,0x99,0xa4,0x1b,0xdd,0xa0,0x13,0x29,0x24,0x5e,0xfc,0x36,0xa9,0xc1,0x58,0xc,0xeb,0xe6,0x23,0x88,0xd4,0xeb,0xad,0x7d,0x37,0xf9,0xce,0xea,0x39,0xe1,0xf,0xea,0x94,0xf8,0x98,0x58,0x29,0x35,0x60,0x48,0x9e,0x63,0x4c,0x8c,0xaa,0x5a,0x7d,0xed,0x31,0xf5,0xda,0x1b,0xb7,0x17,0x63,0x8b,0xa9,0xa1,0x8f,0x7d,0x52,0xb7,0x6e,0x3b,0xf6,0xaf,0xfa,0xdd,0xbd,0xff,0xba,0xae,0xef,0x9e,0xb5,0xe8,0xb7,0xe3,0xbc,0xdf,0x80,0x1b,0x79,0x5d,0xe0,0xb9,0x13,0x27,0xf6,0x23,0x2f,0xb8,0xdd,0xba,0x12,0x82,0xc4,0x36,0x58,0x7b,0x94,0x71,0xf1,0xe0,0xe9,0x9e,0xef,0x9d,0xce,0xc4,0x7,0x86,0xd6,0x87,0x8c,0x1f,0x67,0x9b,0xc7,0x9e,0xb7,0xee,0xb6,0xfd,0x6a,0x32,0xc2,0x9d,0xdc,0xcd,0x42,0x23,0xec,0xec,0x14,0x27,0xd,0x2c,0x5b,0x5b,0x6d,0xfb,0x83,0x26,0xac,0xee,0xbe,0x1e,0xf9,0x6b,0xe0,0x22,0xbc,0xee,0x1,0x4c,0x7d,0xe3,0xef,0xac,0x79,0xec,0x80,0xb6,0x56,0x7f,0x79,0x8f,0xc9,0xc4,0x8e,0xc5,0x3f,0x7d,0x3,0x4,0x2e,0xfe,0xc,0x0,0x0 };

const uint8_t settings_html[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0x95,0x56,0xdf,0x6f,0xdb,0x36,0x10,0x7e,0x8e,0xff,0x8a,0xab,0xf6,0xa0,0xe,0xa8,0xa4,0x66,0x1,0x86,0x36,0x90,0xd,0x14,0x49,0x3b,0x14,0xdb,0xd0,0xa0,0x76,0x30,0xec,0x29,0xa0,0xc5,0xb3,0xc5,0x95,0x22,0x5,0x92,0xb2,0x6b,0x60,0x7f,0xfc,0x8e,0xa4,0x2c,0x2b,0x91,0x97,0x22,0x79,0x88,0xc9,0xe3,0x77,0xc7,0xef,0x7e,0xf0,0x4e,0xe5,0xab,0x2c,0x9b,0x1,0xc0,0x8d,0x6e,0xf,0x46,0x6c,0x6b,0x7,0xaf,0xab,0x9f,0xe1,0x97,0xb7,0x97,0xef,0x61,0xe9,0x70,0xc3,0x14,0xfc,0x6e,0xb0,0xb1,0x68,0x3c,0x68,0x55,0xb,0xb,0x56,0x6f,0xdc,0x9e,0x19,0x4,0x5a,0x4b,0x51,0xa1,0xb2,0xc8,0xa1,0x53,0x1c,0xd,0xb8,0x1a,0xe1,0xcf,0xcf,0x2b,0xf8,0x23,0x8a,0x73,0x58,0x22,0x6,0x61,0x8f,0x83,0x8d,0x90,0xf4,0x4f,0x1b,0xe0,0xe8,0x98,0x90,0x36,0xf7,0x56,0x97,0xba,0x33,0x15,0x5e,0xc3,0x56,0xb8,0xba,0x5b,0xe7,0x95,0x6e,0xa,0xdb,0xb2,0xa,0xeb,0xae,0x56,0xc5,0x5f,0xe2,0x93,0xb8,0xed,0xaa,0x6f,0xb3,0x2c,0x5b,0xcc,0xca,0x57,0xb7,0x5f,0x6e,0x56,0x7f,0xdf,0x7d,0x84,0xda,0x35,0x92,0xf6,0xf1,0x7,0xe0,0xa2,0xac,0x91,0xf1,0xc5,0xec,0xe2,0xa2,0x6c,0xc8,0x32,0x54,0x35,0x33,0x16,0xdd,0x3c,0xb9,0x5f,0x7d,0xca,0xde,0x25,0xa7,0x3,0xc5,0x1a,0x9c,0x27,0x3b,0x81,0xfb,0x56,0x1b,0x97,0x40,0xa5,0x95,0x43,0x45,0xc0,0xbd,0xe0,0xae,0x9e,0x73,0xdc,0x11,0xd3,0x2c,0x6c,0xde,0x80,0x50,0xc2,0x9,0x26,0x33,0x5b,0x31,0x89,0xf3,0xb7,0xf9,0xbb,0x37,0xd0,0x90,0xac,0x21,0x51,0x27,0x26,0x46,0xc9,0xcf,0x6,0xb3,0x4a,0x4b,0x6d,0x46,0x76,0x7f,0xba,0xfa,0xf5,0xea,0xfd,0xd5,0xc7,0x9,0x9a,0xa3,0xad,0x8c,0x68,0x9d,0xd0,0x6a,0x84,0xf6,0xde,0x82,0x77,0x77,0x82,0x67,0x9d,0xab,0x1f,0x19,0x5e,0x1e,0x43,0x4,0xd9,0x93,0x4c,0x45,0x5d,0x29,0xd4,0x37,0x30,0x28,0xe7,0x89,0x75,0x7,0x89,0xb6,0x46,0x24,0x7f,0xdd,0xa1,0xf5,0x54,0xf1,0xbb,0x2b,0x2a,0x6b,0x13,0xa8,0xd,0x6e,0x7a,0x44,0xee,0x5,0x8b,0x99,0xd7,0x8d,0xd4,0xc0,0x9a,0x8a,0xce,0xc2,0x3a,0xff,0x87,0xce,0xca,0x22,0x6e,0x16,0x13,0xc,0x3a,0x27,0xd4,0xd6,0x3e,0x41,0x51,0x6e,0x29,0x33,0x4e,0x38,0x89,0x8b,0xc1,0x33,0xf8,0x97,0xaa,0x22,0xc2,0xcb,0x22,0x9e,0x85,0x4,0x16,0x31,0x83,0x7e,0xb9,0xd6,0xfc,0x10,0xee,0x50,0x6c,0xe7,0x7f,0x2f,0xca,0x4e,0x42,0x25,0x99,0xb5,0xf3,0xa4,0x41,0xd5,0x5,0x7,0x83,0x8b,0x8b,0x92,0xf5,0x2e,0x8,0x2a,0xc0,0xef,0xb9,0xaf,0x87,0xe4,0x74,0x57,0x59,0x30,0xa2,0x43,0xb0,0x29,0x7e,0xa0,0x1c,0x55,0x4e,0x94,0xfe,0x57,0xc3,0xa1,0xa1,0xec,0x33,0xd9,0x6b,0xac,0xfa,0xed,0x33,0x1a,0x95,0x41,0x2e,0xdc,0xf1,0x8a,0xf,0x6b,0xdd,0xb9,0x47,0xe8,0xb2,0xe8,0x64,0xf0,0xb3,0xe8,0x1d,0x2d,0xb9,0xd8,0x81,0xe0,0x3e,0x21,0xcc,0x75,0x21,0x96,0x24,0x89,0xa5,0xc0,0x84,0x8a,0x4a,0x16,0x2b,0x5f,0x35,0xfd,0x7d,0xf5,0x65,0x70,0x97,0xc2,0x77,0x19,0x72,0x47,0x22,0xc7,0xd6,0x3e,0xa8,0x71,0x6d,0xe2,0x82,0x56,0x7c,0xb1,0x5c,0x7e,0xbe,0xbd,0xa6,0xa0,0xf3,0x93,0x2c,0xde,0x66,0x5,0xf7,0x77,0x8d,0xf,0x16,0xe5,0xba,0x73,0x4e,0xab,0x63,0xdc,0x5b,0x43,0x75,0x6f,0xe,0x49,0x50,0xf0,0x6e,0x3d,0x44,0x2d,0xbf,0x2c,0x8b,0x88,0x1d,0x99,0xa0,0x95,0x39,0x47,0xe1,0x8e,0x8c,0xed,0xb5,0xe1,0xe7,0x68,0xb4,0xfd,0xd9,0xcb,0xa9,0x9c,0x34,0x5f,0x48,0xe7,0xa6,0x66,0x4a,0xa1,0x3c,0xc7,0xa6,0x8a,0x47,0x2f,0x27,0x33,0x28,0xbe,0x90,0xcb,0x87,0xce,0x69,0xd3,0x29,0x58,0x86,0xd7,0x73,0x8e,0x12,0x8b,0x88,0x1f,0x51,0xa2,0xe6,0xac,0x22,0x1f,0x2e,0xac,0xaf,0x85,0x87,0x41,0xb1,0x17,0x3c,0xcf,0xaa,0xe8,0xb,0x28,0xee,0xda,0xc5,0x57,0xa4,0x72,0x34,0x2e,0x34,0xf2,0xd8,0x20,0xc1,0x69,0x60,0x6d,0x2b,0xf,0xa0,0x70,0xf,0xc3,0x53,0x2a,0x8b,0xf6,0xa8,0xf5,0x98,0x11,0x67,0x6a,0x4b,0x7d,0x29,0x70,0x32,0x48,0xf8,0xc4,0x1b,0x45,0x37,0xa8,0xe,0x84,0xe2,0xb3,0x18,0x97,0xf8,0xb4,0xde,0xef,0x5b,0xce,0x1c,0x8e,0x2b,0xbe,0xed,0x83,0xf1,0x9b,0xf6,0xcc,0x86,0xf7,0x57,0x3b,0xd7,0xda,0xeb,0xa2,0x78,0x76,0xb0,0x14,0xd4,0x23,0x91,0x59,0xa4,0x66,0x48,0x5e,0x6e,0xfd,0xd0,0x78,0x58,0x4b,0xa6,0xa8,0x5,0x1f,0xf5,0xf7,0x62,0x23,0x38,0x41,0x83,0x85,0x23,0xdc,0xbf,0xe4,0x78,0x2b,0x5d,0x59,0xd5,0x48,0x9d,0xcd,0xf,0xb6,0x2e,0x90,0xb3,0x7e,0xf4,0x49,0x22,0xe,0xc,0xf2,0xb5,0x50,0x71,0xf0,0x31,0xc5,0xa1,0x25,0xff,0x2d,0xa1,0xa4,0x66,0xdc,0x93,0xdd,0x50,0x84,0xea,0x51,0x68,0xf3,0x72,0x3d,0xe4,0x61,0x88,0x26,0x19,0x6e,0x80,0x86,0x41,0xad,0xf9,0x3c,0xbd,0xfb,0xb2,0x5c,0xa5,0xc0,0x42,0x50,0xe6,0x69,0x11,0x2f,0x4c,0x1,0x55,0x15,0x9a,0x7b,0xda,0x74,0xd2,0x89,0x96,0x12,0x56,0x78,0xb5,0x8c,0x4e,0x59,0xda,0x5b,0x14,0xaa,0xed,0x5c,0x9c,0x1,0xa9,0x67,0x94,0xc6,0xe1,0x92,0xf6,0x36,0xce,0xa0,0x6c,0xb7,0x6e,0x84,0x4b,0x1f,0x97,0xd6,0x8e,0xc9,0x8e,0xce,0xee,0x83,0x13,0x47,0xad,0x70,0xdb,0xd3,0xfc,0x41,0xff,0x47,0x1e,0x68,0xea,0x9f,0x27,0x81,0x6f,0xf3,0x2f,0x4a,0xd3,0x34,0x3b,0xf1,0xb3,0x21,0xa4,0x61,0x6c,0x95,0xc2,0x17,0x42,0x38,0x96,0x91,0x39,0x15,0x8a,0x6f,0x87,0xc6,0xfa,0x89,0xeb,0x87,0x14,0xc9,0x26,0xc8,0x1f,0x7e,0x5,0x4d,0x4c,0x3f,0x75,0x62,0x60,0x9e,0xb,0x3d,0xe5,0x3c,0x3e,0xed,0xb,0xc8,0x7,0x2e,0xc6,0x86,0x96,0x71,0xf2,0x51,0x69,0xfb,0xef,0x9a,0xff,0x0,0xf,0xe,0xd1,0x27,0x9b,0x9,0x0,0x0 };

const uint8_t settings_js[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0xcd,0x55,0x51,0x4f,0xdb,0x30,0x10,0x7e,0xcf,0xaf,0x38,0xe5,0x1,0x25,0x30,0x1a,0xda,0x22,0xc4,0xe8,0xba,0x69,0x2,0xa6,0x55,0x3,0x6d,0x6a,0x91,0x78,0x0,0x84,0xdc,0xe4,0xda,0x58,0xa4,0x76,0x64,0x3b,0x54,0xd3,0xd4,0xff,0xbe,0x4b,0x6b,0x27,0x6d,0x68,0xcb,0xdb,0xb4,0x3c,0x44,0xc9,0xe7,0xcf,0x77,0xe7,0xef,0x3b,0xdb,0xd1,0xa1,0x7,0x0,0x97,0x32,0xff,0xad,0xf8,0x34,0x35,0x10,0xc4,0x21,0x74,0x4e,0xda,0x1f,0x61,0x64,0x70,0xc2,0x4,0xfc,0x50,0x38,0xd3,0xa8,0x4a,0xd2,0x5d,0xca,0x35,0x68,0x39,0x31,0x73,0xa6,0x10,0xe8,0x3b,0xe3,0x31,0xa,0x8d,0x9,0x14,0x22,0x41,0x5,0x26,0x45,0xb8,0x1d,0xdc,0xc1,0xcd,0xa,0x6e,0xc1,0x8,0x71,0x9,0x5a,0x1e,0x4c,0x78,0x46,0x2f,0xa9,0x20,0x41,0xc3,0x78,0xa6,0x5b,0x65,0xd4,0x91,0x2c,0x54,0x8c,0x17,0x30,0xe5,0x26,0x2d,0xc6,0xad,0x58,0xce,0x22,0x9d,0xb3,0x18,0xd3,0x22,0x15,0xd1,0x3d,0xff,0xc6,0xaf,0x8a,0xf8,0xc5,0x83,0xc3,0xc8,0x8b,0x22,0xe8,0x97,0xf,0xdc,0xe3,0x78,0x24,0xe3,0x17,0x34,0xf0,0x35,0x36,0x5c,0xa,0x6d,0xf1,0x28,0xf2,0x26,0x85,0x58,0x42,0x90,0x49,0x96,0x3c,0x6b,0x34,0x86,0x8b,0xa9,0xe,0x42,0xf8,0x43,0xb9,0xe6,0x9a,0x10,0x91,0x4,0xbe,0xc3,0xfd,0xf,0xe0,0x26,0x4,0x33,0x3d,0x5d,0xb1,0x0,0x5e,0x99,0xa2,0x9a,0x5,0x52,0x5c,0x20,0xb8,0xa5,0xf3,0x8c,0x9b,0x20,0x7a,0x14,0x51,0xd8,0xf3,0x2a,0x86,0xd6,0x3c,0x21,0xc2,0x92,0xf8,0x70,0xf2,0x64,0x59,0x7e,0xdf,0xf,0x1f,0xda,0x4f,0xbd,0x8a,0x96,0x33,0xad,0xe7,0x52,0xd5,0xd4,0xf6,0x4e,0x6a,0x9c,0x32,0x21,0x30,0xab,0x98,0x9d,0x9d,0x4c,0x56,0x18,0xa9,0xa,0x51,0x31,0xbb,0x6f,0x98,0x4b,0xea,0x35,0x2d,0x95,0xaa,0xf4,0xc3,0x16,0xa7,0xc0,0xea,0xfb,0xdd,0xed,0xd,0x4d,0x29,0xa1,0x9e,0x1b,0x77,0xe5,0x35,0x38,0xe,0xae,0x78,0xb6,0xb6,0x6,0xcd,0xa2,0x15,0xcb,0xd6,0xd5,0x60,0x59,0xb4,0x64,0x2d,0x48,0xc1,0x85,0x57,0xdb,0x44,0x96,0xc4,0x92,0xa8,0xb1,0xc1,0xc4,0xba,0xd4,0x70,0x6e,0xc9,0xaf,0xbd,0x1f,0x19,0xa6,0x4c,0x91,0xd7,0x8e,0xcf,0xb9,0x48,0xe4,0xbc,0xc5,0x92,0xe4,0xfa,0x15,0x85,0xb9,0xe1,0xda,0x20,0xa5,0xe,0xfc,0x32,0xce,0xba,0xc1,0x65,0x74,0x6f,0x59,0x25,0x26,0xdc,0x3c,0x5b,0x61,0xa4,0x88,0xa9,0x3d,0x5f,0xa8,0xca,0xd,0xa2,0x13,0x5a,0xe0,0xdc,0xfa,0x9c,0x2b,0x39,0xcb,0x49,0xe0,0xd1,0x68,0x70,0x5,0x41,0xfb,0xb8,0xdb,0x29,0x57,0xaf,0x74,0x48,0x39,0xb6,0xe8,0xec,0x3a,0x85,0x4f,0x20,0xb0,0x41,0x5c,0xdc,0xd,0xb0,0x95,0xa1,0x98,0x9a,0x14,0x3e,0xf7,0xa1,0xd,0x7,0x7,0xd0,0x80,0x3f,0xf5,0xa1,0xdb,0xa9,0x27,0x6e,0xf6,0xf0,0xaa,0x5,0x1f,0x7d,0x1f,0x8e,0xaa,0x42,0x8f,0xc0,0x27,0x60,0x7b,0x5f,0xaf,0x9e,0x37,0xfa,0xba,0x81,0x45,0xf5,0xbd,0x0,0xcc,0x68,0xbf,0xd6,0xb3,0x58,0x86,0x8a,0xd6,0x7e,0x3d,0x1c,0xfe,0x1c,0x5e,0xc0,0x40,0xbc,0xb2,0x8c,0x72,0xad,0x6a,0xf4,0xeb,0x69,0x9e,0x7b,0x2f,0x7a,0xeb,0x52,0xaf,0xf5,0xd8,0xfb,0x72,0xaf,0xed,0x17,0x27,0xf9,0x2f,0x7,0x5,0xe7,0xc7,0x67,0xa7,0x1b,0xb2,0x6f,0x6b,0xdf,0x86,0xf4,0x8e,0xf2,0x46,0x7e,0x37,0xb0,0x66,0xc1,0xb9,0xb5,0xa0,0x39,0x44,0x36,0x9c,0x9d,0xee,0xb4,0xa1,0x2a,0xb9,0xb2,0xa2,0x42,0xfe,0x47,0x3b,0xea,0xad,0xfc,0xbe,0x1b,0xf5,0x91,0xe4,0xcc,0xb8,0xb4,0x8,0x6d,0x81,0xf6,0xa9,0x75,0x61,0xcb,0xe1,0xd0,0x30,0xc1,0x32,0x36,0x3d,0xc8,0xc9,0x47,0x1c,0x8,0xb3,0x41,0x70,0x1b,0x61,0xeb,0x20,0xf9,0xd0,0xee,0xee,0xf4,0xc1,0x15,0x6b,0x4d,0xb0,0xbf,0xff,0x46,0x7c,0x97,0x5b,0x14,0xb3,0x31,0xaa,0xbd,0x26,0x24,0x5c,0xb3,0x71,0x86,0xcf,0xf5,0x61,0xb9,0xc7,0x87,0x8d,0x5,0xba,0x63,0xff,0x71,0x5f,0x53,0x6d,0x5d,0xd3,0x6a,0x3d,0x55,0x9,0xa,0x89,0xb0,0x3f,0x71,0x69,0x10,0x1d,0xcd,0x13,0xae,0x66,0x81,0x3f,0xc4,0x65,0xfa,0x2c,0x3,0x17,0x18,0x8c,0xa4,0x6b,0x7c,0xc2,0x8a,0xcc,0x7c,0xf1,0xc3,0x3a,0x7b,0x55,0xef,0x2a,0xc5,0x6e,0xf1,0x77,0x48,0xef,0x84,0xaf,0x15,0xa3,0x88,0x5c,0xd0,0xd5,0x56,0xde,0x4,0x14,0x8e,0x91,0x1b,0x61,0xef,0x2f,0xb3,0x1f,0x66,0xf6,0xb7,0x8,0x0,0x0 };

const uint8_t style_css[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0xcd,0x59,0x6d,0x6f,0xe3,0xb8,0x11,0xfe,0x1c,0xff,0xa,0xd6,0xc1,0xe1,0x92,0x6d,0xe4,0x48,0xb2,0xec,0xc4,0x5e,0x2c,0x70,0xbb,0xd9,0xdd,0xbb,0xed,0xdd,0xee,0x1,0x9b,0x5,0xda,0xe2,0xd0,0x16,0x94,0x44,0x5b,0x84,0x25,0x51,0x90,0xa8,0x38,0xde,0xc3,0xf5,0xb7,0x77,0x86,0xa4,0x2c,0xea,0xc5,0x6e,0xf,0xfd,0xd0,0x26,0x88,0x25,0x73,0x86,0xc3,0xe1,0xbc,0x3e,0x64,0x6e,0x5f,0x4c,0x8,0x21,0xf,0xa2,0x38,0x94,0x7c,0x9b,0x48,0x72,0x15,0x5d,0x13,0xdf,0xf5,0x56,0xe4,0x51,0xb2,0xd,0xcd,0xc9,0x8f,0x25,0xcb,0x2a,0x56,0x22,0xd3,0x97,0x84,0x57,0xa4,0x12,0x1b,0xb9,0xa7,0x25,0x23,0xf0,0x9e,0xf2,0x88,0xe5,0x15,0x8b,0x49,0x9d,0xc7,0xac,0x24,0x32,0x61,0xe4,0xe3,0x87,0x2f,0xe4,0x27,0x3d,0x3c,0x23,0x8f,0x8c,0xa9,0x41,0xc3,0x47,0x36,0x3c,0x85,0xf,0x51,0x92,0x98,0x49,0xca,0xd3,0x6a,0x86,0x52,0x1f,0x45,0x5d,0x46,0x6c,0x4d,0xb6,0x5c,0x26,0x75,0x38,0x8b,0x44,0x76,0x5b,0x15,0x34,0x62,0x49,0x9d,0xe4,0xb7,0x7f,0xe6,0xef,0xf9,0xdb,0x3a,0xda,0x4d,0xc8,0x8b,0xdb,0xc9,0xed,0xb,0xf2,0x7d,0x2a,0x42,0x9a,0xe2,0x97,0x49,0x28,0xe2,0x3,0xf9,0x75,0x72,0x11,0xd2,0x68,0xb7,0x2d,0x5,0xa8,0xb0,0x26,0x97,0xf3,0xe5,0x7c,0x35,0x67,0x2f,0x41,0x6e,0x46,0xcb,0x2d,0xcf,0xd7,0xc4,0xc5,0x2f,0x91,0x48,0x45,0x9,0xe4,0x70,0x83,0xbf,0x2f,0x27,0x17,0x1b,0x91,0x4b,0x67,0x43,0x33,0x9e,0x1e,0xd6,0xa4,0xa2,0x79,0xe5,0xc0,0x1e,0x39,0x50,0x7e,0x9b,0x4c,0x32,0xca,0x73,0x14,0xbc,0xe7,0xb1,0x4c,0xd6,0x64,0xe9,0x3e,0xed,0x61,0x86,0x96,0xe7,0xa4,0x6c,0x23,0xd7,0x84,0xd6,0x52,0xb4,0x63,0xca,0x70,0xcd,0x20,0x8,0xa8,0x58,0x24,0xb9,0x50,0x32,0xc,0x87,0x14,0xc5,0x9a,0x2c,0xdc,0xe2,0x59,0xd1,0x37,0x42,0x48,0x30,0xd7,0xaf,0x46,0x8d,0x8a,0x7f,0x85,0xed,0xcf,0x56,0xb,0x96,0x81,0x4c,0xc9,0x9e,0xa5,0x43,0x53,0xbe,0x5,0xdd,0xc1,0x6a,0xc0,0xf8,0xb2,0x2b,0x66,0xae,0xd8,0xcc,0x48,0x28,0xa4,0x14,0x99,0x19,0x4,0xd1,0x89,0xd7,0x13,0xeb,0xcd,0x82,0xd2,0x9e,0xa0,0x44,0x78,0x7a,0xc8,0xb2,0xdc,0xe4,0xe2,0xd2,0xdf,0xcc,0xbd,0xf9,0x12,0x86,0xb,0x1a,0xc7,0x3c,0xdf,0x2,0x9b,0x52,0xf8,0x22,0x14,0x25,0x78,0xd7,0x29,0x69,0xcc,0xeb,0x6a,0x4d,0x2,0x7b,0x50,0x9b,0xa3,0x12,0x29,0x8f,0xc9,0xa5,0xef,0x46,0xbe,0xcb,0xc8,0x42,0x31,0x28,0x1d,0xf6,0x4c,0x9b,0xc6,0x73,0xc1,0xd,0x17,0x29,0x93,0xb0,0x1d,0x7,0xbd,0xab,0xe4,0x2f,0x8c,0x3d,0x12,0x7f,0xa0,0xb4,0xff,0x9f,0x28,0x4d,0xfe,0x97,0x3a,0xcf,0xfb,0x3a,0xff,0xbf,0x6b,0x9c,0xd2,0x90,0xa5,0xa8,0x74,0xca,0x73,0xe6,0x24,0x66,0x4e,0x10,0x18,0x72,0xd1,0x86,0x2b,0x4,0x23,0xc4,0x22,0x66,0xe,0x8c,0x43,0xd2,0x7d,0xa2,0x4f,0x7c,0x4b,0x55,0x48,0x87,0xb4,0xc4,0xe4,0xcb,0xe9,0x13,0xb2,0xc7,0xbc,0x2a,0x52,0xa,0x19,0x14,0xa6,0x22,0xda,0x9d,0xdc,0x6a,0x47,0xc9,0x50,0xa4,0x31,0xa,0x26,0x44,0x49,0xa1,0x28,0xc7,0xa4,0x27,0xcf,0x13,0x48,0x42,0x69,0x53,0xd7,0x29,0xad,0xa4,0x23,0x36,0x8e,0x3c,0x14,0x4c,0x59,0x3c,0x15,0x14,0xa4,0xa8,0x94,0x53,0xfa,0xcd,0x32,0x96,0xd7,0xc3,0x74,0x4d,0x39,0xcc,0xab,0xe4,0x21,0x65,0x6a,0xea,0x9a,0xe4,0x22,0x67,0x2f,0xdb,0x1d,0xba,0xb6,0xb,0x5c,0x9b,0xd0,0x24,0xf7,0x71,0x73,0x9b,0x94,0x29,0x53,0xc3,0xc3,0x89,0x79,0xa9,0x93,0x1b,0x54,0x10,0x7b,0x4b,0x81,0x94,0xdb,0xf6,0x43,0x9f,0x42,0x15,0x85,0xf,0xf5,0xa6,0x2d,0x19,0x89,0x98,0xd,0xa,0x56,0x14,0x45,0xb6,0x26,0xf3,0xb1,0x58,0xd0,0x83,0x7b,0x18,0x74,0xc2,0x92,0xd1,0xdd,0x9a,0xec,0x18,0x2b,0xa0,0x48,0xa4,0xe4,0xf,0x3c,0x2b,0x44,0x29,0x69,0xe,0xc6,0x68,0xcc,0x78,0xe9,0xea,0x38,0xb0,0xdd,0xec,0x37,0x6e,0x9e,0x41,0x6c,0x64,0x3c,0xa7,0xa9,0x56,0xf7,0xf9,0xc8,0x1,0xc1,0xf3,0x94,0x74,0x5d,0xd8,0x7a,0xf0,0x18,0x2d,0xee,0x99,0x60,0x15,0x4f,0xac,0x4,0xf7,0xec,0x1d,0x2c,0xa9,0x51,0x29,0xd2,0xb4,0x13,0xe6,0x4d,0x1c,0xce,0xf6,0x9,0x97,0x68,0x88,0x61,0x59,0x56,0x54,0x5a,0xe6,0x56,0x4c,0x5c,0x6e,0x36,0x91,0xe7,0xde,0x69,0x5a,0x4c,0xf3,0xad,0x2e,0x9c,0xd,0xf5,0xbd,0x1b,0xdc,0x5,0x86,0x5a,0xd5,0x51,0xc4,0xaa,0xca,0x26,0x7,0xf3,0x37,0x8b,0x7b,0x4f,0x93,0x8b,0x92,0x83,0x7b,0xe,0x1d,0xf2,0xea,0x2e,0xa0,0x2b,0x33,0x9b,0xa5,0xe0,0x59,0xa5,0x56,0x13,0x4a,0xab,0x7b,0xf0,0x9d,0x6d,0x61,0x20,0xb5,0x31,0xd3,0xa1,0xb4,0x12,0xa0,0x1b,0x2a,0x19,0x1d,0x2f,0xdb,0xb,0x45,0xd0,0xd,0x77,0x34,0x4c,0xb5,0x9,0x2e,0xa2,0xba,0xac,0x50,0x99,0x42,0x70,0x5d,0xec,0x15,0x8f,0xe,0x15,0x20,0x77,0x1a,0xd5,0xf4,0x1,0x7a,0x25,0x7,0xb,0x7c,0x62,0xfb,0xe9,0xd,0x31,0xdf,0x6e,0x48,0x26,0x72,0xa1,0x7a,0xa6,0x9e,0x5d,0x32,0x48,0x12,0xad,0x6,0x21,0xdd,0x84,0xc1,0x91,0x4e,0x60,0x78,0x33,0x5d,0xa5,0x90,0x30,0x50,0xa5,0x5b,0x93,0x17,0xc3,0xa,0x77,0x8c,0x2a,0xbd,0xe4,0x3a,0xc1,0x18,0x30,0xb,0xab,0x46,0x16,0xb3,0x48,0x94,0x54,0x27,0x8c,0xce,0x40,0xe0,0xbe,0xac,0x24,0x95,0xb5,0x72,0xd4,0x68,0xb7,0x53,0x83,0xb2,0x84,0xae,0xc,0x58,0x1,0x9a,0x5b,0x44,0xb,0x2e,0x81,0xe9,0x2b,0xb3,0x3,0x4a,0x17,0xc0,0x36,0x4c,0xb0,0xad,0x17,0xa2,0xe2,0x7a,0xb1,0x4a,0x82,0x95,0xf,0x28,0xc,0xf5,0xc4,0x7c,0xf8,0xea,0x70,0x40,0x29,0xcf,0xe0,0x56,0xe3,0x88,0x98,0x85,0xf5,0x76,0x6b,0xf4,0xed,0xd8,0xd9,0xb2,0xe7,0x89,0x92,0x36,0x9a,0x0,0xfd,0x92,0xde,0xeb,0xd1,0x8d,0xb1,0x2e,0x59,0xcc,0xa5,0x28,0x1d,0x13,0x90,0x4e,0x58,0x3,0x3d,0xaf,0x46,0xab,0xdb,0x29,0xde,0xa2,0x6f,0xbc,0x76,0xa,0x14,0xec,0x57,0xf8,0x43,0x1e,0x7e,0x78,0xf7,0xf0,0xe3,0x9b,0x9f,0xff,0x62,0xbe,0x6a,0x0,0xf5,0x50,0x57,0xa0,0xc,0x98,0x52,0x3,0x33,0xd5,0x13,0xae,0xf0,0x35,0x2,0x3,0x0,0xf0,0x61,0xe5,0x35,0x72,0xce,0xa2,0x84,0x45,0xbb,0x37,0xe2,0xf9,0xa1,0x19,0x1e,0xad,0xf7,0xad,0xbd,0x21,0x0,0xc0,0xcd,0x4f,0x96,0x87,0x4c,0xd7,0x9a,0x2f,0xc6,0x6c,0xe1,0xf9,0xda,0x7b,0xe7,0x22,0xce,0xd7,0x3c,0xd0,0x39,0xc2,0x1d,0x97,0x4e,0x5d,0x61,0x57,0x53,0x39,0x76,0xac,0xe6,0x4e,0x26,0xbe,0x9e,0x20,0x54,0xa3,0xe3,0x63,0x63,0x4d,0x2a,0xcc,0x7d,0xe3,0x20,0x30,0xd3,0xf,0x3c,0xd6,0x16,0xa,0xa1,0xcc,0xc3,0x9c,0x6f,0x2b,0xc0,0xac,0x1b,0x5a,0xa7,0x92,0x28,0xcb,0x84,0xe2,0xf9,0x84,0x99,0x78,0x5e,0xd4,0x58,0x46,0x2c,0xdb,0xd0,0x10,0x5a,0x77,0x2d,0x71,0x2d,0x81,0x5d,0x59,0x1e,0x74,0x44,0x8e,0xa5,0x3e,0xba,0x8,0x6a,0x3c,0x14,0x48,0xa,0xf9,0x88,0xbe,0x1a,0x59,0x10,0x8c,0xb9,0x3b,0xb9,0x84,0xa,0xf8,0x7b,0x65,0x3a,0xed,0x1,0xd7,0xda,0xa3,0xaf,0x9,0xa6,0xc0,0x99,0x6f,0x6d,0x88,0x3b,0x4d,0x3a,0xf9,0xef,0xcf,0x4,0x7a,0x47,0x4d,0x15,0x3b,0x8d,0x52,0xb7,0x90,0x62,0x3c,0xa2,0x10,0xb1,0xe4,0x2a,0xe1,0x71,0xcc,0x72,0xb2,0x4f,0xe0,0x23,0x17,0xc6,0x6e,0x2c,0xbe,0xee,0x6e,0x63,0x4d,0x37,0xb2,0x29,0xe9,0x60,0x84,0x1c,0x74,0x9c,0x4e,0x5f,0x9e,0xd8,0xda,0x31,0xfe,0x8e,0xa5,0x4,0xf4,0x78,0x4c,0xc4,0xbe,0xab,0x85,0x5e,0xd3,0xac,0x77,0xce,0x4d,0x6b,0xc3,0xf3,0xcf,0x31,0x7d,0xfa,0xc1,0xae,0xea,0xf2,0x40,0xce,0xd8,0x4c,0x6d,0x76,0x53,0x4,0x94,0x3b,0xee,0x6c,0xab,0xeb,0x62,0xd1,0xf6,0x5d,0xab,0xa3,0x36,0x20,0x4f,0xb5,0xc8,0xd6,0xfa,0x66,0xa2,0x8b,0x48,0x40,0xfd,0xb9,0x56,0x5e,0x58,0x85,0xb2,0x14,0x50,0x58,0xd9,0x55,0xb0,0x88,0xd9,0xf6,0xda,0x64,0xc1,0x19,0xf2,0x69,0x92,0xb6,0xec,0xbb,0xcf,0x9f,0x7f,0xfe,0xac,0xec,0x97,0x70,0xd,0x5d,0x86,0xe,0x98,0x55,0x68,0xfe,0x81,0xb9,0xba,0xc0,0x84,0xe6,0x50,0xbd,0xd0,0x9b,0x4e,0x4e,0x33,0xc8,0xec,0xd,0x8d,0xd9,0x87,0xbc,0x43,0x88,0xeb,0xa6,0x4d,0x78,0x95,0x12,0xfc,0xdd,0x8e,0x1d,0x36,0x25,0xb0,0x57,0x86,0x1d,0x17,0x71,0xbf,0xc1,0xcf,0x6e,0x16,0x1,0xef,0x5,0x80,0x97,0x1e,0xc5,0x53,0x14,0x4,0xea,0xe5,0xf0,0x90,0xc8,0x2,0x2f,0xb0,0x82,0x5b,0x83,0x75,0x30,0x6b,0xc,0xd5,0x89,0xc5,0xa6,0x97,0x18,0x62,0x53,0xb1,0x86,0xf8,0x11,0x84,0xdb,0xe8,0xf5,0xd2,0xa5,0x34,0xa,0x7c,0x85,0x12,0x4e,0xf7,0x3e,0x7a,0xec,0x91,0x83,0x79,0xc3,0x59,0xea,0x58,0x8d,0xed,0xda,0x68,0xd6,0x38,0xe6,0x23,0xc3,0x48,0x43,0xc7,0x64,0xf8,0xf6,0x8f,0x76,0x77,0x83,0xbd,0x6,0x7e,0xb0,0xc,0xde,0xb6,0xc1,0x87,0x96,0xea,0x81,0xc9,0x1c,0x22,0x80,0x22,0x56,0x3,0x5c,0xe8,0xb4,0x6c,0x4d,0x6b,0xd7,0x4b,0x40,0x98,0xb4,0x2b,0xf4,0x9a,0x6e,0xd3,0xf6,0x2,0x13,0x99,0xa0,0xe1,0x1f,0x9,0x6c,0x98,0x88,0x8d,0x4e,0x4c,0x64,0xaf,0x8,0xb4,0x1a,0xb1,0x7,0x1f,0x5d,0xa9,0x35,0xc8,0x9e,0x3,0x7e,0xd,0x19,0xa9,0x98,0x24,0xe1,0x41,0x31,0xfe,0xe9,0x51,0x55,0x87,0x76,0xd5,0x6d,0xc9,0x58,0x3e,0xdc,0x93,0x85,0xea,0x34,0x1f,0x58,0xc,0x90,0xe1,0x8,0xf0,0x7a,0xff,0xfa,0xf5,0xd2,0x7b,0x6d,0xb3,0x96,0xa3,0x0,0xcd,0xc6,0x91,0x9a,0xef,0x89,0xa6,0xb5,0x91,0xd8,0x6d,0x68,0xf7,0x6d,0x9,0xfc,0x82,0x30,0xae,0x42,0x95,0xa5,0x1,0x74,0x3d,0x33,0x5b,0x16,0x6d,0xa0,0x73,0xaf,0x11,0xfa,0xfa,0x88,0xa8,0x63,0xd,0xc,0x95,0xd2,0xa2,0x82,0xc,0x69,0xde,0xd4,0x4a,0x60,0x2c,0xd,0x4b,0x2d,0xa7,0xa9,0x87,0x83,0x23,0x86,0xe5,0x86,0x48,0xe5,0x9b,0xe,0x8,0x21,0x4b,0x5d,0x83,0x2c,0xa0,0x80,0x9b,0x18,0x46,0x37,0x46,0xbf,0x39,0x5f,0x2e,0x62,0xfc,0xd5,0xe8,0x23,0xae,0x1,0x44,0x39,0x9b,0x3a,0x57,0x67,0x1e,0x28,0x26,0x6a,0x9b,0xd2,0x58,0xd0,0x8e,0x97,0xfb,0x26,0x5e,0xbe,0xcb,0x0,0xb2,0x50,0x70,0x7f,0x7a,0xc0,0x53,0x0,0xfa,0x8f,0x42,0xd4,0x5c,0xe1,0x59,0xc3,0x30,0xdf,0x2d,0xc1,0x86,0xd7,0x37,0x30,0x6,0x2,0x62,0xf6,0xc4,0x23,0xd6,0x25,0xb5,0x33,0xba,0x54,0xcf,0xc5,0x73,0xcc,0x35,0xac,0x3e,0xb9,0x38,0x9e,0xfb,0x8e,0x68,0x5d,0x1f,0xfc,0xb0,0x1c,0x34,0x37,0x38,0x36,0xa9,0x5b,0x91,0x90,0xb,0x1c,0xf8,0x5e,0x94,0x11,0xec,0x47,0xef,0x4a,0xa8,0x36,0x15,0xe2,0x75,0xd5,0xce,0xc,0x56,0xa0,0xc9,0x21,0x13,0x25,0x43,0x1f,0x5f,0x9c,0x32,0x7,0x7e,0xde,0x90,0x53,0xd4,0x84,0xd1,0xf8,0x34,0x15,0x6f,0xb1,0xce,0xcc,0x3d,0x4d,0x3a,0x23,0x53,0x55,0x97,0x21,0x58,0x33,0x7b,0xd6,0xd0,0x46,0x71,0xa2,0x6a,0xc,0x32,0xf3,0xa,0x60,0xa5,0xda,0x7c,0xb7,0xbe,0xdf,0xa8,0xbb,0x3a,0xaa,0x4e,0x55,0x3c,0xe4,0x29,0x14,0xd6,0xeb,0xb3,0x86,0x40,0x79,0xcd,0xf2,0xa3,0xd,0x5c,0x77,0x43,0x67,0x5,0x3f,0x2a,0x30,0x4d,0xab,0x6c,0x7,0x50,0xc7,0xf3,0xdb,0x6a,0x1a,0xa5,0xa9,0xc7,0x67,0x27,0xac,0x73,0x99,0x38,0x51,0xc2,0xd3,0xf8,0x4a,0xc4,0xf1,0xb5,0x9e,0x3f,0x8a,0xe7,0xc7,0x1,0xfd,0x39,0xe1,0x2a,0xd9,0xd0,0x9e,0x6f,0x58,0x42,0x9f,0x18,0xd1,0x51,0x43,0xc9,0x14,0x0,0xe3,0x54,0x59,0xa9,0xaf,0x6a,0x3f,0xe7,0xfc,0x63,0xce,0xa9,0x46,0x5c,0xd0,0x92,0xa9,0xd8,0x1c,0x47,0xd5,0xbd,0x2a,0xe4,0xf9,0xae,0xb1,0x60,0xf7,0x34,0x77,0xaf,0xf,0x69,0x67,0x35,0x5f,0x87,0x6c,0x83,0x31,0x6d,0x36,0xf0,0x9,0x1a,0xb8,0x51,0xde,0xe,0xb,0xbd,0x87,0x71,0x37,0x62,0xed,0x13,0xc5,0x2d,0xaa,0x42,0x54,0xa1,0xac,0x48,0xc6,0x33,0x1e,0x11,0xa3,0xa4,0x9e,0xab,0x9c,0xbd,0xb4,0x1d,0x6d,0xbe,0x34,0xe9,0xdc,0xec,0xa1,0xd9,0x5a,0xd9,0x81,0x44,0x17,0xa,0x5,0xa9,0x8b,0x2c,0x75,0x7f,0xb3,0x2f,0x69,0x71,0xc,0x63,0x20,0xff,0xa4,0xe,0x2f,0xd8,0x37,0x62,0x2a,0x29,0xc,0x9c,0xb,0xcd,0x58,0xc5,0x82,0xb9,0x48,0xba,0xf2,0xae,0x6d,0x1b,0xb4,0xc8,0xf3,0x41,0x64,0x19,0xd4,0x9e,0xe9,0xbf,0xb5,0xa0,0x2d,0xcc,0x3f,0x21,0xec,0xdd,0x33,0xcd,0x8a,0x94,0xfd,0x3e,0x61,0xf3,0x13,0xc2,0xde,0x32,0x28,0xa6,0xbc,0xc0,0x99,0xd3,0x6,0xda,0x80,0x17,0x3e,0x20,0x8c,0xad,0x54,0xbd,0x6c,0x8e,0x86,0xd8,0x8d,0xa0,0xde,0x43,0x34,0x75,0xd0,0xc9,0xf1,0xea,0xbb,0x64,0xfa,0x78,0x5,0x28,0x4,0xce,0xc8,0xaa,0xf1,0x77,0x9b,0x56,0xff,0xb2,0xa7,0x77,0x85,0xd3,0xf,0xeb,0xf1,0x8b,0xcb,0xd3,0x17,0x81,0xbf,0xe3,0x32,0x3,0x64,0x3f,0xe3,0x61,0x50,0xad,0x7e,0xcc,0x9e,0xe7,0xe6,0xe0,0x77,0x9a,0x6a,0xa0,0xf1,0x29,0x6,0xb0,0x9d,0xc2,0xff,0xbf,0xa0,0xc9,0x5f,0x4d,0xf1,0xdf,0x12,0xd3,0xbf,0x75,0x9a,0xe7,0x9d,0xb9,0xbf,0x1b,0xf0,0xa2,0x69,0x35,0xef,0xc0,0xb0,0xfd,0x6b,0xb,0x63,0x9f,0xa3,0x71,0xcd,0x15,0xfd,0x50,0x9a,0x5,0x9,0xcd,0x89,0x10,0xc7,0x5b,0xe6,0x1b,0xe3,0xdb,0x61,0x7b,0xf7,0xdd,0xff,0xd2,0x23,0xfd,0xcb,0x62,0x73,0x1b,0x34,0xd8,0x4b,0x5d,0x14,0xac,0x8c,0x68,0x65,0x43,0x60,0xff,0x78,0xb3,0xa9,0xf,0x53,0x6a,0x17,0x8d,0xae,0xed,0x9e,0xfa,0x70,0x34,0x8,0xe8,0x89,0xb3,0xef,0xc,0xa0,0xa0,0xc4,0xea,0xd1,0xc5,0x51,0xdd,0xce,0x6d,0xe1,0x8,0xff,0x3e,0xe8,0x5d,0xd0,0xe9,0xa4,0xf8,0xfe,0xf3,0x87,0xb7,0xe4,0xf1,0xaf,0x8f,0x5f,0xde,0x7d,0x54,0x20,0xb9,0xd4,0x27,0x94,0xd1,0xb2,0xda,0xc3,0x6b,0xf6,0xed,0xfd,0x11,0x1,0xe3,0xfc,0x5f,0xa2,0x94,0x56,0xd5,0xdf,0x5f,0x4d,0xc1,0xed,0xda,0xff,0xe6,0xae,0x46,0xe3,0x29,0x7d,0x69,0x97,0x3a,0xde,0x8d,0x7e,0xfa,0xe6,0x39,0x37,0xcf,0xc0,0x3c,0x17,0xe6,0xb9,0x34,0xcf,0x3b,0xf3,0xbc,0x37,0xcf,0x95,0x79,0x7a,0x6e,0xf3,0xd2,0x48,0xf4,0x7c,0x5,0xba,0x1a,0x44,0xb3,0xfc,0xe6,0xa8,0xdb,0xfa,0x78,0xf2,0x24,0xa4,0x73,0x88,0x26,0x6d,0x3f,0x57,0xb5,0x46,0xfd,0x27,0x2c,0x65,0xb4,0xc4,0x6c,0x90,0x89,0x16,0xa0,0x8f,0xe9,0x4e,0x95,0xa9,0xf9,0xc3,0x3,0xde,0x49,0x3c,0xd7,0x82,0x3f,0x3f,0x60,0xd9,0xb5,0x9a,0xae,0x35,0x35,0x17,0x80,0xd,0xf0,0x9d,0xcd,0xe7,0xdf,0xe0,0xd2,0x20,0xcc,0x70,0xf8,0x5d,0xe,0xcf,0x9f,0x2d,0x97,0x3d,0x96,0x79,0x97,0xc5,0xf7,0x7a,0xf4,0xa0,0x47,0x5f,0xd,0x57,0x59,0x74,0x59,0xe6,0x77,0xc3,0x55,0x96,0x3d,0x55,0xfb,0xf4,0xbb,0x2e,0x7d,0x31,0xb2,0x97,0xfb,0x2e,0xcb,0x72,0x64,0x2f,0xab,0x2e,0xcb,0x5d,0x7f,0x2f,0x9e,0xdb,0x63,0x18,0xd9,0x8c,0xd7,0xb3,0xea,0xfd,0xc8,0x6e,0xbc,0x9e,0x5d,0x57,0x36,0x43,0xd7,0xcf,0x96,0xa7,0xd,0x3c,0x44,0xbe,0xdf,0x26,0xff,0x2,0xe5,0x8e,0x5b,0x45,0xe,0x1e,0x0,0x0 };

const uint8_t terminal_html[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0x85,0x54,0x6d,0x6b,0xdb,0x30,0x10,0xfe,0x9c,0xfc,0x8a,0xab,0xf7,0x65,0x83,0x3a,0xee,0x5a,0x18,0x6d,0x71,0xc,0xa3,0x2f,0x30,0xb6,0xb1,0x41,0x32,0xc6,0x3e,0xd,0x45,0xbe,0x44,0x5a,0x65,0xc9,0x48,0x72,0xd2,0xc0,0x7e,0xfc,0x4e,0x96,0xed,0xa4,0xc9,0xda,0x42,0x62,0x49,0xa7,0xe7,0x39,0xdd,0x7b,0x7e,0x92,0xa6,0xe3,0xd1,0x8d,0xa9,0xb7,0x56,0xae,0x84,0x87,0xb7,0xfc,0x1d,0x9c,0x9f,0xbd,0xbf,0x82,0x99,0xc7,0x25,0xd3,0xf0,0xd9,0x62,0xe5,0xd0,0x8e,0x47,0x73,0x21,0x1d,0x38,0xb3,0xf4,0x1b,0x66,0x11,0x68,0xaf,0x24,0x47,0xed,0xb0,0x84,0x46,0x97,0x68,0xc1,0xb,0x84,0xaf,0x9f,0xe6,0xf0,0x25,0x8a,0x27,0x30,0x43,0x6c,0x85,0x1d,0xe,0x96,0x52,0xd1,0xc7,0x58,0x28,0xd1,0x33,0xa9,0xdc,0x64,0x3c,0x9a,0x99,0xc6,0x72,0xbc,0x86,0x95,0xf4,0xa2,0x59,0x4c,0xb8,0xa9,0x32,0x57,0x33,0x8e,0xa2,0x11,0x3a,0xfb,0x29,0xef,0xe5,0x6d,0xc3,0x1f,0xc6,0x69,0x5a,0x8c,0xf3,0x93,0xdb,0x6f,0x37,0xf3,0x5f,0xdf,0xef,0x40,0xf8,0x4a,0xd1,0x39,0x2e,0x0,0xa3,0x5c,0x20,0x2b,0x8b,0xf1,0x68,0x94,0x57,0xa4,0x17,0xb8,0x60,0xd6,0xa1,0x9f,0x26,0x3f,0xe6,0xf7,0xe9,0x65,0xb2,0xbb,0xd0,0xac,0xc2,0x69,0xb2,0x96,0xb8,0xa9,0x8d,0xf5,0x9,0x70,0xa3,0x3d,0x6a,0x2,0x6e,0x64,0xe9,0xc5,0xb4,0xc4,0x35,0xd9,0x99,0xb6,0x87,0x53,0x90,0x5a,0x7a,0xc9,0x54,0xea,0x38,0x53,0x38,0x3d,0x9b,0x5c,0x9e,0x42,0x45,0xb2,0x8a,0x44,0x8d,0x3c,0x52,0x4a,0x5e,0x56,0x98,0x72,0xa3,0x8c,0xdd,0xd3,0xfb,0xe6,0xe2,0xc3,0xc5,0xd5,0xc5,0xdd,0x11,0xba,0x44,0xc7,0xad,0xac,0xbd,0x34,0x7a,0xf,0x1d,0xbc,0x85,0xe0,0xee,0x11,0x9e,0x35,0x5e,0x3c,0x51,0x3c,0xeb,0x43,0x4,0xe9,0x41,0x96,0x22,0x57,0x49,0xfd,0x0,0x16,0xd5,0x34,0x71,0x7e,0xab,0xd0,0x9,0x44,0xf2,0xd7,0x6f,0xeb,0x60,0x2a,0x3e,0xfa,0x8c,0x3b,0x97,0x80,0xb0,0xb8,0xec,0x10,0x93,0x20,0x28,0xc6,0x81,0x1b,0x4d,0x3,0x67,0x39,0xdd,0xb5,0xfb,0xc9,0x1f,0xba,0xcb,0xb3,0x78,0x28,0xe,0x31,0x1e,0x2d,0x5,0x86,0xa9,0x3,0x14,0x40,0xc8,0x8c,0x97,0x5e,0x61,0x31,0x78,0x6,0x7f,0x61,0xde,0xc1,0xf3,0x2c,0xde,0xb5,0x9,0xcc,0x62,0x6,0xc3,0x76,0x61,0xca,0x6d,0xfb,0x86,0x66,0xeb,0xb0,0x8e,0xf2,0x46,0x1,0x57,0xcc,0xb9,0x69,0x52,0xa1,0x6e,0x5a,0x7,0x5b,0x17,0x8b,0x9c,0x75,0x2e,0x48,0x2a,0xbf,0xc7,0x49,0xa8,0x87,0x64,0xf7,0x56,0x9e,0x31,0x32,0x87,0x60,0xc7,0x78,0xaa,0xe,0x2f,0xf5,0xca,0x75,0x94,0x59,0x77,0x7c,0x81,0x31,0x38,0x19,0x19,0x3b,0x27,0x9e,0x65,0x70,0x8b,0xa5,0xf4,0xfd,0x13,0x1f,0x17,0xa6,0xf1,0x4f,0xd0,0x79,0xd6,0xa8,0xd6,0xcf,0xac,0x73,0x34,0x2f,0xe5,0x1a,0x64,0x19,0x12,0xc2,0x7c,0xd3,0xc6,0x92,0x24,0xb1,0x14,0x98,0xd4,0x91,0xe4,0x90,0x87,0xaa,0xe9,0xde,0x13,0xe7,0x7b,0x96,0xd0,0x21,0x4a,0x83,0x9e,0x2e,0x60,0xd6,0x6c,0xba,0x78,0x8d,0x72,0xa9,0xeb,0xc6,0xef,0xd5,0x40,0xd2,0x83,0x5c,0x65,0x8c,0x17,0x49,0xfb,0x76,0xb,0x4a,0x60,0xcd,0x54,0x43,0x30,0x81,0xaa,0x1e,0xf8,0x8b,0xc6,0x7b,0xa3,0x7b,0x52,0x6d,0xa9,0x15,0xec,0x36,0xb2,0x1c,0xea,0x32,0x29,0xc2,0x37,0xcf,0x22,0xec,0xff,0x24,0x9a,0x1b,0x3a,0x32,0xb8,0x42,0x46,0xb5,0xda,0x2e,0xaf,0x70,0x84,0xf4,0x18,0x49,0x16,0xa9,0x1,0x34,0x45,0x20,0x29,0x86,0xed,0x53,0xf2,0x10,0xb2,0xe7,0xc3,0xd0,0x47,0x99,0xf2,0xd1,0xba,0xda,0x41,0xfa,0x4,0xef,0x85,0x7d,0x5f,0x1d,0xd5,0xf5,0x2e,0xf2,0x79,0xd6,0x27,0x24,0x5f,0x52,0xe8,0xd0,0x46,0x48,0x9f,0x79,0xe1,0x7d,0xed,0xae,0xb3,0xec,0xc5,0x91,0x46,0xdd,0xc8,0xec,0x2a,0x4c,0xa9,0xdf,0xb,0xc5,0x34,0xf5,0x7c,0x9c,0x84,0xa1,0x46,0x5a,0x6d,0xb,0x5b,0x84,0x7f,0xcc,0x7a,0x4d,0xd,0x1e,0x8c,0x5e,0xa3,0x75,0x61,0x68,0x84,0x3e,0x23,0xd9,0x80,0x78,0x75,0x78,0xf,0xaa,0xe,0x8d,0x1c,0x2c,0x9b,0x48,0x73,0x6c,0xd3,0xfe,0x6d,0x67,0x59,0x9e,0xf5,0x3e,0xb7,0x8d,0x1b,0xdb,0x95,0xaa,0xaf,0x1b,0xc6,0xf4,0xfb,0x7,0x98,0xd,0xcc,0xa8,0x50,0x6,0x0,0x0 };

const uint8_t terminal_js[] PROGMEM = { 0x1f,0x8b,0x8,0x0,0x61,0xa3,0x8c,0x5e,0x2,0xff,0x7d,0x52,0x5f,0x6b,0xdb,0x30,0x1c,0x7c,0xf7,0xa7,0x38,0xb4,0x17,0xa7,0x29,0xd6,0xba,0xb7,0x35,0xcd,0x60,0x6c,0x1d,0x2d,0x4d,0x9f,0x1c,0xe8,0x4b,0xa1,0x28,0xd2,0x2f,0xb6,0x88,0x22,0x19,0xfd,0x49,0x28,0x23,0xdf,0x7d,0xb2,0xe3,0x92,0xb5,0xb4,0xf5,0x83,0x90,0x4e,0x77,0xc7,0xdd,0x4f,0xe6,0x67,0x5,0x80,0x5f,0xae,0x7b,0xf6,0xba,0x69,0x23,0x4a,0x39,0xc1,0xb7,0xaf,0x17,0xdf,0x51,0x47,0x5a,0xb,0x8b,0x3b,0x4f,0xdb,0x40,0xbe,0x27,0x2d,0x5b,0x1d,0x10,0xdc,0x3a,0xee,0x85,0x27,0xe4,0xbd,0xd1,0x92,0x6c,0x20,0x85,0x64,0x15,0x79,0xc4,0x96,0x70,0x7f,0xbb,0xc4,0xe2,0x8,0x57,0xa8,0x89,0x6,0x70,0xe4,0x61,0xad,0x4d,0x5e,0x9c,0x87,0xa2,0x28,0xb4,0x9,0x55,0xef,0x5a,0xbb,0xe4,0x25,0x5d,0xa2,0xd1,0xb1,0x4d,0xab,0x4a,0xba,0x2d,0xf,0x9d,0x90,0xd4,0xa6,0xd6,0xf2,0x7,0xfd,0x47,0xff,0x4e,0x72,0x53,0xe0,0x8c,0x17,0x9c,0x63,0xde,0x7f,0x78,0xa0,0x55,0xed,0xe4,0x86,0x22,0x7e,0xca,0xa8,0x9d,0xd,0x23,0xce,0x79,0xb1,0x4e,0x76,0x80,0xb0,0xf,0x4f,0xd2,0x59,0x4b,0x32,0x92,0x2a,0x27,0xf8,0x7b,0x28,0x4e,0xfa,0x3a,0xa,0x1f,0x53,0x77,0x52,0xed,0xb5,0x55,0x6e,0x5f,0x9,0xa5,0xae,0x77,0x64,0xe3,0x42,0x87,0x48,0x96,0x7c,0xc9,0x8c,0x13,0x8a,0x9d,0xe3,0xc5,0xb5,0x37,0xca,0x99,0xaf,0x4b,0x16,0xc8,0x2a,0x36,0xa9,0x9c,0x95,0xb9,0xdc,0x6,0xf3,0xb7,0x14,0x60,0x27,0x3c,0xb4,0xed,0x52,0xcc,0x97,0x59,0x30,0x6c,0xb3,0x62,0x27,0x4c,0xa2,0x59,0x31,0x50,0x32,0xec,0x52,0x3c,0xe2,0x3a,0x67,0xf5,0x37,0xcb,0xfb,0x5,0xa6,0x73,0xb0,0x2f,0x60,0x98,0x8e,0xf2,0x29,0xd8,0xd5,0xca,0xff,0x60,0x27,0x91,0xa7,0xb1,0xda,0xab,0x4,0xb9,0xb1,0xb6,0x3a,0x8e,0xb4,0x7c,0xea,0x33,0x96,0x83,0xc7,0x7f,0xd,0xb6,0xa1,0x79,0x49,0x8,0x18,0xd7,0xc,0xc0,0x6c,0x3c,0x7f,0x18,0x28,0x93,0x2a,0x4f,0x9d,0xc9,0xef,0x52,0xf2,0x47,0xcb,0x9b,0xf3,0x31,0xd4,0xbb,0xd2,0x20,0xbd,0x33,0x66,0xe9,0xba,0x63,0xf5,0x37,0xf8,0xd,0xf5,0x3f,0xda,0x51,0x77,0x18,0xf4,0x87,0x21,0x73,0x66,0x4a,0x43,0xc2,0x7f,0x3e,0xd6,0xf7,0x23,0xe6,0x91,0xb1,0x93,0xd3,0x38,0x89,0x32,0x9b,0x1f,0x72,0x75,0x61,0x2,0x4d,0x66,0xff,0x0,0x45,0x81,0x5c,0xa2,0xe9,0x2,0x0,0x0 };

