#ifndef RADIANCE_CONFIG_H
#define RADIANCE_CONFIG_H

#include <string>
#include <stdint.h>
#include <time.h>
#include <iosfwd>
#include <map>

class confval {
	private:
		bool bool_val;
		uint32_t uint_val;
		std::string str_val;
		enum {
			CONF_NONEXISTENT,
			CONF_BOOL,
			CONF_UINT,
			CONF_STR,
		} val_type;
	public:
		confval();
		confval(bool value);
		confval(uint32_t value);
		confval(const char * value);
		const uint32_t get_uint();
		const bool get_bool();
		const std::string get_str();
		const time_t get_time();
		void set(const std::string &val);
};

class config {
	protected:
		template <typename T> void add(const std::string &setting_name, T value);
		confval * get(const std::string &setting_name);
		std::map<std::string, confval> settings;
		confval * dummy_setting;
	public:
		std::map<std::string, confval> get_settings() {return settings;};
		bool get_bool(const std::string &setting_name);
		uint32_t get_uint(const std::string &setting_name);
		std::string get_str(const std::string &setting_name);
		time_t get_time(const std::string &setting_name);
		void set(const std::string &section_name, const std::string &setting_name, const std::string &value);
};

class settings : public config {
	private:
	    void init();
	public:
		settings();
		~settings();
		void load(std::istream &conf_file);
		void load(const std::string &conf_file_path, std::istream &conf_file);
		void reload();
};

class options : public config{
	private:
	    void init();
	public:
		options();
		~options();
};

template <typename T> void config::add(const std::string &setting_name, T value) {
	confval setting(value);
	settings[setting_name] = setting;
}
#endif
