// Copyright (c) 2020 Can Boluk and contributors of the VTIL Project   
// All rights reserved.   
//    
// Redistribution and use in source and binary forms, with or without   
// modification, are permitted provided that the following conditions are met: 
//    
// 1. Redistributions of source code must retain the above copyright notice,   
//    this list of conditions and the following disclaimer.   
// 2. Redistributions in binary form must reproduce the above copyright   
//    notice, this list of conditions and the following disclaimer in the   
//    documentation and/or other materials provided with the distribution.   
// 3. Neither the name of VTIL Project nor the names of its contributors
//    may be used to endorse or promote products derived from this software 
//    without specific prior written permission.   
//    
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE   
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE  
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE   
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR   
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF   
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS   
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN   
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)   
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE  
// POSSIBILITY OF SUCH DAMAGE.        
//
#include "boolean_directives.hpp"

namespace vtil::symbolic::directive
{
    std::vector<std::pair<instance, instance>> boolean_simplifiers
    {
        // Manually added:
        //
        { __uless( A + B, B ),                                             __uless( ~A, B ) },
        { __uless_eq( A + B, B ),                                          __uless_eq( -A, B ) },
        { __ugreat( A + B, B ),                                            __ugreat( -A, B ) },
        { __ugreat_eq( A + B, B ),                                         __ugreat_eq( ~A, B ) },
        { __uless( A + B, B ),                                             __ugreat( A, ~B ) },
        { __uless_eq( A - B, ~B ),                                         __ugreat_eq( A, B ) },
        { __ugreat( A - B, ~B ),                                           __uless( A, B ) },
        { __ugreat_eq( A + B, B ),                                         __uless_eq( A, ~B ) },
        { A<=A,                                                            1 },
        { A<A,                                                             0 },
        { A==A,                                                            1 },
        { A!=A,                                                            0 },
        { A>A,                                                             0 },
        { A>=A,                                                            1 },
        { __uless( A, A ),                                                 0 },
        { __uless_eq( A, A ),                                              1 },
        { __ugreat( A, A ),                                                0 },
        { __ugreat_eq( A, A ),                                             1 },
        { A==~A,                                                           0 },
        { A!=~A,                                                           1 },
        { A==-A,                                                           0 },
        { A!=-A,                                                           1 },
    };
    
    const std::vector<std::pair<instance, instance>>& build_boolean_simplifiers()
    {
        if ( !boolean_simplifiers.empty() )
            return boolean_simplifiers;
#ifndef __INTELLISENSE__
#define ADD_DIRECTIVE( ... ) ([ ] () { boolean_simplifiers.emplace_back( __VA_ARGS__ ); })()
        // Boolean Simplifiers
        //
        ADD_DIRECTIVE( ((A>B)&(A>C)),                                                   __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>C)),                                                   __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>C)),                                                   __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>C)),                                                   __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>C)),                                                   __iff((B<=C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>C)),                                                   __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>=C)),                                                  __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>=C)),                                                  __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>=C)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>=C)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>B)|(A>=C)),                                                  __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A==C)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A==C)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A==C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(A==C)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>B)|(A==C)),                                                  __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A!=C)),                                                  __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A!=C)),                                                  __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A!=C)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A!=C)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A>B)|(A!=C)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(A<=C)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A<=C)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A<=C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(A<=C)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(A<=C)),                                                  __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(A<=C)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(A<C)),                                                   __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A<C)),                                                   __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A<C)),                                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(A<C)),                                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A>B)|(A<C)),                                                   __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(A>C)),                                                  __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A>C)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A>=C)),                                                 __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A>=C)),                                                 __iff((B>=C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A>=C)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>=C)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>=C)),                                                 __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>=C)),                                                 __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A==C)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(A==C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A>=B)|(A==C)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A==C)),                                                 __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A==C)),                                                 __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A!=C)),                                                 __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A!=C)),                                                 __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)|(A!=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A!=C)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A!=C)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(A<=C)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(A<=C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(A<C)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(A<C)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(A<C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)|(A<C)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<C)),                                                  __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<C)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(A>C)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B>=C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(A>=C)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff((B!=C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(A==C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff((B!=C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(A!=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B<=C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(A<=C)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(A<C)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(A, C)),                                         __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(A, C)),                                         __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(A, C)),                                         __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(A, C)),                                         __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|__ugreat(A, C)),                                         __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(A, C)),                                      __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(A, C)),                                      __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(A, C)),                                      __iff(__ugreat_eq(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(A, C)),                                      __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|__ugreat_eq(A, C)),                                      __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(A, C)),                                       __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(A, C)),                                       __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(A, C)),                                       __iff(__uless_eq(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(A, C)),                                       __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|__uless_eq(A, C)),                                       __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( ((A==B)&__uless(A, C)),                                          __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__uless(A, C)),                                          __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__uless(A, C)),                                          __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__uless(A, C)),                                          __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|__uless(A, C)),                                          __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( ((A!=B)&(A>C)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B<=C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&(A>=C)),                                                 __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&(A==C)),                                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff((B!=C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&(A!=C)),                                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff((B!=C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(A<=C)),                                                 __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(A<C)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B>=C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&__ugreat(A, C)),                                         __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(A, C)),                                         __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(A, C)),                                         __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(A, C)),                                         __iff(__uless_eq(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(A, C)),                                         __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&__ugreat_eq(A, C)),                                      __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(A, C)),                                      __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(A, C)),                                      __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(A, C)),                                      __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(A, C)),                                      __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&__uless_eq(A, C)),                                       __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(A, C)),                                       __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(A, C)),                                       __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(A, C)),                                       __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(A, C)),                                       __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&__uless(A, C)),                                          __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless(A, C)),                                          __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless(A, C)),                                          __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless(A, C)),                                          __iff(__ugreat_eq(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless(A, C)),                                          __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A>C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(A>C)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(A>C)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(A>C)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A>C)),                                                  __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A>C)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A>=C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A<=B)&(A>=C)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(A>=C)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A>=C)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A>=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A==C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A<=B)&(A==C)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(A==C)),                                                 __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A==C)),                                                 __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A==C)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A!=C)),                                                 __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<=B)&(A!=C)),                                                 __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A!=C)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A!=C)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A!=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A<=C)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<=C)),                                                 __iff((B<=C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<=C)),                                                 __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<=C)),                                                 __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<=C)),                                                 __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<=C)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<C)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<C)),                                                  __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<C)),                                                  __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<C)),                                                  __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<C)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(A>C)),                                                   __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(A>C)),                                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A<B)&(A>=C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>=C)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>=C)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(A>=C)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(A>=C)),                                                  __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(A>=C)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(A==C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A==C)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A==C)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(A==C)),                                                  __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A==C)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<B)&(A!=C)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A!=C)),                                                  __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A!=C)),                                                  __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A!=C)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(A!=C)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<=C)),                                                  __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<=C)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<B)&(A<C)),                                                   __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<C)),                                                   __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<C)),                                                   __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<C)),                                                   __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<C)),                                                   __iff((B>=C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<C)),                                                   __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(A==C)),                                         __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(A==C)),                                         __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(A==C)),                                         __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)|(A==C)),                                         __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|(A==C)),                                         __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(A!=C)),                                         __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(A!=C)),                                         __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(A!=C)),                                         __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|(A!=C)),                                         __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|(A!=C)),                                         __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(A, C)),                                 __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(A, C)),                                 __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(A, C)),                                 __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat(A, C)),                                 __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat(A, C)),                                 __iff(__uless_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat(A, C)),                                 __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(A, C)),                              __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(A, C)),                              __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(A, C)),                              __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat_eq(A, C)),                              __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat_eq(A, C)),                              __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(A, C)),                               __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(A, C)),                               __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(A, C)),                               __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless_eq(A, C)),                               __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless_eq(A, C)),                               __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless_eq(A, C)),                               __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(A, C)),                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(A, C)),                                  __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(A, C)),                                  __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless(A, C)),                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless(A, C)),                                  __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&(A==C)),                                      __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&(A==C)),                                      __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(A==C)),                                      __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(A==C)),                                      __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(A==C)),                                      __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&(A!=C)),                                      __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&(A!=C)),                                      __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(A!=C)),                                      __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(A!=C)),                                      __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(A!=C)),                                      __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat(A, C)),                              __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat(A, C)),                              __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(A, C)),                              __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(A, C)),                              __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(A, C)),                              __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat_eq(A, C)),                           __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat_eq(A, C)),                           __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat_eq(A, C)),                           __iff(__ugreat_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(A, C)),                           __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(A, C)),                           __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(A, C)),                           __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless_eq(A, C)),                            __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless_eq(A, C)),                            __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(A, C)),                            __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(A, C)),                            __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(A, C)),                            __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless(A, C)),                               __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless(A, C)),                               __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless(A, C)),                               __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(A, C)),                               __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(A, C)),                               __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(A, C)),                               __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&(A==C)),                                       __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&(A==C)),                                       __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(A==C)),                                       __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(A==C)),                                       __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(A==C)),                                       __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&(A!=C)),                                       __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&(A!=C)),                                       __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(A!=C)),                                       __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(A!=C)),                                       __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(A!=C)),                                       __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat(A, C)),                               __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat(A, C)),                               __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat(A, C)),                               __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(A, C)),                               __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(A, C)),                               __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(A, C)),                               __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat_eq(A, C)),                            __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat_eq(A, C)),                            __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(A, C)),                            __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(A, C)),                            __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(A, C)),                            __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless_eq(A, C)),                             __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless_eq(A, C)),                             __iff(__uless_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless_eq(A, C)),                             __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(A, C)),                             __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(A, C)),                             __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(A, C)),                             __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless(A, C)),                                __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless(A, C)),                                __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(A, C)),                                __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(A, C)),                                __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(A, C)),                                __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&(A==C)),                                          __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&(A==C)),                                          __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&(A==C)),                                          __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)|(A==C)),                                          __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|(A==C)),                                          __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&(A!=C)),                                          __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&(A!=C)),                                          __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&(A!=C)),                                          __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|(A!=C)),                                          __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__uless(A, B)|(A!=C)),                                          __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(A, C)),                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(A, C)),                                  __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(A, C)),                                  __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat(A, C)),                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat(A, C)),                                  __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(A, C)),                               __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(A, C)),                               __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(A, C)),                               __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat_eq(A, C)),                               __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat_eq(A, C)),                               __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat_eq(A, C)),                               __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(A, C)),                                __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(A, C)),                                __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(A, C)),                                __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless_eq(A, C)),                                __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless_eq(A, C)),                                __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(A, C)),                                   __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(A, C)),                                   __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(A, C)),                                   __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless(A, C)),                                   __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless(A, C)),                                   __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless(A, C)),                                   __iff(__ugreat_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( ((A>B)&(C>A)),                                                   __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C>A)),                                                   __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C>A)),                                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(C>A)),                                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A>B)|(C>A)),                                                   __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(C>=A)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C>=A)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C>=A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(C>=A)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(C>=A)),                                                  __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(C>=A)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(C==A)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C==A)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C==A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(C==A)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>B)|(C==A)),                                                  __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C!=A)),                                                  __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C!=A)),                                                  __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C!=A)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C!=A)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A>B)|(C!=A)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(C<=A)),                                                  __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<=A)),                                                  __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<=A)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<=A)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>B)|(C<=A)),                                                  __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<A)),                                                   __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<A)),                                                   __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<A)),                                                   __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<A)),                                                   __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<A)),                                                   __iff((B<=C), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<A)),                                                   __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)&(C>A)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(C>A)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(C>A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)|(C>A)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>A)),                                                  __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>A)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(C>=A)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(C>=A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(C==A)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(C==A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A>=B)|(C==A)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C==A)),                                                 __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C==A)),                                                 __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C!=A)),                                                 __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C!=A)),                                                 __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)|(C!=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C!=A)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C!=A)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(C<=A)),                                                 __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C<=A)),                                                 __iff((B>=C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C<=A)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<=A)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<=A)),                                                 __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<=A)),                                                 __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C<A)),                                                  __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C<A)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(C>A)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B<=C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(C>=A)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff((B!=C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(C==A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff((B!=C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(C!=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B>=C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(C<=A)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(C<A)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(C, A)),                                         __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(C, A)),                                         __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(C, A)),                                         __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(C, A)),                                         __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|__ugreat(C, A)),                                         __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(C, A)),                                      __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(C, A)),                                      __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(C, A)),                                      __iff(__uless_eq(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(C, A)),                                      __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|__ugreat_eq(C, A)),                                      __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(C, A)),                                       __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(C, A)),                                       __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(C, A)),                                       __iff(__ugreat_eq(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(C, A)),                                       __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|__uless_eq(C, A)),                                       __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( ((A==B)&__uless(C, A)),                                          __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__uless(C, A)),                                          __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__uless(C, A)),                                          __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__uless(C, A)),                                          __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((A==B)|__uless(C, A)),                                          __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( ((A!=B)&(C>A)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B>=C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(C>=A)),                                                 __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(C==A)),                                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff((B!=C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&(C!=A)),                                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff((B!=C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(C<=A)),                                                 __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&(C<A)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B<=C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&__ugreat(C, A)),                                         __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(C, A)),                                         __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(C, A)),                                         __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(C, A)),                                         __iff(__ugreat_eq(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(C, A)),                                         __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&__ugreat_eq(C, A)),                                      __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(C, A)),                                      __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(C, A)),                                      __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(C, A)),                                      __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(C, A)),                                      __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&__uless_eq(C, A)),                                       __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(C, A)),                                       __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(C, A)),                                       __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(C, A)),                                       __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(C, A)),                                       __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&__uless(C, A)),                                          __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless(C, A)),                                          __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless(C, A)),                                          __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__uless(C, A)),                                          __iff(__uless_eq(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless(C, A)),                                          __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>A)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>A)),                                                  __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>A)),                                                  __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>A)),                                                  __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>A)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>=A)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>=A)),                                                 __iff((B<=C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>=A)),                                                 __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>=A)),                                                 __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>=A)),                                                 __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>=A)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C==A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A<=B)&(C==A)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(C==A)),                                                 __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C==A)),                                                 __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C==A)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C!=A)),                                                 __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<=B)&(C!=A)),                                                 __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C!=A)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C!=A)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C!=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(C<=A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((A<=B)&(C<=A)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(C<=A)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C<=A)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C<=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(C<A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(C<A)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(C<A)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(C<A)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C<A)),                                                  __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C<A)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(C>A)),                                                   __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>A)),                                                   __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>A)),                                                   __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>A)),                                                   __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>A)),                                                   __iff((B>=C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>A)),                                                   __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>=A)),                                                  __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>=A)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<B)&(C==A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C==A)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C==A)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(C==A)),                                                  __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C==A)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((A<B)&(C!=A)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C!=A)),                                                  __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C!=A)),                                                  __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C!=A)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(C!=A)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((A<B)&(C<=A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<=A)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<=A)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(C<=A)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(C<=A)),                                                  __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(C<=A)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(C<A)),                                                   __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(C<A)),                                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(C==A)),                                         __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(C==A)),                                         __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(C==A)),                                         __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)|(C==A)),                                         __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|(C==A)),                                         __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(C!=A)),                                         __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(C!=A)),                                         __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(C!=A)),                                         __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|(C!=A)),                                         __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|(C!=A)),                                         __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(C, A)),                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(C, A)),                                 __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(C, A)),                                 __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat(C, A)),                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat(C, A)),                                 __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(C, A)),                              __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(C, A)),                              __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(C, A)),                              __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat_eq(C, A)),                              __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat_eq(C, A)),                              __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat_eq(C, A)),                              __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(C, A)),                               __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(C, A)),                               __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(C, A)),                               __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless_eq(C, A)),                               __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless_eq(C, A)),                               __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(C, A)),                                  __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(C, A)),                                  __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(C, A)),                                  __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless(C, A)),                                  __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless(C, A)),                                  __iff(__uless_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless(C, A)),                                  __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&(C==A)),                                      __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&(C==A)),                                      __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(C==A)),                                      __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(C==A)),                                      __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(C==A)),                                      __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&(C!=A)),                                      __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&(C!=A)),                                      __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(C!=A)),                                      __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(C!=A)),                                      __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(C!=A)),                                      __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat(C, A)),                              __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat(C, A)),                              __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat(C, A)),                              __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(C, A)),                              __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(C, A)),                              __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(C, A)),                              __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat_eq(C, A)),                           __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat_eq(C, A)),                           __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(C, A)),                           __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(C, A)),                           __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(C, A)),                           __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless_eq(C, A)),                            __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless_eq(C, A)),                            __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless_eq(C, A)),                            __iff(__ugreat_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(C, A)),                            __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(C, A)),                            __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(C, A)),                            __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless(C, A)),                               __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless(C, A)),                               __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(C, A)),                               __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(C, A)),                               __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(C, A)),                               __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&(C==A)),                                       __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&(C==A)),                                       __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(C==A)),                                       __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(C==A)),                                       __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(C==A)),                                       __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&(C!=A)),                                       __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&(C!=A)),                                       __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(C!=A)),                                       __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(C!=A)),                                       __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(C!=A)),                                       __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat(C, A)),                               __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat(C, A)),                               __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(C, A)),                               __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(C, A)),                               __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(C, A)),                               __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat_eq(C, A)),                            __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat_eq(C, A)),                            __iff(__uless_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat_eq(C, A)),                            __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(C, A)),                            __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(C, A)),                            __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(C, A)),                            __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless_eq(C, A)),                             __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless_eq(C, A)),                             __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(C, A)),                             __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(C, A)),                             __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(C, A)),                             __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless(C, A)),                                __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless(C, A)),                                __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless(C, A)),                                __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(C, A)),                                __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(C, A)),                                __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(C, A)),                                __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)&(C==A)),                                          __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&(C==A)),                                          __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&(C==A)),                                          __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)|(C==A)),                                          __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|(C==A)),                                          __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&(C!=A)),                                          __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&(C!=A)),                                          __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&(C!=A)),                                          __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|(C!=A)),                                          __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__uless(A, B)|(C!=A)),                                          __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(C, A)),                                  __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(C, A)),                                  __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(C, A)),                                  __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat(C, A)),                                  __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat(C, A)),                                  __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat(C, A)),                                  __iff(__ugreat_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(C, A)),                               __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(C, A)),                               __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(C, A)),                               __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat_eq(C, A)),                               __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat_eq(C, A)),                               __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(C, A)),                                __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(C, A)),                                __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(C, A)),                                __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless_eq(C, A)),                                __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless_eq(C, A)),                                __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless_eq(C, A)),                                __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(C, A)),                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(C, A)),                                   __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(C, A)),                                   __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless(C, A)),                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless(C, A)),                                   __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(A>C)),                                                   __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(A>C)),                                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B>A)&(A>=C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>=C)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>=C)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(A>=C)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(A>=C)),                                                  __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(A>=C)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(A==C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A==C)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A==C)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(A==C)),                                                  __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A==C)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>A)&(A!=C)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A!=C)),                                                  __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A!=C)),                                                  __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A!=C)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(A!=C)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<=C)),                                                  __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<=C)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>A)&(A<C)),                                                   __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<C)),                                                   __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<C)),                                                   __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<C)),                                                   __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<C)),                                                   __iff((B>=C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<C)),                                                   __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>=A)&(A>C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(A>C)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(A>C)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(A>C)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A>C)),                                                  __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A>C)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(A>=C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B>=A)&(A>=C)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(A>=C)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A>=C)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A>=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(A==C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B>=A)&(A==C)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(A==C)),                                                 __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A==C)),                                                 __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A==C)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A!=C)),                                                 __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>=A)&(A!=C)),                                                 __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A!=C)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A!=C)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A!=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(A<=C)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<=C)),                                                 __iff((B<=C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<=C)),                                                 __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<=C)),                                                 __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<=C)),                                                 __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<=C)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<C)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<C)),                                                  __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<C)),                                                  __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<C)),                                                  __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<C)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(A>C)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B>=C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(A>=C)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff((B!=C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(A==C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff((B!=C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(A!=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B<=C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(A<=C)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(A<C)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(A, C)),                                         __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(A, C)),                                         __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(A, C)),                                         __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(A, C)),                                         __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|__ugreat(A, C)),                                         __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(A, C)),                                      __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(A, C)),                                      __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(A, C)),                                      __iff(__ugreat_eq(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(A, C)),                                      __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|__ugreat_eq(A, C)),                                      __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(A, C)),                                       __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(A, C)),                                       __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(A, C)),                                       __iff(__uless_eq(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(A, C)),                                       __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|__uless_eq(A, C)),                                       __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( ((B==A)&__uless(A, C)),                                          __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__uless(A, C)),                                          __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__uless(A, C)),                                          __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__uless(A, C)),                                          __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|__uless(A, C)),                                          __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( ((B!=A)&(A>C)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B<=C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&(A>=C)),                                                 __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&(A==C)),                                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff((B!=C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&(A!=C)),                                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff((B!=C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(A<=C)),                                                 __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(A<C)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B>=C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&__ugreat(A, C)),                                         __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(A, C)),                                         __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(A, C)),                                         __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(A, C)),                                         __iff(__uless_eq(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(A, C)),                                         __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&__ugreat_eq(A, C)),                                      __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(A, C)),                                      __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(A, C)),                                      __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(A, C)),                                      __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(A, C)),                                      __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&__uless_eq(A, C)),                                       __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(A, C)),                                       __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(A, C)),                                       __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(A, C)),                                       __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(A, C)),                                       __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&__uless(A, C)),                                          __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless(A, C)),                                          __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless(A, C)),                                          __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless(A, C)),                                          __iff(__ugreat_eq(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless(A, C)),                                          __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(A>C)),                                                  __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A>C)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A>=C)),                                                 __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A>=C)),                                                 __iff((B>=C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A>=C)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>=C)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>=C)),                                                 __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>=C)),                                                 __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A==C)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(A==C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B<=A)|(A==C)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A==C)),                                                 __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A==C)),                                                 __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A!=C)),                                                 __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A!=C)),                                                 __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<=A)|(A!=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A!=C)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A!=C)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(A<=C)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(A<=C)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(A<C)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(A<C)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(A<C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)|(A<C)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<C)),                                                  __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<C)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(A>C)),                                                   __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>C)),                                                   __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>C)),                                                   __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>C)),                                                   __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>C)),                                                   __iff((B<=C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>C)),                                                   __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>=C)),                                                  __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>=C)),                                                  __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>=C)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>=C)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)|(A>=C)),                                                  __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A==C)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A==C)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A==C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(A==C)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)|(A==C)),                                                  __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A!=C)),                                                  __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A!=C)),                                                  __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A!=C)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A!=C)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B<A)|(A!=C)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(A<=C)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A<=C)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A<=C)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(A<=C)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(A<=C)),                                                  __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(A<=C)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(A<C)),                                                   __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A<C)),                                                   __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A<C)),                                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(A<C)),                                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B<A)|(A<C)),                                                   __iff((B<C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(A==C)),                                         __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(A==C)),                                         __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(A==C)),                                         __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)|(A==C)),                                         __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|(A==C)),                                         __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(A!=C)),                                         __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(A!=C)),                                         __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(A!=C)),                                         __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|(A!=C)),                                         __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|(A!=C)),                                         __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(A, C)),                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(A, C)),                                 __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(A, C)),                                 __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat(A, C)),                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat(A, C)),                                 __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(A, C)),                              __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(A, C)),                              __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(A, C)),                              __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat_eq(A, C)),                              __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat_eq(A, C)),                              __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat_eq(A, C)),                              __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(A, C)),                               __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(A, C)),                               __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(A, C)),                               __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless_eq(A, C)),                               __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless_eq(A, C)),                               __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(A, C)),                                  __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(A, C)),                                  __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(A, C)),                                  __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless(A, C)),                                  __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless(A, C)),                                  __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless(A, C)),                                  __iff(__ugreat_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&(A==C)),                                      __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&(A==C)),                                      __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(A==C)),                                      __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(A==C)),                                      __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(A==C)),                                      __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&(A!=C)),                                      __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&(A!=C)),                                      __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(A!=C)),                                      __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(A!=C)),                                      __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(A!=C)),                                      __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat(A, C)),                              __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat(A, C)),                              __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat(A, C)),                              __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(A, C)),                              __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(A, C)),                              __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(A, C)),                              __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat_eq(A, C)),                           __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat_eq(A, C)),                           __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(A, C)),                           __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(A, C)),                           __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(A, C)),                           __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless_eq(A, C)),                            __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless_eq(A, C)),                            __iff(__uless_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless_eq(A, C)),                            __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(A, C)),                            __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(A, C)),                            __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(A, C)),                            __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless(A, C)),                               __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless(A, C)),                               __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(A, C)),                               __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(A, C)),                               __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(A, C)),                               __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&(A==C)),                                       __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&(A==C)),                                       __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(A==C)),                                       __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(A==C)),                                       __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(A==C)),                                       __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&(A!=C)),                                       __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&(A!=C)),                                       __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(A!=C)),                                       __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(A!=C)),                                       __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(A!=C)),                                       __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat(A, C)),                               __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat(A, C)),                               __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(A, C)),                               __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(A, C)),                               __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(A, C)),                               __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat_eq(A, C)),                            __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat_eq(A, C)),                            __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat_eq(A, C)),                            __iff(__ugreat_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(A, C)),                            __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(A, C)),                            __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(A, C)),                            __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless_eq(A, C)),                             __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless_eq(A, C)),                             __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(A, C)),                             __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(A, C)),                             __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(A, C)),                             __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless(A, C)),                                __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless(A, C)),                                __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless(A, C)),                                __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(A, C)),                                __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(A, C)),                                __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(A, C)),                                __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)&(A==C)),                                          __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&(A==C)),                                          __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&(A==C)),                                          __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)|(A==C)),                                          __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|(A==C)),                                          __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&(A!=C)),                                          __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&(A!=C)),                                          __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&(A!=C)),                                          __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|(A!=C)),                                          __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__uless(B, A)|(A!=C)),                                          __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(A, C)),                                  __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(A, C)),                                  __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(A, C)),                                  __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat(A, C)),                                  __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat(A, C)),                                  __iff(__uless_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat(A, C)),                                  __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(A, C)),                               __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(A, C)),                               __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(A, C)),                               __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat_eq(A, C)),                               __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat_eq(A, C)),                               __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(A, C)),                                __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(A, C)),                                __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(A, C)),                                __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless_eq(A, C)),                                __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless_eq(A, C)),                                __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless_eq(A, C)),                                __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(A, C)),                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(A, C)),                                   __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(A, C)),                                   __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless(A, C)),                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless(A, C)),                                   __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(C>A)),                                                   __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>A)),                                                   __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>A)),                                                   __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>A)),                                                   __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>A)),                                                   __iff((B>=C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>A)),                                                   __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>=A)),                                                  __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>=A)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>A)&(C==A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C==A)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C==A)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(C==A)),                                                  __iff((B>C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C==A)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>A)&(C!=A)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C!=A)),                                                  __iff((B<=C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C!=A)),                                                  __iff((B<C), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C!=A)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(C!=A)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B>A)&(C<=A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<=A)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<=A)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(C<=A)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(C<=A)),                                                  __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(C<=A)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(C<A)),                                                   __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(C<A)),                                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>A)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>A)),                                                  __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>A)),                                                  __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>A)),                                                  __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>A)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>=A)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>=A)),                                                 __iff((B<=C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>=A)),                                                 __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>=A)),                                                 __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>=A)),                                                 __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>=A)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C==A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B>=A)&(C==A)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(C==A)),                                                 __iff((B>C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C==A)),                                                 __iff((B>=C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C==A)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C!=A)),                                                 __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B>=A)&(C!=A)),                                                 __iff((B<C), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C!=A)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C!=A)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C!=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(C<=A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B>=A)&(C<=A)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(C<=A)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C<=A)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C<=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(C<A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C<A)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C<A)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(C<A)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C<A)),                                                  __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C<A)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(C>A)),                                                  __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B<=C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(C>=A)),                                                 __iff((B==C), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff((B!=C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(C==A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff((B!=C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff((B<C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(C!=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B>=C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(C<=A)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B>C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B<=C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B<C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(C<A)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(C, A)),                                         __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(C, A)),                                         __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(C, A)),                                         __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(C, A)),                                         __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|__ugreat(C, A)),                                         __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(C, A)),                                      __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(C, A)),                                      __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(C, A)),                                      __iff(__uless_eq(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(C, A)),                                      __iff(__uless(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|__ugreat_eq(C, A)),                                      __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(C, A)),                                       __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(C, A)),                                       __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(C, A)),                                       __iff(__ugreat_eq(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(C, A)),                                       __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|__uless_eq(C, A)),                                       __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( ((B==A)&__uless(C, A)),                                          __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__uless(C, A)),                                          __iff(__ugreat(B, C), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__uless(C, A)),                                          __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__uless(C, A)),                                          __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( ((B==A)|__uless(C, A)),                                          __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( ((B!=A)&(C>A)),                                                  __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B>=C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(C>=A)),                                                 __iff((B==C), (A<B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(C==A)),                                                 __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff((B>C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff((B!=C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&(C!=A)),                                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff((B!=C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(C<=A)),                                                 __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B>=C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&(C<A)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B>C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B<=C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B<C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&__ugreat(C, A)),                                         __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(C, A)),                                         __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(C, A)),                                         __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(C, A)),                                         __iff(__ugreat_eq(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(C, A)),                                         __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&__ugreat_eq(C, A)),                                      __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(C, A)),                                      __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(C, A)),                                      __iff(__ugreat(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(C, A)),                                      __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(C, A)),                                      __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&__uless_eq(C, A)),                                       __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(C, A)),                                       __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(C, A)),                                       __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(C, A)),                                       __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(C, A)),                                       __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&__uless(C, A)),                                          __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless(C, A)),                                          __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless(C, A)),                                          __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__uless(C, A)),                                          __iff(__uless_eq(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless(C, A)),                                          __iff(__uless(B, C), (A!=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C>A)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(C>A)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(C>A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)|(C>A)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>A)),                                                  __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>A)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(C>=A)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(C>=A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(C==A)),                                                 __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(C==A)),                                                 __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( ((B<=A)|(C==A)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C==A)),                                                 __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C==A)),                                                 __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C!=A)),                                                 __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C!=A)),                                                 __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<=A)|(C!=A)),                                                 __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C!=A)),                                                 __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C!=A)),                                                 __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(C<=A)),                                                 __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C<=A)),                                                 __iff((B>=C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C<=A)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<=A)),                                                 __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<=A)),                                                 __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<=A)),                                                 __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C<A)),                                                  __iff((B>C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C<A)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B<=C), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B<C), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)&(C>A)),                                                   __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C>A)),                                                   __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C>A)),                                                   __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(C>A)),                                                   __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B<A)|(C>A)),                                                   __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(C>=A)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C>=A)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C>=A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(C>=A)),                                                  __iff((B==C), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(C>=A)),                                                  __iff((B<=C), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(C>=A)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(C==A)),                                                  __iff((B>C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C==A)),                                                  __iff((B>=C), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C==A)),                                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(C==A)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)|(C==A)),                                                  __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C!=A)),                                                  __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C!=A)),                                                  __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C!=A)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C!=A)),                                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( ((B<A)|(C!=A)),                                                  __iff((B<C), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(C<=A)),                                                  __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<=A)),                                                  __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<=A)),                                                  __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<=A)),                                                  __iff((B==C), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)|(C<=A)),                                                  __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<A)),                                                   __iff((B>C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<A)),                                                   __iff((B>=C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<A)),                                                   __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<A)),                                                   __iff((B==C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<A)),                                                   __iff((B<=C), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<A)),                                                   __iff((B<C), (A>B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(C==A)),                                         __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(C==A)),                                         __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(C==A)),                                         __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)|(C==A)),                                         __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|(C==A)),                                         __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(C!=A)),                                         __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(C!=A)),                                         __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(C!=A)),                                         __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|(C!=A)),                                         __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|(C!=A)),                                         __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(C, A)),                                 __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(C, A)),                                 __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(C, A)),                                 __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat(C, A)),                                 __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat(C, A)),                                 __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat(C, A)),                                 __iff(__ugreat_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(C, A)),                              __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(C, A)),                              __iff(__uless_eq(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(C, A)),                              __iff(__uless(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat_eq(C, A)),                              __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat_eq(C, A)),                              __iff(__ugreat(B, C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(C, A)),                               __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(C, A)),                               __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(C, A)),                               __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless_eq(C, A)),                               __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless_eq(C, A)),                               __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless_eq(C, A)),                               __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(C, A)),                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(C, A)),                                  __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(C, A)),                                  __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless(C, A)),                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless(C, A)),                                  __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&(C==A)),                                      __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&(C==A)),                                      __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(C==A)),                                      __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(C==A)),                                      __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(C==A)),                                      __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&(C!=A)),                                      __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&(C!=A)),                                      __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(C!=A)),                                      __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(C!=A)),                                      __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(C!=A)),                                      __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat(C, A)),                              __iff((B==C), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat(C, A)),                              __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(C, A)),                              __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(C, A)),                              __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(C, A)),                              __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat_eq(C, A)),                           __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat_eq(C, A)),                           __iff(__uless_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat_eq(C, A)),                           __iff(__uless(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(C, A)),                           __iff((B==C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(C, A)),                           __iff(__ugreat(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(C, A)),                           __iff(__ugreat_eq(B, C), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless_eq(C, A)),                            __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless_eq(C, A)),                            __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(C, A)),                            __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(C, A)),                            __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(C, A)),                            __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless(C, A)),                               __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless(C, A)),                               __iff(__uless_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless(C, A)),                               __iff(__uless(B, C), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(C, A)),                               __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(C, A)),                               __iff(__ugreat(B, C), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(C, A)),                               __iff(__ugreat_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&(C==A)),                                       __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&(C==A)),                                       __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(C==A)),                                       __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(C==A)),                                       __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(C==A)),                                       __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&(C!=A)),                                       __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&(C!=A)),                                       __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(C!=A)),                                       __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(C!=A)),                                       __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(C!=A)),                                       __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat(C, A)),                               __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat(C, A)),                               __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat(C, A)),                               __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(C, A)),                               __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(C, A)),                               __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(C, A)),                               __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat_eq(C, A)),                            __iff((B==C), (A==B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat_eq(C, A)),                            __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(C, A)),                            __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(C, A)),                            __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(C, A)),                            __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless_eq(C, A)),                             __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless_eq(C, A)),                             __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless_eq(C, A)),                             __iff(__ugreat_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(C, A)),                             __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(C, A)),                             __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(C, A)),                             __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless(C, A)),                                __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless(C, A)),                                __iff(__ugreat(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(C, A)),                                __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(C, A)),                                __iff(__uless_eq(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(C, A)),                                __iff(__uless(B, C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&(C==A)),                                          __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&(C==A)),                                          __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&(C==A)),                                          __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)|(C==A)),                                          __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|(C==A)),                                          __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&(C!=A)),                                          __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&(C!=A)),                                          __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&(C!=A)),                                          __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|(C!=A)),                                          __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__uless(B, A)|(C!=A)),                                          __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(C, A)),                                  __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(C, A)),                                  __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(C, A)),                                  __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat(C, A)),                                  __iff((B==C), (A!=B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat(C, A)),                                  __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(C, A)),                               __iff((B==C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(C, A)),                               __iff(__ugreat(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(C, A)),                               __iff(__ugreat_eq(B, C), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat_eq(C, A)),                               __iff((B==C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat_eq(C, A)),                               __iff(__uless_eq(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat_eq(C, A)),                               __iff(__uless(B, C), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(C, A)),                                __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(C, A)),                                __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(C, A)),                                __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless_eq(C, A)),                                __iff((B==C), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless_eq(C, A)),                                __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(C, A)),                                   __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(C, A)),                                   __iff(__ugreat(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(C, A)),                                   __iff(__ugreat_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless(C, A)),                                   __iff((B==C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless(C, A)),                                   __iff(__uless_eq(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless(C, A)),                                   __iff(__uless(B, C), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((A>B)&(A>C)),                                                   __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>C)),                                                   __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>B)|(A>C)),                                                   __iff((B<(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>=C)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A==C)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A!=C)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A<=C)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(A<=C)),                                                  __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A>B)|(A<=C)),                                                  __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(A<C)),                                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(A>C)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B<=(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A>=C)),                                                 __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>=C)),                                                 __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A==C)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)|(A==C)),                                                 __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A!=C)),                                                 __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A!=C)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(A<=C)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B<=(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(A<C)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)|(A<C)),                                                  __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(A>C)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B<(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(A<=C)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(A, C)),                                         __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(A, C)),                                       __iff(__uless(B, (C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A!=B)&(A>C)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B<(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(A<=C)),                                                 __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(A, C)),                                         __iff(__uless(B, (C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(A, C)),                                       __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A>C)),                                                  __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A<=B)&(A>C)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(A>C)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A>=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A==C)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A!=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A<=C)),                                                 __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<=C)),                                                 __iff((B<(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<=C)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<C)),                                                  __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B<=(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(A>C)),                                                   __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(A>=C)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(A>=C)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(A==C)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(A==C)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A!=C)),                                                  __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A!=C)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B<=(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<=C)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<C)),                                                   __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<C)),                                                   __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat(A, C)),                                 __iff(__uless(B, (C+0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless_eq(A, C)),                               __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(A==C)),                                      __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(A!=C)),                                      __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(A, C)),                              __iff((B==(C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(A, C)),                              __iff(__uless_eq(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(A, C)),                              __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(A, C)),                           __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(A, C)),                            __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(A, C)),                            __iff(__uless_eq(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(A, C)),                            __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(A, C)),                               __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat(A, C)),                               __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless_eq(A, C)),                             __iff(__uless(B, (C+0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&(A==C)),                                          __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&(A!=C)),                                          __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(A, C)),                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(A, C)),                                  __iff(__uless_eq(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(A, C)),                                  __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(A, C)),                               __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(A, C)),                                __iff((B==(C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(A, C)),                                __iff(__uless_eq(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(A, C)),                                __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(A, C)),                                   __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( ((A>B)&(C>A)),                                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C>=A)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(C>=A)),                                                  __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A>B)|(C>=A)),                                                  __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(C==A)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C!=A)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<=A)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<A)),                                                   __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<A)),                                                   __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>B)|(C<A)),                                                   __iff((B<(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)&(C>A)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)|(C>A)),                                                  __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(C>=A)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B<=(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(C==A)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)|(C==A)),                                                 __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C!=A)),                                                 __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C!=A)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(C<=A)),                                                 __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<=A)),                                                 __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C<A)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B<=(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B<(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(C>=A)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(C<A)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(C, A)),                                      __iff(__uless(B, (C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__uless(C, A)),                                          __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&(C>=A)),                                                 __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(C<A)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B<(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(C, A)),                                      __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__uless(C, A)),                                          __iff(__uless(B, (C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>A)),                                                  __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>=A)),                                                 __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>=A)),                                                 __iff((B<(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>=A)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C==A)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C!=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C<=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(C<A)),                                                  __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A<=B)&(C<A)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(C<A)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(C>A)),                                                   __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>A)),                                                   __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B<=(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>=A)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C==A)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(C==A)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C!=A)),                                                  __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C!=A)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(C<=A)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(C<=A)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B<=(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(C<A)),                                                   __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__ugreat_eq(C, A)),                              __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat(A, B)|__uless(C, A)),                                  __iff(__uless(B, (C+0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(C==A)),                                      __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|(C!=A)),                                      __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat(C, A)),                              __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(C, A)),                           __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(C, A)),                           __iff(__uless_eq(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__ugreat_eq(C, A)),                           __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless_eq(C, A)),                            __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(C, A)),                               __iff((B==(C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(C, A)),                               __iff(__uless_eq(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)|__uless(C, A)),                               __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__ugreat_eq(C, A)),                            __iff(__uless(B, (C+0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)&__uless(C, A)),                                __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&(C==A)),                                          __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&(C!=A)),                                          __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat(C, A)),                                  __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(C, A)),                               __iff((B==(C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(C, A)),                               __iff(__uless_eq(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__ugreat_eq(C, A)),                               __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless_eq(C, A)),                                __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(C, A)),                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(C, A)),                                   __iff(__uless_eq(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(A, B)&__uless(C, A)),                                   __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B<=(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(A>C)),                                                   __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(A>=C)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(A>=C)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(A==C)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(A==C)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A!=C)),                                                  __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A!=C)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B<=(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<=C)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<C)),                                                   __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<C)),                                                   __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>=A)&(A>C)),                                                  __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B>=A)&(A>C)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(A>C)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A>=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A==C)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A!=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(A<=C)),                                                 __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<=C)),                                                 __iff((B<(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<=C)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<C)),                                                  __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(A>C)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B<(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(A<=C)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(A, C)),                                         __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(A, C)),                                       __iff(__uless(B, (C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B!=A)&(A>C)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B<(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(A<=C)),                                                 __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(A, C)),                                         __iff(__uless(B, (C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(A, C)),                                       __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(A>C)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B<=(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A>=C)),                                                 __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>=C)),                                                 __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A==C)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<=A)|(A==C)),                                                 __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A!=C)),                                                 __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A!=C)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(A<=C)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B<=(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(A<C)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<=A)|(A<C)),                                                  __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(A>C)),                                                   __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>C)),                                                   __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)|(A>C)),                                                   __iff((B<(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>=C)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A==C)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A!=C)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A<=C)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(A<=C)),                                                  __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B<A)|(A<=C)),                                                  __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(A<C)),                                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(A==C)),                                         __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(A!=C)),                                         __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(A, C)),                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(A, C)),                                 __iff(__uless_eq(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(A, C)),                                 __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(A, C)),                              __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(A, C)),                               __iff((B==(C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(A, C)),                               __iff(__uless_eq(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(A, C)),                               __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(A, C)),                                  __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat(A, C)),                              __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless_eq(A, C)),                            __iff(__uless(B, (C+0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(A==C)),                                       __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(A!=C)),                                       __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(A, C)),                               __iff((B==(C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(A, C)),                               __iff(__uless_eq(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(A, C)),                               __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(A, C)),                            __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(A, C)),                             __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(A, C)),                             __iff(__uless_eq(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(A, C)),                             __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(A, C)),                                __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat(A, C)),                                  __iff(__uless(B, (C+0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless_eq(A, C)),                                __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(C>A)),                                                   __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>A)),                                                   __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B<=(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>=A)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C==A)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(C==A)),                                                  __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C!=A)),                                                  __iff((B<(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C!=A)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(C<=A)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(C<=A)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B<=(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(C<A)),                                                   __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C>A)),                                                  __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>=A)),                                                 __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>=A)),                                                 __iff((B<(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>=A)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C==A)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C!=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C<=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(C<A)),                                                  __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B>=A)&(C<A)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(C<A)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B<(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(C>=A)),                                                 __iff((B==(C+0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B==(C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B<(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(C<A)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(C, A)),                                      __iff(__uless(B, (C+0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__uless(C, A)),                                          __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&(C>=A)),                                                 __iff((B==(C+0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(C<A)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B<(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(C, A)),                                      __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__uless(C, A)),                                          __iff(__uless(B, (C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C>A)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<=A)|(C>A)),                                                  __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(C>=A)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B<=(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(C==A)),                                                 __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<=A)|(C==A)),                                                 __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C!=A)),                                                 __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C!=A)),                                                 __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(C<=A)),                                                 __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<=A)),                                                 __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C<A)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B<=(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B<(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)&(C>A)),                                                   __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C>=A)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(C>=A)),                                                  __iff((B==(C+0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B<A)|(C>=A)),                                                  __iff((B<(C+0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(C==A)),                                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C!=A)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<=A)),                                                  __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<A)),                                                   __iff((B==(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<A)),                                                   __iff((B==(C+0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)|(C<A)),                                                   __iff((B<(C+0x1)), (A>B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(C==A)),                                         __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&(C!=A)),                                         __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat(C, A)),                                 __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(C, A)),                              __iff((B==(C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(C, A)),                              __iff(__uless_eq(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__ugreat_eq(C, A)),                              __iff(__uless(B, (C+0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless_eq(C, A)),                               __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(C, A)),                                  __iff((B==(C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(C, A)),                                  __iff(__uless_eq(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(B, A)&__uless(C, A)),                                  __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__ugreat_eq(C, A)),                           __iff(__uless(B, (C+0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)&__uless(C, A)),                               __iff(__uless(B, (C+0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(C==A)),                                       __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|(C!=A)),                                       __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat(C, A)),                               __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(C, A)),                            __iff((B==(C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(C, A)),                            __iff(__uless_eq(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__ugreat_eq(C, A)),                            __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless_eq(C, A)),                             __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(C, A)),                                __iff((B==(C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(C, A)),                                __iff(__uless_eq(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)|__uless(C, A)),                                __iff(__uless(B, (C+0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)|__ugreat_eq(C, A)),                               __iff(__uless(B, (C+0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless(B, A)|__uless(C, A)),                                   __iff(__uless(B, (C+0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( ((A>B)&(A>C)),                                                   __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>C)),                                                   __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>C)),                                                   __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>C)),                                                   __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>=C)),                                                  __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>=C)),                                                  __iff((B>=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A>=C)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>=C)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>=C)),                                                  __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A>=C)),                                                  __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A==C)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(A==C)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A==C)),                                                  __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A==C)),                                                  __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(A!=C)),                                                  __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(A!=C)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(A!=C)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(A!=C)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(A<=C)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(A<=C)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(A<=C)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(A<=C)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(A<C)),                                                   __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A<C)),                                                   __iff((B>=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(A<C)),                                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(A<C)),                                                   __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(A<C)),                                                   __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(A<C)),                                                   __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>C)),                                                  __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A>=C)),                                                 __iff((B>(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(A>=C)),                                                 __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>=C)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>=C)),                                                 __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A>=C)),                                                 __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A==C)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A==C)),                                                 __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A==C)),                                                 __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(A!=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A!=C)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A!=C)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<=C)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(A<C)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(A<C)),                                                  __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A>=B)|(A<C)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<C)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(A<C)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A>C)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B>(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A>=C)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(A>=C)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A==C)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A!=C)),                                                 __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<=C)),                                                 __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(A<C)),                                                  __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(A<C)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A==B)&__ugreat_eq(A, C)),                                      __iff(__ugreat(B, (C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&__uless(A, C)),                                          __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>C)),                                                  __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)&(A>=C)),                                                 __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A>=C)),                                                 __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A==C)),                                                 __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A!=C)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A<=C)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(A<C)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B>(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(A<C)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat_eq(A, C)),                                      __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|__uless(A, C)),                                          __iff(__ugreat(B, (C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A>C)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(A>C)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(A>C)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(A>C)),                                                  __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A>=C)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(A>=C)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(A>=C)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(A>=C)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A>=C)),                                                 __iff((B>=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(A>=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A==C)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(A==C)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(A==C)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(A==C)),                                                 __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A!=C)),                                                 __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A!=C)),                                                 __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A!=C)),                                                 __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A!=C)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(A<=C)),                                                 __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<=C)),                                                 __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<=C)),                                                 __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<=C)),                                                 __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<C)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<C)),                                                  __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(A<C)),                                                  __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<C)),                                                  __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<C)),                                                  __iff((B>=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(A<C)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>C)),                                                   __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>=C)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>=C)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A>=C)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(A>=C)),                                                  __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(A>=C)),                                                  __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A<B)&(A==C)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A==C)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A==C)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(A!=C)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A!=C)),                                                  __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A!=C)),                                                  __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<=C)),                                                  __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<C)),                                                   __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<C)),                                                   __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(A<C)),                                                   __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<C)),                                                   __iff((B>(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(A<C)),                                                   __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(A==C)),                                         __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(A!=C)),                                         __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(A, C)),                                 __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(A, C)),                              __iff((B==(C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(A, C)),                              __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(A, C)),                              __iff(__ugreat_eq(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(A, C)),                               __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(A, C)),                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(A, C)),                                  __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(A, C)),                                  __iff(__ugreat_eq(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat_eq(A, C)),                           __iff(__ugreat(B, (C-0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless(A, C)),                               __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(A==C)),                                       __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(A!=C)),                                       __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(A, C)),                               __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(A, C)),                            __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(A, C)),                            __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(A, C)),                            __iff(__ugreat_eq(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(A, C)),                             __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(A, C)),                                __iff((B==(C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(A, C)),                                __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(A, C)),                                __iff(__ugreat_eq(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat_eq(A, C)),                               __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless(A, C)),                                   __iff(__ugreat(B, (C-0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( ((A>B)&(C>A)),                                                   __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C>A)),                                                   __iff((B>=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)&(C>A)),                                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(C>A)),                                                   __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(C>A)),                                                   __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(C>A)),                                                   __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(C>=A)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(C>=A)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(C>=A)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(C>=A)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(C==A)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>B)|(C==A)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C==A)),                                                  __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C==A)),                                                  __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C!=A)),                                                  __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C!=A)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(C!=A)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)|(C!=A)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>B)&(C<=A)),                                                  __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<=A)),                                                  __iff((B>=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<=A)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<=A)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<=A)),                                                  __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<=A)),                                                  __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)&(C<A)),                                                   __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<A)),                                                   __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<A)),                                                   __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>B)|(C<A)),                                                   __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)&(C>A)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A>=B)&(C>A)),                                                  __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A>=B)|(C>A)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>A)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>A)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C>=A)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C==A)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C==A)),                                                 __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C==A)),                                                 __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C!=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C!=A)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)|(C!=A)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A>=B)&(C<=A)),                                                 __iff((B>(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)&(C<=A)),                                                 __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<=A)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<=A)),                                                 __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<=A)),                                                 __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A>=B)|(C<A)),                                                  __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C>A)),                                                  __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)|(C>A)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C>=A)),                                                 __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C==A)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C!=A)),                                                 __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B>(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C<=A)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)|(C<=A)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&(C<A)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__ugreat(C, A)),                                         __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A==B)&__uless_eq(C, A)),                                       __iff(__ugreat(B, (C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((A!=B)&(C>A)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B>(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C>A)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C>=A)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C==A)),                                                 __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C!=A)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)&(C<=A)),                                                 __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<=A)),                                                 __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|(C<A)),                                                  __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__ugreat(C, A)),                                         __iff(__ugreat(B, (C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A!=B)|__uless_eq(C, A)),                                       __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(C>A)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>A)),                                                  __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>A)),                                                  __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>A)),                                                  __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>A)),                                                  __iff((B>=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>A)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>=A)),                                                 __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>=A)),                                                 __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C>=A)),                                                 __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C>=A)),                                                 __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C==A)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(C==A)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(C==A)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(C==A)),                                                 __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C!=A)),                                                 __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C!=A)),                                                 __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)&(C!=A)),                                                 __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<=B)|(C!=A)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(C<=A)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(C<=A)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(C<=A)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(C<=A)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C<=A)),                                                 __iff((B>=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)|(C<=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<=B)&(C<A)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(C<A)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)&(C<A)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<=B)|(C<A)),                                                  __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)&(C>A)),                                                   __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>A)),                                                   __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>A)),                                                   __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>A)),                                                   __iff((B>(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)|(C>A)),                                                   __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C>=A)),                                                  __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C==A)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C==A)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C==A)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C!=A)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C!=A)),                                                  __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C!=A)),                                                  __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((A<B)&(C<=A)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<=A)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<=A)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)|(C<=A)),                                                  __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((A<B)|(C<=A)),                                                  __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((A<B)&(C<A)),                                                   __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(C==A)),                                         __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&(C!=A)),                                         __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(C, A)),                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(C, A)),                                 __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat(C, A)),                                 __iff(__ugreat_eq(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__ugreat_eq(C, A)),                              __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(C, A)),                               __iff((B==(C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(C, A)),                               __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless_eq(C, A)),                               __iff(__ugreat_eq(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat(A, B)&__uless(C, A)),                                  __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__ugreat(C, A)),                              __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__ugreat_eq(A, B)&__uless_eq(C, A)),                            __iff(__ugreat(B, (C-0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(C==A)),                                       __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|(C!=A)),                                       __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(C, A)),                               __iff((B==(C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(C, A)),                               __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat(C, A)),                               __iff(__ugreat_eq(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__ugreat_eq(C, A)),                            __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(C, A)),                             __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(C, A)),                             __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless_eq(C, A)),                             __iff(__ugreat_eq(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(A, B)|__uless(C, A)),                                __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless(A, B)|__ugreat(C, A)),                                  __iff(__ugreat(B, (C-0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__uless(A, B)|__uless_eq(C, A)),                                __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>C)),                                                   __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>=C)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>=C)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A>=C)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(A>=C)),                                                  __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(A>=C)),                                                  __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B>A)&(A==C)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A==C)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A==C)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(A!=C)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A!=C)),                                                  __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A!=C)),                                                  __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<=C)),                                                  __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<C)),                                                   __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<C)),                                                   __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(A<C)),                                                   __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<C)),                                                   __iff((B>(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(A<C)),                                                   __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A>C)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(A>C)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(A>C)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(A>C)),                                                  __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(A>=C)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(A>=C)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(A>=C)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(A>=C)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A>=C)),                                                 __iff((B>=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(A>=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(A==C)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(A==C)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(A==C)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(A==C)),                                                 __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A!=C)),                                                 __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A!=C)),                                                 __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A!=C)),                                                 __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A!=C)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(A<=C)),                                                 __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<=C)),                                                 __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<=C)),                                                 __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<=C)),                                                 __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<C)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<C)),                                                  __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(A<C)),                                                  __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<C)),                                                  __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<C)),                                                  __iff((B>=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(A<C)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A>C)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B>(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A>=C)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(A>=C)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A==C)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A!=C)),                                                 __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<=C)),                                                 __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(A<C)),                                                  __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(A<C)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&__ugreat_eq(A, C)),                                      __iff(__ugreat(B, (C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&__uless(A, C)),                                          __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>C)),                                                  __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)&(A>=C)),                                                 __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A>=C)),                                                 __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A==C)),                                                 __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A!=C)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A<=C)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(A<C)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B>(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(A<C)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat_eq(A, C)),                                      __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|__uless(A, C)),                                          __iff(__ugreat(B, (C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>C)),                                                  __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A>=C)),                                                 __iff((B>(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(A>=C)),                                                 __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>=C)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>=C)),                                                 __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A>=C)),                                                 __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A==C)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A==C)),                                                 __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A==C)),                                                 __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(A!=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A!=C)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A!=C)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<=C)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(A<C)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(A<C)),                                                  __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B<=A)|(A<C)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<C)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(A<C)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(A>C)),                                                   __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>C)),                                                   __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>C)),                                                   __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>C)),                                                   __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>=C)),                                                  __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>=C)),                                                  __iff((B>=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A>=C)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>=C)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>=C)),                                                  __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A>=C)),                                                  __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A==C)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(A==C)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A==C)),                                                  __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A==C)),                                                  __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(A!=C)),                                                  __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(A!=C)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(A!=C)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(A!=C)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(A<=C)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(A<=C)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(A<=C)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(A<=C)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(A<C)),                                                   __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A<C)),                                                   __iff((B>=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(A<C)),                                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(A<C)),                                                   __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(A<C)),                                                   __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(A<C)),                                                   __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat_eq(A, C)),                              __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless(A, C)),                                  __iff(__ugreat(B, (C-0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(A==C)),                                      __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(A!=C)),                                      __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(A, C)),                              __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(A, C)),                           __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(A, C)),                           __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(A, C)),                           __iff(__ugreat_eq(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(A, C)),                            __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(A, C)),                               __iff((B==(C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(A, C)),                               __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(A, C)),                               __iff(__ugreat_eq(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat_eq(A, C)),                            __iff(__ugreat(B, (C-0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless(A, C)),                                __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&(A==C)),                                          __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&(A!=C)),                                          __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(A, C)),                                  __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(A, C)),                               __iff((B==(C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(A, C)),                               __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(A, C)),                               __iff(__ugreat_eq(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(A, C)),                                __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(A, C)),                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(A, C)),                                   __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(A, C)),                                   __iff(__ugreat_eq(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C>A)),                                                   __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>A)),                                                   __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>A)),                                                   __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>A)),                                                   __iff((B>(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)|(C>A)),                                                   __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C>=A)),                                                  __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C==A)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C==A)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C==A)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C!=A)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C!=A)),                                                  __iff((B<=(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C!=A)),                                                  __iff((B<(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B>A)&(C<=A)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<=A)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<=A)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)|(C<=A)),                                                  __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>A)|(C<=A)),                                                  __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>A)&(C<A)),                                                   __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C>A)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>A)),                                                  __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>A)),                                                  __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>A)),                                                  __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>A)),                                                  __iff((B>=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>A)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>=A)),                                                 __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>=A)),                                                 __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C>=A)),                                                 __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C>=A)),                                                 __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C==A)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C==A)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C==A)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(C==A)),                                                 __iff((B>(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C!=A)),                                                 __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C!=A)),                                                 __iff((B<=(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)&(C!=A)),                                                 __iff((B<(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B>=A)|(C!=A)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(C<=A)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C<=A)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C<=A)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(C<=A)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C<=A)),                                                 __iff((B>=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)|(C<=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B>=A)&(C<A)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C<A)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)&(C<A)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B>=A)|(C<A)),                                                  __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C>A)),                                                  __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)|(C>A)),                                                  __iff((B==(C-0x1)), (A<=B)) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C>=A)),                                                 __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C==A)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff((B<=(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C!=A)),                                                 __iff((B<(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B>(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C<=A)),                                                 __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)|(C<=A)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B<=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&(C<A)),                                                  __iff((B<(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__ugreat(C, A)),                                         __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B==A)&__uless_eq(C, A)),                                       __iff(__ugreat(B, (C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B!=A)&(C>A)),                                                  __iff((B==(C-0x1)), (A<B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B>(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C>A)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C>=A)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C==A)),                                                 __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C!=A)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)&(C<=A)),                                                 __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B>(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<=A)),                                                 __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B==(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B<=(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|(C<A)),                                                  __iff((B<(C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__ugreat(C, A)),                                         __iff(__ugreat(B, (C-0x1)), (A!=B)) );
        ADD_DIRECTIVE( ((B!=A)|__uless_eq(C, A)),                                       __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(C>A)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<=A)&(C>A)),                                                  __iff((B==(C-0x1)), (A==B)) );
        ADD_DIRECTIVE( ((B<=A)|(C>A)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>A)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>A)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C>=A)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C==A)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C==A)),                                                 __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C==A)),                                                 __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C!=A)),                                                 __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C!=A)),                                                 __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)|(C!=A)),                                                 __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<=A)&(C<=A)),                                                 __iff((B>(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)&(C<=A)),                                                 __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<=A)),                                                 __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<=A)),                                                 __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<=A)),                                                 __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B==(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B<=(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<=A)|(C<A)),                                                  __iff((B<(C-0x1)), (A>=B)) );
        ADD_DIRECTIVE( ((B<A)&(C>A)),                                                   __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C>A)),                                                   __iff((B>=(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)&(C>A)),                                                   __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(C>A)),                                                   __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(C>A)),                                                   __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(C>A)),                                                   __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(C>=A)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(C>=A)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(C>=A)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(C>=A)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(C==A)),                                                  __iff((B>(C-0x1)), 0x0) );
        ADD_DIRECTIVE( ((B<A)|(C==A)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C==A)),                                                  __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C==A)),                                                  __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C!=A)),                                                  __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C!=A)),                                                  __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(C!=A)),                                                  __iff((B<=(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)|(C!=A)),                                                  __iff((B<(C-0x1)), 0x1) );
        ADD_DIRECTIVE( ((B<A)&(C<=A)),                                                  __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<=A)),                                                  __iff((B>=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<=A)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<=A)),                                                  __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<=A)),                                                  __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<=A)),                                                  __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)&(C<A)),                                                   __iff((B>(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<A)),                                                   __iff((B==(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<A)),                                                   __iff((B<=(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( ((B<A)|(C<A)),                                                   __iff((B<(C-0x1)), (A>B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__ugreat(C, A)),                                 __iff(__ugreat(B, (C-0x1)), __uless(A, B)) );
        ADD_DIRECTIVE( (__ugreat(B, A)|__uless_eq(C, A)),                               __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(C==A)),                                      __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|(C!=A)),                                      __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(C, A)),                              __iff((B==(C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(C, A)),                              __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat(C, A)),                              __iff(__ugreat_eq(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__ugreat_eq(C, A)),                           __iff(__ugreat(B, (C-0x1)), __uless_eq(A, B)) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(C, A)),                            __iff((B==(C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(C, A)),                            __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless_eq(C, A)),                            __iff(__ugreat_eq(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__ugreat_eq(B, A)|__uless(C, A)),                               __iff(__ugreat(B, (C-0x1)), 0x1) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__ugreat(C, A)),                               __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless_eq(B, A)&__uless_eq(C, A)),                             __iff(__ugreat(B, (C-0x1)), __ugreat_eq(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&(C==A)),                                          __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&(C!=A)),                                          __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(C, A)),                                  __iff((B==(C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(C, A)),                                  __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat(C, A)),                                  __iff(__ugreat_eq(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__ugreat_eq(C, A)),                               __iff(__ugreat(B, (C-0x1)), 0x0) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(C, A)),                                __iff((B==(C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(C, A)),                                __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless_eq(C, A)),                                __iff(__ugreat_eq(B, (C-0x1)), __ugreat(A, B)) );
        ADD_DIRECTIVE( (__uless(B, A)&__uless(C, A)),                                   __iff(__ugreat(B, (C-0x1)), __ugreat(A, B)) );
#undef ADD_DIRECTIVE
#endif
        return boolean_simplifiers;
    }

	constexpr auto overflow = [ ] ( auto a, auto b ) { return ((a<0)==(b<0))&((a<0)!=((a+b)<0)); };
	constexpr auto underflow = [ ] ( auto a, auto b ) { return ((a<0)!=(b<0))&((a<0)!=((a-b)<0)); };

    const std::vector<std::pair<instance, instance>> boolean_joiners =
    {
        // Manually added:
        //

		// TODO: Replace with proper overflow check detection later, this is bad.
        //
        //{ (A+B)>C,                                                         s((A>!(C-B))|overflow(A,B)|underflow(C,B)) },
		//{ (A+B)<C,                                                         s((A<!(C-B))&~overflow(A,B)&~underflow(C,B)) },
        //{ (A-B)>C,                                                         s((A>!(C+B))&~overflow(C,B)&~underflow(A,B)) },
		//{ (A-B)<C,                                                         s((A<!(C+B))|overflow(C,B)|underflow(A,B)) },
        //{ (A-B)>=C,                                                        s((A==!(C+B))|((A-B)>C)) },
        //{ (A-B)<=C,                                                        s((A==!(C+B))|((A-B)<C)) },
        //{ (A+B)>=C,                                                        s((A==!(C-B))|((A+B)>C)) },
        //{ (A+B)<=C,                                                        s((A==!(C-B))|((A+B)<C)) },

        { (W>B),                                                           (!(~W)<s(~B)) },
        { (W>=B),                                                          (!(~W)<=s(~B)) },
        { (W==B),                                                          (!(~W)==s(~B)) },
        { (W!=B),                                                          (!(~W)!=s(~B)) },
        { (W<=B),                                                          (!(~W)>=s(~B)) },
        { (W<B),                                                           (!(~W)>s(~B)) },
        { __ugreat(W, B),                                                  __uless(!(~W), s(~B)) },
        { __ugreat_eq(W, B),                                               __uless_eq(!(~W), s(~B)) },
        { __uless_eq(W, B),                                                __ugreat_eq(!(~W), s(~B)) },
        { __uless(W, B),                                                   __ugreat(!(~W), s(~B)) },
        { (W>B),                                                           (!(-W)<s(-B)) },
        { (W>=B),                                                          (!(-W)<=s(-B)) },
        { (W==B),                                                          (!(-W)==s(-B)) },
        { (W!=B),                                                          (!(-W)!=s(-B)) },
        { (W<=B),                                                          (!(-W)>=s(-B)) },
        { (W<B),                                                           (!(-W)>s(-B)) },

        { (A+B)==C,                                                        A==!(C-B) },
        { (A-B)==C,                                                        A==!(C+B) },
        { (A+B)!=C,                                                        A!=!(C-B) },
        { (A-B)!=C,                                                        A!=!(C+B) },
        { A==B,                                                            !(A-B)==0u },
        { A==B,                                                            !(A^B)==0u },
        { A!=B,                                                            !(A-B)!=0u },
        { A!=B,                                                            !(A^B)!=0u },
        { (A^B)==C,                                                        !(C^B)==A },
    };
};