/*
  VitaShell
  Copyright (C) 2015-2018, TheFloW

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef __SFO_H__
#define __SFO_H__

#define SFO_MAGIC 0x46535000

#define PSF_TYPE_BIN 0
#define PSF_TYPE_STR 2
#define PSF_TYPE_VAL 4

typedef struct SfoHeader {
  uint32_t magic;
  uint32_t version;
  uint32_t keyofs;
  uint32_t valofs;
  uint32_t count;
} __attribute__((packed)) SfoHeader;

typedef struct SfoEntry {
  uint16_t nameofs;
  uint8_t  alignment;
  uint8_t  type;
  uint32_t valsize;
  uint32_t totalsize;
  uint32_t dataofs;
} __attribute__((packed)) SfoEntry;

int getSfoValue(void *buffer, const char *name, uint32_t *value);
int getSfoString(void *buffer, const char *name, char *string, int length);
int setSfoValue(void *buffer, const char *name, uint32_t value);
int setSfoString(void *buffer, const char *name, const char *string);

int SFOReader(const char *file);

#endif
