#include "Hooks.h"
#include "Functions.h"
#include "Utils.h"

typedef struct FunctionBinding {
    PCSTR name;
    LPCVOID function;
} FunctionBinding;

#define FUNCTION(name) { #name, Hooks_##name }

static CONST FunctionBinding functions[] = {
    FUNCTION(GetProcAddress),
    FUNCTION(OpenProcess),
    FUNCTION(GetProcessImageFileNameA),
    FUNCTION(GetProcessImageFileNameW),
    FUNCTION(GetWindowTextW),
    FUNCTION(QueryFullProcessImageNameW),
    FUNCTION(GetModuleBaseNameA),
    FUNCTION(GetModuleBaseNameW),
    FUNCTION(GetModuleFileNameA),
    FUNCTION(GetModuleFileNameExA),
    FUNCTION(GetModuleFileNameExW),
    FUNCTION(GetComputerNameExW),
    FUNCTION(CreateRemoteThread),
    FUNCTION(NtOpenProcess),
    FUNCTION(ReadProcessMemory),
    FUNCTION(WriteProcessMemory),
    FUNCTION(MultiByteToWideChar),
    FUNCTION(GetUserNameExW),
    FUNCTION(GetDriveTypeW),
    FUNCTION(RegEnumKeyExA),
    FUNCTION(RegOpenKeyExA),
    FUNCTION(RegCloseKey),
    FUNCTION(RegQueryInfoKeyA),
    FUNCTION(RegQueryValueExA),
    FUNCTION(OutputDebugStringA),
    FUNCTION(GetFileVersionInfoA),
    FUNCTION(GetFileVersionInfoW),
    FUNCTION(GetFileVersionInfoSizeA),
    FUNCTION(GetFileVersionInfoSizeW),
    FUNCTION(GetFileSize),
    FUNCTION(GetFileSizeEx),
    FUNCTION(GetWindowInfo),
    FUNCTION(GetWindowsDirectoryA),
    FUNCTION(GetWindowsDirectoryW),
    FUNCTION(GetModuleHandleA),
    FUNCTION(AddVectoredExceptionHandler),
    FUNCTION(AdjustTokenPrivileges),
    FUNCTION(CertGetNameStringW),
    FUNCTION(CreateFileA),
    FUNCTION(CreateFileW),
    FUNCTION(GetCurrentProcess),
    FUNCTION(GetCurrentProcessId),
    FUNCTION(GetCurrentThread),
    FUNCTION(GetCurrentThreadId),
    FUNCTION(CreateToolhelp32Snapshot),
    FUNCTION(EnumChildWindows),
    FUNCTION(EnumProcesses),
    FUNCTION(EnumWindows),
    FUNCTION(GetProcessTimes),
    FUNCTION(WaitForSingleObject),
    FUNCTION(VirtualAlloc),
    FUNCTION(VirtualAllocEx),
    FUNCTION(VirtualFree),
    FUNCTION(VirtualFreeEx),
    FUNCTION(VirtualProtect),
    FUNCTION(VirtualQuery),
    FUNCTION(VirtualQueryEx),
    FUNCTION(SuspendThread),
    FUNCTION(SwitchToThread),
    FUNCTION(Wow64EnableWow64FsRedirection),
    FUNCTION(WinVerifyTrust),
    FUNCTION(Sleep),
    FUNCTION(CreateFileMappingW),
    FUNCTION(OpenProcessToken),
    FUNCTION(EnumServicesStatusA),
    FUNCTION(EnumServicesStatusW),
    FUNCTION(FindFirstVolumeW),
    FUNCTION(FindNextVolumeW),
    FUNCTION(FlushInstructionCache),
    FUNCTION(GetVolumePathNamesForVolumeNameW),
    FUNCTION(GetWindowThreadProcessId),
    FUNCTION(Heap32First),
    FUNCTION(NtQuerySystemInformation),
    FUNCTION(ConvertSidToStringSidA),
    FUNCTION(CryptMsgGetParam),
    FUNCTION(NtQueryInformationProcess),
    FUNCTION(EncodePointer),
    FUNCTION(NtQueryInformationThread),
    FUNCTION(OpenSCManagerA),
    FUNCTION(OpenThread),
    FUNCTION(Process32FirstW),
    FUNCTION(Process32NextW),
    FUNCTION(WriteFile),
    FUNCTION(NtQueryVirtualMemory),
    FUNCTION(SetLastError),
    FUNCTION(SetThreadAffinityMask),
    FUNCTION(Thread32First),
    FUNCTION(Thread32Next),
    FUNCTION(NtQueryObject),
    FUNCTION(NtFsControlFile),
    FUNCTION(GetThreadContext),
    FUNCTION(GetTokenInformation),
    FUNCTION(GetUserProfileDirectoryA),
    FUNCTION(GetUserProfileDirectoryW),
    FUNCTION(NtDuplicateObject),
    FUNCTION(OpenFileMappingW),
    FUNCTION(OpenFileMappingA),
    FUNCTION(RtlDecompressBufferEx),
    FUNCTION(GetTcpTable),
    FUNCTION(CloseHandle),
    FUNCTION(SetFilePointer),
    FUNCTION(OpenFileById),
    FUNCTION(GetMappedFileNameA),
    FUNCTION(GetMappedFileNameW),
    FUNCTION(SetFilePointerEx),
    FUNCTION(ResumeThread),
    FUNCTION(SymGetModuleBase64),
    FUNCTION(GetProcessId),
    FUNCTION(IsBadReadPtr),
    FUNCTION(ReadFile),
    FUNCTION(GetThreadId),
    FUNCTION(LocalAlloc),
    FUNCTION(GetModuleInformation),
    FUNCTION(IsWow64Process),
    FUNCTION(GetSystemDirectoryA),
    FUNCTION(GetSystemDirectoryW),
    FUNCTION(GetProcessHeap),
    FUNCTION(MapViewOfFile),
    FUNCTION(UnmapViewOfFile),
    FUNCTION(GetVolumeInformationByHandleW),
    FUNCTION(EnumProcessModules),
    FUNCTION(GetTickCount),
    FUNCTION(SetupDiGetClassDevsA),
    FUNCTION(SetupDiEnumDeviceInfo),
    FUNCTION(HeapAlloc),
    FUNCTION(HeapFree),
    FUNCTION(FindVolumeClose),
    FUNCTION(NtReadVirtualMemory),
    FUNCTION(NtOpenDirectoryObject),
    FUNCTION(LocalFree),
    FUNCTION(OpenServiceA),
    FUNCTION(OpenServiceW),
    FUNCTION(GetSystemTimeAsFileTime),
    FUNCTION(OpenEventLogA),
    FUNCTION(ReadEventLogA),
    FUNCTION(CloseEventLog),
    FUNCTION(QueryDosDeviceA),
    FUNCTION(QueryDosDeviceW),
    FUNCTION(GetLastError),
    FUNCTION(GetFileInformationByHandle),
    FUNCTION(GetFileInformationByHandleEx),
    FUNCTION(CloseServiceHandle),
    FUNCTION(QueryServiceConfigA),
    FUNCTION(QueryServiceConfigW),
    FUNCTION(WinVerifyTrustEx),
    FUNCTION(LoadLibraryA),
    FUNCTION(GetVolumeInformationW),
    FUNCTION(LoadLibraryExA),
    FUNCTION(FreeLibrary),
    FUNCTION(NtOpenSection),
    FUNCTION(NtQuerySection),
    FUNCTION(GetLogicalDriveStringsA),
    FUNCTION(GetLogicalDriveStringsW),
    FUNCTION(GetModuleHandleExA),
    FUNCTION(Module32FirstW),
    FUNCTION(Module32NextW),
    FUNCTION(SetupDiDestroyDeviceInfoList),
    FUNCTION(SymFunctionTableAccess64),
    FUNCTION(GetUdpTable),
    FUNCTION(CryptDecodeObject),
    FUNCTION(CryptMsgClose),
    FUNCTION(CertFindCertificateInStore),
    FUNCTION(CertCloseStore),
    FUNCTION(NtMapViewOfSection),
    FUNCTION(VerQueryValueA),
    FUNCTION(VerQueryValueW),
    FUNCTION(CryptQueryObject),
    FUNCTION(LookupPrivilegeValueA),
    FUNCTION(NtClose),
    FUNCTION(CompareStringW),
    FUNCTION(StackWalk64),
    FUNCTION(WideCharToMultiByte),
    FUNCTION(GetVersionExA),
    FUNCTION(GetVersionExW),
    FUNCTION(SetupDiGetDeviceRegistryPropertyA),
    FUNCTION(CryptHashCertificate),
    FUNCTION(CertFreeCertificateContext),
    FUNCTION(GetSystemInfo),
    FUNCTION(NtQueryDirectoryObject),
    FUNCTION(RtlGetCompressionWorkSpaceSize),
    FUNCTION(lstrlenW),
    FUNCTION(lstrcatW),
    FUNCTION(NtWow64QueryVirtualMemory64),
    FUNCTION(NtWow64ReadVirtualMemory64),
    FUNCTION(NtWow64QueryInformationProcess64),
    FUNCTION(GetTcp6Table),
    FUNCTION(GetUdp6Table),
    FUNCTION(GetVersion),
    FUNCTION(GetNativeSystemInfo),
    FUNCTION(SnmpExtensionInit),
    FUNCTION(SnmpExtensionQuery),
    FUNCTION(SnmpUtilMemAlloc),
    FUNCTION(SnmpUtilVarBindFree),
    FUNCTION(SnmpExtensionClose),
    FUNCTION(CharUpperW),
    FUNCTION(lstrcmpiW),
    FUNCTION(wsprintfW),
    FUNCTION(wsprintfA),
    FUNCTION(ExitProcess)
};

FARPROC Functions_find(PCSTR name)
{
    for (INT i = 0; i < _countof(functions); ++i)
        if (!strcmp(functions[i].name, name))
            return (FARPROC)functions[i].function;
    return NULL;
}
