/*
 * Demonstration of sound sample player
 * by Lars Malmborg <glue@df.lth.se>
 */

#include <gb/gb.h>
#include <gb/sample.h>
#include <stdio.h>

#define SAMPLES 25768
extern const UBYTE sample[];

void main()
{
	puts("\n    Ren & Stimpy\n");
	while(1)
	{
		waitpad(J_START);
		puts(".");
		play_sample(sample, SAMPLES / 32);
		waitpadup();
	}
}

const UBYTE sample[] =
{
0x86,0x98,0x65,0x97,0x7b,0x79,0x66,0x77,
0x87,0x76,0x88,0x89,0x88,0x68,0x88,0x99,
0x66,0x78,0x88,0x69,0x79,0x87,0x78,0x86,
0x67,0x77,0x87,0x98,0x86,0x8a,0x7a,0x89,
0x76,0x75,0x96,0x64,0x76,0x67,0x6a,0x79,
0x8a,0xaa,0x88,0x68,0x69,0x55,0x6a,0xa7,
0x6b,0x98,0x92,0x78,0x66,0x88,0x68,0x97,
0xa4,0x58,0x96,0x9b,0xcb,0x79,0xba,0x11,
0x3a,0x00,0x8e,0xda,0xaf,0xb4,0x05,0x92,
0x07,0xe5,0x6b,0xfa,0x45,0xb7,0x08,0xb8,
0x77,0xd8,0x05,0xd2,0x27,0xee,0xa9,0xfc,
0x60,0x45,0x40,0x5d,0xca,0xad,0xb5,0x37,
0x97,0x46,0xa8,0x57,0xb6,0x26,0xc6,0x68,
0xed,0x67,0xd7,0x02,0x48,0x36,0xcf,0x9a,
0xb9,0x30,0x49,0x85,0xbb,0xc7,0x68,0x60,
0x38,0x98,0x7e,0xe9,0x88,0x40,0x54,0x7a,
0x7d,0xe8,0x85,0x43,0x66,0xa8,0xdc,0xa7,
0x52,0x66,0x67,0xbb,0xb8,0x79,0x84,0x56,
0x68,0x87,0x9a,0x97,0x77,0x35,0x86,0x9a,
0x8a,0x96,0x53,0x37,0x57,0xdb,0xa9,0xc9,
0x52,0x26,0x87,0x6d,0xc8,0x57,0x87,0x56,
0x58,0x97,0x9c,0xa8,0x65,0x32,0x6a,0xc9,
0x9a,0xa4,0x36,0xba,0x78,0xb6,0x05,0xbb,
0x99,0x99,0x62,0x39,0xc9,0x9a,0xa9,0x74,
0x03,0xaf,0x95,0x8a,0x60,0x3a,0xe9,0x88,
0xb8,0x10,0x7f,0xd6,0x59,0x95,0x15,0xcf,
0x85,0x8b,0x71,0x38,0xfc,0x65,0x98,0x44,
0x7d,0xc8,0x69,0x97,0x43,0x8d,0xb6,0x59,
0x88,0x44,0xbe,0x84,0x79,0x97,0x33,0x9d,
0x95,0x78,0x75,0x46,0xcd,0x84,0x7a,0x95,
0x34,0xbe,0x84,0x78,0x86,0x37,0xeb,0x64,
0x8a,0x94,0x18,0xeb,0x64,0x78,0x85,0x5c,
0xd8,0x46,0x9a,0x73,0x4b,0xe7,0x46,0x88,
0x65,0xae,0x95,0x58,0x97,0x33,0xae,0x95,
0x55,0x99,0x69,0xc9,0x56,0x78,0x85,0x36,
0xca,0x64,0x59,0xb6,0x59,0xa9,0x65,0x7a,
0x82,0x4b,0xb8,0x55,0x6a,0x74,0x9d,0x97,
0x58,0xa8,0x25,0x7e,0xb6,0x35,0xaa,0x77,
0x9a,0x86,0x78,0x85,0x36,0xcc,0x75,0x66,
0x98,0x7a,0xa8,0x67,0x89,0x72,0x4c,0xe7,
0x43,0x6a,0x96,0x89,0x77,0x77,0x77,0x44,
0xbd,0x86,0x66,0x89,0x69,0xb8,0x56,0x89,
0x95,0x35,0xdd,0x75,0x47,0xb9,0x79,0x87,
0x77,0x78,0x52,0x6d,0xc7,0x56,0x68,0x78,
0xda,0x75,0x68,0xa7,0x13,0xcf,0xa5,0x45,
0x9a,0x89,0x98,0x77,0x87,0x63,0x3b,0xea,
0x64,0x58,0x97,0x8b,0xa7,0x66,0x8a,0x63,
0x4c,0xda,0x63,0x5a,0xb9,0x98,0x78,0x77,
0x74,0x27,0xdc,0x85,0x34,0x99,0x9b,0x87,
0x76,0x79,0x71,0x2a,0xec,0x74,0x87,0xbb,
0xa7,0x68,0x89,0x74,0x22,0xbf,0xb7,0x34,
0x7a,0x9a,0x96,0x78,0x78,0x74,0x16,0xdb,
0x76,0x67,0x99,0x88,0x97,0x78,0x86,0x43,
0x8c,0x99,0x75,0x79,0x99,0x88,0x97,0x88,
0x75,0x37,0xbc,0xa6,0x57,0x9a,0x88,0x88,
0x97,0x75,0x45,0x99,0x98,0x77,0x78,0x79,
0x87,0xa9,0x77,0x41,0x4a,0xbb,0xb7,0x67,
0x66,0x99,0x79,0x89,0x75,0x33,0x7a,0xb8,
0x87,0x77,0x77,0x9a,0x98,0x78,0x51,0x49,
0xbb,0xa8,0x76,0x67,0x89,0xa9,0x77,0x84,
0x23,0x7a,0xca,0x98,0x66,0x58,0x9a,0x98,
0x76,0x52,0x27,0x9b,0xec,0x85,0x45,0x89,
0x89,0x98,0x87,0x53,0x47,0x9b,0xca,0x87,
0x66,0x78,0x8a,0xa9,0x94,0x23,0x79,0x9c,
0xcb,0x96,0x56,0x87,0x99,0x89,0x75,0x45,
0x78,0x9a,0xa9,0xa7,0x87,0x67,0x9a,0x75,
0x22,0x79,0xbb,0x89,0xa9,0x75,0x55,0x89,
0x9a,0x87,0x53,0x46,0x77,0xba,0xbb,0x77,
0x66,0x68,0x87,0x97,0x22,0x99,0x7a,0x7a,
0xd9,0x76,0x55,0x88,0x79,0x78,0x85,0x66,
0x65,0x79,0xab,0x98,0x98,0x69,0x88,0x71,
0x05,0x8a,0xd8,0x9a,0xbb,0x75,0x46,0x78,
0x98,0x97,0x46,0x75,0x77,0x89,0xa9,0x98,
0x77,0x88,0x8a,0x60,0x26,0x7d,0xa7,0x9b,
0xbb,0x84,0x47,0x89,0x98,0x85,0x46,0x77,
0x78,0x9b,0xa9,0x86,0x67,0x97,0x87,0x83,
0x16,0x69,0xa6,0x9b,0xcc,0x86,0x57,0x87,
0x65,0x65,0x57,0x89,0x76,0x8a,0x9b,0x87,
0x89,0x88,0x87,0x52,0x24,0x4a,0x78,0xbb,
0xcb,0x88,0x67,0x66,0x66,0x77,0x56,0x77,
0x86,0x79,0x8a,0xa8,0x98,0x89,0x86,0x87,
0x24,0x46,0x96,0x88,0xac,0xd8,0xa8,0x78,
0x85,0x55,0x68,0x89,0x87,0x87,0x87,0x87,
0x78,0x89,0x98,0x88,0x88,0x78,0x88,0x78,
0x87,0x88,0x87,0x78,0x87,0x87,0x78,0x88,
0x88,0x87,0x77,0x77,0x77,0x78,0x87,0x77,
0x76,0x77,0x77,0x78,0x78,0x87,0x88,0x89,
0x87,0x77,0x77,0x78,0x87,0x78,0x77,0x77,
0x77,0x78,0x88,0x77,0x88,0x77,0x88,0x78,
0x88,0x88,0x88,0x88,0x88,0x87,0x77,0x87,
0x78,0x88,0x87,0x88,0x88,0x78,0x88,0x77,
0x77,0x78,0x77,0x88,0x77,0x88,0x88,0x88,
0x89,0x77,0x77,0x78,0x87,0x68,0x77,0x87,
0x77,0x78,0x88,0x77,0x77,0x77,0x87,0x67,
0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x87,
0x77,0x77,0x77,0x77,0x87,0x78,0x88,0x78,
0x77,0x87,0x77,0x77,0x78,0x88,0x87,0x78,
0x88,0x77,0x77,0x88,0x76,0x77,0x77,0x88,
0x77,0x77,0x88,0x87,0x78,0x88,0x87,0x78,
0x77,0x88,0x88,0x88,0x89,0x88,0x78,0x87,
0x87,0x68,0x88,0x87,0x87,0x88,0x77,0x77,
0x87,0x88,0x77,0x78,0x88,0x88,0x88,0x88,
0x88,0x77,0x77,0x78,0x76,0x67,0x77,0x77,
0x67,0x87,0x78,0x77,0x77,0x88,0x87,0x78,
0x77,0x77,0x87,0x88,0x88,0x78,0x87,0x88,
0x88,0x78,0x77,0x87,0x77,0x78,0x87,0x77,
0x77,0x88,0x78,0x88,0x88,0x88,0x78,0x89,
0x97,0x78,0x78,0x87,0x78,0x88,0x88,0x77,
0x87,0x78,0x88,0x77,0x77,0x88,0x78,0x89,
0x88,0x87,0x78,0x78,0x88,0x77,0x88,0x88,
0x77,0x88,0x87,0x87,0x77,0x88,0x87,0x87,
0x78,0x88,0x87,0x88,0x88,0x78,0x77,0x88,
0x87,0x77,0x77,0x87,0x77,0x77,0x88,0x87,
0x77,0x78,0x87,0x78,0x87,0x78,0x88,0x88,
0x88,0x88,0x88,0x88,0x98,0x78,0x78,0x77,
0x77,0x77,0x78,0x88,0x87,0x78,0x87,0x77,
0x77,0x88,0x77,0x87,0x78,0x88,0x88,0x78,
0x88,0x77,0x87,0x78,0x76,0x77,0x88,0x88,
0x87,0x88,0x87,0x78,0x78,0x88,0x87,0x77,
0x88,0x78,0x88,0x88,0x87,0x88,0x88,0x88,
0x88,0x76,0x78,0x87,0x77,0x78,0x87,0x78,
0x77,0x78,0x87,0x77,0x78,0x88,0x77,0x88,
0x88,0x78,0x77,0x77,0x78,0x77,0x77,0x77,
0x87,0x78,0x88,0x76,0x78,0x88,0x88,0x87,
0x87,0x78,0x77,0x88,0x88,0x87,0x78,0x98,
0x87,0x78,0x88,0x77,0x87,0x78,0x87,0x88,
0x77,0x88,0x87,0x77,0x88,0x77,0x77,0x77,
0x87,0x78,0x87,0x78,0x87,0x78,0x88,0x87,
0x78,0x87,0x78,0x77,0x78,0x77,0x88,0x87,
0x88,0x88,0x76,0x88,0x77,0x77,0x78,0x87,
0x88,0x88,0x88,0x88,0x76,0x78,0x77,0x78,
0x88,0x88,0x78,0x87,0x88,0x88,0x87,0x78,
0x87,0x78,0x77,0x88,0x87,0x78,0x77,0x77,
0x87,0x77,0x77,0x76,0x78,0x88,0x88,0x77,
0x87,0x88,0x77,0x77,0x77,0x76,0x78,0x88,
0x88,0x87,0x88,0x88,0x77,0x78,0x87,0x77,
0x78,0x87,0x88,0x88,0x88,0x88,0x88,0x78,
0x87,0x77,0x77,0x88,0x78,0x98,0x88,0x88,
0x78,0x77,0x88,0x76,0x78,0x88,0x88,0x88,
0x87,0x77,0x77,0x77,0x78,0x77,0x77,0x77,
0x78,0x78,0x88,0x78,0x87,0x77,0x77,0x87,
0x67,0x88,0x78,0x77,0x88,0x88,0x77,0x78,
0x87,0x67,0x77,0x78,0x88,0x78,0x88,0x88,
0x87,0x87,0x88,0x77,0x78,0x87,0x88,0x79,
0x87,0xa7,0x97,0x78,0x78,0x87,0x77,0x89,
0x79,0x67,0x89,0x88,0x79,0x78,0x77,0x88,
0x89,0x77,0x97,0x96,0x67,0x79,0x96,0x96,
0x78,0x88,0x68,0x89,0x68,0x66,0x77,0x97,
0xa6,0x67,0xa3,0xa4,0x68,0x39,0xa3,0x8b,
0x93,0xaa,0x87,0xb3,0xc9,0x56,0xa5,0x6a,
0x58,0x86,0x97,0x7b,0x76,0xc5,0x96,0x68,
0x98,0x74,0xcb,0x1a,0x68,0x97,0x66,0xa6,
0x87,0xa7,0x88,0x7d,0x79,0x7a,0x66,0x63,
0x46,0x78,0x98,0xa9,0xc7,0xa8,0xb7,0x49,
0x6a,0x86,0x77,0x86,0x44,0x88,0x57,0x88,
0x69,0x9b,0xfa,0xad,0xab,0x73,0x00,0x05,
0x45,0xbf,0xeb,0xb9,0x87,0x66,0x43,0x67,
0x69,0x99,0xb8,0x69,0x43,0x31,0x59,0xca,
0xdf,0xda,0x78,0x84,0x43,0x24,0x67,0x6d,
0xc9,0x9a,0x67,0x69,0xb7,0x58,0xb8,0x79,
0xb5,0x20,0x08,0xb3,0x8f,0xfa,0x48,0x96,
0x34,0x89,0x98,0x8a,0x50,0x59,0x93,0x7f,
0xf9,0x68,0xa7,0x37,0xb9,0x77,0x74,0x06,
0xa5,0x8c,0xec,0x66,0x98,0x45,0x88,0x88,
0x89,0x96,0x56,0x66,0x76,0x7b,0xa7,0x88,
0x99,0x76,0x79,0x77,0x95,0x61,0x4a,0xd8,
0x7b,0xc9,0x44,0x5a,0x78,0x8a,0x88,0x53,
0x6c,0x86,0x68,0x98,0x43,0x4a,0xea,0x78,
0xaa,0x65,0x77,0x88,0x79,0x87,0x31,0x7c,
0xba,0xaa,0x74,0x37,0xb9,0x88,0x99,0x74,
0x78,0x85,0x45,0xbb,0x74,0x9b,0x74,0x7c,
0xc7,0x47,0xa9,0x67,0x8b,0x70,0x18,0xdd,
0x67,0xba,0x53,0x59,0x97,0x78,0x98,0x43,
0xad,0xa9,0x66,0x86,0x44,0x6a,0xc9,0x78,
0x88,0x88,0x78,0x79,0x87,0x88,0x76,0x76,
0x44,0xb7,0xac,0xb5,0x55,0x78,0x89,0x97,
0x77,0x78,0x85,0x00,0x7e,0xe8,0x76,0x97,
0x45,0xab,0x86,0x58,0x9a,0x64,0x6a,0xaa,
0x87,0x47,0x79,0x8a,0x79,0x77,0x99,0x66,
0x77,0x88,0xa9,0x84,0x56,0x9b,0x35,0xdd,
0x75,0x59,0x96,0x6a,0x98,0x66,0x68,0x62,
0x6b,0xb8,0x68,0xab,0x55,0x9a,0x86,0x79,
0x88,0x98,0x55,0x26,0xd8,0x66,0xce,0x93,
0x35,0x8a,0xc8,0x76,0x79,0xa7,0x55,0x65,
0x66,0x6d,0xea,0x64,0x6a,0x97,0x56,0x88,
0x76,0x6a,0xb9,0x57,0xa7,0x54,0x4a,0xa8,
0x8a,0x99,0x65,0x98,0x68,0x88,0x86,0x57,
0x9b,0x94,0x66,0x67,0x28,0xfd,0x75,0x59,
0x77,0x9a,0x89,0x67,0x70,0x3c,0xe8,0x3b,
0xa9,0x16,0xca,0x57,0x8a,0x96,0x38,0xca,
0x75,0x68,0x56,0x5a,0xec,0x86,0x58,0x97,
0x79,0x77,0x77,0x98,0x12,0xde,0x46,0xac,
0x93,0x6b,0x85,0x57,0x99,0x64,0x6c,0xa8,
0x58,0x88,0x67,0x86,0x77,0x86,0x99,0xa8,
0x78,0x87,0x87,0x77,0x77,0x99,0x76,0x86,
0x76,0x46,0xda,0x98,0x87,0x66,0x8c,0xa8,
0x76,0x65,0x06,0xa6,0xbd,0xca,0x65,0x76,
0x47,0x99,0x76,0x6b,0x96,0x69,0x76,0x68,
0xa7,0x65,0x69,0x85,0xa9,0xa8,0x8a,0x76,
0x77,0x77,0x88,0x98,0x77,0x77,0x52,0x8d,
0xb8,0x8a,0x85,0x47,0x88,0x87,0x88,0x76,
0x56,0x95,0x5e,0xb9,0x97,0xa7,0x57,0x77,
0x88,0x77,0x79,0xa7,0x98,0x86,0x45,0x57,
0x6b,0x7b,0xb9,0xb7,0x77,0x66,0x76,0x66,
0x77,0x59,0x68,0x98,0x99,0x8a,0x78,0x88,
0x66,0x68,0x88,0x87,0x76,0x48,0x84,0xa9,
0x88,0x87,0x97,0x69,0x77,0x88,0x77,0x78,
0x89,0x79,0x88,0x76,0x87,0x77,0x78,0x87,
0x78,0x78,0x79,0x87,0x86,0x7a,0x68,0x77,
0x77,0x86,0x87,0x78,0x88,0x77,0x77,0x87,
0x88,0x79,0x88,0x97,0x87,0x77,0x77,0x67,
0x76,0x77,0x87,0x78,0x78,0x87,0x78,0x88,
0x89,0x98,0x88,0x89,0x87,0x77,0x77,0x77,
0x78,0x76,0x77,0x77,0x77,0x88,0x87,0x87,
0x88,0x78,0x88,0x88,0x88,0x88,0x88,0x87,
0x77,0x76,0x77,0x77,0x77,0x77,0x78,0x88,
0x88,0x88,0x88,0x87,0x87,0x77,0x77,0x88,
0x88,0x98,0x87,0x88,0x87,0x77,0x77,0x87,
0x77,0x87,0x88,0x88,0x77,0x77,0x87,0x77,
0x78,0x77,0x89,0x88,0x98,0x88,0x77,0x77,
0x77,0x76,0x67,0x67,0x87,0x78,0x88,0x87,
0x78,0x87,0x88,0x87,0x77,0x88,0x88,0x98,
0x98,0x87,0x87,0x77,0x77,0x76,0x78,0x77,
0x88,0x87,0x88,0x88,0x77,0x87,0x77,0x87,
0x87,0x78,0x88,0x88,0x88,0x87,0x88,0x77,
0x77,0x77,0x77,0x88,0x77,0x77,0x77,0x77,
0x78,0x88,0x88,0x87,0x78,0x87,0x88,0x78,
0x87,0x88,0x88,0x88,0x88,0x87,0x87,0x78,
0x87,0x77,0x88,0x87,0x78,0x88,0x77,0x87,
0x77,0x77,0x87,0x77,0x88,0x87,0x78,0x88,
0x78,0x87,0x77,0x78,0x77,0x67,0x87,0x78,
0x88,0x88,0x88,0x87,0x78,0x77,0x78,0x87,
0x87,0x88,0x88,0x88,0x88,0x87,0x87,0x77,
0x77,0x67,0x77,0x88,0x78,0x88,0x88,0x97,
0x78,0x78,0x87,0x77,0x89,0x88,0x78,0x87,
0x78,0x87,0x77,0x77,0x86,0x77,0x88,0x88,
0x88,0x87,0x88,0x87,0x88,0x77,0x88,0x88,
0x88,0x98,0x88,0x88,0x87,0x78,0x78,0x67,
0x77,0x77,0x77,0x98,0x78,0x88,0x78,0x87,
0x77,0x68,0x87,0x77,0x98,0x87,0x76,0x96,
0x87,0x87,0x87,0x79,0x68,0x77,0x87,0x87,
0x87,0x89,0x69,0x87,0x86,0x87,0x89,0x89,
0x79,0x98,0x76,0x88,0x69,0x86,0x77,0x87,
0x87,0x79,0x78,0x96,0x97,0x69,0x78,0x86,
0x78,0x59,0x98,0x78,0x88,0x86,0x88,0x68,
0x97,0x56,0x68,0x85,0x65,0xa6,0x46,0x7a,
0x75,0x79,0x76,0x67,0x98,0x97,0x99,0x6a,
0x6b,0x86,0xc5,0xa5,0xa7,0x57,0x78,0x4a,
0x48,0x56,0x8a,0x87,0x8a,0x78,0x88,0x78,
0xa8,0x4a,0x96,0x79,0x6a,0x87,0x67,0x86,
0x86,0x69,0x67,0xa8,0x88,0x89,0x7a,0x86,
0x85,0x88,0x74,0x45,0x87,0x38,0x67,0x86,
0xa7,0x9b,0xa8,0xba,0x78,0x89,0x55,0x96,
0x74,0x75,0x67,0x67,0x69,0x97,0x8d,0xa8,
0xa8,0xaa,0x59,0x69,0x44,0x77,0x84,0x66,
0x65,0x49,0x77,0x98,0xcb,0x7a,0xcb,0x58,
0x98,0x33,0x46,0x60,0x49,0xc5,0x9b,0xfc,
0x6d,0xd8,0x76,0x58,0x04,0x72,0x7a,0x16,
0xb8,0x58,0xba,0x87,0xde,0x9a,0xca,0x66,
0x68,0x41,0x11,0x95,0x06,0xea,0x7e,0xfc,
0x8a,0xa7,0x43,0x43,0x12,0x87,0x8a,0xca,
0x9c,0x67,0x65,0x43,0x67,0x8b,0xcc,0xb9,
0x99,0x46,0x85,0x65,0x5b,0x99,0x82,0x98,
0x36,0xa7,0xab,0xcb,0xb9,0xa7,0x44,0x67,
0x35,0x67,0x8b,0x58,0x89,0xa8,0x6b,0xb9,
0x78,0x78,0x64,0x55,0x77,0x67,0x79,0x76,
0x58,0xdb,0x8b,0xb9,0x47,0x66,0x47,0x99,
0x67,0xb9,0x76,0x13,0x67,0x6c,0xec,0xca,
0x89,0x63,0x43,0x44,0xcb,0x87,0xca,0x98,
0x75,0x05,0x34,0x6b,0xef,0xbb,0xc9,0x35,
0x12,0x49,0x6a,0xbb,0x98,0x89,0x20,0x06,
0x87,0xef,0xd9,0xa9,0x85,0x23,0x77,0x47,
0xec,0x89,0xa8,0x85,0x03,0x86,0x48,0xfd,
0x97,0xb9,0x52,0x36,0x67,0x7b,0xfa,0x88,
0x98,0x64,0x34,0x79,0x76,0x9d,0xc8,0x87,
0x97,0x34,0x9a,0x87,0x89,0x86,0x89,0x62,
0x68,0x44,0x9b,0xea,0x89,0xa5,0x34,0x76,
0x8b,0x98,0x78,0x74,0x79,0xb8,0x68,0x88,
0x45,0x53,0x5d,0xba,0x9b,0x97,0x45,0x87,
0x85,0x8b,0x98,0x77,0x65,0x56,0x85,0x19,
0xfc,0x68,0xca,0x63,0x6a,0x65,0x67,0xa8,
0x98,0x9a,0x56,0x36,0x51,0x7d,0xf9,0x8b,
0x97,0x34,0x78,0x78,0x89,0xa8,0x79,0x86,
0x56,0x48,0x85,0x7c,0xc8,0x8a,0x98,0x46,
0x76,0x68,0x88,0x99,0xa7,0x87,0x66,0x36,
0x86,0x37,0xda,0x79,0xa9,0x53,0x6b,0x77,
0x8a,0xa8,0x78,0x96,0x47,0x76,0x8a,0x63,
0x8a,0x93,0x7e,0xb4,0x7b,0x96,0x58,0x77,
0x58,0xb7,0x57,0x77,0x57,0x95,0x47,0xaa,
0x98,0x9a,0x66,0x88,0x87,0x88,0x76,0x6a,
0x66,0x5a,0x87,0x98,0x93,0x54,0x39,0x9a,
0xad,0xb9,0x77,0x74,0x37,0x96,0x7c,0xa9,
0x76,0x86,0x56,0x64,0x59,0x86,0x5c,0xb9,
0x89,0xb9,0x56,0x65,0x68,0x66,0x88,0x98,
0x88,0x87,0x57,0x65,0x66,0x97,0x6b,0xba,
0x9a,0x89,0x62,0x34,0x86,0xac,0xcc,0x88,
0x86,0x55,0x44,0x78,0x88,0xba,0x97,0x36,
0x44,0x58,0xad,0xeb,0xb9,0x99,0x45,0x33,
0x49,0x79,0xa9,0xc7,0x78,0x86,0x24,0x4b,
0x86,0xeb,0xc9,0x89,0x75,0x46,0x56,0x39,
0x98,0xaa,0xc8,0x57,0x65,0x67,0x9a,0xa6,
0xa9,0x65,0x09,0xc4,0x9b,0xaa,0x88,0xb7,
0x56,0x67,0x56,0x97,0x79,0x8a,0x96,0x87,
0x76,0x53,0x49,0x67,0xb9,0xca,0x8c,0x96,
0x76,0x57,0x68,0x95,0x99,0x89,0x88,0x76,
0x87,0x86,0x68,0x74,0x68,0x76,0x89,0xba,
0xaa,0x88,0x76,0x75,0x57,0x66,0x87,0x87,
0x78,0x77,0x98,0x77,0x78,0x97,0x88,0x78,
0x88,0x87,0x88,0x88,0x89,0x88,0x79,0x97,
0x77,0x67,0x87,0x77,0x77,0x88,0x87,0x87,
0x67,0x77,0x67,0x77,0x88,0x89,0x88,0x88,
0x88,0x88,0x88,0x88,0x98,0x77,0x77,0x76,
0x77,0x78,0x77,0x77,0x77,0x79,0x88,0x77,
0x98,0x88,0x78,0x88,0x87,0x77,0x77,0x77,
0x88,0x77,0x78,0x77,0x76,0x78,0x88,0x77,
0x88,0x88,0x78,0x78,0x77,0x88,0x77,0x78,
0x88,0x76,0x78,0x77,0x87,0x88,0x87,0x88,
0x88,0x78,0x89,0x87,0x88,0x88,0x88,0x78,
0x88,0x87,0x88,0x87,0x78,0x77,0x77,0x88,
0x87,0x88,0x88,0x87,0x87,0x87,0x77,0x66,
0x77,0x78,0x87,0x78,0x78,0x87,0x78,0x88,
0x87,0x77,0x77,0x77,0x87,0x77,0x88,0x77,
0x87,0x88,0x88,0x78,0x87,0x78,0x88,0x87,
0x78,0x87,0x78,0x88,0x98,0x77,0x77,0x77,
0x77,0x88,0x78,0x88,0x78,0x88,0x88,0x77,
0x77,0x77,0x78,0x88,0x87,0x88,0x78,0x88,
0x87,0x77,0x77,0x77,0x77,0x78,0x88,0x77,
0x88,0x78,0x88,0x77,0x77,0x88,0x78,0x88,
0x98,0x98,0x88,0x88,0x87,0x87,0x77,0x77,
0x77,0x77,0x78,0x88,0x87,0x88,0x87,0x78,
0x87,0x87,0x77,0x78,0x77,0x88,0x88,0x78,
0x87,0x77,0x87,0x78,0x77,0x77,0x87,0x88,
0x88,0x78,0x87,0x77,0x77,0x87,0x77,0x78,
0x88,0x88,0x88,0x88,0x88,0x87,0x77,0x88,
0x77,0x77,0x78,0x77,0x77,0x88,0x88,0x88,
0x77,0x87,0x87,0x77,0x88,0x77,0x87,0x78,
0x87,0x78,0x77,0x78,0x77,0x87,0x88,0x87,
0x77,0x88,0x88,0x88,0x87,0x88,0x87,0x78,
0x87,0x87,0x77,0x88,0x88,0x87,0x78,0x87,
0x78,0x77,0x87,0x77,0x77,0x78,0x87,0x88,
0x88,0x98,0x77,0x77,0x78,0x87,0x88,0x78,
0x77,0x77,0x77,0x88,0x87,0x67,0x78,0x78,
0x77,0x77,0x77,0x78,0x88,0x88,0x98,0x77,
0x78,0x88,0x88,0x88,0x77,0x88,0x78,0x87,
0x87,0x77,0x78,0x78,0x77,0x88,0x77,0x78,
0x88,0x98,0x88,0x77,0x77,0x77,0x77,0x78,
0x87,0x77,0x78,0x88,0x87,0x88,0x77,0x77,
0x77,0x77,0x78,0x77,0x88,0x88,0x97,0x78,
0x87,0x88,0x87,0x88,0x78,0x87,0x78,0x88,
0x88,0x77,0x87,0x77,0x77,0x88,0x78,0x78,
0x88,0x88,0x98,0x78,0x77,0x77,0x67,0x77,
0x78,0x77,0x88,0x77,0x87,0x78,0x87,0x77,
0x77,0x77,0x78,0x77,0x88,0x88,0x88,0x88,
0x77,0x87,0x77,0x88,0x88,0x88,0x88,0x78,
0x87,0x78,0x77,0x77,0x77,0x77,0x88,0x78,
0x89,0x88,0x87,0x88,0x77,0x77,0x77,0x77,
0x87,0x78,0x88,0x78,0x77,0x87,0x77,0x77,
0x77,0x77,0x88,0x78,0x88,0x78,0x88,0x78,
0x88,0x87,0x78,0x78,0x88,0x88,0x88,0x78,
0x78,0x77,0x77,0x77,0x77,0x78,0x87,0x78,
0x87,0x88,0x88,0x88,0x77,0x87,0x77,0x78,
0x78,0x77,0x87,0x77,0x78,0x78,0x87,0x88,
0x77,0x78,0x78,0x87,0x88,0x87,0x88,0x78,
0x88,0x87,0x87,0x89,0x88,0x88,0x87,0x87,
0x88,0x77,0x88,0x77,0x77,0x88,0x78,0x87,
0x77,0x87,0x87,0x87,0x77,0x77,0x76,0x88,
0x77,0x87,0x78,0x77,0x87,0x77,0x77,0x78,
0x77,0x88,0x87,0x87,0x78,0x88,0x88,0x87,
0x87,0x78,0x78,0x88,0x87,0x88,0x88,0x88,
0x78,0x76,0x77,0x77,0x78,0x88,0x77,0x87,
0x88,0x88,0x88,0x87,0x77,0x77,0x77,0x88,
0x77,0x77,0x88,0x88,0x88,0x77,0x77,0x77,
0x78,0x88,0x78,0x88,0x88,0x88,0x89,0x77,
0x87,0x87,0x78,0x88,0x78,0x88,0x88,0x88,
0x88,0x77,0x77,0x77,0x78,0x87,0x78,0x78,
0x88,0x88,0x88,0x77,0x77,0x77,0x77,0x77,
0x77,0x78,0x88,0x88,0x88,0x87,0x77,0x77,
0x78,0x77,0x77,0x78,0x88,0x88,0x88,0x77,
0x78,0x77,0x78,0x87,0x77,0x78,0x98,0x88,
0x88,0x87,0x78,0x87,0x88,0x77,0x77,0x78,
0x98,0x88,0x88,0x87,0x78,0x87,0x87,0x77,
0x77,0x78,0x87,0x88,0x87,0x77,0x78,0x77,
0x88,0x87,0x77,0x78,0x87,0x88,0x87,0x87,
0x88,0x77,0x88,0x87,0x77,0x88,0x88,0x88,
0x87,0x87,0x78,0x77,0x88,0x87,0x77,0x88,
0x88,0x87,0x77,0x87,0x78,0x87,0x87,0x87,
0x77,0x78,0x88,0x77,0x77,0x77,0x77,0x77,
0x78,0x87,0x78,0x88,0x87,0x77,0x77,0x78,
0x78,0x87,0x88,0x88,0x88,0x88,0x88,0x78,
0x77,0x87,0x78,0x87,0x78,0x88,0x88,0x88,
0x87,0x78,0x77,0x88,0x78,0x87,0x78,0x88,
0x78,0x88,0x77,0x67,0x77,0x87,0x78,0x87,
0x88,0x88,0x87,0x88,0x77,0x77,0x67,0x87,
0x78,0x77,0x89,0x87,0x88,0x88,0x77,0x78,
0x77,0x87,0x87,0x77,0x88,0x87,0x87,0x87,
0x77,0x77,0x78,0x87,0x87,0x77,0x88,0x77,
0x76,0x87,0x77,0x77,0x78,0x76,0x88,0x87,
0x88,0x77,0x77,0x88,0x87,0x78,0x87,0x78,
0x87,0x88,0x88,0x87,0x77,0x87,0x88,0x78,
0x88,0x78,0x87,0x87,0x78,0x77,0x77,0x87,
0x87,0x78,0x88,0x78,0x88,0x87,0x78,0x88,
0x67,0x77,0x87,0x78,0x88,0x78,0x87,0x87,
0x68,0x88,0x78,0x77,0x87,0x78,0x88,0x78,
0x87,0x77,0x68,0x88,0x88,0x77,0x88,0x78,
0x97,0x88,0x77,0x77,0x77,0x88,0x78,0x77,
0x88,0x77,0x98,0x78,0x77,0x77,0x77,0x88,
0x77,0x77,0x87,0x78,0x77,0x86,0x77,0x87,
0x78,0x78,0x86,0x78,0x88,0x78,0x77,0x87,
0x88,0x88,0x78,0x87,0x87,0x78,0x98,0x78,
0x77,0x77,0x78,0x88,0x88,0x78,0x77,0x88,
0x88,0x88,0x78,0x87,0x88,0x78,0x88,0x88,
0x86,0x78,0x77,0x78,0x77,0x77,0x78,0x78,
0x88,0x78,0x87,0x77,0x77,0x88,0x88,0x77,
0x87,0x78,0x88,0x88,0x77,0x77,0x78,0x88,
0x88,0x77,0x88,0x78,0x88,0x88,0x66,0x77,
0x77,0x88,0x88,0x78,0x88,0x87,0x87,0x88,
0x66,0x77,0x77,0x88,0x88,0x77,0x88,0x87,
0x87,0x87,0x76,0x78,0x87,0x77,0x88,0x88,
0x88,0x88,0x77,0x87,0x87,0x77,0x88,0x77,
0x88,0x88,0x78,0x88,0x76,0x77,0x77,0x77,
0x88,0x87,0x78,0x98,0x87,0x78,0x77,0x67,
0x77,0x87,0x68,0x88,0x67,0x88,0x88,0x67,
0x87,0x77,0x88,0x78,0x77,0x88,0x76,0x88,
0x88,0x77,0x88,0x77,0x78,0x89,0x87,0x88,
0x77,0x78,0x88,0x87,0x78,0x87,0x77,0x98,
0x87,0x77,0x77,0x77,0x88,0x78,0x78,0x88,
0x77,0x89,0x77,0x76,0x77,0x77,0x89,0x88,
0x87,0x88,0x77,0x79,0x87,0x76,0x78,0x87,
0x89,0x88,0x88,0x78,0x87,0x78,0x77,0x77,
0x68,0x87,0x88,0x88,0x88,0x78,0x87,0x77,
0x78,0x77,0x77,0x98,0x78,0x89,0x88,0x87,
0x87,0x77,0x77,0x87,0x77,0x88,0x77,0x87,
0x98,0x78,0x77,0x77,0x77,0x78,0x78,0x77,
0x88,0x77,0x89,0x88,0x78,0x77,0x77,0x78,
0x87,0x78,0x77,0x87,0x88,0x97,0x77,0x87,
0x78,0x78,0x88,0x77,0x87,0x78,0x77,0x88,
0x76,0x78,0x88,0x77,0x88,0x86,0x88,0x77,
0x87,0x87,0x87,0x78,0x88,0x87,0x88,0x88,
0x78,0x87,0x78,0x77,0x78,0x77,0x88,0x87,
0x77,0x88,0x87,0x78,0x77,0x87,0x78,0x88,
0x78,0x87,0x87,0x78,0x87,0x78,0x87,0x77,
0x77,0x78,0x77,0x77,0x77,0x68,0x88,0x77,
0x88,0x77,0x77,0x78,0x88,0x88,0x78,0x88,
0x88,0x88,0x88,0x87,0x77,0x78,0x87,0x88,
0x77,0x78,0x88,0x88,0x88,0x77,0x77,0x88,
0x88,0x87,0x87,0x88,0x88,0x88,0x87,0x87,
0x77,0x78,0x87,0x88,0x78,0x78,0x88,0x87,
0x88,0x78,0x77,0x87,0x77,0x78,0x88,0x88,
0x88,0x88,0x88,0x77,0x87,0x77,0x78,0x78,
0x78,0x88,0x88,0x88,0x78,0x87,0x77,0x78,
0x78,0x77,0x88,0x78,0x88,0x88,0x87,0x77,
0x67,0x77,0x77,0x77,0x77,0x87,0x98,0x88,
0x87,0x77,0x76,0x87,0x78,0x77,0x77,0x78,
0x88,0x88,0x88,0x77,0x77,0x77,0x77,0x78,
0x78,0x77,0x88,0x88,0x88,0x87,0x77,0x87,
0x77,0x88,0x77,0x77,0x88,0x88,0x88,0x88,
0x77,0x77,0x77,0x78,0x78,0x88,0x88,0x78,
0x89,0x77,0x88,0x88,0x77,0x78,0x66,0x88,
0x79,0x77,0x88,0x77,0x88,0x99,0x66,0x88,
0x77,0x86,0x89,0x67,0x98,0x67,0x87,0x89,
0x67,0x88,0x77,0x87,0x79,0x77,0x88,0x77,
0x88,0x89,0x77,0x87,0x66,0x77,0x79,0x76,
0x87,0x77,0x88,0x89,0x67,0x88,0x67,0x87,
0x78,0x77,0x97,0x78,0x77,0x99,0x78,0x98,
0x67,0x78,0x88,0x68,0x87,0x68,0x88,0x8a,
0x77,0x88,0x77,0x78,0x88,0x77,0x87,0x68,
0x97,0x89,0x87,0x97,0x78,0x76,0x88,0x67,
0x87,0x67,0x88,0x78,0x77,0x87,0x57,0x87,
0x79,0x77,0x98,0x67,0x87,0x79,0x76,0x98,
0x68,0x97,0x79,0x87,0x98,0x57,0x97,0x79,
0x76,0x88,0x58,0x97,0x79,0x87,0x98,0x67,
0xa8,0x79,0x87,0x88,0x67,0x86,0x7a,0x76,
0x98,0x57,0x97,0x79,0x77,0x88,0x59,0x96,
0x79,0x76,0x87,0x68,0x97,0x89,0x77,0x96,
0x58,0x96,0x79,0x77,0x97,0x68,0x86,0x78,
0x77,0x97,0x69,0x96,0x79,0x89,0xa8,0x6a,
0x97,0x99,0x77,0x87,0x59,0x86,0x79,0x88,
0x87,0x58,0x87,0x88,0x78,0x88,0x69,0x65,
0x78,0x68,0xa6,0x79,0x76,0x88,0x79,0x99,
0x89,0x86,0x88,0x67,0x87,0x68,0x87,0x78,
0x88,0x87,0x78,0x76,0x89,0x88,0x98,0x88,
0x66,0x77,0x78,0x87,0x89,0x76,0x77,0x88,
0x88,0x89,0x87,0x87,0x77,0x78,0x79,0x97,
0x78,0x88,0x87,0x78,0x87,0x88,0x88,0x88,
0x77,0x66,0x66,0x78,0x87,0x78,0x87,0x66,
0x88,0x89,0x89,0x98,0x88,0x76,0x57,0x67,
0x89,0x87,0x89,0x88,0x77,0x99,0x77,0x88,
0x88,0x87,0x77,0x66,0x77,0x99,0x67,0x88,
0x66,0x78,0x88,0x88,0x88,0x88,0x86,0x78,
0x66,0x7a,0x86,0x88,0x97,0x77,0x99,0x88,
0xa8,0x79,0x97,0x66,0x76,0x67,0x88,0x76,
0x79,0x76,0x78,0x88,0x89,0x78,0x87,0x66,
0x56,0x76,0x78,0x98,0x77,0x88,0x88,0x78,
0x88,0x99,0x78,0x98,0x77,0x78,0x77,0x78,
0x97,0x68,0x87,0x77,0x87,0x98,0x78,0x88,
0x88,0x66,0x88,0x67,0x87,0x67,0x77,0x87,
0x67,0x99,0x89,0x76,0x98,0x76,0x77,0x77,
0x76,0x98,0x67,0x88,0x88,0x77,0x99,0x98,
0x78,0x77,0x55,0x78,0x78,0x89,0x88,0x77,
0x97,0x78,0x98,0x9a,0x87,0x88,0x87,0x77,
0x88,0x76,0x88,0x77,0x88,0x88,0x77,0x87,
0x89,0x78,0x88,0x76,0x76,0x78,0x77,0x97,
0x68,0x86,0x78,0x88,0x99,0x87,0x77,0x78,
0x76,0x98,0x67,0x77,0x77,0x79,0x76,0x77,
0x77,0x9a,0x77,0x87,0x77,0x76,0x77,0x78,
0x86,0x68,0x87,0x78,0x78,0x98,0x88,0x77,
0x88,0x88,0x88,0x88,0x77,0x78,0x88,0xa7,
0x89,0x98,0x89,0x87,0x87,0x88,0x66,0x77,
0x67,0x87,0x67,0x88,0x77,0x89,0x99,0x88,
0x87,0x78,0x77,0x88,0x77,0x87,0x77,0x88,
0x88,0x77,0x99,0x88,0x66,0x67,0x75,0x77,
0x78,0x76,0x77,0x87,0x78,0x87,0x88,0x78,
0x87,0x77,0x88,0x98,0x78,0x97,0x77,0x78,
0x99,0x77,0x88,0x87,0x88,0x88,0x67,0x87,
0x76,0x77,0x77,0x66,0x77,0x97,0x78,0x9a,
0x87,0x88,0x87,0x78,0x99,0x98,0x87,0x88,
0x77,0x9a,0x98,0x87,0x87,0x67,0x87,0x78,
0x66,0x87,0x65,0x67,0x77,0x76,0x87,0x76,
0x78,0x88,0x86,0x79,0x87,0x89,0x99,0x86,
0x68,0x77,0x88,0x98,0x98,0x78,0x87,0x67,
0x88,0x86,0x57,0x76,0x67,0x88,0x89,0x87,
0x88,0x77,0x9a,0x97,0x78,0x88,0x88,0x99,
0x88,0x77,0x78,0x89,0x88,0x86,0x67,0x77,
0x77,0x77,0x88,0x76,0x66,0x66,0x67,0x88,
0x87,0x76,0x67,0x88,0x88,0x88,0x77,0x88,
0x87,0x88,0x86,0x78,0x89,0x99,0x99,0x88,
0x87,0x67,0x66,0x78,0x98,0x88,0x87,0x77,
0x87,0x87,0x87,0x67,0x89,0x88,0x98,0x98,
0x89,0x78,0x87,0x88,0x88,0x98,0x77,0x74,
0x66,0x77,0x97,0x98,0x98,0x97,0x88,0x76,
0x77,0x66,0x65,0x46,0x52,0x47,0x76,0x8a,
0xba,0xcc,0xa9,0x78,0x76,0x57,0x85,0x46,
0x64,0x56,0x78,0xbc,0x9b,0xcb,0x88,0x78,
0x56,0x77,0x67,0x75,0x25,0x86,0x47,0xcd,
0x7b,0xde,0x9a,0xb9,0x57,0x86,0x58,0x99,
0x32,0x77,0x44,0x9c,0xb8,0xde,0xb7,0xbb,
0x62,0x68,0x73,0x67,0x33,0x44,0x33,0x8a,
0xa6,0xbe,0xc8,0x9a,0xa5,0x68,0x83,0x55,
0x44,0x85,0x55,0xa9,0xca,0xca,0xca,0xa8,
0x95,0x55,0x64,0x74,0x15,0x54,0x38,0x9a,
0xac,0xde,0xab,0x99,0x67,0x77,0x67,0x85,
0x14,0x45,0x39,0xac,0xbf,0xfc,0x9a,0xb7,
0x58,0x85,0x22,0x21,0x63,0x25,0x9b,0x99,
0xdd,0xb9,0x99,0x77,0x66,0x55,0x74,0x06,
0x37,0x29,0x8c,0xbe,0xcd,0xad,0xb8,0x57,
0x66,0x55,0x52,0x52,0x43,0x89,0xa9,0xed,
0xdb,0xb9,0x97,0x65,0x56,0x53,0x33,0x67,
0x59,0xaa,0x9a,0xdc,0xac,0xb8,0x98,0x87,
0x55,0x33,0x28,0x34,0x47,0x9b,0xae,0xc8,
0xcc,0x76,0x55,0x64,0x36,0x42,0x37,0x55,
0x77,0xaa,0x9d,0xda,0xba,0xa7,0x65,0x76,
0x55,0x41,0x86,0x84,0x99,0x88,0xab,0xba,
0xb9,0x98,0x76,0x64,0x68,0x64,0x88,0x56,
0x89,0x99,0x9c,0xb9,0x99,0x88,0x78,0x76,
0x89,0x87,0x48,0x88,0x98,0x99,0x56,0x77,
0x77,0x78,0x88,0x66,0x66,0x66,0x87,0x78,
0x67,0x76,0x77,0x66,0x89,0xa8,0x78,0x88,
0x78,0x9a,0x88,0x98,0x78,0x88,0x77,0x76,
0x55,0x67,0x89,0x78,0x88,0x78,0x88,0x78,
0x88,0x98,0x88,0x88,0x78,0x87,0x78,0x88,
0x77,0x77,0x89,0x77,0x88,0x88,0x98,0x89,
0x87,0x87,0x77,0x77,0x77,0x76,0x65,0x77,
0x66,0x56,0x66,0x78,0x89,0x77,0x98,0x89,
0x99,0x78,0x76,0x78,0x88,0x88,0x87,0x79,
0x87,0x78,0x77,0x88,0x87,0x67,0x77,0x78,
0x88,0x78,0x87,0x77,0x99,0x99,0x87,0x77,
0x78,0x88,0x88,0x86,0x78,0x87,0x79,0x88,
0x99,0x98,0x88,0x77,0x77,0x76,0x77,0x66,
0x67,0x87,0x65,0x86,0x56,0x77,0x68,0x96,
0x78,0x98,0x87,0x77,0x66,0x78,0x98,0x89,
0x77,0x98,0x88,0x89,0x87,0x78,0x86,0x78,
0x68,0x88,0x98,0x88,0x88,0x78,0x87,0x87,
0x87,0x77,0x79,0x99,0x98,0x87,0x68,0x97,
0x88,0x88,0x99,0x98,0x88,0x77,0x66,0x66,
0x67,0x78,0x77,0x87,0x76,0x77,0x66,0x76,
0x88,0x77,0x77,0x89,0x86,0x57,0x86,0x68,
0x79,0x88,0x66,0x68,0x89,0x99,0xa9,0x87,
0x78,0x77,0x89,0x89,0xa8,0x67,0x88,0x78,
0x89,0x96,0x59,0x66,0x89,0xaa,0x89,0x76,
0x77,0x87,0x88,0x88,0x68,0x98,0x87,0x98,
0x86,0x67,0x66,0x88,0x87,0x98,0x76,0x65,
0x67,0x78,0x87,0x88,0x66,0x77,0x77,0x78,
0x78,0x76,0x76,0x67,0x88,0x79,0xa9,0x88,
0x88,0x88,0x88,0x97,0x66,0x77,0x89,0x88,
0x79,0x97,0x78,0x75,0x78,0x78,0x98,0x89,
0x96,0x78,0x98,0x97,0x66,0x78,0x88,0xa9,
0x88,0x76,0x77,0x78,0x88,0x78,0x76,0x77,
0x76,0x68,0x77,0x77,0x56,0x77,0x68,0x88,
0x79,0x75,0x68,0x88,0x75,0x67,0x87,0x78,
0x8a,0xa8,0x79,0xa8,0x88,0x98,0x78,0x77,
0x99,0x87,0x79,0x99,0x87,0x77,0x67,0x89,
0x89,0xa9,0x78,0x77,0x88,0x77,0x78,0x89,
0x98,0x78,0x87,0x77,0x76,0x89,0x77,0x75,
0x67,0x76,0x68,0x67,0x77,0x77,0x58,0x57,
0x86,0x66,0x88,0x76,0x67,0x96,0x55,0x66,
0x89,0x87,0x89,0x88,0x88,0x99,0x99,0x99,
0x75,0x78,0x88,0x98,0x8a,0xa7,0x76,0x77,
0x77,0x88,0xa9,0x78,0x87,0x78,0x97,0x87,
0x68,0x98,0x88,0x89,0x99,0x76,0x68,0x89,
0x98,0x66,0x76,0x76,0x67,0x98,0x97,0x75,
0x67,0x76,0x67,0x78,0x87,0x68,0x77,0x66,
0x75,0x57,0x88,0x97,0x66,0x99,0x88,0x88,
0x99,0x97,0x67,0x76,0x98,0x89,0x89,0x98,
0x76,0x78,0x78,0x79,0x89,0x97,0x89,0x89,
0x99,0x77,0x87,0x58,0x97,0x66,0x77,0x76,
0x78,0x9a,0x97,0x76,0x67,0x75,0x88,0x88,
0x98,0x76,0x76,0x67,0x68,0x88,0x87,0x78,
0x56,0x78,0x66,0x66,0x78,0x77,0x76,0x99,
0x88,0x98,0x88,0x89,0x87,0x78,0x98,0x88,
0x98,0xa8,0x76,0x88,0x77,0x88,0x97,0xa9,
0x99,0x77,0x98,0x88,0x86,0x7a,0x87,0x75,
0x68,0x88,0x78,0x97,0x77,0x67,0x86,0x77,
0x87,0x77,0x87,0x87,0x56,0x77,0x66,0x76,
0x89,0x76,0x56,0x68,0x65,0x68,0x77,0x89,
0x76,0x68,0x69,0x98,0x99,0x98,0x67,0x77,
0xa7,0x79,0x89,0x87,0x87,0x8a,0x88,0xb8,
0x77,0x7a,0x8a,0x78,0x99,0x86,0x67,0x78,
0xa8,0x87,0x69,0x69,0x78,0xa9,0x99,0x77,
0x57,0x87,0x88,0x89,0x87,0x65,0x54,0x67,
0x85,0x67,0x69,0x87,0x67,0x78,0x77,0xa5,
0x54,0x67,0x85,0x57,0xbb,0x76,0xac,0xb8,
0x88,0xaa,0x62,0x55,0x76,0x34,0x9d,0x97,
0x9b,0xe9,0x88,0xbc,0xa5,0x02,0x98,0x58,
0x68,0xba,0x57,0xa8,0x53,0x58,0xdc,0x57,
0xec,0x83,0x7a,0xb7,0x30,0x15,0x62,0x4d,
0xee,0xbb,0xeb,0x54,0x55,0x10,0x05,0x89,
0x59,0xfb,0x9b,0x84,0x33,0x05,0xa6,0x8e,
0xed,0xc8,0x77,0x62,0x39,0x85,0x59,0xdc,
0xc8,0x3b,0x64,0x87,0x6c,0xea,0xbb,0x79,
0xa4,0x23,0x52,0x44,0xde,0xbc,0xd9,0x96,
0x10,0x58,0x55,0xad,0xdc,0x8a,0xb9,0x40,
0x02,0x31,0x38,0xde,0xfb,0xac,0xa4,0x35,
0x53,0x54,0x56,0x98,0x9a,0x96,0x78,0x63,
0x58,0x99,0x9c,0xea,0x78,0xa9,0x43,0x57,
0x70,0x1a,0xf7,0x56,0xcf,0xb5,0x8c,0x94,
0x36,0x76,0x78,0xa9,0x57,0xa9,0x54,0x79,
0x65,0x9c,0xca,0x8a,0xb8,0x55,0x79,0x78,
0x96,0x52,0x6a,0x65,0x6b,0xf9,0x57,0xa9,
0x44,0x66,0x76,0x69,0x85,0x79,0x8a,0x96,
0x77,0x65,0x64,0x57,0x8a,0xdb,0xaa,0xa8,
0x86,0x54,0x44,0x79,0xa9,0xac,0x98,0x79,
0x87,0x23,0x35,0x9b,0xcd,0xc9,0x88,0x87,
0x66,0x55,0x68,0x77,0x74,0x9b,0x85,0x6d,
0xc9,0x79,0xa8,0x56,0x78,0x54,0x88,0x87,
0x78,0x87,0x64,0x47,0x95,0x6e,0xd6,0x7a,
0xa8,0x75,0x76,0x34,0x87,0x57,0x85,0x2a,
0xa6,0xaa,0xdc,0x75,0x8a,0x66,0x77,0x86,
0x79,0xa8,0x89,0x89,0x95,0x68,0x88,0x64,
0x59,0x86,0x79,0xa9,0x87,0x9b,0x75,0x89,
0x77,0x65,0x88,0x99,0x77,0x67,0x76,0x63,
0x75,0x59,0x9c,0xa9,0xaa,0x96,0x45,0x76,
0x56,0x77,0x99,0x96,0x67,0x85,0x45,0x57,
0x99,0x9c,0xb7,0xa9,0x56,0x56,0x77,0x8b,
0xa8,0x98,0x57,0x75,0x35,0x9b,0xae,0xdb,
0xa8,0x87,0x55,0x56,0x89,0x78,0x88,0x87,
0x66,0x86,0x96,0x58,0x89,0x42,0x6c,0x79,
0xbc,0xc7,0x66,0x65,0x64,0x48,0x7c,0x87,
0x5b,0x77,0x77,0x46,0x48,0x65,0x4b,0xb7,
0x9b,0xb9,0x88,0xb6,0x54,0x83,0x37,0x98,
0xaa,0xaa,0x99,0x04,0x41,0x7b,0xab,0xfe,
0xb7,0x9a,0x85,0x57,0x65,0x67,0x98,0xca,
0x86,0x7a,0x64,0x47,0x94,0x6b,0xd9,0x99,
0xa7,0x57,0x76,0x67,0x66,0x45,0x86,0x67,
0xb9,0x86,0x98,0x65,0x4c,0x87,0x8a,0xb7,
0x98,0x85,0x59,0x76,0x69,0x95,0x67,0x99,
0x65,0x3a,0xa8,0x87,0xba,0x76,0x99,0x77,
0x6a,0x6a,0xa6,0x87,0x78,0x56,0x50,0x7c,
0x88,0xcc,0xa9,0x86,0xa5,0x56,0x86,0x79,
0x7b,0xa7,0x49,0x83,0x66,0x75,0x3a,0xb8,
0x89,0xca,0x48,0x95,0x78,0x85,0x77,0x86,
0x42,0x58,0x97,0x6e,0xd8,0x9a,0x77,0x86,
0x55,0x86,0x86,0xa7,0x77,0x89,0x67,0x98,
0x76,0x96,0x55,0xaf,0x88,0xcf,0xa5,0x77,
0x44,0x66,0x66,0x78,0x78,0x57,0x87,0xa8,
0xbb,0xba,0xaa,0x74,0x48,0x66,0x68,0x75,
0x78,0x62,0x27,0xa4,0x1d,0xf5,0xbf,0x97,
0x86,0x76,0x36,0x54,0x35,0x9a,0x9b,0xaa,
0x87,0x94,0x36,0x45,0x89,0xbb,0xcb,0xa9,
0x76,0x76,0x26,0x76,0xa8,0xa7,0x9b,0x55,
0x88,0xa5,0x8a,0x96,0x76,0x67,0x89,0xa9,
0x89,0x97,0x32,0x48,0xb1,0x5f,0xb6,0xcd,
0x66,0x84,0x47,0x53,0x57,0x9a,0x98,0xac,
0x97,0x86,0x43,0x41,0x29,0xd5,0xae,0xb9,
0xaa,0x97,0x65,0x75,0x47,0x88,0x98,0x9b,
0x98,0x65,0x43,0x25,0x78,0xcc,0xbb,0xaa,
0x99,0x86,0x55,0x22,0x33,0x8a,0x69,0xdc,
0x99,0xb8,0x78,0x87,0x67,0x88,0x78,0x97,
0x98,0x66,0x48,0x85,0x89,0x99,0x88,0x88,
0x79,0x86,0x97,0x67,0x12,0x98,0x38,0xf9,
0x5b,0xb7,0x88,0x77,0x66,0x76,0x77,0x98,
0x54,0x9b,0x79,0xba,0x79,0x95,0x76,0x89,
0x87,0x88,0x68,0x76,0x87,0x54,0x9a,0x8a,
0xbb,0x77,0x87,0x65,0x87,0x76,0x78,0x54,
0x9a,0x58,0xd9,0x9a,0xa7,0x75,0x25,0x64,
0x67,0x99,0x87,0xab,0x93,0x25,0x52,0x7d,
0xb9,0xec,0x76,0x88,0x62,0x14,0x76,0x8b,
0xcc,0xaa,0x77,0x82,0x55,0x68,0xea,0xbc,
0x88,0x98,0x75,0x45,0x55,0x57,0xa9,0x89,
0xbb,0x78,0x98,0x46,0x87,0x67,0xa9,0x65,
0x29,0xd3,0x3c,0xf8,0x9c,0xa7,0x78,0x75,
0x33,0x43,0x6a,0xc9,0xbc,0x88,0x65,0x77,
0x13,0x6b,0x77,0xbe,0x97,0x89,0x54,0x57,
0x64,0x47,0x76,0x7c,0xe8,0x9d,0x76,0x66,
0x67,0x55,0x87,0x79,0x67,0xab,0x76,0x87,
0x74,0x59,0x76,0x9c,0xa8,0x99,0x97,0x57,
0x76,0x58,0x60,0x7f,0x96,0xcc,0x9a,0x98,
0x97,0x56,0x75,0x56,0x75,0x58,0x88,0x65,
0xed,0x98,0xb7,0x46,0x76,0x66,0x58,0x84,
0x68,0x46,0xb7,0x4a,0xca,0xab,0x89,0x97,
0x69,0x84,0x68,0x74,0x21,0x8b,0x54,0xef,
0x98,0xba,0x84,0x66,0x63,0x56,0x66,0x9a,
0x98,0xb7,0x87,0x68,0x75,0x3b,0xc9,0x7c,
0xc7,0x68,0x77,0x55,0x54,0x56,0x8a,0xaa,
0x8a,0x76,0x77,0x67,0x78,0x88,0x77,0x88,
0x77,0x75,0x34,0x66,0x79,0xba,0xcb,0xa8,
0x87,0x86,0x66,0x86,0x76,0x79,0xa8,0x89,
0x86,0x97,0x77,0x56,0x9d,0x87,0x9a,0x77,
0x79,0x76,0x66,0x87,0x78,0x97,0x88,0xa9,
0x88,0x88,0x76,0x88,0x76,0x87,0x67,0x76,
0x88,0x88,0x9a,0x87,0x77,0x56,0x64,0x87,
0x98,0x78,0x86,0x77,0x86,0x57,0x86,0x68,
0x8c,0x97,0xa9,0x56,0x87,0x77,0x76,0x76,
0x9b,0x67,0x99,0x88,0x88,0x68,0x78,0x97,
0x79,0x89,0x89,0x37,0x57,0x78,0x89,0x77,
0x88,0xa9,0x88,0x99,0x66,0x8a,0x68,0x77,
0x67,0x78,0x77,0x98,0x98,0x98,0x95,0x87,
0x78,0x57,0x78,0x87,0x67,0x84,0x77,0x98,
0x66,0x98,0xa9,0x78,0x8b,0x66,0x88,0x85,
0x67,0x88,0x87,0x88,0x85,0x88,0x98,0x78,
0x88,0x97,0x67,0x78,0x88,0x67,0x57,0x69,
0xa9,0x77,0x88,0x99,0x88,0x79,0x79,0x77,
0x86,0x65,0x66,0x77,0x88,0x88,0x68,0x97,
0x77,0x76,0x87,0x57,0x79,0x77,0x78,0x66,
0x68,0x87,0x76,0x88,0x89,0x96,0x78,0x88,
0x89,0x87,0x87,0x88,0x78,0x89,0x97,0x77,
0x69,0x97,0x77,0x98,0x79,0x78,0x77,0x87,
0x67,0x79,0x98,0x86,0x78,0x99,0x97,0x69,
0x88,0x77,0x77,0x67,0x56,0x66,0x99,0x97,
0x77,0x77,0x77,0x76,0x87,0x68,0x98,0x87,
0x88,0x65,0x56,0x97,0x78,0x78,0x79,0x97,
0x69,0x88,0x88,0x77,0x87,0x87,0x77,0x89,
0x86,0x76,0x78,0x97,0x88,0x99,0x89,0x87,
0x78,0x78,0x77,0x78,0x78,0x77,0x77,0x88,
0x96,0x78,0x99,0x88,0x86,0x76,0x67,0x77,
0x88,0xa9,0x88,0x77,0x78,0x66,0x77,0x89,
0x88,0x77,0x96,0x66,0x57,0x78,0x87,0x87,
0x78,0x86,0x69,0x97,0x88,0x78,0x87,0x77,
0x77,0x87,0x98,0x77,0x67,0x88,0x87,0x88,
0x98,0x98,0x77,0x87,0x87,0x87,0x68,0x88,
0x87,0x88,0x86,0x69,0xa8,0x88,0x86,0x66,
0x77,0x87,0x88,0x98,0x88,0x66,0x88,0x65,
0x78,0x88,0x99,0x87,0x87,0x76,0x67,0x77,
0x78,0x97,0x88,0x87,0x88,0x88,0x99,0x98,
0x78,0x78,0x77,0x88,0x87,0x78,0x68,0x79,
0x77,0x88,0x78,0x87,0x88,0x79,0x89,0x66,
0x77,0x88,0x97,0x79,0x67,0x68,0x87,0x88,
0x87,0x67,0x67,0x67,0x88,0x88,0x87,0x66,
0x77,0x46,0x78,0x88,0x88,0x88,0x77,0x77,
0x77,0x77,0x68,0x78,0x78,0x89,0x87,0x88,
0x89,0x98,0x79,0x77,0x66,0x88,0x78,0x78,
0x76,0x79,0x87,0x68,0x87,0x88,0x67,0x89,
0x89,0x66,0x78,0x87,0x88,0x78,0x8a,0x97,
0x88,0x87,0x77,0x79,0x87,0x77,0x89,0x89,
0x77,0x76,0x65,0x76,0x78,0x88,0x98,0x76,
0x77,0x88,0x86,0x86,0x97,0x77,0x77,0xa9,
0x87,0x79,0x7a,0x78,0x79,0x77,0x77,0x86,
0x78,0x67,0x57,0x87,0x84,0x58,0x97,0x86,
0x78,0xa7,0x77,0x78,0x68,0x96,0x96,0x78,
0x8b,0x87,0x86,0x98,0x87,0x87,0x76,0xa6,
0xa8,0x8a,0x78,0x68,0x58,0x96,0x79,0xa5,
0x95,0x87,0x77,0x97,0x79,0x58,0x77,0x87,
0x77,0x98,0x87,0xa8,0xb9,0x88,0x67,0x77,
0x86,0x8a,0x78,0x67,0x78,0x68,0x85,0x68,
0x78,0x59,0x47,0x86,0x88,0x6a,0x68,0x95,
0x95,0x79,0x7a,0x58,0x68,0x97,0x8a,0x87,
0x68,0x89,0x99,0x86,0x67,0x63,0x98,0x55,
0x77,0xa8,0x76,0x79,0x7b,0x97,0xb7,0xc5,
0x77,0x46,0x47,0x86,0x85,0xc8,0xac,0x5a,
0x99,0x97,0x8a,0xb8,0x58,0x64,0x93,0x77,
0x66,0x57,0x89,0xa6,0xab,0x8a,0x59,0xa9,
0x76,0x74,0x28,0x56,0x78,0x67,0x79,0x9a,
0xb9,0x99,0xba,0x99,0xa7,0xb2,0x03,0x66,
0x74,0x45,0xba,0xa6,0x8c,0xa9,0x97,0xca,
0xa6,0x45,0x60,0x43,0x73,0x35,0xaa,0xac,
0xae,0xed,0xb6,0x9b,0x6b,0x62,0x41,0x35,
0x27,0x23,0xa8,0x9b,0xaf,0xdc,0x88,0xc9,
0x86,0x72,0x00,0x66,0x31,0x29,0xdd,0xaa,
0xdf,0xdc,0x88,0x98,0x73,0x34,0x33,0x14,
0x88,0x58,0xcf,0xfb,0x8a,0xca,0x75,0x57,
0x97,0x30,0x07,0xa7,0x43,0xbf,0xe8,0x8c,
0xda,0x86,0x87,0x64,0x44,0x21,0x69,0x96,
0x5a,0xfe,0x98,0xac,0xa6,0x45,0x76,0x66,
0x62,0x16,0xca,0x51,0x9f,0xe9,0x79,0xba,
0x74,0x37,0x88,0x64,0x25,0xba,0x52,0x5e,
0xfa,0x56,0xcc,0x95,0x56,0x86,0x44,0x78,
0x77,0x77,0xa9,0x76,0x7a,0xa7,0x67,0x9a,
0x87,0x89,0x98,0x86,0x33,0x7a,0x95,0x29,
0xed,0x97,0x8a,0xb8,0x54,0x77,0x75,0x46,
0x99,0x76,0x89,0x98,0x78,0x98,0x88,0x78,
0x87,0x87,0x88,0x74,0x04,0xcb,0x61,0x8f,
0xda,0x57,0xc9,0x75,0x47,0x67,0x65,0xaa,
0x87,0x78,0x78,0x96,0x66,0x78,0x88,0x89,
0xa9,0x77,0x79,0x98,0x41,0x5c,0xa5,0x19,
0xfd,0x64,0x8b,0x88,0x44,0x88,0x75,0x69,
0x86,0x57,0xb8,0x48,0xba,0x75,0x89,0x97,
0x77,0x89,0x88,0x73,0x49,0x96,0x34,0xdc,
0x97,0x9c,0x97,0x65,0x87,0x55,0x58,0xa9,
0x64,0x9c,0x85,0x48,0xb9,0x76,0x9a,0x76,
0x78,0x98,0x86,0x68,0x5c,0x94,0x37,0xfa,
0x78,0xbd,0x86,0x67,0x74,0x46,0x68,0x86,
0x57,0xb9,0x76,0x7b,0xa6,0x5a,0xb7,0x56,
0x88,0x76,0x79,0x61,0x6c,0x63,0x39,0xd7,
0x89,0xdb,0x78,0x88,0x74,0x54,0x67,0x56,
0x69,0xb8,0x87,0xbb,0x67,0x8a,0x88,0x97,
0x76,0x58,0x98,0x51,0x6f,0x81,0x4d,0xf5,
0x5c,0xe9,0x5a,0xb8,0x64,0x67,0x55,0x67,
0x77,0x78,0xa7,0x69,0xb9,0x58,0xa8,0x88,
0x88,0x66,0x77,0x73,0x3a,0xb3,0x29,0xe8,
0x38,0xda,0x57,0xca,0x66,0x77,0x44,0x57,
0x65,0x78,0xa8,0x89,0xaa,0x86,0x9a,0x86,
0x8b,0x85,0x68,0x76,0x41,0x7d,0x41,0x7c,
0xe6,0x4e,0xf7,0x3b,0xc7,0x59,0x95,0x35,
0x67,0x66,0x79,0xa9,0x76,0x9a,0x66,0xaa,
0x77,0xa9,0x77,0x77,0x57,0x63,0x6b,0x63,
0x7d,0xb4,0x8e,0xc6,0x6b,0xa5,0x59,0x85,
0x56,0x66,0x56,0x79,0x98,0x8a,0xa9,0x78,
0xa8,0x78,0x99,0x77,0x77,0x55,0x23,0xc7,
0x07,0xfa,0x39,0xfa,0x68,0xb9,0x56,0x98,
0x54,0x67,0x76,0x66,0x79,0xa8,0x67,0xaa,
0x77,0xba,0x76,0x99,0x65,0x78,0x55,0x63,
0x5a,0x54,0xbc,0x76,0xcc,0x87,0x89,0x75,
0x68,0x85,0x56,0x76,0x54,0x6b,0xb6,0x7a,
0xb9,0x68,0xca,0x68,0xb9,0x55,0x97,0x45,
0x52,0x9b,0x38,0xdd,0x78,0xfd,0x77,0x89,
0x76,0x67,0x85,0x47,0x98,0x55,0x8c,0xa5,
0x7a,0x86,0x78,0x99,0x97,0x78,0x86,0x78,
0x65,0x50,0x4d,0x61,0x9d,0x96,0xae,0xa7,
0x78,0x85,0x45,0x76,0x44,0x6a,0x74,0x4b,
0xd8,0x58,0xba,0x65,0x79,0xa8,0x68,0x99,
0x56,0x98,0x50,0x0b,0xd3,0x28,0xed,0x68,
0xdd,0x95,0x8a,0x75,0x46,0x65,0x78,0x89,
0x77,0xab,0x75,0x98,0x78,0x88,0x9a,0x95,
0x7a,0x95,0x58,0x76,0x11,0xbd,0x53,0x8d,
0xc9,0x89,0xaa,0x65,0x67,0x73,0x36,0x87,
0x79,0xb9,0x87,0x69,0x85,0x37,0xbb,0x98,
0xab,0xa7,0x56,0x76,0x54,0x47,0x63,0x6b,
0xb8,0x89,0xdc,0x98,0x88,0x85,0x43,0x67,
0x66,0x88,0x8c,0xd9,0x54,0x8a,0x64,0x37,
0xbb,0xa8,0x8c,0xb6,0x44,0x77,0x77,0x54,
0x22,0xcf,0x52,0xaf,0xe8,0x59,0x98,0x74,
0x45,0x78,0x65,0x7b,0xcb,0x87,0x57,0x87,
0x65,0x5b,0xea,0x67,0xa9,0x65,0x55,0x79,
0x97,0x62,0x4c,0xd6,0x46,0xce,0xc8,0x56,
0x99,0x75,0x45,0x88,0x78,0x9b,0xba,0x73,
0x48,0x86,0x55,0x9b,0xca,0x97,0x78,0x86,
0x56,0x89,0x86,0x42,0x3a,0xd9,0x65,0x9d,
0xb8,0x65,0x57,0x76,0x44,0x58,0xa9,0x89,
0xb9,0x65,0x56,0x77,0x67,0x8a,0xba,0x88,
0x87,0x78,0x79,0x99,0x87,0x41,0x5c,0xda,
0x65,0x8c,0xdb,0x84,0x58,0x76,0x54,0x79,
0x9a,0xa9,0x99,0x65,0x46,0x78,0x68,0x8a,
0x99,0x89,0x98,0x87,0x77,0x77,0x87,0x52,
0x49,0xba,0x85,0x69,0xbb,0x96,0x45,0x67,
0x78,0x76,0x68,0xaa,0xa8,0x42,0x47,0x99,
0x75,0x6a,0xba,0x98,0x99,0x98,0x77,0x77,
0x65,0x33,0x5a,0xca,0x77,0x9c,0xd9,0x65,
0x66,0x66,0x77,0x67,0x89,0xaa,0x97,0x54,
0x47,0x98,0x77,0x7a,0xbb,0xa9,0x87,0x87,
0x77,0x77,0x76,0x42,0x58,0x9a,0x86,0x78,
0x9a,0xa9,0x86,0x77,0x78,0x87,0x77,0x88,
0x86,0x22,0x48,0xaa,0x86,0x8a,0xcc,0xb9,
0x87,0x87,0x98,0x76,0x64,0x22,0x7b,0xda,
0x75,0x7a,0xbb,0xa8,0x76,0x67,0x87,0x55,
0x77,0x9a,0x84,0x24,0x8a,0xa9,0x78,0xab,
0xa9,0x98,0x66,0x77,0x77,0x56,0x98,0x42,
0x48,0xcb,0x74,0x69,0xdc,0x96,0x67,0x77,
0x67,0x75,0x57,0x99,0x72,0x14,0xad,0xa8,
0x8a,0xdc,0x99,0x98,0x65,0x79,0x98,0x73,
0x02,0x5b,0xea,0x76,0x79,0xdd,0xb8,0x66,
0x56,0x77,0x77,0x78,0x75,0x44,0x69,0xba,
0x99,0x9b,0xb9,0x87,0x76,0x66,0x67,0x87,
0x75,0x43,0x49,0xcb,0x84,0x48,0xdf,0xa5,
0x55,0x78,0x75,0x56,0x56,0x78,0x64,0x34,
0x98,0xc9,0x9a,0xbb,0xa8,0x77,0x76,0x89,
0x96,0x00,0x28,0xee,0x97,0x8a,0xba,0x88,
0x86,0x65,0x57,0x76,0x79,0x86,0x22,0x7c,
0xd9,0x79,0xbb,0xa7,0x79,0x86,0x57,0x97,
0x66,0x53,0x38,0xcc,0x95,0x6c,0xeb,0x64,
0x46,0x76,0x67,0x78,0x89,0xa6,0x00,0x7d,
0xb7,0x46,0xde,0xb6,0x68,0x98,0x77,0x87,
0x66,0x64,0x23,0x8e,0xfa,0x99,0xba,0x65,
0x67,0x78,0xab,0xa6,0x00,0x39,0xdb,0x88,
0xbc,0xa7,0x56,0x54,0x46,0x89,0x89,0xa8,
0x42,0x5b,0xb8,0x7a,0xcb,0x74,0x57,0x66,
0x78,0x77,0x8a,0x73,0x15,0xbb,0x88,0x99,
0xba,0x85,0x25,0x87,0x76,0x79,0x87,0x9b,
0x62,0x49,0xac,0xcd,0xb7,0x56,0x76,0x68,
0xbc,0xa9,0x30,0x17,0xdb,0x77,0xee,0x84,
0x44,0x57,0x88,0x66,0xab,0x98,0x52,0x03,
0x9d,0xcb,0xbb,0x86,0x77,0x66,0x78,0x89,
0x99,0x20,0x4e,0xc6,0x36,0xde,0x96,0x44,
0x79,0x65,0x79,0x98,0x78,0x84,0x22,0x7c,
0xaa,0xcc,0x97,0x66,0x55,0x89,0x9a,0xa5,
0x03,0xac,0x86,0x8c,0xd9,0x44,0x68,0x86,
0x67,0xab,0x78,0x83,0x04,0xaa,0x69,0xfc,
0x65,0x67,0x79,0xa8,0x79,0x84,0x26,0xc9,
0x66,0xae,0xb5,0x56,0x79,0x75,0x68,0x99,
0x89,0x72,0x27,0x96,0x7b,0xb9,0x76,0x78,
0x77,0x88,0x98,0x62,0x17,0xea,0x34,0xcf,
0xa4,0x67,0x99,0x66,0x79,0x98,0x86,0x23,
0xba,0x56,0xce,0x95,0x67,0x88,0x77,0x89,
0x96,0x01,0xad,0x62,0x6e,0xf7,0x48,0x98,
0x75,0x58,0xa8,0x68,0x98,0x55,0x79,0x67,
0x89,0xa9,0x89,0x87,0x67,0x88,0x75,0x14,
0xcc,0x43,0xae,0xc5,0x59,0x97,0x66,0x8a,
0x95,0x6a,0x95,0x48,0xa8,0x78,0xaa,0x87,
0x88,0x76,0x89,0x87,0x52,0x5c,0x94,0x7c,
0xc8,0x68,0x87,0x64,0x68,0x97,0x68,0xba,
0x55,0x7a,0x84,0x4b,0xc7,0x5a,0xa8,0x68,
0x88,0x77,0x50,0x4e,0xc1,0x5d,0xc5,0x4b,
0xa5,0x58,0x87,0x77,0x87,0xa8,0x47,0x88,
0x55,0x9b,0x87,0x8a,0x97,0x88,0x88,0x76,
0x34,0xda,0x17,0xec,0x46,0xc9,0x46,0x77,
0x67,0x88,0x99,0x87,0x77,0x75,0x57,0xa8,
0x6a,0xb9,0x98,0x98,0x78,0x63,0x28,0xb4,
0x3b,0xf9,0x4b,0xc6,0x58,0x85,0x67,0x78,
0x66,0x89,0x86,0x79,0x87,0x66,0x99,0x88,
0x88,0x56,0x88,0x62,0x5c,0x63,0x6e,0xb4,
0x9d,0x85,0x7a,0x74,0x67,0x88,0x77,0x87,
0x89,0x66,0x8a,0x75,0x9b,0x87,0x98,0x66,
0x98,0x74,0x28,0xa5,0x4b,0xe8,0x5d,0xc6,
0x69,0x84,0x48,0x76,0x77,0x57,0xb6,0x5b,
0xa6,0x78,0x86,0x8a,0x87,0x9a,0x88,0x48,
0x94,0x49,0xa8,0x6b,0xb6,0x8b,0x86,0x67,
0x65,0x87,0x99,0x77,0x89,0x75,0x99,0x47,
0xb9,0x69,0xb8,0x68,0x88,0x53,0x6c,0x52,
0x8d,0x54,0xec,0x57,0xb8,0x67,0x87,0x46,
0x88,0x65,0x99,0x75,0x8b,0x64,0xba,0x58,
0xa8,0x79,0x97,0x66,0x62,0x69,0x35,0xd9,
0x7b,0xb9,0x88,0x97,0x67,0x75,0x58,0x87,
0x78,0x88,0x97,0x89,0x98,0x78,0x98,0x9a,
0x77,0x97,0x67,0x76,0x58,0x75,0x79,0x79,
0xa9,0xa9,0x68,0x76,0x86,0x66,0x78,0x78,
0x89,0x87,0x77,0x79,0x87,0x88,0x79,0x77,
0x86,0x88,0x77,0x98,0x77,0x66,0x87,0x66,
0x89,0x78,0x89,0x89,0x97,0x78,0x76,0x87,
0x66,0x87,0x78,0x86,0x77,0x99,0x98,0x88,
0x87,0x79,0x87,0x89,0x77,0x77,0x86,0x77,
0x76,0x78,0x99,0x87,0x78,0x77,0x98,0x77,
0x87,0x67,0x88,0x99,0x67,0x86,0x77,0x87,
0x89,0x76,0x78,0x87,0x88,0x88,0x88,0x78,
0x76,0x77,0x78,0x87,0x7a,0x98,0x76,0x67,
0x77,0x77,0x87,0x69,0x89,0x98,0x78,0x99,
0x87,0x89,0x88,0x78,0x88,0x75,0x67,0x89,
0x88,0x77,0x76,0x78,0x98,0x77,0x88,0x87,
0x77,0x78,0x87,0x77,0x78,0x77,0x77,0x77,
0x88,0x87,0x78,0x87,0x78,0x77,0x89,0x87,
0x78,0x88,0x87,0x56,0x88,0x78,0x89,0x99,
0x77,0x77,0x77,0x87,0x77,0x88,0x89,0x76,
0x78,0x9a,0x87,0x89,0x97,0x77,0x98,0x86,
0x77,0x88,0x87,0x89,0x76,0x78,0x98,0x66,
0x78,0x87,0x77,0x78,0x77,0x68,0x99,0x78,
0x98,0x67,0x79,0x98,0x77,0x87,0x76,0x77,
0x88,0x86,0x78,0x87,0x77,0x66,0x77,0x88,
0x88,0x88,0x77,0x87,0x67,0x77,0x67,0x88,
0x9a,0x87,0x87,0x89,0x87,0x78,0x98,0x87,
0x77,0x77,0x77,0x88,0x88,0x88,0x76,0x67,
0x98,0x66,0x77,0x77,0x77,0x89,0x77,0x88,
0x88,0x88,0x88,0x76,0x79,0x98,0x77,0x78,
0x98,0x89,0x88,0x66,0x78,0x98,0x87,0x76,
0x67,0x89,0x89,0x99,0x87,0x66,0x68,0x77,
0x76,0x78,0x98,0x77,0x87,0x99,0x99,0x87,
0x78,0x87,0x79,0x77,0x77,0x78,0x89,0x89,
0x87,0x78,0x88,0x66,0x77,0x98,0x67,0x87,
0x67,0x76,0x89,0x79,0x98,0x76,0x78,0x89,
0x86,0x68,0x87,0x68,0x78,0x87,0x68,0x87,
0x78,0x87,0x77,0x89,0x88,0x87,0x87,0x76,
0x78,0x87,0x66,0x78,0x89,0x98,0x88,0x88,
0x8a,0x88,0x78,0x88,0x77,0x78,0x77,0x68,
0x89,0x88,0x87,0x87,0x78,0x76,0x77,0x88,
0x77,0x88,0x77,0x76,0x78,0x89,0x88,0x77,
0x98,0x98,0x77,0x68,0x98,0x78,0x87,0x75,
0x67,0x88,0x88,0x78,0x67,0x89,0x98,0x77,
0x87,0x56,0x87,0x76,0x86,0x78,0x87,0x98,
0x89,0x89,0x99,0x87,0x78,0x98,0x78,0x86,
0x87,0x77,0x8b,0x79,0x99,0x66,0x66,0x86,
0x78,0x97,0x76,0x87,0x98,0x78,0x5a,0x97,
0x99,0x87,0x99,0x78,0xa7,0x46,0xa6,0x68,
0x78,0x76,0x76,0x79,0x99,0x99,0x77,0x9a,
0x77,0x96,0x76,0x87,0x56,0x78,0x65,0x77,
0x99,0xb8,0x88,0x9a,0xa9,0xa9,0x76,0x65,
0x75,0x78,0x87,0x57,0x79,0x6b,0x9c,0x79,
0x88,0x89,0x85,0x78,0x95,0x35,0x86,0x84,
0x54,0xa9,0xb9,0x9a,0xbb,0x88,0x9c,0x95,
0x35,0x78,0x74,0x44,0x78,0x84,0x79,0xec,
0x99,0xbb,0xaa,0x67,0x88,0x64,0x12,0x06,
0x86,0x41,0x7e,0xfc,0xaa,0xfd,0xa3,0x47,
0x99,0x21,0x48,0x71,0x56,0xb7,0x87,0xbf,
0xfa,0x98,0x99,0x54,0x37,0x76,0x42,0x04,
0x7d,0x76,0x8c,0xfa,0x87,0x9d,0x77,0x18,
0x76,0x65,0x60,0x68,0xa8,0x78,0xbe,0xa8,
0x87,0x87,0x85,0x56,0x77,0x89,0x77,0x66,
0x68,0x86,0x77,0x8a,0x99,0x88,0x9a,0x87,
0x78,0x98,0x61,0x03,0xac,0xb8,0x9d,0xeb,
0x74,0x58,0x95,0x44,0x38,0xb9,0x67,0xbc,
0xba,0x74,0x34,0x77,0x76,0x9e,0xdb,0x67,
0x98,0x77,0x53,0x57,0x76,0x69,0xab,0xbc,
0xa7,0x77,0x54,0x58,0x79,0xa8,0x79,0xa8,
0x40,0x27,0x99,0x89,0xbc,0xb8,0x56,0x89,
0x64,0x35,0x7a,0x99,0xaa,0xb9,0x76,0x42,
0x25,0x88,0x9b,0xdd,0xc9,0x65,0x66,0x53,
0x26,0x9a,0x76,0x7a,0xb9,0x75,0x79,0x97,
0x67,0x99,0x98,0x88,0x88,0x86,0x31,0x48,
0x98,0x79,0xee,0xd9,0x66,0x77,0x76,0x52,
0x25,0x8b,0xb9,0xab,0xa9,0x76,0x43,0x35,
0x77,0x57,0xce,0xda,0x99,0x87,0x77,0x54,
0x69,0x97,0x55,0xaa,0x85,0x46,0x9b,0xba,
0x86,0x68,0x99,0x75,0x69,0x78,0x88,0x41,
0x15,0xbb,0x76,0x9c,0xca,0x98,0x77,0x88,
0x86,0x54,0x57,0x87,0x89,0x98,0x87,0x88,
0x88,0x88,0x86,0x55,0x8a,0x87,0x89,0x98,
0x88,0x76,0x67,0x77,0x88,0x88,0x66,0x77,
0x77,0x77,0x88,0x89,0x98,0x89,0x98,0x87,
0x77,0x77,0x77,0x77,0x88,0x87,0x67,0x88,
0x98,0x87,0x77,0x77,0x66,0x89,0x99,0x88,
0x88,0x88,0x77,0x87,0x67,0x77,0x77,0x77,
0x77,0x77,0x99,0x89,0x88,0x88,0x88,0x87,
0x76,0x67,0x77,0x66,0x77,0x66,0x78,0x89,
0x87,0x88,0x88,0x88,0x89,0x87,0x88,0x87,
0x78,0x67,0x77,0x88,0x89,0x87,0x77,0x77,
0x77,0x88,0x88,0x98,0x88,0x98,0x78,0x87,
0x88,0x87,0x77,0x78,0x87,0x78,0x76,0x78,
0x77,0x88,0x78,0x88,0x99,0x89,0x98,0x77,
0x77,0x76,0x67,0x77,0x77,0x67,0x77,0x67,
0x77,0x88,0x88,0x88,0x88,0x98,0x99,0x98,
0x89,0x87,0x77,0x77,0x66,0x77,0x78,0x77,
0x78,0x77,0x88,0x78,0x88,0x89,0x77,0x87,
0x78,0x87,0x78,0x87,0x76,0x78,0x87,0x78,
0x87,0x77,0x77,0x87,0x77,0x88,0x88,0x99,
0x97,0x88,0x78,0x86,0x67,0x76,0x77,0x67,
0x86,0x78,0x77,0x89,0x88,0x87,0x88,0x88,
0x99,0x98,0x98,0x88,0x76,0x77,0x76,0x77,
0x88,0x87,0x77,0x77,0x98,0x77,0x88,0x88,
0x87,0x87,0x88,0x77,0x79,0x98,0x87,0x78,
0x77,0x67,0x77,0x77,0x78,0x76,0x77,0x87,
0x77,0x88,0x98,0x88,0x87,0x89,0x76,0x87,
0x67,0x77,0x77,0x67,0x77,0x67,0x87,0x78,
0x78,0x99,0x88,0x88,0x99,0x88,0x77,0x78,
0x87,0x77,0x89,0x98,0x87,0x87,0x88,0x76,
0x77,0x77,0x77,0x78,0x78,0x87,0x77,0x99,
0x99,0x88,0x98,0x78,0x88,0x88,0x77,0x87,
0x67,0x77,0x77,0x77,0x88,0x77,0x87,0x88,
0x76,0x78,0x87,0x87,0x78,0x88,0x87,0x77,
0x98,0x88,0x77,0x88,0x77,0x77,0x88,0x77,
0x76,0x67,0x77,0x78,0x78,0x99,0x88,0x87,
0x89,0x88,0x88,0x77,0x88,0x78,0x77,0x77,
0x77,0x87,0x78,0x77,0x88,0x66,0x89,0x98,
0x87,0x88,0x78,0x87,0x77,0x78,0x98,0x87,
0x88,0x98,0x66,0x67,0x77,0x76,0x67,0x77,
0x77,0x66,0x78,0x89,0x88,0x89,0x88,0x98,
0x98,0x88,0x87,0x77,0x77,0x88,0x88,0x78,
0x88,0x77,0x77,0x77,0x77,0x77,0x77,0x78,
0x88,0x77,0x7a,0xaa,0xa9,0x88,0x87,0x65,
0x77,0x88,0x88,0x66,0x89,0x9a,0x84,0x98,
0x87,0x66,0x45,0x65,0x76,0x87,0x89,0x99,
0xac,0xb9,0x85,0x57,0x47,0x65,0x54,0x78,
0x77,0xaa,0x9b,0xbc,0xbb,0x96,0x43,0x42,
0x43,0x45,0x67,0x89,0xac,0xab,0x8b,0xa9,
0x97,0x78,0x89,0x8a,0xa8,0x85,0x65,0x56,
0x56,0x55,0x55,0x89,0x89,0x86,0x99,0xbb,
0xa8,0xa9,0x79,0xaa,0x97,0x78,0x66,0x45,
0x68,0x87,0x55,0x44,0x54,0x66,0x68,0x7a,
0xbb,0xaa,0x99,0x9a,0xbd,0xa8,0x55,0x47,
0x66,0x55,0x44,0x45,0x68,0x8a,0x7a,0x97,
0x75,0x89,0x88,0x99,0xaa,0x9a,0x78,0x88,
0x89,0x77,0x54,0x46,0x77,0x99,0xa9,0x78,
0x67,0x78,0x85,0x55,0x66,0x98,0xa9,0x98,
0x88,0x89,0xaa,0x99,0x99,0x88,0x77,0x87,
0x64,0x54,0x58,0x89,0x66,0x45,0x69,0xcd,
0xb8,0x67,0x88,0x97,0x65,0x46,0x78,0x9a,
0xb9,0xb9,0x87,0x79,0xa9,0xaa,0x76,0x65,
0x86,0x65,0x24,0x22,0x54,0x69,0x9a,0xba,
0xc9,0xdc,0x98,0x66,0x97,0x73,0x02,0x28,
0xbb,0xc6,0xb7,0x88,0x7a,0x98,0x87,0x76,
0x78,0x58,0x88,0x85,0x63,0x13,0x59,0xcc,
0xb9,0x89,0xab,0xab,0xa9,0xa6,0x10,0x01,
0x6a,0xff,0xdc,0x98,0x78,0x76,0x55,0x67,
0x77,0x79,0x98,0x87,0x55,0x67,0x9a,0xab,
0x99,0x88,0x87,0x89,0x98,0x50,0x12,0x29,
0xdd,0xdb,0xa5,0x68,0x66,0x68,0x57,0x87,
0x88,0x89,0x76,0x43,0x57,0x9a,0xb9,0x98,
0x98,0x76,0x65,0x88,0x9a,0x60,0x03,0x7e,
0xfe,0xa7,0x75,0x56,0x78,0x99,0x88,0x67,
0x66,0x99,0x85,0x54,0x59,0xbc,0xb9,0x88,
0x88,0x88,0x77,0x89,0x88,0x40,0x36,0xad,
0xee,0x87,0x41,0x46,0x99,0xa9,0x9a,0x77,
0x45,0x79,0x98,0x74,0x57,0x99,0xa9,0x56,
0x88,0x99,0x87,0x77,0x77,0x98,0x11,0x68,
0xef,0xb7,0x46,0x46,0x88,0x89,0x87,0x99,
0x77,0x66,0x77,0x56,0x7a,0xba,0xa6,0x55,
0x68,0xaa,0xa8,0x77,0x88,0x96,0x03,0x79,
0xee,0xb8,0x44,0x25,0x9a,0xaa,0x97,0x76,
0x78,0x88,0x75,0x39,0xbb,0xc8,0x42,0x56,
0x9b,0xa7,0x77,0x67,0x88,0x89,0x60,0x3a,
0xad,0xe7,0x37,0x76,0x89,0x67,0x97,0x69,
0x87,0x78,0x88,0x55,0x67,0xbb,0xa7,0x64,
0x58,0x8a,0xa9,0x77,0x77,0x88,0x41,0x78,
0xdf,0xb8,0x46,0x56,0xa8,0x88,0x98,0x76,
0x65,0x78,0x9a,0x76,0x77,0x78,0x87,0x79,
0x87,0x76,0x67,0x98,0x88,0x66,0x87,0x23,
0xab,0xad,0x84,0x88,0x66,0x86,0x8a,0x86,
0x77,0x67,0x88,0x75,0x57,0x9b,0xa8,0x76,
0x77,0x98,0x98,0x98,0x77,0x77,0x77,0x22,
0xae,0xcb,0x71,0x3a,0xa8,0x97,0x69,0x96,
0x68,0x77,0x99,0x75,0x67,0x89,0x98,0x67,
0x89,0x97,0x57,0x9a,0x87,0x65,0x8a,0x71,
0x17,0xdd,0xb6,0x35,0xaa,0x76,0x79,0xb9,
0x54,0x68,0x97,0x65,0x35,0xde,0x97,0x66,
0x7a,0x74,0x68,0xbb,0x85,0x68,0x76,0x78,
0x88,0x42,0x8d,0x97,0x97,0x59,0xc8,0x58,
0x87,0x77,0x78,0xa8,0x67,0x63,0x5b,0xdb,
0x96,0x57,0x76,0x58,0xaa,0xb9,0x56,0x67,
0x77,0x86,0x65,0xbb,0x94,0x47,0x9b,0xa8,
0x79,0x86,0x56,0x89,0x98,0x77,0x53,0x4c,
0xb6,0x9b,0x88,0x95,0x48,0x86,0x99,0x7a,
0x95,0x58,0x87,0x87,0x43,0x9e,0x95,0x78,
0x8a,0x95,0x69,0x87,0x67,0x78,0x87,0x63,
0x17,0xeb,0x87,0x78,0x86,0x46,0xaa,0x88,
0x68,0x97,0x57,0x89,0x96,0x45,0x99,0x77,
0x8a,0xb9,0x65,0x68,0x98,0x77,0x98,0x65,
0x21,0x7f,0xc8,0xa9,0x77,0x63,0x5a,0xa9,
0x98,0x77,0x76,0x78,0x64,0x6d,0xd8,0x68,
0x88,0x75,0x68,0xa9,0x97,0x87,0x65,0x78,
0x98,0x64,0x8c,0xa6,0x58,0xba,0x86,0x79,
0x85,0x68,0x97,0x78,0x88,0x43,0x69,0x9b,
0xa7,0x78,0x66,0x55,0x7b,0xb9,0x99,0x77,
0x65,0x10,0x5e,0xca,0xaa,0xa8,0x54,0x67,
0x78,0x89,0xa9,0x77,0x76,0x54,0x49,0xb9,
0x9a,0xa9,0x66,0x57,0x76,0x78,0xaa,0x88,
0x78,0x76,0x66,0x46,0xbb,0x68,0xa8,0x98,
0x67,0x88,0x79,0x99,0x98,0x85,0x28,0x95,
0x7a,0x9a,0xa6,0x79,0x67,0x75,0x78,0x76,
0x89,0x78,0x76,0x56,0x77,0x68,0x98,0x79,
0x99,0x96,0x68,0x77,0x76,0x79,0x85,0x7a,
0x87,0x77,0x89,0x97,0x78,0x98,0x67,0x88,
0x77,0x78,0x88,0x88,0x88,0x88,0x77,0x66,
0x76,0x68,0x98,0xa9,0x79,0x97,0x77,0x86,
0x57,0x87,0x77,0x88,0x87,0x79,0x88,0x87,
0x78,0x87,0x88,0x77,0x76,0x67,0x87,0x78,
0x88,0x77,0x78,0x98,0x88,0x88,0x77,0x87,
0x77,0x78,0x99,0x77,0x89,0x87,0x77,0x88,
0x77,0x88,0x88,0x88,0x87,0x66,0x78,0x88,
0x88,0x88,0x77,0x77,0x77,0x88,0x88,0x78,
0x77,0x77,0x76,0x87,0x78,0x87,0x77,0x87,
0x88,0x67,0x87,0x78,0x78,0x87,0x77,0x66,
0x77,0x89,0x77,0x77,0x78,0x78,0x89,0x88,
0x88,0x88,0x87,0x88,0x88,0x88,0xa9,0x87,
0x88,0x78,0x77,0x78,0x98,0x88,0x98,0x78,
0x86,0x78,0x78,0x88,0x77,0x77,0x78,0x77,
0x88,0x98,0x88,0x88,0x77,0x67,0x77,0x88,
0x77,0x88,0x77,0x77,0x77,0x78,0x88,0x67,
0x86,0x67,0x78,0x88,0x87,0x77,0x87,0x78,
0x88,0x76,0x78,0x87,0x79,0x87,0x78,0x77,
0x89,0x88,0x88,0x88,0x77,0x78,0x78,0x98,
0x77,0x77,0x77,0x67,0x98,0x88,0x76,0x68,
0x87,0x77,0x77,0x66,0x87,0x78,0x87,0x78,
0x88,0x88,0x89,0x87,0x87,0x77,0x77,0x88,
0x88,0x98,0x77,0x76,0x68,0x86,0x78,0x87,
0x77,0x78,0x88,0x88,0x77,0x88,0x78,0x88,
0x88,0x77,0x89,0x88,0x87,0x78,0x87,0x77,
0x88,0x88,0x88,0x77,0x77,0x68,0x78,0x99,
0x77,0x66,0x89,0x76,0x77,0x77,0x78,0x88,
0x87,0x77,0x87,0x78,0x89,0x86,0x68,0x87,
0x67,0x68,0x87,0x78,0x88,0x88,0x77,0x78,
0x77,0x89,0x76,0x68,0x87,0x87,0x77,0x78,
0x88,0x88,0x87,0x88,0x88,0x88,0x88,0x77,
0x98,0x77,0x78,0x88,0x88,0x88,0x88,0x77,
0x88,0x78,0x88,0x76,0x78,0x87,0x77,0x77,
0x77,0x76,0x78,0x77,0x88,0x78,0x87,0x88,
0x67,0x88,0x77,0x87,0x77,0x87,0x79,0x88,
0x87,0x78,0x88,0x99,0x87,0x77,0x79,0x87,
0x77,0x78,0x77,0x78,0x77,0x78,0x88,0x87,
0x77,0x78,0x88,0x88,0x77,0x78,0x88,0x78,
0x87,0x77,0x78,0x89,0x99,0x98,0x87,0x78,
0x77,0x87,0x77,0x76,0x67,0x77,0x77,0x89,
0x98,0x77,0x88,0x88,0x88,0x87,0x75,0x67,
0x67,0x96,0x77,0x57,0x88,0x9a,0x9a,0xa9,
0xa9,0x79,0x75,0x55,0x66,0x67,0x67,0x78,
0x99,0x98,0x98,0x88,0x88,0xa8,0x88,0x67,
0x86,0x66,0x88,0x77,0x88,0x77,0x79,0xa7,
0x78,0x98,0x89,0x86,0x88,0x66,0x56,0x78,
0x66,0x88,0x76,0x78,0x87,0x88,0x99,0x89,
0xa9,0x88,0x75,0x57,0x75,0x55,0x67,0x67,
0x88,0x87,0x99,0x99,0xa9,0xa9,0x78,0x74,
0x57,0x65,0x76,0x57,0x87,0x88,0x89,0x89,
0x97,0x89,0x89,0x98,0x89,0x85,0x67,0x66,
0x78,0x88,0x76,0x99,0x78,0x98,0x99,0x99,
0x98,0x98,0x67,0x66,0x77,0x75,0x67,0x66,
0x78,0x88,0x88,0x88,0x89,0xa9,0xa8,0x87,
0x45,0x75,0x67,0x76,0x77,0x67,0x87,0x89,
0x87,0x9b,0xa9,0x99,0x88,0x75,0x67,0x65,
0x56,0x77,0x87,0x88,0x98,0x77,0x89,0xb9,
0xa9,0x88,0x77,0x65,0x66,0x66,0x67,0x75,
0x68,0x88,0x89,0x99,0xaa,0x9a,0x99,0xa9,
0x75,0x56,0x66,0x67,0x67,0x56,0x77,0x89,
0x98,0x89,0x99,0x89,0x99,0x87,0x66,0x67,
0x67,0x76,0x65,0x57,0x89,0x98,0x9a,0xaa,
0xaa,0x9a,0x98,0x77,0x56,0x65,0x46,0x76,
0x57,0x99,0x78,0x78,0x88,0x99,0x99,0x88,
0x77,0x75,0x56,0x77,0x66,0x77,0x77,0x77,
0x89,0xa9,0x89,0xa9,0x99,0x98,0x76,0x56,
0x75,0x66,0x67,0x67,0x76,0x79,0x98,0x9a,
0xa9,0x99,0xaa,0x87,0x65,0x67,0x76,0x66,
0x65,0x57,0x88,0x99,0xaa,0x9a,0x9a,0xaa,
0x97,0x65,0x56,0x56,0x76,0x76,0x67,0x77,
0x78,0x99,0x98,0x99,0x8a,0x99,0x77,0x76,
0x68,0x77,0x67,0x66,0x87,0x78,0x89,0x99,
0x98,0x99,0x88,0x87,0x67,0x75,0x66,0x56,
0x65,0x68,0x66,0x78,0x99,0x99,0x89,0x99,
0x9a,0x87,0x66,0x67,0x66,0x66,0x66,0x76,
0x77,0xab,0xa9,0x99,0x99,0xa8,0x88,0x65,
0x55,0x56,0x66,0x77,0x77,0x68,0x89,0xa9,
0x99,0x99,0x99,0x99,0x66,0x46,0x77,0x67,
0x76,0x67,0x76,0x99,0x99,0x89,0xaa,0x99,
0xa9,0x96,0x66,0x55,0x76,0x57,0x66,0x77,
0x88,0x98,0x9a,0xb9,0x9a,0xaa,0x97,0x55,
0x66,0x57,0x56,0x66,0x76,0x77,0x98,0xaa,
0xb9,0xa9,0xb9,0x95,0x55,0x55,0x45,0x56,
0x67,0x79,0x87,0x88,0x99,0x9b,0x9a,0xaa,
0x97,0x64,0x45,0x56,0x67,0x76,0x67,0x77,
0x88,0xaa,0xba,0xba,0xa9,0xa6,0x67,0x47,
0x24,0x27,0x47,0x87,0xa6,0xa7,0xa9,0xcb,
0xba,0xca,0xa8,0x65,0x46,0x36,0x46,0x58,
0x65,0xa7,0xa8,0xab,0xbb,0xaa,0xaa,0x97,
0x75,0x35,0x33,0x36,0x65,0x98,0xa9,0x98,
0x89,0xaa,0xbb,0xaa,0x86,0x74,0x42,0x45,
0x37,0x58,0x77,0x89,0xa7,0xa9,0xaa,0xba,
0xaa,0x66,0x55,0x43,0x45,0x24,0x47,0x78,
0xb9,0xd8,0x99,0xb9,0xcd,0xc9,0x75,0xa2,
0x53,0x36,0x46,0x4a,0x69,0x8b,0x9a,0xaa,
0xab,0xdb,0xa9,0x64,0xa3,0x32,0x62,0x44,
0x57,0x79,0xac,0xaa,0x99,0xb9,0xcc,0xb6,
0x77,0x64,0x32,0x42,0x44,0x78,0x69,0x9b,
0x98,0xac,0xb8,0xcc,0xa6,0x75,0x83,0x30,
0x44,0x25,0x39,0x58,0x9d,0xba,0xdd,0xda,
0xca,0xc9,0x55,0xa1,0x20,0x61,0x35,0x4a,
0x78,0xbb,0xda,0xdd,0xfa,0xa8,0xc7,0x05,
0x53,0x01,0x43,0x51,0x6b,0xa8,0xbf,0xed,
0xdc,0xea,0x76,0x86,0x05,0x23,0x02,0x36,
0x73,0xac,0xca,0xde,0xdd,0xba,0xb9,0x65,
0x40,0x33,0x30,0x26,0x58,0x6a,0xac,0xce,
0xec,0xcb,0xa9,0x86,0x52,0x03,0x54,0x24,
0x88,0x88,0xdd,0xed,0xdb,0xab,0x87,0x75,
0x54,0x02,0x25,0x22,0x6a,0xab,0xbd,0xdd,
0xba,0x89,0x76,0x54,0x56,0x02,0x37,0x53,
0x6a,0xdc,0xdc,0xdd,0xb9,0x77,0x75,0x43,
0x55,0x16,0x57,0x76,0x87,0xbc,0xcb,0xbb,
0xca,0x65,0x56,0x44,0x45,0x55,0x57,0x78,
0x88,0x9c,0xbb,0xba,0xb9,0x96,0x55,0x78,
0x76,0x42,0x58,0x86,0x67,0x8c,0xcb,0x98,
0x98,0x98,0x65,0x77,0x66,0x65,0x35,0x79,
0x87,0x8a,0xbc,0xa8,0x88,0x78,0x86,0x67,
0x78,0x75,0x36,0x77,0x78,0x76,0x8b,0xcc,
0xa8,0x68,0x87,0x66,0x77,0x68,0x75,0x67,
0x64,0x68,0x78,0x88,0x98,0x88,0x78,0x97,
0x88,0x78,0x98,0x77,0x88,0x89,0x77,0x87,
0x77,0x78,0x99,0x87,0x88,0x77,0x78,0x88,
0x98,0x77,0x77,0x66,0x77,0x87,0x68,0x87,
0x77,0x78,0x88,0x88,0x88,0x88,0x88,0x89,
0x97,0x67,0x76,0x78,0x89,0x97,0x66,0x66,
0x67,0x78,0x99,0x87,0x77,0x78,0x76,0x78,
0x87,0x77,0x67,0x76,0x78,0x77,0x88,0x98,
0x88,0x88,0x99,0x87,0x89,0x88,0x78,0x99,
0x77,0x66,0x66,0x67,0x88,0x88,0x87,0x77,
0x87,0x77,0x78,0x88,0x77,0x88,0x77,0x98,
0x78,0x88,0x88,0x77,0x76,0x77,0x66,0x77,
0x88,0x99,0x98,0x87,0x78,0x77,0x89,0x98,
0x88,0x76,0x67,0x66,0x67,0x88,0x66,0x67,
0x77,0x88,0x88,0x89,0x99,0x98,0x88,0x99,
0x88,0x88,0x87,0x88,0x88,0x97,0x66,0x76,
0x67,0x88,0x78,0x87,0x77,0x88,0x76,0x68,
0x88,0x78,0x88,0x88,0x78,0x77,0x78,0x77,
0x88,0x89,0x88,0x77,0x78,0x78,0x98,0x88,
0x76,0x67,0x76,0x77,0x88,0x87,0x78,0x78,
0x86,0x67,0x99,0x76,0x88,0x88,0x88,0x87,
0x78,0x99,0x88,0x88,0x88,0x87,0x78,0x87,
0x88,0x88,0x97,0x78,0x78,0x78,0x98,0x88,
0x88,0x77,0x67,0x66,0x77,0x76,0x77,0x78,
0x87,0x78,0x87,0x88,0x98,0x88,0x88,0x77,
0x77,0x78,0x77,0x87,0x88,0x76,0x67,0x76,
0x78,0x87,0x78,0x78,0x76,0x76,0x58,0x87,
0x67,0x88,0x78,0x88,0x88,0x78,0x89,0x88,
0x88,0x98,0x88,0x88,0x78,0x88,0x88,0x88,
0x77,0x77,0x76,0x77,0x88,0x78,0x88,0x77,
0x76,0x77,0x77,0x78,0x77,0x88,0x88,0x87,
0x78,0x98,0x88,0x98,0x77,0x78,0x87,0x79,
0x88,0x88,0x87,0x77,0x67,0x67,0x88,0x77,
0x99,0x77,0x77,0x67,0x88,0x77,0x77,0x79,
0x88,0x77,0x88,0x98,0x88,0x88,0x98,0x88,
0x98,0x77,0x88,0x87,0x88,0x87,0x76,0x76,
0x67,0x87,0x78,0x98,0x77,0x77,0x66,0x78,
0x78,0x66,0x88,0x88,0x78,0x78,0x88,0x88,
0x99,0x87,0x88,0x87,0x89,0x98,0x88,0x88,
0x77,0x66,0x77,0x78,0x88,0x89,0x88,0x77,
0x76,0x78,0x86,0x76,0x79,0x98,0x88,0x88,
0x78,0x89,0x88,0x99,0x87,0x77,0x77,0x88,
0x78,0x98,0x98,0x77,0x77,0x76,0x88,0x78,
0x88,0x78,0x67,0x77,0x67,0x77,0x77,0x77,
0x88,0x76,0x78,0x79,0x98,0x89,0x87,0x78,
0x77,0x78,0x97,0x89,0x88,0x87,0x76,0x67,
0x68,0x87,0x88,0x88,0x76,0x77,0x67,0x88,
0x67,0x77,0x89,0x97,0x79,0x98,0x98,0x79,
0x99,0x88,0x77,0x87,0x78,0x88,0x89,0x98,
0x87,0x66,0x76,0x67,0x78,0x88,0x86,0x78,
0x77,0x77,0x77,0x66,0x79,0x88,0x77,0x78,
0x78,0x89,0x98,0x88,0x77,0x78,0x78,0x99,
0x88,0x99,0x97,0x76,0x67,0x77,0x88,0x78,
0x77,0x77,0x76,0x67,0x77,0x66,0x68,0x89,
0x88,0x78,0x88,0x88,0x98,0x88,0x89,0x86,
0x78,0x77,0x87,0x78,0x99,0x78,0x77,0x66,
0x77,0x88,0x88,0x89,0x66,0x77,0x68,0x76,
0x77,0x88,0x88,0x87,0x77,0x88,0x88,0x89,
0x88,0x87,0x57,0x87,0x79,0x88,0x9a,0x88,
0x77,0x66,0x67,0x78,0x88,0x88,0x76,0x77,
0x77,0x87,0x76,0x67,0x88,0x89,0x87,0x78,
0x87,0x89,0x88,0x89,0x77,0x89,0x77,0x88,
0x79,0x88,0x99,0x76,0x66,0x77,0x77,0x88,
0x77,0x78,0x77,0x76,0x67,0x65,0x68,0x87,
0x86,0x68,0x97,0x78,0x99,0x98,0x76,0x77,
0x88,0x88,0x89,0x89,0x98,0x77,0x76,0x68,
0x87,0x89,0x88,0x87,0x77,0x77,0x78,0x66,
0x77,0x98,0x89,0x87,0x88,0x77,0x89,0x98,
0x78,0x87,0x77,0x88,0x89,0x88,0x89,0x98,
0x76,0x66,0x77,0x78,0x88,0x88,0x88,0x76,
0x68,0x76,0x66,0x78,0x88,0x88,0x77,0x78,
0x88,0x98,0x88,0x86,0x66,0x79,0x87,0x89,
0x88,0x88,0x77,0x76,0x78,0x88,0x88,0x88,
0x87,0x77,0x77,0x77,0x66,0x67,0x79,0x89,
0x87,0x88,0x88,0x89,0xa8,0x77,0x76,0x87,
0x99,0xa6,0x87,0x8a,0x78,0x77,0x85,0x69,
0x67,0x87,0x7a,0x99,0x57,0x87,0x77,0x66,
0x96,0x67,0x89,0x78,0x78,0x7a,0x97,0x78,
0x87,0x67,0x78,0x86,0x88,0x87,0x78,0x86,
0x58,0x68,0xaa,0x98,0xaa,0x87,0x75,0x67,
0x68,0x95,0x66,0x66,0x58,0xa7,0x9a,0xab,
0xa8,0x65,0x53,0x57,0x79,0xaa,0xa7,0x55,
0x59,0xad,0xdc,0xb9,0x94,0x41,0x03,0x67,
0xdc,0x79,0x85,0x43,0x59,0xdc,0xbd,0x9a,
0x72,0x10,0x13,0x8c,0xde,0xb6,0x44,0x57,
0xdf,0xdd,0xaa,0xb6,0x00,0x00,0x29,0xcd,
0xe9,0x78,0x88,0xbd,0xa9,0x88,0x76,0x21,
0x00,0x37,0xcd,0xdc,0x99,0x8a,0x9b,0xa9,
0x87,0x74,0x01,0x11,0x69,0xbe,0xed,0x9a,
0x87,0x86,0x78,0x78,0x73,0x20,0x03,0x7b,
0xcf,0xdb,0xb8,0x76,0x66,0x67,0x77,0x63,
0x13,0x47,0xac,0xbd,0xca,0x98,0x75,0x57,
0x8b,0xb8,0x10,0x01,0x59,0xde,0xdc,0x9a,
0x98,0x97,0x55,0x44,0x57,0x66,0x75,0x68,
0x9a,0xdd,0xaa,0x85,0x69,0x8b,0xcb,0x82,
0x00,0x14,0x9c,0xde,0xbb,0xa9,0x76,0x64,
0x45,0x68,0x99,0x77,0x64,0x77,0x9a,0xa8,
0x67,0x67,0xaa,0xab,0x97,0x50,0x01,0x37,
0x9b,0xfd,0xcc,0x97,0x54,0x44,0x66,0x8a,
0xaa,0x75,0x54,0x66,0x9a,0x9a,0x99,0x89,
0xa8,0x88,0x77,0x30,0x22,0x4b,0xcf,0xec,
0xa8,0x65,0x56,0x56,0x78,0x9b,0xb8,0x66,
0x44,0x56,0x9b,0xba,0xa8,0x88,0x99,0xa8,
0x76,0x01,0x23,0x9c,0xce,0xca,0x86,0x55,
0x56,0x57,0x89,0xbb,0xa8,0x43,0x12,0x57,
0xce,0xcc,0xb8,0x65,0x77,0x89,0x77,0x21,
0x43,0xae,0xae,0xc8,0x76,0x65,0x57,0x48,
0xa8,0xba,0x84,0x23,0x15,0xaa,0xcd,0xbb,
0x76,0x56,0x99,0xba,0x72,0x12,0x29,0xdb,
0xec,0x88,0x76,0x56,0x65,0x89,0x9c,0xba,
0x63,0x20,0x37,0x8d,0xeb,0xa8,0x65,0x69,
0x89,0xa7,0x40,0x14,0x5c,0xdd,0xda,0x87,
0x56,0x57,0x76,0x99,0x9b,0xa7,0x44,0x34,
0x79,0xbc,0xca,0x86,0x56,0x89,0x89,0x87,
0x12,0x42,0xcd,0xad,0xb8,0x86,0x55,0x68,
0x7b,0x99,0xc9,0x54,0x32,0x37,0x9a,0xed,
0xaa,0x66,0x67,0x99,0xa8,0x40,0x21,0x5d,
0xbd,0xd9,0x77,0x55,0x67,0x67,0x97,0xaa,
0x98,0x53,0x23,0x68,0xbf,0xcc,0xa6,0x54,
0x68,0x9b,0x98,0x20,0x43,0xae,0xae,0xa7,
0x84,0x55,0x78,0x6a,0x89,0xb8,0x86,0x35,
0x26,0x9a,0xeb,0xa9,0x57,0x79,0xa9,0xb9,
0x51,0x12,0x2a,0xea,0xfb,0x88,0x56,0x66,
0x76,0x98,0x8c,0x97,0x54,0x22,0x56,0xae,
0xbc,0xa6,0x65,0x78,0xa9,0x75,0x02,0x46,
0xed,0xde,0x77,0x64,0x65,0x88,0x69,0x7a,
0xb9,0xa6,0x23,0x03,0x79,0xed,0xcb,0x77,
0x54,0x78,0xa9,0x73,0x14,0x48,0xdb,0xeb,
0x67,0x45,0x79,0x97,0x98,0x69,0x97,0x75,
0x43,0x47,0x8b,0xcb,0xc9,0x65,0x56,0x9a,
0xb9,0x50,0x23,0x4b,0xcd,0xe8,0x87,0x45,
0x68,0x78,0x95,0x78,0x79,0x97,0x55,0x66,
0x9b,0xab,0x97,0x77,0x79,0x99,0x95,0x13,
0x14,0xba,0xff,0x98,0x64,0x54,0x77,0x89,
0x59,0xa8,0xa8,0x65,0x44,0x36,0xaa,0xdc,
0x99,0x66,0x78,0x89,0x71,0x24,0x39,0xcd,
0xfb,0x97,0x34,0x47,0x88,0xb9,0x88,0x78,
0x86,0x64,0x45,0x6a,0xcc,0xc9,0x76,0x56,
0x79,0x97,0x55,0x53,0x8a,0xbf,0xb9,0x74,
0x55,0x78,0x99,0x87,0x97,0x78,0x76,0x76,
0x66,0x89,0xbb,0x98,0x86,0x78,0x88,0x64,
0x33,0x38,0x9b,0xf9,0xa9,0x55,0x36,0x78,
0xa8,0x88,0x78,0x86,0x67,0x66,0x88,0x8a,
0xa9,0x99,0x88,0x76,0x75,0x34,0x34,0x9a,
0xee,0xaa,0x64,0x33,0x66,0xab,0x9a,0x96,
0x64,0x57,0x88,0x99,0x88,0xa8,0x79,0x88,
0x88,0x76,0x33,0x34,0xaa,0xcd,0xaa,0x85,
0x55,0x67,0x8a,0x88,0x95,0x46,0x55,0x88,
0x9b,0xaa,0xa7,0x67,0x88,0x9a,0x97,0x53,
0x32,0x5a,0xad,0xdb,0xa7,0x55,0x58,0x89,
0x87,0x86,0x25,0x65,0xaa,0xbb,0x98,0x74,
0x46,0x88,0xaa,0x99,0x63,0x42,0x39,0x8c,
0xea,0xb9,0x77,0x46,0x68,0x88,0x97,0x44,
0x54,0x9b,0xbc,0xb8,0x87,0x54,0x76,0x79,
0xa8,0x98,0x32,0x34,0x68,0xac,0xcb,0xb9,
0x66,0x76,0x78,0x97,0x64,0x35,0x47,0xaa,
0xcc,0xa9,0x66,0x67,0x9a,0xa9,0x85,0x32,
0x34,0x8b,0xcf,0xea,0xa6,0x43,0x45,0x69,
0x98,0xba,0x77,0x63,0x58,0x8a,0xb9,0x9a,
0x87,0xa9,0x88,0x67,0x51,0x23,0x47,0xdd,
0xce,0xb9,0x85,0x35,0x55,0x78,0x78,0x96,
0x69,0x86,0x97,0x68,0x77,0x99,0x9b,0xba,
0xb9,0x63,0x00,0x01,0x59,0xbf,0xed,0xc9,
0x66,0x56,0x56,0x65,0x77,0x68,0x98,0xaa,
0x89,0x76,0x45,0x67,0xb9,0xac,0xa8,0x75,
0x32,0x14,0x79,0xdd,0xcd,0xb8,0x74,0x55,
0x66,0x67,0x77,0x78,0x8a,0xba,0x88,0x86,
0x66,0x79,0xaa,0xba,0x97,0x32,0x22,0x37,
0xab,0xfd,0xbc,0x85,0x76,0x67,0x87,0x66,
0x43,0x45,0x8a,0xbd,0xc9,0x87,0x67,0x78,
0x89,0x87,0x74,0x23,0x44,0xab,0xce,0xca,
0x96,0x56,0x55,0x87,0x78,0x86,0x43,0x46,
0xbb,0xcd,0xa8,0x76,0x58,0xa9,0xaa,0x85,
0x31,0x03,0x68,0xbe,0xcc,0xd9,0x77,0x55,
0x56,0x56,0x96,0x67,0x66,0x78,0x8a,0xbb,
0x98,0x66,0x78,0x9a,0x98,0x86,0x31,0x23,
0x4a,0xbd,0xeb,0xcb,0x87,0x66,0x44,0x65,
0x67,0x67,0x87,0x9a,0x99,0xa7,0x57,0x75,
0x9a,0x9c,0xca,0x84,0x00,0x03,0x78,0xae,
0xec,0xd9,0x9a,0x76,0x66,0x54,0x55,0x44,
0x66,0xaa,0xad,0xa9,0x97,0x66,0x66,0x7a,
0x99,0x84,0x22,0x14,0x6a,0xdd,0xec,0xa9,
0x77,0x66,0x65,0x56,0x45,0x66,0x77,0xaa,
0xac,0xa9,0x96,0x67,0x67,0x9a,0xa9,0x84,
0x32,0x04,0x67,0xcc,0xef,0xcb,0xa8,0x76,
0x76,0x44,0x45,0x66,0x87,0xaa,0xac,0xaa,
0xa7,0x67,0x66,0x9a,0x98,0x95,0x22,0x02,
0x77,0xbe,0xee,0xdb,0x86,0x65,0x44,0x44,
0x66,0x77,0x89,0x89,0x87,0xa9,0x98,0x8a,
0x87,0x76,0x89,0x88,0x75,0x31,0x33,0x69,
0xcf,0xed,0xea,0x86,0x45,0x43,0x25,0x66,
0x88,0x78,0x87,0x88,0x98,0x9b,0x89,0x87,
0x89,0x88,0x98,0x53,0x11,0x25,0x78,0xff,
0xef,0xd8,0x76,0x43,0x44,0x47,0x76,0x99,
0x87,0x97,0x7a,0x88,0xa9,0x79,0x98,0x88,
0x78,0x87,0x55,0x43,0x46,0x8a,0xbd,0xed,
0xda,0x66,0x44,0x45,0x65,0x78,0x77,0x89,
0x89,0x97,0x98,0x57,0x87,0x89,0x88,0x88,
0x76,0x74,0x24,0x33,0x67,0xae,0xff,0xed,
0x96,0x42,0x24,0x44,0x67,0x77,0x99,0x79,
0x99,0xb9,0x88,0x87,0x68,0x77,0x98,0x88,
0x74,0x32,0x23,0x79,0xbe,0xde,0xdb,0x76,
0x54,0x45,0x55,0x56,0x69,0xbb,0xba,0x87,
0x54,0x66,0x8a,0xab,0xba,0x88,0x86,0x77,
0x75,0x22,0x11,0x47,0x9f,0xff,0xee,0x96,
0x54,0x34,0x45,0x78,0x8a,0xa8,0x77,0x66,
0x77,0x68,0x87,0x9a,0xa8,0x88,0x68,0x76,
0x64,0x34,0x35,0x8a,0xcf,0xdd,0xb7,0x55,
0x43,0x45,0x45,0x78,0x9a,0xba,0xa9,0x76,
0x53,0x45,0x8a,0xbc,0xb9,0x96,0x67,0x67,
0x77,0x54,0x32,0x48,0xac,0xff,0xec,0x85,
0x32,0x33,0x66,0x69,0x98,0xaa,0xaa,0x86,
0x55,0x55,0x79,0xab,0xbb,0xaa,0x86,0x55,
0x57,0x77,0x44,0x54,0x58,0xcd,0xfe,0xba,
0x74,0x32,0x46,0x76,0x68,0x89,0xbb,0xa9,
0x85,0x44,0x33,0x7a,0xbd,0xdb,0xa8,0x66,
0x67,0x56,0x66,0x54,0x44,0x58,0xcd,0xef,
0xca,0x85,0x34,0x54,0x68,0x66,0x76,0x8a,
0xbb,0xa8,0x54,0x43,0x58,0x9c,0xdc,0xcb,
0x86,0x65,0x56,0x75,0x43,0x24,0x49,0xbb,
0xff,0xdd,0x85,0x44,0x44,0x67,0x88,0x67,
0xaa,0xab,0xca,0x86,0x41,0x22,0x48,0xbe,
0xfd,0xca,0x96,0x44,0x34,0x66,0x66,0x88,
0xab,0xab,0x96,0x56,0x67,0x89,0x9b,0xa8,
0x78,0x77,0x78,0x66,0x53,0x24,0x38,0xcc,
0xff,0xca,0x74,0x34,0x56,0x78,0x66,0x55,
0x79,0xbc,0xba,0x86,0x52,0x23,0x59,0xbc,
0xdc,0x97,0x54,0x45,0x56,0x8b,0xab,0xba,
0x88,0x76,0x55,0x45,0x77,0x67,0x88,0xad,
0xca,0xa8,0x54,0x55,0x68,0x89,0xa9,0x76,
0x54,0x56,0x57,0x99,0xbd,0xbc,0xca,0x65,
0x43,0x36,0x78,0x99,0x88,0x98,0x9a,0x86,
0x64,0x25,0x8a,0xdd,0xba,0x85,0x34,0x55,
0x78,0x89,0x85,0x45,0x56,0x9b,0xce,0xc8,
0x76,0x45,0x56,0x89,0x76,0x76,0x79,0xa9,
0x99,0x77,0x65,0x66,0x55,0x67,0x8b,0xbb,
0xdc,0x97,0x44,0x45,0x66,0x76,0x68,0x9b,
0xcc,0xb8,0x53,0x21,0x25,0x9c,0xee,0xdd,
0xa7,0x55,0x45,0x56,0x89,0x88,0x75,0x67,
0x78,0xa9,0xbb,0x87,0x86,0x56,0x77,0x98,
0x67,0x78,0x87,0x89,0x99,0x67,0x77,0x56,
0x54,0x45,0x8b,0xef,0xfc,0x95,0x34,0x44,
0x67,0x66,0x78,0xbd,0xca,0x87,0x32,0x21,
0x35,0x48,0xbc,0xff,0xdc,0xa7,0x55,0x43,
0x56,0x67,0x78,0x99,0x99,0x87,0x55,0x23,
0x56,0xae,0xed,0xca,0x88,0x64,0x55,0x34,
0x67,0x89,0xab,0xba,0x97,0x43,0x33,0x56,
0x7b,0xcc,0xcb,0xb9,0x65,0x55,0x43,0x46,
0x8a,0xbc,0xa9,0x87,0x76,0x66,0x43,0x45,
0x5b,0xcd,0xfd,0xb9,0x64,0x45,0x45,0x54,
0x58,0x9b,0xcb,0xb9,0x64,0x35,0x55,0x54,
0x44,0x7a,0xdf,0xfd,0xa6,0x43,0x56,0x88,
0x87,0x67,0x79,0xcb,0x97,0x44,0x33,0x57,
0x76,0x76,0x69,0xac,0xfe,0xb8,0x64,0x45,
0x67,0x87,0x65,0x65,0x8b,0xcc,0xa8,0x54,
0x34,0x77,0x78,0x65,0x79,0xcf,0xfd,0xb7,
0x32,0x33,0x58,0x9a,0xa8,0x77,0x66,0x88,
0x9a,0xa8,0x75,0x66,0x66,0x67,0x66,0x89,
0xcc,0xbb,0x87,0x55,0x78,0x98,0x97,0x76,
0x68,0x88,0x88,0x65,0x44,0x56,0x7a,0xba,
0x99,0x99,0x99,0x98,0x75,0x55,0x57,0x98,
0x87,0x87,0x78,0x99,0x76,0x54,0x45,0x66,
0x9a,0xac,0xa8,0x99,0x77,0x77,0x66,0x57,
0x98,0x89,0x77,0x77,0x77,0x88,0x75,0x55,
0x67,0x8a,0xaa,0x85,0x54,0x57,0x8b,0xbb,
0xa8,0x77,0x78,0x88,0x98,0x77,0x67,0x67,
0x77,0x88,0x87,0x65,0x44,0x68,0xbd,0xcc,
0xa8,0x77,0x66,0x99,0x87,0x76,0x68,0x88,
0x98,0x76,0x66,0x68,0x87,0x97,0x77,0x77,
0x99,0x88,0x87,0x66,0x77,0x78,0x87,0x89,
0x99,0x99,0xa9,0x77,0x65,0x56,0x76,0x66,
0x55,0x68,0x89,0x99,0x88,0x76,0x66,0x56,
0x77,0x9b,0xcd,0xd9,0x97,0x64,0x67,0x88,
0x98,0x76,0x65,0x79,0x89,0x98,0x67,0x65,
0x78,0x88,0x89,0x88,0x89,0x99,0x88,0x77,
0x87,0x87,0x65,0x56,0x78,0xbc,0xa9,0x98,
0x67,0x77,0x88,0x77,0x76,0x67,0x87,0x79,
0x86,0x77,0x67,0x88,0x77,0x77,0x77,0x77,
0x88,0x98,0x99,0x99,0x99,0x98,0x78,0x67,
0x87,0x66,0x67,0x78,0x88,0x88,0x77,0x77,
0x68,0x88,0x78,0x66,0x86,0x68,0x97,0x78,
0x77,0x88,0x78,0x88,0x77,0x78,0x99,0xa9,
0x87,0x67,0x67,0x87,0x67,0x77,0x87,0x77,
0x87,0x77,0x77,0x87,0x68,0x98,0x78,0x77,
0x99,0x77,0x87,0x88,0x89,0x99,0x87,0x78,
0x88,0x99,0x99,0x86,0x77,0x67,0x65,0x67,
0x67,0x89,0x88,0x87,0x87,0x78,0x77,0x88,
0x77,0x87,0x78,0x88,0x87,0x77,0x88,0x98,
0x88,0x76,0x77,0x88,0x98,0x87,0x67,0x88,
0x88,0x76,0x66,0x78,0x88,0x88,0x77,0x77,
0x77,0x79,0x98,0x78,0x77,0x77,0x77,0x77,
0x78,0x89,0x97,0x88,0x78,0x89,0x99,0x98,
0x77,0x78,0x88,0x87,0x76,0x67,0x88,0x88,
0x98,0x77,0x67,0x88,0x87,0x78,0x77,0x67,
0x88,0x77,0x78,0x88,0x88,0x88,0x77,0x88,
0x98,0x98,0x87,0x77,0x78,0x97,0x77,0x77,
0x88,0x88,0x98,0x77,0x77,0x78,0x78,0x87,
0x67,0x66,0x77,0x77,0x77,0x77,0x77,0x78,
0x87,0x77,0x88,0x99,0x88,0x77,0x77,0x88,
0x77,0x77,0x78,0x88,0x99,0x89,0x88,0x78,
0x87,0x88,0x77,0x77,0x67,0x77,0x77,0x77,
0x78,0x89,0x88,0x77,0x87,0x78,0x88,0x87,
0x77,0x88,0x88,0x77,0x77,0x88,0x89,0x98,
0x88,0x88,0x87,0x78,0x88,0x77,0x87,0x77,
0x77,0x77,0x77,0x78,0x88,0x77,0x78,0x77,
0x78,0x88,0x77,0x78,0x88,0x76,0x66,0x77,
0x78,0x99,0x88,0x87,0x77,0x78,0x98,0x87,
0x78,0x77,0x77,0x78,0x78,0x77,0x88,0x88,
0x88,0x77,0x77,0x88,0x87,0x77,0x88,0x77,
0x77,0x77,0x77,0x88,0x88,0x77,0x77,0x77,
0x88,0x88,0x77,0x77,0x77,0x87,0x77,0x77,
0x77,0x88,0x88,0x88,0x87,0x88,0x88,0x88,
0x88,0x88,0x88,0x77,0x78,0x88,0x88,0x88,
0x87,0x77,0x78,0x87,0x77,0x77,0x77,0x78,
0x77,0x77,0x77,0x78,0x88,0x97,0x77,0x77,
0x78,0x88,0x88,0x88,0x88,0x77,0x78,0x88,
0x88,0x88,0x88,0x78,0x88,0x88,0x88,0x87,
0x78,0x77,0x87,0x77,0x77,0x77,0x78,0x88,
0x87,0x77,0x77,0x88,0x88,0x87,0x88,0x77,
0x77,0x78,0x78,0x88,0x88,0x88,0x78,0x78,
0x88,0x88,0x77,0x88,0x87,0x77,0x78,0x77,
0x88,0x88,0x88,0x77,0x77,0x78,0x88,0x77,
0x88,0x87,0x77,0x78,0x88,0x88,0x88,0x88,
0x77,0x87,0x78,0x88,0x77,0x78,0x87,0x78,
0x77,0x77,0x77,0x78,0x78,0x88,0x77,0x78,
0x88,0x88,0x88,0x87,0x88,0x77,0x88,0x78,
0x88,0x88,0x88,0x77,0x78,0x88,0x77,0x77,
0x78,0x77,0x87,0x77,0x78,0x87,0x88,0x88,
0x77,0x77,0x77,0x88,0x88,0x87,0x77,0x88,
0x77,0x88,0x88,0x88,0x88,0x88,0x87,0x88,
0x88,0x88,0x88,0x88,0x87,0x77,0x77,0x77,
0x88,0x78,0x88,0x77,0x78,0x88,0x88,0x88,
0x77,0x77,0x77,0x77,0x88,0x88,0x88,0x88,
0x87,0x77,0x88,0x77,0x88,0x77,0x77,0x78,
0x77,0x78,0x87,0x78,0x88,0x87,0x77,0x77,
0x88,0x88,0x87,0x77,0x88,0x77,0x88,0x88,
0x88,0x88,0x87,0x87,0x88,0x88,0x88,0x87,
0x77,0x88,0x87,0x78,0x77,0x77,0x77,0x88,
0x87,0x78,0x78,0x88,0x88,0x77,0x88,0x77,
0x87,0x88,0x88,0x87,0x88,0x88,0x78,0x88,
0x78,0x87,0x78,0x88,0x88,0x77,0x78,0x88,
0x77,0x88,0x87,0x77,0x77,0x77,0x88,0x87,
0x78,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
0x88,0x88,0x87,0x88,0x88,0x88,0x88,0x77,
0x77,0x77,0x88,0x77,0x88,0x88,0x88,0x88,
0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
0x88,0x88,0x88,0x88
};
