# Awesome Piracy [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> A curated list of arrrrrrrrr!

## Preamble
Over the past couple of years, I've accumulated bookmarks, saved Reddit posts, and GitHub stars all related to piracy in some form or another. This list is my attempt to add structure to those resources and share them. Everything you need to get started on your pirate voyage can be found below.

I am aware that a number of websites featured in this list rely on operating under obscurity, and that this list could potentially contribute to their demise through excess exposure. I'm sorry about that - I just like making lists.

Please ensure you use an adblocker like [uBlock Origin](https://github.com/gorhill/uBlock) to access any of the websites listed here, otherwise, you will have a bad time.

For discussion and feedback, please head to [the Reddit thread on /r/Piracy](https://www.reddit.com/r/Piracy/comments/9nontk/awesome_piracy_a_curated_list_of_awesome_warez/). If you come across dead links, please report them by [creating an issue](https://github.com/Igglybuff/awesome-piracy/issues/new).

## Mirrors
This list is periodically mirrored to [PasteBin](https://github.com/Igglybuff/awesome-piracy/blob/master/pastebin.url).

## How to use this list
Some items in this list could easily fit in more than one category, so to make sure you find what you're looking for please use `Ctrl + F` (or `Cmd + F` on macOS).

## Emoji
You will notice some items on this list have a :star2: next to them. Items with a :star2: represent the author's top pick for that category. This is an entirely opinionated rating from someone who doesn't know everything about every item on the list, so be sure to check out alternative options before assuming something is "the best". That said, I do explore and test every resource I add to this list wherever possible.

## Background Information
- [Wikipedia "File sharing" category](https://en.wikipedia.org/wiki/Category:File_sharing) Wikipedia's full list of file-sharing related articles.

## Contents
- [VPNs](#vpns)
    - [VPN Guides and Tutorials](#vpn-guides-and-tutorials)
    - [VPN Subscription Services](#vpn-subscription-services)
    - [Self-hosted VPNs](#self-hosted-vpns)
- [Browser Extensions](#browser-extensions)
- [Userscripts](#userscripts)
- [Password Vaults](#password-vaults)
- [Antivirus](#antivirus)
- [Privacy](#privacy)
    - [Windows 10 Privacy](#windows-10-privacy)
- [Email](#email)
- [Operating Systems](#operating-systems)
- [Decentralised Networks](#decentralised-networks)
- [Domain Names](#domain-names)
- [Torrenting](#torrenting)
    - [Trackers](#trackers)
        - [Private Trackers](#private-trackers)
        - [Semi-Private Trackers](#semi-private-trackers)
        - [Public Trackers](#public-trackers)
    - [Tracker Aggregators](#tracker-aggregators)
    - [Tracker Proxies](#tracker-proxies)
    - [Tracker Invites](#tracker-invites)
    - [Torrent Clients](#torrent-clients)
    -   - [Deluge](#deluge)
        - [rTorrent](#rtorrent)
        - [WebTorrent Clients](#webtorrent-clients)
    - [autodl-irssi](#autodl-irssi)
    - [Seedboxes](#seedboxes)
        - [Web-based Cloud Seedboxes](#web-based-cloud-seedboxes)
        - [Seedbox Hosting Providers](#seedbox-hosting-providers)
        - [Seedbox Setup Tools and Guides](#seedbox-setup-tools-and-guides)
    - [Tracker Frameworks](#tracker-frameworks)
- [Usenet](#usenet)
    - [Usenet Providers](#usenet-providers)
    - [Usenet Indexers](#usenet-indexers)
        - [Usenet Indexing Software](#usenet-indexing-software)
        - [Paid Indexers](#paid-indexers)
        - [Free Indexers](#free-indexers)
    - [Usenet Clients](#usenet-clients)
- [Direct Downloads](#direct-downloads)
    - [Download Managers](#download-managers)
    - [DDL Tools](#ddl-tools)
    - [Custom Google Search Engines](#custom-google-search-engines)
    - [FTP Indexers](#ftp-indexers)
    - [DDL Search Engines and Crawlers](#ddl-search-engines-and-crawlers)
    - [DDL Link Sites](#ddl-link-sites)
    - [Premium Link Generators](#premium-link-generators)
    - [Premium Link Hosts](#premium-link-hosts)
    - [Open Directories](#open-directories)
    - [Streaming Sites](#streaming-sites)
        - [HD Streaming](#hd-streaming)
        - [Big Media Libraries](#big-media-libraries)
        - [TV](#tv)
        - [Anime](#anime)
        - [Cartoons](#cartoons)
        - [Sports Streaming](#sports-streaming)
        - [Specialty Sites](#specialty-sites)
        - [Openload Hosts](#third-party-hosts)
- [Media Centre Applications](#media-centre-applications)
- [Stremio](#stremio)
- [Plex](#plex)
    - [Plex Plugins](#plex-plugins)
    - [Plex Requests](#plex-requests)
    - [Plex Scripts and Tools](#plex-scripts-and-tools)
    - [Plex Shares](#plex-shares)
    - [Plex Transcoding](#plex-transcoding)
    - [Plex Logging and Metrics](#plex-logging-and-metrics)
    - [Plex Clients](#plex-clients)
- [Kodi](#kodi)
- [Gaming](#gaming)
    - [Repacks](#repacks)
    - [ROMs](#roms)
    - [Console Games](#console-games)
    - [Homebrew and Custom Firmware](#homebrew-and-custom-firmware)
- [Music](#music)
    - [Music Streaming](#music-streaming)
    - [Music Downloading](#music-downloading)
    - [Spotify](#spotify)
    - [iTunes](#itunes)
- [Software](#software)
- [Ebooks](#ebooks)
- [Magazines](#magazines)
- [Academic Papers and Material](#academic-papers-and-material)
- [Textbooks](#textbooks)
- [Courses and Tutorials](#courses-and-tutorials)
- [Audiobooks](#audiobooks)
- [Comicbooks](#comicbooks)
- [Manga](#manga)
- [Documentaries](#documentaries)
- [Fonts, Icons and Graphics](#fonts-icons-and-graphics)
- [Automation](#automation)
    - [TV Automation](#tv-automation)
    - [Movie Automation](#movie-automation)
    - [Music Automation](#music-automation)
    - [Subtitles Automation](#subtitles-automation)
- [P2P Networks](#p2p-networks)
- [Ripping, Transcoding, Converting, Encoding](#ripping-transcoding-converting-encoding)
- [Cloud Storage](#cloud-storage)
- [File Renaming and Tagging](#file-renaming-and-tagging)
- [Mobile Apps](#mobile-apps)
    - [Streaming Apps](#streaming-apps)
    - [Torrent Apps](#torrent-apps)
    - [APKs](#apks)
- [Discord Servers](#discord-servers)
- [IPTV and DVR](#iptv-and-dvr)
    - [Acestreams](#acestreams)
- [IRC](#irc)
    - [IRC Clients](#irc-clients)
    - [IRC Networks](#irc-networks)
    - [IRC Search Engines](#irc-search-engines)
- [DC++](#dc)
- [Full Movies On](#full-movies-on)
- [Piracy Blogs and News](#piracy-blogs-and-news)
- [Content Discovery](#content-discovery)
    - [PreDB Sites](#predb-sites)
- [Dashboards and Homepages](#dashboards-and-homepages)
- [Proxy Sites](#proxy-sites)
- [File Sharing Tools](#file-sharing-tools)
- [Stream Synchronisation](#stream-synchronisation)
- [Telegram Piracy](#telegram-piracy)
- [Miscellaneous](#miscellaneous)

## VPNs

### VPN Guides and Tutorials
- [That One Privacy Site](https://thatoneprivacysite.net/vpn-section/) VPN section of That One Privacy Site with VPN comparisons
- [Choosing the best VPN (for you)](https://www.reddit.com/r/VPN/comments/4iho8e/that_one_privacy_guys_guide_to_choosing_the_best/?st=iu9u47u7&sh=459a76f2) That One Privacy Guy's - Guide to Choosing the Best VPN (for you)
- [/r/VPN wiki](https://www.reddit.com/r/VPN/wiki/index) Helpful FAQ-type resource composed by the folks at /r/VPN
- [Choosing the VPN that's right for you](https://ssd.eff.org/en/module/choosing-vpn-thats-right-you) Helpful guide from the EFF
- [Which VPN services keep you anonymous in 2018?](https://torrentfreak.com/vpn-services-keep-anonymous-2018/) TorrentFreak Article by Ernesto
- [privacytools.io](https://www.privacytools.io/) "Encryption against global mass surveillance". Plenty of information to help protect your privacy online.
- [VPN over SSH](https://wiki.archlinux.org/index.php/VPN_over_SSH) ArchWiki page describing how to achieve a poor man's VPN with SSH tunneling
- [/r/VPNTorrents](https://www.reddit.com/r/VPNTorrents) This is for the discussion of torrenting (and similar P2P protocols) using VPN type technology.

### VPN Subscription Services
- [Private Internet Access](https://www.privateinternetaccess.com/) :star2: Hugely popular subscription-based VPN provider with a proven track record for not keeping logs
- [Mullvad](https://mullvad.net/en/) A Bitcoin-friendly, privacy-first VPN.
- [ProtonVPN](https://protonvpn.com/) High-speed Swiss VPN that safeguards your privacy.
- [NordVPN](https://nordvpn.com/) With NordVPN, encrypt your online activity to protect your private data from hackers or snoopy advertisers.
- [Windscribe](https://windscribe.com/) Simple VPN, has a free plan that gives you 10gb/mo bandwidth, paid version even has port forwarding for static IPs, privacy-focused.
- [ExpressVPN](https://www.expressvpn.com/vpnmentor1) VPN with 256-bit encryption, 94 countries, and no logs. It is also rated as one of the fastest VPNs out there.

### Self-hosted VPNs
- [n2n](https://github.com/ntop/n2n) Peer-to-peer VPN
- [PeerVPN](https://peervpn.net/) PeerVPN is a software that builds virtual ethernet networks between multiple computers.
- [OpenVPN](https://openvpn.net/) :star2: OpenVPN provides flexible VPN solutions to secure your data communications, whether it's for Internet privacy, remote access for employees, securing IoT, or for networking Cloud data centers.
- [Nebula](https://github.com/slackhq/nebula) A scalable overlay networking tool with a focus on performance, simplicity and security
- [Pritunl](https://pritunl.com/) Enterprise Distributed OpenVPN and IPsec Server
- [WireGuard VPN](https://www.wireguard.com/) WireGuard is an extremely simple yet fast and modern VPN that utilizes state-of-the-art cryptography. It aims to be faster, simpler, leaner, and more useful than IPSec.
- [sshuttle](https://github.com/sshuttle/sshuttle) Transparent proxy server that works as a poor man's VPN.
- [ZeroTier](https://www.zerotier.com) Peer-to-peer multi-platform VPN
- [Outline by Alphabet](https://www.getoutline.org/) Not exactly a VPN, but is strong in privacy and security. Works with DO, Google Cloud, AWS and more.
- [Mysterium Network](https://mysterium.network/) Open-source VPN client and server software. It can be used to sell your spare bandwidth for cryptocurrency.
- [tinc](https://tinc-vpn.org/) Peer-to-peer VPN software with mesh routing.
- [OpenConnect](https://www.infradead.org/openconnect/) Multiplatform VPN compatible with Cisco's AnyConnect. Uses well-tested, standard TLS connections which easily bypass DPI.
- [Shadowsocks](https://shadowsocks.org/) Secure SOCKS proxy used in China for bypassing the Great Firewall.

## Browser Extensions
- [Decentraleyes](https://decentraleyes.org/) Protects against tracking with a local CDN (Content Delivery Network) emulation.
- [Privacy Badger](https://www.eff.org/privacybadger) Privacy Badger blocks spying ads and invisible trackers.
- [HTTPS Everywhere](https://www.eff.org/https-everywhere) HTTPS Everywhere is a Firefox, Chrome, and Opera extension that encrypts your communications with many major websites, making your browsing more secure.
- [uBlock Origin](https://github.com/gorhill/uBlock) :star2: An efficient blocker for Chromium and Firefox. Fast and lean.
- [TamperMonkey](https://chrome.google.com/webstore/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo?hl=en) The world's most popular userscript manager
- [WebRTC Network Limiter](https://chrome.google.com/webstore/detail/webrtc-network-limiter/npeicpdbkakmehahjeeohfdhnlpdklia?hl=en) Configures how WebRTC's network traffic is routed by changing Chrome's privacy settings.
- [ScriptSafe](https://chrome.google.com/webstore/detail/scriptsafe/oiigbmnaadbkfbmpbfijlflahbdbdgdf?hl=en) A browser extension that gives users control of the web and more secure browsing while emphasizing simplicity and intuitiveness.
- [NoScript](https://noscript.net/getit) Allow active content to run only from sites you trust, and protect yourself against XSS and clickjacking attacks. Firefox only.
- [Burlesco](https://burles.co/en/) Read the news without subscribing, bypass the paywall
- [Universal Bypass](https://github.com/Sainan/Universal-Bypass) Universal Bypass automatically skips annoying link shorteners.
- [Violentmonkey](https://violentmonkey.github.io/) An open-source userscript manager.
- [Anti-Paywall](https://github.com/nextgens/anti-paywall) A browser extension that maximizes the chances of bypassing paywalls
- [Google Unlocked](https://github.com/Ibit-to/google-unlocked) Uncensor google search results.

## Userscripts
- [IMDb Scout](https://greasyfork.org/en/scripts/3967-imdb-scout) Add links from IMDb pages to torrent sites -- easy downloading from IMDb
- [AdsBypasser](https://adsbypasser.github.io/) This user script helps you to skip countdown ads or continue pages and prevent ad pop-up windows.
- [AntiAdware](https://greasyfork.org/en/scripts/4294-antiadware) Remove forced download accelerators, managers, and adware on supported websites
- [Direct download from Google Play](https://greasyfork.org/en/scripts/33005-direct-download-from-google-play/) Adds APKPure, APKMirror and Evozi download buttons to Google Play when browsing apps.
- [AdGuard Popup Blocker](https://github.com/AdguardTeam/PopupBlocker) Popup Blocker by AdGuard is a userscript that blocks all unwanted pop-up windows in different browsers.
- [openload](https://greasyfork.org/en/scripts/17665-openload) Remove anti-Adblock, ads, pop-ups, and timer waits, and show direct download link on OpenLoad.
- [anti-anti-copy](https://greasyfork.org/en/scripts/7197-anti-anti-copy) some websites prevent you from copying text. this script bypasses it.
- [Torrentz2 Magnet](https://greasyfork.org/en/scripts/21547-torrentz2-magnet) Add magnet link to torrentz2
- [Bypass paywalls for scientific documents](https://greasyfork.org/en/scripts/35521-bypass-paywalls-for-scientific-documents) This script adds download buttons on Google Scholar, Scopus, and Web Of Science, which lead to sci-hub.tw.
- [Google Drive Direct Links](https://greasyfork.org/en/scripts/10052-google-drive-direct-links/feedback) Direct link functionality for Google Drive
- [Bypass Google Sorry (reCAPTCHA)](https://greasyfork.org/en/scripts/33226-bypass-google-sorry-recaptcha) Redirect Google reCAPTCHA to a new search window.
- [Google Image "View Image" button](https://greasyfork.org/en/scripts/38953-google-image-view-image-button) Add "View Image" button.
- [MoreCAPTCHA](https://greasyfork.org/en/scripts/31088-morecaptcha) Speeds up solving Google reCAPTCHA challenges by shortening transition effects and providing continuous selection ability.
- [MAL-Sync](https://greasyfork.org/en/scripts/372847-mal-sync) Integrates MyAnimeList into various sites, with auto episode tracking.
- [Remove fake TPB torrents](https://www.reddit.com/r/Piracy/comments/78aicx/i_wrote_a_small_script_that_automatically_hides/) Script that automatically hides fake torrents on The Pirate Bay based on conditional logic.
- [Get DLC Info from SteamDB](https://cs.rin.ru/forum/viewtopic.php?t=71837) For use with CreamAPI and similar tools.
- [The Pirate Bay Cleaner](https://greasyfork.org/en/scripts/1573-the-pirate-bay-cleaner) Auto-sorting, torrentifying, theme-change, search-change, SSL/HTTPS and more.

## Password Vaults
- [BitWarden](https://bitwarden.com/) :star2: Open source password management solution, can be self-hosted
- [1Password](https://1password.com/) Popular cloud-hosted password manager
- [KeePass](https://keepass.info/) Free, open source, light-weight, and easy-to-use password manager.
  - [Plugins](https://keepass.info/plugins.html) : A list of third-party plugins for KeePass
  - Android: [Keepass2Android](https://github.com/PhilippC/keepass2android)
  - iPhone: [KeePassium](https://keepassium.com/)
  - Chrome: [Tusk](https://chrome.google.com/webstore/detail/keepass-tusk-password-acc/fmhmiaejopepamlcjkncpgpdjichnecm)
  - Firefox: [Tusk](https://addons.mozilla.org/en-US/firefox/addon/keepass-tusk)
  - Web App: [KeeWeb](https://keeweb.info/)
- [LastPass](https://www.lastpass.com/) LastPass remembers all your passwords, so you don't have to.
- [Pass](https://www.passwordstore.org/) Simple GPG/Git password manager. Follows the Unix philosophy.
- [Dashlane](https://www.dashlane.com/) An intuitive password manager with over with over 8 million users worldwide.
- [Passbolt](https://www.passbolt.com/) Free, open source, self-hosted, extensible, OpenPGP based.
- [LessPass](https://lesspass.com/) Stateless open source password manager
- [Psono](https://psono.com/) Open source and self-hosted password manager for teams
- [Buttercup](https://buttercup.pw/) Another open source password manager with desktop, mobile, and browser clients.

## Antivirus
- [MalwareBytes](https://www.malwarebytes.com/) :star2: "crushes malware so you are protected and your machine keeps running smoothly."
- [HitmanPro](https://www.hitmanpro.com) Antivirus product from Sophos
- [VirusTotal](https://www.virustotal.com/) Web service for scanning files and URLs for viruses
- [How to remove viruses and malware on your Windows PC](https://www.howtogeek.com/126911/what-to-do-if-you-get-a-virus-on-your-computer/) Helpful HowToGeek article on cleaning out the pipes
- [Avast Antivirus](https://www.avast.com) Avast Antivirus is a multi-platform antivirus application with a free tier. Be sure to opt-out of sending anonymous usage statistics.

## Privacy
- [Prism Break](https://prism-break.org/en/) Opt out of global data surveillance programs like PRISM, XKeyscore, and Tempora.
- [/r/privacy](https://www.reddit.com/r/privacy/) The intersection of technology, privacy, and freedom in a digital world.
- [Any Soft Keyboard](https://github.com/AnySoftKeyboard/AnySoftKeyboard) A privacy-focused keyboard

### Windows 10 Privacy
- [O&O ShutUp10](https://www.oo-software.com/en/shutup10) O&O ShutUp10 means you have full control over which comfort functions under Windows 10 you wish to use, and you decide when the passing on of your data goes too far.
- [Windows 10 Privacy Guide](https://github.com/adolfintel/Windows10-Privacy) :star2: an In-depth guide on purging Windows 10 of Microsoft's attempts to track you
- [Windows Privacy Tweaker](https://www.phrozen.io/freeware/windows-privacy-tweaker/) Freeware app from phrozen.io
- [Winaero](https://winaero.com/blog/about-us/) Free, small and useful software for Windows.
- [WPD](https://wpd.app/) The real privacy dashboard for Windows
- [Destroy-Windows-10-Spying](http://m.majorgeeks.com/files/details/destroy_windows_10_spying.html) Destroy Windows Spying tool
- [Tron](https://www.reddit.com/r/TronScript) Tron, an automated PC cleanup script
- [Tallow](https://github.com/basil00/TorWall) Tallow is a transparent Tor firewall and proxying solution for Windows.

## Email
- [ProtonMail](https://protonmail.com/) Secure Email Based in Switzerland
- [10 Minute Mail](https://10minutemail.net/) Disposable, private mailboxes
- [Cock.li](https://cock.li/) Yeah it's mail with cocks
- [Tutanota](https://tutanota.com/) Secure, open source email service

## Decentralised Networks
- [Tor](https://www.torproject.org/) :star2: Tor is free software and an open network that helps you defend against traffic analysis.
- [I2P](https://geti2p.net/en/) I2P is an anonymous overlay network - a network within a network. It is intended to protect communication from dragnet surveillance and monitoring by third parties such as ISPs.
- [Freenet](https://freenetproject.org) Freenet is free software which lets you anonymously share files, browse and publish "freesites" (web sites accessible only through Freenet) and chat on forums, without fear of censorship.
- [Zeronet](https://zeronet.io/) Open, free and uncensorable websites, using Bitcoin cryptography and BitTorrent network
- [Loki](https://github.com/loki-project/loki-network) Lokinet is an anonymous, decentralized and IP based overlay network for the internet.
- [IPFS](https://ipfs.io/) A peer-to-peer hypermedia protocol designed to make the web faster, safer, and more open.
- [Yggdrasil](https://yggdrasil-network.github.io/about.html) Makes use of a global spanning tree to form a scalable IPv6 encrypted mesh network.

## Operating Systems
- [Qubes OS](https://www.qubes-os.org/) Qubes OS is a security-oriented operating system
- [Tails](https://tails.boum.org/) Tails is a live operating system that you can start on almost any computer from a USB stick or a DVD.

## Domain Names
- [Njalla](https://njal.la/) a privacy-aware domain registration service
- [xip.io](http://xip.io/) magic domain name that provides wildcard DNS
for any IP address.
- [Domainr](https://domainr.com/) Domainr finds domain names and short URLs. Instantly check availability and register for all top-level domains.

## Torrenting
- [/r/torrents](https://www.reddit.com/r/torrents) Questions and discussion about all things torrent-related
- [BitTorrent](https://en.wikipedia.org/wiki/BitTorrent) Wikipedia's article on the BitTorrent file sharing protocol
- [Live Tracer](https://trace.corrupt-net.org/live.php) Pre-time tracer for scene releases
- [magent2torrent.me](http://magnet2torrent.me/) Converts magnet links to torrent files
- [mgnet.me](http://mgnet.me/) Magnet URI shortener
- [Torrage](https://torrage.info/) Torrage is a free service for caching torrent files online.
- [peerflix Google Search](https://www.google.com/search?q=peerflix+site%3Aherokuapp.com) Searches Heroku-deployed instances of Peerflix for streaming torrents
- [Torznab](https://nzbdrone.readthedocs.io/Implementing-a-Torznab-indexer/) Newznab-like API offering a standardized recent/search API for both TV and movies
- [xbit](https://xbit.pw) Magnet link repository
- [torrents.csv](https://gitlab.com/dessalines/torrents.csv) Torrents.csv is a collaborative repository of torrents, consisting of a single, searchable torrents.csv file.
- [torrents-csv.ml](https://torrents-csv.ml) The above torrents.csv hosted.
- [mktorrent](https://github.com/Rudde/mktorrent) mktorrent is a simple command line utility to create BitTorrent metainfo files.
- [Torrent Paradise](https://torrent-paradise.ml/) IPFS-based decentralised torrent search engine.
- [torrent.nz](https://torrent.nz/) Torrent.nz is a magnet torrent search engine.
- [magnetico](https://github.com/boramalper/magnetico) Autonomous (self-hosted) BitTorrent DHT search engine suite

### Trackers
- [/r/trackers](https://www.reddit.com/r/trackers) :star2: A subreddit for discussing public & private trackers.
- [A Simple Guide To A Better Ratio](https://www.reddit.com/r/trackers/comments/fthja/a_simple_guide_to_a_better_ratio/) A good tracker requires you to upload what you download. This guide explains many of the methods involved with keeping on top of this sometimes difficult task.
- [Tracker Twitters](https://filenetworks.blogspot.com/2010/12/list-of-private-torrent-trackers.html) List Of Private Torrent Trackers & BitTorrent News Accounts To Follow On Twitter
- [Bravo List](http://www.bvlist.com/) Tracker directory

#### Private Trackers
- [AlphaRatio ](https://alpharatio.cc) (AR) :star2: A good starter tracker with lots of freeleech content.
- [AnimeBytes](https://animebytes.tv/) (AB) community centralized around Japanese media, including anime, manga, and music
- [Audionews](https://audionews.org/) (AN) Private torrent tracker for music production audio. (DJ apps, audio editor, DAW apps, etc) Open signups on the 1st-2nd every month.
- [Awesome HD](https://awesome-hd.me/) (AHD) Awesome-HD is a private tracker for quality enthusiasts.
- [BakaBT](https://bakabt.me/) (BBT) a torrent tracker which specializes in serving anime fans
- [BeyondHD](https://beyondhd.xyz/) (BHD) BeyondHD is a ratioless torrent tracker dedicated to HD movies and TV shows in High Definition.
- [Bibliotik](https://bibliotik.me/) (BI) Popular ebooks/audiobooks private tracker
- [Bitspyder](http://bitspyder.net/) (BS) Bitspyder is an educational torrent site devoted to e-Learning content such as e-Books, video courses, and audiobooks.
- [Blutopia](https://blutopia.xyz) (BLU) Blutopia is a private tracker for HD movies and HD TV shows.
- [CGPeers](https://www.cgpeers.com/) (CGP) CGPeers is a private torrent tracker for all things computer graphics: tutorials, graphics software, 3D, visual effects, design, and computer-assisted art.
- [Filelist](https://filelist.io/) (FL) Large Romanian general tracker with mostly English content. No RAR files allowed. (Scene torrents are unrared, and then allowed.)
- [GazelleGames](https://gazellegames.net/login.php) (GGn) Currently the largest private tracker for games.
- [HD4Free](https://hd4.xyz) (HD4F) HD4Free is a general HD tracker with a good range of content. It is a ratioless tracker so it is great for beginners. Note that any adult content/porn is strictly prohibited there.
- [HD-Forever](https://hdf.world/) (HD-F) HD-Forever is a French private tracker for HD movies.
- [HD-Space](https://hd-space.org/) (HDS) HD-Space is a private torrent tracker hosting HD movies, TV shows, and music torrents. Good tracker for beginners.
- [IPTorrents](https://iptorrents.com/) (IPT) Private tracker with movies, books, and more.
- [JPopsuki](https://jpopsuki.eu/) (JPop) JPopsuki is a torrent tracker focused on Asian music.
- [MyAnonaMouse](https://www.myanonamouse.net/) (MAM) Private E-Learning tracker with about 360 000 torrents including audiobooks, e-learning, musicology, and radio.
- [MySpleen](http://www.myspleen.org/login.php) (MS) MySpleen is a private tracker which specialises in comedy, animation, and TV series.
- [Nostalgic Torrents](https://nostalgic.is/) (NT) Private tracker for anime, comics/manga, documentaries, movies, TV - PRE 2013, TV - PRE 2009 With Original Commercials, etc. Also known as The-Archive and HeyNow.
- [PassThePopcorn](https://passthepopcorn.me/) (PTP) ratio-based torrent tracker for movies
- [PolishTracker](https://pte.nu/) (PT) PolishTracker is the oldest private Polish tracker existing to this day
- [PolishSource](https://polishsource.cz/) (PS) PolishSource is a big private Polish ratio-less tracker
- [PrivateHD](https://privatehd.to/) (PhD) PrivateHD is a private BitTorrent tracker focused on high definition movies and TV show torrents.
- [Redacted](https://redacted.ch/) (RED) Largest private music tracker at 1.5 million torrents.
- [TheGeeks](https://thegeeks.click/) (TGBZ) Private tracker for e-learning
- [TorrentLeech](https://torrentleech.org/) (TL) Well-known popular private tracker
- [TVChaos UK](https://www.tvchaosuk.com/) (TVCUK) Private tracker for British television
- [UHDBits](https://uhdbits.org/) (UHD) UHDBits is a Vietnamese private torrent tracker focused on HD movies and TV shows.
- [WorldOfP2P](https://worldofp2p.net) (WOP) Private tracker for Movies, TV, and General.
- [/PTG tracker manifesto](https://pastebin.com/thLgSkNE) List of private trackers
- [0QoLttS.jpg](https://i.imgur.com/0QoLttS.jpg) Screenshot of a table from somewhere of private trackers and their sign-up requirements
- [Private Tracker Flowchart](https://wiki.installgentoo.com/images/9/97/Private_tracker_flowchart.png) V4 of the private tracker flowchart. Somewhat out of date.
- [Private trackers](https://wiki.installgentoo.com/index.php/Private_trackers) Guide on how to get into (and survive) the world of private trackers.
- [RED Interview Prep](https://interviewfor.red/en/index.html) This site was written as a guide for potential users to learn about music formats, transcodes, torrenting, and burning and ripping — everything you need to know to pass the RED interview.
- [Tracker Spreadsheet](https://docs.google.com/spreadsheets/d/1zYZ2107xOZwQ37AjLTc5A4dUJl0ilg8oMrZyA0BGvc0/edit#gid=1357476050) Comprehensive spreadsheet of private trackers (somewhat out of date)

#### Semi-Private Trackers
- [ruTracker](https://rutracker.org/forum/index.php) :star2: RuTracker is a huge Russian torrent site with a thriving file-sharing community.
- [Zamunda.net](http://zamunda.net) A Bulgarian tracker with English and Russian translations available.
- [ArenaBG](https://arenabg.com/) A Bulgarian tracker with an English translation available.
- [NoNaMe Club](https://nnmclub.to/) Russian semi-private tracker and forum
- [MetalArea](https://metalarea.org/) Russian (someplaces english) tracker for obscure metal and dungeon synth.

#### Public Trackers
- [1337x](https://1337x.to/) 1337x is a torrent site that offers verified torrent downloads.
- [ETTV](https://www.ettv.tv/) ETTV is a torrent site specific for movie torrents.
- [EZTV](https://eztv.ag/) EZTV is a torrent site for TV shows founded by TV-torrent distribution group EZTV.
- [Isohunt2](https://isohunt2.net/) Clone of the original isoHunt torrent index and repository
- [KickAss Torrents](https://katcr.co/) Community-made reincarnation launched in 2016
- [RARBG](https://rarbg.to/) :star2: Public tracker with its own release group
- [YTS](https://yts.am/) Small-size HD movies from YIFY
- [The Pirate Bay](https://thepiratebay.org/) Infamous torrent site which is somehow still running, blocked in most places but can be [accessed](https://piratebayblocked.com/) [via](https://cruzing.xyz/) [numerous](https://thepiratebay.vin/) [proxy](https://pirateproxy.life/) [sites](https://tpbproxy.online/)
- [The Proxy Bay](https://proxybay.bz/) Can't access The Pirate Bay? Try one of these proxy sites.
- [Idope (Clone)](https://idope.se/) iDope is a torrent search engine presenting direct magnet links, comments and up to date seeder/leecher statistics.
- [Torrentz2](https://torrentz2.is/) A good replacement of the defunct Torrentz.eu [other](https://torrentsmirror.com/) [mirrors](https://torrentz.pl/)
- [Zooqle](https://zooqle.com/) Zooqle is a relatively new torrent index providing a huge database of verified torrents.
- [rutor](http://rutor.info/) Russian tracker
- [GloTorrents](https://glodls.to/) Download Movies, TV, Games and Other Torrents Free
- [BTDB](https://btdb.to/) Large BitTorrent DHT search engine
- [trackerslist](https://github.com/ngosang/trackerslist) An updated list of public BitTorrent trackers
- [MagnetDL](http://www.magnetdl.com/) Magnet link only search engine
- [TorrentGalaxy](https://torrentgalaxy.org/) Public tracker with a clean UI which now supports embedded streaming for internal uploads
- [Games4theworld](https://games4theworld.org) Torrents and magnet links for games
- [metal-tracker.com](http://en.metal-tracker.com/) Heavy metal music tracker
- [SkyTorrents](https://www.skytorrents.lol/) Revival of the recently-shut-down, privacy-focused, ad-free torrent indexer
- [Pirateiro](http://pirateiro.com/) Pirateiro is a torrent index for Brazilian and Portuguese torrents.
- [TorrentKing](https://torrentking.io/) Torrentking is a popular movie torrent site.
- [moviemagnet](http://moviemagnet.co/) Verified torrents for movies.
- [Zonatorrent](https://zonatorrent.tv/) Spanish tracker
- [TorrentFunk](https://www.torrentfunk.com/) TorrentFunk is a torrent site providing verified torrents for all kinds of content.
- [HDSector](http://udush.com/) Bollywood / Hindi / Hollywood HD Movies
- [OTorrents](https://otorrents.com/) Yet another public torrent tracker
- [Torlock](https://www.torlock.com/) Torlock is a torrent index and torrent search that helps to access the latest in TV series and movies.
- [DIGBT](https://www.digbt.org/) DIGBT is a DHT torrent search engine.
- [Torrent9](https://www.torrent9.ph/) French torrent search engine
- [YggTorrent](https://yggtorrent.si/) French tracker and search engine (have a download/upload ratio limitation)
- [WorldWide Torrents](https://worldwidetorrents.me/) Another public tracker with a reasonably nice UI
- [Rock Box](https://rawkbawx.rocks/) Metal music tracker
- [Music Torrent](http://music-torrent.net) General music tracker
- [7torrents](https://www.7torrents.cc/) Fast, clean, ad-free, privacy-focused DHT search engine

### Tracker Aggregators
- [snowfl](https://snowfl.com/) snowfl is a torrent aggregator which searches various public torrent indexes in real-time
- [Torrents.me](https://torrents.me/) Torrents.me combines popular torrent sites and specialized private trackers in a torrent multisearch.
- [rats-search](https://github.com/DEgITx/rats-search) P2P Bittorrent search engine
- [AIO Search](http://www.aiosearch.com/) Torrent search engine
- [SolidTorrents](https://solidtorrents.net) :star2: A clean, privacy focused torrent search engine.

### Tracker Proxies
- [Jackett](https://github.com/Jackett/Jackett) API Support for your favorite torrent trackers.
- [Cardigann](https://github.com/cardigann/cardigann) A proxy server for adding new indexers to Sonarr, SickRage, and other media managers
- [nzbhydra2](https://github.com/theotherp/nzbhydra2/) :star2: Primarily a Usenet metasearch engine but also supports Torznab

### Tracker Invites
- [/r/OpenSignups](https://www.reddit.com/r/opensignups) Open Signups - When Private Trackers Open Their Doors To The Public
- [/r/Invites](https://www.reddit.com/r/invites) Post wanted ads for private tracker invites here
- [Open sign-ups thread](https://www.reddit.com/r/trackers/comments/7ildxx/open_signups_thread/) /r/trackers thread for posting trackers that are currently open for registration.
- [Opentrackers.org](https://opentrackers.org/) Private Torrent Trackers & File Sharing
- [getting_into_private_trackers](https://www.reddit.com/r/trackers/wiki/getting_into_private_trackers) :star2: Helpful resource from the /r/trackers wiki

### Torrent Clients
- [qBitTorrent](https://www.qbittorrent.org/) Popular, lightweight, multi-platform torrent client
- [qBitTorrent search function](https://www.techsupportalert.com/qbittorrent-help-torrent-search-engine) Allows you to search popular trackers directly from qBittorrent
- [qBitTorrent plugins for public sites](https://github.com/qbittorrent/search-plugins/wiki/Unofficial-search-plugins#plugins-for-public-sites) List of qBitTorrent plugins for searching public torrent sites.
- [Transmission](https://transmissionbt.com/) Default torrent client in many distros.
- [Popcorn Time](https://github.com/popcorn-official/popcorn-desktop) Popcorn Time is a multi-platform, free software BitTorrent client that includes an integrated media player.
- [Butter Project](http://butterproject.org/) A legal fork of Popcorn Time which is configurable to allow for custom sources of video
- [BitLord](http://www.bitlord.com/) Another BitTorrent streaming client
- [Tixati](https://tixati.com/) Lightweight torrent client for Windows and Linux
- [PicoTorrent](https://picotorrent.org/) A lightweight and minimalistic torrent client for Windows
- [FrostWire](https://www.frostwire.com/) FrostWire is a Free and open-source BitTorrent client first released in September 2004, as a fork of LimeWire.
- [peerflix](https://github.com/mafintosh/peerflix) Streaming torrent client for node.js
- [RapidBay](https://github.com/hauxir/rapidbay) Rapid bay is a self-hosted video service/torrent client that makes playing videos from torrents easy.
- [Tornado](https://tornado-torrent.gitlab.io/posts/first-beta/) Tornado is a modern web-first BitTorrent client designed with usability in mind. Based on Transmission.

#### Deluge
- [Deluge](https://www.deluge-torrent.org/) :star2: Deluge is a lightweight, Free Software, cross-platform BitTorrent client.
- [AutoRemovePlus](https://github.com/omaralvarez/deluge-autoremoveplus) Auto removing of deluge torrents
- [ltConfig](https://github.com/ratanakvlun/deluge-ltconfig/releases)
ltConfig is a plugin for Deluge that allows direct modification to libtorrent settings and has preset support.
- [Deluge Plugins](https://dev.deluge-torrent.org/wiki/Plugins) List of official and third-party plugins for Deluge

#### rTorrent
- [rTorrent](https://rakshasa.github.io/rtorrent/) :star2: rTorrent is a text-based ncurses BitTorrent client written in C++
- [ruTorrent](https://github.com/Novik/ruTorrent) Yet another web front-end for rTorrent
- [rTorrent Community wiki](https://github.com/rtorrent-community/rtorrent-community.github.io/wiki) GitHub wiki for rTorrent
- [rTorrent Docs](https://rtorrent-docs.readthedocs.io/en/latest/) Comprehensive manual and user guide for the rTorrent bittorrent client
- [rutorrent-themes](https://github.com/InAnimaTe/rutorrent-themes) A collection of default and new, original themes for ruTorrent.
- [flood](https://github.com/jfurrow/flood) A web UI for rTorrent with a Node.js backend and React frontend.
- [rTorrent ArchWiki Page](https://wiki.archlinux.org/index.php/RTorrent) Detailed article to answer most common questions about rTorrent
- [rTorrent Seedbox Guide](https://jes.sc/kb/rTorrent-ruTorrent-Seedbox-Guide.php) This guide is a single-page, comprehensive guide to take you step-by-step through installation and configuration.
- [rtorrent-ps](https://github.com/pyroscope/rtorrent-ps) Extended rTorrent distribution with a fully customizable canvas and colors, other feature additions, and complete docs.
- [pyrocore](https://github.com/pyroscope/pyrocore) A collection of tools for the BitTorrent protocol and especially the rTorrent client
- [rTorrent research](https://calomel.org/rtorrent_mods.html) security modifications and other hacks for usability
- [rutorrent-all-seeders](https://github.com/AkdM/rutorrent-all-seeders) This ruTorrent plugin adds the columns 'All Seeders' to the torrents list.

#### WebTorrent Clients
- [magnetoo](https://www.magnetoo.io/) Fancy new in-browser WebTorrent streaming service
- [βTorrent](https://btorrent.xyz/) fully-featured [WebTorrent](https://webtorrent.io/) browser client written in HTML, JS and CSS
- [WebTorrent Desktop](https://webtorrent.io/desktop/) WebTorrent Desktop is for streaming torrents.
- [Instant.io](https://instant.io/) Streaming file transfer over WebTorrent (torrents on the web)

### autodl-irssi
- [autodl-irssi](https://autodl-community.github.io/autodl-irssi/) autodl-irssi is a plugin for irssi that monitors IRC announce channels for torrent trackers and downloads torrent files based on user-defined filters.
- [autodl-curl-sonarr](https://github.com/Zymest/autodl-curl-sonarr) Script to use as upload-command for autodl-irssi to post to Sonarr
- [mreg](https://github.com/Igglybuff/mreg) Generates a "Match releases" expression for your autodl-irssi filter based on dvdsreleasedates.com's "Most Requested DVD Release Dates" section.
- [Slack notifications for autodl-irssi](https://gist.github.com/Igglybuff/00d5e91274a562ac724d358bbbc8bc7b) Guide by yours truly on enabling Slack notifications for autodl-irssi

### Seedboxes
- [/r/seedboxes](https://www.reddit.com/r/seedboxes) A place to discuss seedboxes and everything related to them.
- [SeedSync](https://github.com/ipsingh06/seedsync) SeedSync is a GUI-configurable, LFTP-based file transfer and management program.

#### Web-based Cloud Seedboxes
- [Seedr](https://www.seedr.cc/) Essentially a seedbox you can paste torrents into which returns a streamable direct link
- [ZXCFiles](http://www.zxcfiles.net) A similar service that allows you to paste magnet links or upload torrent files and get a DDL. The first 20GB are free.
- [Bitport.io](https://bitport.io/) Another direct download site for pasting magnet links or .torrent files. Free accounts offer 1GB for free.
- [Torrent Safe](https://www.torrentsafe.com/) Free plan includes 1GB max file size, 2 days file lifetime. Discounts for paid subscriptions pop up on their [Facebook page](https://www.facebook.com/TorrentSafe/)
- [Furk.net](https://www.furk.net/) Free trial offers 1GB per day or 5GB per week if you can get an invite/voucher or use Facebook
- [FileStream.me](https://filestream.me/) The free subscription offers 200Mb max file size and 200GB storage total
- [2Giga.link](https://www.2giga.link/)
- [Foxleech](https://www.foxleech.com/) No free trial, plans start at $3 per month
- [Boxopus](https://boxopus.com/) No free trial, plans start at $0.99 per day
- [Put.io](https://put.io/) $0.99 1 day trial
- [Put.io automator](https://github.com/datashaman/putio-automator) A suite of commands for managing torrents, transfers, and files on Put.IO

#### Seedbox Hosting Providers
- [novaDedi](https://novadedi.net/index.php) novaDedi formerly known as metaDedi was created to help to find you the cheapest dedicated server for your intended use case.
- [CheckServers.OVH](https://checkservers.ovh/) Checks the availability of OVH servers.
- [Kimsufi](https://www.kimsufi.com/uk/) Affordable dedicated servers
- [Online.net](https://www.online.net/en) :star2: Seedbox-friendly, affordable, dedicated server host
- [Hetzner](https://hetzner.co.za/) Reliable and affordable server host
- [/u/Andy10gbit](https://www.reddit.com/r/seedboxes/comments/9iu7o8/andy10gbit_server_and_seedbox_list/) Reddit user with good deals on servers and seedboxes
- [Bytesized Hosting](https://bytesized-hosting.com/) "The best Plex server hosting in town"
- [FeralHosting](https://www.feralhosting.com/pricing) Shared seedbox hosting provider
- [Whatbox](https://whatbox.ca/) Whatbox is a BitTorrent CDN
- [Seedboxes.cc](https://seedboxes.cc/) Reliable and affordable web hosting, with the power of your friendly monsters!
- [UltraSeedbox](https://www.ultraseedbox.com/) "Plex optimized" servers to rent
- [SeedHost](https://www.seedhost.eu/seedboxes.php) "Seedhost.eu is the oldest continuously operating seedbox hosting provider on the internet."
- [Chmuranet](https://www.chmuranet.com/) Chmuranet is a small private boutique seedbox provider.
- [Xirvik](https://www.xirvik.com/) Preconfigured seedbox servers
- [OVH](https://www.ovh.com/world/) Large cloud server provider
- [SoYouStart](https://www.soyoustart.com/us/) Another dedicated server host
- [PulsedMedia](https://pulsedmedia.com/) Inexpensive seedbox provider
- [Cloudboxes.io](https://cloudboxes.io/) Seedboxes with impressive 20Gbps uplinks
- [Seedbox.io](https://seedbox.io/) Shared and dedicated slots with 1Gbps+ uplinks
- [Giga-Rapid.com](https://giga-rapid.com/gigaseedbox.php) Shared 1Gbps seedboxes with massive storage & lots of addon applications.

#### Seedbox Setup Tools and Guides
- [swizzin](https://swizzin.ltd/) a light, modular package management suite for media-oriented servers
- [Seedbox Guide](https://seedboxgui.de/) comparison tool to help you find the best fitting Seedbox
- [rtinst](https://github.com/arakasi72/rtinst) seedbox installation script for Ubuntu and Debian systems
- [sboxsetup](https://github.com/dannyti/sboxsetup) Another seedbox setup script
- [QuickBox IO](https://quickbox.io/) Seedbox installer script
- [MediaServer-DockerComposeFiles](https://github.com/vaeyo/MediaServer-DockerComposeFiles) Docker-Compose Files for Media Server Related Apps [Radarr, Sonarr, Plex, rTorrent, NZBGet, Ombi, Emby, etc]
- [usenet-docker](https://github.com/justinhamlett/usenet-docker) Docker-compose configuration for Sabnzbd, CouchPotato, Plex, Sonarr, Plexpy, Nzbhydra, Muximux, Radarr, NZBGet and Ombi with an Nginx proxy.
- [DockSTARTer](https://github.com/GhostWriters/DockSTARTer) DockSTARTer helps you get started with home server apps running in Docker.
- [OpenFLIXR](http://www.openflixr.com/) OpenFLIXR Media Server is an all-in-one media server for automated downloading and serving media.

### Tracker Frameworks
- [Torrent-Tracker-Platforms](https://github.com/HDVinnie/Torrent-Tracker-Platforms) A Curated List Of Torrent Tracker Platforms/Codebases Written In Multiple Coding Languages
- [UNIT3D](https://github.com/HDInnovations/UNIT3D) The Nex-Gen Private Torrent Tracker (Aimed For Movie / TV Use)
- [meanTorrent](https://github.com/taobataoma/meanTorrent) A BitTorrent Private Tracker CMS with Multilingual, and IRC announce support, Cloudflare support.
- [NexusPHP](https://github.com/ZJUT/NexusPHP) BitTorrent private tracker scripts written in PHP.
- [Gazelle](https://whatcd.github.io/Gazelle/) :star2: web framework geared towards private torrent trackers with a focus on music
- [opentracker](https://erdgeist.org/arts/software/opentracker/) Opentracker is an open and free BitTorrent tracker project.

## Usenet
- [Usenet](https://en.wikipedia.org/wiki/Usenet) Usenet is a worldwide distributed discussion system available on computers.
- [Usenet newsgroup](https://en.wikipedia.org/wiki/Usenet_newsgroup) A Usenet newsgroup is a repository usually within the Usenet system, for messages posted from many users in different locations using the Internet.
- [/r/Usenet](https://www.reddit.com/r/Usenet) :star2: a thriving community dedicated to helping users old and new understand and use Usenet.
- [/r/UsenetInvites](https://www.reddit.com/r/UsenetInvites) Requests and offers for Usenet indexers
- [NZBLINK](https://nzblnk.info/) The NZBLNK™ URI scheme defines the format of NZBLNK™ links to identify binary Usenet content and supplies some extra information to handle that content correct (similar to magnet links, but for NZBs).
- [Usenet-Uploaders](https://github.com/animetosho/Nyuu/wiki/Usenet-Uploaders) Table of applications for uploading content to Usenet
- [QuickPar](http://www.quickpar.org.uk/index.htm) Tool for reconstructing damaged/missing/corrupt Usenet binaries
- [NZB Monkey](https://nzblnk.info/nzb-monkey/) NZB download helper-tool
- [SABconnect++](https://github.com/gboudreau/sabconnectplusplus) Chrome extension which adds one-click 'Send to SABnzbd' buttons to many popular NZB index sites.

### Usenet Providers
- [Usenet Providers and Backbones](https://upload.wikimedia.org/wikipedia/commons/7/7d/Usenet_Providers_and_Backbones.svg) This is a simple overview of the current companies, backbones, providers and resellers in the Usenet landscape.
- [A Quick Guide to Choosing a Usenet Provider](https://www.reddit.com/r/usenet/comments/a7ffm7/a_quick_guide_to_choosing_a_usenet_provider/) Reddit post by /u/FlickFreak
- [Eweka](https://www.eweka.nl/) Netherlands-based Usenet provider
- [Newsdemon](https://www.newsdemon.com/) Cheap and cheerful Usenet provider with frequent discounts
- [Newsgroup Ninja](https://www.newsgroup.ninja/en) Popular Usenet provider with a competitive subscription fee
- [Usenet Express](http://usenetexpress.com/) UsenetExpress is a powerful new tier-1 Usenet provider that offers strong security, a 10GB uplink per server and up to 150 streams for an excellent price.
- [Usenet.Farm](https://usenet.farm/) Usenet reseller with 1000+ days retention.

### Usenet Indexers
- [/r/Usenet wiki: indexers](https://www.reddit.com/r/Usenet/wiki/indexers) Information about /r/Usenet's favourite indexing services

#### Usenet Indexing Software
- [nZEDb](https://github.com/nZEDb/nZEDb) a fork of nnplus(2011) | NNTP / Usenet / Newsgroup indexer.
- [newznab-tmux](https://github.com/NNTmux/newznab-tmux) Laravel based usenet indexer
- [newznab](http://www.newznab.com/) newznab is a usenet indexing application, that makes building a usenet community easy.
- [nZEDb-deploy](https://github.com/PREngineer/nZEDb-deploy) A collection of scripts to automate and simplify the deployment of a nZEDb Usenet Indexer using the new format of their GitHub repository.

#### Paid Indexers
- [NZBgeek](https://nzbgeek.info/) Affordable Usenet indexer operating since 2014.
- [NZBFinder](https://nzbfinder.ws/) Usenet indexer and newznab API with a clean UI and 8+ year backlog of NZBs.
- [DrunkenSlug](https://drunkenslug.com/) :star2: Popular NZB indexer with a free tier and decent retention.
- [NZBCat](https://nzb.cat/) Meow *cough* nzb-hair-bal.
- [DOGnzb](https://dognzb.cr/login) Invite-only NZB site.
- [omgwtfnzbs](https://omgwtfnzbs.me/login) Invite-only NZB indexer with a funny name.

#### Free Indexers
- [6box](https://6box.me/) :star2: A recently revived free Usenet indexing service with a generous API
- [Usenet Crawler](https://usenet-crawler.com/) Usenet indexer with API access for registered users
- [NZBIndex](https://www.nzbindex.com) The first free Usenet indexer you find in your Google search results
- [Binsearch](https://www.binsearch.info/) With this site you can search and browse binary Usenet newsgroups.
- [NZBKing](http://nzbking.com/) This service allows you to search and browse binary files that have been posted to Usenet newsgroups.
- [GingaDADDY](https://www.gingadaddy.com/) Another popular free NZB indexer, requires sign-up

### Usenet Clients
- [SABnzbd](https://sabnzbd.org/) :star2: SABnzbd is an Open Source Binary Newsreader written in Python.
- [NZBget](https://nzbget.net/) Efficient Usenet downloader written in C++
- [Usenetic](https://www.usenetic.com/) The full-featured Usenet client for Mac OSX
- [Unison](https://panic.com/blog/the-future-of-unison/) OS X app for accessing Usenet Newsgroups and the many wonders and mysteries contained within (discontinued)
- [spotweb](https://github.com/spotweb/spotweb) Spotweb is a decentralized Usenet community based on the Spotnet protocol.
- [Newsbin](http://newsbin.com/about.php) Newsbin is software for Microsoft Windows Operating Systems that downloads files from Usenet Newsgroups.
- [NZBVortex 3](https://www.nzbvortex.com/landing/) Simply the best Usenet client for Mac
- [alt.binz](https://www.altbinz.net/) alt.binz is a powerful binary newsreader, for downloading and managing articles from Usenet.

## Direct Downloads

### Download Managers
- [JDownloader2](https://jdownloader.org/jdownloader2) :star2: JDownloader is a free, open-source download management tool with a huge community of developers that makes downloading as easy and fast as it should be.
- [Internet Download Manager](https://www.internetdownloadmanager.com/) shareware download manager for Windows
- [idm-trial-reset](https://github.com/J2TeaM/idm-trial-reset) Use IDM forever without cracking.
- [Persepolis](https://github.com/persepolisdm/persepolis) An open source download manager and GUI for Aria2 written in Python with IDM like browser integration. Cross platfrom.
- [pyLoad](https://pyload.net/) Free and Open Source download manager written in Python and designed to be extremely lightweight, easily extensible and fully manageable via web
- [Xtreme Download Manager](https://subhra74.github.io/xdm/#) Xtreme Download Manager is a tool that claims to increase download speeds by up to 500%.
- [Plowshare](https://github.com/mcrapet/plowshare) Command-line tool and engine for managing sharing websites
- [FreeDownloadManager](https://www.freedownloadmanager.org/) FDM can boost all your downloads up to 10 times, process media files of various popular formats, drag & drop URLs right from a web browser as well as simultaneously download multiple files! Compatible with  Google Chrome, Mozilla Firefox, Microsoft Edge, Internet Explorer and Safari
- [EagleGet](http://www.eagleget.com/) EG is a free all-in-one download manager, lightweight and fast, supports all popular browsers and downloads from many streaming services, a perfect alternative to IDM.

### DDL Tools
- [youtube-dl](https://youtube-dl.org/) :star2: youtube-dl is a command-line program to download videos from YouTube.com and a few more sites.
- [youtube-dl-gui](https://mrs0m30n3.github.io/youtube-dl-gui/) A cross-platform front-end GUI of the popular youtube-dl written in wxPython
- [youtube-dl-helper](https://youtube-dl-helper.github.io/) Uses youtube-dl to download video/audio from many sites without requiring you to use the command-line (for Windows)
- [YouTube MP3 Rip](https://ytmp3.cc/en9/) Download YouTube music videos as MP3 files without registration
- [Leonflix](https://leonflix.net/) :star2: A multi-platform desktop app for finding movies and TV shows.
- [maulvi.github.io](https://maulvi.github.io/) Google Drive direct download link generator
- [RapidLeech](https://github.com/Th3-822/rapidleech) a free server transfer script for use on various popular upload/download sites such as uploaded.net, Rapidgator.net, and more than 127 others.
- [megatools](https://github.com/megous/megatools) Open-source command-line tools and C library (libmega) for accessing Mega.co.nz cloud storage.
- [MegaCrypt.js](https://github.com/JohnDeved/megacrypt.js) MegaCrypt.js lets you share your Mega.nz files without actually having to share any Mega.nz links by encrypting them to create a secure proxy for your files.
- [netclix](https://github.com/ston3o/netclix) A simple CLI tool to get movie streaming premium links from VodLocker's API
- [FilePursuit](https://filepursuit.com) :star2: FilePursuit provides a very powerful file indexing and search service allowing you to find a file among millions of files located on web servers.
- [grayhatwarfare S3 bucket search](https://buckets.grayhatwarfare.com/) Not likely to find much with this one but interesting nonetheless
- [annie](https://github.com/iawia002/annie) Fast, simple and clean video downloader
- [aria2](https://aria2.github.io/) a lightweight multi-protocol & multi-source command-line download utility.
- [Persepolis](https://persepolisdm.github.io/) Front-end for aria2.
- [axel](https://github.com/axel-download-accelerator/axel) light command line download accelerator
- [uGet](https://ugetdm.com/) Open Source Download Manager
- [ripme](https://github.com/RipMeApp/ripme) A album/video downloader with support for over 80 sites
- [rdcli](https://github.com/ston3o/rdcli) The simple way to download and unrestrict DDL files, torrents and magnets using Real-Debrid
- [get_iplayer](https://github.com/get-iplayer/get_iplayer) A utility for downloading TV and radio programmes from BBC iPlayer
- [MEGAsync](https://mega.nz/sync) Easily automated synchronisation between your computer and your MEGA account. Can stream Mega videos directly.
- [wget](https://www.gnu.org/software/wget/) `wget` is a free and open-source tool for downloading files using HTTP, HTTPS, FTP, and FTPS. It can be easily called from scripts, cronjobs, terminals without X-Windows support, etc.
- [wget - a noob's guide](https://the-eye.eu/public/Wget_Linux_Guide.pdf) Beginner guide on how to use `wget`.
- [wget for Windows](https://eternallybored.org/misc/wget/) A command-line utility for retrieving files using HTTP, HTTPS, and FTP protocols.
- [curl](https://en.wikipedia.org/wiki/CURL) `curl` is a command-line tool for downloading data using a variety of protocols. Easily installable on most operating systems.
- [FlixGrab](https://www.flixgrab.com/) FlixGrab+ is a unique application for downloading entire NetFlix serials, TV shows, documentaries, movies.
- [Mega.nz IDM Downloader](https://web.archive.org/web/20200629125743/https://github.com/CHEF-KOCH/Mega.nz-IDM-downloader) Unlimited downloading from Mega.nz with IDM.

### Custom Google Search Engines
- These all do the same thing:
    - [FileChef](http://filechef.com/)
    - [The Eye CGS Engine](https://cgs.the-eye.eu/)
    - [opendirectory-finder](https://ewasion.github.io/opendirectory-finder/)
    - [lumpySoft.com](https://lumpysoft.com/)
- [Musgle](http://www.musgle.com/) Searches specifically for music
- [Jimmyr](http://www.jimmyr.com/mp3_search.php) Also searches for music

### FTP Indexers
- [Davos](https://github.com/linuxserver/davos) Web-based FTP automation for Linux servers.
- [Napalm FTP Indexer](https://www.searchftps.net/) NAPALM FTP Indexer lets you search and download files located on public FTP servers.
- [Mamont's open FTP Index](http://www.mmnt.net/) Browsable directory listing of publicly available FTP-sites

### DDL Search Engines and Crawlers
- [ololo](https://ololo.to/) ololo is a video streaming link search engine.
- [MegaSearch](http://megasearch.co) Search engine for finding content hosted on Mega and other premium hosts like OpenLoad
- [VideoSpider](https://videospider.in/) VideoSpider crawls various websites and search engines to find movie and TV episode streaming links
- [Orion](https://orionoid.com/) :star2: Orion is a service that indexes metadata and links from a variety of public websites and networks, including torrent, Usenet, and hoster indexes.
- [Alluc](https://w1.alluc.uno/) Search engine with over 80 million streaming-links from over 700 VOD services, video hosters, and file-hosters
- [OD-Database](https://od-db.the-eye.eu/) Database of searchable open directories curated by The-Eye.eu
- [IPLIVE](https://iplive.club/) DDL search engine
- [SoftArchive](https://sanet.st/full/) SoftArchive or SA is a scene release website, more known for new releases of software, games, music, movies, and eBooks.

### DDL Link Sites
- [/r/ZippyShare](https://www.reddit.com/r/ZippyShare) DDL links hosted on ZippyShare
- [DirtyWarez Forum](https://forum.dirtywarez.com/) Popular warez forum with films, TV shows, ebooks, anime, games, and more
- [snahp.it](https://snahp.it/) :star2: replaced /r/megalinks
- [BlackPearl.biz](https://blackpearl.biz/) Drop-in replacement for snahp.it while their registrations remain closed
- [hdencode](https://hdencode.com/)
- [WarezForums](https://warezforums.com/) Warez forum with films, TV shows, ebooks, anime, games, and more.
- [Movies "R" Us](https://moviesrus.tk) The newest movies in 1080p. Available with DDL through MediaFire and streaming through AnonFile.
- [Movie Glide](https://www.movieglide.com/)
- [Release BB](http://rlsbb.ru)
- [DDLValley](https://www.ddlvalley.me/) DDL links for Movies, Games, Tv Shows, Apps, Ebooks and Music.
- [AdiT-HD](http://adit-hd.com/) direct download site
- [TwoDDL](http://2ddl.ws) Direct download links
- [RapidMoviez](http://rmz.cr/)
- [SceneSource](https://scnsrc.me/) WordPress powered website dedicated to bringing you the latest info on new scene releases
- [MkvCage](https://www.mkvcage.ws/)
- [MovieFiles](https://moviefiles.org/) Direct download search engine which generates Google Drive links
- [IceFilms.info](https://www.icefilms.info/) Another DDL site with TV and movie links on FileUpload, GoUnlimited, Filecandy, and more
- [DownArchive](http://downarchive.org/) DDL blog with premium links on a number of hosts. Lots of software
- [PSARips](https://psarips.com/) Popular site for movies and TV shows, includes torrent files
- [DeeJayPirate's Pastebin](https://pastebin.com/u/DeeJayPirate) Pastebin user who uploads premium links for TV shows
- [AvaxHome](https://avxhm.se) Another DDL site with eBooks, TV, movies, magazines, software, comics, newspapers, games, graphics, etc.
- [Moviesleak](https://moviesleak.net/)
- [Dospelis](https://www.dospelis.net) Spanish DDL indexer
- [movidy](https://movidy.co) Links for movies and shows in Spanish
- [Vidics](https://www.vidics.to/)
- [watchepisodeseries](https://watchepisodeseries.bypassed.wtf/)
- [watchtvseries](http://watchtvseries.unblckd.club/)
- [DownTurk](https://www.downturk.net/)
- [ScnLog](https://scnlog.me/)
- [filewarez.tv](https://filewarez.tv/) Invite-only, hosts both Mega and Google Drive links for TV shows
- [Movie-blog.org](http://movie-blog.sx/) German site for movies
- [Movieworld.to](http://movieworld.to/) Another German site for movies
- [DDL-Warez](https://ddl-warez.to/) German site for movies, shows, books and games
- [DDL-Music](https://ddl-music.to/) German site for music
- [AppNee Freeware Group](https://appnee.com/) Massive DDL site, eBooks, Programs, Games, Operating Systems, etc.
- [480mkv](http://480mkv.com/) 480p DDL for TV Shows
- [FilmRls](https://filmrls.com/) DDL site that generally features quality previews of video content

### Premium Link Generators
- [File Hosting Wiki](https://filehostlist.miraheze.org/wiki/Main_Page) This site aims to provide the most complete lists of premium link generators, torrent downloaders and more, with (possibly) frequent updates.
- [Real-Debrid](https://real-debrid.com/) :star2: Real-Debrid is an unrestricted downloader that allows you to quickly download files hosted on the Internet or instantly stream them into an innovative web player
- [Premiumize](https://www.premiumize.me/) Combine direct and secure access to
premium services
- [Premiumizer](https://github.com/piejanssens/premiumizer) Premiumizer is a download management tool for premiumize.me cloud downloads.
- [OffCloud](https://offcloud.com/?=85a8b709) A simple, elegant and intuitive SaaS to retrieve any data from the cloud.
- [Reevown](https://reevown.com/) A free download service with which you can perform premium downloads.

### Premium Link Hosts
- [File sharing table](https://nafanz.github.io/) Regularly updated table of information about file hosts.
- [Mega](https://mega.nz/) :star2:
- [OpenLoad](https://openload.co/)
- [RapidGator](https://rapidgator.net/)
- [4shared](https://www.4shared.com/)
- [Mediafire](https://www.mediafire.com/)
- [Sendspace](https://www.sendspace.com/)
- [Uploaded](https://uploaded.net/)
- [Zippyshare](https://www.zippyshare.com/)
- [NitroFlare](http://nitroflare.net/)
- [PutLocker](https://www5.putlockertv.to/)

### Open Directories
- [httpdirfs](https://github.com/fangfufu/httpdirfs) A filesystem which allows you to mount HTTP directory listings
- ["All resources I know related to Open Directories"](https://www.reddit.com/r/opendirectories/comments/933pzm/all_resources_i_know_related_to_open_directories/) Thorough post from /u/ElectroXexual
- [The Eye](https://the-eye.eu/public/) :star2: The Eye is a non-profit website dedicated to content archival and long-term preservation.
- [The Holy Grail of Indexes](https://www.reddit.com/r/opendirectories/comments/75ya8g/the_holy_grail_of_indexes/) Posted by /u/shadow_hunter104
- [36 GB of Flash Games](https://www.reddit.com/r/opendirectories/comments/902j1i/36_gb_of_flash_games_19k_files/) Posted by /u/blue_star_
- [FileMasta](https://github.com/HerbL27/FileMasta) Search servers for video, music, books, software, games, subtitles and much more
- [/r/opendirectories](https://www.reddit.com/r/opendirectories) Unprotected directories of pics, vids, music, software, and otherwise interesting files.
- [opendirectories-bot](https://github.com/simon987/opendirectories-bot) Bot used on /r/opendirectories for analysing the contents of open directories posted on the subreddit
- [Panelshow.club](http://panelshow.club/) Directory of panel show TV episodes from [/r/panelshow](https://www.reddit.com/r/panelshow)
- [andesite](https://github.com/nektro/andesite) Easily manage access to your open directory through OAuth2
- [OpenDirectoryDownloader](https://github.com/KoalaBear84/OpenDirectoryDownloader) Indexes open directories

### Streaming Sites
- [How To Stream Movies, TV, Anime & Sports Online](https://www.reddit.com/r/FREEMEDIAHECKYEAH/wiki/index) :star2: Huge list by /u/nbatman

#### HD Streaming
- [/r/MovieStreamingSites](https://www.reddit.com/r/MovieStreamingSites/) Reddit, random streaming sites
- [HD MultiredditHD](https://www.reddit.com/user/nbatman/m/streaming2/) Alternate subreddit curated by /u/nbatman
- [Best Free Streaming](https://www.bestfreestreaming.com/) Site that rates streaming services
- [StreamCR](https://scr.cr/) Clean design, very nice speeds, a large variety of films and series, HD server, Popular Site
- [YMovies](https://ymovies.tv/) Unique design, HD server with additional hosts, nice speeds, YIFY and other releases (+ torrents)
- [HDO](https://hdo.to/) Unique design, HD server with additional hosts, also country-specific films/series
- [M4UFree.TV](http://m4ufree.tv/) Unique design, HD server with backup and additional hosts
- [Movie123](http://movie123.club/) Unique design, HD server with Backup and additional hosts
- [LookMovie](https://lookmovie.ag/) Unique design, HD server, very nice speeds (offers auto quality)
- [AZMovies](https://azmovies.xyz/) Unique design, HD server with additional hosts, also on Reddit
- [Streamlord](http://www.streamlord.com/) Unique design, HD server (subtitles)
- [FlixGo](https://flixgo.net/) Unique design, HD server, very nice speeds
- [Solarmovie](https://solarmoviez.ru/solar.html) Basic streaming site layout, HD server with additional hosts, Popular Site
- [123Movies](https://123movies.website/) Basic streaming site layout, HD server with additional hosts. Previously HDFlix.
- [Yes! Movies](https://yesmovies.to) Basic streaming site layout, HD server with additional hosts
- [Spacemov](http://spacemov.io/) Basic streaming site layout, HD server, only certain films have additional hosts
- [HDOnline](https://www1.hdonline.eu) Basic streaming site layout, HD server with additional hosts
- [#1 Movies Website](https://www1.1movies.is) Basic streaming site layout, HD server with additional hosts
- [CMoviesHD](https://www2.cmovieshd.bz) Basic streaming site layout, HD server with additional hosts
- [Vidcloud](https://vidcloud.icu/) Basic streaming site layout, HD server with additional hosts
- [Series9](https://www2.series9.io/) Unique design, HD server with additional hosts
- [Soap2day](https://www.soap2day.com/) Unique design, very nice speeds, HD server with subtitles.
- [Best-movies.watch](https://best-movies.watch/) Unique design, more than 19000 available

#### Big Media Libraries
- [Streaming Multireddit](https://www.reddit.com/user/nbatman/m/streaming/) Reddit with all types of Streaming Links
- [5Movies](http://5movies.to/) Large collection dating as far back as 1990
- [2TwoMovies](https://two-movies.net/) Large collection dating as far back as 1895
- [CafeHulu](http://cafehulu.com/) Collection of movies/TV shows + many foreign films
- [Solarmovie.fm](http://www.solarmovie.fm/) or [Solarmovies.cc](https://solamovies.cc/) Plenty of movies and TV shows
- [Afdah](http://afdah.to/) Large collection dating as far back as 1920
- [YouTube](http://YouTube.com/) Contains very old films/vlogs/tutorials
- [WorldSrc](https://worldsrc.org) Movies, software, apps, games, music, and images available for fast direct download + torrents.

#### TV
- [TVRaven](https://www.onetvraven.pro/) Large TV collection, friendly UI
- [WatchSeries](http://dwatchseries.to/) TV series, multiple links/backups to different streaming hosts
- [TVBox](https://tvbox.ag/) TV/Movies, easy to navigate site, multiple links/backups to different streaming hosts

#### Anime
- [Nyaa](https://nyaa.si/) BitTorrent software for cats [(Repo)](https://github.com/nyaadevs/nyaa)
- [Hi10 Anime](https://hi10anime.com/) High-Quality 10-bit Anime Encodes
- [Anime Kaizoku](https://animekaizoku.com/) Up to 1080p DDL links, mostly Google Drive
- [Anime Kayo](https://animekayo.com/) Up to 1080p DDL links, mostly Google Drive
- [/r/animepiracy](https://www.reddit.com/r/animepiracy) This sub is about streaming and torrent websites for anime.
- [/r/animepiracy wiki](https://www.reddit.com/r/animepiracy/wiki/index) Lists for sourcing Anime streaming sites, manga sites, and more
- [9Anime](https://9anime.to) Watch anime online. English anime, dubbed, subbed.
- [All-animes](https://all-animes.com) Watch Online Anime In HD English Subbed, Dubbed.
- [GoGo Anime](https://www3.gogoanime.in/) Popular website for watching anime
- [AniLinkz](https://anilinkz.to/) Large database of streaming anime episodes.
- [NyaaPantsu](https://nyaa.pantsu.cat/) Primarily Anime torrents but includes an open directory of DDL links too.
- [Alternatives to Kiss websites](https://www.reddit.com/r/KissCartoon/wiki/alternatives) /r/KissCartoon wiki page with lots of anime sites
- [anime-sharing](http://www.anime-sharing.com/forum/) Forum for sharing anime
- [AniDex](https://anidex.info) Torrent tracker and indexer, primarily for English fansub groups of anime
- [animeEncodes](https://www.animencodes.com/)
- [Anime Twist](https://twist.moe/) An anime direct streaming site with a decent UI and video player
- [AnimeOut](https://www.animeout.xyz/) Over 1000's of Encoded Anime with DDL links.
- [Kissanime.ac](https://kissanime.ac/) Large cartoon collection, uses RapidVideo/Openload
- [Anime8](https://anime8.me/) Basic streaming site layout, large collection of anime shows
- [4anime](https://4anime.to/) A relatively new site the might become the new Masterani.me. Clean interface.
- [AnimeRam](https://ww2.animeram.cc/) A streaming website for dubbed/subbed anime.
- [animepahe](https://animepahe.com/) A minimilistic anime streaming/download website, subs only.

#### Cartoons
- [KissCartoon](https://kisscartoon.ac/) Popular cartoon streaming site
- [watchcartoononline.com](https://www.watchcartoononline.com/) Cartoons, dubbed/subbed anime streaming site
- [watchcartoononline.io](https://www.watchcartoononline.io/) Large DDL site for cartoons as well as anime and movies
- [animetoon](http://www.animetoon.org/) Lots of streaming via premium hosts for cartoons
- [Toonova](http://www.toonova.net/) Another site for streaming cartoons
- [KimCartoon](https://kimcartoon.to/) Large cartoon collection, primarily Openload
- [WatchCartoon](https://www.watchcartoononline.io/) Outdated site layout, still active, uses Openload

#### Sports Streaming
- [/r/MLBstreams](https://www.reddit.com/r/MLBstreams/) Reddit - MLB streams
- [/r/NHLstreams](https://www.reddit.com/r/NHLstreams/) Reddit - NHL streams
- [/r/ncaaBBallstreams](https://www.reddit.com/r/ncaaBBallstreams/) Reddit - NCAABBall streams
- [/r/CFBstreams](https://www.reddit.com/r/CFBstreams/) Reddit - CFB streams
- [/r/WWEstreams](https://www.reddit.com/r/WWEstreams/) Reddit - WWE streams
- [/r/rugbystreams](https://www.reddit.com/r/rugbystreams/) Reddit - rugby streams
- [/r/mmafights](https://www.reddit.com/r/mmafights/) Reddit - MMA streams
- [/r/motorsportsstreams](https://www.reddit.com/r/motorsportsstreams) Reddit - motorsports streams
- [Best Sport Streaming](https://www.bestsportstreaming.com/) Site that rates sport streaming services
- [LiveTV](https://livesx.eu/) Wide variety of sports, results/live scores, video archive and betting
- [Cricfree](https://crickfree.org/) Offers popular sports streams
- [VIPBox](https://www.vipbox.live/) Many sport streams, TV, friendly UI
- [MamaHD](https://www.mamahd.org/) 24/7 feeds, sports streams, clean UI
- [Send It](https://sendit.gg/) Live stream listings for sports, news, gaming, and more.
- [SportsHD](http://www.speedsports.me) Variety of sports including college sports, clean design
- [720pStream](http://www.720pstream.me/) Popular sports only, simple design
- [footybite](https://www.footybite.com/) Soccer streaming site.

#### Specialty Sites
- [Einthusan](https://einthusan.tv/intro/) Foreign
- [Dramago](http://www.dramago.com/) Drama movies/series
- [WatchAsian](https://www2.watchasian.co/) Foreign
- [Layarkaca](http://layarkaca21.ru/) Foreign
- [DramaCool](http://www1.dramacoolfirst.com/) Foreign
- [Daxiv Video](https://daxiv.com/) Primarily Chinese content
- [KingsofHorror](https://www.YouTube.com/user/TheKingsofHorror/) YouTube Horror
- [MutantSorority](https://www.YouTube.com/channel/UCWcF6KTn_sSSJ1AIj1bQmRg) YouTube horror
- [TromaMovies](https://www.YouTube.com/channel/UC4O0LNYmaOczcSMHA_FE1Mw) YouTube horror
- [Film1k](http://www.film1k.com/la-bestia-uccide-a-sangue-freddo-1971.html) Movies with nudity
- [Rulu](https://www.rulu.co/) YouTube Red series
- [Club MST3k](http://www.club-mst3k.com/) Every episode of MST3K
- [Archive.org](https://archive.org/) Old movies
- [MioMio](http://www.miomio.tv/) Asian TV shows/anime

#### Third Party Hosts
- [MovieZion](https://www.nicemoviezion.pro/) Openload
- [Vmovee](https://vmovee.me/) Openload (Many outdated/removed links, not updated)
- [MovieJagg](https://www.coolmoviejagg.pro/) Openload
- [IWannaWatch](https://www.iwannawatch.is/) Openload, Streamango
- [UWatchFree](https://www.uwatchfree.tv/) VidPlayer, ViDeoZa
- [Oakmovies](http://oakmovies.com/) Openload, NT, NY, NW
- [Vexmovies](http://vexmovies.org/) Openload, NY, NW, MC-2
- [Openloadmovie](https://openloadmovie.ws/) Openload (some outdated links)
- [cine.to](https://cine.to/) Openload, Vivo, Streamcloud, Flashx, Streamango
- [cinebloom](https://www2.cinebloom.com) Openload, Streamango
- [HDEUROPIX](https://topeuropix.net/) Openload, Rapidvideo
- [openloadmovies.net](https://openloadmovies.net/) OpenLoad
- [HD MOVIES](https://hdm.to/) OpenLoad, Streamango, Streamcherry
- [VodLocker](https://vodlocker.tv/) Openload, Streamango
- [StreamCouch](https://www2.streamcouch.com/) Openload, Streamango
- [Qwemovies](https://www3.qwemovies.com/) OpenLoad
- [movies2k](http://www.movie2k.st) Openload, Streamango, Streamcloud, Rapidvideo, Upvid
- [xPau.se](http://xpau.se/) Googledrive
- [Flixanity](https://flixanity.xyz/) Openload, Streamango, hls.22x.cartoonhd.pw (subtitles)
- [MegaShare](http://megashare9.su) Openload
- [XMovies8](https://xmovies8.ru/) Openload, FServer, PTServer
- [IceFilms](http://www.icefilms.info/) Openload, FileUpload
- [FilmXY](https://www.filmxy.nl/) RapidVideo, Vidoza, Uptostream (offers download links)
- [1Movies](http://1movies.nl) Openload, FServer
- [WatchFullMovie](http://watchfullmovie.co) Openload
- [FMOVIES](https://www3.fmovies.to/) Openload, MyCloud, RapidVideo, Streamango
- [WatchFree](https://watchfree.at/) Openload, FServer
- [pahe.in](https://pahe.in/) Uptostream, Google Drive, Openload, Mega
- [megaDDL](https://megaddl.co/) Mega, Go4up, 1Fichier, NitroFlare, Openload

## Media Centre Applications
- [Plex](https://www.plex.tv/) :star2: Your content—from live and recorded TV and personal media, to on-demand web shows, video news, and podcasts—beautifully organized and ready to stream everywhere.
- [Emby](https://emby.media/) a personal media server with apps on just about every device.
- [Kodi](https://kodi.tv/) an award-winning free and open-source home theater/media center software and entertainment hub for digital media.
- [OpenPHT](https://github.com/RasPlex/OpenPHT) a community-driven fork of Plex Home Theater
- [Viewscreen](https://github.com/viewscreen/viewscreen) a personal video streaming server
- [Streama](https://github.com/streamaserver/streama) Self-hosted streaming media server.
- [Myflix](https://github.com/pastapojken/Myflix) Myflix tries to be a somewhat simple and lightweight "DIY Netflix", similar to Plex, streama or Emby, for your DIY NAS, especially aimed at the Raspberry Pi/Odroid/etc ecosystem.
- [Stremio](https://www.stremio.com/) Multi-platform video content aggregator with a comprehensive add-on system for extending the functionality
- [Gerbera](https://github.com/gerbera/gerbera) UPnP Media Server for 2018 (Based on MediaTomb)
- [Serviio](http://serviio.org/) Serviio is a free media server. It allows you to stream your media files (music, video or images) to renderer devices (e.g. a TV set, Blu-ray player, games console or mobile phone) on your connected home network.
- [OSMC](https://osmc.tv/) OSMC (short for Open Source Media Center) is a Linux distribution based on Debian that brings Kodi to a variety of devices.
- [Subsonic](http://www.subsonic.org/pages/index.jsp) Music and movie streaming server with a client app and web frontend
- [Rygel](https://wiki.gnome.org/Projects/Rygel) Rygel is a home media solution (UPnP AV MediaServer) that allows you to easily share audio, video, and pictures to other devices.
- [jellyfin](https://github.com/jellyfin/jellyfin) An open-source fork of Emby

## Stremio
- [r/StremioAddons](https://www.reddit.com/r/StremioAddons/) Discussion and links pertaining to unofficial add-ons for Stremio
- [A complete curated list of all working Stremio Add-ons](https://www.reddit.com/r/StremioAddons/comments/ahd6gk/sticky_stremio_addons_list/)
- [PimpMyStremio](https://github.com/sungshon/PimpMyStremio) Local add-on manager for Stremio add-ons, adds tens of new (self-hosted, and much more powerful) add-ons to Stremio
- [Stremio Downloader](https://github.com/BurningSands70/stremio-downloader) An application that allows you to download any stream from Stremio (as opposed to just stream it). Also includes an internal add-on that lets users watch their downloaded content in Stremio while being offline
- [Stremio - Watch together with friends](https://www.reddit.com/r/StremioAddons/comments/cvmu80/guide_stremio_how_to_watch_together/) A guide explaining how to watch videos on Stremio remotely with friends, keeping the playback in sync
- [Stremio - Phone Remote](https://www.reddit.com/r/StremioAddons/comments/cuc3yo/news_phone_remote_for_stremio/) A guide explaining how to control Stremio with your phone
- [Stremio Catalog Builder](https://www.reddit.com/r/StremioAddons/comments/atizrk/news_stremio_catalog_builder/) A website that allows users to customize catalogs in Stremio

## Plex
- [linuxserver/docker-plex](https://github.com/linuxserver/docker-plex) LinuxServer.io Plex Media Server docker image
- [plexinc/pms-docker](https://github.com/plexinc/pms-docker) official Plex docker image
- [timhaak/plex](https://github.com/timhaak/docker-plex) alternative Plex docker image
- [PGBlitz.com](https://pgblitz.com/) :star2: Deploy a Hastey Server through Docker & Ansible with local or Unlimited Google HD Space (Former Name: PlexGuide)
- [hoarding.me](https://hoarding.me/) Unlimited and Automated. How to setup your own dream Plex server.
- [PlexPi](http://plexpi.com/) Plex Media Server for Raspberry Pi 3

### Plex Plugins
- [Official Plex Plugins](https://github.com/plexinc-plugins) Repos for every official Plex Inc. plugin
- [WebTools.bundle](https://github.com/ukdtom/WebTools.bundle) a collection of tools for Plex Media Server. Like the Unsupported AppStore (UAS)
- [Audiobooks.bundle](https://github.com/macr0dev/Audiobooks.bundle) Plex metadata scraper for Audiobooks
- [Sub-Zero.bundle](https://github.com/pannal/Sub-Zero.bundle) :star2: Subtitles for Plex, as good you would expect them to be. (*read*: [plans for a world without Plex plugins](https://www.reddit.com/r/PleX/comments/9n9qjl/subzero_the_future/))
- [TvplexendChannel.bundle](https://github.com/pgaubatz/TvplexendChannel.bundle) A Tvheadend Channel Plugin for PLEX Media Server
- [IPTV.bundle](https://github.com/Cigaras/IPTV.bundle) plays live streams (like IPTV) from an M3U playlist
- [HDGrandSlam.bundle](https://github.com/jumpmanjay/HDGrandSlam.bundle) interfaces with HDHomeRun tuners and DVRs
- [HDHRViewerV2.bundle](https://github.com/zynine-/HDHRViewerV2.bundle) HDHomeRun + Plex
- [SS Plex](https://mikew.github.io/ss-plex.bundle/) Imagine if all the media scattered around the internet could be found in one collection.
- [ExportTools.bundle](https://github.com/ukdtom/ExportTools.bundle) Export Plex Library to a csv, xlsx or m3u8 file
- [Plex-Trakt-Scrobbler](https://github.com/trakt/Plex-Trakt-Scrobbler) Add what you are watching on Plex to trakt.tv
- [Moviemania.bundle](https://www.reddit.com/r/MoviemaniaHQ/comments/6znf6b/plex_pluginagent_beta_1/) Textless movie posters from Moviemania.io
- [lmwt-kiss.bundle](https://github.com/Twoure/lmwt-kiss.bundle) creates a new channel within Plex Media Server (PMS) to view content from PrimeWire.
- [RequestChannel.bundle](https://github.com/ngovil21/RequestChannel.bundle) A Plex Channel to create requests
- [SRT2UTF-8.bundle](https://github.com/ukdtom/SRT2UTF-8.bundle) Plex Agent that'll convert sidecar subtitle files into UTF-8
- [PlexTools.bundle](https://github.com/jwdempsey/PlexTools.bundle) Downloads subtitles for any videos in your library from OpenSubtitles and modifies them to work with Roku clients, and converts videos to MP4 for direct play
- [FMoviesPlus.bundle](https://github.com/coder-alpha/FMoviesPlus.bundle) Plex Media Server plug-in designed for FMovies, G2G, Primewire and more.
- [SuperPLEX](https://normantheidiot.neocities.org/superplex/) A website dedicated to Plex Plugins.

### Plex Requests
- [Ombi](http://ombi.io/) :star2: Want a Movie or TV Show on Plex or Emby? Use Ombi!
- [Plex Requests](http://plexrequests.8bits.ca/) Simple automated way for users to request new content for Plex
- [plexrequests-meteor](https://github.com/lokenx/plexrequests-meteor) Meteor version of the original Plex Requests
- [Mellow](https://github.com/v0idp/Mellow/) Bot which can communicate with several APIs like Ombi, Sonarr, Radarr and Tautulli which are related to home streaming. Based off of node:9.3
- [MediaButler](https://github.com/physk/MediaButler) Discord bot for use with PleX and several other apps that work with it.

### Plex Scripts and Tools
- [plex_top_playlists](https://github.com/pbrink231/plex_top_playlists) A python script to get top weekly or top popular lists and put them in plex as playlists.
- [JBOPS](https://github.com/blacktwin/JBOPS) Just a Bunch Of Plex Scripts
- [plex-subtitles-normalizer](https://github.com/caridy/plex-subtitles-normalizer) CLI tool to fix subtitles needed by Plex Media Center
- [plex_autoscan](https://github.com/l3uddz/plex_autoscan) Script to assist sonarr/radarr with plex imports.
- [plexupdate](https://github.com/mrworf/plexupdate) script to simplify the life of Linux Plex Media Server users.
- [plex2netflix](https://github.com/SpaceK33z/plex2netflix) See how much of your media from Plex is available on Netflix.
- [plexReport](https://github.com/bstascavage/plexReport) Scripts to generate a weekly email of new additions to Plex
- [plex-sync](https://github.com/jacobwgillespie/plex-sync) A simple command-line utility to synchronize watched/seen status between different Plex Media Servers.
- [PlexIPTV](https://github.com/xiaodoudou/PlexIPTV) This app simulates a DVR device for Plex by providing a layer to any IPTV provider (that provide an m3u8 playlist)
- [Plex Media Tagger](https://github.com/ccjensen/PlexMediaTagger) Uses the metadata held in the PlexMediaServer to tag media files
- [PlexEmail](https://github.com/jakewaldron/PlexEmail) This script aggregates all-new TV, movie and music releases for the past configured time then optionally writes to your web directory and sends out an email.
- [Transmogrify](https://github.com/Transmogrify-for-Plex/Transmogrify-for-Plex-chrome) A Chrome extension that adds several features to the Plex/Web 2.0 client for Plex
- [PlexAuth](https://github.com/hjone72/PlexAuth) Plex based authentication using PHP
- [Phlex](https://github.com/d8ahazard/Phlex) A super-sexy voice interface for the Plex HTPC
- [Plex Redirect](https://github.com/ITRav4/PlexRedirect) a Plex landing page that redirects you to various sites.
- [Plaxt](https://plaxt.herokuapp.com/) Webhook-based Trakt.tv scrobbling for Plex
- [goplaxt](https://github.com/XanderStrike/goplaxt/) Full rewrite of the above, written in Go and deployable with Docker
- [plxdwnld](https://piplong.run/plxdwnld/) Bookmarklet for downloading original files from the Plex web interface
- [Kitana](https://github.com/pannal/Kitana) Kitana exposes your Plex plugin interfaces "to the outside world".
- [Python-PlexLibrary](https://github.com/adamgot/python-plexlibrary) Python command-line utility for creating and maintaining dynamic Plex libraries based on "recipes".
- [NowShowing](https://github.com/ninthwalker/NowShowing) Generates an email and web page of Plex recently added content
- ["My (scripted) solution to having a single Movies library for 4k and non-4k."](https://www.reddit.com/r/PleX/comments/afs8m9/my_scripted_solution_to_having_a_single_movies/) Post by /u/spazatk
- [PlexMissingEpisodes](https://github.com/MysticRyuujin/PlexMissingEpisodes) Scan Plex library for missing episodes using TheTVDB#
- [Gaps](https://github.com/JasonHHouse/Gaps) Find the missing movies in your Plex Server
- [PlexRecs](https://github.com/nwithan8/PlexRecs) A Discord bot that provides movie and TV show recommendations from your Plex library
- ["I made my own Pseudo TV for Plex with Kodi and Nvidia Shield"](https://old.reddit.com/r/PleX/comments/awsvp9/i_made_my_own_pseudo_tv_for_plex_with_kodi_and/ehox9zf/) Guide from /u/nads84 on how to make your own "live" TV channels with a Plex library, Kodi, and an NVIDIA Shield
- [Varken](https://github.com/Boerderij/Varken) Standalone application to aggregate data from the Plex ecosystem into InfluxDB using Grafana for a frontend

### Plex Shares
- [/r/plexshares](https://www.reddit.com/r/plexshares/) A nice place to find Plex Media Server shares.
- [BaconFeet](https://baconfeet.com/) "Bringing a difference in streaming to the masses..." ([/r/BaconFeet](https://www.reddit.com/r/BaconFeet/))
- [Elysium](https://elysium.to/) Plex media streaming service

### Plex Transcoding
- [kube-plex](https://github.com/munnerz/kube-plex) Scalable Plex Media Server on Kubernetes -- dispatch transcode jobs as pods on your cluster!
- [UnicornTranscoder](https://github.com/UnicornTranscoder/UnicornTranscoder) a remote transcoder for Plex Media Server
- [Plex-Remote-Transcoder](https://github.com/wnielson/Plex-Remote-Transcoder) A distributed transcoding backend for Plex
- [nvidia-patch](https://github.com/keylase/nvidia-patch) Unlock the transcode or 'session' limit on nVidia consumer grade GPUs

### Plex Logging and Metrics
- [Tautulli](https://tautulli.com/) :star2: Tautulli is a 3rd party application that you can run alongside your Plex Media Server to monitor activity and track various statistics.
- [plexWatch](https://github.com/ljunkie/plexWatch) Notify and Log watched content on a Plex Media Server
- [Plex-Data-Collector-For-InfluxDB](https://github.com/barrycarey/Plex-Data-Collector-For-InfluxDB) Collects data about your Plex server and sends it to InfluxDB

### Plex Clients
- [RasPlex](https://github.com/RasPlex/RasPlex) Rasplex is a community driven port of Plex Home Theater for the Raspberry Pi
- [PlexConnect](https://github.com/iBaa/PlexConnect) Unofficial Plex app for Apple TV devices
- [go-plex-client](https://github.com/jrudio/go-plex-client) A Plex.tv and Plex Media Server Go client

## Kodi
- [/r/Addons4Kodi](https://www.reddit.com/r/addons4kodi) Discussion and links pertaining to unofficial add-ons for Kodi Media Center
- [Seren](https://www.reddit.com/r/Addons4Kodi/comments/dt4kg2/recommended_addons_november_2019/f6ukyfr?utm_source=share&utm_medium=web2x) :star2: Streaming addon which works with Premiumize and Real-Debrid to stream torrents with the appropriate provider package instantly, and behaves similarly to Netflix, with autoplay and Up Next integration
- [Recommended Addons - November 2019](https://www.reddit.com/r/Addons4Kodi/comments/dt4kg2/recommended_addons_november_2019/) Latest working Kodi addons compiled into one place
- [Placenta](http://www.wirelesshack.org/how-to-install-placenta-Kodi-addon.html) a Fork of Exodus / Covenant with more options and links from Mr. Blamo and Muad'Dib
- [Gaia](https://gaiakodi.com/) Grants the ability to instantly watch high-quality files via cached torrents from Real-Debrid or Premiumize.
- [Yoda](http://supremacy.org.uk/zip/repo/) Another solid Exodus/Covenant fork, and this time it's from S-media.
- [Elementum](https://elementum.surge.sh/) Elementum addon is an addon for Kodi, that manages your virtual library, syncs with your Trakt account.
- [Tooonmania2](https://github.com/doko-desuka/doko.repository/releases) lets you watch cartoons, dubbed anime and movies (from animetoon) and subbed anime and movies (from animeplus)
- [PlexKodiConnect](https://github.com/croneter/PlexKodiConnect) Plex integration in Kodi done right
- [Official Plex Addon](https://forums.plex.tv/t/installation-instructions/168854) Official Plex addon for Kodi
- [Ultimate Kodi Guide](https://www.reddit.com/r/Piracy/comments/7wp42u/ultimate_guide_to_install_kodi_popular_streaming/) ULTIMATE GUIDE TO INSTALL KODI + POPULAR STREAMING ADDONS by /u/giorgiomilan
- [kodi-headless](https://hub.docker.com/r/linuxserver/kodi-headless/) A headless install of Kodi in a docker container, most useful for a MySQL setup of Kodi to allow library updates to be sent without the need for a player system to be permanently on.
- [Exodus Redux](https://www.reddit.com/r/Addons4Kodi/comments/9tasx5/requests_recommendations_basics_november_2018/e8uti6w) The newest Exodus fork around, paired with LambdaScrapers.
- [Sparkle](https://github.com/iwannabelikemike/plugin.video.sparkle) Kodi addon for finding acestream links
- [Plexus](http://fusion.tvaddons.co/) Plexus is used in conjunction with Sparkle to play Ace Stream links.
- [Pneumatic](https://forum.kodi.tv/showthread.php?tid=97657) Pneumatic is an NZB engine add-on for XBMC. It requires SABnzbd as a backbone.
- [Python-GoogleDrive-VideoStream](https://github.com/ddurdle/Python-GoogleDrive-VideoStream) The purpose of this plugin is to serve content delivered in Google Drive plugin for KODI through any HTML5 client.
- [Quasar](http://quasar.surge.sh) The purpose of this plugin is to search and stream torrents in Kodi.
- [Burst](http://burst.surge.sh) A torrent content provider to the Quasar plugin.

## Gaming
- [/r/CrackWatch](https://reddit.com/r/CrackWatch/) :star2: New video game crack releases are posted here
- [Beginners Guide to Crack Watch](https://www.reddit.com/r/CrackWatch/comments/a7l141/crack_watch_beginners_guide_to_crack_watch/) Reddit post by /u/EssenseOfMagic
- [GOD scraped URLs](https://drive.google.com/file/d/17MB0gCcCMr3QqE_CgJkaxmdXtZk61TdZ/view) All DDL links for games listed on the now-dead GoodOldDownloads site.
- [Free GOG PC Games](http://freegogpcgames.com/) Magnet links site to download games from GOG.
- [cs.rin.ru](https://cs.rin.ru/) Popular gaming piracy forum
- [SmartSteamEmu](https://github.com/MAXBURAOT/SmartSteamEmu) Steam emulator
- [goldberg_emulator](https://gitlab.com/Mr_Goldberg/goldberg_emulator) Steam emulator that emulates steam online features. Lets you play games that use the steam multiplayer APIs on a LAN without steam or an internet connection
- [CreamAPI](https://cs.rin.ru/forum/viewtopic.php?t=70576) "A Legit DLC Unlocker" for Steam
- [cream-api-autoinstaller](https://github.com/Douile/cream-api-autoinstaller) A python script to automatically install Cream API for Steam games
- [CDRomance](https://cdromance.com/) PSP, PSX, PS2, Gameboy, NDS, SNES, Dreamcast, and Gamecube ROMs and ISOs.
- [redump.org](http://redump.org/) Disc preservation database and internet community dedicated to collecting precise and accurate information about every video game ever released on optical media of any system.
- [Steamless](https://github.com/atom0s/Steamless) Steamless is a DRM remover of the SteamStub variants.
- [MachineGunnur/GOG-Games](https://github.com/MachineGunnur/GOG-Games) A fork of Good Old Downloads' "GOG Games" hosted on Tor

### Repacks
- [FitGirl Repacks](http://fitgirl-repacks.site/) :star2: Popular DDL and torrent site for game repacks
- [Xatab Repacks](https://xatab-repack.net) Russian game repacker, primarily torrents
- [ElAmigos Games](https://www.elamigos-games.com/) Premium links to cracked games
- [qoob.name](http://qoob.name/) Repacker site
- [Nicoblog](https://nicoblog.org/) Plenty of ISOs, ROMs, and repacks
- [Dark Umbra](https://darkumbra.net/) Forum for sourcing games
- [Skidrow Repacks](https://skidrowrepacks.com/) Repacks from popular repacker SKIDROW. Lots of anime stuff too

### ROMs
- [Romsmania](https://romsmania.cc/) Good ROMs collection with a decent UI.
- [Doperoms](https://www.doperoms.com/) Huge collection with over 170,000 ROM files. PS3 included.
- [Vimm's Lair](https://vimm.net/?p=vault) Large collection of ROMs
- [ROM/ISO sites](http://emulation.gametechwiki.com/index.php/ROM_%26_ISO_Sites) Wiki page from gametechwiki.com with more links
- [Romulation.net](https://www.romulation.net/) Collection of ~28,000 console game ROMs
- [The Eye ROMs](http://the-eye.eu/public/rom/) Open directory of ROMs from The Eye
- [myabandonware](https://www.myabandonware.com/) More than 14000 old games to download for free!
- [Old Games Finder](http://www.oldgamesfinder.com/) Old Games Finder is an automated old game search engine. (avoid ISO Zone links, as that site is dead)
- [The ROM Depot](https://theromdepot.com/roms/) About 3TB of ROMs. You may need a VPN.
- [Emulator.Games](https://emulator.games/) Download or play ROMs on your PC, Mobile, Mac, iOS and Android devices.
- ["A simple script for easily downloading emulator.games roms"](https://www.reddit.com/r/Piracy/comments/aytutr/a_simple_script_for_easily_downloading/) Reddit guide and userscript created by /u/estel_smith to allow you to easily download ROMs from Emulator.Games.
- [3DSISO](http://www.3dsiso.com/) Nintendo 3DS ROMs downloads forum.
- [3DSCIA.com](https://www.3dscia.com/) DDL links for 3DS CIA files.
- [Ziperto](https://www.ziperto.com/nintendo/3ds-roms/3ds-cia/) DDL link site primarily for Nintendo games.

### Console Games
- [/r/PkgLinks](https://www.reddit.com/r/PkgLinks/) A place to share working Playstation 4 PKGs
- [NoPayStation](https://nopaystation.com) A Database for PSN content including Vita, PS3, PSX, and PSP
- [/r/SwitchNSPs](https://www.reddit.com/r/SwitchNSPs/) Nintendo Switch games
- See [Discord Servers](#discord-servers) for more Switch games

### Homebrew and Custom Firmware
- [3DS Hacks Guide](https://3ds.hacks.guide/) A complete guide to 3DS custom firmware, from stock to boot9strap.
- [/r/3dshacks](https://www.reddit.com/r/3dshacks) Nintendo 3DS hacking and homebrew.
- [/r/WiiHacks](https://www.reddit.com/r/WiiHacks/) This Subreddit is for people interested in modifying their Wii.
- [/r/WiiUHacks](https://www.reddit.com/r/WiiUHacks) A subreddit dedicated to Wii U hacking and homebrew!
- [/r/vitahacks](https://www.reddit.com/r/vitahacks/) A place to discuss Vita hacking and homebrew.
- [/r/ps4homebrew](https://www.reddit.com/r/ps4homebrew) News, releases, and questions regarding the PS4 jailbreak, homebrew, and mods.
- [/r/SwitchHaxing](https://www.reddit.com/r/SwitchHaxing) Nintendo Switch hacking & homebrew subreddit
- [/r/SwitchHacks](https://www.reddit.com/r/SwitchHacks) Another Nintendo Switch hacking subreddit
- [/r/ps3homebrew](https://www.reddit.com/r/ps3homebrew/) News, updates, apps, and answers regarding PS3 homebrew!
- [/r/YuzuPiracy](https://www.reddit.com/r/YuzuPiracy) Links for Yuzu, the open-source Nintendo Switch emulator
- [/r/VitaPiracy](https://www.reddit.com/r/VitaPiracy/) Fairly active community of PS Vita pirates with guides and releases

## Music
- [MOOVAL](https://www.mooval.de/) Easily move your playlists, tracks, and likes from one streaming service to another.
- [Madsonic](https://www.madsonic.org/) Madsonic is a web-based media library and media streamer with jukebox functionality.
- [MusicBrainz](https://musicbrainz.org/) MusicBrainz is an open music encyclopedia that collects music metadata and makes it available to the public.
- [airsonic](https://airsonic.github.io/) Airsonic is a free, web-based media streamer, providing ubiquitous access to your music.
- [Beets](http://beets.io/) The purpose of beets is to get your music collection right once and for all. It catalogs your collection, automatically improving its metadata as it goes using the MusicBrainz database.
- [gonic](https://github.com/sentriz/gonic) Music streaming server / subsonic server API implementation.
- [LibreSonic](https://github.com/Libresonic/libresonic) Media streaming software

### Music Streaming
- [Muxiv Music](https://muxiv.com/) Stream 45 million songs on all your devices, online or offline. Primarily Chinese content.
- [Hikarinoakariost](https://hikarinoakariost.info/) Site with Japanese music
- [mp3Clan](http://mp3guild.com/) Free music streaming
- [GoSong](https://gosong.unblocked.gdn/) Streamable MP3s
- [MP3Juices](https://mp3juices.unblocked.gdn/) MP3 search engine tool which uses YouTube
- [mp3.li](http://mp3li.unblckd.club) Another MP3 streaming site
- [SongsPK](https://songs-pk.in/) Mainly for downloading Bollywood songs. Domain changes frequently.
- [datmusic](https://datmusic.xyz/) Search engine with a clean UI for streaming music in your browser
- [MusicPleer](https://musicpleer.la/) Another music streaming site with a decent search engine
- [slider.kz](http://slider.kz/) Quirky and fast music streaming site

### Music Downloading
- [Soulseek](http://www.soulseekqt.net/news/) Soulseek is an ad-free, spyware free, just plain free file-sharing network for Windows, Mac, and Linux.
- [irs](https://github.com/kepoorhampond/irs) A music downloader that understands your metadata needs.
- [SMLoadr](https://git.fuwafuwa.moe/SMLoadrDevs/SMLoadr) A streaming music downloader.
- [Deezloader Remaster](https://www.reddit.com/r/DeezloadersIsBack/comments/9n3pf1/deezloader_alpha_latest_version_download10102018/) Tool for downloading music from Deezer
- [Deezloader Remix](https://notabug.org/RemixDevs/DeezloaderRemix) Another program with the same purpose, both based on the original, now defunct Deezloader.
- [/r/DeezloaderIsBack](https://www.reddit.com/r/DeezloadersIsBack) Community supporting Deezloader
- [Deemix](https://codeberg.org/RemixDev/deemix) Another program with the same purpose. "Deemix is a python library that lets you download millions of songs [from Deezer]". "Deemix is meant to replace Deezloader Remix".
- [/r/deemix](https://www.reddit.com/r/deemix) Community supporting Deemix
- [New Album Releases](http://newalbumreleases.net/) Premium DDL links for full albums
- [Kingdom Leaks](https://kingdom-leaks.com/) DDL links for album leaks
- [KHInsider](https://downloads.khinsider.com/) Site collecting soundtracks, mostly MP3, some FLAC, OGG or M4A.
- [VGMLoader](https://github.com/TheLastZombie/VGMLoader) Tool for bulk downloading from KHInsider.
- [Free MPS Download.net](https://free-mp3-download.net/) Search engine with streamable samples and download links
- [chimera](https://notabug.org/Aesir/chimera) Multiple source terminal-based music downloader with audio search engine

### Spotify
- [Get rid of Spotify ads](https://www.reddit.com/r/Piracy/comments/9jvlf8/get_rid_of_spotify_adsbannerslimited_skips_and/) Short guide on avoiding ads, banners, limited skips, and locked shuffle mode in Spotify Free
- [Spotify AdBlock Host file](https://www.reddit.com/r/Piracy/comments/9tcbvc/spotify_adblock_host_file_uptodate_effective/) :star2: This is the most up-to-date list and will block all annoying Spotify ads & analytics.
- [EZBlocker](https://github.com/Xeroday/Spotify-Ad-Blocker/) a Spotify Ad Blocker written in C# for Windows 7/8/10.
- [BlockTheSpot](https://github.com/mrpond/BlockTheSpot) Video, audio & banner AdBlock/skip for Spotify
- [Spytify](https://jwallet.github.io/spy-spotify/) Records Spotify without ads while it plays and includes media tags and album cover to the recorded files
- [Spotify modded APK](https://forum.mobilism.org/viewtopic.php?f=1332&t=2950704) Modded APK with no ads.
- [Downtify](https://github.com/eviabs/downtify-premium) Downtify is an open-source Spotify downloader which makes it possible to download all your favourite songs and/or playlists directly from Spotify.

### iTunes
- [TunesKit](https://www.tuneskit.com/) iTunes DRM removal tool
- [Requiem](https://digiex.net/threads/requiem-4-1-remove-itunes-drm-fairplay-from-music-video-and-books.11796/) Requiem is a program that removes Apple's DRM (called FairPlay) from songs, videos, and books purchased on iTunes
- [How to Remove DRM From iTunes Movies and TV Shows](https://www.howtogeek.com/291612/how-to-remove-drm-from-itunes-movies-and-tv-shows/) HowToGeek article on how to use TunesKit and Requiem
- [Plus Premieres](https://www.pluspremieres.eu/) Download newest iTunes music in M4A format
- [forked-daapd](https://ejurgensen.github.io/forked-daapd/) Linux/FreeBSD DAAP (iTunes) and MPD media server with support for AirPlay devices (multiroom), Apple Remote (and compatibles), Chromecast, Spotify and internet radio.

## Software
- [/r/piracy/wiki/tools](https://www.reddit.com/r/piracy/wiki/tools) Windows/Office activation tools, and images/installers for Windows, Office, and Adobe
- [nsane.down](https://www.nsanedown.com/) A popular file-sharing forum focused on software
- [CrackingPatching.com](https://crackingpatching.com/) Cracked software
- [Appked](https://www.macbed.com/) Mac application sharing site
- [Team-OS HKRG](https://www.teamos-hkrg.com/index.php) Windows software and various activation tools.
- [CracksNow](https://cracksnow.com/) Cracks for Android, Windows, and macOS applications.
- [Nulled](https://www.nulled.to/) Nulled is a cracking community where you can find links to cracked software
- [/s/sjain_guides](https://saidit.net/s/sjain_guides) Guides and downloads for CS:GO, Windows 10 gaming optimisations, and more
- [My Digital Life Forums](https://forums.mydigitallife.net/) Popular forum for modded/cracked software and apps
- [Pro Design Tools](https://prodesigntools.com) Site focused on Adobe Development including cracked software and ebooks.
- [ShareAppsCrack](https://shareappscrack.com/) Website with a plethora of development tools and engineering-focused software, including video tutorials, and some ebooks.
- [Photokaaran](http://photokaaran.com/) Indian site with direct download links of cracked productivity tools.

### Adobe CC
- [Adobe CC 2019/2020 AIO Patcher](https://cracked.to/Thread-Cracked-CRACK-ADOBE-CC-2019-2020-GENP-V2-6-2) Latest Working All-In-One Patcher for all Adobe Creative Cloud 2019/2020 Applications (Windows)
- [Adobe Master Collector](https://saidit.net/s/sjain_guides/wiki/downloads#wiki_adobe_master_collector.3A) This tool downloads pre-activated Adobe applications released by m0nkrus, ranging from CS6 to CC 2020.
- [Adobe CC 2018](https://saidit.net/s/sjain_guides/comments/9oz/adobe_cc_2018_full_indepth_guide_to_installing/) Full in-depth guide to installing and cracking any application (Windows)
- [Adobe Zii 4.0.3](https://www.reddit.com/r/Piracy/comments/9v7tr6/adobe_zii_403_released_now_includes_incopy/) Tool for patching and cracking Adobe CC applications.
- [Adobe Acrobat Pro DC](https://saidit.net/s/sjain_guides/comments/9p5/adobe_acrobat_pro_dc_full_indepth_guide_to/) Full in-depth guide to downloading, installing, activating and optimising.

### Windows
- [/f/MSToolkit](https://raddle.me/f/MSToolkit) Tools for activating Windows software, including Windows 10 itself.
- [Windows 10 Digital License](https://www.nsaneforums.com/topic/316668-microsoft-activation-scripts/) Scripts for activating Windows 10 "legitimately" by binding your HWID to a Microsoft account
- [How to download and install Windows 10 LTSB](https://www.reddit.com/r/Piracy/comments/8pfnun/how_to_download_and_install_windows_10_ltsb/) Guide by /u/sq_skez. "Take everything we loved about Windows 7, add the under-the-hood improvements of Windows 8 and 10 but none of the marketing/cloud/phone app/user-tracking crap, and what do you get? Windows 10 Enterprise LTSC edition."
- [TechBench](https://tb.rg-adguard.net/public.php) Find official Windows isos for Windows 7/8/10
- [Windows 10 Digital License (HWID) & KMS38 Generation](https://web.archive.org/web/20190114172332/https://www.reddit.com/r/s1ave77_library/comments/9o13fq/windows_10_digital_license_hwid_kms38_generation/) Reddit guide by /u/s1ave77 with instructions on how to use HWID to activate various editions of Windows 10.

## Ebooks
- [BookStack](https://www.bookstackapp.com/) BookStack is a simple, self-hosted, easy-to-use platform for organizing and storing information.
- [Ubooquity](http://vaemendis.net/ubooquity/) Ubooquity is a free home server for your comics and ebooks library
- [COPS](https://github.com/seblucas/cops) Calibre OPDS (and HTML) PHP Server : web-based light alternative to Calibre content server / Calibre2OPDS to serve ebooks (epub, mobi, pdf, etc.)
- [b-ok](http://b-ok.xyz/) Free ebook library
- [The idiot-proof guide to downloading ebooks off IRC](https://www.reddit.com/r/Piracy/comments/2oftbu/guide_the_idiot_proof_guide_to_downloading_ebooks/) Posted by /u/Servaplur
- [Guide to Copy Kindle Content to PDF using Calibre](https://www.reddit.com/r/Piracy/comments/bm837l/guide_to_copy_kindle_content_to_pdf_using_calibre/)
- [Apprentice Alf's Blog](https://apprenticealf.wordpress.com/) Everything you ever wanted to know about DRM and ebooks but were afraid to ask.
- [Calibre](https://calibre-ebook.com/) :star2: ebook management tool
- [Calibre-Web](https://github.com/janeczku/calibre-web) Web app for browsing, reading and downloading eBooks stored in a Calibre database
- [Custom Search Engine](https://cse.google.com/cse?cx=000661023013169144559:a1-kkiboeco) A Google custom search engine specifically for ebooks
- [Exploring over 1,800 Calibre ebook servers](https://blog.chrisbonk.ca/2018/12/knowledge-is-power-exploring-over-1800.html?m=1) Blog post detailing how to use Shodan to find Calibre ebook servers
- [DeDRM_tools](https://github.com/apprenticeharper/DeDRM_tools) DeDRM tools for ebooks.
- [ReadAnyBook](https://readanybook.com/) Free online reading.
- [PDFdrive](http://pdfdrive.com) PDF Drive is your search engine for PDF files. No annoying ads, no download limits.
- [Memory of the world](http://library.memoryoftheworld.org) A new website containing a lot of books.

## Magazines
- [PDF Giant](http://pdf-giant.com/) Various categories of downloadable PDFs
- [MagazineLib](https://magazinelib.com/) Free PDF and interactive e-magazines

## Academic Papers and Material
- [LibGen](https://libgen.is/) search engine for articles and books on various topics, which allows free access to content that is otherwise paywalled or not digitized elsewhere
- [Sci-Hub](https://sci-hub.se/) the first pirate website in the world to provide mass and public access to tens of millions of research papers
- [BookSC](http://booksc.org/) The world's largest scientific articles store. 50,000,000+ articles for free.
- [Academic Torrents](http://academictorrents.com/) A Community-Maintained Distributed Repository for researchers, by researchers. Making 32.66TB of research data available!

## Textbooks
- [All IT eBooks](http://www.allitebooks.com/) A big database of free, direct links for IT and programming ebooks
- [it-ebooks](http://it-ebooks.info) Large selection of free and open-source IT ebooks
- [PDF/Ebook trackers for college textbooks](https://www.reddit.com/r/trackers/comments/hrgmv/tracker_with_pdfsebooks_of_college_textbooks/c1xrq44/) Old-but-still-useful list of ebook/textbook trackers, DDL sites, and IRC communities
- [How to "rent" your textbooks for free from Amazon](https://www.reddit.com/r/Piracy/comments/3ma9qe/guide_how_to_rent_your_textbooks_for_free_from/) "Going to college? Living off top ramen for dinner? Let me show you have to "rent" your textbooks for free & for life!"
- [Guide for Finding Textbooks](https://www.reddit.com/r/Piracy/comments/3i9y7n/guide_for_finding_textbooks/) Extensive tutorial by /u/Amosqu
- [forcoder](https://forcoder.su/) Ebooks & Elearning For Programming

## Courses and Tutorials
- [CourseClub](https://courseclub.me/) Download courses from (Lynda, Pluralsight, CBG Nuggets, etc)
- [FreeCourseSite](https://freecoursesite.com/) Mostly highest rated udemy courses torrent
- [FreeTutorials.eu](https://www.freetutorials.eu/) Lots of Udemy courses for free; Has Adblock detector
- [Gigacourse](https://gigacourse.com/)
- [Desire Course](https://desirecourse.net/)
- [GFXDomain.net Tutorials board](http://forum.gfxdomain.net/forums/others-tutorials.42/) Forum with free tutorials for graphic design, mostly via premium file hosts but some torrents
- [tpget](https://github.com/0x6a73/tpget) Tutorialspoint downloader
- [udemy-downloader-gui](https://github.com/FaisalUmair/udemy-downloader-gui) A cross-platform (Windows, Mac, Linux) desktop application for downloading Udemy Courses.
- [tut4dl](https://tut4dl.com/) Download tutorial and training courses from many paid MOOCs, with categories ranging from Cuisine to Cryptography.

## Audiobooks
- [AudioBook Bay](http://audiobookbay.nl/) Download unabridged audiobooks for free or share your audiobooks, safe, fast and high quality
- [AAXtoMP3](https://github.com/KrumpetPirate/AAXtoMP3) Convert Audible's .aax filetype to MP3, FLAC, M4A, or OPUS
- [Booksonic](http://booksonic.org/) Booksonic is a server and an app for streaming your audiobooks to any pc or android phone.
- [The Eye /public/AudioBooks](http://the-eye.eu/public/AudioBooks/) A few publicly accessible audiobooks hosted by The Eye
- [AudioBooks.Cloud](https://audiobooks.cloud/) DDL links for lots of audiobooks.
- [Tokybook](https://tokybook.com/) Free audiobook streaming site.

## Comicbooks
- [Kindle Comic Converter](https://kcc.iosphe.re/) Comic and manga converter for ebook readers
- [readcomiconline.to](https://readcomiconline.to/) Manga and comics uploaded daily
- [Readcomicbooksonline](https://readcomicbooksonline.org/) Tends to Error 520 occasionally
- [Comic Extra](https://www.comicextra.com/) Daily comic uploads, clean UI
- [GetComics](https://getcomics.info/) GetComics started as an alternative place to get downloaded comic files, particularly US-based comics published by DC and Marvel.
- [Gazee!](https://hub.docker.com/r/linuxserver/gazee/) A WebApp Comic Reader for your favorite digital comics. Reach and read your comic library from any web-connected device with a modern web browser.
- [Comix-Load](https://comix-load.in/) DDL links for comic books and manga in English and German.
- [Omnibus](https://github.com/fireshaper/Omnibus) Search for and download comics that are added to GetComics.info easily

## Manga
- [MangaDex](https://www.mangadex.org/) MangaDex is an online manga reader that caters to all languages.
- [/r/manga](https://www.reddit.com/r/manga) Everything and anything manga! (manhwa is okay too!)
- [Madokami](https://manga.madokami.al/) Requires sign-up (currently closed), see mirrors below.
- [Madokami 0-E](https://archive.org/download/Madokami.Manga.0-E) Download manga titles named 0 to E.
- [Madokami F-K](https://archive.org/download/Madokami.Manga.F-K) Download manga titles named F to K.
- [Madokami L-Q](https://archive.org/download/Madokami.Manga.L-Q) Download manga titles named L to Q.
- [Madokami R-Z](https://archive.org/download/Madokami.Manga.R-Z) Download manga titles named R to Z.
- [Madokami novels, raws and artbooks](https://archive.org/download/Madokami.NotManga) Download novels, manga raws and artbooks.
- [Tachiyomi](https://tachiyomi.org/) Free and open source manga reader for Android.
- [MangaZone](http://mangazoneapp.com/) A manga reader app.
- [NineAnime](https://www.nineanime.com/) Updated/Active Manga Site
- [Free Manga Downloader (FMD)](https://github.com/fmd-project-team/FMD) A manga download manager and reader that supports downloading from various websites.
- [HakuNeko](https://github.com/manga-download/hakuneko) A cross-platform downloader for manga and anime from +400 websites. Manga and anime in multiple languages and formats (cbz, a folder with images, epub).

## Documentaries
- [/r/Documentaries](https://www.reddit.com/r/documentaries) Popular documentaries subreddit
- [My big list of documentary sites (streaming and download)](https://www.reddit.com/r/Documentaries/comments/h9pu7/my_big_list_of_documentary_sites_streaming_and/) An old post by /u/whatwhat888 that may still be useful
- [DocuWiki.net](http://docuwiki.net/index.php?title=Main_Page) DocuWiki.net serves as an index of documentary films on the Edonkey Network.
- [MVGroup](http://forums.mvgroup.org/) Forum for documentary torrent and ED2K downloads. Sign-up required.
- [Documentary Addict](https://documentaryaddict.com/) A website which scrapes Youtube for documentaries
- [iHaveNoTv](https://ihavenotv.com/) Community managed documentary collection

## Fonts, Icons, and Graphics
- [Get the font](https://www.getthefont.com/) Searches through GitHub for fonts
- [Web4Sync](https://web4sync.com/) Forum with DDL links catering to web development, graphics design, 3D animation, and photography
- [GFXDomain](http://forum.gfxdomain.net/) Forum for graphic design resources and software
- [GFxtra](https://www.gfxtra.com/) DDL links for graphics, icons, 3D models, and more
- [GraphicEx](https://graphicex.com/) Stock/vector graphics, PhotoShop/InDesign resources, fonts, and more
- [Tomato.to](https://tomato.to/) Stock Downloader | Supports Shutterstock, Gettyimages, Adobe stock, Fotolia, Vectorstock, iStockphoto, PNGTree & PicFair.
- [How to download paid fonts for free](https://www.reddit.com/r/Piracy/comments/8tqfg6/how_to_download_paid_fonts_for_free/) Post by /u/Bebhio on how to use clever Google searches to find fonts online
- [gallery-dl](https://github.com/mikf/gallery-dl) Command-line program to download image-galleries and -collections from several image hosting sites

## Automation
- [FlexGet](https://flexget.com/) FlexGet is a multipurpose automation tool for all of your media with support for torrents, nzbs, podcasts, comics, TV, movies, RSS, HTML, CSV, and more.
- [Pulsarr](https://github.com/roboticsound/Pulsarr) Browser extension (currently Chrome & Firefox) for adding movies to Radarr or Series' to Sonarr while browsing IMDB or TVDB.
- [Bonarr](https://github.com/klassicstudios/Bonarr) A fork of Radarr to work with porn.
- [traktarr](https://github.com/l3uddz/traktarr) Script to add new series & movies to Sonarr/Radarr based on Trakt lists.
- [Mylar](https://github.com/evilhero/mylar) An automated Comic Book Downloader (cbr/cbz) for use with SABnzbd, NZBGet, and torrents
- [LazyLibrarian](https://github.com/DobyTang/LazyLibrarian) LazyLibrarian is a program to follow authors and grab metadata for all your digital reading needs.
- [CloudBox](https://cloudbox.works/) An All-In-One, Cloud-Centric, Media Server Solution
- [Piracy and automation, an overview](https://docs.google.com/document/d/1TwUrRj982WlWUhrxvMadq6gdH0mPW0CGtHsTOFWprCo/edit) Guide by /u/JukeCity101 on how to improve your experience pirating with automation tools
- [Nefarious](https://lardbit.github.io/nefarious/) Nefarious is a web application that helps you download movies and TV shows.

### TV Automation
- [Sonarr](https://github.com/Sonarr/Sonarr) :star2: Smart PVR for newsgroup and BitTorrent users.
- [SickRage](https://github.com/SiCKRAGE/SiCKRAGE) Automatic Video Library Manager for TV Shows.
- [SickChill](https://sickchill.github.io/) an automatic Video Library Manager for TV Shows.
- [SickBeard](http://sickbeard.com/) The ultimate PVR application that searches for and manages your TV shows
- [SickGear](https://github.com/SickGear/SickGear) SickGear has proven the most reliable stable TV fork of the great Sick-Beard to fully automate TV enjoyment with innovation.
- [Medusa](https://pymedusa.com/) Automatic Video Library Manager for TV Shows.

### Movie Automation
- [Radarr](https://radarr.video/) :star2: A fork of Sonarr to work with movies à la Couchpotato.
- [RadarrSync](https://github.com/Sperryfreak01/RadarrSync) Syncs two Radarr servers through web API.
- [CouchPotato](https://github.com/CouchPotato/CouchPotatoServer) Automatic Movie Downloading via NZBs & Torrents
- [Watcher](https://github.com/nosmokingbandit/Watcher3) Watcher is an automated movie NZB & Torrent searcher and snatcher.

### Music Automation
- [betanin](https://github.com/sentriz/betanin) beets.io based man-in-the-middle of your torrent client and music player.
- [Lidarr](https://github.com/lidarr/Lidarr) Looks and smells like Sonarr but made for music.
- [Headphones](https://github.com/rembo10/headphones) Automatic music downloader for SABnzbd

### Subtitles Automation
- [Bazarr](https://github.com/morpheus65535/bazarr) Bazarr is a companion application to Sonarr and Radarr. It manages and downloads subtitles based on your requirements.
- [autosub](https://github.com/agermanidis/autosub) Command-line utility for auto-generating subtitles for any video file using speech recognition
- [nzb-subliminal](https://github.com/caronc/nzb-subliminal) Fetches subtitles for the videos it's provided. It can be easily integrated into NZBGet and SABnzbd too.
- [subsync](https://github.com/smacke/subsync) Automagically synchronize subtitles with the video.
- [vlsub](https://github.com/exebetche/vlsub) VLC extension to download subtitles from opensubtitles.org

## P2P Networks
- [eDonkey network](https://en.wikipedia.org/wiki/EDonkey_network) a decentralized, mostly server-based, peer-to-peer file-sharing network
- [Gnutella](https://en.wikipedia.org/wiki/Gnutella) P2P network behind the popular LimeWire file sharing app
- [FastTrack](https://en.wikipedia.org/wiki/FastTrack) Protocol used by the Kazaa, Grokster, iMesh, and Morpheus file-sharing programs
- [Napster](https://en.wikipedia.org/wiki/Napster) Peer-to-peer file sharing Internet service that emphasized sharing digital audio files, typically audio songs, encoded in MP3 format.
- [Peer-to-peer file sharing](https://en.wikipedia.org/wiki/Peer-to-peer_file_sharing) Detailed Wikipedia page about file sharing
- [IPFS - Distributed Web](https://en.wikipedia.org/wiki/InterPlanetary_File_System) Peer-to-peer distributed file system that seeks to connect all computing devices with the same system of files
- [Kad](https://en.wikipedia.org/wiki/Kad_network) The Kad network is a peer-to-peer (P2P) network that implements the Kademlia P2P overlay protocol.

## Ripping, Transcoding, Converting, Encoding
- [Handbrake](https://handbrake.fr/) :star2: HandBrake is a tool for converting video from nearly any format to a selection of modern, widely supported codecs.
- [MakeMKV](http://www.makemkv.com/) MakeMKV is your one-click solution to convert video that you own into a free and patents-unencumbered format that can be played everywhere.
- [ffmpeg](https://ffmpeg.org/) A complete, cross-platform solution to record, convert and stream audio and video.
- [sickbeard_mp4_automator](https://github.com/mdhiggins/sickbeard_mp4_automator) Automatically convert video files to a standardized mp4 format with proper metadata tagging to create a beautiful and uniform media library
- [Automatic Ripping Machine](https://b3n.org/automatic-ripping-machine/) The A.R.M. (Automatic Ripping Machine) detects the insertion of an optical disc, identifies the type of media and autonomously performs the appropriate action
- [DVD Decrypter](http://dvddecrypter.org.uk/) The original unofficial DVD Decrypter mirror since June 7th, 2005.
- [DVDFab](https://www.dvdfab.cn/) DVD ripping tool
- [The Encoding Guide](https://encoding-guide.neocities.org/) :star2: In-depth guide on encoding video

## Cloud Storage
- [google-drive-ocamlfuse](https://github.com/astrada/google-drive-ocamlfuse) FUSE filesystem over Google Drive
- [rclone](https://rclone.org/) :star2: "rsync for cloud storage"
- [plexdrive](https://github.com/dweidenfeld/plexdrive) mounts your Google Drive FUSE filesystem (optimized for media playback)
- [/r/PlexACD](https://www.reddit.com/r/PlexACD/) Discussion about unlimited cloud storage for Plex libraries
- [rclone-gdrive](https://bytesized-hosting.com/pages/rclone-gdrive) Wiki page on setting up Google Drive with rclone cache and crypt
- [Connect Your Plex Server To Your Google Drive](https://bytesized-hosting.com/pages/plexdrive) This tutorial will help you connect your Google Drive to your Plex server using Plexdrive.
- [RcloneBrowser](https://martins.ninja/RcloneBrowser/) Simple cross-platform GUI for rclone
- [UDS](https://github.com/stewartmcgown/uds) Unlimited Drive Storage. Store files in Google Docs without counting against your quota.
- [Comparison of file hosting services](https://en.wikipedia.org/wiki/Comparison_of_file_hosting_services) This is a comparison of file hosting services that are currently active.
- [Cloud storage table](https://nafanz.github.io/cloudstorage.html) Regularly updated table of information about top cloud storage providers.

## File Renaming and Tagging
- [FileBot](https://www.filebot.net/) :star2: the ultimate tool for organizing and renaming your Movies, TV Shows and Anime as well as fetching subtitles and artwork. It's smart and just works.
- [filebot-node](https://github.com/filebot/filebot-node) a client-server application that'll allow you to run filebot commands
- [docker-filebot](https://github.com/coppit/docker-filebot) A Docker container for FileBot
- [MediaMonkey](https://www.mediamonkey.com/) Manage a movie/music library from 100 to 100,000+ audio/video files and playlists
- [MP3TAG](https://www.mp3tag.de/en/) Mp3tag is a powerful and easy-to-use tool to edit metadata of audio files.
- [Picard](https://picard.musicbrainz.org/) Picard is a cross-platform music tagger written in Python.
- [Beets](https://github.com/beetbox/beets) beets is a music library manager
- [Metatogger](https://www.luminescence-software.org/en/metatogger.html) Metatogger is the new generation of tag editor allowing you to rename, tag and easily sort your audio files.
- [MediaInfo](https://mediaarea.net/en/MediaInfo) MediaInfo is a convenient unified display of the most relevant technical and tag data for video and audio files.
- [iFlicks2](https://iflicksapp.com/) Useful for adding metadata to movies and TV shows
- [MediaElch](https://www.kvibes.de/mediaelch/) Media manager for Kodi. Metadata & artwork retrieval, as well as renaming.
- [/r/datacurator](https://www.reddit.com/r/datacurator/) Subreddit for discussion about the curation of digital data. Be it sorting, file formats, file encoding, best practices, discussion of your setup, tips, and tricks, asking for help, etc.

## Mobile Apps
- [AdAway](https://adaway.org/) An open-source ad blocker for Android using the hosts file. It needs ROOT access
- [NewPipe](https://newpipe.schabi.org/) The original YouTube experience without annoying ads and questionable permissions
- [nzb360](http://nzb360.com/) :star2: nzb360 is a full-featured NZB manager that focuses on providing the best experience possible for controlling all of your Usenet needs.
- [Ombi](https://play.google.com/store/apps/details?id=com.tidusjar.Ombi) Companion app for Ombi to request Plex content
- [Tautulli Remote](https://play.google.com/store/apps/details?id=com.williamcomartin.plexpyremote) Mobile version of Tautilli for monitoring Plex on the go
- [MyJDownloader](https://play.google.com/store/apps/details?id=org.appwork.myjdandroid&hl=en_US) enables you to remote control your desktop JDownloader from your pocket while you're on the go.
- [FilePursuit Pro](https://play.google.com/store/apps/details?id=com.filepursuit.filepursuitpro) FilePursuit provides a very powerful file indexing and search service allowing you to find a file among millions of files located on web servers.
- [YMusic](https://forum.xda-developers.com/android/apps-games/app-youtube-music-sound-stream-youtubes-t3399722) YouTube Music Player & Downloader
- [Cygery AdSkip for YouTube](https://labs.xda-developers.com/store/app/com.cygery.adskip.xda) Automatically click on the "Skip ad" button in the YouTube™ app when it appears.
- [Blokada](https://blokada.org) Blokada is a compact app that transparently blocks unwanted content like ads, tracking, malware, and other annoyances.
- [Tachiyomi](https://github.com/inorichi/tachiyomi) Tachiyomi is a free and open-source manga reader for Android.
- [4PDA.ru](http://4pda.ru/forum/index.php?act=idx) 4PDA is the biggest Russian forum about mobile devices. You can find an endless amount of APKs and Mobile software there. For download, registration is required
- [AnYme](https://github.com/zunjae/anYme) Unofficial Anime App for MyAnimeList
- [Perfect Player](https://play.google.com/store/apps/details?id=com.niklabs.pp) Perfect Player is set-top box style IPTV/Media player for watching videos on TVs, tablets and smartphones.
- ["My little guide for piracy on iPhone"](https://www.reddit.com/r/Piracy/comments/ajkeq2/my_little_guide_for_piracy_on_iphone/) Post by /u/Impulse_13
- [nzbUnity](https://nzbunity.dozenzb.com/) iOS app for managing your favourite NZB applications
- [TiviMate IPTV player](https://play.google.com/store/apps/details?id=ar.tvplayer.tv) A popular Android app for watching IPTV on Android set-top boxes.
- [Fildo](https://fildo.net/android/en/#) Android music streaming app which fetches files from third party MP3 search engines.
- [YouTube Vanced](https://vanced.app/) Vanced is a well known modded version of YouTube with many features such as adblocking and background playback and many more.

### Streaming Apps
- [MediaBox HD](https://mediaboxhd.net) MediaBox HD is a free streaming app with movies, tv shows, and music. VIP membership grants access to 1000s of reliable high-quality streams. It can cast to Chromecast, Apple TV, Fire TV, and Xbox.
- [Kokotime](https://www.kokotime.tv/) Kokotime is an addon-based, simple, free and elegantly designed app that will let you watch all your favorite media content in a unique and elegant user-friendly design
- [Mobdro](https://forum.mobilism.org/viewtopic.php?f=429&t=2720792&hilit=mobdro) Mobdro constantly searches the web for the best free video streams and brings them to your device.
- [Cinema](https://forum.mobilism.org/viewtopic.php?t=2786441) a lot of Movies & TV/Shows to watch and download.
- [Fildo](https://fildo.net/android/en/) Music streaming app
- [TeaTV](https://teatv.net/) App for Android, Windows, and macOS for watching 1080p movies and TV shows for free
- [AniméGlare](https://animeglare.xyz/)
- [AniméVibe](http://animevibe.tv/)
- [ApolloTV](https://apollotv.xyz/)
- [BeeTV](http://beetvapk.me/)
- [Cinema](https://cinemaapk.com/)
- [CKayTV](http://ckaytv.com/)
- [Cyberflix](https://cybercloud.media/) Terrarium clone
- [DreamTV](http://dream-tv.xyz/) Terrarium clone
- [Morph TV](http://titaniumtv.xyz/Morph2.apk) Morpheus fork
- [PhoenixTV](https://tinyurl.com/y7z5zct8) Morpheus fork
- [TitaniumTV](http://titaniumtv.xyz/) Terrarium clone
- [TVZion](https://tvzionapp.live/)
- [UnlockMyTV](https://unlockmytv.com/) Cinema clone ad-free

### Torrent Apps
- [Transdrone](https://play.google.com/store/apps/details?id=org.transdroid.lite) Transdrone allows you to manage the torrents you run on your home server or seedbox.
- [Flud](https://play.google.com/store/apps/details?id=com.delphicoder.flud&hl=en) Flud is a simple and beautiful BitTorrent client for Android.
- [BiglyBT](https://f-droid.org/packages/com.biglybt.android.client/) Free, open-source torrent client for Android phone, tablet, Chromebook, & Android TV
- [LibreTorrent](https://f-droid.org/en/packages/org.proninyaroslav.libretorrent/) LibreTorrent is a Free as in Freedom torrent client for Android 4+, based on libtorrent.
- [Vuze](https://play.google.com/store/apps/details?id=com.vuze.torrent.downloader) Lightweight & powerful BitTorrent app.
- [aTorrent](https://play.google.com/store/apps/details?id=com.mobilityflow.torrent) Another popular torrent client for Android.
- [Trireme](https://www.f-droid.org/en/packages/org.deluge.trireme/) Use this app to connect and manage your Deluge Daemon.

### APKs
- [Aptoide](https://en.aptoide.com/) An alternative repository-based marketplace for Android applications
- [F-Droid](https://f-droid.org/fr/) An installable catalogue of FOSS (Free and Open Source Software) Android applications
- [Yalp Store](https://github.com/yeriomin/YalpStore) Download apks from Google Play Store
- [Mobilism Forum](https://forum.mobilism.org/index.php) :star2: Large forum of mobile apps and books
- [On HAX](https://onhax.me/) APK mirrors
- [APKMirror](https://www.apkmirror.com/) Download free Android APKs
- [ApkPure](https://apkpure.com/) Another free APK mirror site
- [ACMARKET](https://acmarket.net/) download cracked & modified android apps & games free
- [BlackMod](https://blackmod.net/) Lots of cracked Android games
- [Android Zone](https://android-zone.ws/) Another place to find premium links for APKs
- [RevDl](https://www.revdl.com/) Direct download site for Android apps and games.
- [/r/ApksApps](https://www.reddit.com/r/apksapps) "The best Modded apps on Reddit."
- [/r/moddedandroidapps](https://www.reddit.com/r/moddedandroidapps) Modded Android app releases subreddit.
- [IndexOutOfBounds Store](https://store.ioob.pw/) Streaming apps including Liveflix, PopFlix, SeriesDroid S2, and AnimeDroid S2.
- [Aurora OSS](https://gitlab.com/AuroraOSS/AuroraStore) An open-source alternative for the Google Play Store.
- [AuroraDroid](https://gitlab.com/AuroraOSS/auroradroid) Aurora Droid is an unofficial, FOSS client for F-Droid.

## Discord Servers
- [The Ratio](https://discordapp.com/invite/wab3Qag) :star2: Community of seedbox enthusiasts. Buying advice, application setup, and automation help.
- [DoujinStyle](https://discord.gg/z2QDFdA) Discord server with Doujin related materials. Things such as Japanese doujin music and games
- [The Eye](https://discordapp.com/invite/py3kX3Z) Official Discord server for the-eye.eu
- [PlayStation Homebrew](https://discord.gg/JJnvEN8) Home of /r/ps3homebrew and /r/ps4homebrew.
- [Snahp.it](https://discord.gg/ypyKZCj) Official Discord server for snahp.it.
- [WarezNX](https://discord.gg/d6xxuPq) Nintendo Switch Warez server. (/hbg/ has more up to date games as of April 2019)
- [/hbg/ Homebrew General](https://discord.io/homebrew) A Discord server that shares Nintendo Switch Games.
- [/r/soccerstreams](https://discord.gg/geyTtth) Official Discord server for the recently-killed /r/soccerstreams subreddit.
- [APK'S 2 Day](https://discord.gg/2qWqzN8) This is a discord server that acts as a hub for numerous streaming apps.


## IPTV and DVR
- [IPTV Guide and Basics](https://www.reddit.com/r/IPTV/comments/ckoneg/start_here_iptv_guide_and_basics/) Post by /u/Specific_Angle describing in detail how to get started with IPTV
- [iptv-org/iptv](https://github.com/iptv-org/iptv) Collection of 8000+ publicly available IPTV channels from all over the world
- [telly](https://github.com/tellytv/telly) IPTV proxy for Plex Live written in Golang
- [tvheadend](https://github.com/tvheadend/tvheadend) Tvheadend is a TV streaming server for Linux supporting DVB-S, DVB-S2, DVB-C, DVB-T, ATSC, IPTV, SAT>IP, and other formats through the Unix pipe as input sources.
- [/r/IPTV](https://www.reddit.com/r/IPTV) Subreddit some may find helpful for gauging the current state of IPTV providers
- [/r/iptvresellers](https://www.reddit.com/r/IPTVresellers) promotions and advertisements from IPTV providers
- [/r/IPTVReviews](https://www.reddit.com/r/IPTVreviews) Reviews of IPTV service providers
- [MythTV](https://www.mythtv.org/) Free Open Source software digital video recorder
- [allsprk.tv](https://stream.allsprk.tv) A channel-hoppable live streaming site with a chat room
- [UlstreaMix](https://ssl.ustreamix.com/) Live TV streaming site, predominantly sports
- [Xtream Editor](http://www.xtream-editor.com/) Xtream Editor allows you to create, edit and sort m3u playlists online.
- [xTeVe](https://xteve.de/) :star2: M3U Proxy for Plex DVR
- [STBEmulator](http://rocketstreams.tv/stbemu) Popular Android app for using IPTV streams with EPG
- [IPTV Community](https://iptv.community/) Technology and IPTV discussion website, useful for finding an IPTV provider/reseller
- [antennas](https://github.com/TheJF/antennas) HDHomeRun emulator for Plex DVR to connect to Tvheadend.
- [IPTV Providers list](https://docs.google.com/spreadsheets/d/1ehpk3OCkqj4QgF71v410avGpGC5bQ_lOLl5ppRb3Q9s/edit) A recently created list of 40+ IPTV providers with notes
- [fastocloud](https://github.com/fastogt/fastocloud) IPTV/Video cloud admin panel for servers

### Acestreams
- [acestream.org](http://acestream.org/) Ace Stream is a peer-to-peer streaming application that lets you stream live sports and other content
- [AceStreamSearch](https://acestreamsearch.com/en/) Ace Stream Broadcasts Search
- [aceproxy](https://github.com/ValdikSS/aceproxy) Ace Stream HTTP Proxy. (abandonware)
- [iktason/aceproxy](https://hub.docker.com/r/ikatson/aceproxy/) A docker image to run aceengine + aceproxy, e.g. to watch Torrent-TV.ru.

## IRC
- [XDCC Tutorial](http://theloadguru.com/xdcc-irc-beginners-guide/) XDCC Downloading For Beginners: Do It Like A Pro
- [XDCC](https://en.wikipedia.org/wiki/XDCC) XDCC (Xabi DCC or eXtended DCC) is a computer file sharing method which uses the Internet Relay Chat (IRC) network as a hosting service.
- [ZNC](https://github.com/znc/znc) An advanced IRC bouncer

### IRC Clients
- [weechat](https://github.com/weechat/weechat) :star2: The extensible chat client.
- [irssi](https://irssi.org/) Your text mode chatting application since 1999.
- [HexChat](https://hexchat.github.io/) HexChat is an IRC client based on XChat, but unlike XChat it’s completely free for both Windows and Unix-like systems.
- [KVIrc](https://github.com/kvirc/KVIrc) Graphical IRC client
- [mIRC](https://www.mirc.com/) IRC client for Windows
- [Shout](https://github.com/erming/shout) The self-hosted web IRC client
- [Kiwi IRC](https://kiwiirc.com/) Popular web-based IRC client
- [TheLounge](https://hub.docker.com/r/linuxserver/thelounge/) TheLounge (a fork of shoutIRC) is a web IRC client that you host on your own server.

### IRC Networks
- [irc.p2p-network.net](https://p2p-network.net/) P2P file-sharing network
- [p2p-network.net channel list](https://search.mibbit.com/channels/p2p-network) List of all channels on the p2p-network.net IRC network
- [Orpheus](https://orpheus.network/) Formerly known as Apollo
- _Moviegods_  `irc://irc.abjects.net/MOVIEGODS` :star2: XDCC file-sharing network, join #mg-chat to continue downloading
- _The Source_ `irc://irc.scenep2p.net/THE.SOURCE` Another XDCC source
- _Beast-XDCC_ `irc://irc.abjects.net/BEAST-XDCC` One more XDCC source
- _irc.undernet.org/bookz_ `irc://irc.undernet.org/bookz` For downloading ebooks (use `@search <book name>` for a list of available ebooks)
- _irc.irchighway.net/ebooks_ `irc://irc.irchighway.net/ebooks` A nice, friendly IRC channel for trading ebooks

### IRC Search Engines
- [xWeasel](http://xweasel.org) xWeasel is a free stand-alone Download Client based on IRC technology including a multifunctional XDCC Search Engine.
- [ixIRC](https://ixirc.com/) ixIRC lets you search through 17 IRC networks, 32 channels, and over 189915 user-supplied XDCC packs.
- [SunXDCC](http://sunxdcc.com/) Another XDCC file search engine
- [xdcc.eu](http://www.xdcc.eu/) XDCC search engine indexing packets from a large number of networks

## DC++
- [Direct Connect (protocol)](https://en.wikipedia.org/wiki/Direct_Connect_(protocol)) Wikipedia page describing Direct Connect.
- [DC++](https://en.wikipedia.org/wiki/DC%2B%2B) Wikipedia page describing DC++
- [AirDC++](https://www.airdcpp.net/) :star2: Windows GUI and Linux Web DC++ client in active development, with ADC, IPv6 and DHT support.
- [FlylinkDC++](http://www.flylinkdc.com/) Windows DC++ and BitTorrent client in active development, with ADC and DHT support.
- [EiskaltDC++](https://github.com/eiskaltdcpp/eiskaltdcpp) Windows/Linux/macOS DC++ client, with ADC and DHT support
- [LinuxDC++](https://launchpad.net/linuxdcpp) Utilizing the latest DC++ core, LinuxDC++ offers similar functionality to the Windows client like segmented downloading, TTH based file integrity, etc. with a GTK+ user interface.
- [Tankafett](http://tankafett.biz/?do=hublist) List of public DC++ hubs, previously known as hublist.org and TheHubList.com.
- [Linux DC++](https://launchpad.net/linuxdcpp) Easy to configure and use DC++ client

## Full Movies On
- [/r/fullmoviesonyoutube](https://www.reddit.com/r/fullmoviesonyoutube/)
- [/r/fullmovierequest](https://www.reddit.com/r/fullmovierequest/)
- [/r/Fullmoviesonvimeo](https://www.reddit.com/r/Fullmoviesonvimeo/)
- [/r/fulltvshowsonyoutube](https://www.reddit.com/r/fulltvshowsonyoutube/)
- [/r/fulltvshowsonvimeo](https://www.reddit.com/r/fulltvshowsonvimeo/)
- [/r/fullcartoonsonyoutube](https://www.reddit.com/r/fullcartoonsonyoutube/)
- [/r/FullLengthFilms](https://www.reddit.com/r/FullLengthFilms/)
- [/r/FullMoviesDailyMotion](https://www.reddit.com/r/FullMoviesDailyMotion)
- [/r/1080pMoviesOnline](https://www.reddit.com/r/1080pMoviesOnline)
- [fullmoviesandtv multireddit](https://www.reddit.com/user/Wiggly_Poop/m/fullmoviesandtv/) All of the above subreddits as a multireddit

## Piracy Blogs and News
- [TorrentFreak](https://torrentfreak.com) :star2: TorrentFreak is a publication dedicated to bringing the latest news about copyright, privacy, and everything related to filesharing.
- [TechWorm](https://www.techworm.net) Techworm is a Tech, Cyber-security news platform.

## Content Discovery
- [Trakt.tv](https://trakt.tv/) :star2: a platform that does many things, but primarily keeps track of TV shows and movies you watch.
- [IMDb](https://www.imdb.com/) Find movies, TV shows, celebrities, and more
- [Movieo](https://movieo.me/) Discover, organize and track over 250,000 movies.
- [MetaCritic](https://www.metacritic.com) website that aggregates reviews of media products: music albums, video games, films, TV shows, and formerly, books.
- [popular-movies](https://github.com/sjlu/popular-movies) Tries to create a list of popular movies based on a series of heuristics
- [Letterboxd](https://letterboxd.com/) Your life in film
- [Squawkr.io](https://www.squawkr.io/) sends notifications when movies are available for download.
- [What is my movie?](https://www.whatismymovie.com/) AI-powered movie search. "Use your own words, or search with titles, actors, directors, genres, etc. We find movies for you to watch."
- [2160p BluRay Remux List](https://docs.google.com/spreadsheets/d/1qU8E0JT9JQk_BaBCxZS79tn7YmUyY4XBEpHPm3j16jI/edit) Complete list of all available 2160p remuxes
- [Flox](https://github.com/devfake/flox) Flox is a self-hosted movie, series and anime watch list.
- [TVmaze](https://www.tvmaze.com/) TVmaze is a community of TV lovers and dedicated contributors that discuss and help maintain TV information on the web.
- [JustWatch](https://www.justwatch.com/) On JustWatch you can find out where to watch your favorite movies & TV series
- [WhereYouWatch](https://whereyouwatch.com/latest-reports/) Follow upcoming movies and receive email alerts when they are out online as a download or stream – pirated or via retail.
- [Flickmetrix](https://flickmetrix.com/) Movie database search engine with disc/Netflix/Prime filtering
- [dvdsreleasedates.com](https://www.dvdsreleasedates.com/) The latest info on new Blu-ray and DVD releases
- [Simkl](https://simkl.com/) Movie and TV show scrobbler similar to Trakt.tv

### PreDB Sites
- [Urban Dictionary: predb](https://www.urbandictionary.com/define.php?term=predb) Urban Dictionary definition
- [PreDB.org](https://predb.org/)
- [PreDB.me](https://predb.me/)
- [PREdb](https://predb.ovh/)
- [WarezBot](https://github.com/enzobes/WarezBot) Discord bot for scene releases.
- [NSW Releases](http://nswdb.com/) Nintendo Switch scene releases.
- [3DS Releases](http://3dsdb.com/) Nintedo 3DS scene releases.
- [NSWDBot](https://github.com/HunterKing/NSWDBot) A discord bot for scraping NSWDB.com for "Scene" releases.

## Dashboards and Homepages
- [Muximux](https://github.com/mescon/Muximux) A lightweight way to manage your HTPC
- [Heimdall](https://github.com/linuxserver/Heimdall) An Application dashboard and launcher
- [Organizr](https://github.com/causefx/Organizr) :star2: HTPC/Homelab Services Organizer - Written in PHP
- [weboas.is](http://weboas.is/) Homepage for pirates
- [Anonmasky](https://github.com/Anonmasky/anonmasky.github.io) Anonmasky is a beautiful start page for geeks out there. Clone of weboas.is.
- [iDashboard-PHP](https://github.com/causefx/iDashboard-PHP) HTPC Dashboard to load website services, written in PHP (predecessor to Organizr)
- [HTPC-Manager](https://github.com/Hellowlol/HTPC-Manager) A fully responsive interface to manage all your favorite software on your Htpc.
- [Monitorr](https://github.com/Monitorr/Monitorr) Self-hosted PHP-based web front platform that displays the status of any web app or service in real-time.
- [Logarr](https://github.com/Monitorr/logarr) "Logarr" is a self-hosted, PHP-based, single-page log consolidation tool which formats and displays log files for easy analysis.

## Proxy Sites
- [Unblocked](https://unblocked-pw.github.io/) :star2: a Proxy site for accessing your favorite blocked sites
- [ByPassed](https://bypassed.wtf/) ByPassed is an all-in-one solution to unblock censored websites including thepiratebay, kickass, eztv, yts, extratorrent & more.

## File Sharing Tools
- [transfer.sh](https://transfer.sh/) Easy file sharing from the command line
- [FilePizza](https://file.pizza/) Free peer-to-peer file transfers in your browser.
- [DBREE](https://dbr.ee/) DBREE is a simplistic and easy way to upload and share any type of file.
- [WeTransfer](https://wetransfer.com/) WeTransfer was founded in 2009 as the simplest way to send big files around the world.
- [dmca.gripe](https://dmca.gripe/) A DMCA-resistant, permanent file hosting service.
- [FileBin](https://filebin.net/) Convenient file sharing on the web, without registration.

## Stream Synchronisation
- [/r/Movie_Club](https://www.reddit.com/r/Movie_Club) Where you can get together with strangers and watch a great movie every week!
- [sync](https://github.com/calzoneman/sync/) Node.JS Server and JavaScript/HTML Client for synchronizing online media
- [watch2gether](https://www.watch2gether.com/) Enjoy the internet in sync with your friends. Watch videos, listen to music or go shopping on Watch2Gether.
- [SyncLounge](https://synclounge.tv/) :star2: A third-party tool that allows you to watch Plex in sync with your friends/family, wherever you are.
- [Netflix Party](https://chrome.google.com/webstore/detail/netflix-party/oocalimimngaihdkbihfgmpkcpnmlaoa/related) Netflix Party is a Chrome extension for watching Netflix remotely with other users.
- [CyTube](https://cytu.be/) Channel-based shared streaming platform for synchronized viewing of YouTube and Google Drive videos
- [ArconaiTV](https://www.arconaitv.us/) Another stream sharing platform with a nice UI
- [&chill](https://andchill.tv/) Watch videos with people.

## Telegram Piracy
- [Raymond's Piracy Group](https://t.me/raymondfreesoftware) A group of 5000+ pirates chatting on Telegram. This group replaces the now-defunct piracy group which suicideboy used to run.
- [Piracy Links Portal](https://t.me/PiracyLinks) Official invite links portal for piracy groups & channels.
- [piratebazaar](https://t.me/piratebazaar) Curated list of piracy-related links.
- [@itorrentsearchbot](https://t.me/itorrentsearchbot) Search bot for finding torrent and magnet links on 1337x.to by keyword search
- [@vkmusic_bot](https://telegram.me/vkmusic_bot) Find and download pretty much any song
- [@RickyChristanto](https://t.me/RickyChristanto) Channel for movie releases, usually from YTS in MKV format.
- [iMediaShare channel](https://t.me/iMediaShare) Movies, TV shows, apps, and more
- [@movies_inc](https://t.me/movies_inc) Another Telegram channel for downloading movies
- [@Qualitymovies](https://t.me/Qualitymovies) Lots of 720p Blu-Ray movie releases
- [@MusicHuntersBot](https://t.me/MusicHuntersBot) Another music downloader bot
- [@DeezerMusicBot](https://t.me/DeezerMusicBot) Music bot which downloads tracks from Deezer
- [SMLoadrCommuntiy](https://t.me/SMLoadrCommunity) Telegram community for SMLoadr
- [aria-telegram-mirror-bot](https://github.com/out386/aria-telegram-mirror-bot) A Telegram bot to download files via HTTP(S)/BitTorrent and upload them to Google Drive.
- [CrackWatch trackers](https://www.reddit.com/r/CrackWatch/comments/b2ywcn/crackwatch_telegram_tracker/) Telegram channels for CrachWatch.com games & cracks by /u/SHADOWSLIFER.

## Miscellaneous
- [UK ISP Court Orders](http://www.ukispcourtorders.co.uk/) :star2: List of websites recently taken down in the UK by the High Court. Use a VPN to access them, they must be pretty good!
- [Counterfeit and Piracy Watch List 2018](https://torrentfreak.com/images/tradoc_157564.pdf)
- [/r/EmbyShares](https://www.reddit.com/r/EmbyShares) This subreddit is dedicated to the sharing of Emby servers.
- [/r/freefolk](https://www.reddit.com/r/freefolk) Streams for new episodes of Game of Thrones
- [/r/ProshotMusicals](https://www.reddit.com/r/ProShotMusicals) Subreddit for all those theatre obsessed people who want pro shots instead of bootlegs to be seen.
- [Shodan](https://www.shodan.io/) Shodan is the world's first search engine for Internet-connected devices.
- [Pi-hole](https://pi-hole.net/) Pi-hole is a Linux network-level advertisement and internet tracker blocking application which acts as a DNS sinkhole
- [How to use eMule in 2018](https://archive.is/j1T6o) An up-to-date guide detailing how to use eMule to download rare content from the eDonkey and Kad P2P networks.
- [Anon.to](https://anon.to/) URL shortener to de-referer or null-referer your links.
- [Movie Release Types](https://i.imgur.com/kEOrKJT.png) Table of common movie release types, their labels, and descriptions.
- [How To Host "Questionable" Websites v4.0](https://weboas.is/media/host.pdf) PDF from weboas.is. There are also [PNG](https://weboas.is/media/host.png), [PSD](https://weboas.is/media/host.psd), and [TXT](https://weboas.is/media/host.txt) versions
- [Privacy.com](https://privacy.com/) Privacy creates secure virtual cards and completes checkout forms for you, saving you time and money while masking your real card details.
- [/f/Piracy](https://raddle.me/f/Piracy) Raddle forum for Piracy
- [/s/piracy](https://saidit.net/s/piracy) Saidit forum for Piracy - unofficially the backup forum for /r/Piracy if/when it is banned by the Reddit moderators.
- [/v/piracy](https://voat.co/v/piracy) Voat forum for Piracy - another potential fallback option for /r/Piracy.
- [2019 Oscar DVD Screeners](https://whereyouwatch.com/articles/here-are-the-2019-oscar-dvd-screeners/) List of DVD screeners for 2019's Oscars
- [Academy Awards 2019 Screeners Megathread](https://www.reddit.com/r/Piracy/comments/aaqc0b/academy_awards_2019_screeners_megathread/) Post by /u/idoideas listing all available DVDSCR releases for 2019
- [iNFekt](https://infekt.ws/) A text viewer application that has been carefully designed around its main task: viewing and presenting NFO files.
- [NFForce](http://nfforce.temari.fr/) Another NFO viewer.
- [How To Get Everything On Netflix](https://www.removeddit.com/r/NetflixViaVPN/comments/4z5fiq/how_to_get_everything_on_netflix_not_only_the_us/d6t00gv/) Recovered Link to a post by /u/huldre99
- [TheTrove](https://thetrove.net/) The Trove is a non-profit website dedicated to content archival and long-term preservation of RPGs.
- [serials](http://www.serials.ws/) Serial keys for software that may or may not work.
- [scenerules](https://scenerules.org/) NFOs with rules and guidelines for scene releasing standards.
- [SceneLinkList](https://www.scenelinklist.com/) SceneLinkList is a project initiated to display and share as many scene and warez links as possible.
- [TheWarezFolder](http://thewarezfolder.com/) Fairly out of date categorised list of warez sites.
- [castnow](https://github.com/xat/castnow) Castnow is a command-line utility that can be used to play back media files on your Chromecast device.
- [Grabber](https://grabber.co.in/) Download stock images from Shutterstock
- [The Pirate Society](https://thepiratesociety.org/forums/) A mysterious members-only forum for pirates.
- [Bandersnatch Interactive Player](https://mehotkhan.github.io/BandersnatchInteractive/) Online video player for watching the new interactive episode of Black Mirror, "Bandersnatch".
- [Multiup](https://multiup.org/) Website which allows you to upload files to several different file hosting websites.
- [DirtyWarez](https://dirtywarez.org/) Lists top warez sites with Alexa rankings and other metadata.
- [MacGuffin](https://github.com/hwkns/macguffin) Automated tools for handling Scene and P2P film releases.
- [Archive of r/Piracy subreddit 2019-03-19](https://ourproject.org/forum/forum.php?thread_id=44721&forum_id=4917&group_id=2645) An archive of all gilded /r/Piracy comments and threads.
- [PiracyArchive](https://github.com/nid666/PiracyArchive) A complete backup of the Reddit /r/Piracy subreddit
- [List of warez groups](https://en.wikipedia.org/wiki/List_of_warez_groups) Wikipedia's list of warez groups and individuals.
- [netflix-proxy](https://github.com/ab77/netflix-proxy/) Smart DNS proxy to watch Netflix out-of-region
- [k8s-usenet](https://github.com/aldoborrero/k8s-usenet) A collection of Helm (Kubernetes) charts related to different Usenet services (sabnzbd, radarr, sonarr...).
- [Outline](https://outline.com/) Designed to remove ads, comments, and other junk from news articles but conveniently also bypasses paywalls

## Contribute
Contributions welcome! Read the [contribution guidelines](contributing.md) first.

## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0)

To the extent possible under law, Igglybuff has waived all copyright and
related or neighboring rights to this work.
