/******************************************************************************

	ascii_14p.c

	14 pixels ASCII code (ISO-646) proportional font.

	code: 0x20-0x80

******************************************************************************/

#include "psp/psp.h"

#define NUM_FONTS	0x60

/*------------------------------------------------------
	gryph data
------------------------------------------------------*/

static const UINT8 ALIGN_DATA ascii_14p[] = {
	0xf0,0x08,0xf0,0x07,0xf0,0x07,0xf0,0x07,0xf0,0x07,0xf0,0x07,0xf0,0x07,0xf0,0x07,
	0x70,0x03,0x71,0x05,0xf3,0x0b,0xf3,0x0b,0x50,0x6e,0x5f,0xd0,0xb5,0x06,0x55,0x83,
	0x00,0x00,0x53,0x70,0x01,0x00,0xb9,0xf1,0x03,0x00,0x8b,0xf3,0x00,0x31,0x9c,0xf7,
	0x03,0xf7,0xff,0xff,0x0f,0x00,0x3f,0xb7,0x00,0x10,0x3f,0xab,0x00,0x30,0x0f,0x7b,
	0x00,0x93,0x7f,0xbd,0x07,0xd5,0xbe,0xcf,0x0b,0x70,0x0b,0x3f,0x00,0xa0,0x3a,0x1f,
	0x00,0xb0,0x37,0x0f,0x00,0x20,0x11,0x03,0x00,0x00,0xb0,0x02,0x00,0x10,0xf9,0x4c,
	0x00,0xd0,0xfc,0xfa,0x03,0xf3,0xf0,0x93,0x0a,0xf3,0xf0,0x33,0x05,0xe0,0xf8,0x03,
	0x00,0x20,0xfd,0x2b,0x00,0x00,0xf0,0xfb,0x03,0x21,0xf0,0x93,0x0c,0xe6,0xf0,0x33,
	0x0f,0xf1,0xf6,0xa4,0x0d,0x70,0xff,0xef,0x04,0x00,0xf1,0x06,0x00,0x00,0x30,0x00,
	0x00,0xf4,0x04,0xd0,0x00,0x7c,0x0c,0xc4,0x00,0x0f,0x0f,0x59,0x00,0x0f,0x0f,0x0e,
	0x00,0x1d,0x4d,0x0a,0x00,0xd9,0x99,0x86,0x02,0x50,0xf1,0xc7,0x0d,0x00,0xa5,0x3b,
	0x0f,0x00,0x4a,0x3b,0x3f,0x00,0x0e,0x3b,0x1f,0x50,0x09,0xa8,0x0e,0x70,0x04,0xb1,
	0x05,0x00,0xd5,0x0a,0x00,0x00,0x00,0x6f,0x6c,0x00,0x00,0x30,0x0f,0xa8,0x00,0x00,
	0x00,0x5f,0x5e,0x00,0x00,0x00,0xfb,0x09,0x00,0x00,0x50,0xfe,0x02,0x03,0x00,0xf1,
	0x83,0x0b,0x7b,0x00,0xd5,0x00,0x8e,0x6c,0x00,0xc5,0x00,0xe2,0x2f,0x00,0xf2,0x02,
	0xc0,0xdf,0x05,0x90,0xbf,0xcf,0xb2,0x09,0x00,0x42,0x03,0x00,0x00,0xf7,0x03,0xf5,
	0x02,0xd0,0x00,0x41,0x00,0x00,0xe1,0x07,0x00,0xcb,0x00,0x40,0x2f,0x00,0xa0,0x09,
	0x00,0xf0,0x04,0x00,0xf1,0x01,0x00,0xf3,0x00,0x00,0xf1,0x01,0x00,0xf0,0x04,0x00,
	0xa0,0x09,0x00,0x40,0x2f,0x00,0x00,0xcb,0x00,0x00,0xe1,0x07,0x10,0x00,0xd7,0x00,
	0xd0,0x0a,0x30,0x3f,0x00,0x9b,0x00,0xe5,0x00,0xf3,0x00,0xf3,0x00,0xf3,0x00,0xe5,
	0x00,0x9b,0x30,0x3f,0xd0,0x0a,0xd7,0x00,0x00,0x30,0x01,0x00,0x00,0xf0,0x07,0x00,
	0xb1,0xf1,0x67,0x08,0xe3,0xfe,0xfe,0x0a,0x10,0xfd,0x7f,0x00,0xe4,0xfe,0xfe,0x0b,
	0xa0,0xf0,0x47,0x08,0x00,0xf0,0x07,0x00,0x00,0x30,0x01,0x00,0x00,0x30,0x01,0x00,
	0x00,0xf0,0x07,0x00,0x00,0xf0,0x07,0x00,0xb5,0xfb,0xbd,0x0b,0xb5,0xfb,0xbd,0x0b,
	0x00,0xf0,0x07,0x00,0x00,0xf0,0x07,0x00,0x00,0x30,0x01,0x00,0xb5,0x02,0xf7,0x02,
	0xd0,0x00,0x62,0x00,0xb8,0xbb,0x05,0xb8,0xbb,0x05,0x71,0x03,0xf3,0x07,0x30,0x01,
	0x00,0x00,0x00,0x07,0x00,0x00,0x30,0x0e,0x00,0x00,0xb0,0x07,0x00,0x00,0xf2,0x00,
	0x00,0x00,0x99,0x00,0x00,0x10,0x1f,0x00,0x00,0x90,0x09,0x00,0x00,0xe0,0x03,0x00,
	0x00,0xb7,0x00,0x00,0x00,0x3e,0x00,0x00,0x50,0x0c,0x00,0x00,0xd0,0x05,0x00,0x00,
	0xd5,0x00,0x00,0x00,0x43,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x50,0xfe,0x5e,0x00,
	0xe0,0x39,0xe9,0x00,0xf5,0x00,0xf0,0x05,0xc8,0x00,0xc0,0x08,0xbb,0x00,0xb0,0x0b,
	0xbb,0x00,0xb0,0x0b,0xbb,0x00,0xb0,0x0b,0xc8,0x00,0xc0,0x08,0xf5,0x00,0xf0,0x05,
	0xe0,0x39,0xe9,0x00,0x50,0xfe,0x5e,0x00,0x00,0x30,0x00,0x00,0x00,0xb6,0xa3,0xbf,
	0xb5,0xbe,0x00,0xbb,0x00,0xbb,0x00,0xbb,0x00,0xbb,0x00,0xbb,0x00,0xbb,0x00,0xbb,
	0x00,0xbb,0x00,0x22,0x00,0xf9,0x7e,0x00,0x70,0x4e,0xf6,0x05,0xe0,0x08,0xc0,0x0a,
	0xf0,0x05,0xc0,0x09,0x00,0x00,0xf2,0x05,0x00,0x00,0xdc,0x00,0x00,0xc0,0x2f,0x00,
	0x00,0xf9,0x05,0x00,0x40,0x6f,0x00,0x00,0xd0,0x0c,0x00,0x00,0xf3,0xff,0xff,0x07,
	0x30,0x33,0x33,0x01,0x00,0xfb,0x7e,0x00,0x90,0x4e,0xf8,0x03,0xe0,0x06,0xf0,0x07,
	0x70,0x01,0xf0,0x06,0x00,0x70,0xeb,0x01,0x00,0xf0,0xaf,0x00,0x00,0x30,0xf7,0x05,
	0x71,0x01,0xc0,0x0b,0xf2,0x03,0xb0,0x0b,0xd0,0x0a,0xe2,0x07,0x40,0xfe,0xcf,0x00,
	0x00,0x31,0x03,0x00,0x00,0x30,0xbf,0x00,0x00,0xa0,0xbf,0x00,0x00,0xf1,0xbe,0x00,
	0x00,0xc9,0xbb,0x00,0x00,0x5f,0xbb,0x00,0x70,0x0d,0xbb,0x00,0xe0,0x07,0xbb,0x00,
	0xf3,0xff,0xff,0x0b,0x71,0x77,0xdd,0x05,0x00,0x00,0xbb,0x00,0x00,0x00,0xbb,0x00,
	0x00,0x00,0x22,0x00,0xb0,0xff,0xff,0x03,0xb0,0x7d,0x77,0x01,0xe0,0x07,0x00,0x00,
	0xf0,0x07,0x00,0x00,0xf0,0xfd,0x8f,0x00,0xf0,0x3c,0xf7,0x05,0x30,0x00,0xc0,0x0a,
	0x00,0x00,0xb0,0x0b,0xf1,0x03,0xb0,0x0a,0xd0,0x0a,0xf3,0x06,0x20,0xfe,0xbf,0x00,
	0x00,0x30,0x02,0x00,0x00,0xf8,0x7f,0x00,0x70,0x8f,0xfa,0x03,0xd0,0x08,0xa0,0x06,
	0xf1,0x23,0x01,0x00,0xf3,0xfc,0x9f,0x00,0xf3,0x4e,0xf6,0x05,0xf3,0x07,0xc0,0x0b,
	0xf3,0x03,0x70,0x0b,0xf0,0x07,0xa0,0x0b,0xb0,0x1d,0xf6,0x06,0x20,0xfe,0xbf,0x00,
	0x00,0x30,0x03,0x00,0xff,0xff,0x7f,0x77,0x77,0x7f,0x00,0x20,0x2f,0x00,0x80,0x0e,
	0x00,0xc0,0x09,0x00,0xf1,0x05,0x00,0xf5,0x00,0x00,0xba,0x00,0x00,0x6e,0x00,0x30,
	0x2f,0x00,0x80,0x0d,0x00,0x20,0x02,0x00,0x20,0xfb,0x8f,0x00,0xb0,0x7e,0xfa,0x03,
	0xf0,0x07,0xe0,0x07,0xe0,0x08,0xe0,0x07,0x80,0x8f,0xec,0x01,0x20,0xff,0xaf,0x00,
	0xc0,0x1c,0xf3,0x05,0xf2,0x03,0xb0,0x0b,0xf3,0x03,0xb0,0x0b,0xe0,0x1c,0xf4,0x07,
	0x50,0xfe,0xcf,0x00,0x00,0x30,0x03,0x00,0x00,0xfb,0x4e,0x00,0xb0,0x7d,0xea,0x01,
	0xf1,0x04,0xe0,0x06,0xf3,0x03,0xb0,0x0b,0xf3,0x03,0xd0,0x0b,0xe0,0x09,0xf4,0x0b,
	0x50,0xff,0xef,0x0b,0x00,0x73,0xa5,0x0b,0x70,0x02,0xe0,0x08,0xb0,0x0c,0xf7,0x03,
	0x20,0xfe,0x9f,0x00,0x00,0x30,0x02,0x00,0xb5,0x02,0xf7,0x03,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xf7,0x03,0xb5,0x02,0xb5,0x02,0xf7,0x03,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xf7,0x03,0xe5,0x03,0xe0,0x00,0x51,0x00,0x00,0x00,0x0a,0x00,
	0xc0,0x2e,0x00,0xec,0x02,0xc0,0x2e,0x00,0xfa,0x05,0x00,0xc0,0x2e,0x00,0x00,0xec,
	0x02,0x00,0xc0,0x2e,0x00,0x00,0x0a,0xb2,0xbb,0xbb,0x0b,0xb2,0xbb,0xbb,0x0b,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf3,0xff,0xff,0x0f,0x71,0x77,0x77,0x07,0x56,
	0x00,0x00,0xf9,0x05,0x00,0x90,0x5f,0x00,0x00,0xf9,0x05,0x00,0xd0,0x2f,0x00,0xf9,
	0x05,0x90,0x5f,0x00,0xf9,0x05,0x00,0x56,0x00,0x00,0x00,0x30,0x03,0x00,0x20,0xfe,
	0xdf,0x02,0xd0,0x09,0xc1,0x0a,0xf2,0x01,0x50,0x0f,0xf4,0x00,0x80,0x0d,0x00,0x00,
	0xe2,0x07,0x00,0x20,0x9e,0x00,0x00,0xa0,0x0b,0x00,0x00,0xd0,0x07,0x00,0x00,0x70,
	0x03,0x00,0x00,0x70,0x03,0x00,0x00,0xf0,0x07,0x00,0x00,0xf0,0x07,0x00,0x00,0x00,
	0x31,0x02,0x00,0x00,0xb1,0xbf,0xde,0x02,0x00,0x9e,0x00,0x60,0x1e,0x90,0x0a,0x96,
	0x74,0x99,0xf0,0x81,0x5c,0xbe,0xc3,0xc3,0xf0,0x01,0x7b,0xf3,0xb5,0xd3,0x00,0x4c,
	0xf3,0xb5,0xb3,0x00,0x0f,0xc3,0xc3,0xf2,0x40,0x0f,0x97,0xf0,0xc1,0xdc,0x6f,0x3e,
	0xa0,0x0a,0x13,0xc5,0x04,0x10,0x9e,0x00,0xa1,0x04,0x00,0xd2,0xce,0x8f,0x00,0x00,
	0x00,0x32,0x00,0x00,0x00,0xf0,0x0a,0x00,0x00,0xf5,0x0f,0x00,0x00,0xe9,0x4f,0x00,
	0x00,0x8e,0x8e,0x00,0x30,0x4f,0xda,0x00,0x80,0x0f,0xf5,0x01,0xc0,0x7d,0xf9,0x06,
	0xf1,0xff,0xff,0x0b,0xf5,0x02,0x80,0x0f,0xda,0x00,0x30,0x4f,0x8e,0x00,0x00,0x9e,
	0x13,0x00,0x00,0x22,0xf3,0xff,0xdf,0x05,0xf3,0x36,0xb4,0x3f,0xf3,0x03,0x00,0x7f,
	0xf3,0x03,0x20,0x7f,0xf3,0xbc,0xeb,0x1e,0xf3,0xbc,0xeb,0x2e,0xf3,0x03,0x00,0xad,
	0xf3,0x03,0x00,0xf8,0xf3,0x03,0x00,0xea,0xf3,0x03,0x50,0x9e,0xf3,0xff,0xff,0x0c,
	0x30,0x33,0x23,0x00,0x00,0xe7,0xdf,0x02,0x60,0x9f,0xc4,0x0e,0xd0,0x0a,0x10,0x6f,
	0xf2,0x04,0x00,0xbc,0xf3,0x03,0x00,0x22,0xf7,0x03,0x00,0x00,0xf4,0x03,0x00,0x22,
	0xf3,0x03,0x00,0xbb,0xe0,0x08,0x00,0x8f,0x80,0x4f,0x90,0x2f,0x00,0xfb,0xff,0x05,
	0x00,0x30,0x14,0x00,0xf3,0xff,0xaf,0x00,0xf3,0x36,0xf7,0x0c,0xf3,0x03,0x60,0x3f,
	0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,0x7f,
	0xf3,0x03,0x00,0x7f,0xf3,0x03,0x60,0x2f,0xf3,0x36,0xf7,0x0c,0xf3,0xff,0x9f,0x00,
	0xf3,0xff,0xff,0x0f,0xf3,0x79,0x77,0x07,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,
	0xf3,0x79,0x77,0x03,0xf3,0xff,0xff,0x07,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,
	0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0xff,0xff,0x3f,0x30,0x33,0x33,0x03,
	0xf3,0xff,0xff,0x0b,0xf3,0x79,0x77,0x05,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,
	0xf3,0x79,0x37,0x00,0xf3,0xff,0x7f,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,
	0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0x30,0x00,0x00,0x00,
	0x00,0xd4,0xdf,0x05,0x00,0x40,0xbf,0xa7,0x4f,0x00,0xd0,0x0b,0x00,0xcd,0x00,0xf2,
	0x05,0x00,0xf7,0x00,0xf3,0x03,0x00,0x00,0x00,0xf7,0x03,0xfb,0xff,0x03,0xf4,0x03,
	0x32,0xf6,0x03,0xf3,0x04,0x00,0xf3,0x03,0xe0,0x09,0x00,0xf7,0x03,0x70,0x7f,0x50,
	0xfe,0x03,0x00,0xf9,0xff,0xf8,0x03,0x00,0x20,0x13,0x30,0x00,0xf3,0x03,0x00,0x7f,
	0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,0x7f,0xf3,0x79,0x77,0x7f,
	0xf3,0xbc,0xbb,0x7f,0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,0x7f,
	0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,0x7f,0x30,0x00,0x00,0x13,0xf3,0x03,0xf3,0x03,
	0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,
	0xf3,0x03,0x30,0x00,0x00,0x00,0xf3,0x00,0x00,0xf3,0x00,0x00,0xf3,0x00,0x00,0xf3,
	0x00,0x00,0xf3,0x00,0x00,0xf3,0x31,0x00,0xf3,0xf7,0x00,0xf3,0xf5,0x00,0xf5,0xf2,
	0x39,0xdc,0x90,0xff,0x5f,0x00,0x42,0x01,0xf3,0x03,0x20,0x9e,0xf3,0x03,0xe0,0x0b,
	0xf3,0x03,0xcc,0x00,0xf3,0xa3,0x2e,0x00,0xf3,0xfc,0x08,0x00,0xf3,0xbf,0x0e,0x00,
	0xf3,0x06,0x9e,0x00,0xf3,0x03,0xf7,0x02,0xf3,0x03,0xd0,0x0b,0xf3,0x03,0x50,0x4f,
	0xf3,0x03,0x00,0xdd,0x30,0x00,0x00,0x31,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,
	0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,
	0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,
	0xf3,0xff,0xff,0x0b,0x30,0x33,0x33,0x02,0xfb,0x05,0x00,0xf5,0x0b,0xfb,0x09,0x00,
	0xf9,0x0b,0xfb,0x0d,0x00,0xfd,0x0b,0xeb,0x1f,0x10,0xef,0x0b,0xbb,0x5e,0x60,0xbe,
	0x0b,0xbb,0xaa,0xa0,0xba,0x0b,0xbb,0xe6,0xe0,0xb6,0x0b,0xbb,0xf2,0xf5,0xb2,0x0b,
	0xbb,0xe0,0xdd,0xb0,0x0b,0xbb,0xa0,0x9f,0xb0,0x0b,0xbb,0x50,0x5f,0xb0,0x0b,0x22,
	0x00,0x03,0x20,0x02,0xf3,0x07,0x00,0x7f,0xf3,0x0d,0x00,0x7f,0xf3,0x5f,0x00,0x7f,
	0xf3,0xdd,0x00,0x7f,0xf3,0xf5,0x05,0x7f,0xf3,0x93,0x0c,0x7f,0xf3,0x33,0x3f,0x7f,
	0xf3,0x03,0xbb,0x7f,0xf3,0x03,0xf3,0x7f,0xf3,0x03,0xb0,0x7f,0xf3,0x03,0x50,0x7f,
	0x30,0x00,0x00,0x13,0x00,0x00,0x03,0x00,0x00,0x00,0xf8,0xff,0x08,0x00,0x70,0x7f,
	0x73,0x7f,0x00,0xe0,0x0a,0x00,0xeb,0x00,0xf2,0x05,0x00,0xf5,0x02,0xf3,0x03,0x00,
	0xf3,0x03,0xf3,0x03,0x00,0xf3,0x03,0xf3,0x03,0x00,0xf3,0x03,0xf2,0x05,0x00,0xf5,
	0x02,0xe0,0x0b,0x00,0xeb,0x00,0x70,0x7f,0x83,0x7f,0x00,0x00,0xf8,0xff,0x07,0x00,
	0x00,0x00,0x03,0x00,0x00,0xf3,0xff,0xaf,0x02,0xf3,0x79,0xe7,0x0d,0xf3,0x03,0x60,
	0x2f,0xf3,0x03,0x30,0x3f,0xf3,0x03,0xa0,0x0f,0xf3,0xbc,0xfc,0x08,0xf3,0x79,0x57,
	0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,
	0x00,0x30,0x00,0x00,0x00,0x00,0xe5,0xdf,0x05,0x00,0x40,0xaf,0xb7,0x3f,0x00,0xd0,
	0x0b,0x00,0xcc,0x00,0xf2,0x05,0x00,0xf7,0x00,0xf3,0x03,0x00,0xf3,0x03,0xf7,0x03,
	0x00,0xf3,0x03,0xf4,0x03,0x00,0xf3,0x03,0xf3,0x03,0xc5,0xf5,0x01,0xf0,0x08,0xe2,
	0xef,0x00,0x80,0x6f,0x80,0xbf,0x00,0x00,0xfb,0xff,0xfb,0x00,0x00,0x20,0x23,0x30,
	0x00,0xf3,0xff,0xcf,0x04,0xf3,0x79,0xb7,0x3f,0xf3,0x03,0x00,0x7f,0xf3,0x03,0x00,
	0x7f,0xf3,0x03,0x50,0x6f,0xf3,0xff,0xff,0x0c,0xf3,0x79,0xdc,0x00,0xf3,0x03,0xf3,
	0x03,0xf3,0x03,0xb0,0x0b,0xf3,0x03,0x30,0x3f,0xf3,0x03,0x00,0xdb,0x30,0x00,0x00,
	0x31,0x00,0xfa,0x8f,0x00,0xc0,0x7e,0xf9,0x07,0xf3,0x04,0x90,0x0d,0xf2,0x0a,0x50,
	0x0b,0x90,0xbf,0x03,0x00,0x00,0xd5,0x9f,0x00,0x00,0x00,0xf7,0x08,0xf6,0x03,0x80,
	0x0f,0xf3,0x04,0x50,0x3f,0xe0,0x3c,0xc3,0x0e,0x30,0xfe,0xef,0x02,0x00,0x30,0x03,
	0x00,0xf3,0xff,0xff,0x0f,0x71,0xd7,0x7d,0x07,0x00,0xb0,0x0b,0x00,0x00,0xb0,0x0b,
	0x00,0x00,0xb0,0x0b,0x00,0x00,0xb0,0x0b,0x00,0x00,0xb0,0x0b,0x00,0x00,0xb0,0x0b,
	0x00,0x00,0xb0,0x0b,0x00,0x00,0xb0,0x0b,0x00,0x00,0xb0,0x0b,0x00,0x00,0x20,0x02,
	0x00,0xbb,0x00,0x70,0x0b,0xbb,0x00,0x70,0x0b,0xbb,0x00,0x70,0x0b,0xbb,0x00,0x70,
	0x0b,0xbb,0x00,0x70,0x0b,0xbb,0x00,0x70,0x0b,0xbb,0x00,0x70,0x0b,0xbb,0x00,0x70,
	0x0b,0xbb,0x00,0xa0,0x0b,0xf8,0x36,0xf5,0x09,0xc0,0xff,0xcf,0x00,0x00,0x32,0x03,
	0x00,0x7f,0x00,0x60,0x0f,0xbc,0x00,0xa0,0x0c,0xe7,0x00,0xe0,0x08,0xf3,0x02,0xf2,
	0x03,0xf0,0x06,0xf6,0x00,0xb0,0x0a,0xba,0x00,0x70,0x0e,0x7e,0x00,0x30,0x3f,0x3f,
	0x00,0x00,0xbe,0x0f,0x00,0x00,0xfa,0x0a,0x00,0x00,0xf6,0x06,0x00,0x00,0x30,0x00,
	0x00,0x6f,0x00,0xee,0x00,0xf7,0xac,0x00,0xff,0x00,0xca,0xd9,0x30,0xff,0x03,0x9d,
	0xf5,0x41,0xff,0x14,0x5f,0xf1,0x74,0xef,0x47,0x1f,0xe0,0x98,0xbb,0x7a,0x0e,0xa0,
	0xbb,0x9a,0xbb,0x0a,0x70,0xef,0x77,0xff,0x06,0x30,0xff,0x44,0xff,0x03,0x00,0xff,
	0x33,0xff,0x00,0x00,0xfb,0x00,0xbf,0x00,0x00,0x32,0x00,0x13,0x00,0xdb,0x00,0xe0,
	0x0a,0xf3,0x05,0xf5,0x03,0xb0,0x0d,0xbd,0x00,0x30,0xbf,0x3f,0x00,0x00,0xfb,0x0b,
	0x00,0x00,0xf8,0x08,0x00,0x00,0xfe,0x0e,0x00,0x70,0x3f,0x7f,0x00,0xe0,0x09,0xe9,
	0x00,0xf7,0x01,0xf1,0x07,0x9e,0x00,0x90,0x0e,0x03,0x00,0x00,0x03,0x9d,0x00,0x90,
	0x0e,0xf5,0x01,0xf1,0x07,0xd0,0x09,0xe8,0x00,0x60,0x1f,0x7e,0x00,0x00,0xde,0x0e,
	0x00,0x00,0xf7,0x07,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,
	0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0x30,0x00,0x00,0xb0,0xff,0xff,
	0x0f,0x50,0x77,0xd7,0x0e,0x00,0x00,0xf1,0x07,0x00,0x00,0xd9,0x00,0x00,0x30,0x5f,
	0x00,0x00,0xb0,0x0d,0x00,0x00,0xf3,0x03,0x00,0x00,0xbc,0x00,0x00,0x50,0x3f,0x00,
	0x00,0xd0,0x0a,0x00,0x00,0xf3,0xff,0xff,0x3f,0x30,0x33,0x33,0x03,0xf3,0xff,0x07,
	0xf3,0x79,0x03,0xf3,0x03,0x00,0xf3,0x03,0x00,0xf3,0x03,0x00,0xf3,0x03,0x00,0xf3,
	0x03,0x00,0xf3,0x03,0x00,0xf3,0x03,0x00,0xf3,0x03,0x00,0xf3,0x03,0x00,0xf3,0x03,
	0x00,0xf3,0xbc,0x05,0xb2,0xbb,0x05,0x00,0x00,0x00,0x70,0x00,0x00,0x03,0xe0,0x00,
	0x00,0x0b,0x70,0x00,0x00,0x2f,0x00,0x00,0x00,0x99,0x00,0x00,0x01,0xf1,0x00,0x00,
	0x09,0x90,0x00,0x00,0x0e,0x30,0x00,0x00,0x7b,0x00,0x00,0x00,0xe3,0x00,0x00,0x05,
	0xc0,0x00,0x00,0x0d,0x50,0x00,0x00,0x5d,0x00,0x00,0x00,0x34,0x00,0x00,0x00,0xfb,
	0xff,0x75,0xfb,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,
	0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0xb8,0xfd,0xb8,0xbb,0x00,0x90,0x00,0x00,0x00,
	0xfc,0x0c,0x00,0xc0,0x1c,0xcc,0x00,0xc9,0x00,0xc0,0x09,0x01,0x00,0x10,0x00,0xbb,
	0xbb,0x05,0xf5,0x06,0x20,0x2e,0x00,0xc2,0x20,0xfc,0x0a,0xe0,0x7e,0xae,0xf3,0x05,
	0xe7,0x00,0xc7,0xff,0xc0,0x8e,0xfb,0xf4,0x04,0xf7,0xf4,0x16,0xfc,0xc0,0xff,0xfc,
	0x00,0x23,0x30,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,
	0xe9,0x5e,0x00,0xf3,0x7e,0xec,0x00,0xf3,0x05,0xf4,0x03,0xf3,0x03,0xf3,0x03,0xf3,
	0x03,0xf3,0x03,0xf3,0x04,0xf3,0x03,0xf3,0x1b,0xfa,0x00,0xf3,0xfc,0x8f,0x00,0x30,
	0x30,0x02,0x00,0x10,0xfb,0x09,0xc0,0x8e,0x7f,0xf2,0x04,0xbb,0xf4,0x03,0x22,0xf6,
	0x03,0x32,0xf3,0x03,0xbb,0xe0,0x2a,0x9e,0x50,0xff,0x2e,0x00,0x32,0x01,0x00,0x00,
	0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x40,0xdd,0xf6,0x03,0xe0,0x7c,
	0xfe,0x03,0xf3,0x04,0xf6,0x03,0xf5,0x03,0xf3,0x03,0xf6,0x03,0xf3,0x03,0xf3,0x03,
	0xf5,0x03,0xf1,0x09,0xfc,0x03,0x90,0xff,0xfc,0x03,0x00,0x23,0x30,0x00,0x20,0xeb,
	0x08,0xc0,0x8c,0x5f,0xf2,0x04,0xb9,0xf5,0xbc,0xbd,0xf6,0x79,0x57,0xf3,0x03,0x55,
	0xe0,0x1a,0x9e,0x50,0xff,0x1e,0x00,0x31,0x00,0x10,0xfe,0x70,0x7f,0x70,0x0f,0xf3,
	0xff,0xb1,0x7f,0x70,0x0f,0x70,0x0f,0x70,0x0f,0x70,0x0f,0x70,0x0f,0x70,0x0f,0x10,
	0x03,0x20,0xfb,0xb8,0x0b,0xb0,0x7c,0x9f,0x02,0xf0,0x07,0xab,0x00,0xb0,0x5c,0x6f,
	0x00,0xc0,0xfc,0x0b,0x00,0xe3,0x03,0x00,0x00,0xd0,0xff,0xae,0x00,0xf4,0x31,0xf4,
	0x06,0xf3,0x79,0xf8,0x05,0x70,0xfc,0x7c,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0x00,
	0x00,0xf3,0x03,0x00,0x00,0xf3,0xd6,0x2d,0x00,0xf3,0x8e,0xec,0x00,0xf3,0x07,0xf4,
	0x02,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,
	0x03,0xf3,0x03,0xf3,0x03,0x30,0x00,0x30,0x00,0xf3,0x03,0xf3,0x03,0x00,0x00,0xf3,
	0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0x30,
	0x00,0x30,0x3f,0x30,0x3f,0x00,0x03,0x30,0x3f,0x30,0x3f,0x30,0x3f,0x30,0x3f,0x30,
	0x3f,0x30,0x3f,0x30,0x3f,0x30,0x3f,0x71,0x1f,0xb5,0x0a,0xf3,0x03,0x00,0x00,0xf3,
	0x03,0x00,0x00,0xf3,0x03,0x00,0x00,0xf3,0x03,0xf6,0x05,0xf3,0x43,0x5f,0x00,0xf3,
	0xe6,0x09,0x00,0xf3,0xff,0x00,0x00,0xf3,0xec,0x08,0x00,0xf3,0x73,0x2f,0x00,0xf3,
	0x03,0xbe,0x00,0xf3,0x03,0xf5,0x04,0x30,0x00,0x30,0x02,0xf3,0x03,0xf3,0x03,0xf3,
	0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,
	0x03,0x30,0x00,0xf3,0xd7,0x2c,0xd5,0x2d,0xf3,0x7e,0xdc,0x7e,0xde,0xf3,0x05,0xf5,
	0x03,0xf7,0xf3,0x03,0xf3,0x00,0xf7,0xf3,0x03,0xf3,0x00,0xf7,0xf3,0x03,0xf3,0x00,
	0xf7,0xf3,0x03,0xf3,0x00,0xf7,0xf3,0x03,0xf3,0x00,0xf7,0x30,0x00,0x30,0x00,0x31,
	0xf3,0xd6,0x5d,0x00,0xf3,0x9e,0xed,0x00,0xf3,0x05,0xf4,0x03,0xf3,0x03,0xf3,0x03,
	0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,
	0x30,0x00,0x30,0x00,0x00,0xfb,0x0b,0x00,0x80,0x9f,0x8f,0x00,0xf1,0x07,0xf7,0x01,
	0xf5,0x03,0xf3,0x05,0xf5,0x03,0xf3,0x05,0xf1,0x07,0xf7,0x01,0x90,0xbf,0x9f,0x00,
	0x00,0xfb,0x0b,0x00,0xf3,0xd9,0x2d,0x00,0xf3,0x8e,0xde,0x00,0xf3,0x05,0xf5,0x03,
	0xf3,0x03,0xf3,0x05,0xf3,0x03,0xf3,0x07,0xf3,0x04,0xf3,0x03,0xf3,0x3c,0xfa,0x00,
	0xf3,0xfc,0x5f,0x00,0xf3,0x23,0x02,0x00,0xf3,0x03,0x00,0x00,0x20,0xed,0xf9,0x03,
	0xd0,0x8e,0xfe,0x03,0xf3,0x05,0xf5,0x03,0xf5,0x03,0xf3,0x03,0xf6,0x03,0xf3,0x03,
	0xf3,0x04,0xf4,0x03,0xe0,0x3b,0xfc,0x03,0x50,0xff,0xfc,0x03,0x00,0x22,0xf3,0x03,
	0x00,0x00,0xf3,0x03,0xf3,0xd8,0x07,0xf3,0x7e,0x03,0xf3,0x04,0x00,0xf3,0x03,0x00,
	0xf3,0x03,0x00,0xf3,0x03,0x00,0xf3,0x03,0x00,0xf3,0x03,0x00,0x30,0x00,0x00,0x40,
	0xfc,0x09,0xe0,0x8c,0x7f,0xf3,0x04,0x98,0xe0,0x7e,0x01,0x10,0xd8,0x7f,0xb3,0x02,
	0xf9,0xf2,0x09,0xfa,0x90,0xff,0x6f,0x00,0x32,0x02,0x00,0x03,0x00,0x30,0x3f,0x00,
	0x30,0x3f,0x00,0xc2,0xcf,0x02,0x91,0x9f,0x01,0x30,0x3f,0x00,0x30,0x3f,0x00,0x30,
	0x3f,0x00,0x30,0x3f,0x00,0x30,0x3f,0x00,0x20,0xff,0x03,0x00,0x32,0x00,0xf3,0x03,
	0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,
	0xf3,0x03,0xf3,0x03,0xf4,0x03,0xf0,0x3b,0xfc,0x03,0x90,0xff,0xfc,0x03,0x00,0x22,
	0x30,0x00,0xf4,0x01,0xf1,0x04,0xf0,0x05,0xf5,0x00,0xb0,0x09,0xb9,0x00,0x70,0x0d,
	0x7d,0x00,0x20,0x3f,0x2f,0x00,0x00,0xbe,0x0e,0x00,0x00,0xfa,0x0a,0x00,0x00,0xf5,
	0x06,0x00,0x00,0x30,0x00,0x00,0x4f,0xc0,0x0d,0xf4,0x01,0x7d,0xf0,0x0f,0xd7,0x00,
	0xba,0xf3,0x3f,0xaa,0x00,0xe6,0xe5,0x5c,0x7d,0x00,0xf3,0xb9,0x9a,0x3f,0x00,0xf0,
	0x7f,0xf7,0x0f,0x00,0xb0,0x4f,0xf3,0x0c,0x00,0x80,0x1f,0xf1,0x08,0x00,0x10,0x03,
	0x30,0x01,0x00,0xf1,0x07,0xf7,0x00,0x90,0x1e,0x9e,0x00,0x10,0xcf,0x1f,0x00,0x00,
	0xf9,0x09,0x00,0x00,0xf9,0x09,0x00,0x10,0xdf,0x1f,0x00,0x90,0x1e,0x9e,0x00,0xf1,
	0x07,0xf7,0x01,0x31,0x00,0x30,0x01,0x5f,0x00,0x5f,0x9c,0x40,0x0f,0xd7,0x90,0x0c,
	0xf3,0xd2,0x08,0xe0,0xf8,0x04,0xa0,0xff,0x00,0x50,0xbf,0x00,0x10,0x6f,0x00,0x85,
	0x2f,0x00,0xfb,0x08,0x00,0xb0,0xff,0xbf,0x50,0x87,0x7f,0x00,0x80,0x0d,0x00,0xf1,
	0x05,0x00,0xbb,0x00,0x30,0x3f,0x00,0xd0,0x09,0x00,0xf3,0xff,0xbf,0x30,0x33,0x23,
	0x50,0x5b,0xe0,0x1a,0xf0,0x07,0xf0,0x07,0xf0,0x07,0xf0,0x07,0xf8,0x04,0xf5,0x06,
	0xf0,0x07,0xf0,0x07,0xf0,0x07,0xf0,0x07,0xe0,0x1a,0x40,0x5b,0xf3,0x03,0xf3,0x03,
	0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,
	0xf3,0x03,0xf3,0x03,0xf3,0x03,0xf3,0x03,0xa8,0x01,0xd2,0x0a,0xb0,0x0b,0xb0,0x0b,
	0xb0,0x0b,0xb0,0x0b,0x90,0x5e,0xa0,0x3d,0xb0,0x0b,0xb0,0x0b,0xb0,0x0b,0xb0,0x0b,
	0xd2,0x09,0xa8,0x00,0xa2,0x2a,0x70,0xa8,0xfa,0xbf,0x01,0x30,0x05,0x71,0x37,0xf3,
	0x7f,0xf3,0x7f,0x30,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

static const int ALIGN_DATA ascii_14p_pos[NUM_FONTS] = {
	0x000000,0x000000,0x000018,0x000021,0x000059,0x000091,0x0000c1,0x0000fd,0x000105,0x00012c,0x000148,0x00016c,0x00018c,0x000194,0x00019a,0x0001a0,
	0x0001d8,0x00020c,0x000224,0x000254,0x000284,0x0002b4,0x0002e4,0x000314,0x000338,0x000368,0x000398,0x0003a8,0x0003bc,0x0003d7,0x0003ef,0x00040a,
	0x00043e,0x000484,0x0004b4,0x0004e4,0x000514,0x000540,0x000570,0x0005a0,0x0005dc,0x00060c,0x000624,0x000648,0x000678,0x0006a8,0x0006e4,0x000714,
	0x000755,0x000785,0x0007c1,0x0007f1,0x000821,0x000851,0x000881,0x0008b1,0x0008ed,0x00091d,0x00094d,0x00097d,0x0009a7,0x0009df,0x0009fb,0x000a0f,
	0x000a12,0x000a18,0x000a33,0x000a63,0x000a7e,0x000aae,0x000ac9,0x000ae1,0x000b09,0x000b39,0x000b51,0x000b6b,0x000b9b,0x000bb3,0x000be0,0x000c04,
	0x000c24,0x000c4c,0x000c74,0x000c8f,0x000caa,0x000cce,0x000cf2,0x000d16,0x000d43,0x000d67,0x000d85,0x000da0,0x000dbc,0x000dd8,0x000df4,0x000dfd
};

static const INT8 ALIGN_DATA ascii_14p_width[NUM_FONTS] = {
	 0, 4, 6, 8, 8, 8,10, 4, 6, 4, 8, 8, 4, 6, 4, 8,
	 8, 4, 8, 8, 8, 8, 8, 6, 8, 8, 4, 4, 6, 8, 6, 8,
	10, 8, 8, 8, 8, 8, 8,10, 8, 4, 6, 8, 8,10, 8,10,
	 8,10, 8, 8, 8, 8, 8,10, 8, 8, 8, 6, 8, 4, 8, 6,
	 4, 6, 8, 6, 8, 6, 4, 8, 8, 4, 4, 8, 4,10, 8, 8,
	 8, 8, 6, 6, 6, 8, 8,10, 8, 6, 6, 4, 4, 4, 6, 4
};

static const INT8 ALIGN_DATA ascii_14p_height[NUM_FONTS] = {
	 0,12, 3,14,14,12,12, 4,13,14, 9, 8, 4, 2, 3,14,
	13,12,12,12,12,12,12,12,12,12, 8,10, 9, 6, 9,13,
	14,12,12,12,11,12,12,12,12,12,12,12,12,12,12,13,
	12,12,12,12,12,12,12,12,12,12,12,14,14,14, 5, 1,
	 3, 9,12, 9,12, 9,12,10,12,12,13,12,12, 9, 9, 8,
	10,10, 9, 9,12, 9, 9, 9, 9,10, 9,14,14,14, 3, 4
};

static const INT8 ALIGN_DATA ascii_14p_skipx[NUM_FONTS] = {
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0,
	 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1
};

static const INT8 ALIGN_DATA ascii_14p_skipy[NUM_FONTS] = {
	 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 2, 3,10, 6,10, 0,
	 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 2, 4, 2, 0,
	 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,13,
	 0, 4, 1, 4, 1, 4, 1, 4, 1, 1, 1, 1, 1, 4, 4, 4,
	 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 5
};

static const INT8 ALIGN_DATA ascii_14p_pitch[NUM_FONTS] = {
	 5, 4, 6, 8, 8, 8,10, 3, 5, 5, 8, 8, 3, 5, 3, 8,
	 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 8, 8, 8, 8,
	11,10, 9, 8, 8, 8, 8, 9, 8, 3, 7, 9, 8,10, 8, 9,
	 8, 9, 9, 8, 8, 8, 9,12, 9, 9, 8, 6, 8, 6, 7, 5,
	 5, 7, 7, 7, 7, 6, 5, 7, 7, 3, 4, 8, 3,11, 7, 7,
	 7, 7, 5, 7, 5, 7, 7,10, 8, 7, 7, 4, 3, 4, 6, 6
};


/*------------------------------------------------------
	functions
------------------------------------------------------*/

int ascii_14p_get_gryph(struct font_t *font, UINT16 code)
{
	if (code < NUM_FONTS)
	{
		font->data   = &ascii_14p[ascii_14p_pos[code]];
		font->width  = ascii_14p_width[code];
		font->height = ascii_14p_height[code];
		font->pitch  = ascii_14p_pitch[code];
		font->skipx  = ascii_14p_skipx[code];
		font->skipy  = ascii_14p_skipy[code];
		return 1;
	}
	return 0;
}

int ascii_14p_get_pitch(UINT16 code)
{
	if (code < NUM_FONTS)
		return ascii_14p_pitch[code];

	return ascii_14p_pitch[0];
}
