/******************************************************************************

	ui_text.c

	`󥿥ե`ƥȹ

******************************************************************************/

#include "psp.h"
#include <psputility_sysparam.h>


const char *ui_text[UI_TEXT_MAX];

static const char *text_ENGLISH[UI_TEXT_MAX] =
{
		"\0",
		"\n",

		/* psp/filer.c */
		"Please wait...",
		"Could not open zipname.%s",
#ifdef ADHOC
		"Please turn on the WLAN switch.",
		"Failed to load AdHoc modules.",
#endif

		/* psp/sound.c */
		"Could not reserve audio channel for sound.",
		"Could not start sound thread.",

		/* psp/ui.c */
		"Warning: Battery is low (%d%%). Please charge battery!",

		FONT_CIRCLE " to launch, " FONT_CROSS " to cancel",
		FONT_CIRCLE " to confirm, " FONT_CROSS " to cancel",
#ifdef SAVE_STATE
		FONT_CIRCLE " return to game, " FONT_CROSS " return to menu",
#endif
		"Press any button.",
		"Start emulation.",
#ifdef ADHOC
		"Start emulation. (AdHoc)",
#endif
		"Exit emulation.",
		"Reset emulation.",
		"Need to restart emulation.",
#if (EMU_SYSTEM != NCDZ)
		"THIS GAME DOESN'T WORK.",
		"You won't be able to make it work correctly.",
		"Don't bother.",
#endif
		"Do you make this directory the startup directory?",
#ifdef PSP_SLIM
		"This program requires PSP-2000 + FW 3.71 M33 or later.",
#endif
#ifdef SAVE_STATE
		"Start save state.",
		"Start load state.",
#endif
#if defined(SAVE_STATE) || defined(COMMAND_LIST)
		"Complete.",
#endif
#ifdef SAVE_STATE
		"Delete state file.",
#endif
#if (EMU_SYSTEM == NCDZ)
		"MP3 files not found. CDDA cannot play.",
		"IPL.TXT not found.",
		"Boot NEOGEO CDZ BIOS.",
		"NEOGEO CDZ BIOS (neocd.bin) not found.",
		"Invalid NEOGEO CDZ BIOS found.",
		"Cannot launch game.",
#endif

		"Help - %s",
		"Not use",
		"Press any button to return to menu.",
		"File browser",
		"Scroll",
		"Scroll 1 page",
		"Launch game",
		"Launch game (AdHoc)",
		"Exit emulator",
		"Show BIOS select menu",
		"Open color settings menu",
		"Show this help",
		"Boot BIOS",
		"Set selected directory as startup",
		"Change value",
		"Select",
		"Select slot",
		"Change function",
		"Execute function",
		"Select item",
		"Select item / Change value",
		"RGB value +5",
		"Return to file browser",
		"RGB value -5",
		"Restore all values to default",
		"Scroll / Select item",
		"Open / Close item menu",
		"Return to main menu / game",

		/* psp/ui_menu.c */
		"On",
		"Off",
		"Yes",
		"No",
		"Enable",
		"Disable",
		"Return to main menu",

		"Game configuration menu",
		"Raster Effects",
		"Stretch Screen",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"360x270 (4:3)",
		"384x270 (24:17)",
		"466x272 (12:7)",
		"480x270 (16:9)",
		"Rotate Screen",
#else
		"320x224 (4:3)",
		"360x270 (4:3)",
		"366x270 (19:14)",
		"420x270 (14:9)",
		"480x270 (16:9)",
#endif
		"Video Sync",
		"Auto Frameskip",
		"Frameskip",
		"level 1",
		"level 2",
		"level 3",
		"level 4",
		"level 5",
		"level 6",
		"level 7",
		"level 8",
		"level 9",
		"level 10",
		"level 11",
		"Show FPS",
		"60fps Limit",
		"Enable Sound",
		"Sample Rate",
		"11025Hz",
		"22050Hz",
		"44100Hz",
		"Sound Volume",
		"0%",
		"10%",
		"20%",
		"30%",
		"40%",
		"50%",
		"60%",
		"70%",
		"80%",
		"90%",
		"100%",
		"Controller",
		"Player 1",
		"Player 2",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"Player 3",
		"Player 4",
#endif
		"PSP clock",
		"222MHz",
		"266MHz",
		"300MHz",
		"333MHz",
#if (EMU_SYSTEM == MVS)
		"Default",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Machine Region",
		"Japan",
		"USA",
		"Europe",
#endif
#if (EMU_SYSTEM == MVS)
		"Machine Mode",
		"Console (AES)",
		"Arcade (MVS)",
#endif
#if (EMU_SYSTEM == NCDZ)
		"Emulate Load Screen",
		"CD-ROM Speed Limit",
		"Enable CDDA",
		"CDDA Volume",
#endif

		"Key configuration menu",
		"Not use",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
		FONT_CIRCLE,
		FONT_CROSS,
		FONT_SQUARE,
		FONT_TRIANGLE,
		"L TRIGGER",
		"R TRIGGER",
		"START",
		"SELECT",
		"Low",
		"Normal",
		"High",
#if (EMU_SYSTEM == CPS2)
		"Player1 Start",
		"Player2 Start",
#endif
		"%d frame",
		"%d frames",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Button A",
		"Button B",
		"Button C",
		"Button D",
#else
		"Button 1",
		"Button 2",
		"Button 3",
		"Button 4",
		"Button 5",
		"Button 6",
#endif
		"Start",
#if (EMU_SYSTEM == NCDZ)
		"Select",
#else
		"Coin",
		"Service Coin",
#endif
#if (EMU_SYSTEM == MVS)
		"Test Switch",
#elif (EMU_SYSTEM != NCDZ)
		"Service Switch",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Autofire A",
		"Autofire B",
		"Autofire C",
		"Autofire D",
#else
		"Autofire 1",
		"Autofire 2",
		"Autofire 3",
		"Autofire 4",
		"Autofire 5",
		"Autofire 6",
#endif
		"Autofire Interval",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Hotkey A+B",
		"Hotkey A+C",
		"Hotkey A+D",
		"Hotkey B+C",
		"Hotkey B+D",
		"Hotkey C+D",
		"Hotkey A+B+C",
		"Hotkey A+B+D",
		"Hotkey A+C+D",
		"Hotkey B+C+D",
		"Hotkey A+B+C+D",
#else
		"Hotkey 1+2",
		"Hotkey 1+3",
		"Hotkey 1+4",
		"Hotkey 2+3",
		"Hotkey 2+4",
		"Hotkey 3+4",
		"Hotkey 1+2+3",
		"Hotkey 1+2+4",
		"Hotkey 1+3+4",
		"Hotkey 2+3+4",
		"Hotkey 1+2+3+4",
		"Hotkey 4+5+6",
#endif
#if (EMU_SYSTEM != NCDZ)
		"Analog Sensitivity",
#endif
#if (EMU_SYSTEM == CPS1)
		"Dial (Left)",
		"Dial (Right)",
		"Pause",
#endif
#if (EMU_SYSTEM == CPS2)
		"Paddle (Left)",
		"Paddle (Right)",
#endif
#if (EMU_SYSTEM == MVS)
		"Big",
		"Small",
		"Double Up",
		"Start/Collect",
		"Payout",
		"Cancel",
		"Bet",
		"Bet/Cancel All",
		"Operator Menu",
		"Clear Credit",
		"Hopper Out",
#endif
		"Save Screenshot",
		"Switch Player",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Button Layout",
		"Type 1 (NEOGEO PAD)",
		"Type 2 (MVS)",
		"Type 3 (PlayStation)",
		"User Define",
#endif

		"DIP switch settings menu",
		"This game has no DIP switches.",

		"Save/Load State",
		"Slot %d:",
		"Empty",
		"Load",
		"Delete",
		"Save",
		"Play Date",
		"Save Time",
		"Version",
		"Faild to delete file \"%s\".",

		"Main menu",
		"Game configuration",
		"Change game settings.",
		"Key configuration",
		"Change buttons and autofire/hotkey settings.",
#if (EMU_SYSTEM != NCDZ)
		"DIP switch settings",
		"Change hardware DIP switch settings.",
#endif
		"Reset emulation",
		"Reset " SYSTEM_NAME " emulation.",
		"Return to file browser",
		"Stop emulation and return to file browser.",
		"Return to game",
		"Return to game emulation.",
		"Exit emulator",
		"Exit emulation and return to PSP menu.",
#ifdef COMMAND_LIST
		"Show command list",
		"Show command list. (MAME Plus! format \"command.dat\")",
#endif

#if PSP_VIDEO_32BPP
		"Color settings menu",
		"Background image type",
		"Background image blightness",
		"Title bar text",
		"Selected text",
		"Normal text",
		"Information message text",
		"Warning message text",
		"File select bar (start)",
		"File select bar (end)",
		"Title bar/Message box",
		"Title bar/ Message box frame",
		"Background",
		"Red",
		"Green",
		"Blue",
		"Default image",
		"User's image",
		"logo.png only",
		"File select bar",
#endif

		"Command list",

		/* psp/mp3.c */
#if (EMU_SYSTEM == NCDZ)
		"Counld not reopen mp3 file \"%s\".",
		"MP3 decode error.",
		"Could not reserve audio channel for MP3.",
		"Could not start MP3 thread.",
#endif

		/* psp/adhoc.c*/
#ifdef ADHOC
		"lobby",
		"server",
		"crient",
		"Waiting for another PSP to join.\n",
		"Connecting to the %s.",
		"Connected.",
		"Disconnecting from the %s.",
		"Disconnected.",
		"failed.",
		"Select a server to connect to, or " FONT_TRIANGLE " to return.\n",
		"Waiting for %s to accept the connection.\n",
		"To cancel press " FONT_CROSS ".\n",
		"%s has requested a connection.\n",
		"To accept the connection press " FONT_CIRCLE ", to cancel press " FONT_CROSS ".\n",
		"Wainting for synchronization.",
#endif

		/* psp/png.c */
		"Could not allocate memory for PNG.",
		"Could not enecode PNG image.",
#if PSP_VIDEO_32BPP || (EMU_SYSTEM == NCDZ)
		"Could not decode PNG image.",
#endif
		"%d bit color PNG image not supported.",

		/* emumain.c */
		"Fatal error",
		"Snapshot saved as \"%s_%02d.png\".",

#if USE_CACHE
		/* common/cache.c */
		"Could not open cache file.\n",
		"Memory not enough.\n",
		"Could not allocate cache memory.\n",
		"%dKB cache allocated.\n",
		"Cache load error!!!\n",
		"Loading cache information data...\n",
		"Unsupported version of cache file \"V%c%c\".\n",
		"Current required version is \"" CACHE_VERSION "\".\n",
		"Please rebuild cache file.\n",
#if (EMU_SYSTEM == CPS2)
		"Could not open sprite block %03x\n",
#elif (EMU_SYSTEM == MVS)
		"PCM cache enabled.\n",
#endif
#endif

		/* common/loadrom.c */
		"Press any button.\n",
		"Could not allocate %s memory.\n",
		"CRC32 not correct. \"%s\"\n",
		"File not found. \"%s\"\n",

#ifdef SAVE_STATE
		/* common/state.c */
		"Could not allocate state buffer.",
		"Could not create file \"%s.sv%d\"",
		"Could not open file \"%s.sv%d\"",
		"Saving \"%s.sv%d\"",
		"Loading \"%s.sv%d\"",
#if (EMU_SYSTEM == MVS)
		"Could not reload BIOS. Press any button to exit.",
#elif (EMU_SYSTEM == NCDZ)
		"Could not compress state data.",
		"Could not uncompress state data.",
#endif
#endif

#ifdef COMMAND_LIST
		/* common/cmdlist.c */
		"Command list for this game not found.",
		"Command list - %s",
		"%d/%d items",
		"COMMAND.DAT size reduction",
		"This processing removes the command list of the games not being\n",
		"supported by this emulator from COMMAND.DAT.\n",
		"If you want to reduce the size of command.dat, press " FONT_CIRCLE " button.\n",
		"Otherwise, press " FONT_CROSS " button to return to file browser.\n",
		"Checking COMMAND.DAT format...\n",
		"ERROR: Unknown format.\n",
		"ERROR: Empty file.\n",
		"ERROR: Could not allocate memory.\n",
		"ERROR: Could not rename file.\n",
		"ERROR: Could create output file.\n",
		"Copying \"%s\"...\n",
		"Original size:%dbytes, Result:%dbytes (-%.1f%%)\n",
#endif

		/* emulation core */
		"Done.\n",
		"Exit emulation",
		"Please wait.\n",

		/* inptport.c */
		"Controller: Player 1",
		"Controller: Player %d",
#ifdef ADHOC
		"Lost sync.\n",
		"Paused by %s",
		"Return to Game",
		"Disconnect",
#endif

		/* memintrf.c */
		"Loading \"%s\"\n",
		"Load ROM",
#if (EMU_SYSTEM != NCDZ)
		"Checking ROM info...\n",
		"This game not supported.\n",
		"ROM not found. (zip file name incorrect)\n",
		"Driver for \"%s\" not found.\n",
		"ROM set \"%s\" (parent: %s)\n",
		"ROM set \"%s\"\n",
#endif

#if (EMU_SYSTEM == CPS1)

		/* memintrf.c */
		"rominfo.cps1 not found.\n",
		"Could not allocate memory. (0x8000 bytes)",

#elif (EMU_SYSTEM == CPS2)

		/* cps2crpt.c */
		"Decrypting %d%%\r",
		"Decrypting 100%%\n",

		/* memintrf.c */
		"rominfo.cps2 not found.\n",

#ifdef PSP_SLIM
		/* vidhrdw.c */
		"Decoding GFX...\n",
#endif

#elif (EMU_SYSTEM == MVS)

		/* biosmenu.c */
		"BIOS select menu",
		"BIOS not found.",
		"All NVRAM files are removed.\n",

		/* memintrf.c */
		"rominfo.mvs not found.\n",
		"Loading \"%s (%s)\"\n",
		"Decrypting ROM...\n",
		"Loading decrypted GFX2 ROM...\n",
		"Loading decrypted SOUND1 ROM...\n",
		"Could not allocate memory for decrypt ROM.\n",
		"Could not allocate memory for sprite data.\n",
		"Try to use sprite cache...\n",
		"Checking BIOS...\n",

#elif (EMU_SYSTEM == NCDZ)

		/* ncdz.c */
		"Error while processing IPL.TXT.",
		"Reset caused by watchdog counter.",

		/* cdrom.c */
		"Could not open file \"%s\".",
		"Could not insert CD-ROM state data.",

		/* vidhrdw.c */
		"CD-ROM speed limit: Off",
		"CD-ROM speed limit: On",

		/* memintrf.c */
		"Checking game ID...\n",
#endif
		"Cheat menu",
		"Cheat",
		"Select cheat",
		"Cheat for this game not found.",
/*
		"Memory free",
		"Mem free",*/
		NULL
};
static const char *text_JAPANESE[UI_TEXT_MAX] =
{
		"\0",
		"\n",

		/* psp/filer.c */
		"Ф餯",
		"zipname.%s򥪩`ץǤޤ",
#ifdef ADHOC
		"WLANåONˤƤ",
		"AdHoc⥸``ɳޤǤ",
#endif

		/* psp/sound.c */
		"`ǥͥ_Ǥޤ",
		"ɥåɤ_ʼǤޤ",

		/* psp/ui.c */
		": Хåƥ`βޤ(%d%%)늤Ƥ",

		FONT_CIRCLE "       " FONT_CROSS " ֹ",
		FONT_CIRCLE " A      " FONT_CROSS " ֹ",
#ifdef SAVE_STATE
		FONT_CIRCLE " `ˑ   " FONT_CROSS " ˥`ˑ",
#endif
		"ΤܥѺƤ",
		"ߥ`_ʼޤ",
#ifdef ADHOC
		"ߥ`_ʼޤ(AdHoc)",
#endif
		"ߥ`Kˤޤ",
		"ߥ`ꥻåȤޤ",
		"ߥ`Ӥޤ",
#if (EMU_SYSTEM != NCDZ)
		"Υ`τޤ",
		"Υ`ϬF״ǤϤɤäƤ˄ޤ󤬡",
		"ݤˤʤǤ",
#endif
		"Υǥ쥯ȥڥǥ쥯ȥOޤ",
#ifdef PSP_SLIM
		"ΥץPSP-2000 + FW 3.71 M33ԽäǤ",
#endif
#ifdef SAVE_STATE
		"Ʃ`ȥ`֤_ʼޤ",
		"Ʃ`ȥ`ɤ_ʼޤ",
#endif
#if defined(SAVE_STATE) || defined(COMMAND_LIST)
		"ˤޤ",
#endif
#ifdef SAVE_STATE
		"Ʃ`ȥǩ`ޤ",
#endif
#if (EMU_SYSTEM == NCDZ)
		"MP3ե뤬o顢CDDAޤ",
		"IPL.TXTޤ",
		"NEOGEO CDZBIOSӤޤ",
		"NEOGEO CDZBIOS(neocd.bin)ޤ",
		"NEOGEO CDZBIOSoǤ",
		"`ӤǤޤ",
#endif

		"إ - %s",
		"ʹäޤ",
		"ΤܥѺȥ˥`ˑޤ",
		"ե֥饦",
		"`Ƅ",
		"`1ک`Ƅ",
		"`",
		"` (AdHoc)",
		"ߥ`K",
		"BIOSxk˥`ʾ",
		"`O˥`_",
		"Υإפ_",
		"BIOS",
		"xkФΥǥ쥯ȥӥǥ쥯ȥO",
		"",
		"xk",
		"åȤxk",
		"I",
		"Ig",
		"Ŀxk",
		"Ŀxk/Ή",
		"RGB΂+5",
		"ե֥饦ˑ",
		"RGB΂-5",
		"ȫƤ΂˜ʤˑ",
		"ꥹȤ򥹥`/Ŀxk",
		"Ŀ˥`_/]",
		"`/ᥤ˥`ˑ",

		/* psp/ui_menu.c */
		"",
		"",
		"Ϥ",
		"",
		"Є",
		"o",
		"ᥤ˥`ˑ",
		"`O˥`",
		"饹ե",
		"撈",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"360x270 (4:3)",
		"384x270 (24:17)",
		"466x272 (12:7)",
		"480x270 (16:9)",
		"ܞ",
#else
		"320x224 (4:3)",
		"360x270 (4:3)",
		"366x270 (19:14)",
		"420x270 (14:9)",
		"480x270 (16:9)",
#endif
		"VBLANKͬ",
		"Ԅӥե`ॹå",
		"ե`ॹå",
		"٥1",
		"٥2",
		"٥3",
		"٥4",
		"٥5",
		"٥6",
		"٥7",
		"٥8",
		"٥9",
		"٥10",
		"٥11",
		"FPSʾ",
		"60fpsե`",
		"",
		"ץ`",
		"11025Hz",
		"22050Hz",
		"44100Hz",
		"",
		"0%",
		"10%",
		"20%",
		"30%",
		"40%",
		"50%",
		"60%",
		"70%",
		"80%",
		"90%",
		"100%",
		"ȥ`",
		"ץ쥤`1",
		"ץ쥤`2",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"ץ쥤`3",
		"ץ쥤`4",
#endif
		"PSP CPUå",
		"222MHz",
		"266MHz",
		"300MHz",
		"333MHz",
#if (EMU_SYSTEM == MVS)
		"BIOS˜",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"ƥO",
		"ձ",
		"ꥫ",
		"`å",
#endif
#if (EMU_SYSTEM == MVS)
		"ƥ`O",
		"ͥ (AES)",
		"`` (MVS)",
#endif
#if (EMU_SYSTEM == NCDZ)
		"`ɻ楨ߥ`",
		"CD-ROMٶ",
		"CDDA",
		"CDDA",
#endif

		"ܥO˥`",
		"ʹäʤ",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
		FONT_CIRCLE,
		FONT_CROSS,
		FONT_SQUARE,
		FONT_TRIANGLE,
		"Lȥꥬ",
		"Rȥꥬ",
		"START",
		"SELECT",
		"",
		"˜",
		"",
#if (EMU_SYSTEM == CPS2)
		"ץ쥤`1 `",
		"ץ쥤`2 `",
#endif
		"%dե`",
		"%dե`",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"ܥA",
		"ܥB",
		"ܥC",
		"ܥD",
#else
		"ܥ1",
		"ܥ2",
		"ܥ3",
		"ܥ4",
		"ܥ5",
		"ܥ6",
#endif
		"`",
#if (EMU_SYSTEM == NCDZ)
		"쥯",
#else
		"",
		"`ӥ",
#endif
#if (EMU_SYSTEM == MVS)
		"ƥȥå",
#elif (EMU_SYSTEM != NCDZ)
		"`ӥå",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"ܥA B",
		"ܥB B",
		"ܥC B",
		"ܥD B",
#else
		"ܥ1 B",
		"ܥ2 B",
		"ܥ3 B",
		"ܥ4 B",
		"ܥ5 B",
		"ܥ6 B",
#endif
		"Bg",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"AB ͬrѺ",
		"AC ͬrѺ",
		"AD ͬrѺ",
		"BC ͬrѺ",
		"BD ͬrѺ",
		"CD ͬrѺ",
		"ABC ͬrѺ",
		"ABD ͬrѺ",
		"ACD ͬrѺ",
		"BCD ͬrѺ",
		"ABCD ͬrѺ",
#else
		"1+2ͬrѺ",
		"1+3ͬrѺ",
		"1+4ͬrѺ",
		"2+3ͬrѺ",
		"2+4ͬrѺ",
		"3+4ͬrѺ",
		"1+2+3ͬrѺ",
		"1+2+4ͬrѺ",
		"1+3+4ͬrѺ",
		"2+3+4ͬrѺ",
		"1+2+3+4ͬrѺ",
		"4+5+6ͬrѺ",
#endif
#if (EMU_SYSTEM != NCDZ)
		"ʥж",
#endif
#if (EMU_SYSTEM == CPS1)
		" (ܞ)",
		" (һܞ)",
		"ݩ`",
#endif
#if (EMU_SYSTEM == CPS2)
		"ѥɥ (ܞ)",
		"ѥɥ (һܞ)",
#endif
#if (EMU_SYSTEM == MVS)
		"ӥå",
		"`",
		"֥륢å",
		"`/Ӌ",
		"B",
		"󥻥",
		"٥å",
		"ȫƤ˥٥å/ȫƥ󥻥",
		"ڥ`˥`",
		"쥸åȤ򥯥ꥢ",
		"ۥåѩ`ȡ",
#endif
		"`󥷥åȱ",
		"ץ쥤`Ф椨",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"ܥ",
		"1 (NEOGEOѥå)",
		"2 (MVS)",
		"3 (PlayStation)",
		"`x",
#endif

		"ǥåץåO˥`",
		"Υ`ˤϥǥåץåϤޤ",

		"`/`ɥƩ`",
		"å%d:",
		"ǩ`ʤ",
		"`",
		"",
		"`",
		"ץ쥤ո",
		"`֕r",
		"Щ`",
		"ե\"%s\"ǤޤǤ",

		"ᥤ˥`",
		"`O",
		"`΄Oޤ",
		"ܥO",
		"ܥB/ۥåȥ`O򤷤ޤ",
#if (EMU_SYSTEM != NCDZ)
		"ǥåץåO",
		"ǥåץåOޤ",
#endif
		"ߥ`ꥻå",
		SYSTEM_NAME "Υߥ`ꥻåȤޤ",
		"ե֥饦ˑ",
		"ߥ`Kˤե֥饦ˑޤ",
		"`ˑ",
		"`໭ˑޤ",
		"ߥ`K",
		"ΥեȥKˤPSPΥ˥`ˑޤ",
#ifdef COMMAND_LIST
		"ޥɥꥹȱʾ",
		"Υ`ΥޥһEʾޤ",
#endif

#if PSP_VIDEO_32BPP
		"`O˥`",
		"ηN",
		"뤵",
		"ȥЩ`",
		"xk줿",
		"˜ʤ",
		"å`",
		"å`",
		"եxkЩ`(_ʼ)",
		"եxkЩ`(K)",
		"ȥЩ`/å`ܥå",
		"ȥЩ`/å`ܥåΖ",
		"ɫ(δʹÕr)",
		"x",
		"vx",
		"x",
		"˜ʤλ",
		"`λ",
		"logo.pngΤ",
		"եxkЩ`",
#endif

		"ޥɥꥹ",

		/* psp/mp3.c */
#if (EMU_SYSTEM == NCDZ)
		"MP3ե\"%s\"٥`ץǤޤ",
		"MP3ǥ`ɥ`kޤ",
		"MP3å`ǥͥ_Ǥޤ",
		"MP3åɤ_ʼǤޤ",
#endif

		/* psp/adhoc.c*/
#ifdef ADHOC
		"ө`",
		"`Щ`",
		"饤",
		"PSPνӾACС\n",
		"%s˽ӾA...",
		"ӾAޤ",
		"%sж...",
		"жϤޤ",
		"ӾAʧ",
		"ӾA륵`Щ`xk" FONT_TRIANGLE "Ѻֹޤ\n",
		"%sνӾASɤäƤޤ\n",
		FONT_CROSS "Ѻֹޤ\n",
		"%sӾASɤҪ󤷤Ƥޤ\n",
		FONT_CIRCLE "ǽӾASɡ" FONT_CROSS "ǽӾAܷ񤷤ޤ\n",
		"ͬڤäƤޤ",
#endif

		/* psp/png.c */
		"PNGäΥ_Ǥޤ",
		"PNGɤǤޤ",
#if PSP_VIDEO_32BPP || (EMU_SYSTEM == NCDZ)
		"PNGչ_Ǥޤ",
#endif
		"%dbit`PNGˤόꤷƤޤ",

		/* emumain.c */
		"Ĥʥ`",
		"`󥷥åȤ\"%s_%02d.png\"˱椷ޤ",

#if USE_CACHE
		/* common/cache.c */
		"åե򥪩`ץǤޤ\n",
		"꤬ޤ\n",
		"å_Ǥޤ\n",
		"%dKBΥå_ޤ\n",
		"å`Ф˥`kޤ\n",
		"åǩ``...\n",
		"ݩ`ȤƤʤЩ`\"V%c%c\"ΥåեǤ\n",
		"FҪ󤵤륭åեΥЩ`\"" CACHE_VERSION "\"Ǥ\n",
		"åեɤʤƤ\n",
#if (EMU_SYSTEM == CPS2)
		"ץ饤ȥ֥å%03x򥪩`ץǤޤ\n",
#elif (EMU_SYSTEM == MVS)
		"PCMåʹäޤ\n",
#endif
#endif

		/* common/loadrom.c */
		"ΤܥѺƤ\n",
		"_Ǥޤ(REGION_%s)\n",
		"CRC32ޤ\"%s\"\n",
		"ե뤬ҊĤޤ\"%s\"\n",

#ifdef SAVE_STATE
		/* common/state.c */
		"Ʃ`äΥХåե_Ǥޤ",
		"ե\"%s.sv%d\"ɤǤޤ",
		"ե\"%s.sv%d\"򥪩`ץǤޤ",
		"\"%s.sv%d\"򱣴",
		"\"%s.sv%d\"`",
#if (EMU_SYSTEM == MVS)
		"BIOS`ɤǤޤ󡣺ΤܥѺȽKˤޤ",
#elif (EMU_SYSTEM == NCDZ)
		"Ʃ`ȥǩ`RsǤޤ",
		"Ʃ`ȥǩ`չ_Ǥޤ",
#endif
#endif

#ifdef COMMAND_LIST
		/* common/cmdlist.c */
		"Υ`äΥޥɥꥹȤޤ",
		"ޥɥꥹ - %s",
		"%d/%d Ŀ",
		"COMMAND.DAT sСI",
		"Υߥ`ǌꤷƤʤ`ΥޥɥꥹȤ\n",
		"COMMAND.DATΥե륵sСޤ\n",
		"IФϤϡ" FONT_CIRCLE "ܥѺƤ\n",
		FONT_CROSS "ܥѺȄIֹƥե֥饦ˑޤ\n",
		"COMMAND.DAT ʖ...\n",
		"`: δ\"COMMAND.DAT\"եʽʤޤ\n",
		"`: դΥեǤ\n",
		"`: _Ǥޤ\n",
		"`: եͩ`Ǥޤ\n",
		"`: եɤǤޤ\n",
		"\"%s\" Υޥɤ򥳥ԩ`...\n",
		" %dbytes  %dbytes (%.1f%%p)\n",
#endif

		/* emulation core */
		"ˤޤ\n",
		"ߥ`νK",
		"Ф餯\n",

		/* inptport.c */
		"ȥ``: ץ쥤`1",
		"ȥ``: ץ쥤`%d",
#ifdef ADHOC
		"ͬڤʧޤ\n",
		"%sˤݩ`",
		"`_",
		"жϤƽK",
#endif

		/* memintrf.c */
		"` \"%s\"\n",
		"ROMΥ`",
#if (EMU_SYSTEM != NCDZ)
		"ROMå...\n",
		"Υ`ϥݩ`ȤƤޤ\n",
		"ROMҊĤޤ(zipեʤ)\n",
		"\"%s\"Υɥ饤Фޤ\n",
		"ROMå\"%s\" (Hå: %s)\n",
		"ROMå\"%s\"\n",
#endif

#if (EMU_SYSTEM == CPS1)

		/* memintrf.c */
		"rominfo.cps1ҊĤޤ\n",
		"_Ǥޤ(0x8000Х)",

#elif (EMU_SYSTEM == CPS2)

		/* cps2crpt.c */
		"ͺńIg %d%%\r",
		"ͺńIg 100%%\n",

		/* memintrf.c */
		"rominfo.cps2ҊĤޤ\n",

#ifdef PSP_SLIM
		/* vidhrdw.c */
		"եåǩ`չ_...\n",
#endif

#elif (EMU_SYSTEM == MVS)

		/* biosmenu.c */
		"BIOSxk˥`",
		"BIOSҊĤޤ",
		"NVRAMեȫޤ\n",

		/* memintrf.c */
		"rominfo.mvsҊĤޤ\n",
		"` \"%s (%s)\"\n",
		"ͺńIg...\n",
		"ͺŜgGFX2 ROM`...\n",
		"ͺŜgSOUND1 ROM`...\n",
		"ROMͺäΥ_Ǥޤ\n",
		"ץ饤ȥǩ`äΥ_Ǥޤ\n",
		"ץ饤ȥåʹäԇߤޤ\n",
		"BIOSå...\n",

#elif (EMU_SYSTEM == NCDZ)

		/* ncdz.c */
		"IPL.TXTIФ˥`kޤ",
		"åɥå󥿤ˤꥻåȤkޤ",

		/* cdrom.c */
		"ե\"%s\"򥪩`ץǤޤ",
		"CD-ROMΥƩ`ȥǩ`׷ӤǤޤ",

		/* vidhrdw.c */
		"CD-ROMٶ: o",
		"CD-ROMٶ: Є",

		/* memintrf.c */
		"`IDå...\n",
#endif
		"`ȥ˥`",
		"`",
		"`Ȥxkޤ",
		"Υ`äΥ`Ȥޤ",
/*
		"",
		"Oޤ",*/
		NULL
};
static const char *text_SPANISH[UI_TEXT_MAX] =
{
		"\0",
		"\n",

		/* psp/filer.c */
		"Por favor espere...",
		"No se pudo abrir zipname.%s",
#ifdef ADHOC
		"Por favor, active el interruptor WLAN.",
		"No se pudo cargar los modulos AdHoc.",
#endif

		/* psp/sound.c */
		"No se puede reservar canal de audio para el sonido.",
		"No se pudo iniciar la tarea de sonido.",

		/* psp/ui.c */
		"Advertencia: La bateria esta baja (%d%%). Por favor, carga la bateria!",

		FONT_CIRCLE " para cargar, " FONT_CROSS " para cancelar",
		FONT_CIRCLE " para confirmar, " FONT_CROSS " para cancelar",
#ifdef SAVE_STATE
		FONT_CIRCLE " regresar al juego, " FONT_CROSS " regresar al menu",
#endif
		"Pulsa cualquier boton.",
		"Comenzar emulacion.",
#ifdef ADHOC
		"Comenzar emulacion. (AdHoc)",
#endif
		"Salir del emulador.",
		"Resetear la emulacion.",
		"Es necesario reiniciar la emulacion.",
#if (EMU_SYSTEM != NCDZ)
		"ESTE JEUGO NO FUNCIONA.",
		"No sera capaz de hacer que funcione correctamente.",
		"No se moleste.",
#endif
		"Convertir este directorio en el de inicio?",
#ifdef PSP_SLIM
		"Este programa requiere PSP-2000 + FW 3.71 M33 o posterior.",
#endif
#ifdef SAVE_STATE
		"Iniciar el guardardado.",
		"Iniciar la carga.",
#endif
#if defined(SAVE_STATE) || defined(COMMAND_LIST)
		"Completo.",
#endif
#ifdef SAVE_STATE
		"Borrar archivo de esatado.",
#endif
#if (EMU_SYSTEM == NCDZ)
		"MP3 files not found. CDDA cannot play.",
		"IPL.TXT not found.",
		"Boot NEOGEO CDZ BIOS.",
		"NEOGEO CDZ BIOS (neocd.bin) not found.",
		"Invalid NEOGEO CDZ BIOS found.",
		"Cannot launch game.",
#endif

		"Ayuda - %s",
		"No usar",
		"Pulsa cualquier boton para regresar al menu.",
		"Explorador de archivos",
		"Desplazar",
		"Desplazar 1 pagina",
		"Cargar juego",
		"Cargar juego (AdHoc)",
		"Salir del emulador",
		"Mostrar menu de seleccion de BIOS",
		"Abrir el menu de ajustes de color",
		"Muestra esta ayuda",
		"Boot BIOS",
		"Fija el directorio seleccionado como inicial",
		"Cambiar valor",
		"Seleccionar",
		"Seleccionar slot",
		"Cambiar funcion",
		"Ejecutar funcion",
		"Seleccionar item",
		"Seleccionar item / Cambiar valor",
		"Valor RGB +5",
		"Regresar al explorador de archivos",
		"Valor RGB -5",
		"Restaurar todos los valores por defecto",
		"Desplazar / Seleccionar item",
		"Abrir / Cerrar elemento del menu",
		"Regresar al menu principal / juego",

		/* psp/ui_menu.c */
		"On",
		"Off",
		"Si",
		"No",
		"Habilitar",
		"Inhabilitar",
		"Regresar al menu principal",
		"Menu de configuracion del juego",
		"Raster Effects",
		"Estirar Pantalla",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"360x270 (4:3)",
		"384x270 (24:17)",
		"466x272 (12:7)",
		"480x270 (16:9)",
		"Rotar Pantalla",
#else
		"320x224 (4:3)",
		"360x270 (4:3)",
		"366x270 (19:14)",
		"420x270 (14:9)",
		"480x270 (16:9)",
#endif
		"Video Sync",
		"Frameskip Automatico",
		"Frameskip",
		"nivel 1",
		"nivel 2",
		"nivel 3",
		"nivel 4",
		"nivel 5",
		"nivel 6",
		"nivel 7",
		"nivel 8",
		"nivel 9",
		"nivel 10",
		"nivel 11",
		"Mostrar FPS",
		"Limitar a 60fps",
		"Habilinitar Sonido",
		"Frecuencia de muestreo",
		"11025Hz",
		"22050Hz",
		"44100Hz",
		"Volumen del sonido",
		"0%",
		"10%",
		"20%",
		"30%",
		"40%",
		"50%",
		"60%",
		"70%",
		"80%",
		"90%",
		"100%",
		"Control",
		"Jugador 1",
		"Jugador 2",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"Jugador 3",
		"Jugador 4",
#endif
		"PSP clock",
		"222MHz",
		"266MHz",
		"300MHz",
		"333MHz",
#if (EMU_SYSTEM == MVS)
		"Default",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Machine Region",
		"Japan",
		"USA",
		"Europe",
#endif
#if (EMU_SYSTEM == MVS)
		"Machine Mode",
		"Console (AES)",
		"Arcade (MVS)",
#endif
#if (EMU_SYSTEM == NCDZ)
		"Emular la pantalla de carga",
		"Velicida limite de CD-ROM",
		"Habilitar CDDA",
		"CDDA Volume",
#endif

		"Menu de configuracion de botones",
		"No usar",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
		FONT_CIRCLE,
		FONT_CROSS,
		FONT_SQUARE,
		FONT_TRIANGLE,
		"L TRIGGER",
		"R TRIGGER",
		"START",
		"SELECT",
		"Bajo",
		"Normal",
		"Alto",
#if (EMU_SYSTEM == CPS2)
		"Jugador1 Start",
		"Jugador2 Start",
#endif
		"%d frame",
		"%d frames",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Boton A",
		"Boton B",
		"Boton C",
		"Boton D",
#else
		"Boton 1",
		"Boton 2",
		"Boton 3",
		"Boton 4",
		"Boton 5",
		"Boton 6",
#endif
		"Start",
#if (EMU_SYSTEM == NCDZ)
		"Select",
#else
		"Moneda",
		"Moneda de Servicio",
#endif
#if (EMU_SYSTEM == MVS)
		"Interruptor de prueba",
#elif (EMU_SYSTEM != NCDZ)
		"Interruptor de Servicio",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Autodisparo A",
		"Autodisparo B",
		"Autodisparo C",
		"Autodisparo D",
#else
		"Autodisparo 1",
		"Autodisparo 2",
		"Autodisparo 3",
		"Autodisparo 4",
		"Autodisparo 5",
		"Autodisparo 6",
#endif
		"Intervalo de Autodisparo",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Hotkey A+B",
		"Hotkey A+C",
		"Hotkey A+D",
		"Hotkey B+C",
		"Hotkey B+D",
		"Hotkey C+D",
		"Hotkey A+B+C",
		"Hotkey A+B+D",
		"Hotkey A+C+D",
		"Hotkey B+C+D",
		"Hotkey A+B+C+D",
#else
		"Hotkey 1+2",
		"Hotkey 1+3",
		"Hotkey 1+4",
		"Hotkey 2+3",
		"Hotkey 2+4",
		"Hotkey 3+4",
		"Hotkey 1+2+3",
		"Hotkey 1+2+4",
		"Hotkey 1+3+4",
		"Hotkey 2+3+4",
		"Hotkey 1+2+3+4",
		"Hotkey 4+5+6",
#endif
#if (EMU_SYSTEM != NCDZ)
		"Selsibilidar del Analogo",
#endif
#if (EMU_SYSTEM == CPS1)
		"Dial (Izquierda)",
		"Dial (Derecha)",
		"Pausa",
#endif
#if (EMU_SYSTEM == CPS2)
		"Paddle (Izquierda)",
		"Paddle (Derecha)",
#endif
#if (EMU_SYSTEM == MVS)
		"Big",
		"Small",
		"Double Up",
		"Start/Collect",
		"Payout",
		"Cancel",
		"Bet",
		"Bet/Cancel All",
		"Operator Menu",
		"Clear Credit",
		"Hopper Out",
#endif
		"Captura de pantalla",
		"Cambiar Jugador",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Plantilla de Botones",
		"Tipo 1 (NEOGEO PAD)",
		"Tipo 2 (MVS)",
		"Tipo 3 (PlayStation)",
		"Definido por el usuario",
#endif

		"Menu de confiracion DIP",
		"Este juego no tiene DIP switches.",

		"Guardar/Cargar State",
		"Slot %d:",
		"Vacio",
		"Cargar",
		"Borrar",
		"Guardar",
		"Fecha",
		"Hora",
		"Version",
		"Fallo al borrar archivo \"%s\".",

		"Menu principal",
		"Configuracion del Juego",
		"Cambiar ajustes del juego.",
		"Configuracion de botones",
		"Cambiar configuracion de botones autodisparo/hotkey.",
#if (EMU_SYSTEM != NCDZ)
		"Configuracion DIP switch",
		"Cambiar la configuracion DIP swich de hardware.",
#endif
		"Reiniciar emulacion",
		"Reinicia la emulacion de "SYSTEM_NAME,
		"Regresar al explorador de archivos",
		"Detiene la emulacion y regresa al explorador de archivos.",
		"Regresar al juego",
		"Regresar a la emulacion del juego",
		"Salir del emulador",
		"Salir del emulador y volver al menu de PSP.",
#ifdef COMMAND_LIST
		"Mostrar lista de comandos",
		"Mostrar lista de comando. (MAME Plus! format \"command.dat\")",
#endif

#if PSP_VIDEO_32BPP
		"Menu de ajustes de color",
		"Tipo de imagen de fondo",
		"Brillo de imagen de fondo",
		"Texto de barra de titulo",
		"Texto seleccionado",
		"Texto normal",
		"Texto de mensajes de informacion",
		"Texto de mensajes de advertencia",
		"Barra de seleccion de archivo (inico)",
		"Barra de seleccion de archivo (fin)",
		"Barra de titulo/Message box",
		"Barra de titulo/ Message box frame",
		"Fondo",
		"Rojo",
		"Verde",
		"Azul",
		"Imagen por defecto",
		"Imagen del usuario",
		"solo logo.png",
		"Barra de seleccion de archivo",
#endif

		"Lista de comandos",

		/* psp/mp3.c */
#if (EMU_SYSTEM == NCDZ)
		"No se pudo entrar de nuevo a archivo mp3 \"%s\".",
		"Error al decodificar MP3.",
		"No se pudo reservar el canal de audio para MP3.",
		"No se pudo iniciar la tarea de MP3.",
#endif

		/* psp/adhoc.c*/
#ifdef ADHOC
		"lobby",
		"server",
		"crient",
		"Esperando a que otra PSP se una.\n",
		"Conectando a %s.",
		"Conectado.",
		"Desconectar de %s.",
		"Desconectado.",
		"fracasado.",
		"Seleccione un servidor al que conectarse, o pulse " FONT_TRIANGLE " para regresar.\n",
		"Esperando a que %s acepte la coneccion.\n",
		"Para cancelar pulsa " FONT_CROSS ".\n",
		"%s has requested a connection.\n",
		"Para aceptar la conexion pulsa " FONT_CIRCLE ", para cancelar pulsa " FONT_CROSS ".\n",
		"Esperando para la sincronizacion.",
#endif

		/* psp/png.c */
		"No se pudo asignar memoria para PNG.",
		"No se pudo codificar la imagen PNG.",
#if PSP_VIDEO_32BPP || (EMU_SYSTEM == NCDZ)
		"No se pudo decodificar la imagen PNG.",
#endif
		"%d bit color imagen PNG no soportada.",

		/* emumain.c */
		"Error fatal",
		"Capura guardada como \"%s_%02d.png\".",

#if USE_CACHE
		/* common/cache.c */
		"No se pudo abrir archivo de cache.\n",
		"No hay suficiente memoria.\n",
		"No se pudo asignar memoria cache.\n",
		"%dKB cache alojado.\n",
		"Error de carga de cache!!!\n",
		"Cargando informacion de tatos de cache...\n",
		"Version de cache no soportada \"V%c%c\".\n",
		"Version actual requerida \"" CACHE_VERSION "\".\n",
		"Por favor, reconstruir la cache de los archivos.\n",
#if (EMU_SYSTEM == CPS2)
		"No se pudo abrir bloque de sprite %03x\n",
#elif (EMU_SYSTEM == MVS)
		"PCM cache habilitado.\n",
#endif
#endif

		/* common/loadrom.c */
		"Pulse cualquier boton.\n",
		"No ha podido asignar %s memory.\n",
		"CRC32 incorrecto. \"%s\"\n",
		"Archivo no encontrado. \"%s\"\n",

#ifdef SAVE_STATE
		/* common/state.c */
		"No se pudo asignar un bufger de estado.",
		"No se pudo crear el archivo \"%s.sv%d\"",
		"No se pudo abrir el archivo \"%s.sv%d\"",
		"Guardando \"%s.sv%d\"",
		"Cargando \"%s.sv%d\"",
#if (EMU_SYSTEM == MVS)
		"Could not reload BIOS. Press any button to exit.",
#elif (EMU_SYSTEM == NCDZ)
		"No se pueden comprimir los datos de estado.",
		"No se pueden descomprimir los datos de estado.",
#endif
#endif

#ifdef COMMAND_LIST
		/* common/cmdlist.c */
		"La lista de comando para este juejo no se encontro.",
		"Lista de comando - %s",
		"%d/%d items",
		"Reduccion de tamano de COMMAND.DAT",
		"Este proceso elimina la lista de comandos de los juegos que no cuentan\n",
		"con el soporte de este emulador de COMMAND.DAT.\n",
		"Si desea reducir el tamaemulaciono de command.dat, pulse el boton" FONT_CIRCLE "\n",
		"De lo contrario, pulse el boton " FONT_CROSS " para regresar al explorador de archivos.\n",
		"Verifidando el formato de COMMAND.DAT...\n",
		"ERROR: Formato desconocido.\n",
		"ERROR: Archivo vacio.\n",
		"ERROR: No se pudo asignar memoria.\n",
		"ERROR: No se pudo cambiar el nombre de archivo.\n",
		"ERROR: Se pudo crear el archivo de salida.\n",
		"Copiando \"%s\"...\n",
		"Tamano original:%dbytes, Resultado:%dbytes (-%.1f%%)\n",
#endif

		/* emulation core */
		"Terminado.\n",
		"Salir de la emulacion",
		"Por favor espere.\n",

		/* inptport.c */
		"Controller: Player 1",
		"Controller: Player %d",
#ifdef ADHOC
		"Sicronizacion perdida.\n",
		"Pausado por %s",
		"Regresar al juego",
		"Desconectar",
#endif

		/* memintrf.c */
		"Cargando \"%s\"\n",
		"Carga de ROM",
#if (EMU_SYSTEM != NCDZ)
		"Verificando informacion del ROM...\n",
		"Este juego no esta soportado.\n",
		"ROM no encontrado. (zip nombre de archivo incorrecto)\n",
		"Driver para \"%s\" no encontrado.\n",
		"ROM set \"%s\" (parent: %s)\n",
		"ROM set \"%s\"\n",
#endif

#if (EMU_SYSTEM == CPS1)

		/* memintrf.c */
		"rominfo.cps1 no encontrado.\n",
		"No se pudo asignar memoria. (0x8000 bytes)",

#elif (EMU_SYSTEM == CPS2)

		/* cps2crpt.c */
		"Des-encriptando %d%%\r",
		"Des-encriptando 100%%\n",

		/* memintrf.c */
		"rominfo.cps2 no encontrado.\n",

#ifdef PSP_SLIM
		/* vidhrdw.c */
		"Decodificando GFX...\n",
#endif

#elif (EMU_SYSTEM == MVS)

		/* biosmenu.c */
		"Menu de seleccion de BIOS",
		"BIOS no encontrada.",
		"Todos los archivos NVRAM se borraron.\n",

		/* memintrf.c */
		"rominfo.mvs no encontrado.\n",
		"Cargando \"%s (%s)\"\n",
		"Des-encriptando ROM.\n",
		"Cargando GFX2 ROM desencriptado...\n",
		"Cargando SOUND1 ROM desencriptado...\n",
		"No se pudo asignar memoria para desencriptar ROM.\n",
		"No se pudo asignar memoria para los datos de sprite.\n",
		"Trate de usar cache de sprite...\n",
		"Verificando BIOS...\n",

#elif (EMU_SYSTEM == NCDZ)

		/* ncdz.c */
		"Error al procesar IPL.TXT.",
		"Reset caused by watchdog counter.",

		/* cdrom.c */
		"No se pudo abrir el archivo \"%s\".",
		"No se pudo insertar los datos del estado de CD-ROM.",

		/* vidhrdw.c */
		"Velocidad limite de CD-ROM: Off",
		"Velocidad limite de CD-ROM: On",

		/* memintrf.c */
		"Verificando ID de juego...\n",
#endif
		"Cheat menu",
		"Cheat",
		"Seleccionar cheat",
		"Cheat para este juejo no se encontro.",
/*
		"Memory free",
		"Mem free",*/
		NULL
};
static const char *text_CHINESE_SIMPLIFIED[UI_TEXT_MAX] =
{
		"\0",
		"\n",

		/* psp/filer.c */
		"Ե...",
		"޷zipname.%s",
#ifdef ADHOC
		"WLAN",
		"ģȡʧ.",
#endif

		/* psp/sound.c */
		"޷ȷƵ",
		"޷Ƶ߳",

		/* psp/ui.c */
		":(%d%%)!",

		FONT_CIRCLE " ȷ  " FONT_CROSS " ȡ",
		FONT_CIRCLE " ȷ  " FONT_CROSS " ȡ",
#ifdef SAVE_STATE
		FONT_CIRCLE " Ϸ  " FONT_CROSS " ز˵",
#endif
		"밴",
		"ʼģ",
#ifdef ADHOC
		"ʼģ ()",
#endif
		"˳ģ",
		"ģ",
		"Ҫģ",
#if (EMU_SYSTEM != NCDZ)
		"Ϸ޷",
		"޷",
		"",
#endif
		"Ƿ񽫴ļΪʼĿ¼?",
#ifdef PSP_SLIM
		"ҪPSP-2000ϵĻ+3.71 M33ϵͳ",
#endif
#ifdef SAVE_STATE
		"ʼʱ浵",
		"ʼʱ",
#endif
#if defined(SAVE_STATE) || defined(COMMAND_LIST)
		"",
#endif
#ifdef SAVE_STATE
		"ɾ浵ļ",
#endif
#if (EMU_SYSTEM == NCDZ)
		"ûҵMP3ļ޷CDDA",
		"ûҵIPL.TXT",
		"NEOGEO CDZ BIOS",
		"ûҵNEOGEO CDZ BIOS (neocd.bin)",
		"ЧNEOGEO CDZ BIOS",
		"޷Ϸ",
#endif

		" - %s",
		"δʹ",
		"밴ز˵",
		"ϷĿ¼",
		"ƶ",
		"ҳ",
		"Ϸ",
		"Ϸ ()",
		"˳ģ",
		"ʾBIOSѡ˵",
		"ɫ˵",
		"ʾ",
		"BIOS",
		"ΪʼĿ¼",
		"ֵ",
		"ѡ",
		"ѡ浵",
		"л",
		"ִ",
		"ѡĿ",
		"ѡĿ/ֵ",
		"RGBֵ+5",
		"ϷĿ¼",
		"RGBֵ-5",
		"ݻָĬ",
		"ƶ/ѡĿ",
		"/رĿ˵",
		"˵/Ϸ",

		/* psp/ui_menu.c */
		"",
		"",
		"",
		"",
		"",
		"",
		"˵",
		"Ϸò˵",
		"դЧ",
		"",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"360x270 (4:3)",
		"384x270 (24:17)",
		"466x272 (12:7)",
		"480x270 (16:9)",
		"ת",
#else
		"320x224 (4:3)",
		"360x270 (4:3)",
		"366x270 (19:14)",
		"420x270 (14:9)",
		"480x270 (16:9)",
#endif
		"ֱͬ",
		"Զ֡",
		"֡",
		"1",
		"2",
		"3",
		"4",
		"5",
		"6",
		"7",
		"8",
		"9",
		"10",
		"11",
		"ʾ֡",
		"60֡",
		"",
		"",
		"11025Hz",
		"22050Hz",
		"44100Hz",
		"",
		"0%",
		"10%",
		"20%",
		"30%",
		"40%",
		"50%",
		"60%",
		"70%",
		"80%",
		"90%",
		"100%",
		"",
		"1",
		"2",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"3",
		"4",
#endif
		"PSPƵ",
		"222MHz",
		"266MHz",
		"300MHz",
		"333MHz",
#if (EMU_SYSTEM == MVS)
		"Ĭ",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"",
		"հ",
		"",
		"ŷ",
#endif
#if (EMU_SYSTEM == MVS)
		"ģʽ",
		"û (AES)",
		"ֻ (MVS)",
#endif
#if (EMU_SYSTEM == NCDZ)
		"ģȡ",
		"CD-ROMٶ",
		"CDDA",
		"CDDA",
#endif

		"ò˵",
		"δʹ",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
		FONT_CIRCLE,
		FONT_CROSS,
		FONT_SQUARE,
		FONT_TRIANGLE,
		"L",
		"R",
		"START",
		"SELECT",
		"",
		"",
		"",
#if (EMU_SYSTEM == CPS2)
		"1 ʼ",
		"2 ʼ",
#endif
		"%d",
		"%d",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"A",
		"B",
		"C",
		"D",
#else
		"1",
		"2",
		"3",
		"4",
		"5",
		"6",
#endif
		"ʼ",
#if (EMU_SYSTEM == NCDZ)
		"ѡ",
#else
		"Ͷ",
		"Ͷ",
#endif
#if (EMU_SYSTEM == MVS)
		"Կ",
#elif (EMU_SYSTEM != NCDZ)
		"Կ",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"A",
		"B",
		"C",
		"D",
#else
		"1",
		"2",
		"3",
		"4",
		"5",
		"6",
#endif
		"",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"ȼA+B",
		"ȼA+C",
		"ȼA+D",
		"ȼB+C",
		"ȼB+D",
		"ȼC+D",
		"ȼA+B+C",
		"ȼA+B+D",
		"ȼA+C+D",
		"ȼB+C+D",
		"ȼA+B+C+D",
#else
		"ȼ1+2",
		"ȼ1+3",
		"ȼ1+4",
		"ȼ2+3",
		"ȼ2+4",
		"ȼ3+4",
		"ȼ1+2+3",
		"ȼ1+2+4",
		"ȼ1+3+4",
		"ȼ2+3+4",
		"ȼ1+2+3+4",
		"ȼ4+5+6",
#endif
#if (EMU_SYSTEM != NCDZ)
		"ҡ",
#endif
#if (EMU_SYSTEM == CPS1)
		"Dial (ת)",
		"Dial (ת)",
		"Pause",
#endif
#if (EMU_SYSTEM == CPS2)
		"Paddle (ת)",
		"Paddle (ת)",
#endif
#if (EMU_SYSTEM == MVS)
		"Big",
		"Small",
		"Double Up",
		"Start/Collect",
		"Payout",
		"Cancel",
		"Bet",
		"Bet/Cancel All",
		"Operator Menu",
		"Clear Credit",
		"Hopper Out",
#endif
		"ͼ",
		"л",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"ģʽ",
		"1 (NEOGEO)",
		"2 (ֻ)",
		"3 (PlayStation)",
		"Զ",
#endif

		"DIPò˵",
		"ϷûDIP",

		"ʱ浵/",
		"浵%d:",
		"",
		"ȡ",
		"ɾ",
		"",
		"",
		"ʱ",
		"汾",
		"ɾ\"%s\"ʧ",

		"˵",
		"Ϸ",
		"Ϸ",
		"",
		"İ/ȼ",
#if (EMU_SYSTEM != NCDZ)
		"DIP",
		"ӲϵDIP",
#endif
		"ģ",
		""SYSTEM_NAME"ģ",
		"ϷĿ¼",
		"ֹͣģϷĿ¼",
		"Ϸ",
		"ģϷ",
		"˳ģ",
		"˳ģPSP˵",
#ifdef COMMAND_LIST
		"ʾ˵",
		"ʾ˵ (MAME Plusʽ\"command.dat\")",
#endif

#if PSP_VIDEO_32BPP
		"ɫ˵",
		"ͼ",
		"ͼ",
		"",
		"ѡ",
		"ͨ",
		"Ϣ",
		"",
		"ļѡ (ͷ)",
		"ļѡ (β)",
		"/Ϣ",
		"/Ϣ",
		"",
		"",
		"",
		"",
		"Ĭͼ",
		"ûͼ",
		"logo.png",
		"ļѡ",
#endif

		"˵",

		/* psp/mp3.c */
#if (EMU_SYSTEM == NCDZ)
		"޷´\"%s\"",
		"MP3",
		"޷ȷMP3Ƶ",
		"޷MP3߳",
#endif

		/* psp/adhoc.c*/
#ifdef ADHOC
		"",
		"",
		"ͻ",
		"ȴPSP\n",
		"%s",
		"",
		"Ѵ%sϿ",
		"Ͽ",
		"ʧ",
		"ѡһӣ"FONT_TRIANGLE"\n",
		"ڵȴ%sͬ\n",
		""FONT_CROSS"ȡ\n",
		"%s\n",
		""FONT_CIRCLE"ͬӣ"FONT_CROSS"ȡ\n",
		"ȴͬ",
#endif

		/* psp/png.c */
		"޷ΪPNGڴ",
		"޷RPNGͼ",
#if PSP_VIDEO_32BPP || (EMU_SYSTEM == NCDZ)
		"޷RPNGͼ",
#endif
		"֧%dλɫPNGͼ",

		/* emumain.c */
		"ش",
		"ͼΪ\"%s_%02d.png\"",

#if USE_CACHE
		/* common/cache.c */
		"޷򿪻ļ\n",
		"ڴ治\n",
		"޷仺\n",
		"ѷ%dKB\n",
		"ȡ!!!\n",
		"ڶȡϢ\n",
		"֧\"V%c%c\"Ļļ\n",
		"ĿǰҪ\""CACHE_VERSION"\"\n",
		"תļ\n",
#if (EMU_SYSTEM == CPS2)
		"޷ͼ%03x\n",
#elif (EMU_SYSTEM == MVS)
		"PCMѿ\n",
#endif
#endif

		/* common/loadrom.c */
		"밴\n",
		"޷%sڴ\n",
		"CRC32ȷ\"%s\"\n",
		"ûҵ\"%s\"\n",

#ifdef SAVE_STATE
		/* common/state.c */
		"޷仺",
		"޷\"%s.sv%d\"",
		"޷\"%s.sv%d\"",
		"ڱ\"%s.sv%d\"",
		"ڶȡ\"%s.sv%d\"",
#if (EMU_SYSTEM == MVS)
		"޷¶ȡBIOS밴˳",
#elif (EMU_SYSTEM == NCDZ)
		"޷Rʱ浵",
		"޷Rʱ浵",
#endif
#endif

#ifdef COMMAND_LIST
		/* common/cmdlist.c */
		"ûзִϷĲ˵",
		"˵ - %s",
		"%d/%d",
		"COMMAND.DAT",
		"˲ɾCOMMAND.DATûʹõϷ˵\n",
		"ģֵ֧Ϸ˵ᱻɾ\n",
		"command.dat밴"FONT_CIRCLE"\n",
		"밴"FONT_CROSS"ϷĿ¼\n",
		"ڼCOMMAND.DATʽ\n",
		": δ֪ʽ\n",
		": ļ\n",
		": ޷ڴ\n",
		": ޷\n",
		": ޷ļ\n",
		"ڸ\"%s\"\n",
		"ԭʼ:%dֽ, :%dֽ (-%.1f%%)\n",
#endif

		/* emulation core */
		"\n",
		"˳ģ",
		"Ե\n",

		/* inptport.c */
		": 1",
		": %d",
#ifdef ADHOC
		"ͬʧ\n",
		"%sͣ",
		"Ϸ",
		"Ͽ",
#endif

		/* memintrf.c */
		"ڶȡ\"%s\"\n",
		"ȡϷROM",
#if (EMU_SYSTEM != NCDZ)
		"ڼROMϢ\n",
		"ִ֧Ϸ\n",
		"ûҵROM (zipļȷ)\n",
		"ûҵ\"%s\"\n",
		"ROM\"%s\" (ROM: %s)\n",
		"ROM\"%s\"\n",
#endif

#if (EMU_SYSTEM == CPS1)

		/* memintrf.c */
		"ûҵrominfo.cps1\n",
		"޷ڴ (0x8000 bytes)",

#elif (EMU_SYSTEM == CPS2)

		/* cps2crpt.c */
		"ڽܣ%d%%\r",
		"ڽܣ100%%\n",

		/* memintrf.c */
		"ûҵrominfo.cps2\n",

#ifdef PSP_SLIM
		/* vidhrdw.c */
		"չͼ\n",
#endif

#elif (EMU_SYSTEM == MVS)

		/* biosmenu.c */
		"BIOSѡ˵",
		"ûҵBIOS",
		"NVRAMļѱɾ\n",

		/* memintrf.c */
		"ûҵrominfo.mvs\n",
		"ڶȡ\"%s (%s)\"\n",
		"ڽROM\n",
		"ڶȡGFX2ROM\n",
		"ڶȡSOUND1ROM\n",
		"޷ΪROMڴ\n",
		"޷Ϊͼݷڴ\n",
		"ʹͼ񻺴\n",
		"ڼBIOS\n",

#elif (EMU_SYSTEM == NCDZ)

		/* ncdz.c */
		"IPL.TXT",
		"ԭ:ʧ",

		/* cdrom.c */
		"޷\"%s\"",
		"޷CD-ROM",

		/* vidhrdw.c */
		"CD-ROMٶ:",
		"CD-ROMٶ:",

		/* memintrf.c */
		"ڼϷID\n",
#endif
		"ָ˵",
		"ָ",
		"ѡָ",
		"ûзִϷĽָ",
/*
		"ڴͷ",
		"ڴͷŵ",*/
		NULL
};
static const char *text_CHINESE_TRADITIONAL[UI_TEXT_MAX] =
{
		"\0",
		"\n",

		/* psp/filer.c */
		"ՈԵ...",
		"o_zipname.%s",
#ifdef ADHOC
		"Ո_WLAN_P",
		"CģKxȡʧ.",
#endif

		/* psp/sound.c */
		"o_Jl",
		"ol",

		/* psp/ui.c */
		":(%d%%)Ո!",

		FONT_CIRCLE " _  " FONT_CROSS " ȡ",
		FONT_CIRCLE " _  " FONT_CROSS " ȡ",
#ifdef SAVE_STATE
		FONT_CIRCLE " [  " FONT_CROSS " زˆ",
#endif
		"ՈI",
		"_ʼģM",
#ifdef ADHOC
		"_ʼģM (C)",
#endif
		"˳ģM",
		"؆ģM",
		"Ҫ؆ģM",
#if (EMU_SYSTEM != NCDZ)
		"[o\\",
		"o\\",
		"Ո",
#endif
		"Ƿ񌢴ļAOÞ_ʼĿ?",
#ifdef PSP_SLIM
		"ܛҪPSP-2000ϵęC+3.71 M33ϵy",
#endif
#ifdef SAVE_STATE
		"_ʼrn",
		"_ʼrxn",
#endif
#if defined(SAVE_STATE) || defined(COMMAND_LIST)
		"",
#endif
#ifdef SAVE_STATE
		"hnļ",
#endif
#if (EMU_SYSTEM == NCDZ)
		"]ҵMP3ļoCDDA",
		"]ҵIPL.TXT",
		"NEOGEO CDZ BIOS",
		"]ҵNEOGEO CDZ BIOS (neocd.bin)",
		"oЧNEOGEO CDZ BIOS",
		"o\\[",
#endif

		" - %s",
		"δʹ",
		"ՈIزˆ",
		"[Ŀ",
		"Ƅ",
		"",
		"\\[",
		"\\[ (C)",
		"˳ģM",
		"@ʾBIOSxˆ",
		"_ɫˆ",
		"@ʾ",
		"BIOS",
		"OÞ_ʼĿ",
		"Ĕֵ",
		"x",
		"xn",
		"ГQ",
		"",
		"xĿ",
		"xĿ/Ĕֵ",
		"RGBֵ+5",
		"[Ŀ",
		"RGBֵ-5",
		"Д֏ĬJ",
		"Ƅ/xĿ",
		"_/P]Ŀˆ",
		"ˆ/[",

		/* psp/ui_menu.c */
		"_",
		"P",
		"",
		"",
		"_",
		"P",
		"ˆ",
		"[Oòˆ",
		"Ч",
		"s",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"360x270 (4:3)",
		"384x270 (24:17)",
		"466x272 (12:7)",
		"480x270 (16:9)",
		"D",
#else
		"320x224 (4:3)",
		"360x270 (4:3)",
		"366x270 (19:14)",
		"420x270 (14:9)",
		"480x270 (16:9)",
#endif
		"ֱͬ",
		"Ԅ",
		"e",
		"1",
		"2",
		"3",
		"4",
		"5",
		"6",
		"7",
		"8",
		"9",
		"10",
		"11",
		"@ʾ",
		"60",
		"_",
		"",
		"11025Hz",
		"22050Hz",
		"44100Hz",
		"",
		"0%",
		"10%",
		"20%",
		"30%",
		"40%",
		"50%",
		"60%",
		"70%",
		"80%",
		"90%",
		"100%",
		"",
		"1",
		"2",
#if (EMU_SYSTEM == CPS1 || EMU_SYSTEM == CPS2)
		"3",
		"4",
#endif
		"PSPl",
		"222MHz",
		"266MHz",
		"300MHz",
		"333MHz",
#if (EMU_SYSTEM == MVS)
		"ĬJ",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"C^",
		"հ",
		"",
		"W",
#endif
#if (EMU_SYSTEM == MVS)
		"Cģʽ",
		"ÙC (AES)",
		"֙C (MVS)",
#endif
#if (EMU_SYSTEM == NCDZ)
		"ģMxȡ",
		"CD-ROMٶ",
		"CDDA",
		"CDDA",
#endif

		"IOòˆ",
		"δʹ",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
		FONT_CIRCLE,
		FONT_CROSS,
		FONT_SQUARE,
		FONT_TRIANGLE,
		"L",
		"R",
		"START",
		"SELECT",
		"",
		"",
		"",
#if (EMU_SYSTEM == CPS2)
		"1 _ʼ",
		"2 _ʼ",
#endif
		"%d",
		"%d",
		FONT_UPARROW,
		FONT_DOWNARROW,
		FONT_LEFTARROW,
		FONT_RIGHTARROW,
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"IA",
		"IB",
		"IC",
		"ID",
#else
		"I1",
		"I2",
		"I3",
		"I4",
		"I5",
		"I6",
#endif
		"_ʼ",
#if (EMU_SYSTEM == NCDZ)
		"x",
#else
		"Ͷ",
		"{ԇͶ",
#endif
#if (EMU_SYSTEM == MVS)
		"yԇ_P",
#elif (EMU_SYSTEM != NCDZ)
		"{ԇ_P",
#endif
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"BlA",
		"BlB",
		"BlC",
		"BlD",
#else
		"Bl1",
		"Bl2",
		"Bl3",
		"Bl4",
		"Bl5",
		"Bl6",
#endif
		"Blg",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"IA+B",
		"IA+C",
		"IA+D",
		"IB+C",
		"IB+D",
		"IC+D",
		"IA+B+C",
		"IA+B+D",
		"IA+C+D",
		"IB+C+D",
		"IA+B+C+D",
#else
		"I1+2",
		"I1+3",
		"I1+4",
		"I2+3",
		"I2+4",
		"I3+4",
		"I1+2+3",
		"I1+2+4",
		"I1+3+4",
		"I2+3+4",
		"I1+2+3+4",
		"I4+5+6",
#endif
#if (EMU_SYSTEM != NCDZ)
		"uU`",
#endif
#if (EMU_SYSTEM == CPS1)
		"Dial (D)",
		"Dial (D)",
		"Pause",
#endif
#if (EMU_SYSTEM == CPS2)
		"Paddle (D)",
		"Paddle (D)",
#endif
#if (EMU_SYSTEM == MVS)
		"Big",
		"Small",
		"Double Up",
		"Start/Collect",
		"Payout",
		"Cancel",
		"Bet",
		"Bet/Cancel All",
		"Operator Menu",
		"Clear Credit",
		"Hopper Out",
#endif
		"؈D",
		"ГQ",
#if (EMU_SYSTEM == MVS || EMU_SYSTEM == NCDZ)
		"Iģʽ",
		"1 (NEOGEOI)",
		"2 (֙C)",
		"3 (PlayStation)",
		"Զ",
#endif

		"DIP_POòˆ",
		"[]DIP_P",

		"rn/xn",
		"n%d:",
		"",
		"xȡ",
		"h",
		"",
		"[",
		"rg",
		"汾",
		"h\"%s\"ʧ",

		"ˆ",
		"[O",
		"[O",
		"IO",
		"İIBl/IO",
#if (EMU_SYSTEM != NCDZ)
		"DIP_PO",
		"ӲϵDIP_PO",
#endif
		"؆ģM",
		"؆"SYSTEM_NAME"ģM",
		"[Ŀ",
		"ֹͣģMK[Ŀ",
		"[",
		"ģM^m[",
		"˳ģM",
		"˳ģMKPSPˆ",
#ifdef COMMAND_LIST
		"@ʾf",
		"@ʾf (MAME Plusʽ\"command.dat\")",
#endif

#if PSP_VIDEO_32BPP
		"ɫˆ",
		"D",
		"D",
		"}",
		"x",
		"ͨ",
		"Ϣ",
		"",
		"ļx (^)",
		"ļx (β)",
		"}/Ϣ",
		"}/Ϣ",
		"",
		"t",
		"G",
		"{",
		"ĬJD",
		"ÑD",
		"logo.png",
		"ļx",
#endif

		"f",

		/* psp/mp3.c */
#if (EMU_SYSTEM == NCDZ)
		"o´_\"%s\"",
		"MP3ae`",
		"o_JMP3l",
		"oMP3",
#endif

		/* psp/adhoc.c*/
#ifdef ADHOC
		"d",
		"",
		"͑",
		"ȴPSP\n",
		"B%s",
		"B",
		"я%s_B",
		"_B",
		"ʧ",
		"xһBӣ"FONT_TRIANGLE"I\n",
		"ڵȴ%sͬB\n",
		""FONT_CROSS"Iȡ\n",
		"%sՈB\n",
		""FONT_CIRCLE"IͬBӣ"FONT_CROSS"Iȡ\n",
		"ȴͬ",
#endif

		/* psp/png.c */
		"oPNGȴ",
		"osPNGD",
#if PSP_VIDEO_32BPP || (EMU_SYSTEM == NCDZ)
		"o≺PNGD",
#endif
		"֧%dλɫPNGD",

		/* emumain.c */
		"e`",
		"؈D\"%s_%02d.png\"",

#if USE_CACHE
		/* common/cache.c */
		"o_ļ\n",
		"ȴ治\n",
		"o侏\n",
		"ѷ%dKB\n",
		"xȡe`!!!\n",
		"xȡϢ\n",
		"֧\"V%c%c\"ľļ\n",
		"ĿǰҪ\""CACHE_VERSION"\"\n",
		"ՈDQļ\n",
#if (EMU_SYSTEM == CPS2)
		"o_DK%03x\n",
#elif (EMU_SYSTEM == MVS)
		"PCM_\n",
#endif
#endif

		/* common/loadrom.c */
		"ՈI\n",
		"o%sȴ\n",
		"CRC32_\"%s\"\n",
		"]ҵ\"%s\"\n",

#ifdef SAVE_STATE
		/* common/state.c */
		"o侏n^",
		"o\"%s.sv%d\"",
		"o_\"%s.sv%d\"",
		"ڱ\"%s.sv%d\"",
		"xȡ\"%s.sv%d\"",
#if (EMU_SYSTEM == MVS)
		"oxȡBIOSՈI˳",
#elif (EMU_SYSTEM == NCDZ)
		"osrn",
		"o≺rn",
#endif
#endif

#ifdef COMMAND_LIST
		/* common/cmdlist.c */
		"]аlF[Ĳf",
		"f - %s",
		"%d/%d",
		"spCOMMAND.DAT",
		"˲hCOMMAND.DATЛ]ʹõ[f\n",
		"ģMֵ֧[fh\n",
		"spcommand.datweՈ"FONT_CIRCLE"I\n",
		"spՈ"FONT_CROSS"I[Ŀ\n",
		"ڙzCOMMAND.DATʽ\n",
		"e`: δ֪ʽ\n",
		"e`: ļ\n",
		"e`: oȴ\n",
		"e`: o\n",
		"e`: oݔļ\n",
		"}u\"%s\"\n",
		"ԭʼ:%dֹ, sp:%dֹ (-%.1f%%)\n",
#endif

		/* emulation core */
		"\n",
		"˳ģM",
		"ՈԵ\n",

		/* inptport.c */
		": 1",
		": %d",
#ifdef ADHOC
		"ͬʧ\n",
		"%sѕͣ",
		"[",
		"_B",
#endif

		/* memintrf.c */
		"xȡ\"%s\"\n",
		"xȡ[ROM",
#if (EMU_SYSTEM != NCDZ)
		"ڙzROMϢ\n",
		"ִ֧[\n",
		"]ҵROM (zipļ_)\n",
		"]ҵ\"%s\"\n",
		"ROMQ\"%s\" (ROM: %s)\n",
		"ROMQ\"%s\"\n",
#endif

#if (EMU_SYSTEM == CPS1)

		/* memintrf.c */
		"]ҵrominfo.cps1\n",
		"oȴ (0x8000 bytes)",

#elif (EMU_SYSTEM == CPS2)

		/* cps2crpt.c */
		"ڽܣM%d%%\r",
		"ڽܣM100%%\n",

		/* memintrf.c */
		"]ҵrominfo.cps2\n",

#ifdef PSP_SLIM
		/* vidhrdw.c */
		"չ_D񔵓\n",
#endif

#elif (EMU_SYSTEM == MVS)

		/* biosmenu.c */
		"BIOSxˆ",
		"]ҵBIOS",
		"NVRAMļѱh\n",

		/* memintrf.c */
		"]ҵrominfo.mvs\n",
		"xȡ\"%s (%s)\"\n",
		"ڽROM\n",
		"xȡGFX2ROM\n",
		"xȡSOUND1ROM\n",
		"oROMȴ\n",
		"oD񔵓ȴ\n",
		"LԇʹÈD񾏴\n",
		"ڙzBIOS\n",

#elif (EMU_SYSTEM == NCDZ)

		/* ncdz.c */
		"̎IPL.TXTe",
		"ԭ:zyʧ",

		/* cdrom.c */
		"o_\"%s\"",
		"oCD-ROM",

		/* vidhrdw.c */
		"CD-ROMٶ:P",
		"CD-ROMٶ:_",

		/* memintrf.c */
		"ڙz[ID\n",
#endif
		"ָˆ",
		"ָ",
		"xָa",
		"]аlF[Ľָ",
/*
		"ȴጷ",
		"ăȴጷŵO",*/
		NULL
};

//			JAPANESE			0
//			ENGLISH				1
//			FRENCH				2
//			SPANISH				3
//			GERMAN				4
//			ITALIAN				5
//			DUTCH				6
//			PORTUGUESE			7
//			RUSSIAN				8
//			KOREAN				9
//			CHINESE_TRADITIONAL	10
//			CHINESE_SIMPLIFIED	11
static int lang = 0;


void ui_text_init(void)
{
	int i;

	sceUtilityGetSystemParamInt(PSP_SYSTEMPARAM_ID_INT_LANGUAGE, &lang);
    switch (lang)
	{
	case PSP_SYSTEMPARAM_LANGUAGE_CHINESE_SIMPLIFIED:
		lang = LANG_CHINESE_SIMPLIFIED;
		for (i = 0; i < UI_TEXT_MAX; i++)
			ui_text[i] = text_CHINESE_SIMPLIFIED[i];
		break;

	case PSP_SYSTEMPARAM_LANGUAGE_CHINESE_TRADITIONAL:
		lang = LANG_CHINESE_TRADITIONAL;
		for (i = 0; i < UI_TEXT_MAX; i++)
			ui_text[i] = text_CHINESE_TRADITIONAL[i];
		break;

	case PSP_SYSTEMPARAM_LANGUAGE_JAPANESE:
		lang = LANG_JAPANESE;
		for (i = 0; i < UI_TEXT_MAX; i++)
			ui_text[i] = text_JAPANESE[i];
		break;

	case PSP_SYSTEMPARAM_LANGUAGE_SPANISH:
		lang = LANG_SPANISH;
		for (i = 0; i < UI_TEXT_MAX; i++)
			ui_text[i] = text_SPANISH[i];
		break;

	default:
		lang = LANG_ENGLISH;
		for (i = 0; i < UI_TEXT_MAX; i++)
			ui_text[i] = text_ENGLISH[i];
		break;
	}
}

int ui_text_get_language(void)
{
	return lang;
}
