/******************************************************************************

	graphic.c

	14 pixels graphic font. (for user interface)

	code: 0x11-0x19, 0x1b-0x1f

******************************************************************************/

#include "psp/psp.h"

#define NUM_FONTS	0x0e

/*------------------------------------------------------
	gryph data
------------------------------------------------------*/

static const UINT8 ALIGN_DATA graphic_font[] = {
	0x10,0x0c,0x00,0xd0,0x9f,0x00,0xe9,0xef,0x06,0x68,0x1f,0x07,0x60,0x0f,0x00,0x60,
	0x0f,0x00,0x60,0x0f,0x00,0x60,0x0f,0x00,0x60,0x0f,0x00,0x60,0x0f,0x00,0x60,0x0f,
	0x00,0x60,0x0f,0x00,0x30,0x09,0x00,0x00,0xd9,0x00,0x00,0xd9,0x00,0x00,0xd9,0x00,
	0x00,0xd9,0x00,0x00,0xd9,0x00,0x00,0xd9,0x00,0x00,0xd9,0x00,0x00,0xd9,0x00,0x10,
	0xd9,0x00,0xd3,0xeb,0x7b,0x70,0xff,0x0a,0x00,0xea,0x00,0x00,0x30,0x00,0x00,0x10,
	0x00,0x00,0x00,0x00,0x00,0x00,0xe6,0x01,0x00,0x00,0x00,0x00,0x90,0xcf,0x99,0x99,
	0x99,0x99,0x09,0xd1,0xef,0xdd,0xdd,0xdd,0xdd,0x0d,0x00,0xe9,0x00,0x00,0x00,0x00,
	0x00,0x00,0x60,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,
	0x00,0x00,0xb0,0x09,0x97,0x99,0x99,0x99,0xa9,0xdf,0xda,0xdd,0xdd,0xdd,0xdd,0xff,
	0x00,0x00,0x00,0x00,0x80,0x1d,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x10,0x97,0x89,
	0x03,0x00,0x00,0xf7,0xff,0xff,0x9f,0x00,0x70,0xff,0x37,0x71,0xfe,0x0a,0xf1,0x4f,
	0x00,0x00,0xe1,0x6f,0xf7,0x07,0x00,0x00,0x30,0xbf,0xf9,0x03,0x00,0x00,0x00,0xdf,
	0xf9,0x01,0x00,0x00,0x00,0xde,0xf8,0x07,0x00,0x00,0x10,0xcf,0xf3,0x1e,0x00,0x00,
	0xb0,0x7f,0x90,0xef,0x03,0x10,0xfb,0x0d,0x00,0xfa,0xff,0xfe,0xdf,0x01,0x00,0x60,
	0xdb,0xcd,0x07,0x00,0xd1,0x04,0x00,0x70,0x0b,0xe1,0x4f,0x00,0xf7,0x0b,0x10,0xfe,
	0x74,0xbf,0x00,0x00,0xe1,0xff,0x0b,0x00,0x00,0x80,0xff,0x04,0x00,0x00,0xf7,0xeb,
	0x4f,0x00,0x70,0xbf,0x10,0xfe,0x04,0xf1,0x0b,0x00,0xe1,0x0d,0x30,0x00,0x00,0x10,
	0x01,0xf9,0xff,0xff,0xff,0xff,0x0d,0xf9,0x99,0x99,0x99,0xf9,0x0d,0xf9,0x00,0x00,
	0x00,0xd0,0x0d,0xf9,0x00,0x00,0x00,0xd0,0x0d,0xf9,0x00,0x00,0x00,0xd0,0x0d,0xf9,
	0x00,0x00,0x00,0xd0,0x0d,0xf9,0x00,0x00,0x00,0xd0,0x0d,0xf9,0x00,0x00,0x00,0xd0,
	0x0d,0xf9,0x00,0x00,0x00,0xd0,0x0d,0xf9,0xff,0xff,0xff,0xff,0x0d,0x63,0x66,0x66,
	0x66,0x66,0x04,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x70,0x0b,0x00,0x00,0x00,
	0x00,0xf1,0x6f,0x00,0x00,0x00,0x00,0xfa,0xed,0x00,0x00,0x00,0x40,0x8f,0xf4,0x08,
	0x00,0x00,0xd0,0x0f,0xb0,0x1f,0x00,0x00,0xf7,0x06,0x10,0xbf,0x00,0x10,0xdf,0x00,
	0x00,0xf9,0x06,0x90,0x3f,0x00,0x00,0xf0,0x0d,0xf3,0xdf,0xdd,0xdd,0xfd,0x7f,0xd9,
	0xdd,0xdd,0xdd,0xdd,0xcd,0x90,0xfd,0xff,0xff,0xff,0xdf,0x09,0xd9,0x99,0x99,0x99,
	0x99,0x99,0x9d,0xd9,0x00,0x40,0x00,0x00,0x00,0x9d,0xf9,0x00,0xf4,0x04,0x00,0x00,
	0x9f,0xf9,0x00,0xf4,0x04,0x00,0x00,0x9f,0xf9,0x00,0xf4,0x04,0x00,0x00,0x9f,0xf9,
	0x00,0xf4,0x04,0x00,0x00,0x9f,0xf9,0x00,0xf4,0x04,0x00,0x00,0x9f,0xf9,0x00,0xf4,
	0x44,0x44,0x00,0x9f,0xf9,0x00,0xf4,0xff,0xff,0x04,0x9f,0xf9,0x00,0x40,0x44,0x44,
	0x00,0x9f,0x96,0xff,0xff,0xff,0xff,0xdf,0x69,0x60,0x66,0x66,0x66,0x66,0x66,0x06,
	0x90,0xfd,0xff,0xff,0xff,0xdf,0x09,0xd9,0x99,0x99,0x99,0x99,0x99,0x9d,0xd9,0x00,
	0x44,0x44,0x04,0x00,0x9d,0xf9,0x40,0xff,0xdf,0x4d,0x00,0x9f,0xf9,0x40,0x4f,0x44,
	0xd4,0x04,0x9f,0xf9,0x40,0x4f,0x44,0xd4,0x04,0x9f,0xf9,0x40,0xff,0xdf,0x4f,0x00,
	0x9f,0xf9,0x40,0x4f,0x44,0x4d,0x00,0x9f,0xf9,0x40,0x4f,0x00,0xd4,0x04,0x9f,0xf9,
	0x40,0x4f,0x00,0xf4,0x04,0x9f,0xf9,0x00,0x04,0x00,0x40,0x00,0x9f,0x96,0xff,0xff,
	0xff,0xff,0xdf,0x69,0x60,0x66,0x66,0x66,0x66,0x66,0x06,0x00,0x70,0x00,0x00,0x00,
	0xd6,0x06,0x00,0x60,0xfd,0x6d,0x00,0xd6,0xff,0xdf,0x06,0xfc,0xff,0xff,0x0c,0x33,
	0x33,0x33,0x03,0x33,0x33,0x33,0x03,0xfc,0xff,0xff,0x0c,0xd6,0xff,0xdf,0x06,0x60,
	0xfd,0x6d,0x00,0x00,0xd6,0x06,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x03,0x00,0x00,0x00,0x00,0xb1,0x0d,0x00,0x00,0x00,0x80,0xff,0x0d,0x00,0x00,0x60,
	0xff,0xff,0x0d,0x00,0x30,0xfc,0xff,0xff,0x0d,0x00,0xf9,0xff,0xff,0xff,0x0d,0xf1,
	0xff,0xff,0xff,0xff,0x0d,0x30,0xfd,0xff,0xff,0xff,0x0d,0x00,0x70,0xff,0xff,0xff,
	0x0d,0x00,0x00,0x91,0xff,0xff,0x0d,0x00,0x00,0x00,0xc3,0xff,0x0d,0x00,0x00,0x00,
	0x00,0xf6,0x0d,0x00,0x00,0x00,0x00,0x00,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0xbd,
	0x01,0x00,0x00,0x00,0x00,0xfd,0x8f,0x00,0x00,0x00,0x00,0xfd,0xff,0x6f,0x00,0x00,
	0x00,0xfd,0xff,0xff,0x3c,0x00,0x00,0xfd,0xff,0xff,0xff,0x09,0x00,0xfd,0xff,0xff,
	0xff,0xff,0x01,0xfd,0xff,0xff,0xff,0x3d,0x00,0xfd,0xff,0xff,0x7f,0x00,0x00,0xfd,
	0xff,0x9f,0x01,0x00,0x00,0xfd,0xcf,0x03,0x00,0x00,0x00,0xfd,0x06,0x00,0x00,0x00,
	0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

static const int ALIGN_DATA graphic_font_pos[NUM_FONTS] = {
	0x000000,0x000027,0x00004e,0x000078,0x00009c,0x0000e4,0x000111,0x000153,0x000195,0x0001f0,0x00024b,0x000263,0x00027b,0x0002c9
};

static const INT8 ALIGN_DATA graphic_font_width[NUM_FONTS] = {
	 6, 6,14,12,12,10,12,12,14,14, 8, 8,12,12
};

static const INT8 ALIGN_DATA graphic_font_height[NUM_FONTS] = {
	13,13, 6, 6,12, 9,11,11,13,13, 6, 6,13,13
};

static const INT8 ALIGN_DATA graphic_font_skipx[NUM_FONTS] = {
	 5, 4, 0, 1, 2, 3, 2, 2, 1, 1, 4, 4, 2, 3
};

static const INT8 ALIGN_DATA graphic_font_skipy[NUM_FONTS] = {
	 1, 1, 4, 4, 1, 3, 2, 1, 1, 1, 4, 4, 0, 0
};


/*------------------------------------------------------
	functions
------------------------------------------------------*/

int graphic_font_get_gryph(struct font_t *font, UINT16 code)
{
	if (code < NUM_FONTS)
	{
		font->data   = &graphic_font[graphic_font_pos[code]];
		font->width  = graphic_font_width[code];
		font->height = graphic_font_height[code];
		font->pitch  = 14;
		font->skipx  = graphic_font_skipx[code];
		font->skipy  = graphic_font_skipy[code];
		return 1;
	}
	return 0;
}

int graphic_font_get_pitch(UINT16 code)
{
	return 14;
}
