/******************************************************************************

	sprite.c

	MVS ץ饤ȥޥͩ`

******************************************************************************/

#include "mvs.h"


/******************************************************************************
	/ޥ
******************************************************************************/

#define TEXTURE_HEIGHT	512

#define MAKE_FIX_KEY(code, attr)	(code | (attr << 28))
#define MAKE_SPR_KEY(code, attr)	(code | ((attr & 0x0f00) << 20))
#define PSP_UNCACHE_PTR(p)			(((UINT32)(p)) | 0x40000000)


/******************************************************************************
	`/
******************************************************************************/

typedef struct sprite_t SPRITE;

struct sprite_t
{
	UINT32 key;
	UINT32 used;
	INT32 index;
	SPRITE *next;
};

static RECT mvs_src_clip = { 24, 16, 24 + 304, 16 + 224 };

static RECT mvs_clip[6] =
{
	{ 88, 24, 88 + 304, 24 + 224 },	// option_stretch = 0  (304x224 19:14)
	{ 80, 16, 80 + 320, 16 + 240 },	// option_stretch = 1  (320x240  4:3)
	{ 60,  1, 60 + 360,  1 + 270 },	// option_stretch = 2  (360x270  4:3)
	{ 57,  1, 57 + 360,  1 + 270 },	// option_stretch = 3  (366x270 19:14)
	{ 30,  1, 30 + 420,  1 + 270 },	// option_stretch = 4  (420x270 14:9)
	{  0,  1,  0 + 480,  1 + 270 }	    // option_stretch = 5  (480x270 16:9)
};

static int clip_min_y;
static int clip_max_y;
static int clear_spr_texture;
static int clear_fix_texture;

static UINT16 *scrbitmap;


/*------------------------------------------------------------------------
	FIX: /λ8pixel̶Υץ饤
------------------------------------------------------------------------*/

#define FIX_TEXTURE_SIZE	((BUF_WIDTH/8)*(TEXTURE_HEIGHT/8))
#define FIX_HASH_MASK		0x1ff
#define FIX_HASH_SIZE		0x200
#define FIX_MAX_SPRITES		((320/8) * (240/8))

static SPRITE ALIGN_DATA *fix_head[FIX_HASH_SIZE];
static SPRITE ALIGN_DATA fix_data[FIX_TEXTURE_SIZE];
static SPRITE *fix_free_head;

static UINT8 *tex_fix;
static struct Vertex ALIGN_DATA vertices_fix[FIX_MAX_SPRITES * 2];
static UINT16 fix_num;
static UINT16 fix_texture_num;


/*------------------------------------------------------------------------
	SPR: ɉ䥵Υץ饤
------------------------------------------------------------------------*/

#define SPR_TEXTURE_SIZE	((BUF_WIDTH/16)*((TEXTURE_HEIGHT*3)/16))
#define SPR_HASH_MASK		0x1ff
#define SPR_HASH_SIZE		0x200
#define SPR_MAX_SPRITES		0x3000

static SPRITE ALIGN_DATA *spr_head[SPR_HASH_SIZE];
static SPRITE ALIGN_DATA spr_data[SPR_TEXTURE_SIZE];
static SPRITE *spr_free_head;

static UINT8 *tex_spr[3];
static struct Vertex ALIGN_DATA vertices_spr[SPR_MAX_SPRITES * 2];
static UINT16 ALIGN_DATA spr_flags[SPR_MAX_SPRITES];
static UINT16 spr_num;
static UINT16 spr_texture_num;
static UINT16 spr_index;
static UINT8 spr_disable;


/*------------------------------------------------------------------------
	`ååץƩ`֥
------------------------------------------------------------------------*/

static UINT16 *clut;

static const UINT32 ALIGN_DATA color_table[16] =
{
	0x00000000, 0x10101010, 0x20202020, 0x30303030,
	0x40404040, 0x50505050, 0x60606060, 0x70707070,
	0x80808080, 0x90909090, 0xa0a0a0a0, 0xb0b0b0b0,
	0xc0c0c0c0, 0xd0d0d0d0, 0xe0e0e0e0, 0xf0f0f0f0
};


/*------------------------------------------------------------------------
	'swizzle'ƥ㥢ɥ쥹ӋƩ`֥
------------------------------------------------------------------------*/

static const int ALIGN_DATA swizzle_table_8bit[16] =
{
	   0, 16, 16, 16, 16, 16, 16, 16,
	3984, 16, 16, 16, 16, 16, 16, 16
};


/******************************************************************************
	FIXץ饤ȹ
******************************************************************************/

/*------------------------------------------------------------------------
	FIXƥ㤫饹ץ饤ȷŤȡ
------------------------------------------------------------------------*/

static int fix_get_sprite(UINT32 key)
{
	SPRITE *p = fix_head[key & FIX_HASH_MASK];

	while (p)
	{
		if (p->key == key)
		{
			p->used = frames_displayed;
			return p->index;
	 	}
		p = p->next;
	}
	return -1;
}


/*------------------------------------------------------------------------
	FIXƥ˥ץ饤Ȥh
------------------------------------------------------------------------*/

static int fix_insert_sprite(UINT32 key)
{
	UINT16 hash = key & FIX_HASH_MASK;
	SPRITE *p = fix_head[hash];
	SPRITE *q = fix_free_head;

	if (!q) return -1;

	fix_free_head = fix_free_head->next;

	q->next = NULL;
	q->key  = key;
	q->used = frames_displayed;

	if (!p)
	{
		fix_head[hash] = q;
	}
	else
	{
		while (p->next) p = p->next;
		p->next = q;
	}

	fix_texture_num++;

	return q->index;
}


/*------------------------------------------------------------------------
	FIXƥ㤫һrgU^ץ饤Ȥ
------------------------------------------------------------------------*/

static void fix_delete_sprite(void)
{
	int i;
	SPRITE *p, *prev_p;

	for (i = 0; i < FIX_HASH_SIZE; i++)
	{
		prev_p = NULL;
		p = fix_head[i];

		while (p)
		{
			if (frames_displayed != p->used)
			{
				fix_texture_num--;

				if (!prev_p)
				{
					fix_head[i] = p->next;
					p->next = fix_free_head;
					fix_free_head = p;
					p = fix_head[i];
				}
				else
				{
					prev_p->next = p->next;
					p->next = fix_free_head;
					fix_free_head = p;
					p = prev_p->next;
				}
			}
			else
			{
				prev_p = p;
				p = p->next;
			}
		}
	}
}


/******************************************************************************
	SPRץ饤ȹ
******************************************************************************/

/*------------------------------------------------------------------------
	SPRƥ㤫饹ץ饤ȷŤȡ
------------------------------------------------------------------------*/

static int spr_get_sprite(UINT32 key)
{
	SPRITE *p = spr_head[key & SPR_HASH_MASK];

	while (p)
	{
		if (p->key == key)
		{
			if (p->used != frames_displayed)
			{
				update_cache(key << 7);
				p->used = frames_displayed;
			}
			return p->index;
		}
		p = p->next;
	}
	return -1;
}


/*------------------------------------------------------------------------
	SPRƥ˥ץ饤Ȥh
------------------------------------------------------------------------*/

static int spr_insert_sprite(UINT32 key)
{
	UINT16 hash = key & SPR_HASH_MASK;
	SPRITE *p = spr_head[hash];
	SPRITE *q = spr_free_head;

	if (!q) return -1;

	spr_free_head = spr_free_head->next;

	q->next = NULL;
	q->key  = key;
	q->used = frames_displayed;

	if (!p)
	{
		spr_head[hash] = q;
	}
	else
	{
		while (p->next) p = p->next;
		p->next = q;
	}

	spr_texture_num++;

	return q->index;
}


/*------------------------------------------------------------------------
	SPRƥ㤫һrgU^ץ饤Ȥ
------------------------------------------------------------------------*/

static void spr_delete_sprite(void)
{
	int i;
	SPRITE *p, *prev_p;

	for (i = 0; i < SPR_HASH_SIZE; i++)
	{
		prev_p = NULL;
		p = spr_head[i];

		while (p)
		{
			if (frames_displayed != p->used)
			{
				spr_texture_num--;

				if (!prev_p)
				{
					spr_head[i] = p->next;
					p->next = spr_free_head;
					spr_free_head = p;
					p = spr_head[i];
				}
				else
				{
					prev_p->next = p->next;
					p->next = spr_free_head;
					spr_free_head = p;
					p = prev_p->next;
				}
			}
			else
			{
				prev_p = p;
				p = p->next;
			}
		}
	}
}


/******************************************************************************
	ץ饤軭󥿥ե`v
******************************************************************************/

/*------------------------------------------------------------------------
	FIXץ饤Ȥ˥ꥢ
------------------------------------------------------------------------*/

static void blit_clear_fix_sprite(void)
{
	int i;

	for (i = 0; i < FIX_TEXTURE_SIZE - 1; i++)
		fix_data[i].next = &fix_data[i + 1];

	fix_data[i].next = NULL;
	fix_free_head = &fix_data[0];

	memset(fix_head, 0, sizeof(SPRITE *) * FIX_HASH_SIZE);

	fix_texture_num = 0;
	clear_fix_texture = 0;
}


/*------------------------------------------------------------------------
	SPRץ饤Ȥ˥ꥢ
------------------------------------------------------------------------*/

static void blit_clear_spr_sprite(void)
{
	int i;

	for (i = 0; i < SPR_TEXTURE_SIZE - 1; i++)
		spr_data[i].next = &spr_data[i + 1];

	spr_data[i].next = NULL;
	spr_free_head = &spr_data[0];

	memset(spr_head, 0, sizeof(SPRITE *) * SPR_HASH_SIZE);

	spr_texture_num = 0;
	clear_spr_texture = 0;
}


/*------------------------------------------------------------------------
	ȫƤΥץ饤Ȥ˥ꥢ
------------------------------------------------------------------------*/

void blit_clear_all_sprite(void)
{
	blit_clear_spr_sprite();
	blit_clear_fix_sprite();
}


/*------------------------------------------------------------------------
	FIXץ饤ȤΥꥢե饰Ƥ
------------------------------------------------------------------------*/

void blit_set_fix_clear_flag(void)
{
	clear_fix_texture = 1;
}


/*------------------------------------------------------------------------
	SPRץ饤ȤΥꥢե饰Ƥ
------------------------------------------------------------------------*/

void blit_set_spr_clear_flag(void)
{
	clear_spr_texture = 1;
}


/*------------------------------------------------------------------------
	ץ饤ȄIΥꥻå
------------------------------------------------------------------------*/

void blit_reset(void)
{
	int i;

	scrbitmap  = (UINT16 *)video_frame_addr(work_frame, 0, 0);
	tex_spr[0] = (UINT8 *)(scrbitmap + BUF_WIDTH * SCR_HEIGHT);
	tex_spr[1] = tex_spr[0] + BUF_WIDTH * TEXTURE_HEIGHT;
	tex_spr[2] = tex_spr[1] + BUF_WIDTH * TEXTURE_HEIGHT;
	tex_fix    = tex_spr[2] + BUF_WIDTH * TEXTURE_HEIGHT;

	for (i = 0; i < FIX_TEXTURE_SIZE; i++) fix_data[i].index = i;
	for (i = 0; i < SPR_TEXTURE_SIZE; i++) spr_data[i].index = i;

	clip_min_y = FIRST_VISIBLE_LINE;
	clip_max_y = LAST_VISIBLE_LINE;

	clut = (UINT16 *)PSP_UNCACHE_PTR(&video_palettebank[palette_bank]);

	blit_clear_all_sprite();
}


/*------------------------------------------------------------------------
	θ_ʼ
------------------------------------------------------------------------*/

void blit_start(int start, int end)
{
	clip_min_y = start;
	clip_max_y = end + 1;

	spr_num   = 0;
	spr_index = 0;

	if (start == FIRST_VISIBLE_LINE)
	{
		clut = (UINT16 *)PSP_UNCACHE_PTR(&video_palettebank[palette_bank]);

		fix_num = 0;
		spr_disable = 0;

		if (clear_spr_texture) blit_clear_spr_sprite();
		if (clear_fix_texture) blit_clear_fix_sprite();

		sceGuStart(GU_DIRECT, gulist);
		sceGuDrawBufferList(GU_PSM_5551, draw_frame, BUF_WIDTH);
		sceGuScissor(0, 0, BUF_WIDTH, SCR_WIDTH);
		sceGuClear(GU_COLOR_BUFFER_BIT | GU_FAST_CLEAR_BIT);

		sceGuDrawBufferList(GU_PSM_5551, work_frame, BUF_WIDTH);
		sceGuClear(GU_COLOR_BUFFER_BIT | GU_FAST_CLEAR_BIT);

		sceGuScissor(24, 16, 336, 240);
		sceGuClearColor(CNVCOL15TO32(video_palette[4095]));
		sceGuClear(GU_COLOR_BUFFER_BIT | GU_FAST_CLEAR_BIT);

		sceGuClearColor(0);
		sceGuEnable(GU_ALPHA_TEST);
		sceGuTexMode(GU_PSM_T8, 0, 0, GU_TRUE);
		sceGuTexFilter(GU_NEAREST, GU_NEAREST);

		sceGuFinish();
		sceGuSync(0, GU_SYNC_FINISH);
	}
}


/*------------------------------------------------------------------------
	θ½K
------------------------------------------------------------------------*/

void blit_finish(void)
{
	video_copy_rect(work_frame, draw_frame, &mvs_src_clip, &mvs_clip[option_stretch]);
}


/*------------------------------------------------------------------------
	FIX軭ꥹȤ˵h
------------------------------------------------------------------------*/

void blit_draw_fix(int x, int y, UINT32 code, UINT16 attr)
{
	s16 idx;
	struct Vertex *vertices;
	UINT32 key = MAKE_FIX_KEY(code, attr);

	if ((idx = fix_get_sprite(key)) < 0)
	{
		UINT32 col, tile;
		UINT8 *src, *dst, lines = 8;

		if (fix_texture_num == FIX_TEXTURE_SIZE - 1)
			fix_delete_sprite();

		idx = fix_insert_sprite(key);
		dst = SWIZZLED8_8x8(tex_fix, idx);
		src = &fix_memory[code << 5];
		col = color_table[attr];

		while (lines--)
		{
			tile = *(UINT32 *)(src + 0);
			*(UINT32 *)(dst +  0) = ((tile >> 0) & 0x0f0f0f0f) | col;
			*(UINT32 *)(dst +  4) = ((tile >> 4) & 0x0f0f0f0f) | col;
			src += 4;
			dst += 16;
		}
	}

	vertices = &vertices_fix[fix_num];
	fix_num += 2;

	vertices[0].x = vertices[1].x = x;
	vertices[0].y = vertices[1].y = y;
	vertices[0].u = vertices[1].u = (idx & 0x003f) << 3;
	vertices[0].v = vertices[1].v = (idx & 0x0fc0) >> 3;

	vertices[1].x += 8;
	vertices[1].y += 8;
	vertices[1].u += 8;
	vertices[1].v += 8;
}


/*------------------------------------------------------------------------
	FIX軭K
------------------------------------------------------------------------*/

void blit_finish_fix(void)
{
	struct Vertex *vertices;

	if (!fix_num) return;

	sceGuStart(GU_DIRECT, gulist);
	sceGuDrawBufferList(GU_PSM_5551, work_frame, BUF_WIDTH);
	sceGuScissor(24, 16, 336, 240);
	sceGuTexImage(0, 512, 512, BUF_WIDTH, tex_fix);
	sceGuClutLoad(256/8, clut);

	vertices = (struct Vertex *)sceGuGetMemory(fix_num * sizeof(struct Vertex));
	memcpy(vertices, vertices_fix, fix_num * sizeof(struct Vertex));
	sceGuDrawArray(GU_SPRITES, TEXTURE_FLAGS, fix_num, NULL, vertices);

	sceGuFinish();
	sceGuSync(0, GU_SYNC_FINISH);
}


/*------------------------------------------------------------------------
	SPR軭ꥹȤ˵h
------------------------------------------------------------------------*/

void blit_draw_spr(int x, int y, int w, int h, UINT32 code, UINT16 attr)
{
	s16 idx;
	struct Vertex *vertices;
	UINT32 key;

	if (spr_disable) return;

	key = MAKE_SPR_KEY(code, attr);

	if ((idx = spr_get_sprite(key)) < 0)
	{
		UINT32 col, tile;
		UINT8 *src, *dst, lines = 16;

		if (spr_texture_num == SPR_TEXTURE_SIZE - 1)
		{
			spr_delete_sprite();

			if (spr_texture_num == SPR_TEXTURE_SIZE - 1)
			{
				spr_disable = 1;
				return;
			}
		}

		idx = spr_insert_sprite(key);
		dst = SWIZZLED8_16x16(tex_spr[0], idx);
		src = &memory_region_gfx3[(*read_cache)(code << 7)];
		col = color_table[(attr >> 8) & 0x0f];

		while (lines--)
		{
			tile = *(UINT32 *)(src + 0);
			*(UINT32 *)(dst +  0) = ((tile >> 0) & 0x0f0f0f0f) | col;
			*(UINT32 *)(dst +  4) = ((tile >> 4) & 0x0f0f0f0f) | col;
			tile = *(UINT32 *)(src + 4);
			*(UINT32 *)(dst +  8) = ((tile >> 0) & 0x0f0f0f0f) | col;
			*(UINT32 *)(dst + 12) = ((tile >> 4) & 0x0f0f0f0f) | col;
			src += 8;
			dst += swizzle_table_8bit[lines];
		}
	}

	vertices = &vertices_spr[spr_num];
	spr_num += 2;

	spr_flags[spr_index] = (idx >> 10) | ((attr & 0xf000) >> 4);
	spr_index++;

	vertices[0].x = vertices[1].x = x;
	vertices[0].y = vertices[1].y = y;
	vertices[0].u = vertices[1].u = (idx & 0x001f) << 4;
	vertices[0].v = vertices[1].v = (idx & 0x03e0) >> 1;

	attr ^= 0x03;
	vertices[(attr & 0x01) >> 0].u += 16;
	vertices[(attr & 0x02) >> 1].v += 16;

	vertices[1].x += w;
	vertices[1].y += h;
}


/*------------------------------------------------------------------------
	SPR軭K
------------------------------------------------------------------------*/

void blit_finish_spr(void)
{
	int i, total_sprites = 0;
	UINT16 flags, *pflags = spr_flags;
	struct Vertex *vertices, *vertices_tmp;

	if (!spr_index) return;

	flags = *pflags;

	sceGuStart(GU_DIRECT, gulist);
	sceGuDrawBufferList(GU_PSM_5551, work_frame, BUF_WIDTH);
	sceGuScissor(24, clip_min_y, 336, clip_max_y);
	sceGuTexImage(0, 512, 512, BUF_WIDTH, tex_spr[flags & 3]);
	sceGuClutLoad(256/8, &clut[flags & 0xf00]);

	vertices_tmp = vertices = (struct Vertex *)sceGuGetMemory(spr_num * sizeof(struct Vertex));

	for (i = 0; i < spr_num; i += 2)
	{
		if (flags != *pflags)
		{
			if (total_sprites)
			{
				sceGuDrawArray(GU_SPRITES, TEXTURE_FLAGS, total_sprites, NULL, vertices);
				total_sprites = 0;
				vertices = vertices_tmp;
			}

			flags = *pflags;
			sceGuTexImage(0, 512, 512, BUF_WIDTH, tex_spr[flags & 3]);
			sceGuClutLoad(256/8, &clut[flags & 0xf00]);
		}

		vertices_tmp[0] = vertices_spr[i + 0];
		vertices_tmp[1] = vertices_spr[i + 1];

		vertices_tmp += 2;
		total_sprites += 2;
		pflags++;
	}

	if (total_sprites)
		sceGuDrawArray(GU_SPRITES, TEXTURE_FLAGS, total_sprites, NULL, vertices);

	sceGuFinish();
	sceGuSync(0, GU_SYNC_FINISH);
}


/******************************************************************************
	SPR եȥ軭
******************************************************************************/

static void drawgfxline_fixed(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom);
static void drawgfxline_fixed_flip(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom);
static void drawgfxline_zoom(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom);
static void drawgfxline_zoom_flip(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom);

static void drawgfxline_fixed_opaque(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom);
static void drawgfxline_fixed_flip_opaque(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom);
static void drawgfxline_zoom_opaque(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom);
static void drawgfxline_zoom_flip_opaque(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom);

static void ALIGN_DATA (*drawgfxline[8])(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom) =
{
	drawgfxline_zoom,					// 0000
	drawgfxline_zoom_flip,				// 0001
	drawgfxline_zoom_opaque,			// 0010
	drawgfxline_zoom_flip_opaque,		// 0011
	drawgfxline_fixed,					// 0100
	drawgfxline_fixed_flip,				// 0101
	drawgfxline_fixed_opaque,			// 0110
	drawgfxline_fixed_flip_opaque		// 0111
};


static const UINT8 zoom_x_tables[][16] =
{
	{ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
	{ 0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0 },
	{ 0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0 },
	{ 0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0 },
	{ 0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0 },
	{ 0,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0 },
	{ 0,0,1,0,1,0,1,0,1,0,0,0,1,0,1,0 },
	{ 0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0 },
	{ 1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0 },
	{ 1,0,1,0,1,0,1,0,1,1,1,0,1,0,1,0 },
	{ 1,0,1,1,1,0,1,0,1,1,1,0,1,0,1,0 },
	{ 1,0,1,1,1,0,1,0,1,1,1,0,1,0,1,1 },
	{ 1,0,1,1,1,0,1,1,1,1,1,0,1,0,1,1 },
	{ 1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1 },
	{ 1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1 },
	{ 1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1 },
//	{ 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 }
};

static void drawgfxline_zoom(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom)
{
	UINT32 tile;
	const UINT8 *zoom_x_table = zoom_x_tables[zoom];

	tile = src[0];
	if (zoom_x_table[ 0]) { if (tile & 0x0000000f) *dst = pal[(tile >>  0) & 0x0f]; dst++; }
	if (zoom_x_table[ 1]) { if (tile & 0x00000f00) *dst = pal[(tile >>  8) & 0x0f]; dst++; }
	if (zoom_x_table[ 2]) { if (tile & 0x000f0000) *dst = pal[(tile >> 16) & 0x0f]; dst++; }
	if (zoom_x_table[ 3]) { if (tile & 0x0f000000) *dst = pal[(tile >> 24) & 0x0f]; dst++; }
	if (zoom_x_table[ 4]) { if (tile & 0x000000f0) *dst = pal[(tile >>  4) & 0x0f]; dst++; }
	if (zoom_x_table[ 5]) { if (tile & 0x0000f000) *dst = pal[(tile >> 12) & 0x0f]; dst++; }
	if (zoom_x_table[ 6]) { if (tile & 0x00f00000) *dst = pal[(tile >> 20) & 0x0f]; dst++; }
	if (zoom_x_table[ 7]) { if (tile & 0xf0000000) *dst = pal[(tile >> 28) & 0x0f]; dst++; }

	tile = src[1];
	if (zoom_x_table[ 8]) { if (tile & 0x0000000f) *dst = pal[(tile >>  0) & 0x0f]; dst++; }
	if (zoom_x_table[ 9]) { if (tile & 0x00000f00) *dst = pal[(tile >>  8) & 0x0f]; dst++; }
	if (zoom_x_table[10]) { if (tile & 0x000f0000) *dst = pal[(tile >> 16) & 0x0f]; dst++; }
	if (zoom_x_table[11]) { if (tile & 0x0f000000) *dst = pal[(tile >> 24) & 0x0f]; dst++; }
	if (zoom_x_table[12]) { if (tile & 0x000000f0) *dst = pal[(tile >>  4) & 0x0f]; dst++; }
	if (zoom_x_table[13]) { if (tile & 0x0000f000) *dst = pal[(tile >> 12) & 0x0f]; dst++; }
	if (zoom_x_table[14]) { if (tile & 0x00f00000) *dst = pal[(tile >> 20) & 0x0f]; dst++; }
	if (zoom_x_table[15]) { if (tile & 0xf0000000) *dst = pal[(tile >> 28) & 0x0f]; }
}

static void drawgfxline_zoom_opaque(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom)
{
	UINT32 tile;
	const UINT8 *zoom_x_table = zoom_x_tables[zoom];

	tile = src[0];
	if (zoom_x_table[ 0]) { *dst = pal[(tile >>  0) & 0x0f]; dst++; }
	if (zoom_x_table[ 1]) { *dst = pal[(tile >>  8) & 0x0f]; dst++; }
	if (zoom_x_table[ 2]) { *dst = pal[(tile >> 16) & 0x0f]; dst++; }
	if (zoom_x_table[ 3]) { *dst = pal[(tile >> 24) & 0x0f]; dst++; }
	if (zoom_x_table[ 4]) { *dst = pal[(tile >>  4) & 0x0f]; dst++; }
	if (zoom_x_table[ 5]) { *dst = pal[(tile >> 12) & 0x0f]; dst++; }
	if (zoom_x_table[ 6]) { *dst = pal[(tile >> 20) & 0x0f]; dst++; }
	if (zoom_x_table[ 7]) { *dst = pal[(tile >> 28) & 0x0f]; dst++; }

	tile = src[1];
	if (zoom_x_table[ 8]) { *dst = pal[(tile >>  0) & 0x0f]; dst++; }
	if (zoom_x_table[ 9]) { *dst = pal[(tile >>  8) & 0x0f]; dst++; }
	if (zoom_x_table[10]) { *dst = pal[(tile >> 16) & 0x0f]; dst++; }
	if (zoom_x_table[11]) { *dst = pal[(tile >> 24) & 0x0f]; dst++; }
	if (zoom_x_table[12]) { *dst = pal[(tile >>  4) & 0x0f]; dst++; }
	if (zoom_x_table[13]) { *dst = pal[(tile >> 12) & 0x0f]; dst++; }
	if (zoom_x_table[14]) { *dst = pal[(tile >> 20) & 0x0f]; dst++; }
	if (zoom_x_table[15]) { *dst = pal[(tile >> 28) & 0x0f]; }
}

static void drawgfxline_zoom_flip(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom)
{
	UINT32 tile;
	const UINT8 *zoom_x_table = zoom_x_tables[zoom];

	tile = src[1];
	if (zoom_x_table[ 0]) { if (tile & 0xf0000000) *dst = pal[(tile >> 28) & 0x0f]; dst++; }
	if (zoom_x_table[ 1]) { if (tile & 0x00f00000) *dst = pal[(tile >> 20) & 0x0f]; dst++; }
	if (zoom_x_table[ 2]) { if (tile & 0x0000f000) *dst = pal[(tile >> 12) & 0x0f]; dst++; }
	if (zoom_x_table[ 3]) { if (tile & 0x000000f0) *dst = pal[(tile >>  4) & 0x0f]; dst++; }
	if (zoom_x_table[ 4]) { if (tile & 0x0f000000) *dst = pal[(tile >> 24) & 0x0f]; dst++; }
	if (zoom_x_table[ 5]) { if (tile & 0x000f0000) *dst = pal[(tile >> 16) & 0x0f]; dst++; }
	if (zoom_x_table[ 6]) { if (tile & 0x00000f00) *dst = pal[(tile >>  8) & 0x0f]; dst++; }
	if (zoom_x_table[ 7]) { if (tile & 0x0000000f) *dst = pal[(tile >>  0) & 0x0f]; dst++; }

	tile = src[0];
	if (zoom_x_table[ 8]) { if (tile & 0xf0000000) *dst = pal[(tile >> 28) & 0x0f]; dst++; }
	if (zoom_x_table[ 9]) { if (tile & 0x00f00000) *dst = pal[(tile >> 20) & 0x0f]; dst++; }
	if (zoom_x_table[10]) { if (tile & 0x0000f000) *dst = pal[(tile >> 12) & 0x0f]; dst++; }
	if (zoom_x_table[11]) { if (tile & 0x000000f0) *dst = pal[(tile >>  4) & 0x0f]; dst++; }
	if (zoom_x_table[12]) { if (tile & 0x0f000000) *dst = pal[(tile >> 24) & 0x0f]; dst++; }
	if (zoom_x_table[13]) { if (tile & 0x000f0000) *dst = pal[(tile >> 16) & 0x0f]; dst++; }
	if (zoom_x_table[14]) { if (tile & 0x00000f00) *dst = pal[(tile >>  8) & 0x0f]; dst++; }
	if (zoom_x_table[15]) { if (tile & 0x0000000f) *dst = pal[(tile >>  0) & 0x0f]; }
}

static void drawgfxline_zoom_flip_opaque(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom)
{
	UINT32 tile;
	const UINT8 *zoom_x_table = zoom_x_tables[zoom];

	tile = src[1];
	if (zoom_x_table[ 0]) { *dst = pal[(tile >> 28) & 0x0f]; dst++; }
	if (zoom_x_table[ 1]) { *dst = pal[(tile >> 20) & 0x0f]; dst++; }
	if (zoom_x_table[ 2]) { *dst = pal[(tile >> 12) & 0x0f]; dst++; }
	if (zoom_x_table[ 3]) { *dst = pal[(tile >>  4) & 0x0f]; dst++; }
	if (zoom_x_table[ 4]) { *dst = pal[(tile >> 24) & 0x0f]; dst++; }
	if (zoom_x_table[ 5]) { *dst = pal[(tile >> 16) & 0x0f]; dst++; }
	if (zoom_x_table[ 6]) { *dst = pal[(tile >>  8) & 0x0f]; dst++; }
	if (zoom_x_table[ 7]) { *dst = pal[(tile >>  0) & 0x0f]; dst++; }

	tile = src[0];
	if (zoom_x_table[ 8]) { *dst = pal[(tile >> 28) & 0x0f]; dst++; }
	if (zoom_x_table[ 9]) { *dst = pal[(tile >> 20) & 0x0f]; dst++; }
	if (zoom_x_table[10]) { *dst = pal[(tile >> 12) & 0x0f]; dst++; }
	if (zoom_x_table[11]) { *dst = pal[(tile >>  4) & 0x0f]; dst++; }
	if (zoom_x_table[12]) { *dst = pal[(tile >> 24) & 0x0f]; dst++; }
	if (zoom_x_table[13]) { *dst = pal[(tile >> 16) & 0x0f]; dst++; }
	if (zoom_x_table[14]) { *dst = pal[(tile >>  8) & 0x0f]; dst++; }
	if (zoom_x_table[15]) { *dst = pal[(tile >>  0) & 0x0f]; }
}

static void drawgfxline_fixed(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom)
{
	UINT32 tile;

	tile = src[0];
	if (tile)
	{
		if (tile & 0x000f) dst[ 0] = pal[(tile >>  0) & 0x0f];
		if (tile & 0x00f0) dst[ 4] = pal[(tile >>  4) & 0x0f];
		if (tile & 0x0f00) dst[ 1] = pal[(tile >>  8) & 0x0f];
		if (tile & 0xf000) dst[ 5] = pal[(tile >> 12) & 0x0f];
		tile >>= 16;
		if (tile & 0x000f) dst[ 2] = pal[(tile >>  0) & 0x0f];
		if (tile & 0x00f0) dst[ 6] = pal[(tile >>  4) & 0x0f];
		if (tile & 0x0f00) dst[ 3] = pal[(tile >>  8) & 0x0f];
		if (tile & 0xf000) dst[ 7] = pal[(tile >> 12) & 0x0f];
	}
	tile = src[1];
	if (tile)
	{
		if (tile & 0x000f) dst[ 8] = pal[(tile >>  0) & 0x0f];
		if (tile & 0x00f0) dst[12] = pal[(tile >>  4) & 0x0f];
		if (tile & 0x0f00) dst[ 9] = pal[(tile >>  8) & 0x0f];
		if (tile & 0xf000) dst[13] = pal[(tile >> 12) & 0x0f];
		tile >>= 16;
		if (tile & 0x000f) dst[10] = pal[(tile >>  0) & 0x0f];
		if (tile & 0x00f0) dst[14] = pal[(tile >>  4) & 0x0f];
		if (tile & 0x0f00) dst[11] = pal[(tile >>  8) & 0x0f];
		if (tile & 0xf000) dst[15] = pal[(tile >> 12) & 0x0f];
	}
}

static void drawgfxline_fixed_opaque(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom)
{
	UINT32 tile;

	tile = src[0];
	dst[ 0] = pal[(tile >>  0) & 0x0f];
	dst[ 4] = pal[(tile >>  4) & 0x0f];
	dst[ 1] = pal[(tile >>  8) & 0x0f];
	dst[ 5] = pal[(tile >> 12) & 0x0f];
	dst[ 2] = pal[(tile >> 16) & 0x0f];
	dst[ 6] = pal[(tile >> 20) & 0x0f];
	dst[ 3] = pal[(tile >> 24) & 0x0f];
	dst[ 7] = pal[(tile >> 28) & 0x0f];

	tile = src[1];
	dst[ 8] = pal[(tile >>  0) & 0x0f];
	dst[12] = pal[(tile >>  4) & 0x0f];
	dst[ 9] = pal[(tile >>  8) & 0x0f];
	dst[13] = pal[(tile >> 12) & 0x0f];
	dst[10] = pal[(tile >> 16) & 0x0f];
	dst[14] = pal[(tile >> 20) & 0x0f];
	dst[11] = pal[(tile >> 24) & 0x0f];
	dst[15] = pal[(tile >> 28) & 0x0f];
}

static void drawgfxline_fixed_flip(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom)
{
	UINT32 tile;

	tile = src[0];
	if (tile)
	{
		if (tile & 0x000f) dst[15] = pal[(tile >>  0) & 0x0f];
		if (tile & 0x00f0) dst[11] = pal[(tile >>  4) & 0x0f];
		if (tile & 0x0f00) dst[14] = pal[(tile >>  8) & 0x0f];
		if (tile & 0xf000) dst[10] = pal[(tile >> 12) & 0x0f];
		tile >>= 16;
		if (tile & 0x000f) dst[13] = pal[(tile >>  0) & 0x0f];
		if (tile & 0x00f0) dst[ 9] = pal[(tile >>  4) & 0x0f];
		if (tile & 0x0f00) dst[12] = pal[(tile >>  8) & 0x0f];
		if (tile & 0xf000) dst[ 8] = pal[(tile >> 12) & 0x0f];
	}
	tile = src[1];
	if (tile)
	{
		if (tile & 0x000f) dst[ 7] = pal[(tile >>  0) & 0x0f];
		if (tile & 0x00f0) dst[ 3] = pal[(tile >>  4) & 0x0f];
		if (tile & 0x0f00) dst[ 6] = pal[(tile >>  8) & 0x0f];
		if (tile & 0xf000) dst[ 2] = pal[(tile >> 12) & 0x0f];
		tile >>= 16;
		if (tile & 0x000f) dst[ 5] = pal[(tile >>  0) & 0x0f];
		if (tile & 0x00f0) dst[ 1] = pal[(tile >>  4) & 0x0f];
		if (tile & 0x0f00) dst[ 4] = pal[(tile >>  8) & 0x0f];
		if (tile & 0xf000) dst[ 0] = pal[(tile >> 12) & 0x0f];
	}
}

static void drawgfxline_fixed_flip_opaque(UINT32 *src, UINT16 *dst, UINT16 *pal, int zoom)
{
	UINT32 tile;

	tile = src[1];
	dst[ 0] = pal[(tile >> 28) & 0x0f];
	dst[ 1] = pal[(tile >> 20) & 0x0f];
	dst[ 2] = pal[(tile >> 12) & 0x0f];
	dst[ 3] = pal[(tile >>  4) & 0x0f];
	dst[ 4] = pal[(tile >> 24) & 0x0f];
	dst[ 5] = pal[(tile >> 16) & 0x0f];
	dst[ 6] = pal[(tile >>  8) & 0x0f];
	dst[ 7] = pal[(tile >>  0) & 0x0f];

	tile = src[0];
	dst[ 8] = pal[(tile >> 28) & 0x0f];
	dst[ 9] = pal[(tile >> 20) & 0x0f];
	dst[10] = pal[(tile >> 12) & 0x0f];
	dst[11] = pal[(tile >>  4) & 0x0f];
	dst[12] = pal[(tile >> 24) & 0x0f];
	dst[13] = pal[(tile >> 16) & 0x0f];
	dst[14] = pal[(tile >>  8) & 0x0f];
	dst[15] = pal[(tile >>  0) & 0x0f];
}

void blit_draw_spr_line(int x, int y, int zoom_x, int sprite_y, UINT32 code, UINT16 attr, UINT8 opaque)
{
	UINT32 src = (*read_cache)(code << 7);
	UINT32 dst = (y << 9) + x;
	UINT8 flag = (attr & 1) | (opaque & SPRITE_OPAQUE) | ((zoom_x & 0x10) >> 2);

	if (attr & 0x0002) sprite_y ^= 0x0f;
	src += sprite_y << 3;

	(*drawgfxline[flag])((UINT32 *)&memory_region_gfx3[src], &scrbitmap[dst], &video_palette[(attr >> 8) << 4], zoom_x);
}
