# Implementation of patching check for booting writable locations, and booting from HDD path:
# https://github.com/ps2dev/ps2sdk/blob/8b7579979db87ace4b0aa5693a8a560d15224a96/ee/sbv/src/patch_disable_prefix_check.c#L24

.set noreorder # If we're writing assembly, why would we want this?

#include "include/addresses.S"

.globl _start
_start:

# Patch MODLOAD to allow HDD ELF loading
    addu $a0, $ra, 4 * 7 # dma
    li $v1, 0x77
    syscall # SifSetDma

# Boot from HDD
    addu $a0, $ra, 4 * 13 # bootPath
    li $a1, 0
    li $v1, 6
    syscall # LoadExecPS2

# Data

dma:
#typedef struct t_SifDmaTransfer {
#   void    *src;
#   void    *dest;
#   int size;
#   int attr;
#} SifDmaTransfer_t;
.word 0xCD7B70 + ((44 + 4) / 8) * 0x240 + 0x30 # src - sbv_patch_disable_prefix_check
.word IOP_MODLOAD_EXPORT_15 # dest - modload export 15
.word 16 # size
.word 0 # attr

.globl sbv_patch_disable_prefix_check
.balign 16
sbv_patch_disable_prefix_check:
    jr $ra
    addiu $v0, $0, 0

.globl bootPath
bootPath:
    .asciiz "hdd:\\U.ELF"
