#pragma once

#define MODELINDICES \
	X("fire_hydrant",	MI_FIRE_HYDRANT) \
	X("bagelstnd02",	MI_BAGELSTAND2) \
	X("fish01",		MI_FISHSTALL01) \
	X("fishstall02",	MI_FISHSTALL02) \
	X("fishstall03",	MI_FISHSTALL03) \
	X("fishstall04",	MI_FISHSTALL04) \
	X("taxisign",		MI_TAXISIGN) \
	X("phonesign",		MI_PHONESIGN) \
	X("noparkingsign1",	MI_NOPARKINGSIGN1) \
	X("bussign1",		MI_BUSSIGN1) \
	X("roadworkbarrier1",	MI_ROADWORKBARRIER1) \
	X("dump1",		MI_DUMP1) \
	X("trafficcone",	MI_TRAFFICCONE) \
	X("newsstand1",		MI_NEWSSTAND) \
	X("postbox1",		MI_POSTBOX1) \
	X("bin1",		MI_BIN) \
	X("wastebin",		MI_WASTEBIN) \
	X("phonebooth1",	MI_PHONEBOOTH1) \
	X("parkingmeter",	MI_PARKINGMETER) \
	X("trafficlight1",	MI_TRAFFICLIGHTS) \
	X("lamppost1",		MI_SINGLESTREETLIGHTS1) \
	X("lamppost2",		MI_SINGLESTREETLIGHTS2) \
	X("lamppost3",		MI_SINGLESTREETLIGHTS3) \
	X("doublestreetlght1",	MI_DOUBLESTREETLIGHTS) \
	X("rd_Road2A10",	MI_ROADSFORROADBLOCKSSTART) \
	X("rd_Road1A30",	MI_ROADSFORROADBLOCKSEND) \
	X("veg_tree1",		MI_TREE1) \
	X("veg_tree3",		MI_TREE2) \
	X("veg_treea1",		MI_TREE3) \
	X("veg_treenew01",	MI_TREE4) \
	X("veg_treenew05",	MI_TREE5) \
	X("veg_treeb1",		MI_TREE6) \
	X("veg_treenew10",	MI_TREE7) \
	X("veg_treea3",		MI_TREE8) \
	X("veg_treenew09",	MI_TREE9) \
	X("veg_treenew08",	MI_TREE10) \
	X("veg_treenew03",	MI_TREE11) \
	X("veg_treenew16",	MI_TREE12) \
	X("veg_treenew17",	MI_TREE13) \
	X("veg_treenew06",	MI_TREE14) \
	X("doc_crane_cab",	MODELID_CRANE_1) \
	X("cranetopb",		MODELID_CRANE_2) \
	X("cranetopa",		MODELID_CRANE_3) \
	X("package1",		MI_COLLECTABLE1) \
	X("Money",		MI_MONEY) \
	X("barrel1",		MI_CARMINE) \
	X("oddjgaragdoor",	MI_GARAGEDOOR1) \
	X("bombdoor",		MI_GARAGEDOOR2) \
	X("door_bombshop",	MI_GARAGEDOOR3) \
	X("vheistlocdoor",	MI_GARAGEDOOR4) \
	X("door2_garage",	MI_GARAGEDOOR5) \
	X("ind_slidedoor",	MI_GARAGEDOOR6) \
	X("bankjobdoor",	MI_GARAGEDOOR7) \
	X("door_jmsgrage",	MI_GARAGEDOOR9) \
	X("jamesgrge_kb",	MI_GARAGEDOOR10) \
	X("door_sfehousegrge",	MI_GARAGEDOOR11) \
	X("shedgaragedoor",	MI_GARAGEDOOR12) \
	X("door4_garage",	MI_GARAGEDOOR13) \
	X("door_col_compnd_01",	MI_GARAGEDOOR14) \
	X("door_col_compnd_02",	MI_GARAGEDOOR15) \
	X("door_col_compnd_03",	MI_GARAGEDOOR16) \
	X("door_col_compnd_04",	MI_GARAGEDOOR17) \
	X("door_col_compnd_05",	MI_GARAGEDOOR18) \
	X("impex_door",		MI_GARAGEDOOR19) \
	X("SalvGarage",		MI_GARAGEDOOR20) \
	X("door3_garage",	MI_GARAGEDOOR21) \
	X("leveldoor2",		MI_GARAGEDOOR22) \
	X("double_garage_dr",	MI_GARAGEDOOR23) \
	X("amcogaragedoor",	MI_GARAGEDOOR24) \
	X("towergaragedoor1",	MI_GARAGEDOOR25) \
	X("towergaragedoor2",	MI_GARAGEDOOR26) \
	X("towergaragedoor3",	MI_GARAGEDOOR27) \
	X("plysve_gragedoor",	MI_GARAGEDOOR28) \
	X("impexpsubgrgdoor",	MI_GARAGEDOOR29) \
	X("Sub_sprayshopdoor",	MI_GARAGEDOOR30) \
	X("ind_plyrwoor",	MI_GARAGEDOOR31) \
	X("8ballsuburbandoor",	MI_GARAGEDOOR32) \
	X("barrel2",		MI_NAUTICALMINE) \
	X("crushercrush",	MI_CRUSHERBODY) \
	X("crushertop",		MI_CRUSHERLID) \
	X("donkeymag",		MI_DONKEYMAG) \
	X("bullion",		MI_BULLION) \
	X("floatpackge1",	MI_FLOATPACKAGE1) \
	X("briefcase",		MI_BRIEFCASE) \
	X("chinabanner1",	MI_CHINABANNER1) \
	X("chinabanner2",	MI_CHINABANNER2) \
	X("chinabanner3",	MI_CHINABANNER3) \
	X("chinabanner4",	MI_CHINABANNER4) \
	X("iten_chinatown5",	MI_CHINABANNER5) \
	X("iten_chinatown7",	MI_CHINABANNER6) \
	X("iten_chinatown3",	MI_CHINABANNER7) \
	X("iten_chinatown2",	MI_CHINABANNER8) \
	X("iten_chinatown4",	MI_CHINABANNER9) \
	X("iten_washline01",	MI_CHINABANNER10) \
	X("iten_washline02",	MI_CHINABANNER11) \
	X("iten_washline03",	MI_CHINABANNER12) \
	X("chinalanterns",	MI_CHINALANTERN) \
	X("glassfx1",		MI_GLASS1) \
	X("glassfx2",		MI_GLASS2) \
	X("glassfx3",		MI_GLASS3) \
	X("glassfx4",		MI_GLASS4) \
	X("glassfx55",		MI_GLASS5) \
	X("glassfxsub1",	MI_GLASS6) \
	X("glassfxsub2",	MI_GLASS7) \
	X("glassfx_composh",	MI_GLASS8) \
	X("bridge_liftsec",	MI_BRIDGELIFT) \
	X("bridge_liftweight",	MI_BRIDGEWEIGHT) \
	X("subbridge_lift",	MI_BRIDGEROADSEGMENT) \
	X("barrel4",		MI_EXPLODINGBARREL) \
	X("flagsitaly",		MI_ITALYBANNER1) \
	X("adrenaline",		MI_PICKUP_ADRENALINE) \
	X("bodyarmour",		MI_PICKUP_BODYARMOUR) \
	X("info",		MI_PICKUP_INFO) \
	X("health",		MI_PICKUP_HEALTH) \
	X("bonus",		MI_PICKUP_BONUS) \
	X("bribe",		MI_PICKUP_BRIBE) \
	X("killfrenzy",		MI_PICKUP_KILLFRENZY) \
	X("camerapickup",	MI_PICKUP_CAMERA) \
	X("bollardlight",	MI_BOLLARDLIGHT) \
	X("magnet",		MI_MAGNET) \
	X("streetlamp1",	MI_STREETLAMP1) \
	X("streetlamp2",	MI_STREETLAMP2) \
	X("railtrax_lo4b",	MI_RAILTRACKS) \
	X("bar_barrier10",	MI_FENCE) \
	X("bar_barrier12",	MI_FENCE2) \
	X("petrolpump",		MI_PETROLPUMP) \
	X("bodycast",		MI_BODYCAST) \
	X("backdoor",		MI_BACKDOOR) \
	X("coffee",		MI_COFFEE) \
	X("bouy",		MI_BUOY) \
	X("parktable1",		MI_PARKTABLE) \
	X("sbwy_tunl_start",	MI_SUBWAY1) \
	X("sbwy_tunl_bit",	MI_SUBWAY2) \
	X("sbwy_tunl_bend",	MI_SUBWAY3) \
	X("sbwy_tunl_cstm6",	MI_SUBWAY4) \
	X("sbwy_tunl_cstm7",	MI_SUBWAY5) \
	X("sbwy_tunl_cstm8",	MI_SUBWAY6) \
	X("sbwy_tunl_cstm10",	MI_SUBWAY7) \
	X("sbwy_tunl_cstm9",	MI_SUBWAY8) \
	X("sbwy_tunl_cstm11",	MI_SUBWAY9) \
	X("sbwy_tunl_cstm1",	MI_SUBWAY10) \
	X("sbwy_tunl_cstm2",	MI_SUBWAY11) \
	X("sbwy_tunl_cstm4",	MI_SUBWAY12) \
	X("sbwy_tunl_cstm3",	MI_SUBWAY13) \
	X("sbwy_tunl_cstm5",	MI_SUBWAY14) \
	X("subplatform_n2",	MI_SUBWAY15) \
	X("suby_tunl_start",	MI_SUBWAY16) \
	X("sbwy_tunl_start2",	MI_SUBWAY17) \
	X("indy_tunl_start",	MI_SUBWAY18) \
	X("indsubway03",	MI_SUBPLATFORM_IND) \
	X("comerside_subway",	MI_SUBPLATFORM_COMS) \
	X("subplatform",	MI_SUBPLATFORM_COMS2) \
	X("subplatform_n",	MI_SUBPLATFORM_COMN) \
	X("Otherside_subway",	MI_SUBPLATFORM_SUB) \
	X("subplatform_sub",	MI_SUBPLATFORM_SUB2) \
	X("files",		MI_FILES)

#define X(name, var) extern int16 var;
	MODELINDICES
#undef X

// and some hardcoded ones
// expand as needed
enum
{
	MI_PLAYER = 0,
	MI_COP,
	MI_SWAT,
	MI_FBI,
	MI_ARMY,
	MI_MEDIC,
	MI_FIREMAN,
	MI_MALE01,
	MI_TAXI_D,
	MI_PIMP,
	MI_GANG01,
	MI_GANG02,
	MI_GANG03,
	MI_GANG04,
	MI_GANG05,
	MI_GANG06,
	MI_GANG07,
	MI_GANG08,
	MI_GANG09,
	MI_GANG10,
	MI_GANG11,
	MI_GANG12,
	MI_GANG13,
	MI_GANG14,
	MI_CRIMINAL01,
	MI_CRIMINAL02,
	MI_SPECIAL01,
	MI_SPECIAL02,
	MI_SPECIAL03,
	MI_SPECIAL04,
	MI_MALE02,
	MI_MALE03,
	MI_FATMALE01,
	MI_FATMALE02,
	MI_FEMALE01,
	MI_FEMALE02,
	MI_FEMALE03,
	MI_FATFEMALE01,
	MI_FATFEMALE02,
	MI_PROSTITUTE,
	MI_PROSTITUTE2,
	MI_P_MAN1,
	MI_P_MAN2,
	MI_P_WOM1,
	MI_P_WOM2,
	MI_CT_MAN1,
	MI_CT_MAN2,
	MI_CT_WOM1,
	MI_CT_WOM2,
	MI_LI_MAN1,
	MI_LI_MAN2,
	MI_LI_WOM1,
	MI_LI_WOM2,
	MI_DOCKER1,
	MI_DOCKER2,
	MI_SCUM_MAN,
	MI_SCUM_WOM,
	MI_WORKER1,
	MI_WORKER2,
	MI_B_MAN1,
	MI_B_MAN2,
	MI_B_MAN3,
	MI_B_WOM1,
	MI_B_WOM2,
	MI_B_WOM3,
	MI_MOD_MAN,
	MI_MOD_WOM,
	MI_ST_MAN,
	MI_ST_WOM,
	MI_FAN_MAN1,
	MI_FAN_MAN2,
	MI_FAN_WOM,
	MI_HOS_MAN,
	MI_HOS_WOM,
	MI_CONST1,
	MI_CONST2,
	MI_SHOPPER1,
	MI_SHOPPER2,
	MI_SHOPPER3,
	MI_STUD_MAN,
	MI_STUD_WOM,
	MI_CAS_MAN,
	MI_CAS_WOM,
	MI_BUSKER1,
	MI_BUSKER2,
	MI_BUSKER3,
	MI_BUSKER4,
	// three more peds possible

	MI_LAST_PED = 89,
	MI_FIRST_VEHICLE,

	MI_LANDSTAL = MI_FIRST_VEHICLE,
	MI_IDAHO,
	MI_STINGER,
	MI_LINERUN,
	MI_PEREN,
	MI_SENTINEL,
	MI_PATRIOT,
	MI_FIRETRUCK,
	MI_TRASH,
	MI_STRETCH,
	MI_MANANA,
	MI_INFERNUS,
	MI_BLISTA,
	MI_PONY,
	MI_MULE,
	MI_CHEETAH,
	MI_AMBULAN,
	MI_FBICAR,
	MI_MOONBEAM,
	MI_ESPERANT,
	MI_TAXI,
	MI_KURUMA,
	MI_BOBCAT,
	MI_MRWHOOP,
	MI_BFINJECT,
	MI_CORPSE,
	MI_POLICE,
	MI_ENFORCER,
	MI_SECURICA,
	MI_BANSHEE,
	MI_PREDATOR,
	MI_BUS,
	MI_RHINO,
	MI_BARRACKS,
	MI_TRAIN,
	MI_CHOPPER,
	MI_DODO,
	MI_COACH,
	MI_CABBIE,
	MI_STALLION,
	MI_RUMPO,
	MI_RCBANDIT,
	MI_BELLYUP,
	MI_MRWONGS,
	MI_MAFIA,
	MI_YARDIE,
	MI_YAKUZA,
	MI_DIABLOS,
	MI_COLUMB ,
	MI_HOODS,
	MI_AIRTRAIN,
	MI_DEADDODO,
	MI_SPEEDER,
	MI_REEFER,
	MI_PANLANT,
	MI_FLATBED,
	MI_YANKEE,
	MI_ESCAPE,
	MI_BORGNINE,
	MI_TOYZ,
	MI_GHOST,

	// leftovers on PC
	MI_MIAMI_RCBARON = 154,
	MI_MIAMI_RCRAIDER = 155,
	MI_MIAMI_SPARROW = 159,

	MI_GRENADE = 170,
	MI_AK47,
	MI_BASEBALL_BAT,
	MI_COLT,
	MI_MOLOTOV,
	MI_ROCKETLAUNCHER,
	MI_SHOTGUN,
	MI_SNIPER,
	MI_UZI,
	MI_MISSILE,
	MI_M16,
	MI_FLAMETHROWER,
	MI_BOMB,
	MI_FINGERS,

	MI_CUTOBJ01 = 185,
	MI_CUTOBJ02,
	MI_CUTOBJ03,
	MI_CUTOBJ04,
	MI_CUTOBJ05,

	MI_CAR_DOOR = 190,
	MI_CAR_BUMPER,
	MI_CAR_PANEL,
	MI_CAR_BONNET,
	MI_CAR_BOOT,
	MI_CAR_WHEEL,
	MI_BODYPARTA,
	MI_BODYPARTB,

	MI_AIRTRAIN_VLO = 198,
	MI_LOPOLYGUY,

	NUM_DEFAULT_MODELS
};

enum{
	NUM_OF_SPECIAL_CHARS = 4,
	NUM_OF_CUTSCENE_OBJECTS = 5
};

void InitModelIndices(void);
void MatchModelString(const char *name, int16 id);
void TestModelIndices(void);

inline bool
IsGlass(int16 id)
{
	return id == MI_GLASS1 ||
		id == MI_GLASS2 ||
		id == MI_GLASS3 ||
		id == MI_GLASS4 ||
		id == MI_GLASS5 ||
		id == MI_GLASS6 ||
		id == MI_GLASS7 ||
		id == MI_GLASS8;
}

inline bool
IsStreetLight(int16 id)
{
	return id == MI_TRAFFICLIGHTS ||
		id == MI_SINGLESTREETLIGHTS1 ||
		id == MI_SINGLESTREETLIGHTS2 ||
		id == MI_SINGLESTREETLIGHTS3 ||
		id == MI_DOUBLESTREETLIGHTS;
}

inline bool
IsBodyPart(int16 id)
{
	return id == MI_BODYPARTA || id == MI_BODYPARTB;
}

// This is bad and should perhaps not be used
inline bool
IsBoatModel(int16 id)
{
	return id == MI_PREDATOR ||
		id == MI_REEFER ||
		id == MI_SPEEDER ||
		id == MI_GHOST;
}

inline bool
IsPedModel(int16 id)
{
	return id >= MI_PLAYER && id <= MI_LAST_PED;
}

inline bool
IsTreeModel(int16 id)
{
	return id == MI_TREE1 ||
		id == MI_TREE2 ||
		id == MI_TREE3 ||
		id == MI_TREE4 ||
		id == MI_TREE5 ||
		id == MI_TREE6 ||
		id == MI_TREE7 ||
		id == MI_TREE8 ||
		id == MI_TREE9 ||
		id == MI_TREE10 ||
		id == MI_TREE11 ||
		id == MI_TREE12 ||
		id == MI_TREE13 ||
		id == MI_TREE14;
}

inline bool
IsBannerModel(int16 id)
{
	return id == MI_CHINABANNER1 ||
		id == MI_CHINABANNER2 ||
		id == MI_CHINABANNER3 ||
		id == MI_CHINABANNER4 ||
		id == MI_CHINABANNER5 ||
		id == MI_CHINABANNER6 ||
		id == MI_CHINABANNER7 ||
		id == MI_CHINABANNER8 ||
		id == MI_CHINABANNER9 ||
		id == MI_CHINABANNER10 ||
		id == MI_CHINABANNER11 ||
		id == MI_CHINABANNER12 ||
		id == MI_ITALYBANNER1 ||
		id == MI_CHINALANTERN;
}
inline bool
IsPickupModel(int16 id)
{
	return id == MI_GRENADE ||
		id == MI_AK47 ||
		id == MI_BASEBALL_BAT ||
		id == MI_COLT ||
		id == MI_MOLOTOV ||
		id == MI_ROCKETLAUNCHER ||
		id == MI_SHOTGUN ||
		id == MI_SNIPER ||
		id == MI_UZI ||
		id == MI_M16 ||
		id == MI_FLAMETHROWER ||
		id == MI_PICKUP_ADRENALINE ||
		id == MI_PICKUP_BODYARMOUR ||
		id == MI_PICKUP_INFO ||
		id == MI_PICKUP_HEALTH ||
		id == MI_PICKUP_BONUS ||
		id == MI_PICKUP_BRIBE ||
		id == MI_PICKUP_KILLFRENZY ||
		id == MI_PICKUP_CAMERA;
}

inline bool
IsPolicePedModel(int16 id)
{
	return id == MI_COP ||
		id == MI_SWAT ||
		id == MI_FBI ||
		id == MI_ARMY;
}

inline bool
IsPoliceVehicleModel(int16 id)
{
	return id == MI_CHOPPER ||
		id == MI_PREDATOR ||
		id == MI_POLICE ||
		id == MI_ENFORCER;
}

inline bool
IsExplosiveThingModel(int16 id)
{
	return id == MI_EXPLODINGBARREL ||
		id == MI_PETROLPUMP;
}

inline bool 
IsFence(int16 id)
{
	return id == MI_FENCE ||
		id == MI_FENCE2;
}