/*
 * =======================================================================
 *
 * Prototypes for every function in the game.so.
 *
 * =======================================================================
 */

extern void ReadLevel ( const char * filename ) ;
extern void ReadLevelLocals ( FILE * f ) ;
extern void ReadEdict ( FILE * f , edict_t * ent ) ;
extern void WriteLevel ( const char * filename ) ;
extern void WriteLevelLocals ( FILE * f ) ;
extern void WriteEdict ( FILE * f , edict_t * ent ) ;
extern void ReadGame ( const char * filename ) ;
extern void WriteGame ( const char * filename , qboolean autosave ) ;
extern void ReadClient ( FILE * f , gclient_t * client , short save_ver ) ;
extern void WriteClient ( FILE * f , gclient_t * client ) ;
extern void ReadField ( FILE * f , field_t * field , byte * base ) ;
extern void WriteField2 ( FILE * f , field_t * field , byte * base ) ;
extern void WriteField1 ( FILE * f , field_t * field , byte * base ) ;
extern mmove_t * FindMmoveByName ( char * name ) ;
extern mmoveList_t * GetMmoveByAddress ( mmove_t * adr ) ;
extern byte * FindFunctionByName ( char * name ) ;
extern functionList_t * GetFunctionByAddress ( byte * adr ) ;
extern void InitGame ( void ) ;
extern void Info_SetValueForKey ( char * s , char * key , char * value ) ;
extern qboolean Info_Validate ( char * s ) ;
extern void Info_RemoveKey ( char * s , char * key ) ;
extern char * Info_ValueForKey ( char * s , char * key ) ;
extern void Com_sprintf ( char * dest , int size , char * fmt , ... ) ;
extern int Q_strcasecmp ( char * s1 , char * s2 ) ;
extern int Q_strncasecmp ( char * s1 , char * s2 , int n ) ;
extern int Q_stricmp ( const char * s1 , const char * s2 ) ;
extern void Com_PageInMemory ( byte * buffer , int size ) ;
extern char * COM_Parse ( char * * data_p ) ;
extern char * va ( char * format , ... ) ;
extern void Swap_Init ( void ) ;
extern float FloatNoSwap ( float f ) ;
extern float FloatSwap ( float f ) ;
extern int LongNoSwap ( int l ) ;
extern int LongSwap ( int l ) ;
extern short ShortNoSwap ( short l ) ;
extern short ShortSwap ( short l ) ;
extern float LittleFloat ( float l ) ;
extern float BigFloat ( float l ) ;
extern int LittleLong ( int l ) ;
extern int BigLong ( int l ) ;
extern short LittleShort ( short l ) ;
extern short BigShort ( short l ) ;
extern void COM_DefaultExtension ( char * path , const char * extension ) ;
extern void COM_FilePath ( const char * in , char * out ) ;
extern void COM_FileBase ( char * in , char * out ) ;
extern const char * COM_FileExtension ( const char * in ) ;
extern void COM_StripExtension ( char * in , char * out ) ;
extern char * COM_SkipPath ( char * pathname ) ;
extern int Q_log2 ( int val ) ;
extern void VectorScale ( vec3_t in , vec_t scale , vec3_t out ) ;
extern void VectorInverse ( vec3_t v ) ;
extern vec_t VectorLength ( vec3_t v ) ;
extern void CrossProduct ( vec3_t v1 , vec3_t v2 , vec3_t cross ) ;
extern void _VectorCopy ( vec3_t in , vec3_t out ) ;
extern void _VectorAdd ( vec3_t veca , vec3_t vecb , vec3_t out ) ;
extern void _VectorSubtract ( vec3_t veca , vec3_t vecb , vec3_t out ) ;
extern vec_t _DotProduct ( vec3_t v1 , vec3_t v2 ) ;
extern void VectorMA ( vec3_t veca , float scale , vec3_t vecb , vec3_t vecc ) ;
extern vec_t VectorNormalize2 ( vec3_t v , vec3_t out ) ;
extern vec_t VectorNormalize ( vec3_t v ) ;
extern int VectorCompare ( vec3_t v1 , vec3_t v2 ) ;
extern void AddPointToBounds ( vec3_t v , vec3_t mins , vec3_t maxs ) ;
extern void ClearBounds ( vec3_t mins , vec3_t maxs ) ;
extern int BoxOnPlaneSide2 ( vec3_t emins , vec3_t emaxs , struct cplane_s * p ) ;
extern float anglemod ( float a ) ;
extern float LerpAngle ( float a2 , float a1 , float frac ) ;
extern float Q_fabs ( float f ) ;
extern void R_ConcatTransforms ( float in1 [ 3 ] [ 4 ] , float in2 [ 3 ] [ 4 ] , float out [ 3 ] [ 4 ] ) ;
extern void R_ConcatRotations ( float in1 [ 3 ] [ 3 ] , float in2 [ 3 ] [ 3 ] , float out [ 3 ] [ 3 ] ) ;
extern void PerpendicularVector ( vec3_t dst , const vec3_t src ) ;
extern void ProjectPointOnPlane ( vec3_t dst , const vec3_t p , const vec3_t normal ) ;
extern void AngleVectors ( vec3_t angles , vec3_t forward , vec3_t right , vec3_t up ) ;
extern void RotatePointAroundVector ( vec3_t dst , const vec3_t dir , const vec3_t point , float degrees ) ;
extern void Weapon_Heatbeam ( edict_t * ent ) ;
extern void Heatbeam_Fire ( edict_t * ent ) ;
extern void Weapon_ETF_Rifle ( edict_t * ent ) ;
extern void weapon_etf_rifle_fire ( edict_t * ent ) ;
extern void Weapon_Disintegrator ( edict_t * ent ) ;
extern void weapon_tracker_fire ( edict_t * self ) ;
extern void Weapon_ChainFist ( edict_t * ent ) ;
extern void chainfist_smoke ( edict_t * ent ) ;
extern void weapon_chainfist_fire ( edict_t * ent ) ;
extern void Weapon_BFG ( edict_t * ent ) ;
extern void weapon_bfg_fire ( edict_t * ent ) ;
extern void Weapon_Railgun ( edict_t * ent ) ;
extern void weapon_railgun_fire ( edict_t * ent ) ;
extern void Weapon_SuperShotgun ( edict_t * ent ) ;
extern void weapon_supershotgun_fire ( edict_t * ent ) ;
extern void Weapon_Shotgun ( edict_t * ent ) ;
extern void weapon_shotgun_fire ( edict_t * ent ) ;
extern void Weapon_Chaingun ( edict_t * ent ) ;
extern void Chaingun_Fire ( edict_t * ent ) ;
extern void Weapon_Machinegun ( edict_t * ent ) ;
extern void Machinegun_Fire ( edict_t * ent ) ;
extern void Weapon_HyperBlaster ( edict_t * ent ) ;
extern void Weapon_HyperBlaster_Fire ( edict_t * ent ) ;
extern void Weapon_Blaster ( edict_t * ent ) ;
extern void Weapon_Blaster_Fire ( edict_t * ent ) ;
extern void Blaster_Fire ( edict_t * ent , vec3_t g_offset , int damage , qboolean hyper , int effect ) ;
extern void Weapon_RocketLauncher ( edict_t * ent ) ;
extern void Weapon_RocketLauncher_Fire ( edict_t * ent ) ;
extern void Weapon_ProxLauncher ( edict_t * ent ) ;
extern void Weapon_GrenadeLauncher ( edict_t * ent ) ;
extern void weapon_grenadelauncher_fire ( edict_t * ent ) ;
extern void Weapon_Tesla ( edict_t * ent ) ;
extern void Weapon_Grenade ( edict_t * ent ) ;
extern void Throw_Generic ( edict_t * ent , int FRAME_FIRE_LAST , int FRAME_IDLE_LAST , int FRAME_THROW_SOUND , int FRAME_THROW_HOLD , int FRAME_THROW_FIRE , int * pause_frames , int EXPLODE , void ( * fire ) ( edict_t * ent , qboolean held ) ) ;
extern void weapon_grenade_fire ( edict_t * ent , qboolean held ) ;
extern void Weapon_Generic ( edict_t * ent , int FRAME_ACTIVATE_LAST , int FRAME_FIRE_LAST , int FRAME_IDLE_LAST , int FRAME_DEACTIVATE_LAST , int * pause_frames , int * fire_frames , void ( * fire ) ( edict_t * ent ) ) ;
extern void Drop_Weapon ( edict_t * ent , gitem_t * item ) ;
extern void Use_Weapon ( edict_t * ent , gitem_t * item ) ;
extern void Think_Weapon ( edict_t * ent ) ;
extern void NoAmmoWeaponChange ( edict_t * ent ) ;
extern void ChangeWeapon ( edict_t * ent ) ;
extern qboolean Pickup_Weapon ( edict_t * ent , edict_t * other ) ;
extern void PlayerNoise ( edict_t * who , vec3_t where , int type ) ;
extern void P_ProjectSource2 ( gclient_t * client , vec3_t point , vec3_t distance , vec3_t forward , vec3_t right , vec3_t up , vec3_t result ) ;
extern void P_ProjectSource ( gclient_t * client , vec3_t point , vec3_t distance , vec3_t forward , vec3_t right , vec3_t result ) ;
extern byte P_DamageModifier ( edict_t * ent ) ;
extern void ClientEndServerFrame ( edict_t * ent ) ;
extern void G_SetClientFrame ( edict_t * ent ) ;
extern void G_SetClientSound ( edict_t * ent ) ;
extern void G_SetClientEvent ( edict_t * ent ) ;
extern void G_SetClientEffects ( edict_t * ent ) ;
extern void P_WorldEffects ( void ) ;
extern void P_FallingDamage ( edict_t * ent ) ;
extern void SV_CalcBlend ( edict_t * ent ) ;
extern void SV_AddBlend ( float r , float g , float b , float a , float * v_blend ) ;
extern void SV_CalcGunOffset ( edict_t * ent ) ;
extern void SV_CalcViewOffset ( edict_t * ent ) ;
extern void P_DamageFeedback ( edict_t * player ) ;
extern float SV_CalcRoll ( vec3_t angles , vec3_t velocity ) ;
extern edict_t * PlayerTrail_LastSpot ( void ) ;
extern edict_t * PlayerTrail_PickNext ( edict_t * self ) ;
extern edict_t * PlayerTrail_PickFirst ( edict_t * self ) ;
extern void PlayerTrail_New ( vec3_t spot ) ;
extern void PlayerTrail_Add ( vec3_t spot ) ;
extern void PlayerTrail_Init ( void ) ;
extern void G_SetSpectatorStats ( edict_t * ent ) ;
extern void G_CheckChaseStats ( edict_t * ent ) ;
extern void G_SetStats ( edict_t * ent ) ;
extern void InventoryMessage ( edict_t * ent ) ;
extern void HelpComputerMessage ( edict_t * ent ) ;
extern void DeathmatchScoreboardMessage ( edict_t * ent , edict_t * killer ) ;
extern void BeginIntermission ( edict_t * targ ) ;
extern void MoveClientToIntermission ( edict_t * ent ) ;
extern void RemoveAttackingPainDaemons ( edict_t * self ) ;
extern void ClientBeginServerFrame ( edict_t * ent ) ;
extern void ClientThink ( edict_t * ent , usercmd_t * ucmd ) ;
extern void PrintPmove ( pmove_t * pm ) ;
extern unsigned CheckBlock ( void * b , int c ) ;
extern trace_t PM_trace ( vec3_t start , vec3_t mins , vec3_t maxs , vec3_t end ) ;
extern void ClientDisconnect ( edict_t * ent ) ;
extern qboolean ClientConnect ( edict_t * ent , char * userinfo ) ;
extern void ClientUserinfoChanged ( edict_t * ent , char * userinfo ) ;
extern void ClientBegin ( edict_t * ent ) ;
extern void ClientBeginDeathmatch ( edict_t * ent ) ;
extern void PutClientInServer ( edict_t * ent ) ;
extern void spectator_respawn ( edict_t * ent ) ;
extern void respawn ( edict_t * self ) ;
extern void CopyToBodyQue ( edict_t * ent ) ;
extern void body_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void InitBodyQue ( void ) ;
extern void SelectSpawnPoint ( edict_t * ent , vec3_t origin , vec3_t angles ) ;
extern edict_t * SelectCoopSpawnPoint ( edict_t * ent ) ;
extern edict_t * SelectLavaCoopSpawnPoint ( edict_t * ent ) ;
extern edict_t * SelectDeathmatchSpawnPoint ( void ) ;
extern edict_t * SelectFarthestDeathmatchSpawnPoint ( void ) ;
extern edict_t * SelectRandomDeathmatchSpawnPoint ( void ) ;
extern float PlayersRangeFromSpot ( edict_t * spot ) ;
extern void FetchClientEntData ( edict_t * ent ) ;
extern void SaveClientData ( void ) ;
extern void InitClientResp ( gclient_t * client ) ;
extern void InitClientPersistant ( gclient_t * client ) ;
extern void player_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void LookAtKiller ( edict_t * self , edict_t * inflictor , edict_t * attacker ) ;
extern void TossClientWeapon ( edict_t * self ) ;
extern void ClientObituary ( edict_t * self , edict_t * inflictor , edict_t * attacker ) ;
extern qboolean IsNeutral ( edict_t * ent ) ;
extern qboolean IsFemale ( edict_t * ent ) ;
extern void player_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void SP_info_player_intermission ( void ) ;
extern void SP_info_player_coop_lava ( edict_t * self ) ;
extern void SP_info_player_coop ( edict_t * self ) ;
extern void SP_info_player_deathmatch ( edict_t * self ) ;
extern void SP_info_player_start ( edict_t * self ) ;
extern void ThrowArm2 ( edict_t * self ) ;
extern void ThrowArm1 ( edict_t * self ) ;
extern void WidowExplosionLeg ( edict_t * self ) ;
extern void WidowExplosion7 ( edict_t * self ) ;
extern void WidowExplosion6 ( edict_t * self ) ;
extern void WidowExplosion5 ( edict_t * self ) ;
extern void WidowExplosion4 ( edict_t * self ) ;
extern void WidowExplosion3 ( edict_t * self ) ;
extern void WidowExplosion2 ( edict_t * self ) ;
extern void WidowExplosion1 ( edict_t * self ) ;
extern void WidowExplode ( edict_t * self ) ;
extern void ThrowMoreStuff ( edict_t * self , vec3_t point ) ;
extern void ThrowSmallStuff ( edict_t * self , vec3_t point ) ;
extern void ThrowWidowGibReal ( edict_t * self , char * gibname , int damage , int type , vec3_t startpos , qboolean sized , int hitsound , qboolean fade ) ;
extern void ThrowWidowGibSized ( edict_t * self , char * gibname , int damage , int type , vec3_t startpos , int hitsound , qboolean fade ) ;
extern void ThrowWidowGibLoc ( edict_t * self , char * gibname , int damage , int type , vec3_t startpos , qboolean fade ) ;
extern void ThrowWidowGib ( edict_t * self , char * gibname , int damage , int type ) ;
extern void widow_gib_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void WidowVelocityForDamage ( int damage , vec3_t v ) ;
extern void SP_monster_widow2 ( edict_t * self ) ;
extern void Widow2Precache ( ) ;
extern qboolean Widow2_CheckAttack ( edict_t * self ) ;
extern void widow2_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void KillChildren ( edict_t * self ) ;
extern void widow2_dead ( edict_t * self ) ;
extern void widow2_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void widow2_reattack_beam ( edict_t * self ) ;
extern void widow2_attack_beam ( edict_t * self ) ;
extern void widow2_attack ( edict_t * self ) ;
extern void widow2_melee ( edict_t * self ) ;
extern void widow2_walk ( edict_t * self ) ;
extern void widow2_run ( edict_t * self ) ;
extern void widow2_stand ( edict_t * self ) ;
extern void widow2_finaldeath ( edict_t * self ) ;
extern void widow2_keep_searching ( edict_t * self ) ;
extern void widow2_start_searching ( edict_t * self ) ;
extern void Widow2Toss ( edict_t * self ) ;
extern void Widow2Crunch ( edict_t * self ) ;
extern void Widow2TonguePull ( edict_t * self ) ;
extern void Widow2Tongue ( edict_t * self ) ;
extern qboolean widow2_tongue_attack_ok ( vec3_t start , vec3_t end , float range ) ;
extern void Widow2StartSweep ( edict_t * self ) ;
extern void Widow2BeamTargetRemove ( edict_t * self ) ;
extern void Widow2SaveBeamTarget ( edict_t * self ) ;
extern void widow2_disrupt_reattack ( edict_t * self ) ;
extern void Widow2SaveDisruptLoc ( edict_t * self ) ;
extern void WidowDisrupt ( edict_t * self ) ;
extern void widow2_ready_spawn ( edict_t * self ) ;
extern void widow2_spawn_check ( edict_t * self ) ;
extern void Widow2Spawn ( edict_t * self ) ;
extern void Widow2Beam ( edict_t * self ) ;
extern void widow2_search ( edict_t * self ) ;
extern void pauseme ( edict_t * self ) ;
extern void SP_monster_widow ( edict_t * self ) ;
extern void WidowPrecache ( ) ;
extern void WidowCalcSlots ( edict_t * self ) ;
extern qboolean widow_blocked ( edict_t * self , float dist ) ;
extern qboolean Widow_CheckAttack ( edict_t * self ) ;
extern void WidowPowerups ( edict_t * self ) ;
extern void WidowRespondPowerup ( edict_t * self , edict_t * other ) ;
extern void WidowPowerArmor ( edict_t * self ) ;
extern void WidowPent ( edict_t * self , float framenum ) ;
extern void WidowDouble ( edict_t * self , float framenum ) ;
extern void WidowGoinQuad ( edict_t * self , float framenum ) ;
extern void widow_melee ( edict_t * self ) ;
extern void widow_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void widow_dead ( edict_t * self ) ;
extern void widow_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void widow_reattack_blaster ( edict_t * self ) ;
extern void widow_attack_blaster ( edict_t * self ) ;
extern void widow_attack ( edict_t * self ) ;
extern void widow_walk ( edict_t * self ) ;
extern void widow_run ( edict_t * self ) ;
extern void widow_stand ( edict_t * self ) ;
extern void widow_attack_kick ( edict_t * self ) ;
extern void spawn_out_do ( edict_t * self ) ;
extern void spawn_out_start ( edict_t * self ) ;
extern void widow_done_spawn ( edict_t * self ) ;
extern void widow_start_spawn ( edict_t * self ) ;
extern void widow_attack_rail ( edict_t * self ) ;
extern void widow_rail_done ( edict_t * self ) ;
extern void widow_start_rail ( edict_t * self ) ;
extern void WidowSaveLoc ( edict_t * self ) ;
extern void WidowRail ( edict_t * self ) ;
extern void widow_start_run_12 ( edict_t * self ) ;
extern void widow_start_run_10 ( edict_t * self ) ;
extern void widow_start_run_5 ( edict_t * self ) ;
extern void widow_stepshoot ( edict_t * self ) ;
extern void widow_step ( edict_t * self ) ;
extern void widow_ready_spawn ( edict_t * self ) ;
extern void widow_spawn_check ( edict_t * self ) ;
extern void WidowSpawn ( edict_t * self ) ;
extern void WidowBlaster ( edict_t * self ) ;
extern int WidowTorso ( edict_t * self ) ;
extern float target_angle ( edict_t * self ) ;
extern void widow_sight ( edict_t * self , edict_t * other ) ;
extern void widow_search ( edict_t * self ) ;
extern void showme ( edict_t * self ) ;
extern void SP_monster_turret ( edict_t * self ) ;
extern qboolean turret_checkattack ( edict_t * self ) ;
extern void turret_activate ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void turret_wake ( edict_t * self ) ;
extern void turret_wall_spawn ( edict_t * turret ) ;
extern void turret_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void turret_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void turret_attack ( edict_t * self ) ;
extern void TurretFireBlind ( edict_t * self ) ;
extern void TurretFire ( edict_t * self ) ;
extern void turret_run ( edict_t * self ) ;
extern void turret_walk ( edict_t * self ) ;
extern void turret_ready_gun ( edict_t * self ) ;
extern void turret_stand ( edict_t * self ) ;
extern void turret_search ( edict_t * self ) ;
extern void turret_sight ( edict_t * self , edict_t * other ) ;
extern void TurretAim ( edict_t * self ) ;
extern void SP_monster_tank ( edict_t * self ) ;
extern void tank_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void tank_dead ( edict_t * self ) ;
extern void tank_attack ( edict_t * self ) ;
extern void tank_doattack_rocket ( edict_t * self ) ;
extern void tank_refire_rocket ( edict_t * self ) ;
extern void tank_poststrike ( edict_t * self ) ;
extern void tank_reattack_blaster ( edict_t * self ) ;
extern void TankMachineGun ( edict_t * self ) ;
extern void TankRocket ( edict_t * self ) ;
extern void TankStrike ( edict_t * self ) ;
extern void TankBlaster ( edict_t * self ) ;
extern void tank_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void tank_run ( edict_t * self ) ;
extern void tank_walk ( edict_t * self ) ;
extern void tank_stand ( edict_t * self ) ;
extern void tank_idle ( edict_t * self ) ;
extern void tank_windup ( edict_t * self ) ;
extern void tank_thud ( edict_t * self ) ;
extern void tank_footstep ( edict_t * self ) ;
extern void tank_sight ( edict_t * self , edict_t * other ) ;
extern qboolean tank_blocked( edict_t *self, float dist );
extern void SP_monster_supertank ( edict_t * self ) ;
extern qboolean supertank_blocked ( edict_t * self , float dist ) ;
extern void supertank_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void BossExplode ( edict_t * self ) ;
extern void supertank_dead ( edict_t * self ) ;
extern void supertank_attack ( edict_t * self ) ;
extern void supertankMachineGun ( edict_t * self ) ;
extern void supertankRocket ( edict_t * self ) ;
extern void supertank_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void supertank_reattack1 ( edict_t * self ) ;
extern void supertank_run ( edict_t * self ) ;
extern void supertank_walk ( edict_t * self ) ;
extern void supertank_forward ( edict_t * self ) ;
extern void supertank_stand ( edict_t * self ) ;
extern void supertank_search ( edict_t * self ) ;
extern void TreadSound ( edict_t * self ) ;
extern void SP_monster_stalker ( edict_t * self ) ;
extern void stalker_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void stalker_dead ( edict_t * self ) ;
extern qboolean stalker_blocked ( edict_t * self , float dist ) ;
extern void stalker_jump ( edict_t * self ) ;
extern void stalker_jump_wait_land ( edict_t * self ) ;
extern void stalker_jump_up ( edict_t * self ) ;
extern void stalker_jump_down ( edict_t * self ) ;
extern void stalker_dodge ( edict_t * self , edict_t * attacker , float eta , trace_t * tr ) ;
extern void stalker_dodge_jump ( edict_t * self ) ;
extern void stalker_jump_straightup ( edict_t * self ) ;
extern int stalker_do_pounce ( edict_t * self , vec3_t dest ) ;
extern int stalker_check_lz ( edict_t * self , edict_t * target , vec3_t dest ) ;
extern void calcJumpAngle ( vec3_t start , vec3_t end , float velocity , vec3_t angles ) ;
extern void stalker_attack_melee ( edict_t * self ) ;
extern void stalker_swing_attack ( edict_t * self ) ;
extern void stalker_attack_ranged ( edict_t * self ) ;
extern void stalker_shoot_attack2 ( edict_t * self ) ;
extern void stalker_shoot_attack ( edict_t * self ) ;
extern void stalker_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void stalker_false_death_start ( edict_t * self ) ;
extern void stalker_false_death ( edict_t * self ) ;
extern void stalker_heal ( edict_t * self ) ;
extern void stalker_reactivate ( edict_t * self ) ;
extern void stalker_walk ( edict_t * self ) ;
extern void stalker_run ( edict_t * self ) ;
extern void stalker_stand ( edict_t * self ) ;
extern void stalker_idle ( edict_t * self ) ;
extern void stalker_idle_noise ( edict_t * self ) ;
extern void stalker_sight ( edict_t * self , edict_t * other ) ;
extern qboolean stalker_ok_to_transition ( edict_t * self ) ;
extern void SP_monster_soldier_ss ( edict_t * self ) ;
extern void SP_monster_soldier ( edict_t * self ) ;
extern void SP_monster_soldier_light ( edict_t * self ) ;
extern void SP_monster_soldier_x ( edict_t * self ) ;
extern void soldier_blind ( edict_t * self ) ;
extern void soldier_duck ( edict_t * self , float eta ) ;
extern void soldier_sidestep ( edict_t * self ) ;
extern void soldier_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void soldier_dead2 ( edict_t * self ) ;
extern void soldier_dead ( edict_t * self ) ;
extern void soldier_fire7 ( edict_t * self ) ;
extern void soldier_fire6 ( edict_t * self ) ;
extern qboolean soldier_blocked ( edict_t * self , float dist ) ;
extern void soldier_sight ( edict_t * self , edict_t * other ) ;
extern void soldier_attack ( edict_t * self ) ;
extern void soldier_attack6_refire ( edict_t * self ) ;
extern void soldier_fire8 ( edict_t * self ) ;
extern void soldier_fire4 ( edict_t * self ) ;
extern void soldier_attack3_refire ( edict_t * self ) ;
extern void soldier_fire3 ( edict_t * self ) ;
extern void soldier_attack2_refire2 ( edict_t * self ) ;
extern void soldier_attack2_refire1 ( edict_t * self ) ;
extern void soldier_fire2 ( edict_t * self ) ;
extern void soldier_attack1_refire2 ( edict_t * self ) ;
extern void soldier_attack1_refire1 ( edict_t * self ) ;
extern void soldier_fire1 ( edict_t * self ) ;
extern void soldier_fire ( edict_t * self , int in_flash_number ) ;
extern void soldier_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void soldier_run ( edict_t * self ) ;
extern void soldier_fire_run ( edict_t * self ) ;
extern void soldier_walk ( edict_t * self ) ;
extern void soldier_walk1_random ( edict_t * self ) ;
extern void soldier_stand ( edict_t * self ) ;
extern void soldier_cock ( edict_t * self ) ;
extern void soldier_idle ( edict_t * self ) ;
extern void soldier_stop_charge ( edict_t * self ) ;
extern void soldier_start_charge ( edict_t * self ) ;
extern void SP_monster_parasite ( edict_t * self ) ;
extern void parasite_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void parasite_dead ( edict_t * self ) ;
extern qboolean parasite_checkattack ( edict_t * self ) ;
extern qboolean parasite_blocked ( edict_t * self , float dist ) ;
extern void parasite_jump ( edict_t * self ) ;
extern void parasite_jump_wait_land ( edict_t * self ) ;
extern void parasite_jump_up ( edict_t * self ) ;
extern void parasite_jump_down ( edict_t * self ) ;
extern void parasite_attack ( edict_t * self ) ;
extern void parasite_drain_attack ( edict_t * self ) ;
extern qboolean parasite_drain_attack_ok ( vec3_t start , vec3_t end ) ;
extern void parasite_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void parasite_walk ( edict_t * self ) ;
extern void parasite_start_walk ( edict_t * self ) ;
extern void parasite_run ( edict_t * self ) ;
extern void parasite_start_run ( edict_t * self ) ;
extern void parasite_stand ( edict_t * self ) ;
extern void parasite_idle ( edict_t * self ) ;
extern void parasite_refidget ( edict_t * self ) ;
extern void parasite_do_fidget ( edict_t * self ) ;
extern void parasite_end_fidget ( edict_t * self ) ;
extern void parasite_search ( edict_t * self ) ;
extern void parasite_scratch ( edict_t * self ) ;
extern void parasite_tap ( edict_t * self ) ;
extern void parasite_sight ( edict_t * self , edict_t * other ) ;
extern void parasite_reel_in ( edict_t * self ) ;
extern void parasite_launch ( edict_t * self ) ;
extern void SP_monster_mutant ( edict_t * self ) ;
extern qboolean mutant_blocked ( edict_t * self , float dist ) ;
extern void mutant_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void mutant_dead ( edict_t * self ) ;
extern void mutant_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern qboolean mutant_checkattack ( edict_t * self ) ;
extern qboolean mutant_check_jump ( edict_t * self ) ;
extern qboolean mutant_check_melee ( edict_t * self ) ;
extern void mutant_jump ( edict_t * self ) ;
extern void mutant_check_landing ( edict_t * self ) ;
extern void mutant_jump_takeoff ( edict_t * self ) ;
extern void mutant_jump_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void mutant_melee ( edict_t * self ) ;
extern void mutant_check_refire ( edict_t * self ) ;
extern void mutant_hit_right ( edict_t * self ) ;
extern void mutant_hit_left ( edict_t * self ) ;
extern void mutant_run ( edict_t * self ) ;
extern void mutant_walk ( edict_t * self ) ;
extern void mutant_walk_loop ( edict_t * self ) ;
extern void mutant_idle ( edict_t * self ) ;
extern void mutant_idle_loop ( edict_t * self ) ;
extern void mutant_stand ( edict_t * self ) ;
extern void mutant_swing ( edict_t * self ) ;
extern void mutant_search ( edict_t * self ) ;
extern void mutant_sight ( edict_t * self , edict_t * other ) ;
extern void mutant_step ( edict_t * self ) ;
extern qboolean M_walkmove ( edict_t * ent , float yaw , float dist ) ;
extern void M_MoveToGoal ( edict_t * ent , float dist ) ;
extern qboolean SV_CloseEnough ( edict_t * ent , edict_t * goal , float dist ) ;
extern void SV_NewChaseDir ( edict_t * actor , edict_t * enemy , float dist ) ;
extern void SV_FixCheckBottom ( edict_t * ent ) ;
extern qboolean SV_StepDirection ( edict_t * ent , float yaw , float dist ) ;
extern void M_ChangeYaw ( edict_t * ent ) ;
extern qboolean SV_movestep ( edict_t * ent , vec3_t move , qboolean relink ) ;
extern qboolean IsBadAhead ( edict_t * self , edict_t * bad , vec3_t move ) ;
extern qboolean M_CheckBottom ( edict_t * ent ) ;
extern void SP_monster_medic ( edict_t * self ) ;
extern qboolean medic_blocked ( edict_t *self, float dist ) ;
extern void medic_sidestep( edict_t *self ) ;
extern void medic_duck( edict_t *self, float eta ) ;
extern qboolean medic_checkattack ( edict_t * self ) ;
extern void medic_finish_spawn ( edict_t *self );
extern void medic_spawngrows ( edict_t *self );
extern void medic_determine_spawn ( edict_t *self ) ;
extern void medic_start_spawn ( edict_t *self ) ; 
extern void medic_attack ( edict_t * self ) ;
extern void medic_hook_retract ( edict_t * self ) ;
extern void medic_cable_attack ( edict_t * self ) ;
extern void medic_hook_launch ( edict_t * self ) ;
extern void medic_continue ( edict_t * self ) ;
extern void medic_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void medic_dead ( edict_t * self ) ;
extern void medic_fire_blaster ( edict_t * self ) ;
extern void medic_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void medic_run ( edict_t * self ) ;
extern void medic_walk ( edict_t * self ) ;
extern void medic_stand ( edict_t * self ) ;
extern void medic_sight ( edict_t * self , edict_t * other ) ;
extern void medic_search ( edict_t * self ) ;
extern void medic_idle ( edict_t * self ) ;
extern void cleanupHeal( edict_t *self, qboolean change_frame ) ;
extern void abortHeal( edict_t *self, qboolean change_frame, qboolean gib, qboolean mark ) ;
extern qboolean canReach ( edict_t *self, edict_t *other ) ;
extern edict_t * medic_FindDeadMonster ( edict_t * self ) ;
extern void SP_misc_insane ( edict_t * self ) ;
extern void insane_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void insane_dead ( edict_t * self ) ;
extern void insane_stand ( edict_t * self ) ;
extern void insane_checkup ( edict_t * self ) ;
extern void insane_checkdown ( edict_t * self ) ;
extern void insane_onground ( edict_t * self ) ;
extern void insane_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void insane_run ( edict_t * self ) ;
extern void insane_walk ( edict_t * self ) ;
extern void insane_cross ( edict_t * self ) ;
extern void insane_scream ( edict_t * self ) ;
extern void insane_moan ( edict_t * self ) ;
extern void insane_shake ( edict_t * self ) ;
extern void insane_fist ( edict_t * self ) ;
extern void SP_monster_infantry ( edict_t * self ) ;
extern void infantry_sidestep ( edict_t * self ) ;
extern void infantry_duck ( edict_t * self , float eta ) ;
extern qboolean infantry_blocked ( edict_t * self , float dist ) ;
extern void infantry_jump ( edict_t * self ) ;
extern void infantry_jump_wait_land ( edict_t * self ) ;
extern void infantry_jump2_now ( edict_t * self ) ;
extern void infantry_jump_now ( edict_t * self ) ;
extern void infantry_attack ( edict_t * self ) ;
extern void infantry_smack ( edict_t * self ) ;
extern void infantry_swing ( edict_t * self ) ;
extern void infantry_fire_prep ( edict_t * self ) ;
extern void infantry_fire ( edict_t * self ) ;
extern void infantry_cock_gun ( edict_t * self ) ;
extern void infantry_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void infantry_dead ( edict_t * self ) ;
extern void infantry_sight ( edict_t * self , edict_t * other ) ;
extern void InfantryMachineGun ( edict_t * self ) ;
extern void infantry_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void infantry_run ( edict_t * self ) ;
extern void infantry_walk ( edict_t * self ) ;
extern void infantry_fidget ( edict_t * self ) ;
extern void infantry_stand ( edict_t * self ) ;
extern void SP_monster_hover ( edict_t * self ) ;
extern qboolean hover_blocked ( edict_t *self, float dist ) ;
extern void hover_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void hover_dead ( edict_t * self ) ;
extern void hover_deadthink ( edict_t * self ) ;
extern void hover_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void hover_attack ( edict_t * self ) ;
extern void hover_start_attack ( edict_t * self ) ;
extern void hover_walk ( edict_t * self ) ;
extern void hover_run ( edict_t * self ) ;
extern void hover_stand ( edict_t * self ) ;
extern void hover_fire_blaster ( edict_t * self ) ;
extern void hover_reattack ( edict_t * self ) ;
extern void hover_search ( edict_t * self ) ;
extern void hover_sight ( edict_t * self , edict_t * other ) ;
extern void SP_monster_gunner ( edict_t * self ) ;
extern void gunner_sidestep ( edict_t * self ) ;
extern void gunner_duck ( edict_t * self , float eta ) ;
extern qboolean gunner_blocked ( edict_t * self , float dist ) ;
extern void gunner_jump ( edict_t * self ) ;
extern void gunner_jump_wait_land ( edict_t * self ) ;
extern void gunner_jump2_now ( edict_t * self ) ;
extern void gunner_jump_now ( edict_t * self ) ;
extern void gunner_refire_chain ( edict_t * self ) ;
extern void gunner_fire_chain ( edict_t * self ) ;
extern void gunner_attack ( edict_t * self ) ;
extern void gunner_blind_check ( edict_t * self ) ;
extern void GunnerGrenade ( edict_t * self ) ;
extern qboolean gunner_grenade_check ( edict_t * self ) ;
extern void GunnerFire ( edict_t * self ) ;
extern void gunner_opengun ( edict_t * self ) ;
extern void gunner_duck_down ( edict_t * self ) ;
extern void gunner_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void gunner_dead ( edict_t * self ) ;
extern void gunner_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void gunner_runandshoot ( edict_t * self ) ;
extern void gunner_run ( edict_t * self ) ;
extern void gunner_walk ( edict_t * self ) ;
extern void gunner_stand ( edict_t * self ) ;
extern void gunner_fidget ( edict_t * self ) ;
extern void gunner_search ( edict_t * self ) ;
extern void gunner_sight ( edict_t * self , edict_t * other ) ;
extern void gunner_idlesound ( edict_t * self ) ;
extern void SP_monster_gladiator ( edict_t * self ) ;
qboolean gladiator_blocked ( edict_t *self , float dist ) ;
extern void gladiator_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void gladiator_dead ( edict_t * self ) ;
extern void gladiator_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void gladiator_attack ( edict_t * self ) ;
extern void GladiatorGun ( edict_t * self ) ;
extern void gladiator_melee ( edict_t * self ) ;
extern void GaldiatorMelee ( edict_t * self ) ;
extern void gladiator_run ( edict_t * self ) ;
extern void gladiator_walk ( edict_t * self ) ;
extern void gladiator_stand ( edict_t * self ) ;
extern void gladiator_cleaver_swing ( edict_t * self ) ;
extern void gladiator_search ( edict_t * self ) ;
extern void gladiator_sight ( edict_t * self , edict_t * other ) ;
extern void gladiator_idle ( edict_t * self ) ;
extern void SP_monster_kamikaze ( edict_t * self ) ;
extern void SP_monster_flyer ( edict_t * self ) ;
extern int flyer_blocked ( edict_t * self , float dist ) ;
extern void flyer_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void flyer_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void flyer_check_melee ( edict_t * self ) ;
extern void flyer_melee ( edict_t * self ) ;
extern void flyer_nextmove ( edict_t * self ) ;
extern void flyer_setstart ( edict_t * self ) ;
extern void flyer_attack ( edict_t * self ) ;
extern void flyer_loop_melee ( edict_t * self ) ;
extern void flyer_slash_right ( edict_t * self ) ;
extern void flyer_slash_left ( edict_t * self ) ;
extern void flyer_fireright ( edict_t * self ) ;
extern void flyer_fireleft ( edict_t * self ) ;
extern void flyer_fire ( edict_t * self , int flash_number ) ;
extern void flyer_start ( edict_t * self ) ;
extern void flyer_stop ( edict_t * self ) ;
extern void flyer_kamikaze_check ( edict_t * self ) ;
extern void flyer_kamikaze ( edict_t * self ) ;
extern void flyer_kamikaze_explode ( edict_t * self ) ;
extern void flyer_stand ( edict_t * self ) ;
extern void flyer_walk ( edict_t * self ) ;
extern void flyer_run ( edict_t * self ) ;
extern void flyer_pop_blades ( edict_t * self ) ;
extern void flyer_idle ( edict_t * self ) ;
extern void flyer_sight ( edict_t * self , edict_t * other ) ;
extern void SP_monster_floater ( edict_t * self ) ;
extern qboolean floater_blocked ( edict_t * self , float dist ) ;
extern void floater_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void floater_dead ( edict_t * self ) ;
extern void floater_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void floater_melee ( edict_t * self ) ;
extern void floater_attack ( edict_t * self ) ;
extern void floater_zap ( edict_t * self ) ;
extern void floater_wham ( edict_t * self ) ;
extern void floater_walk ( edict_t * self ) ;
extern void floater_run ( edict_t * self ) ;
extern void floater_stand ( edict_t * self ) ;
extern void floater_fire_blaster ( edict_t * self ) ;
extern void floater_idle ( edict_t * self ) ;
extern void floater_sight ( edict_t * self , edict_t * other ) ;
extern void SP_monster_flipper ( edict_t * self ) ;
extern void flipper_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void flipper_sight ( edict_t * self , edict_t * other ) ;
extern void flipper_dead ( edict_t * self ) ;
extern void flipper_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void flipper_melee ( edict_t * self ) ;
extern void flipper_preattack ( edict_t * self ) ;
extern void flipper_bite ( edict_t * self ) ;
extern void flipper_start_run ( edict_t * self ) ;
extern void flipper_walk ( edict_t * self ) ;
extern void flipper_run ( edict_t * self ) ;
extern void flipper_run_loop ( edict_t * self ) ;
extern void flipper_stand ( edict_t * self ) ;
extern void SP_monster_chick ( edict_t * self ) ;
extern void chick_sidestep ( edict_t * self ) ;
extern void chick_duck ( edict_t * self , float eta ) ;
extern qboolean chick_blocked ( edict_t * self , float dist ) ;
extern void chick_sight ( edict_t * self , edict_t * other ) ;
extern void chick_attack ( edict_t * self ) ;
extern void chick_melee ( edict_t * self ) ;
extern void chick_slash ( edict_t * self ) ;
extern void chick_reslash ( edict_t * self ) ;
extern void chick_attack1 ( edict_t * self ) ;
extern void chick_rerocket ( edict_t * self ) ;
extern void ChickReload ( edict_t * self ) ;
extern void Chick_PreAttack1 ( edict_t * self ) ;
extern void ChickRocket ( edict_t * self ) ;
extern void ChickSlash ( edict_t * self ) ;
extern void chick_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void chick_dead ( edict_t * self ) ;
extern void chick_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void chick_run ( edict_t * self ) ;
extern void chick_walk ( edict_t * self ) ;
extern void chick_stand ( edict_t * self ) ;
extern void chick_fidget ( edict_t * self ) ;
extern void ChickMoan ( edict_t * self ) ;
extern void SP_monster_carrier ( edict_t * self ) ;
extern void CarrierPrecache ( ) ;
extern qboolean Carrier_CheckAttack ( edict_t * self ) ;
extern void carrier_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void carrier_dead ( edict_t * self ) ;
extern void carrier_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void carrier_reattack_gren ( edict_t * self ) ;
extern void carrier_attack_gren ( edict_t * self ) ;
extern void carrier_reattack_mg ( edict_t * self ) ;
extern void carrier_attack_mg ( edict_t * self ) ;
extern void carrier_attack ( edict_t * self ) ;
extern void CarrierMachineGunHold ( edict_t * self ) ;
extern void carrier_walk ( edict_t * self ) ;
extern void carrier_run ( edict_t * self ) ;
extern void carrier_stand ( edict_t * self ) ;
extern void CarrierSaveLoc ( edict_t * self ) ;
extern void CarrierRail ( edict_t * self ) ;
extern void carrier_start_spawn ( edict_t * self ) ;
extern void carrier_ready_spawn ( edict_t * self ) ;
extern void carrier_spawn_check ( edict_t * self ) ;
extern void carrier_prep_spawn ( edict_t * self ) ;
extern void CarrierSpawn ( edict_t * self ) ;
extern void CarrierMachineGun ( edict_t * self ) ;
extern void carrier_firebullet_left ( edict_t * self ) ;
extern void carrier_firebullet_right ( edict_t * self ) ;
extern void CarrierRocket ( edict_t * self ) ;
extern void CarrierPredictiveRocket ( edict_t * self ) ;
extern void CarrierGrenade ( edict_t * self ) ;
extern void CarrierCoopCheck ( edict_t * self ) ;
extern void carrier_sight ( edict_t * self , edict_t * other ) ;
extern void SP_monster_brain ( edict_t * self ) ;
extern void brain_duck ( edict_t * self , float eta ) ;
extern void brain_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void brain_dead ( edict_t * self ) ;
extern void brain_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void brain_run ( edict_t * self ) ;
extern void brain_melee ( edict_t * self ) ;
extern void brain_chest_closed ( edict_t * self ) ;
extern void brain_tentacle_attack ( edict_t * self ) ;
extern void brain_chest_open ( edict_t * self ) ;
extern void brain_hit_left ( edict_t * self ) ;
extern void brain_swing_left ( edict_t * self ) ;
extern void brain_hit_right ( edict_t * self ) ;
extern void brain_swing_right ( edict_t * self ) ;
extern void brain_walk ( edict_t * self ) ;
extern void brain_idle ( edict_t * self ) ;
extern void brain_stand ( edict_t * self ) ;
extern void brain_search ( edict_t * self ) ;
extern void brain_sight ( edict_t * self , edict_t * other ) ;
extern void MakronToss ( edict_t * self ) ;
extern void MakronSpawn ( edict_t * self ) ;
extern void SP_monster_makron ( edict_t * self ) ;
extern void MakronPrecache ( void ) ;
extern qboolean Makron_CheckAttack ( edict_t * self ) ;
extern void makron_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void makron_dead ( edict_t * self ) ;
extern void makron_torso ( edict_t * ent ) ;
extern void makron_torso_think ( edict_t * self ) ;
extern void makron_attack ( edict_t * self ) ;
extern void makron_sight ( edict_t * self , edict_t * other ) ;
extern void makron_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void MakronHyperblaster ( edict_t * self ) ;
extern void MakronRailgun ( edict_t * self ) ;
extern void MakronSaveloc ( edict_t * self ) ;
extern void makronBFG ( edict_t * self ) ;
extern void makron_run ( edict_t * self ) ;
extern void makron_walk ( edict_t * self ) ;
extern void makron_prerailgun ( edict_t * self ) ;
extern void makron_brainsplorch ( edict_t * self ) ;
extern void makron_step_right ( edict_t * self ) ;
extern void makron_step_left ( edict_t * self ) ;
extern void makron_popup ( edict_t * self ) ;
extern void makron_hit ( edict_t * self ) ;
extern void makron_stand ( edict_t * self ) ;
extern void makron_taunt ( edict_t * self ) ;
extern void SP_monster_jorg ( edict_t * self ) ;
extern qboolean Jorg_CheckAttack ( edict_t * self ) ;
extern void jorg_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void jorg_dead ( edict_t * self ) ;
extern void jorg_attack ( edict_t * self ) ;
extern void jorg_firebullet ( edict_t * self ) ;
extern void jorg_firebullet_left ( edict_t * self ) ;
extern void jorg_firebullet_right ( edict_t * self ) ;
extern void jorgBFG ( edict_t * self ) ;
extern void jorg_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void jorg_attack1 ( edict_t * self ) ;
extern void jorg_reattack1 ( edict_t * self ) ;
extern void jorg_run ( edict_t * self ) ;
extern void jorg_walk ( edict_t * self ) ;
extern void jorg_stand ( edict_t * self ) ;
extern void jorg_step_right ( edict_t * self ) ;
extern void jorg_step_left ( edict_t * self ) ;
extern void jorg_death_hit ( edict_t * self ) ;
extern void jorg_idle ( edict_t * self ) ;
extern void jorg_search ( edict_t * self ) ;
extern void SP_monster_boss3_stand ( edict_t * self ) ;
extern void Think_Boss3Stand ( edict_t * ent ) ;
extern void Use_Boss3 ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void SP_monster_boss2 ( edict_t * self ) ;
extern qboolean Boss2_CheckAttack ( edict_t * self ) ;
extern void boss2_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void boss2_dead ( edict_t * self ) ;
extern void boss2_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void boss2_reattack_mg ( edict_t * self ) ;
extern void boss2_attack_mg ( edict_t * self ) ;
extern void boss2_attack ( edict_t * self ) ;
extern void boss2_walk ( edict_t * self ) ;
extern void boss2_run ( edict_t * self ) ;
extern void boss2_stand ( edict_t * self ) ;
extern void Boss2MachineGun ( edict_t * self ) ;
extern void boss2_firebullet_left ( edict_t * self ) ;
extern void boss2_firebullet_right ( edict_t * self ) ;
extern void Boss2Rocket ( edict_t * self ) ;
extern void boss2_search ( edict_t * self ) ;
extern void SP_monster_berserk ( edict_t * self ) ;
extern void berserk_sidestep ( edict_t * self ) ;
extern qboolean berserk_blocked ( edict_t * self , float dist ) ;
extern void berserk_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void berserk_dead ( edict_t * self ) ;
extern void berserk_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void berserk_melee ( edict_t * self ) ;
extern void berserk_strike ( edict_t * self ) ;
extern void berserk_attack_club ( edict_t * self ) ;
extern void berserk_swing ( edict_t * self ) ;
extern void berserk_attack_spike ( edict_t * self ) ;
extern void berserk_run ( edict_t * self ) ;
extern void berserk_walk ( edict_t * self ) ;
extern void berserk_fidget ( edict_t * self ) ;
extern void berserk_stand ( edict_t * self ) ;
extern void berserk_search ( edict_t * self ) ;
extern void berserk_sight ( edict_t * self , edict_t * other ) ;
extern void fire_bfg ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , float damage_radius ) ;
extern void bfg_think ( edict_t * self ) ;
extern void bfg_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void bfg_explode ( edict_t * self ) ;
extern void fire_rail ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int kick ) ;
extern void fire_rocket ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , float damage_radius , int radius_damage ) ;
extern void rocket_touch ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void fire_grenade2 ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int speed , float timer , float damage_radius , qboolean held ) ;
extern void fire_grenade ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int speed , float timer , float damage_radius ) ;
extern void Grenade_Touch ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void Grenade_Explode ( edict_t * ent ) ;
extern void fire_blaster ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , int effect , qboolean hyper ) ;
extern void blaster_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void fire_shotgun ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int kick , int hspread , int vspread , int count , int mod ) ;
extern void fire_bullet ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int kick , int hspread , int vspread , int mod ) ;
extern void fire_lead ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int kick , int te_impact , int hspread , int vspread , int mod ) ;
extern qboolean fire_hit ( edict_t * self , vec3_t aim , int damage , int kick ) ;
extern void check_dodge ( edict_t * self , vec3_t start , vec3_t dir , int speed ) ;
extern qboolean KillBox ( edict_t * ent ) ;
extern void G_TouchSolids ( edict_t * ent ) ;
extern void G_TouchTriggers ( edict_t * ent ) ;
extern void G_FreeEdict ( edict_t * ed ) ;
extern edict_t * G_Spawn ( void ) ;
extern void G_InitEdict ( edict_t * e ) ;
extern char * G_CopyString ( char * in ) ;
extern void vectoangles2 ( vec3_t value1 , vec3_t angles ) ;
extern void vectoangles ( vec3_t value1 , vec3_t angles ) ;
extern float vectoyaw2 ( vec3_t vec ) ;
extern float vectoyaw ( vec3_t vec ) ;
extern void G_SetMovedir ( vec3_t angles , vec3_t movedir ) ;
extern char * vtos ( vec3_t v ) ;
extern float * tv ( float x , float y , float z ) ;
extern void G_UseTargets ( edict_t * ent , edict_t * activator ) ;
extern void Think_Delay ( edict_t * ent ) ;
extern edict_t * G_PickTarget ( char * targetname ) ;
extern edict_t * findradius2 ( edict_t * from , vec3_t org , float rad ) ;
extern edict_t * findradius ( edict_t * from , vec3_t org , float rad ) ;
extern edict_t * G_Find ( edict_t * from , int fieldofs , char * match ) ;
extern void G_ProjectSource2 ( vec3_t point , vec3_t distance , vec3_t forward , vec3_t right , vec3_t up , vec3_t result ) ;
extern void G_ProjectSource ( vec3_t point , vec3_t distance , vec3_t forward , vec3_t right , vec3_t result ) ;
extern void SP_turret_invisible_brain ( edict_t * self ) ;
extern void turret_brain_activate ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void turret_brain_deactivate ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void turret_brain_link ( edict_t * self ) ;
extern void turret_brain_think ( edict_t * self ) ;
extern void SP_turret_driver ( edict_t * self ) ;
extern void turret_driver_link ( edict_t * self ) ;
extern void turret_driver_think ( edict_t * self ) ;
extern void turret_driver_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void SP_turret_base ( edict_t * self ) ;
extern void SP_turret_breach ( edict_t * self ) ;
extern void turret_breach_finish_init ( edict_t * self ) ;
extern void turret_breach_think ( edict_t * self ) ;
extern void turret_breach_fire ( edict_t * self ) ;
extern void turret_blocked ( edict_t * self , edict_t * other ) ;
extern float SnapToEights ( float x ) ;
extern void AnglesNormalize ( vec3_t vec ) ;
extern void SP_trigger_monsterjump ( edict_t * self ) ;
extern void trigger_monsterjump_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_trigger_gravity ( edict_t * self ) ;
extern void trigger_gravity_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void trigger_gravity_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_trigger_hurt ( edict_t * self ) ;
extern void hurt_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void hurt_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_trigger_push ( edict_t * self ) ;
extern void trigger_push_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void trigger_push_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_trigger_always ( edict_t * ent ) ;
extern void SP_trigger_counter ( edict_t * self ) ;
extern void trigger_counter_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_trigger_key ( edict_t * self ) ;
extern void trigger_key_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_trigger_relay ( edict_t * self ) ;
extern void trigger_relay_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_trigger_once ( edict_t * ent ) ;
extern void SP_trigger_multiple ( edict_t * ent ) ;
extern void trigger_enable ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void Touch_Multi ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void Use_Multi ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void multi_trigger ( edict_t * ent ) ;
extern void multi_wait ( edict_t * ent ) ;
extern void InitTrigger ( edict_t * self ) ;
extern void SP_target_earthquake ( edict_t * self ) ;
extern void target_earthquake_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void target_earthquake_think ( edict_t * self ) ;
extern void SP_target_lightramp ( edict_t * self ) ;
extern void target_lightramp_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void target_lightramp_think ( edict_t * self ) ;
extern void SP_target_laser ( edict_t * self ) ;
extern void target_laser_start ( edict_t * self ) ;
extern void target_laser_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void target_laser_off ( edict_t * self ) ;
extern void target_laser_on ( edict_t * self ) ;
extern void target_laser_think ( edict_t * self ) ;
extern void SP_target_crosslevel_target ( edict_t * self ) ;
extern void target_crosslevel_target_think ( edict_t * self ) ;
extern void SP_target_crosslevel_trigger ( edict_t * self ) ;
extern void trigger_crosslevel_trigger_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_target_blaster ( edict_t * self ) ;
extern void use_target_blaster ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_target_spawner ( edict_t * self ) ;
extern void use_target_spawner ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_target_splash ( edict_t * self ) ;
extern void use_target_splash ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_target_changelevel ( edict_t * ent ) ;
extern void use_target_changelevel ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_target_explosion ( edict_t * ent ) ;
extern void use_target_explosion ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void target_explosion_explode ( edict_t * self ) ;
extern void SP_target_goal ( edict_t * ent ) ;
extern void use_target_goal ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void SP_target_secret ( edict_t * ent ) ;
extern void use_target_secret ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void SP_target_help ( edict_t * ent ) ;
extern void Use_Target_Help ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void SP_target_speaker ( edict_t * ent ) ;
extern void Use_Target_Speaker ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void SP_target_temp_entity ( edict_t * ent ) ;
extern void Use_Target_Tent ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void ServerCommand ( void ) ;
extern void SVCmd_WriteIP_f ( void ) ;
extern void SVCmd_ListIP_f ( void ) ;
extern void SVCmd_RemoveIP_f ( void ) ;
extern void SVCmd_AddIP_f ( void ) ;
extern qboolean SV_FilterPacket ( char * from ) ;
extern void Svcmd_Test_f ( void ) ;
extern void Vengeance_Launch ( edict_t * self ) ;
extern void Hunter_Launch ( edict_t * self ) ;
extern void Defender_Launch ( edict_t * self ) ;
extern void Own_Sphere ( edict_t * self , edict_t * sphere ) ;
extern edict_t * Sphere_Spawn ( edict_t * owner , int spawnflags ) ;
extern void vengeance_think ( edict_t * self ) ;
extern void hunter_think ( edict_t * self ) ;
extern void defender_think ( edict_t * self ) ;
extern void vengeance_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void defender_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void hunter_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void body_gib ( edict_t * self ) ;
extern void defender_shoot ( edict_t * self , edict_t * enemy ) ;
extern void hunter_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void vengeance_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void sphere_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf , int mod ) ;
extern void sphere_fire ( edict_t * self , edict_t * enemy ) ;
extern void sphere_chase ( edict_t * self , int stupidChase ) ;
extern void sphere_fly ( edict_t * self ) ;
extern void sphere_if_idle_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void sphere_explode ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void sphere_think_explode ( edict_t * self ) ;
extern void Widowlegs_Spawn ( vec3_t startpos , vec3_t angles ) ;
extern void widowlegs_think ( edict_t * self ) ;
extern void SpawnGrow_Spawn ( vec3_t startpos , int size ) ;
extern void spawngrow_think ( edict_t * self ) ;
extern void DetermineBBox ( char * classname , vec3_t mins , vec3_t maxs ) ;
extern qboolean CheckGroundSpawnPoint ( vec3_t origin , vec3_t entMins , vec3_t entMaxs , float height , float gravity ) ;
extern qboolean CheckSpawnPoint ( vec3_t origin , vec3_t mins , vec3_t maxs ) ;
extern qboolean FindSpawnPoint ( vec3_t startpoint , vec3_t mins , vec3_t maxs , vec3_t spawnpoint , float maxMoveUp ) ;
extern edict_t * CreateGroundMonster ( vec3_t origin , vec3_t angles , vec3_t entMins , vec3_t entMaxs , char * classname , int height ) ;
extern edict_t * CreateFlyMonster ( vec3_t origin , vec3_t angles , vec3_t mins , vec3_t maxs , char * classname ) ;
extern edict_t * CreateMonster ( vec3_t origin , vec3_t angles , char * classname ) ;
extern void SP_worldspawn ( edict_t * ent ) ;
extern void SpawnEntities ( const char * mapname , char * entities , const char * spawnpoint ) ;
extern void G_FindTeams ( void ) ;
extern void G_FixTeams ( void ) ;
extern char * ED_ParseEdict ( char * data , edict_t * ent ) ;
extern void ED_ParseField ( const char * key , const char * value , edict_t * ent ) ;
extern char * ED_NewString ( const char * string ) ;
extern void ED_CallSpawn ( edict_t * ent ) ;
extern void SV_Physics_NewToss ( edict_t * ent ) ;
extern void G_RunEntity ( edict_t * ent ) ;
extern void SV_Physics_Step ( edict_t * ent ) ;
extern void SV_AddRotationalFriction ( edict_t * ent ) ;
extern void SV_Physics_Toss ( edict_t * ent ) ;
extern void SV_Physics_Noclip ( edict_t * ent ) ;
extern void SV_Physics_None ( edict_t * ent ) ;
extern void SV_Physics_Pusher ( edict_t * ent ) ;
extern qboolean SV_Push ( edict_t * pusher , vec3_t move , vec3_t amove ) ;
extern trace_t SV_PushEntity ( edict_t * ent , vec3_t push ) ;
extern void RealBoundingBox ( edict_t * ent , vec3_t mins , vec3_t maxs ) ;
extern void SV_AddGravity ( edict_t * ent ) ;
extern int SV_FlyMove ( edict_t * ent , float time , int mask ) ;
extern int ClipVelocity ( vec3_t in , vec3_t normal , vec3_t out , float overbounce ) ;
extern void SV_Impact ( edict_t * e1 , trace_t * trace ) ;
extern qboolean SV_RunThink ( edict_t * ent ) ;
extern void SV_CheckVelocity ( edict_t * ent ) ;
extern edict_t * SV_TestEntityPosition ( edict_t * ent ) ;
extern void fire_tracker ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , edict_t * enemy ) ;
extern void tracker_fly ( edict_t * self ) ;
extern void tracker_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void tracker_explode ( edict_t * self ) ;
extern void tracker_pain_daemon_spawn ( edict_t * owner , edict_t * enemy , int damage ) ;
extern void tracker_pain_daemon_think ( edict_t * self ) ;
extern void fire_blaster2 ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , int effect , qboolean hyper ) ;
extern void blaster2_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void fire_heat ( edict_t * self , vec3_t start , vec3_t aimdir , vec3_t offset , int damage , int kick , qboolean monster ) ;
extern void fire_beams ( edict_t * self , vec3_t start , vec3_t aimdir , vec3_t offset , int damage , int kick , int te_beam , int te_impact , int mod ) ;
extern void fire_tesla ( edict_t * self , vec3_t start , vec3_t aimdir , int damage_multiplier , int speed ) ;
extern void tesla_lava ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void tesla_think ( edict_t * ent ) ;
extern void tesla_activate ( edict_t * self ) ;
extern void tesla_think_active ( edict_t * self ) ;
extern void tesla_zap ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void tesla_blow ( edict_t * self ) ;
extern void tesla_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void tesla_remove ( edict_t * self ) ;
extern void fire_nuke ( edict_t * self , vec3_t start , vec3_t aimdir , int speed ) ;
extern void nuke_bounce ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void Nuke_Think ( edict_t * ent ) ;
extern void nuke_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void Nuke_Explode ( edict_t * ent ) ;
extern void Nuke_Quake ( edict_t * self ) ;
extern void fire_player_melee ( edict_t * self , vec3_t start , vec3_t aim , int reach , int damage , int kick , int quiet , int mod ) ;
extern void fire_prox ( edict_t * self , vec3_t start , vec3_t aimdir , int damage_multiplier , int speed ) ;
extern void prox_land ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void prox_open ( edict_t * ent ) ;
extern void prox_seek ( edict_t * ent ) ;
extern void Prox_Field_Touch ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void prox_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void Prox_Explode ( edict_t * ent ) ;
extern void fire_flechette ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , int kick ) ;
extern void flechette_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_trigger_disguise ( edict_t * self ) ;
extern void trigger_disguise_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void trigger_disguise_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_trigger_teleport ( edict_t * self ) ;
extern void trigger_teleport_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void trigger_teleport_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_info_teleport_destination ( edict_t * self ) ;
extern void SP_target_orb ( edict_t * ent ) ;
extern void orb_think ( edict_t * self ) ;
extern void SP_target_blacklight ( edict_t * ent ) ;
extern void blacklight_think ( edict_t * self ) ;
extern void SP_target_killplayers ( edict_t * self ) ;
extern void target_killplayers_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_target_anger ( edict_t * self ) ;
extern void target_anger_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_target_steam ( edict_t * self ) ;
extern void target_steam_start ( edict_t * self ) ;
extern void use_target_steam ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_func_force_wall ( edict_t * ent ) ;
extern void force_wall_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void force_wall_think ( edict_t * self ) ;
extern void SP_func_door_secret2 ( edict_t * ent ) ;
extern void secret_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void secret_blocked ( edict_t * self , edict_t * other ) ;
extern void fd_secret_done ( edict_t * self ) ;
extern void fd_secret_move6 ( edict_t * self ) ;
extern void fd_secret_move5 ( edict_t * self ) ;
extern void fd_secret_move4 ( edict_t * self ) ;
extern void fd_secret_move3 ( edict_t * self ) ;
extern void fd_secret_move2 ( edict_t * self ) ;
extern void fd_secret_move1 ( edict_t * self ) ;
extern void fd_secret_killed ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void fd_secret_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void fire_doppleganger ( edict_t * ent , vec3_t start , vec3_t aimdir ) ;
extern void body_think ( edict_t * self ) ;
extern void doppleganger_timeout ( edict_t * self ) ;
extern void doppleganger_pain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void doppleganger_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void PrecacheForRandomRespawn ( void ) ;
extern edict_t * DoRandomRespawn ( edict_t * ent ) ;
extern char * FindSubstituteItem ( edict_t * ent ) ;
extern void InitGameRules ( void ) ;
extern qboolean monster_jump_finished ( edict_t * self ) ;
extern void monster_jump_start ( edict_t * self ) ;
extern int CountPlayers ( void ) ;
extern edict_t * PickCoopTarget ( edict_t * self ) ;
extern void TargetTesla ( edict_t * self , edict_t * tesla ) ;
extern qboolean has_valid_enemy ( edict_t * self ) ;
extern void monster_duck_up ( edict_t * self ) ;
extern void monster_duck_hold ( edict_t * self ) ;
extern void monster_duck_down ( edict_t * self ) ;
extern void M_MonsterDodge ( edict_t * self , edict_t * attacker , float eta , trace_t * tr ) ;
extern void drawbbox ( edict_t * self ) ;
extern qboolean below ( edict_t * self , edict_t * other ) ;
extern void PredictAim ( edict_t * target , vec3_t start , float bolt_speed , qboolean eye_height , float offset , vec3_t aimdir , vec3_t aimpoint ) ;
extern qboolean MarkTeslaArea ( edict_t * self , edict_t * tesla ) ;
extern edict_t * CheckForBadArea ( edict_t * ent ) ;
extern edict_t * SpawnBadArea ( vec3_t mins , vec3_t maxs , float lifespan , edict_t * owner ) ;
extern void badarea_touch ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern qboolean face_wall ( edict_t * self ) ;
extern float realrange ( edict_t * self , edict_t * other ) ;
extern qboolean inback ( edict_t * self , edict_t * other ) ;
extern void InitHintPaths ( void ) ;
extern void SP_hint_path ( edict_t * self ) ;
extern void hint_path_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern qboolean monsterlost_checkhint ( edict_t * self ) ;
extern void hintpath_stop ( edict_t * self ) ;
extern void hintpath_go ( edict_t * self , edict_t * point ) ;
extern edict_t * hintpath_other_end ( edict_t * ent ) ;
extern edict_t * hintpath_findstart ( edict_t * ent ) ;
extern qboolean blocked_checknewenemy ( edict_t * self ) ;
extern qboolean blocked_checkjump ( edict_t * self , float dist , float maxDown , float maxUp ) ;
extern qboolean blocked_checkplat ( edict_t * self , float dist ) ;
extern qboolean blocked_checkshot ( edict_t * self , float shotChance ) ;
extern void monster_done_dodge ( edict_t * self ) ;
extern void stationarymonster_start ( edict_t * self ) ;
extern void stationarymonster_start_go ( edict_t * self ) ;
extern void stationarymonster_triggered_start ( edict_t * self ) ;
extern void stationarymonster_triggered_spawn_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void stationarymonster_triggered_spawn ( edict_t * self ) ;
extern void swimmonster_start ( edict_t * self ) ;
extern void swimmonster_start_go ( edict_t * self ) ;
extern void flymonster_start ( edict_t * self ) ;
extern void flymonster_start_go ( edict_t * self ) ;
extern void walkmonster_start ( edict_t * self ) ;
extern void walkmonster_start_go ( edict_t * self ) ;
extern void monster_start_go ( edict_t * self ) ;
extern qboolean monster_start ( edict_t * self ) ;
extern void monster_death_use ( edict_t * self ) ;
extern void monster_triggered_start ( edict_t * self ) ;
extern void monster_triggered_spawn_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void monster_triggered_spawn ( edict_t * self ) ;
extern void monster_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void monster_think ( edict_t * self ) ;
extern void M_MoveFrame ( edict_t * self ) ;
extern void M_SetEffects ( edict_t * ent ) ;
extern void M_droptofloor ( edict_t * ent ) ;
extern void M_WorldEffects ( edict_t * ent ) ;
extern void M_CatagorizePosition ( edict_t * ent ) ;
extern void M_CheckGround ( edict_t * ent ) ;
extern void AttackFinished ( edict_t * self , float time ) ;
extern void M_FlyCheck ( edict_t * self ) ;
extern void M_FliesOn ( edict_t * self ) ;
extern void M_FliesOff ( edict_t * self ) ;
extern void monster_fire_bfg ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int speed , int kick , float damage_radius , int flashtype ) ;
extern void monster_fire_railgun ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int kick , int flashtype ) ;
extern void monster_fire_rocket ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , int flashtype ) ;
extern void monster_fire_grenade ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int speed , int flashtype ) ;
extern void monster_fire_heat ( edict_t * self , vec3_t start , vec3_t dir , vec3_t offset , int damage , int kick , int flashtype ) ;
extern void monster_fire_tracker ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , edict_t * enemy , int flashtype ) ;
extern void monster_fire_blaster2 ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , int flashtype , int effect ) ;
extern void monster_fire_blaster ( edict_t * self , vec3_t start , vec3_t dir , int damage , int speed , int flashtype , int effect ) ;
extern void monster_fire_shotgun ( edict_t * self , vec3_t start , vec3_t aimdir , int damage , int kick , int hspread , int vspread , int count , int flashtype ) ;
extern void monster_fire_bullet ( edict_t * self , vec3_t start , vec3_t dir , int damage , int kick , int hspread , int vspread , int flashtype ) ;
extern void SP_misc_nuke_core ( edict_t * ent ) ;
extern void misc_nuke_core_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_misc_teleporter_dest ( edict_t * ent ) ;
extern void SP_misc_teleporter ( edict_t * ent ) ;
extern void teleporter_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_func_clock ( edict_t * self ) ;
extern void func_clock_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void func_clock_think ( edict_t * self ) ;
extern void func_clock_format_countdown ( edict_t * self ) ;
extern void func_clock_reset ( edict_t * self ) ;
extern void SP_target_string ( edict_t * self ) ;
extern void target_string_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_target_character ( edict_t * self ) ;
extern void SP_misc_gib_head ( edict_t * ent ) ;
extern void SP_misc_gib_leg ( edict_t * ent ) ;
extern void SP_misc_gib_arm ( edict_t * ent ) ;
extern void SP_light_mine2 ( edict_t * ent ) ;
extern void SP_light_mine1 ( edict_t * ent ) ;
extern void SP_misc_satellite_dish ( edict_t * ent ) ;
extern void misc_satellite_dish_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void misc_satellite_dish_think ( edict_t * self ) ;
extern void SP_misc_strogg_ship ( edict_t * ent ) ;
extern void misc_strogg_ship_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_misc_viper_bomb ( edict_t * self ) ;
extern void misc_viper_bomb_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void misc_viper_bomb_prethink ( edict_t * self ) ;
extern void misc_viper_bomb_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_misc_bigviper ( edict_t * ent ) ;
extern void SP_misc_viper ( edict_t * ent ) ;
extern void misc_viper_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_misc_deadsoldier ( edict_t * ent ) ;
extern void misc_deadsoldier_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void SP_misc_banner ( edict_t * ent ) ;
extern void misc_banner_think ( edict_t * ent ) ;
extern void SP_monster_commander_body ( edict_t * self ) ;
extern void commander_body_drop ( edict_t * self ) ;
extern void commander_body_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void commander_body_think ( edict_t * self ) ;
extern void SP_misc_easterchick2 ( edict_t * ent ) ;
extern void misc_easterchick2_think ( edict_t * self ) ;
extern void SP_misc_easterchick ( edict_t * ent ) ;
extern void misc_easterchick_think ( edict_t * self ) ;
extern void SP_misc_eastertank ( edict_t * ent ) ;
extern void misc_eastertank_think ( edict_t * self ) ;
extern void SP_misc_blackhole ( edict_t * ent ) ;
extern void misc_blackhole_think ( edict_t * self ) ;
extern void misc_blackhole_use ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void SP_misc_explobox ( edict_t * self ) ;
extern void barrel_start ( edict_t * self ) ;
extern void barrel_think ( edict_t * self ) ;
extern void barrel_delay ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void barrel_explode ( edict_t * self ) ;
extern void barrel_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_func_explosive ( edict_t * self ) ;
extern void func_explosive_spawn ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void func_explosive_activate ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void func_explosive_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void func_explosive_explode ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void SP_func_object ( edict_t * self ) ;
extern void func_object_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void func_object_release ( edict_t * self ) ;
extern void func_object_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_func_wall ( edict_t * self ) ;
extern void func_wall_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_light ( edict_t * self ) ;
extern void light_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_info_notnull ( edict_t * self ) ;
extern void SP_info_null ( edict_t * self ) ;
extern void SP_viewthing ( edict_t * ent ) ;
extern void TH_viewthing ( edict_t * ent ) ;
extern void SP_point_combat ( edict_t * self ) ;
extern void point_combat_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void SP_path_corner ( edict_t * self ) ;
extern void path_corner_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void BecomeExplosion2 ( edict_t * self ) ;
extern void BecomeExplosion1 ( edict_t * self ) ;
extern void ThrowDebris ( edict_t * self , char * modelname , float speed , vec3_t origin ) ;
extern void debris_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void ThrowClientHead ( edict_t * self , int damage ) ;
extern void ThrowHead ( edict_t * self , char * gibname , int damage , int type ) ;
extern void ThrowGib ( edict_t * self , char * gibname , int damage , int type ) ;
extern void gib_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void gib_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void gib_think ( edict_t * self ) ;
extern void ClipGibVelocity ( edict_t * ent ) ;
extern void VelocityForDamage ( int damage , vec3_t v ) ;
extern void SP_func_areaportal ( edict_t * ent ) ;
extern void Use_Areaportal ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void G_RunFrame ( void ) ;
extern void ExitLevel ( void ) ;
extern void CheckDMRules ( void ) ;
extern void CheckNeedPass ( void ) ;
extern void EndDMLevel ( void ) ;
extern edict_t * CreateTargetChangeLevel ( char * map ) ;
extern void ClientEndServerFrames ( void ) ;
extern void Com_Printf ( char * msg , ... ) ;
extern void Sys_Error ( char * error , ... ) ;
extern game_export_t * GetGameAPI ( game_import_t * import ) ;
extern void ShutdownGame ( void ) ;
extern void SP_xatrix_item ( edict_t * self ) ;
extern void SetItemNames ( void ) ;
extern void InitItems ( void ) ;
extern void SP_item_health_mega ( edict_t * self ) ;
extern void SP_item_health_large ( edict_t * self ) ;
extern void SP_item_health_small ( edict_t * self ) ;
extern void SP_item_health ( edict_t * self ) ;
extern void SpawnItem ( edict_t * ent , gitem_t * item ) ;
extern void SetTriggeredSpawn ( edict_t * ent ) ;
extern void Item_TriggeredSpawn ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void PrecacheItem ( gitem_t * it ) ;
extern void droptofloor ( edict_t * ent ) ;
extern void Use_Item ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern edict_t * Drop_Item ( edict_t * ent , gitem_t * item ) ;
extern void drop_make_touchable ( edict_t * ent ) ;
extern void drop_temp_touch ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void Touch_Item ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void Drop_PowerArmor ( edict_t * ent , gitem_t * item ) ;
extern qboolean Pickup_PowerArmor ( edict_t * ent , edict_t * other ) ;
extern void Use_PowerArmor ( edict_t * ent , gitem_t * item ) ;
extern int PowerArmorType ( edict_t * ent ) ;
extern qboolean Pickup_Armor ( edict_t * ent , edict_t * other ) ;
extern int ArmorIndex ( edict_t * ent ) ;
extern qboolean Pickup_Health ( edict_t * ent , edict_t * other ) ;
extern void MegaHealth_think ( edict_t * self ) ;
extern void Drop_Ammo ( edict_t * ent , gitem_t * item ) ;
extern qboolean Pickup_Ammo ( edict_t * ent , edict_t * other ) ;
extern qboolean Add_Ammo ( edict_t * ent , gitem_t * item , int count ) ;
extern qboolean Pickup_Key ( edict_t * ent , edict_t * other ) ;
extern void Use_Silencer ( edict_t * ent , gitem_t * item ) ;
extern void Use_Invulnerability ( edict_t * ent , gitem_t * item ) ;
extern void Use_Envirosuit ( edict_t * ent , gitem_t * item ) ;
extern void Use_Breather ( edict_t * ent , gitem_t * item ) ;
extern void Use_Quad ( edict_t * ent , gitem_t * item ) ;
extern void Use_Vengeance ( edict_t * ent , gitem_t * item ) ;
extern void Use_Hunter ( edict_t * ent , gitem_t * item ) ;
extern void Use_Defender ( edict_t * ent , gitem_t * item ) ;
extern qboolean Pickup_Sphere ( edict_t * ent , edict_t * other ) ;
extern qboolean Pickup_Doppleganger ( edict_t * ent , edict_t * other ) ;
extern void Use_Doppleganger ( edict_t * ent , gitem_t * item ) ;
extern void Use_Nuke ( edict_t * ent , gitem_t * item ) ;
extern void Use_Compass ( edict_t * ent , gitem_t * item ) ;
extern void Use_Double ( edict_t * ent , gitem_t * item ) ;
extern void Use_IR ( edict_t * ent , gitem_t * item ) ;
extern qboolean Pickup_Nuke ( edict_t * ent , edict_t * other ) ;
extern qboolean Pickup_Pack ( edict_t * ent , edict_t * other ) ;
extern qboolean Pickup_Bandolier ( edict_t * ent , edict_t * other ) ;
extern qboolean Pickup_AncientHead ( edict_t * ent , edict_t * other ) ;
extern qboolean Pickup_Adrenaline ( edict_t * ent , edict_t * other ) ;
extern void Drop_General ( edict_t * ent , gitem_t * item ) ;
extern qboolean Pickup_Powerup ( edict_t * ent , edict_t * other ) ;
extern void SetRespawn ( edict_t * ent , float delay ) ;
extern void DoRespawn ( edict_t * ent ) ;
extern gitem_t * FindItem ( char * pickup_name ) ;
extern gitem_t * FindItemByClassname ( char * classname ) ;
extern gitem_t * GetItemByIndex ( int index ) ;
extern void SP_func_killbox ( edict_t * ent ) ;
extern void use_killbox ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_func_door_secret ( edict_t * ent ) ;
extern void door_secret_die ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void door_secret_blocked ( edict_t * self , edict_t * other ) ;
extern void door_secret_done ( edict_t * self ) ;
extern void door_secret_move6 ( edict_t * self ) ;
extern void door_secret_move5 ( edict_t * self ) ;
extern void door_secret_move4 ( edict_t * self ) ;
extern void door_secret_move3 ( edict_t * self ) ;
extern void door_secret_move2 ( edict_t * self ) ;
extern void door_secret_move1 ( edict_t * self ) ;
extern void door_secret_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_func_conveyor ( edict_t * self ) ;
extern void func_conveyor_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_func_timer ( edict_t * self ) ;
extern void func_timer_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void func_timer_think ( edict_t * self ) ;
extern void SP_trigger_elevator ( edict_t * self ) ;
extern void trigger_elevator_init ( edict_t * self ) ;
extern void trigger_elevator_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_func_train ( edict_t * self ) ;
extern void train_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void func_train_find ( edict_t * self ) ;
extern void train_resume ( edict_t * self ) ;
extern void train_next ( edict_t * self ) ;
extern void train_piece_wait ( edict_t * self ) ;
extern void train_wait ( edict_t * self ) ;
extern void train_blocked ( edict_t * self , edict_t * other ) ;
extern void SP_func_water ( edict_t * self ) ;
extern void smart_water_blocked ( edict_t * self , edict_t * other ) ;
extern void SP_func_door_rotating ( edict_t * ent ) ;
extern void Door_Activate ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void SP_func_door ( edict_t * ent ) ;
extern void door_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void door_killed ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void door_blocked ( edict_t * self , edict_t * other ) ;
extern void Think_SpawnDoorTrigger ( edict_t * ent ) ;
extern void Think_CalcMoveSpeed ( edict_t * self ) ;
extern void Touch_DoorTrigger ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void door_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void smart_water_go_up ( edict_t * self ) ;
extern void door_go_up ( edict_t * self , edict_t * activator ) ;
extern void door_go_down ( edict_t * self ) ;
extern void door_hit_bottom ( edict_t * self ) ;
extern void door_hit_top ( edict_t * self ) ;
extern void door_use_areaportals ( edict_t * self , qboolean open ) ;
extern void SP_func_button ( edict_t * ent ) ;
extern void button_killed ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void button_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void button_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void button_fire ( edict_t * self ) ;
extern void button_wait ( edict_t * self ) ;
extern void button_return ( edict_t * self ) ;
extern void button_done ( edict_t * self ) ;
extern void SP_func_rotating ( edict_t * ent ) ;
extern void rotating_use ( edict_t * self , edict_t * other , edict_t * activator ) ;
extern void rotating_touch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void rotating_blocked ( edict_t * self , edict_t * other ) ;
extern void rotating_decel ( edict_t * self ) ;
extern void rotating_accel ( edict_t * self ) ;
extern void SP_func_plat2 ( edict_t * ent ) ;
extern void plat2_activate ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void Use_Plat2 ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void plat2_blocked ( edict_t * self , edict_t * other ) ;
extern void Touch_Plat_Center2 ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void plat2_operate ( edict_t * ent , edict_t * other ) ;
extern void plat2_go_up ( edict_t * ent ) ;
extern void plat2_go_down ( edict_t * ent ) ;
extern void plat2_hit_bottom ( edict_t * ent ) ;
extern void plat2_hit_top ( edict_t * ent ) ;
extern void plat2_kill_danger_area ( edict_t * ent ) ;
extern void plat2_spawn_danger_area ( edict_t * ent ) ;
extern void SP_func_plat ( edict_t * ent ) ;
extern edict_t * plat_spawn_inside_trigger ( edict_t * ent ) ;
extern void Touch_Plat_Center ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void Use_Plat ( edict_t * ent , edict_t * other , edict_t * activator ) ;
extern void plat_blocked ( edict_t * self , edict_t * other ) ;
extern void plat_go_up ( edict_t * ent ) ;
extern void plat_go_down ( edict_t * ent ) ;
extern void plat_hit_bottom ( edict_t * ent ) ;
extern void plat_hit_top ( edict_t * ent ) ;
extern void Think_AccelMove ( edict_t * ent ) ;
extern void plat_Accelerate ( moveinfo_t * moveinfo ) ;
extern void plat_CalcAcceleratedMove ( moveinfo_t * moveinfo ) ;
extern void AngleMove_Calc ( edict_t * ent , void ( * func ) ( edict_t * ) ) ;
extern void AngleMove_Begin ( edict_t * ent ) ;
extern void AngleMove_Final ( edict_t * ent ) ;
extern void AngleMove_Done ( edict_t * ent ) ;
extern void Move_Calc ( edict_t * ent , vec3_t dest , void ( * func ) ( edict_t * ) ) ;
extern void Move_Begin ( edict_t * ent ) ;
extern void Move_Final ( edict_t * ent ) ;
extern void Move_Done ( edict_t * ent ) ;
extern void T_RadiusClassDamage ( edict_t * inflictor , edict_t * attacker , float damage , char * ignoreClass , float radius , int mod ) ;
extern void T_RadiusNukeDamage ( edict_t * inflictor , edict_t * attacker , float damage , edict_t * ignore , float radius , int mod ) ;
extern void T_RadiusDamage ( edict_t * inflictor , edict_t * attacker , float damage , edict_t * ignore , float radius , int mod ) ;
extern void T_Damage ( edict_t * targ , edict_t * inflictor , edict_t * attacker , vec3_t dir , vec3_t point , vec3_t normal , int damage , int knockback , int dflags , int mod ) ;
extern qboolean CheckTeamDamage ( edict_t * targ , edict_t * attacker ) ;
extern void M_ReactToDamage ( edict_t * targ , edict_t * attacker , edict_t * inflictor ) ;
extern int CheckArmor ( edict_t * ent , vec3_t point , vec3_t normal , int damage , int te_sparks , int dflags ) ;
extern int CheckPowerArmor ( edict_t * ent , vec3_t point , vec3_t normal , int damage , int dflags ) ;
extern void SpawnDamage ( int type , vec3_t origin , vec3_t normal , int damage ) ;
extern void Killed ( edict_t * targ , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern qboolean CanDamage ( edict_t * targ , edict_t * inflictor ) ;
extern void cleanupHealTarget ( edict_t * ent ) ;
extern void ClientCommand ( edict_t * ent ) ;
extern void Cmd_PlayerList_f ( edict_t * ent ) ;
extern void Cmd_Ent_Count_f ( edict_t * ent ) ;
extern void Cmd_Say_f ( edict_t * ent , qboolean team , qboolean arg0 ) ;
extern void Cmd_Wave_f ( edict_t * ent ) ;
extern void Cmd_Players_f ( edict_t * ent ) ;
extern int PlayerSort ( void const * a , void const * b ) ;
extern void Cmd_PutAway_f ( edict_t * ent ) ;
extern void Cmd_Kill_f ( edict_t * ent ) ;
extern void Cmd_InvDrop_f ( edict_t * ent ) ;
extern void Cmd_WeapLast_f ( edict_t * ent ) ;
extern void Cmd_WeapNext_f ( edict_t * ent ) ;
extern void Cmd_WeapPrev_f ( edict_t * ent ) ;
extern void Cmd_InvUse_f ( edict_t * ent ) ;
extern void Cmd_Inven_f ( edict_t * ent ) ;
extern void Cmd_Drop_f ( edict_t * ent ) ;
extern void Cmd_Use_f ( edict_t * ent ) ;
extern void Cmd_Noclip_f ( edict_t * ent ) ;
extern void Cmd_Notarget_f ( edict_t * ent ) ;
extern void Cmd_God_f ( edict_t * ent ) ;
extern void Cmd_Give_f ( edict_t * ent ) ;
extern void ValidateSelectedItem ( edict_t * ent ) ;
extern void SelectPrevItem ( edict_t * ent , int itflags ) ;
extern void SelectNextItem ( edict_t * ent , int itflags ) ;
extern qboolean OnSameTeam ( edict_t * ent1 , edict_t * ent2 ) ;
extern void GetChaseTarget ( edict_t * ent ) ;
extern void ChasePrev ( edict_t * ent ) ;
extern void ChaseNext ( edict_t * ent ) ;
extern void UpdateChaseCam ( edict_t * ent ) ;
extern void ai_run ( edict_t * self , float dist ) ;
extern qboolean ai_checkattack ( edict_t * self , float dist ) ;
extern void ai_run_slide ( edict_t * self , float distance ) ;
extern void ai_run_missile ( edict_t * self ) ;
extern void ai_run_melee ( edict_t * self ) ;
extern qboolean M_CheckAttack ( edict_t * self ) ;
extern qboolean FacingIdeal ( edict_t * self ) ;
extern qboolean FindTarget ( edict_t * self ) ;
extern void FoundTarget ( edict_t * self ) ;
extern void HuntTarget ( edict_t * self ) ;
extern qboolean infront ( edict_t * self , edict_t * other ) ;
extern qboolean visible ( edict_t * self , edict_t * other ) ;
extern int range ( edict_t * self , edict_t * other ) ;
extern void ai_turn ( edict_t * self , float dist ) ;
extern void ai_charge ( edict_t * self , float dist ) ;
extern void ai_walk ( edict_t * self , float dist ) ;
extern void ai_stand ( edict_t * self , float dist ) ;
extern void ai_move ( edict_t * self , float dist ) ;
extern void AI_SetSightClient ( void ) ;
extern void SP_dm_tag_token ( edict_t * self ) ;
extern void Tag_PostInitSetup ( void ) ;
extern void Tag_GameInit ( void ) ;
extern int Tag_ChangeDamage ( edict_t * targ , edict_t * attacker , int damage , int mod ) ;
extern void Tag_DogTag ( edict_t * ent , edict_t * killer , char * * pic ) ;
extern void Tag_PlayerEffects ( edict_t * ent ) ;
extern void Tag_DropToken ( edict_t * ent , gitem_t * item ) ;
extern void Tag_MakeTouchable ( edict_t * ent ) ;
extern void Tag_Respawn ( edict_t * ent ) ;
extern qboolean Tag_PickupToken ( edict_t * ent , edict_t * other ) ;
extern void Tag_Score ( edict_t * attacker , edict_t * victim , int scoreChange ) ;
extern void Tag_PlayerDisconnect ( edict_t * self ) ;
extern void Tag_KillItBonus ( edict_t * self ) ;
extern void Tag_PlayerDeath ( edict_t * targ , edict_t * inflictor , edict_t * attacker ) ;
extern void SP_dm_dball_goal ( edict_t * self ) ;
extern void SP_dm_dball_speed_change ( edict_t * self ) ;
extern void SP_dm_dball_ball_start ( edict_t * self ) ;
extern void SP_dm_dball_team2_start ( edict_t * self ) ;
extern void SP_dm_dball_team1_start ( edict_t * self ) ;
extern void SP_dm_dball_ball ( edict_t * self ) ;
extern void DBall_SpeedTouch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern void DBall_BallRespawn ( edict_t * self ) ;
extern void DBall_BallDie ( edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point ) ;
extern void DBall_BallPain ( edict_t * self , edict_t * other , float kick , int damage ) ;
extern void DBall_BallTouch ( edict_t * ent , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern edict_t * PickBallStart ( edict_t * ent ) ;
extern void DBall_GoalTouch ( edict_t * self , edict_t * other , cplane_t * plane , csurface_t * surf ) ;
extern int DBall_ChangeKnockback ( edict_t * targ , edict_t * attacker , int knockback , int mod ) ;
extern int DBall_ChangeDamage ( edict_t * targ , edict_t * attacker , int damage , int mod ) ;
extern void DBall_PostInitSetup ( void ) ;
extern void DBall_GameInit ( void ) ;
extern void DBall_SelectSpawnPoint ( edict_t * ent , vec3_t origin , vec3_t angles ) ;
extern void DBall_ClientBegin ( edict_t * ent ) ;
extern int DBall_CheckDMRules ( void ) ;
