#ifndef KEYS_DATA
#define KEYS_DATA

/*
 * This file is part of pspcipher.
 *
 * Copyright (C) 2008 hrimfaxi (outmatch@gmail.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

// Begins our key here
u8 key_d91609f0[16] = {
	0xD0, 0x36, 0x12, 0x75, 0x80, 0x56, 0x20, 0x43,
   	0xC4, 0x30, 0x94, 0x3E, 0x1C, 0x75, 0xD1, 0xBF,
};

u8 key_d9160af0[16] = {
	0x10, 0xA9, 0xAC, 0x16, 0xAE, 0x19, 0xC0, 0x7E,
	0x3B, 0x60, 0x77, 0x86, 0x01, 0x6F, 0xF2, 0x63,
};

u8 key_d9160bf0[16] = {
	0x83, 0x83, 0xF1, 0x37, 0x53, 0xD0, 0xBE, 0xFC,
	0x8D, 0xA7, 0x32, 0x52, 0x46, 0x0A, 0xC2, 0xC2,
};

u8 key_d91611f0[16] = {
	0x61, 0xB0, 0xC0, 0x58, 0x71, 0x57, 0xD9, 0xFA,
	0x74, 0x67, 0x0E, 0x5C, 0x7E, 0x6E, 0x95, 0xB9,
};

u8 key_d91612f0[16] = {
	0x9e, 0x20, 0xe1, 0xcd, 0xd7, 0x88, 0xde, 0xc0,
	0x31, 0x9b, 0x10, 0xaf, 0xc5, 0xb8, 0x73, 0x23,
};

u8 key_d91613f0[16] = {
	0xEB, 0xFF, 0x40, 0xD8, 0xB4, 0x1A, 0xE1, 0x66,
   	0x91, 0x3B, 0x8F, 0x64, 0xB6, 0xFC, 0xB7, 0x12,
};

u8 key_d91614f0[16] = {
	0xFD, 0xF7, 0xB7, 0x3C, 0x9F, 0xD1, 0x33, 0x95, 
	0x11, 0xB8, 0xB5, 0xBB, 0x54, 0x23, 0x73, 0x85, 
};

u8 key_d91615f0[16] = {
	0xC8, 0x03, 0xE3, 0x44, 0x50, 0xF1, 0xE7, 0x2A, 
	0x6A, 0x0D, 0xC3, 0x61, 0xB6, 0x8E, 0x5F, 0x51,
};

u8 key_d91616f0[16] = {
	0x53, 0x03, 0xB8, 0x6A, 0x10, 0x19, 0x98, 0x49,
	0x1C, 0xAF, 0x30, 0xE4, 0x25, 0x1B, 0x6B, 0x28,
};

u8 key_d91617f0[16] = {
	0x02, 0xFA, 0x48, 0x73, 0x75, 0xAF, 0xAE, 0x0A,
   	0x67, 0x89, 0x2B, 0x95, 0x4B, 0x09, 0x87, 0xA3,
};

u8 key_d91618f0[16] = {
	0x96, 0x96, 0x7C, 0xC3, 0xF7, 0x12, 0xDA, 0x62,
	0x1B, 0xF6, 0x9A, 0x9A, 0x44, 0x44, 0xBC, 0x48, 
};

u8 key_d91619f0[16] = {
	0xE0, 0x32, 0xA7, 0x08, 0x6B, 0x2B, 0x29, 0x2C,
	0xD1, 0x4D, 0x5B, 0xEE, 0xA8, 0xC8, 0xB4, 0xE9,
};

u8 key_d91620f0[16] = {
	0x52, 0x1C, 0xB4, 0x5F, 0x40, 0x3B, 0x9A, 0xDD,
	0xAC, 0xFC, 0xEA, 0x92, 0xFD, 0xDD, 0xF5, 0x90,
};

u8 key_d91621f0[16] = {
	0xD1, 0x91, 0x2E, 0xA6, 0x21, 0x14, 0x29, 0x62,
	0xF6, 0xED, 0xAE, 0xCB, 0xDD, 0xA3, 0xBA, 0xFE,
};

u8 key_d91622f0[16] = {
	0x59, 0x5D, 0x78, 0x4D, 0x21, 0xB2, 0x01, 0x17,
	0x6C, 0x9A, 0xB5, 0x1B, 0xDA, 0xB7, 0xF9, 0xE6,
};

u8 key_d91623f0[16] = {
	0xAA, 0x45, 0xEB, 0x4F, 0x62, 0xFB, 0xD1, 0x0D, 
	0x71, 0xD5, 0x62, 0xD2, 0xF5, 0xBF, 0xA5, 0x2F,
};

u8 key_d91624f0[16] = {
	0x61, 0xB7, 0x26, 0xAF, 0x8B, 0xF1, 0x41, 0x58,
	0x83, 0x6A, 0xC4, 0x92, 0x12, 0xCB, 0xB1, 0xE9,
};

u8 key_d91628f0[16] = {
	0x49, 0xA4, 0xFC, 0x66, 0xDC, 0xE7, 0x62, 0x21,
	0xDB, 0x18, 0xA7, 0x50, 0xD6, 0xA8, 0xC1, 0xB6,
};

u8 key_d91680f0[16] = {
	0x2C, 0x22, 0x9B, 0x12, 0x36, 0x74, 0x11, 0x67,
	0x49, 0xD1, 0xD1, 0x88, 0x92, 0xF6, 0xA1, 0xD8,
};

u8 key_d91681f0[16] = {
	0x52, 0xB6, 0x36, 0x6C, 0x8C, 0x46, 0x7F, 0x7A, 
	0xCC, 0x11, 0x62, 0x99, 0xC1, 0x99, 0xBE, 0x98, 
};

/* new 2.7X eboot.bin */
u8 ebootbin_271_new[0x10] = {
	0xF4, 0xAE, 0xF4, 0xE1, 0x86, 0xDD, 0xD2, 0x9C,
	0x7C, 0xC5, 0x42, 0xA6, 0x95, 0xA0, 0x83, 0x88,
};

/* new 2.8X eboot.bin */
u8 ebootbin_280_new[0x10] = {
	0xB8, 0x8C, 0x45, 0x8B, 0xB6, 0xE7, 0x6E, 0xB8,
	0x51, 0x59, 0xA6, 0x53, 0x7C, 0x5E, 0x86, 0x31,
};

/* new 3.XX eboot.bin */
u8 ebootbin_300_new[0x10] = {
	0xED, 0x10, 0xE0, 0x36, 0xC4, 0xFE, 0x83, 0xF3,
	0x75, 0x70, 0x5E, 0xF6, 0xA4, 0x40, 0x05, 0xF7,
};

/* new 3.XX eboot.bin */
u8 ebootbin_310_new[0x10] = {
	0x5C, 0x77, 0x0C, 0xBB, 0xB4, 0xC2, 0x4F, 0xA2,
	0x7E, 0x3B, 0x4E, 0xB4, 0xB4, 0xC8, 0x70, 0xAF,
};

CipherKey g_cipher[] = {
	// borrowed from PRXdecrypter 2.6b
	{ 0x8004FD03, ebootbin_271_new, 0x5D, 2 },	// 2.71 eboot.bin
	{ 0xD91605F0, ebootbin_280_new, 0x5D, 2 },	// 2.80 eboot.bin
	{ 0xD91606F0, ebootbin_300_new, 0x5D, 2 },	// 3.00 eboot.bin
	{ 0xD91608F0, ebootbin_310_new, 0x5D, 2 },	// 3.10 eboot.bin

	{ 0xd91609f0, key_d91609f0, 0x5d, 2 },
	{ 0xd9160af0, key_d9160af0, 0x5d, 2 },
	{ 0xd9160bf0, key_d9160bf0, 0x5d, 2 },
	{ 0xd91611f0, key_d91611f0, 0x5d, 2 },
	{ 0xd91612f0, key_d91612f0, 0x5d, 2 },
	{ 0xd91613f0, key_d91613f0, 0x5d, 2 },
	{ 0xd91614f0, key_d91614f0, 0x5d, 2 },
	{ 0xd91615f0, key_d91615f0, 0x5d, 2 },
	{ 0xd91616f0, key_d91616f0, 0x5d, 2 },
	{ 0xd91617f0, key_d91617f0, 0x5d, 2 },
	{ 0xd91618f0, key_d91618f0, 0x5d, 2 },
	{ 0xd91619f0, key_d91619f0, 0x5d, 2 },
	{ 0xd91620f0, key_d91620f0, 0x5d, 2 },
	{ 0xd91621f0, key_d91621f0, 0x5d, 2 },
	{ 0xd91622f0, key_d91622f0, 0x5d, 2 },
	{ 0xd91623f0, key_d91623f0, 0x5d, 2 },
	{ 0xd91624f0, key_d91624f0, 0x5d, 2 },
	{ 0xd91628f0, key_d91628f0, 0x5d, 2 },
	{ 0xd91680f0, key_d91680f0, 0x5d, 6 },
	{ 0xd91681f0, key_d91681f0, 0x5d, 6 },
};

#endif
