# CSGO Crash Exploit

Allows you to crash any **Windows** user in any CSGO match.

---

# THIS HAS BEEN PATCHED AFTER THE RECENT UPDATE ON THE 22nd AUGUST 2019

---

# 19th August 2019 Update

- No longer works if `cl_invites_only_friends` is set to `1`
- No longer works in game if `cl_invites_only_mainmenu` is set to `1`

# Usage

1. Download this script **including the `protobufs` folder** or run `git clone --recursive https://github.com/BeepFelix/csgo-crash-exploit.git`
2. Generate a Steam account from [here](https://accgen.cathook.club/)
3. Rename `config.json.example` into `config.json` and fill it in with the generated account details
4. Install [NodeJS](https://nodejs.org/en/download/)
5. Open a command prompt in the `csgo-crash-exploit` folder and enter `npm install`
6. Enter `node index.js`
7. Follow the onscreen instructions

# How and why did this happen?

## Backstory
Panorama is a framework devloped by Valve that is heavily influenced by the modern day front-end development stack with technologies such as HTML, JS, and CSS. The Panorama framework was originally developed for DOTA 2, but later ported to CS:GO in an effort to renew the game's UI.

On top of all this, the framework's source code can be easily viewed by unzipping the `csgo/panorama/code.pbin` file. With this knowledge, exploitation is as easy as looking for vulnerable lines of code also known as a whitebox audit.

Counter-Strike's lobby system is built off of an ancient technology that would not be acceptable to today's standards. This ancient system not so long ago, allowed you to [join anyone's lobby](https://www.youtube.com/watch?v=vHz0LKRzshw), even if you were not friends. It also allows the lobby owner full permission over the lobby metadata such as players in lobby, the lobby type, the lobby location, and even player ranks. This metadata never gets sanitized on the server-side and the client is expected to handle all sanitization.

## The Exploit
Merging the ancient lobby system and the vulnerable Panorama UI together, one can start having fun.

This exploit relies on the [`game:loc`](https://github.com/BeepFelix/csgo-crash-exploit/blob/master/helpers/Lobby.js#L260) metadata key, which when set to a length greater than `2^15` or `32768` and a client is invited, an out of bounds memory write is triggered, leading to an Access Violation/Segmentation Fault which ultimately crashes the CS:GO client.

## How does this happen?
Once a CS:GO user is invited in-game, the `panorama/layout/friendlobby.xml` file is loaded.

This XML file includes a Javascript file (`panorama/scripts/friendlobby.js`) that populates the fields such as the lobby members' avatars, the gamemode, the average lobby rank, and most importantly, the lobby location.

```js
	var _SetFlag = function ( elTile )
	{
		var countryCode = PartyBrowserAPI.GetPartySessionSetting( _m_xuid, 'game/loc' );
		var elFlagImg = elTile.FindChildTraverse( 'JsFriendLobbyFlag' );
		if ( countryCode )
		{
			elFlagImg.SetImage( 'file://{images}/flags/'+ countryCode +'.png' );
			elFlagImg.RemoveClass( 'hidden' );
		}
		else
		{
			elFlagImg.AddClass( 'hidden' );
		}
	};
  ```
This code snippet highlights how the unsanitized `game:loc` metadata key is handled.

When first auditing this code snippet, I was originally testing for a way to truncate the `.png` file extension and load another arbitrary file of my choosing.

Through this testing, I had attempted to fill the `game:loc` with a massive amount of characters, in the hopes that the parser would completely ignore characters after some power of 2 and throw away the file extension, loading my arbitrary file.

Instead of a file being loaded, my client instantly crashed.

After attaching a debugger to analyze the crash, it was revealed that that when the `file://` URI handler was being parsed by the client, one of the intermediary functions that generated a hash of the file path triggered an Access Violation.

The hash function attempted to call the Clang `memset` function and write the parsed filepath to another area of memory without validating the size of the source data. This is called an `Out-of-bounds Write`.

Initially, I had attempted to escalate this vulnerability to an RCE or remote code execution since the Valve bug bounty program would consider a client crasher out of scope. After contacting many friends who were much better than I was at reverse engineering, it was concluded that the most that could be achieved with this exploit was Denial of Service.

# Credits

- Thanks to **[@shayhelman](https://twitter.com/shayhelman)** for finding the crash method
- Thanks to the countless streamers for being our test subjects
