#コーディング面接の大学

>私はもともとこれをソフトウェアエンジニアになるための短いトピックリストとして作成しましたが、
>今日それは大きなリストに成長しました。この調査計画を経て、[私はAmazonで
> ソフトウェアエンジニアとして雇われました！！](https://startupnextdoor.com/ive-been-acquired-by-amazon/?src=ciu)
>おそらく、あなたは私ほど勉強する必要はないでしょう。とにかく、必要なものはすべてここにあります。
>
>ここに掲載されている項目を学べば、Amazon、Facebook、Google、Microsoftなど
>大手企業を含む、ほぼすべてのソフトウェア会社の面接に備えることができます。
>
> *あなたに最高の幸運がありますように!*

翻訳：
- [中文版本](translations/README-cn.md)
- [TiếngViệt - ベトナム語](translations/README-vi.md)
- [Español](translations/README-es.md)

翻訳中：
- [हिन्दी](https://github.com/jwasham/coding-interview-university/issues/81)
- [עברית](https://github.com/jwasham/coding-interview-university/issues/82)
- [インドネシア語](https://github.com/jwasham/coding-interview-university/issues/101)
- [アラビア語](https://github.com/jwasham/coding-interview-university/issues/98)
- [トルコ語](https://github.com/jwasham/coding-interview-university/issues/90)
- [French](https://github.com/jwasham/coding-interview-university/issues/89)
- [ロシア語](https://github.com/jwasham/coding-interview-university/issues/87)
- [ウクライナ](https://github.com/jwasham/coding-interview-university/issues/106)
- [ブラジルのポルトガル語](https://github.com/jwasham/coding-interview-university/issues/113)
- [韓国語](https://github.com/jwasham/coding-interview-university/issues/118)
- [Telugu](https://github.com/jwasham/coding-interview-university/issues/117)
- [Polish](https://github.com/jwasham/coding-interview-university/issues/122)
- [ドイツ語](https://github.com/jwasham/coding-interview-university/issues/135)
- [Urdu](https://github.com/jwasham/coding-interview-university/issues/140)
- [タイ語](https://github.com/jwasham/coding-interview-university/issues/156)
- [ギリシャ語](https://github.com/jwasham/coding-interview-university/issues/166)
- [Italian](https://github.com/jwasham/coding-interview-university/issues/170)

## これは何？

これは、Webエンジニア(独学で、CS学位なし)から大企業のソフトウェアエンジニアを目指すための私の複数月の学習計画です。

![ホワイトボードでのコーディング - HBOのシリコンバレーから](https://dng5l3qzreal6.cloudfront.net/2016/Aug/coding_board_small-1470866369118.jpg)
これは、 **新人ソフトウェアエンジニア** 、またはソフトウェア/ Webエンジニアからソフトウェアエンジニア（CSの知識が必要な場合）に転職する人を対象にしています。
長年のソフトウェアエ開発経験をお持ちの場合は、より面白い面接を期待してください。

あなたに何年ものソフトウェア/Web開発経験がある場合、Google、Amazon、Facebook、Microsoftなどの大規模なソフトウェア会社は、ソフトウェア/Web開発力ではなくソフトウェア工学に関して見ており、そのためにはCSに関する知識が必要となることをご了承ください。

SREまたはシステムエンジニアになりたい場合は、オプションのリスト(ネットワーク、セキュリティ)から詳細を調べてください。

---

## 目次

- [これは何？](#何のことなの？)
- [なぜこれを使うの？](#why-use-it)
- [使い方](#使い方)
- [あなたは十分にスマートではないと感じないでください](十分にスマートではありません)
- [ビデオリソースについて](#about-video-resources)
- [面接のプロセスと一般的な面接の準備](#面接プロセス--一般面接--準備)
- [面接のための1つの言語を選ぶ](面接のために1つの言語を選択する)
- [ブックリスト](#ブックリスト)
- [始める前に](始める前に#)
- あなたがカバーしていないもの(何があなたには見えません)
- [前提知識](#前提条件知識)
- [日々の計画](日々の計画)
- [アルゴリズムの複雑さ/ Big-O / Asymptotic分析](#アルゴリズム--複雑--big-o--漸近分析)
- [データ構造](#データ構造)
	- [配列](#配列)
	- [連結リスト](#連結リスト)
	- [スタック](#スタック)
	- [キュー](#キュー)
	- [ハッシュテーブル](#ハッシュテーブル)
- [その他の知識](#more-knowledge)
	- [二分探索](#二分探索)
	- [ビット演算](#ビット演算)
- [木構造](#木)
	- [木構造 - ノートと背景](#木---ノート--背景)
	- [二分探索木：BST](#binary-search-trees-bsts)
	- [ヒープ/優先度つきキュー/二分ヒープ](#ヒープ--優先度キュー--バイナリヒープ)
	- 平衡探索木(詳細ではなく一般概念)
	- 木の走査(traversal)：行きがけ順(pre-order)、通りがかり順(in-order)、帰りがけ順(postorder)、深さ優先探索(BFS)、幅優先探索(DFS)
- [ソート](#ソート)
	- 選択ソート
	- 挿入ソート
	- ヒープソート
	- クイックソート
	- マージソート
- [グラフ](#グラフ)
	- 有向グラフ
	- 無向グラフ
	- 隣接行列
	- 隣接リスト
	- トラバーサル：BFS、DFS
- [さらに多くの知識](#偶数知識)
	- [再帰](#再帰)
	- [動的プログラミング](#動的プログラミング)
	- [オブジェクト指向プログラミング](#オブジェクト指向プログラミング)
	- [デザインパターン](#デザインパターン)
	- [組み合わせと確率](#combinatorics-n-choose-k--確率)
	- [NP、NP完全/近似アルゴリズム](#np-np-complete-and-approximation-algorithms)
	- [キャッシュ](#キャッシュ)
	- [プロセスとスレッド](#processes-and-threads)
	- [論文](#論文)
	- [テスト](#テスト)
	- [スケジューリング](#スケジューリング)
	- [システムルーチンを実装する](#implement-system-routines)
	- [文字列検索と操作](#文字列検索--操作)
	- [試行](#試行)
	- [浮動小数点数](浮動小数点数)
	- [ユニコード](#ユニコード)
	- [バイト順(エンディアン)](#エンディアン)
- [ネットワーキング](#ネットワーキング)
- [システム設計、スケーラビリティ、データ処理](#システム設計--スケーラビリティなデータ処理)(4年以上の経験がある場合)
- [最終審査](#最終審査)
- [コーディング質問練習](#コーディング質問練習)
- [コーディング練習問題/挑戦](#コーディング演習問題)
- [面接に近づいたら](面接に一度近づいて)
- [履歴書](あなたの履歴書)
- [面接が来たときに考える](面接のときに考えている)
- [面接官に質問があります](#面接のための質問があります)
- [一度あなたは仕事を得た](一度あなたが仕事をしたこと)

----------------この時点より下のものはすべてオプションです----------------

- [追加の書籍](追加の書籍数)
- [追加の学習](追加学習)
	- [コンパイラ](#コンパイラ)
	- [Emacsとvi(m)](#emacs-and-vim)
	- [Unixコマンドラインツール](#unix-command-line-tools)
	- [情報理論](#情報理論)
	- [パリティとハミング符号](#パリティ--ハミングコード)
	- [情報量(エントロピー)](#エントロピー)
	- [暗号化](#暗号化)
	- [圧縮](#圧縮)
	- [コンピュータセキュリティ](#コンピュータセキュリティ)
	- [ガベージコレクション](#ガベージコレクション)
	- [並列計算](#パラレルプログラミング)
	- [メッセージング、シリアライゼーション・キューイングシステム](#メッセージングシリアライゼーションとキューイングシステム)
	- [A *](#a)
	- [高速フーリエ変換](#高速フーリエ変換)
	- [ブルームフィルタ](#ブルームフィルタ)
	- [HyperLogLog](#hyperloglog)
	- [局所性鋭敏型ハッシュ](#ローカリティセンシティブハッシング)
	- [van Emde Boas Trees(バン エンデ ボース)](ヴァン・エムード・ボア・木)
	- [拡張データ構造](#拡張データ構造)
	- [N-ary(k-ary、M-ary)木](#n-ary-k-ary-m-ary-trees)
	- [平衡探索木](#バランス検索木)
	    - AVL木
	    - スプレー木
	    - 赤黒木
	    - 2-3木
	    - 2-3-4木(別名2-4木)
	    - 多分木(N-ary，K-ary，M-ary木)
	    - B木
	- [kd木](#k-d-trees)
	- [スキップリスト](#スキップリスト)
	- [ネットワークのフロー](#ネットワークフロー)
	- [素集合データ構造とUnion-Findアルゴリズム](#disjoint-sets--union-find)
	- [高速処理のための数学](#数学のための高速処理)
	- [Treap](#treap)
	- [線形計画法](#線形計画法)
	- [ジオメトリ、凸包](#ジオメトリ--凸包)
	- [離散数学](離散数学)
	- [機械学習](機械学習)
- [いくつかの科目の追加の詳細](#追加の詳細--いくつかの科目)
- [ビデオシリーズ](#ビデオシリーズ)
- [コンピュータサイエンスコース](#コンピュータサイエンスコース)

## なぜそれを使用するのですか？

私はこのプロジェクトを始めたとき、ヒープからスタックを知りませんでしたし、Big-Oの何か、樹木に関すること、グラフをたどる方法を知らなかったのです。
ソートアルゴリズムをコーディングしなければならない場合は、あまりうまくいきませんでした。
これまで使用してきたすべてのデータ構造は言語に組み込まれていて、どのようにしてそれらがどのようにして動作するのか分かりませんでした。
私が実行していたプロセスが "メモリ不足"エラーを出さない限り、メモリを管理する必要はありませんでしたが、回避策を見つけなければなりません。
私は人生で数多くの多次元配列を使用していましたが、何千もの連想配列を使用しましたが、データ構造を一から作成したことはありません。


それは長い計画です。あなたに数ヶ月かかるかもしれません。
すでに多くのことに慣れていれば、それほど時間がかかりません。

## それの使い方

下のすべてがアウトラインです。
アイテムを上から下に順番に取り組まなければなりません。

私はGithubの特別なマークダウンフレーバーを使用しています。

**新しいブランチを作成して、このような項目をチェックできるようにしてください．xを角かっこに入れてください：[x]**


    ブランチをフォークし、以下のコマンドに従ってください。

`git checkout -b progress`

`git remote add jwasham https://github.com/jwasham/coding-interview-university`

`git fetch --all`

    変更を完了した後にXですべてのボックスにマークを付ける

`git add . `

`git commit -m "マークされたx"`

`git rebase jwasham/master`

`git push --force`

[Github風マークダウンの詳細](https://guides.github.com/features/mastering-markdown/#GitHub-flavored-markdown)

##あなたは十分にスマートではないと感じないでください
- 成功したソフトウェアエンジニアはスマートですが、多くの人はスマートではないという不安があります。
- [Geniusプログラマーの神話](https://www.youtube.com/watch?v=0SARbwvhupQ)
- [一人で行くのは危険だ：テクノロジーの見えない魔物と戦う](https://www.youtube.com/watch?v=1i8ylq4j_EY)

---

##ビデオリソースについて

一部のビデオは、Coursera、EdX、またはLynda.comクラスに登録することによってのみ利用できます。
これらはMOOCと呼ばれています。
時にはクラスがセッションに入っていないので、数ヶ月待つ必要があるため、アクセス権がありません。 
Lynda.comコースは無料ではありません。

    オンラインコースビデオに付随するYouTubeビデオなど、無料で常時利用可能なパブリックソースを追加することに感謝します。
    私は大学の講義を使うのが好きです。


## 面接のプロセスと一般的な面接の準備

- [ ]  [ABC：常にコーディングする](https://medium.com/always-be-coding/abc-always-be-coding-d5f8051afce2#.4heg8zvm4)
- [ ]  [Whiteboarding](https://medium.com/@dpup/whiteboarding-4df873dbba2e#.hf6jn45g1)
- [ ]  [プログラミング面接中の効果的なホワイトボード](http://www.coderust.com/blog/2014/04/10/effective-whiteboarding-during-programming-interviews/)
- [ ]  [技術職募集での謎解き](https://www.youtube.com/watch?v=N233T0epWTs)
- [ ]  クラッキングコーディング面接セット1：
	- [ ]  [Gayle L McDowell - コーディング面接(ビデオ)](https://www.youtube.com/watch?v=rEJzOhC5ZtQ)
	- [ ]  [Gayle Laakmann McDowell(ビデオ)](https://www.youtube.com/watch?v=aClxtDcdpsQ)とのコーディング面接をクラッキング
- [ ]  ビッグ4で仕事を得る方法：
	- [ ]  [Amazon、Facebook、Google、Microsoftで仕事を手に入れる方法(ビデオ)](https://www.youtube.com/watch?v=YJZCUhxNCv8)
- [ ]  準備コース：
    - [ ]  [Software Engineer Interview Unleashed(有料コース)](https://www.udemy.com/software-engineer-interview-unleashed)：
		- 以前のGoogle面接官からソフトウェアエンジニアの面接準備をする方法を学びます。
	- [ ]  [データ構造、アルゴリズム、面接のためのPython! (有料コース)](https://www.udemy.com/python-for-data-structures-algorithms-and-interviews/)：
		- データ構造、アルゴリズム、模擬面接などを扱うPython中心の面接の準備コース。

##面接のための1つの言語を選ぶ

面接のコーディングの部分に慣れ親しんだ言語を使用することはできますが、大企業にとってはこれらの選択肢が確実です。

- C ++
- Java
- Python

これらを使用することもできますが、最初に読んでください。注意が必要な場合があります：

- JavaScript
- Ruby

あなたは言語に非常に慣れて知識が必要です。

選択肢についてもっと読む：
- http://www.byte-by-byte.com/choose-the-right-language-for-your-coding-interview/
- http://blog.codingforinterviews.com/best-programming-language-jobs/

[言語リソースはこちら](programming-language-resources.md)

私は学習しているので、以下に含まれるC、C ++、Pythonの学習を見ることができます。
いくつかの本があります、下を参照してください。

## ブックリスト

これは私が使ったものよりも短いリストです。これは時間を節約するために省略されています。

### 面接の準備

- [ ]  [プログラミング面接の公開：あなたの次の仕事への秘密、第2版](http://www.wiley.com/WileyCDA/WileyTitle/productCd-047012167X.html)
	- C ++とJavaの回答
	- コーディング面接をクラッキングするためのウォームアップが良い
	- あまりにも難しくない、ほとんどの問題はあなたが面接で（私が読んだことから）見ることよりも簡単かもしれない
- [ ]  [Cracking the Coding Interview、第6版](http://www.amazon.com/Cracking-Coding-Interview-6th-Programming/dp/0984782850/)
	- Javaでの回答

もし余分な時間があれば：

- [ ]  [プログラミング面接の要素(C ++版)](https://www.amazon.com/Elements-Programming-Interviews-Insiders-Guide/dp/1479274836)
- [ ]  プログラミング面接の要素(Java版)
	- [本](https://www.amazon.com/Elements-Programming-Interviews-Java-Insiders/dp/1517435803/)
	- [コンパニオンプロジェクト - 本のすべての問題のメソッドスタブとテストケース](https://github.com/gardncl/elements-of-programming-interviews)

### コンピュータアーキテクチャ

短い時間：

- [ ]  [グレートコードの作成：第1巻：マシンの理解](https://www.amazon.com/Write-Great-Code-Understanding-Machine/dp/1593270038)
	- この本は2004年に出版され、幾分古いですが、コンピュータを簡単に理解するには素晴らしいリソースです。
	- 作者はHLAを発明したので、塩の穀物でHLAの言及と例を取り上げます。広く使われているわけではありませんが、どのようなアセンブリのように見えますか？
	- これらの章はあなたに素敵な基礎を与えるために読む価値があります：
		- 第2章 - 数値表現
        - 第3章 - 2進算術とビット演算
		- 第4章 - 浮動小数点表現
		- 第5章 - キャラクター表現
		- 第6章 - メモリ構成とアクセス
        - 第7章 - 複合データ型とメモリオブジェクト
        - 第9章 - CPUアーキテクチャ
		- 第10章 - 命令セットのアーキテクチャ
		- 第11章 - メモリのアーキテクチャと構成

もっと時間があれば(私はこの本が欲しい)：

- [ ]  [Computer Architecture、第5版：定量的アプローチ](https://www.amazon.com/dp/012383872X/)
	- より豊かで最新の(2011年)、より長い治療のために

### 言語固有

**面接の言語を選択する必要があります(上記参照)。** ここで私の推奨する言語です。私はすべての言語のためのリソースがありません。私は追加を歓迎する。

これらのうちの1つを読んだら、コーディングの問題を開始するために必要なすべてのデータ構造とアルゴリズムの知識が必要です。
**あなたがレビューをしたくない場合は、このプロジェクト**のビデオ講義をすべてスキップすることができます。

[ここに言語固有の追加リソースがあります](programming-language-resources.md)

### C++

私はこれらの2つを読んだことはありませんが、Sedgewickによって高く評価され書かれています。彼は素晴らしいです。

- [ ]  [C++でのアルゴリズム、パート1-4：基礎、データ構造、ソート、検索](https://www.amazon.com/Algorithms-Parts-1-4-Fundamentals-Structure/dp/0201350882/)
- [ ]  [C++でのアルゴリズム第5部：グラフアルゴリズム](https://www.amazon.com/Algorithms-Part-Graph-3rd-Pt-5/dp/0201361183/)

C++の推奨事項がある場合は、私に知らせてください。包括的なリソースを探しています。

### Java

- [ ]  [アルゴリズム(Sedgewick and Wayne)](https://www.amazon.com/Algorithms-4th-Robert-Sedgewick/dp/032157351X/)
	- 書籍コンテンツの動画(とSedgewick!)：
		- [アルゴリズム1](https://www.youtube.com/user/algorithmscourses/playlists?view=50&sort=dd&shelf_id=2)
		- [アルゴリズムII](https://www.youtube.com/user/algorithmscourses/playlists?shelf_id=3&view=50&sort=dd)

OR：

- [ ]  [Javaにおけるデータ構造とアルゴリズム](https://www.amazon.com/Data-Structures-Algorithms-Michael-Goodrich/dp/1118771338/)
	- Goodrich、Tamassia、Goldwasserによる
	- UCバークレーのCSイントロコースのオプションテキストとして使用
	- 下のPython版の私の本のレポートを見てください。この本は同じトピックを扱っています。

### Python

- [ ]  [Pythonのデータ構造とアルゴリズム](https://www.amazon.com/Structures-Algorithms-Python-Michael-Goodrich/dp/1118290275/)
	- Goodrich、Tamassia、Goldwasserによる
	- 私はこの本が好きだった。それはすべてをカバーしました。
	- Pythonコード
	- 私の輝く本のレポート：https://startupnextdoor.com/book-report-data-structures-and-algorithms-in-python/


###オプションの書籍

**ソフトウェア工学の長年の経験があり、もっと面白い面接を期待しない限り、これらのことをお勧めする人もいます。**

- [ ]  [アルゴリズム設計マニュアル](http://www.amazon.com/Algorithm-Design-Manual-Steven-Skiena/dp/1849967202)(Skiena)
	- レビューと問題認識として
	- アルゴリズムのカタログ部分は、面接で得られる難易度の範囲をはるかに超えています。
	- この本は2つの部分を持っています：
		- データ構造とアルゴリズムに関する教科書
			- 長所：
				- アルゴリズムの教科書はどんなものでも良いレビューです
				- 業界および学界の問題を解決した経験から得た素敵な話
				- Cのコード例
			- 短所：
				- Introduction to Algorithms(CLRS)と同様に密集しているか、侵入不可能な場合があります。場合によっては、CLRSが一部の科目にとってより良い選択肢になる可能性があります
				- 7章、8章、9章では、いくつかの項目がうまく説明されていないか、私が持っているよりも多くの脳を必要とするため、追跡しようとすると痛いことがあります
				- 誤解しないで：私はSkiena、彼の教え方、そしてマナーを好きですが、Stony Brookの教材ではないかもしれません。
		- アルゴリズムカタログ：
			- これがあなたがこの本を買う本当の理由です。
			- この部分に近づきます。一度私がそれを通り抜けたら、ここで更新されます。
	- Kindleで読むことが出来ます
	- Half.comは教科書のための良いリソースです。
	- 回答：
		- [ソリューション](http://www.algorithm.cs.sunysb.edu/algowiki/index.php/The_Algorithms_Design_Manual_(Second_Edition))
		- [ソリューション](http://blog.panictank.net/category/algorithmndesignmanualsolutions/page/2/)
	- [正誤表](http://www3.cs.stonybrook.edu/~skiena/algorist/book/errata)

- [ ]  [アルゴリズムの紹介](https://www.amazon.com/Introduction-Algorithms-3rd-MIT-Press/dp/0262033844)
	- **重要：** この本を読む価値は限られています。この本はアルゴリズムとデータ構造の素晴らしいレビューですが、良いコードを書く方法を教えてくれません。まともなソリューションを効率的にコーディングすることができなければなりません。
	- Half.comは、良い価格で教科書のための素晴らしいリソースです。
	- スタインはゲームに遅れていたので、別名CLR、ときにはCLRS

- [ ]  [Programming Pearls](http://www.amazon.com/Programming-Pearls-2nd-Jon-Bentley/dp/0201657880)
	- プログラミング上の問題（データテープを使っているものもあります）への巧妙な解決策を示していますが、これは単なるイントロです。
      これはプログラムの設計とアーキテクチャに関するガイドブックです。
      これはプログラムの設計とアーキテクチャに関するガイドブックです。Code Completeとよく似ていますが、はるかに短いものです。

- ~~シェンの "アルゴリズムとプログラミング：問題と解決策"~~
    - 良い本ですが、いくつかのページで問題を解決した後、私はPascalに悩まされ、whileループ、1つのインデックス付き配列、不確実な事後条件の満足度結果を得ました。
    - むしろ別の本やオンラインのコーディングの問題からコーディングの問題に時間を費やすだろう


## 始める前に

このリストは何ヶ月にもわたって成長しました。

ここで私が作ったいくつかの間違いがあります。
あなたはより良い経験をするでしょう。

### 1.あなたはそれをすべて覚えていない

私は数時間のビデオを見て、豊富なメモを取りました。
そして数ヶ月後に私は覚えていないほどでした。
私はメモを書き、フラッシュカードを作って見直すことができるように3日間過ごしました。

あなたが私と同じ間違いをしないように読んでください：

[コンピュータ科学知識の保持](https://startupnextdoor.com/retaining-computer-science-knowledge/)

### 2.フラッシュカードを使用する

この問題を解決するために、私は2種類のフラッシュカード、一般とコードを追加できる小さなフラッシュカードサイトを作った。
各カードのフォーマットは異なります。

私はモバイル先のウェブサイトを作ったので、どこにいても電話とタブレットを見直すことができました。

あなた自身を無料で作る：

- [Flashcards site repo](https://github.com/jwasham/computer-science-flash-cards)
- [マイフラッシュカードデータベース(旧1200カード)](https://github.com/jwasham/computer-science-flash-cards/blob/master/cards-jwasham.db)：
- [マイフラッシュカードデータベース(新1800カード)](https://github.com/jwasham/computer-science-flash-cards/blob/master/cards-jwasham-extreme.db)：

覚えておいてほしいのですが，私はやりすぎてしまい、アセンブリ言語，機械学習のためのPythonのトリビア，統計に至るまですべてのカードをカバーしています。
何が必要なのかはあまりにも大変です。

**フラッシュカードについての注意：** 最初に答えを知っているときは、それを既知のものとしてマークしないでください。
あなたは本当にそれを知る前に、同じカードを見て、それを正しく数回答えなければなりません。
繰り返すことで、その知識があなたの脳に深く浸透します。


私のフラッシュカードサイトを使用する代わりに[Anki](http://ankisrs.net/)が何度も私に勧められています。
繰り返しシステムを使用して覚えやすくなります。
ユーザーフレンドリーで、すべてのプラットフォームで利用でき、クラウド同期システムを備えています。
iOSでは25ドル、他のプラットフォームでは無料です。

Anki形式の私のフラッシュカードデータベース：https://ankiweb.net/shared/info/25173560(thanks [@xiewenya](https://github.com/xiewenya))


### 3.レビュー、レビュー、評価

私は、ASCII、OSI参照モデル、Big-O記法などのチートシートを用意しています。私は余裕があるときに勉強します。

プログラミングの問題から30分ほど休み、フラッシュカードを通過してください。

### 4.フォーカス

貴重な時間を費やす可能性のある注意散漫がたくさんあります。集中と集中が難しい。

##カバーされていないもの

これらは一般的な技術ですが、この調査計画の一部ではありません：

- SQL
- Javascript
- HTML、CSS、およびその他のフロントエンド技術

##日々の計画

一部の科目は1日を要し、いくつかは複数日を要する。
いくつかは、何も実装することなく学習しているだけです。

毎日私は以下のリストから1つのテーマを取り上げ、そのテーマに関するビデオを見て、以下の実装を書いています：
- C - struct*と何か他のものをargsとする構造体と関数を使用する。
- C++ - 組み込み型を使用しない
- C++ - 連結リストのSTLのstd :: listのような組込み型の使用
- Python - 組み込み型を使用する(Pythonの練習を続ける)
- 簡単なassert（）文を使って、時には正しく動作することを保証するテストを書く
- あなたはJavaや他の何かをするかもしれませんが、これは私のことです。

あなたはこれらのすべてを必要としません。[面接のために必要な言語は1つだけです](面接のための1つの言語を選択します)。

なぜこれらすべてのコード？
- 私はそれが病気になるまで練習、練習、練習をし、何の問題もありません（忘れてはいけないことがいくつかあります）
- 生の制約内で作業する(ガベージコレクションの助けを借りずにメモリを割り当てる/解放する(Pythonを除く))
- 組み込みの型を利用して、実際の使用のために組み込みのツールを使用した経験を持ちます（本番環境で自分のリンクされたリストの実装を書くつもりはありません）

私はすべてのテーマでこれらのすべてをやる時間がないかもしれませんが、私は試してみます。

あなたは私のコードをここに見ることができます：
- [C](https://github.com/jwasham/practice-c)
- [C ++](https://github.com/jwasham/practice-cpp)
- [Python](https://github.com/jwasham/practice-python)

あなたはすべてのアルゴリズムの内容を暗記する必要はありません。

コンピューターではなく、ホワイトボードや紙にコードを書く。いくつかのサンプル入力でテストします。次に、コンピュータでテストします。

##前提知識

- [ ]  **Cを学ぶ**
	- Cはどこにでもあります。あなたは勉強している間、書籍、講義、ビデオ、*どこにでも*見ることができます。
	- [ ]  [Cプログラミング言語、Vol 2](https://www.amazon.com/Programming-Language-Brian-W-Kernighan/dp/0131103628)
		- これは短い本ですが、それはC言語の優れた処理方法を提供します。
		 少しでも練習すれば、すばやく習得できます。 Cを理解すると、プログラムやメモリの仕組みを理解するのに役立ちます。
		- [質問への回答](https://github.com/lekkas/c-algorithms)

- [ ]  **コンピュータがプログラムをどのように処理するか：**
	- [ ]  [CPUがプログラム(ビデオ)をどのように実行するか](https://www.youtube.com/watch?v=42KTvGYQYnA)
	- [ ]  [マシンコード命令(ビデオ)](https://www.youtube.com/watch?v=Mv2XQgpbTNE)

##アルゴリズムの複雑さ/ Big-O / Asymptotic解析
- 実装するものは何もない
- [ ]  [Harvard CS50 - 漸近表記(video)](https://www.youtube.com/watch?v=iOq5kSKqeR4)
- [ ]  [BigO記法(一般的なクイックチュートリアル)(ビデオ)](https://www.youtube.com/watch?v=V6mKVRU1evU)
- [ ] BigO表記(とオメガとシータ) - 最良の数学的説明(ビデオ)(https://www.youtube.com/watch?v=ei-A_wy5Yxw&index=2&list=PL1BaGV1cIH4UhkL8a9bJGG356covJ76qN)
- [ ] Skiena：
	- [動画](https://www.youtube.com/watch?v=gSyDMtdPNpU&index=2&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b)
	- [スライド](http://www3.cs.stonybrook.edu/~algorith/video-lectures/2007/lecture2.pdf)
- [ ]  [アルゴリズム複雑さ分析への穏やかな紹介](http://discrete.gr/complexity/)
- [ ]  [成長の命令(ビデオ)](https://class.coursera.org/algorithmicthink1-004/lecture/59)
- [ ]  [漸近線(Asymptotics)(video)](https://class.coursera.org/algorithmicthink1-004/lecture/61)
- [ ]  [UCバークレー BigO(ビデオ)](https://youtu.be/VIS4YDpuP98)
- [ ]  [UCバークレー Big オメガ(ビデオ)](https://youtu.be/ca3e7UVmeUc)
- [ ]  [償却分析(ビデオ)](https://www.youtube.com/watch?v=B3SpQZaAZP4&index=10&list=PL1BaGV1cIH4UhkL8a9bJGG356covJ76qN)
- [ ]  [「Big Oを描く」(ビデオ)](https://class.coursera.org/algorithmicthink1-004/lecture/63)
- [ ]  TopCoder(漸化関係とマスター定理を含む)：
	- [計算の複雑さ：セクション1](https://www.topcoder.com/community/data-science/data-science-tutorials/computational-complexity-section-1/)
	- [計算の複雑さ：セクション2](https://www.topcoder.com/community/data-science/data-science-tutorials/computational-complexity-section-2/)
- [ ]  [チートシート](http://bigocheatsheet.com/)


    講義の中には数学的にも余裕がある場合は、下にジャンプして
    離散数学ビデオを見て、背景知識を得る。

## データ構造

- ###配列
	- 自動的にサイズ変更ベクトルを実装する。
	- [ ]  説明：
		- [配列(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/OsBSF/arrays)
		- [UCBerkley CS61B - 線形および多次元配列(ビデオ)](https://youtu.be/Wp8oiO_CZZE?t=15m32s)
		- [基本的な配列(video)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Basic-arrays/149042/177104-4.html)
		- [多次元(video)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Multidimensional-arrays/149042/177105-4.html)
		- [動的配列(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/EwbnV/dynamic-arrays)
		- [ジャグ配列(動画)](https://www.youtube.com/watch?v=1jtrQqYpt7g)
		- [ジャグ配列(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Jagged-arrays/149042/177106-4.html)
		- [配列のサイズ変更(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Resizable-arrays/149042/177108-4.html)
	- [ ] ベクトルを実装する(自動サイズ変更可能な可変配列)：
		- [ ] 配列とポインタを使用してコーディングを実践し、インデックスを使用する代わりにインデックスにジャンプするポインタ演算
		- [ ] 割り当てられたメモリを持つ新しい生データ配列
			- 内部で配列を割り当てることができますが、その機能は使用しません。
			- 16で開始するか、開始番号が大きい場合は、2 - 16,32,64,128の出力を使用します
		- [ ]  size() - 項目数
		- [ ]  capacity() - 保持できるアイテムの数
		- [ ]  is_empty()
		- [ ]  at(index) - 指定されたインデックスでitemを返し、インデックスが範囲外であれば吹き飛ばす
		- [ ]  push(item)
		- [ ]  insert(index,item) - itemをindexに挿入し、そのインデックスの値と末尾の要素を右側にシフトする
		- [ ]  prepend(item) - インデックス0に上記の挿入を使用できます
		- [ ]  pop() - 最後から削除し、値を返す
		- [ ]  delete(index) - インデックスの項目を削除し、すべての末尾の要素を左にシフトする
		- [ ]  remove(item) - 値を探し、それを保持するインデックスを削除します(複数の場所であっても)
		- [ ]  find(item) - valueを検索し、その値を持つ最初のインデックスを返します。見つからなければ-1を返します。
		- [ ]  resize(new_capacity)//プライベート関数
			- 容量に達すると、サイズを2倍に変更します
			- アイテムをポップするとき、サイズが容量の1/4である場合、サイズを半分に変更
	- [ ] 時間
		- 最後に追加/削除するO(1)(スペースを増やすために償却される)、索引、または更新
		- 他の場所に挿入/削除するO(n)
    - [ ]  空間
		- メモリ内で連続しているため、プロキシミティはパフォーマンスに役立ちます
		- 必要なスペース=(配列の容量, > = n)*アイテムのサイズですが、2nでもO(n)

- ### 連結リスト
	- [ ] 説明：
		- [ ]  [単独連結されたリスト(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/kHhgK/singly-linked-lists)
		- [ ]  [CS 61B - 連結リスト1(動画)](https://www.youtube.com/watch?v=htzJdKoEmO0&list=PL4BBB74C7D2A1049C&index=7)
		- [ ]  [CS 61B - 連結リスト2(動画)](https://www.youtube.com/watch?v=-c4I3gFYe3w&index=8&list=PL4BBB74C7D2A1049C)
	- [ ]  [Cコード(動画)](https://www.youtube.com/watch?v=QN6FPiD0Gzo)
            ビデオ全体ではなく、ノード構造体とメモリ割り当てに関する部分だけです。
	- [ ] 連結リスト Vs 配列：
		- [コア連結リストs Vs 配列(ビデオ)](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/rjBs9/core-linked-lists-vs-arrays)
		- [実世界の連結リスト Vs 配列(ビデオ)](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/quaUd/in-the-real-world-lists-vs)アレー)
	- [ ]  [連結リスト(ビデオ)を避けるべき理由](https://www.youtube.com/watch?v=YQs6IC-vgmo)
	- [ ]  分かったぞ！：ポインタの知識へのポインタが必要です：
        (そのポインタが指すアドレスを変更する可能性のある関数へのポインタを渡すとき)
        このページはptrからptrまでを把握するためのものです。このリストトラバーサルスタイルはお勧めしません。読みやすさと保守性は巧みさのために苦しんでいます。
		- [ポインターへのポインター](https://www.eskimo.com/~scs/cclass/int/sx8.html)
	- [ ] 実装する(私はテールポインタ＆なしで行った)：
		- [ ]  size() - リスト内のデータ要素の数を返す
		- [ ]  empty() - 空の場合はboolを返します
		- [ ]  value_at(index) - n番目の項目の値を返します(最初は0から始まります)
		- [ ]  push_front(value) - リストの先頭に項目を追加します
		- [ ]  pop_front() - 前面アイテムを削除してその値を返します
		- [ ]  push_back(value) - 最後に項目を追加する
		- [ ]  pop_back() - 終了アイテムを削除し、その値を返します
		- [ ]  front() - フロントアイテムの値を取得する
		- [ ]  back() - 終了項目の値を取得する
		- [ ]  insert(index、value) - インデックスに値を挿入するので、そのインデックスの現在のアイテムはインデックスの新しいアイテムによってポイントされます
		- [ ]  erase(index) - 指定したインデックスのノードを削除する
		- [ ]  value_n_from_end(n) - リストの最後からn番目のノードの値を返します
		- [ ]  reverse() - リストを反転する
		- [ ]  remove_value(value) - この値を持つリストの最初の項目を削除します。
	- [ ] 二重連結リスト
		- [説明(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/jpGKD/doubly-linked-lists)
		- 実装する必要はありません

- ### スタック
	- [ ]  [Stacks(video)](https://www.coursera.org/learn/data-structures/lecture/UdKzQ/stacks)
	- [ ]  [スタックをの使用 Last-In First-Out(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Using-stacks-last-first-out/149042/177120-4 .html)
	- [ ] 実装されません。配列で実装するのは簡単です。

- ### キュー
	- [ ]  [キューの使用 First-In First-Out(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Using-queues-first-first-out/149042/177122-4 .html)
	- [ ]  [キュー(video)](https://www.coursera.org/learn/data-structures/lecture/EShpq/queue)
	- [ ]  [環状バッファ/ FIFO](https://en.wikipedia.org/wiki/Circular_buffer)
	- [ ]  [優先度つきキュー(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Priority-queues-deques/149042/177123-4.html)
	- [ ] テールポインタ付き連結リストを使って実装する：
		- enqueue(value) - テールの位置に値を追加する
		- dequeue() - 値を返し、少なくとも最近追加された要素を削除する(前面)
        - empty()
	- [ ] 固定長配列を使って実装する：
		- enqueue(value) - 利用可能なストレージの最後にアイテムを追加する
		- dequeue() - 値を返し、最近追加された要素のうち最も古い要素を削除します
        - empty()
		- full()
	- [ ] コスト：
	    - 最後の要素の次の要素が必要になるため、先頭にエンキューし、末尾をデキューするリンクリストを使用する悪い実装はO（n）になり、デキューごとに完全なトラバーサルが発生します
		- enqueue：O(1)(償却、連結リストと配列[プロービング])
		- dequeue：O(1)(連結リストと配列)
		- empty：O(1)(連結リストと配列)

- ### ハッシュテーブル
	- [ ] 動画：
		- [ ]  [連鎖によるハッシング(動画)](https://www.youtube.com/watch?v=0M_kIqhwbFo&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=8)
		- [ ]  [ダブリング、ラビン-カープ(ビデオ)](https://www.youtube.com/watch?v=BRO7mVIFt08&index=9&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
		- [ ]  [公開アドレス指定、暗号化ハッシング(動画)](https://www.youtube.com/watch?v=rvdJDijO2Ro&index=10&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
		- [ ]  [PyCon 2010：The Mighty Dictionary(video)](https://www.youtube.com/watch?v=C4Kc8xzcA68)
		- [ ]  [(上級)Randomization：ユニバーサル＆完全 ハッシング(ビデオ)](https://www.youtube.com/watch?v=z0lJ2k0sl1g&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=11)
		- [ ]  [(高度)完全ハッシング(動画)](https://www.youtube.com/watch?v=N0COwN14gt0&list=PL2B4EEwhKD-NbwZ4ezj7gyc_3yNrojKM9&index=4)

	- [ ] オンラインコース：
		- [ ]  [ハッシュ関数について(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Understanding-hash-functions/149042/177126-4.html)
		- [ ]  [ハッシュテーブルの使用(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Using-hash-tables/149042/177127-4.html)
		- [ ]  [ハッシングをサポートする(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Supporting-hashing/149042/177128-4.html)
		- [ ]  [言語サポートハッシュテーブル(ビデオ)](https://www.lynda.com/Developer-Programming-Foundations-tutorials/Language-support-hash-tables/149042/177129-4.html)
		- [ ]  [コアハッシュテーブル(ビデオ)](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/m7UuP/core-hash-tables)
		- [ ]  [データ構造(ビデオ)](https://www.coursera.org/learn/data-structures/home/week/3)
		- [ ]  [電話帳の問題(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/NYZZP/phone-book-problem)
		- [ ] 分散ハッシュテーブル：
			- [Dropbox(ビデオ)でインスタントアップロードとストレージの最適化](https://www.coursera.org/learn/data-structures/lecture/DvaIb/instant-uploads-and-storage-optimization-in-dropbox)
			- [分散ハッシュテーブル(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/tvH8H/distributed-hash-tables)

	- [ ] 線形プロービングを使用して配列で実装する
		- hash(k、m) - mはハッシュテーブルのサイズです
		- add(key、value) - キーがすでに存在する場合は、値を更新します。
		- exists(キー)
		- get(key)
		- remove(キー)

## その他の知識

- ### 二分探索
	- [ ]  [二分探索(動画)](https://www.youtube.com/watch?v=D5SrAga1pno)
	- [ ]  [二分探索(ビデオ)](https://www.khanacademy.org/computing/computer-science/algorithms/binary-search/a/binary-search)
	- [ ]  [詳細](https://www.topcoder.com/community/data-science/data-science-tutorials/binary-search/)
	- [ ] 実装：
		- 二分探索(ソートされた整数の配列)
		- 再帰を利用した二分探索

- ###ビット演算
	- [ ]  [ビットチートシート- 2 ^ 1から2 ^ 16および2 ^ 32までの2の累乗の多くを知るべきです](https://github.com/jwasham/coding-interview-university/blob/master/extras/cheat%20sheets/bits-cheat-cheet.pdf)
	- [ ] ＆、|、^、〜、>>、<<を使ってビットを操作することについての本当の理解を得る
		- [ ]  [words](https://en.wikipedia.org/wiki/Word_(computer_architecture))
		- [ ]  [良いイントロ：ビット操作(動画)](https://www.youtube.com/watch?v=7jkIUgLC29I)
		- [ ]  [Cプログラミングチュートリアル2-10：ビット演算子(ビデオ)](https://www.youtube.com/watch?v=d0AwjSpNXR0)
		- [ ]  [ビット操作](https://en.wikipedia.org/wiki/Bit_manipulation)
		- [ ]  [ビット演算](https://en.wikipedia.org/wiki/Bitwise_operation)
		- [ ]  [Bithacks](https://graphics.stanford.edu/~seander/bithacks.html)
		- [ ]  [The Bit Twiddler](http://bits.stephan-brumme.com/)
		- [ ]  [インタラクティブなBit Twiddler](http://bits.stephan-brumme.com/interactive.html)
	- [ ]  2と1の補数
		- [バイナリ：Plusses＆Minuses(なぜ2の補数を使うのか)(ビデオ)](https://www.youtube.com/watch?v=lKTsv6iVxV4)
		- [1の補数](https://en.wikipedia.org/wiki/Ones%27_complement)
		- [2の補数](https://en.wikipedia.org/wiki/Two%27s_complement)
	- [ ] カウントセットビット
		- [1バイトのビットを数える4つの方法(ビデオ)](https://youtu.be/Hzuzo9NJrlc)
		- [カウントビット](https://graphics.stanford.edu/~seander/bithacks.html#CountBitsSetKernighan)
		- [セットビットの数を32ビット整数で数える方法](http://stackoverflow.com/questions/109023/how-to-count-the-number-of-set-bits-in-a-32ビット整数)
	- [ ]  2の次の累乗に丸めます：
		- [2つの次のパワーに回す](http://bits.stephan-brumme.com/roundUpToNextPowerOfTwo.html)
	- [ ] スワップ値：
		- [スワップ](http://bits.stephan-brumme.com/swap.html)
    - [ ]  絶対値：
		- [絶対整数](http://bits.stephan-brumme.com/absInteger.html)

## 木

- ### 木 - メモと背景
	- [ ]  [シリーズ：Core Trees(ビデオ)](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/ovovP/core-trees)
	- [ ]  [シリーズ：木々(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/95qda/trees)
	- 基本的な木の構築
	- トラバーサル
	- 操作アルゴリズム
	- BFS(幅優先検索)
		- [MIT(動画)](https://www.youtube.com/watch?v=s-CYnVz-uh4&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=13)
		- レベルオーダー(BFS、キューを使用)
            時間複雑度：O(n)
            空間の複雑さ：最適：O(1)、最悪：O(n / 2)= O(n)
	- DFS(深さ優先探索)
		- [MIT(動画)](https://www.youtube.com/watch?v=AfSk24UTFS8&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=14)
        - メモ：
            時間複雑度：O(n)
            空間の複雑さ：
                最良：O(log n) - 平均。木の高さ
                最悪：O(n)
		- inorder(DFS：left、self、right)
		- postorder(DFS：left、right、self)
		- preorder(DFS：自己、左、右)

- ### 二分探索木：BST
	- [ ]  [二分探索木レビュー(動画)](https://www.youtube.com/watch?v=x6At0nzX92o&index=1&list=PLA5Lqm4uh9Bbq-E0ZnqTIa8LRaL77ica6)
	- [ ]  [シリーズ(ビデオ)](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/p82sw/core-introduction-to-binary-search-trees)
		- シンボルテーブルから始まり、BSTアプリケーションを経由します
	- [ ]  [はじめに(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/E7cXP/introduction)
	- [ ]  [MIT(動画)](https://www.youtube.com/watch?v=9Jry5-82I68)
	- C / C ++：
		- [ ]  [二分探索木 - C / C ++での実装(ビデオ)](https://www.youtube.com/watch?v=COZK7NATh4k&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P&index=28)
		- [ ]  [BSTの実装 - スタックとヒープのメモリ割り当て(ビデオ)](https://www.youtube.com/watch?v=hWokyBoo0aI&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P&index=29)
		- [ ]  [二分探索木(ビデオ)の最小要素と最大要素を検索](https://www.youtube.com/watch?v=Ut90klNN264&index=30&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P)
		- [ ]  [二分木の高さを見つける(ビデオ)](https://www.youtube.com/watch?v=_pnqMz5nrRs&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P&index=31)
		- [ ]  [二分木トラバース - 幅優先戦略(ビデオ)](https://www.youtube.com/watch?v=9RHO6jU--GU&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P&index=32)
		- [ ]  [二分木：レベルオーダートラバーサル(動画)](https://www.youtube.com/watch?v=86g8jAQug04&index=33&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P)
		- [ ]  [二分木トラバーサル：Preorder、Inorder、Postorder(video)](https://www.youtube.com/watch?v=gm8DUJJhmY4&index=34&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P)
		- [ ]  [二分木が二分探索木かどうかを確認する(ビデオ)](https://www.youtube.com/watch?v=yEwSGhSsT0U&index=35&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P)
		- [ ]  [二分探索木(ビデオ)からノードを削除](https://www.youtube.com/watch?v=gcULXE7ViZw&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P&index=36)
		- [ ]  [二分探索木(ビデオ)のInorder Successor](https://www.youtube.com/watch?v=5cPbNCrdotA&index=37&list=PL2_aWCzGMAwI3W_JlcBbtYTwiQSsOTa6P)
	- [ ] 実装：
		- [ ]  insert //木に値を挿入する
		- [ ]  get_node_count //格納された値の数を取得する
		- [ ]  print_values //最小値から最大値まで木の値を出力します
		- [ ]  delete_tree 
		- [ ]  is_in_tree //与えられた値が木に存在する場合はtrueを返します
		- [ ]  get_height //ノードの高さを返します(単一ノードの高さは1です)
		- [ ]  get_min //木に格納されている最小値を返します
		- [ ]  get_max //木に格納されている最大値を返します
		- [ ]  is_binary_search_tree
		- [ ]  delete_value
		- [ ]  get_successor //指定された値の後に木の次に高い値を返し、存在しなければ-1を返します

- ### ヒープ/優先度つきキュー/二分ヒープ
	- 木として可視化されますが、通常はストレージ内で線形です(配列、連結リスト)
	- [ ]  [ヒープ](https://en.wikipedia.org/wiki/Heap_(data_structure))
	- [ ]  [はじめに(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/2OpTs/introduction)
	- [ ]  [ナイーブな実装(video)](https://www.coursera.org/learn/data-structures/lecture/z3l9N/naive-implementations)
	- [ ]  [二分木(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/GRV2q/binary-trees)
	- [ ]  [木の高さ備考(ビデオ)](https://www.coursera.org/learn/data-structures/supplement/S5xxz/tree-height-remark)
	- [ ]  [基本的な操作(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/0g1dl/basic-operations)
	- [ ]  [完全な二分木(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/gl5Ni/complete-binary-trees)
	- [ ]  [疑似コード(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/HxQo9/pseudocode)
	- [ ]  [ヒープソート - ジャンプして開始(ビデオ)](https://youtu.be/odNJmw5TOEE?list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&t=3291)
	- [ ]  [ヒープソート(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/hSzMO/heap-sort)
	- [ ]  [ヒープを作る(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/dwrOS/building-a-heap)
	- [ ]  [MIT：ヒープとヒープソート(ビデオ)](https://www.youtube.com/watch?v=B7hVxCmfPtM&index=4&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
	- [ ]  [CS 61B講義24：優先度つきキュー(ビデオ)](https://www.youtube.com/watch?v=yIUFT6AKBGE&index=24&list=PL4BBB74C7D2A1049C)
	- [ ]  [線形時間BuildHeap(max-heap)](https://www.youtube.com/watch?v=MiyLo8adrWw)
	- [ ] 最大ヒープを実装する：
		- [ ] insert
		- [ ]  sift_up - 挿入に必要
		- [ ]  get_max - 最大項目を削除せずに返します
		- [ ]  get_size() - 格納された要素の数を返す
		- [ ]  is_empty() - ヒープに要素が含まれていない場合はtrueを返します。
		- [ ]  extract_max - 最大アイテムを返し、それを削除します。
		- [ ]  sift_down - extract_maxに必要です
		- [ ]  remove(i) - インデックスxのアイテムを削除する
		- [ ]  heapify - heap_sortに必要な要素の配列からヒープを作成する
		- [ ]  heap_sort() - ソートされていない配列を取り出し、最大ヒープを使用してソート済みの配列に変換します
			- 注意：代わりにminヒープを使用すると、操作が節約されますが、必要な領域が2倍になります([in-place](https://ja.wikipedia.org/wiki/In-place%E3%82%A2%E3%83%AB%E3%82%B4%E3%83%AA%E3%82%BA%E3%83%A0)では実行できません)。

## ソート

- [ ]  note：
	- ソートを実装し、最良のケース/最悪のケース、それぞれの平均的な複雑さを知る：
		- バブルソートなし - ひどい - O(n ^ 2)、ただしn <= 16の場合を除く
	- ソートアルゴリズムの安定性( "Quicksortは安定していますか？")
		- [ソートアルゴリズムの安定性](https://en.wikipedia.org/wiki/Sorting_algorithm#Stability)
		- [ソートアルゴリズムの安定性](http://stackoverflow.com/questions/1517793/stability-in-sorting-algorithms)
		- [ソートアルゴリズムの安定性](http://www.geeksforgeeks.org/stability-in-sorting-algorithms/)
		- [ソートアルゴリズム - 安定性](http://homepages.math.uic.edu/~leon/cs-mcs401-s08/handouts/stability.pdf)
	- [ ] 連結リストで使用できるアルゴリズムはどれですか？どの配列ですか？両方でどちら？
		- 連結リストのソートはお勧めしませんが、マージソートは実行可能です。
		- [連結リストのマージソート](http://www.geeksforgeeks.org/merge-sort-for-linked-list/)

- ヒープソートについては、上記のヒープデータ構造を参照してください。ヒープソートは素晴らしいですが、安定していません。

- [ ]  [Sedgewick - Mergesort(5ビデオ)](https://www.youtube.com/watch?v=4nKwesx_c8E&list=PLe-ggMe31CTeunC6GZHFBmQx7EKtjbGf9)
	- [ ]  [1。 マージソート](https://www.youtube.com/watch?v=4nKwesx_c8E&list=PLe-ggMe31CTeunC6GZHFBmQx7EKtjbGf9&index=1)
	- [ ]  [2。 マージソート・ボトムアップ](https://www.youtube.com/watch?v=HGOIGUYjeyk&list=PLe-ggMe31CTeunC6GZHFBmQx7EKtjbGf9&index=2)
	- [ ]  [3。複雑さの並べ替え](https://www.youtube.com/watch?v=WvU_mIWo0Ac&index=3&list=PLe-ggMe31CTeunC6GZHFBmQx7EKtjbGf9)
	- [ ]  [4。コンパレータ](https://www.youtube.com/watch?v=7MvC1kmBza0&index=4&list=PLe-ggMe31CTeunC6GZHFBmQx7EKtjbGf9)
	- [ ]  [5。安定性](https://www.youtube.com/watch?v=XD_5iINB5GI&index=5&list=PLe-ggMe31CTeunC6GZHFBmQx7EKtjbGf9)

- [ ]  [Sedgewick - Quicksort(4ビデオ)](https://www.youtube.com/playlist?list=PLe-ggMe31CTeE3x2-nF1-toca1QpuXwE1)
	- [ ]  [1. クイックソート](https://www.youtube.com/watch?v=5M5A7qPWk84&index=1&list=PLe-ggMe31CTeE3x2-nF1-toca1QpuXwE1)
	- [ ]  [2. 選択](https://www.youtube.com/watch?v=CgVYfSyct_M&index=2&list=PLe-ggMe31CTeE3x2-nF1-toca1QpuXwE1)
	- [ ]  [3. 重複キー](https://www.youtube.com/watch?v=WBFzOYJ5ybM&index=3&list=PLe-ggMe31CTeE3x2-nF1-toca1QpuXwE1)
	- [ ]  [4. システムソート](https://www.youtube.com/watch?v=rejpZ2htBjE&index=4&list=PLe-ggMe31CTeE3x2-nF1-toca1QpuXwE1)

- [ ]  UCバークレー：
	- [ ]  [CS 61B講義29：ソートI(ビデオ)](https://www.youtube.com/watch?v=EiUvYS2DT6I&list=PL4BBB74C7D2A1049C&index=29)
	- [ ]  [CS 61B講義30：ソートII(ビデオ)](https://www.youtube.com/watch?v=2hTY3t80Qsk&list=PL4BBB74C7D2A1049C&index=30)
	- [ ]  [CS 61B講義32：ソートIII(ビデオ)](https://www.youtube.com/watch?v=Y6LOLpxg6Dc&index=32&list=PL4BBB74C7D2A1049C)
	- [ ]  [CS 61B講義33：ソートV(ビデオ)](https://www.youtube.com/watch?v=qNMQ4ly43p4&index=33&list=PL4BBB74C7D2A1049C)

- [ ]  [バブルソート(動画)](https://www.youtube.com/watch?v=P00xJgWzz2c&index=1&list=PL89B61F78B552C1AB)
- [ ]  [バブルソートの分析(動画)](https://www.youtube.com/watch?v=ni_zk257Nqo&index=7&list=PL89B61F78B552C1AB)
- [ ]  [挿入ソート、マージソート(動画)](https://www.youtube.com/watch?v=Kg4bqzAqRBM&index=3&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
- [ ]  [挿入ソート(動画)](https://www.youtube.com/watch?v=c4BRHC7kTaQ&index=2&list=PL89B61F78B552C1AB)
- [ ]  [マージソート(動画)](https://www.youtube.com/watch?v=GCae1WNvnZM&index=3&list=PL89B61F78B552C1AB)
- [ ]  [クイックソート(動画)](https://www.youtube.com/watch?v=y_G9BkAm6B8&index=4&list=PL89B61F78B552C1AB)
- [ ]  [選択ソート(動画)](https://www.youtube.com/watch?v=6nDMgr0-Yyo&index=8&list=PL89B61F78B552C1AB)

- [ ] マージソートコード：
	- [ ]  [出力配列(C)の使用](http://www.cs.yale.edu/homes/aspnes/classes/223/examples/sorting/mergesort.c)
	- [ ]  [出力配列(Python)の使用](https://github.com/jwasham/practice-python/blob/master/merge_sort/merge_sort.py)
	- [ ]  [インプレース(C ++)](https://github.com/jwasham/practice-cpp/blob/master/merge_sort/merge_sort.cc)
- [ ] クイックソートコード：
	- [ ]  [Implementation(C)](http://www.cs.yale.edu/homes/aspnes/classes/223/examples/randomization/quick.c)
	- [ ]  [実装(C)](https://github.com/jwasham/practice-c/blob/master/quick_sort/quick_sort.c)
	- [ ]  [実装(Python)](https://github.com/jwasham/practice-python/blob/master/quick_sort/quick_sort.py)

- [ ] 実装：
	- [ ]  Mergesort：O(n log n)平均と最悪の場合
	- [ ]  Quicksort O(n log n)平均の場合
	- 選択ソートと挿入ソートは両方ともO(n ^ 2)の平均と最悪の場合です
	- ヒープソートについては、上記のヒープデータ構造を参照してください。

- [ ] 必須ではありませんが、私はそれらをお勧めしました：
	- [ ]  [Sedgewick - 基数ソート(6 videos)](https://www.youtube.com/playlist?list=PLe-ggMe31CTcNvUX9E3tQeM6ntrdR8e53)
		- [ ]  [1. Javaの文字列](https://www.youtube.com/watch?v=zRzU-FWsjNU&list=PLe-ggMe31CTcNvUX9E3tQeM6ntrdR8e53&index=6)
		- [ ]  [2. キーインデックスのカウント](https://www.youtube.com/watch?v=CtgKYmXs62w&list=PLe-ggMe31CTcNvUX9E3tQeM6ntrdR8e53&index=5)
		- [ ]  [3. 最下位桁の最初の文字列の基数ソート](https://www.youtube.com/watch?v=2pGVq_BwPKs&list=PLe-ggMe31CTcNvUX9E3tQeM6ntrdR8e53&index=4)
		- [ ]  [4. 最も重要な数字の最初の文字列の基数ソート](https://www.youtube.com/watch?v=M3cYNY90R6c&index=3&list=PLe-ggMe31CTcNvUX9E3tQeM6ntrdR8e53)
		- [ ]  [5. 基数ソートの3つの方法](https://www.youtube.com/watch?v=YVl58kfE6i8&index=2&list=PLe-ggMe31CTcNvUX9E3tQeM6ntrdR8e53)
		- [ ]  [6。接尾辞配列](https://www.youtube.com/watch?v=HKPrVm5FWvg&list=PLe-ggMe31CTcNvUX9E3tQeM6ntrdR8e53&index=1)
	- [ ]  [基数ソート](http://www.cs.yale.edu/homes/aspnes/classes/223/notes.html#radixSort)
	- [ ]  [基数ソート(動画)](https://www.youtube.com/watch?v=xhr26ia4k38)
	- [ ]  [基数ソート、ソート(線形時間指定の制約)(ビデオ)](https://www.youtube.com/watch?v=Nz1KZXbghj8&index=7&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
	- [ ]  [ランダム化：行列乗算、クイックソート、Freivaldsのアルゴリズム(ビデオ)](https://www.youtube.com/watch?v=cNB2lADK3_s&index=8&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp)
	- [ ]  [線形時間で並べ替える(ビデオ)](https://www.youtube.com/watch?v=pOKy3RZbSws&list=PLUl4u3cNGP61hsJNdULdudlRL493b-XZf&index=14)

まとめとして、ここには[15ソートアルゴリズム](https://www.youtube.com/watch?v=kPRA0W1kECg)の視覚的表現があります。
このテーマの詳細が必要な場合は、[いくつかの科目の追加の詳細]の[ソート]の項を参照してください(#additional-detail-on-some-subjects)

##グラフ

グラフはコンピュータサイエンスの多くの問題を表現するために使用することができるので、このセクションは木やソートのように長いです。

- note：
	- メモリにグラフを表示するには4つの基本的な方法があります：
		- オブジェクトとポインタ
		- 隣接行列
		- 隣接リスト
		- 隣接マップ
	- それぞれの表現とその長所と短所を熟知してください
	- BFSとDFS - 計算の複雑さとそのトレードオフ、そしてそれらを実際のコードに実装する方法を知っている
	- 質問が表示されたら、まずグラフベースのソリューションを探し、それがなければ進んでください。

- [ ]  Skiena Lectures - 素晴らしいイントロ：
	- [ ]  [CSE373 2012 - 講義11 - グラフデータ構造(ビデオ)](https://www.youtube.com/watch?v=OiXxhDrFruw&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&index=11)
	- [ ]  [CSE373 2012 - 講義12 - 幅優先検索(ビデオ)](https://www.youtube.com/watch?v=g5vF8jscteo&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&index=12)
	- [ ]  [CSE373 2012 - 講義13 - グラフアルゴリズム(ビデオ)](https://www.youtube.com/watch?v=S23W6eTcqdY&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&index=13)
	- [ ]  [CSE373 2012 - 講義14 - グラフアルゴリズム(1)(ビデオ)](https://www.youtube.com/watch?v=WitPBKGV0HY&index=14&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b)
	- [ ]  [CSE373 2012 - 講義15 - グラフアルゴリズム(2)(動画)(ビデオ)](https://www.youtube.com/watch?v=ia1L30l7OIg&index=15&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b)
	- [ ]  [CSE373 2012 - 講義16 - グラフアルゴリズム(3)(ビデオ)](https://www.youtube.com/watch?v=jgDOQq6iWy8&index=16&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b)

- [ ] グラフ(レビューなど)：

	- [ ]  [6.006単一始点最短経路問題(ビデオ)](https://www.youtube.com/watch?v=Aa2sqUhIn-E&index=15&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
	- [ ]  [6.006 ダイクストラ(ビデオ)](https://www.youtube.com/watch?v=2E7MmKv0Y24&index=16&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
	- [ ]  [6.006 ベルマン-フォード法(ビデオ)](https://www.youtube.com/watch?v=ozsuci5pIso&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=17)
	- [ ]  [6.006 ダイクストラ法のスピードアップ(ビデオ)](https://www.youtube.com/watch?v=CHvQ3q_gJ7E&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=18)
	- [ ]  [Aduni：グラフアルゴリズムI - トポロジカルソート、最小スパニング木、プリムのアルゴリズム - 講演6(ビデオ)](https://www.youtube.com/watch?v=i_AQT_XfvD8&index=6&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm)
	- [Aduni：グラフアルゴリズムII - DFS、BFS、クラスカル法のアルゴリズム、連合探索データ構造 - 講義7(ビデオ)](https://www.youtube.com/watch?v=ufj5_bppBsA&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=7 )
	- [Aduni：グラフアルゴリズムIII：最短経路 - レクチャー8(ビデオ)](https://www.youtube.com/watch?v=DiedsPsMKXc&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=8)
	- [ ]  [Aduni：グラフアルゴリズムIV：幾何学アルゴリズムの紹介 - 第9講(ビデオ)](https://www.youtube.com/watch?v=XIAQRlNkJAw&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=9)
	- [ ]  [CS 61B 2014(58:09から開始)(ビデオ)](https://youtu.be/dgjX4HdMI-Q?list=PL-XXv-cvA_iAlnI-BQr9hjqADPBtujFJd&t=3489)
	- [ ]  [CS 61B 2014：加重グラフ(ビデオ)](https://www.youtube.com/watch?v=aJjlQCFwylA&list=PL-XXv-cvA_iAlnI-BQr9hjqADPBtujFJd&index=19)
	- [ ]  [欲張りアルゴリズム：最小スパニング木(ビデオ)](https://www.youtube.com/watch?v=tKwnms5iRBU&index=16&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp)
	- [ ]  [強固に接続されたコサラジュのアルゴリズムグラフアルゴリズム(ビデオ)](https://www.youtube.com/watch?v=RpgcYiky7uw)

- フルcourseraコース：
	- [ ]  [グラフのアルゴリズム(ビデオ)](https://www.coursera.org/learn/algorithms-on-graphs/home/welcome)

- 私は実装します：
	- [ ] 隣接リストを持つDFS(再帰的)
	- [ ] 隣接リストを持つDFS(スタックで反復)
	- [ ] 隣接行列を持つDFS(再帰的)
	- [ ] 隣接行列を持つDFS(スタックで反復)
	- [ ]  隣接リストを持つBFS
	- [ ] 隣接行列を持つBFS
	- [ ] 単一始点の最短経路(ダイクストラ)
	- [ ] 最小スパニング木
	- DFSベースのアルゴリズム(上記のAduniの動画を参照)：
		- [ ] サイクルをチェックする(トポロジカルソートに必要．開始前にサイクルをチェックする)
		- [ ] トポロジカルソート
		- [ ] グラフ内の接続されたコンポーネントをカウントする
		- [ ] 強く接続されたコンポーネントを一覧表示する
		- [ ] 二部グラフをチェックする

Skienaの本(下記の書籍の節を参照)と面接の書籍

##さらに多くの知識

- ###再帰
	- [ ] 再帰とバックトラックに関するスタンフォードの講義：
		- [ ]  [講義8 |プログラミングの抽象化(ビデオ)](https://www.youtube.com/watch?v=gl3emqCuueQ&list=PLFE6E58F856038C69&index=8)
		- [ ]  [講義9 |プログラミングの抽象化(ビデオ)](https://www.youtube.com/watch?v=uFJhEPrbycQ&list=PLFE6E58F856038C69&index=9)
		- [ ]  [講義10 |プログラミングの抽象化(ビデオ)](https://www.youtube.com/watch?v=NdF1QDTRkck&index=10&list=PLFE6E58F856038C69)
		- [ ]  [講義11 |プログラミングの抽象化(ビデオ)](https://www.youtube.com/watch?v=p-gpaIGRCQI&list=PLFE6E58F856038C69&index=11)
	- それを使用するのが適切なとき
	- 尾の再帰はどのように優れていないのですか？
		- [ ]  [テール再帰とは何かなぜそれが悪いのですか？](https://www.quora.com/What-is-tail-recursion-Why-is-it-so-bad)
		- [ ]  [テール再帰(ビデオ)](https://www.youtube.com/watch?v=L1jjXGfxozc)

- ###動的プログラミング
	- この問題はかなり難しいかもしれません。なぜなら、それぞれのDP可溶性問題は再帰関係として定義されなければならず、それを思い付くのは難しいかもしれないからです。
	- DPの問題の多くの例を見て、あなたが関連するパターンをしっかりと理解するまでお勧めします。
	- [ ] 動画：
		- Skienaのビデオは、時には見ることができないほど小さすぎるホワイトボードを使用することがあるため、フォローするのが難しい場合があります
		- [ ]  [Skiena：CSE373 2012 - 講義19 - 動的プログラミング入門(ビデオ)](https://youtu.be/Qc2ieXRgR0k?list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&t=1718)
		- [ ]  [Skiena：CSE373 2012 - 講義20 - 編集距離(ビデオ)](https://youtu.be/IsmMhMdyeGY?list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&t=2749)
		- [ ]  [Skiena：CSE373 2012 - 講義21 - 動的プログラミング例(ビデオ)](https://youtu.be/o0V9eYF4UI8?list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&t=406)
		- [ ]  [Skiena：CSE373 2012 - 講義22 - 動的プログラミングのアプリケーション(ビデオ)](https://www.youtube.com/watch?v=dRbMC1Ltl3A&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&index=22)
		- [ ] [Simonson：動的プログラミング0(59:18から開始)(ビデオ)](https://youtu.be/J5aJEcOr6Eo?list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&t=3558)
		- [ ]  [Simonson：動的プログラミングI - 講義11(ビデオ)](https://www.youtube.com/watch?v=0EzHjQ_SOeU&index=11&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm)
		- [ ]  [Simonson：動的プログラミングII - 講演12(ビデオ)](https://www.youtube.com/watch?v=v1qiRwuJU7g&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=12)
		- [ ] 個々のDP問題のリスト(それぞれ短い)：
            [動的プログラミング(動画)](https://www.youtube.com/playlist?list=PLrmLmBdmIlpsHaNTPP_jHHDx_os9ItYXr)
	- [ ]  イェール講義ノート：
		- [ ]  [動的プログラミング](http://www.cs.yale.edu/homes/aspnes/classes/223/notes.html#dynamicプログラミング)
	- [ ]  Coursera：
		- [ ]  [RNA二次構造の問題(ビデオ)](https://www.coursera.org/learn/algorithmic-thinking-2/lecture/80RrW/the-rna-secondary-structure-problem)
		- [ ]  [動的プログラミングのアルゴリズム(ビデオ)](https://www.coursera.org/learn/algorithmic-thinking-2/lecture/PSonq/a-dynamic-programming-algorithm)
		- [ ]  [DPアルゴリズムの説明(ビデオ)](https://www.coursera.org/learn/algorithmic-thinking-2/lecture/oUEK2/illustrating-the-dp-algorithm)
		- [ ]  [DPアルゴリズムの実行時間(ビデオ)](https://www.coursera.org/learn/algorithmic-thinking-2/lecture/nfK2r/running-time-of-the-dp-algorithm)
        - [ ] [[DP Vs 再帰的実装(ビデオ)](https://www.coursera.org/learn/algorithmic-thinking-2/lecture/M999a/dp-vs-recursive-implementation)
		- [ ]  [グローバル対配列アライメント(ビデオ)](https://www.coursera.org/learn/algorithmic-thinking-2/lecture/UZ7o6/global-pairwise-sequence-alignment)
		- [ ]  [ローカル対配列アライメント(ビデオ)](https://www.coursera.org/learn/algorithmic-thinking-2/lecture/WnNau/local-pairwise-sequence-alignment)

- ### オブジェクト指向プログラミング
	- [ ]  [オプション：UML 2.0シリーズ(動画)](https://www.youtube.com/watch?v=OkC7HKtiZC0&list=PLGLfVvz_LVvQ5G-LdJ8RLqe-ndo7QITYc)
	- [ ] オブジェクト指向ソフトウェアエンジニアリング：UMLとJavaを使ったソフトウェア開発(21ビデオ)：
		- OOとOOの設計方法を十分に理解している場合は、これをスキップできます。
		- [OOSE：UMLとJavaを使用したソフトウェア開発](https://www.youtube.com/playlist?list=PLJ9pm_Rc9HesnkwKlal_buSIHA-jTZMpO)
	- [ ]  SOLID OOP原則：
		- [ ]  [Bob Martin SOLIDオブジェクト指向とアジャイルデザインの原則(ビデオ)](https://www.youtube.com/watch?v=TMuno5RZNeE)
		- [ ]  [SOLID原則(ビデオ)](https://www.youtube.com/playlist?list=PL4CE9F710017EA77A)
		- [ ]  S - [単一責任の原則](http://www.oodesign.com/single-responsibility-principle.html)| [各オブジェクトへの単一責任](http://www.javacodegeeks.com/2011/11/solid-single-responsibility-principle.html)
			- [もっと味](https://docs.google.com/open?id=0ByOwmqah_nuGNHEtcU5OekdDMkk)
		- [ ]  O - [オープン/クローズの原則l](http://www.oodesign.com/open-close-principle.html)| [プロダクションレベルではオブジェクトは拡張の準備ができていますが、変更はできません](https://en.wikipedia.org/wiki/Open/closed_principle)
			- [もっと風味](http://docs.google.com/a/cleancoder.com/viewer?a=v&pid=explorer&chrome=true&srcid=0BwhCYaYDn8EgN2M5MTkwM2EtNWFkZC00ZTI3LWFjZTUtNTFhZGZiYmUzODc1&hl=en)
		- [ ]  L - [リスコフの置換原則](http://www.oodesign.com/liskov-s-substitution-principle.html)| [基本クラスと派生クラスは `IS A`プリンシパルに従います](http://stackoverflow.com/questions/56860/what-is-the-liskov-substitution-principle)
			- [もっと風味](http://docs.google.com/a/cleancoder.com/viewer?a=v&pid=explorer&chrome=true&srcid=0BwhCYaYDn8EgNzAzZjA5ZmItNjU3NS00MzQ5LTkwYjMtMDJhNDU5ZTM0MTlh&hl=ja)
		- [ ]  I - [インタフェース分離の原則](http://www.oodesign.com/interface-segregation-principle.html)|クライアントは、使用しないインタフェースを強制的に実装するべきではありません
			- [インタフェース分離の原則5分(ビデオ)](https://www.youtube.com/watch?v=3CtAfl7aXAQ)
			- [もっと味](http://docs.google.com/a/cleancoder.com/viewer?a=v&pid=explorer&chrome=true&srcid=0BwhCYaYDn8EgOTViYjJhYzMtMzYxMC00MzFjLWJjMzYtOGJiMDc5N2JkYmJi&hl=ja)
		- [ ]  D - [依存性逆転の原則(http://www.oodesign.com/dependency-inversion-principle.html)|オブジェクトの構成における依存関係を減らす。
			- なぜ依存関係の逆転の原則とそれが重要なのか(http://stackoverflow.com/questions/62539/what-is-the-dependency-inversion-principle-and-why-is-it-important)
			- [もっと味](http://docs.google.com/a/cleancoder.com/viewer?a=v&pid=explorer&chrome=true&srcid=0BwhCYaYDn8EgMjdlMWIzNGUtZTQ0NC00ZjQ5LTkwYzQtZjRhMDRlNTQ3ZGMz&hl=ja)

- ### デザインパターン
	- [ ]  [クイックUMLレビュー(ビデオ)](https://www.youtube.com/watch?v=3cmzqZzwNDM&list=PLGLfVvz_LVvQ5G-LdJ8RLqe-ndo7QITYc&index=3)
	- [ ] これらのパターンを学ぶ：
		- [ ] Strategy(戦略)
		- [ ] Singleton(単一要素)
		- [ ] Adapter(アダプタ)
		- [ ] Prototype(原型)
		- [ ] Decorator(装飾者)
		- [ ] Visitor(訪問者)
		- [ ] Factory,AbstractFactory(工場、抽象工場)
		- [ ] Facade(外見)
		- [ ] Observer(観察者)
		- [ ] Proxy(代理)
		- [ ] Delegate(委任)
		- [ ] Command(命令)
		- [ ] State(状態)
		- [ ] Memento(記念品)
		- [ ] Iterator(イテレータ)
		- [ ] Composite(合成)
		- [ ] Flyweight(フライ級)
	- [ ]  [第6章(パート1) - パターン(ビデオ)](https://youtu.be/LAP2A80Ajrg?list=PLJ9pm_Rc9HesnkwKlal_buSIHA-jTZMpO&t=3344)
	- [ ]  [第6章(パート2) - 抽象化 - 発生、一般階層、プレーヤーロール、シングルトン、オブザーバー、代表団(ビデオ)](https://www.youtube.com/watch?v=U8-PGsjvZc4&index=12&list=PLJ9pm_Rc9HesnkwKlal_buSIHA-jTZMpO)
	- [ ] [第6章(パート3) - アダプタ、ファサード、変更不可、読み取り専用インターフェイス、プロキシ(ビデオ)](https://www.youtube.com/watch?v=7sduBHuex4c&index=13&list=PLJ9pm_Rc9HesnkwKlal_buSIHA-jTZMpO)
	- [ ]  [ビデオシリーズ(27ビデオ)](https://www.youtube.com/playlist?list=PLF206E906175C7E07)
	- [ ]  [ヘッドファーストデザインパターン](https://www.amazon.com/Head-First-Design-Patterns-Freeman/dp/0596007124)
		- 正式な本は「デザインパターン：再利用可能なオブジェクト指向ソフトウェアの要素」であることは分かっていますが、ヘッドファーストはOOの初心者には最適です。
	- [ ]  [参考：開発者のための101のデザインパターンとヒント](https://sourcemaking.com/design-patterns-and-tips)
	- [ ]  [人間のデザインパターン](https://github.com/kamranahmedse/design-patterns-for-humans#structural-design-patterns)


- ###組み合わせ(nCk)と確率
	- [ ]  [数学のスキル：階乗、順列、組み合わせの見つけ方(選択)(ビデオ)](https://www.youtube.com/watch?v=8RRo6Ti9d0U)
	- [ ]  [学校を作る：確率(ビデオ)](https://www.youtube.com/watch?v=sZkAAk9Wwa4)
	- [ ]  [学校を作る：確率とマルコフ連鎖(ビデオ)](https://www.youtube.com/watch?v=dNaJg-mLobQ)
	- [ ]  Khan Academy：
		- コースのレイアウト：
			- [ ]  [基本理論的確率](https://www.khanacademy.org/math/probability/probability-and-combinatorics-topic)
		- ちょうどビデオ - 41(それぞれ単純で、それぞれ短いです)：
			- [ ]  [確率の説明(ビデオ)](https://www.youtube.com/watch?v=uzkc-qNVoOk&list=PLC58778F28211FA19)
- ### NP、NP-完全/近似アルゴリズム
	- 巡回セールスマン問題やナップザック問題など、NP完全問題の最も有名なクラスについて知りましょう。
       そうすれば面接官がこれらについて偽装して尋ねるとき、それらを認識することができます。
	- NP完全の意味を知る。
	- [ ]  [計算上の複雑さ(ビデオ)](https://www.youtube.com/watch?v=moPtwq_cVH8&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=23)
	- [ ]  Simonson：
		- [ ]  [貪欲アルゴリズム。 II＆NP完全性へのイントロ(ビデオ)](https://youtu.be/qcGnJ47Smlo?list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&t=2939)
		- [ ]  [NP完全性II＆リダクション(ビデオ)](https://www.youtube.com/watch?v=e0tGC6ZQdQE&index=16&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm)
		- [ ]  [NP完全性III(ビデオ)](https://www.youtube.com/watch?v=fCX1BGT3wjE&index=17&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm)
		- [ ]  [NP完全性IV(ビデオ)](https://www.youtube.com/watch?v=NKLDp3Rch3M&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=18)
	- [ ] スキナ：
		- [ ]  [CSE373 2012 - 講義23 - NP完全性の紹介(ビデオ)](https://youtu.be/KiK5TVgXbFg?list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&t=1508)
		- [ ]  [CSE373 2012 - 講義24 - NP完全性の証明(ビデオ)](https://www.youtube.com/watch?v=27Al52X3hd4&index=24&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b)
		- [ ]  [CSE373 2012 - 講演25 - NP完全性への挑戦(ビデオ)](https://www.youtube.com/watch?v=xCPH4gwIIXM&index=25&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b)
	- [ ]  [複雑さ：P、NP、NP完全性、削減(ビデオ)](https://www.youtube.com/watch?v=eHZifpgyH_4&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=22)
	- [ ]  [複雑さ：近似アルゴリズム(ビデオ)](https://www.youtube.com/watch?v=MEz1J9wY2iM&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=24)
	- [ ]  [複雑さ：固定パラメータアルゴリズム(ビデオ)](https://www.youtube.com/watch?v=4q-jmGrmxKs&index=25&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp)
	- ピーター・ノヴィグ(Peter Norvig)は、セールスマンの問題を解決するための最適なソリューションについて説明しています。
		- [JupyterNotebook](http://nbviewer.jupyter.org/url/norvig.com/ipython/TSP.ipynb)
	- あなたが持っているなら、CLRSの1048 - 1140ページ。

- ###キャッシュ
	- [ ]  LRUキャッシュ：
		- [ ]  [LRUキャッシュの魔法(Google Devの100日間)(ビデオ)](https://www.youtube.com/watch?v=R5ON3iwx78M)
		- [ ]  [LRU(ビデオ)の実装](https://www.youtube.com/watch?v=bq6N7Ym81iI)
		- [ ]  [LeetCode - 146 LRU Cache(C ++)(video)](https://www.youtube.com/watch?v=8-FZRAjR7qU)
	- [ ]  CPUキャッシュ：
		- [ ]  [MIT 6.004 L15：メモリ階層(ビデオ)](https://www.youtube.com/watch?v=vjYF_fAZI5E&list=PLrRW1w6CGAcXbMtDFj205vALOGmiRc82-&index=24)
		- [ ]  [MIT 6.004 L16：キャッシュの問題(動画)](https://www.youtube.com/watch?v=ajgC3-pyGlk&index=25&list=PLrRW1w6CGAcXbMtDFj205vALOGmiRc82-)

- ###プロセスとスレッド
	- [ ] コンピュータサイエンス162 - オペレーティングシステム(25ビデオ)：
		- プロセスとスレッドのためのビデオ表示1-11
		- [オペレーティングシステムとシステムプログラミング(ビデオ)](https://www.youtube.com/playlist?list=PL-XXv-cvA_iBDyz-ba4yDskqMDY6A1w_c)
	- [プロセスとスレッドの違いは何ですか？](https://www.quora.com/What-is-the-difference-between-a-process-and-thread)
	- カバー：
		- プロセス、スレッド、並行性の問題
			- プロセスとスレッドの違い
			- プロセス
			- スレッド
			- ロック
			- ミューテックス
			- セマフォ
			- モニタ(同期)
			- 彼らの動作の仕方
			- デッドロック
			- ライブロック
		- CPUの動作、割り込み、コンテキストの切り替え
		- マルチコアプロセッサを使用した最新の並行構成
		- [ページング、セグメンテーション、仮想メモリ(動画)](https://www.youtube.com/watch?v=LKe7xK0bF7o&list=PLCiOXwirraUCBE9i_ukL8_Kfg6XNv7Se8&index=2)
		- [割り込み(動画)](https://www.youtube.com/watch?v=uFKi2-J-6II&list=PLCiOXwirraUCBE9i_ukL8_Kfg6XNv7Se8&index=3)
		- [スケジューリング(動画)](https://www.youtube.com/watch?v=-Gu5mYdKbu4&index=4&list=PLCiOXwirraUCBE9i_ukL8_Kfg6XNv7Se8)
		- プロセスリソースのニーズ(メモリ：コード、静的ストレージ、スタック、ヒープ、ファイル記述子、I/O)
		- スレッドリソースの必要性(同じプロセス内の他のスレッドとの上の(マイナススタック)の共有、それぞれが独自のpc、スタックカウンタ、レジスタ、およびスタックを持つ)
		- フォークは、新しいプロセスがメモリに書き込むまで、実際には書き込み時にコピー(読み取り専用)され、次に完全なコピーを行います。
		- コンテキストスイッチ
			- オペレーティングシステムとその基盤となるハードウェアによってコンテキスト切り替えが開始される仕組み
	- [ ]  [C++のスレッド(シリーズ - 10ビデオ)](https://www.youtube.com/playlist?list=PL5jc9xFGsL8E12so1wlMS0r0hTQoJL74M)
	- [ ]  Pythonでの並行性(ビデオ)：
		- [ ]  [スレッドに関する短いシリーズ](https://www.youtube.com/playlist?list=PL1H1sBF1VAKVMONJWJkmUh6_p8g4F2oy1)
		- [ ]  [Pythonスレッド](https://www.youtube.com/watch?v=Bs7vPNbB9JM)
		- [ ]  [Python GIL(2010)について理解する](https://www.youtube.com/watch?v=Obt-vMVdM8s)
			- [参考文献](http://www.dabeaz.com/GIL)
		- [ ]  [David Beazley - 地上からのPython並行処理：LIVE! - PyCon 2015](https://www.youtube.com/watch?v=MCs5OvhV9S4)
		- [ ]  [基調講演David Beazley - 興味のあるトピック(Python Asyncio)](https://www.youtube.com/watch?v=ZzfHjytDceU)
		- [ ]  [Pythonのミューテックス](https://www.youtube.com/watch?v=0zaPs8OtyKY)

- ###論文
	- 完全に理解した上ですべてを読むことは、あなたが持っているより多くの時間がかかるでしょう。私は論文とそのセクションを選択することをお勧めします。
	- [古典的な論文を愛する？](https://www.cs.cmu.edu/~crary/819-f09/)
	- [ ]  [1978：順次プロセスの通信](http://spinroot.com/courses/summer/Papers/hoare_1978.pdf)
		- [Goで実装](https://godoc.org/github.com/thomas11/csp)
	- [ ]  [2003：The Googleファイルシステム](http://static.googleusercontent.com/media/research.google.com/en//archive/gfs-sosp2003.pdf)
		- 2012年に巨像に置き換えられました
	- [ ]  [2004：MapReduce：大規模クラスタでのデータ処理の簡略化](http://static.googleusercontent.com/media/research.google.com/en//archive/mapreduce-osdi04.pdf)
		- 主にCloud Dataflowに置き換えられましたか？
	- [ ]  [2006：Bigtable：構造化データ用分散ストレージシステム](https://static.googleusercontent.com/media/research.google.com/en//archive/bigtable-osdi06.pdf)
		- [Google BigQueryの内部を見る](https://cloud.google.com/files/BigQueryTechnicalWP.pdf)
	- [ ]  [2006：疎結合分散システムのChubby Lockサービス](https://research.google.com/archive/chubby-osdi06.pdf)
	- [ ]  [2007：Dynamo：Amazonの高可用性 key valueストア](https://www.akkadia.org/drepper/cpumemory.pdf)
		- Dynamo紙がNoSQL革命を開始
	- すべてのプログラマーがメモリについて知っておくべきこと(非常に長く、著者はいくつかのセクションのスキップを奨励する)](https://www.akkadia.org/drepper/cpumemory.pdf)
	- [ ]  [2010：Dapper、大規模分散システム追跡基盤](https://research.google.com/pubs/archive/36356.pdf)
	- [ ]  [2010：Dremel：Web-Scaleデータセットのインタラクティブ解析](https://static.googleusercontent.com/media/research.google.com/en//pubs/archive/36632.pdf)
	- [ ]  [2012：Googleの巨像](https://www.wired.com/2012/07/google-colossus/)
		- 論文がありません
	- [ ]  2012：AddressSanitizer：高速アドレス整合性チェッカー：
		- [論文](http://static.googleusercontent.com/media/research.google.com/en//pubs/archive/37752.pdf)
		- [ビデオ](https://www.usenix.org/conference/atc12/technical-sessions/presentation/serebryany)
	- [ ]  2013：スパナ：Googleのグローバル分散データベース：
		- [論文](http://static.googleusercontent.com/media/research.google.com/en//archive/spanner-osdi2012.pdf)
		- [ビデオ](https://www.usenix.org/node/170855)
	- [ ]  [2014年：機械学習：技術的負債の高利貸しクレジットカード](http://static.googleusercontent.com/media/research.google.com/en//pubs/archive/43146.pdf)
	- [ ]  [2015：Googleの継続的なパイプライン](http://static.googleusercontent.com/media/research.google.com/en//pubs/archive/43790.pdf)
	- [ ]  [2015年：大規模な高可用性：Googleの広告用データ基盤の構築](https://static.googleusercontent.com/media/research.google.com/en//pubs/archive/44686.pdf)
	- [ ]  [2015：TensorFlow：異種分散システムの大規模機械学習](http://download.tensorflow.org/paper/whitepaper2015.pdf)
	- [ ]  [2015年：開発者がコードを検索する方法：ケーススタディ](http://static.googleusercontent.com/media/research.google.com/en//pubs/archive/43835.pdf)
	- [ ]  [2016：Borg、Omega、Kubernetes](http://static.googleusercontent.com/media/research.google.com/ja//pubs/archive/44843.pdf)

- ###テスト
    - カバーするために：
        - ユニット(単体)テストの仕組み
        - モックオブジェクトとは何ですか？
        - 統合テストとは
        - 依存性注入とは
	- [ ]  [James Bachによるアジャイルソフトウェアテスト(ビデオ)](https://www.youtube.com/watch?v=SAhJf36_u5U)
	- [ ]  [ジェイムス・バッハによるソフトウェアテストの公開講座(ビデオ)](https://www.youtube.com/watch?v=ILkT_HV9DVU)
	- [ ]  [Steve Freeman - テスト駆動開発(これは私たちが意味するものではありません)(ビデオ)](https://vimeo.com/83960706)
		- [スライド](http://goocon.com/dl/goto-berlin-2013/slides/SteveFreeman_TestDrivenDevelopmentThatsNotWhatWeMeant.pdf)
	- [ ]  [TDDは死んでいます。長いライブテスト。](http://david.heinemeierhansson.com/2014/tdd-is-dead-long-live-testing.html)
	- [ ]  [TDDは死んでいますか？ (ビデオ)](https://www.youtube.com/watch?v=z9quxZsLcfo)
	- [ ]  [ビデオシリーズ(152ビデオ) - すべてではない(ビデオ)](https://www.youtube.com/watch?v=nzJapzxH_rE&list=PLAwxTw4SYaPkWVHeC_8aSIbSxE_NXI76g)
	- [ ]  [Pythonでテスト駆動型Web開発](http://www.obeythetestinggoat.com/pages/book.html#toc)
	- [ ] 依存性注入：
		- [ ]  [動画](https://www.youtube.com/watch?v=IKD2-MAkXyQ)
		- [ ]  [テストのタオ](http://jasonpolites.github.io/tao-of-testing/ch3-1.1.html)
	- [ ]  [テストの書き方](http://jasonpolites.github.io/tao-of-testing/ch4-1.1.html)

- ###スケジューリング
	- OSで、どのように動作するか
	- オペレーティングシステムのビデオから収集できます

- ###システムルーチンを実装する
	- 使用するプログラミングAPIの下にあるものを理解する
    あなたはそれらを実装できますか？

- ###文字列の検索と操作
	- [ ]  [Sedgewick - 接尾辞配列(ビデオ)](https://www.youtube.com/watch?v=HKPrVm5FWvg)
	- [ ]  [Sedgewick - サブストリング(文字列の一部)検索(動画)](https://www.youtube.com/watch?v=2LvvVFCEIv8&list=PLe-ggMe31CTdAdjXB3lIuf2maubzo9t66&index=5)
		- [ ]  [1. サブストリング検索の紹介](https://www.youtube.com/watch?v=2LvvVFCEIv8&list=PLe-ggMe31CTdAdjXB3lIuf2maubzo9t66&index=5)
		- [ ]  [2. ブルートフォースサブストリング検索](https://www.youtube.com/watch?v=CcDXwIGEXYU&list=PLe-ggMe31CTdAdjXB3lIuf2maubzo9t66&index=4)
		- [ ]  [3. クヌース・モーリス・プラット法](https://www.youtube.com/watch?v=n-7n-FDEWzc&index=3&list=PLe-ggMe31CTdAdjXB3lIuf2maubzo9t66)
		- [ ]  [4. ボイヤー-ムーア文字列検索アルゴリズム](https://www.youtube.com/watch?v=fI7Ch6pZXfM&list=PLe-ggMe31CTdAdjXB3lIuf2maubzo9t66&index=2)
		- [ ]  [5. ラビン-カープ文字列検索アルゴリズム](https://www.youtube.com/watch?v=QzI0p6zDjK4&index=1&list=PLe-ggMe31CTdAdjXB3lIuf2maubzo9t66)
	- [ ]  [テキストの検索パターン(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/tAfHI/search-pattern-in-text)

    このテーマについてさらに詳しく知りたい場合は、[いくつかの科目の追加の詳細]の「文字列のマッチング」の項を参照してください(#additional-detail-on-some-subjects)

- ###トライ木
	- さまざまなトライ木があることに注意してください。いくつかは接頭辞を持ち、あるものはパスを追跡するビットの代わりに文字列を使用します。
	- 私はコードを読んだが、実装しないだろう。
	- [ ]  [Sedgewick - 試してみる(3ビデオ)](https://www.youtube.com/playlist?list=PLe-ggMe31CTe9IyG9MB8vt5xUJeYgOYRQ)
		- [ ]  [1. R Way トライ木](https://www.youtube.com/watch?v=buq2bn8x3Vo&index=3&list=PLe-ggMe31CTe9IyG9MB8vt5xUJeYgOYRQ)
		- [ ]  [2. 3分探索木](https://www.youtube.com/watch?v=LelV-kkYMIg&index=2&list=PLe-ggMe31CTe9IyG9MB8vt5xUJeYgOYRQ)
		- [ ]  [3. キャラクターベースの操作](https://www.youtube.com/watch?v=00YaFPcC65g&list=PLe-ggMe31CTe9IyG9MB8vt5xUJeYgOYRQ&index=1)
	- [ ]  [データ構造とプログラミング手法に関する注記](http://www.cs.yale.edu/homes/aspnes/classes/223/notes.html#Tries)
	- [ ] 短期コースビデオ：
		- [ ]  [トライ木の紹介(ビデオ)](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/08Xyf/core-introduction-to-tries)
		- [ ]  [トライ木のパフォーマンス(ビデオ)](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/PvlZW/core-performance-of-tries)
		- [ ]  [トライ木の実装ビデオ)](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/DFvd3/core-implementing-a-trie)
	- [ ]  [Trie：無視されたデータ構造](https://www.toptal.com/java/the-trie-a-neglected-data-structure)
	- [ ]  [TopCoder - トライ木の使用](https://www.topcoder.com/community/data-science/data-science-tutorials/using-tries/)
	- [ ]  [スタンフォード講演(現実世界のユースケース)(ビデオ)](https://www.youtube.com/watch?v=TJ8SkcUSdbU)
	- [ ]  [MIT、高度なデータ構造、文字列(途中でかなり不明瞭になることがあります)](https://www.youtube.com/watch?v=NinWEPPrkDQ&index=16&list=PLUl4u3cNGP61hsJNdULdudlRL493b-XZf)

- ###浮動小数点数
	- [ ] 単純な8ビット：[浮動小数点数の表現 - 1(ビデオ - 計算にエラーがあります - ビデオの説明を参照)](https://www.youtube.com/watch?v=ji3SfClm8TU)
	- [ ]  32ビット：[IEEE754 32ビット浮動小数点バイナリ(ビデオ)](https://www.youtube.com/watch?v=50ZYcZebIec)

- ### Unicode
	- [ ]  [すべてのソフトウェア開発者が絶対に最低限必要とする、絶対にUnicodeと文字セットについて熟知していること](http://www.joelonsoftware.com/articles/Unicode.html)
	- [ ]  [すべてのプログラマーが、エンコーディングと文字セットについて知る必要があることは間違いない](http://kunststube.net/encoding/)

- ###バイト順(エンディアン)
	- [ ]  [ビッグエンディアンとリトルエンディアン](https://www.cs.umd.edu/class/sum2003/cmsc311/Notes/Data/endian.html)
	- [ ]  [ビッグエンディアン Vs リトルエンディアン(ビデオ)](https://www.youtube.com/watch?v=JrNF0KRAlyo)
	- [ ]  [ビッグエンディアンとリトルエンディアンの イン/アウト(ビデオ)](https://www.youtube.com/watch?v=oBSuXP-1Tc0)
		- カーネル開発者のための非常に技術的な話。ほとんどがあなたの頭の上にある場合は心配しないでください。
		- 前半で十分です。

- ###ネットワーキング
	- **ネットワーク経験がある、またはシステムエンジニアになりたい場合は、質問を期待してください**
	- そうでなければ、これは知っているだけでいいです
	- [ ]  [Khan Academy](https://www.khanacademy.org/computing/computer-science/internet-intro)
	- [ ]  [UDPとTCP：トランスポートプロトコルの比較](https://www.youtube.com/watch?v=Vdc8TCESIg8)
	- [[TCP / IPとOSIモデルの説明!](https://www.youtube.com/watch?v=e5DEVa9eSN0)
	- [ ]  [インターネット経由のパケット伝送。ネットワーク＆TCP / IPチュートリアル](https://www.youtube.com/watch?v=nomyRJehhnM)
	- [ ]  [HTTP](https://www.youtube.com/watch?v=WGJrLqtX7As)
	- [ ]  [SSLとHTTPS](https://www.youtube.com/watch?v=S2iBR2ZlZf0)
	- [ ]  [SSL / TLS](https://www.youtube.com/watch?v=Rp3iZUvXWlM)
	- [ ]  [HTTP 2.0](https://www.youtube.com/watch?v=E9FxNzv1Tr8)
	- [ ]  [ビデオシリーズ(21ビデオ)](https://www.youtube.com/playlist?list=PLEbnTDJUr_IggfoqO4iPnPYQui46QqT0j)
	- [ ]  [詳解サブネット化 - 第5部CIDR表記](https://www.youtube.com/watch?v=t5xYI0jzOf4)
	- [ ] ソケット：
		- [ ]  [Java - Sockets - Introduction(video)](https://www.youtube.com/watch?v=6G_W54zuadg&t=6s)
		- [ ]  [ソケットプログラミング(ビデオ)](https://www.youtube.com/watch?v=G75vN2mnJeQ)

##システム設計、スケーラビリティ、データ処理
- **4年以上の経験があれば、システム設計の質問を期待できます。**
- スケーラビリティとシステム設計は、多くのトピックとリソースを持つ非常に大きなトピックです。
      スケーラビリティ(拡張可能)なソフトウェア/ハードウェアシステムを設計する際には、考慮すべき点がたくさんあります。
      これにかなりの時間を費やすことを期待してください。
- 考慮事項：
	- スケーラビリティ
		- 大きなデータセットを単一の値に変換する
		- あるデータセットを別のデータセットに変換する
		- 莫大な量のデータを扱う
	- システム設計
		- 機能セット
		- インターフェース
		- クラス階層
		- 一定の制約の下でシステムを設計する
		- シンプルさと丈夫さ
		- トレードオフ
		- パフォーマンス分析と最適化

- [ ]  **ここをクリック**：[システム設計入門](https://github.com/donnemartin/system-design-primer)
- [ ]  [HiredInTechのシステム設計](http://www.hiredintech.com/system-design/)
- [ ] [技術面接で設計質問に答えるための準備方法](https://www.quora.com/How-do-I-prepare-to-answer-design-questions-in-a-technical-interview?redirected_qid=1500023)
- [ ] [システムデザイン面接の前に知っておくべき8つの事柄](http://blog.gainlo.co/index.php/2015/10/22/8-things-you-need-to-know-before-system-design-interviews/)
- [ ]  [アルゴリズム設計](http://www.hiredintech.com/algorithm-design/)
- [ ]  [データベースの正規化 - 1NF、2NF、3NF、4NF(ビデオ)](https://www.youtube.com/watch?v=UrYLYV7WSHM)
- [ ]  [システム設計の面接](https://github.com/checkcheckzz/system-design-interview) - この中には多くのリソースがあります。記事や例を見てください。私はそれらのいくつかを下に置いた。
- [ ]  [システム設計面接の方法](http://www.palantir.com/2011/10/how-to-rock-a-systems-design-interview/)
- [ ]  [誰もが知っておくべき数字](http://everythingisdata.wordpress.com/2009/10/17/numbers-everyone-should-know/)
- [ ]  [コンテキストスイッチを作るのにどれくらい時間がかかりますか？](http://blog.tsunanet.net/2010/11/how-long-does-it-take-to-make-context.html)
- [ ]  [データセンター間の取引(動画)](https://www.youtube.com/watch?v=srOgpXECblk)
- [ ]  [CAP定理の簡単な英語入門](http://ksat.me/a-plain-english-introduction-to-cap-theorem/)
- [ ] Paxosアルゴリズム：
	- [短い動画](https://www.youtube.com/watch?v=s8JqcZtvnsM)
	- [ユースケースとマルチパクソスによる拡張動画](https://www.youtube.com/watch?v=JEpsBg0AO6o)
	- [論文](http://research.microsoft.com/en-us/um/people/lamport/pubs/paxos-simple.pdf)
- [ ]  [コンシステントハッシュ法](http://www.tom-e-white.com/2007/11/consistent-hashing.html)
- [NoSQLパターン](http://horicky.blogspot.com/2009/11/nosql-patterns.html)

- [ ] スケーラビリティ：
	- [ ]  [概要(動画)](https://www.youtube.com/watch?v=-W9F__D3oY4)
	- [ ] 短いシリーズ：
		- [クローン](http://www.lecloud.net/post/7295452622/scalability-for-dummies-part-1-clones)
		- [データベース](http://www.lecloud.net/post/7994751381/scalability-for-dummies-part-2-database)
		- [キャッシュ](http://www.lecloud.net/post/9246290032/scalability-for-dummies-part-3-cache)
		- [非同期](http://www.lecloud.net/post/9699762917/scalability-for-dummies-part-4-asynchronism)
	- [ ]  [スケーラブルなWebアーキテクチャと分散システム](http://www.aosabook.org/ja/distsys.html)
	- [ ]  [分散コンピューティングの説明の誤り](https://pages.cs.wisc.edu/~zuyu/files/fallacies.pdf)
	- [ ]  [実用的なプログラミングテクニック](http://horicky.blogspot.com/2010/10/scalable-system-design-patterns.html)
		- [extra：Google Pregel グラフ処理](http://horicky.blogspot.com/2010/07/google-pregel-graph-processing.html)
	- [ ]  [Jeff Dean - Googleのソフトウェアシステム構築と教訓(ビデオ)](https://www.youtube.com/watch?v=modXC5IWTJI)
	- [ ]  [スケールのための設計システムの紹介](http://lethain.com/introduction-to-architecting-systems-for-scale/)
	- [ ]  [App EngineとCloud Datastoreを使用してモバイルゲームを世界中の視聴者に拡大(ビデオ)](https://www.youtube.com/watch?v=9nWyWwY2Onc)
	- [ ]  [Googleがプラネットスケールのインフラのプラネットスケールエンジニアリングを行う仕組み](https://www.youtube.com/watch?v=H4vMcD7zKM0)
	- [ ]  [アルゴリズムの重要性](https://www.topcoder.com/community/data-science/data-science-tutorials/the-importance-of-algorithms/)
	- [ ]  [シャーディング](http://highscalability.com/blog/2009/8/6/an-unorthodox-approach-to-database-design-the-coming-of-the.html)
	- [ ]  [Facebook（2009）でスケール](https://www.infoq.com/presentations/Scale-at-Facebook)
	- [ ]  [Facebook(2012年)、「10億ユーザー向けビルド(ビデオ)」](https://www.youtube.com/watch?v=oodS71YtkGU)
	- [ ]  [ロングゲームのためのエンジニアリング - Astrid Atkinson Keynote(ビデオ)](https://www.youtube.com/watch?v=p0jGmgIrf_M&list=PLRXxvay_m8gqVlExPC5DG3TGWJTaBgqSA&index=4)
	- [ ]  [7年間のYouTubeスケーラビリティレッスン30分](http://highscalability.com/blog/2012/3/26/7-years-of-youtube-scalability-lessons-in-30-minutes.html )
		- [動画](https://www.youtube.com/watch?v=G-lGCC4KKok)
	- [ ]  [ペイパルが毎日何十億ものトランザクションにスケーリングされる方法(8VMだけを使用)](http://highscalability.com/blog/2016/8/15/how-paypal-scaled-to-billions-of-transactions-daily-using-ju.html)
	- [ ]  [大きなデータセットで重複を削除する方法](https://blog.clevertap.com/how-to-remove-duplicates-in-large-datasets/)
	- [ ]  [Jon CowieによるEtsyのスケールとエンジニアリング文化の中の一見(ビデオ)](https://www.youtube.com/watch?v=3vV4YiqKm1o)
	- [ ] [Amazonは独自のマイクロサービスアーキテクチャをどのように導いたか](http://thenewstack.io/led-amazon-microservices-architecture/)
	- [ ] [圧縮するか圧縮しないか、それはUberの質問でした](https://eng.uber.com/trip-data-squeeze/)
	- [ ]  [Tarantoolの非同期キュー、キューに入れる](http://highscalability.com/blog/2016/3/3/asyncio-tarantool-queue-get-in-the-queue.html)
	- [ ]  [おおよそのクエリ処理を使用するタイミング](http://highscalability.com/blog/2016/2/25/when-should-approximate-query-processing-be-used.html)

    - [ ]  [単一のデータセンターからフェイルオーバーするための、Googleのネイティブマルチホームアーキテクチャへの移行](http://highscalability.com/blog/2016/2/23/googles-transition-from-single-datacenter-to-failover-to-a-n.html)
	- [ ]  [スパナ](http://highscalability.com/blog/2012/9/24/google-spanners-most-surprising-revelation-nosql-is-out-and.html)
	- [ ]  [Egnyteアーキテクチャ：マルチペタバイト分散システムの構築とスケーリングの教訓](http://highscalability.com/blog/2016/2/15/egnyte-architecture-lessons-learned-in-building-and-scaling.html)
	- [ ]  [機械学習駆動プログラミング：新しい世界のための新しいプログラミング](http://highscalability.com/blog/2016/7/6/machine-learning-driven-programming-a-new-programming-for-a.html)
	- [ ]  [1日あたり何百万ものリクエストを処理する画像最適化技術](http://highscalability.com/blog/2016/6/15/the-image-optimization-technology-that-serves-millions-of-re.html)
	- [ ]  [Patreonのアーキテクチャの概要](http://highscalability.com/blog/2016/2/1/a-patreon-architecture-short.html)
	- [ ]  [Tinder：どのようにして最大のレコメンデーションエンジンの誰があなたが次に誰を見るか決定する？](http://highscalability.com/blog/2016/1/27/tinder-how-does-one-of-the-largest-recommendation-engines-de.html)
	- [ ]  [現代のキャッシュのデザイン](http://highscalability.com/blog/2016/1/25/design-of-a-modern-cache.html)
	- [ ]  [Facebookのスケールでライブビデオストリーミング](http://highscalability.com/blog/2016/1/13/live-video-streaming-at-facebook-scale.html)
    - [ ]  [AmazonのAWSで1,100万人以上のユーザーに拡大するための初心者向けガイド](http://highscalability.com/blog/2016/1/11/a-beginners-guide-to-scaling-to-11-million-users-on-amazons.html)
	- [ ]  [Dockerの効果待ち時間の使用方法](http://highscalability.com/blog/2015/12/16/how-does-the-use-of-docker-effect-latency.html)
	- [ ]  [AMPはGoogleに存在する脅威に対抗していますか？](http://highscalability.com/blog/2015/12/14/does-amp-counter-an-existential-threat-to-google.html)
	- [ ]  [全Netflixスタックの360度ビュー](http://highscalability.com/blog/2015/11/9/a-360-degree-view-of-the-entire-netflix-stack.html) )
	- [ ]  [レイテンシはどこにでもあり、それはあなたのセールスに費やされます - それを粉砕する方法](http://highscalability.com/latency-everywhere-and-it-costs-you-sales-how-crush-it)
	- [ ]  [サーバーレス(非常に長い、要点が必要)](http://martinfowler.com/articles/serverless.html)
	- [ ]  [Instagramを動かすもの：何百ものインスタンス、数十のテクノロジ](http://instagram-engineering.tumblr.com/post/13649370142/what-powers-instagram-hundreds-of-instances)
	- [ ] [シンクキャストアーキテクチャ - 毎日1,500時間の音声を生成する](http://highscalability.com/blog/2012/7/16/cinchcast-architecture-producing-1500-hours-of-audio-every-d.html)
	- [ ]  [Justin.Tvのライブビデオブロードキャストアーキテクチャ](http://highscalability.com/blog/2010/3/16/justintvs-live-video-broadcasting-architecture.html)
	- [ ]  [Playfishのソーシャルゲームアーキテクチャ - 月間5000万人のユーザーと成長](http://highscalability.com/blog/2010/9/21/playfishs-social-gaming-architecture-50-million-monthly-user.html) )
	- [ ]  [アーキテクチャ - 40Mビジター、200Mダイナミックページビュー、30TBデータ]()
	- [ ]  [PlentyOfFishアーキテクチャ](http://highscalability.com/plentyoffish-architecture)
	- [ ]  [Salesforceのアーキテクチャ - どのように130億回のトランザクションを処理するか](http://highscalability.com/blog/2013/9/23/salesforce-architecture-how-they-handle-13-billion-transacti.html) )
	- [ ]  [ESPNの規模でのアーキテクチャ - 毎秒100,000のDuh Nuh Nuhsで動作](http://highscalability.com/blog/2013/11/4/espns-architecture-at-scale-operating-at-100000-duh-nuh-nuhs.html)
	- [ ] サービスを結合する技術の情報については、以下の「メッセージング、シリアライゼーション、およびキューイングシステム」を参照してください。
	- [ ]  Twitter：
		- [O`Reilly MySQL CE 2011：Jeremy Cole、「@Twitterの大小データ」(ビデオ)](https://www.youtube.com/watch?v=5cKTP36HVgI)
		- [スケール時のタイムライン](https://www.infoq.com/presentations/Twitter-Timeline-Scalability)
	- さらに詳しくは、[ビデオシリーズ](ビデオシリーズ)セクションの「Mining Massive Datasets」ビデオシリーズを参照してください。

- [ ] システム設計プロセスの練習：紙で作業しようとするいくつかのアイデアがあります。実際にどのように処理されたかについてのいくつかの文書があります。
	- レビュー：[システム設計入門](https://github.com/donnemartin/system-design-primer)
	- [HiredInTechのシステム設計](http://www.hiredintech.com/system-design/)
	- [チートシート](https://github.com/jwasham/coding-interview-university/blob/master/extras/cheat%20sheets/system-design.pdf)
	- 流れ：
        1. 問題と範囲を理解する：
            - 面接官の助けを借りてユースケースを定義する
			- 追加の機能を提案する
			- 面接官が範囲外とみなすアイテムを削除する
			- 高可用性が必要と仮定し、ユースケースとして追加する
        2. 制約について考える：
			- 毎月のリクエスト数を尋ねる
			- 毎秒どれくらいのリクエストをするか(彼らはボランティアでもよいし、あなたに数学をさせるかもしれない)
			- 読み込みと書き込みの割合を見積もります
			- 推定時に80/20ルールを守って下さい
			- 1秒あたりに書き込まれるデータの量
			- 5年間に必要な合計ストレージ
			- 毎秒読み取られるデータの量
        3. 抽象的なデザイン：
			- レイヤー(サービス、データ、キャッシング)
			- インフラストラクチャ：負荷分散、メッセージング
			- サービスを駆動する主要なアルゴリズムの概要
			- ボトルネックを考慮し、解決策を決定する
	- 演習：
		- [CDNネットワークの設計：古い記事](http://repository.cmu.edu/cgi/viewcontent.cgi?article=2112&context=compsci)
		- [ランダムなID生成システムの設計](https://blog.twitter.com/2010/announcing-snowflake)
		- [オンラインマルチプレイヤーカードゲームのデザイン](http://www.indieflashblog.com/how-to-create-an-asynchronous-multiplayer-game.html)
		- [Key-Valueデータベースの設計](http://www.slideshare.net/dvirsky/introduction-to-redis)
		- [画像共有システムの設計](http://highscalability.com/blog/2011/12/6/instagram-architecture-14-million-users-terabytes-of-photos.html)
		- [推薦システムの設計](http://ijcai13.org/files/tutorial_slides/td3.pdf)
		- [URL短縮システムの設計：上からコピー](http://www.hiredintech.com/system-design/the-system-design-process/)
		- [キャッシュシステムの設計](https://www.adayinthelifeof.nl/2011/02/06/memcache-internals/)

---

##最終レビュー

    このセクションでは、重要な概念のほとんどを見直すためにかなり短いビデオを見ることができます。
    あなたが頻繁に再学習をしたいならいいですね。

- [ ]  2〜3分短編ビデオシリーズ(23ビデオ)
	- [動画](https://www.youtube.com/watch?v=r4r1DZcx1cM&list=PLmVb1OknmNJuC5POdcDv5oCS7_OUkDgpj&index=22)
- [ ] 2〜5分の短編シリーズビデオ - Michael Sambol(18ビデオ)
	- [動画](https://www.youtube.com/channel/UCzDJwLWoYCUQowF_nG3m5OQ)
- [ ]  [Sedgewick Videos - アルゴリズムI](https://www.youtube.com/user/algorithmscourses/playlists?shelf_id=2&view=50&sort=dd)
	- [ ]  [01.Union-Find](https://www.youtube.com/watch?v=8mYfZeHtdNc&list=PLe-ggMe31CTexoNYnMhbHaWhQ0dvcy43t)
	- [ ]  [02.アルゴリズムの分析](https://www.youtube.com/watch?v=ZN-nFW0mEpg&list=PLe-ggMe31CTf0_bkOhh7sa5uqeppp3Sr0)
	- [ ]  [03.スタックとキュー](https://www.youtube.com/watch?v=TIC1gappbP8&list=PLe-ggMe31CTe-9jhnj3P_3mmrCh0A7iHh)
	- [ ]  [04.初級ソート](https://www.youtube.com/watch?v=CD2AL6VO0ak&list=PLe-ggMe31CTe_5WhGV0F--7CK8MoRUqBd)
	- [ ]  [05. マージソート](https://www.youtube.com/watch?v=4nKwesx_c8E&list=PLe-ggMe31CTeunC6GZHFBmQx7EKtjbGf9)
	- [ ]  [06. クイックソート](https://www.youtube.com/watch?v=5M5A7qPWk84&list=PLe-ggMe31CTeE3x2-nF1-toca1QpuXwE1)
	- [ ]  [07.優先度つきキュー](https://www.youtube.com/watch?v=G9TMe0KC0w0&list=PLe-ggMe31CTducy9LDiGVkdSv0NfiRwn5)
	- [ ]  [08. 基本記号表](https://www.youtube.com/watch?v=up_nlilw3ac&list=PLe-ggMe31CTc3a8nKRDxFZZrWrBvkc9SG)
	- [ ]  [09. 平衡探索木](https://www.youtube.com/watch?v=qC1BLLPK_5w&list=PLe-ggMe31CTf7jHH_mFT50kayjCEA6Rhu)
	- [ ]  [10. BSTの幾何学的応用](https://www.youtube.com/watch?v=Wl30aGAp6TY&list=PLe-ggMe31CTdBsRIw0hXln0hilRs-DqAx)
	- [ ]  [11.ハッシュテーブル](https://www.youtube.com/watch?v=QA8fJGO-i9o&list=PLe-ggMe31CTcKxIRGqqThMts2eHtSrf11)
- [ ]  [Sedgewick Videos - アルゴリズムII](https://www.youtube.com/user/algorithmscourses/playlists?flow=list&shelf_id=3&view=50)
	- [ ]  [01.無向グラフ](https://www.youtube.com/watch?v=GmVhD-mmMBg&list=PLe-ggMe31CTc0zDzANxl4I2MhMoRVlbRM)
	- [ ]  [02. 有向グラフ](https://www.youtube.com/watch?v=_z-JsVaUS40&list=PLe-ggMe31CTcEwaU8a1P1Gd95A77HV85K)
	- [ ]  [03.最小スパニング木](https://www.youtube.com/watch?v=t8fNk9tfVYY&list=PLe-ggMe31CTceUZxDesGfHGLE7kcSafqj)
	- [ ]  [04.最短経路](https://www.youtube.com/watch?v=HoGSiB7tSeI&list=PLe-ggMe31CTePpG3jbeOTsnGUGZDKxgZD)
	- [ ]  [05.最大フロー](https://www.youtube.com/watch?v=rYIKlFstBqE&list=PLe-ggMe31CTduQ68XQ-sVj32wYJIspTma)
	- [ ]  [06.基数ソート](https://www.youtube.com/watch?v=HKPrVm5FWvg&list=PLe-ggMe31CTcNvUX9E3tQeM6ntrdR8e53)
	- [ ]  [07.トライ木](https://www.youtube.com/watch?v=00YaFPcC65g&list=PLe-ggMe31CTe9IyG9MB8vt5xUJeYgOYRQ)
	- [ ]  [08.部分文字列検索](https://www.youtube.com/watch?v=QzI0p6zDjK4&list=PLe-ggMe31CTdAdjXB3lIuf2maubzo9t66)
	- [ ]  [09.正規表現](https://www.youtube.com/watch?v=TQWNQsJSPnk&list=PLe-ggMe31CTetTlJWouM42fyttyKPgSDh)
	- [ ]  [10.データ圧縮](https://www.youtube.com/watch?v=at9tjpxcBh8&list=PLe-ggMe31CTciifRRo6yY0Yt0mzgIXXVZ)
	- [ ]  [11.リダクション](https://www.youtube.com/watch?v=Ow5x-ooMGv8&list=PLe-ggMe31CTe_yliW5vc3yO-dj1LSSDyF)
	- [ ]  [12.線形プログラミング](https://www.youtube.com/watch?v=rWhcLyiLZLA&list=PLe-ggMe31CTdy6dKzMgkWFuTTN1H8B-E1)
	- [ ]  [13.難易度](https://www.youtube.com/watch?v=6qcaaDp4cdQ&list=PLe-ggMe31CTcZCjluBHw53e_ek2k9Kn-S)

---

##コーディングの質問練習

上のすべてのコンピュータサイエンスのトピックを知ったので、コーディングの問題に答える練習をしましょう。

**コーディング質問の練習は、プログラミング問題への回答を記憶することではありません。**

プログラミングの問題を練習する必要がある理由
- 問題の認識、そして適切なデータ構造とアルゴリズムの適合
- 問題のための要件を集める
- 面接であなたのように問題をあなたの方法で話している
- コンピュータではなく、ホワイトボードや紙でのコーディング
- ソリューションの時間と空間の複雑さが増す
- ソリューションのテスト

面接では、体系的でコミュニケーション的な問題解決の素晴らしいイントロがあります。あなたはプログラミングの面接の本からもこれを手に入れるでしょうが、私はこの優れた発見しました：
[アルゴリズム設計キャンバス](http://www.hiredintech.com/algorithm-design/)

自宅にホワイトボードはありませんか？それは理にかなっている。私は変わった人で、大きなホワイトボードを持っています。ホワイトボードの代わりに、
アートストアから大きなドローイングパッドを拾い上げます。あなたはソファに座って練習することができます。これが私の「ソファホワイトボード」です。
私はスケールの写真にペンを追加しました。ペンを使うと、あなたは消すことができます。すぐに厄介になる。

![私のソファホワイトボード](https://dng5l3qzreal6.cloudfront.net/2016/Oct/art_board_sm_2-1476233630368.jpg)

補足：

- [Topcodersの数学](https://www.topcoder.com/community/data-science/data-science-tutorials/mathematics-for-topcoders/)
- [動的プログラミング - 初心者から上級者まで](https://www.topcoder.com/community/data-science/data-science-tutorials/dynamic-programming-from-novice-to-advanced/)
- [MIT面接資料](https://web.archive.org/web/20160906124824/http://courses.csail.mit.edu/iap/interview/materials.php)
- [特定の言語でより良くなるための練習](http://exercism.io/languages)

**プログラミングの問題を読んでやる(この順番で)：**

- [ ]  [プログラミング面接公開：あなたが次の仕事に着任する秘訣、第2版](http://www.wiley.com/WileyCDA/WileyTitle/productCd-047012167X.html)
	- C、C ++、Javaの回答
- [ ]  [コーディング面接をクラッキング、第6版](http://www.amazon.com/Cracking-Coding-Interview-6th-Programming/dp/0984782850/)
	- Javaでの回答

[上記のブックリスト](#ブックリスト)を参照してください

##コード演習/挑戦

あなたの脳を学んだら、脳を働かせてください。
できるだけ多く、毎日コーディングの課題に取り組んでください。

- [ ]  [解決策を見つける方法](https://www.topcoder.com/community/data-science/data-science-tutorials/how-to-find-a-solution/)
- [ ]  [Topcoderの問題を解読する方法](https://www.topcoder.com/community/data-science/data-science-tutorials/how-to-dissect-a-topcoder-problem-statement/)

コーディング面接質問ビデオ：
- [IDeserve(88ビデオ)](https://www.youtube.com/watch?v=NBcqBddFbZw&list=PLamzFoFxwoNjPfxzaWqs7cZGsPYy0x_gI)
- [Tushar Roy(5プレイリスト)](https://www.youtube.com/user/tusharroy2525/playlists?shelf_id=2&view=50&sort=dd)

チャレンジサイト：
- [LeetCode](https://leetcode.com/)
- [TopCoder](https://www.topcoder.com/)
- [プロジェクトオイラー(Math-focused)](https://projecteuler.net/index.php?section=problems)
- [コードワード](http://www.codewars.com)
- [HackerEarth](https://www.hackerearth.com/)
- [HackerRank](https://www.hackerrank.com/)
- [Codility](https://codility.com/programmers/)
- [InterviewCake](https://www.interviewcake.com/)
- [Geeks for Geeks](http://www.geeksforgeeks.org/)
- [InterviewBit](https://www.interviewbit.com/invite/icjf)
- [Sphere(Sphere)](http://www.spoj.com/)

チャレンジレポ：
- [Pythonでインタラクティブなコーディング面接の課題](https://github.com/donnemartin/interactive-coding-challenges)

疑似面接：
- [Gainlo.co：大企業の疑似面接官](http://www.gainlo.co/)
- [Pramp：仲間との面接](https://www.pramp.com/)
- [Refdash：疑似面接](https://refdash.com/)

##面接に近づいたら

- [ ] クラッキングコーディング面接セット2(ビデオ)：
	- [コード面接をクラッキングする](https://www.youtube.com/watch?v=4NIb9l3imAo)
	- [コード面接をクラックする - Fullstack Speaker Series](https://www.youtube.com/watch?v=Eg5-tdAwclo)

## あなたの履歴書

- クラッキングでの準備項目の再開を参照してください。コーディング面接とプログラミング面接の公開


##面接が来たときに考えてください

あなたが得る20の面接の質問と、以下の項目の行を考えてみましょう。
それぞれ2-3の答えがあります。
あなたが達成したことについての物語だけでなく、データを持ってください。

- なぜあなたはこの仕事をしたいです？
- あなたが解決した厳しい問題は何ですか？
- 最大の課題に直面した？
- ベスト/最悪のデザインが見られる？
- 既存の製品を改善するためのアイデア。
- 個人として、そしてチームの一員として、どのようにベストを尽くしていますか？
- あなたのスキルや経験のうち、その役割の資産とその理由は？
- [job x / project y]で一番楽しかったことは何ですか？
- [job x / project y]に直面した最大の課題は何ですか？
- [job x / project y]で直面した最も難しいバグは何でしたか？
- [job x / project y]で何を学びましたか？
- あなたは[job x / project y]で何を良くしていますか？

##面接官に質問があります

    私の中には(私は既に知っているかもしれませんが、彼らの意見やチームの視点が必要です)：

あなたのチームはどれくらいの規模ですか？
- あなたの開発サイクルはどのように見えるのですか？あなたはウォーターフォール/スプリント/アジャイルをしますか？
- 締め切りまでのフローは共通ですか？それとも柔軟性はありますか？
- あなたのチームではどのように意思決定が行われますか？
- 週に何回会議がありますか？
- あなたの仕事環境が集中するのに役立つと思いますか？
- 何をしているの？
- それについて何が好きですか？
- 仕事の生活はどうですか？

##一度あなたは仕事を得た

おめでとう!

学び続けます。

あなたは決して本当に終わらない。

---

    *************************************************** *************************************************** *
    *************************************************** *************************************************** *

    この点以下のものはすべてオプションです。
    これらを勉強することで、より多くのCSコンセプトにさらされることになります。
    任意のソフトウェアエンジニアリングジョブ。あなたはもっと豊富なソフトウェアエンジニアになるでしょう。

    *************************************************** *************************************************** *
    *************************************************** *************************************************** *

---


##その他の書籍

- [ ]  [Unixプログラミング環境](http://product.half.ebay.com/The-UNIX-Programming-Environment-by-Brian-W-Kernighan-and-Rob-Pike-1983-Other/54385&tg=情報)
	- 古き良き時代
- [ ]  [Linuxコマンドライン：完全な紹介](https://www.amazon.com/dp/1593273894/)
	- 現代的な選択肢
- [ ]  [TCP / IP Illustrated Series](https://en.wikipedia.org/wiki/TCP/IP_Illustrated)
- [ ]  [ヘッドファーストデザインパターン](https://www.amazon.com/gp/product/0596007124/)
	- デザインパターンへの穏やかな紹介
- [ ]  [デザインパターン：再利用可能なオブジェクト指向ソフトウェアの要素](https://www.amazon.com/Design-Patterns-Elements-Reusable-Object-Oriented/dp/0201633612)
	- 別名「Gang Of Four」の本、またはGOF
	- 正式なデザインパターンの本
- [ ]  [UNIXおよびLinuxシステム管理ハンドブック、第4版](https://www.amazon.com/UNIX-Linux-System-Administration-Handbook/dp/0131480057/)

##その他の学習

これらの話題は面接では出てこないかもしれませんが、
特定のテクノロジとアルゴリズムを認識するためには、より大きなツールボックスが必要になります。

- ###コンパイラ
	- [ ]  [1分でコンパイラがどのように動作するか(ビデオ)](https://www.youtube.com/watch?v=IhC7sdYe-Jg)
	- [ ]  [Harvard CS50 - コンパイラ(ビデオ)](https://www.youtube.com/watch?v=CSZLNYF4Klo)
	- [ ]  [C ++(video)](https://www.youtube.com/watch?v=twodd1KFfGk)
	- [ ]  [コンパイラの最適化について(C ++)(ビデオ)](https://www.youtube.com/watch?v=FnGCDLhaxKU)

- ### Emacsとvi(m)
	- UNIXベースのコードエディタに慣れましょう
	- vi(m)：
		- [vim 01での編集 - インストール、設定、およびモード(ビデオ)](https://www.youtube.com/watch?v=5givLEMcINQ&index=1&list=PL13bz4SHGmRxlZVmWQ9DvXo1fEg4UdGkr)
		- [VIM Adventures](http://vim-adventures.com/)
		- 4ビデオのセット：
			- [vi / vimエディタ - レッスン1](https://www.youtube.com/watch?v=SI8TeVMX8pk)
			- [vi / vimエディタ - レッスン2](https://www.youtube.com/watch?v=F3OO7ZIOaJE)
			- [vi / vimエディター - レッスン3](https://www.youtube.com/watch?v=ZYEccA_nMaI)
			- [vi / vimエディタ - レッスン4](https://www.youtube.com/watch?v=1lYD5gwgZIA)
		- [Emacsの代わりにViを使う](http://www.cs.yale.edu/homes/aspnes/classes/223/notes.html#Using_Vi_instead_of_Emacs)
	- emacs：
		- [基本Emacsチュートリアル(ビデオ)](https://www.youtube.com/watch?v=hbmV1bnQ-i0)
		- 3つのセット(ビデオ)：
			- [Emacsチュートリアル(初心者向け) - 第1部 - ファイルコマンド、カット/コピー/ペースト、カーソルコマンド](https://www.youtube.com/watch?v=ujODL7MD04Q)
			- [Emacsチュートリアル(初心者向け) - パート2 - バッファ管理、検索、M-grep、rgrepモード](https://www.youtube.com/watch?v=XWpsRupJ4II)
			- [Emacsチュートリアル(初心者) - 第3章式、ステートメント、〜/ .emacsファイルとパッケージ](https://www.youtube.com/watch?v=paSgzPso-yc)
		- [邪悪なモード：または、私がEmacsを気絶させ、愛する方法(動画)](https://www.youtube.com/watch?v=JWD1Fpdd4Pc)
		- [EmacsでCプログラムを書く](http://www.cs.yale.edu/homes/aspnes/classes/223/notes.html#Writing_C_programs_with_Emacs)
		- [(多分)組織モードの詳細：構造の管理(ビデオ)](https://www.youtube.com/watch?v=nsGYet02bEk)

- ### Unixコマンドラインツール
	- 私は良いツールから下のリストに記入しました。
	- [ ]  bash
    - [ ]  cat
	- [ ]  grep
	- [ ]  sed
	- [ ]  awk
	- [ ] カールまたはwget
	- [ ] ソート
	- [ ]  tr
	- [ ]  uniq
	- [ ]  [strace](https://en.wikipedia.org/wiki/Strace)
	- [ ]  [tcpdump](https://danielmiessler.com/study/tcpdump/)

- ###情報理論(ビデオ)
	- [ ]  [Khan Academy](https://www.khanacademy.org/computing/computer-science/informationtheory)
	- [ ]  Markovプロセスの詳細：
		- [ ]  [Core Markov Text Generation](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/waxgx/core-markov-text-generation)
		- [ ]  [Markov Text Generationを実装するコア](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/gZhiC/core-implementing-markov-text-generation)
		- [ ]  [プロジェクト=マルコフテキスト生成ウォークスルー](https://www.coursera.org/learn/data-structures-optimizing-performance/lecture/EUjrq/project-markov-text-generation-walkthroughs)
	- 下記のMIT 6.050J Information and Entropyシリーズを参照してください。

- ###パリティ＆ハミングコード(ビデオ)
	- [ ]  [イントロ](https://www.youtube.com/watch?v=q-3BctoUpHE)
	- [ ]  [Parity](https://www.youtube.com/watch?v=DdMcAUlxh1M)
	- [ ] ハミングコード：
		- [エラー検出](https://www.youtube.com/watch?v=1A_NcXxdoCc)
		- [エラー修正](https://www.youtube.com/watch?v=JAMLuxdHH8o)
	- [ ]  [エラーチェック](https://www.youtube.com/watch?v=wbH2VxzmoZk)

- ###エントロピー
	- 下記の動画もご覧ください
	- 最初に情報理論ビデオを見てください
	- [情報理論、Claude Shannon、エントロピー、冗長性、データ圧縮およびビット(ビデオ)](https://youtu.be/JnJq3Py0dyM?t=176)

- ###暗号化
	- 下記の動画もご覧ください
	- 最初に情報理論ビデオを見てください
	- [ ]  [Khan Academy Series](https://www.khanacademy.org/computing/computer-science/cryptography)
	- [ ]  [暗号化：ハッシュ関数](https://www.youtube.com/watch?v=KqqOXndnvic&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=30)
	- [ ]  [暗号化：暗号化](https://www.youtube.com/watch?v=9TNI2wHmaeI&index=31&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp)

- ###圧縮
	- 最初に情報理論ビデオを見てください
	- [ ]  Computerphile(ビデオ)：
		- [ ]  [圧縮](https://www.youtube.com/watch?v=Lto-ajuqW3w)
		- [ ]  [Entropy in Compression](https://www.youtube.com/watch?v=M5c_RFKVkko)
		- [ ]  [上向きの木(ハフマン木)](https://www.youtube.com/watch?v=umTbivyJoiI)
		- [ ]  [エキストラビット/ TRITS - ハフマン木](https://www.youtube.com/watch?v=DV8efuB3h2g)
		- [ ]  [テキストのエレガントな圧縮(LZ 77方式)](https://www.youtube.com/watch?v=goOa3DGezUA)
		- [ ]  [テキスト圧縮が確率を満たす](https://www.youtube.com/watch?v=cCDCfoHTsaU)
	- [ ]  [Compressor Head videos](https://www.youtube.com/playlist?list=PLOU2XLYxmsIJGErt5rrCqaSGTMyyqNt2H)
	- [ ]  [(オプション)Google Developers Live：GZIPでは不十分です!](https://www.youtube.com/watch?v=whGwm0Lky2s)

- ###コンピュータセキュリティ
	- [MIT(23ビデオ)](https://www.youtube.com/playlist?list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [はじめに、脅威モデル](https://www.youtube.com/watch?v=GqmQg-cszw4&index=1&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [ハイジャック攻撃の制御](https://www.youtube.com/watch?v=6bwzNg5qQ0o&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh&index=2)
		- [ ]  [バッファオーバーフローの悪用と防御](https://www.youtube.com/watch?v=drQyrzRoRiA&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh&index=3)
		- [ ]  [特権の分離](https://www.youtube.com/watch?v=6SIJmoE9L9g&index=4&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [機能](https://www.youtube.com/watch?v=8VqTSY-11F4&index=5&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [サンドボックス化ネイティブコード](https://www.youtube.com/watch?v=VEV74hwASeU&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh&index=6)
		- [ ]  [ウェブセキュリティモデル](https://www.youtube.com/watch?v=chkFBigodIw&index=7&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [Webアプリケーションの保護](https://www.youtube.com/watch?v=EBQIGy1ROLY&index=8&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [シンボリック実行](https://www.youtube.com/watch?v=yRVZPvHYHzw&index=9&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [ネットワークセキュリティ](https://www.youtube.com/watch?v=SIEVvk3NVuk&index=11&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [ネットワークプロトコル](https://www.youtube.com/watch?v=QOtA76ga_fY&index=12&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)
		- [ ]  [サイドチャネル攻撃](https://www.youtube.com/watch?v=PuVMkSEcPiI&index=15&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)

- ###ガベージコレクション
	- [ ]  [ガベージコレクション(Java);データの拡張(動画)](https://www.youtube.com/watch?v=StdfeXaKGEc&list=PL-XXv-cvA_iAlnI-BQr9hjqADPBtujFJd&index=25)
	- [ ]  [コンパイラ(ビデオ)](https://www.youtube.com/playlist?list=PLO9y7hOkmmSGTy5z6HZ-W4k2y8WXF7Bff)
	- [ ]  [GC in Python(video)](https://www.youtube.com/watch?v=iHVs_HkjdmI)
	- [ ]  [ディープダイブJava：ガーベッジコレクションは良いです!](https://www.infoq.com/presentations/garbage-collection-benefits)
	- [ ]  [Deep Dive Python：CPythonでのガベージコレクション(ビデオ)](https://www.youtube.com/watch?v=P-8Z0-MhdQs&list=PLdzf4Clw0VbOEWOS_sLhT_9zaiQDrS5AR&index=3)

- ###パラレルプログラミング
	- [ ]  [Coursera(Scala)](https://www.coursera.org/learn/parprog1/home/week/1)
	- [ ]  [高性能並列計算のための効率的なPython(ビデオ)](https://www.youtube.com/watch?v=uY85GkaYzBk)

- ###メッセージング、シリアライゼーション、およびキューイングシステム
	- [ ]  [Thrift](https://thrift.apache.org/)
		- [チュートリアル](http://thrift-tutorial.readthedocs.io/ja/latest/intro.html)
	- [ ]  [プロトコルバッファ](https://developers.google.com/protocol-buffers/)
		- [チュートリアル](https://developers.google.com/protocol-buffers/docs/tutorials)
	- [ ]  [gRPC](http://www.grpc.io/)
		- [gRPC 101 for Java Developers(video)](https://www.youtube.com/watch?v=5tmPvSe7xXQ&list=PLcTqM9n_dieN0k1nSeN36Z_ppKnvMJoly&index=1)
	- [ ]  [Redis](http://redis.io/)
		- [チュートリアル](http://try.redis.io/)
	- [ ]  [Amazon SQS(キュー)](https://aws.amazon.com/sqs/)
	- [ ]  [Amazon SNS(pub-sub)](https://aws.amazon.com/sns/)
	- [ ]  [RabbitMQ](https://www.rabbitmq.com/)
		- [はじめに](https://www.rabbitmq.com/getstarted.html)
	- [ ]  [Celery](http://www.celeryproject.org/)
		- [セロリの最初のステップ](http://docs.celeryproject.org/en/latest/getting-started/first-steps-with-celery.html)
	- [ ]  [ZeroMQ](http://zeromq.org/)
		- [イントロ - マニュアルを読む](http://zeromq.org/intro:read-the-manual)
	- [ ]  [ActiveMQ](http://activemq.apache.org/)
	- [ ]  [Kafka](http://kafka.apache.org/documentation.html#introduction)
	- [ ]  [MessagePack](http://msgpack.org/index.html)
	- [ ]  [Avro](https://avro.apache.org/)

- ### A *
	- [ ]  [検索アルゴリズム](https://en.wikipedia.org/wiki/A*_search_algorithm)
	- [ ]  [A * Pathfinding Tutorial(video)](https://www.youtube.com/watch?v=KNXfSOx4eEE)
	- [ ]  [A *経路探索(E01：アルゴリズムの説明)(ビデオ)](https://www.youtube.com/watch?v=-L-WgKMFuhE)

- ###高速フーリエ変換
	- [ ]  [フーリエ変換のインタラクティブガイド](https://betterexplained.com/articles/an-interactive-guide-to-the-fourier-transform/)
	- [ ]  [フーリエ変換とは何ですか？それは何のために使われますか？](http://www.askamathematician.com/2012/09/q-what-is-a-fourier-transform-what-is-it-used-for/)
	- [ ]  [フーリエ変換とは何ですか？ (ビデオ)](https://www.youtube.com/watch?v=Xxut2PN-V8Q)
	- [ ]  [Divide＆Conquer：FFT(ビデオ)](https://www.youtube.com/watch?v=iTMn0Kt18tg&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=4)
	- [ ]  [FFTの理解](http://jakevdp.github.io/blog/2013/08/28/understanding-the-fft/)

- ###ブルームフィルター
	- mビットとkハッシュ関数を持つBloomフィルタが与えられた場合、挿入とメンバーシップの両方のテストはO(k)
	- [Bloom Filters](https://www.youtube.com/watch?v=-SuTGoFYjZs)
	- [ブルームフィルター|大規模なデータセットのマイニング|スタンフォード大学](https://www.youtube.com/watch?v=qBTdukbzc78)
	- [チュートリアル](http://billmill.org/bloomfilter-tutorial/)
	- [Bloom Filter Appを書く方法](http://blog.michaelschmatz.com/2016/04/11/how-to-write-a-bloom-filter-cpp/)

- ### HyperLogLog
	- [わずか1.5KBのメモリを使用して10億の異なるオブジェクトを数える方法](http://highscalability.com/blog/2012/4/5/big-data-counting-how-to-count-a-billion-distinct -objects-us.html)

- ###局所性に敏感なハッシング
	- ドキュメントの類似性を判断するために使用されます。
	- 2つの文書/文字列がまったく同じかどうかを判断するために使用されるMD5またはSHAの反対。
	- [Simhashing(うまくいけば)シンプルに](http://ferd.ca/simhashing-hopefully-made-simple.html)

- ###ヴァンEmde Boasの木
	- [Divide＆Conquer：van Emde Boas Trees(ビデオ)](https://www.youtube.com/watch?v=hmReJCupbNU&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=6)
	- [ ]  [MIT講義ノート](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-046j-design-and-analysis-of-algorithms-spring-2012/lecture -notes / MIT6_046JS12_lec15.pdf)

- ###拡張データ構造
	- [ ]  [CS 61B講義39：データ構造の拡張](https://youtu.be/zksIj9O8_jc?list=PL4BBB74C7D2A1049C&t=950)

- ###バランスの取れた検索木
	- 少なくとも1つのタイプの平衡二分木を知っている(そしてそれがどのように実装されているか知っている)：
	- "バランスの取れた探索木の​​中で、AVLと2/3の樹木が通過し、赤黒の木がより人気があるようです。
        特に興味深い自己組織化データ構造は、スプレイ木であり、回転を使用します
        アクセスされたキーをルートに移動する」 - Skiena
    これらのうち、私はスプレイ木を実装することを選択しました。私が読んだことから、あなたは
        あなたの面接でバランスの取れた検索木。しかし、私は1つのコーディングへの露出を望んでいた
        そしてそれに直面しましょう、スプレーの木はミツバチの膝です。私は赤黒の木のコードをたくさん読んだ。
		- スプレイ木：挿入、検索、削除機能
        あなたが赤/黒の木の実装を終わらせるならば、これらを試してみてください：
		- 検索と挿入機能、削除をスキップする
    B-Treeについては、非常に大規模なデータセットで非常に広く使用されているため、詳細を知りたい。
	- [ ]  [Self-balancing binary search tree](https://en.wikipedia.org/wiki/Self-balancing_binary_search_tree)

	- [ ]  ** AVL木**
        - 実際には：
            私が言うことから、これらは実際にはあまり使われていませんが、どこになるか分かります。
            AVL木は、O(log n)検索、挿入、および削除をサポートする別の構造です。より厳格に
            赤黒の木よりもバランスがとれているため、挿入と取り出しが遅くなりますが、検索が速くなります。これにより
            一度構築され、再構成なしでロードされる、例えば言語
            辞書(または、アセンブラまたはインタプリタのオペコードなどのプログラム辞書)を含む。
		- [ ]  [MIT AVL Trees / AVL Sort(ビデオ)](https://www.youtube.com/watch?v=FNeL18KsWPc&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=6)
		- [ ]  [AVL木(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/Qq5E0/avl-trees)
		- [ ]  [AVL木実装(ビデオ)](https://www.coursera.org/learn/data-structures/lecture/PKEBC/avl-tree-implementation)
		- [ ]  [スプリットアンドマージ](https://www.coursera.org/learn/data-structures/lecture/22BgE/split-and-merge)

	- [ ]  **スプレッド木**
        - 実際には：
            スプレイ・木は、キャッシュ、メモリ・アロケータ、ルータ、ガベージ・コレクタ、
            データ圧縮、ロープ(長いテキスト文字列に使用される文字列の置換)、Windows NT(仮想メモリ、
            ネットワークおよびファイルシステムコードなど)
		- [ ]  [CS 61B：Splay Trees(video)](https://www.youtube.com/watch?v=Najzh1rYQTo&index=23&list=PL-XXv-cvA_iAlnI-BQr9hjqADPBtujFJd)
		- [ ]  MIT講義：Splay Trees：
			- 非常にマッシーになりますが、最後の10分を確かめてください。
			- [動画](https://www.youtube.com/watch?v=QnPl_Y6EqMo)

	- [ ]  **レッド/ブラックの木**
		- これらは2-3木の翻訳です(下記参照)
        - 実際には：
            赤黒の木は、挿入時間、削除時間、および検索時間に対して最悪の場合の保証を提供します。
            これは、リアルタイムアプリケーションなどの時間に敏感なアプリケーションでは、これらを貴重なものにするだけでなく、
            それは最悪の場合の保証を提供する他のデータ構造における貴重なビルディングブロックになります。
            例えば、計算幾何学で使用される多くのデータ構造は赤黒の木に基づくことができ、
            現在のLinuxカーネルで使用されている完全に公正なスケジューラは赤黒の木を使用します。 Javaのバージョン8では、
            Collection HashMapが変更され、LinkedListを使用して同一の要素を貧弱に保存する代わりに
            ハッシュコードでは、赤黒の木が使用されます。
		- [Aduni - アルゴリズム - 講義4(リンク先のジャンプ先)(ビデオ)](https://youtu.be/1W3x0f_RmUo?list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&t=3871)
		- [Aduni - アルゴリズム - 講義5(ビデオ)](https://www.youtube.com/watch?v=hm2GHwyKF1o&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=5)
		- [ ]  [黒い木](https://en.wikipedia.org/wiki/Red%E2%80%93black_tree)
		- [ ]  [バイナリサーチとレッドブラック木の紹介](https://www.topcoder.com/community/data-science/data-science-tutorials/an-introduction-to-binary-search-and-red -black-trees /)

- [ ]  **2-3の検索木**
    - 実際には：
            2〜3本の木は、検索が遅くなるため(AVL木よりも高さが高いため)、挿入が速くなります。
        - 2-3の木は非常にまれにしか使用しませんが、実装にはさまざまなタイプのノードが含まれるためです。代わりに、人々はレッドブラックの木を使用します。
		- [ ]  [23木の直感と定義(ビデオ)](https://www.youtube.com/watch?v=C3SsdUqasD4&list=PLA5Lqm4uh9Bbq-E0ZnqTIa8LRaL77ica6&index=2)
		- [ ]  [23-Treeのバイナリビュー](https://www.youtube.com/watch?v=iYvBtGKsqSg&index=3&list=PLA5Lqm4uh9Bbq-E0ZnqTIa8LRaL77ica6)
		- [ ]  [2-3木(学生の暗唱)(ビデオ)](https://www.youtube.com/watch?v=TOb1tuEZ2X4&index=5&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp)

	- [ ]  **2-3-4木(別名2-4木)**
        - 実際には：
            すべての2-4木には、同じ順序でデータ要素を持つ対応する赤黒の木があります。挿入と削除
            2-4木の操作は、赤黒の木の色の反転と回転にも相当します。これは2-4の木を
            赤黒の木の背後にある論理を理解するための重要なツールです。そのため、多くの導入アルゴリズムのテキストでは、
            2〜4本の木は実用的ではありません**。
		- [ ]  [CS 61B講義26：バランスの取れた検索木(ビデオ)](https://www.youtube.com/watch?v=zqrqYXkth6Q&index=26&list=PL4BBB74C7D2A1049C)
		- [ ]  [ボトムアップ234-Trees(ビデオ)](https://www.youtube.com/watch?v=DQdMYevEyE4&index=4&list=PLA5Lqm4uh9Bbq-E0ZnqTIa8LRaL77ica6)
		- [ ]  [トップダウン234木(動画)](https://www.youtube.com/watch?v=2679VQ26Fp4&list=PLA5Lqm4uh9Bbq-E0ZnqTIa8LRaL77ica6&index=5)

	- [ ]  **N-ary(K-ary、M-ary)木**
		- 注記：NまたはKは分岐因子(最大分岐)であり、
		- 2分木は2分木であり、分岐因子= 2
		- 2-3本の木は3本である
		- [ ]  [K-Ary Tree](https://en.wikipedia.org/wiki/K-ary_tree)

	- [ ]  **B-Tree**
		- 楽しい事実：それは謎ですが、Bはボーイング、バランスの取れた、またはバイエル(共同発明家)のために立つことができます。
        - 実際には：
            B木はデータベースで広く使用されています。最近のファイルシステムのほとんどは、B-tree(またはVariants)を使用しています。に加えて
            B木はファイルシステムでも使用され、任意のデータベースへの迅速なランダムアクセスを可能にします
            特定のファイル内のブロック基本的な問題は、ファイルブロックのiアドレスをディスクブロックに変換することです
            (またはおそらくシリンダーヘッドセクターへの)アドレスである。
		- [ ]  [B-Tree](https://en.wikipedia.org/wiki/B-tree)
		- [ ]  [B木(ビデオ)の紹介](https://www.youtube.com/watch?v=I22wEC1tTGo&list=PLA5Lqm4uh9Bbq-E0ZnqTIa8LRaL77ica6&index=6)
		- [ ]  [B木の定義と挿入(ビデオ)](https://www.youtube.com/watch?v=s3bCdZGrgpA&index=7&list=PLA5Lqm4uh9Bbq-E0ZnqTIa8LRaL77ica6)
		- [ ]  [B木削除(動画)](https://www.youtube.com/watch?v=svfnVhJOfMc&index=8&list=PLA5Lqm4uh9Bbq-E0ZnqTIa8LRaL77ica6)
		- [ ]  [MIT 6.851 - メモリ階層モデル(ビデオ)](https://www.youtube.com/watch?v=V3omVLzI0WE&index=7&list=PLUl4u3cNGP61hsJNdULdudlRL493b-XZf)
				- キャッシュに気付かないB木、非常に興味深いデータ構造
				- 最初の37分は非常に技術的であり、スキップすることができます(Bはブロックサイズ、キャッシュラインサイズです)


- ### k-D木
	- 矩形または高次元のオブジェクトの点数を見つけるのに最適
	- k最近接の隣人に適している
	- [ ]  [Kd Trees(ビデオ)](https://www.youtube.com/watch?v=W94M9D_yXKk)
	- [ ]  [kNN K-d木アルゴリズム(ビデオ)](https://www.youtube.com/watch?v=Y4ZgLlDfKDg)

- ###リストをスキップする
	- 「これは多少のカルトデータ構造です」 - Skiena
	- [ ]  [ランダム化：リストをスキップ(ビデオ)](https://www.youtube.com/watch?v=2g9OSRKJuzM&index=10&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp)
	- [ ]  [アニメーションともう少し詳しく](https://en.wikipedia.org/wiki/Skip_list)

- ###ネットワークの流れ
	- [ ]  [Ford-Fulkerson(ビデオ)](https://www.youtube.com/watch?v=v1VgJmkEJW0)
	- [ ]  [Ford-Fulkersonアルゴリズム(ビデオ)](https://www.youtube.com/watch?v=v1VgJmkEJW0)
	- [ ]  [ネットワークフロー(動画)](https://www.youtube.com/watch?v=2vhN4Ice5jI)

- ###分離集合と連合検索
	- [ ]  [UCB 61B - ばらばらのセット;並べ替えと選択(動画)](https://www.youtube.com/watch?v=MAEGXTwmUsI&list=PL-XXv-cvA_iAlnI-BQr9hjqADPBtujFJd&index=21)
	- [ ]  [Sedgewickアルゴリズム - Union-Find(6ビデオ)](https://www.youtube.com/watch?v=8mYfZeHtdNc&list=PLe-ggMe31CTexoNYnMhbHaWhQ0dvcy43t)

- ###高速処理のための数学
	- [ ]  [整数演算、Karatsuba倍数(ビデオ)](https://www.youtube.com/watch?v=eCaXlAaN2uE&index=11&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
	- [中国の剰余定理(暗号で使用)(ビデオ)](https://www.youtube.com/watch?v=ru7mWZJlRQg)

- ###
	- 二分探索木とヒープの組み合わせ
	- [ ]  [Treap](https://en.wikipedia.org/wiki/Treap)
	- [ ]  [データ構造：Treaps説明(動画)](https://www.youtube.com/watch?v=6podLUYinH8)
	- [ ]  [セット操作のアプリケーション](https://www.cs.cmu.edu/~scandal/papers/treaps-spaa98.pdf)

- ###リニアプログラミング(ビデオ)
	- [ ]  [線形計画法](https://www.youtube.com/watch?v=M4K6HYLHREQ)
	- [ ]  [最小費用の見積もり](https://www.youtube.com/watch?v=2ACJ9EWUC6U)
	- [ ]  [最大値の検索](https://www.youtube.com/watch?v=8AA_81xI3ik)
	- [ ]  [Pythonで線形方程式を解く - シンプレックスアルゴリズム](https://www.youtube.com/watch?v=44pAWI7v5Zk)

- ###幾何学、凸包(ビデオ)
	- [ ]  [Graph Alg。 IV：幾何学アルゴリズムの紹介 - 講義9(https://youtu.be/XIAQRlNkJAw?list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&t=3164)
	- [ ]  [Geometric Algorithms：Graham＆Jarvis - 講義10](https://www.youtube.com/watch?v=J5aJEcOr6Eo&index=10&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm)
	- [Divide＆Conquer：Convex Hull、Median Finding](https://www.youtube.com/watch?v=EzeYI7p9MjU&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=2)

- ###離散数学
	- 下のビデオを見る

- ###機械学習
	- [ ] なぜMLですか？
		- [ ]  [Googleがどのように最初の企業を学習するマシンとして自分自身を作り直すか](https://backchannel.com/how-google-is-remaking-itself-as-a-machine-learning-first-company-ada63defcb70)
		- [ ]  [知的コンピュータシステムのための大規模な深い学習(ビデオ)](https://www.youtube.com/watch?v=QSaZGT4-6EY)
		- [ ]  [深い学習と理解度対ソフトウェア工学と検証、Peter Norvig](https://www.youtube.com/watch?v=X769cyzBNVw)
	- [ ]  [Googleのクラウドマシン学習ツール(動画)](https://www.youtube.com/watch?v=Ja2hxBAwG_0)
	- [ ]  [Google Developers `Machine Learning Recipes(Scikit Learn＆Tensorflow)(ビデオ)](https://www.youtube.com/playlist?list=PLOU2XLYxmsIIuiBfYad6rFYQU_jL2ryal)
	- [ ]  [Tensorflow(video)](https://www.youtube.com/watch?v=oZikw5k_2FM)
	- [ ]  [Tensorflowチュートリアル](https://www.tensorflow.org/versions/r0.11/tutorials/index.html)
	- [ ]  [Pythonでニューラルネットワークを実装する実践ガイド(Theanoを使用)](http://www.analyticsvidhya.com/blog/2016/04/neural-networks-python-theano/)
	- コース：
		- [グレートスターターコース：機械学習](https://www.coursera.org/learn/machine-learning)
  			- [動画のみ](https://www.youtube.com/playlist?list=PLZ9qNFMHZ-A4rycgrgOYma6zxF4BZGGPW)
  			- 線形代数のレビューについてはビデオ12〜18を参照してください(14と15は重複しています)
		- [機械学習のためのニューラルネットワーク](https://www.coursera.org/learn/neural-networks)
		- [GoogleのDeep Learning Nanodegree](https://www.udacity.com/course/deep-learning--ud730)
		- [Google / Kaggle Machine Learning Engineer Nanodegree](https://www.udacity.com/course/machine-learning-engineer-nanodegree-by-google--nd009)
		- [自己運転車技術者Nanodegree](https://www.udacity.com/drive)
		- [Metis Online Course(2ヶ月間99ドル)](http://www.thisismetis.com/explore-data-science)
	- リソース：
		- 書籍：
			- [Python Machine Learning](https://www.amazon.com/Python-Machine-Learning-Sebastian-Raschka/dp/1783555130/)
			- [ゼロからのデータ科学：Pythonの第一原理](https://www.amazon.com/Data-Science-Scratch-Principles-Python/dp/149190142X)
			- [Pythonによる機械学習入門](https://www.amazon.com/Introduction-Machine-Learning-Python-Scientists/dp/1449369413/)
		- [ソフトウェアエンジニア向け機械学習](https://github.com/ZuzooVn/machine-learning-for-software-engineers)
		- データスクール：http://www.dataschool.io/

-

##追加科目の詳細

    私は既に上記のいくつかのアイデアを強化するためにこれらを追加しましたが、それらを含めたくありませんでした
    それはちょうどあまりにも多くのためです。それは科目にそれを過ごすのは簡単です。
    あなたは今世紀に雇われたかったですね。

- [ ]  **連合検索**
	- [ ]  [概要](https://www.coursera.org/learn/data-structures/lecture/JssSY/overview)
	- [ ]  [Naive Implementation](https://www.coursera.org/learn/data-structures/lecture/EM5D0/naive-implementations)
	- [ ]  [木](https://www.coursera.org/learn/data-structures/lecture/Mxu0w/trees)
	- [ ]  [ランキングによる連合](https://www.coursera.org/learn/data-structures/lecture/qb4c2/union-by-rank)
	- [ ]  [パス圧縮](https://www.coursera.org/learn/data-structures/lecture/Q9CVI/path-compression)
	- [ ]  [分析オプション](https://www.coursera.org/learn/data-structures/lecture/GQQLN/analysis-optional)

- [ ]  **もっとダイナミックなプログラミング**(ビデオ)
	- [ ]  [6.006：動的プログラミングI：フィボナッチ、最短経路](https://www.youtube.com/watch?v=OQ5jsbhAv_M&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=19)
	- [ ]  [6.006：ダイナミックプログラミングII：テキストジャスティフィケーション、ブラックジャック](https://www.youtube.com/watch?v=ENyox7kNKeY&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=20)
	- [ ]  [6.006：DP III：かっこ、編集距離、ナップザック](https://www.youtube.com/watch?v=ocZMDMZwhCY&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=21)
	- [6.006：DP IV：Guitar Fingering、Tetris、Super Mario Bros.](https://www.youtube.com/watch?v=tp4_UXaVyx8&index=22&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)
	- [ ]  [6.046：Dynamic Programming＆Advanced DP](https://www.youtube.com/watch?v=Tw1k46ywN6E&index=14&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp)
	- [ ]  [6.046：ダイナミックプログラミング：オールペア最短パス](https://www.youtube.com/watch?v=NzgFUwOaoIw&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=15)
	- [ ]  [6.046：ダイナミックプログラミング(学生の暗唱)](https://www.youtube.com/watch?v=krZI60lKPek&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=12)

- [ ]  **高度なグラフ処理**(ビデオ)
	- [ ]  [同期分散アルゴリズム：対称性を破る。木にまたがる最短パス](https://www.youtube.com/watch?v=mUBmcbbJNf4&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=27)
	- [ ]  [非同期分散アルゴリズム：木にまたがる最短パス](https://www.youtube.com/watch?v=kQ-UQAzcnzA&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp&index=28)

- [ ]  MIT **確率**(mathy、ゆっくりと進み、数学的なことに良い)(ビデオ)：
	- [ ]  [MIT 6.042J - 確率の紹介](https://www.youtube.com/watch?v=SmFwFdESMHI&index=18&list=PLB7540DEDD482705B)
	- [ ]  [MIT 6.042J - 条件付き確率](https://www.youtube.com/watch?v=E6FbvM-FGZ8&index=19&list=PLB7540DEDD482705B)
	- [ ]  [MIT 6.042J - 独立性](https://www.youtube.com/watch?v=l1BCv3qqW4A&index=20&list=PLB7540DEDD482705B)
	- [ ]  [MIT 6.042J - ランダム変数](https://www.youtube.com/watch?v=MOfhhFaQdjw&list=PLB7540DEDD482705B&index=21)
	- [ ]  [MIT 6.042J - 期待値I](https://www.youtube.com/watch?v=gGlMSe7uEkA&index=22&list=PLB7540DEDD482705B)
	- [ ]  [MIT 6.042J - Expectation II](https://www.youtube.com/watch?v=oI9fMUqgfxY&index=23&list=PLB7540DEDD482705B)
	- [ ]  [MIT 6.042J - 大きな偏差](https://www.youtube.com/watch?v=q4mwO2qS2z4&index=24&list=PLB7540DEDD482705B)
	- [ ]  [MIT 6.042J - ランダムウォーク](https://www.youtube.com/watch?v=56iFMY8QW2k&list=PLB7540DEDD482705B&index=25)

- [ ]  [Simonson：Approximation Algorithms(video)](https://www.youtube.com/watch?v=oDniZCmNmNw&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=19)

- [ ]  **文字列マッチング**
	- [ ]  Rabin-Karp(ビデオ)：
		- [Rabin Karps Algorithm](https://www.coursera.org/learn/data-structures/lecture/c0Qkw/rabin-karps-algorithm)
		- [Precomputing](https://www.coursera.org/learn/data-structures/lecture/nYrc8/optimization-precomputation)
		- [最適化：実装と分析](https://www.coursera.org/learn/data-structures/lecture/h4ZLc/optimization-implementation-and-analysis)
		- [表倍増、Karp-Rabin](https://www.youtube.com/watch?v=BRO7mVIFt08&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=9)
		- [ローリングハッシュ、償却分析](https://www.youtube.com/watch?v=w6nuXg0BISo&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&index=32)
	- [ ] クヌース・モリス・プラット(KMP)：
		- [Knuth-Morris-Pratt(KMP)文字列マッチングアルゴリズム](https://www.youtube.com/watch?v=5i7oKodCRJo)
	- [ ]  Boyer-Moore文字列検索アルゴリズム
		- [Boyer-Moore String Search Algorithm](https://en.wikipedia.org/wiki/Boyer%E2%80%93Moore_string_search_algorithm)
		- [高度な文字列検索Boyer-Moore-Horspoolアルゴリズム(ビデオ)](https://www.youtube.com/watch?v=QDZpzctPf10)
	- [ ]  [Coursera：文字列のアルゴリズム](https://www.coursera.org/learn/algorithms-on-strings/home/week/1)
		- すごく始まりますが、KMPを過ぎるまでには、必要以上に複雑になります
		- 試行の良い説明
		- スキップすることができます

- [ ]  **ソート**

	- [ ] スタンフォードのソーティングに関する講義：
		- [ ]  [講義15 |プログラミングの抽象化(ビデオ)](https://www.youtube.com/watch?v=ENp00xylP7c&index=15&list=PLFE6E58F856038C69)
		- [ ]  [講義16 |プログラミングの抽象化(ビデオ)](https://www.youtube.com/watch?v=y4M9IVgrVKo&index=16&list=PLFE6E58F856038C69)
	- [ ]  Shai Simonson、[Aduni.org](http://www.aduni.org/)：
		- [ ]  [アルゴリズム - ソート - 講義2(ビデオ)](https://www.youtube.com/watch?v=odNJmw5TOEE&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=2)
		- [ ]  [アルゴリズム - ソートII - レクチャー3(ビデオ)](https://www.youtube.com/watch?v=hj8YKFTFKEE&list=PLFDnELG9dpVxQCxuD-9BSy2E7BWY3t5Sm&index=3)
	- [ ]  Steven Skienaのソーティングに関する講義：
		- [ ]  [講義は26:46に始まります(ビデオ)](https://youtu.be/ute-pmMkyuk?list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&t=1600)
		- [ ]  [講義は27:40(ビデオ)から開始](https://www.youtube.com/watch?v=yLvp-pB8mak&index=8&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b)
		- [ ]  [講演は35:00(ビデオ)から開始](https://www.youtube.com/watch?v=q7K9otnzlfE&index=9&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b)
		- [ ]  [講演は23:50から始まります(ビデオ)](https://www.youtube.com/watch?v=TvqIGu9Iupw&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&index=10)


##ビデオシリーズ

座って楽しんでください。 「ネットフリックスとスキル」：P

- [ ]  [個々の動的プログラミングの問題のリスト(それぞれ短いです)](https://www.youtube.com/playlist?list=PLrmLmBdmIlpsHaNTPP_jHHDx_os9ItYXr)

- [ ]  [x86アーキテクチャ、アセンブリ、アプリケーション(11ビデオ)](https://www.youtube.com/playlist?list=PL038BE01D3BAEFDB0)

- [ ]  [MIT 18.06線形代数、2005年春(35ビデオ)](https://www.youtube.com/playlist?list=PLE7DDD91010BC51F8)

- [ ]  [優秀 - MIT Calculus Revisited：単一変数計算](https://www.youtube.com/playlist?list=PL3B08AE665AB9002A)

- [ ]  [コンピュータサイエンス70,001 - 春2015 - 離散数学と確率論](https://www.youtube.com/playlist?list=PL-XXv-cvA_iD8wQm8U0gG_Z1uHjImKXFy)

- [ ]  [Shai Simonsonによる離散数学(19ビデオ)](https://www.youtube.com/playlist?list=PL3o9D4Dl2FJ9q0_gtFXPh_H4POI5dK0yG)

- [ ]  [離散数学第1部：Sarada Herke(5ビデオ)](https://www.youtube.com/playlist?list=PLGxuz-nmYlQPOc4w1Kp2MZrdqOOm4Jxeo)

- [ ]  CSE373 - アルゴリズムの分析(25ビデオ)
	- [アルゴリズム設計マニュアルのSkiena講義](https://www.youtube.com/watch?v=ZFjhkohHdAA&list=PLOtl7M3yp-DV69F32zdK7YJcNXpTunF2b&index=1)

- [UCバークレー61B(Spring 2014)：データ構造(25ビデオ)](https://www.youtube.com/watch?v=mFPmKGIrQs4&list=PL-XXv-cvA_iAlnI-BQr9hjqADPBtujFJd)

- [UC Berkeley 61B(2006年秋)：データ構造(39ビデオ)](https://www.youtube.com/playlist?list=PL4BBB74C7D2A1049C)

- [UC Berkeley 61C：機械構造物(26ビデオ)](https://www.youtube.com/watch?v=gJJUUFyuvvg&list=PL-XXv-cvA_iCl2-D-FS5mk0jFF6cYSJs_)

- [ ]  [OOSE：UMLとJavaを使用したソフトウェア開発(21ビデオ)](https://www.youtube.com/playlist?list=PLJ9pm_Rc9HesnkwKlal_buSIHA-jTZMpO)

- [ ]  [UC Berkeley CS 152：コンピュータアーキテクチャとエンジニアリング(20ビデオ)](https://www.youtube.com/watch?v=UH0QYvtP7Rk&index=20&list=PLkFD6_40KJIwEiwQx1dACXwh-2Fuo32qr)

- [ ]  [MIT 6.004：計算構造(49ビデオ)](https://www.youtube.com/playlist?list=PLrRW1w6CGAcXbMtDFj205vALOGmiRc82-)

- [Carnegie Mellon - Computer Architecture Lectures(39ビデオ)](https://www.youtube.com/playlist?list=PL5PHm2jkkXmi5CxxI7b3JCL1TWybTDtKq)

- [ ]  [MIT 6.006：アルゴリズム紹介(47ビデオ)](https://www.youtube.com/watch?v=HtSuA80QTyo&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb&nohtml5=False)

- [ ]  [MIT 6.033：コンピュータシステムエンジニアリング(22ビデオ)](https://www.youtube.com/watch?v=zm2VP0kHl1M&list=PL6535748F59DCA484)

- [ ]  [MIT 6.034人工知能、2010年秋(30ビデオ)](https://www.youtube.com/playlist?list=PLUl4u3cNGP63gFHB6xb-kVBiQHYe_4hSi)

- [ ]  [MIT 6.042J：コンピュータサイエンスの数学、2010年秋(25ビデオ)](https://www.youtube.com/watch?v=L3LMbpZIKhQ&list=PLB7540DEDD482705B)

- [ ]  [MIT 6.046：アルゴリズムの設計と分析(34ビデオ)](https://www.youtube.com/watch?v=2P-yW7LQr08&list=PLUl4u3cNGP6317WaSNfmCvGym2ucw3oGp)

- [ ]  [MIT 6.050J：情報とエントロピー、2008年春(19ビデオ)](https://www.youtube.com/watch?v=phxsQrZQupo&list=PL_2Bwul6T-A7OldmhGODImZL8KEVE38X7)

- [ ]  [MIT 6.851：高度なデータ構造(22ビデオ)](https://www.youtube.com/watch?v=T0yzrZL1py0&list=PLUl4u3cNGP61hsJNdULdudlRL493b-XZf&index=1)

- [ ]  [MIT 6.854：Advanced Algorithms、Spring 2016(24ビデオ)](https://www.youtube.com/playlist?list=PL6ogFv-ieghdoGKGg2Bik3Gl1glBTEu8c)

- [ ]  [Harvard COMPSCI 224：Advanced Algorithms(25ビデオ)](https://www.youtube.com/playlist?list=PL2SOU6wwxB0uP4rJgf5ayhHWgw7akUWSf)

- [ ]  [MIT 6.858コンピュータシステムセキュリティ、2014年秋](https://www.youtube.com/watch?v=GqmQg-cszw4&index=1&list=PLUl4u3cNGP62K2DjQLRxDNRi0z2IRWnNh)

- [ ]  [Stanford：Programming Paradigms(27ビデオ)](https://www.youtube.com/view_play_list?p=9D558D49CA734A02)

- [ ]  [Christof Paarによる暗号の概要](https://www.youtube.com/playlist?list=PL6N5qY2nvvJE8X75VkXglSrVhLv1tVcfy)
	- [スライドと問題セットと一緒のコースウェブサイト](http://www.crypto-textbook.com/)

- [ ]  [Mining Massive Datasets - スタンフォード大学(94ビデオ)](https://www.youtube.com/playlist?list=PLLssT5z_DsK9JDLcT8T62VtzwyW9LNepV)

- [ ] グラフ理論(Sarada Herke)(67ビデオ)(https://www.youtube.com/user/DrSaradaHerke/playlists?shelf_id=5&view=50&sort=dd)

##コンピュータサイエンスコース

- [オンラインCSコースのディレクトリ](https://github.com/open-source-society/computer-science)
- [CSコースのディレクトリ(多くはオンライン講義あり)](https://github.com/prakhar1989/awesome-courses)