## Programming Language Resources

- C
    - [ANSI C Cheat Sheet](https://github.com/jwasham/coding-interview-university/blob/master/extras/cheat%20sheets/C%20Reference%20Card%20(ANSI)%202.2.pdf)
    - K&R C book (ANSI C)
    - [Make, Clang (video)](https://www.youtube.com/watch?v=U3zCxnj2w8M)
    - GDB:
        - [Harvard CS50 - GDB (video)](https://www.youtube.com/watch?v=USPvePv1uzE)
        - [Harvard CS50 - GDB (video)](https://www.youtube.com/watch?v=y5JmQItfFck)
        - [Valgrind (video)](https://www.youtube.com/watch?v=fvTsFjDuag8)
    - [Let us C](https://books.google.co.in/books/about/Let_Us_C.html?id=7HrjAAAACAAJ)
- C++
    - [C++ Cheat Sheet](https://github.com/jwasham/coding-interview-university/blob/master/extras/cheat%20sheets/Cpp_reference.pdf)
    - [STL Cheat Sheet](https://github.com/jwasham/coding-interview-university/blob/master/extras/cheat%20sheets/STL%20Quick%20Reference%201.29.pdf)
    - [basics](https://www.tutorialspoint.com/cplusplus/cpp_basic_syntax.htm)
    - [pointers](https://www.cprogramming.com/tutorial/lesson6.html)
    - [class and object](https://www.cprogramming.com/tutorial/lesson12.html)
    - [functions](https://www.cprogramming.com/tutorial/lesson4.html)
    - [references](https://www.geeksforgeeks.org/references-in-c/)
    - [templates](https://www.cprogramming.com/tutorial/templates.html)
    - [compilation](https://www.youtube.com/watch?v=ZTu0kf-7h08)
    - [scope & linkage](https://www.learncpp.com/cpp-tutorial/scope-duration-and-linkage-summary/)
    - [namespaces](https://www.tutorialspoint.com/cplusplus/cpp_namespaces.htm)
    - [OOP](https://www.geeksforgeeks.org/object-oriented-programming-in-cpp/)
    - [STL](https://www.hackerearth.com/practice/notes/standard-template-library/)
    - [functors](http://www.cprogramming.com/tutorial/functors-function-objects-in-c++.html)
    - [C++ at Google (video)](https://www.youtube.com/watch?v=NOCElcMcFik)
    - [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html)
        - Google uses clang-format (there is a command line "style" argument: -style=google)
    - [Efficiency with Algorithms, Performance with Data Structures (video)](https://youtu.be/fHNmRkzxHWs)
    - [Review of C++ concepts (video)](https://www.youtube.com/watch?v=Rub-JsjMhWY)
    - [Let us C++](https://books.google.co.in/books/about/Let_Us_C++.html?id=6HrjAAAACAAJ)
    - [C++ Primer](https://books.google.co.in/books/about/C++_Primer.html?id=J1HMLyxqJfgC&redir_esc=y)
- Python
    - [Python Cheat Sheet](https://github.com/jwasham/coding-interview-university/blob/master/extras/cheat%20sheets/python-cheat-sheet-v1.pdf)
    - [Python in One Video](https://www.youtube.com/watch?v=N4mEzFDjqtA)
    - [Series on 3.4 (video)](https://www.youtube.com/playlist?list=PL6gx4Cwl9DGAcbMi1sH6oAMk4JHw91mC_)
    - [Statistics for Hackers (video)](https://www.youtube.com/watch?v=Iq9DzN6mvYA)
    - [Faster Python (video)](https://www.youtube.com/watch?v=JDSGVvMwNM8)
    - [CPython Walk (video)](https://www.youtube.com/watch?v=LhadeL7_EIU&list=PLzV58Zm8FuBL6OAv1Yu6AwXZrnsFbbR0S&index=6)
    - [10 Tips for Pythonic Code (video)](https://www.youtube.com/watch?v=_O23jIXsshs)
    - [Beyond PEP 8 -- Best practices for beautiful intelligible code (video)](https://www.youtube.com/watch?v=wf-BqAjZb8M)
    - [Automate the Boring Stuff with Python](https://automatetheboringstuff.com/)
    - [Coding Interview Essentials](https://github.com/ajinkyal121/coding-interview-university/blob/master/extras/cheat%20sheets/Coding%20Interview%20Python%20Language%20Essentials.pdf)
    - [Data Structures And Algorithms in Python](https://www.youtube.com/watch?v=kQDxmjfkIKY)
- Java
    - [Stanford CS106A - Programming Methodology (video)](https://see.stanford.edu/Course/CS106A)
    - [Software Construction In Java (video)](https://www.edx.org/course/software-construction-java-mitx-6-005-1x)
    - [Introduction To Programming In Java](http://introcs.cs.princeton.edu/java/home/)
    - [Algorithms 4th Ed - Algorithm Book In Java](http://algs4.cs.princeton.edu/home/)
    - [Effective Java 3rd Edition](https://www.amazon.com/Effective-Java-Joshua-Bloch-ebook/dp/B078H61SCH)
    - [Data Structures Easy to Advanced Course - Full Tutorial from a Google Engineer](https://www.youtube.com/watch?v=RBSGKlAvoiM&t=1744s)
- Go
    - [The Go programming Language](https://golang.org/)
    - [The Go programming Language (book)](http://www.gopl.io/)
    - [A Tour of Go](https://tour.golang.org/)
    - [Effective Go](https://golang.org/doc/effective_go.html)
    - [Go Wiki](https://golang.org/wiki)
    - [Go at Google: Language Design in the Service of Software Engineering](https://talks.golang.org/2012/splash.article)
    - [Go Proverbs](http://go-proverbs.github.io/)
    - [Go Proverbs - Rob Pike (video)](https://www.youtube.com/watch?v=PAAkCSZUG1c)
- HTML
    - [Quick HTML Tutorial for Beginners](https://www.youtube.com/playlist?list=PLr6-GrHUlVf_ZNmuQSXdS197Oyr1L9sPB)
    - [HTML Crash Course for Beginners (1 hr)](https://www.youtube.com/watch?v=UB1O30fR-EE)
    - [Basic HTML and HTML5](https://www.freecodecamp.org/learn/responsive-web-design/basic-html-and-html5/)
- CSS
    - [Quick CSS Tutorial for Beginners](https://www.youtube.com/playlist?list=PLr6-GrHUlVf8JIgLcu3sHigvQjTw_aC9C)
    - [CSS Crash Course for absolute Beginners](https://www.youtube.com/watch?v=yfoY53QXEnI)
    - [Basic CSS](https://www.freecodecamp.org/learn/responsive-web-design/basic-css/)
- Javascript
    - [Learn Javascript in 12 minutes](https://www.youtube.com/watch?v=Ukg_U3CnJWI)
    - [Javascript Beginner Tutorials](https://www.youtube.com/playlist?list=PL41lfR-6DnOrwYi5d824q9-Y6z3JdSgQa)
    - [Javascript Algorithms and Data Structures](https://www.freecodecamp.org/learn/javascript-algorithms-and-data-structures/basic-javascript/)
    - [Javascript Algorithms With Explanations](https://github.com/trekhleb/javascript-algorithms)
- Other Language 1
- Other Language 2
- etc
