---
title: Security
sidebar_label: Security
---

- [That One Privacy Site](https://thatoneprivacysite.net/) - VPN and email service comparisons.
- [privacytools.io](https://www.privacytools.io/) - "Encryption against global mass surveillance". Plenty of information to help protect your privacy online.
- [Prism Break](https://prism-break.org/en/) - Opt out of global data surveillance programs like PRISM, XKeyscore, and Tempora.
- [r/privacy](https://www.reddit.com/r/privacy/) - The intersection of technology, privacy, and freedom in a digital world.
- [Any Soft Keyboard](https://github.com/AnySoftKeyboard/AnySoftKeyboard) - A privacy-focused keyboard.
- [How To Host "Questionable" Websites v4.0](https://weboas.is/media/host.pdf) - PDF from weboas.is. There are also [PNG](https://weboas.is/media/host.png), [PSD](https://weboas.is/media/host.psd), and [TXT](https://weboas.is/media/host.txt) - versions.
- [UK ISP Court Orders](http://www.ukispcourtorders.co.uk/) - List of websites recently taken down in the UK by the High Court. Use a VPN to access them, they must be pretty good!
- [Counterfeit and Piracy Watch List 2018](https://torrentfreak.com/images/tradoc_157564.pdf)
- [Am I Unique?](https://amiunique.org/) - Learn how identifiable you are on the Internet.
- [Simplewall](https://www.henrypp.org/product/simplewall) - Simple tool to configure Windows Filtering Platform (WFP) which can configure network activity on your computer.
- [I know What You Download](https://iknowwhatyoudownload.com/) - Check for what internet knows about you download history.
- [Anon.to](https://anon.to/) - URL shortener to de-referer or null-referer your links.
- [Privacy.com](https://privacy.com/) - Privacy creates secure virtual cards and completes checkout forms for you, saving you time and money while masking your real card details.
- [Project Honey Pot](https://www.projecthoneypot.org/) - Online fraud & abuse tracker.
- [Protecting yourself from being caught pirating - Guide concerning copyright infringement complaints](https://www.reddit.com/r/Piracy/wiki/faq/isp_complaints)

## Email

- [ProtonMail](https://protonmail.com/) - Secure Email Based in Switzerland.
- [Cock.li](https://cock.li/) - Yeah it's mail with cocks.
- [Tutanota](https://tutanota.com/) - Secure, open source email service.
- [Mailbox](https://mailbox.org/en/) - Mailbox.org fights for privacy eMails since years and is a big player when it comes to eMail.
- [EmailDrop](https://www.emaildrop.io/) - Emaildrop is a free disposable email provider.
- [Dismail](https://dismail.de/) - Dismail provides a reliable eMail service wich is cheap.
- [mailbox.org](https://mailbox.org/) - First of his kind, fully transparent eMail provider.
- [Posteo](https://posteo.de/) - A german eMail service which offers a transparent eMail service.

### Temporary

- [10 Minute Mail](https://10minutemail.net/) - Disposable, private mailboxes.
- [Disposable](https://github.com/0x19/disposable) - Disposable is a robust disposable email (burner emails) - API designed to help you verify whenever email address is coming from disposable service.
- [Nada](https://getnada.com/) - Fast & free.
- [s.MailPro](https://smailpro.com/) - Offering Temporary Email Service.
- [Temp Mail](https://temp-mail.org/en/) - Keep spam out of your mail and stay safe - just use a disposable temporary email address!
- [Tempr eMail](https://tempr.email/fr/) - Similar service like Temp Mail, it's from the same provider.

### self hosted

- [docker-mailserver](https://github.com/tomav/docker-mailserver) - A fullstack but simple mailserver (smtp, imap, antispam, antivirus, ssl, etc.) - using Docker.
- [FastMail](https://www.fastmail.com/?STKI=16785160) - Email, calendars and contacts done right.
- [Rainloop](https://www.rainloop.net/) - SIMPLE, MODERN & FAST WEB-BASED EMAIL CLIENT.
- [Roundcube](https://roundcube.net/) - MIME support, address book, folder manipulation, message searching and spell checking.
- [Simple Login](https://github.com/simple-login/app) - Email alias/forwarding and identity provider service.

### eMail Clients

- [Confidant](https://www.confidantmail.org/) - Another secure eMail provider, apps are planned.
- [ElectronMail](https://github.com/vladimiry/ElectronMail) - Electron based wrapper for ProtonMail & Tutanota.
- [Lavabit](https://lavabit.com/) - Those guys are back and they are now developing their own mail protocol for secure communication.
- [Mozilla Thunderbird](http://www.thunderbird.net/en-US/) - Well-known open source eMail Client from Mozilla.
- [p=p](http://www.pep.security/) - Pretty Easy Privacy (p=p) - email client encrypts all communications in your email without the need for you to create new accounts.
- [Tutanota](https://github.com/tutao/tutanota) - Email client with a strong focus on security and privacy that lets you encrypt emails on all your devices.

## Data leak checking

- [I Got Phished](https://igotphished.abuse.ch/) - Collecting information regarding users that became victims of a phishing attack by entering their password on a phishing website.
- [Have I been pwned?](https://haveibeenpwned.com/) - Check if you have an account that has been compromised in a data breach.
- [Firefox Monitor](https://monitor.firefox.com/) - Have your accounts been leaked or stolen in a data breach? Find out at Firefox Monitor.
- [LeakCheck](https://leakcheck.net/) - Paid database engine to check if your eMail, online accounts have been compromised.
- [Snusbase](https://snusbase.com/) - Paid Database Search Engine to check for latest database breaches.
- [GhostProject.fr](https://ghostproject.fr/) - Free Database Lookup of Recent 1.4 billion password breach compilation, GhostProject allows you to Search by email or username.

## Secure Messenger

- [Briar](http://briarproject.org/)
- [Riot](http://matrix.org/blog/home/)
- [Threema](http://threema.ch/en)
- [Wire](http://wire.com/)
- [Signal](http://signal.org/)

## Password Managers

:::caution

[LastPass security issues](https://en.wikipedia.org/wiki/LastPass#Security_issues) - Wikipedia

:::

- [Wikipedia's list of Password Managers](http://en.wikipedia.org/wiki/List_of_password_managers) - Overview of all password manager utilities.
- [BitWarden](https://bitwarden.com/) - Open source password management solution, can be self-hosted.
- [KeePassXC](https://keepassxc.org/) - KeePassXC is a community fork of KeePassX, a native cross-platform port of KeePass Password Safe.
- [LessPass](https://lesspass.com/) - Stateless open source password manager.
- [1Password](https://1password.com/) - Popular cloud-hosted password manager.
- [KeePass](https://keepass.info/) - Free, open source, light-weight, and easy-to-use password manager.
  - [Plugins](https://keepass.info/plugins.html) - A list of third-party plugins for KeePass.
  - [Keepass2Android](https://github.com/PhilippC/keepass2android) - A Password manager app for Android based on Keepass.
  - [KeePassium](https://keepassium.com/) - KeePassium combines the security of KeePass with a clean intuitive design.
- [KeeWeb](https://keeweb.info/) - Free cross-platform password manager compatible with KeePass.
- [Pass](https://www.passwordstore.org/) - Simple GPG/Git password manager. Follows the Unix philosophy.
- [Dashlane](https://www.dashlane.com/) - An intuitive password manager with over with over 8 million users worldwide.
- [Passbolt](https://www.passbolt.com/) - Free, open source, self-hosted, extensible, OpenPGP based.
- [Psono](https://psono.com/) - Open source and self-hosted password manager for teams.
- [Buttercup](https://buttercup.pw/) - Another open source password manager with desktop, mobile, and browser clients.
- [MiniKeePass](https://minikeepass.github.io/) - iOS version of KeePass (_unofficial_).
- [KeeVault](http://keevault.pm/) - Secure, Open Source Password Management.
- [LastPass (Last Choice)](https://www.lastpass.com/) - LastPass remembers all your passwords, so you don't have to.

## DNS

- [AdGuard](https://adguard.com/en/adguard-dns/overview.html) - AdGuard DNS is a foolproof way to block ads that does not require installing any applications.
- [Snopyta](https://snopyta.org/service/dns/) - Finland based non-profit DNS that doesn't keep.
- [UncensoredDNS](https://blog.uncensoreddns.org/dns-servers/) - An uncensored alternative to the internet providers filtered DNS servers.
- [Digitale Gesellschaft](https://www.digitale-gesellschaft.ch/dns) - Another uncensored DNS servers.
- [AppliedPrivacy](https://appliedprivacy.net/de/services/dns/) - A privacy conscious DNS service.
- [NixNet](https://nixnet.xyz/dns/) - Uncensored DNS that doesn't keep logs.
- [DNSCrypt](https://www.dnscrypt.org/) - A protocol to improve DNS security.
- [Stubby](https://github.com/getdnsapi/stubby) - Stubby is the name given to a mode of using getdns which enables it to act as a local DNS Privacy stub resolver (using DNS-over-TLS).
- [YogaDNS](https://yogadns.com/docs/) - YogaDNS automatically intercepts DNS requests at the system level and allows you to process them over user-defined DNS servers using modern protocols and flexible rules.

### Cloud based

- [Blockchain-DNS.info](https://blockchain-dns.info/) - First step towards the uncensored Internet.
- [NextDNS](https://www.nextdns.io/) - Cloud-based private DNS service that gives you full control over what is allowed and what is blocked on the Internet.
- [NixNet DNS](https://docs.nixnet.services/DNS)

## VPN

- [r/VPNTorrents](https://www.reddit.com/r/VPNTorrents) - This is for the discussion of torrenting (and similar P2P protocols) - using VPN type technology.
- [r/VPN wiki](https://www.removeddit.com/r/VPN/wiki/index) - Helpful Wiki resource written by the community from /r/VPN.
- [That One Privacy Site](https://thatoneprivacysite.net/vpn-section/) - VPN section of "That One Privacy Site" with VPN comparisons.
- Open QB advance settings, and bind the network interface to your VPN network adapter (TAP) - e.g. PIA/Proton [check this example](https://i.imgur.com/pD7atey.jpg).
- [Choosing the best VPN (for you) - /r/VPN](https://www.removeddit.com/r/VPN/comments/4iho8e/that_one_privacy_guys_guide_to_choosing_the_best/?st=iu9u47u7&sh=459a76f2) - That One Privacy Guy's - Guide to Choosing the Best VPN (for you).
- [Choosing the VPN that's right for you](https://ssd.eff.org/en/module/choosing-vpn-thats-right-you) - Helpful guide from EFF.org.
- [VPN over SSH](https://wiki.archlinux.org/index.php/VPN_over_SSH) - ArchWiki page which explains how to achieve a poor man's VPN via SSH tunneling.
- [Which VPN Services Keep You Anonymous in 2019?](https://torrentfreak.com/which-vpn-services-keep-you-anonymous-in-2019/) - TorrentFreak article by Ernesto about which VPN you _could_ use.
- [How To Set Up an OpenVPN Server on Ubuntu 16.04](https://www.digitalocean.com/community/tutorials/how-to-set-up-an-openvpn-server-on-ubuntu-16-04) - The guide still works on newer Ubuntu releases without any problems.

### Services

- [Mullvad](https://mullvad.net/en/) - A Bitcoin-friendly, privacy-first VPN.
- [ProtonVPN](https://protonvpn.com/) - High-speed Swiss VPN that safeguards your privacy.
- [IVPN](https://www.ivpn.net/) - Based in Gibraltar and offers a 3 day free trial.
- [NordVPN](https://nordvpn.com/) - With NordVPN, encrypt your online activity to protect your private data from hackers or snoopy advertisers.
- [ExpressVPN](https://www.expressvpn.com/vpnmentor1) - VPN with 256-bit encryption, 94 countries, and no logs. It is also rated as one of the fastest VPNs out there.
- [Windscribe](https://windscribe.com/) - Simple VPN, has a free plan that gives you 10gb/mo bandwidth, paid version even has port forwarding for static IPs, privacy-focused.
- [Private Internet Access](https://www.privateinternetaccess.com/) - Hugely popular subscription-based VPN provider with a proven track record for not keeping logs.

### Self-hosted

- [ZeroTier](https://www.zerotier.com) - Peer-to-peer multi-platform VPN.
- [Algo VPN](https://github.com/trailofbits/algo) - A set of Ansible scripts that simplify the setup of a personal WireGuard and IPsec VPN.
- [Cloudron](https://cloudron.io/get.html) - A solution that allows anybody to create private clouds instantaneously.
- [DSVPN](https://github.com/jedisct1/dsvpn) - `Linux` - DSVPN is a dead simple VPN, designed to address the most common use case for using a VPN.
- [Mysterium Network](https://mysterium.network/) - Yet another self-hosted VPN.
- [n2n](https://github.com/ntop/n2n) - A Peer-to-peer VPN.
- [Nebula](https://github.com/slackhq/nebula) - A scalable overlay networking tool with a focus on performance, simplicity and security.
- [ocserv](https://www.infradead.org/ocserv/) - Cisco AnyConnect-compatible VPN server.
- [OpenConnect](https://www.infradead.org/openconnect/) - Multiplatform VPN compatible with Cisco's AnyConnect. Uses well-tested, standard TLS connections which easily bypass DPI.
- [OpenVPN](https://openvpn.net/) - OpenVPN provides flexible VPN solutions to secure your data communications, whether it's for Internet privacy, remote access for employees, securing IoT, or for networking Cloud data centers.
- [Outline by Alphabet](https://www.getoutline.org/) - Not a traditional VPN but it might work with Google Cloud, AWS & more.
- [PeerVPN](https://peervpn.net/) - PeerVPN is a software that builds virtual ethernet networks between multiple computers.
- [Pritunl](https://pritunl.com/) - Enterprise Distributed OpenVPN and IPsec Server.
- [SoftEther VPN](https://github.com/SoftEtherVPN/SoftEtherVPN) - Cross-platform multi-protocol VPN software.
- [Tailscale](https://github.com/tailscale/tailscal) - Tailscale is a mesh VPN that makes it easy to connect your devices, wherever they are. No more fighting configuration or firewall ports.
- [tinc](https://tinc-vpn.org/) - Peer-to-peer VPN software with mesh routing.
- [vpn-at-home](https://github.com/ezaquarii/vpn-at-home) - 1-click, self-hosted deployment of OpenVPN with DNS ad blocking sinkhole.
- [WireGuard VPN](https://www.wireguard.com/) - WireGuard is an extremely simple yet fast and modern VPN that utilizes state-of-the-art cryptography. It aims to be faster, simpler, leaner, and more useful than IPSec.

### Decentralized

- [radvpn](https://github.com/mehrdadrad/radvpn) - Decentralized VPN.
- [Mysterium Network](https://mysterium.network/vpn/) - Claims to be world’s 1st decentralized free VPN which uses OpenVPN & WireGuard.
- [TachyonVpn](https://github.com/tachyon-protocol/TachyonVpn) - A Decentralized VPN that is secured by Tachyon Protocol.

## VPS Hosting Providers

- [Bulletproof Hosting](https://en.wikipedia.org/wiki/Bulletproof_hosting)
- [BlueAngelHost](https://www.blueangelhost.com/) - Ignores DMCA requests, starts with 2,50€ a month, servers are based in Sofia.
- [CyberHour](https://www.cyberhour.com/) - Rusian based host provider which allows Warez.
- [FlokiNET](https://flokinet.is/) - Designed for Whistleblower, ignores DMCA requests, starts with 2,99€ a month, servers are located in Bukarest, Reykjavik or Helsinki. Servers are known to be slow.
- [Hostkey](https://www.hostkey.com/) - Dedicated Servers & more.
- [HostPlay](https://www.hostplay.com/) - Russian based VPS, starting for 15,44€ a month.
- [KnownSRV.com](https://knownsrv.com/) - They use offshore data centers in Romania, Luxembourg and the Netherlands.
- [NetEngi](https://netengi.com/) - Rent professional web hosting of high quality and cheap price with cPanel.
- [Offshore Servers](https://www.offshore-servers.com/) - Ignores DMCA requests, no name required for the registration, starting with 8,17€ a month. Servers are located in Moskow or Warschau.
- [Inferno Solutions](https://inferno.name/) - VPS, Dedicated Server & more. Multiple server located around the world. Starts with 4,54€ a month.
- [ProHoster](https://prohoster.info/?partner=483528) - Provides a free domain, starts with 0,00€, multiple server locations, e.g. Moskow, New York, Amsterdam.
- [RapidLeechHost.com](https://www.estrowebservices.com/) - RapidLeechHost only allows warez linking on their offshore plans, using servers based in Netherlands.
- [SharkServe](https://www.sharkserve.rs/) - DDoS protection, Bitcoin & Co.
- [SporeStack](https://sporestack.com/news/#2019-02-27) - Truly Hidden Hosting.
- [Warez Hosting](https://warezhosting.ru/) - Private & Anonymous VPS Hosting!
- [WebCare360](https://webcare360.com/) - Powerful Offshore cpanel shared hosting provider.
- [WRZHost.com](http://wrzhost.com/) - WrzHost specializes in allowing warez, and acts as a safe-haven for people wanting to start warez-related projects with anonymity. They offer shared hosting, Linux VPS’s and dedicated servers.

## Alternate Networks

- [I2P](https://geti2p.net/en/) - I2P is an anonymous overlay network - a network within a network. It is intended to protect communication from dragnet surveillance and monitoring by third parties such as ISPs.
  - [ANONYMOUS TORRENTING WITH I2P-SNARK: USING SNARK](https://privacytutorials.wordpress.com/2015/01/05/anonymous-torrenting-with-i2p-snark-using-snark/)
- [Zeronet](https://zeronet.io/) - Open, free and uncensorable websites, using Bitcoin cryptography and BitTorrent network.
- [Loki](https://github.com/loki-project/loki-network) - Lokinet is an anonymous, decentralized and IP based overlay network for the internet.
- [SILO](https://medium.com/arweave-updates/building-silo-a-truly-private-internet-556c860222ca) - Offers complete privacy across the network (work in progress project in cooperationship with Loki).
- [IPFS](https://ipfs.io/) - A peer-to-peer hypermedia protocol designed to make the web faster, safer, and more open.
- [Yggdrasil](https://yggdrasil-network.github.io/about.html) - Makes use of a global spanning tree to form a scalable IPv6 encrypted mesh network.
- [cjdns](https://github.com/cjdelisle/cjdns) - Cjdns (Caleb James DeLisle's Network Suite) - is a networking protocol and reference implementation, founded on the ideology that networks should be easy to set up.
- [Freenet](https://freenetproject.org/) - Freenet is free software which lets you anonymously share files, browse and publish "freesites" (web sites accessible only through Freenet) - and chat on forums, without fear of censorship.
- [GnUNet](https://gnunet.org/) - GNUnet is a framework for secure peer-to-peer networking that does not use any centralized or otherwise trusted services.
- [Psiphon](https://www.psiphon.ca/) - Run your own server, invite your friends, build a community, provide free and unfiltered Internet access to the world.
- [Scuttlebutt](https://www.scuttlebutt.nz/) - A decentralised secure gossip platform that aims to harmonize four perspectives of life: Environment reflecting Technology reflecting Community reflecting Society.

### Tor

- [Tor](https://www.torproject.org/) - Tor is free software and an open network that helps you defend against traffic analysis.

:::caution

I'm not responsible for the links, domains, it's content or if the provided `.onion` links are really the ones advertised. It's impossible for me as individual person to check every single page every second and monitor it's content.

Also be very carefull of scams. you can find the links to some scam sites on [`torss7t3bxd3qsxn.onion`](http://torss7t3bxd3qsxn.onion/)

:::

:::note Something to consider

[Judge Recommends to Deny Summary Judgment Against Tor Exit Node Operator in Piracy Case](https://torrentfreak.com/judge-recommends-to-deny-summary-judgment-against-tor-exit-node-operator-in-piracy-case-190907/) - TorrentFreak

:::

:::caution

[Bittorrent over Tor isn't a good idea](https://blog.torproject.org/bittorrent-over-tor-isnt-good-idea) - Tor Blog

:::

:::info
If you suspect your access to the Tor network is being blocked, you may want to use bridges.

You can get latest Tor bridges from [bridges.torproject.org](https://bridges.torproject.org/)

:::


:::tip

Just replace .onion with .onion.ws or any other domain made available by volounteers [Tor2web](https://www.tor2web.org/) operators.

Example: `http://archivecaslytosk.onion/ => http://archivecaslytosk.onion.ws/`

This connects you with Tor2web, which then talks to the onion service via Tor and relays the response back to you.

**WARNING**: Tor2web only protects publishers, _not readers_. As a reader installing Tor Browser will give you much greater anonymity than using Tor2web. Using Tor2web trades off security for convenience and usability.

:::

#### Web Archive

| clearnet/name                  | onion address                                                                                                                              |
| ------------------------------ | :----------------------------------------------------------------------------------------------------------------------------------------- |
| Archive Today (archive.is)     | [`archivecaslytosk.onion`](http://archivecaslytosk.onion/)                                                                                 |
| Internet Archive (archive.org) | [`archivebyd3rzt3ehjpm4c3bjkyxv3hjleiytnvxcn7x32psn2kxcuid.onion`](http://archivebyd3rzt3ehjpm4c3bjkyxv3hjleiytnvxcn7x32psn2kxcuid.onion/) |

#### Filesharing

| clearnet/name | onion address                                                                                                                              |
| ------------- | :----------------------------------------------------------------------------------------------------------------------------------------- |
| OnionShare    | [`lldan5gahapx5k7iafb3s4ikijc4ni7gx5iywdflkba5y2ezyg6sjgyd.onion`](http://lldan5gahapx5k7iafb3s4ikijc4ni7gx5iywdflkba5y2ezyg6sjgyd.onion/) |

#### Comics & eBooks

| clearnet/name | onion address                                                                     |
| ------------- | :-------------------------------------------------------------------------------- |
| Comic Books   | [`r6rfy5zlifbsiiym.onion/series/0021`](http://r6rfy5zlifbsiiym.onion/series/0021) |
| Imperial      | [`xfmro77i3lixucja.onion`](http://xfmro77i3lixucja.onion/)                        |
| Z-Library     | [`2bu5puxp6afwjgql.onion`](http://2bu5puxp6afwjgql.onion/)                        |

#### Security & Privacy Tools

| clearnet/name         | onion address                                                                                                                               |
| --------------------- | :------------------------------------------------------------------------------------------------------------------------------------------ |
| GNUPG                 | [`ic6au7wa3f6naxjq.onion`](http://ic6au7wa3f6naxjq.onion/)                                                                                  |
| OpenPGPKeysever       | [`pgpkeysximvxiazm.onion`](http://pgpkeysximvxiazm.onion/)                                                                                  |
| Privacytools.io       | [`privacy2zbidut4m4jyj3ksdqidzkw3uoip2vhvhbvwxbqux5xy5obyd.onion`](http://privacy2zbidut4m4jyj3ksdqidzkw3uoip2vhvhbvwxbqux5xy5obyd.onion/)  |
| Privacy International | [`privacyintyqcroe.onion`](http://privacyintyqcroe.onion/)                                                                                  |
| Security in a Box     | [`bpo4ybbs2apk4sk4.onion/en`](http://bpo4ybbs2apk4sk4.onion/en/)                                                                            |
| Tor Project servers   | [`expyuzz4wqqyqhjn.onion`](http://expyuzz4wqqyqhjn.onion/)                                                                                  |
| Ooni                  | [`fqnqc7zix2wblwex.onion`](http://fqnqc7zix2wblwex.onion/)                                                                                  |
| Whonix                | [`kkkkkkkkkk63ava6.onion/wiki/The_World_Wide_Web_And_Your_Privacy`](http://kkkkkkkkkk63ava6.onion/wiki/The_World_Wide_Web_And_Your_Privacy) |

#### Search Engines

| clearnet/name | onion address                                              |
| ------------- | :--------------------------------------------------------- |
| DuckDuckGo    | [`3g2upl4pq6kufc4m.onion`](http://3g2upl4pq6kufc4m.onion/) |
| SearX         | [`ulrn6sryqaifefld.onion`](http://ulrn6sryqaifefld.onion/) |

##### Tor Network Search Engines

| clearnet/name | onion address                                              |
| ------------- | :--------------------------------------------------------- |
| Candle        | [`gjobqjj7wyczbqie.onion`](http://gjobqjj7wyczbqie.onion/) |
| Grams         | [`grams7ebnju7gwjl.onion`](http://grams7ebnju7gwjl.onion/) |
| Haystack      | [`haystakvxad7wbk5.onion`](http://haystakvxad7wbk5.onion/) |
| Not Evil      | [`hss3uro2hsxfogfq.onion`](http://hss3uro2hsxfogfq.onion/) |
| Tor Onionland | [`3bbaaaccczcbdddz.onion`](http://3bbaaaccczcbdddz.onion/) |
| Tor Search    | [`kbhpodhnfxl3clb4.onion`](http://kbhpodhnfxl3clb4.onion/) |

#### Hosting

| clearnet/name    | onion address                                                                                                                              |
| ---------------- | :----------------------------------------------------------------------------------------------------------------------------------------- |
| Ablative Hosting | [`hzwjmjimhr7bdmfv2doll4upibt5ojjmpo3pbp5ctwcg37n3hyk7qzid.onion`](http://hzwjmjimhr7bdmfv2doll4upibt5ojjmpo3pbp5ctwcg37n3hyk7qzid.onion/) |
| Black Cloud      | [`bcloud2suoza3ybr.onion`](http://bcloud2suoza3ybr.onion/)                                                                                 |
| Cloudflare       | [`dns4torpnlfs2ifuz2s2yf3fc7rdmsbhm6rw75euj35pac6ap25zgqad.onion`](http://dns4torpnlfs2ifuz2s2yf3fc7rdmsbhm6rw75euj35pac6ap25zgqad.onion/) |
| Daniel Uploads   | [`filesto37i2x5dea.onion`](http://filesto37i2x5dea.onion/)                                                                                 |
| dhosting         | [`dhosting4okcs22v.onion`](http://dhosting4okcs22v.onion/)                                                                                 |
| Image Hosting    | [`twlba5j7oo5g4kj5.onion`](http://twlba5j7oo5g4kj5.onion/)                                                                                 |
| Kowloon          | [`kowloon5aibdbege.onion`](http://kowloon5aibdbege.onion/)                                                                                 |
| OnionContainers  | [`container656ovix.onion`](http://container656ovix.onion/)                                                                                 |
| PopFiles         | [`popfilesxuru7lsr.onion`](http://popfilesxuru7lsr.onion/)                                                                                 |
| Riseup Etherpad  | [`5jp7xtmox6jyoqd5.onion`](http://5jp7xtmox6jyoqd5.onion/)                                                                                 |

#### Bitcoin

| clearnet/name | onion address                                              |
| ------------- | :--------------------------------------------------------- |
| Bitblender    | [`bitblendervrfkzr.onion`](http://bitblendervrfkzr.onion/) |
| BitCloak      | [`bitcloak43blmhmn.onion`](http://bitcloak43blmhmn.onion/) |
| Blockchain    | [`blockchainbdgpzk.onion`](http://blockchainbdgpzk.onion/) |
| CryptoMixer   | [`cryptomixns23scr.onion`](http://cryptomixns23scr.onion/) |
| PrivCoin      | [`tr5ods7ncr6eznny.onion`](http://tr5ods7ncr6eznny.onion/) |

#### eMail Services

| clearnet/name     | onion address                                                                                                                                                           |
| ----------------- | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| danwin1210        | [`danielas3rtn54uwmofdo3x2bsdifr47huasnmbgqzfrec5ubupvtpid.onion/mail/index.php`](http://danielas3rtn54uwmofdo3x2bsdifr47huasnmbgqzfrec5ubupvtpid.onion/mail/index.php) |
| ProtonMail.com    | [`protonirockerxow.onion`](http://protonirockerxow.onion)                                                                                                               |
| Confidant         | [`cwu7eglxcabwttzf.onion`](http://cwu7eglxcabwttzf.onion/)                                                                                                              |
| Cock.li           | [`cockmailwwfvrtqj.onion`](http://cockmailwwfvrtqj.onion/)                                                                                                              |
| Cock.li (Webmail) | [`mail.cockmailwwfvrtqj.onion`](http://mail.cockmailwwfvrtqj.onion/)                                                                                                    |
| Daniel Email      | [`tt3j2x4k5ycaa5zt.onion/mail`](http://tt3j2x4k5ycaa5zt.onion/mail/)                                                                                                    |
| Mailpile          | [`clgs64523yi2bkhz.onion`](http://clgs64523yi2bkhz.onion/)                                                                                                              |
| OnionMail         | [`en.onionmail.info`](http://en.onionmail.info/)                                                                                                                        |
| Systemli          | [`h2qkxasmmqdmyiov.onion`](http://h2qkxasmmqdmyiov.onion/)                                                                                                              |
| Paranoid          | [`paranoid.email`](http://paranoid.email/)                                                                                                                              |
| bitmessage.ch     | [`bitmailendavkbec.onion`](http://bitmailendavkbec.onion/)                                                                                                              |
| Riseup            | [`vww6ybal4bd7szmgncyruucpgfkqahzddi37ktceo3ah7ngmcopnpyyd.onion`](http://vww6ybal4bd7szmgncyruucpgfkqahzddi37ktceo3ah7ngmcopnpyyd.onion/)                              |
| Mail2Tor          | [`mail2tor2zyjdctd.onion`](http://mail2tor2zyjdctd.onion/)                                                                                                              |
| SecMail           | [`secmailw453j7piv.onion`](http://secmailw453j7piv.onion/)                                                                                                              |
| CTemplar          | [`ctemplar42u6fulx.onion`](http://ctemplar42u6fulx.onion/)                                                                                                              |
| TorBox            | [`torbox3uiot6wchz.onion`](http://torbox3uiot6wchz.onion/)                                                                                                              |
| SCRYPTMail        | [`scryptmail.com`](http://scryptmail.com/)                                                                                                                              |

##### Paid eMail services

| clearnet/name | onion address                                              |
| ------------- | :--------------------------------------------------------- |
| Elude         | [`eludemaillhqfkh5.onion`](http://eludemaillhqfkh5.onion/) |
| RayServers    | [`nmf6cg7tiyqlhsg3.onion`](http://nmf6cg7tiyqlhsg3.onion/) |
| Mail City     | [`eozm6j6i4mmme2p5.onion`](http://eozm6j6i4mmme2p5.onion/) |

##### Temp eMail services

| clearnet/name   | onion address                                              |
| --------------- | :--------------------------------------------------------- |
| GuerrillaMail   | [`grrmailb3fxpjbwm.onion`](http://grrmailb3fxpjbwm.onion/) |
| TempMailAddress | [`tempmailaddress.com`](http://tempmailaddress.com/)       |

#### Code/Text sharing

| clearnet/name      | onion address                                                                                                                                                                                                                                                     |
| ------------------ | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| DeepPaste          | [`4m6omb3gmrmnwzxi.onion`](http://4m6omb3gmrmnwzxi.onion/)                                                                                                                                                                                                        |
| Felixx             | [`felixxxboni3mk4a.onion/felixxx.php?page=pastebin`](http://felixxxboni3mk4a.onion/felixxx.php?page=pastebin)                                                                                                                                                     |
| Riseup Paste       | [`6zc6sejeho3fwrd4.onion`](http://6zc6sejeho3fwrd4.onion/)                                                                                                                                                                                                        |
| Pasta              | [`pastagdsp33j7aoq.onion`](http://pastagdsp33j7aoq.onion/)                                                                                                                                                                                                        |
| Stronghold Paste   | [`nzxj65x32vh2fkhk.onion`](http://nzxj65x32vh2fkhk.onion/)                                                                                                                                                                                                        |
| Zerobin            | [`zerobinqmdqd236y.onion`](http://zerobinqmdqd236y.onion/)                                                                                                                                                                                                        |
| Riseup Onion Index | [`vww6ybal4bd7szmgncyruucpgfkqahzddi37ktceo3ah7ngmcopnpyyd.onion/en/security/network-security/tor#riseups-tor-onion-services`](http://vww6ybal4bd7szmgncyruucpgfkqahzddi37ktceo3ah7ngmcopnpyyd.onion/en/security/network-security/tor#riseups-tor-onion-services) |

#### Onion Directories

| clearnet/name   | onion address                                                            |
| --------------- | :----------------------------------------------------------------------- |
| CB3ROB          | [`cb3robuo3hobodw6.onion`](http://cb3robuo3hobodw6.onion/)               |
| Daniel's onions | [`onionsnjajzkhm5g.onion`](http://onionsnjajzkhm5g.onion/)               |
| Fresh Onions    | [`zlal32teyptf4tvi.onion`](http://zlal32teyptf4tvi.onion/)               |
| onionsoup       | [`soupkso3la22ltl3.onion`](http://soupkso3la22ltl3.onion/)               |
| UnderDir        | [`underdj5ziov3ic7.onion`](http://underdj5ziov3ic7.onion/)               |
| VisiTOR         | [`visitorfi5kl7q7i.onion/search`](http://visitorfi5kl7q7i.onion/search/) |

#### Software

| clearnet/name                                      | onion address                                              |
| -------------------------------------------------- | :--------------------------------------------------------- |
| The Nowhere Server (restored from backup after FH) | [`2gxxzwnj52jutais.onion`](http://2gxxzwnj52jutais.onion/) |
| The Pirate Bay – Torrents                          | [`jntlesnev5o7zysa.onion`](http://jntlesnev5o7zysa.onion/) |
| The Pirate Bay – Torrents (official .onion)        | [`uj3wazyk5u4hnvtk.onion`](http://uj3wazyk5u4hnvtk.onion/) |
| DoxBin                                             | [`doxbindtelxceher.onion`](http://doxbindtelxceher.onion/) |
| Pony at Noisebridge                                | [`2ygbaoezjdmacnro.onion`](http://2ygbaoezjdmacnro.onion/) |
| Imperial Library of Trantor                        | [`xfmro77i3lixucja.onion`](http://xfmro77i3lixucja.onion/) |
| Jotunbane’s Reading Club                           | [`c3jemx2ube5v5zpg.onion`](http://c3jemx2ube5v5zpg.onion/) |
| HackBB – Hacking & cracking forum                  | [`jv7aqstbyhd5hqki.onion`](http://jv7aqstbyhd5hqki.onion/) |

#### eBooks

| clearnet/name  | onion address                                              |
| -------------- | :--------------------------------------------------------- |
| Tor Library    | [`am4wuhz3zifexz5u.onion`](http://am4wuhz3zifexz5u.onion/) |
| Various eBooks | [`xfmro77i3lixucja.onion`](http://xfmro77i3lixucja.onion/) |

#### Music

| clearnet/name                                    | onion address                                              |
| ------------------------------------------------ | :--------------------------------------------------------- |
| Music Downloads                                  | [`wuvdsbmbwyjzsgei.onion`](http://wuvdsbmbwyjzsgei.onion/) |
| Speedcore Music                                  | [`lolicore75rq3tm5.onion`](http://lolicore75rq3tm5.onion/) |
| 20th Century Western Music Recordings and Scores | [`vt27twhtksyvjrky.onion`](http://vt27twhtksyvjrky.onion/) |

#### Misc

| clearnet/name      | onion address                                              |
| ------------------ | :--------------------------------------------------------- |
| The Hidden Wiki    | [`zqktlwi4fecvo6ri.onion`](http://zqktlwi4fecvo6ri.onion/) |
| Is it up?          | [`nlmymchrmnlmbnii.onion`](http://nlmymchrmnlmbnii.onion/) |
| Anonet Webproxy    | [`xdagknwjc7aaytzh.onion`](http://xdagknwjc7aaytzh.onion/) |
| Gateway to Freenet | [`2vlqpcqpjlhmd5r2.onion`](http://2vlqpcqpjlhmd5r2.onion/) |
| Tor links          | [`torlinkbgs6aabns.onion`](http://torlinkbgs6aabns.onion/) |

### P2P Networks

- [eDonkey network](https://en.wikipedia.org/wiki/EDonkey_network) - A decentralized, mostly server-based, peer-to-peer file-sharing network.
- [Gnutella](https://en.wikipedia.org/wiki/Gnutella) - P2P network behind the popular LimeWire file sharing app.
- [FastTrack](https://en.wikipedia.org/wiki/FastTrack) - Protocol used by the Kazaa, Grokster, iMesh, and Morpheus file-sharing programs.
- [Napster](https://en.wikipedia.org/wiki/Napster) - Peer-to-peer file sharing Internet service that emphasized sharing digital audio files, typically audio songs, encoded in MP3 format.
- [IPFS - Distributed Web](https://en.wikipedia.org/wiki/InterPlanetary_File_System) - Peer-to-peer distributed file system that seeks to connect all computing devices with the same system of files.
- [Kad](https://en.wikipedia.org/wiki/Kad_network) - The Kad network is a peer-to-peer (P2P) - network that implements the Kademlia P2P overlay protocol.

## Proxy

:::caution

[Why You Shouldn’t Use a Free Proxy](https://www.vpnmentor.com/blog/why-you-shouldnt-use-free-proxies/) - VpnMentor
[Proxy Services Are Not Safe. Try These Alternatives](https://www.wired.com/2015/07/proxy-services-totally-unsecure-alternatives/) - WIRED
[HydraX.net ‘Google Drive Streaming Proxy’ Traffic Being Sent to ACE Anti-Piracy Coalition](https://torrentfreak.com/hydrax-net-google-drive-streaming-proxy-traffic-being-sent-to-ace-anti-piracy-coalition-200509/) - TorrentFreak

:::

- [v2rayN](https://github.com/2dust/v2rayN) - A proxy wrapper for Android and Windows.
- [Shadowsocks](https://shadowsocks.org/) - A secure socks5 proxy, designed to protect your Internet traffic.
- [sshuttle](https://github.com/sshuttle/sshuttle) - Transparent proxy server that works as a poor man's VPN.
- [kalitorify](https://github.com/brainfucksec/kalitorify) - Transparent proxy through Tor for Kali Linux OS.
- [dnscrypt-proxy](https://github.com/DNSCrypt/dnscrypt-proxy) - A flexible DNS proxy, with support for modern encrypted DNS protocols.
- [Simple DNSCrypt](https://simplednscrypt.org/) - A simple management tool to configure dnscrypt-proxy on windows based systems.

### Reverse Proxies

- [bitmitigate.com](https://bitmitigate.com)
- [blazingfast.io](https://blazingfast.io)
- [Cloudflare](https://www.cloudflare.com)
- [ddos-guard.net](https://ddos-guard.net/en)
- [Geniusguard.com](https://www.geniusguard.com)
- [puroxy.org](https://puroxy.org)
- [x4b.net](https://www.x4b.net)

## Router Firewalls

- [OpenWRT](https://openwrt.org/) - The OpenWrt Project is a Linux operating system targeting embedded devices.
- [VyOS.io](https://www.vyos.io/) - VyOS is a Linux-based network operating system that provides software-based network routing, firewall, and VPN functionality.
- [GufW](http://gufw.org/)
- [FlatPak](https://www.flatpak.org/)
- [IPFire](https://www.ipfire.org)
- [Endian Firewall](https://www.endian.com)
- [pfSense](https://www.pfsense.org)
- [LibreCMC](https://librecmc.org/)
- [Opensense](https://opnsense.org)
- [gl-inet](https://www.gl-inet.com/)

## Operating Systems

- [Overview of Security-focused operating system on Wikipedia](https://en.wikipedia.org/wiki/Security-focused_operating_system)
- [Cuckoo](https://github.com/cuckoosandbox/cuckoo) - Open source automated malware analysis system.
- [SIFT](https://digital-forensics.sans.org/community/downloads) - Forensic workstation made by SANS.
- [Security related Operating Systems @ Rawsec](http://list.rawsec.ml/operating_systems.html) - Complete list of security related operating systems.
- [Security @ Distrowatch](http://distrowatch.com/search.php?category=Security) - Website dedicated to talking about, reviewing, and keeping up to date with open source operating systems.

### Linux

- [Qubes OS](https://www.qubes-os.org/) - Qubes OS is a security-oriented operating system.
- [Tails](https://tails.boum.org/) - Tails is a live operating system that you can start on almost any computer from a USB stick or a DVD.
- [Fedora Workstation](https://getfedora.org/) - Fedora Workstation is a secure, reliable, and user-friendly Linux distribution developed by the Fedora Project.
- [kloak](https://github.com/vmonaco/kloak) - Keystroke-level online anonymization kernel: obfuscates typing behavior at the device level.
- [The practical linux hardening guide](https://github.com/trimstray/the-practical-linux-hardening-guide) - This guide details the planning and the tools involved in creating a secure Linux production systems - work in progress project!

### Windows

:::caution
"[Don't use Windows 10 - It's a privacy nightmare](https://www.privacytools.io/operating-systems/#win10)" - Privacy tools
:::

- [Windows 10 Privacy Guide](https://github.com/adolfintel/Windows10-Privacy) - An In-depth guide on purging Windows 10 of Microsoft's attempts to track you.
- [Destroy-Windows-10-Spying](http://m.majorgeeks.com/files/details/destroy_windows_10_spying.html) - Destroy Windows Spying tool.
- [Tron](https://www.reddit.com/r/TronScript) - Tron, an automated PC cleanup script.
- [Windows 10 Privacy Guide](https://github.com/adolfintel/Windows10-Privacy) - An in-depth guide on purging Windows 10 of Microsoft's attempts to track you.
- [Windows 10 hardening by CHEF-KOCH](https://github.com/CHEF-KOCH/Windows-10-hardening) - Windows 10 hardening without gimmicks.
- [BlackBird](http://www.getblackbird.net/) - Blocks telemetry, Ads etc.
- [DisableWinTracking](https://github.com/10se1ucgo/DisableWinTracking) - Uses some known methods that attempt to disable tracking in Windows 10.
- [O&O ShutUp10](http://www.oo-software.com/en/shutup10) - Have full control over which comfort functions under Windows 10 you wish to use, and you decide when the passing on of your data goes too far.
- [Tallow - Transparent Tor for Windows](https://github.com/basil00/TorWall) - Tallow is a small program that redirects all outbound traffic from a Windows machine via the Tor anonymity network.
- [W10Privacy](http://www.winprivacy.de/english-home/) - Yet another little utility similar to O&O ShutUp.
- [Win10-Initial-Setup-Script](https://github.com/Disassembler0/Win10-Initial-Setup-Script) - A customizable script to setup script via PowerShell/CMD.
- [Winaero](http://winaero.com/download.php) - Free, small and useful software for Windows.
- [Windows Privacy Tweaker](http://www.phrozen.io/freeware/windows-privacy-tweaker/) - Freeware app from phrozen.io.
- [WPD](http://wpd.app/) - The real privacy dashboard for Windows.
- [Hard_Configurator](http://hard-configurator.com/) - GUI to manage Software Restriction Policy (SRP) - and harden Windows.
- [hardentools](https://github.com/securitywithoutborders/hardentools) - Hardentools is a utility that disables a number of risky Windows features.
- [MSGM ToolKit](http://www.majorgeeks.com/files/details/msmg_toolkit.html) - Free program to customize Windows similar like NTLite but without a nice looking GUI.
- [NTLite](http://www.ntlite.com/) - Paid program to remove integrated telemetry, integrate updates & more.
- [How to remove viruses and malware on your Windows PC](https://www.howtogeek.com/126911/what-to-do-if-you-get-a-virus-on-your-computer/) - Helpful HowToGeek article on cleaning out the pipes.

### Android

- [Intra](https://getintra.org/) - Intra gives you safer, more open internet access.
- [DNSFilter](https://f-droid.org/en/packages/dnsfilter.android/) - No-root ad-blocker and DNS changer.
- [Nebulo DNS](https://play.google.com/store/apps/details?id=com.frostnerd.smokescreen) - DNS Changer for DNS over HTTPS/TLS.
- [AdAway](https://adaway.org/) - An open-source ad blocker for Android using the hosts file. needs ROOT access.

## Browsers

- [ungoogled-chromium](https://github.com/Eloston/ungoogled-chromium) - Google Chromium, sans integration with Google.
  - [chromium-web-store](https://github.com/NeverDecaf/chromium-web-store) - Allows adding extensions from chrome web store on ungoogled-chromium.
- [Bromite](https://www.bromite.org/) - A Chromium fork with ad blocking and privacy enhancements.

## Search Engines

- [SearX](https://searx.space/) - A free internet metasearch engine which aggregates results from more than 70 search services.
- [MetaGer](https://metager.de/) - Search engine made in Germany.
- [DavidWon.com](http://davidwon.com/) - An alternative search engine for Reddit, Google etc which comes with pre-defined tags to find some things faster.
- [Ecosia](https://www.ecosia.org/?c=en) - Ecosia's search results are provided by Bing and enhanced by the company's own algorithms to strip away tracking.
- [Search Encrypt](https://www.searchencrypt.com/) - The Privacy Based Search Engine.
- [Swisscows](https://swisscows.com/) - Private and secure Search engine made from Swiss.
- [Jive Search](https://jivesearch.com/) - A search engine that doesn't track you.
- [Yippy](https://yippy.com/) - Another private search engine and replacement for Google Search.
- [Qwant](https://lite.qwant.com/) - Yet another search engine.
- [Librefox](https://librefox.org/) - Firefox with privacy enhancements.

## Antivirus

:::tip Overall Strategy

- Diversify your analysis approach.
- Don't rely on the results from a single tool.
- Run everything with as few privileges as necessary.
- APT investigations must be seperated from commodity malware, otherwise you give malware authors "ideas".
- Treat everything like it could be malicious until you have enough evidence to suggest otherwise.

:::

- [MalwareBytes](https://www.malwarebytes.com/) - Crushes malware so you are protected and your machine keeps running smoothly.
- [HitmanPro](https://www.hitmanpro.com) - Antivirus product from Sophos.
- [Avast Antivirus](https://www.avast.com) - Avast Antivirus is a multi-platform antivirus application with a free tier. Be sure to opt-out of sending anonymous usage statistics.
- [VirusTotal](https://www.virustotal.com/) - Web service for scanning files and URLs for viruses.

### VirusTotal alternatives

- [Any-Run](https://any.run/) - Run files in a sandbox.
- [Thread Minder](https://www.threatminer.com/) - Allow analysts to find additional information on indicators of compromise (IOC) - such as domain names, IP's and more.
- [ThreatCrowd](https://www.threatcrowd.com/) - Search engine for threats, show correlations of submitted entries eg IP, hashes, domains etc.
- [URLScan](https://urlscan.io/) - Check the website.
- [Sooty](https://github.com/TheresAFewConors/Sooty) - SOC Analyst Tool.
- [CheckIP](https://threatstop.com/checkip) - Free resource for checking rep on IPs/CIDRs and domains.
- [Hybrid-Analysis](https://www.hybrid-analysis.com/) - [alternative](https://app.sndbox.com/) - The free version is normally good enough.

## SMS

- [Crypton](https://crypton.sh/) - Secure SMS Cloud service.
- [SMS Privacy](https://smsprivacy.org/) - Send & recieve SMS securely.

## Virtual Phone Numbers

- [Burner](https://www.burnerapp.com/) - Rent a temporary phone number and give it out to whomever you want.
- [Esendex.com.au](https://www.esendex.com.au/) - (`Registration required`) - Bulk SMS provider.
- [Free Online Phone](https://www.freeonlinephone.org/) - Just use one of the numbers listed, then select one of the numbers and you can see the SMS that reach that number.
- [FreePhoneNum](https://freephonenum.com/us) - The service offers a very temporary number for verification or any other purpose.
- [Freevirtualnumber.skycallbd](http://freevirtualnumber.skycallbd.com) - Receive Free SMS Online For Any SMS verification.
- [GetFreeSMSNumber](https://getfreesmsnumber.com/) - Free Receive SMS Online.
- [Getsms](http://getsms.org) - (`RU`) - Russian service to get virtual SMS numbers.
- [Google Voice](https://voice.google.com/) - Navigate to Google Voice and register or select a phone number via fake account ([works without phone number verification](https://www.wikicue.com/how-can-i-create-a-google-account-without-giving-a-phone-number-during-the-registration-process/)).
- [Hs3x](http://hs3x.com) - Which Country Number That You want? Which Website That Want To Verify, just reg you number online.
- [hs3x](https://hs3x.com/) - Receive SMS Online For Free.
- [MyTrashmobile](https://www.mytrashmobile.com/) - Receive text messages for online verifications as in WhatsApp or Facebook.
- [Online SIM](https://onlinesim.ru/) - `RU` - Russian SMS service.
- [Onlinesim](http://onlinesim.ru) - (`RU`) - Russian paid service to send and get SMS.
- [Proovl](https://www.proovl.com/) - Send and Receive SMS - As Easy As You'd Expect!
- [Receive SMS Online](https://www.receivesmsonline.net/) - Virtual numbers from United States, United Kingdom, Sweden, Canada and more.
- [Receive SMS](https://www.receivesms.org/) - Free service to verify your membership without giving out my own number.
- [Receive-a-sms](http://receive-a-sms.com) - Get your text messages through the internet with a free virtual phone number Stay anonymous with FREE phone verification, terms and conditions apply.
- [Receive-sms-free](http://Receive-sms-free.com) - Receive SMS Online,Get SMS numbers Online, Temporary phone numbers, Disposable Mobile numbers, Get SMS Online, Virtual Phone Online, Receive Voice.
- [Receive-sms-now)](http://receive-sms-now.com) - (`RU`) - Russian and international numbers online.
- [Receive-SMS-Now](https://receive-sms-now.com/) - Receive SMS Online for FREE and with NO Registration.
- [Receive-sms-online.com](https://receive-sms-online.com/) - Another free SMS provider.
- [Receive-SMS](https://receive-sms.com/) - Webservice to vie SMS.
- [Receive-smsonline](http://Receive-smsonline.net) - Free Receive SMS Online, does not work with Google phone verification!
- [Receivefreesms.net](http://receivefreesms.net) - Receive SMS Online.
- [ReceiveFreesms](http://receivefreesms.com/) - Receive SMS Online For FREE. Get Free SMS here to Verify your Services and APP. Receive Free sms text Online Worldwide.
- [ReceiveSMS](https://www.receivesms.co/) - Receive Your SMS Online With Our Virtual Numbers For Free! Without Registration!
- [Receivesmsonline.in](http://receivesmsonline.in/) - Get SMS online for free, it will not work with Google phone number verification!
- [Receivesmsonline](http://Receivesmsonline.com) - A free service for receiving SMS messages and voice mails online. There is no need to register.
- [Receivesmsverification](http://receivesmsverification.com) - Receive SMS Online without register. You can receive SMS online for free. Receive bypass sms without registration, Verify whatsapp, LINE, any type of account.
- [sms-online.co](https://sms-online.co/receive-free-sms) - Receive SMS Online for Free, will not work with Google number registration!
- [Sms-receive](http://Sms-receive.net) - Receive SMS and voice mail online.
- [SMS.INK](https://sms.ink/) - `RU` - Share SMS.
- [Smsc](https://smsc.ru/) - (`needs registration`) - Offers Russian and Ukrainian numbers.
- [SMSFinder](https://smsfinders.com/) - SMS service located in USA, UK, France, Canada, Sweden.
- [Smska](https://smska.us) - (`RU`) - Yet another free russian virtual number provider.
- [Smsreceivefree](http://Smsreceivefree.com) - Temporary SMS and Disposable Numbers.
- [SMSToolsOnline](https://smstools.online/) - Yet another free SMS service.
- [Sonetel](http://Sonetel.com) - Free and paid service for virtual sms numbers.
- [Tempsms](http://Tempsms.ru) - (`RU`) - Keep spam out of your phone and stay safe - just use a free disposable temporary phone number!
- [Zadarma](https://zadarma.com/en/) - The Zadarma VoIP project enables you to setup your business telephone system without the heavy hardware and wiring expenses.

## Virtualisation

- [FireJail](http://firejail.wordpress.com/) - Firejail is a SUID program that reduces the risk of security breaches by restricting the running environment of untrusted applications using Linux namespaces and seccomp-bpf.
- [FlatPak](http://flatpak.org/getting) - Standalone apps for Linux are here!
- [KVM](http://www.linux-kvm.org/page/Main_Page) - KVM (for Kernel-based Virtual Machine) - is a full virtualization solution for Linux on x86 hardware containing virtualization extensions (Intel VT or AMD-V).
- [Sandboxie](http://www.sandboxie.com/) - Install and run programs in a virtual sandbox (software based) - environment without writing to the hard drive itself.
- [Virtualbox](http://www.virtualbox.org/wiki/Downloads) - VirtualBox is a general-purpose full virtualizer for x86 hardware, targeted at server, desktop and embedded use.
- [VMWare](https://www.vmware.com/en.html) - (paid) - Closed source, but maybe the most reliable and used program for creating/booting up a virtual machine.

## Ad-Blocking

- [AdBlock Radio](https://github.com/adblockradio/adblockradio) - Block ads on live radio streams and podcasts. Machine learning meets Shazam!
- [AdGuard](https://adguard.com/en/welcome.html) - Claims to be the worlds most advance ad-blocker.
- [Filterlists](https://filterlists.com/) - An independent directory of filter and host lists for advertisements, trackers, malware, and annoyances.
- [uBlock origin](https://github.com/gorhill/uBlock) - A fast and efficient Ad Blocker.
- [An Overview of Ad Blocking Technology](https://www.techotopia.com/index.php/An_Overview_of_Ad_Blocking_Technology) - Basically explains how an Ad-Blocker works.
- [Wikipedia's Website about Ad blocking](https://en.wikipedia.org/wiki/Ad_blocking) - Wikipedia's info page about ad-blockers.

### DNS based AdBlocker

- [AdGuard Home](https://github.com/AdguardTeam/AdGuardHome) - AdGuard Home is a network-wide software for blocking ads & tracking.
- [Pi-hole](https://pi-hole.net/) - Pi-Hole is a Linux network-level advertisement and internet tracker blocking application which acts as a DNS sinkhole.

## Checksum verification

- [OpenHashTab](https://github.com/namazso/OpenHashTab) - File hashing shell extension for Windows.
- [GtkHash](https://github.com/tristanheaven/gtkhash) - A cross-platform desktop utility for computing message digests or checksums.

## Metadata cleaner

- [mat2](https://pypi.org/project/mat2/) - mat2 cleans metadata.
- [CCleaner](https://www.ccleaner.com/) - `Bundleware` - `Make sure CCLeaner is blocked via firewall` - It removes unused files from your system.
  - [Winapp3.ini](https://github.com/MoscaDotTo/Winapp2/blob/master/Winapp3/Winapp3.ini)
- [Bleachbit](https://www.bleachbit.org/) - Unless CCleaner it works on all operating systems and is fully open source but comes with less "cleaning features".
- [ExifTool](https://exiftool.org/) - Most reliable photo exif cleaning tool.
- [Exiv2](https://www.exiv2.org/) - Exiv2 is a C++ library and a command line utility to manage image metadata.
- [ExifTool by Phil Harvey](http://www.sno.phy.queensu.ca/~phil/exiftool/) - Read, Write and Edit Meta Information!
- [ExifTool GUI](http://u88.n24.queensu.ca/~bogdan/) - Adds a GUI to ExifTool by Phil Harvey.
- [Exif Purge](http://www.exifpurge.com/) - EXIF Purge is a small portable application to remove EXIF meta data from multiple images at once.

## Social Media

- [Fake-It 3.0](https://fake-it.ws/) - Generate full fake identities with random First and Last Name, Address, Social Security Number, Credit Card, IBAN Bank Numbers, Phone Number, and more! The website also provides other generator tools e.g. for passwords etc.
- [Forget](http://forget.codl.fr/about/) - Automatically deletes your old posts that everyone has forgotten about.
- [Keybase](http://keybase.io/docs/extension) - Keybase Extension Brings End-to-End Encrypted Chat To Twitter, Reddit & GitHub.
- [Reddit PowerDeleteSuite](https://github.com/j0be/PowerDeleteSuite) - Delete old reddit posts.
- [Nuke Reddit History](https://github.com/sr33/Nuke-Reddit-History) - [Firefox add-on](http://addons.mozilla.org/en-US/firefox/addon/nukereddithistory/) - + [Chrome extension](http://chrome.google.com/webstore/detail/nuke-reddit-history/aclagjkmidmkcdhkhlicmgkgmpgccaod/)
- [Random AI generated profile pictures](http://notarealhuman.com/) - Random AI generated profile pictures.
- [ShadowCrypt](http://shadowcrypt-release.weebly.com/about.html) - Chrome extension that brings encrypted messaging to Internet sites such as Reddit, Facebook or Twitter., it is a bit outdated but still works. (Keep in mind that this extension has a security hole which might reveal your encrypted messages).
- [Social Amnesia](https://github.com/Nick-Gottschlich/Social-Amnesia) - Deletes Twitter and Reddit content based on your terms.
- [TweetDelete](http://www.tweetdelete.net/) - Protect your privacy by automatically deleting posts older than a specified age from your Twitter feed.
- [Framapiaf](https://framapiaf.org/about/) - Mastodon instance of [Framasoft](https://framasoft.org) - A nonprofit organization focusing on free-software alorisation.
- [Mamot](https://mamot.fr/about/) - Mastodon instance of the [La Quadrature du Net](https://www.laquadrature.net/en/) - A French advocacy group that promotes digital rights and freedoms of citizens.
- [Mastodon](https://joinmastodon.org/) - Mastodon is an open-source self-hosted, federated social media networking service.
- [MeWe](https://mewe.com/) - Google+ replacement.
- [Movim](https://freedif.org/movim-the-decentralized-social-network) - Movim is a social network, based on XMPP, with Chat and chatrooms, news & communities features.
- [Nitter](https://nitter.net/) - Nitter is a free and open source alternative Twitter front-end focused on privacy.
- [Pleroma](https://pleroma.social/) - Host your own social media.
- [social.privacytools.io](https://social.privacytools.io/about/) - Mastodon instance by PrivacyTools, a volunteer-run privacy centered collective.
- [Stream.io](https://Stream.io) - Tries to combine all social networks into one place (_currently beta_).
- [NextCloudTalk](https://nextcloud.com/talk/) - Basically, Hangouts via NextCloud.
- [Jitsi](https://jitsi.org/) - Decrentralized chat, eMail platform.
- [JMP.chat](https://jmp.chat/)
- [Whereby](https://whereby.com/) - Anoher video calling app focused on privacy and usability.

## Payment

- [2Checkout](https://www.2checkout.com/)
- [Amazon Pay](https://pay.amazon.com/)
- [Authorize.Net](https://account.authorize.net/)
- [Braintree](https://www.braintreepayments.com/)
- [Dwolla](https://www.dwolla.com/)
- [Google Pay](https://pay.google.com/about/)
- [Intuit](https://www.intuit.com/)
- [Klarna](https://www.klarna.com/international/)
- [Payoneer](https://www.payoneer.com/)
- [Pyline](https://paylinedata.com/) - US only so far.
- [Shopify Payments](https://www.shopify.com/)
- [Skrill](https://www.skrill.com/)
- [Square](https://www.ojrq.net)
- [Stripe](https://stripe.com/)
- [TransferWise](https://transferwise.com/)
- [WePay](https://go.wepay.com/)
- [WorldPay](https://www.worldpay.com/)
- [Monero](https://www.getmonero.org/)
- [DeepOnion](https://deeponion.org/)
- [Pirate Chain](https://pirate.black/)
- [Zcash](https://github.com/adityapk00/zecwallet-lite/releases/latest)
- [Liberapay](https://en.liberapay.com/)

### Anonymous Cryptocurrency Exchanges

- [Binance](https://www.binance.com/) - Hong Kong-based exchange.
- [Changelly](https://itunes.apple.com/us/app/stratis/id1250824734?mt=8) - (_iOS app_) - Cryptocurrency exchange service that allows for instant transfers from one cryptocurrency wallet to another across various cryptocurrencies.
- [ShapeShift](https://itunes.apple.com/us/app/shapeshift-crypto-converter/id996569075?mt=8) - (_iOS App_) - Claims to not collect any data!
- [Tornado](https://tornado.cash/) - (_Beta!_) - Audit but still in beta!

## Domain Names

- [Domainr](https://domainr.com/) - Domainr allows you to find domain names and short URLs. Instantly check availability and register for all top-level domains.
- [xip.io](http://xip.io/) - Magic domain name that provides wildcard DNS for any IP address.
- [Namecheap](https://www.namecheap.com/) - Namecheap accepts Bitcoin and offers domain registration, hosting, email, SSL certs, and a variety of other products.
- [Njalla](https://njal.la/) - Privacy-focused domain registration service based in Nevis.
- [OrangeWebsite](https://www.orangewebsite.com/) - Anonymous domain registration services and also accepts cryptocurrency payments, based in Iceland.

## Secure PasteBin alternatives

- [PrivateBin](https://privatebin.net/) - A minimalist, open source online pastebin where the server has zero knowledge of pasted data.
- [ZeroBin](https://zerobin.net/)
  - [Tor Mirror](https://zerobinqmdqd236y.onion)
  - [source code](https://github.com/sebsauvage/ZeroBin)
