---
title: Movie/TV release names
author: xuac
author_url: https://github.com/xuac
author_title: Admin
author_image_url: https://github.com/xuac.png
---

Pirated movie release types vary wildly in rarity and quality due to the different sources and methods used for acquiring the video content and time frame of normal release. The sources for pirated copies have often changed with time in response to technology or anti-piracy measures.

<!--truncate-->

Quality can very from grainy and unwatchable to high definition. You will see these types in the name of the file you are downloading, giving you the background on it.

There are various acronyms that are used in release names, but they all follow a similar format.

```
Title.Of.The.Movie.YEAR.Source.Codec-GROUP
```

**Group:** The name of the group who created/distributed the release.

**Codec:** Will indicate what the codec is of the main stream of each type.

```
Title.Of.The.Movie.2001.BluRay.DD5.1.x264-GROUP
```

The above example indicates that the audio track (or main audio track, if it has multiple) is encoded in Dolby Digital (AC3) with 5.1 channels, and the video has been encoded with the x264 encoder to H264/AVC.

## CONTAINERS

A ‘container’ commonly known as _file format_ is the name for the small wrapper that contains video data and codec data. It can be identified by its file extension. MP4, MKV, AVI, FLV, and WEBM to name a few.

MKV is generally what you will be looking for as it can hold many kinds of video, audio, and subtitles, including all the ones listed.

## CODECS

A ‘codec’ is a specification on how to convert from raw data to images on a screen. When a video file is stored, there is a specific codec that converts that data into what you see.

Video files that use a specific codec are said to be ‘encoded’ using that codec.

Some codecs are better than others in the sense that they can get more quality using fewer bits (smaller filesizes) than others.

**Some of the popular codecs:**

#### XVID

Xvid isn’t actually a codec, it’s a program that encodes videos. The name for the codec it uses is MPEG-4 ASP, but that never stuck. Quality-wise, it was OK for it’s time (2001!), but doesn’t hold up against modern codecs. Usually contained in AVI containers.

#### H.264

Also called MPEG-4 AVC, this codec is used everywhere, basically. Usually contained in MP4, if not MKV.

#### H.265

Also known as HEVC. It is the successor to H264 and it aims to reduce filesizes by up to 50% compared to H264, though this number is not a blanket figure to be applied to every single scenario. H265 is more effective at higher resolutions, so the 50% figure might be applicable to 4K, though the savings can still be considerable at 1080p and 720p.

Many people choose to download small-sized H265 content that would otherwise be too blurry on H264. Though H264 still reigns supreme at higher bitrates, as x265 (the encoding tool used to create H265 video) is still not as mature as x264, which is why many quality-oriented private trackers still maintain a higher focus on x264-encoded content. Some 1080p Blu-Rays and all 4K Blu-Rays use this codec.

Usually contained in MP4, if not MKV.

## RESOLUTION

Resolution refers to the number of pixels in an image or a single frame of a video file. It is usually expressed in the form 'WIDTHxHEIGHT'.

Most televisions are ‘Full HD’, which means 1920x1080. ‘UHD’, on the other hand, is twice the width and height to make 3840x2160. Most individuals and companies call this specific resolution ‘4K’.

Additionally, resolution can be expressed as the height of the image followed by a ‘p’. 1920x1080 becomes 1080p, 3840x2160 (4K) becomes 2160p. This can be a very loose definition, however, as movies that are produced at a wider aspect ratio will be called 1080p, yet will have a resolution 1920x800.

## BITRATE

The term ‘bitrate’ refers to the number of bits (ones and zeros) per second for a video or audio file. This number directly affects both quality and filesize. A video file with a high bitrate will result in a larger filesize than one with a low bitrate (assuming equal runtime), and will be more detailed. How much of this detail you see will be dependent upon you and your set up (ie. the size of your screen, how far you sit from it). Most people will settle at a bitrate of 4000 Mbps at 720p (Which would give you a 2GiB file a 1-hour movie, or 4GiB for a 2-hour movie). When watching on a small screen (like a phone), the requirements will go even lower (down to 1 Mbps or maybe even lower).

A higher bitrate yields better quality at the cost of filesize. Conversely, a lower bitrate takes up less space, but hurts image quality. Dual-layer Blu-Ray discs hold 50 GiB. If you see a movie release that’s 1.4 GiB, don’t be surprised if it’s not up to par.

Bitrate is usually measured in megabits per second, abbreviated to Mbps (note the lowercase ‘b’). One byte is 8 bits, so one megabyte is 8 megabits.

## SOURCE

This will vary depending on the medium it was sourced from (BluRay, DVD, WEB). It will also vary depending on how the media was ripped (BRRip, WEBRip, HDRip, HDcam)

There are a few variations of WEB releases, mainly WEB-DL and WEBRip. Scene groups will not specify the type of WEB release their content is and will simply use WEB instead of specifiying WEB-DL or WEBRip. P2P groups will tend to specify between WEB-DL and WEBRip.

#### CAM/CAMRIP

A copy made in a cinema using a camcorder or mobile phone. The sound source is the camera microphone. Cam rips quickly appear after the first preview or premiere of the film.

The quality ranges from terrible to watchable, depending on the group or person recording and the resolution of the camera used. The main disadvantage is the sound quality, it's usually poor as the microphone does not only record the sound from the movie, but also any background noise. These are very common.

#### TELESYNC

A telesync (TS) is shot in an empty cinema or from the projection booth with a professional camera mounted on a tripod, directly connected to the sound source. The professional camera source is then synced with audio source fed directly from the cinema's sound system, or captured from an FM transmission intended for hearing-impaired customers or from a drive-in theater. They are usually of decent quality. HDTS is used to label a High-definition video recording.

#### WORKPRINT

A copy made from an unfinished version of a film produced by the studio. Typically WPs have missing effects and overlays and often differ from its theatrical release. Some have a time index marker running in a corner or on the top edge and some also include watermarks. These are very rare and you usually will not encounter them.

#### TELECINE

A Telecine is a copy captured from a film print using a machine that transfers the movie from its analog reel to digital format. However, the result is inferior because the source material is usually a lower quality reel. Telecine machines usually cause a slight left-right jitter in the picture and have inferior color levels compared to DVD. These are rare because telecine machines for making these prints are very costly and very large. HDTC is used to label a High-definition video recording.

#### PPV RIP

PPVRips come from Pay-Per-View sources. All the PPVRip releases are brand new movies which have not yet been released to Screener or DVD, but are available for viewing by customers with high-end TV package deals.

#### SCREENER

Screeners are early DVD or BD releases of the theatrical version of a film, typically sent to movie reviewers, Academy members, and executives for review purposes. A screener normally has a message overlaid on its picture, with wording similar to:

> The film you are watching is a promotional copy, if you purchased this film at a retail store please contact 1-800-NO-COPIES to report it.

or more commonly if released for awards consideration simply:

> FOR YOUR CONSIDERATION

Apart from this, some movie studios release their screeners with a number of scenes of varying duration shown in black-and-white. Aside from this message, and the occasional B&W scenes, screeners are normally of only slightly lower quality than a retail DVD-Rip, due to the smaller investment in DVD mastering for the limited run. Some screener rips with the overlay message get cropped to remove the message and get released mislabeled as DVD-Rips.

**\*Note:** Screeners make a small exception here - since the content may differ from a retail version, it can be considered as lower quality than a DVD-Rip (even if the screener in question was sourced from a DVD).\*

#### DDC

A digital distribution copy (DDC) is basically the same as a Screener, but sent digitally (FTP, HTTP, etc.) to companies instead of via the postal system. This makes distribution cheaper. Its quality higher than a Cam or Telesync.

In The Scene DDC refers to Downloadable/Direct Digital Content which is not freely available.

#### R5

The R5 is a retail DVD from region 5. Region 5 consists of the Indian subcontinent, Africa, North Korea, Russia and Mongolia. R5 releases differ from normal releases in that they are a direct telecine transfer of the film without any of the image processing.

If the DVD does not contain an English-language audio track, the R5 video is synced to a previously released English audio track. Then a LiNE tag is added. This means that the sound often is not as good as DVD-Rips. To account for the lesser audio quality, some release groups take the high quality Russian or Ukrainian 5.1 channel audio track included with the R5 DVD and remove the non-English spoken portion of the audio and sync the remaining portion, which contains high quality sound effects and music with a previously recorded source of English vocals usually taken from a LiNE tagged release. The result of this process is an _almost_ retail DVD quality surround sound audio track.

Releases of this type are normally tagged AC3.5.1.HQ and details about what was done to the release are present in the release notes.

#### DVD RIP

A DVD-Rip is a final retail version of a film, typically released before it is available outside its originating region.

Often after one group of pirates releases a high-quality DVD-Rip, the "race" to release that film will stop. Because of their high quality, DVD-Rips generally replace any earlier copies that may already have been circulating. Widescreen DVDs used to be indicated as WS.DVDRip.

#### DVD-R

DVD-R refers to a final retail version of a film in DVD format, generally a complete copy from the original DVD. DVD-R releases often accompany DVD-Rips. DVD-R rips are larger in size, generally filling up the 4.37 to 7.95 GiB. Untouched or lossless rips in the strictest sense are 1:1 rips of the source, with nothing removed or changed.

#### TV RIP

TVRip is a capture source from an analog capture card (coaxial/composite/s-video connection). Digital satellite rip (DSR, also called SATRip or DTH) is a rip that is captured from a non-standard definition digital source like satellite. HDTV stands for captured source from HD television, while PDTV (Pure Digital TV) stands for any SDTV rip captured using solely digital methods from the original transport stream, not from HDMI or other outputs from a decoder, it can also refer to any standard definition content broadcast on a HD channel.

DVB rips often come from free-to-air transmissions (such as digital terrestrial television). With an HDTV source, the quality can sometimes even surpass DVD. Movies in this format are starting to grow in popularity. Some advertisement and commercial banner can be seen on some releases during playback.

Analog, DSR, and PDTV sources used to be often reencoded to 512×384 if fullscreen, currently to 640x480 if fullscreen and 720x404 if widescreen. HDTV sources are reencoded to multiple resolutions such as 720x404 (360p), 960×540 (540p), 1280×720 (720p), and 1920x1080 (1080p) at various file sizes for pirated releases. They can be progressive scan captured or not (480i digital transmission or 1080i broadcast for HD caps).

#### VOD RIP

VODRip stands for Video-On-Demand Rip. This can be done by recording or capturing a video/movie from an On-Demand service such as through a cable or satellite TV service. Most services will state that ripping or capturing films is a breach of their use policy, but it is becoming more and more popular as it requires little technology or setup.

There are many online On-Demand services that would not require one to connect their TV and computer. It can be done by using software to identify the video source address and downloading it as a video file which is often the method that bears the best quality end result.

#### WEB DOWNLOAD

WEB-DL refers to a file losslessly ripped from a streaming service, such as Netflix, Amazon Video, Hulu, Crunchyroll, Discovery GO, BBC iPlayer, etc., or downloaded via an online distribution website such as iTunes.

The quality is good enough, since they are not reencoded. The video (H.264 or H.265) and audio (AC3/AAC) streams are usually extracted from the iTunes or Amazon Video and remuxed (repackaged) into a into a popular video container without sacrificing quality. An advantage with these releases is that, like BD/DVDRips, they usually have no onscreen network logos. HDRips are typically transcoded versions of HDTV or WEB-DL source files, but may be any type of HD transcode.

Popular paid streaming services such as Netflix utilize Widevine DRM to prevent downloading of the video stream. Only a handful of underground groups around the world (namely, The Scene) has access to tools to decrypt Widevine-protected content.

#### WEB RIP

This can be a vague term, in that it can mean that a web stream was screen captured or that it has been encoded down from a higher resolution WEB-DL (typically a 4k WEB-DL, encoded down to 1080p or 720p), which in many cases results in a higher quality video compared to the actual 720p or 1080p WEB-DL. The file is often extracted using the HLS or RTMP/E protocols and remuxed from a TS, MP4 or FLV container to MKV.

#### WEB CAPTURE

A WEBCap is a rip created by capturing video from a DRM-enabled streaming service, such as Disney Plus or Netflix. Quality can range from mediocre (comparable with low quality XVID encodes) to excellent (comparable with high quality BR encodes). Essentially, the quality of the image obtained depends on internet connection speed and the specifications of the recording machine.

WEBCaps are often labeled as WEBRips, with a note attached by the encoder to let others know it was capped & encoded instead of losslessly remuxed.

WEB releases can also have extra qualifiers which will indicate which streaming service is was sourced from. The scene doesn't provide this type of indication, so only p2p groups will indicate which streaming service it was sourced from.

**Common abbreviations for content producers and distributors:**

| Notation | Network                                                    |
| -------- | ---------------------------------------------------------- |
| ABC      | American Broadcasting Company                              |
| ATVP     | Apple TV +                                                 |
| AMZN     | Amazon Studios                                             |
| BBC      | British Broadcasting Corporation                           |
| CBS      | CBS Corporation                                            |
| CC       | Comedy Central                                             |
| CR       | Crunchyroll                                                |
| CW       | The CW                                                     |
| DCU      | DC Universe                                                |
| DSNY     | Disney Networks (Disney Channel, Disney XD, Disney Junior) |
| FBWatch  | Facebook Watch                                             |
| FREE     | Freeform                                                   |
| FOX      | Fox Broadcasting Company                                   |
| HULU     | Hulu Networks                                              |
| iP       | BBC iPlayer                                                |
| LIFE     | Lifetime                                                   |
| MTV      | MTV Networks                                               |
| NBC      | National Broadcasting Company                              |
| NICK     | Nickelodeon                                                |
| NF       | Netflix                                                    |
| RED      | YouTube Premium (formerly YouTube Red)                     |
| TF1      | TF1 Network                                                |
| STZ      | STARZ                                                      |

#### HC HD RIP

In a HC HDRip, HC stands for hard-coded subtitles. This format is released shortly after the movie leaves theaters. Usually sourced from Korean Video On-Demand services like Naver.

The quality is lower than a WEB-DL as it is screen recorded. The reason as this is a less preferred option Is because of the subtitles being baked into the video, and cannot be removed. P2P groups have released blurred copies, which have the subtitles blurred or blocked.

#### BD RIP

Blu-ray or Bluray rips are encoded directly from the Blu-ray disc to 1080p or 720p (depending on disc source), and use the x264 or x265 codec. They can be ripped from BD25 or BD50 discs (or UHD Blu-ray at higher resolutions). BDRips are from a Blu-ray disc and encoded to a lower resolution from its source (i.e. 1080p to 720p/576p/480p). BRRips are an already encoded video at HD resolution that is then transcoded to an SD resolution.

BRRips are only available in an HD resolution to an SD resolution range, whereas BDRips can go from 2160p to 1080p, etc as long as they go downward in resolution of the source disc. BDRips are not a transcode, but BRRips are. BD/BRRips in DVDRip resolutions can vary between XviD/x264/x265 codecs (commonly 700 MB and 1.5 GB in size as well as larger DVD5 or DVD9: 4.5 GB or 8.4GB). Size fluctuates depending on length and quality of releases, but the higher the size the more likely they use the x264/x265 codecs. A BD/BRRip to DVDRip resolution looks better, regardless, because the encode is from a higher quality source. BDRips and BRRips are often confused with each other, but have followed the above guideline after Blu-ray replaced BDRip title structure in scene releases.

Full BD25/BD50 data rips also exist, and are similar to their counterpart DVD5/DVD9 full data releases. They are AVCHD compatible using the BD folder structure (sometimes called Bluray RAW/m2ts/iso), and are usually intended to be burnt back to disk for play in AVCHD-compatible Blu-ray players. BD25/BD50 data rips may or may not be remuxed and are never transcoded.

BD and BR Rips come in various (now possibly outdated) versions:

**mHD (or mini HD)**

encoded in the same resolution but at a lower bitrate and are smaller in size.

**1080p**

can be anywhere from 8 GB to as large as 40–60 GB.

**720p**

usually around 4–7 GB and is the most downloaded form of BDRip.
m-1080p (or mini 1080p)
usually a little bit larger than 720p.

**m-720p (or mini 720p)**

a compressed version of a 720p and usually sized at around 2–3 GB.

## MISCELLANEOUS ATTRIBUTES

There are other qualifiers that indicate other attributes regarding the release:

#### SDR

Standard Dynamic range. If it's a 4k release, it's a given that it is an HDR/HDR10 release, unless otherwise specified as SDR

#### DV

Dolby Vision. Only a handful of movies/shows (approximately 100 total, at the time of writing) have made their way onto the wild with DV metadata included. These releases are uploaded in the .mp4 format since mkv does not have support for DV metadata.

#### REMUX

Remuxing (or **remu**ltiple**x**ing) is the process of "repackaging" the streams inside a video container into another video container. However, in regards to Warez releases, REMUX is only used for Bluray releases, indicating that the main video stream from a Bluray has been remuxed into a single video file.

The full bluray contains a number of different directories and video containers, each containing different types of videos depending on the bluray, including extras such as cast Q&A, director interviews, deleted scenes, etc. Remuxes and full blurays can be many tens of GiB, averaging out at around 60 GiB per 4k remux.

#### FULL BLUERAY

This is not indicated anywhere in the filename, however it can be easily perceived by paying attention to the video codec, as it can specify whether the video is an encode or if it is unadulterated. If the release title contains AVC or HEVC, then it means it is the unadulterated video (not encoded). Following that, if it contains REMUX in the title, then it is a single video file (an mkv file), otherwise it is the full bluray, shared as an .iso file or its contents dumped into a folder.

## CONCLUSION

Hopefully now all those jargony names and standards now make sense for you. There can be exceptions to these rules at times but they are rarely seen and when you come around any, make sure you trust the source.
