---
title: Media Centre Applications
sidebar_label: Media Centre Applications
---

- [Emby](https://emby.media/) - A personal media server with apps on just about every device.
  - [r/EmbyShares](https://www.removeddit.com/r/EmbyShares) - This subreddit is dedicated to the sharing of Emby servers.
- [Myflix](https://github.com/pastapojken/Myflix) - Myflix tries to be a somewhat simple and lightweight "DIY Netflix", similar to Plex, streama or Emby, for your DIY NAS, especially aimed at the Raspberry Pi/Odroid/etc ecosystem.
- [Gerbera](https://github.com/gerbera/gerbera) - UPnP Media Server for 2018 (Based on MediaTomb).
- [Serviio](http://serviio.org/) - Serviio is a free media server. It allows you to stream your media files (music, video or images) - to renderer devices (e.g. a TV set, Blu-ray player, games console or mobile phone) - on your connected home network.
- [Rygel](https://wiki.gnome.org/Projects/Rygel) - Rygel is a home media solution (UPnP AV MediaServer) - that allows you to easily share audio, video, and pictures to other devices.
- [Jellyfin](https://jellyfin.org/) - Open source alternative to Plex.
- [OpenPHT](https://github.com/RasPlex/OpenPHT) - A community driven fork of Plex Home Theater.
- [OSMC](https://osmc.tv/) - OSMC (short for Open Source Media Center) - is a Linux distribution based on Debian that brings Kodi to a variety of devices.
- [Subsonic](http://www.subsonic.org/pages/index.jsp) - Music and movie streaming server with a client app and web frontend.
- [Streama](https://github.com/streamaserver/streama) - Self hosted streaming media server.
- [Stremio](https://www.stremio.com/) - Multi-platform video content aggregator with a comprehensive add-on system for extending functionality.
- [Viewscreen](https://github.com/viewscreen/viewscreen) - A personal video streaming server.

## Plex

- [Plex](https://www.plex.tv/) - Your favorite movies, TV, music, web shows, podcasts, and more, all streamed to your favorite screens.
- [hoarding.me](https://hoarding.me/) - Unlimited and automated. How to setup your own dream Plex server?!.
- [linuxserver/docker-plex](https://github.com/linuxserver/docker-plex) - LinuxServer.io Plex Media Server docker image.
- [PGBlitz.com](https://pgblitz.com/) - Deploy a Hastey Server through Docker & Ansible with local or Unlimited Google HD.
- [PlexPi](http://plexpi.com/) - Plex Media Server for your Raspberry Pi 3.
- [plexinc/pms-docker](https://github.com/plexinc/pms-docker) - Official Plex docker image.
  - [timhaak/plex](https://github.com/timhaak/docker-plex) - Alternative Plex docker image.
- ["My (scripted) - solution to having a single Movies library for 4k and non-4k."](https://www.reddit.com/r/PleX/comments/afs8m9/my_scripted_solution_to_having_a_single_movies/) - Post by /u/spazatk.
- ["I made my own Pseudo TV for Plex with Kodi and Nvidia Shield"](https://reddit.com/r/PleX/comments/awsvp9/i_made_my_own_pseudo_tv_for_plex_with_kodi_and/ehox9zf/) - Guide from /u/nads84 on how to make your own "live" TV channels with a Plex library, Kodi, and an NVIDIA Shield.
- [Unlock the transcode or 'session' limit on nVidia consumer grade GPUs](http://slothtechtv.com/2018/09/unlock-the-transcode-or-session-limit-on-nvidia-consumer-grade-gpus) - Article describing how to bypass the artifical single-transcode limit.

### Plex Plugins

- [Audiobooks.bundle](https://github.com/macr0dev/Audiobooks.bundle) - Plex metadata scraper for Audiobooks.
- [ExportTools.bundle](https://github.com/ukdtom/ExportTools.bundle) - Export Plex Library to a csv, xlsx or m3u8 file.
- [FMoviesPlus.bundle](https://github.com/coder-alpha/FMoviesPlus.bundle) - Plex Media Server plug-in designed for FMovies, G2G, Primewire and more.
- [HDGrandSlam.bundle](https://github.com/jumpmanjay/HDGrandSlam.bundle) - Interfaces with HDHomeRun tuners and DVRs.
- [HDHRViewerV2.bundle](https://github.com/zynine-/HDHRViewerV2.bundle) - HDHomeRun + Plex.
- [IPTV.bundle](https://github.com/Cigaras/IPTV.bundle) - The website plays live streams (like IPTV) - from an M3U playlist.
- [lmwt-kiss.bundle](https://github.com/Twoure/lmwt-kiss.bundle) - Creates a new channel within Plex Media Server (PMS) - to view content from PrimeWire.
- [Moviemania.bundle](http://www.reddit.com/r/MoviemaniaHQ/comments/6znf6b/plex_pluginagent_beta_1/) - Textless movie posters from Moviemania.io.
- [Official Plex Plugins](https://github.com/plexinc-plugins) - Repos for every official Plex Inc. plugin.
- [Plex-Trakt-Scrobbler](https://github.com/trakt/Plex-Trakt-Scrobbler) - Add what you are watching on Plex to trakt.tv.
- [PlexTools.bundle](https://github.com/jwdempsey/PlexTools.bundle) - Downloads subtitles for any videos in your library from OpenSubtitles and modifies them to work with Roku clients, and converts videos to MP4 for direct play.
- [RequestChannel.bundle](https://github.com/ngovil21/RequestChannel.bundle) - A Plex Channel to create requests.
- [SRT2UTF-8.bundle](https://github.com/ukdtom/SRT2UTF-8.bundle) - Plex Agent that'll convert sidecar subtitle files into UTF-8.
- [SS Plex](http://mikew.github.io/ss-plex.bundle/) - Imagine if all the media scattered around the internet could be found in one collection.
- [Sub-Zero.bundle](https://github.com/pannal/Sub-Zero.bundle) - Subtitles for Plex, as good you would expect them to be. (_read_: [plans for a world without Plex plugins](http://www.reddit.com/r/PleX/comments/9n9qjl/subzero_the_future/)).
- [SuperPLEX](http://normantheidiot.neocities.org/superplex/) - A website dedicated to Plex plugins.
- [TvplexendChannel.bundle](https://github.com/pgaubatz/TvplexendChannel.bundle) - A Tvheadend Channel Plugin for PLEX Media Server.
- [WebTools.bundle](https://github.com/ukdtom/WebTools.bundle) - A collection of several tools for Plex Media Server. Like the Unsupported AppStore (UAS).
- [SyncLounge](https://synclounge.tv/) - Enjoy Plex with your friends. In Sync. Together.

### Plex Requests

- [Ombi](http://ombi.io/) - Want a Movie or TV Show on Plex or Emby? Use Ombi!.
- [Plex Requests](http://plexrequests.8bits.ca/) - Simple automated way for users to request new content for Plex.
- [plexrequests-meteor](https://github.com/lokenx/plexrequests-meteor) - Meteor version of the original Plex Requests.
- [Mellow](https://github.com/v0idp/Mellow/) - Bot which can communicate with several APIs like Ombi, Sonarr, Radarr and Tautulli which are related to home streaming. Based off of node:9.3.
- [MediaButler](https://github.com/physk/MediaButler) - Discord bot for use with PleX and several other apps that work with it.

### Plex Scripts and Tools

- [goplaxt](https://github.com/XanderStrike/goplaxt/) - Full rewrite of the above, written in Go and deployable with Docker.
- [Varken](https://github.com/Boerderij/Varken) - Standalone application to aggregate data from the Plex ecosystem into InfluxDB using Grafana for a frontend.
- [DocDownloader](https://docdownloader.com/) - Scribd Downloader; Issuu Downloader; Slideshare Downloader; Academia Downloader. Scribd Downloader.
- [Gaps](https://github.com/JasonHHouse/Gaps) - Find the missing movies in your Plex Server.
- [JBOPS](https://github.com/blacktwin/JBOPS) - Just a Bunch Of Plex Scripts.
- [killstream](https://github.com/blacktwin/JBOPS/tree/master/killstream) - Killing streams is a Plex Pass only feature. So these scripts will only work for Plex Pass users.
- [Kitana](https://github.com/pannal/Kitana) - Kitana exposes your Plex plugin interfaces "to the outside world".
- [NowShowing](https://github.com/ninthwalker/NowShowing) - Generates an email and web page of Plex recently added content.
- [Phlex](https://github.com/d8ahazard/Phlex) - A super-sexy voice interface for the Plex HTPC.
- [Plaxt](https://plaxt.herokuapp.com/) - Webhook-based Trakt.tv scrobbling for Plex.
- [Plex Media Tagger](https://github.com/ccjensen/PlexMediaTagger) - Uses the metadata held in the PlexMediaServer to tag media files.
- [Plex Redirect](https://github.com/ITRav4/PlexRedirect) - A Plex landing page that redirects you to various sites.
- [plex_autoscan](https://github.com/l3uddz/plex_autoscan) - Script to assist sonarr/radarr with plex imports.
- [plex_top_playlists](https://github.com/pbrink231/plex_top_playlists) - A python script to get top weekly or top popular lists and put them in plex as playlists.
- [plex-subtitles-normalizer](https://github.com/caridy/plex-subtitles-normalizer) - CLI tool to fix subtitles needed by Plex Media Center.
- [plex-sync](https://github.com/jacobwgillespie/plex-sync) - A simple command-line utility to synchronize watched / seen status between different Plex Media Servers.
- [plex2netflix](https://github.com/SpaceK33z/plex2netflix) - See how much of your media from Plex is available on Netflix.
- [PlexAuth](https://github.com/hjone72/PlexAuth) - Plex based authentication using PHP.
- [PlexEmail](https://github.com/jakewaldron/PlexEmail) - This script aggregates all new TV, movie and music releases for the past configured time then optionally writes to your web directory and sends out an email.
- [PlexIPTV](https://github.com/xiaodoudou/PlexIPTV) - This app simulates a DVR device for Plex by providing a layer to any IPTV provider (that provide a m3u8 playlist).
- [PlexMissingEpisodes](https://github.com/MysticRyuujin/PlexMissingEpisodes) - Scan Plex library for missing episodes using TheTVDB.
- [PlexRecs](https://github.com/nwithan8/PlexRecs) - A Discord bot that provides movie and TV show recommendations from your Plex library.
- [plexReport](https://github.com/bstascavage/plexReport) - Scripts to generate a weekly email of new additions to Plex.
- [plexupdate](https://github.com/mrworf/plexupdate) - Script to simplify the life of Linux Plex Media Server users.
- [plxdwnld](https://piplong.run/plxdwnld/) - Bookmarklet for downloading original files from the Plex web interface.
- [Python-PlexLibrary](https://github.com/adamgot/python-plexlibrary) - Python command line utility for creating and maintaining dynamic Plex libraries based on "recipes".
- [Transmogrify](https://github.com/Transmogrify-for-Plex/Transmogrify-for-Plex-chrome) - A Chrome extension that adds several features to the Plex/Web 2.0 client for Plex.

### Plex Sharing

- [r/plexshares](https://www.reddit.com/r/plexshares/) - A nice place to find Plex Media Server shares.
- [Elysium](https://elysium.to/) - Plex media streaming service.

### Plex Transcoding

- [nvidia-patch](https://github.com/keylase/nvidia-patch) - Unlock the transcode or 'session' limit on nVidia consumer grade GPUs.
- [kube-plex](https://github.com/munnerz/kube-plex) - Scalable Plex Media Server on Kubernetes -- dispatch transcode jobs as pods on your cluster!.
- [Plex-Remote-Transcoder](https://github.com/wnielson/Plex-Remote-Transcoder) - A distributed transcoding backend for Plex.
- [UnicornTranscoder](https://github.com/UnicornTranscoder/UnicornTranscoder) - A remote transcoder for Plex Media Server.

### Plex Logging and Metrics

- [Plex-Data-Collector-For-InfluxDB](https://github.com/barrycarey/Plex-Data-Collector-For-InfluxDB) - Collects data about your Plex server and sends it to InfluxDB.
- [plexWatch](https://github.com/ljunkie/plexWatch) - Notify and Log watched content on a Plex Media Server.
- [Tautulli](https://tautulli.com/) - Tautulli is a 3rd party application that you can run alongside your Plex Media Server to monitor activity and track various statistics.
- [r/PlexACD](https://www.removeddit.com/r/PlexACD/) - Discussion about unlimited cloud storage for Plex libraries.

### Plex Clients

- [go-plex-client](https://github.com/jrudio/go-plex-client) - A Plex.tv and Plex Media Server Go client.
- [PlexConnect](https://github.com/iBaa/PlexConnect) - Unofficial Plex app for Apple TV devices.
- [RasPlex](https://github.com/RasPlex/RasPlex) - Rasplex is a community driven port of Plex Home Theater for the Raspberry Pi.

## Kodi

- [Kodi](https://kodi.tv/) - An award-winning free and open-source home theater/media center software and entertainment hub for digital media.
- [Kodi setup guide](https://www.removeddit.com/r/Addons4Kodi/comments/93porc/requests_recommendations_basics_august_2018/e3f6i12/)
- [r/Addons4Kodi](https://www.removeddit.com/r/addons4kodi) - Discussion and links pertaining to unofficial addons for Kodi Media Center.
- [Burst](http://burst.surge.sh) - A torrent content provider to the Quasar plugin.
- [Elementum](https://elementum.surge.sh/) - Elementum addon is an addon for Kodi, that manages your virtual library, syncs with your Trakt account.
- [Exodus Redux](https://www.removeddit.com/r/Addons4Kodi/comments/9tasx5/requests_recommendations_basics_november_2018/e8uti6w) - The newest Exodus fork around, paired with LambdaScrapers.
- [Gaia](https://gaiakodi.com/) - Grants the ability to instantly watch high quality files via cached torrents from Real-Debrid or Premiumize.
- [kodi-headless](https://hub.docker.com/r/linuxserver/kodi-headless/) - A headless install of kodi in a docker container, most useful for a mysql setup of kodi to allow library updates to be sent without the need for a player system to be permanently on.
- [Official Plex Addon](https://forums.plex.tv/t/installation-instructions/168854) - Official Plex add-on for Kodi.
- [PlexKodiConnect](https://github.com/croneter/PlexKodiConnect) - Plex integration in Kodi done right.
- [Python-GoogleDrive-VideoStream](https://github.com/ddurdle/Python-GoogleDrive-VideoStream) - Provides service content delivered in Google Drive plugin for KODI through any HTML5 client.
- [Seren](https://www.removeddit.com/r/Addons4Kodi/comments/dt4kg2/recommended_addons_november_2019/f6ukyfr?utm_source=share&utm_medium=web2x) - Kodi addon which works with Premiumize and Real-Debrid to stream torrents with the appropriate provider package instantly.
- [Sparkle](https://github.com/iwannabelikemike/plugin.video.sparkle) - Kodi addon for finding acestream links.
- [Tooonmania2](https://github.com/doko-desuka/doko.repository/releases) - Lets you watch cartoons, dubbed anime and movies (from animetoon) - and subbed anime and movies (from animeplus).
- [tvtorrentorganizer](https://github.com/tvtorrentorganizer/tvtorrentorganizer) - Bash 4 Script to Organize TV Show Downloads for Kodi.
- [Ultimate Kodi Guide](https://www.removeddit.com/r/Piracy/comments/7wp42u/ultimate_guide_to_install_kodi_popular_streaming/) - ULTIMATE GUIDE TO INSTALL KODI + POPULAR STREAMING ADDONS by /u/giorgiomilan.
- [Yoda](http://supremacy.org.uk/zip/repo/) - Another solid Exodus/Covenant fork, and this time it's from S-media.
- [VShare](https://vshare.eu) - Allows all the kodi users to pair with this service, which allows users to share and stream their favorite videos.
- [Recommended Addons - November 2019](https://www.reddit.com/r/Addons4Kodi/comments/dt4kg2/recommended_addons_november_2019/) - Latest working Kodi addons compiled into one place.
- [Placenta](http://www.wirelesshack.org/how-to-install-placenta-Kodi-addon.html) - A Fork of Exodus / Covenant with more options and links from Mr. Blamo and Muad'Dib.
- [Plexus](http://fusion.tvaddons.co/) - Plexus is used in conjunction with Sparkle to play Ace Stream links.
- [Pneumatic](https://forum.kodi.tv/showthread.php?tid=97657) - Pneumatic is an NZB engine add-on for XBMC. It requires SABnzbd as a backbone.
- [Quasar](http://quasar.surge.sh) - The purpose of this plugin is to search and stream torrents in Kodi.

## Stremio

- [Stremio](https://www.stremio.com/) - Multi-platform video content aggregator with a comprehensive add-on system for extending the functionality.
- [Stremio Downloader](https://github.com/BurningSands70/stremio-downloader) - An application that allows you to download any stream from Stremio.
- [r/StremioAddons](https://www.removeddit.com/r/StremioAddons/) - Discussion and links on reddit to unofficial add-ons for Stremio.
- [A complete curated list of all working Stremio Add-ons provided (via Reddit)](https://www.removeddit.com/r/StremioAddons/comments/ahd6gk/sticky_stremio_addons_list/)
- [PimpMyStremio](https://github.com/sungshon/PimpMyStremio) - A local add-on manager for Stremio add-ons, adds tens of new (self-hosted, and much more powerful) - add-ons to Stremio.
- [RAR addon](https://rarbg.best4stremio.space/stremio/v1) - Watch content from RARBG in Stremio.
- [Stremio - Watch together with friends](https://www.removeddit.com/r/StremioAddons/comments/cvmu80/guide_stremio_how_to_watch_together/) - A guide explaining how to watch videos on Stremio remotely with friends, keeping the playback in sync.
- [Stremio - Phone Remote](https://www.removeddit.com/r/StremioAddons/comments/cuc3yo/news_phone_remote_for_stremio/) - A short guide explaining how to control Stremio with your phone.
- [Stremio Catalog Builder](https://www.removeddit.com/r/StremioAddons/comments/atizrk/news_stremio_catalog_builder/) - A small ebsite that allows users to customize catalogs in Stremio.
