---
title: Browser Extensions
sidebar_label: Browser Extensions
---

- [uBlock Origin](https://github.com/gorhill/uBlock) - An efficient blocker for Chromium and Firefox. Fast and lean.
- [Add-Art](https://add-art.org/) - Replaces ads with art.
- [uMatrix](https://github.com/gorhill/uMatrix) - Point and click matrix to filter net requests according to source, destination and type.
- [Decentraleyes](https://decentraleyes.org/) - Protects against tracking with a local CDN (Content Delivery Network) - emulation.
- [Privacy Badger](https://www.eff.org/privacybadger) - Privacy Badger blocks spying ads and invisible trackers.
- [HTTPS Everywhere](https://www.eff.org/https-everywhere) - HTTPS Everywhere is a Firefox, Chrome, and Opera extension that encrypts your communications with many major websites, making your browsing more secure.
- [Nano Adblocker](https://github.com/NanoAdblocker/NanoCore) - Just another adblocker based on uBlock Origin.
- [Nano Defender](https://jspenguin2017.github.io/uBlockProtector/) - An anti-Adblock defuser for Nano Adblocker and uBlock Origin.
- [TamperMonkey](https://chrome.google.com/webstore/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo?hl=en) - The world's most popular userscript manager.
- [WebRTC Network Limiter](https://chrome.google.com/webstore/detail/webrtc-network-limiter/npeicpdbkakmehahjeeohfdhnlpdklia?hl=en) - Configures how WebRTC's network traffic is routed by changing Chrome's privacy settings.
- [ScriptSafe](https://chrome.google.com/webstore/detail/scriptsafe/oiigbmnaadbkfbmpbfijlflahbdbdgdf?hl=en) - A browser extension that gives users control of the web and more secure browsing while emphasizing simplicity and intuitiveness.
- [NoScript](https://noscript.net/getit) - Allow active content to run only from sites you trust, and protect yourself against XSS and clickjacking attacks. Firefox only.
- [Universal Bypass](https://universal-bypass.org/) - Universal Bypass automatically skips annoying link shorteners.
- [Violentmonkey](https://violentmonkey.github.io/) - An open-source userscript manager.
- [Anti-Paywall](https://github.com/nextgens/anti-paywall) - A browser extension that maximizes the chances of bypassing paywalls.
- [Google unlocked](https://github.com/Ibit-to/google-unlocked) - Google Unlocked Chrome extension unlocks hidden google search results.
  - [Website](https://ibit.uno/)
- [Hide Fake Torrents on TPB](https://chrome.google.com/webstore/detail/hide-fake-torrents-on-tpb/fkdhkcpmifehkmadpldbbdadepgplcmo) - Hide fake torrents on TPB.
- [Reddit Enhancement Suite](http://redditenhancementsuite.com/) - Community-driven unofficial browser extension for reddit.
- [CanvasBlocker](https://github.com/kkapsner/CanvasBlocker) - Alters some JS APIs to prevent fingerprinting.
- [Canvas Fingerprint Blocker](https://github.com/joue-quroi/canvas-fingerprint-blocker) - Block HTML canvas element from being used for fingerprinting purposes.
- [Chameleon](https://addons.mozilla.org/en-US/firefox/addon/chameleon-ext/) - Spoof your Firefox browser profile. Includes a few privacy enhancing options.
- [ClearURLs](https://gitlab.com/KevinRoebert/ClearUrls) - Remove tracking fields from URLs.
- [CSS Exfil Protection](https://github.com/mlgualtieri/CSS-Exfil-Protection) - Fixes several holes regarding [CSS manipulation](https://www.mike-gualtieri.com/css-exfil-vulnerability-tester)
- [Decentraleyes](https://git.synz.io/Synzvato/decentraleyes) - Local emulation of Content Delivery Networks.
- [Enterprise Policy Generator](https://github.com/cadeyrn/enterprise-policy-generator) - A Firefox WebExtension for generating Enterprise Policies.
- [Header Editor](https://addons.mozilla.org/firefox/addon/header-editor/) - Protects you from e.g. ETag tracking, an alternative is [ETag Stoppa](https://addons.mozilla.org/firefox/addon/etag-stoppa/)
- [Replace zero-width characters with emojis](https://github.com/chpmrc/zero-width-chrome-extension) - Google Chrome extension that can detect attempts to fingerprint text using the ["zero-width character"](https://www.bleepingcomputer.com/news/security/google-chrome-extension-detects-zero-width-character-fingerprinting-attacks/) - technique.
- [Site Bleacher](https://github.com/wooque/site-bleacher) - Firefox/Chrome addon/extension which removes automatically cookies, local storages, IndexedDBs, service workers, cache storages, filesystems and webSQLs.
- [Smart Referer](https://gitlab.com/smart-referer/smart-referer) - Change your Browser referer.
- [Temporary Containers](https://addons.mozilla.org/en-US/firefox/addon/temporary-containers/) - Alternative to Firefox first party isolation.
- [Trace - Online Tracking Protection](https://absolutedouble.co.uk/trace/) - HTML5 Canvas protection for [Chrome](https://chrome.google.com/webstore/detail/trace/njkmjblmcfiobddjgebnoeldkjcplfjb) - & [Firefox](https://addons.mozilla.org/en-US/firefox/addon/absolutedouble-trace).
- [zero-width-chrome-extension](https://github.com/chpmrc/zero-width-chrome-extension) - Replace scary zero-width characters with funny emojis in Chrome to reduce the Browser fingerprint.
- [ScriptSafe](https://github.com/andryou/scriptsafe) - Similar to NoScript with some nice features.
- [MoreCAPTCHA](https://greasyfork.org/en/scripts/31088-morecaptcha) - Speeds up solving Google reCAPTCHA challenges by shortening transition effects and providing continuous selection ability.
- [Buster](https://github.com/dessant/buster) - Captcha solver extension for humans.
- [Media Reaper](https://sasrip.cf/) - Privacy 1st, Audio & Video Download.
- [Stream Recorder](https://www.hlsloader.com/) - Allows you to save videos delivered through HLS (HTTP Live Streaming) in mp4 format.
- [Video Downloader professional](https://chrome.google.com/webstore/detail/video-downloader-professi/bacakpdjpomjaelpkpkabmedhkoongbi) - Video Downloader professional - the fastest and easiest way to download any video from any website.
- [Flash Video Downloader](https://chrome.google.com/webstore/detail/flash-video-downloader/aiimdkdngfcipjohbjenkahhlhccpdbc) - Chrome Download extension for videos and flash videos from 99% of websites.
- [Stream Video Downloader](https://chrome.google.com/webstore/detail/stream-video-downloader/imkngaibigegepnlckfcbecjoilcjbhf) - Video downloader that really works with Streaming websites. Download Mp4 and audio formats.
- [Video Downloader PLUS](https://chrome.google.com/webstore/detail/video-downloader-plus/fhplmmllnpjjlncfjpbbpjadoeijkogc) - Downloads most popular media types from ANY website.
- [Video DownloadHelper](https://chrome.google.com/webstore/detail/video-downloadhelper/lmjnegcaeklhafolokijcfjliaokphfk) - The most complete Web video downloader ! The popular Video DownloadHelper Firefox extension is now available for Chrome.
- [Keyboard Privacy](https://chrome.google.com/webstore/detail/keyboard-privacy/aoeboeflhhnobfjkafamelopfeojdohk) - Prevents behavioral profiling by randomizing the rate at which characters reach the DOM.
- [AudioContext Fingerprint Defender](https://chrome.google.com/webstore/detail/audiocontext-fingerprint/pcbjiidheaempljdefbdplebgdgpjcbe?hl=en) - Defending against AudioContext fingerprinting by reporting a fake value.
- [Telegram Media Downloader](https://chrome.google.com/webstore/detail/telegram-media-downloader/ffhhcekaaamffjnapdckmnkllkmmpfnh) - Bypass the 1.5 GB download limit and scrape channels/groups.
- [netflix-1080p](https://github.com/truedread/netflix-1080p/) - Chrome extension to play Netflix in 5.1 and 1080p.

### Browser Extensions for YouTube

- [Iridium](https://github.com/ParticleCore/Iridium) - Iridium is an extension built to improve your experience with the new YouTube Material layout.
- [YouTube Skip intro (Chrome)](https://chrome.google.com/webstore/detail/youtube-skip-intro/pkfnooichbjhhoajcoffiggbckfbflbg) - Define the intro time to skip it each time you play a video on YouTube helpful when you watching a series or any many episodes shows.
- [YouTube: Age Verification Bypass](https://greasyfork.org/scripts/375525) - Watch restricted videos without having to log in.
- [Invidition](https://addons.mozilla.org/en-US/firefox/addon/invidition/) - Redirects YouTube and Twitter to their alternative ads-free, privacy-friendly, interfaces.

## Misc Browser Extensions

- [RSS Subscription Extension by Google](https://chrome.google.com/webstore/detail/rss-subscription-extensio/nlbjncdgjeocebhnmkbbbdekmmmcbfjd?hl=en) - Adds one-click subscription to your toolbar and brings back the posability to read RSS Feeds in Chrome.
- [Containerise](https://addons.mozilla.org/en-US/firefox/addon/containerise/) - Automatically open websites in a dedicated container. Simply add rules to map domain or subdomain to your container.
- [Image Search Options](https://saucenao.com/tools/) - Add search options to the right-click context menu.
- [MegaLinks & Snahp.it Forum Link Solver](https://github.com/samvk/snahp-it-forum-link-solver) - Simplify opening forum.snahp.it links.
- [Remote Torrent Adder](https://chrome.google.com/webstore/detail/remote-torrent-adder/oabphaconndgibllomdcjbfdghcmenci?hl=en) - Allows you to send torrent files from your browser to your remote or local Bittorrent client's web interface.
- [SABconnect++](https://github.com/gboudreau/sabconnectplusplus) - Chrome extension which adds one-click 'Send to SABnzbd' buttons to many popular NZB index sites.
- [Save To The Wayback Machine](https://chrome.google.com/webstore/detail/save-to-the-wayback-machi/eebpioaailbjojmdbmlpomfgijnlcemk) - Quickly save web pages to the Internet Archive's Wayback Machine.
- [Stylus](https://github.com/openstyles/stylus/) - Redesign your favorite websites with Stylus, an actively developed and community driven userstyles manager.
- [Onion Browser Button](https://chrome.google.com/webstore/detail/onion-browser-button/fockhhgebmfjljjmjhbdgibcmofjbpca?hl=en)
  - [source code](https://github.com/jeremy-jr-benthum/tor-button)
- [Save to the Wayback Machine](https://github.com/VerifiedJoseph/Save-to-the-Wayback-Machine) - Browser extension for quickly saving web pages to the Internet Archive's Wayback Machine.
- [Search by Image](https://github.com/dessant/search-by-image) - Enables you to initiate a reverse image search from the context menu or the browser toolbar, and supports more than 30 search engines.
- [2read](https://2read.net/) - Convert article in current tab to readable form and upload it to IPFS.
- [User-Agent Switcher](https://github.com/ray-lothian/UserAgent-Switcher) - A User-Agent spoofer browser extension that is highly configurable.
- [Simple Translate](https://github.com/sienori/simple-translate) - Quickly translate selected text on web page.
- [h264ify](https://github.com/erkserkserks/h264ify) - A Chrome extension that makes YouTube stream H.264 videos instead of VP8/VP9 videos.
- [SponsorBlock](https://sponsor.ajay.app/) - SponsorBlock is a crowdsourced browser extension to skip sponsor segments in YouTube videos.
