---
title: Maintaining Better Ratio
author: xuac
author_url: https://github.com/xuac
author_title: Admin
author_image_url: https://github.com/xuac.png
---

A good tracker requires you to upload or seed what you download so that the availability never goes down. There are many ways to keep a good ratio.

<!--truncate-->

### HOP ON EARLY

Once a torrent has a ratio of more seeders to leechers it can often be difficult to get a decent upload speed. Going through your tracker's recently uploaded list, try to find a torrent that has a high number of initial leechers (or possibly one that could be popular), start downloading and you should be uploading instantly.

This method is generally more effective with a fast internet connection or a seedbox as with a slower connection you may not be able to upload a substantial amount before it has an abundance of seeders

Note that this won't work if your tracker has a quarantine period or "waiting time" where new users are forced to wait a certain time before they're allowed to download files.

### PORT FORWARDING

Port forwarding is key to enabling other users to connect to you in order for you to upload. By forwarding ports you give easier access to the data that you have downloaded and connects you to your peers. Port forwarding is a simple process, but varies depending on your computers and routers settings.

Suggested ports range from 49152 to 65534 to avoid program issues and remember to change your torrent client's configuration to the forwarded port.

### CROSS SEEDING

Cross Seeding involves re-seeding already downloaded data. By either downloading an identical file from another source like a tracker that you already have a high ratio on) or obtaining it locally you can use already obtained data to seed to another identical torrent which only tracks upload bandwidth as nothing was effectively 'downloaded'.

Don't forget to check your tracker's rules, some forbid this method and may lead to a ban. Also, identical is key here, if it's not the same it won't be recognized and you won't be able to upload.

### USE A SEEDBOX

A Seedbox is a private dedicated server which is used for downloading and uploading data, using a remote torrent client. Seedboxes download and upload the data on their own servers, generally at speeds of 100Mbit/s or higher. By using Seedbox's in conjunction with early torrenting, the data will be downloaded at high-end speeds and uploaded tenfold. Data is then stored on the servers which can then be downloaded through an FTP server.

### CHECK YOUR TRACKER'S RULES

Getting a decent ratio isn't always hard or bandwidth consuming. By checking your trackers rules, you may find that some have a 'timing' rule. What this means is by staying on a torrent and attempting to seed you will after a certain amount of time be given the remaining upload data just for the dedication of staying on the torrent. Most high-end trackers have this or a similar feature so make sure to update yourself on the rules.

### THROTTLE

Throttling is the means in which you change the configuration of your torrent client to only download at the same speed you upload. This guarantees a ratio of greater than one is kept, but is only recommended if a decent internet connection is available or you are at risk of having your account disabled.

### PARTIAL DOWNLOADING

Partial downloading consists of downloading only a certain number of files from a multi-file torrent and uploading. By changing the priorities on the files located within a torrent, specified downloads can be 'skipped'. Doing so, only minimal amounts are downloaded and uploading is prioritized.

Be sure to check your torrents rules, as this method can get you a warning or even a ban.

### FREELEECH

Freeleech torrents can be found on most trackers. A torrent (or in cases entire sites) may be specified as 'freeleech' for a certain time, sometimes permanently, and any data downloaded does not count towards usage, but uploading does in most cases.

### CONCLUSION

It's really important to thoroughly go through your tracker's rules to make sure you don't get your account disabled or banned.
