#pragma once
//#include "../main/rdr2_main.hpp"

static std::map<uintptr_t, uintptr_t> nativehash_to_address_table = {
{0x4ede34fbadd967a6, 0x2a181c4 }, // WAIT
{0xe81651ad79516e48, 0x2a14840 }, // START_NEW_SCRIPT
{0xb8ba7f44df1575e1, 0x2a14878 }, // START_NEW_SCRIPT_WITH_ARGS
{0xeb1c67c3a5333a92, 0x2a148b4 }, // START_NEW_SCRIPT_WITH_NAME_HASH
{0xc4bb298bd441be78, 0x2a148dc }, // START_NEW_SCRIPT_WITH_NAME_HASH_AND_ARGS
{0x83666f9fb8febd4b, 0x2a14678 }, // TIMERA
{0xc9d9444186b5a374, 0x2a1468c }, // TIMERB
{0xc1b1e9a034a63a62, 0x2a145d0 }, // SETTIMERA
{0x5ae11bc36633de4e, 0x2a145e8 }, // SETTIMERB
{0x50597ee2, 0x2a146a0 }, // TIMESTEP
{0xbadbfa3b172435f, 0x2a1463c }, // SIN
{0xd0ffb162f40a139c, 0x2a144f4 }, // COS
{0x71d93b57d07f9804, 0x2a14668 }, // SQRT
{0xe3621cc40f31fe2e, 0x2a14560 }, // POW
{0x652d2eeef1d3e62c, 0x2a14778 }, // VMAG
{0xa8ceacb4f35ae058, 0x2a14748 }, // VMAG2
{0x2a488c176d52cca5, 0x2a14704 }, // VDIST
{0xb7a628320eff8e47, 0x2a146c4 }, // VDIST2
{0xedd95a39e5544de8, 0x2a14614 }, // SHIFT_LEFT
{0x97ef1e5bce9dc075, 0x2a14628 }, // SHIFT_RIGHT
{0xf34ee736cf047844, 0x2a14520 }, // FLOOR
{0x11e019c8f43acc8a, 0x2a144b0 }, // CEIL
{0xf2db717a73826179, 0x2a14588 }, // ROUND
{0xbbda792448db5a89, 0x2a146b0 }, // TO_FLOAT
{0x42b65deef2edf2a1, 0x2a14600 }, // _SET_THREAD_PRIORITY
{0xd2c91a0b572aae56, 0xf28c78 }, // CREATE_NEW_SCRIPTED_CONVERSATION
{0x95d9f4bc443956e7, 0xf27798 }, // ADD_PED_TO_CONVERSATION
{0x6b17c62c9635d2dc, 0xf2f104 }, // START_SCRIPT_CONVERSATION
{0x3b3cad6166916d87, 0xf2d278 }, // PRELOAD_SCRIPT_CONVERSATION
{0x23641afe870af385, 0xf2f080 }, // START_PRELOADED_CONVERSATION
{0xdf0d54be7a776737, 0xf2c60c }, // IS_SCRIPTED_CONVERSATION_LOADED
{0x480357ee890c295a, 0xf2adc0 }, // GET_CURRENT_SCRIPTED_CONVERSATION_LINE
{0x8530ad776cd72b12, 0xf2cdfc }, // PAUSE_SCRIPTED_CONVERSATION
{0x9aeb285d1818c9ac, 0xf2d780 }, // RESTART_SCRIPTED_CONVERSATION
{0xd79deefb53455eba, 0xf2f34c }, // STOP_SCRIPTED_CONVERSATION
{0x9663fe6b7a61eb00, 0xf2ef64 }, // SKIP_TO_NEXT_SCRIPTED_CONVERSATION_LINE
{0xc6ed9d5092438d91, 0xf0498 }, // REGISTER_SCRIPT_WITH_AUDIO
{0xa8638be228d4751a, 0xf0498 }, // UNREGISTER_SCRIPT_WITH_AUDIO
{0x2f844a8b08d76685, 0xf2d6d0 }, // REQUEST_SCRIPT_AUDIO_BANK
{0x77ed170667f50170, 0xf2d468 }, // RELEASE_NAMED_SCRIPT_AUDIO_BANK
{0x7a2d8ad0a9eb9c3f, 0xf2d47c }, // RELEASE_SCRIPT_AUDIO_BANK
{0x430386fe9bf80b45, 0xf2b490 }, // GET_SOUND_ID
{0x353fc880830b88fa, 0xf2d4bc }, // RELEASE_SOUND_ID
{0x7ff4944cc209192d, 0xf2d080 }, // PLAY_SOUND
{0x67c540aa08e4a6f5, 0xf2d15c }, // PLAY_SOUND_FRONTEND
{0x8e04fedd28d42462, 0xf2d000 }, // _PLAY_AMBIENT_SPEECH1
{0xed640017ed337e45, 0xf2cfdc }, // _PLAY_AMBIENT_SPEECH_AT_COORDS
{0xbc9ae166038a5cec, 0xf2cf44 }, // PLAY_PAIN
{0x6c8065a3b780185b, 0xf2d82c }, // SET_AMBIENT_VOICE_NAME
{0x79d2f0e66f81d90d, 0xf2f240 }, // STOP_CURRENT_PLAYING_SPEECH
{0xb8bec0ca6f0edb0f, 0xf2f230 }, // STOP_CURRENT_PLAYING_AMBIENT_SPEECH
{0x9072c8b49907bfad, 0xf2b79c }, // IS_AMBIENT_SPEECH_PLAYING
{0xcc9aa18dcc7084f4, 0xf2c690 }, // IS_SCRIPTED_SPEECH_PLAYING
{0x729072355fa39ec9, 0xf2bb98 }, // IS_ANY_SPEECH_PLAYING
{0x49b99bf3fda89a7a, 0xf2a38c }, // _CAN_PED_SPEAK
{0x49e937f18f4020c, 0xf2c418 }, // IS_PED_IN_CURRENT_CONVERSATION
{0x95d2d383d5396b8a, 0xf2ea04 }, // SET_PED_IS_DRUNK
{0xee066c7006c49c0a, 0xf2ce94 }, // PLAY_ANIMAL_VOCALIZATION
{0xc265df9fb44a9fbd, 0xf2b7c8 }, // IS_ANIMAL_VOCALIZATION_PLAYING
{0xcc97b29285b1dc3b, 0xf2d908 }, // SET_ANIMAL_MOOD
{0x399d2d3b33f1b8eb, 0xf2ecb8 }, // SET_STATIC_EMITTER_ENABLED
{0xcd536c4d33dcc900, 0xf2cf18 }, // PLAY_END_CREDITS_MUSIC
{0xbda07e5950085e46, 0xf2d8d0 }, // SET_AMBIENT_ZONE_STATE
{0x218dd44aaac964ff, 0xf2841c }, // CLEAR_AMBIENT_ZONE_STATE
{0x9748fa4de50cce3e, 0xf2d884 }, // SET_AMBIENT_ZONE_LIST_STATE
{0x120c48c614909fa4, 0xf28408 }, // CLEAR_AMBIENT_ZONE_LIST_STATE
{0x1d6650420cec9d3b, 0xf2d8ec }, // SET_AMBIENT_ZONE_STATE_PERSISTENT
{0xf3638dae8c4045e1, 0xf2d8a0 }, // SET_AMBIENT_ZONE_LIST_STATE_PERSISTENT
{0x9d6bfc12b05c6121, 0xf2c27c }, // IS_HORN_ACTIVE
{0xd11fa52eb849d978, 0xf2c764 }, // IS_STREAM_PLAYING
{0x1f1f957154ec51df, 0xf2c868 }, // LOAD_STREAM
{0x89049dd63c08b5d1, 0xf2d1fc }, // PLAY_STREAM_FROM_PED
{0x58fce43488f9f5f4, 0xf2d218 }, // PLAY_STREAM_FRONTEND
{0x21442f412e8de56b, 0xf2d20c }, // PLAY_STREAM_FROM_POSITION
{0xa4718a1419d18151, 0xf2f3e8 }, // STOP_STREAM
{0x9d64d7405520e3d3, 0xf2f2a4 }, // STOP_PED_SPEAKING
{0xa9a41c1e940fb0e8, 0xf2a1f4 }, // DISABLE_PED_PAIN_AUDIO
{0x932c2d096a2c3fff, 0xf2b770 }, // IS_AMBIENT_SPEECH_DISABLED
{0x76d683c108594d0e, 0xf2e7e8 }, // SET_HORN_ENABLED
{0xe5564483e407f914, 0xf2dc74 }, // SET_AUDIO_VEHICLE_PRIORITY
{0x4f0c413926060b38, 0xf2a854 }, // _FORCE_VEHICLE_ENGINE_AUDIO
{0x3bd3f52ba9b1e4e8, 0xf0498 }, // SET_GPS_ACTIVE
{0x13a80fc08f6e4f2, 0xf2efa8 }, // START_AUDIO_SCENE
{0xdfe8422b3b94e688, 0xf2f178 }, // STOP_AUDIO_SCENE
{0xbac7fc81a75ec1a1, 0xf2f1a4 }, // STOP_AUDIO_SCENES
{0xb65b60556e2a9225, 0xf2bc2c }, // IS_AUDIO_SCENE_ACTIVE
{0xef21a9ef089a2668, 0xf2dc44 }, // SET_AUDIO_SCENE_VARIABLE
{0x153973ab99fe8980, 0xf27728 }, // ADD_ENTITY_TO_AUDIO_MIX_GROUP
{0x18eb48cfc41f2ea0, 0xf2d53c }, // REMOVE_ENTITY_FROM_AUDIO_MIX_GROUP
{0x845ffc3a4feefa3e, 0xf279e0 }, // AUDIO_IS_SCRIPTED_MUSIC_PLAYING
{0x1e5185b72ef5158a, 0xf2d2bc }, // PREPARE_MUSIC_EVENT
{0x5b17a90291133da5, 0xf282b0 }, // CANCEL_MUSIC_EVENT
{0x706d57b0f50da710, 0xf2f4a4 }, // TRIGGER_MUSIC_EVENT
{0xe7a0d23dc414507b, 0xf2b234 }, // GET_MUSIC_PLAYTIME
{0xb9efd5c25018725a, 0xf2dbe4 }, // SET_AUDIO_FLAG
{0x44dbad7a7fa2be5, 0xf2ebd4 }, // SET_PORTAL_SETTINGS_OVERRIDE
{0xb4bbfd9cd8b3922b, 0xf2d54c }, // REMOVE_PORTAL_SETTINGS_OVERRIDE
{0x16af9b4eeac3b305, 0xf2d3f0 }, // REGISTER_OBJECT_SCRIPT_BRAIN
{0x1cf6e5c6750eadbd, 0xf2a490 }, // ENABLE_SCRIPT_BRAIN_SET
{0x3f44ea613a5b2676, 0xf2a258 }, // DISABLE_SCRIPT_BRAIN_SET
{0x33281167e4942e4f, 0xf2d558 }, // RENDER_SCRIPT_CAMS
{0x8c7c7ff7cf0e5153, 0xf2f300 }, // _RENDER_FIRST_PERSON_CAM
{0xe72cdba7f0a02dd6, 0xf28b80 }, // CREATE_CAM
{0x40c23491ce83708e, 0xf28c14 }, // CREATE_CAM_WITH_PARAMS
{0x57cdf879ea466c46, 0xf28ba8 }, // CREATE_CAMERA
{0x98b99b9f27e2d60b, 0xf28bd0 }, // CREATE_CAMERA_WITH_PARAMS
{0x4e67e0b6d7fd5145, 0xf2a008 }, // DESTROY_CAM
{0x163600d6e136c9f8, 0xf29ff8 }, // DESTROY_ALL_CAMS
{0x153ad457764fd704, 0xf2a308 }, // DOES_CAM_EXIST
{0x87295bca613800c8, 0xf2dc9c }, // SET_CAM_ACTIVE
{0x63efcc7e1810b8e6, 0xf2bd40 }, // IS_CAM_ACTIVE
{0x4415f8a6c536d39f, 0xf2bd88 }, // IS_CAM_RENDERING
{0x3a8931ecc8015d6, 0xf2b408 }, // GET_RENDERING_CAM
{0x6b12f11c2a9f0344, 0xf2abf0 }, // GET_CAM_COORD
{0x9bf96b57254e7889, 0xf2ac5c }, // GET_CAM_ROT
{0x8101d32a0a6b0f60, 0xf2ac38 }, // GET_CAM_FOV
{0xa47bbfffb83d4d0a, 0xf2dd74 }, // SET_CAM_PARAMS
{0xf9ee7d419ee49de6, 0xf2dd04 }, // SET_CAM_COORD
{0x63dfa6810ad78719, 0xf2ddd4 }, // SET_CAM_ROT
{0x27666e5988d9d429, 0xf2dd44 }, // SET_CAM_FOV
{0xa924028272a61364, 0xf2dd64 }, // SET_CAM_NEAR_CLIP
{0x5e32817bf6302111, 0xf2dd24 }, // SET_CAM_FAR_CLIP
{0x45fd891364181f9e, 0xf2dd54 }, // SET_CAM_MOTION_BLUR_STRENGTH
{0xfdc0df7f6fb0a592, 0xf27934 }, // ATTACH_CAM_TO_ENTITY
{0xdfc1e4a44c0324ca, 0xf27950 }, // ATTACH_CAM_TO_PED_BONE
{0x5b41ddbeb559556, 0xf2a034 }, // DETACH_CAM
{0x948b39341c3a40c2, 0xf2d24c }, // POINT_CAM_AT_COORD
{0xfc2867e6074d3a61, 0xf2d25c }, // POINT_CAM_AT_ENTITY
{0xca1b30a3357c71f1, 0xf2f1f0 }, // STOP_CAM_POINTING
{0x3cb9e8bde5e76f33, 0xf2dcdc }, // SET_CAM_AFFECTS_AIMING
{0xf1f57f9d230f9cd1, 0xf2767c }, // ADD_CAM_SPLINE_NODE
{0xf1898a68e7c15636, 0xf2ddf8 }, // SET_CAM_SPLINE_PHASE
{0x95edcd24d90033a, 0xf2aca8 }, // GET_CAM_SPLINE_PHASE
{0xff6311652ca91015, 0xf2dde8 }, // SET_CAM_SPLINE_DURATION
{0x84b3645618e726b0, 0xf2de08 }, // SET_CAM_SPLINE_SMOOTHING_STYLE
{0x8b15ae2987c1ac8f, 0xf2dcb0 }, // SET_CAM_ACTIVE_WITH_INTERP
{0x578f8f1caa17bd2b, 0xf2bd64 }, // IS_CAM_INTERPOLATING
{0xf9a7bcf5d050d4e7, 0xf2ef04 }, // SHAKE_CAM
{0x2eeb402bd7320159, 0xf2bdac }, // IS_CAM_SHAKING
{0xb78cc4b4706614b0, 0xf2f1fc }, // STOP_CAM_SHAKING
{0xa263ddf694d563f6, 0xf2cecc }, // PLAY_CAM_ANIM
{0xf5472c80df2ff847, 0xf2c560 }, // IS_SCREEN_FADED_OUT
{0x37f9a426fbcf4af2, 0xf2c544 }, // IS_SCREEN_FADED_IN
{0x2f39befe7b88d00, 0xf2c598 }, // IS_SCREEN_FADING_OUT
{0xceccc63ffa2ef24, 0xf2c57c }, // IS_SCREEN_FADING_IN
{0x6a053cf596f67df7, 0xf2a3f8 }, // DO_SCREEN_FADE_IN
{0x40c719a5e410b9e4, 0xf2a404 }, // DO_SCREEN_FADE_OUT
{0xd7f4d54cf80afa34, 0xf2eee8 }, // SET_WIDESCREEN_BORDERS
{0x595320200b98596e, 0xf2af4c }, // GET_GAMEPLAY_CAM_COORD
{0x252d2b5582957a6, 0xf2b008 }, // GET_GAMEPLAY_CAM_ROT
{0xf6a96e5aceec6e50, 0xf2af90 }, // GET_GAMEPLAY_CAM_FOV
{0xc4abf536048998aa, 0xf2afb0 }, // GET_GAMEPLAY_CAM_RELATIVE_HEADING
{0x5d1eb123eac5d071, 0xf2e5ac }, // SET_GAMEPLAY_CAM_RELATIVE_HEADING
{0x99aadebba803f827, 0xf2afdc }, // GET_GAMEPLAY_CAM_RELATIVE_PITCH
{0xfb760af4f537b8bf, 0xf2e5c0 }, // SET_GAMEPLAY_CAM_RELATIVE_PITCH
{0xd9b31b4650520529, 0xf2ef18 }, // SHAKE_GAMEPLAY_CAM
{0xea4c5f4aa0a4dbef, 0xf2c218 }, // IS_GAMEPLAY_CAM_SHAKING
{0x570e35f5c4a44838, 0xf2e5d4 }, // SET_GAMEPLAY_CAM_SHAKE_AMPLITUDE
{0xe0de43d290fb65f9, 0xf2f258 }, // STOP_GAMEPLAY_CAM_SHAKING
{0x8660ea714834e412, 0xf2c1f4 }, // IS_GAMEPLAY_CAM_RENDERING
{0x8fe0d24ffd04d5a2, 0xf2c1d0 }, // IS_GAMEPLAY_CAM_LOOKING_BEHIND
{0x2e941b5ffa2989c6, 0xf2c73c }, // IS_SPHERE_VISIBLE
{0x14f3947318ca8ad2, 0xf2ed28 }, // _CLAMP_GAMEPLAY_CAM_YAW
{0x326c7aa308f3df6a, 0xf2ed3c }, // _CLAMP_GAMEPLAY_CAM_PITCH
{0x2126c740a4ac370b, 0xf2ed14 }, // _ANIMATE_GAMEPLAY_CAM_ZOOM
{0x9c473089a934c930, 0xf2a1d4 }, // _DISABLE_FIRST_PERSON_CAM_THIS_FRAME
{0xa40c2f51fb589e9a, 0xf2c1a4 }, // IS_FOLLOW_VEHICLE_CAM_ACTIVE
{0xf63134c54b6ec212, 0xf2c148 }, // IS_FIRST_PERSON_AIM_CAM_ACTIVE
{0xb4132ca1b0ee1365, 0xf2af3c }, // _GET_GAMEPLAY_CAM_ZOOM
{0x715b7f5e8bed32a2, 0xf2e3cc }, // _SET_FIRST_PERSON_CAM_PITCH_RANGE
{0x5352e025ec2b416f, 0xf2aea0 }, // _GET_GAMEPLAY_CAM_COORDS
{0x602685bd85dd26ca, 0xf2aef4 }, // _GET_GAMEPLAY_CAM_ROT
{0xfa33b8c69a4a6a0f, 0xf2e604 }, // SET_GAMEPLAY_COORD_HINT
{0x90fb951648851733, 0xf2e764 }, // SET_GAMEPLAY_PED_HINT
{0xe2b2bb7dac280515, 0xf2e7b0 }, // SET_GAMEPLAY_VEHICLE_HINT
{0xc40551d65f2bf297, 0xf2e72c }, // SET_GAMEPLAY_OBJECT_HINT
{0xd1f7f32640adfd12, 0xf2e628 }, // SET_GAMEPLAY_ENTITY_HINT
{0x2e04ab5fee042d4a, 0xf2c23c }, // IS_GAMEPLAY_HINT_ACTIVE
{0x1bcec33d54cfca8a, 0xf2f210 }, // STOP_GAMEPLAY_HINT
{0x661e58bc6f00a49a, 0xf2e6fc }, // SET_GAMEPLAY_HINT_FOV
{0xb90411f480457a6c, 0xf2de18 }, // SET_CINEMATIC_BUTTON_ACTIVE
{0xbf7c780731aadbf8, 0xf2bdd0 }, // IS_CINEMATIC_CAM_RENDERING
{0xa5929c2e57ac90d1, 0xf2a15c }, // _DISABLE_VEHICLE_FIRST_PERSON_CAM_THIS_FRAME
{0xce7a90b160f75046, 0xf2de44 }, // SET_CINEMATIC_MODE_ACTIVE
{0x3a52c59ffb2deed8, 0xf2deb8 }, // SET_CLOCK_TIME
{0x4d1a590c92bf377e, 0xf2cd68 }, // PAUSE_CLOCK
{0x184750ae88d0b1d, 0xf27820 }, // ADVANCE_CLOCK_TIME_TO
{0xab7c251c7701d336, 0xf277e0 }, // ADD_TO_CLOCK_TIME
{0xc82cf208c2b19199, 0xf2ad34 }, // GET_CLOCK_HOURS
{0x4e162231b823dbbf, 0xf2ad40 }, // GET_CLOCK_MINUTES
{0xb6101abe62b5f080, 0xf2ad58 }, // GET_CLOCK_SECONDS
{0x2ad3092562941e2, 0xf2de78 }, // SET_CLOCK_DATE
{0x4dd02d4c7fb30076, 0xf2ad28 }, // GET_CLOCK_DAY_OF_WEEK
{0xdf2fd796c54480a5, 0xf2ad1c }, // GET_CLOCK_DAY_OF_MONTH
{0x2d44e8fc79eab1ac, 0xf2ad4c }, // GET_CLOCK_MONTH
{0xe136dca28c4a48ba, 0xf2ad64 }, // GET_CLOCK_YEAR
{0xe4cb8d126501ec52, 0xf2b228 }, // GET_MILLISECONDS_PER_GAME_MINUTE
{0x90338ad4a784e455, 0xf2b3c8 }, // GET_POSIX_TIME
{0x579cced0265d4896, 0xf28ee4 }, // NETWORK_CLAN_SERVICE_IS_VALID
{0xb124b57f571d8f18, 0xf28e90 }, // NETWORK_CLAN_PLAYER_IS_ACTIVE
{0xeee6eacbe8874fba, 0xf28e64 }, // NETWORK_CLAN_PLAYER_GET_DESC
{0x1f471b79acc90bef, 0xf28d10 }, // _NETWORK_CLAN_GET_NUM_MEMBERSHIP_DESC
{0x48de78af2c8885b8, 0xf28d34 }, // NETWORK_CLAN_GET_MEMBERSHIP_DESC
{0x9aa46badad0e27ed, 0xf28da8 }, // NETWORK_GET_PRIMARY_CLAN_DATA_CLEAR
{0xce86d8191b762107, 0xf28ddc }, // NETWORK_GET_PRIMARY_CLAN_DATA_START
{0xb5074db804e28ce7, 0xf28dc8 }, // NETWORK_GET_PRIMARY_CLAN_DATA_PENDING
{0x5b4f04f19376a0ba, 0xf28e04 }, // NETWORK_GET_PRIMARY_CLAN_DATA_SUCCESS
{0xc080ff658b2e41da, 0xf28d80 }, // NETWORK_GET_PRIMARY_CLAN_DATA_NEW
{0xc827d175f1292f2, 0xf29564 }, // _GET_DATA_CONTAINER_FROM_PATH
{0xc827d175f1292f3, 0xf29540 }, // _GET_DATA_CONTAINER_FROM_CHILD_INDEX
{0xc827d175f1292f4, 0xf291fc }, // _ADD_DATA_CONTAINER_FROM_PATH
{0x98bb14345bb68257, 0xf291c8 }, // _ADD_DATA_CONTAINER_BY_HASH
{0xeb4f9a3537eeabcd, 0xf291a4 }, // _ADD_DATA_CONTAINER
{0x37bb86a751148a6a, 0xf29178 }, // _ADD_DATA_BOOL_FROM_PATH
{0xbc95d3ae2eca70d6, 0xf29138 }, // _ADD_DATA_BOOL_BY_HASH
{0x58baa5f635da2ff4, 0xf2910c }, // _ADD_DATA_BOOL
{0x267f9527f4350ade, 0xf2938c }, // _ADD_DATA_INT_BY_HASH
{0x307a3247c5457bde, 0xf29340 }, // _ADD_DATA_INT
{0x5154228273adb9a6, 0xf29244 }, // _ADD_DATA_FLOAT
{0x8e173dfb041993c6, 0xf29308 }, // _ADD_DATA_HASH_BY_HASH
{0x8538f1205d60eca6, 0xf292bc }, // _ADD_DATA_HASH
{0xead09e76e22630c3, 0xf29438 }, // _ADD_DATA_STRING_BY_HASH
{0x617fca1c5652bbad, 0xf293ec }, // _ADD_DATA_STRING
{0x7d0f2014db28dd00, 0xf29294 }, // _ADD_DATA_GANG_ID
{0xdb5b9a474148f699, 0xf294f0 }, // _ADD_UI_ITEM_LIST_FROM_PATH
{0x3c7799283325181b, 0xf294bc }, // _ADD_UI_ITEM_LIST_BY_HASH
{0xfe74fa57e0ce6824, 0xf29498 }, // _ADD_UI_ITEM_LIST
{0x5859e970794d92f3, 0xf29610 }, // _INSERT_UI_ITEM_TO_LIST_FROM_CONTEXT_STRING_ALIAS
{0xee97a05c05f16e41, 0xf295e4 }, // _INSERT_UI_ITEM_TO_LIST_FROM_CONTEXT_HASH_ALIAS
{0x5740774f608e4fc8, 0xf29628 }, // _INSERT_UI_ITEM_TO_LIST_FROM_PATH_STRING_ALIAS
{0xf68b1726eaf7b285, 0xf298cc }, // _REMOVE_BINDING_ARRAY_ITEM_BY_DATA_CONTEXT_ID
{0xa1f15c1d03df802d, 0xf29514 }, // _CLEAR_BINDING_ARRAY
{0xe96d7f9fefcc105f, 0xf29584 }, // _GET_ITEM_CONTEXT_BY_INDEX
{0xfe74fa57e0ce6825, 0xf29904 }, // _SET_TEMPLATED_UI_ITEM_LIST_SIZE
{0xae7138d0541f2de, 0xf298dc }, // _SET_TEMPLATED_UI_ITEM_HASH_ALIAS
{0x52f5f08278ea5d75, 0xf292e4 }, // _ADD_HASH_ARRAY
{0x1b23e0627bdbfe85, 0xf29414 }, // _ADD_STRING_ARRAY
{0xd23f5de04fe717e2, 0xf29520 }, // _GET_ARRAY_COUNT
{0xab888b4b91046771, 0xf511d8 }, // _WRITE_DATA_SCRIPT_VARIABLES
{0xab888b4b91046770, 0xf29914 }, // _WRITE_DATA_BOOL
{0xbdfe546e4c2d0e21, 0xf29930 }, // _WRITE_DATA_BOOL_FROM_PARENT
{0x335c3f6b3766b8d9, 0xf299c8 }, // _WRITE_DATA_INT
{0x9efa98238ba08fc4, 0xf299e0 }, // _WRITE_DATA_INT_FROM_PARENT
{0x9d6e10a41d6ed6ec, 0xf299f4 }, // _WRITE_DATA_INT_FROM_PARENT_BY_HASH
{0xdf504beceb15da93, 0xf29978 }, // _WRITE_DATA_FLOAT
{0xacdef586bd71b1fd, 0xf299c8 }, // _WRITE_DATA_HASH_STRING
{0x971f04e1eaa7ae8, 0xf299e0 }, // _WRITE_DATA_HASH_STRING_FROM_PARENT
{0x20209529689e0953, 0xf299f4 }, // _WRITE_DATA_HASH_STRING_FROM_PARENT_BY_HASH
{0xe1bd342f2872aee9, 0xf29a34 }, // _WRITE_DATA_STRING
{0x4ff713b2f17a391e, 0xf29a4c }, // _WRITE_DATA_STRING_FROM_PARENT
{0x5eefbd4b6d7cd6eb, 0xf29670 }, // _READ_DATA_BOOL
{0xa8ede09fe07bd77f, 0xf296a8 }, // _READ_DATA_BOOL_FROM_PARENT
{0x4cdc3fddfae07eb3, 0xf296d0 }, // _READ_DATA_BOOL_FROM_PARENT_BY_HASH
{0x570784d782597512, 0xf29748 }, // _READ_DATA_INT
{0xffc566a4801f6b40, 0xf297a0 }, // _READ_DATA_INT_FROM_PARENT
{0xb5f668b648ec0970, 0xf297c4 }, // _READ_DATA_INT_FROM_PARENT_BY_HASH
{0x9b535990b01b62de, 0xf297a0 }, // _READ_DATA_HASH_STRING_FROM_PARENT
{0x1f43bc25a119b252, 0xf297c4 }, // _READ_DATA_HASH_STRING_FROM_PARENT_BY_HASH
{0x3d290b5ffa7c5151, 0xf297fc }, // _READ_DATA_STRING
{0x6323ad277c4a2afb, 0xf2981c }, // _READ_DATA_STRING_FROM_PARENT
{0x1e7130793aaaab8d, 0xf29640 }, // _IS_DATA_ID_VALID
{0xae9938d0541f2da, 0xf298a8 }, // _REMOVE_DATA_ENTRY
{0x9dce9b01a93b58bc, 0xf2f600 }, // _VIRTUAL_COLLECTION_SET_SIZE
{0x49a8447533308bcf, 0xf2f5f0 }, // _VIRTUAL_COLLECTION_SET_INTEREST_INDEX
{0x6dcbf187221cf73d, 0xf2f5cc }, // _VIRTUAL_COLLECTION_ADD_ITEM
{0x9d95666ed2b5f60, 0xf2f5e4 }, // _VIRTUAL_COLLECTION_RESET
{0x37963b56755bfb35, 0xf2f5a8 }, // _DOES_VIRTUAL_COLLECTION_EXIST
{0xa5834834ca8fd7fc, 0xf29d40 }, // DATAFILE_WATCH_REQUEST_ID
{0x56b7291fb953dd51, 0xf29c48 }, // DATAFILE_CREATE
{0x9fb90eedea9f2d5c, 0xf29c54 }, // DATAFILE_DELETE
{0xbbd8cf823cae557c, 0xf29c84 }, // DATAFILE_GET_FILE_DICT
{0x26fdf5e99aa2f3e9, 0xf29c34 }, // _OBJECT_VALUE_ADD_INTEGER
{0x175e915a486ee548, 0xf29ad8 }, // _OBJECT_VALUE_GET_BOOLEAN
{0x9d896a3b87d96e2b, 0xf29b58 }, // _OBJECT_VALUE_GET_INTEGER
{0x814643eca258adf5, 0xf29b2c }, // _OBJECT_VALUE_GET_FLOAT
{0xe37b38c0b4e95dfa, 0xf29b80 }, // _OBJECT_VALUE_GET_STRING
{0xe459c941431e0ffa, 0xf29bd0 }, // _OBJECT_VALUE_GET_VECTOR3
{0x4d7a30130f46ac9c, 0xf29b04 }, // _OBJECT_VALUE_GET_OBJECT
{0x1b5447cf18544b18, 0xf29ab0 }, // _OBJECT_VALUE_GET_ARRAY
{0x92e11e3ca4c7cdf0, 0xf29bac }, // _OBJECT_VALUE_GET_TYPE
{0xab1231d2de52f2d3, 0xf28f40 }, // _ARRAY_VALUE_GET_BOOLEAN
{0x96dea500b6ebbe53, 0xf28fdc }, // _ARRAY_VALUE_GET_INTEGER
{0xa9d003cf419cb81e, 0xf28fb4 }, // _ARRAY_VALUE_GET_FLOAT
{0xb6790a8ff80f889f, 0xf29004 }, // _ARRAY_VALUE_GET_STRING
{0x850da2750da14e9a, 0xf29054 }, // _ARRAY_VALUE_GET_VECTOR3
{0xa010655985853485, 0xf28f90 }, // _ARRAY_VALUE_GET_OBJECT
{0x6a885bf69239e539, 0xf28f6c }, // _ARRAY_VALUE_GET_SIZE
{0x151dafe6b3b9888f, 0xf29030 }, // _ARRAY_VALUE_GET_TYPE
{0x129567f0c05f81b9, 0xf2cd2c }, // _DATAFILE_UNLOAD
{0xae156a747c39a741, 0xf2cbc4 }, // _DATAFILE_REGISTER_QUERY
{0x83c3ed532b6e5d07, 0xf2cc78 }, // _DATAFILE_GET_DATA_NODE_INDEX
{0xdf01b1f7a886b42d, 0xf2cd0c }, // _DATAFILE_GET_NUM_NODES
{0x6beb168d5195e7ab, 0xf2caec }, // _DATAFILE_GET_NUM_CHILDREN
{0xfbff3ff2f5e80c0b, 0xf2cc28 }, // _DATAFILE_GET_HASH
{0x8eaf8e9f2eb7b2e, 0xf2cca0 }, // _DATAFILE_GET_STRING
{0x6fbf89b12da279c, 0xf2ccc8 }, // _DATAFILE_GET_VECTOR
{0x7f034fc3e891b57a, 0xf2cc00 }, // _DATAFILE_GET_FLOAT
{0xef44acc657352a35, 0xf2cc50 }, // _DATAFILE_GET_INT
{0xd9138f3f8261df7, 0xf2cbd8 }, // _DATAFILE_GET_BOOL
{0xfe26e4609b1c3772, 0xf29ef4 }, // DECOR_SET_BOOL
{0x238f8b0c1c7fe834, 0xf29f24 }, // DECOR_SET_FLOAT
{0xe88f4d7f52a6090f, 0xf29f50 }, // DECOR_SET_INT
{0xdef3f1b071abb197, 0xf29dac }, // DECOR_GET_BOOL
{0xe5ff70cd842ca9d4, 0xf29dd4 }, // DECOR_GET_FLOAT
{0x44db62727762fd9b, 0xf29dfc }, // DECOR_GET_INT
{0xd9d1cdbf3464dcdf, 0xf29d84 }, // DECOR_EXIST_ON
{0x2ba7f5877a088a1d, 0xf29e98 }, // DECOR_REMOVE
{0xb253d644e3c36b3, 0xf29e6c }, // DECOR_REGISTER
{0x72355278c069f272, 0xf29e44 }, // DECOR_IS_REGISTERED_AS_TYPE
{0x2763dc12bbe2bb6f, 0xf2bef4 }, // IS_DLC_PRESENT
{0x71d4bf5890659b0c, 0xf2b098 }, // GET_IS_LOADING_SCREEN_ACTIVE
{0xd42bd6eb2e0f1677, 0xf540e4 }, // DOES_ENTITY_EXIST
{0x622b1980cbe13332, 0xf540b8 }, // DOES_ENTITY_BELONG_TO_THIS_SCRIPT
{0x20487f0da9af164a, 0xf54138 }, // DOES_ENTITY_HAVE_DRAWABLE
{0xa512b3f1b2a0b51c, 0xf54178 }, // DOES_ENTITY_HAVE_PHYSICS
{0x73bb763880cd23a6, 0xf55a0c }, // HAS_ENTITY_BEEN_DAMAGED_BY_ANY_OBJECT
{0x9934e9c42d52d87e, 0xf55a30 }, // HAS_ENTITY_BEEN_DAMAGED_BY_ANY_PED
{0x695d7c26de65c423, 0xf55a54 }, // HAS_ENTITY_BEEN_DAMAGED_BY_ANY_VEHICLE
{0x7b6e7bec1143ac86, 0xf55a78 }, // HAS_ENTITY_BEEN_DAMAGED_BY_ENTITY
{0xfcdff7b72d23a1ac, 0xf55ae8 }, // HAS_ENTITY_CLEAR_LOS_TO_ENTITY
{0xe88f19660651d566, 0xf55b20 }, // HAS_ENTITY_CLEAR_LOS_TO_ENTITY_IN_FRONT
{0xdf18751ec74f90ff, 0xf55b58 }, // HAS_ENTITY_COLLIDED_WITH_ANYTHING
{0x9ffaf4940a54cc09, 0xf54724 }, // GET_ANIM_DURATION
{0x56d713888a566481, 0xf54aa8 }, // GET_ENTITY_ATTACHED_TO
{0xa86d5f069399f44d, 0xf54b94 }, // GET_ENTITY_COORDS
{0x2412d9c05bb09b97, 0xf54bec }, // GET_ENTITY_FORWARD_VECTOR
{0xdb0954e9960f6457, 0xf54c34 }, // GET_ENTITY_FORWARD_X
{0x9a5c073ecbda7ee7, 0xf54c58 }, // GET_ENTITY_FORWARD_Y
{0xc230dd956e2f5507, 0xf54c7c }, // GET_ENTITY_HEADING
{0x82368787ea73c0f7, 0xf54ca8 }, // GET_ENTITY_HEALTH
{0x15d757606d170c3c, 0xf54d88 }, // GET_ENTITY_MAX_HEALTH
{0x166e7cf68597d8b5, 0xf57fc4 }, // SET_ENTITY_MAX_HEALTH
{0x296debc84474b375, 0xf54cec }, // GET_ENTITY_HEIGHT
{0xd3b5baea08f63e9, 0xf54d24 }, // GET_ENTITY_HEIGHT_ABOVE_GROUND
{0x3a9b1120af13fbf2, 0xf54d78 }, // GET_ENTITY_MATRIX
{0xda76a9f39210d365, 0xf54dbc }, // GET_ENTITY_MODEL
{0x497c6b1a2c9ae69c, 0xf554e0 }, // GET_OFFSET_FROM_ENTITY_GIVEN_WORLD_COORDS
{0x1899f328b0e12848, 0xf55538 }, // GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS
{0xef355abeff7f5005, 0xf54e08 }, // GET_ENTITY_PITCH
{0xbf966536fa8b6879, 0xf54eec }, // GET_ENTITY_ROLL
{0xe09caf86c32cb48f, 0xf54f10 }, // GET_ENTITY_ROTATION
{0xfb6ba510a533df81, 0xf54f8c }, // GET_ENTITY_SPEED
{0xf2db09816a419dc5, 0xf54fb0 }, // GET_ENTITY_SPEED_VECTOR
{0x56398be65160c3be, 0xf550a0 }, // GET_ENTITY_UPRIGHT_VALUE
{0x4805d2b1d8cf94a9, 0xf550c4 }, // GET_ENTITY_VELOCITY
{0x280bbe5601eaa983, 0xf554d4 }, // GET_OBJECT_INDEX_FROM_ENTITY_INDEX
{0xf16d042bd640ea3, 0xf554d4 }, // GET_PED_INDEX_FROM_ENTITY_INDEX
{0xdf1e5aac561afc59, 0xf554d4 }, // GET_VEHICLE_INDEX_FROM_ENTITY_INDEX
{0x82cfa50e34681ca5, 0xf55888 }, // GET_WORLD_POSITION_OF_ENTITY_BONE
{0x990e294fc387fb88, 0xf5543c }, // GET_NEAREST_PLAYER_TO_ENTITY
{0xb2c30c3b4aff718c, 0xf55474 }, // GET_NEAREST_PLAYER_TO_ENTITY_ON_TEAM
{0x97f696aca466b4e0, 0xf55078 }, // GET_ENTITY_TYPE
{0xade28862b6d7b85b, 0xf54e34 }, // GET_ENTITY_POPULATION_TYPE
{0x27cff3e5a286d3df, 0xf55bf4 }, // IS_AN_ENTITY
{0xcf8176912dda4ea5, 0xf55de0 }, // IS_ENTITY_A_PED
{0x138190f64db4bbd1, 0xf55dbc }, // IS_ENTITY_A_MISSION_ENTITY
{0xc3d96af45fccec4c, 0xf55e04 }, // IS_ENTITY_A_VEHICLE
{0xa27a546a375fdef, 0xf55c88 }, // IS_ENTITY_AN_OBJECT
{0x5e58342602e94718, 0xf55d64 }, // IS_ENTITY_AT_COORD
{0xc057f02b837a27f6, 0xf55dac }, // IS_ENTITY_AT_ENTITY
{0xee6ad63abf59c0b7, 0xf55cac }, // IS_ENTITY_ATTACHED
{0x306c1f6178f01ab3, 0xf55cd0 }, // IS_ENTITY_ATTACHED_TO_ANY_OBJECT
{0xc841153ded2ca89a, 0xf55cf4 }, // IS_ENTITY_ATTACHED_TO_ANY_PED
{0x12df6e0d2e736749, 0xf55d18 }, // IS_ENTITY_ATTACHED_TO_ANY_VEHICLE
{0x154a3c529497053e, 0xf55d3c }, // IS_ENTITY_ATTACHED_TO_ENTITY
{0x7d5b1f88e7504bba, 0xf55e70 }, // IS_ENTITY_DEAD
{0x886e37ec497200b6, 0xf55ee4 }, // IS_ENTITY_IN_AIR
{0xd3151e53134595e5, 0xf55f10 }, // IS_ENTITY_IN_ANGLED_AREA
{0xc2634c40a16193e, 0xf55f64 }, // IS_ENTITY_IN_AREA
{0xdde5c125ac446723, 0xf55fe0 }, // IS_ENTITY_IN_WATER
{0x4a77c3f73fd9e831, 0xf55000 }, // GET_ENTITY_SUBMERGED_LEVEL
{0x613c15d5d8db781f, 0xf560b0 }, // IS_ENTITY_ON_SCREEN
{0xdee49d5ca6c49148, 0xf5611c }, // IS_ENTITY_PLAYING_ANIM
{0x86468adfa0f6b861, 0xf56174 }, // IS_ENTITY_STATIC
{0x9a2304a64c3c8423, 0xf561a8 }, // IS_ENTITY_TOUCHING_ENTITY
{0x2ae3ebc8deb9768b, 0xf561d0 }, // IS_ENTITY_TOUCHING_MODEL
{0xf6f6afd8d4fb2658, 0xf561f8 }, // IS_ENTITY_UPRIGHT
{0x109de3da41aad94a, 0xf56220 }, // IS_ENTITY_UPSIDEDOWN
{0xffc96ecb7fa404ca, 0xf56244 }, // IS_ENTITY_VISIBLE
{0xf213c724e77f321a, 0xf56274 }, // IS_ENTITY_VISIBLE_TO_SCRIPT
{0x140188e884645624, 0xf56068 }, // IS_ENTITY_OCCLUDED
{0x3546fab293ff2981, 0xf58ec8 }, // WOULD_ENTITY_BE_OCCLUDED
{0x5e1cc2e8dc3111dd, 0xf562a0 }, // IS_ENTITY_WAITING_FOR_WORLD_COLLISION
{0x31da7cec5334db37, 0xf53964 }, // APPLY_FORCE_TO_ENTITY_CENTER_OF_MASS
{0xf15e8f5d333f09c4, 0xf53954 }, // APPLY_FORCE_TO_ENTITY
{0x6b9bbd38ab0796df, 0xf539ac }, // ATTACH_ENTITY_TO_ENTITY
{0xb629a43ca1643481, 0xf539bc }, // ATTACH_ENTITY_TO_ENTITY_PHYSICALLY
{0xbaca8fe9c76c124e, 0xf54ac8 }, // GET_ENTITY_BONE_INDEX_BY_NAME
{0xbb19ac7d4dcefd0f, 0xf53cac }, // CLEAR_ENTITY_LAST_DAMAGE_ENTITY
{0x4cd38c78bd19a497, 0xf53f3c }, // DELETE_ENTITY
{0x64cde9d6bf8ecad3, 0xf53f88 }, // DETACH_ENTITY
{0x7d9efb7ad6b19754, 0xf546f8 }, // FREEZE_ENTITY_POSITION
{0x740cb4f3f602c9f4, 0xf5819c }, // _SET_ENTITY_SOMETHING
{0xdc19c288082e586e, 0xf57b1c }, // SET_ENTITY_AS_MISSION_ENTITY
{0x4971d2f8162b9674, 0xf57b38 }, // SET_ENTITY_AS_NO_LONGER_NEEDED
{0x2595dd4236549ce3, 0xf57b38 }, // SET_PED_AS_NO_LONGER_NEEDED
{0x629bfa74418d6239, 0xf57b38 }, // SET_VEHICLE_AS_NO_LONGER_NEEDED
{0x3ae22deb5ba5a3e6, 0xf57b38 }, // SET_OBJECT_AS_NO_LONGER_NEEDED
{0xd06d522b90e861f, 0xf57ba4 }, // SET_ENTITY_CAN_BE_DAMAGED
{0xef1afb18649e015, 0xf57bb8 }, // SET_ENTITY_CAN_BE_DAMAGED_BY_RELATIONSHIP_GROUP
{0x6d09f32e284d0fb7, 0xf57bd0 }, // SET_ENTITY_CAN_BE_TARGETED_WITHOUT_LOS
{0xaa2fadd30f45a9da, 0xf54b60 }, // GET_ENTITY_COLLISION_DISABLED
{0xf66f820909453b8c, 0xf57c28 }, // SET_ENTITY_COLLISION
{0xe0580ec84813875a, 0xf57c48 }, // SET_ENTITY_COMPLETELY_DISABLE_COLLISION
{0x6843da7060a026b, 0xf57c68 }, // SET_ENTITY_COORDS
{0x239a3351ac1da385, 0xf57d28 }, // SET_ENTITY_COORDS_NO_OFFSET
{0xfbfc4473f66ce344, 0xf57dd0 }, // SET_ENTITY_DYNAMIC
{0xcf2b9c0645c4651b, 0xf57e18 }, // SET_ENTITY_HEADING
{0xa5c38736c426fcb8, 0xf57e3c }, // SET_ENTITY_INVINCIBLE
{0xa5d170c44cb2189, 0xf57e50 }, // SET_ENTITY_IS_TARGET_PRIORITY
{0x9b9ee31aed48072e, 0xf57f50 }, // SET_ENTITY_LOAD_COLLISION_FLAG
{0xbeb1600952b9cf5c, 0xf55998 }, // HAS_COLLISION_LOADED_AROUND_ENTITY
{0x473598683095d430, 0xf58078 }, // SET_ENTITY_ONLY_DAMAGED_BY_PLAYER
{0x6c1f6aa2f0add104, 0xf5808c }, // SET_ENTITY_ONLY_DAMAGED_BY_RELATIONSHIP_GROUP
{0xfaee099c6f890bb8, 0xf580a4 }, // SET_ENTITY_PROOFS
{0x100e7007d13e3687, 0xf580bc }, // SET_ENTITY_QUATERNION
{0x9cc8314dfede441e, 0xf58164 }, // SET_ENTITY_ROTATION
{0x1794b4fcc84d812f, 0xf581d0 }, // SET_ENTITY_VISIBLE
{0x1c99bb7b6e96d16f, 0xf581c0 }, // SET_ENTITY_VELOCITY
{0xcedb728a1083fa7, 0xf57e04 }, // SET_ENTITY_HAS_GRAVITY
{0x5fb407f0a7c877bf, 0xf57f88 }, // SET_ENTITY_LOD_DIST
{0xdf240d0c2a948683, 0xf54d48 }, // GET_ENTITY_LOD_DIST
{0xdf7692b1d9e7ba7, 0xf57a68 }, // SET_ENTITY_ALPHA
{0x1bb501624faf2bea, 0xf54a3c }, // GET_ENTITY_ALPHA
{0x744b9ef44779d9ab, 0xf5744c }, // RESET_ENTITY_ALPHA
{0xacad101e1fb66689, 0xf57a80 }, // SET_ENTITY_ALWAYS_PRERENDER
{0x85b8a7534e44bc23, 0xf5813c }, // SET_ENTITY_RENDER_SCORCHED
{0x10b2218320b6f5ac, 0xf53e38 }, // CREATE_MODEL_SWAP
{0x824e1c26a14cb817, 0xf57278 }, // REMOVE_MODEL_SWAP
{0x69848b3fb3c4426, 0xf53de8 }, // CREATE_MODEL_HIDE
{0xd136090a9aaab17d, 0xf53e10 }, // CREATE_MODEL_HIDE_EXCLUDING_SCRIPT_OBJECTS
{0x3f38a98576f6213a, 0xf5725c }, // REMOVE_MODEL_HIDE
{0x961a905afbc34c7, 0xf53db0 }, // CREATE_FORCED_OBJECT
{0x553fa683f2bcd814, 0xf571cc }, // REMOVE_FORCED_OBJECT
{0xe037bf068223c38d, 0xf58060 }, // SET_ENTITY_NO_COLLISION_ENTITY
{0x516c6abd18322b63, 0xf57fd4 }, // SET_ENTITY_MOTION_BLUR
{0x42718cc559bd7776, 0xf54614 }, // FIND_ANIM_EVENT_PHASE
{0x4c9e96473d4f1a88, 0xf54694 }, // FORCE_ENTITY_AI_AND_ANIMATION_UPDATE
{0x5851cc48405f4a07, 0xf55964 }, // HAS_ANIM_EVENT_FIRED
{0xaeb40615337ef1e3, 0xf559dc }, // HAS_ENTITY_ANIM_FINISHED
{0xdc6d22fab76d4874, 0xf56f60 }, // PLAY_ENTITY_ANIM
{0x786591d986de9159, 0xf58cfc }, // STOP_ENTITY_ANIM
{0x8ae2f981cddb8fa4, 0xf578b0 }, // SET_DECISION_MAKER
{0xd9f8455409b525e9, 0xf5309c }, // ADD_SHOCKING_EVENT_AT_POSITION
{0x7fd8f3be76f89422, 0xf53104 }, // ADD_SHOCKING_EVENT_FOR_ENTITY
{0x9db47e16060d6354, 0xf56528 }, // IS_SHOCKING_EVENT_IN_SPHERE
{0xe8bb3cc253a34559, 0xf57354 }, // REMOVE_SHOCKING_EVENT
{0xd47a168c2ab90dc4, 0xf57020 }, // REMOVE_ALL_SHOCKING_EVENTS
{0xdb249021652420c5, 0xf57378 }, // REMOVE_SHOCKING_EVENT_SPAWN_BLOCKING_AREAS
{0x84994fad4e4e4e69, 0xf58d7c }, // SUPPRESS_SHOCKING_EVENTS_NEXT_FRAME
{0x6b83617e04503888, 0xf58cb4 }, // START_SCRIPT_FIRE
{0x790125c36e194069, 0xf57348 }, // REMOVE_SCRIPT_FIRE
{0xc4dc7418a44d6822, 0xf58a8c }, // START_ENTITY_FIRE
{0x8390751dc40c1e98, 0xf58d14 }, // STOP_ENTITY_FIRE
{0x1bd7c371ce257c3e, 0xf5608c }, // IS_ENTITY_ON_FIRE
{0xf9617bc6fae61e08, 0xf554b0 }, // GET_NUMBER_OF_FIRES_IN_RANGE
{0xdb38f247bd421708, 0xf58d40 }, // STOP_FIRE_IN_RANGE
{0xb646fb657f448261, 0xf54834 }, // GET_CLOSEST_FIRE_POS
{0x7d6f58f69da92530, 0xf52dd4 }, // ADD_EXPLOSION
{0xd84a917a64d4d016, 0xf53000 }, // ADD_OWNED_EXPLOSION
{0x53ba259f3a67a99e, 0xf52e0c }, // ADD_EXPLOSION_WITH_USER_VFX
{0x8391ba4313a25ad3, 0xf5636c }, // IS_EXPLOSION_IN_AREA
{0xd96e82aebffaaff0, 0xf56300 }, // IS_EXPLOSION_ACTIVE_IN_AREA
{0xd62dd846d82cbb90, 0xf563a8 }, // IS_EXPLOSION_IN_SPHERE
{0x5ae661ecd18524c9, 0xf5633c }, // IS_EXPLOSION_IN_ANGLED_AREA
{0x8002ddab58594d78, 0xf55588 }, // _GET_ENTITY_INSIDE_EXPLOSION_AREA
{0xd2d9e04c0df927f4, 0xf541f4 }, // DRAW_LIGHT_WITH_RANGE
{0xbdbacb52a03cc760, 0xf58e80 }, // _UPDATE_ENTITY_SHIT_OR_SOMETHING
{0xcaafc225e33b1d15, 0xf57784 }, // SET_CHECKPOINT_RGBA
{0x99aff17222d4deb4, 0xf57758 }, // _SET_CHECKPOINT_ICON_RGBA
{0xded5b0c8ebaae12, 0xf53f30 }, // DELETE_CHECKPOINT
{0x405224591df02025, 0xf5425c }, // DRAW_RECT
{0x906b86e6d7896b9e, 0xf588e8 }, // SET_SCRIPT_GFX_DRAW_BEHIND_PAUSEMENU
{0xcfcc78391c8b3814, 0xf58908 }, // SET_SCRIPT_GFX_DRAW_ORDER
{0xc9884ecade94cb34, 0xf542b4 }, // DRAW_SPRITE
{0x40866a418eb8efde, 0xf539dc }, // ATTACH_TV_AUDIO_TO_ENTITY
{0x64437c98fcc5f291, 0xf58a0c }, // SET_TV_AUDIO_FRONTEND
{0x66773c92835d0909, 0xf5572c }, // GET_SCREEN_RESOLUTION
{0xcb50d7afcc8b0ec6, 0xf55704 }, // GET_SCREEN_COORD_FROM_WORLD_COORD
{0xb2797619a7c7747b, 0xf57604 }, // SET_ARTIFICIAL_LIGHTS_STATE
{0xfb405cb357c69cb9, 0xf53f00 }, // CREATE_TRACKED_POINT
{0xf6fda3d4404d4f2c, 0xf589d0 }, // SET_TRACKED_POINT_INFO
{0xcbb056ba159fb48d, 0xf56600 }, // IS_TRACKED_POINT_VISIBLE
{0x37a59922109f8f1c, 0xf53f60 }, // DESTROY_TRACKED_POINT
{0x8fbfd2aeb196b369, 0xf53b68 }, // _SET_FAR_SHADOWS_SUPPRESSED
{0xce4774e0f9ad48d1, 0xf53be4 }, // _CASCADESHADOWS_SET_TYPE
{0xf7c29d7c12c36f03, 0xf53b60 }, // _CASCADESHADOWS_RESET_TYPE
{0xef9e1c45732f55fa, 0xf58e00 }, // TOGGLE_PAUSED_RENDERPHASES
{0x86ed21bdb2791ce8, 0xf5584c }, // GET_TOGGLE_PAUSED_RENDERPHASES_STATUS
{0x2e80bf72ef7c87ac, 0xf58c2c }, // START_PARTICLE_FX_NON_LOOPED_AT_COORD
{0xfb97618457994a62, 0xf58b28 }, // START_NETWORKED_PARTICLE_FX_NON_LOOPED_AT_COORD
{0x3faa72bd940c3ac0, 0xf58ca4 }, // START_PARTICLE_FX_NON_LOOPED_ON_PED_BONE
{0xff4c64c513388c12, 0xf58c84 }, // START_PARTICLE_FX_NON_LOOPED_ON_ENTITY
{0xe6cfe43937061143, 0xf58b80 }, // START_NETWORKED_PARTICLE_FX_NON_LOOPED_ON_ENTITY
{0x60b85bed6577a35b, 0xf586ec }, // SET_PARTICLE_FX_NON_LOOPED_COLOUR
{0xba32867e86125d3a, 0xf58b90 }, // START_PARTICLE_FX_LOOPED_AT_COORD
{0xe689c1b1432bb8af, 0xf58c1c }, // START_PARTICLE_FX_LOOPED_ON_PED_BONE
{0xbd41e1440ce39800, 0xf58ba0 }, // START_PARTICLE_FX_LOOPED_ON_ENTITY
{0xd3ba6ec7f2fbd5e9, 0xf58c0c }, // START_PARTICLE_FX_LOOPED_ON_ENTITY_BONE
{0x8f90ab32e1944bde, 0xf58aac }, // START_NETWORKED_PARTICLE_FX_LOOPED_ON_ENTITY
{0x9c56621462ffe7a6, 0xf58b18 }, // START_NETWORKED_PARTICLE_FX_LOOPED_ON_ENTITY_BONE
{0x22970f3a088b133b, 0xf58d50 }, // STOP_PARTICLE_FX_LOOPED
{0x9dd5aff561e88f2a, 0xf5419c }, // DOES_PARTICLE_FX_LOOPED_EXIST
{0xd3a4a95fc94fe83b, 0xf586c8 }, // SET_PARTICLE_FX_LOOPED_OFFSETS
{0x3674f389b0facd80, 0xf5868c }, // SET_PARTICLE_FX_LOOPED_EVOLUTION
{0x239879fc61c610cc, 0xf5865c }, // SET_PARTICLE_FX_LOOPED_COLOUR
{0x88786e76234f7054, 0xf5864c }, // SET_PARTICLE_FX_LOOPED_ALPHA
{0x1a9e1c0d98d093b7, 0xf586dc }, // SET_PARTICLE_FX_LOOPED_SCALE
{0x9b04d471da0ad7aa, 0xf586a8 }, // SET_PARTICLE_FX_LOOPED_FAR_CLIP_DIST
{0x459598f579c98929, 0xf572d4 }, // REMOVE_PARTICLE_FX
{0x92884b4a49d81325, 0xf572e8 }, // REMOVE_PARTICLE_FX_FROM_ENTITY
{0x87b5905eca623b68, 0xf57338 }, // REMOVE_PARTICLE_FX_IN_RANGE
{0xa10db07fc234dd12, 0xf58ea8 }, // USE_PARTICLE_FX_ASSET
{0xbe711a169e9c7e95, 0xf58704 }, // SET_PARTICLE_FX_OVERRIDE
{0x274b3dabf7e72def, 0xf574a4 }, // RESET_PARTICLE_FX_OVERRIDE
{0x86de59fa02902b40, 0xf570f4 }, // REMOVE_DECALS_IN_RANGE
{0xfb8972bae0013140, 0xf570e8 }, // REMOVE_DECALS_FROM_OBJECT
{0x57cb267624ef85c0, 0xf52d5c }, // ADD_DECAL
{0x46f246d6504f0031, 0xf58a9c }, // START_PETROL_TRAIL_DECALS
{0x73354fb6d03d2e8a, 0xf52f74 }, // ADD_PETROL_TRAIL_DECAL_INFO
{0xe126aae933f3b56, 0xf543e8 }, // END_PETROL_TRAIL_DECALS
{0x49a720552eb0bb88, 0xf570d4 }, // REMOVE_DECAL
{0x3e4b4e5cf5d3eeb5, 0xf55c5c }, // IS_DECAL_ALIVE
{0xfa08722a5ea82da7, 0xf589a0 }, // SET_TIMECYCLE_MODIFIER
{0xfdb74c9cc54c3f37, 0xf589ac }, // SET_TIMECYCLE_MODIFIER_STRENGTH
{0xff927a09f481d80c, 0xf589f8 }, // SET_TRANSITION_TIMECYCLE_MODIFIER
{0xe3f4af2d63491fb, 0xf53ce8 }, // CLEAR_TIMECYCLE_MODIFIER
{0xa705394293e2b3d3, 0xf55834 }, // GET_TIMECYCLE_MODIFIER_INDEX
{0x2da67ba3c8a6755d, 0xf55840 }, // GET_TIMECYCLE_TRANSITION_MODIFIER_INDEX
{0x6fe93bcc7bf12b63, 0xf5437c }, // _SET_EXTRA_TIMECYCLE_MODIFIER_STRENGTH
{0x593faf7fc9401a56, 0xf58a1c }, // SET_TV_CHANNEL
{0xf90fbfd68f3c59ae, 0xf5587c }, // GET_TV_CHANNEL
{0x73a97068787d7231, 0xf58a40 }, // SET_TV_VOLUME
{0xc0a145540254a840, 0xf542c4 }, // DRAW_TV_CHANNEL
{0xdec6b25f5dc8925b, 0xf58a28 }, // SET_TV_CHANNEL_PLAYLIST
{0x4d562223e0eb65f3, 0xf5665c }, // _IS_TV_PLAYLIST_ITEM_PLAYING
{0x6fc9b065229c0787, 0xf0498 }, // ENABLE_MOVIE_SUBTITLES
{0x4102732df6b4005f, 0xf537e8 }, // ANIMPOSTFX_PLAY
{0xb4fd7446bab2f394, 0xf538f4 }, // ANIMPOSTFX_STOP
{0x4a123e85d7c4ca0b, 0xf53738 }, // ANIMPOSTFX_IS_RUNNING
{0x66560a0d4c64fd21, 0xf53900 }, // ANIMPOSTFX_STOP_ALL
{0xd43a616ae3ac4ef6, 0xf55958 }, // _GOOGLE_ANALYTICS_PUSH_PAGE
{0xc6de040378364798, 0xf55928 }, // _GOOGLE_ANALYTICS_POP_PAGE
{0x58f441b90ea84d06, 0xfd8c28 }, // BUSYSPINNER_OFF
{0x823bf7b1df613a21, 0xfd8bfc }, // BUSYSPINNER_IS_ON
{0x9d7e12ec6a1ee4e5, 0xfd98d8 }, // _GET_TEXT_SUBSTRING
{0xcfedccad3c5ba90d, 0xfd9bc8 }, // _GET_LABEL_TEXT
{0x916ed8321f087059, 0xfd8cb0 }, // CLEAR_ALL_HELP_MESSAGES
{0x73c258c68d6f55b6, 0xfd9394 }, // DOES_TEXT_LABEL_EXIST
{0x481fbf588b0b76db, 0xfda0d4 }, // GET_LENGTH_OF_LITERAL_STRING
{0xdc5ad6b7ab8184f5, 0xfda0fc }, // GET_LENGTH_OF_LITERAL_STRING_IN_BYTES
{0x81e47f0ee1f2b21e, 0xfdbdd4 }, // IS_RADAR_PREFERENCE_SWITCHED_ON
{0xd63fe3af9fb3d53f, 0xfd91b0 }, // DISPLAY_HUD
{0x71b72b478f8189dc, 0xfdb9dc }, // IS_HUD_HIDDEN
{0x1b82fd5ffa4d666e, 0xfdbd98 }, // IS_RADAR_HIDDEN
{0x4170b650590b3b00, 0xfde804 }, // SET_TEXT_SCALE
{0xbe5261939fbecb8c, 0xfde774 }, // SET_TEXT_CENTRE
{0x1be39dbaa7263ca5, 0xfde7bc }, // SET_TEXT_DROPSHADOW
{0xe550cde128d56757, 0xfde7cc }, // SET_TEXT_RENDER_ID
{0x98af2bb6f62bd588, 0xfdd8cc }, // REGISTER_NAMED_RENDERTARGET
{0x3ee32f7964c40fe6, 0xfdbba4 }, // IS_NAMED_RENDERTARGET_REGISTERED
{0xe692ee61761361f, 0xfdd8f8 }, // RELEASE_NAMED_RENDERTARGET
{0x2f506b8556242ddb, 0xfdcb40 }, // LINK_NAMED_RENDERTARGET
{0xb6762a85ee29aa60, 0xfda2b8 }, // GET_NAMED_RENDERTARGET_RENDER_ID
{0x707032835ff09ae7, 0xfdbb80 }, // IS_NAMED_RENDERTARGET_LINKED
{0xea600aabaf4b9084, 0xfdab44 }, // HIDE_LOADING_ON_FADE_THIS_FRAME
{0x36cdd81627a6fcd2, 0xfdab3c }, // HIDE_HUD_AND_RADAR_THIS_FRAME
{0x402669a4bdaa72da, 0xfde498 }, // SET_MISSION_NAME
{0xd98630ce73c61e98, 0xfde4d0 }, // _SET_MISSION_NAME_2
{0xb39c81628ef10b42, 0xfd9d88 }, // GET_HUD_SCREEN_POSITION_FROM_WORLD_POSITION
{0x56ce42a528156a67, 0xfd90d0 }, // DISABLE_FRONTEND_THIS_FRAME
{0x30996422df1ee561, 0xfd87a4 }, // _ALLOW_PAUSE_MENU_WHEN_DEAD_THIS_FRAME
{0xce47c21c0687ebc2, 0xfde0d8 }, // SET_FRONTEND_ACTIVE
{0x535384d6067ba42e, 0xfdbbc8 }, // IS_PAUSE_MENU_ACTIVE
{0xfbbf5943e4c2c992, 0xfd9610 }, // _FORCE_CLOSE_TEXT_INPUT_BOX
{0xbc19069d5fbb5c46, 0xf54aa0 }, // _IS_MULTIPLAYER_CHAT_ACTIVE
{0x6dfdd665e416b093, 0xfdcac8 }, // _JOURNAL_WRITE_ENTRY
{0xcf782691d91f270e, 0xfdc9c4 }, // _JOURNAL_CAN_WRITE_ENTRY
{0xe65b5de53351be22, 0xfdca1c }, // _JOURNAL_GET_ENTRY_COUNT
{0x3d16abd7a1fd8c96, 0xfdc9fc }, // _JOURNAL_GET_ENTRY_AT_INDEX
{0xcb5945e1b855852f, 0xfdca58 }, // _JOURNAL_GET_GRIME_AT_INDEX
{0x5514c3e60673530f, 0xfdca30 }, // _JOURNAL_GET_ENTRY_INFO
{0x62cc549b3b8ea2aa, 0xfdca78 }, // _JORUNAL_GET_TEXTURE_WITH_LAYOUT
{0xe4509babe59bd24e, 0xfdcaa4 }, // _JORUNAL_MARK_READ
{0xf402978de6f88d6e, 0xfdc9e8 }, // _JORUNAL_CLEAR_ALL_PROGRESS
{0x29fa7910726c3889, 0x103c428 }, // _CREATE_PROMPT
{0x4f97de45a519419, 0x103cf58 }, // _BEGIN_REGISTER_PROMPT
{0xf7aa2696a22ad8b9, 0x103cf74 }, // _END_REGISTER_PROMPT
{0xca24f528d0d16289, 0x103d334 }, // _PROMPT_SET_PRIORITY
{0xb5352b7494a08258, 0x103d06c }, // _PROMPT_SET_CONTROL_ACTION
{0x565c1ce183cb0eaf, 0x103cfec }, // _PROMPT_SET_ALLOWED_ACTION
{0xcc6656799977741b, 0x103d400 }, // _PROMPT_SET_STANDARD_MODE
{0xc92ac953f0a982ae, 0x103cd18 }, // _PROMPT_HAS_STANDARD_MODE_COMPLETED
{0x1473d3af51d54276, 0x103d324 }, // _PROMPT_SET_PRESSED_TIMED_MODE
{0x3ce854d250a88daf, 0x103cbf8 }, // _PROMPT_HAS_PRESSED_TIMED_MODE_COMPLETED
{0x1a17b9ecff617562, 0x103cc88 }, // _PROMPT_HAS_PRESSED_TIMED_MODE_FAILED
{0x94073d5ca3f16b7b, 0x103d0f0 }, // _PROMPT_SET_HOLD_MODE
{0x74c7d7b72ed0d3cf, 0x103d3f0 }, // _PROMPT_SET_STANDARDIZED_HOLD_MODE
{0xea5ccf4eeb2f82d1, 0x103d0cc }, // _PROMPT_SET_HOLD_INDEFINITELY_MODE
{0x3ce932e737c145d6, 0x103d0a4 }, // _PROMPT_SET_HOLD_AUTO_FILL_MODE
{0x8010bebd0d5ed5bc, 0x103c948 }, // _PROMPT_HAS_HOLD_AUTO_FILL_MODE
{0xc7d70eaef92eff48, 0x103cdf0 }, // _PROMPT_IS_HOLD_MODE_RUNNING
{0xe0f65f0640ef0617, 0x103c9b8 }, // _PROMPT_HAS_HOLD_MODE_COMPLETED
{0xdf6423bf071c7f71, 0x103d2c4 }, // _PROMPT_SET_MASH_MODE
{0x7b66e89312727274, 0x103d1a4 }, // _PROMPT_SET_MASH_INDEFINITELY_MODE
{0xcd1bdff15efa79f5, 0x103d30c }, // _PROMPT_SET_MASH_WITH_RESISTANCE_MODE
{0xdc0cb602deadba53, 0x103d2f4 }, // _PROMPT_SET_MASH_WITH_RESISTANCE_CAN_FAIL_MODE
{0x6c39587d7cc66801, 0x103d190 }, // _PROMPT_SET_MASH_AUTO_FILL_MODE
{0x32df729d8bd3c1c6, 0x103d1f8 }, // _PROMPT_SET_MASH_MANUAL_MODE
{0x179dcf71f705da20, 0x103d1c8 }, // _PROMPT_SET_MASH_MANUAL_CAN_FAIL_MODE
{0x845ce958416dc473, 0x103ca48 }, // _PROMPT_HAS_MASH_MODE_COMPLETED
{0x25b18e530cf39d6f, 0x103cad8 }, // _PROMPT_HAS_MASH_MODE_FAILED
{0x8a9585293863b8a5, 0x103c76c }, // _PROMPT_GET_MASH_MODE_PROGRESS
{0xa0d1d79c6036a855, 0x103d25c }, // _PROMPT_SET_MASH_MANUAL_MODE_INCREASE_PER_PRESS
{0x7d393c247fb9b431, 0x103d228 }, // _PROMPT_SET_MASH_MANUAL_MODE_DECAY_SPEED
{0x56dbb26f98582c29, 0x103d290 }, // _PROMPT_SET_MASH_MANUAL_MODE_PRESSED_GROWTH_SPEED
{0x7abe7095fb3d2581, 0x103d374 }, // _PROMPT_SET_ROTATE_MODE
{0x5f6503d9cd2754eb, 0x103d420 }, // _PROMPT_SET_TARGET_MODE
{0x5e019c45dd3b6a14, 0x103d43c }, // _PROMPT_SET_TARGET_MODE_TARGET
{0x123054bec8a30f, 0x103cd40 }, // _PROMPT_SET_TARGET_MODE_PROGRESS
{0xf957a1654c6322fe, 0x103d014 }, // _PROMPT_SET_BEAT_MODE
{0x1fe4788ab1430c55, 0x103d590 }, // _PROMPT_WAS_BEAT_MODE_PRESSED_IN_TIME_WINDOW
{0xb487a4936fbf40ac, 0x103d040 }, // _PROMPT_SET_BEAT_MODE_GRAYED_OUT
{0xdc6c55dfa2c24ee5, 0x103cfc8 }, // _PROMPT_RESTART_MODES
{0xac6586a7fdcd4b68, 0x103d3bc }, // _PROMPT_SET_SPINNER_SPEED
{0x832cb510de546282, 0x103d388 }, // _PROMPT_SET_SPINNER_POSITION
{0xc5f428ee08fa7f2c, 0x103d500 }, // _PROMPT_SET_URGENT_PULSING_ENABLED
{0x1fba0dabecddb52b, 0x103c7c4 }, // _PROMPT_GET_URGENT_PULSING_ENABLED
{0xdec85c174751292b, 0x103d410 }, // _PROMPT_SET_TAG
{0xb796970bd125fce8, 0x103c6d4 }, // _PROMPT_GET_GROUP_ID_FOR_TARGET_ENTITY
{0xcb73d7521e7103f0, 0x103c6b0 }, // _PROMPT_GET_GROUP_ID_FOR_SCENARIO_POINT
{0x2f11d3a254169ea4, 0x103d090 }, // _PROMPT_SET_GROUP
{0x4e52c800a28f7be8, 0x103cf9c }, // _PROMPT_REMOVE_GROUP
{0xc65a45d4453c2627, 0x103c558 }, // _PROMPT_SET_ACTIVE_GROUP_THIS_FRAME
{0xc1fcc36c3f7286c8, 0x103c4c8 }, // _PROMPT_GET_GROUP_ACTIVE_PAGE
{0x315c81d760609108, 0x103c598 }, // _PROMPT_SET_AMBIENT_GROUP_THIS_FRAME
{0xeb550b927b34a1bb, 0x103c47c }, // _PROMPT_DOES_AMBIENT_GROUP_EXIST
{0x684c96cc7c66e8ef, 0x103c5ec }, // _PROMPT_ADD_GROUP_LINK
{0x837972ed28159536, 0x103c600 }, // _PROMPT_ADD_GROUP_RETURN_LINK
{0x876e4a35c73a6655, 0x103d4b4 }, // _PROMPT_SET_TRANSPORT_MODE
{0xede88d4d13cf59, 0x103c690 }, // _PROMPT_DELETE
{0x347469fbdd1589a9, 0x103cf20 }, // _PROMPT_IS_VALID
{0x546e342e01de71cf, 0x103cd74 }, // _PROMPT_IS_ACTIVE
{0x71215accfde075ee, 0x103d564 }, // _PROMPT_SET_VISIBLE
{0x8a0fb4d03a630d21, 0x103d534 }, // _PROMPT_SET_ENABLED
{0x5dd02a8318420dd7, 0x103d484 }, // _PROMPT_SET_TEXT
{0x560e76d5e2e1803f, 0x103cffc }, // _PROMPT_SET_ATTRIBUTE
{0xae84c5ee2c384fb3, 0x103c650 }, // _PROMPT_SET_POSITION
{0x21e60e230086697f, 0x103cec8 }, // _PROMPT_IS_PRESSED
{0x2787cc611d3facc5, 0x103ce80 }, // _PROMPT_IS_JUST_PRESSED
{0x635cc82fa297a827, 0x103cea4 }, // _PROMPT_IS_JUST_RELEASED
{0xafc887ba7a7756d6, 0x103d624 }, // _PROMPT_IS_RELEASED
{0x6565032897ba861, 0x103c4a8 }, // _PROMPT_GLOBAL_ENABLE_PROMPT_TYPE_THIS_FRAME
{0xfc094ef26dd153fa, 0x103c468 }, // _PROMPT_GLOBAL_DISABLE_PROMPT_TYPE_THIS_FRAME
{0x6a2f820452017ea2, 0x103c4bc }, // _PROMPT_GLOBAL_FILTER_CLEAR
{0x530a428705be5def, 0x103c5e0 }, // _PROMPT_GLOBAL_SET_FAVOURED_PED_FOR_CONFLICT_RESOLUTION
{0x51259ae5c72d4a1b, 0x103c418 }, // _PROMPT_GLOBAL_CLEAR_FAVOURED_PED_FOR_CONFLICT_RESOLUTION
{0xd00eddfb58b7f28, 0x103ceec }, // _PROMPT_IS_ENABLED
{0x2f385ecc5200938d, 0x103cf48 }, // _PROMPT_SET_ORDERING_AS_INPUT_TYPE
{0x53cb4b502e1c57ea, 0xf53d68 }, // CREATE_FAKE_MP_GAMER_TAG
{0x839bfd7d7e49fe09, 0xf572a4 }, // REMOVE_MP_GAMER_TAG
{0x6e1c31e14c7a5f97, 0xf56490 }, // IS_MP_GAMER_TAG_ACTIVE
{0xea6f4b8d4b4b5b3e, 0xf584cc }, // SET_MP_GAMER_TAG_NAME
{0xa0d7ce5f83259663, 0xf58484 }, // SET_MP_GAMER_TAG_BIG_TEXT
{0xf12e4ccaf249dc10, 0xfde4f4 }, // _SET_MOUSE_CURSOR_ACTIVE_THIS_FRAME
{0x7f5858aab5a58cce, 0xfde4e4 }, // _SET_MOUSE_CURSOR_SPRITE
{0x17c1b3159f79f6c, 0xfdbe54 }, // IS_VALID_INTERIOR
{0x4200f14d6f840a9a, 0xfdba94 }, // IS_INTERIOR_SCENE
{0xa1762d5bbfca13a8, 0xfd8e6c }, // CLEAR_ROOM_FOR_ENTITY
{0xbc29a9894c976945, 0xfd9670 }, // FORCE_ROOM_FOR_ENTITY
{0x76e46e0eb52afc6, 0xfda644 }, // GET_ROOM_KEY_FROM_ENTITY
{0x27d7b6f79e1f4603, 0xfda084 }, // GET_KEY_FOR_ENTITY_IN_ROOM
{0xb417689857646f61, 0xfd9eb8 }, // GET_INTERIOR_FROM_ENTITY
{0x115b4aa8fb28ab43, 0xfd9684 }, // FORCE_ROOM_FOR_GAME_VIEWPORT
{0x951a049765e0d450, 0xfd8e78 }, // CLEAR_ROOM_FOR_GAME_VIEWPORT
{0xcdd36c9e5c469070, 0xfd9e34 }, // GET_INTERIOR_AT_COORDS
{0xbd3d33eabf680168, 0xfdd634 }, // PIN_INTERIOR_IN_MEMORY
{0x7fd1a0b814f6055, 0xfded8c }, // UNPIN_INTERIOR
{0x941560d2d45dbfc8, 0xfdba70 }, // IS_INTERIOR_READY
{0xaad6170aa33b13c0, 0xfd9e54 }, // GET_INTERIOR_AT_COORDS_WITH_TYPE
{0x3543aea1816d1d2b, 0xfd9e78 }, // GET_INTERIOR_AT_COORDS_WITH_TYPEHASH
{0xf291396b517e25b2, 0xfdb8f8 }, // _ARE_COORDS_COLLIDING_WITH_EXTERIOR
{0x5054d1a5218fa696, 0xfd9e98 }, // GET_INTERIOR_FROM_COLLISION
{0x174d0aab11ced739, 0xfd8614 }, // ACTIVATE_INTERIOR_ENTITY_SET
{0x33b81a2c07a51fff, 0xfd9084 }, // DEACTIVATE_INTERIOR_ENTITY_SET
{0x32810ca2125f5842, 0xfdba20 }, // IS_INTERIOR_ENTITY_SET_ACTIVE
{0x3c2b92a1a07d4fce, 0xfd90f0 }, // DISABLE_INTERIOR
{0x856ff92c57742ae5, 0xfdbec4 }, // _ITEM_DATABASE_CAN_EQUIP_ITEM_ON_CATEGORY
{0x2970d1d6bfcf9b46, 0xfdc388 }, // _ITEM_DATABASE_GET_FITS_SLOT_COUNT
{0x77210c146ced5261, 0xfdc3a8 }, // _ITEM_DATABASE_GET_FITS_SLOT_INFO
{0x44915068579d7710, 0xfdc3d4 }, // _ITEM_DATABASE_GET_HAS_SLOT_COUNT
{0x8a9bd0db7e8376cf, 0xfdc3f4 }, // _ITEM_DATABASE_GET_HAS_SLOT_INFO
{0xfe90abbcbfdc13b2, 0xfdc0ec }, // _ITEM_DATABASE_FILLOUT_ITEM_INFO
{0x74f7928816e4e181, 0xfdbf70 }, // _ITEM_DATABASE_FILLOUT_ACQUIRE_COST
{0x7a62a2eede1c3766, 0xfdc190 }, // _ITEM_DATABASE_FILLOUT_SELL_PRICE
{0x4776efd78f75c23f, 0xfdc168 }, // _ITEM_DATABASE_FILLOUT_SATCHEL_DATA
{0xb86f7cc2dc67ac60, 0xfdc1ec }, // _ITEM_DATABASE_FILLOUT_UI_DATA
{0x9379be60dc55bbe6, 0xfdc0c4 }, // _ITEM_DATABASE_FILLOUT_ITEM_EFFECTS_IDS
{0xcf2d360d27fd1abf, 0xfdc074 }, // _ITEM_DATABASE_FILLOUT_ITEM_EFFECTS_ID_INFO
{0x5a11d6eea17165b0, 0xfdc1bc }, // _ITEM_DATABASE_FILLOUT_TAG_DATA
{0x1fddad392d04144, 0xfdc240 }, // _ITEM_DATABASE_GET_ACQUIRE_COSTS_COUNT
{0x6772a83c67a25775, 0xfdc214 }, // _ITEM_DATABASE_GET_ACQUIRE_COST
{0x71efa7999ae79408, 0xfdbef0 }, // _ITEM_DATABASE_CREATE_ITEM_COLLECTION
{0x337f88e3a063995e, 0xfdc7e8 }, // _ITEM_DATABASE_IS_INTRINSIC_ITEM
{0x337f88e3a063995f, 0xfdc874 }, // _ITEM_DATABASE_IS_OVERPOWERED_ITEM
{0x6d5d51b188333fd1, 0xfdc828 }, // _ITEM_DATABASE_IS_KEY_VALID
{0x891a45960b6b768a, 0xfdc444 }, // _ITEM_DATABASE_GET_BUNDLE_ID
{0x3332695b01015df9, 0xfdc334 }, // _ITEM_DATABASE_GET_BUNDLE_ITEM_COUNT
{0x5d48a77e4b668b57, 0xfdc358 }, // _ITEM_DATABASE_GET_BUNDLE_ITEM_INFO
{0xb9507d8e1d8716, 0xfdc8d4 }, // _ITEM_DATABASE_IS_SHOP_KEY_VALID
{0xc568b1a0f17c7025, 0xfdc518 }, // _ITEM_DATABASE_GET_SHOP_INVENTORIES_ITEMS_COUNT
{0x4a79b41b4eb91f4e, 0xfdc538 }, // _ITEM_DATABASE_GET_SHOP_INVENTORIES_ITEM_INFO
{0xcfb06801f5099b25, 0xfdbe98 }, // _ITEM_DATABASE_GET_SHOP_INVENTORIES_ITEM_INFO_BY_KEY
{0x76c752d788a76813, 0xfdc564 }, // _ITEM_DATABASE_GET_SHOP_INVENTORIES_REQUIREMENT_GROUP_INFO
{0xe0ea5c031ae5539f, 0xfdc594 }, // _ITEM_DATABASE_GET_SHOP_INVENTORIES_REQUIREMENT_INFO
{0x3afe5182c45a84f6, 0xfdc898 }, // _ITEM_DATABASE_IS_SHOP_LAYOUT_KEY_VALID
{0x66a6d76b6bb999b4, 0xfdc5cc }, // _ITEM_DATABASE_GET_SHOP_LAYOUT_INFO
{0x86fcb565cca0cfa7, 0xfdc6f0 }, // _ITEM_DATABASE_GET_SHOP_LAYOUT_ROOT_MENU_INFO
{0xd66114469978b55b, 0xfdc5f4 }, // _ITEM_DATABASE_GET_SHOP_LAYOUT_MENU_INFO_BY_ID
{0xf04247092f193b75, 0xfdc620 }, // _ITEM_DATABASE_GET_SHOP_LAYOUT_MENU_INFO_BY_INDEX
{0x9a60570657a7b635, 0xfdc650 }, // _ITEM_DATABASE_GET_SHOP_LAYOUT_MENU_PAGE_KEY
{0xb347c100df0c9b7f, 0xfdc680 }, // _ITEM_DATABASE_GET_SHOP_LAYOUT_PAGE_INFO_BY_KEY
{0xf32bef578b3dbae8, 0xfdc6ac }, // _ITEM_DATABASE_GET_SHOP_LAYOUT_PAGE_ITEM_KEY
{0x4ce753203fa42214, 0xfdc7a8 }, // _ITEM_DATABASE_IS_BUY_AWARD_KEY_VALID
{0xb52e20f6767a09a2, 0xfdc01c }, // _ITEM_DATABASE_FILLOUT_BUY_AWARD_ACQUIRE_COSTS
{0x4eb37aab79ab0c48, 0xfdc2ec }, // _ITEM_DATABASE_GET_ITEM_PRICE_MODIFIERS
{0x40c5d95818823c94, 0xfdc140 }, // _ITEM_DATABASE_FILLOUT_PRICE_MODIFIER_BY_KEY
{0x5aaaf40e9b224f5e, 0xfdc4d8 }, // _ITEM_DATABASE_GET_NUMBER_OF_MODIFIED_PRICES
{0xcb92ec9c004732b4, 0xfdc4b4 }, // _ITEM_DATABASE_GET_MODIFIED_PRICE
{0x1289d8315235856d, 0xfdc4f8 }, // _ITEM_DATABASE_GET_NUMBER_OF_MODIFIERS
{0x60614a0ab580a2b5, 0xfdc114 }, // _ITEM_DATABASE_FILLOUT_MODIFIER
{0xff5fb5605ad56856, 0xfdbf44 }, // _ITEM_DATABASE_DOES_ITEM_HAVE_TAG
{0x6111b8f9413f413a, 0xfdc490 }, // _ITEM_DATABASE_GET_ITEM_TAG_TYPE
{0xcec6a41e8910486a, 0xfdc910 }, // _ITEM_DATABASE_LOCALIZATION_GET_NUM_LABEL_TYPES
{0x49885d82a13eeaea, 0xfdc930 }, // _ITEM_DATABASE_LOCALIZATION_GET_NUM_VALUES
{0xcabf5d41d0073d4a, 0xfdc954 }, // _ITEM_DATABASE_LOCALIZATION_GET_TYPE
{0x9ae5610fdced6ea7, 0xfdc978 }, // _ITEM_DATABASE_LOCALIZATION_GET_VALUE
{0xa1af16083320065a, 0xfd9060 }, // CREATE_ITEMSET
{0x712bc69f10549b92, 0xfd90c4 }, // DESTROY_ITEMSET
{0xd30765d153ef5c76, 0xfdbaf0 }, // IS_ITEMSET_VALID
{0xabe74510883c7950, 0xfd8768 }, // ADD_TO_ITEMSET
{0xc5baa432b429dc24, 0xfdd93c }, // REMOVE_FROM_ITEMSET
{0x55f2e375ac6018a9, 0xfd9fcc }, // GET_ITEMSET_SIZE
{0x275a2e2c0fab7612, 0xfd9dec }, // GET_INDEXED_ITEM_IN_ITEMSET
{0xd1503c2ee2fe688c, 0xfdbac8 }, // IS_IN_ITEMSET
{0x85f3a86ca9021fb0, 0xfd8c6c }, // CLEAN_ITEMSET
{0x3c1a05f86ae6acb5, 0xfdcb6c }, // _GET_SYSTEM_LANGUAGE
{0xdb917da5c6835fcc, 0xfd9a34 }, // GET_CURRENT_LANGUAGE
{0x76e30b799ebeea0f, 0xfdcb4c }, // _LOCALIZATION_GET_USER_LANGUAGE
{0x6d2c41a8bd6d6fd0, 0xfd9828 }, // GET_BLIP_FROM_ENTITY
{0x5cd2889b2b381d45, 0xfda1c0 }, // GET_MAIN_PLAYER_BLIP_ID
{0x2ff4cf43b7209d1, 0xfd8b68 }, // SET_BLIP_FLASH_TIMER
{0xdf2b55f717ddb10, 0xfd8b14 }, // SET_BLIP_FLASHES
{0x72dd432f3cdfc0ee, 0xfded4c }, // TRIGGER_SONAR_BLIP
{0x4ff674f5e23d49ce, 0xfddc30 }, // SET_BLIP_COORDS
{0x201c319797bda603, 0xfd97e0 }, // GET_BLIP_COORDS
{0x74f74d3207ed525c, 0xfddc90 }, // SET_BLIP_SPRITE
{0xa062d6d7c0b2c2c, 0xfddc50 }, // SET_BLIP_NAME_FROM_TEXT_FILE
{0x93dd5a31bc2b459, 0xfddc60 }, // SET_BLIP_NAME_TO_PLAYER_NAME
{0x6049966a94fbe706, 0xfddc70 }, // SET_BLIP_ROTATION
{0xd38744167b2fa257, 0xfddc80 }, // SET_BLIP_SCALE
{0xf2c3c9da47aaa54a, 0xfdd91c }, // REMOVE_BLIP
{0xcd82fa174080b3b1, 0xfd922c }, // DOES_BLIP_EXIST
{0xcaf6489da2c8dd9e, 0xfdec9c }, // SET_RADAR_ZOOM
{0x46534526b9cd2d17, 0xfdb844 }, // IS_BLIP_ON_MINIMAP
{0xee1c7ba69bb74b08, 0xfd9694 }, // FORCE_SONAR_BLIPS_THIS_FRAME
{0x5de61c90ddecfa2d, 0xfde174 }, // SET_GPS_FLAGS
{0x4d3771237c79ff41, 0xfd8dcc }, // CLEAR_GPS_FLAGS
{0xf6cef599fc470b33, 0xfde15c }, // SET_GPS_CUSTOM_ROUTE_RENDER
{0x1eaa5674b4d181c5, 0xfd8dc4 }, // CLEAR_GPS_CUSTOM_ROUTE
{0x3d3d15af7bcaaf83, 0xfdeb60 }, // START_GPS_MULTI_ROUTE
{0x64c59dd6834fa942, 0xfd8664 }, // ADD_POINT_TO_GPS_MULTI_ROUTE
{0x4426d65e029a4dc0, 0xfde184 }, // SET_GPS_MULTI_ROUTE_RENDER
{0x9e0ab9aaee87ce28, 0xfd8dd4 }, // CLEAR_GPS_MULTI_ROUTE
{0x8fdc6f796e350d1, 0xfd8df4 }, // CLEAR_GPS_PLAYER_WAYPOINT
{0xfa8c41e8020d3439, 0xfd8df4 }, // SET_WAYPOINT_OFF
{0x202b1bbfc6ab5ee4, 0xfdbe68 }, // IS_WAYPOINT_ACTIVE
{0x1b3da717b9aff828, 0xfd9204 }, // DISPLAY_RADAR
{0xa8ebbae986fb5457, 0xfde5e4 }, // SET_RADAR_AS_EXTERIOR_THIS_FRAME
{0x4b8f743a4a6d2ff8, 0xfde45c }, // _SET_MINIMAP_REVEALED
{0xbfd145ef819fb3a, 0xfdcb88 }, // LOCK_MINIMAP_ANGLE
{0x5373de8e179bc2a0, 0xfded6c }, // UNLOCK_MINIMAP_ANGLE
{0x2a0c4736ac5af0ce, 0xfdcfcc }, // _MINIGAME_IS_CONNECTED_TO_SERVER
{0xf5446e47941e654c, 0xfdd038 }, // _MINIGAME_LEAVE_TABLE
{0x578907f59ba01b6c, 0xfdcf80 }, // _MINIGAME_GET_NEXT_EVENT_TYPE
{0xdf728c5ae137fc13, 0xfdcf58 }, // _MINIGAME_GET_NEXT_EVENT
{0x833e03baebadc4b0, 0xfdd100 }, // _MINIGAME_POP_NEXT_EVENT
{0x9105a4a2556fa937, 0xfdcff0 }, // _MINIGAME_IS_REQUEST_PENDING
{0x2d20e12e1990d584, 0xfdd79c }, // _POKER_GET_GAME_SETTINGS_FOR_ID
{0xb4d610ea5a1fde74, 0xfdd670 }, // _POKER_BUY_IN
{0x8ded681b161ebd78, 0xfdd720 }, // _POKER_CALL
{0x49a045628d9b1b86, 0xfdd74c }, // _POKER_CHECK
{0x3dfab7d9bb45b5be, 0xfdd778 }, // _POKER_FOLD
{0xeccf45a79a17bb96, 0xfdd7c0 }, // _POKER_RAISE
{0x2f2131db0a8b02dc, 0xfdd7e8 }, // _POKER_REVEAL
{0x399e6cd12fc8ca89, 0xfd93c4 }, // _DOMINOES_BUY_IN
{0xb79a29b33bf29ba5, 0xfd9498 }, // _DOMINOES_PLACE_DOMINO
{0xe26aee7e67d9e21d, 0xfd94e8 }, // _DOMINOES_REQUEST_VALID_PLACEMENTS
{0x40dc2907a9697ef7, 0xfda2f8 }, // GET_NUMBER_OF_FREE_STACKS_OF_THIS_SIZE
{0x5cd7a49104afcb6b, 0xfde620 }, // SET_RANDOM_SEED
{0x9682af6050854856, 0xfde86c }, // SET_TIME_SCALE
{0x36694b456be80d0a, 0xfde488 }, // SET_MISSION_FLAG
{0xb15cd1cf58771de1, 0xfda23c }, // GET_MISSION_FLAG
{0xb1adccc4150c6473, 0xfde610 }, // SET_RANDOM_EVENT_FLAG
{0x924d54e5698ae3e0, 0xfda544 }, // GET_RANDOM_EVENT_FLAG
{0x6e5a7fbeecab3c72, 0xfde660 }, // SET_RANDOM_WEATHER_TYPE
{0xd85dfe5c131e4ae9, 0xfd8eb4 }, // CLEAR_WEATHER_TYPE_PERSIST
{0xac679b2342f14f2, 0xfd9a6c }, // _GET_WEATHER_TYPE_TRANSITION
{0xfa3e3ca8a1de6d5d, 0xfddefc }, // _SET_WEATHER_TYPE_TRANSITION
{0x80a398f16ffe3cc3, 0xfd8e44 }, // CLEAR_OVERRIDE_WEATHER
{0xd00c2d82dc04a99f, 0xfde9b4 }, // SET_WIND_SPEED
{0xffb7e74e041150a4, 0xfda940 }, // GET_WIND_SPEED
{0xb56c4f5f57a45600, 0xfde9a4 }, // SET_WIND_DIRECTION
{0xf703e82f3fe14a5f, 0xfda8fc }, // GET_WIND_DIRECTION
{0x193dfc0526830fd6, 0xfde5fc }, // _SET_RAIN_FX_INTENSITY
{0x931b5f4cc130224b, 0xfda534 }, // GET_RAIN_LEVEL
{0x1e5d727041be1709, 0xfda6a4 }, // GET_SNOW_LEVEL
{0x369db5b2510fa080, 0xfd9648 }, // FORCE_LIGHTNING_FLASH
{0x4f67e8eca7d3f667, 0xfd9c2c }, // GET_GAME_TIMER
{0xbe7f225417e35a7c, 0xfda784 }, // _GET_SYSTEM_TIME
{0xb0ce5e5ed8bb3581, 0xfda348 }, // _GET_NUMBER_OF_MICROSECONDS_SINCE_LAST_CALL
{0x63219768c586667c, 0xfda664 }, // _GET_SCRIPT_TIME_WITHIN_FRAME_IN_MICROSECONDS
{0x1411a7cbc3a6eb7b, 0xfddaa0 }, // _RESET_SCRIPT_TIME_WITHIN_FRAME
{0x5e72022914ce3c38, 0xfd9c1c }, // GET_FRAME_TIME
{0x3f3172feae3afe1c, 0xfda790 }, // _GET_BENCHMARK_TIME
{0x77dfa958fcf100c1, 0xfd9c10 }, // GET_FRAME_COUNT
{0xe29f927a961f8aaa, 0xfda554 }, // GET_RANDOM_FLOAT_IN_RANGE
{0xd53343aa4fb7dd28, 0xfda5ac }, // GET_RANDOM_INT_IN_RANGE
{0x24fa4267bb8d2431, 0xfd9cd0 }, // GET_GROUND_Z_FOR_3D_COORD
{0x2a29ca9a6319e6ab, 0xfd9c78 }, // GET_GROUND_Z_AND_NORMAL_FOR_3D_COORD
{0x6e3c15d296c15583, 0xfd8918 }, // ASIN
{0x586690f0176dc575, 0xfd85a8 }, // ACOS
{0x8c13db96497b7abf, 0xfdeca8 }, // TAN
{0x503054ded0b78027, 0xfd896c }, // ATAN
{0x965b220a066e3f07, 0xfd893c }, // ATAN2
{0xbe7f4e3cdbafb28, 0xfd9b38 }, // GET_DISTANCE_BETWEEN_COORDS
{0xd0dfe1c486097bbb, 0xfd974c }, // GET_ANGLE_BETWEEN_2D_VECTORS
{0x38d5202ff9271c62, 0xfd9d20 }, // GET_HEADING_FROM_VECTOR_2D
{0xf73fbe4845c43b5b, 0xfddbf0 }, // SET_BIT
{0x7d1d4a3602b6ad4e, 0xfd8d04 }, // CLEAR_BIT
{0xfd340785adf8cfb7, 0xfd9cfc }, // GET_HASH_KEY
{0x825ca3ed43831015, 0xfdbcb0 }, // IS_POSITION_OCCUPIED
{0x3b882a96ea77d5b1, 0xfd8cf0 }, // CLEAR_AREA
{0xa4d83115c1e02f8a, 0xfd8cd8 }, // CLEAR_ANGLED_AREA_OF_VEHICLES
{0xd37becf862da726f, 0xfdde88 }, // SET_CREDITS_ACTIVE
{0x3d0eac6385dd6100, 0xfdd57c }, // NETWORK_SET_SCRIPT_IS_SAFE_FOR_NETWORK_GAME
{0x66ab6b6c7e72f393, 0xfdd624 }, // PAUSE_DEATH_ARREST_RESTART
{0x6c9ff40ff1b69f8f, 0xfdac08 }, // IGNORE_NEXT_RESTART
{0xdf3b5846de5904af, 0xfde05c }, // SET_FADE_IN_AFTER_DEATH_ARREST
{0xac806c4cab973517, 0xfde06c }, // SET_FADE_IN_AFTER_LOAD
{0xb2c69e11a37b5af0, 0xfdd5c8 }, // OVERRIDE_SAVE_HOUSE
{0x867654cbc7606f2c, 0xfde9c4 }, // SHOOT_SINGLE_BULLET_BETWEEN_COORDS
{0xdcb8ddd5d054a7e7, 0xfda25c }, // GET_MODEL_DIMENSIONS
{0x4ed6cfdfe8d4131a, 0xfdb7d8 }, // IS_BIT_SET
{0xf4d8bcd052e7ea1b, 0xfdbb6c }, // IS_MINIGAME_IN_PROGRESS
{0x4fb556acefa93098, 0xfdea40 }, // SHOULD_USE_METRIC_MEASUREMENTS
{0xbfbb74a15efc149b, 0xfd8f44 }, // COMPARE_STRINGS
{0xc214d5b8a38c828, 0xfd8594 }, // ABSI
{0x134549b388167cbf, 0xfd857c }, // ABSF
{0x5b0061efdfc8941, 0xfdbcc0 }, // IS_PROJECTILE_IN_AREA
{0x4965fb9e14235c7, 0xfdbd30 }, // IS_PROJECTILE_TYPE_IN_AREA
{0x928431f4133cd3d4, 0xfdbcec }, // IS_PROJECTILE_TYPE_IN_ANGLED_AREA
{0xf51c9baad9ed64c4, 0xfdbd68 }, // _IS_PROJECTILE_TYPE_IN_RADIUS
{0xd73c960a681052df, 0xfd9990 }, // _GET_PROJECTILE_NEAR_PED_COORDS
{0x9578986a6105a6ad, 0xfda524 }, // _GET_PROJECTILE_NEAR_PED
{0x9d09d8493747cf02, 0xfdb868 }, // IS_BULLET_IN_ANGLED_AREA
{0xc652fd308772d79e, 0xfdb89c }, // IS_BULLET_IN_AREA
{0xc128137c52152741, 0xfdb8cc }, // IS_BULLET_IN_BOX
{0xc153e5bccf411814, 0xfdaa50 }, // HAS_BULLET_IMPACTED_IN_AREA
{0x3b6a4c05fb2b33ac, 0xfdaa88 }, // HAS_BULLET_IMPACTED_IN_BOX
{0x88cfae250d3e0c71, 0xf54aa0 }, // IS_ORBIS_VERSION
{0xd1ccc2a2639d325f, 0xf54aa0 }, // IS_DURANGO_VERSION
{0xb0fb6cfaa5a1c833, 0xfd8628 }, // IS_PC_VERSION
{0x602102324604d96b, 0xfdbdfc }, // IS_STRING_NULL
{0x2cf12f9acf18f048, 0xfdbe10 }, // IS_STRING_NULL_OR_EMPTY
{0xd3852f22ab713a1f, 0xfd8870 }, // ARE_STRINGS_EQUAL
{0x9382d5d43d2aa6ff, 0xfdeb98 }, // _DOES_STRING_EXIST_IN_STRING
{0xf2dd2298b3af23e2, 0xfdec0c }, // STRING_TO_INT
{0xcf11c0ceb40c401b, 0xfdaca0 }, // _STRING_FORMAT_INT
{0xfa925ac00eb830b9, 0xff06c4 }, // _CREATE_VAR_STRING
{0x324dc1cef57f31e6, 0xfddc08 }, // SET_BITS_IN_RANGE
{0x68e1352af48f905d, 0xfd97b8 }, // GET_BITS_IN_RANGE
{0xfaec088d28b1de4a, 0xfde0e8 }, // SET_GAME_PAUSED
{0x3215376e79f6ea18, 0xfde824 }, // SET_THIS_SCRIPT_CAN_BE_PAUSED
{0x8abd939c2e5d00ed, 0xfde848 }, // SET_THIS_SCRIPT_CAN_REMOVE_BLIPS_CREATED_BY_ANY_SCRIPT
{0xea6dc3a8add2005f, 0xfdd80c }, // POPULATE_NOW
{0xf7ac7dc0dee7c9be, 0xfd8f74 }, // _COPY_MEMORY
{0x50e52637ef70ef77, 0xfd954c }, // ENABLE_DISPATCH_SERVICE
{0x66947e61a44de2c6, 0xfd8bd4 }, // BLOCK_DISPATCH_SERVICE_RESOURCE_CREATION
{0x3f892caf67444ae7, 0xfd8fd0 }, // CREATE_INCIDENT
{0x5cfd0f0d6aae0aee, 0xfd909c }, // DELETE_INCIDENT
{0x39f2b1bad412246a, 0xfdb9f8 }, // IS_INCIDENT_VALID
{0x5ebda1a3b8cb5ef7, 0xfd8674 }, // ADD_POP_MULTIPLIER_AREA
{0x3ba619c81a646b3, 0xfd9320 }, // DOES_POP_MULTIPLIER_AREA_EXIST
{0x88cb484364efb37a, 0xfdd958 }, // REMOVE_POP_MULTIPLIER_AREA
{0xc7817264bc4b6377, 0xfdda38 }, // RESET_DISPATCH_IDEAL_SPAWN_DISTANCE
{0xeab6823b82fbd283, 0xfddf70 }, // SET_DISPATCH_IDEAL_SPAWN_DISTANCE
{0x49f751f6868ddc5b, 0xfdd928 }, // REMOVE_DISPATCH_SPAWN_BLOCKING_AREA
{0x44131118d8db3cd, 0xfd91c0 }, // DISPLAY_ONSCREEN_KEYBOARD
{0x37df360f235a3893, 0xfdedd0 }, // UPDATE_ONSCREEN_KEYBOARD
{0xafb4cf58a4a292b1, 0xfda408 }, // GET_ONSCREEN_KEYBOARD_RESULT
{0x58a39be597ce99cd, 0xfd8c58 }, // _CANCEL_ONSCREEN_KEYBOARD
{0x7acf124c12a2b045, 0xfd85cc }, // _REMOVE_STEALTH_KILL
{0xb3e9be963f10c445, 0xfde768 }, // SET_SUPER_JUMP_THIS_FRAME
{0x29d1f6df864a094e, 0xfdeb20 }, // _START_BENCHMARK_RECORDING
{0xb89aec71aff2b599, 0xfdeb7c }, // _STOP_BENCHMARK_RECORDING
{0xecbabd0307fb216f, 0xfdda8c }, // _RESET_BENCHMARK_RECORDING
{0xf4743e2ecc02b3da, 0xfddb30 }, // _SAVE_BENCHMARK_RECORDING
{0x4ffa0386a6216113, 0xf54aa0 }, // _UI_IS_SINGLEPLAYER_PAUSE_MENU_ACTIVE
{0x22fc52cf470cc98d, 0xfd9780 }, // _GET_BENCHMARK_ITERATIONS_FROM_COMMAND_LINE
{0x9297dacf3a2cdff7, 0xfd979c }, // _GET_BENCHMARK_PASS_FROM_COMMAND_LINE
{0xfcc24220fddac929, 0x1084ff0 }, // _CASH_INVENTORY_TRANSACTION_READY_FOR_TRANSITIONING
{0xffea09ccec4af32f, 0x1085168 }, // _CASH_INVENTORY_TRANSACTION_FIRE_AND_FORGET_ITEM
{0xf039ec27f4490e96, 0x1085204 }, // _CASH_INVENTORY_TRANSACTION_START
{0x52a226adf4a270d2, 0x1084f1c }, // _CASH_INVENTORY_TRANSACTION_FIND
{0x59ef5d516e2d96b9, 0x1085144 }, // _CASH_INVENTORY_TRANSACTION_DELETE
{0x3745c002f5a21c45, 0x108508c }, // _CASH_INVENTORY_TRANSACTION_ADD_ITEM_WITH_INGREDIENTS
{0xcf2d04d076847478, 0x10851e4 }, // _CASH_INVENTORY_TRANSACTION_GET_NUMBER_ITEMS
{0x592bc00bf6629be7, 0x10850f8 }, // _CASH_INVENTORY_TRANSACTION_CHECKOUT
{0x26c008791d066f37, 0x108511c }, // _CASH_INVENTORY_TRANSACTION_CHECKOUT_STATUS
{0x1077788e268557c2, 0x10881cc }, // NETWORK_IS_SIGNED_ONLINE
{0x85443ff4c328f53b, 0x10879d0 }, // _NETWORK_ARE_ROS_AVAILABLE
{0x9a4cf4f48ad77302, 0x1087c28 }, // NETWORK_IS_CLOUD_AVAILABLE
{0x8db296b814edda07, 0x1087e1c }, // NETWORK_IS_HOST
{0x25cb5a9f37bfd063, 0x1087a10 }, // NETWORK_HAVE_ONLINE_PRIVILEGES
{0xaf50da1a3f8b1ba4, 0x108686c }, // NETWORK_CAN_ACCESS_MULTIPLAYER
{0xcef70aa5b3f89ba1, 0x10888fc }, // NETWORK_SESSION_IS_PRIVATE
{0x6d03bfbd643b2a02, 0x1086f7c }, // _NETWORK_GET_SERVER_TIME
{0xd972df67326f966e, 0x10869fc }, // NETWORK_CLEAR_CLOCK_TIME_OVERRIDE
{0xd7c95d322ff57522, 0x1087c0c }, // NETWORK_IS_CLOCK_TIME_OVERRIDDEN
{0xdddf64c91bfcf0aa, 0x1087c90 }, // NETWORK_IS_FINDING_GAMERS
{0x6d14ccee1b40381a, 0x1086a04 }, // NETWORK_CLEAR_FOUND_GAMERS
{0x86e0660e4f5c956d, 0x1086a10 }, // NETWORK_CLEAR_GET_GAMER_STATUS
{0x10fab35428ccc9d7, 0x1087de8 }, // NETWORK_IS_GAME_IN_PROGRESS
{0xd83c2b94e7508980, 0x10881b0 }, // NETWORK_IS_SESSION_ACTIVE
{0xca97246103b63917, 0x1087ecc }, // NETWORK_IS_IN_SESSION
{0x9de624d2fc4b603f, 0x1087ecc }, // NETWORK_IS_SESSION_STARTED
{0x4eebc3694e49c572, 0x1086940 }, // NETWORK_CAN_SESSION_END
{0x2fc5650b0271cb57, 0x1087e94 }, // NETWORK_IS_IN_PLATFORM_PARTY
{0xe30cf56f1efa5f43, 0x1087320 }, // NETWORK_GET_RANDOM_INT_RANGED
{0x1ca59e306ecb80a5, 0x1088f38 }, // NETWORK_SET_THIS_SCRIPT_IS_NETWORK_SCRIPT
{0x2910669969e9535e, 0x1087600 }, // NETWORK_GET_THIS_SCRIPT_IS_NETWORK_SCRIPT
{0xa6c90fbc38e395ee, 0x10870a4 }, // _NETWORK_GET_NUM_PARTICIPANTS_HOST
{0x18d0456e86604654, 0x108712c }, // NETWORK_GET_NUM_PARTICIPANTS
{0x57d158647a6bfabf, 0x1087578 }, // NETWORK_GET_SCRIPT_STATUS
{0x3e9b2f01c50df595, 0x10883b0 }, // NETWORK_REGISTER_HOST_BROADCAST_VARIABLES
{0x3364aa97340ca215, 0x10883c4 }, // NETWORK_REGISTER_PLAYER_BROADCAST_VARIABLES
{0x24fb80d107371267, 0x10872c0 }, // NETWORK_GET_PLAYER_INDEX
{0x1b84df6af2a46938, 0x10871f0 }, // NETWORK_GET_PARTICIPANT_INDEX
{0x6c0e2e0125610278, 0x10872e0 }, // NETWORK_GET_PLAYER_INDEX_FROM_PED
{0xa4a79dd2d9600654, 0x10870f4 }, // NETWORK_GET_NUM_CONNECTED_PLAYERS
{0x93dc1be4e1abe9d1, 0x1088008 }, // NETWORK_IS_PLAYER_CONNECTED
{0xcf61d4b4702ee9eb, 0x1087660 }, // NETWORK_GET_TOTAL_NUM_PLAYERS
{0x6ff8ff40b6357d45, 0x1087f08 }, // NETWORK_IS_PARTICIPANT_ACTIVE
{0xb8dfd30d6973e135, 0x1087f70 }, // NETWORK_IS_PLAYER_ACTIVE
{0x3ca58f6cb7cbd784, 0x1087f94 }, // NETWORK_IS_PLAYER_A_PARTICIPANT
{0x83cd99a1e6061ab5, 0x1087e38 }, // NETWORK_IS_HOST_OF_THIS_SCRIPT
{0x3b3d11cd9ffcdfc9, 0x1088e40 }, // NETWORK_SET_MISSION_FINISHED
{0x9d40df90fad26098, 0x1088148 }, // NETWORK_IS_SCRIPT_ACTIVE
{0x3658e8cd94fc121a, 0x108717c }, // NETWORK_GET_NUM_SCRIPT_PARTICIPANTS
{0x90986e8876ce0a83, 0x1089498 }, // PARTICIPANT_ID
{0x57a3bddad8e5aa0a, 0x1089498 }, // PARTICIPANT_ID_TO_INT
{0x7a1adeef01740a24, 0x1086d80 }, // NETWORK_GET_DESTROYER_OF_NETWORK_ID
{0x4caca84440fa26f6, 0x1086c78 }, // _NETWORK_GET_DESTROYER_OF_ENTITY
{0x42b2daa6b596f5f8, 0x1086e30 }, // NETWORK_GET_ENTITY_KILLER_OF_PLAYER
{0xea23c49eaa83acfb, 0x10886ac }, // NETWORK_RESURRECT_LOCAL_PLAYER
{0x2d95c7e2d7e07307, 0x1088e18 }, // NETWORK_SET_LOCAL_PLAYER_INVINCIBLE_TIME
{0x524ff0aeff9c3973, 0x1088e30 }, // NETWORK_SET_LOCAL_PLAYER_SYNC_LOOK_AT
{0xa11700682f3ad45c, 0x108577c }, // NETWORK_GET_NETWORK_ID_FROM_ENTITY
{0xce4e5d9b0a4ff560, 0x1086dcc }, // NETWORK_GET_ENTITY_FROM_NETWORK_ID
{0xc7827959479dcc78, 0x1086e0c }, // NETWORK_GET_ENTITY_IS_NETWORKED
{0x6faacd625d80caa, 0x10883a4 }, // NETWORK_REGISTER_ENTITY_AS_NETWORKED
{0x38ce16c96bd11344, 0x1086bdc }, // NETWORK_DOES_NETWORK_ID_EXIST
{0xa670b3662faffbd0, 0x1088560 }, // NETWORK_REQUEST_CONTROL_OF_NETWORK_ID
{0x4d36070fe0215186, 0x10877c8 }, // NETWORK_HAS_CONTROL_OF_NETWORK_ID
{0xb69317bf5e782347, 0x108853c }, // NETWORK_REQUEST_CONTROL_OF_ENTITY
{0x1bf60a500e28887, 0x10877a4 }, // NETWORK_HAS_CONTROL_OF_ENTITY
{0x5bc9495f0b3b6fa6, 0x10877ec }, // NETWORK_HAS_CONTROL_OF_PICKUP
{0xb4c94523f023419c, 0x108577c }, // VEH_TO_NET
{0xedec3c276198689, 0x108577c }, // PED_TO_NET
{0x99bfdc94a603e541, 0x108577c }, // OBJ_TO_NET
{0x367b936610ba360c, 0x1086dcc }, // NET_TO_VEH
{0xbdcd95fc216a8b3e, 0x1086dcc }, // NET_TO_PED
{0xd8515f5fea14cb3f, 0x1086dcc }, // NET_TO_OBJ
{0xbffeab45a9a9094a, 0x1086dcc }, // NET_TO_ENT
{0xe86051786b66cd8e, 0x1087074 }, // NETWORK_GET_LOCAL_HANDLE
{0x388eb2b86c73b6b3, 0x10876ec }, // NETWORK_HANDLE_FROM_PLAYER
{0xbc1d768f2f5d6c05, 0x10876fc }, // NETWORK_HASH_FROM_PLAYER_HANDLE
{0xd45cb817d7e177d2, 0x10876dc }, // NETWORK_HANDLE_FROM_FRIEND
{0x426141162ebe5cdb, 0x1086e9c }, // NETWORK_GET_GAMERTAG_FROM_HANDLE
{0x57dba049e110f217, 0x108649c }, // NETWORK_ARE_HANDLES_THE_SAME
{0x6f79b93b0a8e4133, 0x1087df8 }, // NETWORK_IS_HANDLE_VALID
{0xce5f689cf5a0a49d, 0x108725c }, // NETWORK_GET_PLAYER_FROM_GAMER_HANDLE
{0xf10b05ddf8d16e9, 0x108695c }, // NETWORK_IS_GAMER_IN_MY_SESSION
{0x859ed1cea343fca8, 0x1088f68 }, // NETWORK_SHOW_PROFILE_UI
{0x1a24a179f9b31654, 0x1087cb4 }, // NETWORK_IS_FRIEND
{0xbe73da6984a6e33, 0xf54aa0 }, // NETWORK_IS_PENDING_FRIEND
{0x8e02d73914064223, 0x10863e4 }, // NETWORK_ADD_FRIEND
{0xf808475fa571d823, 0x1088d74 }, // NETWORK_SET_FRIENDLY_FIRE_OPTION
{0x1dccacdcfc569362, 0x1088f00 }, // NETWORK_SET_RICH_PRESENCE
{0x5ed0356a0ce3a34f, 0x1087624 }, // NETWORK_GET_TIMEOUT_TIME
{0xe05e81a888fa63c8, 0x1089b08 }, // SET_NETWORK_ID_EXISTS_ON_ALL_MACHINES
{0xa8a024587329f36a, 0x1089af0 }, // _SET_NETWORK_ID_SYNC_TO_PLAYER
{0xf1ca12b18aef5298, 0x1088d4c }, // _NETWORK_SET_ENTITY_INVISIBLE_TO_NETWORK
{0xa6928482543022b4, 0x1089b30 }, // SET_NETWORK_ID_VISIBLE_IN_CUTSCENE
{0xa1607996431332df, 0x10860f4 }, // _NETWORK_CAN_NETWORK_ID_BE_SEEN
{0xd1065d68947e7b6e, 0x1089ab4 }, // SET_LOCAL_PLAYER_VISIBLE_IN_CUTSCENE
{0xe5f773c1a1d9d168, 0x1089a8c }, // SET_LOCAL_PLAYER_INVISIBLE_LOCALLY
{0x12b37d54667db0b8, 0x108a034 }, // SET_PLAYER_INVISIBLE_LOCALLY
{0xfaa10f1fafb11af2, 0x108a048 }, // SET_PLAYER_VISIBLE_LOCALLY
{0xe0031d3c8f36ab82, 0x1089910 }, // SET_ENTITY_VISIBLE_IN_CUTSCENE
{0x6e192e33ad436366, 0x1086008 }, // IS_DAMAGE_TRACKER_ACTIVE_ON_NETWORK_ID
{0xd45b1ffccd52ff19, 0x1084c54 }, // ACTIVATE_DAMAGE_TRACKER_ON_NETWORK_ID
{0xd82cf8e64c8729d8, 0x1086220 }, // IS_SPHERE_VISIBLE_TO_ANOTHER_MACHINE
{0xdc3a310219e5da62, 0x108624c }, // IS_SPHERE_VISIBLE_TO_PLAYER
{0x4e5c93bd0c32fbf8, 0x10896e0 }, // RESERVE_NETWORK_MISSION_OBJECTS
{0xb60feba45333d36f, 0x10896f8 }, // RESERVE_NETWORK_MISSION_PEDS
{0x76b02e21ed27a469, 0x1089728 }, // RESERVE_NETWORK_MISSION_VEHICLES
{0x800dd4721a8b008b, 0x1084dd4 }, // CAN_REGISTER_MISSION_OBJECTS
{0xbcbf4fef9fa5d781, 0x1084df8 }, // CAN_REGISTER_MISSION_PEDS
{0x7277f1f2e085ee74, 0x1084e40 }, // CAN_REGISTER_MISSION_VEHICLES
{0x69778e7564bade6d, 0x1084da4 }, // CAN_REGISTER_MISSION_ENTITIES
{0xaa81b5f10bc43ac2, 0x1085b10 }, // GET_NUM_RESERVED_MISSION_OBJECTS
{0x1f13d5ae5cb17e17, 0x1085b34 }, // GET_NUM_RESERVED_MISSION_PEDS
{0xcf3a965906452031, 0x1085b7c }, // GET_NUM_RESERVED_MISSION_VEHICLES
{0x7a5487fe9faa6b48, 0x1085a28 }, // GET_NETWORK_TIME
{0x89023fbbf9200e9f, 0x1085a44 }, // GET_NETWORK_TIME_ACCURATE
{0x46718aceedeafc84, 0x1085f74 }, // HAS_NETWORK_TIME_STARTED
{0x17008ccdad48503, 0x1085ed4 }, // GET_TIME_OFFSET
{0xcb2cf5148012c8d0, 0x108627c }, // IS_TIME_LESS_THAN
{0xde350f8651e4346c, 0x1086290 }, // IS_TIME_MORE_THAN
{0xa2c6fc031d46fff0, 0x1085ec4 }, // GET_TIME_DIFFERENCE
{0x9a73240b49945c76, 0x10858cc }, // GET_CLOUD_TIME_AS_INT
{0xac97af97fa68e5d5, 0x108530c }, // _GET_DATE_AND_TIME_FROM_UNIX_EPOCH
{0x423de3854bb50894, 0x1088df0 }, // NETWORK_SET_IN_SPECTATOR_MODE
{0x48746e388762e11, 0x1087ee8 }, // NETWORK_IS_IN_SPECTATOR_MODE
{0x9ca5de655269fec4, 0x1088dcc }, // NETWORK_SET_IN_MP_CUTSCENE
{0x6cc27c9fa2040220, 0x1087e70 }, // NETWORK_IS_IN_MP_CUTSCENE
{0x63f9ee203c3619f2, 0x1088068 }, // NETWORK_IS_PLAYER_IN_MP_CUTSCENE
{0x5ffe9b4144f9712f, 0x1089a5c }, // USE_PLAYER_COLOUR_INSTEAD_OF_TEAM_COLOUR
{0xd0afaff5a51d72f7, 0x1086c4c }, // NETWORK_END_TUTORIAL_SESSION
{0xada24309fe08dacf, 0x1087e54 }, // NETWORK_IS_IN_TUTORIAL_SESSION
{0x9de986fc9a87c474, 0x10864e8 }, // _NETWORK_IS_PLAYER_EQUAL_TO_INDEX
{0xbbdf066252829606, 0x1086b08 }, // NETWORK_CONCEAL_PLAYER
{0x919b3c98ed8292f9, 0x1087fe4 }, // NETWORK_IS_PLAYER_CONCEALED
{0x467c11ed88b7d28, 0x1088238 }, // NETWORK_IS_TUNABLE_CLOUD_REQUEST_PENDING
{0x85e5f8b9b898b20a, 0x1086c00 }, // NETWORK_DOES_TUNABLE_EXIST
{0x8be1146dfd5d4468, 0x1086374 }, // NETWORK_ACCESS_TUNABLE_INT
{0xaa6a47a573abb75a, 0x108634c }, // NETWORK_ACCESS_TUNABLE_BOOL
{0x7fd2990af016795e, 0x108a894 }, // UGC_REQUEST_CONTENT_DATA_FROM_PARAMS
{0x5e0165278f6339ee, 0x108a86c }, // UGC_REQUEST_CACHED_DESCRIPTION
{0x16160da74a8e74a2, 0x108a1e8 }, // TEXTURE_DOWNLOAD_REQUEST
{0x308f96458b7087cc, 0x108a8e0 }, // UGC_TEXTURE_DOWNLOAD_REQUEST
{0x487eb90b98e9fb19, 0x108a1c0 }, // TEXTURE_DOWNLOAD_RELEASE
{0x3448505b6e35262d, 0x108a198 }, // TEXTURE_DOWNLOAD_GET_NAME
{0x8bd6c6dea20e82c6, 0x1085ea4 }, // _GET_STATUS_OF_TEXTURE_DOWNLOAD
{0x8020a73847e0ca7d, 0x1087a2c }, // _NETWORK_HAS_PLAYER_BEEN_BANNED
{0xa699957e60d80214, 0x10878ac }, // NETWORK_HAS_ROS_PRIVILEGE
{0xff8fcf9ffc458a1c, 0x10871a4 }, // _NETWORK_GET_NUM_UNACKED_FOR_PLAYER
{0x52c1eadaf7b10302, 0x1086f90 }, // _NETWORK_GET_OLDEST_RESEND_COUNT_FOR_PLAYER
{0x509d5878eb39e842, 0x108532c }, // CREATE_OBJECT
{0x9a294b2138abb884, 0x1085388 }, // CREATE_OBJECT_NO_OFFSET
{0x931914268722c263, 0x10854c8 }, // DELETE_OBJECT
{0x58a850eaee20faa3, 0x1089544 }, // PLACE_OBJECT_ON_GROUND_PROPERLY
{0x2fdff4107b8c1147, 0x108a12c }, // SLIDE_OBJECT
{0x8a7391690f5afd81, 0x1089ed0 }, // SET_OBJECT_TARGETTABLE
{0xe143fa2249364369, 0x1085884 }, // GET_CLOSEST_OBJECT_OF_TYPE
{0x8abfb70c49cc43e2, 0x1085f98 }, // HAS_OBJECT_BEEN_BROKEN
{0x761b0e69ac4d007e, 0x1085f44 }, // HAS_CLOSEST_OBJECT_OF_TYPE_BEEN_BROKEN
{0x163e252de035a133, 0x1085c38 }, // _GET_OBJECT_OFFSET_FROM_COORDS
{0x464d8e1427156fe4, 0x10895fc }, // REMOVE_DOOR_FROM_SYSTEM
{0x6bab9442830c7f53, 0x108573c }, // DOOR_SYSTEM_SET_DOOR_STATE
{0x160aa1b32f6139b8, 0x1085690 }, // DOOR_SYSTEM_GET_DOOR_STATE
{0x3c27e13b42a0e82, 0x108572c }, // DOOR_SYSTEM_SET_AUTOMATIC_RATE
{0x9ba001cb45cbf627, 0x108571c }, // DOOR_SYSTEM_SET_AUTOMATIC_DISTANCE
{0xb6e6fba95c7324ac, 0x108574c }, // DOOR_SYSTEM_SET_OPEN_RATIO
{0x65499865fca6e5ec, 0x10856b0 }, // DOOR_SYSTEM_GET_OPEN_RATIO
{0xc153c43ea202c8c1, 0x1086088 }, // IS_DOOR_REGISTERED_WITH_SYSTEM
{0xc531ee8a1145a149, 0x108602c }, // IS_DOOR_CLOSED
{0xbfa48e2ff417213f, 0x10854e0 }, // DOES_OBJECT_OF_TYPE_EXIST_AT_COORDS
{0x2a70bae8883e4c81, 0x10861ac }, // IS_POINT_IN_ANGLED_AREA
{0xf6df6e90de7df90f, 0x1089dc0 }, // SET_OBJECT_PHYSICS_PARAMS
{0xb6fbfd079b8d0596, 0x1085bc4 }, // GET_OBJECT_FRAGMENT_DAMAGE_HEALTH
{0x406137f8ef90eaf5, 0x1089770 }, // SET_ACTIVATE_OBJECT_PHYSICS_AS_SOON_AS_IT_IS_UNFROZEN
{0xb252bc036b525623, 0x108a250 }, // TRACK_OBJECT_VISIBILITY
{0x8b32ace6326a7546, 0x108613c }, // IS_OBJECT_VISIBLE
{0xb48fced898292e52, 0x1085d14 }, // GET_RAYFIRE_MAP_OBJECT
{0x5c29f698d404c5e1, 0x108a0e0 }, // SET_STATE_OF_RAYFIRE_MAP_OBJECT
{0x899ba936634a322e, 0x1085e2c }, // GET_STATE_OF_RAYFIRE_MAP_OBJECT
{0x52af537a0c5b8aad, 0x1085598 }, // DOES_RAYFIRE_MAP_OBJECT_EXIST
{0x260ee4fdbdf4db01, 0x1085d3c }, // GET_RAYFIRE_MAP_OBJECT_ANIM_PHASE
{0xfba08c503dd5fa58, 0x10853fc }, // CREATE_PICKUP
{0x891804727e0a98b7, 0x1085450 }, // CREATE_PICKUP_ROTATE
{0x673966a0c0fd7171, 0x108531c }, // CREATE_AMBIENT_PICKUP
{0x2eaf1fdb2fb55698, 0x1085460 }, // CREATE_PORTABLE_PICKUP
{0x8dc39368bdd57755, 0x1084cf8 }, // ATTACH_PORTABLE_PICKUP_TO_PED
{0xcf463d1e9a0aecb1, 0x10854d4 }, // DETACH_PORTABLE_PICKUP_FROM_PED
{0x6e16bc2503ff1ff0, 0x1085d94 }, // GET_SAFE_PICKUP_COORDS
{0x225b8b35c88029b3, 0x1085c88 }, // GET_PICKUP_COORDS
{0x27f9d613092159cf, 0x10895e0 }, // REMOVE_ALL_PICKUPS_OF_TYPE
{0x80ec48e6679313f9, 0x1085fd0 }, // HAS_PICKUP_BEEN_COLLECTED
{0x3288d8acaecd2ab2, 0x1089608 }, // REMOVE_PICKUP
{0xafc1ca75ad4074d1, 0x1085514 }, // DOES_PICKUP_EXIST
{0xd9efb6dbf7daaea3, 0x1085548 }, // DOES_PICKUP_OBJECT_EXIST
{0x5099bc55630b25ae, 0x1085cd0 }, // GET_PICKUP_OBJECT
{0xf9c36251f6e48e33, 0x108556c }, // DOES_PICKUP_OF_TYPE_EXIST_IN_AREA
{0x78015c9b4b3ecc9d, 0x108a010 }, // SET_PICKUP_REGENERATION_TIME
{0x88eaec617cd26926, 0x1089a9c }, // _SET_LOCAL_PLAYER_CAN_USE_PICKUPS_WITH_THIS_MODEL
{0x53e0df1a2a3cf0ca, 0x108a0f0 }, // SET_TEAM_PICKUP_OBJECT
{0x318516e02de3ece2, 0x1089f6c }, // SET_PICKUP_GENERATION_RANGE_MULTIPLIER
{0x8f96ca6c551ad51, 0x1085f24 }, // GET_WEAPON_TYPE_FROM_PICKUP_TYPE
{0x971da0055324d033, 0x1089f14 }, // _SET_OBJECT_TEXTURE_VARIATION
{0x5eaad83f8cfb4575, 0x10852ec }, // _GET_PICKUP_HASH
{0xf538081986e49e9d, 0x1089930 }, // SET_FORCE_OBJECT_THIS_FRAME
{0xadbe4809f19f927a, 0x108948c }, // _MARK_OBJECT_FOR_DELETION
{0x1cea6bfdf248e5d9, 0xf80b90 }, // IS_CONTROL_ENABLED
{0xf3a21bcd95725a4a, 0xf80c7c }, // IS_CONTROL_PRESSED
{0x648ee3e7f38877dd, 0xf80ca4 }, // IS_CONTROL_RELEASED
{0x580417101ddb492f, 0xf80c2c }, // IS_CONTROL_JUST_PRESSED
{0x50f940259d3841e6, 0xf80c54 }, // IS_CONTROL_JUST_RELEASED
{0xd95e79e8686d2c27, 0xf7ccb4 }, // GET_CONTROL_VALUE
{0xec3c9b8d5327b563, 0xf7cbfc }, // GET_CONTROL_NORMAL
{0x5b84d09cec5209c5, 0xf7cc20 }, // GET_CONTROL_UNBOUND_NORMAL
{0xe8a25867fba3b05e, 0xf85f90 }, // _SET_CONTROL_NORMAL
{0xe2587f8cbbd87b1d, 0xf80d44 }, // IS_DISABLED_CONTROL_PRESSED
{0x91aef906bca88877, 0xf80cf4 }, // IS_DISABLED_CONTROL_JUST_PRESSED
{0x305c8dcd79da8b0f, 0xf80d1c }, // IS_DISABLED_CONTROL_JUST_RELEASED
{0x11e65974a982637c, 0xf7ce74 }, // GET_DISABLED_CONTROL_NORMAL
{0x4f8a26a890fd62fb, 0xf7ce98 }, // GET_DISABLED_CONTROL_UNBOUND_NORMAL
{0xa571d46727e2b718, 0xf83650 }, // _IS_INPUT_DISABLED
{0x48b3886c1358d0d5, 0xf85f3c }, // SET_PAD_SHAKE
{0x38c16a305e8cdc8d, 0xf8c754 }, // STOP_PAD_SHAKE
{0x77b612531280010d, 0xf80ed8 }, // IS_LOOK_INVERTED
{0xede476e5ee29edb1, 0xf86a4c }, // SET_INPUT_EXCLUSIVE
{0xfe99b66d079cf6bc, 0xf7bb8c }, // DISABLE_CONTROL_ACTION
{0x351220255d64c155, 0xf7c16c }, // ENABLE_CONTROL_ACTION
{0x5f4b6931816e599b, 0xf7baa0 }, // DISABLE_ALL_CONTROL_ACTIONS
{0xbf1a602b5ba52fee, 0xf8ba94 }, // SET_ROADS_IN_AREA
{0x1a5aa1208af5db59, 0xf8ba4c }, // SET_ROADS_IN_ANGLED_AREA
{0x1ee7063b80ffc77c, 0xf8ba04 }, // SET_ROADS_BACK_TO_ORIGINAL
{0x27501b9f3b407e, 0xf8ba20 }, // SET_ROADS_BACK_TO_ORIGINAL_IN_ANGLED_AREA
{0x240a18690ae96513, 0xf7cb68 }, // GET_CLOSEST_VEHICLE_NODE
{0x23cffd4ccb243354, 0xf7cb88 }, // GET_CLOSEST_VEHICLE_NODE_WITH_HEADING
{0x5a6d8df6fbc5d0c4, 0xf7d820 }, // GET_NTH_CLOSEST_VEHICLE_NODE
{0x116443008e5cefc3, 0xf7d840 }, // GET_NTH_CLOSEST_VEHICLE_NODE_ID
{0x591b40d4390db54a, 0xf7d8bc }, // GET_NTH_CLOSEST_VEHICLE_NODE_WITH_HEADING
{0x4114eaa8a7f7766d, 0xf7d874 }, // GET_NTH_CLOSEST_VEHICLE_NODE_ID_WITH_HEADING
{0x2fac235a6062f14a, 0xf7d830 }, // GET_NTH_CLOSEST_VEHICLE_NODE_FAVOUR_DIRECTION
{0x5829a02af4f0b3cb, 0xf8370c }, // IS_VEHICLE_NODE_ID_VALID
{0x8e8d72ff24dee1fb, 0xf80108 }, // GET_VEHICLE_NODE_POSITION
{0x28533dbddf7c2c97, 0xf800c4 }, // GET_VEHICLE_NODE_IS_SWITCHED_OFF
{0x132f52bba570fe92, 0xf7cb58 }, // GET_CLOSEST_ROAD
{0xf7b79a50b905a30d, 0xf79ccc }, // _ARE_PATH_NODES_LOADED_IN_AREA
{0x93e0db8440b73a7d, 0xf7f8a0 }, // GET_RANDOM_VEHICLE_NODE
{0x125bf4abfc536b09, 0xf8331c }, // IS_POINT_ON_ROAD
{0x34f060f4bf92e018, 0xf89a94 }, // SET_PED_PATHS_IN_AREA
{0xb61c8e878a4199ca, 0xf7fa04 }, // GET_SAFE_COORD_FOR_PED
{0xe04b48f2cc926253, 0xf89a7c }, // SET_PED_PATHS_BACK_TO_ORIGINAL
{0x387ead7ee42f6685, 0xf79880 }, // ADD_NAVMESH_REQUIRED_REGION
{0xf813c7e63f9062a5, 0xf81000 }, // IS_NAVMESH_LOADED_IN_AREA
{0xfcd5c8e06e502f5a, 0xf79808 }, // ADD_NAVMESH_BLOCKING_OBJECT
{0x46399a7895957c0e, 0xf84d54 }, // REMOVE_NAVMESH_BLOCKING_OBJECT
{0xeaeb0db4b132399, 0xf7bd24 }, // DOES_NAVMESH_BLOCKING_OBJECT_EXIST
{0xb919e1fb47cc4e0, 0xf85dd8 }, // SET_AMBIENT_PED_RANGE_MULTIPLIER_THIS_FRAME
{0x72751156e7678833, 0xf0498 }, // SET_IGNORE_NO_GPS_FLAG
{0xd49f9b0955c367de, 0xf7b638 }, // CREATE_PED
{0xcc0ef140f99365c5, 0xf7b8c4 }, // DELETE_PED
{0xef29a16337facadb, 0xf7b2dc }, // CLONE_PED
{0xe952d6431689ad9a, 0xf7b314 }, // CLONE_PED_TO_TARGET
{0xa3ee4a07279bb9db, 0xf82038 }, // IS_PED_IN_VEHICLE
{0x796d90efb19aa332, 0xf81f64 }, // IS_PED_IN_MODEL
{0x997abd671d25ca0b, 0xf81e14 }, // IS_PED_IN_ANY_VEHICLE
{0x84a2dd9ac37c35c1, 0xf81b70 }, // IS_PED_INJURED
{0xd839450756ed5a80, 0xf81738 }, // IS_PED_FATALLY_INJURED
{0x3317dedb88c95038, 0xf81410 }, // IS_PED_DEAD_OR_DYING
{0x3998b1276a3300e5, 0xf810d0 }, // IS_PED_AIMING_FROM_COVER
{0x24b100c68c645951, 0xf82800 }, // IS_PED_RELOADING
{0x12534c348c6cb68b, 0xf810f4 }, // IS_PED_A_PLAYER
{0x7dd959874c1fd534, 0xf7b694 }, // CREATE_PED_INSIDE_VEHICLE
{0xaa5a7ece2aa8fe70, 0xf88120 }, // SET_PED_DESIRED_HEADING
{0xff287323b0e2c69a, 0xf7c360 }, // _FREEZE_PED_CAMERA_ROTATION
{0xd71649db0a545aa3, 0xf81634 }, // IS_PED_FACING_PED
{0x4e209b2c1ead5159, 0xf81f38 }, // IS_PED_IN_MELEE_COMBAT
{0x530944f6f4b8a214, 0xf82b2c }, // IS_PED_STOPPED
{0xa0d3d71ea1086c55, 0xf80a6c }, // IS_ANY_PED_SHOOTING_IN_AREA
{0x34616828cd07f1a1, 0xf82978 }, // IS_PED_SHOOTING
{0x7aefb85c1d49deb6, 0xf86e60 }, // SET_PED_ACCURACY
{0x37f4ad56ecbc0cd6, 0xf7dd1c }, // GET_PED_ACCURACY
{0xc9d55b1a358a5bf7, 0xf8245c }, // IS_PED_MODEL
{0x2d05ced3a38d0f3a, 0xf808d8 }, // EXPLODE_PED_HEAD
{0x5ba652a0cd14df2f, 0xf7967c }, // ADD_ARMOUR_TO_PED
{0xf75b0d629e1c063d, 0xf88f98 }, // SET_PED_INTO_VEHICLE
{0x9e8c908f41584ecd, 0xf898dc }, // SET_PED_MOVE_ANIMS_BLEND_OUT
{0x6d9f5faa7488ba46, 0xf82370 }, // IS_PED_MALE
{0xb980061da992779d, 0xf81ac8 }, // IS_PED_HUMAN
{0x9a9112a0fe9a4713, 0xf80184 }, // GET_VEHICLE_PED_IS_IN
{0xbb8de8cf6a8dd8bb, 0xf85650 }, // RESET_PED_LAST_VEHICLE
{0x7a556143a1c03898, 0xf8bc74 }, // SET_SCENARIO_PED_DENSITY_MULTIPLIER_THIS_FRAME
{0xee01041d559983ea, 0xf899c0 }, // SET_PED_NON_CREATION_AREA
{0x2e05208086ba0651, 0xf7ae28 }, // CLEAR_PED_NON_CREATION_AREA
{0x460bc76a0e10655e, 0xf82568 }, // IS_PED_ON_MOUNT
{0xe7e11b8dcbed1058, 0xf7d7c8 }, // GET_MOUNT
{0x67722aeb798e5fab, 0xf825dc }, // IS_PED_ON_VEHICLE
{0xec5f66e459af3bb2, 0xf825a8 }, // IS_PED_ON_SPECIFIC_VEHICLE
{0xa9c8960e8684c1b5, 0xf89700 }, // SET_PED_MONEY
{0x3f69145bba87bae7, 0xf7ea38 }, // GET_PED_MONEY
{0xa808aa1d79230fc2, 0xf82a88 }, // IS_PED_SITTING_IN_VEHICLE
{0x826aa586edb9fef8, 0xf82a5c }, // IS_PED_SITTING_IN_ANY_VEHICLE
{0x1fee67db37f59b2, 0xf8253c }, // IS_PED_ON_FOOT
{0xc70b5fae151982d8, 0xf82678 }, // IS_PED_PLANTING_BOMB
{0xcd5003b097200f36, 0xf7cdbc }, // GET_DEAD_PED_PICKUP_COORDS
{0x2e0e1c2b4f6cb339, 0xf81d40 }, // IS_PED_IN_ANY_BOAT
{0x298b91ae825e5705, 0xf81d6c }, // IS_PED_IN_ANY_HELI
{0x5fff4cfc74d8fb80, 0xf81d90 }, // IS_PED_IN_ANY_PLANE
{0x9134873537fa419c, 0xf81ee0 }, // IS_PED_IN_FLYING_VEHICLE
{0xd75960f6bd9ea49c, 0xf7e880 }, // GET_PED_LAST_DAMAGE_BONE
{0x8ef6b7ac68e2f01b, 0xf7ad08 }, // CLEAR_PED_LAST_DAMAGE_BONE
{0x1b1e2a40a65b8521, 0xf85d38 }, // SET_AI_WEAPON_DAMAGE_MODIFIER
{0xea16670e7ba4743c, 0xf85230 }, // RESET_AI_WEAPON_DAMAGE_MODIFIER
{0x66460deddd417254, 0xf85d14 }, // SET_AI_MELEE_WEAPON_DAMAGE_MODIFIER
{0x63f58f7c80513aad, 0xf876b0 }, // SET_PED_CAN_BE_TARGETTED
{0xbf1ca77833e58f2c, 0xf87768 }, // SET_PED_CAN_BE_TARGETTED_BY_TEAM
{0x66b57b72e0836a76, 0xf87750 }, // SET_PED_CAN_BE_TARGETTED_BY_PLAYER
{0xfb92a102f1c4dfa3, 0xf8166c }, // IS_PED_FALLING
{0xcedabc5900a0bf97, 0xf82094 }, // IS_PED_JUMPING
{0x53e8cb4f48bfe623, 0xf812fc }, // IS_PED_CLIMBING
{0x117c70d1f5730b5e, 0xf82e50 }, // IS_PED_VAULTING
{0x5527b8246fef9b11, 0xf814a0 }, // IS_PED_DIVING
{0x26af0e8e30bd2a2c, 0xf82614 }, // _IS_PED_OPENING_A_DOOR
{0x6e575d6a898ab852, 0xf81dbc }, // IS_PED_IN_ANY_TAXI
{0xf107e836a70dce05, 0xf88b04 }, // SET_PED_ID_RANGE
{0x52d59ab61ddc05dd, 0xf88aa8 }, // SET_PED_HIGHLY_PERCEPTIVE
{0xf29cf591c4bf6cee, 0xf89f68 }, // SET_PED_SEEING_RANGE
{0x33a8f7f7d5f7f33c, 0xf88a50 }, // SET_PED_HEARING_RANGE
{0x2db492222fb21e26, 0xf8a8f0 }, // SET_PED_VISUAL_FIELD_MIN_ANGLE
{0x70793bdca1e854d4, 0xf8a898 }, // SET_PED_VISUAL_FIELD_MAX_ANGLE
{0x9c74b0bc831b753a, 0xf8a948 }, // SET_PED_VISUAL_FIELD_PERIPHERAL_RANGE
{0x3b6405e8ab34a907, 0xf8a840 }, // SET_PED_VISUAL_FIELD_CENTER_ANGLE
{0x88cbb5ceb96b7bd2, 0xf2d908 }, // SET_PED_STEALTH_MOVEMENT
{0x7c2ac9ca66575fbf, 0xf7edcc }, // GET_PED_STEALTH_MOVEMENT
{0x90370ebe0fee1a3d, 0xf7b564 }, // CREATE_GROUP
{0x2a7819605465fbce, 0xf872c8 }, // SET_PED_AS_GROUP_LEADER
{0x9f3480fe65db31b5, 0xf872d8 }, // SET_PED_AS_GROUP_MEMBER
{0x2e2f4240b3f24647, 0xf87984 }, // SET_PED_CAN_TELEPORT_TO_GROUP_LEADER
{0x8eb2f69076af7053, 0xf84d38 }, // REMOVE_GROUP
{0xed74007ffb146bc2, 0xf84e10 }, // REMOVE_PED_FROM_GROUP
{0x9bb01e3834671191, 0xf818bc }, // IS_PED_GROUP_MEMBER
{0x1c86d8aef8254b78, 0xf818f8 }, // IS_PED_HANGING_ON_TO_VEHICLE
{0x4102c7858cfee4e4, 0xf8678c }, // SET_GROUP_SEPARATION_RANGE
{0xd6a86331a537a7b9, 0xf826d8 }, // IS_PED_PRONE
{0x4859f1fc66a6278e, 0xf81e40 }, // IS_PED_IN_COMBAT
{0xead42de3610d0721, 0xf7a11c }, // CAN_PED_IN_COMBAT_SEE_TARGET
{0x4ae4ff911dfb61da, 0xf82068 }, // IS_PED_JACKING
{0x9a497fe2df198913, 0xf81170 }, // IS_PED_BEING_JACKED
{0x4fbacce3b4138ee8, 0xf811c8 }, // IS_PED_BEING_STUNNED
{0x9b128dc36c1e04cf, 0xf7dcf4 }, // GET_PEDS_JACKER
{0x5486a79d9fbd342d, 0xf7d520 }, // GET_JACK_TARGET
{0xbbcce00b381f8482, 0xf8175c }, // IS_PED_FLEEING
{0x60dfd0691a170b88, 0xf81e74 }, // IS_PED_IN_COVER
{0x845333b3150583ab, 0xf81eb4 }, // IS_PED_IN_COVER_FACING_LEFT
{0x9f65dbc537e59ad5, 0xf8185c }, // IS_PED_GOING_INTO_COVER
{0x6f4c85acd641bcd2, 0xf7fb1c }, // GET_SEAT_PED_IS_TRYING_TO_ENTER
{0x93c8b64deb84728c, 0xf7ed64 }, // GET_PED_SOURCE_OF_DEATH
{0x16ffe42ab2d2dc59, 0xf7e0b8 }, // GET_PED_CAUSE_OF_DEATH
{0x1e98817b311ae98a, 0xf7edec }, // GET_PED_TIME_OF_DEATH
{0xadb3f206518799e8, 0xf89d3c }, // SET_PED_RELATIONSHIP_GROUP_DEFAULT_HASH
{0xc80a74ac829ddd92, 0xf89d4c }, // SET_PED_RELATIONSHIP_GROUP_HASH
{0xbf25eb89375a37ad, 0xf8b9bc }, // SET_RELATIONSHIP_BETWEEN_GROUPS
{0x5e29243fb56fc6d4, 0xf7b09c }, // CLEAR_RELATIONSHIP_BETWEEN_GROUPS
{0xf372bc22fcb88606, 0xf7995c }, // ADD_RELATIONSHIP_GROUP
{0xb6ba2444ab393da2, 0xf84e3c }, // REMOVE_RELATIONSHIP_GROUP
{0xeba5ad3a0eaf7121, 0xf7f8d4 }, // GET_RELATIONSHIP_BETWEEN_PEDS
{0x42fdd0f017b1e38e, 0xf7ebe8 }, // GET_PED_RELATIONSHIP_GROUP_DEFAULT_HASH
{0x7dbdd04862d95f04, 0xf7ec08 }, // GET_PED_RELATIONSHIP_GROUP_HASH
{0x9e6b70061662ae5c, 0xf7f8b0 }, // GET_RELATIONSHIP_BETWEEN_GROUPS
{0x112942c6e708f70b, 0xf8a774 }, // SET_PED_TO_INFORM_RESPECTED_FRIENDS
{0x625b774d75c87068, 0xf82850 }, // IS_PED_RESPONDING_TO_EVENT
{0x9ac577f5a12ad8a9, 0xf8847c }, // SET_PED_FIRING_PATTERN
{0x614da022990752dc, 0xf89fc0 }, // SET_PED_SHOOT_RATE
{0xff41b4b141ed981c, 0xf85f00 }, // SET_COMBAT_FLOAT
{0x52dff8a10508090a, 0xf7cb98 }, // GET_COMBAT_FLOAT
{0x8de69fe35ca09a45, 0xf7d0fc }, // GET_GROUP_SIZE
{0x7c6b0c22f9f40bbe, 0xf7bca4 }, // DOES_GROUP_EXIST
{0xf162e133b4e7a675, 0xf7e498 }, // GET_PED_GROUP_INDEX
{0x5891cac5d4acff74, 0xf81f0c }, // IS_PED_IN_GROUP
{0x6a3975dea89f9a17, 0xf7f440 }, // GET_PLAYER_PED_IS_FOLLOWING
{0xce2f5fc3af7e8c1e, 0xf86720 }, // SET_GROUP_FORMATION
{0x1d9d45004c28c916, 0xf86730 }, // SET_GROUP_FORMATION_SPACING
{0x63dab4ccb3273205, 0xf852a0 }, // RESET_GROUP_FORMATION_DEFAULT_SPACING
{0x6094ad011a2ea87d, 0xf801ac }, // GET_VEHICLE_PED_IS_USING
{0xf92691aed837a5fc, 0xf8015c }, // GET_VEHICLE_PED_IS_ENTERING
{0x9ff447b6b6ad960a, 0xf8883c }, // SET_PED_GRAVITY
{0x697157ced63f18d4, 0xf79b4c }, // APPLY_DAMAGE_TO_PED
{0xff059e1e4c01e63c, 0xf7ee7c }, // GET_PED_TYPE
{0xbb03c38dd3fb7ffd, 0xf8726c }, // SET_PED_AS_COP
{0xf5f6378c4f3419d3, 0xf893a0 }, // SET_PED_MAX_HEALTH
{0x4700a416e8324ef3, 0xf7e8c8 }, // GET_PED_MAX_HEALTH
{0x43c851690662113d, 0xf89450 }, // SET_PED_MAX_TIME_IN_WATER
{0x6ba428c528d9e522, 0xf894a8 }, // SET_PED_MAX_TIME_UNDERWATER
{0x7a6535691b477c48, 0xf875fc }, // SET_PED_CAN_BE_KNOCKED_OFF_VEHICLE
{0x51ac07a44d4f5b8a, 0xf7a020 }, // CAN_KNOCK_PED_OFF_VEHICLE
{0x45bbcba77c29a841, 0xf83754 }, // KNOCK_PED_OFF_VEHICLE
{0x51455483cf23ed97, 0xf7ddb4 }, // GET_PED_AS_GROUP_MEMBER
{0x5cce68dbd5fe93ec, 0xf7dd94 }, // GET_PED_AS_GROUP_LEADER
{0x971d38760fbc02ef, 0xf89008 }, // SET_PED_KEEP_TASK
{0x9de327631295b4c2, 0xf82b6c }, // IS_PED_SWIMMING
{0xc024869a53992f34, 0xf82be0 }, // IS_PED_SWIMMING_UNDER_WATER
{0x102e68b2024d536d, 0xf86064 }, // SET_CREATE_RANDOM_COPS
{0x6f972c1ab75a1ed0, 0xf81de8 }, // IS_PED_IN_ANY_TRAIN
{0xbb062b2b5722478e, 0xf81830 }, // IS_PED_GETTING_INTO_A_VEHICLE
{0xdf1af8b5d56542fa, 0xf8646c }, // SET_ENABLE_HANDCUFFS
{0xc52e0f855c58fc2e, 0xf863e0 }, // SET_ENABLE_BOUND_ANKLES
{0x97b0db5b4aa74e77, 0xf85774 }, // RESET_PED_WEAPON_MOVEMENT_CLIPSET
{0x22ef8ff8778030eb, 0xf85588 }, // RESET_PED_IN_VEHICLE_CONTEXT
{0xddf803377f94aaa8, 0xf8865c }, // SET_PED_GESTURE_GROUP
{0xbe22b26dd764c040, 0xf7c8bc }, // GET_ANIM_INITIAL_OFFSET_POSITION
{0x4b805e6046ee9e47, 0xf7c8cc }, // GET_ANIM_INITIAL_OFFSET_ROTATION
{0xc8a9481a01e63c28, 0xf89ce4 }, // SET_PED_RANDOM_COMPONENT_VARIATION
{0x6fd7816a36615f48, 0xf83744 }, // KNOCK_OFF_PED_PROP
{0x9f8aa94d6d97dbf4, 0xf85e4c }, // SET_BLOCKING_OF_NON_TEMPORARY_EVENTS
{0x2f25d9aefa34fba2, 0xf84bd8 }, // REGISTER_TARGET
{0x9222f300bf8354fe, 0xf84bb4 }, // REGISTER_HATED_TARGETS_AROUND_PED
{0xc33ab876a77f8164, 0xf7cb48 }, // GET_CLOSEST_PED
{0x128f79edcece4fd5, 0xf7a158 }, // CAN_PED_RAGDOLL
{0xae99fb955581844a, 0xf8a7dc }, // SET_PED_TO_RAGDOLL
{0xd76632d99e4966c8, 0xf8a7ec }, // SET_PED_TO_RAGDOLL_WITH_FALL
{0xf0a4f1bbf4fa7497, 0xf89cd4 }, // SET_PED_RAGDOLL_ON_COLLISION
{0x47e4e977581c5b55, 0xf827a8 }, // IS_PED_RAGDOLL
{0xe3b6097cc25aa69e, 0xf8294c }, // IS_PED_RUNNING_RAGDOLL_TASK
{0x1f6594b923b9251, 0xf89c90 }, // SET_PED_RAGDOLL_FORCE_FALL
{0x9fa4664cf62e47e8, 0xf85694 }, // RESET_PED_RAGDOLL_TIMER
{0xb128377056a54e2a, 0xf878cc }, // SET_PED_CAN_RAGDOLL
{0x2afe52f782f25775, 0xf7edcc }, // IS_PED_RUNNING_MOBILE_PHONE_TASK
{0x26695ec767728d84, 0xf8b8e4 }, // SET_RAGDOLL_BLOCKING_FLAGS
{0xd86d101fcfd00a4b, 0xf7afc8 }, // CLEAR_RAGDOLL_BLOCKING_FLAGS
{0x9d3151a373974804, 0xf8a378 }, // SET_PED_SPHERE_DEFENSIVE_AREA
{0x413c6c763a4affad, 0xf88088 }, // SET_PED_DEFENSIVE_AREA_DIRECTION
{0x74d4e028107450a9, 0xf84db4 }, // REMOVE_PED_DEFENSIVE_AREA
{0x3c06b8786dd94cd1, 0xf7e2fc }, // GET_PED_DEFENSIVE_AREA_POSITION
{0xba63d9fe45412247, 0xf8143c }, // IS_PED_DEFENSIVE_AREA_ACTIVE
{0x8d8acd8388cd99ce, 0xf859cc }, // REVIVE_INJURED_PED
{0x71bc8e838b9c6035, 0xf859b4 }, // RESURRECT_PED
{0x98efa132a4117be1, 0xf0498 }, // SET_PED_NAME_DEBUG
{0xef0d582cbf2d9b0f, 0xf79b5c }, // APPLY_PED_BLOOD_SPECIFIC
{0x46df918788cb093f, 0xf79b7c }, // APPLY_PED_DAMAGE_PACK
{0x8fe22675a5a45817, 0xf7a5a4 }, // CLEAR_PED_BLOOD_DAMAGE
{0x56e3b78c5408d9f4, 0xf7a620 }, // CLEAR_PED_BLOOD_DAMAGE_BY_ZONE
{0x523c79aeefcc4a2a, 0xf7a7d4 }, // CLEAR_PED_DAMAGE_DECAL_BY_ZONE
{0x9c720776daa43e7e, 0xf7aee8 }, // CLEAR_PED_WETNESS
{0x44cb6447d2571aa0, 0xf8aa7c }, // SET_PED_WETNESS_HEIGHT
{0xb5485e4907b53019, 0xf8aa34 }, // SET_PED_WETNESS_ENABLED_THIS_FRAME
{0x6585d955a68452a5, 0xf7a944 }, // CLEAR_PED_ENV_DIRT
{0x27b0405f59637d1f, 0xf8a3e0 }, // SET_PED_SWEAT
{0xe5173c163976e38, 0xf7a5a4 }, // CLEAR_PED_DECORATIONS
{0x11b499c1e0ff8559, 0xf8cb4c }, // WAS_PED_SKELETON_UPDATED
{0x17c07fc640e86b4e, 0xf7def0 }, // GET_PED_BONE_COORDS
{0x1b5c85c612e5256e, 0xf799e0 }, // ADD_SCENARIO_BLOCKING_AREA
{0xd37401d78a929a49, 0xf84e5c }, // REMOVE_SCENARIO_BLOCKING_AREAS
{0x31d16b74c6e29d66, 0xf84e48 }, // REMOVE_SCENARIO_BLOCKING_AREA
{0x57ab4a3080f85143, 0xf82d74 }, // IS_PED_USING_ANY_SCENARIO
{0xffc24b988b938b38, 0xf864f8 }, // SET_FACIAL_IDLE_ANIM_OVERRIDE
{0x726256cc1eeb182f, 0xf7a3cc }, // CLEAR_FACIAL_IDLE_ANIM_OVERRIDE
{0xbaf20c5432058024, 0xf878bc }, // SET_PED_CAN_PLAY_GESTURE_ANIMS
{0x6373d1349925a70e, 0xf87894 }, // SET_PED_CAN_PLAY_AMBIENT_ANIMS
{0xeb0585d15254740, 0xf878a8 }, // SET_PED_CAN_PLAY_AMBIENT_BASE_ANIMS
{0x6c3b4d6d13b4c841, 0xf87508 }, // SET_PED_CAN_ARM_IK
{0xc11c18092c5530dc, 0xf877dc }, // SET_PED_CAN_HEAD_IK
{0x73518ece2485412b, 0xf87838 }, // SET_PED_CAN_LEG_IK
{0xf2b7106d37947ce0, 0xf8799c }, // SET_PED_CAN_TORSO_IK
{0xec4686ec06434678, 0xf87ab0 }, // SET_PED_CAN_USE_AUTO_CONVERSATION_LOOKAT
{0x5cd3cb88a7f8850d, 0xf81984 }, // IS_PED_HEADTRACKING_PED
{0x813a0a7c9d2e831f, 0xf8195c }, // IS_PED_HEADTRACKING_ENTITY
{0x1913fe4cbf41c463, 0xf87f80 }, // SET_PED_CONFIG_FLAG
{0xc1e8a365bf3b29f2, 0xf89d5c }, // SET_PED_RESET_FLAG
{0x7ee53118c892b513, 0xf7e1d0 }, // GET_PED_CONFIG_FLAG
{0xaf9e59b1b1fbf2a0, 0xf7ec38 }, // GET_PED_RESET_FLAG
{0xbddb8d9ec6bcf3c, 0xf888f0 }, // SET_PED_GROUP_MEMBER_PASSENGER_INDEX
{0x414641c26e105898, 0xf826a4 }, // IS_PED_EVASIVE_DIVING
{0xe163a4bce4de6f11, 0xf896ec }, // SET_PED_MODEL_IS_SUPPRESSED
{0xdf993ee5e90aba25, 0xf87928 }, // SET_PED_CAN_RAGDOLL_FROM_PLAYER_IMPACT
{0xc396f5b86ff9febd, 0xf892d4 }, // SET_PED_LEG_IK_MODE
{0x4d9ca1009afbd057, 0xf87e0c }, // SET_PED_COMBAT_MOVEMENT
{0xdea92412fcaeb3f5, 0xf7e128 }, // GET_PED_COMBAT_MOVEMENT
{0xc7622c0d36b2fda8, 0xf87c90 }, // SET_PED_COMBAT_ABILITY
{0x3c606747b23e497b, 0xf87e64 }, // SET_PED_COMBAT_RANGE
{0x9f7794730795e019, 0xf87ce8 }, // SET_PED_COMBAT_ATTRIBUTES
{0x703b9079823da4a, 0xf8a628 }, // SET_PED_TARGET_LOSS_RESPONSE
{0xdcca191df9980fd7, 0xf82640 }, // IS_PED_PERFORMING_MELEE_ACTION
{0x863b23efde9c5df2, 0xf8119c }, // IS_PED_BEING_STEALTH_KILLED
{0x18a3e9ee1297fd39, 0xf7d67c }, // GET_MELEE_TARGET_FOR_PED
{0x70a2d1137c8ed7c9, 0xf88584 }, // SET_PED_FLEE_ATTRIBUTES
{0x83961498679dc9f, 0xf80a44 }, // IS_ANY_PED_NEAR_POINT
{0xfcf37a457cb96dc0, 0xf81924 }, // IS_PED_HEADING_TOWARDS_POSITION
{0x7d7a2e43e74e2eb8, 0xf851b0 }, // REQUEST_PED_VISIBILITY_TRACKING
{0x2bc338a7b21f4608, 0xf8519c }, // REQUEST_PED_VEHICLE_VISIBILITY_TRACKING
{0x91c8e617f64188ac, 0xf835e4 }, // IS_TRACKED_PED_VISIBLE
{0x3f428d08be5aae31, 0xf7df40 }, // GET_PED_BONE_INDEX
{0xf28965d04f570dca, 0xf7c4c8 }, // FORCE_PED_MOTION_STATE
{0x433083750c5e064a, 0xf893f8 }, // SET_PED_MAX_MOVE_BLEND_RATIO
{0x1a898d26e2333dd, 0xf89694 }, // SET_PED_MIN_MOVE_BLEND_RATIO
{0x85bf80fa50a39d1, 0xf89968 }, // SET_PED_MOVE_RATE_OVERRIDE
{0xcff869cbfa210d82, 0xf7eb54 }, // GET_PED_NEARBY_VEHICLES
{0x23f8f5fc7e8c4a6b, 0xf7eb28 }, // GET_PED_NEARBY_PEDS
{0xe73468d085f745, 0xf82d50 }, // IS_PED_USING_ACTION_MODE
{0xd75accf5e0fb5367, 0xf8a824 }, // SET_PED_USING_ACTION_MODE
{0x364df566ec833de2, 0xf87ac4 }, // SET_PED_CAPSULE
{0xc32779c16fceecd9, 0xf86970 }, // SET_IK_TARGET
{0xdc2c5c242aac342b, 0xf89338 }, // SET_PED_LOD_MULTIPLIER
{0xe832d760399eb220, 0xf79984 }, // ADD_ROPE
{0x52b4829281364649, 0xf7b8ec }, // DELETE_ROPE
{0xaa5d6b1888e4db20, 0xf7b894 }, // DELETE_CHILD_ROPE
{0xfd5448be3111ed96, 0xf7bdf8 }, // DOES_ROPE_EXIST
{0xf159a63806bb5ba8, 0xf85a48 }, // ROPE_DRAW_SHADOW_ENABLED
{0x3655f544cd30f0b5, 0xf7f9c4 }, // GET_ROPE_VERTEX_COUNT
{0x3d95ec8b6d940ac3, 0xf79d1c }, // ATTACH_ENTITIES_TO_ROPE
{0xbcf3026912a8647d, 0xf7ba00 }, // DETACH_ROPE_FROM_ENTITY
{0x21bb0fbd3e217c2d, 0xf7f940 }, // GET_ROPE_LAST_VERTEX_COORD
{0xea61ca8e80f09e4d, 0xf7f980 }, // GET_ROPE_VERTEX_COORD
{0x1461c72c889e343e, 0xf8c748 }, // START_ROPE_WINDING
{0xcb2d4ab84a19aa7c, 0xf8c7b0 }, // STOP_ROPE_WINDING
{0x538d1179ec1aa9a9, 0xf8c73c }, // START_ROPE_UNWINDING_FRONT
{0xfff3a50779efbbb3, 0xf8c7a4 }, // STOP_ROPE_UNWINDING_FRONT
{0xd009f759a723db1b, 0xf85a5c }, // ROPE_FORCE_LENGTH
{0xeea3b200a6feb65b, 0xf86174 }, // SET_DAMPING
{0x710311adf0e20730, 0xf79554 }, // ACTIVATE_PHYSICS
{0x2e648d16f6e308f3, 0xf79f68 }, // BREAK_ENTITY_GLASS
{0x5cec1a84620e7d5b, 0xf86338 }, // SET_DISABLE_BREAKING
{0x1ba3aed21c16cfb, 0xf863a8 }, // SET_DISABLE_FRAG_DAMAGE
{0x275f255ed201b937, 0xf7f400 }, // GET_PLAYER_PED
{0x5c880f9056d784c8, 0xf7f468 }, // GET_PLAYER_PED_SCRIPT_INDEX
{0xed40380076a31506, 0xf8b418 }, // SET_PLAYER_MODEL
{0xb464eb6a40c7975b, 0xf7f680 }, // GET_PLAYER_TEAM
{0xe8dd8536f01de600, 0xf8b628 }, // SET_PLAYER_TEAM
{0x7124fd9ac0e01ba0, 0xf7f3b8 }, // GET_PLAYER_NAME
{0x80b00eb26d9521c7, 0xf80248 }, // GET_WANTED_LEVEL_RADIUS
{0x1b1a3b358f7d8f07, 0xf8026c }, // GET_WANTED_LEVEL_THRESHOLD
{0x384d4765395e006c, 0xf0498 }, // SET_PLAYER_WANTED_LEVEL
{0xe1c0ad4c24324c36, 0xf832f4 }, // IS_PLAYER_WANTED_LEVEL_GREATER
{0x4e4b996c928c7aa6, 0xf0498 }, // CLEAR_PLAYER_WANTED_LEVEL
{0x2e9c3fcb6798f397, 0xf8304c }, // IS_PLAYER_DEAD
{0x4d51e59243281d80, 0xf8ae6c }, // SET_PLAYER_CONTROL
{0xabc532f9098bfd9d, 0xf7f76c }, // GET_PLAYER_WANTED_LEVEL
{0x28a4bd2cee236e19, 0xf86c04 }, // SET_MAX_WANTED_LEVEL
{0x6fd7dd6b63f2820e, 0xf8b6f8 }, // SET_POLICE_RADAR_BLIPS
{0xbffb35986caae58c, 0xf8319c }, // IS_PLAYER_PLAYING
{0x34630a768925b852, 0xf8648c }, // SET_EVERYONE_IGNORE_PLAYER
{0xe705309b8c6445a4, 0xf85d88 }, // SET_ALL_RANDOM_PEDS_FLEE
{0xd5c198a62f1deb0a, 0xf85d9c }, // SET_ALL_RANDOM_PEDS_FLEE_THIS_FRAME
{0xd7fa719cb54866c2, 0xf8c194 }, // SET_WANTED_LEVEL_MULTIPLIER
{0x62d14f18e8b0cae, 0xf85934 }, // RESET_WANTED_LEVEL_DIFFICULTY
{0x2df170b1185af777, 0xf7a2a0 }, // CAN_PLAYER_START_MISSION
{0xaa67bcb0097f2fa3, 0xf831e0 }, // IS_PLAYER_READY_FOR_CUTSCENE
{0x27f89fdc16688a7a, 0xf83294 }, // IS_PLAYER_TARGETTING_ENTITY
{0xae663ddd99c8a670, 0xf7f658 }, // GET_PLAYER_TARGET_ENTITY
{0x936f967d4be1ce9d, 0xf83070 }, // IS_PLAYER_FREE_AIMING
{0x8c67c11c68713d25, 0xf83094 }, // IS_PLAYER_FREE_AIMING_AT_ENTITY
{0xa6817c110b830ead, 0xf7cfb0 }, // GET_ENTITY_PLAYER_IS_FREE_AIMING_AT
{0x3a3cd06597388322, 0xf8b394 }, // SET_PLAYER_LOCKON_RANGE_OVERRIDE
{0xc7fe774412046825, 0xf8ad80 }, // SET_PLAYER_CAN_BE_HASSLED_BY_GANGS
{0x5eda520f7a3baf4e, 0xf8ae18 }, // SET_PLAYER_CAN_USE_COVER
{0xd04cfad1e2b7984a, 0xf7d670 }, // GET_MAX_WANTED_LEVEL
{0x4605c66e0f935f83, 0xf83270 }, // IS_PLAYER_TARGETTING_ANYTHING
{0xc41f4b6e23fe6a4a, 0xf85998 }, // RESTORE_PLAYER_STAMINA
{0x9bab31815159abcf, 0xf7f204 }, // GET_PLAYER_GROUP
{0x7964097fce4c244b, 0xf83028 }, // IS_PLAYER_CONTROL_ON
{0xb78350754157c00f, 0xf83228 }, // IS_PLAYER_SCRIPT_CONTROL_ON
{0xb8a70c22fd48197a, 0xf82fbc }, // IS_PLAYER_CLIMBING
{0xc8183ae963c58374, 0xf82f90 }, // IS_PLAYER_BEING_ARRESTED
{0x12917931c31f1750, 0xf857e8 }, // RESET_PLAYER_ARREST_STATE
{0x2f96e7720b0b19ea, 0xf7f0d8 }, // GET_PLAYERS_LAST_VEHICLE
{0x47e385b0d957c8d4, 0xf7f28c }, // GET_PLAYER_INDEX
{0x748b3a65c2604c33, 0xf554d4 }, // INT_TO_PLAYERINDEX
{0x58ff971fc8f2702c, 0xf554d4 }, // INT_TO_PARTICIPANTINDEX
{0x217e9dc48139933d, 0xf843bc }, // PLAYER_ID
{0x96275889b8e0ee0, 0xf843d8 }, // PLAYER_PED_ID
{0x8a9386f0749a17fa, 0xf7f28c }, // NETWORK_PLAYER_ID_TO_INT
{0xc11469dca6fc3bb5, 0xf8037c }, // HAS_FORCE_CLEANUP_OCCURRED
{0x768c017fb878e4f4, 0xf7c3a4 }, // FORCE_CLEANUP
{0xdaacaf8b687f2353, 0xf7c3bc }, // FORCE_CLEANUP_FOR_ALL_THREADS_WITH_THIS_NAME
{0xf4c9512a2f0a3031, 0xf7c3e8 }, // FORCE_CLEANUP_FOR_THREAD_WITH_THIS_ID
{0x84e8e29ebd4a46d2, 0xf7caf8 }, // GET_CAUSE_OF_MOST_RECENT_FORCE_CLEANUP
{0xda35a134038557ec, 0xf8b3e8 }, // SET_PLAYER_MAY_ONLY_ENTER_THIS_VEHICLE
{0xbec463b3a11c909e, 0xf8b3cc }, // SET_PLAYER_MAY_NOT_ENTER_ANY_VEHICLE
{0x908258b6209e71f7, 0xf83510 }, // IS_SYSTEM_UI_BEING_DISPLAYED
{0xfebeebc9cbdf4b12, 0xf8b344 }, // SET_PLAYER_INVINCIBLE
{0xcbbcb2ccfa7dc4e, 0xf7f31c }, // GET_PLAYER_INVINCIBLE
{0x462aa1973cbba75e, 0xf8b380 }, // SET_PLAYER_LOCKON
{0xd66a941f401e7302, 0xf8b61c }, // SET_PLAYER_TARGETING_MODE
{0x270b63a641be32f2, 0xf7af98 }, // CLEAR_PLAYER_HAS_DAMAGED_AT_LEAST_ONE_PED
{0xda4a4b9b96e20092, 0xf80688 }, // HAS_PLAYER_DAMAGED_AT_LEAST_ONE_PED
{0x361096d6ce4372c, 0xf7af8c }, // CLEAR_PLAYER_HAS_DAMAGED_AT_LEAST_ONE_NON_ANIMAL_PED
{0x16c8d205dd5a2e90, 0xf80664 }, // HAS_PLAYER_DAMAGED_AT_LEAST_ONE_NON_ANIMAL_PED
{0x5da6500fe849da16, 0xf85d04 }, // SET_AIR_DRAG_MULTIPLIER_FOR_PLAYERS_VEHICLE
{0xbfceabde34da5085, 0xf8be58 }, // SET_SWIM_MULTIPLIER_FOR_PLAYER
{0xd5fcc166aeb2fd0f, 0xf8b088 }, // SET_PLAYER_FORCED_AIM
{0x2970929fd5f9fc89, 0xf7bc60 }, // DISABLE_PLAYER_FIRING
{0xdf8822c55edda65b, 0xf8c6e0 }, // START_PLAYER_TELEPORT
{0xc39dce4672cbfbc1, 0xf8caa0 }, // _HAS_PLAYER_TELEPORT_FINISHED
{0x858b86146601be8, 0xf8c790 }, // STOP_PLAYER_TELEPORT
{0x85eeaeb8783feb5, 0xf832d8 }, // IS_PLAYER_TELEPORT_ACTIVE
{0xd7ecc25e176ecba5, 0xf7f104 }, // GET_PLAYER_CURRENT_STEALTH_NOISE
{0x8899c244ebcf70de, 0xf8b1a4 }, // SET_PLAYER_HEALTH_RECHARGE_MULTIPLIER
{0x94d529f7b73d7a85, 0xf8b680 }, // SET_PLAYER_WEAPON_DAMAGE_MODIFIER
{0xd15cc2d493160be3, 0xf8b690 }, // SET_PLAYER_WEAPON_DEFENSE_MODIFIER
{0xe4cb5a3f18170381, 0xf8b408 }, // SET_PLAYER_MELEE_WEAPON_DAMAGE_MODIFIER
{0xb5ec6bdaebca454c, 0xf8b440 }, // SET_PLAYER_NOISE_MULTIPLIER
{0x4de44fa389dca565, 0xf8b554 }, // SET_PLAYER_SNEAKING_NOISE_MULTIPLIER
{0xfa0c063c422c4355, 0xf8c3b4 }, // SIMULATE_PLAYER_INPUT_GAIT
{0x61a2eecab274829b, 0xf85800 }, // RESET_PLAYER_INPUT_GAIT
{0xe0447def81ccdfd2, 0xf8b540 }, // SET_PLAYER_SIMULATE_AIMING
{0xd0d9317dfeef9a66, 0xf8ae3c }, // SET_PLAYER_CLOTH_PIN_FRAMES
{0xc932f57f31ea9152, 0xf80640 }, // HAS_PLAYER_BEEN_SPOTTED_IN_STOLEN_VEHICLE
{0x2fb0acada6a238dd, 0xf83204 }, // IS_PLAYER_RIDING_TRAIN
{0x402b5d7d269ff796, 0x2a1c9fc }, // _EVENT_QUEUE_IS_EMPTY
{0xd87df294b049211d, 0x2a1ca20 }, // _EVENT_QUEUE_POP
{0xa8c44c13419634f2, 0xf0498 }, // _STOP_RECORDING_THIS_FRAME
{0xf838d47de58edb2, 0xf54aa0 }, // _IS_INTERIOR_RENDERING_DISABLED
{0x46ed607ddd40d7fe, 0x1071ed4 }, // REQUEST_SCRIPT
{0x86d3067e1cfd1c, 0x1072d48 }, // SET_SCRIPT_AS_NO_LONGER_NEEDED
{0xe97bd36574f8b0a6, 0x1071674 }, // HAS_SCRIPT_LOADED
{0x552b171e3f69e5ae, 0x10710a8 }, // DOES_SCRIPT_EXIST
{0xf6b9ce3f8d5b9b74, 0x1071ef4 }, // REQUEST_SCRIPT_WITH_NAME_HASH
{0x50723a1567c8361e, 0x1072d68 }, // SET_SCRIPT_WITH_NAME_HASH_AS_NO_LONGER_NEEDED
{0xa5d8e0c2f3c7eebc, 0x10716a0 }, // HAS_SCRIPT_WITH_NAME_HASH_LOADED
{0xa34e89749f628284, 0x10710d4 }, // DOES_SCRIPT_WITH_NAME_HASH_EXIST
{0x87ed52ae40ea1a52, 0x1073614 }, // TERMINATE_THREAD
{0x46e9ae36d8fa6417, 0x1071a60 }, // IS_THREAD_ACTIVE
{0x39382eb8dcd8684d, 0x10722a8 }, // SCRIPT_THREAD_ITERATOR_RESET
{0x3ce3fb167e837d7c, 0x107228c }, // SCRIPT_THREAD_ITERATOR_GET_NEXT_THREAD_ID
{0x55525c346bef6960, 0x1071440 }, // GET_ID_OF_THIS_THREAD
{0x5e8b6d17ff91cd59, 0x10735fc }, // TERMINATE_THIS_THREAD
{0x8e34c953364a76dd, 0x10714c8 }, // _GET_NUMBER_OF_REFERENCES_OF_SCRIPT_WITH_NAME_HASH
{0xbc2c927f5c264960, 0x1071420 }, // GET_HASH_OF_THIS_SCRIPT_NAME
{0x5ce8de5909565748, 0x107149c }, // GET_NUMBER_OF_EVENTS
{0xc9f59c0a710ecd34, 0x10713d4 }, // GET_EVENT_EXISTS
{0xa85e614430eff816, 0x1071364 }, // GET_EVENT_AT_INDEX
{0x57ec5fa4d4d6afca, 0x10713a4 }, // GET_EVENT_DATA
{0x5ae99c571d5bbe5d, 0x1073620 }, // TRIGGER_SCRIPT_EVENT
{0xfc179d7e8886dadf, 0x1072dec }, // SHUTDOWN_LOADING_SCREEN
{0x5cb83156aa038f95, 0x1072ce4 }, // SET_NO_LOADING_SCREEN
{0x323daf00687e0f28, 0x107148c }, // GET_NO_LOADING_SCREEN
{0x2eb67d564dcc09d5, 0x1070c54 }, // BG_START_CONTEXT_HASH
{0x6d1431744182cde8, 0x1070b7c }, // BG_END_CONTEXT_HASH
{0x49ba5678ba040ca7, 0x1070c28 }, // BG_START_CONTEXT
{0x3abf7ba1c3e2c8cf, 0x1070b50 }, // BG_END_CONTEXT
{0x7ee9f5d83dd4f90e, 0x1072f94 }, // START_SHAPE_TEST_LOS_PROBE
{0x377906d8a31e5586, 0x1072ed8 }, // _START_SHAPE_TEST_RAY
{0xfe466162c4401d18, 0x1072f14 }, // START_SHAPE_TEST_BOX
{0x28579d1b8f8aac80, 0x1072f58 }, // START_SHAPE_TEST_CAPSULE
{0xaa5b7c8309f73230, 0x1072fd4 }, // START_SHAPE_TEST_SWEPT_SPHERE
{0x9839013d8b6014f1, 0x1072fc4 }, // _START_SHAPE_TEST_SURROUNDING_COORDS
{0xede8ac7c5108fb1d, 0x10714f8 }, // GET_SHAPE_TEST_RESULT
{0x8ef0f633280c0663, 0x1072848 }, // _GET_TOTAL_SC_INBOX_IDS
{0xff92537c4ddc1241, 0x10727f0 }, // _SC_INBOX_MESSAGE_INIT
{0x74cf39e030a382c4, 0x10727c4 }, // _IS_SC_INBOX_VALID
{0x63cac501fff66dc4, 0x107291c }, // _SC_INBOX_MESSAGE_POP
{0x95bb39c4da99f348, 0x107285c }, // SC_INBOX_MESSAGE_GET_DATA_INT
{0x66f77fd58506ff6b, 0x1072890 }, // SC_INBOX_MESSAGE_GET_DATA_STRING
{0x176d077685cd83e4, 0x10728cc }, // _SC_INBOX_MESSAGE_GET_STRING
{0x9c74ac9d87b3fff4, 0x1072a08 }, // SC_PROFANITY_CHECK_STRING
{0x8c8052af40c4247, 0x1072a60 }, // SC_PROFANITY_GET_CHECK_IS_VALID
{0x3a10bcd0c8aa0b82, 0x1072a30 }, // SC_PROFANITY_GET_CHECK_IS_PENDING
{0xf302973bb8be70e6, 0x1072a90 }, // SC_PROFANITY_GET_STRING_PASSED
{0xcf3bfb99ebbe5b1, 0x1072ac0 }, // SC_PROFANITY_GET_STRING_STATUS
{0xefb64240f6b17817, 0x10727a0 }, // _SC_FEED_SUBMIT_PRESET_MESSAGE
{0x1f471b79acc91bee, 0x1072eb4 }, // _START_MANAGER
{0x1f471b79acc91bed, 0x1072e5c }, // _MANAGER_IS_READY
{0x1f471b79acc91bec, 0x1072e44 }, // _MANAGER_IS_FAILED
{0xfa28fe3a6246fc30, 0x1071e48 }, // REQUEST_MODEL
{0x1283b8b89dd5d1b6, 0x10715ec }, // HAS_MODEL_LOADED
{0x4ad96ef928bd4f9a, 0x1072cc0 }, // SET_MODEL_AS_NO_LONGER_NEEDED
{0xd6f3b6d7716cff8e, 0x107197c }, // IS_MODEL_IN_CDIMAGE
{0x392c8d8e07b70efc, 0x10719a0 }, // IS_MODEL_VALID
{0x354f62672de7db0a, 0x1071958 }, // IS_MODEL_A_VEHICLE
{0xa3720f162a033c9, 0x1071dc0 }, // REQUEST_COLLISION_AT_COORD
{0xf1767be37f661551, 0x1071df0 }, // REQUEST_COLLISION_FOR_MODEL
{0x210a79c9ec89778f, 0x1071584 }, // HAS_COLLISION_FOR_MODEL_LOADED
{0x537f44cb0d7f150d, 0x1071060 }, // DOES_ANIM_DICT_EXIST
{0xa862a2ad321f94b4, 0x1071d9c }, // REQUEST_ANIM_DICT
{0x27ff6fe8009b40ca, 0x107153c }, // HAS_ANIM_DICT_LOADED
{0x4763145053a33d46, 0x1071d1c }, // REMOVE_ANIM_DICT
{0xef7611b57a820126, 0x1071da8 }, // REQUEST_CLIP_SET
{0x1f23d6b6da1cc3b2, 0x1071560 }, // HAS_CLIP_SET_LOADED
{0x817fa1b1ee7cd6f0, 0x1071d28 }, // REMOVE_CLIP_SET
{0xb3bc8250f4fe8b63, 0x1072c04 }, // SET_GAME_PAUSES_FOR_STREAMING
{0x30cccc4d88e654ca, 0x10714bc }, // GET_NUMBER_OF_STREAMING_REQUESTS
{0x1ff43843028e0c, 0x1071e88 }, // REQUEST_PTFX_ASSET
{0x13a3f30a9ed0bc31, 0x1071658 }, // HAS_PTFX_ASSET_LOADED
{0x42f9049ea419e86, 0x1071d64 }, // REMOVE_PTFX_ASSET
{0xf2b2353bbc0d4e8f, 0x1071e7c }, // REQUEST_NAMED_PTFX_ASSET
{0x65bb72f29138f5d6, 0x1071634 }, // HAS_NAMED_PTFX_ASSET_LOADED
{0xf20866829e1c81a2, 0x1071d58 }, // REMOVE_NAMED_PTFX_ASSET
{0x86ccaf7ce493efbe, 0xfcce8 }, // CLEAR_FOCUS
{0x25f6ef88664540e2, 0x1072bf4 }, // _SET_FOCUS_AREA
{0x955aedd58f4bd309, 0x1072be8 }, // SET_FOCUS_ENTITY
{0xf87de697e9a06ec6, 0x107180c }, // IS_ENTITY_FOCUS
{0x3cacc83f6fed837c, 0x1072c94 }, // SET_MAPDATACULLBOX_ENABLED
{0xed20cb1f5297791d, 0x10719f4 }, // IS_PLAYER_SWITCH_IN_PROGRESS
{0x354837e5a5baa5af, 0x1071ce0 }, // PREFETCH_SRL
{0x5c2c88512cf6dafb, 0x1071a3c }, // IS_SRL_LOADED
{0x360710033be60d9, 0x1070b1c }, // BEGIN_SRL
{0x1ce71fb33ca079fe, 0x107113c }, // END_SRL
{0x18231aef458bcff2, 0x1072dd8 }, // SET_SRL_TIME
{0xb88b905afa35cb4d, 0x1072c38 }, // SET_HD_AREA
{0xd83b22434e52728d, 0x1070f44 }, // CLEAR_HD_AREA
{0xe73a266db0ca9042, 0x103a2ac }, // TASK_PAUSE
{0x919be13eed931959, 0x103a92c }, // TASK_STAND_STILL
{0xae4086104e067b1, 0x1039e94 }, // TASK_JUMP
{0x3eb1fe9e8e908e15, 0x1039120 }, // TASK_COWER
{0xf2eab31979a7f910, 0x1039db0 }, // TASK_HANDS_UP
{0xa98fcafd7893c834, 0x103da8c }, // UPDATE_TASK_HANDS_UP_DURATION
{0xc20e50aa46d09ca8, 0x1039410 }, // TASK_ENTER_VEHICLE
{0xd3dbce61a490be02, 0x1039f48 }, // TASK_LEAVE_VEHICLE
{0xe2a2aa2f659d77a7, 0x103ae30 }, // TASK_VEHICLE_DRIVE_TO_COORD
{0x480142959d337d00, 0x103af64 }, // TASK_VEHICLE_DRIVE_WANDER
{0x304ae42e357b8c7e, 0x10397ec }, // TASK_FOLLOW_TO_OFFSET_OF_ENTITY
{0xd76b57b44f1e6f8b, 0x10399e4 }, // TASK_GO_STRAIGHT_TO_COORD
{0x61e360b7e040d12e, 0x1039a28 }, // TASK_GO_STRAIGHT_TO_COORD_RELATIVE_TO_ENTITY
{0x93b93a37987f1f3d, 0x1038b50 }, // TASK_ACHIEVE_HEADING
{0x841142a1376e9006, 0x1039624 }, // TASK_FLUSH_ROUTE
{0x1e7889778264843a, 0x1039478 }, // TASK_EXTEND_ROUTE
{0x6a071245eb0d1882, 0x1039c00 }, // TASK_GO_TO_ENTITY
{0x94587f17e9c365d5, 0x103a89c }, // TASK_SMART_FLEE_COORD
{0x22b0d0e37ccb840d, 0x103a8d4 }, // TASK_SMART_FLEE_PED
{0x452419cbd838065b, 0x103a7ec }, // TASK_SHOCKING_EVENT_REACT
{0xe054346ca3a0f315, 0x103b274 }, // TASK_WANDER_IN_AREA
{0xbb9ce077274f6a1b, 0x103b2e8 }, // TASK_WANDER_STANDARD
{0x965fec691d55e9bf, 0x103a3dc }, // TASK_PLANT_BOMB
{0x15d3a79d4e44b913, 0x1039750 }, // TASK_FOLLOW_NAV_MESH_TO_COORD
{0x17f58b88d085dbac, 0x10508e0 }, // TASK_FOLLOW_NAV_MESH_TO_COORD_ADVANCED
{0x8e06a6fe76c9eff4, 0x1038158 }, // SET_PED_PATH_CAN_USE_CLIMBOVERS
{0x77a5b103c87f476e, 0x10381b4 }, // SET_PED_PATH_CAN_USE_LADDERS
{0xe361c5c71c431a4f, 0x10380fc }, // SET_PED_PATH_CAN_DROP_FROM_HEIGHT
{0xf35425a4204367ec, 0x10384d4 }, // SET_PED_PATH_MAY_ENTER_WATER
{0x38fe1ec73743793c, 0x10385dc }, // SET_PED_PATH_PREFER_TO_AVOID_WATER
{0x4455517b28441e60, 0x1038044 }, // SET_PED_PATH_AVOID_FIRE
{0x5bc448cb78fa3e88, 0x1039b58 }, // TASK_GO_TO_COORD_ANY_MEANS
{0x1dd45f9ecfdb1bc9, 0x1039ba0 }, // TASK_GO_TO_COORD_ANY_MEANS_EXTRA_PARAMS
{0xb8ecd61f531a7b02, 0x1039bb0 }, // TASK_GO_TO_COORD_ANY_MEANS_EXTRA_PARAMS_WITH_CRUISE_SPEED
{0xea47fe3719165b94, 0x103a3f0 }, // TASK_PLAY_ANIM
{0x83cdb10ea29b370b, 0x103a400 }, // TASK_PLAY_ANIM_ADVANCED
{0x97ff36a1d40ea00a, 0x1038ae0 }, // STOP_ANIM_TASK
{0x126ef75f1e17abe5, 0x103a654 }, // TASK_SCRIPTED_ANIMATION
{0x77a1eec547e7fcf1, 0x10379a0 }, // PLAY_ENTITY_SCRIPTED_ANIM
{0xee08c992d238c5d1, 0x1038ac8 }, // STOP_ANIM_PLAYBACK
{0x32d49c5e359c847, 0x1037c84 }, // SET_ANIM_RATE
{0x6fa46612594f7973, 0x1039f60 }, // TASK_LOOK_AT_COORD
{0x69f4be8c8cc4796c, 0x1039f98 }, // TASK_LOOK_AT_ENTITY
{0xf804f1db19b9689, 0x1038f4c }, // TASK_CLEAR_LOOK_AT
{0xe8854a4326b9e12b, 0x103788c }, // OPEN_SEQUENCE_TASK
{0x39e72bc99e6360cb, 0x1035708 }, // CLOSE_SEQUENCE_TASK
{0x5aba3986d90d8a3b, 0x103a32c }, // TASK_PERFORM_SEQUENCE
{0x3841422e9c488d8c, 0x1035674 }, // CLEAR_SEQUENCE_TASK
{0x58c70cf3a41e4ae7, 0x1038834 }, // SET_SEQUENCE_TO_REPEAT
{0xa9010cfe1e3533, 0x1036894 }, // GET_SEQUENCE_PROGRESS
{0xb0760331c7aa4155, 0x1036060 }, // GET_IS_TASK_ACTIVE
{0x77f1beb8863288d5, 0x1036868 }, // GET_SCRIPT_TASK_STATUS
{0x534aeba6e5ed4cab, 0x1035ed8 }, // GET_ACTIVE_VEHICLE_MISSION_TYPE
{0x504d54df3f6f2247, 0x1039f34 }, // TASK_LEAVE_ANY_VEHICLE
{0x9b53bb6e8943af53, 0x1038c1c }, // TASK_AIM_GUN_AT_ENTITY
{0x5ad23d40115353ac, 0x103aae8 }, // TASK_TURN_PED_TO_FACE_ENTITY
{0x6671f3eec681bda1, 0x1038be8 }, // TASK_AIM_GUN_AT_COORD
{0x46a6cc01e0826106, 0x103a804 }, // TASK_SHOOT_AT_COORD
{0x7aa80209bda643eb, 0x103a88c }, // TASK_SHUFFLE_TO_NEXT_VEHICLE_SEAT
{0xe1ef3c1216aff2cd, 0x10355ec }, // CLEAR_PED_TASKS
{0x176cecf6f920d707, 0x10355a8 }, // CLEAR_PED_SECONDARY_TASK
{0x7f93691ab4b92272, 0x1039450 }, // TASK_EVERYONE_LEAVE_VEHICLE
{0xe39b4ff4fdebde27, 0x1039954 }, // TASK_GOTO_ENTITY_OFFSET
{0x338e7ef52b6095a9, 0x10399b4 }, // TASK_GOTO_ENTITY_OFFSET_XY
{0x1dda930a0ac38571, 0x103aad4 }, // TASK_TURN_PED_TO_FACE_COORD
{0xc429dceeb339e129, 0x103b1fc }, // TASK_VEHICLE_TEMP_ACTION
{0x659427e0ef36bcde, 0x103b11c }, // TASK_VEHICLE_MISSION
{0x9454528df15d657a, 0x103b178 }, // TASK_VEHICLE_MISSION_PED_TARGET
{0xfa6e4b75f302400, 0x103af7c }, // TASK_VEHICLE_ESCORT
{0x15c86013127ce63f, 0x1038ea8 }, // TASK_BOAT_MISSION
{0x2f8af0e82773a171, 0x10391e0 }, // TASK_DRIVE_BY
{0xe5b302114d8162ee, 0x1037d10 }, // SET_DRIVEBY_TASK_TARGET
{0xc35b5cdb2824cf69, 0x10354bc }, // CLEAR_DRIVEBY_TASK_UNDERNEATH_DRIVING_TASK
{0x8785e6e40c7a8818, 0x1036d90 }, // IS_DRIVEBY_TASK_UNDERNEATH_DRIVING_TASK
{0xa320ef046186fa3b, 0x1036e20 }, // IS_MOUNTED_WEAPON_TASK_UNDERNEATH_DRIVING_TASK
{0x9a7d091411c5f684, 0x103b30c }, // TASK_WARP_PED_INTO_VEHICLE
{0x8da95e8298ae772, 0x103a834 }, // TASK_SHOOT_AT_ENTITY
{0x89d9fcc2435112f1, 0x1038f58 }, // TASK_CLIMB
{0xb6c987f9285a3814, 0x1038f6c }, // TASK_CLIMB_LADDER
{0xaaa34f8a7cb32098, 0x1035608 }, // CLEAR_PED_TASKS_IMMEDIATELY
{0x89221b16730234f0, 0x103a354 }, // TASK_PERFORM_SEQUENCE_FROM_PROGRESS
{0x1e982ac8716912c5, 0x1037e70 }, // SET_PED_DESIRED_MOVE_BLEND_RATIO
{0x8517d4a6ca8513ed, 0x1036258 }, // GET_PED_DESIRED_MOVE_BLEND_RATIO
{0xa9da48fab8a76c12, 0x1039944 }, // TASK_GOTO_ENTITY_AIMING
{0x933c06518b52a9a4, 0x103a7d8 }, // TASK_SET_SPHERE_DEFENSIVE_AREA
{0x95a6c46a31d1917d, 0x1038f40 }, // TASK_CLEAR_DEFENSIVE_AREA
{0xd04fe6765d990a06, 0x103a2bc }, // TASK_PED_SLIDE_TO_COORD
{0xd5c12a75c7b9497f, 0x1034f64 }, // ADD_COVER_POINT
{0xae287c923d891715, 0x1037aac }, // REMOVE_COVER_POINT
{0xa98b8e3c088e5a31, 0x1035b08 }, // DOES_SCRIPTED_COVER_POINT_EXIST_AT_COORDS
{0x594a1028fc2a3e85, 0x10367d0 }, // GET_SCRIPTED_COVER_POINT_COORDS
{0xf166e48407bac484, 0x103909c }, // TASK_COMBAT_PED
{0x944f30dcb7096bde, 0x10390b4 }, // TASK_COMBAT_PED_TIMED
{0x75ac2b60386d89f2, 0x103a6b4 }, // TASK_SEEK_COVER_FROM_POS
{0x84d32b3bec531324, 0x103a674 }, // TASK_SEEK_COVER_FROM_PED
{0xd43d95c7a869447f, 0x103a73c }, // TASK_SEEK_COVER_TO_COVER_POINT
{0x39246a6958ef072c, 0x103a6f4 }, // TASK_SEEK_COVER_TO_COORDS
{0x4172393e6be1fece, 0x103a518 }, // TASK_PUT_PED_DIRECTLY_INTO_COVER
{0x1c6cd14a876ffe39, 0x103a57c }, // TASK_PUT_PED_DIRECTLY_INTO_MELEE
{0x4a58a47a72e3fcb4, 0x1039d58 }, // TASK_GUARD_CURRENT_POSITION
{0xd2a207eebdf9889b, 0x1039d28 }, // TASK_GUARD_ASSIGNED_DEFENSIVE_AREA
{0xae032f8bba959e90, 0x103a914 }, // TASK_STAND_GUARD
{0x5c9b84bd7d31d908, 0x1037d38 }, // SET_DRIVE_TASK_CRUISE_SPEED
{0x404a5aa9b9f0b746, 0xf2d908 }, // SET_DRIVE_TASK_MAX_CRUISE_SPEED
{0x45c597097dd7cb81, 0x1034edc }, // ADD_COVER_BLOCKING_AREA
{0xdb6708c0b46f56d8, 0x1037a60 }, // REMOVE_ALL_COVER_BLOCKING_AREAS
{0x58e2e0f23f6b76c3, 0x103ac2c }, // TASK_USE_NEAREST_SCENARIO_TO_COORD_WARP
{0x9fda1b3d7e7028b3, 0x103ab3c }, // TASK_USE_NEAREST_SCENARIO_CHAIN_TO_COORD
{0x97a28e63f0ba5631, 0x103ab88 }, // TASK_USE_NEAREST_SCENARIO_CHAIN_TO_COORD_WARP
{0x5a59271ffadd33c1, 0x1035938 }, // DOES_SCENARIO_EXIST_IN_AREA
{0x788756d73ac2e07c, 0x1037550 }, // IS_SCENARIO_OCCUPIED
{0x295e3ccec879ccd7, 0x10378f8 }, // PED_HAS_USE_SCENARIO_TASK
{0x748040460f8df5dc, 0x1037970 }, // PLAY_ANIM_ON_RUNNING_SCENARIO
{0xf9034c136c9e00d3, 0x1035974 }, // DOES_SCENARIO_GROUP_EXIST
{0x367a09ded4e05b99, 0x1037508 }, // IS_SCENARIO_GROUP_ENABLED
{0x2c8e5b49848664e, 0x1038714 }, // SET_SCENARIO_GROUP_ENABLED
{0xdd902d0349afad3a, 0x1037bf8 }, // RESET_SCENARIO_GROUPS_ENABLED
{0x3a815db3ea088722, 0x1037600 }, // IS_SCENARIO_TYPE_ENABLED
{0xeb47ec4e34fb7ee1, 0x103880c }, // SET_SCENARIO_TYPE_ENABLED
{0xd40ee2a7f2b2d6d, 0x1037c20 }, // RESET_SCENARIO_TYPES_ENABLED
{0xaa135f9482c82cc3, 0x1036edc }, // IS_PED_ACTIVE_IN_SCENARIO
{0x4cf5f55dac3280a0, 0x1039060 }, // TASK_COMBAT_HATED_TARGETS_IN_AREA
{0x7bf835bb9e2698c8, 0x1039030 }, // TASK_COMBAT_HATED_TARGETS_AROUND_PED
{0x2bba30b854534a0c, 0x1039048 }, // TASK_COMBAT_HATED_TARGETS_AROUND_PED_TIMED
{0x7285951dbf6b5a51, 0x103aaa8 }, // TASK_THROW_PROJECTILE
{0xa21c51255b205245, 0x103aa6c }, // TASK_SWAP_WEAPON
{0x62d2916f56b9cd2d, 0x103a604 }, // TASK_RELOAD_WEAPON
{0x2a74e1d5f2f00eec, 0x103715c }, // IS_PED_GETTING_UP
{0xdeb6d52126e7d640, 0x10371f0 }, // IS_PED_IN_WRITHE
{0xa36bfb5ee89f3d82, 0x1037878 }, // OPEN_PATROL_ROUTE
{0xb043eca801b8cbc1, 0x10356fc }, // CLOSE_PATROL_ROUTE
{0x8edf950167586b7c, 0x1034ff0 }, // ADD_PATROL_ROUTE_NODE
{0x23083260dec3a551, 0x1034fd8 }, // ADD_PATROL_ROUTE_LINK
{0xaf8a443ccc8018dc, 0x1035780 }, // CREATE_PATROL_ROUTE
{0x7767dd9d65e91319, 0x103589c }, // DELETE_PATROL_ROUTE
{0xbda5df49d080fe4e, 0x103a23c }, // TASK_PATROL
{0xe5da8615a6180789, 0x103aa34 }, // TASK_STAY_IN_COVER
{0x10ab107b887214d8, 0x103b1e8 }, // TASK_VEHICLE_SHOOT_AT_PED
{0xe41885592b08b097, 0x103ada4 }, // TASK_VEHICLE_AIM_AT_PED
{0x5190796ed39c9b6d, 0x103b1d4 }, // TASK_VEHICLE_SHOOT_AT_COORD
{0x447c1e9ef844bc0f, 0x103ad94 }, // TASK_VEHICLE_AIM_AT_COORD
{0x195aeeb13cefe2ee, 0x103b0bc }, // TASK_VEHICLE_GOTO_NAVMESH
{0x11315ab3385b8ac0, 0x1039bc0 }, // TASK_GO_TO_COORD_WHILE_AIMING_AT_COORD
{0xb2a16444ead9ae47, 0x1039be0 }, // TASK_GO_TO_COORD_WHILE_AIMING_AT_ENTITY
{0x97465886d35210e9, 0x1039c60 }, // TASK_GO_TO_ENTITY_WHILE_AIMING_AT_ENTITY
{0xa55547801eb331fc, 0x1039a78 }, // TASK_GO_TO_COORD_AND_AIM_AT_HATED_ENTITIES_NEAR_COORD
{0x8c825bdc7741d37c, 0x1037de0 }, // SET_HIGH_FALL_TASK
{0x9eefb62eb27b5792, 0x1037bc4 }, // REQUEST_WAYPOINT_RECORDING
{0xcb4e8be8a0063c5d, 0x10360e4 }, // GET_IS_WAYPOINT_RECORDING_LOADED
{0xff1b8b4aa1c25dc8, 0x1037ac4 }, // REMOVE_WAYPOINT_RECORDING
{0x5343532c01a07234, 0x103de68 }, // WAYPOINT_RECORDING_GET_NUM_POINTS
{0x2fb897405c90b361, 0x103de58 }, // WAYPOINT_RECORDING_GET_COORD
{0x5622aebc33aca9, 0x103de90 }, // WAYPOINT_RECORDING_GET_SPEED_AT_POINT
{0xb629a298081f876f, 0x103de2c }, // WAYPOINT_RECORDING_GET_CLOSEST_WAYPOINT
{0x759591819534f7b, 0x10397fc }, // TASK_FOLLOW_WAYPOINT_RECORDING
{0xe03b3f2d3dc59b64, 0x1037738 }, // IS_WAYPOINT_PLAYBACK_GOING_ON_FOR_PED
{0x2720aaa75001e094, 0x1036434 }, // GET_PED_WAYPOINT_PROGRESS
{0xe6a877c64caf1bc5, 0x10363dc }, // GET_PED_WAYPOINT_DISTANCE
{0xed98e10b0afce4b4, 0x10386a4 }, // SET_PED_WAYPOINT_ROUTE_OFFSET
{0xa5b769058763e497, 0x1036a9c }, // GET_WAYPOINT_DISTANCE_ALONG_ROUTE
{0x701375a7d43f01cb, 0x103dbf8 }, // WAYPOINT_PLAYBACK_GET_IS_PAUSED
{0xf342546aa06fed5, 0x103dc94 }, // WAYPOINT_PLAYBACK_PAUSE
{0x244f70c84c547d2d, 0x103dcd0 }, // WAYPOINT_PLAYBACK_RESUME
{0x7d7d2b47fa788e85, 0x103dc50 }, // WAYPOINT_PLAYBACK_OVERRIDE_SPEED
{0x6599d834b12d0800, 0x103de10 }, // WAYPOINT_PLAYBACK_USE_DEFAULT_SPEED
{0x5a353b8e6b1095b5, 0x103db40 }, // USE_WAYPOINT_RECORDING_AS_ASSISTED_MOVEMENT_ROUTE
{0x20e330937c399d29, 0x103dd74 }, // WAYPOINT_PLAYBACK_START_AIMING_AT_PED
{0x8968400d900ed8b3, 0x103dd04 }, // WAYPOINT_PLAYBACK_START_AIMING_AT_COORD
{0xe70ba7b90f8390dc, 0x103dde4 }, // WAYPOINT_PLAYBACK_START_SHOOTING_AT_PED
{0x57a25cfcc9db671, 0x103ddc4 }, // WAYPOINT_PLAYBACK_START_SHOOTING_AT_COORD
{0x47efa040ebb8e2ea, 0x103ddf4 }, // WAYPOINT_PLAYBACK_STOP_AIMING_OR_SHOOTING
{0x3548536485dd792b, 0x1035330 }, // ASSISTED_MOVEMENT_REMOVE_ROUTE
{0x60f9a4393a21f741, 0x103530c }, // ASSISTED_MOVEMENT_IS_ROUTE_LOADED
{0xd5002d78b7162e1b, 0x103533c }, // ASSISTED_MOVEMENT_SET_ROUTE_PROPERTIES
{0x3123faa6db1cf7ed, 0x103afec }, // TASK_VEHICLE_FOLLOW_WAYPOINT_RECORDING
{0xf5134943ea29868c, 0x103776c }, // IS_WAYPOINT_PLAYBACK_GOING_ON_FOR_VEHICLE
{0x9824cff8fc66e159, 0x1036a5c }, // GET_VEHICLE_WAYPOINT_PROGRESS
{0x416b62ac8b9e5bbd, 0x1036a7c }, // GET_VEHICLE_WAYPOINT_TARGET_POINT
{0x8a4e6ac373666bc5, 0x103dba8 }, // VEHICLE_WAYPOINT_PLAYBACK_PAUSE
{0xdc04fcaa7839d492, 0x103dbb4 }, // VEHICLE_WAYPOINT_PLAYBACK_RESUME
{0x5ceb25a7d2848963, 0x103dbc0 }, // VEHICLE_WAYPOINT_PLAYBACK_USE_DEFAULT_SPEED
{0x121f0593e0a431d7, 0x103db98 }, // VEHICLE_WAYPOINT_PLAYBACK_OVERRIDE_SPEED
{0x90d2156198831d69, 0x103a784 }, // TASK_SET_BLOCKING_OF_NON_TEMPORARY_EVENTS
{0x4f056e1affef17ab, 0x1039898 }, // TASK_FORCE_MOTION_STATE
{0x2d537ba194896636, 0x103a1c0 }, // TASK_MOVE_NETWORK_BY_NAME
{0x921ce12c489c4c41, 0x1037624 }, // IS_TASK_MOVE_NETWORK_ACTIVE
{0x30ed88d5e0c56a37, 0x1037648 }, // IS_TASK_MOVE_NETWORK_READY_FOR_TRANSITION
{0xd01015c7316ae176, 0x1037b7c }, // REQUEST_TASK_MOVE_NETWORK_STATE_TRANSITION
{0x717e4d1f2048376d, 0x1036980 }, // GET_TASK_MOVE_NETWORK_STATE
{0xd5bb4025ae449a4e, 0x103892c }, // SET_TASK_MOVE_NETWORK_SIGNAL_FLOAT
{0xb0a6cfd2c69c1088, 0x1038914 }, // SET_TASK_MOVE_NETWORK_SIGNAL_BOOL
{0xb4f47213df45a64c, 0x1036910 }, // GET_TASK_MOVE_NETWORK_EVENT
{0x349ce7b56dafd95c, 0x1036e94 }, // IS_MOVE_BLEND_RATIO_STILL
{0xf133bbbe91e1691f, 0x1036eb0 }, // IS_MOVE_BLEND_RATIO_WALKING
{0xd4d8636c0199a939, 0x1036e4c }, // IS_MOVE_BLEND_RATIO_RUNNING
{0x24a2ad74fa9814e2, 0x1036e78 }, // IS_MOVE_BLEND_RATIO_SPRINTING
{0xac29253eef8f0180, 0x103741c }, // IS_PED_STILL
{0xde4c184b2b9b071a, 0x1037448 }, // IS_PED_WALKING
{0xc5286ffc176f28a2, 0x10372bc }, // IS_PED_RUNNING
{0x57e457cd2c0fc168, 0x10373f0 }, // IS_PED_SPRINTING
{0xf3b9a78a178572b1, 0x1038dfc }, // TASK_ARREST_PED
{0x90a09f3a45fed688, 0xf7edcc }, // IS_PED_BEING_ARRESTED
{0x67406f2c8f87fc4f, 0x103d8f0 }, // UNCUFF_PED
{0x74e559b3bc910685, 0x1037038 }, // IS_PED_CUFFED
{0xc1ba29df5631b0f8, 0x1037b3c }, // REQUEST_STREAMED_TEXTURE_DICT
{0x54d6900929ccf162, 0x1036bdc }, // HAS_STREAMED_TEXTURE_DICT_LOADED
{0x4aca10a91f66f1e2, 0x1038844 }, // SET_STREAMED_TEXTURE_DICT_AS_NO_LONGER_NEEDED
{0x25b7a0206bdfac76, 0x10376e0 }, // _IS_APP_ACTIVE
{0x4e511d093a86ad49, 0x103770c }, // _IS_APP_RUNNING
{0xdb30bec7a7a5cbd3, 0x1036d0c }, // _IS_ANY_APP_RUNNING
{0x2ff10c9c3f92277e, 0x1035720 }, // _CLOSE_APP_BY_HASH
{0x4428420a248a354, 0x1036c58 }, // _CLOSE_APP_BY_HASH_IMMEDIATE
{0x3015635426d1b17c, 0x1036c4c }, // _CLOSE_APP
{0xad7b70f7230c5a12, 0x10356dc }, // _CLOSE_ALL_APPS
{0xc1bcf31e975b3195, 0x10377c8 }, // _LAUNCH_APP_BY_HASH_WITH_ENTRY
{0xc8fc7f4e4cf4f581, 0x1037794 }, // _LAUNCH_APP_BY_HASH
{0x7b2027bac5c8ec89, 0x10377fc }, // _LAUNCH_APP_WITH_ENTRY
{0xe555ec27d65ede80, 0x1035404 }, // _CAN_LAUNCH_APP_BY_HASH
{0x7689cd255655bfd7, 0x1037b8c }, // _UIAPP_REQUEST_TRANSITION_BY_HASH
{0x67ed5a7963f2f722, 0x1035c04 }, // _IS_EVENT_PENDING
{0x90237103f27f7937, 0x1035c38 }, // _PEEK_EVENT
{0x8e8a2369f48ec839, 0x1035c60 }, // _POP_EVENT
{0xb8188ccf52202475, 0x103c1bc }, // _LOG_IS_ENTRY_REGISTERED
{0x69d5479982355d8f, 0x103bfa8 }, // _LOG_ADD_ENTRY_HASH
{0x6965469934958d8f, 0x103c2e8 }, // _LOG_SET_ENTRY_ICON_TEXTURE
{0x69684d9936958d8f, 0x103c2bc }, // _LOG_SET_ENTRY_BRIEF_TEXTURE
{0x80d6524190258c3e, 0x103c3cc }, // _LOG_UPDATE_ENTRY_SUBHEADER
{0x72a5cd214b342568, 0x103c314 }, // _LOG_SET_ENTRY_PINNED
{0xde31d66d1e54c471, 0x103c230 }, // _MARK_MISSION_COMPLETED
{0x13e8d7dd08543482, 0x103c204 }, // _MARK_ENTRY_AVAILABILITY
{0x3920574cf0a2b7b6, 0x103c1ec }, // _MARK_ALL_ENTRIES_AVAILABILITY
{0xd594a19be09a75c6, 0x103c270 }, // _REMOVE_LOG_ENTRY
{0xb95b4ea6b1edf035, 0x103c120 }, // _CLEAR_LOG_ENTRIES
{0xb43163388484cc87, 0x103c06c }, // _LOG_ADD_OR_UPDATE_OBJECTIVE
{0xfa233f8fe190514c, 0x103c288 }, // _LOG_SET_CACHED_OBJECTIVE
{0xdff0d417277b41f8, 0x103c12c }, // _LOG_CLEAR_CACHED_OBJECTIVE
{0xcc48ffbb45b54f71, 0x103c198 }, // _LOG_HAS_DISPLAYED_CACHED_OBJECTIVE
{0xa3108d6981a5cadb, 0x103c138 }, // _LOG_CLEAR_HAS_DISPLAYED_CACHED_OBJECTIVE
{0xa3108d6981a5cadc, 0x103c334 }, // _LOG_SET_HAS_DISPLAYED_CACHED_OBJECTIVE
{0x15a4461beb788096, 0x103c150 }, // _LOG_GET_CACHED_OBJECTIVE
{0xe9990552dec71600, 0x103c264 }, // _LOG_PRINT_CACHED_OBJECTIVE
{0x136a027cf37b0a4f, 0x103c394 }, // _SET_PENDING_DETAILS_ID
{0x60c59968e8e87e6b, 0x103c0f4 }, // _ADD_TOTAL_TAKE_ENTRY
{0xd106b211ef1b8f04, 0x103c3b4 }, // _SET_TOTAL_TAKE_SUMMARY
{0x49e58fe6ef40b987, 0x103c244 }, // _POST_NOTIFICATION
{0x2cc24a2a7a1489c4, 0x103d890 }, // _GET_IS_THREAT_INDICATOR_CAPABLE_RADAR_SHOWN
{0xfc2e0a5e9ed4e1b4, 0x103d8ac }, // _GET_IS_THREAT_INDICATOR_ON
{0xc116e6df68dce667, 0x103d8c8 }, // _SET_RPG_ICON_VISIBILITY
{0xc0081b34e395ce48, 0x103bf54 }, // _REQUEST_FLOW_BLOCK
{0xf320a77dd5f781df, 0x103bf48 }, // _RELEASE_FLOW_BLOCK
{0x10a93c057b6bd944, 0x103bf24 }, // _IS_FLOW_BLOCK_LOADED
{0x3b7519720c9dcb45, 0x103befc }, // _ENTER_FLOW_BLOCK
{0x5d15569c0febf757, 0x103d6e4 }, // _DOES_STATE_MACHINE_EXIST
{0x4c6f2c4b7a03a266, 0x103d690 }, // _STATE_MACHINE_CREATE
{0x7ea9c3547e80350e, 0x103d73c }, // _STATE_MACHINE_REQUEST_TRANSITION
{0x4eb122210a90e2d8, 0x103d6b8 }, // _STATE_MACHINE_DESTROY
{0xc4b660c7b6040e75, 0x103d9c4 }, // _UNLOCK_IS_UNLOCKED
{0x1b7c5ada8a6910a0, 0x103da20 }, // _UNLOCK_SET_UNLOCKED
{0x8588a14b75af096b, 0x103d9e8 }, // _UNLOCK_IS_VISIBLE
{0x46b901a8ecdb5a61, 0x103da34 }, // _UNLOCK_SET_VISIBLE
{0x644166ba7aa49dea, 0x103d978 }, // _UNLOCK_IS_NEW
{0xa6d79c7aef870a99, 0x103da0c }, // _UNLOCK_SET_NEW
{0xaf35d0d2583051b0, 0x10a35c4 }, // CREATE_VEHICLE
{0xe20a909d8c4a70f8, 0x10a3930 }, // DELETE_VEHICLE
{0xecb9e9bc887e8060, 0x10a8058 }, // SET_VEHICLE_ALLOW_NO_PASSENGERS_LOCKON
{0x45a54ec7a22455, 0x10a61c0 }, // IS_VEHICLE_MODEL
{0xbbb134fb9d50c0cc, 0x10a6e60 }, // SET_ALL_VEHICLE_GENERATORS_ACTIVE_IN_AREA
{0x3d596e6e88a02c24, 0x10a6e58 }, // SET_ALL_VEHICLE_GENERATORS_ACTIVE
{0x7263332501e07f52, 0x10a85a8 }, // SET_VEHICLE_ON_GROUND_PROPERLY
{0x78c3311a73135241, 0x10a6308 }, // IS_VEHICLE_STOPPED
{0x59f3f16577cd79b2, 0x10a4eb0 }, // GET_VEHICLE_NUMBER_OF_PASSENGERS
{0xa9c55f1c15e62e06, 0x10a4e70 }, // GET_VEHICLE_MAX_NUMBER_OF_PASSENGERS
{0x9a578736ff3a17c3, 0x10a4e90 }, // GET_VEHICLE_MODEL_NUMBER_OF_SEATS
{0x7892685bf6d9775e, 0x10a5f50 }, // IS_SEAT_WARP_ONLY
{0x606374ebfc27b133, 0x10a81bc }, // SET_VEHICLE_DENSITY_MULTIPLIER_THIS_FRAME
{0x1f91d44490e1ea0c, 0x10a7c44 }, // SET_RANDOM_VEHICLE_DENSITY_MULTIPLIER_THIS_FRAME
{0xfedfa97638d61d4a, 0x10a7590 }, // SET_PARKED_VEHICLE_DENSITY_MULTIPLIER_THIS_FRAME
{0xd4288603e8766ff7, 0xf0498 }, // SET_DISABLE_RANDOM_TRAINS_THIS_FRAME
{0x96f78a6a075d55d9, 0x10a8240 }, // SET_VEHICLE_DOORS_LOCKED
{0xa9f1d75195cc40f6, 0x10a8448 }, // _SET_VEHICLE_DOOR_DESTROY_TYPE
{0x359a8ea1fb8d6f0f, 0x10a8264 }, // SET_VEHICLE_DOORS_LOCKED_FOR_PLAYER
{0xfa2cddfeb8bc898b, 0x10a4d34 }, // GET_VEHICLE_DOORS_LOCKED_FOR_PLAYER
{0x2381977da948f8dc, 0x10a8250 }, // SET_VEHICLE_DOORS_LOCKED_FOR_ALL_PLAYERS
{0xe712bc978770f105, 0x10a827c }, // SET_VEHICLE_DOORS_LOCKED_FOR_TEAM
{0x75dced9eec5769d7, 0x10a3dd8 }, // EXPLODE_VEHICLE
{0xaeab044f05b92659, 0x10a6fcc }, // SET_BOAT_ANCHOR
{0xc075176cfb8b4128, 0x10a3358 }, // _CAN_BOAT_BE_ANCHORED
{0x286771f3059a37a7, 0x10a6ff0 }, // _SET_BOAT_FROZEN_WHEN_ANCHORED
{0xe3261532550d6a9f, 0x10a6fe0 }, // _SET_BOAT_ANCHOR_BUOYANCY_COEFFICIENT
{0x62a6d317a011ea1d, 0x10a700c }, // _SET_BOAT_EXPLODES_ON_WRECKED_ACTION
{0xab315515c9f8803d, 0x10a874c }, // SET_VEHICLE_STRONG
{0xe052c1b1caa4ece4, 0x10a6278 }, // IS_VEHICLE_SEAT_FREE
{0xbb40dd2270b65366, 0x10a4818 }, // GET_PED_IN_VEHICLE_SEAT
{0x74583b19feeafda7, 0x10a4510 }, // GET_LAST_PED_IN_VEHICLE_SEAT
{0xf9f92af49f12f6e7, 0x10a83d4 }, // SET_VEHICLE_FORWARD_SPEED
{0x260be8f09e326a20, 0x10a333c }, // BRING_VEHICLE_TO_HALT
{0xa4ffcd645b11f25a, 0x10a8294 }, // SET_VEHICLE_DOORS_SHUT
{0xebd0a4e935106fe5, 0x10a87ac }, // SET_VEHICLE_TYRES_CAN_BURST
{0x839137c40275fb77, 0x10a88a8 }, // SET_VEHICLE_WHEELS_CAN_BREAK
{0x550ce392a4672412, 0x10a8310 }, // SET_VEHICLE_DOOR_OPEN
{0x745f15a215f2ddf1, 0x10a6bb8 }, // REMOVE_VEHICLE_WINDOW
{0x629f0a0e952cae7d, 0x10a84d4 }, // SET_VEHICLE_LIGHTS
{0x1156c6ee7e82a98a, 0x10a7c20 }, // SET_RANDOM_TRAINS
{0xa3120a1385f17ff7, 0x10a38f8 }, // DELETE_ALL_TRAINS
{0xdfba6bbff7ccafbb, 0x10a7d5c }, // SET_TRAIN_SPEED
{0x1021eb2e96b793c, 0x10a7cb8 }, // SET_TRAIN_CRUISE_SPEED
{0xf44d446d4e36db87, 0x10a7c10 }, // SET_RANDOM_BOATS
{0xc474cf16eda45dc9, 0x10a6c44 }, // REQUEST_VEHICLE_RECORDING
{0xba9325be372ab6ea, 0x10a5918 }, // HAS_VEHICLE_RECORDING_BEEN_LOADED
{0x139e35755418f6aa, 0x10a6ba8 }, // REMOVE_VEHICLE_RECORDING
{0x1a00961a1be94e5e, 0x10a4990 }, // GET_POSITION_OF_VEHICLE_RECORDING_AT_TIME
{0x61787dd28b8cc0d5, 0x10a49e4 }, // GET_ROTATION_OF_VEHICLE_RECORDING_AT_TIME
{0x233b51c7913fa031, 0x10a4b3c }, // GET_TIME_POSITION_IN_RECORDING
{0x4932b84e3276508e, 0x10a8bdc }, // START_PLAYBACK_RECORDED_VEHICLE
{0xbf9b4d6267e8c26d, 0x10a8c20 }, // STOP_PLAYBACK_RECORDED_VEHICLE
{0x2774b3a9034278f, 0x10a5dac }, // IS_PLAYBACK_GOING_ON_FOR_VEHICLE
{0x5a7472606ec5b7c1, 0x10a5de0 }, // IS_PLAYBACK_USING_AI_GOING_ON_FOR_VEHICLE
{0xd78084eed4cd94c6, 0x10a7ae4 }, // SET_PLAYBACK_SPEED
{0x5f5e6379c59efc56, 0x10a8b84 }, // SKIP_TIME_IN_PLAYBACK_RECORDED_VEHICLE
{0x52f45d033645181b, 0x10a4194 }, // GET_CLOSEST_VEHICLE
{0xd0fb093a4cdb932c, 0x10a4bd0 }, // GET_TRAIN_CARRIAGE
{0xd3630fb07e8b570, 0x10a3900 }, // DELETE_MISSION_TRAIN
{0xbbe7648349b49be8, 0x10a74d8 }, // SET_MISSION_TRAIN_AS_NO_LONGER_NEEDED
{0x7632755962ab9922, 0x10a74e8 }, // SET_MISSION_TRAIN_COORDS
{0x799cfc7c5b743b15, 0x10a5f78 }, // IS_THIS_MODEL_A_BOAT
{0xfc08c8f8c1edf174, 0x10a5fc0 }, // IS_THIS_MODEL_A_TRAIN
{0x5254ba0b44adc16, 0x10a80ac }, // SET_VEHICLE_CAN_BE_TARGETTED
{0x4bf8131ae811541c, 0x10a80d4 }, // SET_VEHICLE_CAN_BE_VISIBLY_DAMAGED
{0x758c3460ee915d0a, 0x10a8208 }, // SET_VEHICLE_DIRT_LEVEL
{0x7ae191143c7a9107, 0x10a6118 }, // IS_VEHICLE_DOOR_FULLY_OPEN
{0xb64cfa14cb9a2e78, 0x10a836c }, // SET_VEHICLE_ENGINE_ON
{0x6e884bab713a2a94, 0x10a87c0 }, // SET_VEHICLE_UNDRIVEABLE
{0x652712478f1721f4, 0x10a8620 }, // SET_VEHICLE_PROVIDES_COVER
{0xd57f10ebba814ecf, 0x10a82c0 }, // SET_VEHICLE_DOOR_CONTROL
{0x6f8a202eb312a3c, 0x10a82d8 }, // SET_VEHICLE_DOOR_LATCHED
{0x6a3c24b91fd0ea09, 0x10a8330 }, // SET_VEHICLE_DOOR_SHUT
{0x9666cf20a1c6d780, 0x10a82a8 }, // SET_VEHICLE_DOOR_BROKEN
{0xc5ed9d59b4646611, 0x10a80e8 }, // SET_VEHICLE_CAN_BREAK
{0x54800d386c5825e5, 0x10a8470 }, // SET_VEHICLE_IS_CONSIDERED_BY_PLAYER
{0xc867fd144f2469d3, 0x10a4d84 }, // GET_VEHICLE_DOOR_LOCK_STATUS
{0x81fb9d6422f804c, 0x10a70d0 }, // _SET_VEHICLE_DOOR_CAN_BREAK
{0xd5d119529654ee0, 0x10a61e8 }, // IS_VEHICLE_ON_ALL_WHEELS
{0x79811282a9d1ae56, 0x10a83c8 }, // SET_VEHICLE_FIXED
{0xb70986ab19b04aff, 0x10a70a8 }, // SET_DISABLE_VEHICLE_PETROL_TANK_FIRES
{0x5795fbe7a2001c14, 0x10a7094 }, // SET_DISABLE_VEHICLE_PETROL_TANK_DAMAGE
{0xc619a44639bc0cb4, 0x10a6b8c }, // REMOVE_VEHICLES_FROM_GENERATORS_IN_AREA
{0x84daae11e9ee4fc3, 0x10a86d0 }, // SET_VEHICLE_STEER_BIAS
{0xfa9a55d9c4351625, 0x10a6174 }, // IS_VEHICLE_EXTRA_TURNED_ON
{0xbb6f89150bc9d16b, 0x10a83b0 }, // SET_VEHICLE_EXTRA
{0xaf5e7e9a7620ffb5, 0x10a3a4c }, // DOES_EXTRA_EXIST
{0x1d7678f81452bb41, 0x10a8188 }, // SET_VEHICLE_DAMAGE
{0x90dbffac43b22081, 0x10a4dbc }, // GET_VEHICLE_ENGINE_HEALTH
{0x8bdc5b998b4654ef, 0x10a835c }, // SET_VEHICLE_ENGINE_HEALTH
{0x1e5a9b356d5098be, 0x10a4ef8 }, // GET_VEHICLE_PETROL_TANK_HEALTH
{0x6ab2918ee3bec94c, 0x10a8610 }, // SET_VEHICLE_PETROL_TANK_HEALTH
{0x1aba9753939503c5, 0x10a632c }, // IS_VEHICLE_STUCK_TIMER_UP
{0x23298b468f7d88b6, 0x10a6cfc }, // RESET_VEHICLE_STUCK_TIMER
{0xb86d29b10f627379, 0x10a6140 }, // IS_VEHICLE_DRIVEABLE
{0xbb5a3fa8ed3979c5, 0x10a83f8 }, // SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER
{0xb4e3bfc39ca16057, 0x10a8bf8 }, // START_VEHICLE_HORN
{0x252253c8a45aa1fc, 0x10a840c }, // SET_VEHICLE_HAS_STRONG_AXLES
{0xa0a424505a1b6429, 0x10a322c }, // ARE_ANY_VEHICLE_SEATS_FREE
{0xa402939c6761e1a3, 0x10a839c }, // SET_VEHICLE_EXPLODES_ON_HIGH_EXPLOSION_DAMAGE
{0x5698ba4fd04d39c4, 0x10a5b70 }, // IS_ANY_VEHICLE_NEAR_POINT
{0x84b81ef78bd22357, 0x10a6c38 }, // REQUEST_VEHICLE_HIGH_DETAIL_MODEL
{0x81a15811460fab3a, 0x10a6c14 }, // REQUEST_VEHICLE_ASSET
{0xb935f3154bc913c8, 0x10a58cc }, // HAS_VEHICLE_ASSET_LOADED
{0x888a4e675b38f5ad, 0x10a6b9c }, // REMOVE_VEHICLE_ASSET
{0x501354951cd942de, 0x10a806c }, // SET_VEHICLE_AUTOMATICALLY_ATTACHES
{0x3f5029a8fc060c48, 0x10a619c }, // IS_VEHICLE_IN_BURNOUT
{0x91be51aec4e99710, 0x10a83e4 }, // SET_VEHICLE_HANDBRAKE
{0xcf867a239ec30741, 0x10a4f50 }, // GET_VEHICLE_TRAILER_VEHICLE
{0xfe52f34491529f0b, 0x10a4df8 }, // GET_VEHICLE_ESTIMATED_MAX_SPEED
{0x4c221bac54d735c3, 0x10a30fc }, // _ADD_SPEED_ZONE_FOR_COORD
{0xfe9ab3354ace6c9c, 0x10a6b68 }, // _REMOVE_SPEED_ZONE
{0xf8b2d32a2231fd24, 0x10a33a0 }, // CAN_SHUFFLE_SEAT
{0x35ad938c74cacd6a, 0x10a68fc }, // MODIFY_VEHICLE_TOP_SPEED
{0xa94f3e0ab9695e19, 0x10a44e8 }, // GET_LAST_DRIVEN_VEHICLE
{0xefc5dc62e67609b, 0x10a33d4 }, // CLEAR_LAST_DRIVEN_VEHICLE
{0x5f5e2b1b9eaecc0f, 0x10a8518 }, // SET_VEHICLE_LOD_MULTIPLIER
{0xdbc28a8c683cd80b, 0x10a34c8 }, // COPY_VEHICLE_DAMAGES
{0xb79be78c665b3e6d, 0x10a867c }, // SET_VEHICLE_SHOOT_AT_TARGET
{0x373cb1283308bd7b, 0x10a72e8 }, // SET_FORCE_HD_VEHICLE
{0x1f3969b140dee157, 0x10a8d04 }, // TRACK_VEHICLE_VISIBILITY
{0x424910cd5de8c246, 0x10a63b8 }, // IS_VEHICLE_VISIBLE
{0x4ea71b4c9db3c3f1, 0x10a8434 }, // SET_VEHICLE_INACTIVE_DURING_PLAYBACK
{0x48e4c137a71c2688, 0x10a8348 }, // SET_VEHICLE_ENGINE_CAN_DEGRADE
{0x6c32fc81dff25c9a, 0x10a84ac }, // SET_VEHICLE_IS_STOLEN
{0x94b1e71b144356a5, 0x10a3a2c }, // DISABLE_VEHICLE_WEAPON
{0xe42952510f84afdb, 0x10a80c0 }, // SET_VEHICLE_CAN_BE_USED_BY_FLEEING_PEDS
{0x1549ba7fe83a2383, 0x10a84c0 }, // _SET_VEHICLE_JET_ENGINE_ON
{0xc462c79379abbcb1, 0x10a88bc }, // SET_VEHICLE_WHEELS_CAN_BREAK_OFF_WHEN_BLOW_UP
{0x893dafbfa67110e, 0x10a8030 }, // SET_VEHICLE_EXCLUSIVE_DRIVER
{0xc6b9bf123b9463b6, 0x10a8388 }, // _SET_VEHICLE_EXCLUSIVE_DRIVER_2
{0x42113b857e33c16e, 0x10a4cfc }, // GET_VEHICLE_BODY_HEALTH
{0x55ccaae4f28c67a0, 0x10a8088 }, // SET_VEHICLE_BODY_HEALTH
{0xfca8b23f28813f69, 0x10a5284 }, // GET_WATER_HEIGHT
{0xdcf3690aa262c03f, 0x10a52a8 }, // GET_WATER_HEIGHT_NO_WAVES
{0x8974647ed222ea5f, 0x10a8c88 }, // TEST_PROBE_AGAINST_ALL_WATER
{0x2b3451fa1e3142e2, 0x10a8ce0 }, // TEST_VERTICAL_PROBE_AGAINST_ALL_WATER
{0x4bef8dd75af6c71c, 0x10a6b40 }, // _REMOVE_CURRENT_RISE
{0x14e56bc5b5db6a19, 0x10a75fc }, // SET_PED_AMMO
{0x3edcb0505123623b, 0x10a7a2c }, // SET_PED_INFINITE_AMMO
{0x15a522136d7f951, 0x10a4000 }, // GET_AMMO_IN_PED_WEAPON
{0xa38dcffcea8962fa, 0x10a45c8 }, // GET_MAX_AMMO_IN_CLIP
{0x2e1202248937775c, 0x10a3f90 }, // GET_AMMO_IN_CLIP
{0xdcd2a934d65cb497, 0x10a6ee0 }, // SET_AMMO_IN_CLIP
{0xdc16122c7a20c933, 0x10a4590 }, // GET_MAX_AMMO
{0x5fd1e1f011e76d7e, 0x10a7610 }, // SET_PED_AMMO_BY_TYPE
{0x39d22031557946c1, 0x10a4784 }, // GET_PED_AMMO_BY_TYPE
{0xa4efef9440a5b0ef, 0x10a7624 }, // SET_PED_AMMO_TO_DROP
{0x7fead38b326b9f74, 0x10a47a8 }, // GET_PED_AMMO_TYPE_FROM_WEAPON
{0xedca14ca5199ff25, 0x10a52ec }, // GET_WEAPONTYPE_GROUP
{0xadf692b254977c0c, 0x10a7050 }, // SET_CURRENT_PED_WEAPON
{0x3a87e44bb9a01d54, 0x10a4290 }, // GET_CURRENT_PED_WEAPON
{0x3b390a939af0b5fc, 0x10a42d0 }, // GET_CURRENT_PED_WEAPON_ENTITY_INDEX
{0x8483e98e8b888ae2, 0x10a40ac }, // GET_BEST_PED_WEAPON
{0x75c55983c2c39daa, 0x10a7040 }, // SET_CURRENT_PED_VEHICLE_WEAPON
{0x1017582bcd3832dc, 0x10a4268 }, // GET_CURRENT_PED_VEHICLE_WEAPON
{0x937c71165cf334b3, 0x10a6838 }, // IS_WEAPON_VALID
{0x8decb02f88f428bc, 0x10a5818 }, // HAS_PED_GOT_WEAPON
{0xb80ca294f2f26749, 0x10a5d88 }, // IS_PED_WEAPON_READY_TO_SHOOT
{0xb282dc6ebd803c75, 0x10a56bc }, // GIVE_DELAYED_WEAPON_TO_PED
{0xf25df915fa38c5f3, 0x10a6ae4 }, // REMOVE_ALL_PED_WEAPONS
{0x4899cb088edf59b8, 0x10a6bf8 }, // REMOVE_WEAPON_FROM_PED
{0x6f6981d2253c208f, 0x10a5998 }, // HIDE_PED_WEAPON_FOR_SCRIPTED_CUTSCENE
{0x725a4ccfded9a70, 0x10a7648 }, // SET_PED_CURRENT_WEAPON_VISIBLE
{0x476ae72c1d19d1a8, 0x10a7850 }, // SET_PED_DROPS_WEAPONS_WHEN_DEAD
{0x6c4d0409ba1a2bc2, 0x10a483c }, // GET_PED_LAST_WEAPON_IMPACT_COORD
{0x208a1888007fc0e6, 0x10a7700 }, // SET_PED_DROPS_INVENTORY_WEAPON
{0xf7d82b0d66777611, 0x10a6be8 }, // REMOVE_WEAPON_COMPONENT_FROM_WEAPON_OBJECT
{0x76a18844e743bf91, 0x10a5964 }, // HAS_WEAPON_GOT_WEAPON_COMPONENT
{0xd79334a4bb99bad1, 0xfd9214 }, // DRAW_TEXT_
{0x29b30d07c3f7873b, 0xfda890 }, // _GET_WAYPOINT_COORDS
{0x675680d089bfa21f, 0xf85940 }, // SET_PED_STAMINA
{0x283978a15512b2fe, 0xf8b8f4 }, // SET_PED_VISIBLE
{0x50a41ad966910f03, 0xfde790 }, // _SET_TEXT_COLOR
};
