#pragma once
#include "../main/rdr2_main.hpp"

class c_menu_framework
{

public:
	float menu_x = 250, menu_y = 290;
	enum item_type : int {
		type_bool = 0,
		type_int = 1,
		type_float = 2
	};
	enum tab_type : int {
		type_on_off = 0,
		type_tab = 1,
		type_dont_draw = 2
	};
	static struct menu_item_t {
		std::string m_title;

		float* m_float;
		int* m_int;
		bool* m_bool;

		float m_float_step;
		int m_int_step;
		int m_type;
		int tab_type;

		float m_float_min;
		int m_int_min;

		float m_float_max;
		int m_int_max;

		std::string tool_tip;
	};

	//int m_total_items = 0;
	int m_current_pos = 0;
	int menu_page = 0;
	std::vector<menu_item_t> items;
public:

	void add_entry(std::string title, bool* value, int is_tab = 0, std::string tooltip = "") {
		menu_item_t m_item;

		m_item.m_title = ((is_tab ? "" : "  ") + title);
		m_item.m_bool = value;
		m_item.m_type = item_type::type_bool;
		m_item.tab_type = is_tab;
		m_item.tool_tip = tooltip;
		items.emplace_back(m_item);
	}

	template <class t>
	void add_entry(std::string title, t* value, t min, t max, t step, std::string tooltip = "") {
		menu_item_t m_item;
		m_item.m_title = ("  " + title);
		if (std::is_same<t, float>()) {
			m_item.m_float = (float*)value;
			m_item.m_float_min = min;
			m_item.m_float_max = max;
			m_item.m_float_step = step;
			m_item.m_type = item_type::type_float;
		}
		else if (std::is_same<t, int>()) {
			m_item.m_int = (int*)value;
			m_item.m_int_min = min;
			m_item.m_int_max = max;
			m_item.m_int_step = step;
			m_item.m_type = item_type::type_int;
		}
		m_item.tool_tip = tooltip;
		items.emplace_back(m_item);
	}

	void add_menu_entries(int x, int y);

	void draw_menu_entries();

};
extern c_menu_framework* menu_framework;