// Copyright 2020 by FireEye, Inc.
// You may not use this file except in compliance with the license. The license should have been received with this file. You may obtain a copy of the license at:
// https://github.com/fireeye/red_team_tool_countermeasures/blob/master/LICENSE.txt
rule APT_Backdoor_Win_DShell_2
{
    meta:
        description = "This rule looks for strings specific to the D programming language in combination with a selection of Windows functions that are present within a DShell payload"
        md5 = "e0683f8ee787313cfd2c61cd0995a830"
        rev = 4
        author = "FireEye"
    strings:
        $dlang1 = "C:\\D\\dmd2\\windows\\bin\\..\\..\\src\\phobos\\std\\utf.d" ascii wide
        $dlang2 = "C:\\D\\dmd2\\windows\\bin\\..\\..\\src\\phobos\\std\\file.d" ascii wide
        $dlang3 = "C:\\D\\dmd2\\windows\\bin\\..\\..\\src\\phobos\\std\\format.d" ascii wide
        $dlang4 = "C:\\D\\dmd2\\windows\\bin\\..\\..\\src\\phobos\\std\\base64.d" ascii wide
        $dlang5 = "C:\\D\\dmd2\\windows\\bin\\..\\..\\src\\phobos\\std\\stdio.d" ascii wide
        $dlang6 = "\\..\\..\\src\\phobos\\std\\utf.d" ascii wide
        $dlang7 = "\\..\\..\\src\\phobos\\std\\file.d" ascii wide
        $dlang8 = "\\..\\..\\src\\phobos\\std\\format.d" ascii wide
        $dlang9 = "\\..\\..\\src\\phobos\\std\\base64.d" ascii wide
        $dlang10 = "\\..\\..\\src\\phobos\\std\\stdio.d" ascii wide
        $dlang11 = "Unexpected '\\n' when converting from type const(char)[] to type int" ascii wide
        $ign1 = "--strip-comments"
        $ign2 = "Usage: rdmd [RDMD AND DMD OPTIONS]"
        $s1 = "CloseHandle"
        $s2 = "CommandLineToArgvW"
        $s3 = "CreateFileA"
        $s4 = "CreateSemaphoreA"
        $s5 = "CreateThread"
        $s6 = "DeleteCriticalSection"
        $s7 = "DeleteFileA"
        $s8 = "DuplicateHandle"
        $s9 = "EnterCriticalSection"
        $s10 = "ExitProcess"
        $s11 = "ExitThread"
        $s12 = "ExpandEnvironmentStringsW"
        $s13 = "FileTimeToDosDateTime"
        $s14 = "FindClose"
        $s15 = "FindFirstFileA"
        $s16 = "FindFirstFileW"
        $s17 = "FindNextFileA"
        $s18 = "FindNextFileW"
        $s19 = "FormatMessageW"
        $s20 = "FreeEnvironmentStringsA"
        $s21 = "FreeEnvironmentStringsW"
        $s22 = "FreeLibrary"
        $s23 = "GetACP"
        $s24 = "GetCPInfo"
        $s25 = "GetCommandLineA"
        $s26 = "GetCommandLineW"
        $s27 = "GetConsoleOutputCP"
        $s28 = "GetConsoleScreenBufferInfo"
        $s29 = "GetCurrentProcess"
        $s30 = "GetCurrentThread"
        $s31 = "GetCurrentThreadId"
        $s32 = "GetEnvironmentStrings"
        $s33 = "GetEnvironmentStringsW"
        $s34 = "GetEnvironmentVariableA"
        $s35 = "GetEnvironmentVariableW"
        $s36 = "GetExitCodeThread"
        $s37 = "GetFileAttributesW"
        $s38 = "GetFileType"
        $s39 = "GetLastError"
        $s40 = "GetModuleFileNameA"
        $s41 = "GetModuleHandleA"
        $s42 = "GetOEMCP"
        $s43 = "GetProcAddress"
        $s44 = "GetProcessHeap"
        $s45 = "GetStdHandle"
        $s46 = "GetStringTypeA"
        $s47 = "GetSystemInfo"
        $s48 = "GetThreadContext"
        $s49 = "GetTickCount"
        $s50 = "GetTimeZoneInformation"
        $s51 = "GetVersion"
        $s52 = "GlobalAlloc"
        $s53 = "GlobalFree"
        $s54 = "GlobalMemoryStatus"
        $s55 = "HeapAlloc"
        $s56 = "HeapFree"
        $s57 = "HeapReAlloc"
        $s58 = "InitializeCriticalSection"
        $s59 = "IsDebuggerPresent"
        $s60 = "LCMapStringA"
        $s61 = "LeaveCriticalSection"
        $s62 = "LoadLibraryA"
        $s63 = "LoadLibraryW"
        $s64 = "LocalFree"
        $s65 = "MessageBoxA"
        $s66 = "MultiByteToWideChar"
        $s67 = "QueryPerformanceCounter"
        $s68 = "QueryPerformanceFrequency"
        $s69 = "RaiseException"
        $s70 = "ReadFile"
        $s71 = "RegCloseKey"
        $s72 = "RegCreateKeyExW"
        $s73 = "RegDeleteKeyW"
        $s74 = "RegDeleteValueW"
        $s75 = "RegEnumKeyExW"
        $s76 = "RegEnumValueW"
        $s77 = "RegFlushKey"
        $s78 = "RegOpenKeyExW"
        $s79 = "RegOpenKeyW"
        $s80 = "RegQueryInfoKeyW"
        $s81 = "RegQueryValueExW"
        $s82 = "RegSetValueExW"
        $s83 = "ReleaseSemaphore"
        $s84 = "ResumeThread"
        $s85 = "RtlCaptureContext"
        $s86 = "RtlUnwind"
        $s87 = "SetConsoleCtrlHandler"
        $s88 = "SetEnvironmentVariableW"
        $s89 = "SetFilePointer"
        $s90 = "SetHandleCount"
        $s91 = "SetLastError"
        $s92 = "Sleep"
        $s93 = "SuspendThread"
        $s94 = "SwitchToThread"
        $s95 = "SystemTimeToTzSpecificLocalTime"
        $s96 = "TryEnterCriticalSection"
        $s97 = "TzSpecificLocalTimeToSystemTime"
        $s98 = "UnhandledExceptionFilter"
        $s99 = "VirtualAlloc"
        $s100 = "VirtualFree"
        $s101 = "WaitForSingleObject"
        $s102 = "WideCharToMultiByte"
        $s103 = "WriteConsoleA"
        $s104 = "WriteFile"
        $s105 = "lstrlenW"
    condition:
        (uint16(0) == 0x5A4D and uint32(uint32(0x3C)) == 0x00004550) and filesize > 500KB and filesize > 700KB and all of ($s*) and 1 of ($dlang*) and not $ign1 and not $ign2
}